/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeHostsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHostsRequestMarshaller
implements Marshaller<Request<DescribeHostsRequest>, DescribeHostsRequest> {
    @Override
    public Request<DescribeHostsRequest> marshall(DescribeHostsRequest describeHostsRequest) {
        SdkInternalList describeHostsRequestHostIdsList;
        if (describeHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeHostsRequest> request = new DefaultRequest<DescribeHostsRequest>(describeHostsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeHostsRequestFilterList = (SdkInternalList)describeHostsRequest.getFilter();
        if (!describeHostsRequestFilterList.isEmpty() || !describeHostsRequestFilterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter describeHostsRequestFilterListValue : describeHostsRequestFilterList) {
                SdkInternalList filterValuesList;
                if (describeHostsRequestFilterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString(describeHostsRequestFilterListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeHostsRequestFilterListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (!(describeHostsRequestHostIdsList = (SdkInternalList)describeHostsRequest.getHostIds()).isEmpty() || !describeHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String describeHostsRequestHostIdsListValue : describeHostsRequestHostIdsList) {
                if (describeHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString(describeHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (describeHostsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeHostsRequest.getMaxResults()));
        }
        if (describeHostsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeHostsRequest.getNextToken()));
        }
        return request;
    }
}

