/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeClientVpnEndpointsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClientVpnEndpointsRequestMarshaller
implements Marshaller<Request<DescribeClientVpnEndpointsRequest>, DescribeClientVpnEndpointsRequest> {
    @Override
    public Request<DescribeClientVpnEndpointsRequest> marshall(DescribeClientVpnEndpointsRequest describeClientVpnEndpointsRequest) {
        SdkInternalList describeClientVpnEndpointsRequestFiltersList;
        if (describeClientVpnEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeClientVpnEndpointsRequest> request = new DefaultRequest<DescribeClientVpnEndpointsRequest>(describeClientVpnEndpointsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeClientVpnEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeClientVpnEndpointsRequestClientVpnEndpointIdsList = (SdkInternalList)describeClientVpnEndpointsRequest.getClientVpnEndpointIds();
        if (!describeClientVpnEndpointsRequestClientVpnEndpointIdsList.isEmpty() || !describeClientVpnEndpointsRequestClientVpnEndpointIdsList.isAutoConstruct()) {
            int clientVpnEndpointIdsListIndex = 1;
            for (String describeClientVpnEndpointsRequestClientVpnEndpointIdsListValue : describeClientVpnEndpointsRequestClientVpnEndpointIdsList) {
                if (describeClientVpnEndpointsRequestClientVpnEndpointIdsListValue != null) {
                    request.addParameter("ClientVpnEndpointId." + clientVpnEndpointIdsListIndex, StringUtils.fromString(describeClientVpnEndpointsRequestClientVpnEndpointIdsListValue));
                }
                ++clientVpnEndpointIdsListIndex;
            }
        }
        if (describeClientVpnEndpointsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeClientVpnEndpointsRequest.getMaxResults()));
        }
        if (describeClientVpnEndpointsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeClientVpnEndpointsRequest.getNextToken()));
        }
        if (!(describeClientVpnEndpointsRequestFiltersList = (SdkInternalList)describeClientVpnEndpointsRequest.getFilters()).isEmpty() || !describeClientVpnEndpointsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeClientVpnEndpointsRequestFiltersListValue : describeClientVpnEndpointsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeClientVpnEndpointsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeClientVpnEndpointsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeClientVpnEndpointsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

