/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateNetworkInsightsPathRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateNetworkInsightsPathRequestMarshaller
implements Marshaller<Request<CreateNetworkInsightsPathRequest>, CreateNetworkInsightsPathRequest> {
    @Override
    public Request<CreateNetworkInsightsPathRequest> marshall(CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) {
        SdkInternalList createNetworkInsightsPathRequestTagSpecificationsList;
        if (createNetworkInsightsPathRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateNetworkInsightsPathRequest> request = new DefaultRequest<CreateNetworkInsightsPathRequest>(createNetworkInsightsPathRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInsightsPath");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInsightsPathRequest.getSourceIp() != null) {
            request.addParameter("SourceIp", StringUtils.fromString(createNetworkInsightsPathRequest.getSourceIp()));
        }
        if (createNetworkInsightsPathRequest.getDestinationIp() != null) {
            request.addParameter("DestinationIp", StringUtils.fromString(createNetworkInsightsPathRequest.getDestinationIp()));
        }
        if (createNetworkInsightsPathRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(createNetworkInsightsPathRequest.getSource()));
        }
        if (createNetworkInsightsPathRequest.getDestination() != null) {
            request.addParameter("Destination", StringUtils.fromString(createNetworkInsightsPathRequest.getDestination()));
        }
        if (createNetworkInsightsPathRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(createNetworkInsightsPathRequest.getProtocol()));
        }
        if (createNetworkInsightsPathRequest.getDestinationPort() != null) {
            request.addParameter("DestinationPort", StringUtils.fromInteger(createNetworkInsightsPathRequest.getDestinationPort()));
        }
        if (!(createNetworkInsightsPathRequestTagSpecificationsList = (SdkInternalList)createNetworkInsightsPathRequest.getTagSpecifications()).isEmpty() || !createNetworkInsightsPathRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createNetworkInsightsPathRequestTagSpecificationsListValue : createNetworkInsightsPathRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createNetworkInsightsPathRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createNetworkInsightsPathRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createNetworkInsightsPathRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createNetworkInsightsPathRequest.getClientToken()));
        return request;
    }
}

