/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CapacityReservationOptionsRequest;
import com.amazonaws.services.ec2.model.CreateFleetRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import com.amazonaws.services.ec2.model.FleetSpotCapacityRebalanceRequest;
import com.amazonaws.services.ec2.model.FleetSpotMaintenanceStrategiesRequest;
import com.amazonaws.services.ec2.model.OnDemandOptionsRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.SpotOptionsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    @Override
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        SdkInternalList createFleetRequestTagSpecificationsList;
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        SdkInternalList createFleetRequestLaunchTemplateConfigsList;
        OnDemandOptionsRequest onDemandOptions;
        SpotOptionsRequest spotOptions;
        if (createFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFleetRequest> request = new DefaultRequest<CreateFleetRequest>(createFleetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFleetRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFleetRequest.getClientToken()));
        }
        if ((spotOptions = createFleetRequest.getSpotOptions()) != null) {
            FleetSpotCapacityRebalanceRequest capacityRebalance;
            FleetSpotMaintenanceStrategiesRequest maintenanceStrategies;
            if (spotOptions.getAllocationStrategy() != null) {
                request.addParameter("SpotOptions.AllocationStrategy", StringUtils.fromString(spotOptions.getAllocationStrategy()));
            }
            if ((maintenanceStrategies = spotOptions.getMaintenanceStrategies()) != null && (capacityRebalance = maintenanceStrategies.getCapacityRebalance()) != null && capacityRebalance.getReplacementStrategy() != null) {
                request.addParameter("SpotOptions.MaintenanceStrategies.CapacityRebalance.ReplacementStrategy", StringUtils.fromString(capacityRebalance.getReplacementStrategy()));
            }
            if (spotOptions.getInstanceInterruptionBehavior() != null) {
                request.addParameter("SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString(spotOptions.getInstanceInterruptionBehavior()));
            }
            if (spotOptions.getInstancePoolsToUseCount() != null) {
                request.addParameter("SpotOptions.InstancePoolsToUseCount", StringUtils.fromInteger(spotOptions.getInstancePoolsToUseCount()));
            }
            if (spotOptions.getSingleInstanceType() != null) {
                request.addParameter("SpotOptions.SingleInstanceType", StringUtils.fromBoolean(spotOptions.getSingleInstanceType()));
            }
            if (spotOptions.getSingleAvailabilityZone() != null) {
                request.addParameter("SpotOptions.SingleAvailabilityZone", StringUtils.fromBoolean(spotOptions.getSingleAvailabilityZone()));
            }
            if (spotOptions.getMinTargetCapacity() != null) {
                request.addParameter("SpotOptions.MinTargetCapacity", StringUtils.fromInteger(spotOptions.getMinTargetCapacity()));
            }
            if (spotOptions.getMaxTotalPrice() != null) {
                request.addParameter("SpotOptions.MaxTotalPrice", StringUtils.fromString(spotOptions.getMaxTotalPrice()));
            }
        }
        if ((onDemandOptions = createFleetRequest.getOnDemandOptions()) != null) {
            CapacityReservationOptionsRequest capacityReservationOptions;
            if (onDemandOptions.getAllocationStrategy() != null) {
                request.addParameter("OnDemandOptions.AllocationStrategy", StringUtils.fromString(onDemandOptions.getAllocationStrategy()));
            }
            if ((capacityReservationOptions = onDemandOptions.getCapacityReservationOptions()) != null && capacityReservationOptions.getUsageStrategy() != null) {
                request.addParameter("OnDemandOptions.CapacityReservationOptions.UsageStrategy", StringUtils.fromString(capacityReservationOptions.getUsageStrategy()));
            }
            if (onDemandOptions.getSingleInstanceType() != null) {
                request.addParameter("OnDemandOptions.SingleInstanceType", StringUtils.fromBoolean(onDemandOptions.getSingleInstanceType()));
            }
            if (onDemandOptions.getSingleAvailabilityZone() != null) {
                request.addParameter("OnDemandOptions.SingleAvailabilityZone", StringUtils.fromBoolean(onDemandOptions.getSingleAvailabilityZone()));
            }
            if (onDemandOptions.getMinTargetCapacity() != null) {
                request.addParameter("OnDemandOptions.MinTargetCapacity", StringUtils.fromInteger(onDemandOptions.getMinTargetCapacity()));
            }
            if (onDemandOptions.getMaxTotalPrice() != null) {
                request.addParameter("OnDemandOptions.MaxTotalPrice", StringUtils.fromString(onDemandOptions.getMaxTotalPrice()));
            }
        }
        if (createFleetRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString(createFleetRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(createFleetRequestLaunchTemplateConfigsList = (SdkInternalList)createFleetRequest.getLaunchTemplateConfigs()).isEmpty() || !createFleetRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest createFleetRequestLaunchTemplateConfigsListValue : createFleetRequestLaunchTemplateConfigsList) {
                SdkInternalList fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = createFleetRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString(launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString(launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString(launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = (SdkInternalList)createFleetRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !fleetLaunchTemplateConfigRequestOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        Placement placement;
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString(fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble(fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble(fleetLaunchTemplateConfigRequestOverridesListValue.getPriority()));
                        }
                        if ((placement = fleetLaunchTemplateConfigRequestOverridesListValue.getPlacement()) != null) {
                            if (placement.getAvailabilityZone() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                            }
                            if (placement.getAffinity() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Affinity", StringUtils.fromString(placement.getAffinity()));
                            }
                            if (placement.getGroupName() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                            }
                            if (placement.getPartitionNumber() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.PartitionNumber", StringUtils.fromInteger(placement.getPartitionNumber()));
                            }
                            if (placement.getHostId() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostId", StringUtils.fromString(placement.getHostId()));
                            }
                            if (placement.getTenancy() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
                            }
                            if (placement.getSpreadDomain() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.SpreadDomain", StringUtils.fromString(placement.getSpreadDomain()));
                            }
                            if (placement.getHostResourceGroupArn() != null) {
                                request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostResourceGroupArn", StringUtils.fromString(placement.getHostResourceGroupArn()));
                            }
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if ((targetCapacitySpecification = createFleetRequest.getTargetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.getTotalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringUtils.fromInteger(targetCapacitySpecification.getTotalTargetCapacity()));
            }
            if (targetCapacitySpecification.getOnDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringUtils.fromInteger(targetCapacitySpecification.getOnDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.getSpotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringUtils.fromInteger(targetCapacitySpecification.getSpotTargetCapacity()));
            }
            if (targetCapacitySpecification.getDefaultTargetCapacityType() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringUtils.fromString(targetCapacitySpecification.getDefaultTargetCapacityType()));
            }
        }
        if (createFleetRequest.getTerminateInstancesWithExpiration() != null) {
            request.addParameter("TerminateInstancesWithExpiration", StringUtils.fromBoolean(createFleetRequest.getTerminateInstancesWithExpiration()));
        }
        if (createFleetRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(createFleetRequest.getType()));
        }
        if (createFleetRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate(createFleetRequest.getValidFrom()));
        }
        if (createFleetRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate(createFleetRequest.getValidUntil()));
        }
        if (createFleetRequest.getReplaceUnhealthyInstances() != null) {
            request.addParameter("ReplaceUnhealthyInstances", StringUtils.fromBoolean(createFleetRequest.getReplaceUnhealthyInstances()));
        }
        if (!(createFleetRequestTagSpecificationsList = (SdkInternalList)createFleetRequest.getTagSpecifications()).isEmpty() || !createFleetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFleetRequestTagSpecificationsListValue : createFleetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFleetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createFleetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFleetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

