/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DnsEntry;
import com.amazonaws.services.ec2.model.State;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class VpcEndpointConnection
implements Serializable,
Cloneable {
    private String serviceId;
    private String vpcEndpointId;
    private String vpcEndpointOwner;
    private String vpcEndpointState;
    private Date creationTimestamp;
    private SdkInternalList<DnsEntry> dnsEntries;
    private SdkInternalList<String> networkLoadBalancerArns;
    private SdkInternalList<String> gatewayLoadBalancerArns;

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public VpcEndpointConnection withServiceId(String serviceId) {
        this.setServiceId(serviceId);
        return this;
    }

    public void setVpcEndpointId(String vpcEndpointId) {
        this.vpcEndpointId = vpcEndpointId;
    }

    public String getVpcEndpointId() {
        return this.vpcEndpointId;
    }

    public VpcEndpointConnection withVpcEndpointId(String vpcEndpointId) {
        this.setVpcEndpointId(vpcEndpointId);
        return this;
    }

    public void setVpcEndpointOwner(String vpcEndpointOwner) {
        this.vpcEndpointOwner = vpcEndpointOwner;
    }

    public String getVpcEndpointOwner() {
        return this.vpcEndpointOwner;
    }

    public VpcEndpointConnection withVpcEndpointOwner(String vpcEndpointOwner) {
        this.setVpcEndpointOwner(vpcEndpointOwner);
        return this;
    }

    public void setVpcEndpointState(String vpcEndpointState) {
        this.vpcEndpointState = vpcEndpointState;
    }

    public String getVpcEndpointState() {
        return this.vpcEndpointState;
    }

    public VpcEndpointConnection withVpcEndpointState(String vpcEndpointState) {
        this.setVpcEndpointState(vpcEndpointState);
        return this;
    }

    public VpcEndpointConnection withVpcEndpointState(State vpcEndpointState) {
        this.vpcEndpointState = vpcEndpointState.toString();
        return this;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public VpcEndpointConnection withCreationTimestamp(Date creationTimestamp) {
        this.setCreationTimestamp(creationTimestamp);
        return this;
    }

    public List<DnsEntry> getDnsEntries() {
        if (this.dnsEntries == null) {
            this.dnsEntries = new SdkInternalList();
        }
        return this.dnsEntries;
    }

    public void setDnsEntries(Collection<DnsEntry> dnsEntries) {
        if (dnsEntries == null) {
            this.dnsEntries = null;
            return;
        }
        this.dnsEntries = new SdkInternalList<DnsEntry>(dnsEntries);
    }

    public VpcEndpointConnection withDnsEntries(DnsEntry ... dnsEntries) {
        if (this.dnsEntries == null) {
            this.setDnsEntries(new SdkInternalList<DnsEntry>(dnsEntries.length));
        }
        for (DnsEntry ele : dnsEntries) {
            this.dnsEntries.add(ele);
        }
        return this;
    }

    public VpcEndpointConnection withDnsEntries(Collection<DnsEntry> dnsEntries) {
        this.setDnsEntries(dnsEntries);
        return this;
    }

    public List<String> getNetworkLoadBalancerArns() {
        if (this.networkLoadBalancerArns == null) {
            this.networkLoadBalancerArns = new SdkInternalList();
        }
        return this.networkLoadBalancerArns;
    }

    public void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
        if (networkLoadBalancerArns == null) {
            this.networkLoadBalancerArns = null;
            return;
        }
        this.networkLoadBalancerArns = new SdkInternalList<String>(networkLoadBalancerArns);
    }

    public VpcEndpointConnection withNetworkLoadBalancerArns(String ... networkLoadBalancerArns) {
        if (this.networkLoadBalancerArns == null) {
            this.setNetworkLoadBalancerArns(new SdkInternalList<String>(networkLoadBalancerArns.length));
        }
        for (String ele : networkLoadBalancerArns) {
            this.networkLoadBalancerArns.add(ele);
        }
        return this;
    }

    public VpcEndpointConnection withNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
        this.setNetworkLoadBalancerArns(networkLoadBalancerArns);
        return this;
    }

    public List<String> getGatewayLoadBalancerArns() {
        if (this.gatewayLoadBalancerArns == null) {
            this.gatewayLoadBalancerArns = new SdkInternalList();
        }
        return this.gatewayLoadBalancerArns;
    }

    public void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
        if (gatewayLoadBalancerArns == null) {
            this.gatewayLoadBalancerArns = null;
            return;
        }
        this.gatewayLoadBalancerArns = new SdkInternalList<String>(gatewayLoadBalancerArns);
    }

    public VpcEndpointConnection withGatewayLoadBalancerArns(String ... gatewayLoadBalancerArns) {
        if (this.gatewayLoadBalancerArns == null) {
            this.setGatewayLoadBalancerArns(new SdkInternalList<String>(gatewayLoadBalancerArns.length));
        }
        for (String ele : gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns.add(ele);
        }
        return this;
    }

    public VpcEndpointConnection withGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
        this.setGatewayLoadBalancerArns(gatewayLoadBalancerArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceId() != null) {
            sb.append("ServiceId: ").append(this.getServiceId()).append(",");
        }
        if (this.getVpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(this.getVpcEndpointId()).append(",");
        }
        if (this.getVpcEndpointOwner() != null) {
            sb.append("VpcEndpointOwner: ").append(this.getVpcEndpointOwner()).append(",");
        }
        if (this.getVpcEndpointState() != null) {
            sb.append("VpcEndpointState: ").append(this.getVpcEndpointState()).append(",");
        }
        if (this.getCreationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(this.getCreationTimestamp()).append(",");
        }
        if (this.getDnsEntries() != null) {
            sb.append("DnsEntries: ").append(this.getDnsEntries()).append(",");
        }
        if (this.getNetworkLoadBalancerArns() != null) {
            sb.append("NetworkLoadBalancerArns: ").append(this.getNetworkLoadBalancerArns()).append(",");
        }
        if (this.getGatewayLoadBalancerArns() != null) {
            sb.append("GatewayLoadBalancerArns: ").append(this.getGatewayLoadBalancerArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointConnection)) {
            return false;
        }
        VpcEndpointConnection other = (VpcEndpointConnection)obj;
        if (other.getServiceId() == null ^ this.getServiceId() == null) {
            return false;
        }
        if (other.getServiceId() != null && !other.getServiceId().equals(this.getServiceId())) {
            return false;
        }
        if (other.getVpcEndpointId() == null ^ this.getVpcEndpointId() == null) {
            return false;
        }
        if (other.getVpcEndpointId() != null && !other.getVpcEndpointId().equals(this.getVpcEndpointId())) {
            return false;
        }
        if (other.getVpcEndpointOwner() == null ^ this.getVpcEndpointOwner() == null) {
            return false;
        }
        if (other.getVpcEndpointOwner() != null && !other.getVpcEndpointOwner().equals(this.getVpcEndpointOwner())) {
            return false;
        }
        if (other.getVpcEndpointState() == null ^ this.getVpcEndpointState() == null) {
            return false;
        }
        if (other.getVpcEndpointState() != null && !other.getVpcEndpointState().equals(this.getVpcEndpointState())) {
            return false;
        }
        if (other.getCreationTimestamp() == null ^ this.getCreationTimestamp() == null) {
            return false;
        }
        if (other.getCreationTimestamp() != null && !other.getCreationTimestamp().equals(this.getCreationTimestamp())) {
            return false;
        }
        if (other.getDnsEntries() == null ^ this.getDnsEntries() == null) {
            return false;
        }
        if (other.getDnsEntries() != null && !other.getDnsEntries().equals(this.getDnsEntries())) {
            return false;
        }
        if (other.getNetworkLoadBalancerArns() == null ^ this.getNetworkLoadBalancerArns() == null) {
            return false;
        }
        if (other.getNetworkLoadBalancerArns() != null && !other.getNetworkLoadBalancerArns().equals(this.getNetworkLoadBalancerArns())) {
            return false;
        }
        if (other.getGatewayLoadBalancerArns() == null ^ this.getGatewayLoadBalancerArns() == null) {
            return false;
        }
        return other.getGatewayLoadBalancerArns() == null || other.getGatewayLoadBalancerArns().equals(this.getGatewayLoadBalancerArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceId() == null ? 0 : this.getServiceId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointId() == null ? 0 : this.getVpcEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointOwner() == null ? 0 : this.getVpcEndpointOwner().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointState() == null ? 0 : this.getVpcEndpointState().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTimestamp() == null ? 0 : this.getCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getDnsEntries() == null ? 0 : this.getDnsEntries().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkLoadBalancerArns() == null ? 0 : this.getNetworkLoadBalancerArns().hashCode());
        hashCode = 31 * hashCode + (this.getGatewayLoadBalancerArns() == null ? 0 : this.getGatewayLoadBalancerArns().hashCode());
        return hashCode;
    }

    public VpcEndpointConnection clone() {
        try {
            return (VpcEndpointConnection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

