/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.UnlimitedSupportedInstanceFamily;
import com.amazonaws.services.ec2.model.transform.ModifyDefaultCreditSpecificationRequestMarshaller;
import java.io.Serializable;

public class ModifyDefaultCreditSpecificationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyDefaultCreditSpecificationRequest> {
    private String instanceFamily;
    private String cpuCredits;

    public void setInstanceFamily(String instanceFamily) {
        this.instanceFamily = instanceFamily;
    }

    public String getInstanceFamily() {
        return this.instanceFamily;
    }

    public ModifyDefaultCreditSpecificationRequest withInstanceFamily(String instanceFamily) {
        this.setInstanceFamily(instanceFamily);
        return this;
    }

    public ModifyDefaultCreditSpecificationRequest withInstanceFamily(UnlimitedSupportedInstanceFamily instanceFamily) {
        this.instanceFamily = instanceFamily.toString();
        return this;
    }

    public void setCpuCredits(String cpuCredits) {
        this.cpuCredits = cpuCredits;
    }

    public String getCpuCredits() {
        return this.cpuCredits;
    }

    public ModifyDefaultCreditSpecificationRequest withCpuCredits(String cpuCredits) {
        this.setCpuCredits(cpuCredits);
        return this;
    }

    @Override
    public Request<ModifyDefaultCreditSpecificationRequest> getDryRunRequest() {
        Request<ModifyDefaultCreditSpecificationRequest> request = new ModifyDefaultCreditSpecificationRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.getInstanceFamily()).append(",");
        }
        if (this.getCpuCredits() != null) {
            sb.append("CpuCredits: ").append(this.getCpuCredits());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDefaultCreditSpecificationRequest)) {
            return false;
        }
        ModifyDefaultCreditSpecificationRequest other = (ModifyDefaultCreditSpecificationRequest)obj;
        if (other.getInstanceFamily() == null ^ this.getInstanceFamily() == null) {
            return false;
        }
        if (other.getInstanceFamily() != null && !other.getInstanceFamily().equals(this.getInstanceFamily())) {
            return false;
        }
        if (other.getCpuCredits() == null ^ this.getCpuCredits() == null) {
            return false;
        }
        return other.getCpuCredits() == null || other.getCpuCredits().equals(this.getCpuCredits());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceFamily() == null ? 0 : this.getInstanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.getCpuCredits() == null ? 0 : this.getCpuCredits().hashCode());
        return hashCode;
    }

    @Override
    public ModifyDefaultCreditSpecificationRequest clone() {
        return (ModifyDefaultCreditSpecificationRequest)super.clone();
    }
}

