/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateTransitGatewayVpcAttachmentRequestOptions;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateTransitGatewayVpcAttachmentRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTransitGatewayVpcAttachmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateTransitGatewayVpcAttachmentRequest> {
    private String transitGatewayId;
    private String vpcId;
    private SdkInternalList<String> subnetIds;
    private CreateTransitGatewayVpcAttachmentRequestOptions options;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setTransitGatewayId(String transitGatewayId) {
        this.transitGatewayId = transitGatewayId;
    }

    public String getTransitGatewayId() {
        return this.transitGatewayId;
    }

    public CreateTransitGatewayVpcAttachmentRequest withTransitGatewayId(String transitGatewayId) {
        this.setTransitGatewayId(transitGatewayId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public CreateTransitGatewayVpcAttachmentRequest withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new SdkInternalList();
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new SdkInternalList<String>(subnetIds);
    }

    public CreateTransitGatewayVpcAttachmentRequest withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new SdkInternalList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public CreateTransitGatewayVpcAttachmentRequest withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public void setOptions(CreateTransitGatewayVpcAttachmentRequestOptions options) {
        this.options = options;
    }

    public CreateTransitGatewayVpcAttachmentRequestOptions getOptions() {
        return this.options;
    }

    public CreateTransitGatewayVpcAttachmentRequest withOptions(CreateTransitGatewayVpcAttachmentRequestOptions options) {
        this.setOptions(options);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateTransitGatewayVpcAttachmentRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateTransitGatewayVpcAttachmentRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateTransitGatewayVpcAttachmentRequest> getDryRunRequest() {
        Request<CreateTransitGatewayVpcAttachmentRequest> request = new CreateTransitGatewayVpcAttachmentRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransitGatewayId() != null) {
            sb.append("TransitGatewayId: ").append(this.getTransitGatewayId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayVpcAttachmentRequest)) {
            return false;
        }
        CreateTransitGatewayVpcAttachmentRequest other = (CreateTransitGatewayVpcAttachmentRequest)obj;
        if (other.getTransitGatewayId() == null ^ this.getTransitGatewayId() == null) {
            return false;
        }
        if (other.getTransitGatewayId() != null && !other.getTransitGatewayId().equals(this.getTransitGatewayId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransitGatewayId() == null ? 0 : this.getTransitGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CreateTransitGatewayVpcAttachmentRequest clone() {
        return (CreateTransitGatewayVpcAttachmentRequest)super.clone();
    }
}

