/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.whois.ip.parsers;

import org.graylog.plugins.threatintel.whois.ip.parsers.WhoisParser;

public class ARINResponseParser
extends WhoisParser {
    private NetworkType prevNetworkType = null;
    private NetworkType currNetworkType = null;

    @Override
    public void readLine(String line) {
        if (line.startsWith("#") || line.isEmpty()) {
            return;
        }
        if (line.startsWith("NetType:")) {
            this.prevNetworkType = this.currNetworkType;
            this.currNetworkType = NetworkType.getEnum(this.lineValue(line));
            if (null != this.currNetworkType && this.currNetworkType.isMoreSpecificThan(this.prevNetworkType)) {
                this.organization = null;
                this.countryCode = null;
            }
        }
        if ((line.startsWith("Organization:") || line.startsWith("Customer:")) && this.organization == null) {
            this.organization = this.lineValue(line);
        }
        if (line.startsWith("Country:") && this.countryCode == null) {
            this.countryCode = this.lineValue(line);
        }
        if (line.startsWith("ResourceLink") && !line.contains("http")) {
            this.isRedirect = true;
            this.registryRedirect = this.findRegistryFromWhoisServer(this.lineValue(line));
        }
    }

    @Override
    public String buildQueryForIp(String ip) {
        return "n + " + ip;
    }

    private static enum NetworkType {
        REASSIGNED("Reassigned"),
        DIRECT_ASSIGNMENT("Direct Assignment"),
        REALLOCATED("Reallocated"),
        DIRECT_ALLOCATION("Direct Allocation");

        private String displayName;

        private NetworkType(String displayName) {
            this.displayName = displayName;
        }

        String displayName() {
            return this.displayName;
        }

        boolean isMoreSpecificThan(NetworkType netType) {
            if (null == netType) {
                return true;
            }
            return this.ordinal() < netType.ordinal();
        }

        static NetworkType getEnum(String value) {
            for (NetworkType v : NetworkType.values()) {
                if (!value.equalsIgnoreCase(v.displayName())) continue;
                return v;
            }
            return null;
        }
    }
}

