/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import java.util.Collections;
import java.util.Set;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.threatintel.PluginConfigService;
import org.graylog.plugins.threatintel.adapters.abusech.AbuseChRansomAdapter;
import org.graylog.plugins.threatintel.adapters.otx.OTXDataAdapter;
import org.graylog.plugins.threatintel.adapters.spamhaus.SpamhausEDROPDataAdapter;
import org.graylog.plugins.threatintel.adapters.tor.TorExitNodeDataAdapter;
import org.graylog.plugins.threatintel.functions.DomainFunctions;
import org.graylog.plugins.threatintel.functions.GenericLookupResult;
import org.graylog.plugins.threatintel.functions.IPFunctions;
import org.graylog.plugins.threatintel.functions.abusech.AbuseChRansomDomainLookupFunction;
import org.graylog.plugins.threatintel.functions.abusech.AbuseChRansomIpLookupFunction;
import org.graylog.plugins.threatintel.functions.global.GlobalDomainLookupFunction;
import org.graylog.plugins.threatintel.functions.global.GlobalIpLookupFunction;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog.plugins.threatintel.functions.misc.PrivateNetLookupFunction;
import org.graylog.plugins.threatintel.functions.otx.OTXDomainLookupFunction;
import org.graylog.plugins.threatintel.functions.otx.OTXIPLookupFunction;
import org.graylog.plugins.threatintel.functions.spamhaus.SpamhausIpLookupFunction;
import org.graylog.plugins.threatintel.functions.tor.TorExitNodeLookupFunction;
import org.graylog.plugins.threatintel.migrations.V20170821100300_MigrateOTXAPIToken;
import org.graylog.plugins.threatintel.migrations.V20180906112716_RecreateThreatintelLookupTables;
import org.graylog.plugins.threatintel.whois.ip.WhoisDataAdapter;
import org.graylog.plugins.threatintel.whois.ip.WhoisLookupIpFunction;
import org.graylog2.plugin.PluginConfigBean;
import org.graylog2.plugin.PluginModule;

public class ThreatIntelPluginModule
extends PluginModule {
    public Set<? extends PluginConfigBean> getConfigBeans() {
        return Collections.emptySet();
    }

    protected void configure() {
        this.bind(PluginConfigService.class).in(Scopes.SINGLETON);
        this.addMessageProcessorFunction("otx_lookup_domain", OTXDomainLookupFunction.class);
        this.addMessageProcessorFunction("otx_lookup_ip", OTXIPLookupFunction.class);
        this.addMessageProcessorFunction("tor_lookup", TorExitNodeLookupFunction.class);
        this.addMessageProcessorFunction("spamhaus_lookup_ip", SpamhausIpLookupFunction.class);
        this.addMessageProcessorFunction("abusech_ransom_lookup_domain", AbuseChRansomDomainLookupFunction.class);
        this.addMessageProcessorFunction("abusech_ransom_lookup_ip", AbuseChRansomIpLookupFunction.class);
        this.addMessageProcessorFunction("threat_intel_lookup_ip", GlobalIpLookupFunction.class);
        this.addMessageProcessorFunction("threat_intel_lookup_domain", GlobalDomainLookupFunction.class);
        this.addMessageProcessorFunction("whois_lookup_ip", WhoisLookupIpFunction.class);
        this.addMessageProcessorFunction("in_private_net", PrivateNetLookupFunction.class);
        this.installLookupDataAdapter("abuse-ch-ransom", AbuseChRansomAdapter.class, AbuseChRansomAdapter.Factory.class, AbuseChRansomAdapter.Config.class);
        this.installLookupDataAdapter("spamhaus-edrop", SpamhausEDROPDataAdapter.class, SpamhausEDROPDataAdapter.Factory.class, SpamhausEDROPDataAdapter.Config.class);
        this.installLookupDataAdapter("torexitnode", TorExitNodeDataAdapter.class, TorExitNodeDataAdapter.Factory.class, TorExitNodeDataAdapter.Config.class);
        this.installLookupDataAdapter("whois", WhoisDataAdapter.class, WhoisDataAdapter.Factory.class, WhoisDataAdapter.Config.class);
        this.installLookupDataAdapter("otx-api", OTXDataAdapter.class, OTXDataAdapter.Factory.class, OTXDataAdapter.Config.class);
        this.addMigration(V20180906112716_RecreateThreatintelLookupTables.class);
        this.addMigration(V20170821100300_MigrateOTXAPIToken.class);
        this.addDomainFunction("abusech_ransomware", AbuseChRansomDomainLookupFunction.class);
        this.addIPFunction("abusech_ransomware", AbuseChRansomIpLookupFunction.class);
        this.addIPFunction("spamhaus", SpamhausIpLookupFunction.class);
        this.addIPFunction("tor", TorExitNodeLookupFunction.class);
    }

    private void addMessageProcessorFunction(String name, Class<? extends Function<?>> functionClass) {
        this.addMessageProcessorFunction(this.binder(), name, functionClass);
    }

    private MapBinder<String, Function<?>> processorFunctionBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Function<?>>(){});
    }

    private void addMessageProcessorFunction(Binder binder, String name, Class<? extends Function<?>> functionClass) {
        this.processorFunctionBinder(binder).addBinding((Object)name).to(functionClass);
    }

    private MapBinder<String, LookupTableFunction<? extends GenericLookupResult>> domainFunctionBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<LookupTableFunction<? extends GenericLookupResult>>(){}, DomainFunctions.class);
    }

    private MapBinder<String, LookupTableFunction<? extends GenericLookupResult>> ipFunctionBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<LookupTableFunction<? extends GenericLookupResult>>(){}, IPFunctions.class);
    }

    private void addDomainFunction(String id, Class<? extends LookupTableFunction<? extends GenericLookupResult>> functionClass) {
        this.domainFunctionBinder().addBinding((Object)id).to(functionClass);
    }

    private void addIPFunction(String id, Class<? extends LookupTableFunction<? extends GenericLookupResult>> functionClass) {
        this.ipFunctionBinder().addBinding((Object)id).to(functionClass);
    }
}

