/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.system;

import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.graylog.plugins.collector.system.CollectorSystemConfiguration;
import org.graylog2.plugin.cluster.ClusterConfigService;

public class CollectorSystemConfigurationSupplier
implements Supplier<CollectorSystemConfiguration> {
    private final ClusterConfigService clusterConfigService;
    private final CollectorSystemConfiguration config;

    @Inject
    public CollectorSystemConfigurationSupplier(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.config = null;
    }

    public CollectorSystemConfigurationSupplier(@Nonnull CollectorSystemConfiguration config) {
        this.clusterConfigService = null;
        this.config = config;
    }

    public CollectorSystemConfiguration get() {
        if (this.config != null) {
            return this.config;
        }
        if (this.clusterConfigService != null) {
            return (CollectorSystemConfiguration)this.clusterConfigService.getOrDefault(CollectorSystemConfiguration.class, (Object)CollectorSystemConfiguration.defaultConfiguration());
        }
        throw new IllegalStateException("Neither config nor clusterConfigService are set. This should not happen!");
    }
}

