/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Validator;
import org.graylog.plugins.collector.collectors.Collector;
import org.graylog.plugins.collector.collectors.CollectorActions;
import org.graylog.plugins.collector.collectors.CollectorImpl;
import org.graylog.plugins.collector.collectors.CollectorNodeDetails;
import org.graylog.plugins.collector.collectors.CollectorService;
import org.graylog.plugins.collector.collectors.CollectorUpload;
import org.graylog.plugins.collector.collectors.rest.models.CollectorAction;
import org.graylog.plugins.collector.collectors.rest.models.requests.CollectorRegistrationRequest;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class CollectorServiceImpl
implements CollectorService {
    private final JacksonDBCollection<CollectorImpl, String> coll;
    private final JacksonDBCollection<CollectorActions, String> collActions;
    private final JacksonDBCollection<CollectorUpload, String> collUpload;
    private final Validator validator;

    @Inject
    public CollectorServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider, Validator validator) {
        this.validator = validator;
        String collectionName = CollectorImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, CollectorImpl.class, String.class, (ObjectMapper)mapperProvider.get());
        this.coll.createIndex((DBObject)new BasicDBObject("id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        String actionCollectionName = CollectorActions.class.getAnnotation(CollectionName.class).value();
        DBCollection actionDbCollection = mongoConnection.getDatabase().getCollection(actionCollectionName);
        this.collActions = JacksonDBCollection.wrap((DBCollection)actionDbCollection, CollectorActions.class, String.class, (ObjectMapper)mapperProvider.get());
        String uploadCollectionName = CollectorUpload.class.getAnnotation(CollectionName.class).value();
        DBCollection uploadDbCollection = mongoConnection.getDatabase().getCollection(uploadCollectionName);
        this.collUpload = JacksonDBCollection.wrap((DBCollection)uploadDbCollection, CollectorUpload.class, String.class, (ObjectMapper)mapperProvider.get());
    }

    @Override
    public long count() {
        return this.coll.count();
    }

    @Override
    public Collector save(Collector collector) {
        if (collector instanceof CollectorImpl) {
            CollectorImpl collectorImpl = (CollectorImpl)collector;
            Set violations = this.validator.validate((Object)collectorImpl, new Class[0]);
            if (violations.isEmpty()) {
                return (Collector)this.coll.findAndModify(DBQuery.is((String)"id", (Object)collector.getId()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)collectorImpl, true, true);
            }
            throw new IllegalArgumentException("Specified object failed validation: " + violations);
        }
        throw new IllegalArgumentException("Specified object is not of correct implementation type (" + collector.getClass() + ")!");
    }

    @Override
    public List<Collector> all() {
        return this.toAbstractListType((DBCursor<CollectorImpl>)this.coll.find());
    }

    @Override
    public Collector findById(String id) {
        return (Collector)this.coll.findOne(DBQuery.is((String)"id", (Object)id));
    }

    @Override
    public List<Collector> findByNodeId(String nodeId) {
        return this.toAbstractListType((DBCursor<CollectorImpl>)this.coll.find(DBQuery.is((String)"node_id", (Object)nodeId)));
    }

    @Override
    public int destroy(Collector collector) {
        return this.coll.remove(DBQuery.is((String)"id", (Object)collector.getId())).getN();
    }

    @Override
    public int destroyExpired(Period period) {
        int count = 0;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)period);
        for (Collector collector : this.all()) {
            if (!collector.getLastSeen().isBefore((ReadableInstant)threshold)) continue;
            count += this.destroy(collector);
        }
        return count;
    }

    @Override
    public Collector fromRequest(String collectorId, CollectorRegistrationRequest request, String collectorVersion) {
        return CollectorImpl.create(collectorId, request.nodeId(), collectorVersion, CollectorNodeDetails.create(request.nodeDetails().operatingSystem(), request.nodeDetails().tags(), request.nodeDetails().ip(), request.nodeDetails().metrics(), request.nodeDetails().logFileList(), request.nodeDetails().statusList()), DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    @Override
    public CollectorActions actionFromRequest(String collectorId, List<CollectorAction> actions) {
        CollectorActions collectorActions = this.findActionByCollector(collectorId, false);
        if (collectorActions == null) {
            return CollectorActions.create(collectorId, DateTime.now((DateTimeZone)DateTimeZone.UTC), actions);
        }
        ArrayList<CollectorAction> updatedActions = new ArrayList<CollectorAction>();
        for (CollectorAction action : actions) {
            for (CollectorAction existingsAction : collectorActions.getAction()) {
                if (existingsAction.backend().equals(action.backend())) continue;
                updatedActions.add(existingsAction);
            }
            updatedActions.add(action);
        }
        return CollectorActions.create(collectorActions.getId(), collectorId, DateTime.now((DateTimeZone)DateTimeZone.UTC), updatedActions);
    }

    @Override
    public CollectorActions saveAction(CollectorActions collectorActions) {
        return (CollectorActions)this.collActions.findAndModify(DBQuery.is((String)"collector_id", (Object)collectorActions.getCollectorId()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)collectorActions, true, true);
    }

    @Override
    public CollectorActions findActionByCollector(String collectorId, boolean remove) {
        if (remove) {
            return (CollectorActions)this.collActions.findAndRemove(DBQuery.is((String)"collector_id", (Object)collectorId));
        }
        return (CollectorActions)this.collActions.findOne(DBQuery.is((String)"collector_id", (Object)collectorId));
    }

    @Override
    public CollectorUpload saveUpload(CollectorUpload collectorUpload) {
        return (CollectorUpload)this.collUpload.findAndModify(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"collector_id", (Object)collectorUpload.collectorId()), DBQuery.is((String)"collector_name", (Object)collectorUpload.collectorName())}), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)collectorUpload, true, true);
    }

    private List<Collector> toAbstractListType(DBCursor<CollectorImpl> collectors) {
        return this.toAbstractListType(collectors.toArray());
    }

    private List<Collector> toAbstractListType(List<CollectorImpl> collectors) {
        ArrayList result = Lists.newArrayListWithCapacity((int)collectors.size());
        result.addAll(collectors);
        return result;
    }
}

