{
"/*\n"
"    Phosphor shader - Copyright (C) 2011 caligari.\n"
"\n"
"    Ported by Hyllian.\n"
"\n"
"   This program is free software; you can redistribute it and/or\n"
"   modify it under the terms of the GNU General Public License\n"
"   as published by the Free Software Foundation; either version 2\n"
"   of the License, or (at your option) any later version.\n"
"\n"
"   This program is distributed in the hope that it will be useful,\n"
"   but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"   GNU General Public License for more details.\n"
"\n"
"   You should have received a copy of the GNU General Public License\n"
"   along with this program; if not, write to the Free Software\n"
"   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n"
"\n"
"*/\n"
"\n"
"// Parameter lines go here:\n"
"// 0.5 = the spot stays inside the original pixel\n"
"// 1.0 = the spot bleeds up to the center of next pixel\n"
"#pragma parameter SPOT_WIDTH \"CRTCaligari Spot Width\" 0.9 0.1 1.5 0.05\n"
"#pragma parameter SPOT_HEIGHT \"CRTCaligari Spot Height\" 0.65 0.1 1.5 0.05\n"
"// Used to counteract the desaturation effect of weighting.\n"
"#pragma parameter COLOR_BOOST \"CRTCaligari Color Boost\" 1.45 1.0 2.0 0.05\n"
"// Constants used with gamma correction.\n"
"#pragma parameter InputGamma \"CRTCaligari Input Gamma\" 2.4 0.0 5.0 0.1\n"
"#pragma parameter OutputGamma \"CRTCaligari Output Gamma\" 2.2 0.0 5.0 0.1\n"
"\n"
"#if defined(VERTEX)\n"
"\n"
"#if __VERSION__ >= 130\n"
"#define COMPAT_VARYING out\n"
"#define COMPAT_ATTRIBUTE in\n"
"#define COMPAT_TEXTURE texture\n"
"#else\n"
"#define COMPAT_VARYING varying \n"
"#define COMPAT_ATTRIBUTE attribute \n"
"#define COMPAT_TEXTURE texture2D\n"
"#endif\n"
"\n"
"#ifdef GL_ES\n"
"#define COMPAT_PRECISION mediump\n"
"#else\n"
"#define COMPAT_PRECISION\n"
"#endif\n"
"\n"
"COMPAT_ATTRIBUTE vec4 VertexCoord;\n"
"COMPAT_ATTRIBUTE vec4 COLOR;\n"
"COMPAT_ATTRIBUTE vec4 TexCoord;\n"
"COMPAT_VARYING vec4 COL0;\n"
"COMPAT_VARYING vec4 TEX0;\n"
"COMPAT_VARYING vec2 onex;\n"
"COMPAT_VARYING vec2 oney;\n"
"\n"
"vec4 _oPosition1; \n"
"uniform mat4 MVPMatrix;\n"
"uniform COMPAT_PRECISION int FrameDirection;\n"
"uniform COMPAT_PRECISION int FrameCount;\n"
"uniform COMPAT_PRECISION vec2 OutputSize;\n"
"uniform COMPAT_PRECISION vec2 TextureSize;\n"
"uniform COMPAT_PRECISION vec2 InputSize;\n"
"\n"
"#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize\n"
"\n"
"void main()\n"
"{\n"
"    gl_Position = MVPMatrix * VertexCoord;\n"
"    COL0 = COLOR;\n"
"    TEX0.xy = TexCoord.xy;\n"
"   onex = vec2(SourceSize.z, 0.0);\n"
"   oney = vec2(0.0, SourceSize.w);\n"
"}\n"
"\n"
"#elif defined(FRAGMENT)\n"
"\n"
"#if __VERSION__ >= 130\n"
"#define COMPAT_VARYING in\n"
"#define COMPAT_TEXTURE texture\n"
"out vec4 FragColor;\n"
"#else\n"
"#define COMPAT_VARYING varying\n"
"#define FragColor gl_FragColor\n"
"#define COMPAT_TEXTURE texture2D\n"
"#endif\n"
"\n"
"#ifdef GL_ES\n"
"#ifdef GL_FRAGMENT_PRECISION_HIGH\n"
"precision highp float;\n"
"#else\n"
"precision mediump float;\n"
"#endif\n"
"#define COMPAT_PRECISION mediump\n"
"#else\n"
"#define COMPAT_PRECISION\n"
"#endif\n"
"\n"
"uniform COMPAT_PRECISION int FrameDirection;\n"
"uniform COMPAT_PRECISION int FrameCount;\n"
"uniform COMPAT_PRECISION vec2 OutputSize;\n"
"uniform COMPAT_PRECISION vec2 TextureSize;\n"
"uniform COMPAT_PRECISION vec2 InputSize;\n"
"uniform sampler2D Texture;\n"
"COMPAT_VARYING vec4 TEX0;\n"
"COMPAT_VARYING vec2 onex;\n"
"COMPAT_VARYING vec2 oney;\n"
"\n"
"// compatibility #defines\n"
"#define Source Texture\n"
"#define vTexCoord TEX0.xy\n"
"\n"
"#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize\n"
"#define OutputSize vec4(OutputSize, 1.0 / OutputSize)\n"
"\n"
"#ifdef PARAMETER_UNIFORM\n"
"// All parameter floats need to have COMPAT_PRECISION in front of them\n"
"uniform COMPAT_PRECISION float SPOT_WIDTH;\n"
"uniform COMPAT_PRECISION float SPOT_HEIGHT;\n"
"uniform COMPAT_PRECISION float COLOR_BOOST;\n"
"uniform COMPAT_PRECISION float InputGamma;\n"
"uniform COMPAT_PRECISION float OutputGamma;\n"
"#else\n"
"#define SPOT_WIDTH 0.9\n"
"#define SPOT_HEIGHT 0.65\n"
"#define COLOR_BOOST 1.45\n"
"#define InputGamma 2.4\n"
"#define OutputGamma 2.2\n"
"#endif\n"
"\n"
"#define GAMMA_IN(color)     pow(color,vec4(InputGamma))\n"
"#define GAMMA_OUT(color)    pow(color, vec4(1.0 / OutputGamma))\n"
"\n"
"#define TEX2D(coords)	GAMMA_IN( COMPAT_TEXTURE(Source, coords) )\n"
"\n"
"// Macro for weights computing\n"
"#define WEIGHT(w) \\\n"
"   if(w>1.0) w=1.0; \\\n"
"w = 1.0 - w * w; \\\n"
"w = w * w;\n"
"\n"
"void main()\n"
"{\n"
"   vec2 coords = ( vTexCoord * SourceSize.xy );\n"
"   vec2 pixel_center = floor( coords ) + vec2(0.5, 0.5);\n"
"   vec2 texture_coords = pixel_center * SourceSize.zw;\n"
"\n"
"   vec4 color = TEX2D( texture_coords );\n"
"\n"
"   float dx = coords.x - pixel_center.x;\n"
"\n"
"   float h_weight_00 = dx / SPOT_WIDTH;\n"
"   WEIGHT( h_weight_00 );\n"
"\n"
"   color *= vec4( h_weight_00, h_weight_00, h_weight_00, h_weight_00  );\n"
"\n"
"   // get closest horizontal neighbour to blend\n"
"   vec2 coords01;\n"
"   if (dx>0.0) {\n"
"      coords01 = onex;\n"
"      dx = 1.0 - dx;\n"
"   } else {\n"
"      coords01 = -onex;\n"
"      dx = 1.0 + dx;\n"
"   }\n"
"   vec4 colorNB = TEX2D( texture_coords + coords01 );\n"
"\n"
"   float h_weight_01 = dx / SPOT_WIDTH;\n"
"   WEIGHT( h_weight_01 );\n"
"\n"
"   color = color + colorNB * vec4( h_weight_01 );\n"
"\n"
"   //////////////////////////////////////////////////////\n"
"   // Vertical Blending\n"
"   float dy = coords.y - pixel_center.y;\n"
"   float v_weight_00 = dy / SPOT_HEIGHT;\n"
"   WEIGHT( v_weight_00 );\n"
"   color *= vec4( v_weight_00 );\n"
"\n"
"   // get closest vertical neighbour to blend\n"
"   vec2 coords10;\n"
"   if (dy>0.0) {\n"
"      coords10 = oney;\n"
"      dy = 1.0 - dy;\n"
"   } else {\n"
"      coords10 = -oney;\n"
"      dy = 1.0 + dy;\n"
"   }\n"
"   colorNB = TEX2D( texture_coords + coords10 );\n"
"\n"
"   float v_weight_10 = dy / SPOT_HEIGHT;\n"
"   WEIGHT( v_weight_10 );\n"
"\n"
"   color = color + colorNB * vec4( v_weight_10 * h_weight_00, v_weight_10 * h_weight_00, v_weight_10 * h_weight_00, v_weight_10 * h_weight_00 );\n"
"\n"
"   colorNB = TEX2D(  texture_coords + coords01 + coords10 );\n"
"\n"
"   color = color + colorNB * vec4( v_weight_10 * h_weight_01, v_weight_10 * h_weight_01, v_weight_10 * h_weight_01, v_weight_10 * h_weight_01 );\n"
"\n"
"   color *= vec4( COLOR_BOOST );\n"
"\n"
"   color = clamp( GAMMA_OUT(color), 0.0, 1.0 );\n"
"   FragColor = vec4(color.rgb, 1.0);\n"
"} \n"
"#endif\n"
},
