/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.HeadTable;
import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaTable
extends ListBasedTable<Integer> {
    @Override
    public String tableName() {
        return "loca";
    }

    @Override
    public String[] dependencyNames() {
        return new String[]{"head", "maxp"};
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n = ((HeadTable)trueTypeTableArray[0]).indexToLocFormat;
        switch (n) {
            case 0: {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    dataOutputStream.writeShort(n2 / 2);
                }
                break;
            }
            case 1: {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    dataOutputStream.writeInt(n3);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid indexToLocFormat.");
            }
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n2 = ((HeadTable)trueTypeTableArray[0]).indexToLocFormat;
        int n3 = ((MaxpTable)trueTypeTableArray[1]).numGlyphs;
        switch (n2) {
            case 0: {
                this.clear();
                for (int i = 0; i <= n3; ++i) {
                    this.add(dataInputStream.readUnsignedShort() * 2);
                }
                break;
            }
            case 1: {
                this.clear();
                for (int i = 0; i <= n3; ++i) {
                    this.add(dataInputStream.readInt());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Invalid indexToLocFormat.");
            }
        }
    }
}

