/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class PuaaLookup {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            PuaaLookup.printHelp();
            return;
        }
        ArrayList<PuaaSubtable> arrayList = new ArrayList<PuaaSubtable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            Iterator iterator = stringArray[n++];
            if (bl && ((String)((Object)iterator)).startsWith("-")) {
                if (((String)((Object)iterator)).equals("--")) {
                    bl = false;
                    continue;
                }
                if (((String)((Object)iterator)).equals("-i") && n < stringArray.length) {
                    PuaaTable puaaTable;
                    if ((puaaTable = PuaaLookup.read(new File(stringArray[n++]))) == null) continue;
                    arrayList.addAll(puaaTable);
                    continue;
                }
                if (((String)((Object)iterator)).equals("-p") && n < stringArray.length) {
                    String string;
                    if ((string = stringArray[n++].trim().toLowerCase()).length() <= 0) continue;
                    arrayList2.add(string);
                    continue;
                }
                if (((String)((Object)iterator)).equals("-c") && n < stringArray.length) {
                    int n2;
                    if ((n2 = PuaaLookup.parseCodePoint(stringArray[n++])) < 0) continue;
                    arrayList3.add(n2);
                    continue;
                }
                if (((String)((Object)iterator)).equals("--help")) {
                    PuaaLookup.printHelp();
                    continue;
                }
                System.err.println("Unknown option: " + iterator);
                continue;
            }
            int n3 = PuaaLookup.parseCodePoint((String)((Object)iterator));
            if (n3 < 0) continue;
            arrayList3.add(n3);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (arrayList3.isEmpty()) {
            if (arrayList2.isEmpty()) {
                System.out.println("Properties:");
                for (PuaaSubtable puaaSubtable : arrayList) {
                    System.out.println("  " + puaaSubtable.property);
                }
                return;
            }
            for (PuaaSubtable puaaSubtable : arrayList) {
                if (!arrayList2.contains(puaaSubtable.property.toLowerCase())) continue;
                System.out.println(puaaSubtable.property + ":");
                for (PuaaSubtableEntry.Single single : PuaaUtility.createRunsFromEntries(puaaSubtable)) {
                    String string = PuaaUtility.joinRange(single);
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("  ");
                    stringBuffer.append(string);
                    stringBuffer.append(": ");
                    for (int i = string.length(); i < 14; ++i) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(single.value);
                    System.out.println(stringBuffer.toString());
                }
            }
            return;
        }
        int n4 = 0;
        for (PuaaSubtable puaaSubtable : arrayList) {
            int n5 = puaaSubtable.property.length();
            if (n5 <= n4) continue;
            n4 = n5;
        }
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            System.out.println("U+" + PuaaUtility.toHexString(n6) + ":");
            for (PuaaSubtable puaaSubtable : arrayList) {
                String string;
                if (!arrayList2.isEmpty() && !arrayList2.contains(puaaSubtable.property.toLowerCase()) || (string = puaaSubtable.getPropertyValue(n6)) == null) continue;
                String string2 = puaaSubtable.property;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("  ");
                stringBuffer.append(string2);
                stringBuffer.append(": ");
                for (int i = string2.length(); i < n4; ++i) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                System.out.println(stringBuffer.toString());
            }
        }
    }

    private static PuaaTable read(File file) {
        System.out.print("Reading " + file.getName() + "...");
        try {
            PuaaTable puaaTable = PuaaLookup.extract(file);
            if (puaaTable == null) {
                System.out.println(" ERROR: table not found");
            } else {
                System.out.println(" DONE");
            }
            return puaaTable;
        }
        catch (IOException iOException) {
            System.out.println(" ERROR: " + iOException);
            return null;
        }
    }

    private static int parseCodePoint(String string) {
        if (string.codePointCount(0, string.length()) == 1) {
            return string.codePointAt(0);
        }
        try {
            string = string.replaceAll("[Uu][+]|[0][Xx]|\\s", "");
            int n = Integer.parseInt(string, 16);
            if (Character.isValidCodePoint(n)) {
                return n;
            }
            string = Integer.toHexString(n).toUpperCase();
            System.err.println("Invalid code point: " + string);
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Invalid code point: " + string);
            return -1;
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("PuaaLookup - Look up Unicode Character Database properties in TrueType files.");
        System.out.println();
        System.out.println("  -i <path>     Specify source TrueType file.");
        System.out.println("  -p <prop>     Specify properties to look up.");
        System.out.println("  -c <cp>       Specify code points to look up.");
        System.out.println("  --            Process remaining arguments as code points.");
        System.out.println();
    }

    public static PuaaTable extract(File file) throws IOException {
        long l = file.length();
        if (l < 12L) {
            throw new IOException("file too small");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IOException("file too large");
        }
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        TrueTypeFile trueTypeFile = new TrueTypeFile();
        trueTypeFile.decompile(byArray);
        return (PuaaTable)trueTypeFile.getByTableName("PUAA");
    }
}

