/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.rsrc.SoundResource;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class SoundMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;

    public SoundMenuBar(Window window, SoundResource soundResource) {
        this.add(new FileMenu(window, soundResource));
    }

    public static class SaveAiffMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SaveAiffMenuItem(SoundResource soundResource) {
            super("Save as AIFF...");
            this.setAccelerator(KeyStroke.getKeyStroke(83, CommonMenuItems.SHORTCUT_KEY | 1));
            final byte[] byArray = soundResource.toAiff();
            if (byArray == null) {
                this.setEnabled(false);
            } else {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        File file = Main.getSaveFile(".aiff");
                        if (file == null) {
                            return;
                        }
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            fileOutputStream.write(byArray);
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "An error occurred while saving this file.", "Save", 0);
                        }
                    }
                });
            }
        }
    }

    public static class SaveWavMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SaveWavMenuItem(SoundResource soundResource) {
            super("Save as WAV...");
            this.setAccelerator(KeyStroke.getKeyStroke(83, CommonMenuItems.SHORTCUT_KEY));
            final byte[] byArray = soundResource.toWav();
            if (byArray == null) {
                this.setEnabled(false);
            } else {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        File file = Main.getSaveFile(".wav");
                        if (file == null) {
                            return;
                        }
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            fileOutputStream.write(byArray);
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, "An error occurred while saving this file.", "Save", 0);
                        }
                    }
                });
            }
        }
    }

    public static class FileMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public FileMenu(Window window, SoundResource soundResource) {
            super("File");
            this.add(new CommonMenuItems.NewMenu());
            this.add(new CommonMenuItems.OpenMenuItem());
            this.add(new CommonMenuItems.CloseMenuItem(window));
            this.addSeparator();
            this.add(new SaveWavMenuItem(soundResource));
            this.add(new SaveAiffMenuItem(soundResource));
            if (!CommonMenuItems.IS_MAC_OS) {
                this.addSeparator();
                this.add(new CommonMenuItems.ExitMenuItem());
            }
        }
    }
}

