/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.mover.MoverFile;
import com.kreative.bitsnpicas.mover.ResourceBundle;
import com.kreative.rsrc.MacResourceArray;
import com.kreative.rsrc.MacResourceProvider;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSelection
implements ClipboardOwner,
Transferable {
    public static final DataFlavor resourceFlavor = new DataFlavor(ResourceBundle.class, "Resource");
    private List<ResourceBundle> resources = new ArrayList<ResourceBundle>();

    public ResourceSelection(ResourceBundle resourceBundle) {
        this.resources.add(resourceBundle.clone());
    }

    public ResourceSelection(ResourceBundle[] resourceBundleArray) {
        for (ResourceBundle resourceBundle : resourceBundleArray) {
            this.resources.add(resourceBundle.clone());
        }
    }

    public ResourceSelection(List<ResourceBundle> list) {
        for (ResourceBundle resourceBundle : list) {
            this.resources.add(resourceBundle.clone());
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (resourceFlavor.equals(dataFlavor)) {
            return this.resources;
        }
        if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
            File file = File.createTempFile("kbnptemp", ".tmp");
            File file2 = new File(file.getAbsolutePath() + "d");
            file.delete();
            file2.mkdir();
            file2.deleteOnExit();
            ArrayList<File> arrayList = new ArrayList<File>();
            for (ResourceBundle resourceBundle : this.resources) {
                FileOutputStream fileOutputStream;
                MacResourceArray macResourceArray = new MacResourceArray();
                MoverFile moverFile = new MoverFile((MacResourceProvider)macResourceArray);
                moverFile.add(resourceBundle);
                File file3 = new File(file2, resourceBundle.name);
                file3.createNewFile();
                try {
                    File file4 = MacUtility.getResourceFork(file3);
                    fileOutputStream = new FileOutputStream(file4);
                    fileOutputStream.write(macResourceArray.getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    MacUtility.setTypeAndCreator(file3, resourceBundle.moverType, "movr");
                }
                catch (IOException iOException) {
                    fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(macResourceArray.getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                arrayList.add(file3);
            }
            return arrayList;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{resourceFlavor, DataFlavor.javaFileListFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return resourceFlavor.equals(dataFlavor) || DataFlavor.javaFileListFlavor.equals(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

