/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.Base64InputStream;
import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.FileProxy;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.GlyphPair;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaydateBitmapFontImporter
implements BitmapFontImporter {
    private static final Pattern FNT_FILE_PATTERN = Pattern.compile("^(.+)\\.fnt$", 2);
    private static final Pattern PNG_FILE_PATTERN = Pattern.compile("^(.+)-table-(\\d+)-(\\d+)\\.png$", 2);
    private static final Pattern PROPERTY_LINE = Pattern.compile("^(--\\s*)?(\\w+)\\s*=\\s*(.+)$");
    private static final Pattern METRICS_LINE = Pattern.compile("\"(\\w+)\"\\s*:\\s*(-?\\d+)");

    private static Pattern fntFilePattern(String string) {
        return Pattern.compile("^(" + Pattern.quote(string) + ")\\.fnt$", 2);
    }

    private static Pattern pngFilePattern(String string) {
        return Pattern.compile("^(" + Pattern.quote(string) + ")-table-(\\d+)-(\\d+)\\.png$", 2);
    }

    private static File findFileMatching(Pattern pattern, File file) {
        for (File file2 : file.listFiles()) {
            if (!pattern.matcher(file2.getName()).matches()) continue;
            return file2;
        }
        return null;
    }

    private static boolean looksLikeFnt(FileProxy fileProxy) {
        return fileProxy.startsWith(116, 114, 97, 99, 107, 105, 110, 103) || fileProxy.startsWith(100, 97, 116, 97) || fileProxy.startsWith(119, 105, 100, 116, 104) || fileProxy.startsWith(104, 101, 105, 103, 104, 116) || fileProxy.startsWith(115, 112, 97, 99, 101) || fileProxy.startsWith(45, 45);
    }

    public static boolean canImportFont(FileProxy fileProxy) {
        File file = fileProxy.getFile();
        Matcher matcher = PNG_FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            File file2 = PlaydateBitmapFontImporter.findFileMatching(PlaydateBitmapFontImporter.fntFilePattern(matcher.group(1)), file.getParentFile());
            return file2 != null && PlaydateBitmapFontImporter.looksLikeFnt(new FileProxy(file2));
        }
        Matcher matcher2 = FNT_FILE_PATTERN.matcher(file.getName());
        return matcher2.matches() && PlaydateBitmapFontImporter.looksLikeFnt(fileProxy);
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        return this.importFont(new ByteArrayInputStream(byArray));
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        BitmapFont bitmapFont = this.importFont(scanner, null, null, -1, -1);
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        Matcher matcher = PNG_FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            File file2 = PlaydateBitmapFontImporter.findFileMatching(PlaydateBitmapFontImporter.fntFilePattern(matcher.group(1)), file.getParentFile());
            if (file2 == null) {
                throw new FileNotFoundException();
            }
            int n = Integer.parseInt(matcher.group(2));
            int n2 = Integer.parseInt(matcher.group(3));
            BufferedImage bufferedImage = ImageIO.read(file);
            return this.importFont(file2, matcher.group(1), bufferedImage, n, n2);
        }
        Matcher matcher2 = FNT_FILE_PATTERN.matcher(file.getName());
        if (matcher2.matches()) {
            File file3 = PlaydateBitmapFontImporter.findFileMatching(PlaydateBitmapFontImporter.pngFilePattern(matcher2.group(1)), file.getParentFile());
            if (file3 != null && (matcher = PNG_FILE_PATTERN.matcher(file3.getName())).matches()) {
                int n = Integer.parseInt(matcher.group(2));
                int n3 = Integer.parseInt(matcher.group(3));
                BufferedImage bufferedImage = ImageIO.read(file3);
                return this.importFont(file, matcher.group(1), bufferedImage, n, n3);
            }
            return this.importFont(file, matcher2.group(1), null, -1, -1);
        }
        return this.importFont(file, file.getName(), null, -1, -1);
    }

    private BitmapFont[] importFont(File file, String string, BufferedImage bufferedImage, int n, int n2) throws IOException {
        Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
        BitmapFont bitmapFont = this.importFont(scanner, string, bufferedImage, n, n2);
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFont(Scanner scanner, String string, BufferedImage bufferedImage, int n, int n2) throws IOException {
        int n3;
        Object object;
        Object object2;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        int n7 = 1;
        ArrayList arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        while (scanner.hasNextLine()) {
            int n8;
            Object object3;
            String string2 = scanner.nextLine();
            Matcher matcher = PROPERTY_LINE.matcher(string2);
            if (matcher.matches()) {
                object3 = matcher.group(2);
                object2 = matcher.group(3);
                if (((String)object3).equals("name")) {
                    string = object2;
                    continue;
                }
                if (((String)object3).equals("metrics")) {
                    object = METRICS_LINE.matcher((CharSequence)object2);
                    while (((Matcher)object).find()) {
                        object3 = ((Matcher)object).group(1);
                        object2 = ((Matcher)object).group(2);
                        if (((String)object3).equals("baseline")) {
                            try {
                                n4 = Integer.parseInt((String)object2);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        if (((String)object3).equals("xHeight")) {
                            try {
                                n5 = Integer.parseInt((String)object2);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        if (!((String)object3).equals("capHeight")) continue;
                        try {
                            n6 = Integer.parseInt((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    continue;
                }
                if (((String)object3).equals("tracking")) {
                    try {
                        n7 = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (((String)object3).equals("data")) {
                    try {
                        bufferedImage = ImageIO.read(new Base64InputStream((String)object2));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (((String)object3).equals("width")) {
                    try {
                        n = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (!((String)object3).equals("height")) continue;
                try {
                    n2 = Integer.parseInt((String)object2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string2.startsWith("--")) continue;
            Object object4 = object3 = string2.contains("\t") ? string2.split("\t+") : string2.split("\\s+");
            if (((String[])object3).length != 2) continue;
            try {
                n8 = Integer.parseInt(object3[1]);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            object = PlaydateBitmapFontImporter.splitCodePoints(object3[0]);
            switch (((ArrayList)object).size()) {
                case 1: {
                    arrayList.add(((ArrayList)object).get(0));
                    arrayList2.add(n8);
                    break;
                }
                case 2: {
                    arrayList3.add(((ArrayList)object).get(0));
                    arrayList4.add(((ArrayList)object).get(1));
                    arrayList5.add(n8);
                }
            }
        }
        if (string == null) {
            string = "Untitled";
        }
        if (bufferedImage == null) {
            throw new IOException("no png data found");
        }
        if (n < 1 || n2 < 1) {
            throw new IOException("invalid cell size: " + n + ", " + n2);
        }
        int n9 = bufferedImage.getWidth() / n;
        int n10 = bufferedImage.getHeight() / n2;
        if (n9 < 1 || n10 < 1) {
            throw new IOException("invalid cell count: " + n9 + ", " + n10);
        }
        int n11 = n4 == null ? n2 : (n4 > 0 ? n4 : n2 + n4);
        object2 = new ArrayList();
        object = new BufferedImage(n, n2, 2);
        int[] nArray = new int[n * n2];
        int n12 = 0;
        int n13 = 0;
        int n14 = arrayList.size();
        for (n3 = 0; n3 < n14; ++n3) {
            bufferedImage.getRGB(n13 * n, n12 * n2, n, n2, nArray, 0, n);
            ((BufferedImage)object).setRGB(0, 0, n, n2, nArray, 0, n);
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
            bitmapFontGlyph.setCharacterWidth((Integer)arrayList2.get(n3) + n7);
            bitmapFontGlyph.setToImage(0, -n11, (BufferedImage)object);
            bitmapFontGlyph.contract();
            ((ArrayList)object2).add(bitmapFontGlyph);
            if (++n13 < n9) continue;
            n13 = 0;
            if (++n12 < n10) continue;
            n12 = 0;
        }
        BitmapFont bitmapFont = new BitmapFont(n11, n2 - n11, n11, n2 - n11, 0, 0, 0);
        bitmapFont.setName(1, string);
        bitmapFont.setName(4, string);
        n3 = arrayList.size();
        for (n13 = 0; n13 < n3; ++n13) {
            bitmapFont.putCharacter((Integer)arrayList.get(n13), (FontGlyph)((ArrayList)object2).get(n13));
        }
        n3 = arrayList5.size();
        for (n13 = 0; n13 < n3; ++n13) {
            bitmapFont.setKernPair(new GlyphPair((Integer)arrayList3.get(n13), (Integer)arrayList4.get(n13)), (Integer)arrayList5.get(n13));
        }
        if (n4 == null) {
            bitmapFont.setAscentDescent();
        }
        if (n5 == null) {
            bitmapFont.setXHeight();
        } else {
            bitmapFont.setXHeight(n5);
        }
        if (n6 == null) {
            bitmapFont.setCapHeight();
        } else {
            bitmapFont.setCapHeight(n6);
        }
        return bitmapFont;
    }

    private static ArrayList<Integer> splitCodePoints(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            if (string.regionMatches(n, "space", 0, 5)) {
                n += 5;
                arrayList.add(32);
                continue;
            }
            if (string.regionMatches(n, "U+", 0, 2)) {
                int n4;
                int n5;
                n += 2;
                n3 = 0;
                while (n < n2 && (n5 = Character.digit(n4 = string.codePointAt(n), 16)) >= 0) {
                    n += Character.charCount(n4);
                    n3 = n3 << 4 | n5;
                }
                arrayList.add(n3);
                continue;
            }
            n3 = string.codePointAt(n);
            n += Character.charCount(n3);
            arrayList.add(n3);
        }
        return arrayList;
    }
}

