/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.Base64InputStream;
import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.GlyphPair;
import com.kreative.bitsnpicas.WIBInputStream;
import com.kreative.bitsnpicas.XMLUtility;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class KbitxBitmapFontImporter
implements BitmapFontImporter {
    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont bitmapFont = KbitxBitmapFontImporter.parse("<byte[]>", byteArrayInputStream);
        byteArrayInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BitmapFont bitmapFont = KbitxBitmapFontImporter.parse("<InputStream>", inputStream);
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont bitmapFont = KbitxBitmapFontImporter.parse(file.getName(), fileInputStream);
        fileInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    private static BitmapFont parse(String string, InputStream inputStream) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(XMLUtility.entityResolver("BitsNPicasBitmap", "kbitx.dtd", KbitxBitmapFontImporter.class));
            documentBuilder.setErrorHandler(XMLUtility.errorHandler(string));
            Document document = documentBuilder.parse(new InputSource(inputStream));
            return KbitxBitmapFontImporter.parseDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
    }

    private static BitmapFont parseDocument(Node node) throws IOException {
        String string = node.getNodeName();
        if (string.equalsIgnoreCase("#document")) {
            for (Node node2 : XMLUtility.getChildren(node)) {
                String string2 = node2.getNodeName();
                if (string2.equalsIgnoreCase("kbits")) {
                    if (!node2.hasAttributes() && !node2.hasChildNodes()) continue;
                    return KbitxBitmapFontImporter.parseKbits(node2);
                }
                throw new IOException("Unknown element: " + string2);
            }
            throw new IOException("Empty document.");
        }
        throw new IOException("Unknown element: " + string);
    }

    private static BitmapFont parseKbits(Node node) throws IOException {
        BitmapFont bitmapFont = new BitmapFont();
        for (Node node2 : XMLUtility.getChildren(node)) {
            Object object;
            Object object2;
            String string = node2.getNodeName();
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (string.equalsIgnoreCase("prop")) {
                object2 = XMLUtility.parseString(namedNodeMap, "id");
                object = XMLUtility.parseInt(namedNodeMap, "value");
                if ("emAscent".equalsIgnoreCase((String)object2) && object != null) {
                    bitmapFont.setEmAscent((Integer)object);
                }
                if ("emDescent".equalsIgnoreCase((String)object2) && object != null) {
                    bitmapFont.setEmDescent((Integer)object);
                }
                if ("lineAscent".equalsIgnoreCase((String)object2) && object != null) {
                    bitmapFont.setLineAscent((Integer)object);
                }
                if ("lineDescent".equalsIgnoreCase((String)object2) && object != null) {
                    bitmapFont.setLineDescent((Integer)object);
                }
                if ("lineGap".equalsIgnoreCase((String)object2) && object != null) {
                    bitmapFont.setLineGap((Integer)object);
                }
                if ("xHeight".equalsIgnoreCase((String)object2) && object != null) {
                    bitmapFont.setXHeight((Integer)object);
                }
                if (!"capHeight".equalsIgnoreCase((String)object2) || object == null) continue;
                bitmapFont.setCapHeight((Integer)object);
                continue;
            }
            if (string.equalsIgnoreCase("name")) {
                object2 = XMLUtility.parseInt(namedNodeMap, "id");
                object = XMLUtility.parseString(namedNodeMap, "value");
                if (object2 == null || object == null) continue;
                bitmapFont.setName((Integer)object2, (String)object);
                continue;
            }
            if (string.equalsIgnoreCase("g")) {
                object2 = XMLUtility.parseInt(namedNodeMap, "u");
                object = XMLUtility.parseString(namedNodeMap, "n");
                if (object2 != null) {
                    bitmapFont.putCharacter((Integer)object2, KbitxBitmapFontImporter.parseGlyph(namedNodeMap));
                }
                if (object == null) continue;
                bitmapFont.putNamedGlyph((String)object, KbitxBitmapFontImporter.parseGlyph(namedNodeMap));
                continue;
            }
            if (!string.equalsIgnoreCase("k") || (object2 = XMLUtility.parseInt(namedNodeMap, "o")) == null) continue;
            object = XMLUtility.parseInt(namedNodeMap, "lu");
            String string2 = XMLUtility.parseString(namedNodeMap, "ln");
            Integer n = XMLUtility.parseInt(namedNodeMap, "ru");
            String string3 = XMLUtility.parseString(namedNodeMap, "rn");
            if (object != null) {
                if (n != null) {
                    bitmapFont.setKernPair(new GlyphPair((Integer)object, n), (Integer)object2);
                }
                if (string3 != null) {
                    bitmapFont.setKernPair(new GlyphPair((Integer)object, string3), (Integer)object2);
                }
            }
            if (string2 == null) continue;
            if (n != null) {
                bitmapFont.setKernPair(new GlyphPair(string2, n), (Integer)object2);
            }
            if (string3 == null) continue;
            bitmapFont.setKernPair(new GlyphPair(string2, string3), (Integer)object2);
        }
        return bitmapFont;
    }

    private static BitmapFontGlyph parseGlyph(NamedNodeMap namedNodeMap) throws IOException {
        Object object;
        byte[][] byArray;
        String string = XMLUtility.parseString(namedNodeMap, "d");
        if (string == null || string.length() == 0) {
            byArray = new byte[0][0];
        } else {
            object = new Base64InputStream(string);
            int n = KbitxBitmapFontImporter.readLEB128((InputStream)object);
            int n2 = KbitxBitmapFontImporter.readLEB128((InputStream)object);
            byArray = new byte[n][n2];
            WIBInputStream wIBInputStream = new WIBInputStream((InputStream)object);
            for (byte[] byArray2 : byArray) {
                wIBInputStream.read(byArray2);
            }
            wIBInputStream.close();
            ((Base64InputStream)object).close();
        }
        object = XMLUtility.parseInt(namedNodeMap, "x");
        Integer n = XMLUtility.parseInt(namedNodeMap, "y");
        Integer n3 = XMLUtility.parseInt(namedNodeMap, "w");
        return new BitmapFontGlyph(byArray, object == null ? 0 : (Integer)object, n3 == null ? 0 : n3, n == null ? 0 : n);
    }

    private static int readLEB128(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = inputStream.read();
        while (n3 >= 0) {
            n |= (n3 & 0x7F) << n2;
            if ((n3 & 0x80) == 0) break;
            n2 += 7;
            n3 = inputStream.read();
        }
        return n;
    }
}

