/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.geos.GEOSFontFile;
import com.kreative.bitsnpicas.geos.GEOSFontPointSize;
import com.kreative.bitsnpicas.geos.GEOSFontStrike;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class GEOSBitmapFontImporter
implements BitmapFontImporter {
    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont[] bitmapFontArray = this.importFont(byteArrayInputStream);
        byteArrayInputStream.close();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        ArrayList<BitmapFont> arrayList = new ArrayList<BitmapFont>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        GEOSFontFile gEOSFontFile = new GEOSFontFile(dataInputStream);
        if (gEOSFontFile.isValid()) {
            for (int n : gEOSFontFile.getFontPointSizes()) {
                BitmapFont bitmapFont = this.importFont(gEOSFontFile, n);
                if (bitmapFont == null) continue;
                arrayList.add(bitmapFont);
            }
        }
        return arrayList.toArray(new BitmapFont[arrayList.size()]);
    }

    public BitmapFont importFont(GEOSFontFile gEOSFontFile, int n) {
        BitmapFontGlyph bitmapFontGlyph;
        int n2;
        GEOSFontPointSize gEOSFontPointSize = gEOSFontFile.getFontPointSize(n);
        GEOSFontStrike gEOSFontStrike = gEOSFontPointSize.isMega() ? gEOSFontPointSize.megaStrikeIndex : gEOSFontPointSize.strike;
        int n3 = gEOSFontStrike.ascent + 1;
        int n4 = gEOSFontStrike.height - n3;
        int n5 = n3;
        int n6 = n4;
        while (n5 + n6 < n) {
            if (n5 + n6 < n) {
                ++n5;
            }
            if (n5 + n6 >= n) continue;
            ++n6;
        }
        while (n5 + n6 > n) {
            if (n5 + n6 > n) {
                --n5;
            }
            if (n5 + n6 <= n) continue;
            --n6;
        }
        String string = gEOSFontFile.getClassTextString();
        String[] stringArray = string.split(" +");
        BitmapFont bitmapFont = new BitmapFont(n5, n6, n3, n4, 0, 0, 0);
        for (n2 = 32; n2 < 128; ++n2) {
            bitmapFontGlyph = GEOSBitmapFontImporter.getASCIIGlyph(gEOSFontPointSize, n2);
            if (bitmapFontGlyph == null) continue;
            bitmapFont.putCharacter(n2, bitmapFontGlyph);
        }
        if (gEOSFontPointSize.isUTF8()) {
            for (n2 = 128; n2 < 0x110000; ++n2) {
                bitmapFontGlyph = GEOSBitmapFontImporter.getUTF8Glyph(gEOSFontPointSize, n2);
                if (bitmapFontGlyph == null) continue;
                bitmapFont.putCharacter(n2, bitmapFontGlyph);
            }
        }
        if (bitmapFont.isEmpty()) {
            return null;
        }
        bitmapFont.setName(1, gEOSFontFile.getFontName());
        bitmapFont.setName(5, stringArray[stringArray.length - 1]);
        bitmapFont.setName(10, gEOSFontFile.getDescriptionString());
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private static BitmapFontGlyph getASCIIGlyph(GEOSFontPointSize gEOSFontPointSize, int n) {
        int n2 = n - 32;
        GEOSFontStrike gEOSFontStrike = gEOSFontPointSize.isMega() ? gEOSFontPointSize.megaStrikes[n2 >> 4] : gEOSFontPointSize.strike;
        return GEOSBitmapFontImporter.getGlyph(gEOSFontStrike, n2);
    }

    private static BitmapFontGlyph getUTF8Glyph(GEOSFontPointSize gEOSFontPointSize, int n) {
        GEOSFontStrike gEOSFontStrike = gEOSFontPointSize.utf8Strikes.get(gEOSFontPointSize.utf8Map.get(n));
        return GEOSBitmapFontImporter.getGlyph(gEOSFontStrike, n & 0x3F);
    }

    private static BitmapFontGlyph getGlyph(GEOSFontStrike gEOSFontStrike, int n) {
        int n2;
        int n3;
        if (gEOSFontStrike == null) {
            return null;
        }
        byte[][] byArray = gEOSFontStrike.getGlyph(n);
        if (byArray == null) {
            return null;
        }
        if (gEOSFontStrike.offsetWidths != null) {
            n3 = gEOSFontStrike.offsetWidths[n].offset;
            n2 = gEOSFontStrike.offsetWidths[n].width;
        } else {
            n3 = 0;
            n2 = byArray[0].length;
        }
        if (n2 == 0 && byArray[0].length == 0) {
            return null;
        }
        return new BitmapFontGlyph(byArray, n3, n2, gEOSFontStrike.ascent + 1);
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont[] bitmapFontArray = this.importFont(fileInputStream);
        fileInputStream.close();
        return bitmapFontArray;
    }
}

