/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos.mover;

import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.SaveChangesDialog;
import com.kreative.bitsnpicas.edit.SaveInterface;
import com.kreative.bitsnpicas.geos.GEOSFontFile;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;

public class SaveManager
extends WindowAdapter
implements SaveInterface {
    private JFrame frame;
    private File file;
    private GEOSFontFile gff;
    private boolean changed;

    public SaveManager(JFrame jFrame, File file, GEOSFontFile gEOSFontFile) {
        this.frame = jFrame;
        this.file = file;
        this.gff = gEOSFontFile;
        this.changed = false;
        this.updateWindow();
    }

    public void setChanged() {
        this.changed = true;
        this.updateWindow();
    }

    public boolean save() {
        if (this.file == null) {
            return this.saveAs();
        }
        boolean bl = this.write();
        if (bl) {
            this.changed = false;
        }
        this.updateWindow();
        return bl;
    }

    public boolean saveAs() {
        File file = Main.getSaveFile(".cvt");
        if (file == null) {
            return false;
        }
        this.file = file;
        boolean bl = this.write();
        if (bl) {
            this.changed = false;
        }
        this.updateWindow();
        return bl;
    }

    private boolean write() {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.file));
            this.gff.write(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (!this.changed) {
            window.dispose();
        } else {
            switch (new SaveChangesDialog(window, this.gff.getFontName()).showDialog()) {
                case SAVE: {
                    if (!this.save()) break;
                    window.dispose();
                    break;
                }
                case DONT_SAVE: {
                    window.dispose();
                    break;
                }
            }
        }
    }

    private void updateWindow() {
        if (CommonMenuItems.IS_MAC_OS) {
            this.frame.getRootPane().putClientProperty("Window.documentFile", this.file);
            this.frame.getRootPane().putClientProperty("Window.documentModified", this.changed);
            this.frame.setTitle(this.gff.getFontName());
        } else {
            this.frame.setTitle(this.changed ? this.gff.getFontName() + " \u2022" : this.gff.getFontName());
        }
    }
}

