/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RockboxBitmapFontExporter
implements BitmapFontExporter {
    public static final int RB11 = 1380069681;
    public static final int RB12 = 1380069682;
    private int magic;
    private int depth;

    public RockboxBitmapFontExporter(int n) {
        if (n != 1380069681 && n != 1380069682) {
            throw new IllegalArgumentException("bad magic number");
        }
        this.magic = n;
        this.depth = 0;
    }

    @Override
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontImpl(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFontImpl(bitmapFont, new DataOutputStream(outputStream));
    }

    @Override
    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontImpl(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFontImpl(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        Object object;
        int n3;
        int n4 = bitmapFont.getLineAscent();
        int n5 = n4 + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        HashMap<Integer, byte[]> hashMap = new HashMap<Integer, byte[]>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        for (n3 = 0; n3 < 0x110000; ++n3) {
            object = (BitmapFontGlyph)bitmapFont.getCharacter(n3);
            if (object == null) continue;
            n2 = ((BitmapFontGlyph)object).getCharacterWidth();
            if (n2 > n6) {
                n6 = n2;
            }
            if (n7 < 0) {
                n7 = n3;
            }
            n8 = n3 - n7 + 1;
            int n10 = (n2 + 15) / 16 * 2;
            byte[] byArray = new byte[n10 * n5];
            byte[][] byArray2 = ((BitmapFontGlyph)object).getGlyph();
            int n11 = 0;
            int n12 = ((BitmapFontGlyph)object).getGlyphAscent() - n4;
            int n13 = 0;
            while (n13 < n5) {
                if (n12 >= 0 && n12 < byArray2.length) {
                    int n14 = 0;
                    int n15 = -((BitmapFontGlyph)object).getGlyphOffset();
                    int n16 = 0;
                    while (n16 < n2) {
                        byte by = 0;
                        int n17 = 128;
                        while (n17 != 0 && n16 < n2) {
                            if (n15 >= 0 && n15 < byArray2[n12].length && byArray2[n12][n15] < 0) {
                                by = (byte)(by | n17);
                            }
                            n17 >>= 1;
                            ++n16;
                            ++n15;
                        }
                        byArray[n11 + n14] = by;
                        ++n14;
                    }
                }
                ++n13;
                ++n12;
                n11 += n10;
            }
            byArray = this.magic == 1380069681 ? RockboxBitmapFontExporter.swab(byArray, 0, n2, n5) : RockboxBitmapFontExporter.rotleft(byArray, 0, n2, n5);
            hashMap3.put(n3, n2);
            hashMap2.put(n3, n9);
            hashMap.put(n3, byArray);
            n9 += byArray.length;
        }
        dataOutputStream.writeInt(this.magic);
        if (this.magic == 1380069681) {
            String string = bitmapFont.getName(1);
            object = string != null ? string.getBytes("UTF-8") : new byte[]{};
            dataOutputStream.write((byte[])object, 0, Math.min(((Object)object).length, 64));
            for (n2 = ((Object)object).length; n2 < 64; ++n2) {
                dataOutputStream.write(32);
            }
            String string2 = bitmapFont.getName(0);
            byte[] byArray = string2 != null ? string2.getBytes("UTF-8") : new byte[]{};
            dataOutputStream.write(byArray, 0, Math.min(byArray.length, 256));
            for (int i = byArray.length; i < 256; ++i) {
                dataOutputStream.write(32);
            }
        }
        n3 = !RockboxBitmapFontExporter.isMono(n7, n8, hashMap) ? 1 : 0;
        dataOutputStream.writeShort(Short.reverseBytes((short)n6));
        dataOutputStream.writeShort(Short.reverseBytes((short)n5));
        dataOutputStream.writeShort(Short.reverseBytes((short)n4));
        dataOutputStream.writeShort(Short.reverseBytes((short)this.depth));
        dataOutputStream.writeInt(Integer.reverseBytes(n7));
        dataOutputStream.writeInt(Integer.reverseBytes(n7));
        dataOutputStream.writeInt(Integer.reverseBytes(n8));
        dataOutputStream.writeInt(Integer.reverseBytes(this.magic == 1380069681 ? n9 / 2 : n9));
        dataOutputStream.writeInt(Integer.reverseBytes(n3 != 0 ? n8 : 0));
        dataOutputStream.writeInt(Integer.reverseBytes(n3 != 0 ? n8 : 0));
        for (n = 0; n < n8; ++n) {
            if (!hashMap.containsKey(n7 + n)) continue;
            dataOutputStream.write(hashMap.get(n7 + n));
        }
        if (this.magic == 1380069681) {
            while ((n9 & 3) != 0) {
                dataOutputStream.writeByte(0);
                ++n9;
            }
        } else {
            while ((n9 & 1) != 0) {
                dataOutputStream.writeByte(0);
                ++n9;
            }
        }
        if (n3 != 0) {
            for (n = 0; n < n8; ++n) {
                if (hashMap2.containsKey(n7 + n)) {
                    if (this.magic == 1380069681) {
                        dataOutputStream.writeInt(Integer.reverseBytes((Integer)hashMap2.get(n7 + n) / 2));
                        continue;
                    }
                    dataOutputStream.writeShort(Short.reverseBytes(((Integer)hashMap2.get(n7 + n)).shortValue()));
                    continue;
                }
                if (this.magic == 1380069681) {
                    dataOutputStream.writeInt(0);
                    continue;
                }
                dataOutputStream.writeShort(0);
            }
            for (n = 0; n < n8; ++n) {
                if (hashMap3.containsKey(n7 + n)) {
                    dataOutputStream.writeByte((Integer)hashMap3.get(n7 + n));
                    continue;
                }
                dataOutputStream.writeByte((Integer)hashMap3.get(n7));
            }
        }
    }

    private static boolean isMono(int n, int n2, HashMap<Integer, byte[]> hashMap) {
        byte[] byArray = hashMap.get(n);
        if (byArray == null) {
            return true;
        }
        int n3 = byArray.length;
        for (int i = 1; i < n2; ++i) {
            byArray = hashMap.get(n + i);
            if (byArray == null) {
                return false;
            }
            if (byArray.length == n3) continue;
            return false;
        }
        return true;
    }

    private static byte[] swab(byte[] byArray, int n, int n2, int n3) {
        int n4 = (n2 + 15) / 16 * 2;
        int n5 = n4 * n3;
        byte[] byArray2 = new byte[n5];
        for (int i = 0; i < n5; ++i) {
            byArray2[i ^ 1] = byArray[n++];
        }
        return byArray2;
    }

    private static byte[] rotleft(byte[] byArray, int n, int n2, int n3) {
        int n4 = (n2 + 15) / 16;
        int n5 = n4 * n3;
        int[] nArray = new int[n5];
        int n6 = 0;
        while (n6 < n5) {
            nArray[n6] = (byArray[n++] & 0xFF) << 8;
            int n7 = n6++;
            nArray[n7] = nArray[n7] | (byArray[n++] & 0xFF) << 0;
        }
        byte[] byArray2 = new byte[(n3 + 7) / 8 * n2];
        int n8 = 0;
        int n9 = 1;
        for (int i = 0; i < n3; ++i) {
            n = i * n4;
            int n10 = 32768;
            for (int j = 0; j < n2; ++j) {
                if ((nArray[n] & n10) != 0) {
                    int n11 = n8 + j;
                    byArray2[n11] = (byte)(byArray2[n11] | n9);
                }
                if ((n10 >>= 1) != 0) continue;
                n10 = 32768;
                ++n;
            }
            if ((n9 <<= 1) < 256) continue;
            n9 = 1;
            n8 += n2;
        }
        return byArray2;
    }
}

