/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.Base64OutputStream;
import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.GlyphPair;
import com.kreative.bitsnpicas.WIBOutputStream;
import com.kreative.bitsnpicas.XMLUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KbitxBitmapFontExporter
implements BitmapFontExporter {
    @Override
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
        printWriter.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
    }

    @Override
    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<!DOCTYPE kbits PUBLIC \"-//Kreative//DTD BitsNPicasBitmap 1.0//EN\" \"http://www.kreativekorp.com/dtd/kbitx.dtd\">");
        printWriter.println("<kbits>");
        for (Map.Entry<String, String> entry : KbitxBitmapFontExporter.getProperties(bitmapFont).entrySet()) {
            printWriter.println(XMLUtility.wrap("prop", true, "id", entry.getKey(), "value", entry.getValue()));
        }
        for (Map.Entry<Object, String> entry : bitmapFont.names(false).entrySet()) {
            printWriter.println(XMLUtility.wrap("name", true, "id", ((Integer)entry.getKey()).toString(), "value", entry.getValue()));
        }
        for (Map.Entry<Object, String> entry : bitmapFont.characters(false).entrySet()) {
            printWriter.println(KbitxBitmapFontExporter.encodeGlyph(entry.getKey(), (BitmapFontGlyph)((Object)entry.getValue())));
        }
        for (Map.Entry<Object, String> entry : bitmapFont.namedGlyphs(false).entrySet()) {
            printWriter.println(KbitxBitmapFontExporter.encodeGlyph(entry.getKey(), (BitmapFontGlyph)((Object)entry.getValue())));
        }
        for (Map.Entry<Object, Object> entry : bitmapFont.kernPairs(false).entrySet()) {
            Object object = ((GlyphPair)entry.getKey()).getLeft();
            Object object2 = ((GlyphPair)entry.getKey()).getRight();
            printWriter.println(XMLUtility.wrap("k", true, object instanceof Integer ? "lu" : "ln", object.toString(), object2 instanceof Integer ? "ru" : "rn", object2.toString(), "o", ((Integer)entry.getValue()).toString()));
        }
        printWriter.println("</kbits>");
    }

    private static Map<String, String> getProperties(BitmapFont bitmapFont) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("emAscent", Integer.toString(bitmapFont.getEmAscent()));
        linkedHashMap.put("emDescent", Integer.toString(bitmapFont.getEmDescent()));
        linkedHashMap.put("lineAscent", Integer.toString(bitmapFont.getLineAscent()));
        linkedHashMap.put("lineDescent", Integer.toString(bitmapFont.getLineDescent()));
        linkedHashMap.put("lineGap", Integer.toString(bitmapFont.getLineGap()));
        linkedHashMap.put("xHeight", Integer.toString(bitmapFont.getXHeight()));
        linkedHashMap.put("capHeight", Integer.toString(bitmapFont.getCapHeight()));
        return linkedHashMap;
    }

    private static String encodeGlyph(Object object, BitmapFontGlyph bitmapFontGlyph) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Base64OutputStream base64OutputStream = new Base64OutputStream(stringBuffer, false);
        byte[][] byArray = bitmapFontGlyph.getGlyph();
        int n = byArray.length;
        int n2 = 0;
        for (byte[] byArray2 : byArray) {
            if (n2 >= byArray2.length) continue;
            n2 = byArray2.length;
        }
        KbitxBitmapFontExporter.writeLEB128(base64OutputStream, n);
        KbitxBitmapFontExporter.writeLEB128(base64OutputStream, n2);
        Object object2 = new WIBOutputStream(base64OutputStream);
        for (byte[] byArray3 : byArray) {
            ((OutputStream)object2).write(byArray3);
            ((OutputStream)object2).write(new byte[n2 - byArray3.length]);
        }
        ((WIBOutputStream)object2).close();
        base64OutputStream.close();
        return XMLUtility.wrap("g", true, object instanceof Integer ? "u" : "n", object.toString(), "x", Integer.toString(bitmapFontGlyph.getX()), "y", Integer.toString(bitmapFontGlyph.getY()), "w", Integer.toString(bitmapFontGlyph.getCharacterWidth()), "d", stringBuffer.toString());
    }

    private static void writeLEB128(OutputStream outputStream, int n) throws IOException {
        while (n >= 128) {
            outputStream.write(n | 0x80);
            n >>= 7;
        }
        outputStream.write(n);
    }
}

