/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class KbitsBitmapFontExporter
implements BitmapFontExporter {
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.exportFont(bitmapFont, dataOutputStream);
        dataOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFont(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        this.exportFont(bitmapFont, dataOutputStream);
        dataOutputStream.close();
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(1262644816);
        dataOutputStream.writeInt(1651078259);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(bitmapFont.getEmAscent());
        dataOutputStream.writeInt(bitmapFont.getEmDescent());
        dataOutputStream.writeInt(bitmapFont.getLineAscent());
        dataOutputStream.writeInt(bitmapFont.getLineDescent());
        dataOutputStream.writeInt(bitmapFont.getLineGap());
        dataOutputStream.writeInt(bitmapFont.getXHeight());
        for (Map.Entry<Integer, String> entry : bitmapFont.names(false).entrySet()) {
            dataOutputStream.writeInt(1851878757);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(entry.getKey());
            dataOutputStream.writeUTF(entry.getValue());
        }
        for (Map.Entry<Integer, String> entry : bitmapFont.characters(false).entrySet()) {
            dataOutputStream.writeInt(1667785074);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(entry.getKey());
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)((Object)entry.getValue());
            dataOutputStream.writeInt(bitmapFontGlyph.getCharacterWidth());
            dataOutputStream.writeInt(bitmapFontGlyph.getGlyphOffset());
            dataOutputStream.writeInt(bitmapFontGlyph.getGlyphAscent());
            byte[][] byArray = bitmapFontGlyph.getGlyph();
            dataOutputStream.writeInt(byArray.length);
            for (byte[] byArray2 : byArray) {
                dataOutputStream.writeInt(byArray2.length);
                dataOutputStream.write(byArray2);
            }
        }
        dataOutputStream.writeInt(1718185518);
    }
}

