/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.importer.EncodingSelectionImporter;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class EncodingSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public EncodingSelectionPanel(String string, final File file, final EncodingSelectionImporter encodingSelectionImporter) {
        final JComboBox<Object> jComboBox = new JComboBox<Object>(EncodingList.instance().glyphLists().toArray());
        jComboBox.setEditable(false);
        jComboBox.setSelectedItem(EncodingList.instance().getGlyphList(string));
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.add((Component)new JLabel("Select an encoding for " + file.getName() + "."), "First");
        jPanel.add(jComboBox, "Center");
        JButton jButton = new JButton("Open");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel(new BorderLayout(12, 12));
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "Last");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(jPanel3);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GlyphList glyphList = (GlyphList)jComboBox.getSelectedItem();
                    Font[] fontArray = encodingSelectionImporter.createImporter(glyphList).importFont(file);
                    if (fontArray != null && fontArray.length > 0) {
                        Main.openFonts(file, null, fontArray);
                    } else {
                        JOptionPane.showMessageDialog(null, "The selected file did not contain any fonts.", "Open", 0);
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "An error occurred while reading the selected file.", "Open", 0);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    JOptionPane.showMessageDialog(null, "The selected file requires KSFL, but KSFL is not in the classpath.", "Open", 0);
                }
            }
        });
    }
}

