/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorInstruction {
    private final char operation;
    private final Number[] operands;

    public VectorInstruction(char c, Number ... numberArray) {
        this.operation = c;
        this.operands = new Number[numberArray.length];
        int n = 0;
        for (Number number : numberArray) {
            this.operands[n++] = number;
        }
    }

    public VectorInstruction(char c, Collection<? extends Number> collection) {
        this.operation = c;
        this.operands = new Number[collection.size()];
        int n = 0;
        for (Number number : collection) {
            this.operands[n++] = number;
        }
    }

    public char getOperation() {
        return this.operation;
    }

    public List<Number> getOperands() {
        return Collections.unmodifiableList(Arrays.asList(this.operands));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.operation);
        for (Number number : this.operands) {
            stringBuffer.append(" ");
            stringBuffer.append(number);
        }
        return stringBuffer.toString();
    }
}

