/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.PathGraph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;

public class BitmapFontGlyph
extends FontGlyph {
    protected byte[][] glyph;
    protected int x;
    protected int y;
    protected int advance;

    public BitmapFontGlyph() {
        this.glyph = new byte[0][0];
        this.x = 0;
        this.y = 0;
        this.advance = 0;
    }

    public BitmapFontGlyph(byte[][] byArray) {
        this.glyph = byArray;
        this.x = 0;
        this.y = byArray.length;
        this.advance = byArray.length < 1 ? 0 : byArray[0].length;
    }

    public BitmapFontGlyph(byte[][] byArray, int n, int n2, int n3) {
        this.glyph = byArray;
        this.x = n;
        this.y = n3;
        this.advance = n2;
    }

    public byte[][] getGlyph() {
        return this.glyph;
    }

    public void setGlyph(byte[][] byArray) {
        this.glyph = byArray;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getGlyphWidth() {
        return this.glyph.length < 1 ? 0 : this.glyph[0].length;
    }

    public double getGlyphWidth2D() {
        return this.glyph.length < 1 ? 0.0 : (double)this.glyph[0].length;
    }

    public int getGlyphHeight() {
        return this.glyph.length;
    }

    public double getGlyphHeight2D() {
        return this.glyph.length;
    }

    public int getGlyphOffset() {
        return this.x;
    }

    public double getGlyphOffset2D() {
        return this.x;
    }

    public int getGlyphAscent() {
        return this.y;
    }

    public double getGlyphAscent2D() {
        return this.y;
    }

    public int getGlyphDescent() {
        return this.glyph.length - this.y;
    }

    public double getGlyphDescent2D() {
        return this.glyph.length - this.y;
    }

    public int getCharacterWidth() {
        return this.advance;
    }

    public double getCharacterWidth2D() {
        return this.advance;
    }

    public void setCharacterWidth(int n) {
        this.advance = n;
    }

    public void setCharacterWidth2D(double d) {
        this.advance = (int)Math.ceil(d);
    }

    public double paint(Graphics graphics, double d, double d2, double d3) {
        int n;
        Color color = graphics.getColor();
        int n2 = color.getRGB() & 0xFFFFFF;
        int n3 = color.getAlpha();
        int n4 = this.glyph.length < 1 ? 0 : this.glyph[0].length;
        int n5 = this.glyph.length;
        int[] nArray = new int[n4 * n5];
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            for (n = 0; n < n4; ++n) {
                nArray[n6] = n3 * (this.glyph[i][n] & 0xFF) / 255 << 24 | n2;
                ++n6;
            }
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n4, n5, nArray, 0, n4);
        Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        n = (int)Math.round(d + (double)this.x * d3);
        int n7 = (int)Math.round(d2 - (double)this.y * d3);
        int n8 = (int)Math.round((double)n4 * d3);
        int n9 = (int)Math.round((double)n5 * d3);
        graphics.drawImage(image, n, n7, n + n8, n7 + n9, 0, 0, n4, n5, null);
        return (double)this.advance * d3;
    }

    public PathGraph convertToPathGraph(int n) {
        PathGraph pathGraph = new PathGraph();
        int n2 = this.glyph.length < 1 ? 0 : this.glyph[0].length;
        int n3 = this.glyph.length;
        int n4 = 0;
        int n5 = this.y - 1;
        while (n4 < n3) {
            int n6 = 0;
            int n7 = this.x;
            while (n6 < n2) {
                if ((this.glyph[n4][n6] & 0xFF) >= 128) {
                    pathGraph.plot(n, n7, n5);
                }
                ++n6;
                ++n7;
            }
            ++n4;
            --n5;
        }
        return pathGraph;
    }

    public PathGraph convertToPathGraph(int n, int n2) {
        PathGraph pathGraph = new PathGraph();
        int n3 = this.glyph.length < 1 ? 0 : this.glyph[0].length;
        int n4 = this.glyph.length;
        int n5 = 0;
        int n6 = this.y - 1;
        while (n5 < n4) {
            int n7 = 0;
            int n8 = this.x;
            while (n7 < n3) {
                if ((this.glyph[n5][n7] & 0xFF) >= 128) {
                    pathGraph.plot(n, n2, n8, n6);
                }
                ++n7;
                ++n8;
            }
            ++n5;
            --n6;
        }
        return pathGraph;
    }

    public byte getPixel(int n, int n2) {
        byte[][] byArray = this.getGlyph();
        int n3 = n - this.getX();
        int n4 = n2 + this.getY();
        if (n4 >= 0 && n4 < byArray.length && n3 >= 0 && n3 < byArray[n4].length) {
            return byArray[n4][n3];
        }
        return 0;
    }

    public void drawLine(int n, int n2, int n3, int n4, byte by) {
        byte[][] byArray = this.getGlyph();
        int n5 = this.getX();
        int n6 = this.getY();
        int n7 = Math.abs(n3 - n) + Math.abs(n4 - n2) + 1;
        for (int i = 0; i <= n7; ++i) {
            int n8 = n + (int)Math.round((double)((n3 - n) * i) / (double)n7) - n5;
            int n9 = n2 + (int)Math.round((double)((n4 - n2) * i) / (double)n7) + n6;
            if (n9 < 0 || n9 >= byArray.length || n8 < 0 || n8 >= byArray[n9].length) continue;
            byArray[n9][n8] = by;
        }
    }

    public void drawRect(int n, int n2, int n3, int n4, byte by) {
        int n5;
        int n6;
        int n7;
        int n8;
        byte[][] byArray = this.getGlyph();
        int n9 = this.getX();
        int n10 = this.getY();
        int n11 = n2 + n4;
        for (n8 = n2; n8 <= n11; ++n8) {
            n7 = n - n9;
            n6 = n + n3 - n9;
            n5 = n8 + n10;
            if (n5 < 0 || n5 >= byArray.length) continue;
            if (n7 >= 0 && n7 < byArray[n5].length) {
                byArray[n5][n7] = by;
            }
            if (n6 < 0 || n6 >= byArray[n5].length) continue;
            byArray[n5][n6] = by;
        }
        n11 = n + n3;
        for (n8 = n; n8 <= n11; ++n8) {
            n7 = n8 - n9;
            n6 = n2 + n10;
            n5 = n2 + n4 + n10;
            if (n6 >= 0 && n6 < byArray.length && n7 >= 0 && n7 < byArray[n6].length) {
                byArray[n6][n7] = by;
            }
            if (n5 < 0 || n5 >= byArray.length || n7 < 0 || n7 >= byArray[n5].length) continue;
            byArray[n5][n7] = by;
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, byte by) {
        byte[][] byArray = this.getGlyph();
        int n5 = this.getX();
        int n6 = this.getY();
        int n7 = n2 + n4;
        for (int i = n2; i < n7; ++i) {
            int n8 = i + n6;
            int n9 = n + n3;
            for (int j = n; j < n9; ++j) {
                int n10 = j - n5;
                if (n8 < 0 || n8 >= byArray.length || n10 < 0 || n10 >= byArray[n8].length) continue;
                byArray[n8][n10] = by;
            }
        }
    }

    public void invertRect(int n, int n2, int n3, int n4) {
        byte[][] byArray = this.getGlyph();
        int n5 = this.getX();
        int n6 = this.getY();
        int n7 = n2 + n4;
        for (int i = n2; i < n7; ++i) {
            int n8 = i + n6;
            int n9 = n + n3;
            for (int j = n; j < n9; ++j) {
                int n10 = j - n5;
                if (n8 < 0 || n8 >= byArray.length || n10 < 0 || n10 >= byArray[n8].length) continue;
                byte[] byArray2 = byArray[n8];
                int n11 = n10;
                byArray2[n11] = ~byArray2[n11];
            }
        }
    }

    public void setToImage(int n, int n2, BufferedImage bufferedImage) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int[] nArray = new int[n3 * n4];
        bufferedImage.getRGB(0, 0, n3, n4, nArray, 0, n3);
        byte[][] byArray = new byte[n4][n3];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            for (int i = 0; i < n3; ++i) {
                int n7 = nArray[n6 + i] >> 24 & 0xFF;
                int n8 = nArray[n6 + i] >> 16 & 0xFF;
                int n9 = nArray[n6 + i] >> 8 & 0xFF;
                int n10 = nArray[n6 + i] >> 0 & 0xFF;
                int n11 = (25500 - (30 * n8 + 59 * n9 + 11 * n10)) * n7 / 25500;
                byArray[n5][i] = (byte)n11;
            }
            ++n5;
            n6 += n3;
        }
        this.setXY(n, -n2);
        this.setGlyph(byArray);
    }

    public void expand(int n, int n2, int n3, int n4) {
        byte[][] byArray = this.getGlyph();
        if (byArray.length == 0) {
            this.setXY(n, -n2);
            this.setGlyph(new byte[n4][n3]);
            return;
        }
        int n5 = this.getX();
        int n6 = this.getY();
        int n7 = byArray[0].length;
        int n8 = byArray.length;
        int n9 = Math.min(n, n5);
        int n10 = Math.min(n2, -n6);
        int n11 = Math.max(n + n3, n5 + n7) - n9;
        int n12 = Math.max(n2 + n4, -n6 + n8) - n10;
        if (n9 < n5 || n10 < -n6 || n9 + n11 > n5 + n7 || n10 + n12 > -n6 + n8) {
            byte[][] byArray2 = new byte[n12][n11];
            int n13 = 0;
            int n14 = -n6 - n10;
            while (n13 < n8) {
                int n15 = 0;
                int n16 = n5 - n9;
                while (n15 < n7) {
                    byArray2[n14][n16] = byArray[n13][n15];
                    ++n15;
                    ++n16;
                }
                ++n13;
                ++n14;
            }
            this.setXY(n9, -n10);
            this.setGlyph(byArray2);
        }
    }

    public void contract() {
        int n;
        byte[][] byArray = this.getGlyph();
        if (byArray.length == 0) {
            this.setXY(0, 0);
            return;
        }
        int n2 = this.getX();
        int n3 = this.getY();
        int n4 = byArray[0].length;
        int n5 = byArray.length;
        int n6 = n2;
        int n7 = -n3;
        int n8 = n2 + n4;
        for (n = -n3 + n5; n > n7 && BitmapFontGlyph.rowEmpty(byArray, n + n3 - 1); --n) {
        }
        while (n7 < n && BitmapFontGlyph.rowEmpty(byArray, n7 + n3)) {
            ++n7;
        }
        while (n8 > n6 && BitmapFontGlyph.colEmpty(byArray, n8 - n2 - 1)) {
            --n8;
        }
        while (n6 < n8 && BitmapFontGlyph.colEmpty(byArray, n6 - n2)) {
            ++n6;
        }
        if (n8 == n6 || n == n7) {
            this.setXY(0, 0);
            this.setGlyph(new byte[0][0]);
            return;
        }
        if (n6 != n2 || n7 != -n3 || n8 != n2 + n4 || n != -n3 + n5) {
            int n9 = n8 - n6;
            int n10 = n - n7;
            byte[][] byArray2 = new byte[n10][n9];
            int n11 = 0;
            int n12 = n7 + n3;
            while (n11 < n10) {
                int n13 = 0;
                int n14 = n6 - n2;
                while (n13 < n9) {
                    byArray2[n11][n13] = byArray[n12][n14];
                    ++n13;
                    ++n14;
                }
                ++n11;
                ++n12;
            }
            this.setXY(n6, -n7);
            this.setGlyph(byArray2);
        }
    }

    public static BitmapFontGlyph compose(BitmapFontGlyph ... bitmapFontGlyphArray) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (BitmapFontGlyph bitmapFontGlyph : bitmapFontGlyphArray) {
            if (bitmapFontGlyph == null) continue;
            if (bitmapFontGlyph.x < n) {
                n = bitmapFontGlyph.x;
            }
            if (-bitmapFontGlyph.y < n2) {
                n2 = -bitmapFontGlyph.y;
            }
            if (bitmapFontGlyph.advance > n5) {
                n5 = bitmapFontGlyph.advance;
            }
            if (-bitmapFontGlyph.y + bitmapFontGlyph.glyph.length > n4) {
                n4 = -bitmapFontGlyph.y + bitmapFontGlyph.glyph.length;
            }
            for (Object i : (BitmapFontGlyph)bitmapFontGlyph.glyph) {
                if (bitmapFontGlyph.x + ((Object)i).length <= n3) continue;
                n3 = bitmapFontGlyph.x + ((Object)i).length;
            }
        }
        if (n4 < n2 || n3 < n) {
            return null;
        }
        byte[][] byArray = new byte[n4 - n2][n3 - n];
        for (BitmapFontGlyph bitmapFontGlyph : bitmapFontGlyphArray) {
            if (bitmapFontGlyph == null) continue;
            int n6 = bitmapFontGlyph.x - n;
            int n7 = -bitmapFontGlyph.y - n2;
            for (int i = 0; i < bitmapFontGlyph.glyph.length; ++i) {
                for (int j = 0; j < bitmapFontGlyph.glyph[i].length; ++j) {
                    if ((bitmapFontGlyph.glyph[i][j] & 0xFF) <= (byArray[n7 + i][n6 + j] & 0xFF)) continue;
                    byArray[n7 + i][n6 + j] = bitmapFontGlyph.glyph[i][j];
                }
            }
        }
        return new BitmapFontGlyph(byArray, n, n5, -n2);
    }

    private static boolean rowEmpty(byte[][] byArray, int n) {
        for (byte by : byArray[n]) {
            if (by == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean colEmpty(byte[][] byArray, int n) {
        for (byte[] byArray2 : byArray) {
            if (byArray2[n] == 0) continue;
            return false;
        }
        return true;
    }
}

