/*******************************<GINKGO LICENSE>******************************
Copyright (c) 2017-2023, the Ginkgo authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************<GINKGO LICENSE>*******************************/

#ifndef GKO_CORE_MATRIX_HYBRID_KERNELS_HPP_
#define GKO_CORE_MATRIX_HYBRID_KERNELS_HPP_


#include <ginkgo/core/matrix/hybrid.hpp>


#include <ginkgo/core/matrix/dense.hpp>


#include "core/base/kernel_declaration.hpp"


namespace gko {
namespace kernels {


#define GKO_DECLARE_HYBRID_COMPUTE_ROW_NNZ                            \
    void compute_row_nnz(std::shared_ptr<const DefaultExecutor> exec, \
                         const array<int64>& row_ptrs, size_type* row_nnzs)

#define GKO_DECLARE_HYBRID_COMPUTE_COO_ROW_PTRS_KERNEL                     \
    void compute_coo_row_ptrs(std::shared_ptr<const DefaultExecutor> exec, \
                              const array<size_type>& row_nnz,             \
                              size_type ell_lim, int64* coo_row_ptrs)

#define GKO_DECLARE_HYBRID_FILL_IN_MATRIX_DATA_KERNEL(ValueType, IndexType) \
    void fill_in_matrix_data(                                               \
        std::shared_ptr<const DefaultExecutor> exec,                        \
        const device_matrix_data<ValueType, IndexType>& data,               \
        const int64* row_ptrs, const int64* coo_row_ptrs,                   \
        matrix::Hybrid<ValueType, IndexType>* result)

#define GKO_DECLARE_HYBRID_CONVERT_TO_CSR_KERNEL(ValueType, IndexType)      \
    void convert_to_csr(std::shared_ptr<const DefaultExecutor> exec,        \
                        const matrix::Hybrid<ValueType, IndexType>* source, \
                        const IndexType* ell_row_ptrs,                      \
                        const IndexType* coo_row_ptrs,                      \
                        matrix::Csr<ValueType, IndexType>* result)


#define GKO_DECLARE_ALL_AS_TEMPLATES                                     \
    GKO_DECLARE_HYBRID_COMPUTE_ROW_NNZ;                                  \
    GKO_DECLARE_HYBRID_COMPUTE_COO_ROW_PTRS_KERNEL;                      \
    template <typename ValueType, typename IndexType>                    \
    GKO_DECLARE_HYBRID_FILL_IN_MATRIX_DATA_KERNEL(ValueType, IndexType); \
    template <typename ValueType, typename IndexType>                    \
    GKO_DECLARE_HYBRID_CONVERT_TO_CSR_KERNEL(ValueType, IndexType)


GKO_DECLARE_FOR_ALL_EXECUTOR_NAMESPACES(hybrid, GKO_DECLARE_ALL_AS_TEMPLATES);


#undef GKO_DECLARE_ALL_AS_TEMPLATES


}  // namespace kernels
}  // namespace gko


#endif  // GKO_CORE_MATRIX_HYBRID_KERNELS_HPP_
