/* $Id: xp_icmp_addrmask.c,v 1.1 2002/01/21 18:28:46 mixter Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"


rpack_t *send_icmpmaskreq_req(struct sockaddr_in to) {

    int sndsock, rcvsock;
    int res;
    struct protoent *pe;
    struct sockaddr_in from;
    struct ip *ip, *rcv_ip;
    struct icmp *icmp, *rcv_icmp;
    unsigned char *pack, *recv_pack=NULL;
    int on = 1;
    int packlen;
    rpack_t *retval = NULL;

    sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
    pe = getprotobyname("icmp");
    rcvsock = socket(AF_INET, SOCK_RAW, pe->p_proto);
    setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on, sizeof(on));

    packlen = sizeof(struct ip) + sizeof(struct icmp);

    pack = (unsigned char *)calloc( packlen, 1);

    if (pack == NULL) {
        perror("calloc");
        return NULL;
    }

    ip = (struct ip *)pack;
    icmp = (struct icmp *)(pack + sizeof(struct ip));
    
    ip->ip_p     = IPPROTO_ICMP;
    ip->ip_dst   = to.sin_addr;
    ip->ip_len   = packlen;
    ip->ip_ttl   = 250;
    ip->ip_v     = IP_VERSION;
    ip->ip_hl    = sizeof(struct ip) >> 2;
    ip->ip_off   = 0;
    ip->ip_tos  = 0; 
    ip->ip_id   = rand();

    icmp->icmp_type = ICMP_MASKREQ;
    icmp->icmp_code = 0;
    icmp->icmp_seq = rand();
    icmp->icmp_cksum = in_cksum((unsigned short *)icmp,
                                packlen - sizeof(struct ip));
    if (icmp->icmp_cksum == 0)
        icmp->icmp_cksum = 0xffff;
    
#ifdef EBUG 
    fprintf(stderr,"TEST: ICMP address mask request to %s ",
                                            inet_ntoa(to.sin_addr));
#endif
    
   res = sendto(sndsock, (void *)pack, packlen,
                0, (struct sockaddr *)&to, sizeof(struct sockaddr));

   if (res <0) {
       perror("sendto:");
       close(sndsock);
       close(rcvsock);
       free(pack);
       return NULL;
   }
#ifdef EBUG
   fprintf(stderr,"[%d bytes] sent, waiting for reponse.\n", res);
#endif

   recv_pack=(unsigned char*)calloc(PACKBUF_SIZ+1, 1);
   res = wait_icmp(rcvsock, &from, recv_pack, PACKBUF_SIZ);
   
   if (res == 0 || res < 0 ) {
#ifdef EBUG
       if (res < 0) 
           perror("Receive error:");
       else    
           fprintf(stderr, "Receive timeout. Quitting..\n");
#endif

       close(sndsock);
       close(rcvsock);
       free(pack);
       free(recv_pack);
       return NULL;
   }

#ifdef EBUG
   fprintf(stderr,"Received %d bytes packet.\n", res);
#endif
 
   rcv_ip = (struct ip *)recv_pack;
 /* sanity checks */

#ifdef DEBUG
    fprintf(stderr, "hlen: %d\nlen: %d\n", rcv_ip->ip_hl<<2, rcv_ip->ip_len);
#endif    
    
   if ((unsigned)res < sizeof(struct ip)      ||
       (rcv_ip->ip_hl << 2) > (unsigned)res ||
#ifdef __linux__
       ntohs(rcv_ip->ip_len)
#else       
       (rcv_ip->ip_len)
#endif       
       > res          ) {
#ifdef EBUG
       fprintf(stderr,"Received maliformed packet!\n");
#endif
       close(sndsock);
       close(rcvsock);
       free(pack);
       free(recv_pack);
       return NULL;
   }

   rcv_icmp = (struct icmp *)(recv_pack + (rcv_ip->ip_hl<<2));

#ifdef DEBUG
   fprintf(stderr,"type: %d code: %d\n", rcv_icmp->icmp_type, rcv_icmp->icmp_code);
#endif   

  retval=(rpack_t *)calloc(sizeof(rpack_t), 1);

   retval->packsize = res;
   retval->pkt = (char *)recv_pack;
   retval->ip = rcv_ip;
   retval->icmp = rcv_icmp;
      
   close(sndsock);
   close(rcvsock);
   free(pack);
   free(recv_pack);
   return retval;

}
