/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ScoreMatrix;
import jalview.util.Comparison;
import jalview.util.Format;
import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class AlignSeq {
    public static final String PEP = "pep";
    public static final String DNA = "dna";
    static String[] dna = new String[]{"A", "C", "G", "T", "-"};
    static String[] pep = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X", "-"};
    int[][] score;
    int[][] E;
    int[][] F;
    int[][] traceback;
    int[] seq1;
    int[] seq2;
    SequenceI s1;
    SequenceI s2;
    public String s1str;
    public String s2str;
    int maxi;
    int maxj;
    int[] aseq1;
    int[] aseq2;
    public String astr1 = "";
    public String astr2 = "";
    public int seq1start;
    public int seq1end;
    public int seq2start;
    public int seq2end;
    int count;
    public int maxscore;
    float pid;
    int prev = 0;
    int gapOpen = 120;
    int gapExtend = 20;
    int[][] lookup = ResidueProperties.getBLOSUM62();
    String[] intToStr = pep;
    int defInt = 23;
    StringBuffer output = new StringBuffer();
    String type;
    private int[] charToInt;

    public AlignSeq(SequenceI s1, SequenceI s2, String type) {
        this.SeqInit(s1, s1.getSequenceAsString(), s2, s2.getSequenceAsString(), type);
    }

    public AlignSeq(SequenceI s1, String string1, SequenceI s2, String string2, String type) {
        this.SeqInit(s1, string1, s2, string2, type);
    }

    public int getMaxScore() {
        return this.maxscore;
    }

    public int getSeq2Start() {
        return this.seq2start;
    }

    public int getSeq2End() {
        return this.seq2end;
    }

    public int getSeq1Start() {
        return this.seq1start;
    }

    public int getSeq1End() {
        return this.seq1end;
    }

    public String getOutput() {
        return this.output.toString();
    }

    public String getAStr1() {
        return this.astr1;
    }

    public String getAStr2() {
        return this.astr2;
    }

    public int[] getASeq1() {
        return this.aseq1;
    }

    public int[] getASeq2() {
        return this.aseq2;
    }

    public SequenceI getS1() {
        return this.s1;
    }

    public SequenceI getS2() {
        return this.s2;
    }

    public void SeqInit(SequenceI s1, String string1, SequenceI s2, String string2, String type) {
        this.s1 = s1;
        this.s2 = s2;
        this.setDefaultParams(type);
        this.SeqInit(string1, string2);
    }

    public void SeqInit(SequenceI s1, String string1, SequenceI s2, String string2, ScoreMatrix scoreMatrix) {
        this.s1 = s1;
        this.s2 = s2;
        this.setType(scoreMatrix.isDNA() ? DNA : PEP);
        this.lookup = scoreMatrix.getMatrix();
    }

    private void SeqInit(String string1, String string2) {
        this.s1str = AlignSeq.extractGaps(" .-", string1);
        this.s2str = AlignSeq.extractGaps(" .-", string2);
        if (this.s1str.length() == 0 || this.s2str.length() == 0) {
            this.output.append("ALL GAPS: " + (this.s1str.length() == 0 ? this.s1.getName() : " ") + (this.s2str.length() == 0 ? this.s2.getName() : ""));
            return;
        }
        this.seq1 = new int[this.s1str.length()];
        this.seq2 = new int[this.s2str.length()];
        this.score = new int[this.s1str.length()][this.s2str.length()];
        this.E = new int[this.s1str.length()][this.s2str.length()];
        this.F = new int[this.s1str.length()][this.s2str.length()];
        this.traceback = new int[this.s1str.length()][this.s2str.length()];
        this.seq1 = this.stringToInt(this.s1str, this.type);
        this.seq2 = this.stringToInt(this.s2str, this.type);
    }

    private void setDefaultParams(String type) {
        this.setType(type);
        if (type.equals(PEP)) {
            this.lookup = ResidueProperties.getDefaultPeptideMatrix();
        } else if (type.equals(DNA)) {
            this.lookup = ResidueProperties.getDefaultDnaMatrix();
        }
    }

    private void setType(String type2) {
        this.type = type2;
        if (this.type.equals(PEP)) {
            this.intToStr = pep;
            this.charToInt = ResidueProperties.aaIndex;
            this.defInt = 23;
        } else if (this.type.equals(DNA)) {
            this.intToStr = dna;
            this.charToInt = ResidueProperties.nucleotideIndex;
            this.defInt = 4;
        } else {
            this.output.append("Wrong type = dna or pep only");
            throw new Error("Unknown Type " + type2 + " - dna or pep are the only allowed values.");
        }
    }

    public void traceAlignment() {
        int i;
        int max = -9999;
        for (i = 0; i < this.seq1.length; ++i) {
            if (this.score[i][this.seq2.length - 1] <= max) continue;
            max = this.score[i][this.seq2.length - 1];
            this.maxi = i;
            this.maxj = this.seq2.length - 1;
        }
        for (int j = 0; j < this.seq2.length; ++j) {
            if (this.score[this.seq1.length - 1][j] <= max) continue;
            max = this.score[this.seq1.length - 1][j];
            this.maxi = this.seq1.length - 1;
            this.maxj = j;
        }
        i = this.maxi;
        int j = this.maxj;
        this.maxscore = this.score[i][j] / 10;
        this.seq1end = this.maxi + 1;
        this.seq2end = this.maxj + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        this.count = this.seq1.length + this.seq2.length - 1;
        while (i > 0 && j > 0) {
            int trace;
            if (this.aseq1[this.count] != this.defInt && i >= 0) {
                this.aseq1[this.count] = this.seq1[i];
                this.astr1 = this.s1str.charAt(i) + this.astr1;
            }
            if (this.aseq2[this.count] != this.defInt && j > 0) {
                this.aseq2[this.count] = this.seq2[j];
                this.astr2 = this.s2str.charAt(j) + this.astr2;
            }
            if ((trace = this.findTrace(i, j)) == 0) {
                --i;
                --j;
            } else if (trace == 1) {
                --j;
                this.aseq1[this.count] = this.defInt;
                this.astr1 = "-" + this.astr1.substring(1);
            } else if (trace == -1) {
                --i;
                this.aseq2[this.count] = this.defInt;
                this.astr2 = "-" + this.astr2.substring(1);
            }
            --this.count;
        }
        this.seq1start = i + 1;
        this.seq2start = j + 1;
        if (this.aseq1[this.count] != this.defInt) {
            this.aseq1[this.count] = this.seq1[i];
            this.astr1 = this.s1str.charAt(i) + this.astr1;
        }
        if (this.aseq2[this.count] != this.defInt) {
            this.aseq2[this.count] = this.seq2[j];
            this.astr2 = this.s2str.charAt(j) + this.astr2;
        }
    }

    public void printAlignment(PrintStream os) {
        int maxid = this.s1.getName().length();
        if (this.s2.getName().length() > maxid) {
            maxid = this.s2.getName().length();
        }
        int len = 72 - maxid - 1;
        int nochunks = (this.aseq1.length - this.count) / len + 1;
        this.pid = 0.0f;
        this.output.append("Score = " + this.score[this.maxi][this.maxj] + "\n");
        this.output.append("Length of alignment = " + (this.aseq1.length - this.count) + "\n");
        this.output.append("Sequence ");
        this.output.append(new Format("%" + maxid + "s").form(this.s1.getName()));
        this.output.append(" :  " + this.s1.getStart() + " - " + this.s1.getEnd() + " (Sequence length = " + this.s1str.length() + ")\n");
        this.output.append("Sequence ");
        this.output.append(new Format("%" + maxid + "s").form(this.s2.getName()));
        this.output.append(" :  " + this.s2.getStart() + " - " + this.s2.getEnd() + " (Sequence length = " + this.s2str.length() + ")\n\n");
        for (int j = 0; j < nochunks; ++j) {
            int i;
            this.output.append(new Format("%" + maxid + "s").form(this.s1.getName()) + " ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= this.astr1.length()) continue;
                this.output.append(this.astr1.charAt(i + j * len));
            }
            this.output.append("\n");
            this.output.append(new Format("%" + maxid + "s").form(" ") + " ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= this.astr1.length()) continue;
                if (this.astr1.charAt(i + j * len) == this.astr2.charAt(i + j * len) && !Comparison.isGap(this.astr1.charAt(i + j * len))) {
                    this.pid += 1.0f;
                    this.output.append("|");
                    continue;
                }
                if (this.type.equals(PEP)) {
                    if (ResidueProperties.getPAM250(this.astr1.charAt(i + j * len), this.astr2.charAt(i + j * len)) > 0) {
                        this.output.append(".");
                        continue;
                    }
                    this.output.append(" ");
                    continue;
                }
                this.output.append(" ");
            }
            this.output = this.output.append("\n");
            this.output = this.output.append(new Format("%" + maxid + "s").form(this.s2.getName()) + " ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= this.astr2.length()) continue;
                this.output.append(this.astr2.charAt(i + j * len));
            }
            this.output = this.output.append("\n\n");
        }
        this.pid = this.pid / (float)(this.aseq1.length - this.count) * 100.0f;
        this.output = this.output.append(new Format("Percentage ID = %2.2f\n\n").form(this.pid));
        try {
            os.print(this.output.toString());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void printScoreMatrix(int[][] mat) {
        int n = this.seq1.length;
        int m = this.seq2.length;
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                Format.print(System.out, "%8s", this.s2str.substring(0, 1));
                for (int jj = 1; jj < m; ++jj) {
                    Format.print(System.out, "%5s", this.s2str.substring(jj, jj + 1));
                }
                System.out.println();
            }
            for (int j = 0; j < m; ++j) {
                if (j == 0) {
                    Format.print(System.out, "%3s", this.s1str.substring(i, i + 1));
                }
                Format.print(System.out, "%3d ", mat[i][j] / 10);
            }
            System.out.println();
        }
    }

    public int findTrace(int i, int j) {
        int t = 0;
        int max = this.score[i - 1][j - 1] + this.lookup[this.seq1[i]][this.seq2[j]] * 10;
        if (this.F[i][j] > max) {
            max = this.F[i][j];
            t = -1;
        } else if (this.F[i][j] == max && this.prev == -1) {
            max = this.F[i][j];
            t = -1;
        }
        if (this.E[i][j] >= max) {
            max = this.E[i][j];
            t = 1;
        } else if (this.E[i][j] == max && this.prev == 1) {
            max = this.E[i][j];
            t = 1;
        }
        this.prev = t;
        return t;
    }

    public void calcScoreMatrix() {
        int i;
        int n = this.seq1.length;
        int m = this.seq2.length;
        this.score[0][0] = this.lookup[this.seq1[0]][this.seq2[0]] * 10;
        this.E[0][0] = -this.gapExtend;
        this.F[0][0] = 0;
        for (int j = 1; j < m; ++j) {
            this.E[0][j] = this.max(this.score[0][j - 1] - this.gapOpen, this.E[0][j - 1] - this.gapExtend);
            this.F[0][j] = -this.gapExtend;
            this.score[0][j] = this.max(this.lookup[this.seq1[0]][this.seq2[j]] * 10, -this.gapOpen, -this.gapExtend);
            this.traceback[0][j] = 1;
        }
        for (i = 1; i < n; ++i) {
            this.E[i][0] = -this.gapOpen;
            this.F[i][0] = this.max(this.score[i - 1][0] - this.gapOpen, this.F[i - 1][0] - this.gapExtend);
            this.score[i][0] = this.max(this.lookup[this.seq1[i]][this.seq2[0]] * 10, this.E[i][0], this.F[i][0]);
            this.traceback[i][0] = -1;
        }
        for (i = 1; i < n; ++i) {
            for (int j = 1; j < m; ++j) {
                this.E[i][j] = this.max(this.score[i][j - 1] - this.gapOpen, this.E[i][j - 1] - this.gapExtend);
                this.F[i][j] = this.max(this.score[i - 1][j] - this.gapOpen, this.F[i - 1][j] - this.gapExtend);
                this.score[i][j] = this.max(this.score[i - 1][j - 1] + this.lookup[this.seq1[i]][this.seq2[j]] * 10, this.E[i][j], this.F[i][j]);
                this.traceback[i][j] = this.findTrace(i, j);
            }
        }
    }

    public static String extractGaps(String gapChar, String seq) {
        StringTokenizer str = new StringTokenizer(seq, gapChar);
        StringBuffer newString = new StringBuffer();
        while (str.hasMoreTokens()) {
            newString.append(str.nextToken());
        }
        return newString.toString();
    }

    public int max(int i1, int i2, int i3) {
        int max = i1;
        if (i2 > i1) {
            max = i2;
        }
        if (i3 > max) {
            max = i3;
        }
        return max;
    }

    public int max(int i1, int i2) {
        int max = i1;
        if (i2 > i1) {
            max = i2;
        }
        return max;
    }

    public int[] stringToInt(String s, String type) {
        int[] seq1 = new int[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('a' <= c && c <= 'z') {
                c = (char)(c - 32);
            }
            try {
                seq1[i] = this.charToInt[c];
                if (seq1[i] >= 0 && seq1[i] <= this.defInt) continue;
                seq1[i] = this.defInt;
                continue;
            }
            catch (Exception e) {
                seq1[i] = this.defInt;
            }
        }
        return seq1;
    }

    public static void displayMatrix(Graphics g, int[][] mat, int n, int m, int psize) {
        int j;
        int i;
        int max = -1000;
        int min = 1000;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                if (mat[i][j] >= max) {
                    max = mat[i][j];
                }
                if (mat[i][j] > min) continue;
                min = mat[i][j];
            }
        }
        System.out.println(max + " " + min);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                int x = psize * i;
                int y = psize * j;
                float score = (float)(mat[i][j] - min) / (float)(max - min);
                g.setColor(new Color(score, 0.0f, 0.0f));
                g.fillRect(x, y, psize, psize);
            }
        }
    }
}

