// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelsv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchCreateCustomVocabularyItem = "BatchCreateCustomVocabularyItem"

// BatchCreateCustomVocabularyItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateCustomVocabularyItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateCustomVocabularyItem for more information on using the BatchCreateCustomVocabularyItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchCreateCustomVocabularyItemRequest method.
//	req, resp := client.BatchCreateCustomVocabularyItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem
func (c *LexModelsV2) BatchCreateCustomVocabularyItemRequest(input *BatchCreateCustomVocabularyItemInput) (req *request.Request, output *BatchCreateCustomVocabularyItemOutput) {
	op := &request.Operation{
		Name:       opBatchCreateCustomVocabularyItem,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchcreate",
	}

	if input == nil {
		input = &BatchCreateCustomVocabularyItemInput{}
	}

	output = &BatchCreateCustomVocabularyItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateCustomVocabularyItem API operation for Amazon Lex Model Building V2.
//
// Create a batch of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BatchCreateCustomVocabularyItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchCreateCustomVocabularyItem
func (c *LexModelsV2) BatchCreateCustomVocabularyItem(input *BatchCreateCustomVocabularyItemInput) (*BatchCreateCustomVocabularyItemOutput, error) {
	req, out := c.BatchCreateCustomVocabularyItemRequest(input)
	return out, req.Send()
}

// BatchCreateCustomVocabularyItemWithContext is the same as BatchCreateCustomVocabularyItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateCustomVocabularyItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BatchCreateCustomVocabularyItemWithContext(ctx aws.Context, input *BatchCreateCustomVocabularyItemInput, opts ...request.Option) (*BatchCreateCustomVocabularyItemOutput, error) {
	req, out := c.BatchCreateCustomVocabularyItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteCustomVocabularyItem = "BatchDeleteCustomVocabularyItem"

// BatchDeleteCustomVocabularyItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteCustomVocabularyItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteCustomVocabularyItem for more information on using the BatchDeleteCustomVocabularyItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteCustomVocabularyItemRequest method.
//	req, resp := client.BatchDeleteCustomVocabularyItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem
func (c *LexModelsV2) BatchDeleteCustomVocabularyItemRequest(input *BatchDeleteCustomVocabularyItemInput) (req *request.Request, output *BatchDeleteCustomVocabularyItemOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteCustomVocabularyItem,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchdelete",
	}

	if input == nil {
		input = &BatchDeleteCustomVocabularyItemInput{}
	}

	output = &BatchDeleteCustomVocabularyItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteCustomVocabularyItem API operation for Amazon Lex Model Building V2.
//
// Delete a batch of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BatchDeleteCustomVocabularyItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchDeleteCustomVocabularyItem
func (c *LexModelsV2) BatchDeleteCustomVocabularyItem(input *BatchDeleteCustomVocabularyItemInput) (*BatchDeleteCustomVocabularyItemOutput, error) {
	req, out := c.BatchDeleteCustomVocabularyItemRequest(input)
	return out, req.Send()
}

// BatchDeleteCustomVocabularyItemWithContext is the same as BatchDeleteCustomVocabularyItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteCustomVocabularyItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BatchDeleteCustomVocabularyItemWithContext(ctx aws.Context, input *BatchDeleteCustomVocabularyItemInput, opts ...request.Option) (*BatchDeleteCustomVocabularyItemOutput, error) {
	req, out := c.BatchDeleteCustomVocabularyItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateCustomVocabularyItem = "BatchUpdateCustomVocabularyItem"

// BatchUpdateCustomVocabularyItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateCustomVocabularyItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateCustomVocabularyItem for more information on using the BatchUpdateCustomVocabularyItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateCustomVocabularyItemRequest method.
//	req, resp := client.BatchUpdateCustomVocabularyItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem
func (c *LexModelsV2) BatchUpdateCustomVocabularyItemRequest(input *BatchUpdateCustomVocabularyItemInput) (req *request.Request, output *BatchUpdateCustomVocabularyItemOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateCustomVocabularyItem,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchupdate",
	}

	if input == nil {
		input = &BatchUpdateCustomVocabularyItemInput{}
	}

	output = &BatchUpdateCustomVocabularyItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateCustomVocabularyItem API operation for Amazon Lex Model Building V2.
//
// Update a batch of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BatchUpdateCustomVocabularyItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BatchUpdateCustomVocabularyItem
func (c *LexModelsV2) BatchUpdateCustomVocabularyItem(input *BatchUpdateCustomVocabularyItemInput) (*BatchUpdateCustomVocabularyItemOutput, error) {
	req, out := c.BatchUpdateCustomVocabularyItemRequest(input)
	return out, req.Send()
}

// BatchUpdateCustomVocabularyItemWithContext is the same as BatchUpdateCustomVocabularyItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateCustomVocabularyItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BatchUpdateCustomVocabularyItemWithContext(ctx aws.Context, input *BatchUpdateCustomVocabularyItemInput, opts ...request.Option) (*BatchUpdateCustomVocabularyItemOutput, error) {
	req, out := c.BatchUpdateCustomVocabularyItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBuildBotLocale = "BuildBotLocale"

// BuildBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the BuildBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BuildBotLocale for more information on using the BuildBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BuildBotLocaleRequest method.
//	req, resp := client.BuildBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale
func (c *LexModelsV2) BuildBotLocaleRequest(input *BuildBotLocaleInput) (req *request.Request, output *BuildBotLocaleOutput) {
	op := &request.Operation{
		Name:       opBuildBotLocale,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &BuildBotLocaleInput{}
	}

	output = &BuildBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BuildBotLocale API operation for Amazon Lex Model Building V2.
//
// Builds a bot, its intents, and its slot types into a specific locale. A bot
// can be built into multiple locales. At runtime the locale is used to choose
// a specific build of the bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation BuildBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale
func (c *LexModelsV2) BuildBotLocale(input *BuildBotLocaleInput) (*BuildBotLocaleOutput, error) {
	req, out := c.BuildBotLocaleRequest(input)
	return out, req.Send()
}

// BuildBotLocaleWithContext is the same as BuildBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See BuildBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) BuildBotLocaleWithContext(ctx aws.Context, input *BuildBotLocaleInput, opts ...request.Option) (*BuildBotLocaleOutput, error) {
	req, out := c.BuildBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBot = "CreateBot"

// CreateBotRequest generates a "aws/request.Request" representing the
// client's request for the CreateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBot for more information on using the CreateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotRequest method.
//	req, resp := client.CreateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot
func (c *LexModelsV2) CreateBotRequest(input *CreateBotInput) (req *request.Request, output *CreateBotOutput) {
	op := &request.Operation{
		Name:       opCreateBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/",
	}

	if input == nil {
		input = &CreateBotInput{}
	}

	output = &CreateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBot API operation for Amazon Lex Model Building V2.
//
// Creates an Amazon Lex conversational bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot
func (c *LexModelsV2) CreateBot(input *CreateBotInput) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	return out, req.Send()
}

// CreateBotWithContext is the same as CreateBot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotWithContext(ctx aws.Context, input *CreateBotInput, opts ...request.Option) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotAlias = "CreateBotAlias"

// CreateBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotAlias for more information on using the CreateBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotAliasRequest method.
//	req, resp := client.CreateBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias
func (c *LexModelsV2) CreateBotAliasRequest(input *CreateBotAliasInput) (req *request.Request, output *CreateBotAliasOutput) {
	op := &request.Operation{
		Name:       opCreateBotAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botaliases/",
	}

	if input == nil {
		input = &CreateBotAliasInput{}
	}

	output = &CreateBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotAlias API operation for Amazon Lex Model Building V2.
//
// Creates an alias for the specified version of a bot. Use an alias to enable
// you to change the version of a bot without updating applications that use
// the bot.
//
// For example, you can create an alias called "PROD" that your applications
// use to call the Amazon Lex bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias
func (c *LexModelsV2) CreateBotAlias(input *CreateBotAliasInput) (*CreateBotAliasOutput, error) {
	req, out := c.CreateBotAliasRequest(input)
	return out, req.Send()
}

// CreateBotAliasWithContext is the same as CreateBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotAliasWithContext(ctx aws.Context, input *CreateBotAliasInput, opts ...request.Option) (*CreateBotAliasOutput, error) {
	req, out := c.CreateBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotLocale = "CreateBotLocale"

// CreateBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotLocale for more information on using the CreateBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotLocaleRequest method.
//	req, resp := client.CreateBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale
func (c *LexModelsV2) CreateBotLocaleRequest(input *CreateBotLocaleInput) (req *request.Request, output *CreateBotLocaleOutput) {
	op := &request.Operation{
		Name:       opCreateBotLocale,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/",
	}

	if input == nil {
		input = &CreateBotLocaleInput{}
	}

	output = &CreateBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotLocale API operation for Amazon Lex Model Building V2.
//
// Creates a locale in the bot. The locale contains the intents and slot types
// that the bot uses in conversations with users in the specified language and
// locale. You must add a locale to a bot before you can add intents and slot
// types to the bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale
func (c *LexModelsV2) CreateBotLocale(input *CreateBotLocaleInput) (*CreateBotLocaleOutput, error) {
	req, out := c.CreateBotLocaleRequest(input)
	return out, req.Send()
}

// CreateBotLocaleWithContext is the same as CreateBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotLocaleWithContext(ctx aws.Context, input *CreateBotLocaleInput, opts ...request.Option) (*CreateBotLocaleOutput, error) {
	req, out := c.CreateBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBotVersion = "CreateBotVersion"

// CreateBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBotVersion for more information on using the CreateBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBotVersionRequest method.
//	req, resp := client.CreateBotVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion
func (c *LexModelsV2) CreateBotVersionRequest(input *CreateBotVersionInput) (req *request.Request, output *CreateBotVersionOutput) {
	op := &request.Operation{
		Name:       opCreateBotVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/",
	}

	if input == nil {
		input = &CreateBotVersionInput{}
	}

	output = &CreateBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBotVersion API operation for Amazon Lex Model Building V2.
//
// Creates a new version of the bot based on the DRAFT version. If the DRAFT
// version of this resource hasn't changed since you created the last version,
// Amazon Lex doesn't create a new version, it returns the last created version.
//
// When you create the first version of a bot, Amazon Lex sets the version to
// 1. Subsequent versions increment by 1.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateBotVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion
func (c *LexModelsV2) CreateBotVersion(input *CreateBotVersionInput) (*CreateBotVersionOutput, error) {
	req, out := c.CreateBotVersionRequest(input)
	return out, req.Send()
}

// CreateBotVersionWithContext is the same as CreateBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateBotVersionWithContext(ctx aws.Context, input *CreateBotVersionInput, opts ...request.Option) (*CreateBotVersionOutput, error) {
	req, out := c.CreateBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExport = "CreateExport"

// CreateExportRequest generates a "aws/request.Request" representing the
// client's request for the CreateExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExport for more information on using the CreateExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateExportRequest method.
//	req, resp := client.CreateExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport
func (c *LexModelsV2) CreateExportRequest(input *CreateExportInput) (req *request.Request, output *CreateExportOutput) {
	op := &request.Operation{
		Name:       opCreateExport,
		HTTPMethod: "PUT",
		HTTPPath:   "/exports/",
	}

	if input == nil {
		input = &CreateExportInput{}
	}

	output = &CreateExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExport API operation for Amazon Lex Model Building V2.
//
// Creates a zip archive containing the contents of a bot or a bot locale. The
// archive contains a directory structure that contains JSON files that define
// the bot.
//
// You can create an archive that contains the complete definition of a bot,
// or you can specify that the archive contain only the definition of a single
// bot locale.
//
// For more information about exporting bots, and about the structure of the
// export archive, see Importing and exporting bots (https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport
func (c *LexModelsV2) CreateExport(input *CreateExportInput) (*CreateExportOutput, error) {
	req, out := c.CreateExportRequest(input)
	return out, req.Send()
}

// CreateExportWithContext is the same as CreateExport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateExportWithContext(ctx aws.Context, input *CreateExportInput, opts ...request.Option) (*CreateExportOutput, error) {
	req, out := c.CreateExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntent = "CreateIntent"

// CreateIntentRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntent for more information on using the CreateIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIntentRequest method.
//	req, resp := client.CreateIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent
func (c *LexModelsV2) CreateIntentRequest(input *CreateIntentInput) (req *request.Request, output *CreateIntentOutput) {
	op := &request.Operation{
		Name:       opCreateIntent,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
	}

	if input == nil {
		input = &CreateIntentInput{}
	}

	output = &CreateIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntent API operation for Amazon Lex Model Building V2.
//
// Creates an intent.
//
// To define the interaction between the user and your bot, you define one or
// more intents. For example, for a pizza ordering bot you would create an OrderPizza
// intent.
//
// When you create an intent, you must provide a name. You can optionally provide
// the following:
//
//   - Sample utterances. For example, "I want to order a pizza" and "Can I
//     order a pizza." You can't provide utterances for built-in intents.
//
//   - Information to be gathered. You specify slots for the information that
//     you bot requests from the user. You can specify standard slot types, such
//     as date and time, or custom slot types for your application.
//
//   - How the intent is fulfilled. You can provide a Lambda function or configure
//     the intent to return the intent information to your client application.
//     If you use a Lambda function, Amazon Lex invokes the function when all
//     of the intent information is available.
//
//   - A confirmation prompt to send to the user to confirm an intent. For
//     example, "Shall I order your pizza?"
//
//   - A conclusion statement to send to the user after the intent is fulfilled.
//     For example, "I ordered your pizza."
//
//   - A follow-up prompt that asks the user for additional activity. For example,
//     "Do you want a drink with your pizza?"
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent
func (c *LexModelsV2) CreateIntent(input *CreateIntentInput) (*CreateIntentOutput, error) {
	req, out := c.CreateIntentRequest(input)
	return out, req.Send()
}

// CreateIntentWithContext is the same as CreateIntent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateIntentWithContext(ctx aws.Context, input *CreateIntentInput, opts ...request.Option) (*CreateIntentOutput, error) {
	req, out := c.CreateIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourcePolicy = "CreateResourcePolicy"

// CreateResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourcePolicy for more information on using the CreateResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResourcePolicyRequest method.
//	req, resp := client.CreateResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy
func (c *LexModelsV2) CreateResourcePolicyRequest(input *CreateResourcePolicyInput) (req *request.Request, output *CreateResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opCreateResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &CreateResourcePolicyInput{}
	}

	output = &CreateResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Creates a new resource policy with the specified policy statements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy
func (c *LexModelsV2) CreateResourcePolicy(input *CreateResourcePolicyInput) (*CreateResourcePolicyOutput, error) {
	req, out := c.CreateResourcePolicyRequest(input)
	return out, req.Send()
}

// CreateResourcePolicyWithContext is the same as CreateResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateResourcePolicyWithContext(ctx aws.Context, input *CreateResourcePolicyInput, opts ...request.Option) (*CreateResourcePolicyOutput, error) {
	req, out := c.CreateResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourcePolicyStatement = "CreateResourcePolicyStatement"

// CreateResourcePolicyStatementRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourcePolicyStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourcePolicyStatement for more information on using the CreateResourcePolicyStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResourcePolicyStatementRequest method.
//	req, resp := client.CreateResourcePolicyStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement
func (c *LexModelsV2) CreateResourcePolicyStatementRequest(input *CreateResourcePolicyStatementInput) (req *request.Request, output *CreateResourcePolicyStatementOutput) {
	op := &request.Operation{
		Name:       opCreateResourcePolicyStatement,
		HTTPMethod: "POST",
		HTTPPath:   "/policy/{resourceArn}/statements/",
	}

	if input == nil {
		input = &CreateResourcePolicyStatementInput{}
	}

	output = &CreateResourcePolicyStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResourcePolicyStatement API operation for Amazon Lex Model Building V2.
//
// Adds a new resource policy statement to a bot or bot alias. If a resource
// policy exists, the statement is added to the current resource policy. If
// a policy doesn't exist, a new policy is created.
//
// You can't create a resource policy statement that allows cross-account access.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateResourcePolicyStatement for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement
func (c *LexModelsV2) CreateResourcePolicyStatement(input *CreateResourcePolicyStatementInput) (*CreateResourcePolicyStatementOutput, error) {
	req, out := c.CreateResourcePolicyStatementRequest(input)
	return out, req.Send()
}

// CreateResourcePolicyStatementWithContext is the same as CreateResourcePolicyStatement with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourcePolicyStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateResourcePolicyStatementWithContext(ctx aws.Context, input *CreateResourcePolicyStatementInput, opts ...request.Option) (*CreateResourcePolicyStatementOutput, error) {
	req, out := c.CreateResourcePolicyStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSlot = "CreateSlot"

// CreateSlotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlot for more information on using the CreateSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSlotRequest method.
//	req, resp := client.CreateSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot
func (c *LexModelsV2) CreateSlotRequest(input *CreateSlotInput) (req *request.Request, output *CreateSlotOutput) {
	op := &request.Operation{
		Name:       opCreateSlot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
	}

	if input == nil {
		input = &CreateSlotInput{}
	}

	output = &CreateSlotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSlot API operation for Amazon Lex Model Building V2.
//
// Creates a slot in an intent. A slot is a variable needed to fulfill an intent.
// For example, an OrderPizza intent might need slots for size, crust, and number
// of pizzas. For each slot, you define one or more utterances that Amazon Lex
// uses to elicit a response from the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot
func (c *LexModelsV2) CreateSlot(input *CreateSlotInput) (*CreateSlotOutput, error) {
	req, out := c.CreateSlotRequest(input)
	return out, req.Send()
}

// CreateSlotWithContext is the same as CreateSlot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateSlotWithContext(ctx aws.Context, input *CreateSlotInput, opts ...request.Option) (*CreateSlotOutput, error) {
	req, out := c.CreateSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSlotType = "CreateSlotType"

// CreateSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSlotType for more information on using the CreateSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSlotTypeRequest method.
//	req, resp := client.CreateSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType
func (c *LexModelsV2) CreateSlotTypeRequest(input *CreateSlotTypeInput) (req *request.Request, output *CreateSlotTypeOutput) {
	op := &request.Operation{
		Name:       opCreateSlotType,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
	}

	if input == nil {
		input = &CreateSlotTypeInput{}
	}

	output = &CreateSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSlotType API operation for Amazon Lex Model Building V2.
//
// # Creates a custom slot type
//
// To create a custom slot type, specify a name for the slot type and a set
// of enumeration values, the values that a slot of this type can assume.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType
func (c *LexModelsV2) CreateSlotType(input *CreateSlotTypeInput) (*CreateSlotTypeOutput, error) {
	req, out := c.CreateSlotTypeRequest(input)
	return out, req.Send()
}

// CreateSlotTypeWithContext is the same as CreateSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateSlotTypeWithContext(ctx aws.Context, input *CreateSlotTypeInput, opts ...request.Option) (*CreateSlotTypeOutput, error) {
	req, out := c.CreateSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTestSetDiscrepancyReport = "CreateTestSetDiscrepancyReport"

// CreateTestSetDiscrepancyReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateTestSetDiscrepancyReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTestSetDiscrepancyReport for more information on using the CreateTestSetDiscrepancyReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTestSetDiscrepancyReportRequest method.
//	req, resp := client.CreateTestSetDiscrepancyReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport
func (c *LexModelsV2) CreateTestSetDiscrepancyReportRequest(input *CreateTestSetDiscrepancyReportInput) (req *request.Request, output *CreateTestSetDiscrepancyReportOutput) {
	op := &request.Operation{
		Name:       opCreateTestSetDiscrepancyReport,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets/{testSetId}/testsetdiscrepancy",
	}

	if input == nil {
		input = &CreateTestSetDiscrepancyReportInput{}
	}

	output = &CreateTestSetDiscrepancyReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTestSetDiscrepancyReport API operation for Amazon Lex Model Building V2.
//
// Create a report that describes the differences between the bot and the test
// set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateTestSetDiscrepancyReport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateTestSetDiscrepancyReport
func (c *LexModelsV2) CreateTestSetDiscrepancyReport(input *CreateTestSetDiscrepancyReportInput) (*CreateTestSetDiscrepancyReportOutput, error) {
	req, out := c.CreateTestSetDiscrepancyReportRequest(input)
	return out, req.Send()
}

// CreateTestSetDiscrepancyReportWithContext is the same as CreateTestSetDiscrepancyReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTestSetDiscrepancyReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateTestSetDiscrepancyReportWithContext(ctx aws.Context, input *CreateTestSetDiscrepancyReportInput, opts ...request.Option) (*CreateTestSetDiscrepancyReportOutput, error) {
	req, out := c.CreateTestSetDiscrepancyReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUploadUrl = "CreateUploadUrl"

// CreateUploadUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreateUploadUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUploadUrl for more information on using the CreateUploadUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUploadUrlRequest method.
//	req, resp := client.CreateUploadUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl
func (c *LexModelsV2) CreateUploadUrlRequest(input *CreateUploadUrlInput) (req *request.Request, output *CreateUploadUrlOutput) {
	op := &request.Operation{
		Name:       opCreateUploadUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/createuploadurl/",
	}

	if input == nil {
		input = &CreateUploadUrlInput{}
	}

	output = &CreateUploadUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUploadUrl API operation for Amazon Lex Model Building V2.
//
// Gets a pre-signed S3 write URL that you use to upload the zip archive when
// importing a bot or a bot locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation CreateUploadUrl for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl
func (c *LexModelsV2) CreateUploadUrl(input *CreateUploadUrlInput) (*CreateUploadUrlOutput, error) {
	req, out := c.CreateUploadUrlRequest(input)
	return out, req.Send()
}

// CreateUploadUrlWithContext is the same as CreateUploadUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUploadUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) CreateUploadUrlWithContext(ctx aws.Context, input *CreateUploadUrlInput, opts ...request.Option) (*CreateUploadUrlOutput, error) {
	req, out := c.CreateUploadUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBot = "DeleteBot"

// DeleteBotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBot for more information on using the DeleteBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotRequest method.
//	req, resp := client.DeleteBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot
func (c *LexModelsV2) DeleteBotRequest(input *DeleteBotInput) (req *request.Request, output *DeleteBotOutput) {
	op := &request.Operation{
		Name:       opDeleteBot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/",
	}

	if input == nil {
		input = &DeleteBotInput{}
	}

	output = &DeleteBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBot API operation for Amazon Lex Model Building V2.
//
// Deletes all versions of a bot, including the Draft version. To delete a specific
// version, use the DeleteBotVersion operation.
//
// When you delete a bot, all of the resources contained in the bot are also
// deleted. Deleting a bot removes all locales, intents, slot, and slot types
// defined for the bot.
//
// If a bot has an alias, the DeleteBot operation returns a ResourceInUseException
// exception. If you want to delete the bot and the alias, set the skipResourceInUseCheck
// parameter to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot
func (c *LexModelsV2) DeleteBot(input *DeleteBotInput) (*DeleteBotOutput, error) {
	req, out := c.DeleteBotRequest(input)
	return out, req.Send()
}

// DeleteBotWithContext is the same as DeleteBot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotWithContext(ctx aws.Context, input *DeleteBotInput, opts ...request.Option) (*DeleteBotOutput, error) {
	req, out := c.DeleteBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotAlias = "DeleteBotAlias"

// DeleteBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotAlias for more information on using the DeleteBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotAliasRequest method.
//	req, resp := client.DeleteBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias
func (c *LexModelsV2) DeleteBotAliasRequest(input *DeleteBotAliasInput) (req *request.Request, output *DeleteBotAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteBotAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botaliases/{botAliasId}/",
	}

	if input == nil {
		input = &DeleteBotAliasInput{}
	}

	output = &DeleteBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotAlias API operation for Amazon Lex Model Building V2.
//
// Deletes the specified bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias
func (c *LexModelsV2) DeleteBotAlias(input *DeleteBotAliasInput) (*DeleteBotAliasOutput, error) {
	req, out := c.DeleteBotAliasRequest(input)
	return out, req.Send()
}

// DeleteBotAliasWithContext is the same as DeleteBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotAliasWithContext(ctx aws.Context, input *DeleteBotAliasInput, opts ...request.Option) (*DeleteBotAliasOutput, error) {
	req, out := c.DeleteBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotLocale = "DeleteBotLocale"

// DeleteBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotLocale for more information on using the DeleteBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotLocaleRequest method.
//	req, resp := client.DeleteBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale
func (c *LexModelsV2) DeleteBotLocaleRequest(input *DeleteBotLocaleInput) (req *request.Request, output *DeleteBotLocaleOutput) {
	op := &request.Operation{
		Name:       opDeleteBotLocale,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &DeleteBotLocaleInput{}
	}

	output = &DeleteBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotLocale API operation for Amazon Lex Model Building V2.
//
// Removes a locale from a bot.
//
// When you delete a locale, all intents, slots, and slot types defined for
// the locale are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale
func (c *LexModelsV2) DeleteBotLocale(input *DeleteBotLocaleInput) (*DeleteBotLocaleOutput, error) {
	req, out := c.DeleteBotLocaleRequest(input)
	return out, req.Send()
}

// DeleteBotLocaleWithContext is the same as DeleteBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotLocaleWithContext(ctx aws.Context, input *DeleteBotLocaleInput, opts ...request.Option) (*DeleteBotLocaleOutput, error) {
	req, out := c.DeleteBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBotVersion = "DeleteBotVersion"

// DeleteBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBotVersion for more information on using the DeleteBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBotVersionRequest method.
//	req, resp := client.DeleteBotVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion
func (c *LexModelsV2) DeleteBotVersionRequest(input *DeleteBotVersionInput) (req *request.Request, output *DeleteBotVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteBotVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/",
	}

	if input == nil {
		input = &DeleteBotVersionInput{}
	}

	output = &DeleteBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBotVersion API operation for Amazon Lex Model Building V2.
//
// Deletes a specific version of a bot. To delete all versions of a bot, use
// the DeleteBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DeleteBot.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteBotVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion
func (c *LexModelsV2) DeleteBotVersion(input *DeleteBotVersionInput) (*DeleteBotVersionOutput, error) {
	req, out := c.DeleteBotVersionRequest(input)
	return out, req.Send()
}

// DeleteBotVersionWithContext is the same as DeleteBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteBotVersionWithContext(ctx aws.Context, input *DeleteBotVersionInput, opts ...request.Option) (*DeleteBotVersionOutput, error) {
	req, out := c.DeleteBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomVocabulary = "DeleteCustomVocabulary"

// DeleteCustomVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomVocabulary for more information on using the DeleteCustomVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomVocabularyRequest method.
//	req, resp := client.DeleteCustomVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary
func (c *LexModelsV2) DeleteCustomVocabularyRequest(input *DeleteCustomVocabularyInput) (req *request.Request, output *DeleteCustomVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomVocabulary,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary",
	}

	if input == nil {
		input = &DeleteCustomVocabularyInput{}
	}

	output = &DeleteCustomVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCustomVocabulary API operation for Amazon Lex Model Building V2.
//
// Removes a custom vocabulary from the specified locale in the specified bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteCustomVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteCustomVocabulary
func (c *LexModelsV2) DeleteCustomVocabulary(input *DeleteCustomVocabularyInput) (*DeleteCustomVocabularyOutput, error) {
	req, out := c.DeleteCustomVocabularyRequest(input)
	return out, req.Send()
}

// DeleteCustomVocabularyWithContext is the same as DeleteCustomVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteCustomVocabularyWithContext(ctx aws.Context, input *DeleteCustomVocabularyInput, opts ...request.Option) (*DeleteCustomVocabularyOutput, error) {
	req, out := c.DeleteCustomVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExport = "DeleteExport"

// DeleteExportRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExport for more information on using the DeleteExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteExportRequest method.
//	req, resp := client.DeleteExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport
func (c *LexModelsV2) DeleteExportRequest(input *DeleteExportInput) (req *request.Request, output *DeleteExportOutput) {
	op := &request.Operation{
		Name:       opDeleteExport,
		HTTPMethod: "DELETE",
		HTTPPath:   "/exports/{exportId}/",
	}

	if input == nil {
		input = &DeleteExportInput{}
	}

	output = &DeleteExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExport API operation for Amazon Lex Model Building V2.
//
// Removes a previous export and the associated files stored in an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport
func (c *LexModelsV2) DeleteExport(input *DeleteExportInput) (*DeleteExportOutput, error) {
	req, out := c.DeleteExportRequest(input)
	return out, req.Send()
}

// DeleteExportWithContext is the same as DeleteExport with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteExportWithContext(ctx aws.Context, input *DeleteExportInput, opts ...request.Option) (*DeleteExportOutput, error) {
	req, out := c.DeleteExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImport = "DeleteImport"

// DeleteImportRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImport for more information on using the DeleteImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImportRequest method.
//	req, resp := client.DeleteImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport
func (c *LexModelsV2) DeleteImportRequest(input *DeleteImportInput) (req *request.Request, output *DeleteImportOutput) {
	op := &request.Operation{
		Name:       opDeleteImport,
		HTTPMethod: "DELETE",
		HTTPPath:   "/imports/{importId}/",
	}

	if input == nil {
		input = &DeleteImportInput{}
	}

	output = &DeleteImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImport API operation for Amazon Lex Model Building V2.
//
// Removes a previous import and the associated file stored in an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteImport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport
func (c *LexModelsV2) DeleteImport(input *DeleteImportInput) (*DeleteImportOutput, error) {
	req, out := c.DeleteImportRequest(input)
	return out, req.Send()
}

// DeleteImportWithContext is the same as DeleteImport with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteImportWithContext(ctx aws.Context, input *DeleteImportInput, opts ...request.Option) (*DeleteImportOutput, error) {
	req, out := c.DeleteImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntent = "DeleteIntent"

// DeleteIntentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntent for more information on using the DeleteIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIntentRequest method.
//	req, resp := client.DeleteIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent
func (c *LexModelsV2) DeleteIntentRequest(input *DeleteIntentInput) (req *request.Request, output *DeleteIntentOutput) {
	op := &request.Operation{
		Name:       opDeleteIntent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
	}

	if input == nil {
		input = &DeleteIntentInput{}
	}

	output = &DeleteIntentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntent API operation for Amazon Lex Model Building V2.
//
// Removes the specified intent.
//
// Deleting an intent also deletes the slots associated with the intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent
func (c *LexModelsV2) DeleteIntent(input *DeleteIntentInput) (*DeleteIntentOutput, error) {
	req, out := c.DeleteIntentRequest(input)
	return out, req.Send()
}

// DeleteIntentWithContext is the same as DeleteIntent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteIntentWithContext(ctx aws.Context, input *DeleteIntentInput, opts ...request.Option) (*DeleteIntentOutput, error) {
	req, out := c.DeleteIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy
func (c *LexModelsV2) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Removes an existing policy from a bot or bot alias. If the resource doesn't
// have a policy attached, Amazon Lex returns an exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy
func (c *LexModelsV2) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicyStatement = "DeleteResourcePolicyStatement"

// DeleteResourcePolicyStatementRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicyStatement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicyStatement for more information on using the DeleteResourcePolicyStatement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyStatementRequest method.
//	req, resp := client.DeleteResourcePolicyStatementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement
func (c *LexModelsV2) DeleteResourcePolicyStatementRequest(input *DeleteResourcePolicyStatementInput) (req *request.Request, output *DeleteResourcePolicyStatementOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicyStatement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policy/{resourceArn}/statements/{statementId}/",
	}

	if input == nil {
		input = &DeleteResourcePolicyStatementInput{}
	}

	output = &DeleteResourcePolicyStatementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResourcePolicyStatement API operation for Amazon Lex Model Building V2.
//
// Deletes a policy statement from a resource policy. If you delete the last
// statement from a policy, the policy is deleted. If you specify a statement
// ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
// a policy attached, Amazon Lex returns an exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteResourcePolicyStatement for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement
func (c *LexModelsV2) DeleteResourcePolicyStatement(input *DeleteResourcePolicyStatementInput) (*DeleteResourcePolicyStatementOutput, error) {
	req, out := c.DeleteResourcePolicyStatementRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyStatementWithContext is the same as DeleteResourcePolicyStatement with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicyStatement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteResourcePolicyStatementWithContext(ctx aws.Context, input *DeleteResourcePolicyStatementInput, opts ...request.Option) (*DeleteResourcePolicyStatementOutput, error) {
	req, out := c.DeleteResourcePolicyStatementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlot = "DeleteSlot"

// DeleteSlotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlot for more information on using the DeleteSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlotRequest method.
//	req, resp := client.DeleteSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot
func (c *LexModelsV2) DeleteSlotRequest(input *DeleteSlotInput) (req *request.Request, output *DeleteSlotOutput) {
	op := &request.Operation{
		Name:       opDeleteSlot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
	}

	if input == nil {
		input = &DeleteSlotInput{}
	}

	output = &DeleteSlotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlot API operation for Amazon Lex Model Building V2.
//
// Deletes the specified slot from an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot
func (c *LexModelsV2) DeleteSlot(input *DeleteSlotInput) (*DeleteSlotOutput, error) {
	req, out := c.DeleteSlotRequest(input)
	return out, req.Send()
}

// DeleteSlotWithContext is the same as DeleteSlot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteSlotWithContext(ctx aws.Context, input *DeleteSlotInput, opts ...request.Option) (*DeleteSlotOutput, error) {
	req, out := c.DeleteSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSlotType = "DeleteSlotType"

// DeleteSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSlotType for more information on using the DeleteSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSlotTypeRequest method.
//	req, resp := client.DeleteSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType
func (c *LexModelsV2) DeleteSlotTypeRequest(input *DeleteSlotTypeInput) (req *request.Request, output *DeleteSlotTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteSlotType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
	}

	if input == nil {
		input = &DeleteSlotTypeInput{}
	}

	output = &DeleteSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSlotType API operation for Amazon Lex Model Building V2.
//
// Deletes a slot type from a bot locale.
//
// If a slot is using the slot type, Amazon Lex throws a ResourceInUseException
// exception. To avoid the exception, set the skipResourceInUseCheck parameter
// to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType
func (c *LexModelsV2) DeleteSlotType(input *DeleteSlotTypeInput) (*DeleteSlotTypeOutput, error) {
	req, out := c.DeleteSlotTypeRequest(input)
	return out, req.Send()
}

// DeleteSlotTypeWithContext is the same as DeleteSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteSlotTypeWithContext(ctx aws.Context, input *DeleteSlotTypeInput, opts ...request.Option) (*DeleteSlotTypeOutput, error) {
	req, out := c.DeleteSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTestSet = "DeleteTestSet"

// DeleteTestSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTestSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTestSet for more information on using the DeleteTestSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTestSetRequest method.
//	req, resp := client.DeleteTestSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet
func (c *LexModelsV2) DeleteTestSetRequest(input *DeleteTestSetInput) (req *request.Request, output *DeleteTestSetOutput) {
	op := &request.Operation{
		Name:       opDeleteTestSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/testsets/{testSetId}",
	}

	if input == nil {
		input = &DeleteTestSetInput{}
	}

	output = &DeleteTestSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTestSet API operation for Amazon Lex Model Building V2.
//
// The action to delete the selected test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteTestSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteTestSet
func (c *LexModelsV2) DeleteTestSet(input *DeleteTestSetInput) (*DeleteTestSetOutput, error) {
	req, out := c.DeleteTestSetRequest(input)
	return out, req.Send()
}

// DeleteTestSetWithContext is the same as DeleteTestSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTestSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteTestSetWithContext(ctx aws.Context, input *DeleteTestSetInput, opts ...request.Option) (*DeleteTestSetOutput, error) {
	req, out := c.DeleteTestSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUtterances = "DeleteUtterances"

// DeleteUtterancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUtterances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUtterances for more information on using the DeleteUtterances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUtterancesRequest method.
//	req, resp := client.DeleteUtterancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances
func (c *LexModelsV2) DeleteUtterancesRequest(input *DeleteUtterancesInput) (req *request.Request, output *DeleteUtterancesOutput) {
	op := &request.Operation{
		Name:       opDeleteUtterances,
		HTTPMethod: "DELETE",
		HTTPPath:   "/bots/{botId}/utterances/",
	}

	if input == nil {
		input = &DeleteUtterancesInput{}
	}

	output = &DeleteUtterancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUtterances API operation for Amazon Lex Model Building V2.
//
// Deletes stored utterances.
//
// Amazon Lex stores the utterances that users send to your bot. Utterances
// are stored for 15 days for use with the ListAggregatedUtterances (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListAggregatedUtterances.html)
// operation, and then stored indefinitely for use in improving the ability
// of your bot to respond to user input..
//
// Use the DeleteUtterances operation to manually delete utterances for a specific
// session. When you use the DeleteUtterances operation, utterances stored for
// improving your bot's ability to respond to user input are deleted immediately.
// Utterances stored for use with the ListAggregatedUtterances operation are
// deleted after 15 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DeleteUtterances for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteUtterances
func (c *LexModelsV2) DeleteUtterances(input *DeleteUtterancesInput) (*DeleteUtterancesOutput, error) {
	req, out := c.DeleteUtterancesRequest(input)
	return out, req.Send()
}

// DeleteUtterancesWithContext is the same as DeleteUtterances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUtterances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DeleteUtterancesWithContext(ctx aws.Context, input *DeleteUtterancesInput, opts ...request.Option) (*DeleteUtterancesOutput, error) {
	req, out := c.DeleteUtterancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBot = "DescribeBot"

// DescribeBotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBot for more information on using the DescribeBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotRequest method.
//	req, resp := client.DescribeBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot
func (c *LexModelsV2) DescribeBotRequest(input *DescribeBotInput) (req *request.Request, output *DescribeBotOutput) {
	op := &request.Operation{
		Name:       opDescribeBot,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/",
	}

	if input == nil {
		input = &DescribeBotInput{}
	}

	output = &DescribeBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBot API operation for Amazon Lex Model Building V2.
//
// Provides metadata information about a bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot
func (c *LexModelsV2) DescribeBot(input *DescribeBotInput) (*DescribeBotOutput, error) {
	req, out := c.DescribeBotRequest(input)
	return out, req.Send()
}

// DescribeBotWithContext is the same as DescribeBot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotWithContext(ctx aws.Context, input *DescribeBotInput, opts ...request.Option) (*DescribeBotOutput, error) {
	req, out := c.DescribeBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotAlias = "DescribeBotAlias"

// DescribeBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotAlias for more information on using the DescribeBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotAliasRequest method.
//	req, resp := client.DescribeBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias
func (c *LexModelsV2) DescribeBotAliasRequest(input *DescribeBotAliasInput) (req *request.Request, output *DescribeBotAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeBotAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botaliases/{botAliasId}/",
	}

	if input == nil {
		input = &DescribeBotAliasInput{}
	}

	output = &DescribeBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotAlias API operation for Amazon Lex Model Building V2.
//
// Get information about a specific bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias
func (c *LexModelsV2) DescribeBotAlias(input *DescribeBotAliasInput) (*DescribeBotAliasOutput, error) {
	req, out := c.DescribeBotAliasRequest(input)
	return out, req.Send()
}

// DescribeBotAliasWithContext is the same as DescribeBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotAliasWithContext(ctx aws.Context, input *DescribeBotAliasInput, opts ...request.Option) (*DescribeBotAliasOutput, error) {
	req, out := c.DescribeBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotLocale = "DescribeBotLocale"

// DescribeBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotLocale for more information on using the DescribeBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotLocaleRequest method.
//	req, resp := client.DescribeBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale
func (c *LexModelsV2) DescribeBotLocaleRequest(input *DescribeBotLocaleInput) (req *request.Request, output *DescribeBotLocaleOutput) {
	op := &request.Operation{
		Name:       opDescribeBotLocale,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &DescribeBotLocaleInput{}
	}

	output = &DescribeBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotLocale API operation for Amazon Lex Model Building V2.
//
// Describes the settings that a bot has for a specific locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale
func (c *LexModelsV2) DescribeBotLocale(input *DescribeBotLocaleInput) (*DescribeBotLocaleOutput, error) {
	req, out := c.DescribeBotLocaleRequest(input)
	return out, req.Send()
}

// DescribeBotLocaleWithContext is the same as DescribeBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotLocaleWithContext(ctx aws.Context, input *DescribeBotLocaleInput, opts ...request.Option) (*DescribeBotLocaleOutput, error) {
	req, out := c.DescribeBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotRecommendation = "DescribeBotRecommendation"

// DescribeBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotRecommendation for more information on using the DescribeBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotRecommendationRequest method.
//	req, resp := client.DescribeBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation
func (c *LexModelsV2) DescribeBotRecommendationRequest(input *DescribeBotRecommendationInput) (req *request.Request, output *DescribeBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opDescribeBotRecommendation,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
	}

	if input == nil {
		input = &DescribeBotRecommendationInput{}
	}

	output = &DescribeBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Provides metadata information about a bot recommendation. This information
// will enable you to get a description on the request inputs, to download associated
// transcripts after processing is complete, and to download intents and slot-types
// generated by the bot recommendation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotRecommendation
func (c *LexModelsV2) DescribeBotRecommendation(input *DescribeBotRecommendationInput) (*DescribeBotRecommendationOutput, error) {
	req, out := c.DescribeBotRecommendationRequest(input)
	return out, req.Send()
}

// DescribeBotRecommendationWithContext is the same as DescribeBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotRecommendationWithContext(ctx aws.Context, input *DescribeBotRecommendationInput, opts ...request.Option) (*DescribeBotRecommendationOutput, error) {
	req, out := c.DescribeBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBotVersion = "DescribeBotVersion"

// DescribeBotVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBotVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBotVersion for more information on using the DescribeBotVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBotVersionRequest method.
//	req, resp := client.DescribeBotVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion
func (c *LexModelsV2) DescribeBotVersionRequest(input *DescribeBotVersionInput) (req *request.Request, output *DescribeBotVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeBotVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/",
	}

	if input == nil {
		input = &DescribeBotVersionInput{}
	}

	output = &DescribeBotVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBotVersion API operation for Amazon Lex Model Building V2.
//
// Provides metadata about a version of a bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeBotVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion
func (c *LexModelsV2) DescribeBotVersion(input *DescribeBotVersionInput) (*DescribeBotVersionOutput, error) {
	req, out := c.DescribeBotVersionRequest(input)
	return out, req.Send()
}

// DescribeBotVersionWithContext is the same as DescribeBotVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBotVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeBotVersionWithContext(ctx aws.Context, input *DescribeBotVersionInput, opts ...request.Option) (*DescribeBotVersionOutput, error) {
	req, out := c.DescribeBotVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomVocabularyMetadata = "DescribeCustomVocabularyMetadata"

// DescribeCustomVocabularyMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomVocabularyMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomVocabularyMetadata for more information on using the DescribeCustomVocabularyMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomVocabularyMetadataRequest method.
//	req, resp := client.DescribeCustomVocabularyMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata
func (c *LexModelsV2) DescribeCustomVocabularyMetadataRequest(input *DescribeCustomVocabularyMetadataInput) (req *request.Request, output *DescribeCustomVocabularyMetadataOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomVocabularyMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/metadata",
	}

	if input == nil {
		input = &DescribeCustomVocabularyMetadataInput{}
	}

	output = &DescribeCustomVocabularyMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomVocabularyMetadata API operation for Amazon Lex Model Building V2.
//
// Provides metadata information about a custom vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeCustomVocabularyMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeCustomVocabularyMetadata
func (c *LexModelsV2) DescribeCustomVocabularyMetadata(input *DescribeCustomVocabularyMetadataInput) (*DescribeCustomVocabularyMetadataOutput, error) {
	req, out := c.DescribeCustomVocabularyMetadataRequest(input)
	return out, req.Send()
}

// DescribeCustomVocabularyMetadataWithContext is the same as DescribeCustomVocabularyMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomVocabularyMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeCustomVocabularyMetadataWithContext(ctx aws.Context, input *DescribeCustomVocabularyMetadataInput, opts ...request.Option) (*DescribeCustomVocabularyMetadataOutput, error) {
	req, out := c.DescribeCustomVocabularyMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExport = "DescribeExport"

// DescribeExportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExport for more information on using the DescribeExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeExportRequest method.
//	req, resp := client.DescribeExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport
func (c *LexModelsV2) DescribeExportRequest(input *DescribeExportInput) (req *request.Request, output *DescribeExportOutput) {
	op := &request.Operation{
		Name:       opDescribeExport,
		HTTPMethod: "GET",
		HTTPPath:   "/exports/{exportId}/",
	}

	if input == nil {
		input = &DescribeExportInput{}
	}

	output = &DescribeExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExport API operation for Amazon Lex Model Building V2.
//
// Gets information about a specific export.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport
func (c *LexModelsV2) DescribeExport(input *DescribeExportInput) (*DescribeExportOutput, error) {
	req, out := c.DescribeExportRequest(input)
	return out, req.Send()
}

// DescribeExportWithContext is the same as DescribeExport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeExportWithContext(ctx aws.Context, input *DescribeExportInput, opts ...request.Option) (*DescribeExportOutput, error) {
	req, out := c.DescribeExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImport = "DescribeImport"

// DescribeImportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImport for more information on using the DescribeImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImportRequest method.
//	req, resp := client.DescribeImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport
func (c *LexModelsV2) DescribeImportRequest(input *DescribeImportInput) (req *request.Request, output *DescribeImportOutput) {
	op := &request.Operation{
		Name:       opDescribeImport,
		HTTPMethod: "GET",
		HTTPPath:   "/imports/{importId}/",
	}

	if input == nil {
		input = &DescribeImportInput{}
	}

	output = &DescribeImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImport API operation for Amazon Lex Model Building V2.
//
// Gets information about a specific import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeImport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport
func (c *LexModelsV2) DescribeImport(input *DescribeImportInput) (*DescribeImportOutput, error) {
	req, out := c.DescribeImportRequest(input)
	return out, req.Send()
}

// DescribeImportWithContext is the same as DescribeImport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeImportWithContext(ctx aws.Context, input *DescribeImportInput, opts ...request.Option) (*DescribeImportOutput, error) {
	req, out := c.DescribeImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIntent = "DescribeIntent"

// DescribeIntentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIntent for more information on using the DescribeIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIntentRequest method.
//	req, resp := client.DescribeIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent
func (c *LexModelsV2) DescribeIntentRequest(input *DescribeIntentInput) (req *request.Request, output *DescribeIntentOutput) {
	op := &request.Operation{
		Name:       opDescribeIntent,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
	}

	if input == nil {
		input = &DescribeIntentInput{}
	}

	output = &DescribeIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIntent API operation for Amazon Lex Model Building V2.
//
// Returns metadata about an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent
func (c *LexModelsV2) DescribeIntent(input *DescribeIntentInput) (*DescribeIntentOutput, error) {
	req, out := c.DescribeIntentRequest(input)
	return out, req.Send()
}

// DescribeIntentWithContext is the same as DescribeIntent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeIntentWithContext(ctx aws.Context, input *DescribeIntentInput, opts ...request.Option) (*DescribeIntentOutput, error) {
	req, out := c.DescribeIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourcePolicy = "DescribeResourcePolicy"

// DescribeResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourcePolicy for more information on using the DescribeResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeResourcePolicyRequest method.
//	req, resp := client.DescribeResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy
func (c *LexModelsV2) DescribeResourcePolicyRequest(input *DescribeResourcePolicyInput) (req *request.Request, output *DescribeResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeResourcePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &DescribeResourcePolicyInput{}
	}

	output = &DescribeResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Gets the resource policy and policy revision for a bot or bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy
func (c *LexModelsV2) DescribeResourcePolicy(input *DescribeResourcePolicyInput) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	return out, req.Send()
}

// DescribeResourcePolicyWithContext is the same as DescribeResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeResourcePolicyWithContext(ctx aws.Context, input *DescribeResourcePolicyInput, opts ...request.Option) (*DescribeResourcePolicyOutput, error) {
	req, out := c.DescribeResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSlot = "DescribeSlot"

// DescribeSlotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlot for more information on using the DescribeSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlotRequest method.
//	req, resp := client.DescribeSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot
func (c *LexModelsV2) DescribeSlotRequest(input *DescribeSlotInput) (req *request.Request, output *DescribeSlotOutput) {
	op := &request.Operation{
		Name:       opDescribeSlot,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
	}

	if input == nil {
		input = &DescribeSlotInput{}
	}

	output = &DescribeSlotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlot API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about a slot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot
func (c *LexModelsV2) DescribeSlot(input *DescribeSlotInput) (*DescribeSlotOutput, error) {
	req, out := c.DescribeSlotRequest(input)
	return out, req.Send()
}

// DescribeSlotWithContext is the same as DescribeSlot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeSlotWithContext(ctx aws.Context, input *DescribeSlotInput, opts ...request.Option) (*DescribeSlotOutput, error) {
	req, out := c.DescribeSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSlotType = "DescribeSlotType"

// DescribeSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSlotType for more information on using the DescribeSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSlotTypeRequest method.
//	req, resp := client.DescribeSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType
func (c *LexModelsV2) DescribeSlotTypeRequest(input *DescribeSlotTypeInput) (req *request.Request, output *DescribeSlotTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeSlotType,
		HTTPMethod: "GET",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
	}

	if input == nil {
		input = &DescribeSlotTypeInput{}
	}

	output = &DescribeSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSlotType API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about a slot type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType
func (c *LexModelsV2) DescribeSlotType(input *DescribeSlotTypeInput) (*DescribeSlotTypeOutput, error) {
	req, out := c.DescribeSlotTypeRequest(input)
	return out, req.Send()
}

// DescribeSlotTypeWithContext is the same as DescribeSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeSlotTypeWithContext(ctx aws.Context, input *DescribeSlotTypeInput, opts ...request.Option) (*DescribeSlotTypeOutput, error) {
	req, out := c.DescribeSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestExecution = "DescribeTestExecution"

// DescribeTestExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestExecution for more information on using the DescribeTestExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestExecutionRequest method.
//	req, resp := client.DescribeTestExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution
func (c *LexModelsV2) DescribeTestExecutionRequest(input *DescribeTestExecutionInput) (req *request.Request, output *DescribeTestExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeTestExecution,
		HTTPMethod: "GET",
		HTTPPath:   "/testexecutions/{testExecutionId}",
	}

	if input == nil {
		input = &DescribeTestExecutionInput{}
	}

	output = &DescribeTestExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestExecution API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestExecution for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestExecution
func (c *LexModelsV2) DescribeTestExecution(input *DescribeTestExecutionInput) (*DescribeTestExecutionOutput, error) {
	req, out := c.DescribeTestExecutionRequest(input)
	return out, req.Send()
}

// DescribeTestExecutionWithContext is the same as DescribeTestExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestExecutionWithContext(ctx aws.Context, input *DescribeTestExecutionInput, opts ...request.Option) (*DescribeTestExecutionOutput, error) {
	req, out := c.DescribeTestExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestSet = "DescribeTestSet"

// DescribeTestSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestSet for more information on using the DescribeTestSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestSetRequest method.
//	req, resp := client.DescribeTestSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet
func (c *LexModelsV2) DescribeTestSetRequest(input *DescribeTestSetInput) (req *request.Request, output *DescribeTestSetOutput) {
	op := &request.Operation{
		Name:       opDescribeTestSet,
		HTTPMethod: "GET",
		HTTPPath:   "/testsets/{testSetId}",
	}

	if input == nil {
		input = &DescribeTestSetInput{}
	}

	output = &DescribeTestSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestSet API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSet
func (c *LexModelsV2) DescribeTestSet(input *DescribeTestSetInput) (*DescribeTestSetOutput, error) {
	req, out := c.DescribeTestSetRequest(input)
	return out, req.Send()
}

// DescribeTestSetWithContext is the same as DescribeTestSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestSetWithContext(ctx aws.Context, input *DescribeTestSetInput, opts ...request.Option) (*DescribeTestSetOutput, error) {
	req, out := c.DescribeTestSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestSetDiscrepancyReport = "DescribeTestSetDiscrepancyReport"

// DescribeTestSetDiscrepancyReportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestSetDiscrepancyReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestSetDiscrepancyReport for more information on using the DescribeTestSetDiscrepancyReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestSetDiscrepancyReportRequest method.
//	req, resp := client.DescribeTestSetDiscrepancyReportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport
func (c *LexModelsV2) DescribeTestSetDiscrepancyReportRequest(input *DescribeTestSetDiscrepancyReportInput) (req *request.Request, output *DescribeTestSetDiscrepancyReportOutput) {
	op := &request.Operation{
		Name:       opDescribeTestSetDiscrepancyReport,
		HTTPMethod: "GET",
		HTTPPath:   "/testsetdiscrepancy/{testSetDiscrepancyReportId}",
	}

	if input == nil {
		input = &DescribeTestSetDiscrepancyReportInput{}
	}

	output = &DescribeTestSetDiscrepancyReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestSetDiscrepancyReport API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test set discrepancy report.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestSetDiscrepancyReport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetDiscrepancyReport
func (c *LexModelsV2) DescribeTestSetDiscrepancyReport(input *DescribeTestSetDiscrepancyReportInput) (*DescribeTestSetDiscrepancyReportOutput, error) {
	req, out := c.DescribeTestSetDiscrepancyReportRequest(input)
	return out, req.Send()
}

// DescribeTestSetDiscrepancyReportWithContext is the same as DescribeTestSetDiscrepancyReport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestSetDiscrepancyReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestSetDiscrepancyReportWithContext(ctx aws.Context, input *DescribeTestSetDiscrepancyReportInput, opts ...request.Option) (*DescribeTestSetDiscrepancyReportOutput, error) {
	req, out := c.DescribeTestSetDiscrepancyReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTestSetGeneration = "DescribeTestSetGeneration"

// DescribeTestSetGenerationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTestSetGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTestSetGeneration for more information on using the DescribeTestSetGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTestSetGenerationRequest method.
//	req, resp := client.DescribeTestSetGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration
func (c *LexModelsV2) DescribeTestSetGenerationRequest(input *DescribeTestSetGenerationInput) (req *request.Request, output *DescribeTestSetGenerationOutput) {
	op := &request.Operation{
		Name:       opDescribeTestSetGeneration,
		HTTPMethod: "GET",
		HTTPPath:   "/testsetgenerations/{testSetGenerationId}",
	}

	if input == nil {
		input = &DescribeTestSetGenerationInput{}
	}

	output = &DescribeTestSetGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTestSetGeneration API operation for Amazon Lex Model Building V2.
//
// Gets metadata information about the test set generation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation DescribeTestSetGeneration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeTestSetGeneration
func (c *LexModelsV2) DescribeTestSetGeneration(input *DescribeTestSetGenerationInput) (*DescribeTestSetGenerationOutput, error) {
	req, out := c.DescribeTestSetGenerationRequest(input)
	return out, req.Send()
}

// DescribeTestSetGenerationWithContext is the same as DescribeTestSetGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTestSetGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) DescribeTestSetGenerationWithContext(ctx aws.Context, input *DescribeTestSetGenerationInput, opts ...request.Option) (*DescribeTestSetGenerationOutput, error) {
	req, out := c.DescribeTestSetGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTestExecutionArtifactsUrl = "GetTestExecutionArtifactsUrl"

// GetTestExecutionArtifactsUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetTestExecutionArtifactsUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTestExecutionArtifactsUrl for more information on using the GetTestExecutionArtifactsUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTestExecutionArtifactsUrlRequest method.
//	req, resp := client.GetTestExecutionArtifactsUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl
func (c *LexModelsV2) GetTestExecutionArtifactsUrlRequest(input *GetTestExecutionArtifactsUrlInput) (req *request.Request, output *GetTestExecutionArtifactsUrlOutput) {
	op := &request.Operation{
		Name:       opGetTestExecutionArtifactsUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/testexecutions/{testExecutionId}/artifacturl",
	}

	if input == nil {
		input = &GetTestExecutionArtifactsUrlInput{}
	}

	output = &GetTestExecutionArtifactsUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTestExecutionArtifactsUrl API operation for Amazon Lex Model Building V2.
//
// The pre-signed Amazon S3 URL to download the test execution result artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation GetTestExecutionArtifactsUrl for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/GetTestExecutionArtifactsUrl
func (c *LexModelsV2) GetTestExecutionArtifactsUrl(input *GetTestExecutionArtifactsUrlInput) (*GetTestExecutionArtifactsUrlOutput, error) {
	req, out := c.GetTestExecutionArtifactsUrlRequest(input)
	return out, req.Send()
}

// GetTestExecutionArtifactsUrlWithContext is the same as GetTestExecutionArtifactsUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetTestExecutionArtifactsUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) GetTestExecutionArtifactsUrlWithContext(ctx aws.Context, input *GetTestExecutionArtifactsUrlInput, opts ...request.Option) (*GetTestExecutionArtifactsUrlOutput, error) {
	req, out := c.GetTestExecutionArtifactsUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAggregatedUtterances = "ListAggregatedUtterances"

// ListAggregatedUtterancesRequest generates a "aws/request.Request" representing the
// client's request for the ListAggregatedUtterances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAggregatedUtterances for more information on using the ListAggregatedUtterances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAggregatedUtterancesRequest method.
//	req, resp := client.ListAggregatedUtterancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances
func (c *LexModelsV2) ListAggregatedUtterancesRequest(input *ListAggregatedUtterancesInput) (req *request.Request, output *ListAggregatedUtterancesOutput) {
	op := &request.Operation{
		Name:       opListAggregatedUtterances,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/aggregatedutterances/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAggregatedUtterancesInput{}
	}

	output = &ListAggregatedUtterancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAggregatedUtterances API operation for Amazon Lex Model Building V2.
//
// Provides a list of utterances that users have sent to the bot.
//
// Utterances are aggregated by the text of the utterance. For example, all
// instances where customers used the phrase "I want to order pizza" are aggregated
// into the same line in the response.
//
// You can see both detected utterances and missed utterances. A detected utterance
// is where the bot properly recognized the utterance and activated the associated
// intent. A missed utterance was not recognized by the bot and didn't activate
// an intent.
//
// Utterances can be aggregated for a bot alias or for a bot version, but not
// both at the same time.
//
// Utterances statistics are not generated under the following conditions:
//
//   - The childDirected field was set to true when the bot was created.
//
//   - You are using slot obfuscation with one or more slots.
//
//   - You opted out of participating in improving Amazon Lex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListAggregatedUtterances for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListAggregatedUtterances
func (c *LexModelsV2) ListAggregatedUtterances(input *ListAggregatedUtterancesInput) (*ListAggregatedUtterancesOutput, error) {
	req, out := c.ListAggregatedUtterancesRequest(input)
	return out, req.Send()
}

// ListAggregatedUtterancesWithContext is the same as ListAggregatedUtterances with the addition of
// the ability to pass a context and additional request options.
//
// See ListAggregatedUtterances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListAggregatedUtterancesWithContext(ctx aws.Context, input *ListAggregatedUtterancesInput, opts ...request.Option) (*ListAggregatedUtterancesOutput, error) {
	req, out := c.ListAggregatedUtterancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAggregatedUtterancesPages iterates over the pages of a ListAggregatedUtterances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAggregatedUtterances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAggregatedUtterances operation.
//	pageNum := 0
//	err := client.ListAggregatedUtterancesPages(params,
//	    func(page *lexmodelsv2.ListAggregatedUtterancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListAggregatedUtterancesPages(input *ListAggregatedUtterancesInput, fn func(*ListAggregatedUtterancesOutput, bool) bool) error {
	return c.ListAggregatedUtterancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAggregatedUtterancesPagesWithContext same as ListAggregatedUtterancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListAggregatedUtterancesPagesWithContext(ctx aws.Context, input *ListAggregatedUtterancesInput, fn func(*ListAggregatedUtterancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAggregatedUtterancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAggregatedUtterancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAggregatedUtterancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotAliases = "ListBotAliases"

// ListBotAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListBotAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotAliases for more information on using the ListBotAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotAliasesRequest method.
//	req, resp := client.ListBotAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases
func (c *LexModelsV2) ListBotAliasesRequest(input *ListBotAliasesInput) (req *request.Request, output *ListBotAliasesOutput) {
	op := &request.Operation{
		Name:       opListBotAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botaliases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotAliasesInput{}
	}

	output = &ListBotAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotAliases API operation for Amazon Lex Model Building V2.
//
// Gets a list of aliases for the specified bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotAliases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases
func (c *LexModelsV2) ListBotAliases(input *ListBotAliasesInput) (*ListBotAliasesOutput, error) {
	req, out := c.ListBotAliasesRequest(input)
	return out, req.Send()
}

// ListBotAliasesWithContext is the same as ListBotAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotAliasesWithContext(ctx aws.Context, input *ListBotAliasesInput, opts ...request.Option) (*ListBotAliasesOutput, error) {
	req, out := c.ListBotAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotAliasesPages iterates over the pages of a ListBotAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotAliases operation.
//	pageNum := 0
//	err := client.ListBotAliasesPages(params,
//	    func(page *lexmodelsv2.ListBotAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotAliasesPages(input *ListBotAliasesInput, fn func(*ListBotAliasesOutput, bool) bool) error {
	return c.ListBotAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotAliasesPagesWithContext same as ListBotAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotAliasesPagesWithContext(ctx aws.Context, input *ListBotAliasesInput, fn func(*ListBotAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotLocales = "ListBotLocales"

// ListBotLocalesRequest generates a "aws/request.Request" representing the
// client's request for the ListBotLocales operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotLocales for more information on using the ListBotLocales
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotLocalesRequest method.
//	req, resp := client.ListBotLocalesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales
func (c *LexModelsV2) ListBotLocalesRequest(input *ListBotLocalesInput) (req *request.Request, output *ListBotLocalesOutput) {
	op := &request.Operation{
		Name:       opListBotLocales,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotLocalesInput{}
	}

	output = &ListBotLocalesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotLocales API operation for Amazon Lex Model Building V2.
//
// Gets a list of locales for the specified bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotLocales for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales
func (c *LexModelsV2) ListBotLocales(input *ListBotLocalesInput) (*ListBotLocalesOutput, error) {
	req, out := c.ListBotLocalesRequest(input)
	return out, req.Send()
}

// ListBotLocalesWithContext is the same as ListBotLocales with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotLocales for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotLocalesWithContext(ctx aws.Context, input *ListBotLocalesInput, opts ...request.Option) (*ListBotLocalesOutput, error) {
	req, out := c.ListBotLocalesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotLocalesPages iterates over the pages of a ListBotLocales operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotLocales method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotLocales operation.
//	pageNum := 0
//	err := client.ListBotLocalesPages(params,
//	    func(page *lexmodelsv2.ListBotLocalesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotLocalesPages(input *ListBotLocalesInput, fn func(*ListBotLocalesOutput, bool) bool) error {
	return c.ListBotLocalesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotLocalesPagesWithContext same as ListBotLocalesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotLocalesPagesWithContext(ctx aws.Context, input *ListBotLocalesInput, fn func(*ListBotLocalesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotLocalesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotLocalesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotLocalesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotRecommendations = "ListBotRecommendations"

// ListBotRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBotRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotRecommendations for more information on using the ListBotRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotRecommendationsRequest method.
//	req, resp := client.ListBotRecommendationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations
func (c *LexModelsV2) ListBotRecommendationsRequest(input *ListBotRecommendationsInput) (req *request.Request, output *ListBotRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListBotRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotRecommendationsInput{}
	}

	output = &ListBotRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotRecommendations API operation for Amazon Lex Model Building V2.
//
// Get a list of bot recommendations that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotRecommendations for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotRecommendations
func (c *LexModelsV2) ListBotRecommendations(input *ListBotRecommendationsInput) (*ListBotRecommendationsOutput, error) {
	req, out := c.ListBotRecommendationsRequest(input)
	return out, req.Send()
}

// ListBotRecommendationsWithContext is the same as ListBotRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotRecommendationsWithContext(ctx aws.Context, input *ListBotRecommendationsInput, opts ...request.Option) (*ListBotRecommendationsOutput, error) {
	req, out := c.ListBotRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotRecommendationsPages iterates over the pages of a ListBotRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotRecommendations operation.
//	pageNum := 0
//	err := client.ListBotRecommendationsPages(params,
//	    func(page *lexmodelsv2.ListBotRecommendationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotRecommendationsPages(input *ListBotRecommendationsInput, fn func(*ListBotRecommendationsOutput, bool) bool) error {
	return c.ListBotRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotRecommendationsPagesWithContext same as ListBotRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotRecommendationsPagesWithContext(ctx aws.Context, input *ListBotRecommendationsInput, fn func(*ListBotRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBotVersions = "ListBotVersions"

// ListBotVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBotVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBotVersions for more information on using the ListBotVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotVersionsRequest method.
//	req, resp := client.ListBotVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions
func (c *LexModelsV2) ListBotVersionsRequest(input *ListBotVersionsInput) (req *request.Request, output *ListBotVersionsOutput) {
	op := &request.Operation{
		Name:       opListBotVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotVersionsInput{}
	}

	output = &ListBotVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBotVersions API operation for Amazon Lex Model Building V2.
//
// Gets information about all of the versions of a bot.
//
// The ListBotVersions operation returns a summary of each version of a bot.
// For example, if a bot has three numbered versions, the ListBotVersions operation
// returns for summaries, one for each numbered version and one for the DRAFT
// version.
//
// The ListBotVersions operation always returns at least one version, the DRAFT
// version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBotVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions
func (c *LexModelsV2) ListBotVersions(input *ListBotVersionsInput) (*ListBotVersionsOutput, error) {
	req, out := c.ListBotVersionsRequest(input)
	return out, req.Send()
}

// ListBotVersionsWithContext is the same as ListBotVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListBotVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotVersionsWithContext(ctx aws.Context, input *ListBotVersionsInput, opts ...request.Option) (*ListBotVersionsOutput, error) {
	req, out := c.ListBotVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotVersionsPages iterates over the pages of a ListBotVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBotVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBotVersions operation.
//	pageNum := 0
//	err := client.ListBotVersionsPages(params,
//	    func(page *lexmodelsv2.ListBotVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotVersionsPages(input *ListBotVersionsInput, fn func(*ListBotVersionsOutput, bool) bool) error {
	return c.ListBotVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotVersionsPagesWithContext same as ListBotVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotVersionsPagesWithContext(ctx aws.Context, input *ListBotVersionsInput, fn func(*ListBotVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBots = "ListBots"

// ListBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBots for more information on using the ListBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotsRequest method.
//	req, resp := client.ListBotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots
func (c *LexModelsV2) ListBotsRequest(input *ListBotsInput) (req *request.Request, output *ListBotsOutput) {
	op := &request.Operation{
		Name:       opListBots,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotsInput{}
	}

	output = &ListBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBots API operation for Amazon Lex Model Building V2.
//
// Gets a list of available bots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBots for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots
func (c *LexModelsV2) ListBots(input *ListBotsInput) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	return out, req.Send()
}

// ListBotsWithContext is the same as ListBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotsWithContext(ctx aws.Context, input *ListBotsInput, opts ...request.Option) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotsPages iterates over the pages of a ListBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBots operation.
//	pageNum := 0
//	err := client.ListBotsPages(params,
//	    func(page *lexmodelsv2.ListBotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBotsPages(input *ListBotsInput, fn func(*ListBotsOutput, bool) bool) error {
	return c.ListBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotsPagesWithContext same as ListBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBotsPagesWithContext(ctx aws.Context, input *ListBotsInput, fn func(*ListBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBuiltInIntents = "ListBuiltInIntents"

// ListBuiltInIntentsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuiltInIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuiltInIntents for more information on using the ListBuiltInIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBuiltInIntentsRequest method.
//	req, resp := client.ListBuiltInIntentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents
func (c *LexModelsV2) ListBuiltInIntentsRequest(input *ListBuiltInIntentsInput) (req *request.Request, output *ListBuiltInIntentsOutput) {
	op := &request.Operation{
		Name:       opListBuiltInIntents,
		HTTPMethod: "POST",
		HTTPPath:   "/builtins/locales/{localeId}/intents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBuiltInIntentsInput{}
	}

	output = &ListBuiltInIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuiltInIntents API operation for Amazon Lex Model Building V2.
//
// Gets a list of built-in intents provided by Amazon Lex that you can use in
// your bot.
//
// To use a built-in intent as a the base for your own intent, include the built-in
// intent signature in the parentIntentSignature parameter when you call the
// CreateIntent operation. For more information, see CreateIntent (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateIntent.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBuiltInIntents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents
func (c *LexModelsV2) ListBuiltInIntents(input *ListBuiltInIntentsInput) (*ListBuiltInIntentsOutput, error) {
	req, out := c.ListBuiltInIntentsRequest(input)
	return out, req.Send()
}

// ListBuiltInIntentsWithContext is the same as ListBuiltInIntents with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuiltInIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInIntentsWithContext(ctx aws.Context, input *ListBuiltInIntentsInput, opts ...request.Option) (*ListBuiltInIntentsOutput, error) {
	req, out := c.ListBuiltInIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBuiltInIntentsPages iterates over the pages of a ListBuiltInIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBuiltInIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBuiltInIntents operation.
//	pageNum := 0
//	err := client.ListBuiltInIntentsPages(params,
//	    func(page *lexmodelsv2.ListBuiltInIntentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBuiltInIntentsPages(input *ListBuiltInIntentsInput, fn func(*ListBuiltInIntentsOutput, bool) bool) error {
	return c.ListBuiltInIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBuiltInIntentsPagesWithContext same as ListBuiltInIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInIntentsPagesWithContext(ctx aws.Context, input *ListBuiltInIntentsInput, fn func(*ListBuiltInIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBuiltInIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBuiltInIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBuiltInIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBuiltInSlotTypes = "ListBuiltInSlotTypes"

// ListBuiltInSlotTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListBuiltInSlotTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuiltInSlotTypes for more information on using the ListBuiltInSlotTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBuiltInSlotTypesRequest method.
//	req, resp := client.ListBuiltInSlotTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes
func (c *LexModelsV2) ListBuiltInSlotTypesRequest(input *ListBuiltInSlotTypesInput) (req *request.Request, output *ListBuiltInSlotTypesOutput) {
	op := &request.Operation{
		Name:       opListBuiltInSlotTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/builtins/locales/{localeId}/slottypes/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBuiltInSlotTypesInput{}
	}

	output = &ListBuiltInSlotTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuiltInSlotTypes API operation for Amazon Lex Model Building V2.
//
// Gets a list of built-in slot types that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListBuiltInSlotTypes for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes
func (c *LexModelsV2) ListBuiltInSlotTypes(input *ListBuiltInSlotTypesInput) (*ListBuiltInSlotTypesOutput, error) {
	req, out := c.ListBuiltInSlotTypesRequest(input)
	return out, req.Send()
}

// ListBuiltInSlotTypesWithContext is the same as ListBuiltInSlotTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuiltInSlotTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInSlotTypesWithContext(ctx aws.Context, input *ListBuiltInSlotTypesInput, opts ...request.Option) (*ListBuiltInSlotTypesOutput, error) {
	req, out := c.ListBuiltInSlotTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBuiltInSlotTypesPages iterates over the pages of a ListBuiltInSlotTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBuiltInSlotTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBuiltInSlotTypes operation.
//	pageNum := 0
//	err := client.ListBuiltInSlotTypesPages(params,
//	    func(page *lexmodelsv2.ListBuiltInSlotTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListBuiltInSlotTypesPages(input *ListBuiltInSlotTypesInput, fn func(*ListBuiltInSlotTypesOutput, bool) bool) error {
	return c.ListBuiltInSlotTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBuiltInSlotTypesPagesWithContext same as ListBuiltInSlotTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListBuiltInSlotTypesPagesWithContext(ctx aws.Context, input *ListBuiltInSlotTypesInput, fn func(*ListBuiltInSlotTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBuiltInSlotTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBuiltInSlotTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBuiltInSlotTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomVocabularyItems = "ListCustomVocabularyItems"

// ListCustomVocabularyItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomVocabularyItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomVocabularyItems for more information on using the ListCustomVocabularyItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomVocabularyItemsRequest method.
//	req, resp := client.ListCustomVocabularyItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems
func (c *LexModelsV2) ListCustomVocabularyItemsRequest(input *ListCustomVocabularyItemsInput) (req *request.Request, output *ListCustomVocabularyItemsOutput) {
	op := &request.Operation{
		Name:       opListCustomVocabularyItems,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomVocabularyItemsInput{}
	}

	output = &ListCustomVocabularyItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomVocabularyItems API operation for Amazon Lex Model Building V2.
//
// Paginated list of custom vocabulary items for a given bot locale's custom
// vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListCustomVocabularyItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListCustomVocabularyItems
func (c *LexModelsV2) ListCustomVocabularyItems(input *ListCustomVocabularyItemsInput) (*ListCustomVocabularyItemsOutput, error) {
	req, out := c.ListCustomVocabularyItemsRequest(input)
	return out, req.Send()
}

// ListCustomVocabularyItemsWithContext is the same as ListCustomVocabularyItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomVocabularyItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListCustomVocabularyItemsWithContext(ctx aws.Context, input *ListCustomVocabularyItemsInput, opts ...request.Option) (*ListCustomVocabularyItemsOutput, error) {
	req, out := c.ListCustomVocabularyItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomVocabularyItemsPages iterates over the pages of a ListCustomVocabularyItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomVocabularyItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomVocabularyItems operation.
//	pageNum := 0
//	err := client.ListCustomVocabularyItemsPages(params,
//	    func(page *lexmodelsv2.ListCustomVocabularyItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListCustomVocabularyItemsPages(input *ListCustomVocabularyItemsInput, fn func(*ListCustomVocabularyItemsOutput, bool) bool) error {
	return c.ListCustomVocabularyItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomVocabularyItemsPagesWithContext same as ListCustomVocabularyItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListCustomVocabularyItemsPagesWithContext(ctx aws.Context, input *ListCustomVocabularyItemsInput, fn func(*ListCustomVocabularyItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomVocabularyItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomVocabularyItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomVocabularyItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExports = "ListExports"

// ListExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListExports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExports for more information on using the ListExports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListExportsRequest method.
//	req, resp := client.ListExportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports
func (c *LexModelsV2) ListExportsRequest(input *ListExportsInput) (req *request.Request, output *ListExportsOutput) {
	op := &request.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/exports/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output = &ListExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExports API operation for Amazon Lex Model Building V2.
//
// Lists the exports for a bot, bot locale, or custom vocabulary. Exports are
// kept in the list for 7 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListExports for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports
func (c *LexModelsV2) ListExports(input *ListExportsInput) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	return out, req.Send()
}

// ListExportsWithContext is the same as ListExports with the addition of
// the ability to pass a context and additional request options.
//
// See ListExports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListExportsWithContext(ctx aws.Context, input *ListExportsInput, opts ...request.Option) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExportsPages iterates over the pages of a ListExports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListExports operation.
//	pageNum := 0
//	err := client.ListExportsPages(params,
//	    func(page *lexmodelsv2.ListExportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListExportsPages(input *ListExportsInput, fn func(*ListExportsOutput, bool) bool) error {
	return c.ListExportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExportsPagesWithContext same as ListExportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListExportsPagesWithContext(ctx aws.Context, input *ListExportsInput, fn func(*ListExportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImports = "ListImports"

// ListImportsRequest generates a "aws/request.Request" representing the
// client's request for the ListImports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImports for more information on using the ListImports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImportsRequest method.
//	req, resp := client.ListImportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports
func (c *LexModelsV2) ListImportsRequest(input *ListImportsInput) (req *request.Request, output *ListImportsOutput) {
	op := &request.Operation{
		Name:       opListImports,
		HTTPMethod: "POST",
		HTTPPath:   "/imports/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportsInput{}
	}

	output = &ListImportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImports API operation for Amazon Lex Model Building V2.
//
// Lists the imports for a bot, bot locale, or custom vocabulary. Imports are
// kept in the list for 7 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListImports for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports
func (c *LexModelsV2) ListImports(input *ListImportsInput) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	return out, req.Send()
}

// ListImportsWithContext is the same as ListImports with the addition of
// the ability to pass a context and additional request options.
//
// See ListImports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListImportsWithContext(ctx aws.Context, input *ListImportsInput, opts ...request.Option) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImportsPages iterates over the pages of a ListImports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImports operation.
//	pageNum := 0
//	err := client.ListImportsPages(params,
//	    func(page *lexmodelsv2.ListImportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListImportsPages(input *ListImportsInput, fn func(*ListImportsOutput, bool) bool) error {
	return c.ListImportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImportsPagesWithContext same as ListImportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListImportsPagesWithContext(ctx aws.Context, input *ListImportsInput, fn func(*ListImportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIntents = "ListIntents"

// ListIntentsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntents for more information on using the ListIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntentsRequest method.
//	req, resp := client.ListIntentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents
func (c *LexModelsV2) ListIntentsRequest(input *ListIntentsInput) (req *request.Request, output *ListIntentsOutput) {
	op := &request.Operation{
		Name:       opListIntents,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIntentsInput{}
	}

	output = &ListIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntents API operation for Amazon Lex Model Building V2.
//
// Get a list of intents that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListIntents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents
func (c *LexModelsV2) ListIntents(input *ListIntentsInput) (*ListIntentsOutput, error) {
	req, out := c.ListIntentsRequest(input)
	return out, req.Send()
}

// ListIntentsWithContext is the same as ListIntents with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentsWithContext(ctx aws.Context, input *ListIntentsInput, opts ...request.Option) (*ListIntentsOutput, error) {
	req, out := c.ListIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIntentsPages iterates over the pages of a ListIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIntents operation.
//	pageNum := 0
//	err := client.ListIntentsPages(params,
//	    func(page *lexmodelsv2.ListIntentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListIntentsPages(input *ListIntentsInput, fn func(*ListIntentsOutput, bool) bool) error {
	return c.ListIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIntentsPagesWithContext same as ListIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListIntentsPagesWithContext(ctx aws.Context, input *ListIntentsInput, fn func(*ListIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendedIntents = "ListRecommendedIntents"

// ListRecommendedIntentsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendedIntents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendedIntents for more information on using the ListRecommendedIntents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecommendedIntentsRequest method.
//	req, resp := client.ListRecommendedIntentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents
func (c *LexModelsV2) ListRecommendedIntentsRequest(input *ListRecommendedIntentsInput) (req *request.Request, output *ListRecommendedIntentsOutput) {
	op := &request.Operation{
		Name:       opListRecommendedIntents,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/intents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendedIntentsInput{}
	}

	output = &ListRecommendedIntentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendedIntents API operation for Amazon Lex Model Building V2.
//
// Gets a list of recommended intents provided by the bot recommendation that
// you can use in your bot. Intents in the response are ordered by relevance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListRecommendedIntents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListRecommendedIntents
func (c *LexModelsV2) ListRecommendedIntents(input *ListRecommendedIntentsInput) (*ListRecommendedIntentsOutput, error) {
	req, out := c.ListRecommendedIntentsRequest(input)
	return out, req.Send()
}

// ListRecommendedIntentsWithContext is the same as ListRecommendedIntents with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendedIntents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListRecommendedIntentsWithContext(ctx aws.Context, input *ListRecommendedIntentsInput, opts ...request.Option) (*ListRecommendedIntentsOutput, error) {
	req, out := c.ListRecommendedIntentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendedIntentsPages iterates over the pages of a ListRecommendedIntents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendedIntents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecommendedIntents operation.
//	pageNum := 0
//	err := client.ListRecommendedIntentsPages(params,
//	    func(page *lexmodelsv2.ListRecommendedIntentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListRecommendedIntentsPages(input *ListRecommendedIntentsInput, fn func(*ListRecommendedIntentsOutput, bool) bool) error {
	return c.ListRecommendedIntentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendedIntentsPagesWithContext same as ListRecommendedIntentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListRecommendedIntentsPagesWithContext(ctx aws.Context, input *ListRecommendedIntentsInput, fn func(*ListRecommendedIntentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendedIntentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendedIntentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendedIntentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSlotTypes = "ListSlotTypes"

// ListSlotTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListSlotTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSlotTypes for more information on using the ListSlotTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSlotTypesRequest method.
//	req, resp := client.ListSlotTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes
func (c *LexModelsV2) ListSlotTypesRequest(input *ListSlotTypesInput) (req *request.Request, output *ListSlotTypesOutput) {
	op := &request.Operation{
		Name:       opListSlotTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSlotTypesInput{}
	}

	output = &ListSlotTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSlotTypes API operation for Amazon Lex Model Building V2.
//
// Gets a list of slot types that match the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListSlotTypes for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes
func (c *LexModelsV2) ListSlotTypes(input *ListSlotTypesInput) (*ListSlotTypesOutput, error) {
	req, out := c.ListSlotTypesRequest(input)
	return out, req.Send()
}

// ListSlotTypesWithContext is the same as ListSlotTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListSlotTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotTypesWithContext(ctx aws.Context, input *ListSlotTypesInput, opts ...request.Option) (*ListSlotTypesOutput, error) {
	req, out := c.ListSlotTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSlotTypesPages iterates over the pages of a ListSlotTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSlotTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSlotTypes operation.
//	pageNum := 0
//	err := client.ListSlotTypesPages(params,
//	    func(page *lexmodelsv2.ListSlotTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListSlotTypesPages(input *ListSlotTypesInput, fn func(*ListSlotTypesOutput, bool) bool) error {
	return c.ListSlotTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSlotTypesPagesWithContext same as ListSlotTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotTypesPagesWithContext(ctx aws.Context, input *ListSlotTypesInput, fn func(*ListSlotTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSlotTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSlotTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSlotTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSlots = "ListSlots"

// ListSlotsRequest generates a "aws/request.Request" representing the
// client's request for the ListSlots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSlots for more information on using the ListSlots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSlotsRequest method.
//	req, resp := client.ListSlotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots
func (c *LexModelsV2) ListSlotsRequest(input *ListSlotsInput) (req *request.Request, output *ListSlotsOutput) {
	op := &request.Operation{
		Name:       opListSlots,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSlotsInput{}
	}

	output = &ListSlotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSlots API operation for Amazon Lex Model Building V2.
//
// Gets a list of slots that match the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListSlots for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots
func (c *LexModelsV2) ListSlots(input *ListSlotsInput) (*ListSlotsOutput, error) {
	req, out := c.ListSlotsRequest(input)
	return out, req.Send()
}

// ListSlotsWithContext is the same as ListSlots with the addition of
// the ability to pass a context and additional request options.
//
// See ListSlots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotsWithContext(ctx aws.Context, input *ListSlotsInput, opts ...request.Option) (*ListSlotsOutput, error) {
	req, out := c.ListSlotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSlotsPages iterates over the pages of a ListSlots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSlots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSlots operation.
//	pageNum := 0
//	err := client.ListSlotsPages(params,
//	    func(page *lexmodelsv2.ListSlotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListSlotsPages(input *ListSlotsInput, fn func(*ListSlotsOutput, bool) bool) error {
	return c.ListSlotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSlotsPagesWithContext same as ListSlotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListSlotsPagesWithContext(ctx aws.Context, input *ListSlotsInput, fn func(*ListSlotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSlotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSlotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSlotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource
func (c *LexModelsV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Lex Model Building V2.
//
// Gets a list of tags associated with a resource. Only bots, bot aliases, and
// bot channels can have tags associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource
func (c *LexModelsV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTestExecutionResultItems = "ListTestExecutionResultItems"

// ListTestExecutionResultItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestExecutionResultItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestExecutionResultItems for more information on using the ListTestExecutionResultItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestExecutionResultItemsRequest method.
//	req, resp := client.ListTestExecutionResultItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems
func (c *LexModelsV2) ListTestExecutionResultItemsRequest(input *ListTestExecutionResultItemsInput) (req *request.Request, output *ListTestExecutionResultItemsOutput) {
	op := &request.Operation{
		Name:       opListTestExecutionResultItems,
		HTTPMethod: "POST",
		HTTPPath:   "/testexecutions/{testExecutionId}/results",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestExecutionResultItemsInput{}
	}

	output = &ListTestExecutionResultItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestExecutionResultItems API operation for Amazon Lex Model Building V2.
//
// Gets a list of test execution result items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestExecutionResultItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutionResultItems
func (c *LexModelsV2) ListTestExecutionResultItems(input *ListTestExecutionResultItemsInput) (*ListTestExecutionResultItemsOutput, error) {
	req, out := c.ListTestExecutionResultItemsRequest(input)
	return out, req.Send()
}

// ListTestExecutionResultItemsWithContext is the same as ListTestExecutionResultItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestExecutionResultItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionResultItemsWithContext(ctx aws.Context, input *ListTestExecutionResultItemsInput, opts ...request.Option) (*ListTestExecutionResultItemsOutput, error) {
	req, out := c.ListTestExecutionResultItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestExecutionResultItemsPages iterates over the pages of a ListTestExecutionResultItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestExecutionResultItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestExecutionResultItems operation.
//	pageNum := 0
//	err := client.ListTestExecutionResultItemsPages(params,
//	    func(page *lexmodelsv2.ListTestExecutionResultItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestExecutionResultItemsPages(input *ListTestExecutionResultItemsInput, fn func(*ListTestExecutionResultItemsOutput, bool) bool) error {
	return c.ListTestExecutionResultItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestExecutionResultItemsPagesWithContext same as ListTestExecutionResultItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionResultItemsPagesWithContext(ctx aws.Context, input *ListTestExecutionResultItemsInput, fn func(*ListTestExecutionResultItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestExecutionResultItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestExecutionResultItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestExecutionResultItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestExecutions = "ListTestExecutions"

// ListTestExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestExecutions for more information on using the ListTestExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestExecutionsRequest method.
//	req, resp := client.ListTestExecutionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions
func (c *LexModelsV2) ListTestExecutionsRequest(input *ListTestExecutionsInput) (req *request.Request, output *ListTestExecutionsOutput) {
	op := &request.Operation{
		Name:       opListTestExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/testexecutions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestExecutionsInput{}
	}

	output = &ListTestExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestExecutions API operation for Amazon Lex Model Building V2.
//
// The list of test set executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestExecutions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestExecutions
func (c *LexModelsV2) ListTestExecutions(input *ListTestExecutionsInput) (*ListTestExecutionsOutput, error) {
	req, out := c.ListTestExecutionsRequest(input)
	return out, req.Send()
}

// ListTestExecutionsWithContext is the same as ListTestExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionsWithContext(ctx aws.Context, input *ListTestExecutionsInput, opts ...request.Option) (*ListTestExecutionsOutput, error) {
	req, out := c.ListTestExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestExecutionsPages iterates over the pages of a ListTestExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestExecutions operation.
//	pageNum := 0
//	err := client.ListTestExecutionsPages(params,
//	    func(page *lexmodelsv2.ListTestExecutionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestExecutionsPages(input *ListTestExecutionsInput, fn func(*ListTestExecutionsOutput, bool) bool) error {
	return c.ListTestExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestExecutionsPagesWithContext same as ListTestExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestExecutionsPagesWithContext(ctx aws.Context, input *ListTestExecutionsInput, fn func(*ListTestExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestSetRecords = "ListTestSetRecords"

// ListTestSetRecordsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestSetRecords operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestSetRecords for more information on using the ListTestSetRecords
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestSetRecordsRequest method.
//	req, resp := client.ListTestSetRecordsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords
func (c *LexModelsV2) ListTestSetRecordsRequest(input *ListTestSetRecordsInput) (req *request.Request, output *ListTestSetRecordsOutput) {
	op := &request.Operation{
		Name:       opListTestSetRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets/{testSetId}/records",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestSetRecordsInput{}
	}

	output = &ListTestSetRecordsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestSetRecords API operation for Amazon Lex Model Building V2.
//
// The list of test set records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestSetRecords for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSetRecords
func (c *LexModelsV2) ListTestSetRecords(input *ListTestSetRecordsInput) (*ListTestSetRecordsOutput, error) {
	req, out := c.ListTestSetRecordsRequest(input)
	return out, req.Send()
}

// ListTestSetRecordsWithContext is the same as ListTestSetRecords with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestSetRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetRecordsWithContext(ctx aws.Context, input *ListTestSetRecordsInput, opts ...request.Option) (*ListTestSetRecordsOutput, error) {
	req, out := c.ListTestSetRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestSetRecordsPages iterates over the pages of a ListTestSetRecords operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestSetRecords method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestSetRecords operation.
//	pageNum := 0
//	err := client.ListTestSetRecordsPages(params,
//	    func(page *lexmodelsv2.ListTestSetRecordsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestSetRecordsPages(input *ListTestSetRecordsInput, fn func(*ListTestSetRecordsOutput, bool) bool) error {
	return c.ListTestSetRecordsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestSetRecordsPagesWithContext same as ListTestSetRecordsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetRecordsPagesWithContext(ctx aws.Context, input *ListTestSetRecordsInput, fn func(*ListTestSetRecordsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestSetRecordsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestSetRecordsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestSetRecordsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTestSets = "ListTestSets"

// ListTestSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListTestSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTestSets for more information on using the ListTestSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTestSetsRequest method.
//	req, resp := client.ListTestSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets
func (c *LexModelsV2) ListTestSetsRequest(input *ListTestSetsInput) (req *request.Request, output *ListTestSetsOutput) {
	op := &request.Operation{
		Name:       opListTestSets,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestSetsInput{}
	}

	output = &ListTestSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTestSets API operation for Amazon Lex Model Building V2.
//
// # The list of the test sets
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation ListTestSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTestSets
func (c *LexModelsV2) ListTestSets(input *ListTestSetsInput) (*ListTestSetsOutput, error) {
	req, out := c.ListTestSetsRequest(input)
	return out, req.Send()
}

// ListTestSetsWithContext is the same as ListTestSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListTestSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetsWithContext(ctx aws.Context, input *ListTestSetsInput, opts ...request.Option) (*ListTestSetsOutput, error) {
	req, out := c.ListTestSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTestSetsPages iterates over the pages of a ListTestSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTestSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTestSets operation.
//	pageNum := 0
//	err := client.ListTestSetsPages(params,
//	    func(page *lexmodelsv2.ListTestSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *LexModelsV2) ListTestSetsPages(input *ListTestSetsInput, fn func(*ListTestSetsOutput, bool) bool) error {
	return c.ListTestSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTestSetsPagesWithContext same as ListTestSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) ListTestSetsPagesWithContext(ctx aws.Context, input *ListTestSetsInput, fn func(*ListTestSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTestSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTestSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTestSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchAssociatedTranscripts = "SearchAssociatedTranscripts"

// SearchAssociatedTranscriptsRequest generates a "aws/request.Request" representing the
// client's request for the SearchAssociatedTranscripts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAssociatedTranscripts for more information on using the SearchAssociatedTranscripts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAssociatedTranscriptsRequest method.
//	req, resp := client.SearchAssociatedTranscriptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts
func (c *LexModelsV2) SearchAssociatedTranscriptsRequest(input *SearchAssociatedTranscriptsInput) (req *request.Request, output *SearchAssociatedTranscriptsOutput) {
	op := &request.Operation{
		Name:       opSearchAssociatedTranscripts,
		HTTPMethod: "POST",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/associatedtranscripts",
	}

	if input == nil {
		input = &SearchAssociatedTranscriptsInput{}
	}

	output = &SearchAssociatedTranscriptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAssociatedTranscripts API operation for Amazon Lex Model Building V2.
//
// Search for associated transcripts that meet the specified criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation SearchAssociatedTranscripts for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SearchAssociatedTranscripts
func (c *LexModelsV2) SearchAssociatedTranscripts(input *SearchAssociatedTranscriptsInput) (*SearchAssociatedTranscriptsOutput, error) {
	req, out := c.SearchAssociatedTranscriptsRequest(input)
	return out, req.Send()
}

// SearchAssociatedTranscriptsWithContext is the same as SearchAssociatedTranscripts with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAssociatedTranscripts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) SearchAssociatedTranscriptsWithContext(ctx aws.Context, input *SearchAssociatedTranscriptsInput, opts ...request.Option) (*SearchAssociatedTranscriptsOutput, error) {
	req, out := c.SearchAssociatedTranscriptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBotRecommendation = "StartBotRecommendation"

// StartBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the StartBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBotRecommendation for more information on using the StartBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartBotRecommendationRequest method.
//	req, resp := client.StartBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation
func (c *LexModelsV2) StartBotRecommendationRequest(input *StartBotRecommendationInput) (req *request.Request, output *StartBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opStartBotRecommendation,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
	}

	if input == nil {
		input = &StartBotRecommendationInput{}
	}

	output = &StartBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Use this to provide your transcript data, and to start the bot recommendation
// process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartBotRecommendation
func (c *LexModelsV2) StartBotRecommendation(input *StartBotRecommendationInput) (*StartBotRecommendationOutput, error) {
	req, out := c.StartBotRecommendationRequest(input)
	return out, req.Send()
}

// StartBotRecommendationWithContext is the same as StartBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See StartBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartBotRecommendationWithContext(ctx aws.Context, input *StartBotRecommendationInput, opts ...request.Option) (*StartBotRecommendationOutput, error) {
	req, out := c.StartBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImport = "StartImport"

// StartImportRequest generates a "aws/request.Request" representing the
// client's request for the StartImport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImport for more information on using the StartImport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartImportRequest method.
//	req, resp := client.StartImportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport
func (c *LexModelsV2) StartImportRequest(input *StartImportInput) (req *request.Request, output *StartImportOutput) {
	op := &request.Operation{
		Name:       opStartImport,
		HTTPMethod: "PUT",
		HTTPPath:   "/imports/",
	}

	if input == nil {
		input = &StartImportInput{}
	}

	output = &StartImportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImport API operation for Amazon Lex Model Building V2.
//
// Starts importing a bot, bot locale, or custom vocabulary from a zip archive
// that you uploaded to an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartImport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport
func (c *LexModelsV2) StartImport(input *StartImportInput) (*StartImportOutput, error) {
	req, out := c.StartImportRequest(input)
	return out, req.Send()
}

// StartImportWithContext is the same as StartImport with the addition of
// the ability to pass a context and additional request options.
//
// See StartImport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartImportWithContext(ctx aws.Context, input *StartImportInput, opts ...request.Option) (*StartImportOutput, error) {
	req, out := c.StartImportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTestExecution = "StartTestExecution"

// StartTestExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartTestExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTestExecution for more information on using the StartTestExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTestExecutionRequest method.
//	req, resp := client.StartTestExecutionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution
func (c *LexModelsV2) StartTestExecutionRequest(input *StartTestExecutionInput) (req *request.Request, output *StartTestExecutionOutput) {
	op := &request.Operation{
		Name:       opStartTestExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/testsets/{testSetId}/testexecutions",
	}

	if input == nil {
		input = &StartTestExecutionInput{}
	}

	output = &StartTestExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTestExecution API operation for Amazon Lex Model Building V2.
//
// The action to start test set execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartTestExecution for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestExecution
func (c *LexModelsV2) StartTestExecution(input *StartTestExecutionInput) (*StartTestExecutionOutput, error) {
	req, out := c.StartTestExecutionRequest(input)
	return out, req.Send()
}

// StartTestExecutionWithContext is the same as StartTestExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartTestExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartTestExecutionWithContext(ctx aws.Context, input *StartTestExecutionInput, opts ...request.Option) (*StartTestExecutionOutput, error) {
	req, out := c.StartTestExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTestSetGeneration = "StartTestSetGeneration"

// StartTestSetGenerationRequest generates a "aws/request.Request" representing the
// client's request for the StartTestSetGeneration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTestSetGeneration for more information on using the StartTestSetGeneration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTestSetGenerationRequest method.
//	req, resp := client.StartTestSetGenerationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration
func (c *LexModelsV2) StartTestSetGenerationRequest(input *StartTestSetGenerationInput) (req *request.Request, output *StartTestSetGenerationOutput) {
	op := &request.Operation{
		Name:       opStartTestSetGeneration,
		HTTPMethod: "PUT",
		HTTPPath:   "/testsetgenerations",
	}

	if input == nil {
		input = &StartTestSetGenerationInput{}
	}

	output = &StartTestSetGenerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTestSetGeneration API operation for Amazon Lex Model Building V2.
//
// The action to start the generation of test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StartTestSetGeneration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartTestSetGeneration
func (c *LexModelsV2) StartTestSetGeneration(input *StartTestSetGenerationInput) (*StartTestSetGenerationOutput, error) {
	req, out := c.StartTestSetGenerationRequest(input)
	return out, req.Send()
}

// StartTestSetGenerationWithContext is the same as StartTestSetGeneration with the addition of
// the ability to pass a context and additional request options.
//
// See StartTestSetGeneration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StartTestSetGenerationWithContext(ctx aws.Context, input *StartTestSetGenerationInput, opts ...request.Option) (*StartTestSetGenerationOutput, error) {
	req, out := c.StartTestSetGenerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopBotRecommendation = "StopBotRecommendation"

// StopBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the StopBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopBotRecommendation for more information on using the StopBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopBotRecommendationRequest method.
//	req, resp := client.StopBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation
func (c *LexModelsV2) StopBotRecommendationRequest(input *StopBotRecommendationInput) (req *request.Request, output *StopBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opStopBotRecommendation,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/stopbotrecommendation",
	}

	if input == nil {
		input = &StopBotRecommendationInput{}
	}

	output = &StopBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Stop an already running Bot Recommendation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation StopBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StopBotRecommendation
func (c *LexModelsV2) StopBotRecommendation(input *StopBotRecommendationInput) (*StopBotRecommendationOutput, error) {
	req, out := c.StopBotRecommendationRequest(input)
	return out, req.Send()
}

// StopBotRecommendationWithContext is the same as StopBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See StopBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) StopBotRecommendationWithContext(ctx aws.Context, input *StopBotRecommendationInput, opts ...request.Option) (*StopBotRecommendationOutput, error) {
	req, out := c.StopBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource
func (c *LexModelsV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Lex Model Building V2.
//
// Adds the specified tags to the specified resource. If a tag key already exists,
// the existing value is replaced with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource
func (c *LexModelsV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource
func (c *LexModelsV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Lex Model Building V2.
//
// Removes tags from a bot, bot alias, or bot channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource
func (c *LexModelsV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBot = "UpdateBot"

// UpdateBotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBot for more information on using the UpdateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotRequest method.
//	req, resp := client.UpdateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot
func (c *LexModelsV2) UpdateBotRequest(input *UpdateBotInput) (req *request.Request, output *UpdateBotOutput) {
	op := &request.Operation{
		Name:       opUpdateBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/",
	}

	if input == nil {
		input = &UpdateBotInput{}
	}

	output = &UpdateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBot API operation for Amazon Lex Model Building V2.
//
// Updates the configuration of an existing bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot
func (c *LexModelsV2) UpdateBot(input *UpdateBotInput) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	return out, req.Send()
}

// UpdateBotWithContext is the same as UpdateBot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotWithContext(ctx aws.Context, input *UpdateBotInput, opts ...request.Option) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBotAlias = "UpdateBotAlias"

// UpdateBotAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBotAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBotAlias for more information on using the UpdateBotAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotAliasRequest method.
//	req, resp := client.UpdateBotAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias
func (c *LexModelsV2) UpdateBotAliasRequest(input *UpdateBotAliasInput) (req *request.Request, output *UpdateBotAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateBotAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botaliases/{botAliasId}/",
	}

	if input == nil {
		input = &UpdateBotAliasInput{}
	}

	output = &UpdateBotAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBotAlias API operation for Amazon Lex Model Building V2.
//
// Updates the configuration of an existing bot alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBotAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias
func (c *LexModelsV2) UpdateBotAlias(input *UpdateBotAliasInput) (*UpdateBotAliasOutput, error) {
	req, out := c.UpdateBotAliasRequest(input)
	return out, req.Send()
}

// UpdateBotAliasWithContext is the same as UpdateBotAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBotAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotAliasWithContext(ctx aws.Context, input *UpdateBotAliasInput, opts ...request.Option) (*UpdateBotAliasOutput, error) {
	req, out := c.UpdateBotAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBotLocale = "UpdateBotLocale"

// UpdateBotLocaleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBotLocale operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBotLocale for more information on using the UpdateBotLocale
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotLocaleRequest method.
//	req, resp := client.UpdateBotLocaleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale
func (c *LexModelsV2) UpdateBotLocaleRequest(input *UpdateBotLocaleInput) (req *request.Request, output *UpdateBotLocaleOutput) {
	op := &request.Operation{
		Name:       opUpdateBotLocale,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
	}

	if input == nil {
		input = &UpdateBotLocaleInput{}
	}

	output = &UpdateBotLocaleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBotLocale API operation for Amazon Lex Model Building V2.
//
// Updates the settings that a bot has for a specific locale.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBotLocale for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale
func (c *LexModelsV2) UpdateBotLocale(input *UpdateBotLocaleInput) (*UpdateBotLocaleOutput, error) {
	req, out := c.UpdateBotLocaleRequest(input)
	return out, req.Send()
}

// UpdateBotLocaleWithContext is the same as UpdateBotLocale with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBotLocale for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotLocaleWithContext(ctx aws.Context, input *UpdateBotLocaleInput, opts ...request.Option) (*UpdateBotLocaleOutput, error) {
	req, out := c.UpdateBotLocaleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBotRecommendation = "UpdateBotRecommendation"

// UpdateBotRecommendationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBotRecommendation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBotRecommendation for more information on using the UpdateBotRecommendation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBotRecommendationRequest method.
//	req, resp := client.UpdateBotRecommendationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation
func (c *LexModelsV2) UpdateBotRecommendationRequest(input *UpdateBotRecommendationInput) (req *request.Request, output *UpdateBotRecommendationOutput) {
	op := &request.Operation{
		Name:       opUpdateBotRecommendation,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
	}

	if input == nil {
		input = &UpdateBotRecommendationInput{}
	}

	output = &UpdateBotRecommendationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBotRecommendation API operation for Amazon Lex Model Building V2.
//
// Updates an existing bot recommendation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateBotRecommendation for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotRecommendation
func (c *LexModelsV2) UpdateBotRecommendation(input *UpdateBotRecommendationInput) (*UpdateBotRecommendationOutput, error) {
	req, out := c.UpdateBotRecommendationRequest(input)
	return out, req.Send()
}

// UpdateBotRecommendationWithContext is the same as UpdateBotRecommendation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBotRecommendation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateBotRecommendationWithContext(ctx aws.Context, input *UpdateBotRecommendationInput, opts ...request.Option) (*UpdateBotRecommendationOutput, error) {
	req, out := c.UpdateBotRecommendationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExport = "UpdateExport"

// UpdateExportRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExport for more information on using the UpdateExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateExportRequest method.
//	req, resp := client.UpdateExportRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport
func (c *LexModelsV2) UpdateExportRequest(input *UpdateExportInput) (req *request.Request, output *UpdateExportOutput) {
	op := &request.Operation{
		Name:       opUpdateExport,
		HTTPMethod: "PUT",
		HTTPPath:   "/exports/{exportId}/",
	}

	if input == nil {
		input = &UpdateExportInput{}
	}

	output = &UpdateExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExport API operation for Amazon Lex Model Building V2.
//
// Updates the password used to protect an export zip archive.
//
// The password is not required. If you don't supply a password, Amazon Lex
// generates a zip file that is not protected by a password. This is the archive
// that is available at the pre-signed S3 URL provided by the DescribeExport
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateExport for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport
func (c *LexModelsV2) UpdateExport(input *UpdateExportInput) (*UpdateExportOutput, error) {
	req, out := c.UpdateExportRequest(input)
	return out, req.Send()
}

// UpdateExportWithContext is the same as UpdateExport with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateExportWithContext(ctx aws.Context, input *UpdateExportInput, opts ...request.Option) (*UpdateExportOutput, error) {
	req, out := c.UpdateExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntent = "UpdateIntent"

// UpdateIntentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntent for more information on using the UpdateIntent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIntentRequest method.
//	req, resp := client.UpdateIntentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent
func (c *LexModelsV2) UpdateIntentRequest(input *UpdateIntentInput) (req *request.Request, output *UpdateIntentOutput) {
	op := &request.Operation{
		Name:       opUpdateIntent,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
	}

	if input == nil {
		input = &UpdateIntentInput{}
	}

	output = &UpdateIntentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIntent API operation for Amazon Lex Model Building V2.
//
// Updates the settings for an intent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateIntent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent
func (c *LexModelsV2) UpdateIntent(input *UpdateIntentInput) (*UpdateIntentOutput, error) {
	req, out := c.UpdateIntentRequest(input)
	return out, req.Send()
}

// UpdateIntentWithContext is the same as UpdateIntent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateIntentWithContext(ctx aws.Context, input *UpdateIntentInput, opts ...request.Option) (*UpdateIntentOutput, error) {
	req, out := c.UpdateIntentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourcePolicy = "UpdateResourcePolicy"

// UpdateResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourcePolicy for more information on using the UpdateResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResourcePolicyRequest method.
//	req, resp := client.UpdateResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy
func (c *LexModelsV2) UpdateResourcePolicyRequest(input *UpdateResourcePolicyInput) (req *request.Request, output *UpdateResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateResourcePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/policy/{resourceArn}/",
	}

	if input == nil {
		input = &UpdateResourcePolicyInput{}
	}

	output = &UpdateResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResourcePolicy API operation for Amazon Lex Model Building V2.
//
// Replaces the existing resource policy for a bot or bot alias with a new one.
// If the policy doesn't exist, Amazon Lex returns an exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     You asked to describe a resource that doesn't exist. Check the resource that
//     you are requesting and try again.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy
func (c *LexModelsV2) UpdateResourcePolicy(input *UpdateResourcePolicyInput) (*UpdateResourcePolicyOutput, error) {
	req, out := c.UpdateResourcePolicyRequest(input)
	return out, req.Send()
}

// UpdateResourcePolicyWithContext is the same as UpdateResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateResourcePolicyWithContext(ctx aws.Context, input *UpdateResourcePolicyInput, opts ...request.Option) (*UpdateResourcePolicyOutput, error) {
	req, out := c.UpdateResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSlot = "UpdateSlot"

// UpdateSlotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSlot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSlot for more information on using the UpdateSlot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSlotRequest method.
//	req, resp := client.UpdateSlotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot
func (c *LexModelsV2) UpdateSlotRequest(input *UpdateSlotInput) (req *request.Request, output *UpdateSlotOutput) {
	op := &request.Operation{
		Name:       opUpdateSlot,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
	}

	if input == nil {
		input = &UpdateSlotInput{}
	}

	output = &UpdateSlotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSlot API operation for Amazon Lex Model Building V2.
//
// Updates the settings for a slot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateSlot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot
func (c *LexModelsV2) UpdateSlot(input *UpdateSlotInput) (*UpdateSlotOutput, error) {
	req, out := c.UpdateSlotRequest(input)
	return out, req.Send()
}

// UpdateSlotWithContext is the same as UpdateSlot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSlot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateSlotWithContext(ctx aws.Context, input *UpdateSlotInput, opts ...request.Option) (*UpdateSlotOutput, error) {
	req, out := c.UpdateSlotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSlotType = "UpdateSlotType"

// UpdateSlotTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSlotType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSlotType for more information on using the UpdateSlotType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSlotTypeRequest method.
//	req, resp := client.UpdateSlotTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType
func (c *LexModelsV2) UpdateSlotTypeRequest(input *UpdateSlotTypeInput) (req *request.Request, output *UpdateSlotTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateSlotType,
		HTTPMethod: "PUT",
		HTTPPath:   "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
	}

	if input == nil {
		input = &UpdateSlotTypeInput{}
	}

	output = &UpdateSlotTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSlotType API operation for Amazon Lex Model Building V2.
//
// Updates the configuration of an existing slot type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateSlotType for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType
func (c *LexModelsV2) UpdateSlotType(input *UpdateSlotTypeInput) (*UpdateSlotTypeOutput, error) {
	req, out := c.UpdateSlotTypeRequest(input)
	return out, req.Send()
}

// UpdateSlotTypeWithContext is the same as UpdateSlotType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSlotType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateSlotTypeWithContext(ctx aws.Context, input *UpdateSlotTypeInput, opts ...request.Option) (*UpdateSlotTypeOutput, error) {
	req, out := c.UpdateSlotTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTestSet = "UpdateTestSet"

// UpdateTestSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTestSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTestSet for more information on using the UpdateTestSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTestSetRequest method.
//	req, resp := client.UpdateTestSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet
func (c *LexModelsV2) UpdateTestSetRequest(input *UpdateTestSetInput) (req *request.Request, output *UpdateTestSetOutput) {
	op := &request.Operation{
		Name:       opUpdateTestSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/testsets/{testSetId}",
	}

	if input == nil {
		input = &UpdateTestSetInput{}
	}

	output = &UpdateTestSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTestSet API operation for Amazon Lex Model Building V2.
//
// The action to update the test set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lex Model Building V2's
// API operation UpdateTestSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Your request rate is too high. Reduce the frequency of requests.
//
//   - ServiceQuotaExceededException
//     You have reached a quota for your bot.
//
//   - ValidationException
//     One of the input parameters in your request isn't valid. Check the parameters
//     and try your request again.
//
//   - PreconditionFailedException
//     Your request couldn't be completed because one or more request fields aren't
//     valid. Check the fields in your request and try again.
//
//   - ConflictException
//     The action that you tried to perform couldn't be completed because the resource
//     is in a conflicting state. For example, deleting a bot that is in the CREATING
//     state. Try your request again.
//
//   - InternalServerException
//     The service encountered an unexpected condition. Try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateTestSet
func (c *LexModelsV2) UpdateTestSet(input *UpdateTestSetInput) (*UpdateTestSetOutput, error) {
	req, out := c.UpdateTestSetRequest(input)
	return out, req.Send()
}

// UpdateTestSetWithContext is the same as UpdateTestSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTestSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LexModelsV2) UpdateTestSetWithContext(ctx aws.Context, input *UpdateTestSetInput, opts ...request.Option) (*UpdateTestSetOutput, error) {
	req, out := c.UpdateTestSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The active context used in the test execution.
type ActiveContext struct {
	_ struct{} `type:"structure"`

	// The name of active context.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveContext) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ActiveContext) SetName(v string) *ActiveContext {
	s.Name = &v
	return s
}

// Provides settings that enable advanced recognition settings for slot values.
type AdvancedRecognitionSetting struct {
	_ struct{} `type:"structure"`

	// Enables using the slot values as a custom vocabulary for recognizing user
	// utterances.
	AudioRecognitionStrategy *string `locationName:"audioRecognitionStrategy" type:"string" enum:"AudioRecognitionStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedRecognitionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedRecognitionSetting) GoString() string {
	return s.String()
}

// SetAudioRecognitionStrategy sets the AudioRecognitionStrategy field's value.
func (s *AdvancedRecognitionSetting) SetAudioRecognitionStrategy(v string) *AdvancedRecognitionSetting {
	s.AudioRecognitionStrategy = &v
	return s
}

// The information about the agent turn in a test set execution.
type AgentTurnResult struct {
	_ struct{} `type:"structure"`

	// The actual agent prompt for the agent turn in a test set execution.
	ActualAgentPrompt *string `locationName:"actualAgentPrompt" min:"1" type:"string"`

	// The actual elicited slot for the agent turn in a test set execution.
	ActualElicitedSlot *string `locationName:"actualElicitedSlot" min:"1" type:"string"`

	// The actual intent for the agent turn in a test set execution.
	ActualIntent *string `locationName:"actualIntent" min:"1" type:"string"`

	// Details about an error in an execution of a test set.
	ErrorDetails *ExecutionErrorDetails `locationName:"errorDetails" type:"structure"`

	// The expected agent prompt for the agent turn in a test set execution.
	//
	// ExpectedAgentPrompt is a required field
	ExpectedAgentPrompt *string `locationName:"expectedAgentPrompt" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnResult) GoString() string {
	return s.String()
}

// SetActualAgentPrompt sets the ActualAgentPrompt field's value.
func (s *AgentTurnResult) SetActualAgentPrompt(v string) *AgentTurnResult {
	s.ActualAgentPrompt = &v
	return s
}

// SetActualElicitedSlot sets the ActualElicitedSlot field's value.
func (s *AgentTurnResult) SetActualElicitedSlot(v string) *AgentTurnResult {
	s.ActualElicitedSlot = &v
	return s
}

// SetActualIntent sets the ActualIntent field's value.
func (s *AgentTurnResult) SetActualIntent(v string) *AgentTurnResult {
	s.ActualIntent = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *AgentTurnResult) SetErrorDetails(v *ExecutionErrorDetails) *AgentTurnResult {
	s.ErrorDetails = v
	return s
}

// SetExpectedAgentPrompt sets the ExpectedAgentPrompt field's value.
func (s *AgentTurnResult) SetExpectedAgentPrompt(v string) *AgentTurnResult {
	s.ExpectedAgentPrompt = &v
	return s
}

// The specification of an agent turn.
type AgentTurnSpecification struct {
	_ struct{} `type:"structure"`

	// The agent prompt for the agent turn in a test set.
	//
	// AgentPrompt is a required field
	AgentPrompt *string `locationName:"agentPrompt" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentTurnSpecification) GoString() string {
	return s.String()
}

// SetAgentPrompt sets the AgentPrompt field's value.
func (s *AgentTurnSpecification) SetAgentPrompt(v string) *AgentTurnSpecification {
	s.AgentPrompt = &v
	return s
}

// Filters responses returned by the ListAggregatedUtterances operation.
type AggregatedUtterancesFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to filter the utterance list.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AggregatedUtterancesFilterName"`

	// The operator to use for the filter. Specify EQ when the ListAggregatedUtterances
	// operation should return only utterances that equal the specified value. Specify
	// CO when the ListAggregatedUtterances operation should return utterances that
	// contain the specified value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"AggregatedUtterancesFilterOperator"`

	// The value to use for filtering the list of bots.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregatedUtterancesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregatedUtterancesFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AggregatedUtterancesFilter) SetName(v string) *AggregatedUtterancesFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AggregatedUtterancesFilter) SetOperator(v string) *AggregatedUtterancesFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AggregatedUtterancesFilter) SetValues(v []*string) *AggregatedUtterancesFilter {
	s.Values = v
	return s
}

// Specifies attributes for sorting a list of utterances.
type AggregatedUtterancesSortBy struct {
	_ struct{} `type:"structure"`

	// The utterance attribute to sort by.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"AggregatedUtterancesSortAttribute"`

	// Specifies whether to sort the aggregated utterances in ascending or descending
	// order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregatedUtterancesSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AggregatedUtterancesSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *AggregatedUtterancesSortBy) SetAttribute(v string) *AggregatedUtterancesSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *AggregatedUtterancesSortBy) SetOrder(v string) *AggregatedUtterancesSortBy {
	s.Order = &v
	return s
}

// Provides summary information for aggregated utterances. The ListAggregatedUtterances
// operations combines all instances of the same utterance into a single aggregated
// summary.
type AggregatedUtterancesSummary struct {
	_ struct{} `type:"structure"`

	// Aggregated utterance data may contain utterances from versions of your bot
	// that have since been deleted. When the aggregated contains this kind of data,
	// this field is set to true.
	ContainsDataFromDeletedResources *bool `locationName:"containsDataFromDeletedResources" type:"boolean"`

	// The number of times that the utterance was detected by Amazon Lex during
	// the time period. When an utterance is detected, it activates an intent or
	// a slot.
	HitCount *int64 `locationName:"hitCount" type:"integer"`

	// The number of times that the utterance was missed by Amazon Lex An utterance
	// is missed when it doesn't activate an intent or slot.
	MissedCount *int64 `locationName:"missedCount" type:"integer"`

	// The text of the utterance. If the utterance was used with the RecognizeUtterance
	// operation, the text is the transcription of the audio utterance.
	Utterance *string `locationName:"utterance" type:"string"`

	// The date and time that the utterance was first recorded in the time window
	// for aggregation. An utterance may have been sent to Amazon Lex before that
	// time, but only utterances within the time window are counted.
	UtteranceFirstRecordedInAggregationDuration *time.Time `locationName:"utteranceFirstRecordedInAggregationDuration" type:"timestamp"`

	// The last date and time that an utterance was recorded in the time window
	// for aggregation. An utterance may be sent to Amazon Lex after that time,
	// but only utterances within the time window are counted.
	UtteranceLastRecordedInAggregationDuration *time.Time `locationName:"utteranceLastRecordedInAggregationDuration" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AggregatedUtterancesSummary) GoString() string {
	return s.String()
}

// SetContainsDataFromDeletedResources sets the ContainsDataFromDeletedResources field's value.
func (s *AggregatedUtterancesSummary) SetContainsDataFromDeletedResources(v bool) *AggregatedUtterancesSummary {
	s.ContainsDataFromDeletedResources = &v
	return s
}

// SetHitCount sets the HitCount field's value.
func (s *AggregatedUtterancesSummary) SetHitCount(v int64) *AggregatedUtterancesSummary {
	s.HitCount = &v
	return s
}

// SetMissedCount sets the MissedCount field's value.
func (s *AggregatedUtterancesSummary) SetMissedCount(v int64) *AggregatedUtterancesSummary {
	s.MissedCount = &v
	return s
}

// SetUtterance sets the Utterance field's value.
func (s *AggregatedUtterancesSummary) SetUtterance(v string) *AggregatedUtterancesSummary {
	s.Utterance = &v
	return s
}

// SetUtteranceFirstRecordedInAggregationDuration sets the UtteranceFirstRecordedInAggregationDuration field's value.
func (s *AggregatedUtterancesSummary) SetUtteranceFirstRecordedInAggregationDuration(v time.Time) *AggregatedUtterancesSummary {
	s.UtteranceFirstRecordedInAggregationDuration = &v
	return s
}

// SetUtteranceLastRecordedInAggregationDuration sets the UtteranceLastRecordedInAggregationDuration field's value.
func (s *AggregatedUtterancesSummary) SetUtteranceLastRecordedInAggregationDuration(v time.Time) *AggregatedUtterancesSummary {
	s.UtteranceLastRecordedInAggregationDuration = &v
	return s
}

// Specifies the allowed input types.
type AllowedInputTypes struct {
	_ struct{} `type:"structure"`

	// Indicates whether audio input is allowed.
	//
	// AllowAudioInput is a required field
	AllowAudioInput *bool `locationName:"allowAudioInput" type:"boolean" required:"true"`

	// Indicates whether DTMF input is allowed.
	//
	// AllowDTMFInput is a required field
	AllowDTMFInput *bool `locationName:"allowDTMFInput" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowedInputTypes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AllowedInputTypes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowedInputTypes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowedInputTypes"}
	if s.AllowAudioInput == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowAudioInput"))
	}
	if s.AllowDTMFInput == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowDTMFInput"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAudioInput sets the AllowAudioInput field's value.
func (s *AllowedInputTypes) SetAllowAudioInput(v bool) *AllowedInputTypes {
	s.AllowAudioInput = &v
	return s
}

// SetAllowDTMFInput sets the AllowDTMFInput field's value.
func (s *AllowedInputTypes) SetAllowDTMFInput(v bool) *AllowedInputTypes {
	s.AllowDTMFInput = &v
	return s
}

// The object containing information that associates the recommended intent/slot
// type with a conversation.
type AssociatedTranscript struct {
	_ struct{} `type:"structure"`

	// The content of the transcript that meets the search filter criteria. For
	// the JSON format of the transcript, see Output transcript format (https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html).
	Transcript *string `locationName:"transcript" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscript) GoString() string {
	return s.String()
}

// SetTranscript sets the Transcript field's value.
func (s *AssociatedTranscript) SetTranscript(v string) *AssociatedTranscript {
	s.Transcript = &v
	return s
}

// Filters to search for the associated transcript.
type AssociatedTranscriptFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to use for filtering. The allowed names are IntentId
	// and SlotTypeId.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"AssociatedTranscriptFilterName"`

	// The values to use to filter the transcript.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscriptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedTranscriptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatedTranscriptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatedTranscriptFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociatedTranscriptFilter) SetName(v string) *AssociatedTranscriptFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AssociatedTranscriptFilter) SetValues(v []*string) *AssociatedTranscriptFilter {
	s.Values = v
	return s
}

// Specifies the audio and DTMF input specification.
type AudioAndDTMFInputSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the settings on audio input.
	AudioSpecification *AudioSpecification `locationName:"audioSpecification" type:"structure"`

	// Specifies the settings on DTMF input.
	DtmfSpecification *DTMFSpecification `locationName:"dtmfSpecification" type:"structure"`

	// Time for which a bot waits before assuming that the customer isn't going
	// to speak or press a key. This timeout is shared between Audio and DTMF inputs.
	//
	// StartTimeoutMs is a required field
	StartTimeoutMs *int64 `locationName:"startTimeoutMs" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioAndDTMFInputSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioAndDTMFInputSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioAndDTMFInputSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioAndDTMFInputSpecification"}
	if s.StartTimeoutMs == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeoutMs"))
	}
	if s.StartTimeoutMs != nil && *s.StartTimeoutMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("StartTimeoutMs", 1))
	}
	if s.AudioSpecification != nil {
		if err := s.AudioSpecification.Validate(); err != nil {
			invalidParams.AddNested("AudioSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.DtmfSpecification != nil {
		if err := s.DtmfSpecification.Validate(); err != nil {
			invalidParams.AddNested("DtmfSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSpecification sets the AudioSpecification field's value.
func (s *AudioAndDTMFInputSpecification) SetAudioSpecification(v *AudioSpecification) *AudioAndDTMFInputSpecification {
	s.AudioSpecification = v
	return s
}

// SetDtmfSpecification sets the DtmfSpecification field's value.
func (s *AudioAndDTMFInputSpecification) SetDtmfSpecification(v *DTMFSpecification) *AudioAndDTMFInputSpecification {
	s.DtmfSpecification = v
	return s
}

// SetStartTimeoutMs sets the StartTimeoutMs field's value.
func (s *AudioAndDTMFInputSpecification) SetStartTimeoutMs(v int64) *AudioAndDTMFInputSpecification {
	s.StartTimeoutMs = &v
	return s
}

// The location of audio log files collected when conversation logging is enabled
// for a bot.
type AudioLogDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the audio log files are stored. The IAM role specified
	// in the roleArn parameter of the CreateBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html)
	// operation must have permission to write to this bucket.
	//
	// S3Bucket is a required field
	S3Bucket *S3BucketLogDestination `locationName:"s3Bucket" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLogDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLogDestination"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil {
		if err := s.S3Bucket.Validate(); err != nil {
			invalidParams.AddNested("S3Bucket", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *AudioLogDestination) SetS3Bucket(v *S3BucketLogDestination) *AudioLogDestination {
	s.S3Bucket = v
	return s
}

// Settings for logging audio of conversations between Amazon Lex and a user.
// You specify whether to log audio and the Amazon S3 bucket where the audio
// file is stored.
type AudioLogSetting struct {
	_ struct{} `type:"structure"`

	// The location of audio log files collected when conversation logging is enabled
	// for a bot.
	//
	// Destination is a required field
	Destination *AudioLogDestination `locationName:"destination" type:"structure" required:"true"`

	// Determines whether audio logging in enabled for the bot.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLogSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLogSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLogSetting"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *AudioLogSetting) SetDestination(v *AudioLogDestination) *AudioLogSetting {
	s.Destination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AudioLogSetting) SetEnabled(v bool) *AudioLogSetting {
	s.Enabled = &v
	return s
}

// Specifies the audio input specifications.
type AudioSpecification struct {
	_ struct{} `type:"structure"`

	// Time for which a bot waits after the customer stops speaking to assume the
	// utterance is finished.
	//
	// EndTimeoutMs is a required field
	EndTimeoutMs *int64 `locationName:"endTimeoutMs" min:"1" type:"integer" required:"true"`

	// Time for how long Amazon Lex waits before speech input is truncated and the
	// speech is returned to application.
	//
	// MaxLengthMs is a required field
	MaxLengthMs *int64 `locationName:"maxLengthMs" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSpecification"}
	if s.EndTimeoutMs == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeoutMs"))
	}
	if s.EndTimeoutMs != nil && *s.EndTimeoutMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EndTimeoutMs", 1))
	}
	if s.MaxLengthMs == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxLengthMs"))
	}
	if s.MaxLengthMs != nil && *s.MaxLengthMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxLengthMs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTimeoutMs sets the EndTimeoutMs field's value.
func (s *AudioSpecification) SetEndTimeoutMs(v int64) *AudioSpecification {
	s.EndTimeoutMs = &v
	return s
}

// SetMaxLengthMs sets the MaxLengthMs field's value.
func (s *AudioSpecification) SetMaxLengthMs(v int64) *AudioSpecification {
	s.MaxLengthMs = &v
	return s
}

type BatchCreateCustomVocabularyItemInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// A list of new custom vocabulary items. Each entry must contain a phrase and
	// can optionally contain a displayAs and/or a weight.
	//
	// CustomVocabularyItemList is a required field
	CustomVocabularyItemList []*NewCustomVocabularyItem `locationName:"customVocabularyItemList" min:"1" type:"list" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateCustomVocabularyItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateCustomVocabularyItemInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.CustomVocabularyItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomVocabularyItemList"))
	}
	if s.CustomVocabularyItemList != nil && len(s.CustomVocabularyItemList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomVocabularyItemList", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.CustomVocabularyItemList != nil {
		for i, v := range s.CustomVocabularyItemList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomVocabularyItemList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetBotId(v string) *BatchCreateCustomVocabularyItemInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetBotVersion(v string) *BatchCreateCustomVocabularyItemInput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItemList sets the CustomVocabularyItemList field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetCustomVocabularyItemList(v []*NewCustomVocabularyItem) *BatchCreateCustomVocabularyItemInput {
	s.CustomVocabularyItemList = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchCreateCustomVocabularyItemInput) SetLocaleId(v string) *BatchCreateCustomVocabularyItemInput {
	s.LocaleId = &v
	return s
}

type BatchCreateCustomVocabularyItemOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A list of custom vocabulary items that failed to create during the operation.
	// The reason for the error is contained within each error object.
	Errors []*FailedCustomVocabularyItem `locationName:"errors" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of custom vocabulary items that were successfully created during the
	// operation.
	Resources []*CustomVocabularyItem `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateCustomVocabularyItemOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetBotId(v string) *BatchCreateCustomVocabularyItemOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetBotVersion(v string) *BatchCreateCustomVocabularyItemOutput {
	s.BotVersion = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetErrors(v []*FailedCustomVocabularyItem) *BatchCreateCustomVocabularyItemOutput {
	s.Errors = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetLocaleId(v string) *BatchCreateCustomVocabularyItemOutput {
	s.LocaleId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchCreateCustomVocabularyItemOutput) SetResources(v []*CustomVocabularyItem) *BatchCreateCustomVocabularyItemOutput {
	s.Resources = v
	return s
}

type BatchDeleteCustomVocabularyItemInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// A list of custom vocabulary items requested to be deleted. Each entry must
	// contain the unique custom vocabulary entry identifier.
	//
	// CustomVocabularyItemList is a required field
	CustomVocabularyItemList []*CustomVocabularyEntryId `locationName:"customVocabularyItemList" min:"1" type:"list" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteCustomVocabularyItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteCustomVocabularyItemInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.CustomVocabularyItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomVocabularyItemList"))
	}
	if s.CustomVocabularyItemList != nil && len(s.CustomVocabularyItemList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomVocabularyItemList", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.CustomVocabularyItemList != nil {
		for i, v := range s.CustomVocabularyItemList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomVocabularyItemList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetBotId(v string) *BatchDeleteCustomVocabularyItemInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetBotVersion(v string) *BatchDeleteCustomVocabularyItemInput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItemList sets the CustomVocabularyItemList field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetCustomVocabularyItemList(v []*CustomVocabularyEntryId) *BatchDeleteCustomVocabularyItemInput {
	s.CustomVocabularyItemList = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchDeleteCustomVocabularyItemInput) SetLocaleId(v string) *BatchDeleteCustomVocabularyItemInput {
	s.LocaleId = &v
	return s
}

type BatchDeleteCustomVocabularyItemOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A list of custom vocabulary items that failed to delete during the operation.
	// The reason for the error is contained within each error object.
	Errors []*FailedCustomVocabularyItem `locationName:"errors" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of custom vocabulary items that were successfully deleted during the
	// operation.
	Resources []*CustomVocabularyItem `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteCustomVocabularyItemOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetBotId(v string) *BatchDeleteCustomVocabularyItemOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetBotVersion(v string) *BatchDeleteCustomVocabularyItemOutput {
	s.BotVersion = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetErrors(v []*FailedCustomVocabularyItem) *BatchDeleteCustomVocabularyItemOutput {
	s.Errors = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetLocaleId(v string) *BatchDeleteCustomVocabularyItemOutput {
	s.LocaleId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchDeleteCustomVocabularyItemOutput) SetResources(v []*CustomVocabularyItem) *BatchDeleteCustomVocabularyItemOutput {
	s.Resources = v
	return s
}

type BatchUpdateCustomVocabularyItemInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// A list of custom vocabulary items with updated fields. Each entry must contain
	// a phrase and can optionally contain a displayAs and/or a weight.
	//
	// CustomVocabularyItemList is a required field
	CustomVocabularyItemList []*CustomVocabularyItem `locationName:"customVocabularyItemList" min:"1" type:"list" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateCustomVocabularyItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateCustomVocabularyItemInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.CustomVocabularyItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomVocabularyItemList"))
	}
	if s.CustomVocabularyItemList != nil && len(s.CustomVocabularyItemList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomVocabularyItemList", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.CustomVocabularyItemList != nil {
		for i, v := range s.CustomVocabularyItemList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomVocabularyItemList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetBotId(v string) *BatchUpdateCustomVocabularyItemInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetBotVersion(v string) *BatchUpdateCustomVocabularyItemInput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItemList sets the CustomVocabularyItemList field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetCustomVocabularyItemList(v []*CustomVocabularyItem) *BatchUpdateCustomVocabularyItemInput {
	s.CustomVocabularyItemList = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchUpdateCustomVocabularyItemInput) SetLocaleId(v string) *BatchUpdateCustomVocabularyItemInput {
	s.LocaleId = &v
	return s
}

type BatchUpdateCustomVocabularyItemOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A list of custom vocabulary items that failed to update during the operation.
	// The reason for the error is contained within each error object.
	Errors []*FailedCustomVocabularyItem `locationName:"errors" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of custom vocabulary items that were successfully updated during the
	// operation.
	Resources []*CustomVocabularyItem `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateCustomVocabularyItemOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetBotId(v string) *BatchUpdateCustomVocabularyItemOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetBotVersion(v string) *BatchUpdateCustomVocabularyItemOutput {
	s.BotVersion = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetErrors(v []*FailedCustomVocabularyItem) *BatchUpdateCustomVocabularyItemOutput {
	s.Errors = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetLocaleId(v string) *BatchUpdateCustomVocabularyItemOutput {
	s.LocaleId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *BatchUpdateCustomVocabularyItemOutput) SetResources(v []*CustomVocabularyItem) *BatchUpdateCustomVocabularyItemOutput {
	s.Resources = v
	return s
}

// Provides a record of an event that affects a bot alias. For example, when
// the version of a bot that the alias points to changes.
type BotAliasHistoryEvent struct {
	_ struct{} `type:"structure"`

	// The version of the bot that was used in the event.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time that the event ended.
	EndDate *time.Time `locationName:"endDate" type:"timestamp"`

	// The date and time that the event started.
	StartDate *time.Time `locationName:"startDate" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasHistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasHistoryEvent) GoString() string {
	return s.String()
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotAliasHistoryEvent) SetBotVersion(v string) *BotAliasHistoryEvent {
	s.BotVersion = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *BotAliasHistoryEvent) SetEndDate(v time.Time) *BotAliasHistoryEvent {
	s.EndDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *BotAliasHistoryEvent) SetStartDate(v time.Time) *BotAliasHistoryEvent {
	s.StartDate = &v
	return s
}

// Specifies settings that are unique to a locale. For example, you can use
// different Lambda function depending on the bot's locale.
type BotAliasLocaleSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the Lambda function that should be used in the locale.
	CodeHookSpecification *CodeHookSpecification `locationName:"codeHookSpecification" type:"structure"`

	// Determines whether the locale is enabled for the bot. If the value is false,
	// the locale isn't available for use.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasLocaleSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasLocaleSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotAliasLocaleSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotAliasLocaleSettings"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.CodeHookSpecification != nil {
		if err := s.CodeHookSpecification.Validate(); err != nil {
			invalidParams.AddNested("CodeHookSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeHookSpecification sets the CodeHookSpecification field's value.
func (s *BotAliasLocaleSettings) SetCodeHookSpecification(v *CodeHookSpecification) *BotAliasLocaleSettings {
	s.CodeHookSpecification = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BotAliasLocaleSettings) SetEnabled(v bool) *BotAliasLocaleSettings {
	s.Enabled = &v
	return s
}

// Summary information about bot aliases returned from the ListBotAliases (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotAliases.html)
// operation.
type BotAliasSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned to the bot alias. You can use this ID to get
	// detailed information about the alias using the DescribeBotAlias (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotAlias.html)
	// operation.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The name of the bot alias.
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string"`

	// The current state of the bot alias. If the status is Available, the alias
	// is ready for use.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The version of the bot that the bot alias references.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the bot alias was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// A timestamp of the date and time that the bot alias was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasSummary) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *BotAliasSummary) SetBotAliasId(v string) *BotAliasSummary {
	s.BotAliasId = &v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *BotAliasSummary) SetBotAliasName(v string) *BotAliasSummary {
	s.BotAliasName = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *BotAliasSummary) SetBotAliasStatus(v string) *BotAliasSummary {
	s.BotAliasStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotAliasSummary) SetBotVersion(v string) *BotAliasSummary {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotAliasSummary) SetCreationDateTime(v time.Time) *BotAliasSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotAliasSummary) SetDescription(v string) *BotAliasSummary {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotAliasSummary) SetLastUpdatedDateTime(v time.Time) *BotAliasSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// The target Amazon S3 location for the test set execution using a bot alias.
type BotAliasTestExecutionTarget struct {
	_ struct{} `type:"structure"`

	// The bot alias Id of the bot alias used in the test set execution.
	//
	// BotAliasId is a required field
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The bot Id of the bot alias used in the test set execution.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The locale Id of the bot alias used in the test set execution.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasTestExecutionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotAliasTestExecutionTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotAliasTestExecutionTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotAliasTestExecutionTarget"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *BotAliasTestExecutionTarget) SetBotAliasId(v string) *BotAliasTestExecutionTarget {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *BotAliasTestExecutionTarget) SetBotId(v string) *BotAliasTestExecutionTarget {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotAliasTestExecutionTarget) SetLocaleId(v string) *BotAliasTestExecutionTarget {
	s.LocaleId = &v
	return s
}

// Provides the identity of a the bot that was exported.
type BotExportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot assigned by Amazon Lex.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that was exported. This will be either DRAFT or the
	// version number.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotExportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotExportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotExportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotExportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BotExportSpecification) SetBotId(v string) *BotExportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotExportSpecification) SetBotVersion(v string) *BotExportSpecification {
	s.BotVersion = &v
	return s
}

// Filters the responses returned by the ListBots operation.
type BotFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to filter the list of bots.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"BotFilterName"`

	// The operator to use for the filter. Specify EQ when the ListBots operation
	// should return only aliases that equal the specified value. Specify CO when
	// the ListBots operation should return aliases that contain the specified value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"BotFilterOperator"`

	// The value to use for filtering the list of bots.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BotFilter) SetName(v string) *BotFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *BotFilter) SetOperator(v string) *BotFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *BotFilter) SetValues(v []*string) *BotFilter {
	s.Values = v
	return s
}

// Provides the bot parameters required for importing a bot.
type BotImportSpecification struct {
	_ struct{} `type:"structure"`

	// The name that Amazon Lex should use for the bot.
	//
	// BotName is a required field
	BotName *string `locationName:"botName" min:"1" type:"string" required:"true"`

	// A list of tags to add to the bot. You can only add tags when you import a
	// bot. You can't use the UpdateBot operation to update tags. To update tags,
	// use the TagResource operation.
	BotTags map[string]*string `locationName:"botTags" type:"map"`

	// By default, data stored by Amazon Lex is encrypted. The DataPrivacy structure
	// provides settings that determine how Amazon Lex handles special cases of
	// securing the data for your bot.
	//
	// DataPrivacy is a required field
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure" required:"true"`

	// The time, in seconds, that Amazon Lex should keep information about a user's
	// conversation with the bot.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Lex
	// deletes any data provided before the timeout.
	//
	// You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role used to build and run the
	// bot.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// A list of tags to add to the test alias for a bot. You can only add tags
	// when you import a bot. You can't use the UpdateAlias operation to update
	// tags. To update tags on the test alias, use the TagResource operation.
	TestBotAliasTags map[string]*string `locationName:"testBotAliasTags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotImportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotImportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotImportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotImportSpecification"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 1))
	}
	if s.DataPrivacy == nil {
		invalidParams.Add(request.NewErrParamRequired("DataPrivacy"))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.DataPrivacy != nil {
		if err := s.DataPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DataPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotName sets the BotName field's value.
func (s *BotImportSpecification) SetBotName(v string) *BotImportSpecification {
	s.BotName = &v
	return s
}

// SetBotTags sets the BotTags field's value.
func (s *BotImportSpecification) SetBotTags(v map[string]*string) *BotImportSpecification {
	s.BotTags = v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *BotImportSpecification) SetDataPrivacy(v *DataPrivacy) *BotImportSpecification {
	s.DataPrivacy = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *BotImportSpecification) SetIdleSessionTTLInSeconds(v int64) *BotImportSpecification {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BotImportSpecification) SetRoleArn(v string) *BotImportSpecification {
	s.RoleArn = &v
	return s
}

// SetTestBotAliasTags sets the TestBotAliasTags field's value.
func (s *BotImportSpecification) SetTestBotAliasTags(v map[string]*string) *BotImportSpecification {
	s.TestBotAliasTags = v
	return s
}

// Provides the bot locale parameters required for exporting a bot locale.
type BotLocaleExportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to create the locale for.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to export.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the language and locale to export. The string must match
	// one of the locales in the bot.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleExportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleExportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleExportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleExportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BotLocaleExportSpecification) SetBotId(v string) *BotLocaleExportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotLocaleExportSpecification) SetBotVersion(v string) *BotLocaleExportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotLocaleExportSpecification) SetLocaleId(v string) *BotLocaleExportSpecification {
	s.LocaleId = &v
	return s
}

// Filters responses returned by the ListBotLocales operation.
type BotLocaleFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to filter the list of bots.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"BotLocaleFilterName"`

	// The operator to use for the filter. Specify EQ when the ListBotLocales operation
	// should return only aliases that equal the specified value. Specify CO when
	// the ListBotLocales operation should return aliases that contain the specified
	// value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"BotLocaleFilterOperator"`

	// The value to use for filtering the list of bots.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BotLocaleFilter) SetName(v string) *BotLocaleFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *BotLocaleFilter) SetOperator(v string) *BotLocaleFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *BotLocaleFilter) SetValues(v []*string) *BotLocaleFilter {
	s.Values = v
	return s
}

// Provides information about an event that occurred affecting the bot locale.
type BotLocaleHistoryEvent struct {
	_ struct{} `type:"structure"`

	// A description of the event that occurred.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true"`

	// A timestamp of the date and time that the event occurred.
	//
	// EventDate is a required field
	EventDate *time.Time `locationName:"eventDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleHistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleHistoryEvent) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *BotLocaleHistoryEvent) SetEvent(v string) *BotLocaleHistoryEvent {
	s.Event = &v
	return s
}

// SetEventDate sets the EventDate field's value.
func (s *BotLocaleHistoryEvent) SetEventDate(v time.Time) *BotLocaleHistoryEvent {
	s.EventDate = &v
	return s
}

// Provides the bot locale parameters required for importing a bot locale.
type BotLocaleImportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to import the locale to.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to import the locale to. This can only be the DRAFT
	// version of the bot.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot
	// types, and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`

	// Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent,
	// AMAZON.KendraSearchIntent, or both when returning alternative intents. AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent are only inserted if they are configured for
	// the bot.
	//
	// For example, suppose a bot is configured with the confidence threshold of
	// 0.80 and the AMAZON.FallbackIntent. Amazon Lex returns three alternative
	// intents with the following confidence scores: IntentA (0.70), IntentB (0.60),
	// IntentC (0.50). The response from the PostText operation would be:
	//
	//    * AMAZON.FallbackIntent
	//
	//    * IntentA
	//
	//    * IntentB
	//
	//    * IntentC
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double"`

	// Defines settings for using an Amazon Polly voice to communicate with a user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleImportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleImportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleImportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleImportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.VoiceSettings != nil {
		if err := s.VoiceSettings.Validate(); err != nil {
			invalidParams.AddNested("VoiceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BotLocaleImportSpecification) SetBotId(v string) *BotLocaleImportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotLocaleImportSpecification) SetBotVersion(v string) *BotLocaleImportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotLocaleImportSpecification) SetLocaleId(v string) *BotLocaleImportSpecification {
	s.LocaleId = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *BotLocaleImportSpecification) SetNluIntentConfidenceThreshold(v float64) *BotLocaleImportSpecification {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *BotLocaleImportSpecification) SetVoiceSettings(v *VoiceSettings) *BotLocaleImportSpecification {
	s.VoiceSettings = v
	return s
}

// Specifies attributes for sorting a list of bot locales.
type BotLocaleSortBy struct {
	_ struct{} `type:"structure"`

	// The bot locale attribute to sort by.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotLocaleSortAttribute"`

	// Specifies whether to sort the bot locales in ascending or descending order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotLocaleSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotLocaleSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotLocaleSortBy) SetAttribute(v string) *BotLocaleSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotLocaleSortBy) SetOrder(v string) *BotLocaleSortBy {
	s.Order = &v
	return s
}

// Summary information about bot locales returned by the ListBotLocales (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotLocales.html)
// operation.
type BotLocaleSummary struct {
	_ struct{} `type:"structure"`

	// The current status of the bot locale. When the status is Built the locale
	// is ready for use.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The description of the bot locale.
	Description *string `locationName:"description" type:"string"`

	// A timestamp of the date and time that the bot locale was last built.
	LastBuildSubmittedDateTime *time.Time `locationName:"lastBuildSubmittedDateTime" type:"timestamp"`

	// A timestamp of the date and time that the bot locale was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale of the bot locale.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The name of the bot locale.
	LocaleName *string `locationName:"localeName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotLocaleSummary) GoString() string {
	return s.String()
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *BotLocaleSummary) SetBotLocaleStatus(v string) *BotLocaleSummary {
	s.BotLocaleStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotLocaleSummary) SetDescription(v string) *BotLocaleSummary {
	s.Description = &v
	return s
}

// SetLastBuildSubmittedDateTime sets the LastBuildSubmittedDateTime field's value.
func (s *BotLocaleSummary) SetLastBuildSubmittedDateTime(v time.Time) *BotLocaleSummary {
	s.LastBuildSubmittedDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotLocaleSummary) SetLastUpdatedDateTime(v time.Time) *BotLocaleSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BotLocaleSummary) SetLocaleId(v string) *BotLocaleSummary {
	s.LocaleId = &v
	return s
}

// SetLocaleName sets the LocaleName field's value.
func (s *BotLocaleSummary) SetLocaleName(v string) *BotLocaleSummary {
	s.LocaleName = &v
	return s
}

// A bot that is a member of a network of bots.
type BotMember struct {
	_ struct{} `type:"structure"`

	// The alias ID of a bot that is a member of this network of bots.
	//
	// BotMemberAliasId is a required field
	BotMemberAliasId *string `locationName:"botMemberAliasId" min:"10" type:"string" required:"true"`

	// The alias name of a bot that is a member of this network of bots.
	//
	// BotMemberAliasName is a required field
	BotMemberAliasName *string `locationName:"botMemberAliasName" min:"1" type:"string" required:"true"`

	// The unique ID of a bot that is a member of this network of bots.
	//
	// BotMemberId is a required field
	BotMemberId *string `locationName:"botMemberId" min:"10" type:"string" required:"true"`

	// The unique name of a bot that is a member of this network of bots.
	//
	// BotMemberName is a required field
	BotMemberName *string `locationName:"botMemberName" min:"1" type:"string" required:"true"`

	// The version of a bot that is a member of this network of bots.
	//
	// BotMemberVersion is a required field
	BotMemberVersion *string `locationName:"botMemberVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotMember"}
	if s.BotMemberAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberAliasId"))
	}
	if s.BotMemberAliasId != nil && len(*s.BotMemberAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberAliasId", 10))
	}
	if s.BotMemberAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberAliasName"))
	}
	if s.BotMemberAliasName != nil && len(*s.BotMemberAliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberAliasName", 1))
	}
	if s.BotMemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberId"))
	}
	if s.BotMemberId != nil && len(*s.BotMemberId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberId", 10))
	}
	if s.BotMemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberName"))
	}
	if s.BotMemberName != nil && len(*s.BotMemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberName", 1))
	}
	if s.BotMemberVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotMemberVersion"))
	}
	if s.BotMemberVersion != nil && len(*s.BotMemberVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotMemberVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotMemberAliasId sets the BotMemberAliasId field's value.
func (s *BotMember) SetBotMemberAliasId(v string) *BotMember {
	s.BotMemberAliasId = &v
	return s
}

// SetBotMemberAliasName sets the BotMemberAliasName field's value.
func (s *BotMember) SetBotMemberAliasName(v string) *BotMember {
	s.BotMemberAliasName = &v
	return s
}

// SetBotMemberId sets the BotMemberId field's value.
func (s *BotMember) SetBotMemberId(v string) *BotMember {
	s.BotMemberId = &v
	return s
}

// SetBotMemberName sets the BotMemberName field's value.
func (s *BotMember) SetBotMemberName(v string) *BotMember {
	s.BotMemberName = &v
	return s
}

// SetBotMemberVersion sets the BotMemberVersion field's value.
func (s *BotMember) SetBotMemberVersion(v string) *BotMember {
	s.BotMemberVersion = &v
	return s
}

// A statistical summary of the bot recommendation results.
type BotRecommendationResultStatistics struct {
	_ struct{} `type:"structure"`

	// Statistical information about about the intents associated with the bot recommendation
	// results.
	Intents *IntentStatistics `locationName:"intents" type:"structure"`

	// Statistical information about the slot types associated with the bot recommendation
	// results.
	SlotTypes *SlotTypeStatistics `locationName:"slotTypes" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResultStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResultStatistics) GoString() string {
	return s.String()
}

// SetIntents sets the Intents field's value.
func (s *BotRecommendationResultStatistics) SetIntents(v *IntentStatistics) *BotRecommendationResultStatistics {
	s.Intents = v
	return s
}

// SetSlotTypes sets the SlotTypes field's value.
func (s *BotRecommendationResultStatistics) SetSlotTypes(v *SlotTypeStatistics) *BotRecommendationResultStatistics {
	s.SlotTypes = v
	return s
}

// The object representing the URL of the bot definition, the URL of the associated
// transcript, and a statistical summary of the bot recommendation results.
type BotRecommendationResults struct {
	_ struct{} `type:"structure"`

	// The presigned url link of the associated transcript.
	AssociatedTranscriptsUrl *string `locationName:"associatedTranscriptsUrl" min:"1" type:"string"`

	// The presigned URL link of the recommended bot definition.
	BotLocaleExportUrl *string `locationName:"botLocaleExportUrl" min:"1" type:"string"`

	// The statistical summary of the bot recommendation results.
	Statistics *BotRecommendationResultStatistics `locationName:"statistics" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationResults) GoString() string {
	return s.String()
}

// SetAssociatedTranscriptsUrl sets the AssociatedTranscriptsUrl field's value.
func (s *BotRecommendationResults) SetAssociatedTranscriptsUrl(v string) *BotRecommendationResults {
	s.AssociatedTranscriptsUrl = &v
	return s
}

// SetBotLocaleExportUrl sets the BotLocaleExportUrl field's value.
func (s *BotRecommendationResults) SetBotLocaleExportUrl(v string) *BotRecommendationResults {
	s.BotLocaleExportUrl = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *BotRecommendationResults) SetStatistics(v *BotRecommendationResultStatistics) *BotRecommendationResults {
	s.Statistics = v
	return s
}

// A summary of the bot recommendation.
type BotRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot recommendation to be updated.
	//
	// BotRecommendationId is a required field
	BotRecommendationId *string `locationName:"botRecommendationId" min:"10" type:"string" required:"true"`

	// The status of the bot recommendation.
	//
	// If the status is Failed, then the reasons for the failure are listed in the
	// failureReasons field.
	//
	// BotRecommendationStatus is a required field
	BotRecommendationStatus *string `locationName:"botRecommendationStatus" type:"string" required:"true" enum:"BotRecommendationStatus"`

	// A timestamp of the date and time that the bot recommendation was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// A timestamp of the date and time that the bot recommendation was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotRecommendationSummary) GoString() string {
	return s.String()
}

// SetBotRecommendationId sets the BotRecommendationId field's value.
func (s *BotRecommendationSummary) SetBotRecommendationId(v string) *BotRecommendationSummary {
	s.BotRecommendationId = &v
	return s
}

// SetBotRecommendationStatus sets the BotRecommendationStatus field's value.
func (s *BotRecommendationSummary) SetBotRecommendationStatus(v string) *BotRecommendationSummary {
	s.BotRecommendationStatus = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotRecommendationSummary) SetCreationDateTime(v time.Time) *BotRecommendationSummary {
	s.CreationDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotRecommendationSummary) SetLastUpdatedDateTime(v time.Time) *BotRecommendationSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// Specifies attributes for sorting a list of bots.
type BotSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of bots.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotSortAttribute"`

	// The order to sort the list. You can choose ascending or descending.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotSortBy) SetAttribute(v string) *BotSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotSortBy) SetOrder(v string) *BotSortBy {
	s.Order = &v
	return s
}

// Summary information about a bot returned by the ListBots (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBots.html)
// operation.
type BotSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned to the bot. Use this ID to get detailed information
	// about the bot with the DescribeBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBot.html)
	// operation.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The name of the bot.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The current status of the bot. When the status is Available the bot is ready
	// for use.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The type of the bot.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// The description of the bot.
	Description *string `locationName:"description" type:"string"`

	// The date and time that the bot was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The latest numerical version in use for the bot.
	LatestBotVersion *string `locationName:"latestBotVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotSummary) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BotSummary) SetBotId(v string) *BotSummary {
	s.BotId = &v
	return s
}

// SetBotName sets the BotName field's value.
func (s *BotSummary) SetBotName(v string) *BotSummary {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *BotSummary) SetBotStatus(v string) *BotSummary {
	s.BotStatus = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *BotSummary) SetBotType(v string) *BotSummary {
	s.BotType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotSummary) SetDescription(v string) *BotSummary {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *BotSummary) SetLastUpdatedDateTime(v time.Time) *BotSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLatestBotVersion sets the LatestBotVersion field's value.
func (s *BotSummary) SetLatestBotVersion(v string) *BotSummary {
	s.LatestBotVersion = &v
	return s
}

// The version of a bot used for a bot locale.
type BotVersionLocaleDetails struct {
	_ struct{} `type:"structure"`

	// The version of a bot used for a bot locale.
	//
	// SourceBotVersion is a required field
	SourceBotVersion *string `locationName:"sourceBotVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionLocaleDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionLocaleDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotVersionLocaleDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotVersionLocaleDetails"}
	if s.SourceBotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceBotVersion"))
	}
	if s.SourceBotVersion != nil && len(*s.SourceBotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceBotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceBotVersion sets the SourceBotVersion field's value.
func (s *BotVersionLocaleDetails) SetSourceBotVersion(v string) *BotVersionLocaleDetails {
	s.SourceBotVersion = &v
	return s
}

// Specifies attributes for sorting a list of bot versions.
type BotVersionSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of versions.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BotVersionSortAttribute"`

	// The order to sort the list. You can specify ascending or descending order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BotVersionSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BotVersionSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BotVersionSortBy) SetAttribute(v string) *BotVersionSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BotVersionSortBy) SetOrder(v string) *BotVersionSortBy {
	s.Order = &v
	return s
}

// Summary information about a bot version returned by the ListBotVersions (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersions.html)
// operation.
type BotVersionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the bot associated with the version.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The status of the bot. When the status is available, the version of the bot
	// is ready for use.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The numeric version of the bot, or DRAFT to indicate that this is the version
	// of the bot that can be updated..
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the version was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the version.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BotVersionSummary) GoString() string {
	return s.String()
}

// SetBotName sets the BotName field's value.
func (s *BotVersionSummary) SetBotName(v string) *BotVersionSummary {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *BotVersionSummary) SetBotStatus(v string) *BotVersionSummary {
	s.BotStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BotVersionSummary) SetBotVersion(v string) *BotVersionSummary {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *BotVersionSummary) SetCreationDateTime(v time.Time) *BotVersionSummary {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BotVersionSummary) SetDescription(v string) *BotVersionSummary {
	s.Description = &v
	return s
}

type BuildBotLocaleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot to build. The identifier is returned in the response
	// from the CreateBot (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html)
	// operation.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to build. This can only be the draft version of the
	// bot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot
	// types, and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuildBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuildBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *BuildBotLocaleInput) SetBotId(v string) *BuildBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BuildBotLocaleInput) SetBotVersion(v string) *BuildBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BuildBotLocaleInput) SetLocaleId(v string) *BuildBotLocaleInput {
	s.LocaleId = &v
	return s
}

type BuildBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the specified bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The bot's build status. When the status is ReadyExpressTesting you can test
	// the bot using the utterances defined for the intents and slot types. When
	// the status is Built, the bot is ready for use and can be tested using any
	// utterance.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The version of the bot that was built. This is only the draft version of
	// the bot.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp indicating the date and time that the bot was last built for
	// this locale.
	LastBuildSubmittedDateTime *time.Time `locationName:"lastBuildSubmittedDateTime" type:"timestamp"`

	// The language and locale specified of where the bot can be used.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuildBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *BuildBotLocaleOutput) SetBotId(v string) *BuildBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *BuildBotLocaleOutput) SetBotLocaleStatus(v string) *BuildBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *BuildBotLocaleOutput) SetBotVersion(v string) *BuildBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetLastBuildSubmittedDateTime sets the LastBuildSubmittedDateTime field's value.
func (s *BuildBotLocaleOutput) SetLastBuildSubmittedDateTime(v time.Time) *BuildBotLocaleOutput {
	s.LastBuildSubmittedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *BuildBotLocaleOutput) SetLocaleId(v string) *BuildBotLocaleOutput {
	s.LocaleId = &v
	return s
}

// Specifies attributes for sorting a list of built-in intents.
type BuiltInIntentSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of built-in intents.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BuiltInIntentSortAttribute"`

	// The order to sort the list. You can specify ascending or descending order.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuiltInIntentSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuiltInIntentSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BuiltInIntentSortBy) SetAttribute(v string) *BuiltInIntentSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BuiltInIntentSortBy) SetOrder(v string) *BuiltInIntentSortBy {
	s.Order = &v
	return s
}

// Provides summary information about a built-in intent for the ListBuiltInIntents
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInIntents.html)
// operation.
type BuiltInIntentSummary struct {
	_ struct{} `type:"structure"`

	// The description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The signature of the built-in intent. Use this to specify the parent intent
	// of a derived intent.
	IntentSignature *string `locationName:"intentSignature" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInIntentSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *BuiltInIntentSummary) SetDescription(v string) *BuiltInIntentSummary {
	s.Description = &v
	return s
}

// SetIntentSignature sets the IntentSignature field's value.
func (s *BuiltInIntentSummary) SetIntentSignature(v string) *BuiltInIntentSummary {
	s.IntentSignature = &v
	return s
}

// Specifies attributes for sorting a list of built-in slot types.
type BuiltInSlotTypeSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of built-in intents.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"BuiltInSlotTypeSortAttribute"`

	// The order to sort the list. You can choose ascending or descending.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BuiltInSlotTypeSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BuiltInSlotTypeSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *BuiltInSlotTypeSortBy) SetAttribute(v string) *BuiltInSlotTypeSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *BuiltInSlotTypeSortBy) SetOrder(v string) *BuiltInSlotTypeSortBy {
	s.Order = &v
	return s
}

// Provides summary information about a built-in slot type for the ListBuiltInSlotTypes
// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInSlotTypes.html)
// operation.
type BuiltInSlotTypeSummary struct {
	_ struct{} `type:"structure"`

	// The description of the built-in slot type.
	Description *string `locationName:"description" type:"string"`

	// The signature of the built-in slot type. Use this to specify the parent slot
	// type of a derived slot type.
	SlotTypeSignature *string `locationName:"slotTypeSignature" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BuiltInSlotTypeSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *BuiltInSlotTypeSummary) SetDescription(v string) *BuiltInSlotTypeSummary {
	s.Description = &v
	return s
}

// SetSlotTypeSignature sets the SlotTypeSignature field's value.
func (s *BuiltInSlotTypeSummary) SetSlotTypeSignature(v string) *BuiltInSlotTypeSummary {
	s.SlotTypeSignature = &v
	return s
}

// Describes a button to use on a response card used to gather slot values from
// a user.
type Button struct {
	_ struct{} `type:"structure"`

	// The text that appears on the button. Use this to tell the user what value
	// is returned when they choose this button.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`

	// The value returned to Amazon Lex when the user chooses this button. This
	// must be one of the slot values configured for the slot.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Button) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Button) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Button) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Button"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *Button) SetText(v string) *Button {
	s.Text = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Button) SetValue(v string) *Button {
	s.Value = &v
	return s
}

// The Amazon CloudWatch Logs log group where the text and metadata logs are
// delivered. The log group must exist before you enable logging.
type CloudWatchLogGroupLogDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the log group where text and metadata logs
	// are delivered.
	//
	// CloudWatchLogGroupArn is a required field
	CloudWatchLogGroupArn *string `locationName:"cloudWatchLogGroupArn" min:"1" type:"string" required:"true"`

	// The prefix of the log stream name within the log group that you specified
	//
	// LogPrefix is a required field
	LogPrefix *string `locationName:"logPrefix" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogGroupLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLogGroupLogDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLogGroupLogDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLogGroupLogDestination"}
	if s.CloudWatchLogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogGroupArn"))
	}
	if s.CloudWatchLogGroupArn != nil && len(*s.CloudWatchLogGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogGroupArn", 1))
	}
	if s.LogPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("LogPrefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupArn sets the CloudWatchLogGroupArn field's value.
func (s *CloudWatchLogGroupLogDestination) SetCloudWatchLogGroupArn(v string) *CloudWatchLogGroupLogDestination {
	s.CloudWatchLogGroupArn = &v
	return s
}

// SetLogPrefix sets the LogPrefix field's value.
func (s *CloudWatchLogGroupLogDestination) SetLogPrefix(v string) *CloudWatchLogGroupLogDestination {
	s.LogPrefix = &v
	return s
}

// Contains information about code hooks that Amazon Lex calls during a conversation.
type CodeHookSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies a Lambda function that verifies requests to a bot or fulfills the
	// user's request to a bot.
	//
	// LambdaCodeHook is a required field
	LambdaCodeHook *LambdaCodeHook `locationName:"lambdaCodeHook" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeHookSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeHookSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeHookSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeHookSpecification"}
	if s.LambdaCodeHook == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaCodeHook"))
	}
	if s.LambdaCodeHook != nil {
		if err := s.LambdaCodeHook.Validate(); err != nil {
			invalidParams.AddNested("LambdaCodeHook", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaCodeHook sets the LambdaCodeHook field's value.
func (s *CodeHookSpecification) SetLambdaCodeHook(v *LambdaCodeHook) *CodeHookSpecification {
	s.LambdaCodeHook = v
	return s
}

// A composite slot is a combination of two or more slots that capture multiple
// pieces of information in a single user input.
type CompositeSlotTypeSetting struct {
	_ struct{} `type:"structure"`

	// Subslots in the composite slot.
	SubSlots []*SubSlotTypeComposition `locationName:"subSlots" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeSlotTypeSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompositeSlotTypeSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompositeSlotTypeSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompositeSlotTypeSetting"}
	if s.SubSlots != nil {
		for i, v := range s.SubSlots {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubSlots", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubSlots sets the SubSlots field's value.
func (s *CompositeSlotTypeSetting) SetSubSlots(v []*SubSlotTypeComposition) *CompositeSlotTypeSetting {
	s.SubSlots = v
	return s
}

// Provides an expression that evaluates to true or false.
type Condition struct {
	_ struct{} `type:"structure"`

	// The expression string that is evaluated.
	//
	// ExpressionString is a required field
	ExpressionString *string `locationName:"expressionString" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.ExpressionString == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionString"))
	}
	if s.ExpressionString != nil && len(*s.ExpressionString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpressionString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpressionString sets the ExpressionString field's value.
func (s *Condition) SetExpressionString(v string) *Condition {
	s.ExpressionString = &v
	return s
}

// A set of actions that Amazon Lex should run if the condition is matched.
type ConditionalBranch struct {
	_ struct{} `type:"structure"`

	// Contains the expression to evaluate. If the condition is true, the branch's
	// actions are taken.
	//
	// Condition is a required field
	Condition *Condition `locationName:"condition" type:"structure" required:"true"`

	// The name of the branch.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next step in the conversation.
	//
	// NextStep is a required field
	NextStep *DialogState `locationName:"nextStep" type:"structure" required:"true"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	Response *ResponseSpecification `locationName:"response" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalBranch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalBranch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalBranch"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextStep == nil {
		invalidParams.Add(request.NewErrParamRequired("NextStep"))
	}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}
	if s.NextStep != nil {
		if err := s.NextStep.Validate(); err != nil {
			invalidParams.AddNested("NextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.Response != nil {
		if err := s.Response.Validate(); err != nil {
			invalidParams.AddNested("Response", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ConditionalBranch) SetCondition(v *Condition) *ConditionalBranch {
	s.Condition = v
	return s
}

// SetName sets the Name field's value.
func (s *ConditionalBranch) SetName(v string) *ConditionalBranch {
	s.Name = &v
	return s
}

// SetNextStep sets the NextStep field's value.
func (s *ConditionalBranch) SetNextStep(v *DialogState) *ConditionalBranch {
	s.NextStep = v
	return s
}

// SetResponse sets the Response field's value.
func (s *ConditionalBranch) SetResponse(v *ResponseSpecification) *ConditionalBranch {
	s.Response = v
	return s
}

// Provides a list of conditional branches. Branches are evaluated in the order
// that they are entered in the list. The first branch with a condition that
// evaluates to true is executed. The last branch in the list is the default
// branch. The default branch should not have any condition expression. The
// default branch is executed if no other branch has a matching condition.
type ConditionalSpecification struct {
	_ struct{} `type:"structure"`

	// Determines whether a conditional branch is active. When active is false,
	// the conditions are not evaluated.
	//
	// Active is a required field
	Active *bool `locationName:"active" type:"boolean" required:"true"`

	// A list of conditional branches. A conditional branch is made up of a condition,
	// a response and a next step. The response and next step are executed when
	// the condition is true.
	//
	// ConditionalBranches is a required field
	ConditionalBranches []*ConditionalBranch `locationName:"conditionalBranches" min:"1" type:"list" required:"true"`

	// The conditional branch that should be followed when the conditions for other
	// branches are not satisfied. A conditional branch is made up of a condition,
	// a response and a next step.
	//
	// DefaultBranch is a required field
	DefaultBranch *DefaultConditionalBranch `locationName:"defaultBranch" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionalSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionalSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionalSpecification"}
	if s.Active == nil {
		invalidParams.Add(request.NewErrParamRequired("Active"))
	}
	if s.ConditionalBranches == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionalBranches"))
	}
	if s.ConditionalBranches != nil && len(s.ConditionalBranches) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalBranches", 1))
	}
	if s.DefaultBranch == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultBranch"))
	}
	if s.ConditionalBranches != nil {
		for i, v := range s.ConditionalBranches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConditionalBranches", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DefaultBranch != nil {
		if err := s.DefaultBranch.Validate(); err != nil {
			invalidParams.AddNested("DefaultBranch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *ConditionalSpecification) SetActive(v bool) *ConditionalSpecification {
	s.Active = &v
	return s
}

// SetConditionalBranches sets the ConditionalBranches field's value.
func (s *ConditionalSpecification) SetConditionalBranches(v []*ConditionalBranch) *ConditionalSpecification {
	s.ConditionalBranches = v
	return s
}

// SetDefaultBranch sets the DefaultBranch field's value.
func (s *ConditionalSpecification) SetDefaultBranch(v *DefaultConditionalBranch) *ConditionalSpecification {
	s.DefaultBranch = v
	return s
}

// The action that you tried to perform couldn't be completed because the resource
// is in a conflicting state. For example, deleting a bot that is in the CREATING
// state. Try your request again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The item listing the evaluation of intent level success or failure.
type ConversationLevelIntentClassificationResultItem struct {
	_ struct{} `type:"structure"`

	// The intent name used in the evaluation of intent level success or failure.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// The number of times the specific intent is used in the evaluation of intent
	// level success or failure.
	//
	// MatchResult is a required field
	MatchResult *string `locationName:"matchResult" type:"string" required:"true" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelIntentClassificationResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelIntentClassificationResultItem) GoString() string {
	return s.String()
}

// SetIntentName sets the IntentName field's value.
func (s *ConversationLevelIntentClassificationResultItem) SetIntentName(v string) *ConversationLevelIntentClassificationResultItem {
	s.IntentName = &v
	return s
}

// SetMatchResult sets the MatchResult field's value.
func (s *ConversationLevelIntentClassificationResultItem) SetMatchResult(v string) *ConversationLevelIntentClassificationResultItem {
	s.MatchResult = &v
	return s
}

// The conversation level details of the conversation used in the test set.
type ConversationLevelResultDetail struct {
	_ struct{} `type:"structure"`

	// The success or failure of the streaming of the conversation.
	//
	// EndToEndResult is a required field
	EndToEndResult *string `locationName:"endToEndResult" type:"string" required:"true" enum:"TestResultMatchStatus"`

	// The speech transcription success or failure details of the conversation.
	SpeechTranscriptionResult *string `locationName:"speechTranscriptionResult" type:"string" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelResultDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelResultDetail) GoString() string {
	return s.String()
}

// SetEndToEndResult sets the EndToEndResult field's value.
func (s *ConversationLevelResultDetail) SetEndToEndResult(v string) *ConversationLevelResultDetail {
	s.EndToEndResult = &v
	return s
}

// SetSpeechTranscriptionResult sets the SpeechTranscriptionResult field's value.
func (s *ConversationLevelResultDetail) SetSpeechTranscriptionResult(v string) *ConversationLevelResultDetail {
	s.SpeechTranscriptionResult = &v
	return s
}

// The slots used for the slot resolution in the conversation.
type ConversationLevelSlotResolutionResultItem struct {
	_ struct{} `type:"structure"`

	// The intents used in the slots list for the slot resolution details.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// The number of matching slots used in the slots listings for the slot resolution
	// evaluation.
	//
	// MatchResult is a required field
	MatchResult *string `locationName:"matchResult" type:"string" required:"true" enum:"TestResultMatchStatus"`

	// The slot name in the slots list for the slot resolution details.
	//
	// SlotName is a required field
	SlotName *string `locationName:"slotName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelSlotResolutionResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelSlotResolutionResultItem) GoString() string {
	return s.String()
}

// SetIntentName sets the IntentName field's value.
func (s *ConversationLevelSlotResolutionResultItem) SetIntentName(v string) *ConversationLevelSlotResolutionResultItem {
	s.IntentName = &v
	return s
}

// SetMatchResult sets the MatchResult field's value.
func (s *ConversationLevelSlotResolutionResultItem) SetMatchResult(v string) *ConversationLevelSlotResolutionResultItem {
	s.MatchResult = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *ConversationLevelSlotResolutionResultItem) SetSlotName(v string) *ConversationLevelSlotResolutionResultItem {
	s.SlotName = &v
	return s
}

// The test result evaluation item at the conversation level.
type ConversationLevelTestResultItem struct {
	_ struct{} `type:"structure"`

	// The conversation Id of the test result evaluation item.
	//
	// ConversationId is a required field
	ConversationId *string `locationName:"conversationId" min:"1" type:"string" required:"true"`

	// The end-to-end success or failure of the test result evaluation item.
	//
	// EndToEndResult is a required field
	EndToEndResult *string `locationName:"endToEndResult" type:"string" required:"true" enum:"TestResultMatchStatus"`

	// The intent classification of the test result evaluation item.
	//
	// IntentClassificationResults is a required field
	IntentClassificationResults []*ConversationLevelIntentClassificationResultItem `locationName:"intentClassificationResults" type:"list" required:"true"`

	// The slot success or failure of the test result evaluation item.
	//
	// SlotResolutionResults is a required field
	SlotResolutionResults []*ConversationLevelSlotResolutionResultItem `locationName:"slotResolutionResults" type:"list" required:"true"`

	// The speech transcription success or failure of the test result evaluation
	// item.
	SpeechTranscriptionResult *string `locationName:"speechTranscriptionResult" type:"string" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultItem) GoString() string {
	return s.String()
}

// SetConversationId sets the ConversationId field's value.
func (s *ConversationLevelTestResultItem) SetConversationId(v string) *ConversationLevelTestResultItem {
	s.ConversationId = &v
	return s
}

// SetEndToEndResult sets the EndToEndResult field's value.
func (s *ConversationLevelTestResultItem) SetEndToEndResult(v string) *ConversationLevelTestResultItem {
	s.EndToEndResult = &v
	return s
}

// SetIntentClassificationResults sets the IntentClassificationResults field's value.
func (s *ConversationLevelTestResultItem) SetIntentClassificationResults(v []*ConversationLevelIntentClassificationResultItem) *ConversationLevelTestResultItem {
	s.IntentClassificationResults = v
	return s
}

// SetSlotResolutionResults sets the SlotResolutionResults field's value.
func (s *ConversationLevelTestResultItem) SetSlotResolutionResults(v []*ConversationLevelSlotResolutionResultItem) *ConversationLevelTestResultItem {
	s.SlotResolutionResults = v
	return s
}

// SetSpeechTranscriptionResult sets the SpeechTranscriptionResult field's value.
func (s *ConversationLevelTestResultItem) SetSpeechTranscriptionResult(v string) *ConversationLevelTestResultItem {
	s.SpeechTranscriptionResult = &v
	return s
}

// The test set results data at the conversation level.
type ConversationLevelTestResults struct {
	_ struct{} `type:"structure"`

	// The item list in the test set results data at the conversation level.
	//
	// Items is a required field
	Items []*ConversationLevelTestResultItem `locationName:"items" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResults) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ConversationLevelTestResults) SetItems(v []*ConversationLevelTestResultItem) *ConversationLevelTestResults {
	s.Items = v
	return s
}

// The selection to filter the test set results data at the conversation level.
type ConversationLevelTestResultsFilterBy struct {
	_ struct{} `type:"structure"`

	// The selection of matched or mismatched end-to-end status to filter test set
	// results data at the conversation level.
	EndToEndResult *string `locationName:"endToEndResult" type:"string" enum:"TestResultMatchStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultsFilterBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLevelTestResultsFilterBy) GoString() string {
	return s.String()
}

// SetEndToEndResult sets the EndToEndResult field's value.
func (s *ConversationLevelTestResultsFilterBy) SetEndToEndResult(v string) *ConversationLevelTestResultsFilterBy {
	s.EndToEndResult = &v
	return s
}

// Configures conversation logging that saves audio, text, and metadata for
// the conversations with your users.
type ConversationLogSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 settings for logging audio to an S3 bucket.
	AudioLogSettings []*AudioLogSetting `locationName:"audioLogSettings" min:"1" type:"list"`

	// The Amazon CloudWatch Logs settings for logging text and metadata.
	TextLogSettings []*TextLogSetting `locationName:"textLogSettings" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogSettings"}
	if s.AudioLogSettings != nil && len(s.AudioLogSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AudioLogSettings", 1))
	}
	if s.TextLogSettings != nil && len(s.TextLogSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TextLogSettings", 1))
	}
	if s.AudioLogSettings != nil {
		for i, v := range s.AudioLogSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioLogSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TextLogSettings != nil {
		for i, v := range s.TextLogSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextLogSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioLogSettings sets the AudioLogSettings field's value.
func (s *ConversationLogSettings) SetAudioLogSettings(v []*AudioLogSetting) *ConversationLogSettings {
	s.AudioLogSettings = v
	return s
}

// SetTextLogSettings sets the TextLogSettings field's value.
func (s *ConversationLogSettings) SetTextLogSettings(v []*TextLogSetting) *ConversationLogSettings {
	s.TextLogSettings = v
	return s
}

// The data source that uses conversation logs.
type ConversationLogsDataSource struct {
	_ struct{} `type:"structure"`

	// The bot alias Id from the conversation logs.
	//
	// BotAliasId is a required field
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The bot Id from the conversation logs.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The filter for the data source of the conversation log.
	//
	// Filter is a required field
	Filter *ConversationLogsDataSourceFilterBy `locationName:"filter" type:"structure" required:"true"`

	// The locale Id of the conversation log.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogsDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogsDataSource"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *ConversationLogsDataSource) SetBotAliasId(v string) *ConversationLogsDataSource {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *ConversationLogsDataSource) SetBotId(v string) *ConversationLogsDataSource {
	s.BotId = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ConversationLogsDataSource) SetFilter(v *ConversationLogsDataSourceFilterBy) *ConversationLogsDataSource {
	s.Filter = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ConversationLogsDataSource) SetLocaleId(v string) *ConversationLogsDataSource {
	s.LocaleId = &v
	return s
}

// The selected data source to filter the conversation log.
type ConversationLogsDataSourceFilterBy struct {
	_ struct{} `type:"structure"`

	// The end time for the conversation log.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The selection to filter by input mode for the conversation logs.
	//
	// InputMode is a required field
	InputMode *string `locationName:"inputMode" type:"string" required:"true" enum:"ConversationLogsInputModeFilter"`

	// The start time for the conversation log.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSourceFilterBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationLogsDataSourceFilterBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationLogsDataSourceFilterBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationLogsDataSourceFilterBy"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.InputMode == nil {
		invalidParams.Add(request.NewErrParamRequired("InputMode"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ConversationLogsDataSourceFilterBy) SetEndTime(v time.Time) *ConversationLogsDataSourceFilterBy {
	s.EndTime = &v
	return s
}

// SetInputMode sets the InputMode field's value.
func (s *ConversationLogsDataSourceFilterBy) SetInputMode(v string) *ConversationLogsDataSourceFilterBy {
	s.InputMode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ConversationLogsDataSourceFilterBy) SetStartTime(v time.Time) *ConversationLogsDataSourceFilterBy {
	s.StartTime = &v
	return s
}

type CreateBotAliasInput struct {
	_ struct{} `type:"structure"`

	// Maps configuration information to a specific locale. You can use this parameter
	// to specify a specific Lambda function to run different functions in different
	// locales.
	BotAliasLocaleSettings map[string]*BotAliasLocaleSettings `locationName:"botAliasLocaleSettings" min:"1" type:"map"`

	// The alias to create. The name must be unique for the bot.
	//
	// BotAliasName is a required field
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string" required:"true"`

	// The unique identifier of the bot that the alias applies to.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that this alias points to. You can use the UpdateBotAlias
	// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_UpdateBotAlias.html)
	// operation to change the bot version associated with the alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Specifies whether Amazon Lex logs text and audio for a conversation with
	// the bot. When you enable conversation logs, text logs store text input, transcripts
	// of audio input, and associated metadata in Amazon CloudWatch Logs. Audio
	// logs store audio input in Amazon S3.
	ConversationLogSettings *ConversationLogSettings `locationName:"conversationLogSettings" type:"structure"`

	// A description of the alias. Use this description to help identify the alias.
	Description *string `locationName:"description" type:"string"`

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment
	// of user utterances.
	SentimentAnalysisSettings *SentimentAnalysisSettings `locationName:"sentimentAnalysisSettings" type:"structure"`

	// A list of tags to add to the bot alias. You can only add tags when you create
	// an alias, you can't use the UpdateBotAlias operation to update the tags on
	// a bot alias. To update tags, use the TagResource operation.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotAliasInput"}
	if s.BotAliasLocaleSettings != nil && len(s.BotAliasLocaleSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasLocaleSettings", 1))
	}
	if s.BotAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasName"))
	}
	if s.BotAliasName != nil && len(*s.BotAliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasName", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.BotAliasLocaleSettings != nil {
		for i, v := range s.BotAliasLocaleSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BotAliasLocaleSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ConversationLogSettings != nil {
		if err := s.ConversationLogSettings.Validate(); err != nil {
			invalidParams.AddNested("ConversationLogSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.SentimentAnalysisSettings != nil {
		if err := s.SentimentAnalysisSettings.Validate(); err != nil {
			invalidParams.AddNested("SentimentAnalysisSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasLocaleSettings sets the BotAliasLocaleSettings field's value.
func (s *CreateBotAliasInput) SetBotAliasLocaleSettings(v map[string]*BotAliasLocaleSettings) *CreateBotAliasInput {
	s.BotAliasLocaleSettings = v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *CreateBotAliasInput) SetBotAliasName(v string) *CreateBotAliasInput {
	s.BotAliasName = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *CreateBotAliasInput) SetBotId(v string) *CreateBotAliasInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotAliasInput) SetBotVersion(v string) *CreateBotAliasInput {
	s.BotVersion = &v
	return s
}

// SetConversationLogSettings sets the ConversationLogSettings field's value.
func (s *CreateBotAliasInput) SetConversationLogSettings(v *ConversationLogSettings) *CreateBotAliasInput {
	s.ConversationLogSettings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotAliasInput) SetDescription(v string) *CreateBotAliasInput {
	s.Description = &v
	return s
}

// SetSentimentAnalysisSettings sets the SentimentAnalysisSettings field's value.
func (s *CreateBotAliasInput) SetSentimentAnalysisSettings(v *SentimentAnalysisSettings) *CreateBotAliasInput {
	s.SentimentAnalysisSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBotAliasInput) SetTags(v map[string]*string) *CreateBotAliasInput {
	s.Tags = v
	return s
}

type CreateBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot alias.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// Configuration information for a specific locale.
	BotAliasLocaleSettings map[string]*BotAliasLocaleSettings `locationName:"botAliasLocaleSettings" min:"1" type:"map"`

	// The name specified for the bot alias.
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string"`

	// The current status of the alias. The alias is first put into the Creating
	// state. When the alias is ready to be used, it is put into the Available state.
	// You can use the DescribeBotAlias operation to get the current state of an
	// alias.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The unique identifier of the bot that this alias applies to.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with this alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The conversation log settings specified for the alias.
	ConversationLogSettings *ConversationLogSettings `locationName:"conversationLogSettings" type:"structure"`

	// A Unix timestamp indicating the date and time that the bot alias was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the bot alias.
	Description *string `locationName:"description" type:"string"`

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment
	// of user utterances.
	SentimentAnalysisSettings *SentimentAnalysisSettings `locationName:"sentimentAnalysisSettings" type:"structure"`

	// A list of tags associated with the bot alias.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *CreateBotAliasOutput) SetBotAliasId(v string) *CreateBotAliasOutput {
	s.BotAliasId = &v
	return s
}

// SetBotAliasLocaleSettings sets the BotAliasLocaleSettings field's value.
func (s *CreateBotAliasOutput) SetBotAliasLocaleSettings(v map[string]*BotAliasLocaleSettings) *CreateBotAliasOutput {
	s.BotAliasLocaleSettings = v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *CreateBotAliasOutput) SetBotAliasName(v string) *CreateBotAliasOutput {
	s.BotAliasName = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *CreateBotAliasOutput) SetBotAliasStatus(v string) *CreateBotAliasOutput {
	s.BotAliasStatus = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *CreateBotAliasOutput) SetBotId(v string) *CreateBotAliasOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotAliasOutput) SetBotVersion(v string) *CreateBotAliasOutput {
	s.BotVersion = &v
	return s
}

// SetConversationLogSettings sets the ConversationLogSettings field's value.
func (s *CreateBotAliasOutput) SetConversationLogSettings(v *ConversationLogSettings) *CreateBotAliasOutput {
	s.ConversationLogSettings = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotAliasOutput) SetCreationDateTime(v time.Time) *CreateBotAliasOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotAliasOutput) SetDescription(v string) *CreateBotAliasOutput {
	s.Description = &v
	return s
}

// SetSentimentAnalysisSettings sets the SentimentAnalysisSettings field's value.
func (s *CreateBotAliasOutput) SetSentimentAnalysisSettings(v *SentimentAnalysisSettings) *CreateBotAliasOutput {
	s.SentimentAnalysisSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBotAliasOutput) SetTags(v map[string]*string) *CreateBotAliasOutput {
	s.Tags = v
	return s
}

type CreateBotInput struct {
	_ struct{} `type:"structure"`

	// The list of bot members in a network to be created.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name of the bot. The bot name must be unique in the account that creates
	// the bot.
	//
	// BotName is a required field
	BotName *string `locationName:"botName" min:"1" type:"string" required:"true"`

	// A list of tags to add to the bot. You can only add tags when you create a
	// bot. You can't use the UpdateBot operation to update tags. To update tags,
	// use the TagResource operation.
	BotTags map[string]*string `locationName:"botTags" type:"map"`

	// The type of a bot to create.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// Provides information on additional privacy protections Amazon Lex should
	// use with the bot's data.
	//
	// DataPrivacy is a required field
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure" required:"true"`

	// A description of the bot. It appears in lists to help you identify a particular
	// bot.
	Description *string `locationName:"description" type:"string"`

	// The time, in seconds, that Amazon Lex should keep information about a user's
	// conversation with the bot.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Lex
	// deletes any data provided before the timeout.
	//
	// You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
	//
	// IdleSessionTTLInSeconds is a required field
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access
	// the bot.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"32" type:"string" required:"true"`

	// A list of tags to add to the test alias for a bot. You can only add tags
	// when you create a bot. You can't use the UpdateAlias operation to update
	// tags. To update tags on the test alias, use the TagResource operation.
	TestBotAliasTags map[string]*string `locationName:"testBotAliasTags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotInput"}
	if s.BotName == nil {
		invalidParams.Add(request.NewErrParamRequired("BotName"))
	}
	if s.BotName != nil && len(*s.BotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotName", 1))
	}
	if s.DataPrivacy == nil {
		invalidParams.Add(request.NewErrParamRequired("DataPrivacy"))
	}
	if s.IdleSessionTTLInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("IdleSessionTTLInSeconds"))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 32))
	}
	if s.BotMembers != nil {
		for i, v := range s.BotMembers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BotMembers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DataPrivacy != nil {
		if err := s.DataPrivacy.Validate(); err != nil {
			invalidParams.AddNested("DataPrivacy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotMembers sets the BotMembers field's value.
func (s *CreateBotInput) SetBotMembers(v []*BotMember) *CreateBotInput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *CreateBotInput) SetBotName(v string) *CreateBotInput {
	s.BotName = &v
	return s
}

// SetBotTags sets the BotTags field's value.
func (s *CreateBotInput) SetBotTags(v map[string]*string) *CreateBotInput {
	s.BotTags = v
	return s
}

// SetBotType sets the BotType field's value.
func (s *CreateBotInput) SetBotType(v string) *CreateBotInput {
	s.BotType = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *CreateBotInput) SetDataPrivacy(v *DataPrivacy) *CreateBotInput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotInput) SetDescription(v string) *CreateBotInput {
	s.Description = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateBotInput) SetIdleSessionTTLInSeconds(v int64) *CreateBotInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateBotInput) SetRoleArn(v string) *CreateBotInput {
	s.RoleArn = &v
	return s
}

// SetTestBotAliasTags sets the TestBotAliasTags field's value.
func (s *CreateBotInput) SetTestBotAliasTags(v map[string]*string) *CreateBotInput {
	s.TestBotAliasTags = v
	return s
}

type CreateBotLocaleInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to create the locale for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to create the locale for. This can only be the draft
	// version of the bot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// A description of the bot locale. Use this to help identify the bot locale
	// in lists.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot
	// types, and slots used in the bot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`

	// Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent,
	// AMAZON.KendraSearchIntent, or both when returning alternative intents. AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent are only inserted if they are configured for
	// the bot.
	//
	// For example, suppose a bot is configured with the confidence threshold of
	// 0.80 and the AMAZON.FallbackIntent. Amazon Lex returns three alternative
	// intents with the following confidence scores: IntentA (0.70), IntentB (0.60),
	// IntentC (0.50). The response from the RecognizeText operation would be:
	//
	//    * AMAZON.FallbackIntent
	//
	//    * IntentA
	//
	//    * IntentB
	//
	//    * IntentC
	//
	// NluIntentConfidenceThreshold is a required field
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double" required:"true"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interaction with
	// the user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.NluIntentConfidenceThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("NluIntentConfidenceThreshold"))
	}
	if s.VoiceSettings != nil {
		if err := s.VoiceSettings.Validate(); err != nil {
			invalidParams.AddNested("VoiceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateBotLocaleInput) SetBotId(v string) *CreateBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotLocaleInput) SetBotVersion(v string) *CreateBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotLocaleInput) SetDescription(v string) *CreateBotLocaleInput {
	s.Description = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateBotLocaleInput) SetLocaleId(v string) *CreateBotLocaleInput {
	s.LocaleId = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *CreateBotLocaleInput) SetNluIntentConfidenceThreshold(v float64) *CreateBotLocaleInput {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *CreateBotLocaleInput) SetVoiceSettings(v *VoiceSettings) *CreateBotLocaleInput {
	s.VoiceSettings = v
	return s
}

type CreateBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The specified bot identifier.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The status of the bot.
	//
	// When the status is Creating the bot locale is being configured. When the
	// status is Building Amazon Lex is building the bot for testing and use.
	//
	// If the status of the bot is ReadyExpressTesting, you can test the bot using
	// the exact utterances specified in the bots' intents. When the bot is ready
	// for full testing or to run, the status is Built.
	//
	// If there was a problem with building the bot, the status is Failed. If the
	// bot was saved but not built, the status is NotBuilt.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The specified bot version.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp specifying the date and time that the bot locale was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The specified description of the bot locale.
	Description *string `locationName:"description" type:"string"`

	// The specified locale identifier.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The specified locale name.
	LocaleName *string `locationName:"localeName" type:"string"`

	// The specified confidence threshold for inserting the AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent intents.
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double"`

	// The Amazon Polly voice ID that Amazon Lex uses for voice interaction with
	// the user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotLocaleOutput) SetBotId(v string) *CreateBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *CreateBotLocaleOutput) SetBotLocaleStatus(v string) *CreateBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotLocaleOutput) SetBotVersion(v string) *CreateBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotLocaleOutput) SetCreationDateTime(v time.Time) *CreateBotLocaleOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotLocaleOutput) SetDescription(v string) *CreateBotLocaleOutput {
	s.Description = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateBotLocaleOutput) SetLocaleId(v string) *CreateBotLocaleOutput {
	s.LocaleId = &v
	return s
}

// SetLocaleName sets the LocaleName field's value.
func (s *CreateBotLocaleOutput) SetLocaleName(v string) *CreateBotLocaleOutput {
	s.LocaleName = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *CreateBotLocaleOutput) SetNluIntentConfidenceThreshold(v float64) *CreateBotLocaleOutput {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *CreateBotLocaleOutput) SetVoiceSettings(v *VoiceSettings) *CreateBotLocaleOutput {
	s.VoiceSettings = v
	return s
}

type CreateBotOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a particular bot. You use this to identify the bot
	// when you call other Amazon Lex API operations.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The list of bots in a network that was created.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name specified for the bot.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// Shows the current status of the bot. The bot is first in the Creating status.
	// Once the bot is read for use, it changes to the Available status. After the
	// bot is created, you can use the DRAFT version of the bot.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// A list of tags associated with the bot.
	BotTags map[string]*string `locationName:"botTags" type:"map"`

	// The type of a bot that was created.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// A timestamp indicating the date and time that the bot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The data privacy settings specified for the bot.
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure"`

	// The description specified for the bot.
	Description *string `locationName:"description" type:"string"`

	// The session idle time specified for the bot.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// The IAM role specified for the bot.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// A list of tags associated with the test alias for the bot.
	TestBotAliasTags map[string]*string `locationName:"testBotAliasTags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotOutput) SetBotId(v string) *CreateBotOutput {
	s.BotId = &v
	return s
}

// SetBotMembers sets the BotMembers field's value.
func (s *CreateBotOutput) SetBotMembers(v []*BotMember) *CreateBotOutput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *CreateBotOutput) SetBotName(v string) *CreateBotOutput {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *CreateBotOutput) SetBotStatus(v string) *CreateBotOutput {
	s.BotStatus = &v
	return s
}

// SetBotTags sets the BotTags field's value.
func (s *CreateBotOutput) SetBotTags(v map[string]*string) *CreateBotOutput {
	s.BotTags = v
	return s
}

// SetBotType sets the BotType field's value.
func (s *CreateBotOutput) SetBotType(v string) *CreateBotOutput {
	s.BotType = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotOutput) SetCreationDateTime(v time.Time) *CreateBotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *CreateBotOutput) SetDataPrivacy(v *DataPrivacy) *CreateBotOutput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotOutput) SetDescription(v string) *CreateBotOutput {
	s.Description = &v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateBotOutput) SetIdleSessionTTLInSeconds(v int64) *CreateBotOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateBotOutput) SetRoleArn(v string) *CreateBotOutput {
	s.RoleArn = &v
	return s
}

// SetTestBotAliasTags sets the TestBotAliasTags field's value.
func (s *CreateBotOutput) SetTestBotAliasTags(v map[string]*string) *CreateBotOutput {
	s.TestBotAliasTags = v
	return s
}

type CreateBotVersionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to create the version for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// Specifies the locales that Amazon Lex adds to this version. You can choose
	// the Draft version or any other previously published version for each locale.
	// When you specify a source version, the locale data is copied from the source
	// version to the new version.
	//
	// BotVersionLocaleSpecification is a required field
	BotVersionLocaleSpecification map[string]*BotVersionLocaleDetails `locationName:"botVersionLocaleSpecification" min:"1" type:"map" required:"true"`

	// A description of the version. Use the description to help identify the version
	// in lists.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotVersionInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersionLocaleSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersionLocaleSpecification"))
	}
	if s.BotVersionLocaleSpecification != nil && len(s.BotVersionLocaleSpecification) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersionLocaleSpecification", 1))
	}
	if s.BotVersionLocaleSpecification != nil {
		for i, v := range s.BotVersionLocaleSpecification {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BotVersionLocaleSpecification", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateBotVersionInput) SetBotId(v string) *CreateBotVersionInput {
	s.BotId = &v
	return s
}

// SetBotVersionLocaleSpecification sets the BotVersionLocaleSpecification field's value.
func (s *CreateBotVersionInput) SetBotVersionLocaleSpecification(v map[string]*BotVersionLocaleDetails) *CreateBotVersionInput {
	s.BotVersionLocaleSpecification = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotVersionInput) SetDescription(v string) *CreateBotVersionInput {
	s.Description = &v
	return s
}

type CreateBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The bot identifier specified in the request.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// When you send a request to create or update a bot, Amazon Lex sets the status
	// response element to Creating. After Amazon Lex builds the bot, it sets status
	// to Available. If Amazon Lex can't build the bot, it sets status to Failed.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The version number assigned to the version.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The source versions used for each locale in the new version.
	BotVersionLocaleSpecification map[string]*BotVersionLocaleDetails `locationName:"botVersionLocaleSpecification" min:"1" type:"map"`

	// A timestamp of the date and time that the version was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the version specified in the request.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBotVersionOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateBotVersionOutput) SetBotId(v string) *CreateBotVersionOutput {
	s.BotId = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *CreateBotVersionOutput) SetBotStatus(v string) *CreateBotVersionOutput {
	s.BotStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateBotVersionOutput) SetBotVersion(v string) *CreateBotVersionOutput {
	s.BotVersion = &v
	return s
}

// SetBotVersionLocaleSpecification sets the BotVersionLocaleSpecification field's value.
func (s *CreateBotVersionOutput) SetBotVersionLocaleSpecification(v map[string]*BotVersionLocaleDetails) *CreateBotVersionOutput {
	s.BotVersionLocaleSpecification = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateBotVersionOutput) SetCreationDateTime(v time.Time) *CreateBotVersionOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBotVersionOutput) SetDescription(v string) *CreateBotVersionOutput {
	s.Description = &v
	return s
}

type CreateExportInput struct {
	_ struct{} `type:"structure"`

	// The file format of the bot or bot locale definition files.
	//
	// FileFormat is a required field
	FileFormat *string `locationName:"fileFormat" type:"string" required:"true" enum:"ImportExportFileFormat"`

	// An password to use to encrypt the exported archive. Using a password is optional,
	// but you should encrypt the archive to protect the data in transit between
	// Amazon Lex and your local computer.
	//
	// FilePassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateExportInput's
	// String and GoString methods.
	FilePassword *string `locationName:"filePassword" min:"1" type:"string" sensitive:"true"`

	// Specifies the type of resource to export, either a bot or a bot locale. You
	// can only specify one type of resource to export.
	//
	// ResourceSpecification is a required field
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExportInput"}
	if s.FileFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("FileFormat"))
	}
	if s.FilePassword != nil && len(*s.FilePassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilePassword", 1))
	}
	if s.ResourceSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceSpecification"))
	}
	if s.ResourceSpecification != nil {
		if err := s.ResourceSpecification.Validate(); err != nil {
			invalidParams.AddNested("ResourceSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateExportInput) SetFileFormat(v string) *CreateExportInput {
	s.FileFormat = &v
	return s
}

// SetFilePassword sets the FilePassword field's value.
func (s *CreateExportInput) SetFilePassword(v string) *CreateExportInput {
	s.FilePassword = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *CreateExportInput) SetResourceSpecification(v *ExportResourceSpecification) *CreateExportInput {
	s.ResourceSpecification = v
	return s
}

type CreateExportOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the request to export a bot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// An identifier for a specific request to create an export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The status of the export. When the status is Completed, you can use the DescribeExport
	// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
	// operation to get the pre-signed S3 URL link to your exported bot or bot locale.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`

	// The file format used for the bot or bot locale definition files.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"ImportExportFileFormat"`

	// A description of the type of resource that was exported, either a bot or
	// a bot locale.
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateExportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateExportOutput) SetCreationDateTime(v time.Time) *CreateExportOutput {
	s.CreationDateTime = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *CreateExportOutput) SetExportId(v string) *CreateExportOutput {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *CreateExportOutput) SetExportStatus(v string) *CreateExportOutput {
	s.ExportStatus = &v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *CreateExportOutput) SetFileFormat(v string) *CreateExportOutput {
	s.FileFormat = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *CreateExportOutput) SetResourceSpecification(v *ExportResourceSpecification) *CreateExportOutput {
	s.ResourceSpecification = v
	return s
}

type CreateIntentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this intent.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with this intent.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// A description of the intent. Use the description to help identify the intent
	// in lists.
	Description *string `locationName:"description" type:"string"`

	// Specifies that Amazon Lex invokes the alias Lambda function for each user
	// input. You can invoke this Lambda function to personalize user interaction.
	//
	// For example, suppose that your bot determines that the user's name is John.
	// You Lambda function might retrieve John's information from a backend database
	// and prepopulate some of the values. For example, if you find that John is
	// gluten intolerant, you might set the corresponding intent slot, glutenIntolerant
	// to true. You might find John's phone number and set the corresponding session
	// attribute.
	DialogCodeHook *DialogCodeHookSettings `locationName:"dialogCodeHook" type:"structure"`

	// Specifies that Amazon Lex invokes the alias Lambda function when the intent
	// is ready for fulfillment. You can invoke this function to complete the bot's
	// transaction with the user.
	//
	// For example, in a pizza ordering bot, the Lambda function can look up the
	// closest pizza restaurant to the customer's location and then place an order
	// on the customer's behalf.
	FulfillmentCodeHook *FulfillmentCodeHookSettings `locationName:"fulfillmentCodeHook" type:"structure"`

	// Configuration settings for the response that is sent to the user at the beginning
	// of a conversation, before eliciting slot values.
	InitialResponseSetting *InitialResponseSetting `locationName:"initialResponseSetting" type:"structure"`

	// A list of contexts that must be active for this intent to be considered by
	// Amazon Lex.
	//
	// When an intent has an input context list, Amazon Lex only considers using
	// the intent in an interaction with the user when the specified contexts are
	// included in the active context list for the session. If the contexts are
	// not active, then Amazon Lex will not use the intent.
	//
	// A context can be automatically activated using the outputContexts property
	// or it can be set at runtime.
	//
	// For example, if there are two intents with different input contexts that
	// respond to the same utterances, only the intent with the active context will
	// respond.
	//
	// An intent may have up to 5 input contexts. If an intent has multiple input
	// contexts, all of the contexts must be active to consider the intent.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// Sets the response that Amazon Lex sends to the user when the intent is closed.
	IntentClosingSetting *IntentClosingSetting `locationName:"intentClosingSetting" type:"structure"`

	// Provides prompts that Amazon Lex sends to the user to confirm the completion
	// of an intent. If the user answers "no," the settings contain a statement
	// that is sent to the user to end the intent.
	IntentConfirmationSetting *IntentConfirmationSetting `locationName:"intentConfirmationSetting" type:"structure"`

	// The name of the intent. Intent names must be unique in the locale that contains
	// the intent and cannot match the name of any built-in intent.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// Configuration information required to use the AMAZON.KendraSearchIntent intent
	// to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent
	// is called when Amazon Lex can't determine another intent to invoke.
	KendraConfiguration *KendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// The identifier of the language and locale where this intent is used. All
	// of the bots, slot types, and slots used by the intent must have the same
	// locale. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// A lists of contexts that the intent activates when it is fulfilled.
	//
	// You can use an output context to indicate the intents that Amazon Lex should
	// consider for the next turn of the conversation with a customer.
	//
	// When you use the outputContextsList property, all of the contexts specified
	// in the list are activated when the intent is fulfilled. You can set up to
	// 10 output contexts. You can also set the number of conversation turns that
	// the context should be active, or the length of time that the context should
	// be active.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// A unique identifier for the built-in intent to base this intent on.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// An array of strings that a user might say to signal the intent. For example,
	// "I want a pizza", or "I want a {PizzaSize} pizza".
	//
	// In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate
	// where they should be displayed in the utterance shown to the user..
	SampleUtterances []*SampleUtterance `locationName:"sampleUtterances" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntentInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentName == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentName"))
	}
	if s.IntentName != nil && len(*s.IntentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntentName", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.DialogCodeHook != nil {
		if err := s.DialogCodeHook.Validate(); err != nil {
			invalidParams.AddNested("DialogCodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.FulfillmentCodeHook != nil {
		if err := s.FulfillmentCodeHook.Validate(); err != nil {
			invalidParams.AddNested("FulfillmentCodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.InitialResponseSetting != nil {
		if err := s.InitialResponseSetting.Validate(); err != nil {
			invalidParams.AddNested("InitialResponseSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.InputContexts != nil {
		for i, v := range s.InputContexts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputContexts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.IntentClosingSetting != nil {
		if err := s.IntentClosingSetting.Validate(); err != nil {
			invalidParams.AddNested("IntentClosingSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.IntentConfirmationSetting != nil {
		if err := s.IntentConfirmationSetting.Validate(); err != nil {
			invalidParams.AddNested("IntentConfirmationSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.KendraConfiguration != nil {
		if err := s.KendraConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KendraConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputContexts != nil {
		for i, v := range s.OutputContexts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputContexts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SampleUtterances != nil {
		for i, v := range s.SampleUtterances {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SampleUtterances", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateIntentInput) SetBotId(v string) *CreateIntentInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateIntentInput) SetBotVersion(v string) *CreateIntentInput {
	s.BotVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntentInput) SetDescription(v string) *CreateIntentInput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *CreateIntentInput) SetDialogCodeHook(v *DialogCodeHookSettings) *CreateIntentInput {
	s.DialogCodeHook = v
	return s
}

// SetFulfillmentCodeHook sets the FulfillmentCodeHook field's value.
func (s *CreateIntentInput) SetFulfillmentCodeHook(v *FulfillmentCodeHookSettings) *CreateIntentInput {
	s.FulfillmentCodeHook = v
	return s
}

// SetInitialResponseSetting sets the InitialResponseSetting field's value.
func (s *CreateIntentInput) SetInitialResponseSetting(v *InitialResponseSetting) *CreateIntentInput {
	s.InitialResponseSetting = v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *CreateIntentInput) SetInputContexts(v []*InputContext) *CreateIntentInput {
	s.InputContexts = v
	return s
}

// SetIntentClosingSetting sets the IntentClosingSetting field's value.
func (s *CreateIntentInput) SetIntentClosingSetting(v *IntentClosingSetting) *CreateIntentInput {
	s.IntentClosingSetting = v
	return s
}

// SetIntentConfirmationSetting sets the IntentConfirmationSetting field's value.
func (s *CreateIntentInput) SetIntentConfirmationSetting(v *IntentConfirmationSetting) *CreateIntentInput {
	s.IntentConfirmationSetting = v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *CreateIntentInput) SetIntentName(v string) *CreateIntentInput {
	s.IntentName = &v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *CreateIntentInput) SetKendraConfiguration(v *KendraConfiguration) *CreateIntentInput {
	s.KendraConfiguration = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateIntentInput) SetLocaleId(v string) *CreateIntentInput {
	s.LocaleId = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *CreateIntentInput) SetOutputContexts(v []*OutputContext) *CreateIntentInput {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *CreateIntentInput) SetParentIntentSignature(v string) *CreateIntentInput {
	s.ParentIntentSignature = &v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *CreateIntentInput) SetSampleUtterances(v []*SampleUtterance) *CreateIntentInput {
	s.SampleUtterances = v
	return s
}

type CreateIntentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the intent.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the intent.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp of the date and time that the intent was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the intent.
	Description *string `locationName:"description" type:"string"`

	// The dialog Lambda function specified for the intent.
	DialogCodeHook *DialogCodeHookSettings `locationName:"dialogCodeHook" type:"structure"`

	// The fulfillment Lambda function specified for the intent.
	FulfillmentCodeHook *FulfillmentCodeHookSettings `locationName:"fulfillmentCodeHook" type:"structure"`

	// Configuration settings for the response that is sent to the user at the beginning
	// of a conversation, before eliciting slot values.
	InitialResponseSetting *InitialResponseSetting `locationName:"initialResponseSetting" type:"structure"`

	// The list of input contexts specified for the intent.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// The closing setting specified for the intent.
	IntentClosingSetting *IntentClosingSetting `locationName:"intentClosingSetting" type:"structure"`

	// The confirmation setting specified for the intent.
	IntentConfirmationSetting *IntentConfirmationSetting `locationName:"intentConfirmationSetting" type:"structure"`

	// A unique identifier for the intent.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The name specified for the intent.
	IntentName *string `locationName:"intentName" min:"1" type:"string"`

	// Configuration for searching a Amazon Kendra index specified for the intent.
	KendraConfiguration *KendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// The locale that the intent is specified to use.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The list of output contexts specified for the intent.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// The signature of the parent intent specified for the intent.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// The sample utterances specified for the intent.
	SampleUtterances []*SampleUtterance `locationName:"sampleUtterances" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntentOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateIntentOutput) SetBotId(v string) *CreateIntentOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateIntentOutput) SetBotVersion(v string) *CreateIntentOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateIntentOutput) SetCreationDateTime(v time.Time) *CreateIntentOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIntentOutput) SetDescription(v string) *CreateIntentOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *CreateIntentOutput) SetDialogCodeHook(v *DialogCodeHookSettings) *CreateIntentOutput {
	s.DialogCodeHook = v
	return s
}

// SetFulfillmentCodeHook sets the FulfillmentCodeHook field's value.
func (s *CreateIntentOutput) SetFulfillmentCodeHook(v *FulfillmentCodeHookSettings) *CreateIntentOutput {
	s.FulfillmentCodeHook = v
	return s
}

// SetInitialResponseSetting sets the InitialResponseSetting field's value.
func (s *CreateIntentOutput) SetInitialResponseSetting(v *InitialResponseSetting) *CreateIntentOutput {
	s.InitialResponseSetting = v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *CreateIntentOutput) SetInputContexts(v []*InputContext) *CreateIntentOutput {
	s.InputContexts = v
	return s
}

// SetIntentClosingSetting sets the IntentClosingSetting field's value.
func (s *CreateIntentOutput) SetIntentClosingSetting(v *IntentClosingSetting) *CreateIntentOutput {
	s.IntentClosingSetting = v
	return s
}

// SetIntentConfirmationSetting sets the IntentConfirmationSetting field's value.
func (s *CreateIntentOutput) SetIntentConfirmationSetting(v *IntentConfirmationSetting) *CreateIntentOutput {
	s.IntentConfirmationSetting = v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *CreateIntentOutput) SetIntentId(v string) *CreateIntentOutput {
	s.IntentId = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *CreateIntentOutput) SetIntentName(v string) *CreateIntentOutput {
	s.IntentName = &v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *CreateIntentOutput) SetKendraConfiguration(v *KendraConfiguration) *CreateIntentOutput {
	s.KendraConfiguration = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateIntentOutput) SetLocaleId(v string) *CreateIntentOutput {
	s.LocaleId = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *CreateIntentOutput) SetOutputContexts(v []*OutputContext) *CreateIntentOutput {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *CreateIntentOutput) SetParentIntentSignature(v string) *CreateIntentOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *CreateIntentOutput) SetSampleUtterances(v []*SampleUtterance) *CreateIntentOutput {
	s.SampleUtterances = v
	return s
}

type CreateResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// A resource policy to add to the resource. The policy is a JSON structure
	// that contains one or more statements that define the policy. The policy must
	// follow the IAM syntax. For more information about the contents of a JSON
	// policy document, see IAM JSON policy reference (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
	//
	// If the policy isn't valid, Amazon Lex returns a validation exception.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 2))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *CreateResourcePolicyInput) SetPolicy(v string) *CreateResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyInput) SetResourceArn(v string) *CreateResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type CreateResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy was attached to.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyOutput) SetResourceArn(v string) *CreateResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateResourcePolicyOutput) SetRevisionId(v string) *CreateResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type CreateResourcePolicyStatementInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Lex action that this policy either allows or denies. The action
	// must apply to the resource type of the specified ARN. For more information,
	// see Actions, resources, and condition keys for Amazon Lex V2 (https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
	//
	// Action is a required field
	Action []*string `locationName:"action" type:"list" required:"true"`

	// Specifies a condition when the policy is in effect. If the principal of the
	// policy is a service principal, you must provide two condition blocks, one
	// with a SourceAccount global condition key and one with a SourceArn global
	// condition key.
	//
	// For more information, see IAM JSON policy elements: Condition (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
	Condition map[string]map[string]*string `locationName:"condition" type:"map"`

	// Determines whether the statement allows or denies access to the resource.
	//
	// Effect is a required field
	Effect *string `locationName:"effect" type:"string" required:"true" enum:"Effect"`

	// The identifier of the revision of the policy to edit. If this revision ID
	// doesn't match the current revision ID, Amazon Lex throws an exception.
	//
	// If you don't specify a revision, Amazon Lex overwrites the contents of the
	// policy with the new values.
	ExpectedRevisionId *string `location:"querystring" locationName:"expectedRevisionId" min:"1" type:"string"`

	// An IAM principal, such as an IAM user, IAM role, or Amazon Web Services services
	// that is allowed or denied access to a resource. For more information, see
	// Amazon Web Services JSON policy elements: Principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
	//
	// Principal is a required field
	Principal []*Principal `locationName:"principal" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The name of the statement. The ID is the same as the Sid IAM property. The
	// statement name must be unique within the policy. For more information, see
	// IAM JSON policy elements: Sid (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html).
	//
	// StatementId is a required field
	StatementId *string `locationName:"statementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourcePolicyStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourcePolicyStatementInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Effect == nil {
		invalidParams.Add(request.NewErrParamRequired("Effect"))
	}
	if s.ExpectedRevisionId != nil && len(*s.ExpectedRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpectedRevisionId", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.Principal != nil {
		for i, v := range s.Principal {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Principal", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateResourcePolicyStatementInput) SetAction(v []*string) *CreateResourcePolicyStatementInput {
	s.Action = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CreateResourcePolicyStatementInput) SetCondition(v map[string]map[string]*string) *CreateResourcePolicyStatementInput {
	s.Condition = v
	return s
}

// SetEffect sets the Effect field's value.
func (s *CreateResourcePolicyStatementInput) SetEffect(v string) *CreateResourcePolicyStatementInput {
	s.Effect = &v
	return s
}

// SetExpectedRevisionId sets the ExpectedRevisionId field's value.
func (s *CreateResourcePolicyStatementInput) SetExpectedRevisionId(v string) *CreateResourcePolicyStatementInput {
	s.ExpectedRevisionId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *CreateResourcePolicyStatementInput) SetPrincipal(v []*Principal) *CreateResourcePolicyStatementInput {
	s.Principal = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyStatementInput) SetResourceArn(v string) *CreateResourcePolicyStatementInput {
	s.ResourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *CreateResourcePolicyStatementInput) SetStatementId(v string) *CreateResourcePolicyStatementInput {
	s.StatementId = &v
	return s
}

type CreateResourcePolicyStatementOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourcePolicyStatementOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateResourcePolicyStatementOutput) SetResourceArn(v string) *CreateResourcePolicyStatementOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateResourcePolicyStatementOutput) SetRevisionId(v string) *CreateResourcePolicyStatementOutput {
	s.RevisionId = &v
	return s
}

type CreateSlotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the slot.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// A description of the slot. Use this to help identify the slot in lists.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the intent that contains the slot.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale that the slot will be used in.
	// The string must match one of the supported locales. All of the bots, intents,
	// slot types used by the slot must have the same locale. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// Indicates whether the slot returns multiple values in one response. Multi-value
	// slots are only available in the en-US locale. If you set this value to true
	// in any other locale, Amazon Lex throws a ValidationException.
	//
	// If the multipleValuesSetting is not set, the default value is false.
	MultipleValuesSetting *MultipleValuesSetting `locationName:"multipleValuesSetting" type:"structure"`

	// Determines how slot values are used in Amazon CloudWatch logs. If the value
	// of the obfuscationSetting parameter is DefaultObfuscation, slot values are
	// obfuscated in the log output. If the value is None, the actual value is present
	// in the log output.
	//
	// The default is to obfuscate values in the CloudWatch logs.
	ObfuscationSetting *ObfuscationSetting `locationName:"obfuscationSetting" type:"structure"`

	// The name of the slot. Slot names must be unique within the bot that contains
	// the slot.
	//
	// SlotName is a required field
	SlotName *string `locationName:"slotName" min:"1" type:"string" required:"true"`

	// The unique identifier for the slot type associated with this slot. The slot
	// type determines the values that can be entered into the slot.
	SlotTypeId *string `locationName:"slotTypeId" min:"1" type:"string"`

	// Specifications for the constituent sub slots and the expression for the composite
	// slot.
	SubSlotSetting *SubSlotSetting `locationName:"subSlotSetting" type:"structure"`

	// Specifies prompts that Amazon Lex sends to the user to elicit a response
	// that provides the value for the slot.
	//
	// ValueElicitationSetting is a required field
	ValueElicitationSetting *SlotValueElicitationSetting `locationName:"valueElicitationSetting" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotName"))
	}
	if s.SlotName != nil && len(*s.SlotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotName", 1))
	}
	if s.SlotTypeId != nil && len(*s.SlotTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeId", 1))
	}
	if s.ValueElicitationSetting == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueElicitationSetting"))
	}
	if s.ObfuscationSetting != nil {
		if err := s.ObfuscationSetting.Validate(); err != nil {
			invalidParams.AddNested("ObfuscationSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.SubSlotSetting != nil {
		if err := s.SubSlotSetting.Validate(); err != nil {
			invalidParams.AddNested("SubSlotSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.ValueElicitationSetting != nil {
		if err := s.ValueElicitationSetting.Validate(); err != nil {
			invalidParams.AddNested("ValueElicitationSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotInput) SetBotId(v string) *CreateSlotInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotInput) SetBotVersion(v string) *CreateSlotInput {
	s.BotVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotInput) SetDescription(v string) *CreateSlotInput {
	s.Description = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *CreateSlotInput) SetIntentId(v string) *CreateSlotInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotInput) SetLocaleId(v string) *CreateSlotInput {
	s.LocaleId = &v
	return s
}

// SetMultipleValuesSetting sets the MultipleValuesSetting field's value.
func (s *CreateSlotInput) SetMultipleValuesSetting(v *MultipleValuesSetting) *CreateSlotInput {
	s.MultipleValuesSetting = v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *CreateSlotInput) SetObfuscationSetting(v *ObfuscationSetting) *CreateSlotInput {
	s.ObfuscationSetting = v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *CreateSlotInput) SetSlotName(v string) *CreateSlotInput {
	s.SlotName = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *CreateSlotInput) SetSlotTypeId(v string) *CreateSlotInput {
	s.SlotTypeId = &v
	return s
}

// SetSubSlotSetting sets the SubSlotSetting field's value.
func (s *CreateSlotInput) SetSubSlotSetting(v *SubSlotSetting) *CreateSlotInput {
	s.SubSlotSetting = v
	return s
}

// SetValueElicitationSetting sets the ValueElicitationSetting field's value.
func (s *CreateSlotInput) SetValueElicitationSetting(v *SlotValueElicitationSetting) *CreateSlotInput {
	s.ValueElicitationSetting = v
	return s
}

type CreateSlotOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot associated with the slot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The timestamp of the date and time that the slot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description associated with the slot.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the intent associated with the slot.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The language and local specified for the slot.
	LocaleId *string `locationName:"localeId" type:"string"`

	// Indicates whether the slot returns multiple values in one response.
	MultipleValuesSetting *MultipleValuesSetting `locationName:"multipleValuesSetting" type:"structure"`

	// Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch
	// logs.
	ObfuscationSetting *ObfuscationSetting `locationName:"obfuscationSetting" type:"structure"`

	// The unique identifier associated with the slot. Use this to identify the
	// slot when you update or delete it.
	SlotId *string `locationName:"slotId" min:"10" type:"string"`

	// The name specified for the slot.
	SlotName *string `locationName:"slotName" min:"1" type:"string"`

	// The unique identifier of the slot type associated with this slot.
	SlotTypeId *string `locationName:"slotTypeId" min:"1" type:"string"`

	// Specifications for the constituent sub slots and the expression for the composite
	// slot.
	SubSlotSetting *SubSlotSetting `locationName:"subSlotSetting" type:"structure"`

	// The value elicitation settings specified for the slot.
	ValueElicitationSetting *SlotValueElicitationSetting `locationName:"valueElicitationSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotOutput) SetBotId(v string) *CreateSlotOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotOutput) SetBotVersion(v string) *CreateSlotOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSlotOutput) SetCreationDateTime(v time.Time) *CreateSlotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotOutput) SetDescription(v string) *CreateSlotOutput {
	s.Description = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *CreateSlotOutput) SetIntentId(v string) *CreateSlotOutput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotOutput) SetLocaleId(v string) *CreateSlotOutput {
	s.LocaleId = &v
	return s
}

// SetMultipleValuesSetting sets the MultipleValuesSetting field's value.
func (s *CreateSlotOutput) SetMultipleValuesSetting(v *MultipleValuesSetting) *CreateSlotOutput {
	s.MultipleValuesSetting = v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *CreateSlotOutput) SetObfuscationSetting(v *ObfuscationSetting) *CreateSlotOutput {
	s.ObfuscationSetting = v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *CreateSlotOutput) SetSlotId(v string) *CreateSlotOutput {
	s.SlotId = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *CreateSlotOutput) SetSlotName(v string) *CreateSlotOutput {
	s.SlotName = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *CreateSlotOutput) SetSlotTypeId(v string) *CreateSlotOutput {
	s.SlotTypeId = &v
	return s
}

// SetSubSlotSetting sets the SubSlotSetting field's value.
func (s *CreateSlotOutput) SetSubSlotSetting(v *SubSlotSetting) *CreateSlotOutput {
	s.SubSlotSetting = v
	return s
}

// SetValueElicitationSetting sets the ValueElicitationSetting field's value.
func (s *CreateSlotOutput) SetValueElicitationSetting(v *SlotValueElicitationSetting) *CreateSlotOutput {
	s.ValueElicitationSetting = v
	return s
}

type CreateSlotTypeInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this slot type.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the bot version associated with this slot type.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *CompositeSlotTypeSetting `locationName:"compositeSlotTypeSetting" type:"structure"`

	// A description of the slot type. Use the description to help identify the
	// slot type in lists.
	Description *string `locationName:"description" type:"string"`

	// Sets the type of external information used to create the slot type.
	ExternalSourceSetting *ExternalSourceSetting `locationName:"externalSourceSetting" type:"structure"`

	// The identifier of the language and locale that the slot type will be used
	// in. The string must match one of the supported locales. All of the bots,
	// intents, and slots used by the slot type must have the same locale. For more
	// information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The built-in slot type used as a parent of this slot type. When you define
	// a parent slot type, the new slot type has the configuration of the parent
	// slot type.
	//
	// Only AMAZON.AlphaNumeric is supported.
	ParentSlotTypeSignature *string `locationName:"parentSlotTypeSignature" type:"string"`

	// The name for the slot. A slot type name must be unique within the intent.
	//
	// SlotTypeName is a required field
	SlotTypeName *string `locationName:"slotTypeName" min:"1" type:"string" required:"true"`

	// A list of SlotTypeValue objects that defines the values that the slot type
	// can take. Each value can have a list of synonyms, additional values that
	// help train the machine learning model about the values that it resolves for
	// a slot.
	SlotTypeValues []*SlotTypeValue `locationName:"slotTypeValues" min:"1" type:"list"`

	// Determines the strategy that Amazon Lex uses to select a value from the list
	// of possible values. The field can be set to one of the following values:
	//
	//    * ORIGINAL_VALUE - Returns the value entered by the user, if the user
	//    value is similar to the slot value.
	//
	//    * TOP_RESOLUTION - If there is a resolution list for the slot, return
	//    the first value in the resolution list. If there is no resolution list,
	//    return null.
	//
	// If you don't specify the valueSelectionSetting parameter, the default is
	// ORIGINAL_VALUE.
	ValueSelectionSetting *SlotValueSelectionSetting `locationName:"valueSelectionSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSlotTypeInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotTypeName"))
	}
	if s.SlotTypeName != nil && len(*s.SlotTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeName", 1))
	}
	if s.SlotTypeValues != nil && len(s.SlotTypeValues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeValues", 1))
	}
	if s.CompositeSlotTypeSetting != nil {
		if err := s.CompositeSlotTypeSetting.Validate(); err != nil {
			invalidParams.AddNested("CompositeSlotTypeSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.ExternalSourceSetting != nil {
		if err := s.ExternalSourceSetting.Validate(); err != nil {
			invalidParams.AddNested("ExternalSourceSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.SlotTypeValues != nil {
		for i, v := range s.SlotTypeValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SlotTypeValues", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValueSelectionSetting != nil {
		if err := s.ValueSelectionSetting.Validate(); err != nil {
			invalidParams.AddNested("ValueSelectionSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotTypeInput) SetBotId(v string) *CreateSlotTypeInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotTypeInput) SetBotVersion(v string) *CreateSlotTypeInput {
	s.BotVersion = &v
	return s
}

// SetCompositeSlotTypeSetting sets the CompositeSlotTypeSetting field's value.
func (s *CreateSlotTypeInput) SetCompositeSlotTypeSetting(v *CompositeSlotTypeSetting) *CreateSlotTypeInput {
	s.CompositeSlotTypeSetting = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotTypeInput) SetDescription(v string) *CreateSlotTypeInput {
	s.Description = &v
	return s
}

// SetExternalSourceSetting sets the ExternalSourceSetting field's value.
func (s *CreateSlotTypeInput) SetExternalSourceSetting(v *ExternalSourceSetting) *CreateSlotTypeInput {
	s.ExternalSourceSetting = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotTypeInput) SetLocaleId(v string) *CreateSlotTypeInput {
	s.LocaleId = &v
	return s
}

// SetParentSlotTypeSignature sets the ParentSlotTypeSignature field's value.
func (s *CreateSlotTypeInput) SetParentSlotTypeSignature(v string) *CreateSlotTypeInput {
	s.ParentSlotTypeSignature = &v
	return s
}

// SetSlotTypeName sets the SlotTypeName field's value.
func (s *CreateSlotTypeInput) SetSlotTypeName(v string) *CreateSlotTypeInput {
	s.SlotTypeName = &v
	return s
}

// SetSlotTypeValues sets the SlotTypeValues field's value.
func (s *CreateSlotTypeInput) SetSlotTypeValues(v []*SlotTypeValue) *CreateSlotTypeInput {
	s.SlotTypeValues = v
	return s
}

// SetValueSelectionSetting sets the ValueSelectionSetting field's value.
func (s *CreateSlotTypeInput) SetValueSelectionSetting(v *SlotValueSelectionSetting) *CreateSlotTypeInput {
	s.ValueSelectionSetting = v
	return s
}

type CreateSlotTypeOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the bot associated with the slot type.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot type.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *CompositeSlotTypeSetting `locationName:"compositeSlotTypeSetting" type:"structure"`

	// A timestamp of the date and time that the slot type was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the slot type.
	Description *string `locationName:"description" type:"string"`

	// The type of external information used to create the slot type.
	ExternalSourceSetting *ExternalSourceSetting `locationName:"externalSourceSetting" type:"structure"`

	// The specified language and local specified for the slot type.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The signature of the base slot type specified for the slot type.
	ParentSlotTypeSignature *string `locationName:"parentSlotTypeSignature" type:"string"`

	// The unique identifier assigned to the slot type. Use this to identify the
	// slot type in the UpdateSlotType and DeleteSlotType operations.
	SlotTypeId *string `locationName:"slotTypeId" min:"10" type:"string"`

	// The name specified for the slot type.
	SlotTypeName *string `locationName:"slotTypeName" min:"1" type:"string"`

	// The list of values that the slot type can assume.
	SlotTypeValues []*SlotTypeValue `locationName:"slotTypeValues" min:"1" type:"list"`

	// The strategy that Amazon Lex uses to select a value from the list of possible
	// values.
	ValueSelectionSetting *SlotValueSelectionSetting `locationName:"valueSelectionSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSlotTypeOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *CreateSlotTypeOutput) SetBotId(v string) *CreateSlotTypeOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CreateSlotTypeOutput) SetBotVersion(v string) *CreateSlotTypeOutput {
	s.BotVersion = &v
	return s
}

// SetCompositeSlotTypeSetting sets the CompositeSlotTypeSetting field's value.
func (s *CreateSlotTypeOutput) SetCompositeSlotTypeSetting(v *CompositeSlotTypeSetting) *CreateSlotTypeOutput {
	s.CompositeSlotTypeSetting = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateSlotTypeOutput) SetCreationDateTime(v time.Time) *CreateSlotTypeOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSlotTypeOutput) SetDescription(v string) *CreateSlotTypeOutput {
	s.Description = &v
	return s
}

// SetExternalSourceSetting sets the ExternalSourceSetting field's value.
func (s *CreateSlotTypeOutput) SetExternalSourceSetting(v *ExternalSourceSetting) *CreateSlotTypeOutput {
	s.ExternalSourceSetting = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CreateSlotTypeOutput) SetLocaleId(v string) *CreateSlotTypeOutput {
	s.LocaleId = &v
	return s
}

// SetParentSlotTypeSignature sets the ParentSlotTypeSignature field's value.
func (s *CreateSlotTypeOutput) SetParentSlotTypeSignature(v string) *CreateSlotTypeOutput {
	s.ParentSlotTypeSignature = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *CreateSlotTypeOutput) SetSlotTypeId(v string) *CreateSlotTypeOutput {
	s.SlotTypeId = &v
	return s
}

// SetSlotTypeName sets the SlotTypeName field's value.
func (s *CreateSlotTypeOutput) SetSlotTypeName(v string) *CreateSlotTypeOutput {
	s.SlotTypeName = &v
	return s
}

// SetSlotTypeValues sets the SlotTypeValues field's value.
func (s *CreateSlotTypeOutput) SetSlotTypeValues(v []*SlotTypeValue) *CreateSlotTypeOutput {
	s.SlotTypeValues = v
	return s
}

// SetValueSelectionSetting sets the ValueSelectionSetting field's value.
func (s *CreateSlotTypeOutput) SetValueSelectionSetting(v *SlotValueSelectionSetting) *CreateSlotTypeOutput {
	s.ValueSelectionSetting = v
	return s
}

type CreateTestSetDiscrepancyReportInput struct {
	_ struct{} `type:"structure"`

	// The target bot for the test set discrepancy report.
	//
	// Target is a required field
	Target *TestSetDiscrepancyReportResourceTarget `locationName:"target" type:"structure" required:"true"`

	// The test set Id for the test set discrepancy report.
	//
	// TestSetId is a required field
	TestSetId *string `location:"uri" locationName:"testSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTestSetDiscrepancyReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTestSetDiscrepancyReportInput"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.TestSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetId"))
	}
	if s.TestSetId != nil && len(*s.TestSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetId", 10))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTarget sets the Target field's value.
func (s *CreateTestSetDiscrepancyReportInput) SetTarget(v *TestSetDiscrepancyReportResourceTarget) *CreateTestSetDiscrepancyReportInput {
	s.Target = v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *CreateTestSetDiscrepancyReportInput) SetTestSetId(v string) *CreateTestSetDiscrepancyReportInput {
	s.TestSetId = &v
	return s
}

type CreateTestSetDiscrepancyReportOutput struct {
	_ struct{} `type:"structure"`

	// The creation date and time for the test set discrepancy report.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The target bot for the test set discrepancy report.
	Target *TestSetDiscrepancyReportResourceTarget `locationName:"target" type:"structure"`

	// The unique identifier of the test set discrepancy report to describe.
	TestSetDiscrepancyReportId *string `locationName:"testSetDiscrepancyReportId" min:"10" type:"string"`

	// The test set Id for the test set discrepancy report.
	TestSetId *string `locationName:"testSetId" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTestSetDiscrepancyReportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetCreationDateTime(v time.Time) *CreateTestSetDiscrepancyReportOutput {
	s.CreationDateTime = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetTarget(v *TestSetDiscrepancyReportResourceTarget) *CreateTestSetDiscrepancyReportOutput {
	s.Target = v
	return s
}

// SetTestSetDiscrepancyReportId sets the TestSetDiscrepancyReportId field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetTestSetDiscrepancyReportId(v string) *CreateTestSetDiscrepancyReportOutput {
	s.TestSetDiscrepancyReportId = &v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *CreateTestSetDiscrepancyReportOutput) SetTestSetId(v string) *CreateTestSetDiscrepancyReportOutput {
	s.TestSetId = &v
	return s
}

type CreateUploadUrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlInput) GoString() string {
	return s.String()
}

type CreateUploadUrlOutput struct {
	_ struct{} `type:"structure"`

	// An identifier for a unique import job. Use it when you call the StartImport
	// (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_StartImport.html)
	// operation.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// A pre-signed S3 write URL. Upload the zip archive file that contains the
	// definition of your bot or bot locale.
	UploadUrl *string `locationName:"uploadUrl" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlOutput) GoString() string {
	return s.String()
}

// SetImportId sets the ImportId field's value.
func (s *CreateUploadUrlOutput) SetImportId(v string) *CreateUploadUrlOutput {
	s.ImportId = &v
	return s
}

// SetUploadUrl sets the UploadUrl field's value.
func (s *CreateUploadUrlOutput) SetUploadUrl(v string) *CreateUploadUrlOutput {
	s.UploadUrl = &v
	return s
}

// A custom response string that Amazon Lex sends to your application. You define
// the content and structure the string.
type CustomPayload struct {
	_ struct{} `type:"structure"`

	// The string that is sent to your application.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomPayload"}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValue sets the Value field's value.
func (s *CustomPayload) SetValue(v string) *CustomPayload {
	s.Value = &v
	return s
}

// The unique entry identifier for the custom vocabulary items.
type CustomVocabularyEntryId struct {
	_ struct{} `type:"structure"`

	// The unique item identifier for the custom vocabulary items.
	//
	// ItemId is a required field
	ItemId *string `locationName:"itemId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyEntryId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyEntryId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyEntryId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyEntryId"}
	if s.ItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemId"))
	}
	if s.ItemId != nil && len(*s.ItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ItemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItemId sets the ItemId field's value.
func (s *CustomVocabularyEntryId) SetItemId(v string) *CustomVocabularyEntryId {
	s.ItemId = &v
	return s
}

// Provides the parameters required for exporting a custom vocabulary.
type CustomVocabularyExportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contains the custom vocabulary to export.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that contains the custom vocabulary to export.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The locale of the bot that contains the custom vocabulary to export.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyExportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyExportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyExportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyExportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CustomVocabularyExportSpecification) SetBotId(v string) *CustomVocabularyExportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CustomVocabularyExportSpecification) SetBotVersion(v string) *CustomVocabularyExportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CustomVocabularyExportSpecification) SetLocaleId(v string) *CustomVocabularyExportSpecification {
	s.LocaleId = &v
	return s
}

// Provides the parameters required for importing a custom vocabulary.
type CustomVocabularyImportSpecification struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to import the custom vocabulary to.
	//
	// BotId is a required field
	BotId *string `locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to import the custom vocabulary to.
	//
	// BotVersion is a required field
	BotVersion *string `locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the local to import the custom vocabulary to. The value
	// must be en_GB.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyImportSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyImportSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyImportSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyImportSpecification"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *CustomVocabularyImportSpecification) SetBotId(v string) *CustomVocabularyImportSpecification {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *CustomVocabularyImportSpecification) SetBotVersion(v string) *CustomVocabularyImportSpecification {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *CustomVocabularyImportSpecification) SetLocaleId(v string) *CustomVocabularyImportSpecification {
	s.LocaleId = &v
	return s
}

// The unique custom vocabulary item from the custom vocabulary list.
type CustomVocabularyItem struct {
	_ struct{} `type:"structure"`

	// The DisplayAs value for the custom vocabulary item from the custom vocabulary
	// list.
	DisplayAs *string `locationName:"displayAs" min:"1" type:"string"`

	// The unique item identifer for the custom vocabulary item from the custom
	// vocabulary list.
	//
	// ItemId is a required field
	ItemId *string `locationName:"itemId" min:"1" type:"string" required:"true"`

	// The unique phrase for the custom vocabulary item from the custom vocabulary
	// list.
	//
	// Phrase is a required field
	Phrase *string `locationName:"phrase" min:"1" type:"string" required:"true"`

	// The weight assigned for the custom vocabulary item from the custom vocabulary
	// list.
	Weight *int64 `locationName:"weight" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomVocabularyItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomVocabularyItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomVocabularyItem"}
	if s.DisplayAs != nil && len(*s.DisplayAs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayAs", 1))
	}
	if s.ItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemId"))
	}
	if s.ItemId != nil && len(*s.ItemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ItemId", 1))
	}
	if s.Phrase == nil {
		invalidParams.Add(request.NewErrParamRequired("Phrase"))
	}
	if s.Phrase != nil && len(*s.Phrase) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Phrase", 1))
	}
	if s.Weight != nil && *s.Weight < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Weight", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayAs sets the DisplayAs field's value.
func (s *CustomVocabularyItem) SetDisplayAs(v string) *CustomVocabularyItem {
	s.DisplayAs = &v
	return s
}

// SetItemId sets the ItemId field's value.
func (s *CustomVocabularyItem) SetItemId(v string) *CustomVocabularyItem {
	s.ItemId = &v
	return s
}

// SetPhrase sets the Phrase field's value.
func (s *CustomVocabularyItem) SetPhrase(v string) *CustomVocabularyItem {
	s.Phrase = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CustomVocabularyItem) SetWeight(v int64) *CustomVocabularyItem {
	s.Weight = &v
	return s
}

// Specifies the DTMF input specifications.
type DTMFSpecification struct {
	_ struct{} `type:"structure"`

	// The DTMF character that clears the accumulated DTMF digits and immediately
	// ends the input.
	//
	// DeletionCharacter is a required field
	DeletionCharacter *string `locationName:"deletionCharacter" type:"string" required:"true"`

	// The DTMF character that immediately ends input. If the user does not press
	// this character, the input ends after the end timeout.
	//
	// EndCharacter is a required field
	EndCharacter *string `locationName:"endCharacter" type:"string" required:"true"`

	// How long the bot should wait after the last DTMF character input before assuming
	// that the input has concluded.
	//
	// EndTimeoutMs is a required field
	EndTimeoutMs *int64 `locationName:"endTimeoutMs" min:"1" type:"integer" required:"true"`

	// The maximum number of DTMF digits allowed in an utterance.
	//
	// MaxLength is a required field
	MaxLength *int64 `locationName:"maxLength" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DTMFSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DTMFSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DTMFSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DTMFSpecification"}
	if s.DeletionCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("DeletionCharacter"))
	}
	if s.EndCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("EndCharacter"))
	}
	if s.EndTimeoutMs == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeoutMs"))
	}
	if s.EndTimeoutMs != nil && *s.EndTimeoutMs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EndTimeoutMs", 1))
	}
	if s.MaxLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxLength"))
	}
	if s.MaxLength != nil && *s.MaxLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionCharacter sets the DeletionCharacter field's value.
func (s *DTMFSpecification) SetDeletionCharacter(v string) *DTMFSpecification {
	s.DeletionCharacter = &v
	return s
}

// SetEndCharacter sets the EndCharacter field's value.
func (s *DTMFSpecification) SetEndCharacter(v string) *DTMFSpecification {
	s.EndCharacter = &v
	return s
}

// SetEndTimeoutMs sets the EndTimeoutMs field's value.
func (s *DTMFSpecification) SetEndTimeoutMs(v int64) *DTMFSpecification {
	s.EndTimeoutMs = &v
	return s
}

// SetMaxLength sets the MaxLength field's value.
func (s *DTMFSpecification) SetMaxLength(v int64) *DTMFSpecification {
	s.MaxLength = &v
	return s
}

// By default, data stored by Amazon Lex is encrypted. The DataPrivacy structure
// provides settings that determine how Amazon Lex handles special cases of
// securing the data for your bot.
type DataPrivacy struct {
	_ struct{} `type:"structure"`

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service,
	// you must specify whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in
	// part, to children under age 13 and subject to the Children's Online Privacy
	// Protection Act (COPPA) by specifying true or false in the childDirected field.
	// By specifying true in the childDirected field, you confirm that your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. By specifying false in the childDirected field, you confirm
	// that your use of Amazon Lex is not related to a website, program, or other
	// application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to COPPA. You may not specify a default value for
	// the childDirected field that does not accurately reflect whether your use
	// of Amazon Lex is related to a website, program, or other application that
	// is directed or targeted, in whole or in part, to children under age 13 and
	// subject to COPPA. If your use of Amazon Lex relates to a website, program,
	// or other application that is directed in whole or in part, to children under
	// age 13, you must obtain any required verifiable parental consent under COPPA.
	// For information regarding the use of Amazon Lex in connection with websites,
	// programs, or other applications that are directed or targeted, in whole or
	// in part, to children under age 13, see the Amazon Lex FAQ (http://aws.amazon.com/lex/faqs#data-security).
	//
	// ChildDirected is a required field
	ChildDirected *bool `locationName:"childDirected" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPrivacy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataPrivacy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataPrivacy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataPrivacy"}
	if s.ChildDirected == nil {
		invalidParams.Add(request.NewErrParamRequired("ChildDirected"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildDirected sets the ChildDirected field's value.
func (s *DataPrivacy) SetChildDirected(v bool) *DataPrivacy {
	s.ChildDirected = &v
	return s
}

// The object used for specifying the data range that the customer wants Amazon
// Lex to read through in the input transcripts.
type DateRangeFilter struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating the end date for the date range filter.
	//
	// EndDateTime is a required field
	EndDateTime *time.Time `locationName:"endDateTime" type:"timestamp" required:"true"`

	// A timestamp indicating the start date for the date range filter.
	//
	// StartDateTime is a required field
	StartDateTime *time.Time `locationName:"startDateTime" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateRangeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateRangeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateRangeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateRangeFilter"}
	if s.EndDateTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDateTime"))
	}
	if s.StartDateTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDateTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *DateRangeFilter) SetEndDateTime(v time.Time) *DateRangeFilter {
	s.EndDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *DateRangeFilter) SetStartDateTime(v time.Time) *DateRangeFilter {
	s.StartDateTime = &v
	return s
}

// A set of actions that Amazon Lex should run if none of the other conditions
// are met.
type DefaultConditionalBranch struct {
	_ struct{} `type:"structure"`

	// The next step in the conversation.
	NextStep *DialogState `locationName:"nextStep" type:"structure"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	Response *ResponseSpecification `locationName:"response" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultConditionalBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultConditionalBranch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultConditionalBranch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefaultConditionalBranch"}
	if s.NextStep != nil {
		if err := s.NextStep.Validate(); err != nil {
			invalidParams.AddNested("NextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.Response != nil {
		if err := s.Response.Validate(); err != nil {
			invalidParams.AddNested("Response", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextStep sets the NextStep field's value.
func (s *DefaultConditionalBranch) SetNextStep(v *DialogState) *DefaultConditionalBranch {
	s.NextStep = v
	return s
}

// SetResponse sets the Response field's value.
func (s *DefaultConditionalBranch) SetResponse(v *ResponseSpecification) *DefaultConditionalBranch {
	s.Response = v
	return s
}

type DeleteBotAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot alias to delete.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The unique identifier of the bot associated with the alias to delete.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// By default, Amazon Lex checks if any other resource, such as a bot network,
	// is using the bot alias before it is deleted and throws a ResourceInUseException
	// exception if the alias is being used by another resource. Set this parameter
	// to true to skip this check and remove the alias even if it is being used
	// by another resource.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotAliasInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DeleteBotAliasInput) SetBotAliasId(v string) *DeleteBotAliasInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotAliasInput) SetBotId(v string) *DeleteBotAliasInput {
	s.BotId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteBotAliasInput) SetSkipResourceInUseCheck(v bool) *DeleteBotAliasInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot alias to delete.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The current status of the alias. The status is Deleting while the alias is
	// in the process of being deleted. Once the alias is deleted, it will no longer
	// appear in the list of aliases returned by the ListBotAliases operation.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The unique identifier of the bot that contains the alias to delete.
	BotId *string `locationName:"botId" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DeleteBotAliasOutput) SetBotAliasId(v string) *DeleteBotAliasOutput {
	s.BotAliasId = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *DeleteBotAliasOutput) SetBotAliasStatus(v string) *DeleteBotAliasOutput {
	s.BotAliasStatus = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotAliasOutput) SetBotId(v string) *DeleteBotAliasOutput {
	s.BotId = &v
	return s
}

type DeleteBotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot to delete.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// By default, Amazon Lex checks if any other resource, such as an alias or
	// bot network, is using the bot version before it is deleted and throws a ResourceInUseException
	// exception if the bot is being used by another resource. Set this parameter
	// to true to skip this check and remove the bot even if it is being used by
	// another resource.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotInput) SetBotId(v string) *DeleteBotInput {
	s.BotId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteBotInput) SetSkipResourceInUseCheck(v bool) *DeleteBotInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteBotLocaleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot that contains the locale.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that contains the locale.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that will be deleted. The string
	// must match one of the supported locales. For more information, see Supported
	// languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotLocaleInput) SetBotId(v string) *DeleteBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotLocaleInput) SetBotVersion(v string) *DeleteBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteBotLocaleInput) SetLocaleId(v string) *DeleteBotLocaleInput {
	s.LocaleId = &v
	return s
}

type DeleteBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contained the deleted locale.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The status of deleting the bot locale. The locale first enters the Deleting
	// status. Once the locale is deleted it no longer appears in the list of locales
	// for the bot.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The version of the bot that contained the deleted locale.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The language and locale of the deleted locale.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotLocaleOutput) SetBotId(v string) *DeleteBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *DeleteBotLocaleOutput) SetBotLocaleStatus(v string) *DeleteBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotLocaleOutput) SetBotVersion(v string) *DeleteBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteBotLocaleOutput) SetLocaleId(v string) *DeleteBotLocaleOutput {
	s.LocaleId = &v
	return s
}

type DeleteBotOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot that Amazon Lex is deleting.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The current status of the bot. The status is Deleting while the bot and its
	// associated resources are being deleted.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotOutput) SetBotId(v string) *DeleteBotOutput {
	s.BotId = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DeleteBotOutput) SetBotStatus(v string) *DeleteBotOutput {
	s.BotStatus = &v
	return s
}

type DeleteBotVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot that contains the version.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to delete.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// By default, Amazon Lex checks if any other resource, such as an alias or
	// bot network, is using the bot version before it is deleted and throws a ResourceInUseException
	// exception if the version is being used by another resource. Set this parameter
	// to true to skip this check and remove the version even if it is being used
	// by another resource.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBotVersionInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotVersionInput) SetBotId(v string) *DeleteBotVersionInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotVersionInput) SetBotVersion(v string) *DeleteBotVersionInput {
	s.BotVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteBotVersionInput) SetSkipResourceInUseCheck(v bool) *DeleteBotVersionInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that is being deleted.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The current status of the bot.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The version of the bot that is being deleted.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBotVersionOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteBotVersionOutput) SetBotId(v string) *DeleteBotVersionOutput {
	s.BotId = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DeleteBotVersionOutput) SetBotStatus(v string) *DeleteBotVersionOutput {
	s.BotStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteBotVersionOutput) SetBotVersion(v string) *DeleteBotVersionOutput {
	s.BotVersion = &v
	return s
}

type DeleteCustomVocabularyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot to remove the custom vocabulary from.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to remove the custom vocabulary from.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The locale identifier for the locale that contains the custom vocabulary
	// to remove.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomVocabularyInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteCustomVocabularyInput) SetBotId(v string) *DeleteCustomVocabularyInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteCustomVocabularyInput) SetBotVersion(v string) *DeleteCustomVocabularyInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteCustomVocabularyInput) SetLocaleId(v string) *DeleteCustomVocabularyInput {
	s.LocaleId = &v
	return s
}

type DeleteCustomVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that the custom vocabulary was removed from.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot that the custom vocabulary was removed from.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The status of removing the custom vocabulary.
	CustomVocabularyStatus *string `locationName:"customVocabularyStatus" type:"string" enum:"CustomVocabularyStatus"`

	// The locale identifier for the locale that the custom vocabulary was removed
	// from.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomVocabularyOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DeleteCustomVocabularyOutput) SetBotId(v string) *DeleteCustomVocabularyOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteCustomVocabularyOutput) SetBotVersion(v string) *DeleteCustomVocabularyOutput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyStatus sets the CustomVocabularyStatus field's value.
func (s *DeleteCustomVocabularyOutput) SetCustomVocabularyStatus(v string) *DeleteCustomVocabularyOutput {
	s.CustomVocabularyStatus = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteCustomVocabularyOutput) SetLocaleId(v string) *DeleteCustomVocabularyOutput {
	s.LocaleId = &v
	return s
}

type DeleteExportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the export to delete.
	//
	// ExportId is a required field
	ExportId *string `location:"uri" locationName:"exportId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *DeleteExportInput) SetExportId(v string) *DeleteExportInput {
	s.ExportId = &v
	return s
}

type DeleteExportOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the deleted export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The current status of the deletion. When the deletion is complete, the export
	// will no longer be returned by the ListExports (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html)
	// operation and calls to the DescribeExport (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeExport.html)
	// operation with the export identifier will fail.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteExportOutput) GoString() string {
	return s.String()
}

// SetExportId sets the ExportId field's value.
func (s *DeleteExportOutput) SetExportId(v string) *DeleteExportOutput {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *DeleteExportOutput) SetExportStatus(v string) *DeleteExportOutput {
	s.ExportStatus = &v
	return s
}

type DeleteImportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the import to delete.
	//
	// ImportId is a required field
	ImportId *string `location:"uri" locationName:"importId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImportInput"}
	if s.ImportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportId"))
	}
	if s.ImportId != nil && len(*s.ImportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ImportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportId sets the ImportId field's value.
func (s *DeleteImportInput) SetImportId(v string) *DeleteImportInput {
	s.ImportId = &v
	return s
}

type DeleteImportOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the deleted import.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// The current status of the deletion. When the deletion is complete, the import
	// will no longer be returned by the ListImports (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html)
	// operation and calls to the DescribeImport (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeImport.html)
	// operation with the import identifier will fail.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImportOutput) GoString() string {
	return s.String()
}

// SetImportId sets the ImportId field's value.
func (s *DeleteImportOutput) SetImportId(v string) *DeleteImportOutput {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *DeleteImportOutput) SetImportStatus(v string) *DeleteImportOutput {
	s.ImportStatus = &v
	return s
}

type DeleteIntentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the intent.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the intent.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The unique identifier of the intent to delete.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale where the bot will be deleted.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntentInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteIntentInput) SetBotId(v string) *DeleteIntentInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteIntentInput) SetBotVersion(v string) *DeleteIntentInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DeleteIntentInput) SetIntentId(v string) *DeleteIntentInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteIntentInput) SetLocaleId(v string) *DeleteIntentInput {
	s.LocaleId = &v
	return s
}

type DeleteIntentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntentOutput) GoString() string {
	return s.String()
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the revision to edit. If this ID doesn't match the current
	// revision number, Amazon Lex returns an exception
	//
	// If you don't specify a revision ID, Amazon Lex will delete the current policy.
	ExpectedRevisionId *string `location:"querystring" locationName:"expectedRevisionId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that has the resource
	// policy attached.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ExpectedRevisionId != nil && len(*s.ExpectedRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpectedRevisionId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedRevisionId sets the ExpectedRevisionId field's value.
func (s *DeleteResourcePolicyInput) SetExpectedRevisionId(v string) *DeleteResourcePolicyInput {
	s.ExpectedRevisionId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy was deleted from.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyOutput) SetResourceArn(v string) *DeleteResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DeleteResourcePolicyOutput) SetRevisionId(v string) *DeleteResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type DeleteResourcePolicyStatementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the revision of the policy to delete the statement from.
	// If this revision ID doesn't match the current revision ID, Amazon Lex throws
	// an exception.
	//
	// If you don't specify a revision, Amazon Lex removes the current contents
	// of the statement.
	ExpectedRevisionId *string `location:"querystring" locationName:"expectedRevisionId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The name of the statement (SID) to delete from the policy.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"statementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyStatementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyStatementInput"}
	if s.ExpectedRevisionId != nil && len(*s.ExpectedRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExpectedRevisionId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpectedRevisionId sets the ExpectedRevisionId field's value.
func (s *DeleteResourcePolicyStatementInput) SetExpectedRevisionId(v string) *DeleteResourcePolicyStatementInput {
	s.ExpectedRevisionId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyStatementInput) SetResourceArn(v string) *DeleteResourcePolicyStatementInput {
	s.ResourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *DeleteResourcePolicyStatementInput) SetStatementId(v string) *DeleteResourcePolicyStatementInput {
	s.StatementId = &v
	return s
}

type DeleteResourcePolicyStatementOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy statement was removed from.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyStatementOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyStatementOutput) SetResourceArn(v string) *DeleteResourcePolicyStatementOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DeleteResourcePolicyStatementOutput) SetRevisionId(v string) *DeleteResourcePolicyStatementOutput {
	s.RevisionId = &v
	return s
}

type DeleteSlotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot to delete.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot to delete.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the intent associated with the slot.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale that the slot will be deleted from.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The identifier of the slot to delete.
	//
	// SlotId is a required field
	SlotId *string `location:"uri" locationName:"slotId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotId"))
	}
	if s.SlotId != nil && len(*s.SlotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteSlotInput) SetBotId(v string) *DeleteSlotInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteSlotInput) SetBotVersion(v string) *DeleteSlotInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DeleteSlotInput) SetIntentId(v string) *DeleteSlotInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteSlotInput) SetLocaleId(v string) *DeleteSlotInput {
	s.LocaleId = &v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *DeleteSlotInput) SetSlotId(v string) *DeleteSlotInput {
	s.SlotId = &v
	return s
}

type DeleteSlotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotOutput) GoString() string {
	return s.String()
}

type DeleteSlotTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot type.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot type.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale that the slot type will be deleted
	// from. The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// By default, the DeleteSlotType operations throws a ResourceInUseException
	// exception if you try to delete a slot type used by a slot. Set the skipResourceInUseCheck
	// parameter to true to skip this check and remove the slot type even if a slot
	// uses it.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`

	// The identifier of the slot type to delete.
	//
	// SlotTypeId is a required field
	SlotTypeId *string `location:"uri" locationName:"slotTypeId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSlotTypeInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotTypeId"))
	}
	if s.SlotTypeId != nil && len(*s.SlotTypeId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteSlotTypeInput) SetBotId(v string) *DeleteSlotTypeInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DeleteSlotTypeInput) SetBotVersion(v string) *DeleteSlotTypeInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteSlotTypeInput) SetLocaleId(v string) *DeleteSlotTypeInput {
	s.LocaleId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteSlotTypeInput) SetSkipResourceInUseCheck(v bool) *DeleteSlotTypeInput {
	s.SkipResourceInUseCheck = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *DeleteSlotTypeInput) SetSlotTypeId(v string) *DeleteSlotTypeInput {
	s.SlotTypeId = &v
	return s
}

type DeleteSlotTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSlotTypeOutput) GoString() string {
	return s.String()
}

type DeleteTestSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The test set Id of the test set to be deleted.
	//
	// TestSetId is a required field
	TestSetId *string `location:"uri" locationName:"testSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTestSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTestSetInput"}
	if s.TestSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetId"))
	}
	if s.TestSetId != nil && len(*s.TestSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSetId sets the TestSetId field's value.
func (s *DeleteTestSetInput) SetTestSetId(v string) *DeleteTestSetInput {
	s.TestSetId = &v
	return s
}

type DeleteTestSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTestSetOutput) GoString() string {
	return s.String()
}

type DeleteUtterancesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot that contains the utterances.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale where the utterances were collected.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `location:"querystring" locationName:"localeId" type:"string"`

	// The unique identifier of the session with the user. The ID is returned in
	// the response from the RecognizeText (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeText.html)
	// and RecognizeUtterance (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeUtterance.html)
	// operations.
	SessionId *string `location:"querystring" locationName:"sessionId" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUtterancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUtterancesInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.SessionId != nil && len(*s.SessionId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DeleteUtterancesInput) SetBotId(v string) *DeleteUtterancesInput {
	s.BotId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DeleteUtterancesInput) SetLocaleId(v string) *DeleteUtterancesInput {
	s.LocaleId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *DeleteUtterancesInput) SetSessionId(v string) *DeleteUtterancesInput {
	s.SessionId = &v
	return s
}

type DeleteUtterancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUtterancesOutput) GoString() string {
	return s.String()
}

type DescribeBotAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot alias to describe.
	//
	// BotAliasId is a required field
	BotAliasId *string `location:"uri" locationName:"botAliasId" min:"10" type:"string" required:"true"`

	// The identifier of the bot associated with the bot alias to describe.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotAliasInput"}
	if s.BotAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasId"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DescribeBotAliasInput) SetBotAliasId(v string) *DescribeBotAliasInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotAliasInput) SetBotId(v string) *DescribeBotAliasInput {
	s.BotId = &v
	return s
}

type DescribeBotAliasOutput struct {
	_ struct{} `type:"structure"`

	// A list of events that affect a bot alias. For example, an event is recorded
	// when the version that the alias points to changes.
	BotAliasHistoryEvents []*BotAliasHistoryEvent `locationName:"botAliasHistoryEvents" type:"list"`

	// The identifier of the bot alias.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The locale settings that are unique to the alias.
	BotAliasLocaleSettings map[string]*BotAliasLocaleSettings `locationName:"botAliasLocaleSettings" min:"1" type:"map"`

	// The name of the bot alias.
	BotAliasName *string `locationName:"botAliasName" min:"1" type:"string"`

	// The current status of the alias. When the alias is Available, the alias is
	// ready for use with your bot.
	BotAliasStatus *string `locationName:"botAliasStatus" type:"string" enum:"BotAliasStatus"`

	// The identifier of the bot associated with the bot alias.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the bot alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Specifics of how Amazon Lex logs text and audio conversations with the bot
	// associated with the alias.
	ConversationLogSettings *ConversationLogSettings `locationName:"conversationLogSettings" type:"structure"`

	// A timestamp of the date and time that the alias was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the bot alias.
	Description *string `locationName:"description" type:"string"`

	// A timestamp of the date and time that the alias was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// A list of the networks to which the bot alias you described belongs.
	ParentBotNetworks []*ParentBotNetwork `locationName:"parentBotNetworks" type:"list"`

	// Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment
	// of user utterances.
	SentimentAnalysisSettings *SentimentAnalysisSettings `locationName:"sentimentAnalysisSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotAliasOutput) GoString() string {
	return s.String()
}

// SetBotAliasHistoryEvents sets the BotAliasHistoryEvents field's value.
func (s *DescribeBotAliasOutput) SetBotAliasHistoryEvents(v []*BotAliasHistoryEvent) *DescribeBotAliasOutput {
	s.BotAliasHistoryEvents = v
	return s
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *DescribeBotAliasOutput) SetBotAliasId(v string) *DescribeBotAliasOutput {
	s.BotAliasId = &v
	return s
}

// SetBotAliasLocaleSettings sets the BotAliasLocaleSettings field's value.
func (s *DescribeBotAliasOutput) SetBotAliasLocaleSettings(v map[string]*BotAliasLocaleSettings) *DescribeBotAliasOutput {
	s.BotAliasLocaleSettings = v
	return s
}

// SetBotAliasName sets the BotAliasName field's value.
func (s *DescribeBotAliasOutput) SetBotAliasName(v string) *DescribeBotAliasOutput {
	s.BotAliasName = &v
	return s
}

// SetBotAliasStatus sets the BotAliasStatus field's value.
func (s *DescribeBotAliasOutput) SetBotAliasStatus(v string) *DescribeBotAliasOutput {
	s.BotAliasStatus = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotAliasOutput) SetBotId(v string) *DescribeBotAliasOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotAliasOutput) SetBotVersion(v string) *DescribeBotAliasOutput {
	s.BotVersion = &v
	return s
}

// SetConversationLogSettings sets the ConversationLogSettings field's value.
func (s *DescribeBotAliasOutput) SetConversationLogSettings(v *ConversationLogSettings) *DescribeBotAliasOutput {
	s.ConversationLogSettings = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotAliasOutput) SetCreationDateTime(v time.Time) *DescribeBotAliasOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotAliasOutput) SetDescription(v string) *DescribeBotAliasOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotAliasOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotAliasOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetParentBotNetworks sets the ParentBotNetworks field's value.
func (s *DescribeBotAliasOutput) SetParentBotNetworks(v []*ParentBotNetwork) *DescribeBotAliasOutput {
	s.ParentBotNetworks = v
	return s
}

// SetSentimentAnalysisSettings sets the SentimentAnalysisSettings field's value.
func (s *DescribeBotAliasOutput) SetSentimentAnalysisSettings(v *SentimentAnalysisSettings) *DescribeBotAliasOutput {
	s.SentimentAnalysisSettings = v
	return s
}

type DescribeBotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot to describe.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotInput) SetBotId(v string) *DescribeBotInput {
	s.BotId = &v
	return s
}

type DescribeBotLocaleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the locale.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the locale.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The unique identifier of the locale to describe. The string must match one
	// of the supported locales. For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotLocaleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotLocaleInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotLocaleInput) SetBotId(v string) *DescribeBotLocaleInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotLocaleInput) SetBotVersion(v string) *DescribeBotLocaleInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotLocaleInput) SetLocaleId(v string) *DescribeBotLocaleInput {
	s.LocaleId = &v
	return s
}

type DescribeBotLocaleOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the locale.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// History of changes, such as when a locale is used in an alias, that have
	// taken place for the locale.
	BotLocaleHistoryEvents []*BotLocaleHistoryEvent `locationName:"botLocaleHistoryEvents" type:"list"`

	// The status of the bot. If the status is Failed, the reasons for the failure
	// are listed in the failureReasons field.
	BotLocaleStatus *string `locationName:"botLocaleStatus" type:"string" enum:"BotLocaleStatus"`

	// The version of the bot associated with the locale.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time that the locale was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the locale.
	Description *string `locationName:"description" type:"string"`

	// if botLocaleStatus is Failed, Amazon Lex explains why it failed to build
	// the bot.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The number of intents defined for the locale.
	IntentsCount *int64 `locationName:"intentsCount" type:"integer"`

	// The date and time that the locale was last submitted for building.
	LastBuildSubmittedDateTime *time.Time `locationName:"lastBuildSubmittedDateTime" type:"timestamp"`

	// The date and time that the locale was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The unique identifier of the described locale.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The name of the locale.
	LocaleName *string `locationName:"localeName" type:"string"`

	// The confidence threshold where Amazon Lex inserts the AMAZON.FallbackIntent
	// and AMAZON.KendraSearchIntent intents in the list of possible intents for
	// an utterance.
	NluIntentConfidenceThreshold *float64 `locationName:"nluIntentConfidenceThreshold" type:"double"`

	// Recommended actions to take to resolve an error in the failureReasons field.
	RecommendedActions []*string `locationName:"recommendedActions" type:"list"`

	// The number of slot types defined for the locale.
	SlotTypesCount *int64 `locationName:"slotTypesCount" type:"integer"`

	// The Amazon Polly voice Amazon Lex uses for voice interaction with the user.
	VoiceSettings *VoiceSettings `locationName:"voiceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotLocaleOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotLocaleOutput) SetBotId(v string) *DescribeBotLocaleOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleHistoryEvents sets the BotLocaleHistoryEvents field's value.
func (s *DescribeBotLocaleOutput) SetBotLocaleHistoryEvents(v []*BotLocaleHistoryEvent) *DescribeBotLocaleOutput {
	s.BotLocaleHistoryEvents = v
	return s
}

// SetBotLocaleStatus sets the BotLocaleStatus field's value.
func (s *DescribeBotLocaleOutput) SetBotLocaleStatus(v string) *DescribeBotLocaleOutput {
	s.BotLocaleStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotLocaleOutput) SetBotVersion(v string) *DescribeBotLocaleOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotLocaleOutput) SetCreationDateTime(v time.Time) *DescribeBotLocaleOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotLocaleOutput) SetDescription(v string) *DescribeBotLocaleOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotLocaleOutput) SetFailureReasons(v []*string) *DescribeBotLocaleOutput {
	s.FailureReasons = v
	return s
}

// SetIntentsCount sets the IntentsCount field's value.
func (s *DescribeBotLocaleOutput) SetIntentsCount(v int64) *DescribeBotLocaleOutput {
	s.IntentsCount = &v
	return s
}

// SetLastBuildSubmittedDateTime sets the LastBuildSubmittedDateTime field's value.
func (s *DescribeBotLocaleOutput) SetLastBuildSubmittedDateTime(v time.Time) *DescribeBotLocaleOutput {
	s.LastBuildSubmittedDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotLocaleOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotLocaleOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotLocaleOutput) SetLocaleId(v string) *DescribeBotLocaleOutput {
	s.LocaleId = &v
	return s
}

// SetLocaleName sets the LocaleName field's value.
func (s *DescribeBotLocaleOutput) SetLocaleName(v string) *DescribeBotLocaleOutput {
	s.LocaleName = &v
	return s
}

// SetNluIntentConfidenceThreshold sets the NluIntentConfidenceThreshold field's value.
func (s *DescribeBotLocaleOutput) SetNluIntentConfidenceThreshold(v float64) *DescribeBotLocaleOutput {
	s.NluIntentConfidenceThreshold = &v
	return s
}

// SetRecommendedActions sets the RecommendedActions field's value.
func (s *DescribeBotLocaleOutput) SetRecommendedActions(v []*string) *DescribeBotLocaleOutput {
	s.RecommendedActions = v
	return s
}

// SetSlotTypesCount sets the SlotTypesCount field's value.
func (s *DescribeBotLocaleOutput) SetSlotTypesCount(v int64) *DescribeBotLocaleOutput {
	s.SlotTypesCount = &v
	return s
}

// SetVoiceSettings sets the VoiceSettings field's value.
func (s *DescribeBotLocaleOutput) SetVoiceSettings(v *VoiceSettings) *DescribeBotLocaleOutput {
	s.VoiceSettings = v
	return s
}

type DescribeBotOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The list of bots in the network that was described.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name of the bot.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The current status of the bot. When the status is Available the bot is ready
	// to be used in conversations with users.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The type of the bot that was described.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// A timestamp of the date and time that the bot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Settings for managing data privacy of the bot and its conversations with
	// users.
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure"`

	// The description of the bot.
	Description *string `locationName:"description" type:"string"`

	// If the botStatus is Failed, this contains a list of reasons that the bot
	// couldn't be built.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The maximum time in seconds that Amazon Lex retains the data gathered in
	// a conversation.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// A timestamp of the date and time that the bot was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access
	// the bot.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotOutput) SetBotId(v string) *DescribeBotOutput {
	s.BotId = &v
	return s
}

// SetBotMembers sets the BotMembers field's value.
func (s *DescribeBotOutput) SetBotMembers(v []*BotMember) *DescribeBotOutput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *DescribeBotOutput) SetBotName(v string) *DescribeBotOutput {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DescribeBotOutput) SetBotStatus(v string) *DescribeBotOutput {
	s.BotStatus = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *DescribeBotOutput) SetBotType(v string) *DescribeBotOutput {
	s.BotType = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotOutput) SetCreationDateTime(v time.Time) *DescribeBotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *DescribeBotOutput) SetDataPrivacy(v *DataPrivacy) *DescribeBotOutput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotOutput) SetDescription(v string) *DescribeBotOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotOutput) SetFailureReasons(v []*string) *DescribeBotOutput {
	s.FailureReasons = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *DescribeBotOutput) SetIdleSessionTTLInSeconds(v int64) *DescribeBotOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeBotOutput) SetRoleArn(v string) *DescribeBotOutput {
	s.RoleArn = &v
	return s
}

type DescribeBotRecommendationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot associated with the bot recommendation.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the bot recommendation to describe.
	//
	// BotRecommendationId is a required field
	BotRecommendationId *string `location:"uri" locationName:"botRecommendationId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the bot recommendation.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale of the bot recommendation to describe.
	// The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotRecommendationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotRecommendationInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotRecommendationId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotRecommendationId"))
	}
	if s.BotRecommendationId != nil && len(*s.BotRecommendationId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotRecommendationId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotRecommendationInput) SetBotId(v string) *DescribeBotRecommendationInput {
	s.BotId = &v
	return s
}

// SetBotRecommendationId sets the BotRecommendationId field's value.
func (s *DescribeBotRecommendationInput) SetBotRecommendationId(v string) *DescribeBotRecommendationInput {
	s.BotRecommendationId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotRecommendationInput) SetBotVersion(v string) *DescribeBotRecommendationInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotRecommendationInput) SetLocaleId(v string) *DescribeBotRecommendationInput {
	s.LocaleId = &v
	return s
}

type DescribeBotRecommendationOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the bot recommendation.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the bot recommendation being described.
	BotRecommendationId *string `locationName:"botRecommendationId" min:"10" type:"string"`

	// The object representing the URL of the bot definition, the URL of the associated
	// transcript and a statistical summary of the bot recommendation results.
	BotRecommendationResults *BotRecommendationResults `locationName:"botRecommendationResults" type:"structure"`

	// The status of the bot recommendation. If the status is Failed, then the reasons
	// for the failure are listed in the failureReasons field.
	BotRecommendationStatus *string `locationName:"botRecommendationStatus" type:"string" enum:"BotRecommendationStatus"`

	// The version of the bot associated with the bot recommendation.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The date and time that the bot recommendation was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The object representing the passwords that were used to encrypt the data
	// related to the bot recommendation results, as well as the KMS key ARN used
	// to encrypt the associated metadata.
	EncryptionSetting *EncryptionSetting `locationName:"encryptionSetting" type:"structure"`

	// If botRecommendationStatus is Failed, Amazon Lex explains why.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The date and time that the bot recommendation was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The identifier of the language and locale of the bot recommendation to describe.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The object representing the Amazon S3 bucket containing the transcript, as
	// well as the associated metadata.
	TranscriptSourceSetting *TranscriptSourceSetting `locationName:"transcriptSourceSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotRecommendationOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotRecommendationOutput) SetBotId(v string) *DescribeBotRecommendationOutput {
	s.BotId = &v
	return s
}

// SetBotRecommendationId sets the BotRecommendationId field's value.
func (s *DescribeBotRecommendationOutput) SetBotRecommendationId(v string) *DescribeBotRecommendationOutput {
	s.BotRecommendationId = &v
	return s
}

// SetBotRecommendationResults sets the BotRecommendationResults field's value.
func (s *DescribeBotRecommendationOutput) SetBotRecommendationResults(v *BotRecommendationResults) *DescribeBotRecommendationOutput {
	s.BotRecommendationResults = v
	return s
}

// SetBotRecommendationStatus sets the BotRecommendationStatus field's value.
func (s *DescribeBotRecommendationOutput) SetBotRecommendationStatus(v string) *DescribeBotRecommendationOutput {
	s.BotRecommendationStatus = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotRecommendationOutput) SetBotVersion(v string) *DescribeBotRecommendationOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotRecommendationOutput) SetCreationDateTime(v time.Time) *DescribeBotRecommendationOutput {
	s.CreationDateTime = &v
	return s
}

// SetEncryptionSetting sets the EncryptionSetting field's value.
func (s *DescribeBotRecommendationOutput) SetEncryptionSetting(v *EncryptionSetting) *DescribeBotRecommendationOutput {
	s.EncryptionSetting = v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotRecommendationOutput) SetFailureReasons(v []*string) *DescribeBotRecommendationOutput {
	s.FailureReasons = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeBotRecommendationOutput) SetLastUpdatedDateTime(v time.Time) *DescribeBotRecommendationOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeBotRecommendationOutput) SetLocaleId(v string) *DescribeBotRecommendationOutput {
	s.LocaleId = &v
	return s
}

// SetTranscriptSourceSetting sets the TranscriptSourceSetting field's value.
func (s *DescribeBotRecommendationOutput) SetTranscriptSourceSetting(v *TranscriptSourceSetting) *DescribeBotRecommendationOutput {
	s.TranscriptSourceSetting = v
	return s
}

type DescribeBotVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot containing the version to return metadata for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to return metadata for.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBotVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBotVersionInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotVersionInput) SetBotId(v string) *DescribeBotVersionInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotVersionInput) SetBotVersion(v string) *DescribeBotVersionInput {
	s.BotVersion = &v
	return s
}

type DescribeBotVersionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contains the version.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The members of bot network in the version that was described.
	BotMembers []*BotMember `locationName:"botMembers" type:"list"`

	// The name of the bot that contains the version.
	BotName *string `locationName:"botName" min:"1" type:"string"`

	// The current status of the bot. When the status is Available, the bot version
	// is ready for use.
	BotStatus *string `locationName:"botStatus" type:"string" enum:"BotStatus"`

	// The type of the bot in the version that was described.
	BotType *string `locationName:"botType" type:"string" enum:"BotType"`

	// The version of the bot that was described.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the bot version was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Data privacy settings for the bot version.
	DataPrivacy *DataPrivacy `locationName:"dataPrivacy" type:"structure"`

	// The description specified for the bot.
	Description *string `locationName:"description" type:"string"`

	// If the botStatus is Failed, this contains a list of reasons that the version
	// couldn't be built.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The number of seconds that a session with the bot remains active before it
	// is discarded by Amazon Lex.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// A list of the networks to which the bot version you described belongs.
	ParentBotNetworks []*ParentBotNetwork `locationName:"parentBotNetworks" type:"list"`

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access
	// the bot version.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBotVersionOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeBotVersionOutput) SetBotId(v string) *DescribeBotVersionOutput {
	s.BotId = &v
	return s
}

// SetBotMembers sets the BotMembers field's value.
func (s *DescribeBotVersionOutput) SetBotMembers(v []*BotMember) *DescribeBotVersionOutput {
	s.BotMembers = v
	return s
}

// SetBotName sets the BotName field's value.
func (s *DescribeBotVersionOutput) SetBotName(v string) *DescribeBotVersionOutput {
	s.BotName = &v
	return s
}

// SetBotStatus sets the BotStatus field's value.
func (s *DescribeBotVersionOutput) SetBotStatus(v string) *DescribeBotVersionOutput {
	s.BotStatus = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *DescribeBotVersionOutput) SetBotType(v string) *DescribeBotVersionOutput {
	s.BotType = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeBotVersionOutput) SetBotVersion(v string) *DescribeBotVersionOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeBotVersionOutput) SetCreationDateTime(v time.Time) *DescribeBotVersionOutput {
	s.CreationDateTime = &v
	return s
}

// SetDataPrivacy sets the DataPrivacy field's value.
func (s *DescribeBotVersionOutput) SetDataPrivacy(v *DataPrivacy) *DescribeBotVersionOutput {
	s.DataPrivacy = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeBotVersionOutput) SetDescription(v string) *DescribeBotVersionOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeBotVersionOutput) SetFailureReasons(v []*string) *DescribeBotVersionOutput {
	s.FailureReasons = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *DescribeBotVersionOutput) SetIdleSessionTTLInSeconds(v int64) *DescribeBotVersionOutput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetParentBotNetworks sets the ParentBotNetworks field's value.
func (s *DescribeBotVersionOutput) SetParentBotNetworks(v []*ParentBotNetwork) *DescribeBotVersionOutput {
	s.ParentBotNetworks = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeBotVersionOutput) SetRoleArn(v string) *DescribeBotVersionOutput {
	s.RoleArn = &v
	return s
}

type DescribeCustomVocabularyMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the bot that contains the custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The bot version of the bot to return metadata for.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The locale to return the custom vocabulary information for. The locale must
	// be en_GB.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomVocabularyMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomVocabularyMetadataInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeCustomVocabularyMetadataInput) SetBotId(v string) *DescribeCustomVocabularyMetadataInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeCustomVocabularyMetadataInput) SetBotVersion(v string) *DescribeCustomVocabularyMetadataInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeCustomVocabularyMetadataInput) SetLocaleId(v string) *DescribeCustomVocabularyMetadataInput {
	s.LocaleId = &v
	return s
}

type DescribeCustomVocabularyMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot that contains the custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot that contains the custom vocabulary to describe.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The date and time that the custom vocabulary was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The status of the custom vocabulary. If the status is Ready the custom vocabulary
	// is ready to use.
	CustomVocabularyStatus *string `locationName:"customVocabularyStatus" type:"string" enum:"CustomVocabularyStatus"`

	// The date and time that the custom vocabulary was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The locale that contains the custom vocabulary to describe.
	LocaleId *string `locationName:"localeId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCustomVocabularyMetadataOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetBotId(v string) *DescribeCustomVocabularyMetadataOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetBotVersion(v string) *DescribeCustomVocabularyMetadataOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetCreationDateTime(v time.Time) *DescribeCustomVocabularyMetadataOutput {
	s.CreationDateTime = &v
	return s
}

// SetCustomVocabularyStatus sets the CustomVocabularyStatus field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetCustomVocabularyStatus(v string) *DescribeCustomVocabularyMetadataOutput {
	s.CustomVocabularyStatus = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetLastUpdatedDateTime(v time.Time) *DescribeCustomVocabularyMetadataOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeCustomVocabularyMetadataOutput) SetLocaleId(v string) *DescribeCustomVocabularyMetadataOutput {
	s.LocaleId = &v
	return s
}

type DescribeExportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the export to describe.
	//
	// ExportId is a required field
	ExportId *string `location:"uri" locationName:"exportId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeExportInput"}
	if s.ExportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportId"))
	}
	if s.ExportId != nil && len(*s.ExportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ExportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportId sets the ExportId field's value.
func (s *DescribeExportInput) SetExportId(v string) *DescribeExportInput {
	s.ExportId = &v
	return s
}

type DescribeExportOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the export was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// A pre-signed S3 URL that points to the bot or bot locale archive. The URL
	// is only available for 5 minutes after calling the DescribeExport operation.
	DownloadUrl *string `locationName:"downloadUrl" min:"1" type:"string"`

	// The unique identifier of the described export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The status of the export. When the status is Complete the export archive
	// file is available for download.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`

	// If the exportStatus is failed, contains one or more reasons why the export
	// could not be completed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The file format used in the files that describe the resource.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"ImportExportFileFormat"`

	// The last date and time that the export was updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The bot, bot ID, and optional locale ID of the exported bot or bot locale.
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeExportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeExportOutput) SetCreationDateTime(v time.Time) *DescribeExportOutput {
	s.CreationDateTime = &v
	return s
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *DescribeExportOutput) SetDownloadUrl(v string) *DescribeExportOutput {
	s.DownloadUrl = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *DescribeExportOutput) SetExportId(v string) *DescribeExportOutput {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *DescribeExportOutput) SetExportStatus(v string) *DescribeExportOutput {
	s.ExportStatus = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeExportOutput) SetFailureReasons(v []*string) *DescribeExportOutput {
	s.FailureReasons = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *DescribeExportOutput) SetFileFormat(v string) *DescribeExportOutput {
	s.FileFormat = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeExportOutput) SetLastUpdatedDateTime(v time.Time) *DescribeExportOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeExportOutput) SetResourceSpecification(v *ExportResourceSpecification) *DescribeExportOutput {
	s.ResourceSpecification = v
	return s
}

type DescribeImportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the import to describe.
	//
	// ImportId is a required field
	ImportId *string `location:"uri" locationName:"importId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImportInput"}
	if s.ImportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportId"))
	}
	if s.ImportId != nil && len(*s.ImportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ImportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportId sets the ImportId field's value.
func (s *DescribeImportInput) SetImportId(v string) *DescribeImportInput {
	s.ImportId = &v
	return s
}

type DescribeImportOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that the import was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// If the importStatus field is Failed, this provides one or more reasons for
	// the failure.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The unique identifier of the described import.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// The status of the import process. When the status is Completed the resource
	// is imported and ready for use.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`

	// The unique identifier that Amazon Lex assigned to the resource created by
	// the import.
	ImportedResourceId *string `locationName:"importedResourceId" min:"5" type:"string"`

	// The name of the imported resource.
	ImportedResourceName *string `locationName:"importedResourceName" min:"1" type:"string"`

	// The date and time that the import was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The strategy used when there was a name conflict between the imported resource
	// and an existing resource. When the merge strategy is FailOnConflict existing
	// resources are not overwritten and the import fails.
	MergeStrategy *string `locationName:"mergeStrategy" type:"string" enum:"MergeStrategy"`

	// The specifications of the imported bot, bot locale, or custom vocabulary.
	ResourceSpecification *ImportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeImportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeImportOutput) SetCreationDateTime(v time.Time) *DescribeImportOutput {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeImportOutput) SetFailureReasons(v []*string) *DescribeImportOutput {
	s.FailureReasons = v
	return s
}

// SetImportId sets the ImportId field's value.
func (s *DescribeImportOutput) SetImportId(v string) *DescribeImportOutput {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *DescribeImportOutput) SetImportStatus(v string) *DescribeImportOutput {
	s.ImportStatus = &v
	return s
}

// SetImportedResourceId sets the ImportedResourceId field's value.
func (s *DescribeImportOutput) SetImportedResourceId(v string) *DescribeImportOutput {
	s.ImportedResourceId = &v
	return s
}

// SetImportedResourceName sets the ImportedResourceName field's value.
func (s *DescribeImportOutput) SetImportedResourceName(v string) *DescribeImportOutput {
	s.ImportedResourceName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeImportOutput) SetLastUpdatedDateTime(v time.Time) *DescribeImportOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *DescribeImportOutput) SetMergeStrategy(v string) *DescribeImportOutput {
	s.MergeStrategy = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeImportOutput) SetResourceSpecification(v *ImportResourceSpecification) *DescribeImportOutput {
	s.ResourceSpecification = v
	return s
}

type DescribeIntentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the intent.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the intent.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the intent to describe.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale of the intent to describe. The
	// string must match one of the supported locales. For more information, see
	// Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIntentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIntentInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeIntentInput) SetBotId(v string) *DescribeIntentInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeIntentInput) SetBotVersion(v string) *DescribeIntentInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeIntentInput) SetIntentId(v string) *DescribeIntentInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeIntentInput) SetLocaleId(v string) *DescribeIntentInput {
	s.LocaleId = &v
	return s
}

type DescribeIntentOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the intent.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the intent.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// A timestamp of the date and time that the intent was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The Lambda function called during each turn of a conversation with the intent.
	DialogCodeHook *DialogCodeHookSettings `locationName:"dialogCodeHook" type:"structure"`

	// The Lambda function called when the intent is complete and ready for fulfillment.
	FulfillmentCodeHook *FulfillmentCodeHookSettings `locationName:"fulfillmentCodeHook" type:"structure"`

	// Configuration setting for a response sent to the user before Amazon Lex starts
	// eliciting slots.
	InitialResponseSetting *InitialResponseSetting `locationName:"initialResponseSetting" type:"structure"`

	// A list of contexts that must be active for the intent to be considered for
	// sending to the user.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// The response that Amazon Lex sends to when the intent is closed.
	IntentClosingSetting *IntentClosingSetting `locationName:"intentClosingSetting" type:"structure"`

	// Prompts that Amazon Lex sends to the user to confirm completion of an intent.
	IntentConfirmationSetting *IntentConfirmationSetting `locationName:"intentConfirmationSetting" type:"structure"`

	// The unique identifier assigned to the intent when it was created.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The name specified for the intent.
	IntentName *string `locationName:"intentName" min:"1" type:"string"`

	// Configuration information required to use the AMAZON.KendraSearchIntent intent.
	KendraConfiguration *KendraConfiguration `locationName:"kendraConfiguration" type:"structure"`

	// A timestamp of the date and time that the intent was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale specified for the intent.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A list of contexts that are activated when the intent is fulfilled.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// The identifier of the built-in intent that this intent is derived from, if
	// any.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`

	// User utterances that trigger this intent.
	SampleUtterances []*SampleUtterance `locationName:"sampleUtterances" type:"list"`

	// The list that determines the priority that slots should be elicited from
	// the user.
	SlotPriorities []*SlotPriority `locationName:"slotPriorities" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIntentOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeIntentOutput) SetBotId(v string) *DescribeIntentOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeIntentOutput) SetBotVersion(v string) *DescribeIntentOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeIntentOutput) SetCreationDateTime(v time.Time) *DescribeIntentOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeIntentOutput) SetDescription(v string) *DescribeIntentOutput {
	s.Description = &v
	return s
}

// SetDialogCodeHook sets the DialogCodeHook field's value.
func (s *DescribeIntentOutput) SetDialogCodeHook(v *DialogCodeHookSettings) *DescribeIntentOutput {
	s.DialogCodeHook = v
	return s
}

// SetFulfillmentCodeHook sets the FulfillmentCodeHook field's value.
func (s *DescribeIntentOutput) SetFulfillmentCodeHook(v *FulfillmentCodeHookSettings) *DescribeIntentOutput {
	s.FulfillmentCodeHook = v
	return s
}

// SetInitialResponseSetting sets the InitialResponseSetting field's value.
func (s *DescribeIntentOutput) SetInitialResponseSetting(v *InitialResponseSetting) *DescribeIntentOutput {
	s.InitialResponseSetting = v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *DescribeIntentOutput) SetInputContexts(v []*InputContext) *DescribeIntentOutput {
	s.InputContexts = v
	return s
}

// SetIntentClosingSetting sets the IntentClosingSetting field's value.
func (s *DescribeIntentOutput) SetIntentClosingSetting(v *IntentClosingSetting) *DescribeIntentOutput {
	s.IntentClosingSetting = v
	return s
}

// SetIntentConfirmationSetting sets the IntentConfirmationSetting field's value.
func (s *DescribeIntentOutput) SetIntentConfirmationSetting(v *IntentConfirmationSetting) *DescribeIntentOutput {
	s.IntentConfirmationSetting = v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeIntentOutput) SetIntentId(v string) *DescribeIntentOutput {
	s.IntentId = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *DescribeIntentOutput) SetIntentName(v string) *DescribeIntentOutput {
	s.IntentName = &v
	return s
}

// SetKendraConfiguration sets the KendraConfiguration field's value.
func (s *DescribeIntentOutput) SetKendraConfiguration(v *KendraConfiguration) *DescribeIntentOutput {
	s.KendraConfiguration = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeIntentOutput) SetLastUpdatedDateTime(v time.Time) *DescribeIntentOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeIntentOutput) SetLocaleId(v string) *DescribeIntentOutput {
	s.LocaleId = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *DescribeIntentOutput) SetOutputContexts(v []*OutputContext) *DescribeIntentOutput {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *DescribeIntentOutput) SetParentIntentSignature(v string) *DescribeIntentOutput {
	s.ParentIntentSignature = &v
	return s
}

// SetSampleUtterances sets the SampleUtterances field's value.
func (s *DescribeIntentOutput) SetSampleUtterances(v []*SampleUtterance) *DescribeIntentOutput {
	s.SampleUtterances = v
	return s
}

// SetSlotPriorities sets the SlotPriorities field's value.
func (s *DescribeIntentOutput) SetSlotPriorities(v []*SlotPriority) *DescribeIntentOutput {
	s.SlotPriorities = v
	return s
}

type DescribeResourcePolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourcePolicyInput) SetResourceArn(v string) *DescribeResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DescribeResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON structure that contains the resource policy. For more information
	// about the contents of a JSON policy document, see IAM JSON policy reference
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html).
	Policy *string `locationName:"policy" min:"2" type:"string"`

	// The Amazon Resource Name (ARN) of the bot or bot alias that the resource
	// policy is attached to.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`

	// The current revision of the resource policy. Use the revision ID to make
	// sure that you are updating the most current version of a resource policy
	// when you add a policy statement to a resource, delete a resource, or update
	// a resource.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *DescribeResourcePolicyOutput) SetPolicy(v string) *DescribeResourcePolicyOutput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeResourcePolicyOutput) SetResourceArn(v string) *DescribeResourcePolicyOutput {
	s.ResourceArn = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DescribeResourcePolicyOutput) SetRevisionId(v string) *DescribeResourcePolicyOutput {
	s.RevisionId = &v
	return s
}

type DescribeSlotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the intent that contains the slot.
	//
	// IntentId is a required field
	IntentId *string `location:"uri" locationName:"intentId" min:"10" type:"string" required:"true"`

	// The identifier of the language and locale of the slot to describe. The string
	// must match one of the supported locales. For more information, see Supported
	// languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The unique identifier for the slot.
	//
	// SlotId is a required field
	SlotId *string `location:"uri" locationName:"slotId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlotInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.IntentId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntentId"))
	}
	if s.IntentId != nil && len(*s.IntentId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IntentId", 10))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotId"))
	}
	if s.SlotId != nil && len(*s.SlotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeSlotInput) SetBotId(v string) *DescribeSlotInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeSlotInput) SetBotVersion(v string) *DescribeSlotInput {
	s.BotVersion = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeSlotInput) SetIntentId(v string) *DescribeSlotInput {
	s.IntentId = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeSlotInput) SetLocaleId(v string) *DescribeSlotInput {
	s.LocaleId = &v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *DescribeSlotInput) SetSlotId(v string) *DescribeSlotInput {
	s.SlotId = &v
	return s
}

type DescribeSlotOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the slot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A timestamp of the date and time that the slot was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the slot.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the intent associated with the slot.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// A timestamp of the date and time that the slot was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale specified for the slot.
	LocaleId *string `locationName:"localeId" type:"string"`

	// Indicates whether the slot accepts multiple values in a single utterance.
	//
	// If the multipleValuesSetting is not set, the default value is false.
	MultipleValuesSetting *MultipleValuesSetting `locationName:"multipleValuesSetting" type:"structure"`

	// Whether slot values are shown in Amazon CloudWatch logs. If the value is
	// None, the actual value of the slot is shown in logs.
	ObfuscationSetting *ObfuscationSetting `locationName:"obfuscationSetting" type:"structure"`

	// The unique identifier generated for the slot.
	SlotId *string `locationName:"slotId" min:"10" type:"string"`

	// The name specified for the slot.
	SlotName *string `locationName:"slotName" min:"1" type:"string"`

	// The identifier of the slot type that determines the values entered into the
	// slot.
	SlotTypeId *string `locationName:"slotTypeId" min:"1" type:"string"`

	// Specifications for the constituent sub slots and the expression for the composite
	// slot.
	SubSlotSetting *SubSlotSetting `locationName:"subSlotSetting" type:"structure"`

	// Prompts that Amazon Lex uses to elicit a value for the slot.
	ValueElicitationSetting *SlotValueElicitationSetting `locationName:"valueElicitationSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeSlotOutput) SetBotId(v string) *DescribeSlotOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeSlotOutput) SetBotVersion(v string) *DescribeSlotOutput {
	s.BotVersion = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeSlotOutput) SetCreationDateTime(v time.Time) *DescribeSlotOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSlotOutput) SetDescription(v string) *DescribeSlotOutput {
	s.Description = &v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *DescribeSlotOutput) SetIntentId(v string) *DescribeSlotOutput {
	s.IntentId = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeSlotOutput) SetLastUpdatedDateTime(v time.Time) *DescribeSlotOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeSlotOutput) SetLocaleId(v string) *DescribeSlotOutput {
	s.LocaleId = &v
	return s
}

// SetMultipleValuesSetting sets the MultipleValuesSetting field's value.
func (s *DescribeSlotOutput) SetMultipleValuesSetting(v *MultipleValuesSetting) *DescribeSlotOutput {
	s.MultipleValuesSetting = v
	return s
}

// SetObfuscationSetting sets the ObfuscationSetting field's value.
func (s *DescribeSlotOutput) SetObfuscationSetting(v *ObfuscationSetting) *DescribeSlotOutput {
	s.ObfuscationSetting = v
	return s
}

// SetSlotId sets the SlotId field's value.
func (s *DescribeSlotOutput) SetSlotId(v string) *DescribeSlotOutput {
	s.SlotId = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *DescribeSlotOutput) SetSlotName(v string) *DescribeSlotOutput {
	s.SlotName = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *DescribeSlotOutput) SetSlotTypeId(v string) *DescribeSlotOutput {
	s.SlotTypeId = &v
	return s
}

// SetSubSlotSetting sets the SubSlotSetting field's value.
func (s *DescribeSlotOutput) SetSubSlotSetting(v *SubSlotSetting) *DescribeSlotOutput {
	s.SubSlotSetting = v
	return s
}

// SetValueElicitationSetting sets the ValueElicitationSetting field's value.
func (s *DescribeSlotOutput) SetValueElicitationSetting(v *SlotValueElicitationSetting) *DescribeSlotOutput {
	s.ValueElicitationSetting = v
	return s
}

type DescribeSlotTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the bot associated with the slot type.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot associated with the slot type.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the language and locale of the slot type to describe. The
	// string must match one of the supported locales. For more information, see
	// Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The identifier of the slot type.
	//
	// SlotTypeId is a required field
	SlotTypeId *string `location:"uri" locationName:"slotTypeId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSlotTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSlotTypeInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.SlotTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("SlotTypeId"))
	}
	if s.SlotTypeId != nil && len(*s.SlotTypeId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("SlotTypeId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *DescribeSlotTypeInput) SetBotId(v string) *DescribeSlotTypeInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeSlotTypeInput) SetBotVersion(v string) *DescribeSlotTypeInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeSlotTypeInput) SetLocaleId(v string) *DescribeSlotTypeInput {
	s.LocaleId = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *DescribeSlotTypeInput) SetSlotTypeId(v string) *DescribeSlotTypeInput {
	s.SlotTypeId = &v
	return s
}

type DescribeSlotTypeOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with the slot type.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot associated with the slot type.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *CompositeSlotTypeSetting `locationName:"compositeSlotTypeSetting" type:"structure"`

	// A timestamp of the date and time that the slot type was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description specified for the slot type.
	Description *string `locationName:"description" type:"string"`

	// Provides information about the external source of the slot type's definition.
	ExternalSourceSetting *ExternalSourceSetting `locationName:"externalSourceSetting" type:"structure"`

	// A timestamp of the date and time that the slot type was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The language and locale specified for the slot type.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The built in slot type used as a parent to this slot type.
	ParentSlotTypeSignature *string `locationName:"parentSlotTypeSignature" type:"string"`

	// The unique identifier for the slot type.
	SlotTypeId *string `locationName:"slotTypeId" min:"10" type:"string"`

	// The name specified for the slot type.
	SlotTypeName *string `locationName:"slotTypeName" min:"1" type:"string"`

	// The values that the slot type can take. Includes any synonyms for the slot
	// type values.
	SlotTypeValues []*SlotTypeValue `locationName:"slotTypeValues" min:"1" type:"list"`

	// The strategy that Amazon Lex uses to choose a value from a list of possible
	// values.
	ValueSelectionSetting *SlotValueSelectionSetting `locationName:"valueSelectionSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSlotTypeOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *DescribeSlotTypeOutput) SetBotId(v string) *DescribeSlotTypeOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *DescribeSlotTypeOutput) SetBotVersion(v string) *DescribeSlotTypeOutput {
	s.BotVersion = &v
	return s
}

// SetCompositeSlotTypeSetting sets the CompositeSlotTypeSetting field's value.
func (s *DescribeSlotTypeOutput) SetCompositeSlotTypeSetting(v *CompositeSlotTypeSetting) *DescribeSlotTypeOutput {
	s.CompositeSlotTypeSetting = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeSlotTypeOutput) SetCreationDateTime(v time.Time) *DescribeSlotTypeOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeSlotTypeOutput) SetDescription(v string) *DescribeSlotTypeOutput {
	s.Description = &v
	return s
}

// SetExternalSourceSetting sets the ExternalSourceSetting field's value.
func (s *DescribeSlotTypeOutput) SetExternalSourceSetting(v *ExternalSourceSetting) *DescribeSlotTypeOutput {
	s.ExternalSourceSetting = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeSlotTypeOutput) SetLastUpdatedDateTime(v time.Time) *DescribeSlotTypeOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *DescribeSlotTypeOutput) SetLocaleId(v string) *DescribeSlotTypeOutput {
	s.LocaleId = &v
	return s
}

// SetParentSlotTypeSignature sets the ParentSlotTypeSignature field's value.
func (s *DescribeSlotTypeOutput) SetParentSlotTypeSignature(v string) *DescribeSlotTypeOutput {
	s.ParentSlotTypeSignature = &v
	return s
}

// SetSlotTypeId sets the SlotTypeId field's value.
func (s *DescribeSlotTypeOutput) SetSlotTypeId(v string) *DescribeSlotTypeOutput {
	s.SlotTypeId = &v
	return s
}

// SetSlotTypeName sets the SlotTypeName field's value.
func (s *DescribeSlotTypeOutput) SetSlotTypeName(v string) *DescribeSlotTypeOutput {
	s.SlotTypeName = &v
	return s
}

// SetSlotTypeValues sets the SlotTypeValues field's value.
func (s *DescribeSlotTypeOutput) SetSlotTypeValues(v []*SlotTypeValue) *DescribeSlotTypeOutput {
	s.SlotTypeValues = v
	return s
}

// SetValueSelectionSetting sets the ValueSelectionSetting field's value.
func (s *DescribeSlotTypeOutput) SetValueSelectionSetting(v *SlotValueSelectionSetting) *DescribeSlotTypeOutput {
	s.ValueSelectionSetting = v
	return s
}

type DescribeTestExecutionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The execution Id of the test set execution.
	//
	// TestExecutionId is a required field
	TestExecutionId *string `location:"uri" locationName:"testExecutionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTestExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTestExecutionInput"}
	if s.TestExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestExecutionId"))
	}
	if s.TestExecutionId != nil && len(*s.TestExecutionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestExecutionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestExecutionId sets the TestExecutionId field's value.
func (s *DescribeTestExecutionInput) SetTestExecutionId(v string) *DescribeTestExecutionInput {
	s.TestExecutionId = &v
	return s
}

type DescribeTestExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether we use streaming or non-streaming APIs are used for the
	// test set execution. For streaming, StartConversation Amazon Lex Runtime API
	// is used. Whereas for non-streaming, RecognizeUtterance and RecognizeText
	// Amazon Lex Runtime API is used.
	ApiMode *string `locationName:"apiMode" type:"string" enum:"TestExecutionApiMode"`

	// The execution creation date and time for the test set execution.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// Reasons for the failure of the test set execution.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The date and time of the last update for the execution.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The target bot for the test set execution details.
	Target *TestExecutionTarget `locationName:"target" type:"structure"`

	// The execution Id for the test set execution.
	TestExecutionId *string `locationName:"testExecutionId" min:"10" type:"string"`

	// Indicates whether test set is audio or text.
	TestExecutionModality *string `locationName:"testExecutionModality" type:"string" enum:"TestExecutionModality"`

	// The test execution status for the test execution.
	TestExecutionStatus *string `locationName:"testExecutionStatus" type:"string" enum:"TestExecutionStatus"`

	// The test set Id for the test set execution.
	TestSetId *string `locationName:"testSetId" min:"10" type:"string"`

	// The test set name of the test set execution.
	TestSetName *string `locationName:"testSetName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestExecutionOutput) GoString() string {
	return s.String()
}

// SetApiMode sets the ApiMode field's value.
func (s *DescribeTestExecutionOutput) SetApiMode(v string) *DescribeTestExecutionOutput {
	s.ApiMode = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeTestExecutionOutput) SetCreationDateTime(v time.Time) *DescribeTestExecutionOutput {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeTestExecutionOutput) SetFailureReasons(v []*string) *DescribeTestExecutionOutput {
	s.FailureReasons = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeTestExecutionOutput) SetLastUpdatedDateTime(v time.Time) *DescribeTestExecutionOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *DescribeTestExecutionOutput) SetTarget(v *TestExecutionTarget) *DescribeTestExecutionOutput {
	s.Target = v
	return s
}

// SetTestExecutionId sets the TestExecutionId field's value.
func (s *DescribeTestExecutionOutput) SetTestExecutionId(v string) *DescribeTestExecutionOutput {
	s.TestExecutionId = &v
	return s
}

// SetTestExecutionModality sets the TestExecutionModality field's value.
func (s *DescribeTestExecutionOutput) SetTestExecutionModality(v string) *DescribeTestExecutionOutput {
	s.TestExecutionModality = &v
	return s
}

// SetTestExecutionStatus sets the TestExecutionStatus field's value.
func (s *DescribeTestExecutionOutput) SetTestExecutionStatus(v string) *DescribeTestExecutionOutput {
	s.TestExecutionStatus = &v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *DescribeTestExecutionOutput) SetTestSetId(v string) *DescribeTestExecutionOutput {
	s.TestSetId = &v
	return s
}

// SetTestSetName sets the TestSetName field's value.
func (s *DescribeTestExecutionOutput) SetTestSetName(v string) *DescribeTestExecutionOutput {
	s.TestSetName = &v
	return s
}

type DescribeTestSetDiscrepancyReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the test set discrepancy report.
	//
	// TestSetDiscrepancyReportId is a required field
	TestSetDiscrepancyReportId *string `location:"uri" locationName:"testSetDiscrepancyReportId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetDiscrepancyReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetDiscrepancyReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTestSetDiscrepancyReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTestSetDiscrepancyReportInput"}
	if s.TestSetDiscrepancyReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetDiscrepancyReportId"))
	}
	if s.TestSetDiscrepancyReportId != nil && len(*s.TestSetDiscrepancyReportId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetDiscrepancyReportId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSetDiscrepancyReportId sets the TestSetDiscrepancyReportId field's value.
func (s *DescribeTestSetDiscrepancyReportInput) SetTestSetDiscrepancyReportId(v string) *DescribeTestSetDiscrepancyReportInput {
	s.TestSetDiscrepancyReportId = &v
	return s
}

type DescribeTestSetDiscrepancyReportOutput struct {
	_ struct{} `type:"structure"`

	// The time and date of creation for the test set discrepancy report.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The failure report for the test set discrepancy report generation action.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The date and time of the last update for the test set discrepancy report.
	LastUpdatedDataTime *time.Time `locationName:"lastUpdatedDataTime" type:"timestamp"`

	// The target bot location for the test set discrepancy report.
	Target *TestSetDiscrepancyReportResourceTarget `locationName:"target" type:"structure"`

	// Pre-signed Amazon S3 URL to download the test set discrepancy report.
	TestSetDiscrepancyRawOutputUrl *string `locationName:"testSetDiscrepancyRawOutputUrl" min:"1" type:"string"`

	// The unique identifier of the test set discrepancy report to describe.
	TestSetDiscrepancyReportId *string `locationName:"testSetDiscrepancyReportId" min:"10" type:"string"`

	// The status for the test set discrepancy report.
	TestSetDiscrepancyReportStatus *string `locationName:"testSetDiscrepancyReportStatus" type:"string" enum:"TestSetDiscrepancyReportStatus"`

	// The top 200 error results from the test set discrepancy report.
	TestSetDiscrepancyTopErrors *TestSetDiscrepancyErrors `locationName:"testSetDiscrepancyTopErrors" type:"structure"`

	// The test set Id for the test set discrepancy report.
	TestSetId *string `locationName:"testSetId" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetDiscrepancyReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetDiscrepancyReportOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetCreationDateTime(v time.Time) *DescribeTestSetDiscrepancyReportOutput {
	s.CreationDateTime = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetFailureReasons(v []*string) *DescribeTestSetDiscrepancyReportOutput {
	s.FailureReasons = v
	return s
}

// SetLastUpdatedDataTime sets the LastUpdatedDataTime field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetLastUpdatedDataTime(v time.Time) *DescribeTestSetDiscrepancyReportOutput {
	s.LastUpdatedDataTime = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetTarget(v *TestSetDiscrepancyReportResourceTarget) *DescribeTestSetDiscrepancyReportOutput {
	s.Target = v
	return s
}

// SetTestSetDiscrepancyRawOutputUrl sets the TestSetDiscrepancyRawOutputUrl field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetTestSetDiscrepancyRawOutputUrl(v string) *DescribeTestSetDiscrepancyReportOutput {
	s.TestSetDiscrepancyRawOutputUrl = &v
	return s
}

// SetTestSetDiscrepancyReportId sets the TestSetDiscrepancyReportId field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetTestSetDiscrepancyReportId(v string) *DescribeTestSetDiscrepancyReportOutput {
	s.TestSetDiscrepancyReportId = &v
	return s
}

// SetTestSetDiscrepancyReportStatus sets the TestSetDiscrepancyReportStatus field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetTestSetDiscrepancyReportStatus(v string) *DescribeTestSetDiscrepancyReportOutput {
	s.TestSetDiscrepancyReportStatus = &v
	return s
}

// SetTestSetDiscrepancyTopErrors sets the TestSetDiscrepancyTopErrors field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetTestSetDiscrepancyTopErrors(v *TestSetDiscrepancyErrors) *DescribeTestSetDiscrepancyReportOutput {
	s.TestSetDiscrepancyTopErrors = v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *DescribeTestSetDiscrepancyReportOutput) SetTestSetId(v string) *DescribeTestSetDiscrepancyReportOutput {
	s.TestSetId = &v
	return s
}

type DescribeTestSetGenerationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the test set generation.
	//
	// TestSetGenerationId is a required field
	TestSetGenerationId *string `location:"uri" locationName:"testSetGenerationId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetGenerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetGenerationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTestSetGenerationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTestSetGenerationInput"}
	if s.TestSetGenerationId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetGenerationId"))
	}
	if s.TestSetGenerationId != nil && len(*s.TestSetGenerationId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetGenerationId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSetGenerationId sets the TestSetGenerationId field's value.
func (s *DescribeTestSetGenerationInput) SetTestSetGenerationId(v string) *DescribeTestSetGenerationInput {
	s.TestSetGenerationId = &v
	return s
}

type DescribeTestSetGenerationOutput struct {
	_ struct{} `type:"structure"`

	// The creation date and time for the test set generation.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The test set description for the test set generation.
	Description *string `locationName:"description" type:"string"`

	// The reasons the test set generation failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The data source of the test set used for the test set generation.
	GenerationDataSource *TestSetGenerationDataSource `locationName:"generationDataSource" type:"structure"`

	// The date and time of the last update for the test set generation.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The roleARN of the test set used for the test set generation.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// The Amazon S3 storage location for the test set generation.
	StorageLocation *TestSetStorageLocation `locationName:"storageLocation" type:"structure"`

	// The unique identifier of the test set generation.
	TestSetGenerationId *string `locationName:"testSetGenerationId" min:"10" type:"string"`

	// The status for the test set generation.
	TestSetGenerationStatus *string `locationName:"testSetGenerationStatus" type:"string" enum:"TestSetGenerationStatus"`

	// The unique identifier for the test set created for the generated test set.
	TestSetId *string `locationName:"testSetId" min:"10" type:"string"`

	// The test set name for the generated test set.
	TestSetName *string `locationName:"testSetName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetGenerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetGenerationOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeTestSetGenerationOutput) SetCreationDateTime(v time.Time) *DescribeTestSetGenerationOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeTestSetGenerationOutput) SetDescription(v string) *DescribeTestSetGenerationOutput {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DescribeTestSetGenerationOutput) SetFailureReasons(v []*string) *DescribeTestSetGenerationOutput {
	s.FailureReasons = v
	return s
}

// SetGenerationDataSource sets the GenerationDataSource field's value.
func (s *DescribeTestSetGenerationOutput) SetGenerationDataSource(v *TestSetGenerationDataSource) *DescribeTestSetGenerationOutput {
	s.GenerationDataSource = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeTestSetGenerationOutput) SetLastUpdatedDateTime(v time.Time) *DescribeTestSetGenerationOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeTestSetGenerationOutput) SetRoleArn(v string) *DescribeTestSetGenerationOutput {
	s.RoleArn = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *DescribeTestSetGenerationOutput) SetStorageLocation(v *TestSetStorageLocation) *DescribeTestSetGenerationOutput {
	s.StorageLocation = v
	return s
}

// SetTestSetGenerationId sets the TestSetGenerationId field's value.
func (s *DescribeTestSetGenerationOutput) SetTestSetGenerationId(v string) *DescribeTestSetGenerationOutput {
	s.TestSetGenerationId = &v
	return s
}

// SetTestSetGenerationStatus sets the TestSetGenerationStatus field's value.
func (s *DescribeTestSetGenerationOutput) SetTestSetGenerationStatus(v string) *DescribeTestSetGenerationOutput {
	s.TestSetGenerationStatus = &v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *DescribeTestSetGenerationOutput) SetTestSetId(v string) *DescribeTestSetGenerationOutput {
	s.TestSetId = &v
	return s
}

// SetTestSetName sets the TestSetName field's value.
func (s *DescribeTestSetGenerationOutput) SetTestSetName(v string) *DescribeTestSetGenerationOutput {
	s.TestSetName = &v
	return s
}

type DescribeTestSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The test set Id for the test set request.
	//
	// TestSetId is a required field
	TestSetId *string `location:"uri" locationName:"testSetId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTestSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTestSetInput"}
	if s.TestSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestSetId"))
	}
	if s.TestSetId != nil && len(*s.TestSetId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestSetId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestSetId sets the TestSetId field's value.
func (s *DescribeTestSetInput) SetTestSetId(v string) *DescribeTestSetInput {
	s.TestSetId = &v
	return s
}

type DescribeTestSetOutput struct {
	_ struct{} `type:"structure"`

	// The creation date and time for the test set data.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The description of the test set.
	Description *string `locationName:"description" type:"string"`

	// The date and time for the last update of the test set data.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Indicates whether the test set is audio or text data.
	Modality *string `locationName:"modality" type:"string" enum:"TestSetModality"`

	// The total number of agent and user turn in the test set.
	NumTurns *int64 `locationName:"numTurns" type:"integer"`

	// The roleARN used for any operation in the test set to access resources in
	// the Amazon Web Services account.
	RoleArn *string `locationName:"roleArn" min:"32" type:"string"`

	// The status of the test set.
	Status *string `locationName:"status" type:"string" enum:"TestSetStatus"`

	// The Amazon S3 storage location for the test set data.
	StorageLocation *TestSetStorageLocation `locationName:"storageLocation" type:"structure"`

	// The test set Id for the test set response.
	TestSetId *string `locationName:"testSetId" min:"10" type:"string"`

	// The test set name of the test set.
	TestSetName *string `locationName:"testSetName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTestSetOutput) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *DescribeTestSetOutput) SetCreationDateTime(v time.Time) *DescribeTestSetOutput {
	s.CreationDateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeTestSetOutput) SetDescription(v string) *DescribeTestSetOutput {
	s.Description = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *DescribeTestSetOutput) SetLastUpdatedDateTime(v time.Time) *DescribeTestSetOutput {
	s.LastUpdatedDateTime = &v
	return s
}

// SetModality sets the Modality field's value.
func (s *DescribeTestSetOutput) SetModality(v string) *DescribeTestSetOutput {
	s.Modality = &v
	return s
}

// SetNumTurns sets the NumTurns field's value.
func (s *DescribeTestSetOutput) SetNumTurns(v int64) *DescribeTestSetOutput {
	s.NumTurns = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeTestSetOutput) SetRoleArn(v string) *DescribeTestSetOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTestSetOutput) SetStatus(v string) *DescribeTestSetOutput {
	s.Status = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *DescribeTestSetOutput) SetStorageLocation(v *TestSetStorageLocation) *DescribeTestSetOutput {
	s.StorageLocation = v
	return s
}

// SetTestSetId sets the TestSetId field's value.
func (s *DescribeTestSetOutput) SetTestSetId(v string) *DescribeTestSetOutput {
	s.TestSetId = &v
	return s
}

// SetTestSetName sets the TestSetName field's value.
func (s *DescribeTestSetOutput) SetTestSetName(v string) *DescribeTestSetOutput {
	s.TestSetName = &v
	return s
}

// Defines the action that the bot executes at runtime when the conversation
// reaches this step.
type DialogAction struct {
	_ struct{} `type:"structure"`

	// If the dialog action is ElicitSlot, defines the slot to elicit from the user.
	SlotToElicit *string `locationName:"slotToElicit" min:"1" type:"string"`

	// When true the next message for the intent is not used.
	SuppressNextMessage *bool `locationName:"suppressNextMessage" type:"boolean"`

	// The action that the bot should execute.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DialogActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialogAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialogAction"}
	if s.SlotToElicit != nil && len(*s.SlotToElicit) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SlotToElicit", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSlotToElicit sets the SlotToElicit field's value.
func (s *DialogAction) SetSlotToElicit(v string) *DialogAction {
	s.SlotToElicit = &v
	return s
}

// SetSuppressNextMessage sets the SuppressNextMessage field's value.
func (s *DialogAction) SetSuppressNextMessage(v bool) *DialogAction {
	s.SuppressNextMessage = &v
	return s
}

// SetType sets the Type field's value.
func (s *DialogAction) SetType(v string) *DialogAction {
	s.Type = &v
	return s
}

// Settings that specify the dialog code hook that is called by Amazon Lex at
// a step of the conversation.
type DialogCodeHookInvocationSetting struct {
	_ struct{} `type:"structure"`

	// Determines whether a dialog code hook is used when the intent is activated.
	//
	// Active is a required field
	Active *bool `locationName:"active" type:"boolean" required:"true"`

	// Indicates whether a Lambda function should be invoked for the dialog.
	//
	// EnableCodeHookInvocation is a required field
	EnableCodeHookInvocation *bool `locationName:"enableCodeHookInvocation" type:"boolean" required:"true"`

	// A label that indicates the dialog step from which the dialog code hook is
	// happening.
	InvocationLabel *string `locationName:"invocationLabel" min:"1" type:"string"`

	// Contains the responses and actions that Amazon Lex takes after the Lambda
	// function is complete.
	//
	// PostCodeHookSpecification is a required field
	PostCodeHookSpecification *PostDialogCodeHookInvocationSpecification `locationName:"postCodeHookSpecification" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogCodeHookInvocationSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogCodeHookInvocationSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialogCodeHookInvocationSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialogCodeHookInvocationSetting"}
	if s.Active == nil {
		invalidParams.Add(request.NewErrParamRequired("Active"))
	}
	if s.EnableCodeHookInvocation == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableCodeHookInvocation"))
	}
	if s.InvocationLabel != nil && len(*s.InvocationLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationLabel", 1))
	}
	if s.PostCodeHookSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("PostCodeHookSpecification"))
	}
	if s.PostCodeHookSpecification != nil {
		if err := s.PostCodeHookSpecification.Validate(); err != nil {
			invalidParams.AddNested("PostCodeHookSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *DialogCodeHookInvocationSetting) SetActive(v bool) *DialogCodeHookInvocationSetting {
	s.Active = &v
	return s
}

// SetEnableCodeHookInvocation sets the EnableCodeHookInvocation field's value.
func (s *DialogCodeHookInvocationSetting) SetEnableCodeHookInvocation(v bool) *DialogCodeHookInvocationSetting {
	s.EnableCodeHookInvocation = &v
	return s
}

// SetInvocationLabel sets the InvocationLabel field's value.
func (s *DialogCodeHookInvocationSetting) SetInvocationLabel(v string) *DialogCodeHookInvocationSetting {
	s.InvocationLabel = &v
	return s
}

// SetPostCodeHookSpecification sets the PostCodeHookSpecification field's value.
func (s *DialogCodeHookInvocationSetting) SetPostCodeHookSpecification(v *PostDialogCodeHookInvocationSpecification) *DialogCodeHookInvocationSetting {
	s.PostCodeHookSpecification = v
	return s
}

// Settings that determine the Lambda function that Amazon Lex uses for processing
// user responses.
type DialogCodeHookSettings struct {
	_ struct{} `type:"structure"`

	// Enables the dialog code hook so that it processes user requests.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogCodeHookSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogCodeHookSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialogCodeHookSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialogCodeHookSettings"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *DialogCodeHookSettings) SetEnabled(v bool) *DialogCodeHookSettings {
	s.Enabled = &v
	return s
}

// The current state of the conversation with the user.
type DialogState struct {
	_ struct{} `type:"structure"`

	// Defines the action that the bot executes at runtime when the conversation
	// reaches this step.
	DialogAction *DialogAction `locationName:"dialogAction" type:"structure"`

	// Override settings to configure the intent state.
	Intent *IntentOverride `locationName:"intent" type:"structure"`

	// Map of key/value pairs representing session-specific context information.
	// It contains application information passed between Amazon Lex and a client
	// application.
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DialogState) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DialogState) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DialogState"}
	if s.DialogAction != nil {
		if err := s.DialogAction.Validate(); err != nil {
			invalidParams.AddNested("DialogAction", err.(request.ErrInvalidParams))
		}
	}
	if s.Intent != nil {
		if err := s.Intent.Validate(); err != nil {
			invalidParams.AddNested("Intent", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDialogAction sets the DialogAction field's value.
func (s *DialogState) SetDialogAction(v *DialogAction) *DialogState {
	s.DialogAction = v
	return s
}

// SetIntent sets the Intent field's value.
func (s *DialogState) SetIntent(v *IntentOverride) *DialogState {
	s.Intent = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *DialogState) SetSessionAttributes(v map[string]*string) *DialogState {
	s.SessionAttributes = v
	return s
}

// Settings that specify the dialog code hook that is called by Amazon Lex between
// eliciting slot values.
type ElicitationCodeHookInvocationSetting struct {
	_ struct{} `type:"structure"`

	// Indicates whether a Lambda function should be invoked for the dialog.
	//
	// EnableCodeHookInvocation is a required field
	EnableCodeHookInvocation *bool `locationName:"enableCodeHookInvocation" type:"boolean" required:"true"`

	// A label that indicates the dialog step from which the dialog code hook is
	// happening.
	InvocationLabel *string `locationName:"invocationLabel" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElicitationCodeHookInvocationSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElicitationCodeHookInvocationSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElicitationCodeHookInvocationSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElicitationCodeHookInvocationSetting"}
	if s.EnableCodeHookInvocation == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableCodeHookInvocation"))
	}
	if s.InvocationLabel != nil && len(*s.InvocationLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableCodeHookInvocation sets the EnableCodeHookInvocation field's value.
func (s *ElicitationCodeHookInvocationSetting) SetEnableCodeHookInvocation(v bool) *ElicitationCodeHookInvocationSetting {
	s.EnableCodeHookInvocation = &v
	return s
}

// SetInvocationLabel sets the InvocationLabel field's value.
func (s *ElicitationCodeHookInvocationSetting) SetInvocationLabel(v string) *ElicitationCodeHookInvocationSetting {
	s.InvocationLabel = &v
	return s
}

// The object representing the passwords that were used to encrypt the data
// related to the bot recommendation, as well as the KMS key ARN used to encrypt
// the associated metadata.
type EncryptionSetting struct {
	_ struct{} `type:"structure"`

	// The password used to encrypt the associated transcript file.
	//
	// AssociatedTranscriptsPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EncryptionSetting's
	// String and GoString methods.
	AssociatedTranscriptsPassword *string `locationName:"associatedTranscriptsPassword" type:"string" sensitive:"true"`

	// The password used to encrypt the recommended bot recommendation file.
	//
	// BotLocaleExportPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EncryptionSetting's
	// String and GoString methods.
	BotLocaleExportPassword *string `locationName:"botLocaleExportPassword" type:"string" sensitive:"true"`

	// The KMS key ARN used to encrypt the metadata associated with the bot recommendation.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionSetting"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedTranscriptsPassword sets the AssociatedTranscriptsPassword field's value.
func (s *EncryptionSetting) SetAssociatedTranscriptsPassword(v string) *EncryptionSetting {
	s.AssociatedTranscriptsPassword = &v
	return s
}

// SetBotLocaleExportPassword sets the BotLocaleExportPassword field's value.
func (s *EncryptionSetting) SetBotLocaleExportPassword(v string) *EncryptionSetting {
	s.BotLocaleExportPassword = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *EncryptionSetting) SetKmsKeyArn(v string) *EncryptionSetting {
	s.KmsKeyArn = &v
	return s
}

// Details about an error in an execution of a test set.
type ExecutionErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code for the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" min:"1" type:"string" required:"true"`

	// The message describing the error.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExecutionErrorDetails) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ExecutionErrorDetails) SetErrorCode(v string) *ExecutionErrorDetails {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ExecutionErrorDetails) SetErrorMessage(v string) *ExecutionErrorDetails {
	s.ErrorMessage = &v
	return s
}

// Filters the response form the ListExports (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html)
// operation
type ExportFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to use for filtering.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"ExportFilterName"`

	// The operator to use for the filter. Specify EQ when the ListExports operation
	// should return only resource types that equal the specified value. Specify
	// CO when the ListExports operation should return resource types that contain
	// the specified value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"ExportFilterOperator"`

	// The values to use to filter the response. The values must be Bot, BotLocale,
	// or CustomVocabulary.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ExportFilter) SetName(v string) *ExportFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ExportFilter) SetOperator(v string) *ExportFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ExportFilter) SetValues(v []*string) *ExportFilter {
	s.Values = v
	return s
}

// Provides information about the bot or bot locale that you want to export.
// You can specify the botExportSpecification or the botLocaleExportSpecification,
// but not both.
type ExportResourceSpecification struct {
	_ struct{} `type:"structure"`

	// Parameters for exporting a bot.
	BotExportSpecification *BotExportSpecification `locationName:"botExportSpecification" type:"structure"`

	// Parameters for exporting a bot locale.
	BotLocaleExportSpecification *BotLocaleExportSpecification `locationName:"botLocaleExportSpecification" type:"structure"`

	// The parameters required to export a custom vocabulary.
	CustomVocabularyExportSpecification *CustomVocabularyExportSpecification `locationName:"customVocabularyExportSpecification" type:"structure"`

	// Specifications for the test set that is exported as a resource.
	TestSetExportSpecification *TestSetExportSpecification `locationName:"testSetExportSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportResourceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportResourceSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportResourceSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportResourceSpecification"}
	if s.BotExportSpecification != nil {
		if err := s.BotExportSpecification.Validate(); err != nil {
			invalidParams.AddNested("BotExportSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.BotLocaleExportSpecification != nil {
		if err := s.BotLocaleExportSpecification.Validate(); err != nil {
			invalidParams.AddNested("BotLocaleExportSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomVocabularyExportSpecification != nil {
		if err := s.CustomVocabularyExportSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomVocabularyExportSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.TestSetExportSpecification != nil {
		if err := s.TestSetExportSpecification.Validate(); err != nil {
			invalidParams.AddNested("TestSetExportSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotExportSpecification sets the BotExportSpecification field's value.
func (s *ExportResourceSpecification) SetBotExportSpecification(v *BotExportSpecification) *ExportResourceSpecification {
	s.BotExportSpecification = v
	return s
}

// SetBotLocaleExportSpecification sets the BotLocaleExportSpecification field's value.
func (s *ExportResourceSpecification) SetBotLocaleExportSpecification(v *BotLocaleExportSpecification) *ExportResourceSpecification {
	s.BotLocaleExportSpecification = v
	return s
}

// SetCustomVocabularyExportSpecification sets the CustomVocabularyExportSpecification field's value.
func (s *ExportResourceSpecification) SetCustomVocabularyExportSpecification(v *CustomVocabularyExportSpecification) *ExportResourceSpecification {
	s.CustomVocabularyExportSpecification = v
	return s
}

// SetTestSetExportSpecification sets the TestSetExportSpecification field's value.
func (s *ExportResourceSpecification) SetTestSetExportSpecification(v *TestSetExportSpecification) *ExportResourceSpecification {
	s.TestSetExportSpecification = v
	return s
}

// Provides information about sorting a list of exports.
type ExportSortBy struct {
	_ struct{} `type:"structure"`

	// The export field to use for sorting.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"ExportSortAttribute"`

	// The order to sort the list.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *ExportSortBy) SetAttribute(v string) *ExportSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *ExportSortBy) SetOrder(v string) *ExportSortBy {
	s.Order = &v
	return s
}

// Provides summary information about an export in an export list.
type ExportSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the export was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The unique identifier that Amazon Lex assigned to the export.
	ExportId *string `locationName:"exportId" min:"10" type:"string"`

	// The status of the export. When the status is Completed the export is ready
	// to download.
	ExportStatus *string `locationName:"exportStatus" type:"string" enum:"ExportStatus"`

	// The file format used in the export files.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"ImportExportFileFormat"`

	// The date and time that the export was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// Information about the bot or bot locale that was exported.
	ResourceSpecification *ExportResourceSpecification `locationName:"resourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *ExportSummary) SetCreationDateTime(v time.Time) *ExportSummary {
	s.CreationDateTime = &v
	return s
}

// SetExportId sets the ExportId field's value.
func (s *ExportSummary) SetExportId(v string) *ExportSummary {
	s.ExportId = &v
	return s
}

// SetExportStatus sets the ExportStatus field's value.
func (s *ExportSummary) SetExportStatus(v string) *ExportSummary {
	s.ExportStatus = &v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *ExportSummary) SetFileFormat(v string) *ExportSummary {
	s.FileFormat = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *ExportSummary) SetLastUpdatedDateTime(v time.Time) *ExportSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *ExportSummary) SetResourceSpecification(v *ExportResourceSpecification) *ExportSummary {
	s.ResourceSpecification = v
	return s
}

// Provides information about the external source of the slot type's definition.
type ExternalSourceSetting struct {
	_ struct{} `type:"structure"`

	// Settings required for a slot type based on a grammar that you provide.
	GrammarSlotTypeSetting *GrammarSlotTypeSetting `locationName:"grammarSlotTypeSetting" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSourceSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalSourceSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalSourceSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalSourceSetting"}
	if s.GrammarSlotTypeSetting != nil {
		if err := s.GrammarSlotTypeSetting.Validate(); err != nil {
			invalidParams.AddNested("GrammarSlotTypeSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrammarSlotTypeSetting sets the GrammarSlotTypeSetting field's value.
func (s *ExternalSourceSetting) SetGrammarSlotTypeSetting(v *GrammarSlotTypeSetting) *ExternalSourceSetting {
	s.GrammarSlotTypeSetting = v
	return s
}

// The unique failed custom vocabulary item from the custom vocabulary list.
type FailedCustomVocabularyItem struct {
	_ struct{} `type:"structure"`

	// The unique error code for the failed custom vocabulary item from the custom
	// vocabulary list.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// The error message for the failed custom vocabulary item from the custom vocabulary
	// list.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The unique item identifer for the failed custom vocabulary item from the
	// custom vocabulary list.
	ItemId *string `locationName:"itemId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCustomVocabularyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCustomVocabularyItem) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCustomVocabularyItem) SetErrorCode(v string) *FailedCustomVocabularyItem {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCustomVocabularyItem) SetErrorMessage(v string) *FailedCustomVocabularyItem {
	s.ErrorMessage = &v
	return s
}

// SetItemId sets the ItemId field's value.
func (s *FailedCustomVocabularyItem) SetItemId(v string) *FailedCustomVocabularyItem {
	s.ItemId = &v
	return s
}

// Determines if a Lambda function should be invoked for a specific intent.
type FulfillmentCodeHookSettings struct {
	_ struct{} `type:"structure"`

	// Determines whether the fulfillment code hook is used. When active is false,
	// the code hook doesn't run.
	Active *bool `locationName:"active" type:"boolean"`

	// Indicates whether a Lambda function should be invoked to fulfill a specific
	// intent.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// Provides settings for update messages sent to the user for long-running Lambda
	// fulfillment functions. Fulfillment updates can be used only with streaming
	// conversations.
	FulfillmentUpdatesSpecification *FulfillmentUpdatesSpecification `locationName:"fulfillmentUpdatesSpecification" type:"structure"`

	// Provides settings for messages sent to the user for after the Lambda fulfillment
	// function completes. Post-fulfillment messages can be sent for both streaming
	// and non-streaming conversations.
	PostFulfillmentStatusSpecification *PostFulfillmentStatusSpecification `locationName:"postFulfillmentStatusSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentCodeHookSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentCodeHookSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FulfillmentCodeHookSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FulfillmentCodeHookSettings"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.FulfillmentUpdatesSpecification != nil {
		if err := s.FulfillmentUpdatesSpecification.Validate(); err != nil {
			invalidParams.AddNested("FulfillmentUpdatesSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PostFulfillmentStatusSpecification != nil {
		if err := s.PostFulfillmentStatusSpecification.Validate(); err != nil {
			invalidParams.AddNested("PostFulfillmentStatusSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *FulfillmentCodeHookSettings) SetActive(v bool) *FulfillmentCodeHookSettings {
	s.Active = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *FulfillmentCodeHookSettings) SetEnabled(v bool) *FulfillmentCodeHookSettings {
	s.Enabled = &v
	return s
}

// SetFulfillmentUpdatesSpecification sets the FulfillmentUpdatesSpecification field's value.
func (s *FulfillmentCodeHookSettings) SetFulfillmentUpdatesSpecification(v *FulfillmentUpdatesSpecification) *FulfillmentCodeHookSettings {
	s.FulfillmentUpdatesSpecification = v
	return s
}

// SetPostFulfillmentStatusSpecification sets the PostFulfillmentStatusSpecification field's value.
func (s *FulfillmentCodeHookSettings) SetPostFulfillmentStatusSpecification(v *PostFulfillmentStatusSpecification) *FulfillmentCodeHookSettings {
	s.PostFulfillmentStatusSpecification = v
	return s
}

// Provides settings for a message that is sent to the user when a fulfillment
// Lambda function starts running.
type FulfillmentStartResponseSpecification struct {
	_ struct{} `type:"structure"`

	// Determines whether the user can interrupt the start message while it is playing.
	AllowInterrupt *bool `locationName:"allowInterrupt" type:"boolean"`

	// The delay between when the Lambda fulfillment function starts running and
	// the start message is played. If the Lambda function returns before the delay
	// is over, the start message isn't played.
	//
	// DelayInSeconds is a required field
	DelayInSeconds *int64 `locationName:"delayInSeconds" min:"1" type:"integer" required:"true"`

	// 1 - 5 message groups that contain start messages. Amazon Lex chooses one
	// of the messages to play to the user.
	//
	// MessageGroups is a required field
	MessageGroups []*MessageGroup `locationName:"messageGroups" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentStartResponseSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentStartResponseSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FulfillmentStartResponseSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FulfillmentStartResponseSpecification"}
	if s.DelayInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("DelayInSeconds"))
	}
	if s.DelayInSeconds != nil && *s.DelayInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DelayInSeconds", 1))
	}
	if s.MessageGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageGroups"))
	}
	if s.MessageGroups != nil && len(s.MessageGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageGroups", 1))
	}
	if s.MessageGroups != nil {
		for i, v := range s.MessageGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MessageGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowInterrupt sets the AllowInterrupt field's value.
func (s *FulfillmentStartResponseSpecification) SetAllowInterrupt(v bool) *FulfillmentStartResponseSpecification {
	s.AllowInterrupt = &v
	return s
}

// SetDelayInSeconds sets the DelayInSeconds field's value.
func (s *FulfillmentStartResponseSpecification) SetDelayInSeconds(v int64) *FulfillmentStartResponseSpecification {
	s.DelayInSeconds = &v
	return s
}

// SetMessageGroups sets the MessageGroups field's value.
func (s *FulfillmentStartResponseSpecification) SetMessageGroups(v []*MessageGroup) *FulfillmentStartResponseSpecification {
	s.MessageGroups = v
	return s
}

// Provides settings for a message that is sent periodically to the user while
// a fulfillment Lambda function is running.
type FulfillmentUpdateResponseSpecification struct {
	_ struct{} `type:"structure"`

	// Determines whether the user can interrupt an update message while it is playing.
	AllowInterrupt *bool `locationName:"allowInterrupt" type:"boolean"`

	// The frequency that a message is sent to the user. When the period ends, Amazon
	// Lex chooses a message from the message groups and plays it to the user. If
	// the fulfillment Lambda returns before the first period ends, an update message
	// is not played to the user.
	//
	// FrequencyInSeconds is a required field
	FrequencyInSeconds *int64 `locationName:"frequencyInSeconds" min:"1" type:"integer" required:"true"`

	// 1 - 5 message groups that contain update messages. Amazon Lex chooses one
	// of the messages to play to the user.
	//
	// MessageGroups is a required field
	MessageGroups []*MessageGroup `locationName:"messageGroups" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentUpdateResponseSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentUpdateResponseSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FulfillmentUpdateResponseSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FulfillmentUpdateResponseSpecification"}
	if s.FrequencyInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("FrequencyInSeconds"))
	}
	if s.FrequencyInSeconds != nil && *s.FrequencyInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FrequencyInSeconds", 1))
	}
	if s.MessageGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageGroups"))
	}
	if s.MessageGroups != nil && len(s.MessageGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageGroups", 1))
	}
	if s.MessageGroups != nil {
		for i, v := range s.MessageGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MessageGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowInterrupt sets the AllowInterrupt field's value.
func (s *FulfillmentUpdateResponseSpecification) SetAllowInterrupt(v bool) *FulfillmentUpdateResponseSpecification {
	s.AllowInterrupt = &v
	return s
}

// SetFrequencyInSeconds sets the FrequencyInSeconds field's value.
func (s *FulfillmentUpdateResponseSpecification) SetFrequencyInSeconds(v int64) *FulfillmentUpdateResponseSpecification {
	s.FrequencyInSeconds = &v
	return s
}

// SetMessageGroups sets the MessageGroups field's value.
func (s *FulfillmentUpdateResponseSpecification) SetMessageGroups(v []*MessageGroup) *FulfillmentUpdateResponseSpecification {
	s.MessageGroups = v
	return s
}

// Provides information for updating the user on the progress of fulfilling
// an intent.
type FulfillmentUpdatesSpecification struct {
	_ struct{} `type:"structure"`

	// Determines whether fulfillment updates are sent to the user. When this field
	// is true, updates are sent.
	//
	// If the active field is set to true, the startResponse, updateResponse, and
	// timeoutInSeconds fields are required.
	//
	// Active is a required field
	Active *bool `locationName:"active" type:"boolean" required:"true"`

	// Provides configuration information for the message sent to users when the
	// fulfillment Lambda functions starts running.
	StartResponse *FulfillmentStartResponseSpecification `locationName:"startResponse" type:"structure"`

	// The length of time that the fulfillment Lambda function should run before
	// it times out.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" min:"1" type:"integer"`

	// Provides configuration information for messages sent periodically to the
	// user while the fulfillment Lambda function is running.
	UpdateResponse *FulfillmentUpdateResponseSpecification `locationName:"updateResponse" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentUpdatesSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FulfillmentUpdatesSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FulfillmentUpdatesSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FulfillmentUpdatesSpecification"}
	if s.Active == nil {
		invalidParams.Add(request.NewErrParamRequired("Active"))
	}
	if s.TimeoutInSeconds != nil && *s.TimeoutInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInSeconds", 1))
	}
	if s.StartResponse != nil {
		if err := s.StartResponse.Validate(); err != nil {
			invalidParams.AddNested("StartResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.UpdateResponse != nil {
		if err := s.UpdateResponse.Validate(); err != nil {
			invalidParams.AddNested("UpdateResponse", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *FulfillmentUpdatesSpecification) SetActive(v bool) *FulfillmentUpdatesSpecification {
	s.Active = &v
	return s
}

// SetStartResponse sets the StartResponse field's value.
func (s *FulfillmentUpdatesSpecification) SetStartResponse(v *FulfillmentStartResponseSpecification) *FulfillmentUpdatesSpecification {
	s.StartResponse = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *FulfillmentUpdatesSpecification) SetTimeoutInSeconds(v int64) *FulfillmentUpdatesSpecification {
	s.TimeoutInSeconds = &v
	return s
}

// SetUpdateResponse sets the UpdateResponse field's value.
func (s *FulfillmentUpdatesSpecification) SetUpdateResponse(v *FulfillmentUpdateResponseSpecification) *FulfillmentUpdatesSpecification {
	s.UpdateResponse = v
	return s
}

type GetTestExecutionArtifactsUrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the completed test execution.
	//
	// TestExecutionId is a required field
	TestExecutionId *string `location:"uri" locationName:"testExecutionId" min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestExecutionArtifactsUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestExecutionArtifactsUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestExecutionArtifactsUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestExecutionArtifactsUrlInput"}
	if s.TestExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("TestExecutionId"))
	}
	if s.TestExecutionId != nil && len(*s.TestExecutionId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TestExecutionId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTestExecutionId sets the TestExecutionId field's value.
func (s *GetTestExecutionArtifactsUrlInput) SetTestExecutionId(v string) *GetTestExecutionArtifactsUrlInput {
	s.TestExecutionId = &v
	return s
}

type GetTestExecutionArtifactsUrlOutput struct {
	_ struct{} `type:"structure"`

	// The pre-signed Amazon S3 URL to download completed test execution.
	DownloadArtifactsUrl *string `locationName:"downloadArtifactsUrl" min:"1" type:"string"`

	// The unique identifier of the completed test execution.
	TestExecutionId *string `locationName:"testExecutionId" min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestExecutionArtifactsUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTestExecutionArtifactsUrlOutput) GoString() string {
	return s.String()
}

// SetDownloadArtifactsUrl sets the DownloadArtifactsUrl field's value.
func (s *GetTestExecutionArtifactsUrlOutput) SetDownloadArtifactsUrl(v string) *GetTestExecutionArtifactsUrlOutput {
	s.DownloadArtifactsUrl = &v
	return s
}

// SetTestExecutionId sets the TestExecutionId field's value.
func (s *GetTestExecutionArtifactsUrlOutput) SetTestExecutionId(v string) *GetTestExecutionArtifactsUrlOutput {
	s.TestExecutionId = &v
	return s
}

// Settings requried for a slot type based on a grammar that you provide.
type GrammarSlotTypeSetting struct {
	_ struct{} `type:"structure"`

	// The source of the grammar used to create the slot type.
	Source *GrammarSlotTypeSource `locationName:"source" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrammarSlotTypeSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrammarSlotTypeSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrammarSlotTypeSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrammarSlotTypeSetting"}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *GrammarSlotTypeSetting) SetSource(v *GrammarSlotTypeSource) *GrammarSlotTypeSetting {
	s.Source = v
	return s
}

// Describes the Amazon S3 bucket name and location for the grammar that is
// the source for the slot type.
type GrammarSlotTypeSource struct {
	_ struct{} `type:"structure"`

	// The KMS key required to decrypt the contents of the grammar, if any.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The name of the Amazon S3 bucket that contains the grammar source.
	//
	// S3BucketName is a required field
	S3BucketName *string `locationName:"s3BucketName" min:"3" type:"string" required:"true"`

	// The path to the grammar in the Amazon S3 bucket.
	//
	// S3ObjectKey is a required field
	S3ObjectKey *string `locationName:"s3ObjectKey" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrammarSlotTypeSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrammarSlotTypeSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrammarSlotTypeSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrammarSlotTypeSource"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3ObjectKey == nil {
		invalidParams.Add(request.NewErrParamRequired("S3ObjectKey"))
	}
	if s.S3ObjectKey != nil && len(*s.S3ObjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *GrammarSlotTypeSource) SetKmsKeyArn(v string) *GrammarSlotTypeSource {
	s.KmsKeyArn = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *GrammarSlotTypeSource) SetS3BucketName(v string) *GrammarSlotTypeSource {
	s.S3BucketName = &v
	return s
}

// SetS3ObjectKey sets the S3ObjectKey field's value.
func (s *GrammarSlotTypeSource) SetS3ObjectKey(v string) *GrammarSlotTypeSource {
	s.S3ObjectKey = &v
	return s
}

// A card that is shown to the user by a messaging platform. You define the
// contents of the card, the card is displayed by the platform.
//
// When you use a response card, the response from the user is constrained to
// the text associated with a button on the card.
type ImageResponseCard struct {
	_ struct{} `type:"structure"`

	// A list of buttons that should be displayed on the response card. The arrangement
	// of the buttons is determined by the platform that displays the button.
	Buttons []*Button `locationName:"buttons" type:"list"`

	// The URL of an image to display on the response card. The image URL must be
	// publicly available so that the platform displaying the response card has
	// access to the image.
	ImageUrl *string `locationName:"imageUrl" min:"1" type:"string"`

	// The subtitle to display on the response card. The format of the subtitle
	// is determined by the platform displaying the response card.
	Subtitle *string `locationName:"subtitle" min:"1" type:"string"`

	// The title to display on the response card. The format of the title is determined
	// by the platform displaying the response card.
	//
	// Title is a required field
	Title *string `locationName:"title" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageResponseCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageResponseCard) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageResponseCard) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageResponseCard"}
	if s.ImageUrl != nil && len(*s.ImageUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageUrl", 1))
	}
	if s.Subtitle != nil && len(*s.Subtitle) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subtitle", 1))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.Buttons != nil {
		for i, v := range s.Buttons {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Buttons", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetButtons sets the Buttons field's value.
func (s *ImageResponseCard) SetButtons(v []*Button) *ImageResponseCard {
	s.Buttons = v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *ImageResponseCard) SetImageUrl(v string) *ImageResponseCard {
	s.ImageUrl = &v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *ImageResponseCard) SetSubtitle(v string) *ImageResponseCard {
	s.Subtitle = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ImageResponseCard) SetTitle(v string) *ImageResponseCard {
	s.Title = &v
	return s
}

// Filters the response from the ListImports (https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html)
// operation.
type ImportFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to use for filtering.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"ImportFilterName"`

	// The operator to use for the filter. Specify EQ when the ListImports operation
	// should return only resource types that equal the specified value. Specify
	// CO when the ListImports operation should return resource types that contain
	// the specified value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"ImportFilterOperator"`

	// The values to use to filter the response. The values must be Bot, BotLocale,
	// or CustomVocabulary.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ImportFilter) SetName(v string) *ImportFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ImportFilter) SetOperator(v string) *ImportFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ImportFilter) SetValues(v []*string) *ImportFilter {
	s.Values = v
	return s
}

// Provides information about the bot or bot locale that you want to import.
// You can specify the botImportSpecification or the botLocaleImportSpecification,
// but not both.
type ImportResourceSpecification struct {
	_ struct{} `type:"structure"`

	// Parameters for importing a bot.
	BotImportSpecification *BotImportSpecification `locationName:"botImportSpecification" type:"structure"`

	// Parameters for importing a bot locale.
	BotLocaleImportSpecification *BotLocaleImportSpecification `locationName:"botLocaleImportSpecification" type:"structure"`

	// Provides the parameters required for importing a custom vocabulary.
	CustomVocabularyImportSpecification *CustomVocabularyImportSpecification `locationName:"customVocabularyImportSpecification" type:"structure"`

	// Specifications for the test set that is imported.
	TestSetImportResourceSpecification *TestSetImportResourceSpecification `locationName:"testSetImportResourceSpecification" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportResourceSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportResourceSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportResourceSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportResourceSpecification"}
	if s.BotImportSpecification != nil {
		if err := s.BotImportSpecification.Validate(); err != nil {
			invalidParams.AddNested("BotImportSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.BotLocaleImportSpecification != nil {
		if err := s.BotLocaleImportSpecification.Validate(); err != nil {
			invalidParams.AddNested("BotLocaleImportSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomVocabularyImportSpecification != nil {
		if err := s.CustomVocabularyImportSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomVocabularyImportSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.TestSetImportResourceSpecification != nil {
		if err := s.TestSetImportResourceSpecification.Validate(); err != nil {
			invalidParams.AddNested("TestSetImportResourceSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotImportSpecification sets the BotImportSpecification field's value.
func (s *ImportResourceSpecification) SetBotImportSpecification(v *BotImportSpecification) *ImportResourceSpecification {
	s.BotImportSpecification = v
	return s
}

// SetBotLocaleImportSpecification sets the BotLocaleImportSpecification field's value.
func (s *ImportResourceSpecification) SetBotLocaleImportSpecification(v *BotLocaleImportSpecification) *ImportResourceSpecification {
	s.BotLocaleImportSpecification = v
	return s
}

// SetCustomVocabularyImportSpecification sets the CustomVocabularyImportSpecification field's value.
func (s *ImportResourceSpecification) SetCustomVocabularyImportSpecification(v *CustomVocabularyImportSpecification) *ImportResourceSpecification {
	s.CustomVocabularyImportSpecification = v
	return s
}

// SetTestSetImportResourceSpecification sets the TestSetImportResourceSpecification field's value.
func (s *ImportResourceSpecification) SetTestSetImportResourceSpecification(v *TestSetImportResourceSpecification) *ImportResourceSpecification {
	s.TestSetImportResourceSpecification = v
	return s
}

// Provides information for sorting a list of imports.
type ImportSortBy struct {
	_ struct{} `type:"structure"`

	// The export field to use for sorting.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"ImportSortAttribute"`

	// The order to sort the list.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *ImportSortBy) SetAttribute(v string) *ImportSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *ImportSortBy) SetOrder(v string) *ImportSortBy {
	s.Order = &v
	return s
}

// Provides summary information about an import in an import list.
type ImportSummary struct {
	_ struct{} `type:"structure"`

	// The date and time that the import was created.
	CreationDateTime *time.Time `locationName:"creationDateTime" type:"timestamp"`

	// The unique identifier that Amazon Lex assigned to the import.
	ImportId *string `locationName:"importId" min:"10" type:"string"`

	// The status of the resource. When the status is Completed the resource is
	// ready to build.
	ImportStatus *string `locationName:"importStatus" type:"string" enum:"ImportStatus"`

	// The unique identifier that Amazon Lex assigned to the imported resource.
	ImportedResourceId *string `locationName:"importedResourceId" min:"5" type:"string"`

	// The name that you gave the imported resource.
	ImportedResourceName *string `locationName:"importedResourceName" min:"1" type:"string"`

	// The type of resource that was imported.
	ImportedResourceType *string `locationName:"importedResourceType" type:"string" enum:"ImportResourceType"`

	// The date and time that the import was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The strategy used to merge existing bot or bot locale definitions with the
	// imported definition.
	MergeStrategy *string `locationName:"mergeStrategy" type:"string" enum:"MergeStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportSummary) GoString() string {
	return s.String()
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *ImportSummary) SetCreationDateTime(v time.Time) *ImportSummary {
	s.CreationDateTime = &v
	return s
}

// SetImportId sets the ImportId field's value.
func (s *ImportSummary) SetImportId(v string) *ImportSummary {
	s.ImportId = &v
	return s
}

// SetImportStatus sets the ImportStatus field's value.
func (s *ImportSummary) SetImportStatus(v string) *ImportSummary {
	s.ImportStatus = &v
	return s
}

// SetImportedResourceId sets the ImportedResourceId field's value.
func (s *ImportSummary) SetImportedResourceId(v string) *ImportSummary {
	s.ImportedResourceId = &v
	return s
}

// SetImportedResourceName sets the ImportedResourceName field's value.
func (s *ImportSummary) SetImportedResourceName(v string) *ImportSummary {
	s.ImportedResourceName = &v
	return s
}

// SetImportedResourceType sets the ImportedResourceType field's value.
func (s *ImportSummary) SetImportedResourceType(v string) *ImportSummary {
	s.ImportedResourceType = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *ImportSummary) SetLastUpdatedDateTime(v time.Time) *ImportSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetMergeStrategy sets the MergeStrategy field's value.
func (s *ImportSummary) SetMergeStrategy(v string) *ImportSummary {
	s.MergeStrategy = &v
	return s
}

// Configuration setting for a response sent to the user before Amazon Lex starts
// eliciting slots.
type InitialResponseSetting struct {
	_ struct{} `type:"structure"`

	// Settings that specify the dialog code hook that is called by Amazon Lex at
	// a step of the conversation.
	CodeHook *DialogCodeHookInvocationSetting `locationName:"codeHook" type:"structure"`

	// Provides a list of conditional branches. Branches are evaluated in the order
	// that they are entered in the list. The first branch with a condition that
	// evaluates to true is executed. The last branch in the list is the default
	// branch. The default branch should not have any condition expression. The
	// default branch is executed if no other branch has a matching condition.
	Conditional *ConditionalSpecification `locationName:"conditional" type:"structure"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	InitialResponse *ResponseSpecification `locationName:"initialResponse" type:"structure"`

	// The next step in the conversation.
	NextStep *DialogState `locationName:"nextStep" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitialResponseSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitialResponseSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitialResponseSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitialResponseSetting"}
	if s.CodeHook != nil {
		if err := s.CodeHook.Validate(); err != nil {
			invalidParams.AddNested("CodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.Conditional != nil {
		if err := s.Conditional.Validate(); err != nil {
			invalidParams.AddNested("Conditional", err.(request.ErrInvalidParams))
		}
	}
	if s.InitialResponse != nil {
		if err := s.InitialResponse.Validate(); err != nil {
			invalidParams.AddNested("InitialResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.NextStep != nil {
		if err := s.NextStep.Validate(); err != nil {
			invalidParams.AddNested("NextStep", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeHook sets the CodeHook field's value.
func (s *InitialResponseSetting) SetCodeHook(v *DialogCodeHookInvocationSetting) *InitialResponseSetting {
	s.CodeHook = v
	return s
}

// SetConditional sets the Conditional field's value.
func (s *InitialResponseSetting) SetConditional(v *ConditionalSpecification) *InitialResponseSetting {
	s.Conditional = v
	return s
}

// SetInitialResponse sets the InitialResponse field's value.
func (s *InitialResponseSetting) SetInitialResponse(v *ResponseSpecification) *InitialResponseSetting {
	s.InitialResponse = v
	return s
}

// SetNextStep sets the NextStep field's value.
func (s *InitialResponseSetting) SetNextStep(v *DialogState) *InitialResponseSetting {
	s.NextStep = v
	return s
}

// A context that must be active for an intent to be selected by Amazon Lex.
type InputContext struct {
	_ struct{} `type:"structure"`

	// The name of the context.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputContext"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *InputContext) SetName(v string) *InputContext {
	s.Name = &v
	return s
}

// Specifications for the current state of the dialog between the user and the
// bot in the test set.
type InputSessionStateSpecification struct {
	_ struct{} `type:"structure"`

	// Active contexts for the session state.
	ActiveContexts []*ActiveContext `locationName:"activeContexts" type:"list"`

	// Runtime hints for the session state.
	RuntimeHints *RuntimeHints `locationName:"runtimeHints" type:"structure"`

	// Session attributes for the session state.
	SessionAttributes map[string]*string `locationName:"sessionAttributes" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSessionStateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSessionStateSpecification) GoString() string {
	return s.String()
}

// SetActiveContexts sets the ActiveContexts field's value.
func (s *InputSessionStateSpecification) SetActiveContexts(v []*ActiveContext) *InputSessionStateSpecification {
	s.ActiveContexts = v
	return s
}

// SetRuntimeHints sets the RuntimeHints field's value.
func (s *InputSessionStateSpecification) SetRuntimeHints(v *RuntimeHints) *InputSessionStateSpecification {
	s.RuntimeHints = v
	return s
}

// SetSessionAttributes sets the SessionAttributes field's value.
func (s *InputSessionStateSpecification) SetSessionAttributes(v map[string]*string) *InputSessionStateSpecification {
	s.SessionAttributes = v
	return s
}

// Information for an intent that is classified by the test workbench.
type IntentClassificationTestResultItem struct {
	_ struct{} `type:"structure"`

	// The name of the intent.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// Indicates whether the conversation involves multiple turns or not.
	//
	// MultiTurnConversation is a required field
	MultiTurnConversation *bool `locationName:"multiTurnConversation" type:"boolean" required:"true"`

	// The result of the intent classification test.
	//
	// ResultCounts is a required field
	ResultCounts *IntentClassificationTestResultItemCounts `locationName:"resultCounts" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClassificationTestResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClassificationTestResultItem) GoString() string {
	return s.String()
}

// SetIntentName sets the IntentName field's value.
func (s *IntentClassificationTestResultItem) SetIntentName(v string) *IntentClassificationTestResultItem {
	s.IntentName = &v
	return s
}

// SetMultiTurnConversation sets the MultiTurnConversation field's value.
func (s *IntentClassificationTestResultItem) SetMultiTurnConversation(v bool) *IntentClassificationTestResultItem {
	s.MultiTurnConversation = &v
	return s
}

// SetResultCounts sets the ResultCounts field's value.
func (s *IntentClassificationTestResultItem) SetResultCounts(v *IntentClassificationTestResultItemCounts) *IntentClassificationTestResultItem {
	s.ResultCounts = v
	return s
}

// The number of items in the intent classification test.
type IntentClassificationTestResultItemCounts struct {
	_ struct{} `type:"structure"`

	// The number of matched and mismatched results for intent recognition for the
	// intent.
	//
	// IntentMatchResultCounts is a required field
	IntentMatchResultCounts map[string]*int64 `locationName:"intentMatchResultCounts" type:"map" required:"true"`

	// The number of matched, mismatched, and execution error results for speech
	// transcription for the intent.
	SpeechTranscriptionResultCounts map[string]*int64 `locationName:"speechTranscriptionResultCounts" type:"map"`

	// The total number of results in the intent classification test.
	//
	// TotalResultCount is a required field
	TotalResultCount *int64 `locationName:"totalResultCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClassificationTestResultItemCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClassificationTestResultItemCounts) GoString() string {
	return s.String()
}

// SetIntentMatchResultCounts sets the IntentMatchResultCounts field's value.
func (s *IntentClassificationTestResultItemCounts) SetIntentMatchResultCounts(v map[string]*int64) *IntentClassificationTestResultItemCounts {
	s.IntentMatchResultCounts = v
	return s
}

// SetSpeechTranscriptionResultCounts sets the SpeechTranscriptionResultCounts field's value.
func (s *IntentClassificationTestResultItemCounts) SetSpeechTranscriptionResultCounts(v map[string]*int64) *IntentClassificationTestResultItemCounts {
	s.SpeechTranscriptionResultCounts = v
	return s
}

// SetTotalResultCount sets the TotalResultCount field's value.
func (s *IntentClassificationTestResultItemCounts) SetTotalResultCount(v int64) *IntentClassificationTestResultItemCounts {
	s.TotalResultCount = &v
	return s
}

// Information for the results of the intent classification test.
type IntentClassificationTestResults struct {
	_ struct{} `type:"structure"`

	// A list of the results for the intent classification test.
	//
	// Items is a required field
	Items []*IntentClassificationTestResultItem `locationName:"items" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClassificationTestResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClassificationTestResults) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *IntentClassificationTestResults) SetItems(v []*IntentClassificationTestResultItem) *IntentClassificationTestResults {
	s.Items = v
	return s
}

// Provides a statement the Amazon Lex conveys to the user when the intent is
// successfully fulfilled.
type IntentClosingSetting struct {
	_ struct{} `type:"structure"`

	// Specifies whether an intent's closing response is used. When this field is
	// false, the closing response isn't sent to the user. If the active field isn't
	// specified, the default is true.
	Active *bool `locationName:"active" type:"boolean"`

	// The response that Amazon Lex sends to the user when the intent is complete.
	ClosingResponse *ResponseSpecification `locationName:"closingResponse" type:"structure"`

	// A list of conditional branches associated with the intent's closing response.
	// These branches are executed when the nextStep attribute is set to EvalutateConditional.
	Conditional *ConditionalSpecification `locationName:"conditional" type:"structure"`

	// Specifies the next step that the bot executes after playing the intent's
	// closing response.
	NextStep *DialogState `locationName:"nextStep" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClosingSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentClosingSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntentClosingSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntentClosingSetting"}
	if s.ClosingResponse != nil {
		if err := s.ClosingResponse.Validate(); err != nil {
			invalidParams.AddNested("ClosingResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.Conditional != nil {
		if err := s.Conditional.Validate(); err != nil {
			invalidParams.AddNested("Conditional", err.(request.ErrInvalidParams))
		}
	}
	if s.NextStep != nil {
		if err := s.NextStep.Validate(); err != nil {
			invalidParams.AddNested("NextStep", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *IntentClosingSetting) SetActive(v bool) *IntentClosingSetting {
	s.Active = &v
	return s
}

// SetClosingResponse sets the ClosingResponse field's value.
func (s *IntentClosingSetting) SetClosingResponse(v *ResponseSpecification) *IntentClosingSetting {
	s.ClosingResponse = v
	return s
}

// SetConditional sets the Conditional field's value.
func (s *IntentClosingSetting) SetConditional(v *ConditionalSpecification) *IntentClosingSetting {
	s.Conditional = v
	return s
}

// SetNextStep sets the NextStep field's value.
func (s *IntentClosingSetting) SetNextStep(v *DialogState) *IntentClosingSetting {
	s.NextStep = v
	return s
}

// Provides a prompt for making sure that the user is ready for the intent to
// be fulfilled.
type IntentConfirmationSetting struct {
	_ struct{} `type:"structure"`

	// Specifies whether the intent's confirmation is sent to the user. When this
	// field is false, confirmation and declination responses aren't sent. If the
	// active field isn't specified, the default is true.
	Active *bool `locationName:"active" type:"boolean"`

	// The DialogCodeHookInvocationSetting object associated with intent's confirmation
	// step. The dialog code hook is triggered based on these invocation settings
	// when the confirmation next step or declination next step or failure next
	// step is InvokeDialogCodeHook.
	CodeHook *DialogCodeHookInvocationSetting `locationName:"codeHook" type:"structure"`

	// A list of conditional branches to evaluate after the intent is closed.
	ConfirmationConditional *ConditionalSpecification `locationName:"confirmationConditional" type:"structure"`

	// Specifies the next step that the bot executes when the customer confirms
	// the intent.
	ConfirmationNextStep *DialogState `locationName:"confirmationNextStep" type:"structure"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	ConfirmationResponse *ResponseSpecification `locationName:"confirmationResponse" type:"structure"`

	// A list of conditional branches to evaluate after the intent is declined.
	DeclinationConditional *ConditionalSpecification `locationName:"declinationConditional" type:"structure"`

	// Specifies the next step that the bot executes when the customer declines
	// the intent.
	DeclinationNextStep *DialogState `locationName:"declinationNextStep" type:"structure"`

	// When the user answers "no" to the question defined in promptSpecification,
	// Amazon Lex responds with this response to acknowledge that the intent was
	// canceled.
	DeclinationResponse *ResponseSpecification `locationName:"declinationResponse" type:"structure"`

	// The DialogCodeHookInvocationSetting used when the code hook is invoked during
	// confirmation prompt retries.
	ElicitationCodeHook *ElicitationCodeHookInvocationSetting `locationName:"elicitationCodeHook" type:"structure"`

	// Provides a list of conditional branches. Branches are evaluated in the order
	// that they are entered in the list. The first branch with a condition that
	// evaluates to true is executed. The last branch in the list is the default
	// branch. The default branch should not have any condition expression. The
	// default branch is executed if no other branch has a matching condition.
	FailureConditional *ConditionalSpecification `locationName:"failureConditional" type:"structure"`

	// The next step to take in the conversation if the confirmation step fails.
	FailureNextStep *DialogState `locationName:"failureNextStep" type:"structure"`

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	FailureResponse *ResponseSpecification `locationName:"failureResponse" type:"structure"`

	// Prompts the user to confirm the intent. This question should have a yes or
	// no answer.
	//
	// Amazon Lex uses this prompt to ensure that the user acknowledges that the
	// intent is ready for fulfillment. For example, with the OrderPizza intent,
	// you might want to confirm that the order is correct before placing it. For
	// other intents, such as intents that simply respond to user questions, you
	// might not need to ask the user for confirmation before providing the information.
	//
	// PromptSpecification is a required field
	PromptSpecification *PromptSpecification `locationName:"promptSpecification" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentConfirmationSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentConfirmationSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntentConfirmationSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntentConfirmationSetting"}
	if s.PromptSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptSpecification"))
	}
	if s.CodeHook != nil {
		if err := s.CodeHook.Validate(); err != nil {
			invalidParams.AddNested("CodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfirmationConditional != nil {
		if err := s.ConfirmationConditional.Validate(); err != nil {
			invalidParams.AddNested("ConfirmationConditional", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfirmationNextStep != nil {
		if err := s.ConfirmationNextStep.Validate(); err != nil {
			invalidParams.AddNested("ConfirmationNextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfirmationResponse != nil {
		if err := s.ConfirmationResponse.Validate(); err != nil {
			invalidParams.AddNested("ConfirmationResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.DeclinationConditional != nil {
		if err := s.DeclinationConditional.Validate(); err != nil {
			invalidParams.AddNested("DeclinationConditional", err.(request.ErrInvalidParams))
		}
	}
	if s.DeclinationNextStep != nil {
		if err := s.DeclinationNextStep.Validate(); err != nil {
			invalidParams.AddNested("DeclinationNextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.DeclinationResponse != nil {
		if err := s.DeclinationResponse.Validate(); err != nil {
			invalidParams.AddNested("DeclinationResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.ElicitationCodeHook != nil {
		if err := s.ElicitationCodeHook.Validate(); err != nil {
			invalidParams.AddNested("ElicitationCodeHook", err.(request.ErrInvalidParams))
		}
	}
	if s.FailureConditional != nil {
		if err := s.FailureConditional.Validate(); err != nil {
			invalidParams.AddNested("FailureConditional", err.(request.ErrInvalidParams))
		}
	}
	if s.FailureNextStep != nil {
		if err := s.FailureNextStep.Validate(); err != nil {
			invalidParams.AddNested("FailureNextStep", err.(request.ErrInvalidParams))
		}
	}
	if s.FailureResponse != nil {
		if err := s.FailureResponse.Validate(); err != nil {
			invalidParams.AddNested("FailureResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.PromptSpecification != nil {
		if err := s.PromptSpecification.Validate(); err != nil {
			invalidParams.AddNested("PromptSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *IntentConfirmationSetting) SetActive(v bool) *IntentConfirmationSetting {
	s.Active = &v
	return s
}

// SetCodeHook sets the CodeHook field's value.
func (s *IntentConfirmationSetting) SetCodeHook(v *DialogCodeHookInvocationSetting) *IntentConfirmationSetting {
	s.CodeHook = v
	return s
}

// SetConfirmationConditional sets the ConfirmationConditional field's value.
func (s *IntentConfirmationSetting) SetConfirmationConditional(v *ConditionalSpecification) *IntentConfirmationSetting {
	s.ConfirmationConditional = v
	return s
}

// SetConfirmationNextStep sets the ConfirmationNextStep field's value.
func (s *IntentConfirmationSetting) SetConfirmationNextStep(v *DialogState) *IntentConfirmationSetting {
	s.ConfirmationNextStep = v
	return s
}

// SetConfirmationResponse sets the ConfirmationResponse field's value.
func (s *IntentConfirmationSetting) SetConfirmationResponse(v *ResponseSpecification) *IntentConfirmationSetting {
	s.ConfirmationResponse = v
	return s
}

// SetDeclinationConditional sets the DeclinationConditional field's value.
func (s *IntentConfirmationSetting) SetDeclinationConditional(v *ConditionalSpecification) *IntentConfirmationSetting {
	s.DeclinationConditional = v
	return s
}

// SetDeclinationNextStep sets the DeclinationNextStep field's value.
func (s *IntentConfirmationSetting) SetDeclinationNextStep(v *DialogState) *IntentConfirmationSetting {
	s.DeclinationNextStep = v
	return s
}

// SetDeclinationResponse sets the DeclinationResponse field's value.
func (s *IntentConfirmationSetting) SetDeclinationResponse(v *ResponseSpecification) *IntentConfirmationSetting {
	s.DeclinationResponse = v
	return s
}

// SetElicitationCodeHook sets the ElicitationCodeHook field's value.
func (s *IntentConfirmationSetting) SetElicitationCodeHook(v *ElicitationCodeHookInvocationSetting) *IntentConfirmationSetting {
	s.ElicitationCodeHook = v
	return s
}

// SetFailureConditional sets the FailureConditional field's value.
func (s *IntentConfirmationSetting) SetFailureConditional(v *ConditionalSpecification) *IntentConfirmationSetting {
	s.FailureConditional = v
	return s
}

// SetFailureNextStep sets the FailureNextStep field's value.
func (s *IntentConfirmationSetting) SetFailureNextStep(v *DialogState) *IntentConfirmationSetting {
	s.FailureNextStep = v
	return s
}

// SetFailureResponse sets the FailureResponse field's value.
func (s *IntentConfirmationSetting) SetFailureResponse(v *ResponseSpecification) *IntentConfirmationSetting {
	s.FailureResponse = v
	return s
}

// SetPromptSpecification sets the PromptSpecification field's value.
func (s *IntentConfirmationSetting) SetPromptSpecification(v *PromptSpecification) *IntentConfirmationSetting {
	s.PromptSpecification = v
	return s
}

// Filters the response from the ListIntents operation.
type IntentFilter struct {
	_ struct{} `type:"structure"`

	// The name of the field to use for the filter.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"IntentFilterName"`

	// The operator to use for the filter. Specify EQ when the ListIntents operation
	// should return only aliases that equal the specified value. Specify CO when
	// the ListIntents operation should return aliases that contain the specified
	// value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"IntentFilterOperator"`

	// The value to use for the filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntentFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *IntentFilter) SetName(v string) *IntentFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IntentFilter) SetOperator(v string) *IntentFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *IntentFilter) SetValues(v []*string) *IntentFilter {
	s.Values = v
	return s
}

// Information about intent-level slot resolution in a test result.
type IntentLevelSlotResolutionTestResultItem struct {
	_ struct{} `type:"structure"`

	// The name of the intent that was recognized.
	//
	// IntentName is a required field
	IntentName *string `locationName:"intentName" min:"1" type:"string" required:"true"`

	// Indicates whether the conversation involves multiple turns or not.
	//
	// MultiTurnConversation is a required field
	MultiTurnConversation *bool `locationName:"multiTurnConversation" type:"boolean" required:"true"`

	// The results for the slot resolution in the test execution result.
	//
	// SlotResolutionResults is a required field
	SlotResolutionResults []*SlotResolutionTestResultItem `locationName:"slotResolutionResults" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentLevelSlotResolutionTestResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentLevelSlotResolutionTestResultItem) GoString() string {
	return s.String()
}

// SetIntentName sets the IntentName field's value.
func (s *IntentLevelSlotResolutionTestResultItem) SetIntentName(v string) *IntentLevelSlotResolutionTestResultItem {
	s.IntentName = &v
	return s
}

// SetMultiTurnConversation sets the MultiTurnConversation field's value.
func (s *IntentLevelSlotResolutionTestResultItem) SetMultiTurnConversation(v bool) *IntentLevelSlotResolutionTestResultItem {
	s.MultiTurnConversation = &v
	return s
}

// SetSlotResolutionResults sets the SlotResolutionResults field's value.
func (s *IntentLevelSlotResolutionTestResultItem) SetSlotResolutionResults(v []*SlotResolutionTestResultItem) *IntentLevelSlotResolutionTestResultItem {
	s.SlotResolutionResults = v
	return s
}

// Indicates the success or failure of slots at the intent level.
type IntentLevelSlotResolutionTestResults struct {
	_ struct{} `type:"structure"`

	// Indicates the items for the slot level resolution for the intents.
	//
	// Items is a required field
	Items []*IntentLevelSlotResolutionTestResultItem `locationName:"items" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentLevelSlotResolutionTestResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentLevelSlotResolutionTestResults) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *IntentLevelSlotResolutionTestResults) SetItems(v []*IntentLevelSlotResolutionTestResultItem) *IntentLevelSlotResolutionTestResults {
	s.Items = v
	return s
}

// Override settings to configure the intent state.
type IntentOverride struct {
	_ struct{} `type:"structure"`

	// The name of the intent. Only required when you're switching intents.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A map of all of the slot value overrides for the intent. The name of the
	// slot maps to the value of the slot. Slots that are not included in the map
	// aren't overridden.
	Slots map[string]*SlotValueOverride `locationName:"slots" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntentOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntentOverride"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Slots != nil {
		for i, v := range s.Slots {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Slots", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *IntentOverride) SetName(v string) *IntentOverride {
	s.Name = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *IntentOverride) SetSlots(v map[string]*SlotValueOverride) *IntentOverride {
	s.Slots = v
	return s
}

// Specifies attributes for sorting a list of intents.
type IntentSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute to use to sort the list of intents.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"IntentSortAttribute"`

	// The order to sort the list. You can choose ascending or descending.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntentSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntentSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *IntentSortBy) SetAttribute(v string) *IntentSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *IntentSortBy) SetOrder(v string) *IntentSortBy {
	s.Order = &v
	return s
}

// The object that contains the statistical summary of recommended intents associated
// with the bot recommendation.
type IntentStatistics struct {
	_ struct{} `type:"structure"`

	// The number of recommended intents associated with the bot recommendation.
	DiscoveredIntentCount *int64 `locationName:"discoveredIntentCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentStatistics) GoString() string {
	return s.String()
}

// SetDiscoveredIntentCount sets the DiscoveredIntentCount field's value.
func (s *IntentStatistics) SetDiscoveredIntentCount(v int64) *IntentStatistics {
	s.DiscoveredIntentCount = &v
	return s
}

// Summary information about an intent returned by the ListIntents operation.
type IntentSummary struct {
	_ struct{} `type:"structure"`

	// The description of the intent.
	Description *string `locationName:"description" type:"string"`

	// The input contexts that must be active for this intent to be considered for
	// recognition.
	InputContexts []*InputContext `locationName:"inputContexts" type:"list"`

	// The unique identifier assigned to the intent. Use this ID to get detailed
	// information about the intent with the DescribeIntent operation.
	IntentId *string `locationName:"intentId" min:"10" type:"string"`

	// The name of the intent.
	IntentName *string `locationName:"intentName" min:"1" type:"string"`

	// The timestamp of the date and time that the intent was last updated.
	LastUpdatedDateTime *time.Time `locationName:"lastUpdatedDateTime" type:"timestamp"`

	// The output contexts that are activated when this intent is fulfilled.
	OutputContexts []*OutputContext `locationName:"outputContexts" type:"list"`

	// If this intent is derived from a built-in intent, the name of the parent
	// intent.
	ParentIntentSignature *string `locationName:"parentIntentSignature" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntentSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *IntentSummary) SetDescription(v string) *IntentSummary {
	s.Description = &v
	return s
}

// SetInputContexts sets the InputContexts field's value.
func (s *IntentSummary) SetInputContexts(v []*InputContext) *IntentSummary {
	s.InputContexts = v
	return s
}

// SetIntentId sets the IntentId field's value.
func (s *IntentSummary) SetIntentId(v string) *IntentSummary {
	s.IntentId = &v
	return s
}

// SetIntentName sets the IntentName field's value.
func (s *IntentSummary) SetIntentName(v string) *IntentSummary {
	s.IntentName = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *IntentSummary) SetLastUpdatedDateTime(v time.Time) *IntentSummary {
	s.LastUpdatedDateTime = &v
	return s
}

// SetOutputContexts sets the OutputContexts field's value.
func (s *IntentSummary) SetOutputContexts(v []*OutputContext) *IntentSummary {
	s.OutputContexts = v
	return s
}

// SetParentIntentSignature sets the ParentIntentSignature field's value.
func (s *IntentSummary) SetParentIntentSignature(v string) *IntentSummary {
	s.ParentIntentSignature = &v
	return s
}

// The service encountered an unexpected condition. Try your request again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides configuration information for the AMAZON.KendraSearchIntent intent.
// When you use this intent, Amazon Lex searches the specified Amazon Kendra
// index and returns documents from the index that match the user's utterance.
type KendraConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the
	// AMAZON.KendraSearchIntent intent to search. The index must be in the same
	// account and Region as the Amazon Lex bot.
	//
	// KendraIndex is a required field
	KendraIndex *string `locationName:"kendraIndex" min:"32" type:"string" required:"true"`

	// A query filter that Amazon Lex sends to Amazon Kendra to filter the response
	// from a query. The filter is in the format defined by Amazon Kendra. For more
	// information, see Filtering queries (https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
	QueryFilterString *string `locationName:"queryFilterString" min:"1" type:"string"`

	// Determines whether the AMAZON.KendraSearchIntent intent uses a custom query
	// string to query the Amazon Kendra index.
	QueryFilterStringEnabled *bool `locationName:"queryFilterStringEnabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KendraConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KendraConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KendraConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KendraConfiguration"}
	if s.KendraIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("KendraIndex"))
	}
	if s.KendraIndex != nil && len(*s.KendraIndex) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("KendraIndex", 32))
	}
	if s.QueryFilterString != nil && len(*s.QueryFilterString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryFilterString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKendraIndex sets the KendraIndex field's value.
func (s *KendraConfiguration) SetKendraIndex(v string) *KendraConfiguration {
	s.KendraIndex = &v
	return s
}

// SetQueryFilterString sets the QueryFilterString field's value.
func (s *KendraConfiguration) SetQueryFilterString(v string) *KendraConfiguration {
	s.QueryFilterString = &v
	return s
}

// SetQueryFilterStringEnabled sets the QueryFilterStringEnabled field's value.
func (s *KendraConfiguration) SetQueryFilterStringEnabled(v bool) *KendraConfiguration {
	s.QueryFilterStringEnabled = &v
	return s
}

// Specifies a Lambda function that verifies requests to a bot or fulfills the
// user's request to a bot.
type LambdaCodeHook struct {
	_ struct{} `type:"structure"`

	// The version of the request-response that you want Amazon Lex to use to invoke
	// your Lambda function.
	//
	// CodeHookInterfaceVersion is a required field
	CodeHookInterfaceVersion *string `locationName:"codeHookInterfaceVersion" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// LambdaARN is a required field
	LambdaARN *string `locationName:"lambdaARN" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaCodeHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaCodeHook) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaCodeHook) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaCodeHook"}
	if s.CodeHookInterfaceVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeHookInterfaceVersion"))
	}
	if s.CodeHookInterfaceVersion != nil && len(*s.CodeHookInterfaceVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodeHookInterfaceVersion", 1))
	}
	if s.LambdaARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaARN"))
	}
	if s.LambdaARN != nil && len(*s.LambdaARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaARN", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeHookInterfaceVersion sets the CodeHookInterfaceVersion field's value.
func (s *LambdaCodeHook) SetCodeHookInterfaceVersion(v string) *LambdaCodeHook {
	s.CodeHookInterfaceVersion = &v
	return s
}

// SetLambdaARN sets the LambdaARN field's value.
func (s *LambdaCodeHook) SetLambdaARN(v string) *LambdaCodeHook {
	s.LambdaARN = &v
	return s
}

// The object that contains transcript filter details that are associated with
// a bot recommendation.
type LexTranscriptFilter struct {
	_ struct{} `type:"structure"`

	// The object that contains a date range filter that will be applied to the
	// transcript. Specify this object if you want Amazon Lex to only read the files
	// that are within the date range.
	DateRangeFilter *DateRangeFilter `locationName:"dateRangeFilter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LexTranscriptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LexTranscriptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LexTranscriptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LexTranscriptFilter"}
	if s.DateRangeFilter != nil {
		if err := s.DateRangeFilter.Validate(); err != nil {
			invalidParams.AddNested("DateRangeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRangeFilter sets the DateRangeFilter field's value.
func (s *LexTranscriptFilter) SetDateRangeFilter(v *DateRangeFilter) *LexTranscriptFilter {
	s.DateRangeFilter = v
	return s
}

type ListAggregatedUtterancesInput struct {
	_ struct{} `type:"structure"`

	// The time window for aggregating the utterance information. You can specify
	// a time between one hour and two weeks.
	//
	// AggregationDuration is a required field
	AggregationDuration *UtteranceAggregationDuration `locationName:"aggregationDuration" type:"structure" required:"true"`

	// The identifier of the bot alias associated with this request. If you specify
	// the bot alias, you can't specify the bot version.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The unique identifier of the bot associated with this request.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The identifier of the bot version associated with this request. If you specify
	// the bot version, you can't specify the bot alias.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Provides the specification of a filter used to limit the utterances in the
	// response to only those that match the filter specification. You can only
	// specify one filter and one string to filter on.
	Filters []*AggregatedUtterancesFilter `locationName:"filters" min:"1" type:"list"`

	// The identifier of the language and locale where the utterances were collected.
	// For more information, see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" type:"string" required:"true"`

	// The maximum number of utterances to return in each page of results. If there
	// are fewer results than the maximum page size, only the actual number of results
	// are returned. If you don't specify the maxResults parameter, 1,000 results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListAggregatedUtterances operation contains more
	// results that specified in the maxResults parameter, a token is returned in
	// the response. Use that token in the nextToken parameter to return the next
	// page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies sorting parameters for the list of utterances. You can sort by
	// the hit count, the missed count, or the number of distinct sessions the utterance
	// appeared in.
	SortBy *AggregatedUtterancesSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregatedUtterancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregatedUtterancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAggregatedUtterancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAggregatedUtterancesInput"}
	if s.AggregationDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregationDuration"))
	}
	if s.BotAliasId != nil && len(*s.BotAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotAliasId", 10))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.AggregationDuration != nil {
		if err := s.AggregationDuration.Validate(); err != nil {
			invalidParams.AddNested("AggregationDuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationDuration sets the AggregationDuration field's value.
func (s *ListAggregatedUtterancesInput) SetAggregationDuration(v *UtteranceAggregationDuration) *ListAggregatedUtterancesInput {
	s.AggregationDuration = v
	return s
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *ListAggregatedUtterancesInput) SetBotAliasId(v string) *ListAggregatedUtterancesInput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *ListAggregatedUtterancesInput) SetBotId(v string) *ListAggregatedUtterancesInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListAggregatedUtterancesInput) SetBotVersion(v string) *ListAggregatedUtterancesInput {
	s.BotVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListAggregatedUtterancesInput) SetFilters(v []*AggregatedUtterancesFilter) *ListAggregatedUtterancesInput {
	s.Filters = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListAggregatedUtterancesInput) SetLocaleId(v string) *ListAggregatedUtterancesInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAggregatedUtterancesInput) SetMaxResults(v int64) *ListAggregatedUtterancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAggregatedUtterancesInput) SetNextToken(v string) *ListAggregatedUtterancesInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListAggregatedUtterancesInput) SetSortBy(v *AggregatedUtterancesSortBy) *ListAggregatedUtterancesInput {
	s.SortBy = v
	return s
}

type ListAggregatedUtterancesOutput struct {
	_ struct{} `type:"structure"`

	// Summaries of the aggregated utterance data. Each response contains information
	// about the number of times that the utterance was seen during the time period,
	// whether it was detected or missed, and when it was seen during the time period.
	AggregatedUtterancesSummaries []*AggregatedUtterancesSummary `locationName:"aggregatedUtterancesSummaries" type:"list"`

	// The time period used to aggregate the utterance data.
	AggregationDuration *UtteranceAggregationDuration `locationName:"aggregationDuration" type:"structure"`

	// The last date and time that the aggregated data was collected. The time period
	// depends on the length of the aggregation window.
	//
	//    * Hours - for 1 hour time window, every half hour; otherwise every hour.
	//
	//    * Days - every 6 hours
	//
	//    * Weeks - for a one week time window, every 12 hours; otherwise, every
	//    day
	AggregationLastRefreshedDateTime *time.Time `locationName:"aggregationLastRefreshedDateTime" type:"timestamp"`

	// The date and time that the aggregation window ends. Only data collected between
	// the start time and the end time are returned in the results.
	AggregationWindowEndTime *time.Time `locationName:"aggregationWindowEndTime" type:"timestamp"`

	// The date and time that the aggregation window begins. Only data collected
	// after this time is returned in the results.
	AggregationWindowStartTime *time.Time `locationName:"aggregationWindowStartTime" type:"timestamp"`

	// The identifier of the bot alias that contains the utterances. If you specified
	// the bot version, the bot alias ID isn't returned.
	BotAliasId *string `locationName:"botAliasId" min:"10" type:"string"`

	// The identifier of the bot that contains the utterances.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the bot version that contains the utterances. If you specified
	// the bot alias, the bot version isn't returned.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The identifier of the language and locale that the utterances are in.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListAggregatedUtterances operation. If the nextToken field is present,
	// you send the contents as the nextToken parameter of a ListAggregatedUtterances
	// operation request to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregatedUtterancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAggregatedUtterancesOutput) GoString() string {
	return s.String()
}

// SetAggregatedUtterancesSummaries sets the AggregatedUtterancesSummaries field's value.
func (s *ListAggregatedUtterancesOutput) SetAggregatedUtterancesSummaries(v []*AggregatedUtterancesSummary) *ListAggregatedUtterancesOutput {
	s.AggregatedUtterancesSummaries = v
	return s
}

// SetAggregationDuration sets the AggregationDuration field's value.
func (s *ListAggregatedUtterancesOutput) SetAggregationDuration(v *UtteranceAggregationDuration) *ListAggregatedUtterancesOutput {
	s.AggregationDuration = v
	return s
}

// SetAggregationLastRefreshedDateTime sets the AggregationLastRefreshedDateTime field's value.
func (s *ListAggregatedUtterancesOutput) SetAggregationLastRefreshedDateTime(v time.Time) *ListAggregatedUtterancesOutput {
	s.AggregationLastRefreshedDateTime = &v
	return s
}

// SetAggregationWindowEndTime sets the AggregationWindowEndTime field's value.
func (s *ListAggregatedUtterancesOutput) SetAggregationWindowEndTime(v time.Time) *ListAggregatedUtterancesOutput {
	s.AggregationWindowEndTime = &v
	return s
}

// SetAggregationWindowStartTime sets the AggregationWindowStartTime field's value.
func (s *ListAggregatedUtterancesOutput) SetAggregationWindowStartTime(v time.Time) *ListAggregatedUtterancesOutput {
	s.AggregationWindowStartTime = &v
	return s
}

// SetBotAliasId sets the BotAliasId field's value.
func (s *ListAggregatedUtterancesOutput) SetBotAliasId(v string) *ListAggregatedUtterancesOutput {
	s.BotAliasId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *ListAggregatedUtterancesOutput) SetBotId(v string) *ListAggregatedUtterancesOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListAggregatedUtterancesOutput) SetBotVersion(v string) *ListAggregatedUtterancesOutput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListAggregatedUtterancesOutput) SetLocaleId(v string) *ListAggregatedUtterancesOutput {
	s.LocaleId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAggregatedUtterancesOutput) SetNextToken(v string) *ListAggregatedUtterancesOutput {
	s.NextToken = &v
	return s
}

type ListBotAliasesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to list aliases for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The maximum number of aliases to return in each page of results. If there
	// are fewer results than the max page size, only the actual number of results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListBotAliases operation contains more results than
	// specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBotAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBotAliasesInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListBotAliasesInput) SetBotId(v string) *ListBotAliasesInput {
	s.BotId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBotAliasesInput) SetMaxResults(v int64) *ListBotAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotAliasesInput) SetNextToken(v string) *ListBotAliasesInput {
	s.NextToken = &v
	return s
}

type ListBotAliasesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information for the bot aliases that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter
	// of the request. If there are more aliases available, the nextToken field
	// contains a token to get the next page of results.
	BotAliasSummaries []*BotAliasSummary `locationName:"botAliasSummaries" type:"list"`

	// The identifier of the bot associated with the aliases.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBotAliases operation. If the nextToken field is present, you send
	// the contents as the nextToken parameter of a ListBotAliases operation request
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotAliasesOutput) GoString() string {
	return s.String()
}

// SetBotAliasSummaries sets the BotAliasSummaries field's value.
func (s *ListBotAliasesOutput) SetBotAliasSummaries(v []*BotAliasSummary) *ListBotAliasesOutput {
	s.BotAliasSummaries = v
	return s
}

// SetBotId sets the BotId field's value.
func (s *ListBotAliasesOutput) SetBotId(v string) *ListBotAliasesOutput {
	s.BotId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotAliasesOutput) SetNextToken(v string) *ListBotAliasesOutput {
	s.NextToken = &v
	return s
}

type ListBotLocalesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to list locales for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot to list locales for.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// Provides the specification for a filter used to limit the response to only
	// those locales that match the filter specification. You can only specify one
	// filter and one value to filter on.
	Filters []*BotLocaleFilter `locationName:"filters" min:"1" type:"list"`

	// The maximum number of aliases to return in each page of results. If there
	// are fewer results than the max page size, only the actual number of results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListBotLocales operation contains more results than
	// specified in the maxResults parameter, a token is returned in the response.
	// Use that token as the nextToken parameter to return the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies sorting parameters for the list of locales. You can sort by locale
	// name in ascending or descending order.
	SortBy *BotLocaleSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotLocalesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotLocalesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBotLocalesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBotLocalesInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListBotLocalesInput) SetBotId(v string) *ListBotLocalesInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListBotLocalesInput) SetBotVersion(v string) *ListBotLocalesInput {
	s.BotVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListBotLocalesInput) SetFilters(v []*BotLocaleFilter) *ListBotLocalesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBotLocalesInput) SetMaxResults(v int64) *ListBotLocalesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotLocalesInput) SetNextToken(v string) *ListBotLocalesInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListBotLocalesInput) SetSortBy(v *BotLocaleSortBy) *ListBotLocalesInput {
	s.SortBy = v
	return s
}

type ListBotLocalesOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to list locales for.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// Summary information for the locales that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter
	// of the request. If there are more locales available, the nextToken field
	// contains a token to get the next page of results.
	BotLocaleSummaries []*BotLocaleSummary `locationName:"botLocaleSummaries" type:"list"`

	// The version of the bot.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBotLocales operation. If the nextToken field is present, you send
	// the contents as the nextToken parameter of a ListBotLocales operation request
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotLocalesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotLocalesOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *ListBotLocalesOutput) SetBotId(v string) *ListBotLocalesOutput {
	s.BotId = &v
	return s
}

// SetBotLocaleSummaries sets the BotLocaleSummaries field's value.
func (s *ListBotLocalesOutput) SetBotLocaleSummaries(v []*BotLocaleSummary) *ListBotLocalesOutput {
	s.BotLocaleSummaries = v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListBotLocalesOutput) SetBotVersion(v string) *ListBotLocalesOutput {
	s.BotVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotLocalesOutput) SetNextToken(v string) *ListBotLocalesOutput {
	s.NextToken = &v
	return s
}

type ListBotRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot that contains the bot recommendation list.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The version of the bot that contains the bot recommendation list.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"5" type:"string" required:"true"`

	// The identifier of the language and locale of the bot recommendation list.
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The maximum number of bot recommendations to return in each page of results.
	// If there are fewer results than the max page size, only the actual number
	// of results are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListBotRecommendation operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBotRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBotRecommendationsInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListBotRecommendationsInput) SetBotId(v string) *ListBotRecommendationsInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListBotRecommendationsInput) SetBotVersion(v string) *ListBotRecommendationsInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListBotRecommendationsInput) SetLocaleId(v string) *ListBotRecommendationsInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBotRecommendationsInput) SetMaxResults(v int64) *ListBotRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotRecommendationsInput) SetNextToken(v string) *ListBotRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListBotRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the bot that contains the bot recommendation list.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// Summary information for the bot recommendations that meet the filter specified
	// in this request. The length of the list is specified in the maxResults parameter
	// of the request. If there are more bot recommendations available, the nextToken
	// field contains a token to get the next page of results.
	BotRecommendationSummaries []*BotRecommendationSummary `locationName:"botRecommendationSummaries" type:"list"`

	// The version of the bot that contains the bot recommendation list.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// The identifier of the language and locale of the bot recommendation list.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBotRecommendations operation. If the nextToken field is present,
	// you send the contents as the nextToken parameter of a ListBotRecommendations
	// operation request to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotRecommendationsOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *ListBotRecommendationsOutput) SetBotId(v string) *ListBotRecommendationsOutput {
	s.BotId = &v
	return s
}

// SetBotRecommendationSummaries sets the BotRecommendationSummaries field's value.
func (s *ListBotRecommendationsOutput) SetBotRecommendationSummaries(v []*BotRecommendationSummary) *ListBotRecommendationsOutput {
	s.BotRecommendationSummaries = v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListBotRecommendationsOutput) SetBotVersion(v string) *ListBotRecommendationsOutput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListBotRecommendationsOutput) SetLocaleId(v string) *ListBotRecommendationsOutput {
	s.LocaleId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotRecommendationsOutput) SetNextToken(v string) *ListBotRecommendationsOutput {
	s.NextToken = &v
	return s
}

type ListBotVersionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to list versions for.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The maximum number of versions to return in each page of results. If there
	// are fewer results than the max page size, only the actual number of results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response to the ListBotVersion operation contains more results than
	// specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies sorting parameters for the list of versions. You can specify that
	// the list be sorted by version name in either ascending or descending order.
	SortBy *BotVersionSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBotVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBotVersionsInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListBotVersionsInput) SetBotId(v string) *ListBotVersionsInput {
	s.BotId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBotVersionsInput) SetMaxResults(v int64) *ListBotVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotVersionsInput) SetNextToken(v string) *ListBotVersionsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListBotVersionsInput) SetSortBy(v *BotVersionSortBy) *ListBotVersionsInput {
	s.SortBy = v
	return s
}

type ListBotVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot to list versions for.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// Summary information for the bot versions that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter
	// of the request. If there are more versions available, the nextToken field
	// contains a token to get the next page of results.
	BotVersionSummaries []*BotVersionSummary `locationName:"botVersionSummaries" type:"list"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBotVersions operation. If the nextToken field is present, you
	// send the contents as the nextToken parameter of a ListBotAliases operation
	// request to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotVersionsOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *ListBotVersionsOutput) SetBotId(v string) *ListBotVersionsOutput {
	s.BotId = &v
	return s
}

// SetBotVersionSummaries sets the BotVersionSummaries field's value.
func (s *ListBotVersionsOutput) SetBotVersionSummaries(v []*BotVersionSummary) *ListBotVersionsOutput {
	s.BotVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotVersionsOutput) SetNextToken(v string) *ListBotVersionsOutput {
	s.NextToken = &v
	return s
}

type ListBotsInput struct {
	_ struct{} `type:"structure"`

	// Provides the specification of a filter used to limit the bots in the response
	// to only those that match the filter specification. You can only specify one
	// filter and one string to filter on.
	Filters []*BotFilter `locationName:"filters" min:"1" type:"list"`

	// The maximum number of bots to return in each page of results. If there are
	// fewer results than the maximum page size, only the actual number of results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListBots operation contains more results than specified
	// in the maxResults parameter, a token is returned in the response.
	//
	// Use the returned token in the nextToken parameter of a ListBots request to
	// return the next page of results. For a complete set of results, call the
	// ListBots operation until the nextToken returned in the response is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies sorting parameters for the list of bots. You can specify that the
	// list be sorted by bot name in ascending or descending order.
	SortBy *BotSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBotsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListBotsInput) SetFilters(v []*BotFilter) *ListBotsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBotsInput) SetMaxResults(v int64) *ListBotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotsInput) SetNextToken(v string) *ListBotsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListBotsInput) SetSortBy(v *BotSortBy) *ListBotsInput {
	s.SortBy = v
	return s
}

type ListBotsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information for the bots that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter
	// of the request. If there are more bots available, the nextToken field contains
	// a token to the next page of results.
	BotSummaries []*BotSummary `locationName:"botSummaries" type:"list"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBots operation. If the nextToken field is present, you send the
	// contents as the nextToken parameter of a ListBots operation request to get
	// the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBotsOutput) GoString() string {
	return s.String()
}

// SetBotSummaries sets the BotSummaries field's value.
func (s *ListBotsOutput) SetBotSummaries(v []*BotSummary) *ListBotsOutput {
	s.BotSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotsOutput) SetNextToken(v string) *ListBotsOutput {
	s.NextToken = &v
	return s
}

type ListBuiltInIntentsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the language and locale of the intents to list. The string
	// must match one of the supported locales. For more information, see Supported
	// languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The maximum number of built-in intents to return in each page of results.
	// If there are fewer results than the max page size, only the actual number
	// of results are returned.
	MaxResults *int64 `locationName:"maxResults" min:"20" type:"integer"`

	// If the response from the ListBuiltInIntents operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Specifies sorting parameters for the list of built-in intents. You can specify
	// that the list be sorted by the built-in intent signature in either ascending
	// or descending order.
	SortBy *BuiltInIntentSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInIntentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInIntentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuiltInIntentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuiltInIntentsInput"}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 20 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 20))
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListBuiltInIntentsInput) SetLocaleId(v string) *ListBuiltInIntentsInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBuiltInIntentsInput) SetMaxResults(v int64) *ListBuiltInIntentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuiltInIntentsInput) SetNextToken(v string) *ListBuiltInIntentsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListBuiltInIntentsInput) SetSortBy(v *BuiltInIntentSortBy) *ListBuiltInIntentsInput {
	s.SortBy = v
	return s
}

type ListBuiltInIntentsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information for the built-in intents that meet the filter criteria
	// specified in the request. The length of the list is specified in the maxResults
	// parameter of the request. If there are more intents available, the nextToken
	// field contains a token to get the next page of results.
	BuiltInIntentSummaries []*BuiltInIntentSummary `locationName:"builtInIntentSummaries" type:"list"`

	// The language and locale of the intents in the list.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBuiltInIntents operation. If the nextToken field is present, you
	// send the contents as the nextToken parameter of a ListBotAliases operation
	// request to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInIntentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInIntentsOutput) GoString() string {
	return s.String()
}

// SetBuiltInIntentSummaries sets the BuiltInIntentSummaries field's value.
func (s *ListBuiltInIntentsOutput) SetBuiltInIntentSummaries(v []*BuiltInIntentSummary) *ListBuiltInIntentsOutput {
	s.BuiltInIntentSummaries = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListBuiltInIntentsOutput) SetLocaleId(v string) *ListBuiltInIntentsOutput {
	s.LocaleId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuiltInIntentsOutput) SetNextToken(v string) *ListBuiltInIntentsOutput {
	s.NextToken = &v
	return s
}

type ListBuiltInSlotTypesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the language and locale of the slot types to list. The
	// string must match one of the supported locales. For more information, see
	// Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The maximum number of built-in slot types to return in each page of results.
	// If there are fewer results than the max page size, only the actual number
	// of results are returned.
	MaxResults *int64 `locationName:"maxResults" min:"20" type:"integer"`

	// If the response from the ListBuiltInSlotTypes operation contains more results
	// than specified in the maxResults parameter, a token is returned in the response.
	// Use that token in the nextToken parameter to return the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Determines the sort order for the response from the ListBuiltInSlotTypes
	// operation. You can choose to sort by the slot type signature in either ascending
	// or descending order.
	SortBy *BuiltInSlotTypeSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInSlotTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInSlotTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuiltInSlotTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuiltInSlotTypesInput"}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 20 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 20))
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListBuiltInSlotTypesInput) SetLocaleId(v string) *ListBuiltInSlotTypesInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBuiltInSlotTypesInput) SetMaxResults(v int64) *ListBuiltInSlotTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuiltInSlotTypesInput) SetNextToken(v string) *ListBuiltInSlotTypesInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListBuiltInSlotTypesInput) SetSortBy(v *BuiltInSlotTypeSortBy) *ListBuiltInSlotTypesInput {
	s.SortBy = v
	return s
}

type ListBuiltInSlotTypesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information for the built-in slot types that meet the filter criteria
	// specified in the request. The length of the list is specified in the maxResults
	// parameter of the request. If there are more slot types available, the nextToken
	// field contains a token to get the next page of results.
	BuiltInSlotTypeSummaries []*BuiltInSlotTypeSummary `locationName:"builtInSlotTypeSummaries" type:"list"`

	// The language and locale of the slot types in the list.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListBuiltInSlotTypes operation. If the nextToken field is present,
	// you send the contents as the nextToken parameter of a LIstBuiltInSlotTypes
	// operation request to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInSlotTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuiltInSlotTypesOutput) GoString() string {
	return s.String()
}

// SetBuiltInSlotTypeSummaries sets the BuiltInSlotTypeSummaries field's value.
func (s *ListBuiltInSlotTypesOutput) SetBuiltInSlotTypeSummaries(v []*BuiltInSlotTypeSummary) *ListBuiltInSlotTypesOutput {
	s.BuiltInSlotTypeSummaries = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListBuiltInSlotTypesOutput) SetLocaleId(v string) *ListBuiltInSlotTypesOutput {
	s.LocaleId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuiltInSlotTypesOutput) SetNextToken(v string) *ListBuiltInSlotTypesOutput {
	s.NextToken = &v
	return s
}

type ListCustomVocabularyItemsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" min:"10" type:"string" required:"true"`

	// The bot version of the bot to the list custom vocabulary request.
	//
	// BotVersion is a required field
	BotVersion *string `location:"uri" locationName:"botVersion" min:"1" type:"string" required:"true"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// LocaleId is a required field
	LocaleId *string `location:"uri" locationName:"localeId" type:"string" required:"true"`

	// The maximum number of items returned by the list operation.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken identifier to the list custom vocabulary request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVocabularyItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVocabularyItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomVocabularyItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomVocabularyItemsInput"}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("BotVersion"))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListCustomVocabularyItemsInput) SetBotId(v string) *ListCustomVocabularyItemsInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListCustomVocabularyItemsInput) SetBotVersion(v string) *ListCustomVocabularyItemsInput {
	s.BotVersion = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListCustomVocabularyItemsInput) SetLocaleId(v string) *ListCustomVocabularyItemsInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomVocabularyItemsInput) SetMaxResults(v int64) *ListCustomVocabularyItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomVocabularyItemsInput) SetNextToken(v string) *ListCustomVocabularyItemsInput {
	s.NextToken = &v
	return s
}

type ListCustomVocabularyItemsOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bot associated with this custom vocabulary.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The identifier of the version of the bot associated with this custom vocabulary.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// The custom vocabulary items from the list custom vocabulary response.
	CustomVocabularyItems []*CustomVocabularyItem `locationName:"customVocabularyItems" type:"list"`

	// The identifier of the language and locale where this custom vocabulary is
	// used. The string must match one of the supported locales. For more information,
	// see Supported Languages (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	LocaleId *string `locationName:"localeId" type:"string"`

	// The nextToken identifier to the list custom vocabulary response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVocabularyItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomVocabularyItemsOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *ListCustomVocabularyItemsOutput) SetBotId(v string) *ListCustomVocabularyItemsOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListCustomVocabularyItemsOutput) SetBotVersion(v string) *ListCustomVocabularyItemsOutput {
	s.BotVersion = &v
	return s
}

// SetCustomVocabularyItems sets the CustomVocabularyItems field's value.
func (s *ListCustomVocabularyItemsOutput) SetCustomVocabularyItems(v []*CustomVocabularyItem) *ListCustomVocabularyItemsOutput {
	s.CustomVocabularyItems = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListCustomVocabularyItemsOutput) SetLocaleId(v string) *ListCustomVocabularyItemsOutput {
	s.LocaleId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomVocabularyItemsOutput) SetNextToken(v string) *ListCustomVocabularyItemsOutput {
	s.NextToken = &v
	return s
}

type ListExportsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier that Amazon Lex assigned to the bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot to list exports for.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Provides the specification of a filter used to limit the exports in the response
	// to only those that match the filter specification. You can only specify one
	// filter and one string to filter on.
	Filters []*ExportFilter `locationName:"filters" min:"1" type:"list"`

	// Specifies the resources that should be exported. If you don't specify a resource
	// type in the filters parameter, both bot locales and custom vocabularies are
	// exported.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The maximum number of exports to return in each page of results. If there
	// are fewer results than the max page size, only the actual number of results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListExports operation contains more results that
	// specified in the maxResults parameter, a token is returned in the response.
	//
	// Use the returned token in the nextToken parameter of a ListExports request
	// to return the next page of results. For a complete set of results, call the
	// ListExports operation until the nextToken returned in the response is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Determines the field that the list of exports is sorted by. You can sort
	// by the LastUpdatedDateTime field in ascending or descending order.
	SortBy *ExportSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExportsInput"}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListExportsInput) SetBotId(v string) *ListExportsInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListExportsInput) SetBotVersion(v string) *ListExportsInput {
	s.BotVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListExportsInput) SetFilters(v []*ExportFilter) *ListExportsInput {
	s.Filters = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListExportsInput) SetLocaleId(v string) *ListExportsInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListExportsInput) SetMaxResults(v int64) *ListExportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsInput) SetNextToken(v string) *ListExportsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListExportsInput) SetSortBy(v *ExportSortBy) *ListExportsInput {
	s.SortBy = v
	return s
}

type ListExportsOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned to the bot by Amazon Lex.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot that was exported.
	BotVersion *string `locationName:"botVersion" min:"1" type:"string"`

	// Summary information for the exports that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter.
	// If there are more exports available, the nextToken field contains a token
	// to get the next page of results.
	ExportSummaries []*ExportSummary `locationName:"exportSummaries" type:"list"`

	// The locale specified in the request.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListExports operation. If the nextToken field is present, you send
	// the contents as the nextToken parameter of a ListExports operation request
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListExportsOutput) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *ListExportsOutput) SetBotId(v string) *ListExportsOutput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListExportsOutput) SetBotVersion(v string) *ListExportsOutput {
	s.BotVersion = &v
	return s
}

// SetExportSummaries sets the ExportSummaries field's value.
func (s *ListExportsOutput) SetExportSummaries(v []*ExportSummary) *ListExportsOutput {
	s.ExportSummaries = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListExportsOutput) SetLocaleId(v string) *ListExportsOutput {
	s.LocaleId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsOutput) SetNextToken(v string) *ListExportsOutput {
	s.NextToken = &v
	return s
}

type ListImportsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier that Amazon Lex assigned to the bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot to list imports for.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// Provides the specification of a filter used to limit the bots in the response
	// to only those that match the filter specification. You can only specify one
	// filter and one string to filter on.
	Filters []*ImportFilter `locationName:"filters" min:"1" type:"list"`

	// Specifies the locale that should be present in the list. If you don't specify
	// a resource type in the filters parameter, the list contains both bot locales
	// and custom vocabularies.
	LocaleId *string `locationName:"localeId" type:"string"`

	// The maximum number of imports to return in each page of results. If there
	// are fewer results than the max page size, only the actual number of results
	// are returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the response from the ListImports operation contains more results than
	// specified in the maxResults parameter, a token is returned in the response.
	//
	// Use the returned token in the nextToken parameter of a ListImports request
	// to return the next page of results. For a complete set of results, call the
	// ListImports operation until the nextToken returned in the response is null.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Determines the field that the list of imports is sorted by. You can sort
	// by the LastUpdatedDateTime field in ascending or descending order.
	SortBy *ImportSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImportsInput"}
	if s.BotId != nil && len(*s.BotId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 10))
	}
	if s.BotVersion != nil && len(*s.BotVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("BotVersion", 5))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotId sets the BotId field's value.
func (s *ListImportsInput) SetBotId(v string) *ListImportsInput {
	s.BotId = &v
	return s
}

// SetBotVersion sets the BotVersion field's value.
func (s *ListImportsInput) SetBotVersion(v string) *ListImportsInput {
	s.BotVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListImportsInput) SetFilters(v []*ImportFilter) *ListImportsInput {
	s.Filters = v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *ListImportsInput) SetLocaleId(v string) *ListImportsInput {
	s.LocaleId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImportsInput) SetMaxResults(v int64) *ListImportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsInput) SetNextToken(v string) *ListImportsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListImportsInput) SetSortBy(v *ImportSortBy) *ListImportsInput {
	s.SortBy = v
	return s
}

type ListImportsOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned by Amazon Lex to the bot.
	BotId *string `locationName:"botId" min:"10" type:"string"`

	// The version of the bot that was imported. It will always be DRAFT.
	BotVersion *string `locationName:"botVersion" min:"5" type:"string"`

	// Summary information for the imports that meet the filter criteria specified
	// in the request. The length of the list is specified in the maxResults parameter.
	// If there are more imports available, the nextToken field contains a token
	// to get the next page of results.
	ImportSummaries []*ImportSummary `locationName:"importSummaries" type:"list"`

	// The locale specified in the request.
	LocaleId *string `locationName:"localeId" type:"string"`

	// A token that indicates whether there are more results to return in a response
	// to the ListImports operation. If the nextToken field is present, you send
	// the contents as the nextToken parameter of a ListImports operation request
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the A