#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsAddLogContainer(plfolog: *const super::super::Foundation::FILE_OBJECT, pcbcontainer: *const u64, puszcontainerpath: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsAddLogContainer(plfolog : *const super::super::Foundation:: FILE_OBJECT, pcbcontainer : *const u64, puszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsAddLogContainer(plfolog, pcbcontainer, puszcontainerpath)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsAddLogContainerSet(plfolog: *const super::super::Foundation::FILE_OBJECT, pcbcontainer: ::core::option::Option<*const u64>, rguszcontainerpath: &[super::super::super::Win32::Foundation::UNICODE_STRING]) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsAddLogContainerSet(plfolog : *const super::super::Foundation:: FILE_OBJECT, ccontainers : u16, pcbcontainer : *const u64, rguszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsAddLogContainerSet(plfolog, rguszcontainerpath.len().try_into().unwrap(), ::core::mem::transmute(pcbcontainer.unwrap_or(::std::ptr::null())), ::core::mem::transmute(rguszcontainerpath.as_ptr()))
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsAdvanceLogBase(pvmarshalcontext: *mut ::core::ffi::c_void, plsnbase: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, fflags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsAdvanceLogBase(pvmarshalcontext : *mut ::core::ffi::c_void, plsnbase : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, fflags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsAdvanceLogBase(pvmarshalcontext, plsnbase, fflags)
}
#[inline]
pub unsafe fn ClfsAlignReservedLog(pvmarshalcontext: *const ::core::ffi::c_void, rgcbreservation: &[i64], pcbalignreservation: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsAlignReservedLog(pvmarshalcontext : *const ::core::ffi::c_void, crecords : u32, rgcbreservation : *const i64, pcbalignreservation : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsAlignReservedLog(pvmarshalcontext, rgcbreservation.len().try_into().unwrap(), ::core::mem::transmute(rgcbreservation.as_ptr()), pcbalignreservation)
}
#[inline]
pub unsafe fn ClfsAllocReservedLog(pvmarshalcontext: *const ::core::ffi::c_void, pcbadjustment: &[i64]) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsAllocReservedLog(pvmarshalcontext : *const ::core::ffi::c_void, crecords : u32, pcbadjustment : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsAllocReservedLog(pvmarshalcontext, pcbadjustment.len().try_into().unwrap(), ::core::mem::transmute(pcbadjustment.as_ptr()))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCloseAndResetLogFile(plfolog: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsCloseAndResetLogFile(plfolog : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsCloseAndResetLogFile(plfolog)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCloseLogFileObject(plfolog: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsCloseLogFileObject(plfolog : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsCloseLogFileObject(plfolog)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateLogFile<P0>(pplfolog: *mut *mut super::super::Foundation::FILE_OBJECT, puszlogfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, fdesiredaccess: u32, dwsharemode: u32, psdlogfile: P0, fcreatedisposition: u32, fcreateoptions: u32, fflagsandattributes: u32, flogoptionflag: u32, pvcontext: ::core::option::Option<*const ::core::ffi::c_void>, cbcontext: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
{
    ::windows_targets::link!("clfs.sys" "system" fn ClfsCreateLogFile(pplfolog : *mut *mut super::super::Foundation:: FILE_OBJECT, puszlogfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, fdesiredaccess : u32, dwsharemode : u32, psdlogfile : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, fcreatedisposition : u32, fcreateoptions : u32, fflagsandattributes : u32, flogoptionflag : u32, pvcontext : *const ::core::ffi::c_void, cbcontext : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsCreateLogFile(pplfolog, puszlogfilename, fdesiredaccess, dwsharemode, psdlogfile.into_param().abi(), fcreatedisposition, fcreateoptions, fflagsandattributes, flogoptionflag, ::core::mem::transmute(pvcontext.unwrap_or(::std::ptr::null())), cbcontext)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateMarshallingArea(plfolog: *const super::super::Foundation::FILE_OBJECT, epooltype: super::super::Foundation::POOL_TYPE, pfnallocbuffer: PALLOCATE_FUNCTION, pfnfreebuffer: super::super::Foundation::PFREE_FUNCTION, cbmarshallingbuffer: u32, cmaxwritebuffers: u32, cmaxreadbuffers: u32, ppvmarshalcontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsCreateMarshallingArea(plfolog : *const super::super::Foundation:: FILE_OBJECT, epooltype : super::super::Foundation:: POOL_TYPE, pfnallocbuffer : PALLOCATE_FUNCTION, pfnfreebuffer : super::super::Foundation:: PFREE_FUNCTION, cbmarshallingbuffer : u32, cmaxwritebuffers : u32, cmaxreadbuffers : u32, ppvmarshalcontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsCreateMarshallingArea(plfolog, epooltype, pfnallocbuffer, pfnfreebuffer, cbmarshallingbuffer, cmaxwritebuffers, cmaxreadbuffers, ppvmarshalcontext)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateMarshallingAreaEx(plfolog: *const super::super::Foundation::FILE_OBJECT, epooltype: super::super::Foundation::POOL_TYPE, pfnallocbuffer: PALLOCATE_FUNCTION, pfnfreebuffer: super::super::Foundation::PFREE_FUNCTION, cbmarshallingbuffer: u32, cmaxwritebuffers: u32, cmaxreadbuffers: u32, calignmentsize: u32, fflags: u64, ppvmarshalcontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsCreateMarshallingAreaEx(plfolog : *const super::super::Foundation:: FILE_OBJECT, epooltype : super::super::Foundation:: POOL_TYPE, pfnallocbuffer : PALLOCATE_FUNCTION, pfnfreebuffer : super::super::Foundation:: PFREE_FUNCTION, cbmarshallingbuffer : u32, cmaxwritebuffers : u32, cmaxreadbuffers : u32, calignmentsize : u32, fflags : u64, ppvmarshalcontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsCreateMarshallingAreaEx(plfolog, epooltype, pfnallocbuffer, pfnfreebuffer, cbmarshallingbuffer, cmaxwritebuffers, cmaxreadbuffers, calignmentsize, fflags, ppvmarshalcontext)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsCreateScanContext(plfolog: *const super::super::Foundation::FILE_OBJECT, cfromcontainer: u32, ccontainers: u32, escanmode: u8, pcxscan: *mut super::super::super::Win32::Storage::FileSystem::CLS_SCAN_CONTEXT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsCreateScanContext(plfolog : *const super::super::Foundation:: FILE_OBJECT, cfromcontainer : u32, ccontainers : u32, escanmode : u8, pcxscan : *mut super::super::super::Win32::Storage::FileSystem:: CLS_SCAN_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsCreateScanContext(plfolog, cfromcontainer, ccontainers, escanmode, pcxscan)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsDeleteLogByPointer(plfolog: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsDeleteLogByPointer(plfolog : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsDeleteLogByPointer(plfolog)
}
#[inline]
pub unsafe fn ClfsDeleteLogFile(puszlogfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, flogoptionflag: u32, pvcontext: ::core::option::Option<*const ::core::ffi::c_void>, cbcontext: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsDeleteLogFile(puszlogfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, pvreserved : *const ::core::ffi::c_void, flogoptionflag : u32, pvcontext : *const ::core::ffi::c_void, cbcontext : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsDeleteLogFile(puszlogfilename, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), flogoptionflag, ::core::mem::transmute(pvcontext.unwrap_or(::std::ptr::null())), cbcontext)
}
#[inline]
pub unsafe fn ClfsDeleteMarshallingArea(pvmarshalcontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsDeleteMarshallingArea(pvmarshalcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsDeleteMarshallingArea(pvmarshalcontext)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsEarlierLsn(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Storage::FileSystem::CLS_LSN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsEarlierLsn(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Storage::FileSystem:: CLS_LSN);
    ClfsEarlierLsn(plsn)
}
#[inline]
pub unsafe fn ClfsFinalize() {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsFinalize());
    ClfsFinalize()
}
#[inline]
pub unsafe fn ClfsFlushBuffers(pvmarshalcontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsFlushBuffers(pvmarshalcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsFlushBuffers(pvmarshalcontext)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsFlushToLsn(pvmarshalcontext: *const ::core::ffi::c_void, plsnflush: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnlastflushed: ::core::option::Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsFlushToLsn(pvmarshalcontext : *const ::core::ffi::c_void, plsnflush : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnlastflushed : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsFlushToLsn(pvmarshalcontext, plsnflush, ::core::mem::transmute(plsnlastflushed.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn ClfsFreeReservedLog(pvmarshalcontext: *const ::core::ffi::c_void, pcbadjustment: &[i64]) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsFreeReservedLog(pvmarshalcontext : *const ::core::ffi::c_void, crecords : u32, pcbadjustment : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsFreeReservedLog(pvmarshalcontext, pcbadjustment.len().try_into().unwrap(), ::core::mem::transmute(pcbadjustment.as_ptr()))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsGetContainerName(plfolog: *const super::super::Foundation::FILE_OBJECT, cidlogicalcontainer: u32, puszcontainername: *mut super::super::super::Win32::Foundation::UNICODE_STRING, pcactuallencontainername: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsGetContainerName(plfolog : *const super::super::Foundation:: FILE_OBJECT, cidlogicalcontainer : u32, puszcontainername : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, pcactuallencontainername : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsGetContainerName(plfolog, cidlogicalcontainer, puszcontainername, ::core::mem::transmute(pcactuallencontainername.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsGetIoStatistics(plfolog: *const super::super::Foundation::FILE_OBJECT, pvstatsbuffer: *mut ::core::ffi::c_void, cbstatsbuffer: u32, estatsclass: super::super::super::Win32::Storage::FileSystem::CLFS_IOSTATS_CLASS, pcbstatswritten: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsGetIoStatistics(plfolog : *const super::super::Foundation:: FILE_OBJECT, pvstatsbuffer : *mut ::core::ffi::c_void, cbstatsbuffer : u32, estatsclass : super::super::super::Win32::Storage::FileSystem:: CLFS_IOSTATS_CLASS, pcbstatswritten : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsGetIoStatistics(plfolog, pvstatsbuffer, cbstatsbuffer, estatsclass, ::core::mem::transmute(pcbstatswritten.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsGetLogFileInformation(plfolog: *const super::super::Foundation::FILE_OBJECT, pinfobuffer: *mut super::super::super::Win32::Storage::FileSystem::CLS_INFORMATION, pcbinfobuffer: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsGetLogFileInformation(plfolog : *const super::super::Foundation:: FILE_OBJECT, pinfobuffer : *mut super::super::super::Win32::Storage::FileSystem:: CLS_INFORMATION, pcbinfobuffer : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsGetLogFileInformation(plfolog, pinfobuffer, pcbinfobuffer)
}
#[inline]
pub unsafe fn ClfsInitialize() -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsInitialize() -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsInitialize()
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLaterLsn(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Storage::FileSystem::CLS_LSN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLaterLsn(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Storage::FileSystem:: CLS_LSN);
    ClfsLaterLsn(plsn)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnBlockOffset(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> u32 {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnBlockOffset(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> u32);
    ClfsLsnBlockOffset(plsn)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnContainer(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> u32 {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnContainer(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> u32);
    ClfsLsnContainer(plsn)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnCreate(cidcontainer: u32, offblock: u32, crecord: u32) -> super::super::super::Win32::Storage::FileSystem::CLS_LSN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnCreate(cidcontainer : u32, offblock : u32, crecord : u32) -> super::super::super::Win32::Storage::FileSystem:: CLS_LSN);
    ClfsLsnCreate(cidcontainer, offblock, crecord)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnDifference(plsnstart: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnfinish: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, cbcontainer: u32, cbmaxblock: u32, pcbdifference: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnDifference(plsnstart : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnfinish : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, cbcontainer : u32, cbmaxblock : u32, pcbdifference : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsLsnDifference(plsnstart, plsnfinish, cbcontainer, cbmaxblock, pcbdifference)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnEqual(plsn1: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsn2: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnEqual(plsn1 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsn2 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ClfsLsnEqual(plsn1, plsn2)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnGreater(plsn1: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsn2: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnGreater(plsn1 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsn2 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ClfsLsnGreater(plsn1, plsn2)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnInvalid(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnInvalid(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ClfsLsnInvalid(plsn)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnLess(plsn1: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsn2: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnLess(plsn1 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsn2 : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ClfsLsnLess(plsn1, plsn2)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnNull(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnNull(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ClfsLsnNull(plsn)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsLsnRecordSequence(plsn: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> u32 {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsLsnRecordSequence(plsn : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> u32);
    ClfsLsnRecordSequence(plsn)
}
#[inline]
pub unsafe fn ClfsMgmtDeregisterManagedClient(clientcookie: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtDeregisterManagedClient(clientcookie : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtDeregisterManagedClient(clientcookie)
}
#[inline]
pub unsafe fn ClfsMgmtHandleLogFileFull(client: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtHandleLogFileFull(client : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtHandleLogFileFull(client)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtInstallPolicy(logfile: *const super::super::Foundation::FILE_OBJECT, policy: *const super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY, policylength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtInstallPolicy(logfile : *const super::super::Foundation:: FILE_OBJECT, policy : *const super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY, policylength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtInstallPolicy(logfile, policy, policylength)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtQueryPolicy(logfile: *const super::super::Foundation::FILE_OBJECT, policytype: super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY_TYPE, policy: *mut super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY, policylength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtQueryPolicy(logfile : *const super::super::Foundation:: FILE_OBJECT, policytype : super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY_TYPE, policy : *mut super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY, policylength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtQueryPolicy(logfile, policytype, policy, policylength)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtRegisterManagedClient(logfile: *const super::super::Foundation::FILE_OBJECT, registrationdata: *const CLFS_MGMT_CLIENT_REGISTRATION, clientcookie: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtRegisterManagedClient(logfile : *const super::super::Foundation:: FILE_OBJECT, registrationdata : *const CLFS_MGMT_CLIENT_REGISTRATION, clientcookie : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtRegisterManagedClient(logfile, registrationdata, clientcookie)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtRemovePolicy(logfile: *const super::super::Foundation::FILE_OBJECT, policytype: super::super::super::Win32::Storage::FileSystem::CLFS_MGMT_POLICY_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtRemovePolicy(logfile : *const super::super::Foundation:: FILE_OBJECT, policytype : super::super::super::Win32::Storage::FileSystem:: CLFS_MGMT_POLICY_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtRemovePolicy(logfile, policytype)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtSetLogFileSize(logfile: *const super::super::Foundation::FILE_OBJECT, newsizeincontainers: *const u64, resultingsizeincontainers: ::core::option::Option<*mut u64>, completionroutine: PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtSetLogFileSize(logfile : *const super::super::Foundation:: FILE_OBJECT, newsizeincontainers : *const u64, resultingsizeincontainers : *mut u64, completionroutine : PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtSetLogFileSize(logfile, newsizeincontainers, ::core::mem::transmute(resultingsizeincontainers.unwrap_or(::std::ptr::null_mut())), completionroutine, ::core::mem::transmute(completionroutinedata.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsMgmtSetLogFileSizeAsClient(logfile: *const super::super::Foundation::FILE_OBJECT, clientcookie: ::core::option::Option<*const *const ::core::ffi::c_void>, newsizeincontainers: *const u64, resultingsizeincontainers: ::core::option::Option<*mut u64>, completionroutine: PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtSetLogFileSizeAsClient(logfile : *const super::super::Foundation:: FILE_OBJECT, clientcookie : *const *const ::core::ffi::c_void, newsizeincontainers : *const u64, resultingsizeincontainers : *mut u64, completionroutine : PCLFS_SET_LOG_SIZE_COMPLETE_CALLBACK, completionroutinedata : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtSetLogFileSizeAsClient(logfile, ::core::mem::transmute(clientcookie.unwrap_or(::std::ptr::null())), newsizeincontainers, ::core::mem::transmute(resultingsizeincontainers.unwrap_or(::std::ptr::null_mut())), completionroutine, ::core::mem::transmute(completionroutinedata.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ClfsMgmtTailAdvanceFailure<P0>(client: *const ::core::ffi::c_void, reason: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("clfs.sys" "system" fn ClfsMgmtTailAdvanceFailure(client : *const ::core::ffi::c_void, reason : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsMgmtTailAdvanceFailure(client, reason.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsQueryLogFileInformation(plfolog: *const super::super::Foundation::FILE_OBJECT, einformationclass: super::super::super::Win32::Storage::FileSystem::CLS_LOG_INFORMATION_CLASS, pinfoinputbuffer: ::core::option::Option<*const ::core::ffi::c_void>, cbinfoinputbuffer: u32, pinfobuffer: *mut ::core::ffi::c_void, pcbinfobuffer: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsQueryLogFileInformation(plfolog : *const super::super::Foundation:: FILE_OBJECT, einformationclass : super::super::super::Win32::Storage::FileSystem:: CLS_LOG_INFORMATION_CLASS, pinfoinputbuffer : *const ::core::ffi::c_void, cbinfoinputbuffer : u32, pinfobuffer : *mut ::core::ffi::c_void, pcbinfobuffer : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsQueryLogFileInformation(plfolog, einformationclass, ::core::mem::transmute(pinfoinputbuffer.unwrap_or(::std::ptr::null())), cbinfoinputbuffer, pinfobuffer, pcbinfobuffer)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadLogRecord(pvmarshalcontext: *const ::core::ffi::c_void, plsnfirst: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, pecontextmode: super::super::super::Win32::Storage::FileSystem::CLFS_CONTEXT_MODE, ppvreadbuffer: *mut *mut ::core::ffi::c_void, pcbreadbuffer: *mut u32, perecordtype: *mut u8, plsnundonext: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnprevious: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, ppvreadcontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsReadLogRecord(pvmarshalcontext : *const ::core::ffi::c_void, plsnfirst : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, pecontextmode : super::super::super::Win32::Storage::FileSystem:: CLFS_CONTEXT_MODE, ppvreadbuffer : *mut *mut ::core::ffi::c_void, pcbreadbuffer : *mut u32, perecordtype : *mut u8, plsnundonext : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, ppvreadcontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsReadLogRecord(pvmarshalcontext, plsnfirst, pecontextmode, ppvreadbuffer, pcbreadbuffer, perecordtype, plsnundonext, plsnprevious, ppvreadcontext)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadNextLogRecord(pvreadcontext: *mut ::core::ffi::c_void, ppvbuffer: *mut *mut ::core::ffi::c_void, pcbbuffer: *mut u32, perecordtype: *mut u8, plsnuser: ::core::option::Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, plsnundonext: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnprevious: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, plsnrecord: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsReadNextLogRecord(pvreadcontext : *mut ::core::ffi::c_void, ppvbuffer : *mut *mut ::core::ffi::c_void, pcbbuffer : *mut u32, perecordtype : *mut u8, plsnuser : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnundonext : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnrecord : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsReadNextLogRecord(pvreadcontext, ppvbuffer, pcbbuffer, perecordtype, ::core::mem::transmute(plsnuser.unwrap_or(::std::ptr::null())), plsnundonext, plsnprevious, plsnrecord)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadPreviousRestartArea(pvreadcontext: *const ::core::ffi::c_void, ppvrestartbuffer: *mut *mut ::core::ffi::c_void, pcbrestartbuffer: *mut u32, plsnrestart: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsReadPreviousRestartArea(pvreadcontext : *const ::core::ffi::c_void, ppvrestartbuffer : *mut *mut ::core::ffi::c_void, pcbrestartbuffer : *mut u32, plsnrestart : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsReadPreviousRestartArea(pvreadcontext, ppvrestartbuffer, pcbrestartbuffer, plsnrestart)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReadRestartArea(pvmarshalcontext: *mut ::core::ffi::c_void, ppvrestartbuffer: *mut *mut ::core::ffi::c_void, pcbrestartbuffer: *mut u32, plsn: *mut super::super::super::Win32::Storage::FileSystem::CLS_LSN, ppvreadcontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsReadRestartArea(pvmarshalcontext : *mut ::core::ffi::c_void, ppvrestartbuffer : *mut *mut ::core::ffi::c_void, pcbrestartbuffer : *mut u32, plsn : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN, ppvreadcontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsReadRestartArea(pvmarshalcontext, ppvrestartbuffer, pcbrestartbuffer, plsn, ppvreadcontext)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsRemoveLogContainer<P0>(plfolog: *const super::super::Foundation::FILE_OBJECT, puszcontainerpath: *const super::super::super::Win32::Foundation::UNICODE_STRING, fforce: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("clfs.sys" "system" fn ClfsRemoveLogContainer(plfolog : *const super::super::Foundation:: FILE_OBJECT, puszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, fforce : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsRemoveLogContainer(plfolog, puszcontainerpath, fforce.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsRemoveLogContainerSet<P0>(plfolog: *const super::super::Foundation::FILE_OBJECT, rgwszcontainerpath: &[super::super::super::Win32::Foundation::UNICODE_STRING], fforce: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("clfs.sys" "system" fn ClfsRemoveLogContainerSet(plfolog : *const super::super::Foundation:: FILE_OBJECT, ccontainers : u16, rgwszcontainerpath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, fforce : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsRemoveLogContainerSet(plfolog, rgwszcontainerpath.len().try_into().unwrap(), ::core::mem::transmute(rgwszcontainerpath.as_ptr()), fforce.into_param().abi())
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReserveAndAppendLog(pvmarshalcontext: *const ::core::ffi::c_void, rgwriteentries: ::core::option::Option<&[super::super::super::Win32::Storage::FileSystem::CLS_WRITE_ENTRY]>, plsnundonext: ::core::option::Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, plsnprevious: ::core::option::Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, rgcbreservation: ::core::option::Option<&mut [i64]>, fflags: u32, plsn: ::core::option::Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsReserveAndAppendLog(pvmarshalcontext : *const ::core::ffi::c_void, rgwriteentries : *const super::super::super::Win32::Storage::FileSystem:: CLS_WRITE_ENTRY, cwriteentries : u32, plsnundonext : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, creserverecords : u32, rgcbreservation : *mut i64, fflags : u32, plsn : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsReserveAndAppendLog(
        pvmarshalcontext,
        ::core::mem::transmute(rgwriteentries.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        rgwriteentries.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        ::core::mem::transmute(plsnundonext.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(plsnprevious.unwrap_or(::std::ptr::null())),
        rgcbreservation.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        ::core::mem::transmute(rgcbreservation.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        fflags,
        ::core::mem::transmute(plsn.unwrap_or(::std::ptr::null_mut())),
    )
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsReserveAndAppendLogAligned(pvmarshalcontext: *const ::core::ffi::c_void, rgwriteentries: ::core::option::Option<&[super::super::super::Win32::Storage::FileSystem::CLS_WRITE_ENTRY]>, cbentryalignment: u32, plsnundonext: ::core::option::Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, plsnprevious: ::core::option::Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, rgcbreservation: ::core::option::Option<&mut [i64]>, fflags: u32, plsn: ::core::option::Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsReserveAndAppendLogAligned(pvmarshalcontext : *const ::core::ffi::c_void, rgwriteentries : *const super::super::super::Win32::Storage::FileSystem:: CLS_WRITE_ENTRY, cwriteentries : u32, cbentryalignment : u32, plsnundonext : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, plsnprevious : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, creserverecords : u32, rgcbreservation : *mut i64, fflags : u32, plsn : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsReserveAndAppendLogAligned(
        pvmarshalcontext,
        ::core::mem::transmute(rgwriteentries.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        rgwriteentries.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        cbentryalignment,
        ::core::mem::transmute(plsnundonext.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(plsnprevious.unwrap_or(::std::ptr::null())),
        rgcbreservation.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()),
        ::core::mem::transmute(rgcbreservation.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        fflags,
        ::core::mem::transmute(plsn.unwrap_or(::std::ptr::null_mut())),
    )
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsScanLogContainers(pcxscan: *mut super::super::super::Win32::Storage::FileSystem::CLS_SCAN_CONTEXT, escanmode: u8) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsScanLogContainers(pcxscan : *mut super::super::super::Win32::Storage::FileSystem:: CLS_SCAN_CONTEXT, escanmode : u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsScanLogContainers(pcxscan, escanmode)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsSetArchiveTail(plfolog: *const super::super::Foundation::FILE_OBJECT, plsnarchivetail: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsSetArchiveTail(plfolog : *const super::super::Foundation:: FILE_OBJECT, plsnarchivetail : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsSetArchiveTail(plfolog, plsnarchivetail)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsSetEndOfLog(plfolog: *const super::super::Foundation::FILE_OBJECT, plsnend: *const super::super::super::Win32::Storage::FileSystem::CLS_LSN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsSetEndOfLog(plfolog : *const super::super::Foundation:: FILE_OBJECT, plsnend : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsSetEndOfLog(plfolog, plsnend)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_FileSystem", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn ClfsSetLogFileInformation(plfolog: *const super::super::Foundation::FILE_OBJECT, einformationclass: super::super::super::Win32::Storage::FileSystem::CLS_LOG_INFORMATION_CLASS, pinfobuffer: *const ::core::ffi::c_void, cbbuffer: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsSetLogFileInformation(plfolog : *const super::super::Foundation:: FILE_OBJECT, einformationclass : super::super::super::Win32::Storage::FileSystem:: CLS_LOG_INFORMATION_CLASS, pinfobuffer : *const ::core::ffi::c_void, cbbuffer : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsSetLogFileInformation(plfolog, einformationclass, pinfobuffer, cbbuffer)
}
#[inline]
pub unsafe fn ClfsTerminateReadLog(pvcursorcontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsTerminateReadLog(pvcursorcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsTerminateReadLog(pvcursorcontext)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ClfsWriteRestartArea(pvmarshalcontext: *mut ::core::ffi::c_void, pvrestartbuffer: *const ::core::ffi::c_void, cbrestartbuffer: u32, plsnbase: ::core::option::Option<*const super::super::super::Win32::Storage::FileSystem::CLS_LSN>, fflags: u32, pcbwritten: ::core::option::Option<*mut u32>, plsnnext: ::core::option::Option<*mut super::super::super::Win32::Storage::FileSystem::CLS_LSN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("clfs.sys" "system" fn ClfsWriteRestartArea(pvmarshalcontext : *mut ::core::ffi::c_void, pvrestartbuffer : *const ::core::ffi::c_void, cbrestartbuffer : u32, plsnbase : *const super::super::super::Win32::Storage::FileSystem:: CLS_LSN, fflags : u32, pcbwritten : *mut u32, plsnnext : *mut super::super::super::Win32::Storage::FileSystem:: CLS_LSN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ClfsWriteRestartArea(pvmarshalcontext, pvrestartbuffer, cbrestartbuffer, ::core::mem::transmute(plsnbase.unwrap_or(::std::ptr::null())), fflags, ::core::mem::transmute(pcbwritten.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(plsnnext.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CmCallbackGetKeyObjectID(cookie: *const i64, object: *const ::core::ffi::c_void, objectid: ::core::option::Option<*mut usize>, objectname: ::core::option::Option<*mut *mut super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmCallbackGetKeyObjectID(cookie : *const i64, object : *const ::core::ffi::c_void, objectid : *mut usize, objectname : *mut *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    CmCallbackGetKeyObjectID(cookie, object, ::core::mem::transmute(objectid.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(objectname.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CmCallbackGetKeyObjectIDEx(cookie: *const i64, object: *const ::core::ffi::c_void, objectid: ::core::option::Option<*mut usize>, objectname: ::core::option::Option<*mut *mut super::super::super::Win32::Foundation::UNICODE_STRING>, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmCallbackGetKeyObjectIDEx(cookie : *const i64, object : *const ::core::ffi::c_void, objectid : *mut usize, objectname : *mut *mut super::super::super::Win32::Foundation:: UNICODE_STRING, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    CmCallbackGetKeyObjectIDEx(cookie, object, ::core::mem::transmute(objectid.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(objectname.unwrap_or(::std::ptr::null_mut())), flags)
}
#[inline]
pub unsafe fn CmCallbackReleaseKeyObjectIDEx(objectname: *const super::super::super::Win32::Foundation::UNICODE_STRING) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmCallbackReleaseKeyObjectIDEx(objectname : *const super::super::super::Win32::Foundation:: UNICODE_STRING));
    CmCallbackReleaseKeyObjectIDEx(objectname)
}
#[inline]
pub unsafe fn CmGetBoundTransaction(cookie: *const i64, object: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmGetBoundTransaction(cookie : *const i64, object : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    CmGetBoundTransaction(cookie, object)
}
#[inline]
pub unsafe fn CmGetCallbackVersion(major: ::core::option::Option<*mut u32>, minor: ::core::option::Option<*mut u32>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmGetCallbackVersion(major : *mut u32, minor : *mut u32));
    CmGetCallbackVersion(::core::mem::transmute(major.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(minor.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CmRegisterCallback(function: PEX_CALLBACK_FUNCTION, context: ::core::option::Option<*const ::core::ffi::c_void>, cookie: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmRegisterCallback(function : PEX_CALLBACK_FUNCTION, context : *const ::core::ffi::c_void, cookie : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    CmRegisterCallback(function, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), cookie)
}
#[inline]
pub unsafe fn CmRegisterCallbackEx(function: PEX_CALLBACK_FUNCTION, altitude: *const super::super::super::Win32::Foundation::UNICODE_STRING, driver: *const ::core::ffi::c_void, context: ::core::option::Option<*const ::core::ffi::c_void>, cookie: *mut i64, reserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmRegisterCallbackEx(function : PEX_CALLBACK_FUNCTION, altitude : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driver : *const ::core::ffi::c_void, context : *const ::core::ffi::c_void, cookie : *mut i64, reserved : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    CmRegisterCallbackEx(function, altitude, driver, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), cookie, ::core::mem::transmute(reserved.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn CmSetCallbackObjectContext(object: *mut ::core::ffi::c_void, cookie: *const i64, newcontext: *const ::core::ffi::c_void, oldcontext: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmSetCallbackObjectContext(object : *mut ::core::ffi::c_void, cookie : *const i64, newcontext : *const ::core::ffi::c_void, oldcontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    CmSetCallbackObjectContext(object, cookie, newcontext, ::core::mem::transmute(oldcontext.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn CmUnRegisterCallback(cookie: i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn CmUnRegisterCallback(cookie : i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    CmUnRegisterCallback(cookie)
}
#[inline]
pub unsafe fn DbgBreakPointWithStatus(status: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn DbgBreakPointWithStatus(status : u32));
    DbgBreakPointWithStatus(status)
}
#[inline]
pub unsafe fn DbgPrint<P0>(format: P0) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "cdecl" fn DbgPrint(format : ::windows_core::PCSTR) -> u32);
    DbgPrint(format.into_param().abi())
}
#[inline]
pub unsafe fn DbgPrintEx<P0>(componentid: u32, level: u32, format: P0) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "cdecl" fn DbgPrintEx(componentid : u32, level : u32, format : ::windows_core::PCSTR) -> u32);
    DbgPrintEx(componentid, level, format.into_param().abi())
}
#[inline]
pub unsafe fn DbgPrintReturnControlC<P0>(format: P0) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "cdecl" fn DbgPrintReturnControlC(format : ::windows_core::PCSTR) -> u32);
    DbgPrintReturnControlC(format.into_param().abi())
}
#[inline]
pub unsafe fn DbgPrompt<P0>(prompt: P0, response: &mut [u8]) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn DbgPrompt(prompt : ::windows_core::PCSTR, response : ::windows_core::PSTR, length : u32) -> u32);
    DbgPrompt(prompt.into_param().abi(), ::core::mem::transmute(response.as_ptr()), response.len().try_into().unwrap())
}
#[inline]
pub unsafe fn DbgQueryDebugFilterState(componentid: u32, level: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn DbgQueryDebugFilterState(componentid : u32, level : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    DbgQueryDebugFilterState(componentid, level)
}
#[inline]
pub unsafe fn DbgSetDebugFilterState<P0>(componentid: u32, level: u32, state: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn DbgSetDebugFilterState(componentid : u32, level : u32, state : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    DbgSetDebugFilterState(componentid, level, state.into_param().abi())
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn DbgSetDebugPrintCallback<P0>(debugprintcallback: PDEBUG_PRINT_CALLBACK, enable: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn DbgSetDebugPrintCallback(debugprintcallback : PDEBUG_PRINT_CALLBACK, enable : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    DbgSetDebugPrintCallback(debugprintcallback, enable.into_param().abi())
}
#[inline]
pub unsafe fn EtwActivityIdControl(controlcode: u32, activityid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwActivityIdControl(controlcode : u32, activityid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwActivityIdControl(controlcode, activityid)
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwEventEnabled(reghandle: u64, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn EtwEventEnabled(reghandle : u64, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR) -> super::super::super::Win32::Foundation:: BOOLEAN);
    EtwEventEnabled(reghandle, eventdescriptor)
}
#[inline]
pub unsafe fn EtwProviderEnabled(reghandle: u64, level: u8, keyword: u64) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwProviderEnabled(reghandle : u64, level : u8, keyword : u64) -> super::super::super::Win32::Foundation:: BOOLEAN);
    EtwProviderEnabled(reghandle, level, keyword)
}
#[inline]
pub unsafe fn EtwRegister(providerid: *const ::windows_core::GUID, enablecallback: PETWENABLECALLBACK, callbackcontext: ::core::option::Option<*const ::core::ffi::c_void>, reghandle: *mut u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwRegister(providerid : *const ::windows_core::GUID, enablecallback : PETWENABLECALLBACK, callbackcontext : *const ::core::ffi::c_void, reghandle : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwRegister(providerid, enablecallback, ::core::mem::transmute(callbackcontext.unwrap_or(::std::ptr::null())), reghandle)
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwSetInformation(reghandle: u64, informationclass: super::super::super::Win32::System::Diagnostics::Etw::EVENT_INFO_CLASS, eventinformation: ::core::option::Option<*const ::core::ffi::c_void>, informationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwSetInformation(reghandle : u64, informationclass : super::super::super::Win32::System::Diagnostics::Etw:: EVENT_INFO_CLASS, eventinformation : *const ::core::ffi::c_void, informationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwSetInformation(reghandle, informationclass, ::core::mem::transmute(eventinformation.unwrap_or(::std::ptr::null())), informationlength)
}
#[inline]
pub unsafe fn EtwUnregister(reghandle: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwUnregister(reghandle : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwUnregister(reghandle)
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWrite(reghandle: u64, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR, activityid: ::core::option::Option<*const ::windows_core::GUID>, userdata: ::core::option::Option<&[super::super::super::Win32::System::Diagnostics::Etw::EVENT_DATA_DESCRIPTOR]>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwWrite(reghandle : u64, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR, activityid : *const ::windows_core::GUID, userdatacount : u32, userdata : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DATA_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwWrite(reghandle, eventdescriptor, ::core::mem::transmute(activityid.unwrap_or(::std::ptr::null())), userdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), ::core::mem::transmute(userdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())))
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWriteEx(reghandle: u64, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR, filter: u64, flags: u32, activityid: ::core::option::Option<*const ::windows_core::GUID>, relatedactivityid: ::core::option::Option<*const ::windows_core::GUID>, userdata: ::core::option::Option<&[super::super::super::Win32::System::Diagnostics::Etw::EVENT_DATA_DESCRIPTOR]>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwWriteEx(reghandle : u64, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR, filter : u64, flags : u32, activityid : *const ::windows_core::GUID, relatedactivityid : *const ::windows_core::GUID, userdatacount : u32, userdata : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DATA_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwWriteEx(reghandle, eventdescriptor, filter, flags, ::core::mem::transmute(activityid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(relatedactivityid.unwrap_or(::std::ptr::null())), userdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), ::core::mem::transmute(userdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())))
}
#[inline]
pub unsafe fn EtwWriteString<P0>(reghandle: u64, level: u8, keyword: u64, activityid: ::core::option::Option<*const ::windows_core::GUID>, string: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwWriteString(reghandle : u64, level : u8, keyword : u64, activityid : *const ::windows_core::GUID, string : ::windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwWriteString(reghandle, level, keyword, ::core::mem::transmute(activityid.unwrap_or(::std::ptr::null())), string.into_param().abi())
}
#[cfg(feature = "Win32_System_Diagnostics_Etw")]
#[inline]
pub unsafe fn EtwWriteTransfer(reghandle: u64, eventdescriptor: *const super::super::super::Win32::System::Diagnostics::Etw::EVENT_DESCRIPTOR, activityid: ::core::option::Option<*const ::windows_core::GUID>, relatedactivityid: ::core::option::Option<*const ::windows_core::GUID>, userdata: ::core::option::Option<&[super::super::super::Win32::System::Diagnostics::Etw::EVENT_DATA_DESCRIPTOR]>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn EtwWriteTransfer(reghandle : u64, eventdescriptor : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DESCRIPTOR, activityid : *const ::windows_core::GUID, relatedactivityid : *const ::windows_core::GUID, userdatacount : u32, userdata : *const super::super::super::Win32::System::Diagnostics::Etw:: EVENT_DATA_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    EtwWriteTransfer(reghandle, eventdescriptor, ::core::mem::transmute(activityid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(relatedactivityid.unwrap_or(::std::ptr::null())), userdata.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), ::core::mem::transmute(userdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireFastMutex(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireFastMutex(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    ExAcquireFastMutex(fastmutex)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireFastMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireFastMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    ExAcquireFastMutexUnsafe(fastmutex)
}
#[inline]
pub unsafe fn ExAcquirePushLockExclusiveEx(pushlock: *mut usize, flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquirePushLockExclusiveEx(pushlock : *mut usize, flags : u32));
    ExAcquirePushLockExclusiveEx(pushlock, flags)
}
#[inline]
pub unsafe fn ExAcquirePushLockSharedEx(pushlock: *mut usize, flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquirePushLockSharedEx(pushlock : *mut usize, flags : u32));
    ExAcquirePushLockSharedEx(pushlock, flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireResourceExclusiveLite<P0>(resource: *mut super::super::Foundation::ERESOURCE, wait: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireResourceExclusiveLite(resource : *mut super::super::Foundation:: ERESOURCE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireResourceExclusiveLite(resource, wait.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireResourceSharedLite<P0>(resource: *mut super::super::Foundation::ERESOURCE, wait: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireResourceSharedLite(resource : *mut super::super::Foundation:: ERESOURCE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireResourceSharedLite(resource, wait.into_param().abi())
}
#[inline]
pub unsafe fn ExAcquireRundownProtection(runref: *mut EX_RUNDOWN_REF) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtection(runref : *mut EX_RUNDOWN_REF) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireRundownProtection(runref)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAcquireRundownProtectionCacheAware<P0>(runrefcacheaware: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireRundownProtectionCacheAware(runrefcacheaware.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAcquireRundownProtectionCacheAwareEx<P0>(runrefcacheaware: P0, count: u32) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtectionCacheAwareEx(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, count : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireRundownProtectionCacheAwareEx(runrefcacheaware.into_param().abi(), count)
}
#[inline]
pub unsafe fn ExAcquireRundownProtectionEx(runref: *mut EX_RUNDOWN_REF, count: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireRundownProtectionEx(runref : *mut EX_RUNDOWN_REF, count : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireRundownProtectionEx(runref, count)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireSharedStarveExclusive<P0>(resource: *mut super::super::Foundation::ERESOURCE, wait: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireSharedStarveExclusive(resource : *mut super::super::Foundation:: ERESOURCE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireSharedStarveExclusive(resource, wait.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExAcquireSharedWaitForExclusive<P0>(resource: *mut super::super::Foundation::ERESOURCE, wait: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireSharedWaitForExclusive(resource : *mut super::super::Foundation:: ERESOURCE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExAcquireSharedWaitForExclusive(resource, wait.into_param().abi())
}
#[inline]
pub unsafe fn ExAcquireSpinLockExclusive(spinlock: *mut i32) -> u8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockExclusive(spinlock : *mut i32) -> u8);
    ExAcquireSpinLockExclusive(spinlock)
}
#[inline]
pub unsafe fn ExAcquireSpinLockExclusiveAtDpcLevel(spinlock: *mut i32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockExclusiveAtDpcLevel(spinlock : *mut i32));
    ExAcquireSpinLockExclusiveAtDpcLevel(spinlock)
}
#[inline]
pub unsafe fn ExAcquireSpinLockShared(spinlock: *mut i32) -> u8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockShared(spinlock : *mut i32) -> u8);
    ExAcquireSpinLockShared(spinlock)
}
#[inline]
pub unsafe fn ExAcquireSpinLockSharedAtDpcLevel(spinlock: *mut i32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAcquireSpinLockSharedAtDpcLevel(spinlock : *mut i32));
    ExAcquireSpinLockSharedAtDpcLevel(spinlock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocateCacheAwareRundownProtection(pooltype: super::super::Foundation::POOL_TYPE, pooltag: u32) -> super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocateCacheAwareRundownProtection(pooltype : super::super::Foundation:: POOL_TYPE, pooltag : u32) -> super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE);
    ExAllocateCacheAwareRundownProtection(pooltype, pooltag)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePool(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePool(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize) -> *mut ::core::ffi::c_void);
    ExAllocatePool(pooltype, numberofbytes)
}
#[inline]
pub unsafe fn ExAllocatePool2(flags: u64, numberofbytes: usize, tag: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePool2(flags : u64, numberofbytes : usize, tag : u32) -> *mut ::core::ffi::c_void);
    ExAllocatePool2(flags, numberofbytes, tag)
}
#[inline]
pub unsafe fn ExAllocatePool3(flags: u64, numberofbytes: usize, tag: u32, extendedparameters: ::core::option::Option<&[POOL_EXTENDED_PARAMETER]>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePool3(flags : u64, numberofbytes : usize, tag : u32, extendedparameters : *const POOL_EXTENDED_PARAMETER, extendedparameterscount : u32) -> *mut ::core::ffi::c_void);
    ExAllocatePool3(flags, numberofbytes, tag, ::core::mem::transmute(extendedparameters.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), extendedparameters.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithQuota(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithQuota(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize) -> *mut ::core::ffi::c_void);
    ExAllocatePoolWithQuota(pooltype, numberofbytes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithQuotaTag(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithQuotaTag(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize, tag : u32) -> *mut ::core::ffi::c_void);
    ExAllocatePoolWithQuotaTag(pooltype, numberofbytes, tag)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithTag(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithTag(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize, tag : u32) -> *mut ::core::ffi::c_void);
    ExAllocatePoolWithTag(pooltype, numberofbytes, tag)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocatePoolWithTagPriority(pooltype: super::super::Foundation::POOL_TYPE, numberofbytes: usize, tag: u32, priority: EX_POOL_PRIORITY) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocatePoolWithTagPriority(pooltype : super::super::Foundation:: POOL_TYPE, numberofbytes : usize, tag : u32, priority : EX_POOL_PRIORITY) -> *mut ::core::ffi::c_void);
    ExAllocatePoolWithTagPriority(pooltype, numberofbytes, tag, priority)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExAllocateTimer(callback: PEXT_CALLBACK, callbackcontext: ::core::option::Option<*const ::core::ffi::c_void>, attributes: u32) -> super::super::Foundation::PEX_TIMER {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExAllocateTimer(callback : PEXT_CALLBACK, callbackcontext : *const ::core::ffi::c_void, attributes : u32) -> super::super::Foundation:: PEX_TIMER);
    ExAllocateTimer(callback, ::core::mem::transmute(callbackcontext.unwrap_or(::std::ptr::null())), attributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExCancelTimer<P0>(timer: P0, parameters: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_TIMER>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExCancelTimer(timer : super::super::Foundation:: PEX_TIMER, parameters : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExCancelTimer(timer.into_param().abi(), ::core::mem::transmute(parameters.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExCleanupRundownProtectionCacheAware<P0>(runrefcacheaware: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExCleanupRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    ExCleanupRundownProtectionCacheAware(runrefcacheaware.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExConvertExclusiveToSharedLite(resource: *mut super::super::Foundation::ERESOURCE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExConvertExclusiveToSharedLite(resource : *mut super::super::Foundation:: ERESOURCE));
    ExConvertExclusiveToSharedLite(resource)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExCreateCallback<P0, P1>(callbackobject: *mut super::super::Foundation::PCALLBACK_OBJECT, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, create: P0, allowmultiplecallbacks: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExCreateCallback(callbackobject : *mut super::super::Foundation:: PCALLBACK_OBJECT, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, create : super::super::super::Win32::Foundation:: BOOLEAN, allowmultiplecallbacks : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExCreateCallback(callbackobject, objectattributes, create.into_param().abi(), allowmultiplecallbacks.into_param().abi())
}
#[inline]
pub unsafe fn ExCreatePool(flags: u32, tag: usize, params: ::core::option::Option<*const POOL_CREATE_EXTENDED_PARAMS>, poolhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExCreatePool(flags : u32, tag : usize, params : *const POOL_CREATE_EXTENDED_PARAMS, poolhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExCreatePool(flags, tag, ::core::mem::transmute(params.unwrap_or(::std::ptr::null())), poolhandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExDeleteResourceLite(resource: *mut super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExDeleteResourceLite(resource : *mut super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExDeleteResourceLite(resource)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExDeleteTimer<P0, P1, P2>(timer: P0, cancel: P1, wait: P2, parameters: ::core::option::Option<*const EXT_DELETE_PARAMETERS>) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_TIMER>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P2: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExDeleteTimer(timer : super::super::Foundation:: PEX_TIMER, cancel : super::super::super::Win32::Foundation:: BOOLEAN, wait : super::super::super::Win32::Foundation:: BOOLEAN, parameters : *const EXT_DELETE_PARAMETERS) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExDeleteTimer(timer.into_param().abi(), cancel.into_param().abi(), wait.into_param().abi(), ::core::mem::transmute(parameters.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ExDestroyPool<P0>(poolhandle: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExDestroyPool(poolhandle : super::super::super::Win32::Foundation:: HANDLE));
    ExDestroyPool(poolhandle.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExEnterCriticalRegionAndAcquireResourceExclusive(resource: *mut super::super::Foundation::ERESOURCE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExEnterCriticalRegionAndAcquireResourceExclusive(resource : *mut super::super::Foundation:: ERESOURCE) -> *mut ::core::ffi::c_void);
    ExEnterCriticalRegionAndAcquireResourceExclusive(resource)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExEnterCriticalRegionAndAcquireResourceShared(resource: *mut super::super::Foundation::ERESOURCE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExEnterCriticalRegionAndAcquireResourceShared(resource : *mut super::super::Foundation:: ERESOURCE) -> *mut ::core::ffi::c_void);
    ExEnterCriticalRegionAndAcquireResourceShared(resource)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExEnterCriticalRegionAndAcquireSharedWaitForExclusive(resource: *mut super::super::Foundation::ERESOURCE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExEnterCriticalRegionAndAcquireSharedWaitForExclusive(resource : *mut super::super::Foundation:: ERESOURCE) -> *mut ::core::ffi::c_void);
    ExEnterCriticalRegionAndAcquireSharedWaitForExclusive(resource)
}
#[inline]
pub unsafe fn ExEnumerateSystemFirmwareTables(firmwaretableprovidersignature: u32, firmwaretablebuffer: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExEnumerateSystemFirmwareTables(firmwaretableprovidersignature : u32, firmwaretablebuffer : *mut ::core::ffi::c_void, bufferlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExEnumerateSystemFirmwareTables(firmwaretableprovidersignature, ::core::mem::transmute(firmwaretablebuffer.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExExtendZone(zone: *mut ZONE_HEADER, segment: *mut ::core::ffi::c_void, segmentsize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExExtendZone(zone : *mut ZONE_HEADER, segment : *mut ::core::ffi::c_void, segmentsize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExExtendZone(zone, segment, segmentsize)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExFreeCacheAwareRundownProtection<P0>(runrefcacheaware: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExFreeCacheAwareRundownProtection(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    ExFreeCacheAwareRundownProtection(runrefcacheaware.into_param().abi())
}
#[inline]
pub unsafe fn ExFreePool(p: *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExFreePool(p : *mut ::core::ffi::c_void));
    ExFreePool(p)
}
#[inline]
pub unsafe fn ExFreePool2(p: *mut ::core::ffi::c_void, tag: u32, extendedparameters: ::core::option::Option<&[POOL_EXTENDED_PARAMETER]>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExFreePool2(p : *mut ::core::ffi::c_void, tag : u32, extendedparameters : *const POOL_EXTENDED_PARAMETER, extendedparameterscount : u32));
    ExFreePool2(p, tag, ::core::mem::transmute(extendedparameters.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), extendedparameters.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()))
}
#[inline]
pub unsafe fn ExFreePoolWithTag(p: *mut ::core::ffi::c_void, tag: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExFreePoolWithTag(p : *mut ::core::ffi::c_void, tag : u32));
    ExFreePoolWithTag(p, tag)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExGetExclusiveWaiterCount(resource: *const super::super::Foundation::ERESOURCE) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExGetExclusiveWaiterCount(resource : *const super::super::Foundation:: ERESOURCE) -> u32);
    ExGetExclusiveWaiterCount(resource)
}
#[inline]
pub unsafe fn ExGetFirmwareEnvironmentVariable(variablename: *const super::super::super::Win32::Foundation::UNICODE_STRING, vendorguid: *const ::windows_core::GUID, value: ::core::option::Option<*mut ::core::ffi::c_void>, valuelength: *mut u32, attributes: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExGetFirmwareEnvironmentVariable(variablename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, vendorguid : *const ::windows_core::GUID, value : *mut ::core::ffi::c_void, valuelength : *mut u32, attributes : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExGetFirmwareEnvironmentVariable(variablename, vendorguid, ::core::mem::transmute(value.unwrap_or(::std::ptr::null_mut())), valuelength, ::core::mem::transmute(attributes.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn ExGetFirmwareType() -> super::super::super::Win32::System::SystemInformation::FIRMWARE_TYPE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExGetFirmwareType() -> super::super::super::Win32::System::SystemInformation:: FIRMWARE_TYPE);
    ExGetFirmwareType()
}
#[inline]
pub unsafe fn ExGetPreviousMode() -> i8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExGetPreviousMode() -> i8);
    ExGetPreviousMode()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExGetSharedWaiterCount(resource: *const super::super::Foundation::ERESOURCE) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExGetSharedWaiterCount(resource : *const super::super::Foundation:: ERESOURCE) -> u32);
    ExGetSharedWaiterCount(resource)
}
#[inline]
pub unsafe fn ExGetSystemFirmwareTable(firmwaretableprovidersignature: u32, firmwaretableid: u32, firmwaretablebuffer: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExGetSystemFirmwareTable(firmwaretableprovidersignature : u32, firmwaretableid : u32, firmwaretablebuffer : *mut ::core::ffi::c_void, bufferlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExGetSystemFirmwareTable(firmwaretableprovidersignature, firmwaretableid, ::core::mem::transmute(firmwaretablebuffer.unwrap_or(::std::ptr::null_mut())), bufferlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn ExInitializePushLock() -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInitializePushLock(pushlock : *mut usize));
    let mut result__ = ::std::mem::zeroed();
    ExInitializePushLock(&mut result__);
    result__
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExInitializeResourceLite(resource: *mut super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInitializeResourceLite(resource : *mut super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExInitializeResourceLite(resource)
}
#[inline]
pub unsafe fn ExInitializeRundownProtection() -> EX_RUNDOWN_REF {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInitializeRundownProtection(runref : *mut EX_RUNDOWN_REF));
    let mut result__ = ::std::mem::zeroed();
    ExInitializeRundownProtection(&mut result__);
    result__
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExInitializeRundownProtectionCacheAware<P0>(runrefcacheaware: P0, runrefsize: usize)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInitializeRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, runrefsize : usize));
    ExInitializeRundownProtectionCacheAware(runrefcacheaware.into_param().abi(), runrefsize)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExInitializeRundownProtectionCacheAwareEx<P0>(runrefcacheaware: P0, flags: u32)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInitializeRundownProtectionCacheAwareEx(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, flags : u32));
    ExInitializeRundownProtectionCacheAwareEx(runrefcacheaware.into_param().abi(), flags)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExInitializeZone(zone: *mut ZONE_HEADER, blocksize: u32, initialsegment: *mut ::core::ffi::c_void, initialsegmentsize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInitializeZone(zone : *mut ZONE_HEADER, blocksize : u32, initialsegment : *mut ::core::ffi::c_void, initialsegmentsize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExInitializeZone(zone, blocksize, initialsegment, initialsegmentsize)
}
#[inline]
pub unsafe fn ExInterlockedAddLargeInteger(addend: *mut i64, increment: i64, lock: *mut usize) -> i64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInterlockedAddLargeInteger(addend : *mut i64, increment : i64, lock : *mut usize) -> i64);
    ExInterlockedAddLargeInteger(addend, increment, lock)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExInterlockedExtendZone(zone: *mut ZONE_HEADER, segment: *mut ::core::ffi::c_void, segmentsize: u32, lock: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExInterlockedExtendZone(zone : *mut ZONE_HEADER, segment : *mut ::core::ffi::c_void, segmentsize : u32, lock : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExInterlockedExtendZone(zone, segment, segmentsize, lock)
}
#[inline]
pub unsafe fn ExIsManufacturingModeEnabled() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExIsManufacturingModeEnabled() -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExIsManufacturingModeEnabled()
}
#[inline]
pub unsafe fn ExIsProcessorFeaturePresent(processorfeature: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExIsProcessorFeaturePresent(processorfeature : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExIsProcessorFeaturePresent(processorfeature)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExIsResourceAcquiredExclusiveLite(resource: *const super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExIsResourceAcquiredExclusiveLite(resource : *const super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExIsResourceAcquiredExclusiveLite(resource)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExIsResourceAcquiredSharedLite(resource: *const super::super::Foundation::ERESOURCE) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExIsResourceAcquiredSharedLite(resource : *const super::super::Foundation:: ERESOURCE) -> u32);
    ExIsResourceAcquiredSharedLite(resource)
}
#[inline]
pub unsafe fn ExIsSoftBoot() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExIsSoftBoot() -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExIsSoftBoot()
}
#[inline]
pub unsafe fn ExLocalTimeToSystemTime(localtime: *const i64) -> i64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExLocalTimeToSystemTime(localtime : *const i64, systemtime : *mut i64));
    let mut result__ = ::std::mem::zeroed();
    ExLocalTimeToSystemTime(localtime, &mut result__);
    result__
}
#[inline]
pub unsafe fn ExNotifyCallback(callbackobject: *const ::core::ffi::c_void, argument1: ::core::option::Option<*const ::core::ffi::c_void>, argument2: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExNotifyCallback(callbackobject : *const ::core::ffi::c_void, argument1 : *const ::core::ffi::c_void, argument2 : *const ::core::ffi::c_void));
    ExNotifyCallback(callbackobject, ::core::mem::transmute(argument1.unwrap_or(::std::ptr::null())), ::core::mem::transmute(argument2.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ExQueryTimerResolution(maximumtime: *mut u32, minimumtime: *mut u32, currenttime: *mut u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExQueryTimerResolution(maximumtime : *mut u32, minimumtime : *mut u32, currenttime : *mut u32));
    ExQueryTimerResolution(maximumtime, minimumtime, currenttime)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExQueueWorkItem(workitem: *mut super::super::Foundation::WORK_QUEUE_ITEM, queuetype: WORK_QUEUE_TYPE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExQueueWorkItem(workitem : *mut super::super::Foundation:: WORK_QUEUE_ITEM, queuetype : WORK_QUEUE_TYPE));
    ExQueueWorkItem(workitem, queuetype)
}
#[inline]
pub unsafe fn ExRaiseAccessViolation() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExRaiseAccessViolation());
    ExRaiseAccessViolation()
}
#[inline]
pub unsafe fn ExRaiseDatatypeMisalignment() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExRaiseDatatypeMisalignment());
    ExRaiseDatatypeMisalignment()
}
#[inline]
pub unsafe fn ExRaiseStatus<P0>(status: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExRaiseStatus(status : super::super::super::Win32::Foundation:: NTSTATUS));
    ExRaiseStatus(status.into_param().abi())
}
#[inline]
pub unsafe fn ExReInitializeRundownProtection(runref: *mut EX_RUNDOWN_REF) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReInitializeRundownProtection(runref : *mut EX_RUNDOWN_REF));
    ExReInitializeRundownProtection(runref)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExReInitializeRundownProtectionCacheAware<P0>(runrefcacheaware: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReInitializeRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    ExReInitializeRundownProtectionCacheAware(runrefcacheaware.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExRegisterCallback<P0>(callbackobject: P0, callbackfunction: PCALLBACK_FUNCTION, callbackcontext: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PCALLBACK_OBJECT>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExRegisterCallback(callbackobject : super::super::Foundation:: PCALLBACK_OBJECT, callbackfunction : PCALLBACK_FUNCTION, callbackcontext : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    ExRegisterCallback(callbackobject.into_param().abi(), callbackfunction, ::core::mem::transmute(callbackcontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReinitializeResourceLite(resource: *mut super::super::Foundation::ERESOURCE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReinitializeResourceLite(resource : *mut super::super::Foundation:: ERESOURCE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExReinitializeResourceLite(resource)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseFastMutex(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseFastMutex(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    ExReleaseFastMutex(fastmutex)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseFastMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseFastMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    ExReleaseFastMutexUnsafe(fastmutex)
}
#[inline]
pub unsafe fn ExReleasePushLockExclusiveEx(pushlock: *mut usize, flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleasePushLockExclusiveEx(pushlock : *mut usize, flags : u32));
    ExReleasePushLockExclusiveEx(pushlock, flags)
}
#[inline]
pub unsafe fn ExReleasePushLockSharedEx(pushlock: *mut usize, flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleasePushLockSharedEx(pushlock : *mut usize, flags : u32));
    ExReleasePushLockSharedEx(pushlock, flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseResourceAndLeaveCriticalRegion(resource: *mut super::super::Foundation::ERESOURCE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseResourceAndLeaveCriticalRegion(resource : *mut super::super::Foundation:: ERESOURCE));
    ExReleaseResourceAndLeaveCriticalRegion(resource)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseResourceForThreadLite(resource: *mut super::super::Foundation::ERESOURCE, resourcethreadid: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseResourceForThreadLite(resource : *mut super::super::Foundation:: ERESOURCE, resourcethreadid : usize));
    ExReleaseResourceForThreadLite(resource, resourcethreadid)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExReleaseResourceLite(resource: *mut super::super::Foundation::ERESOURCE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseResourceLite(resource : *mut super::super::Foundation:: ERESOURCE));
    ExReleaseResourceLite(resource)
}
#[inline]
pub unsafe fn ExReleaseRundownProtection(runref: *mut EX_RUNDOWN_REF) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtection(runref : *mut EX_RUNDOWN_REF));
    ExReleaseRundownProtection(runref)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExReleaseRundownProtectionCacheAware<P0>(runrefcacheaware: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtectionCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    ExReleaseRundownProtectionCacheAware(runrefcacheaware.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExReleaseRundownProtectionCacheAwareEx<P0>(runref: P0, count: u32)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtectionCacheAwareEx(runref : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE, count : u32));
    ExReleaseRundownProtectionCacheAwareEx(runref.into_param().abi(), count)
}
#[inline]
pub unsafe fn ExReleaseRundownProtectionEx(runref: *mut EX_RUNDOWN_REF, count: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseRundownProtectionEx(runref : *mut EX_RUNDOWN_REF, count : u32));
    ExReleaseRundownProtectionEx(runref, count)
}
#[inline]
pub unsafe fn ExReleaseSpinLockExclusive(spinlock: *mut i32, oldirql: u8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockExclusive(spinlock : *mut i32, oldirql : u8));
    ExReleaseSpinLockExclusive(spinlock, oldirql)
}
#[inline]
pub unsafe fn ExReleaseSpinLockExclusiveFromDpcLevel(spinlock: *mut i32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockExclusiveFromDpcLevel(spinlock : *mut i32));
    ExReleaseSpinLockExclusiveFromDpcLevel(spinlock)
}
#[inline]
pub unsafe fn ExReleaseSpinLockShared(spinlock: *mut i32, oldirql: u8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockShared(spinlock : *mut i32, oldirql : u8));
    ExReleaseSpinLockShared(spinlock, oldirql)
}
#[inline]
pub unsafe fn ExReleaseSpinLockSharedFromDpcLevel(spinlock: *mut i32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExReleaseSpinLockSharedFromDpcLevel(spinlock : *mut i32));
    ExReleaseSpinLockSharedFromDpcLevel(spinlock)
}
#[inline]
pub unsafe fn ExRundownCompleted() -> EX_RUNDOWN_REF {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExRundownCompleted(runref : *mut EX_RUNDOWN_REF));
    let mut result__ = ::std::mem::zeroed();
    ExRundownCompleted(&mut result__);
    result__
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExRundownCompletedCacheAware<P0>(runrefcacheaware: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExRundownCompletedCacheAware(runrefcacheaware : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    ExRundownCompletedCacheAware(runrefcacheaware.into_param().abi())
}
#[inline]
pub unsafe fn ExSecurePoolUpdate<P0>(securepoolhandle: P0, tag: u32, allocation: *const ::core::ffi::c_void, cookie: usize, offset: usize, size: usize, buffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSecurePoolUpdate(securepoolhandle : super::super::super::Win32::Foundation:: HANDLE, tag : u32, allocation : *const ::core::ffi::c_void, cookie : usize, offset : usize, size : usize, buffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExSecurePoolUpdate(securepoolhandle.into_param().abi(), tag, allocation, cookie, offset, size, buffer)
}
#[inline]
pub unsafe fn ExSecurePoolValidate<P0>(securepoolhandle: P0, tag: u32, allocation: *const ::core::ffi::c_void, cookie: usize) -> u32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSecurePoolValidate(securepoolhandle : super::super::super::Win32::Foundation:: HANDLE, tag : u32, allocation : *const ::core::ffi::c_void, cookie : usize) -> u32);
    ExSecurePoolValidate(securepoolhandle.into_param().abi(), tag, allocation, cookie)
}
#[inline]
pub unsafe fn ExSetFirmwareEnvironmentVariable(variablename: *const super::super::super::Win32::Foundation::UNICODE_STRING, vendorguid: *const ::windows_core::GUID, value: ::core::option::Option<*const ::core::ffi::c_void>, valuelength: u32, attributes: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSetFirmwareEnvironmentVariable(variablename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, vendorguid : *const ::windows_core::GUID, value : *const ::core::ffi::c_void, valuelength : u32, attributes : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExSetFirmwareEnvironmentVariable(variablename, vendorguid, ::core::mem::transmute(value.unwrap_or(::std::ptr::null())), valuelength, attributes)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExSetResourceOwnerPointer(resource: *mut super::super::Foundation::ERESOURCE, ownerpointer: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSetResourceOwnerPointer(resource : *mut super::super::Foundation:: ERESOURCE, ownerpointer : *const ::core::ffi::c_void));
    ExSetResourceOwnerPointer(resource, ownerpointer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExSetResourceOwnerPointerEx(resource: *mut super::super::Foundation::ERESOURCE, ownerpointer: *const ::core::ffi::c_void, flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSetResourceOwnerPointerEx(resource : *mut super::super::Foundation:: ERESOURCE, ownerpointer : *const ::core::ffi::c_void, flags : u32));
    ExSetResourceOwnerPointerEx(resource, ownerpointer, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExSetTimer<P0>(timer: P0, duetime: i64, period: i64, parameters: ::core::option::Option<*const _EXT_SET_PARAMETERS_V0>) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_TIMER>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSetTimer(timer : super::super::Foundation:: PEX_TIMER, duetime : i64, period : i64, parameters : *const _EXT_SET_PARAMETERS_V0) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExSetTimer(timer.into_param().abi(), duetime, period, ::core::mem::transmute(parameters.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ExSetTimerResolution<P0>(desiredtime: u32, setresolution: P0) -> u32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSetTimerResolution(desiredtime : u32, setresolution : super::super::super::Win32::Foundation:: BOOLEAN) -> u32);
    ExSetTimerResolution(desiredtime, setresolution.into_param().abi())
}
#[inline]
pub unsafe fn ExSizeOfRundownProtectionCacheAware() -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSizeOfRundownProtectionCacheAware() -> usize);
    ExSizeOfRundownProtectionCacheAware()
}
#[inline]
pub unsafe fn ExSystemTimeToLocalTime(systemtime: *const i64) -> i64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExSystemTimeToLocalTime(systemtime : *const i64, localtime : *mut i64));
    let mut result__ = ::std::mem::zeroed();
    ExSystemTimeToLocalTime(systemtime, &mut result__);
    result__
}
#[inline]
pub unsafe fn ExTryAcquireSpinLockExclusiveAtDpcLevel(spinlock: *mut i32) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExTryAcquireSpinLockExclusiveAtDpcLevel(spinlock : *mut i32) -> u32);
    ExTryAcquireSpinLockExclusiveAtDpcLevel(spinlock)
}
#[inline]
pub unsafe fn ExTryAcquireSpinLockSharedAtDpcLevel(spinlock: *mut i32) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExTryAcquireSpinLockSharedAtDpcLevel(spinlock : *mut i32) -> u32);
    ExTryAcquireSpinLockSharedAtDpcLevel(spinlock)
}
#[inline]
pub unsafe fn ExTryConvertSharedSpinLockExclusive(spinlock: *mut i32) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExTryConvertSharedSpinLockExclusive(spinlock : *mut i32) -> u32);
    ExTryConvertSharedSpinLockExclusive(spinlock)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ExTryToAcquireFastMutex(fastmutex: *mut super::super::Foundation::FAST_MUTEX) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExTryToAcquireFastMutex(fastmutex : *mut super::super::Foundation:: FAST_MUTEX) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExTryToAcquireFastMutex(fastmutex)
}
#[inline]
pub unsafe fn ExUnregisterCallback(callbackregistration: *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExUnregisterCallback(callbackregistration : *mut ::core::ffi::c_void));
    ExUnregisterCallback(callbackregistration)
}
#[inline]
pub unsafe fn ExUuidCreate(uuid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExUuidCreate(uuid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ExUuidCreate(uuid)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn ExVerifySuite(suitetype: super::super::super::Win32::System::Kernel::SUITE_TYPE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExVerifySuite(suitetype : super::super::super::Win32::System::Kernel:: SUITE_TYPE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ExVerifySuite(suitetype)
}
#[inline]
pub unsafe fn ExWaitForRundownProtectionRelease(runref: *mut EX_RUNDOWN_REF) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExWaitForRundownProtectionRelease(runref : *mut EX_RUNDOWN_REF));
    ExWaitForRundownProtectionRelease(runref)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ExWaitForRundownProtectionReleaseCacheAware<P0>(runref: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEX_RUNDOWN_REF_CACHE_AWARE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ExWaitForRundownProtectionReleaseCacheAware(runref : super::super::Foundation:: PEX_RUNDOWN_REF_CACHE_AWARE));
    ExWaitForRundownProtectionReleaseCacheAware(runref.into_param().abi())
}
#[inline]
pub unsafe fn FsRtlIsTotalDeviceFailure<P0>(status: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn FsRtlIsTotalDeviceFailure(status : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: BOOLEAN);
    FsRtlIsTotalDeviceFailure(status.into_param().abi())
}
#[inline]
pub unsafe fn HalAcquireDisplayOwnership(resetdisplayparameters: PHAL_RESET_DISPLAY_PARAMETERS) {
    ::windows_targets::link!("hal.dll" "system" fn HalAcquireDisplayOwnership(resetdisplayparameters : PHAL_RESET_DISPLAY_PARAMETERS));
    HalAcquireDisplayOwnership(resetdisplayparameters)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_IscsiDisc", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn HalAllocateAdapterChannel(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, wcb: *const WAIT_CONTEXT_BLOCK, numberofmapregisters: u32, executionroutine: *const super::super::Foundation::DRIVER_CONTROL) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("hal.dll" "system" fn HalAllocateAdapterChannel(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, wcb : *const WAIT_CONTEXT_BLOCK, numberofmapregisters : u32, executionroutine : *const super::super::Foundation:: DRIVER_CONTROL) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HalAllocateAdapterChannel(adapterobject, wcb, numberofmapregisters, executionroutine)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalAllocateCommonBuffer<P0>(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, length: u32, logicaladdress: *mut i64, cacheenabled: P0) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("hal.dll" "system" fn HalAllocateCommonBuffer(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, length : u32, logicaladdress : *mut i64, cacheenabled : super::super::super::Win32::Foundation:: BOOLEAN) -> *mut ::core::ffi::c_void);
    HalAllocateCommonBuffer(adapterobject, length, logicaladdress, cacheenabled.into_param().abi())
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalAllocateCrashDumpRegisters(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, numberofmapregisters: *mut u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("hal.dll" "system" fn HalAllocateCrashDumpRegisters(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, numberofmapregisters : *mut u32) -> *mut ::core::ffi::c_void);
    HalAllocateCrashDumpRegisters(adapterobject, numberofmapregisters)
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn HalAllocateHardwareCounters(groupaffinty: ::core::option::Option<&[super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY]>, resourcelist: ::core::option::Option<*const PHYSICAL_COUNTER_RESOURCE_LIST>, countersethandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("hal.dll" "system" fn HalAllocateHardwareCounters(groupaffinty : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, groupcount : u32, resourcelist : *const PHYSICAL_COUNTER_RESOURCE_LIST, countersethandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HalAllocateHardwareCounters(::core::mem::transmute(groupaffinty.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), groupaffinty.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), ::core::mem::transmute(resourcelist.unwrap_or(::std::ptr::null())), countersethandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn HalAssignSlotResources(registrypath: *const super::super::super::Win32::Foundation::UNICODE_STRING, driverclassname: *const super::super::super::Win32::Foundation::UNICODE_STRING, driverobject: *const super::super::Foundation::DRIVER_OBJECT, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, bustype: INTERFACE_TYPE, busnumber: u32, slotnumber: u32, allocatedresources: *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("hal.dll" "system" fn HalAssignSlotResources(registrypath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverclassname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, bustype : INTERFACE_TYPE, busnumber : u32, slotnumber : u32, allocatedresources : *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HalAssignSlotResources(registrypath, driverclassname, driverobject, deviceobject, bustype, busnumber, slotnumber, allocatedresources)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn HalBugCheckSystem(errorsource: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_DESCRIPTOR, errorrecord: *const WHEA_ERROR_RECORD) {
    ::windows_targets::link!("hal.dll" "system" fn HalBugCheckSystem(errorsource : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_DESCRIPTOR, errorrecord : *const WHEA_ERROR_RECORD));
    HalBugCheckSystem(errorsource, errorrecord)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalDmaAllocateCrashDumpRegistersEx(adapter: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, numberofmapregisters: u32, r#type: HAL_DMA_CRASH_DUMP_REGISTER_TYPE, mapregisterbase: *mut *mut ::core::ffi::c_void, mapregistersavailable: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("hal.dll" "system" fn HalDmaAllocateCrashDumpRegistersEx(adapter : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, numberofmapregisters : u32, r#type : HAL_DMA_CRASH_DUMP_REGISTER_TYPE, mapregisterbase : *mut *mut ::core::ffi::c_void, mapregistersavailable : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HalDmaAllocateCrashDumpRegistersEx(adapter, numberofmapregisters, r#type, mapregisterbase, mapregistersavailable)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalDmaFreeCrashDumpRegistersEx(adapter: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, r#type: HAL_DMA_CRASH_DUMP_REGISTER_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("hal.dll" "system" fn HalDmaFreeCrashDumpRegistersEx(adapter : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, r#type : HAL_DMA_CRASH_DUMP_REGISTER_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HalDmaFreeCrashDumpRegistersEx(adapter, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn HalExamineMBR(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, mbrtypeidentifier: u32, buffer: *mut *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn HalExamineMBR(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, mbrtypeidentifier : u32, buffer : *mut *mut ::core::ffi::c_void));
    HalExamineMBR(deviceobject, sectorsize, mbrtypeidentifier, buffer)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalFreeCommonBuffer<P0>(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, length: u32, logicaladdress: i64, virtualaddress: *const ::core::ffi::c_void, cacheenabled: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("hal.dll" "system" fn HalFreeCommonBuffer(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, length : u32, logicaladdress : i64, virtualaddress : *const ::core::ffi::c_void, cacheenabled : super::super::super::Win32::Foundation:: BOOLEAN));
    HalFreeCommonBuffer(adapterobject, length, logicaladdress, virtualaddress, cacheenabled.into_param().abi())
}
#[inline]
pub unsafe fn HalFreeHardwareCounters<P0>(countersethandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("hal.dll" "system" fn HalFreeHardwareCounters(countersethandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HalFreeHardwareCounters(countersethandle.into_param().abi())
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalGetAdapter(devicedescription: *const DEVICE_DESCRIPTION, numberofmapregisters: *mut u32) -> *mut super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT {
    ::windows_targets::link!("hal.dll" "system" fn HalGetAdapter(devicedescription : *const DEVICE_DESCRIPTION, numberofmapregisters : *mut u32) -> *mut super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT);
    HalGetAdapter(devicedescription, numberofmapregisters)
}
#[inline]
pub unsafe fn HalGetBusData(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *mut ::core::ffi::c_void, length: u32) -> u32 {
    ::windows_targets::link!("hal.dll" "system" fn HalGetBusData(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *mut ::core::ffi::c_void, length : u32) -> u32);
    HalGetBusData(busdatatype, busnumber, slotnumber, buffer, length)
}
#[inline]
pub unsafe fn HalGetBusDataByOffset(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *mut ::core::ffi::c_void, offset: u32, length: u32) -> u32 {
    ::windows_targets::link!("hal.dll" "system" fn HalGetBusDataByOffset(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *mut ::core::ffi::c_void, offset : u32, length : u32) -> u32);
    HalGetBusDataByOffset(busdatatype, busnumber, slotnumber, buffer, offset, length)
}
#[inline]
pub unsafe fn HalGetInterruptVector(interfacetype: INTERFACE_TYPE, busnumber: u32, businterruptlevel: u32, businterruptvector: u32, irql: *mut u8, affinity: *mut usize) -> u32 {
    ::windows_targets::link!("hal.dll" "system" fn HalGetInterruptVector(interfacetype : INTERFACE_TYPE, busnumber : u32, businterruptlevel : u32, businterruptvector : u32, irql : *mut u8, affinity : *mut usize) -> u32);
    HalGetInterruptVector(interfacetype, busnumber, businterruptlevel, businterruptvector, irql, affinity)
}
#[inline]
pub unsafe fn HalMakeBeep(frequency: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("hal.dll" "system" fn HalMakeBeep(frequency : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    HalMakeBeep(frequency)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn HalReadDmaCounter(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT) -> u32 {
    ::windows_targets::link!("hal.dll" "system" fn HalReadDmaCounter(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT) -> u32);
    HalReadDmaCounter(adapterobject)
}
#[inline]
pub unsafe fn HalSetBusData(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *const ::core::ffi::c_void, length: u32) -> u32 {
    ::windows_targets::link!("hal.dll" "system" fn HalSetBusData(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *const ::core::ffi::c_void, length : u32) -> u32);
    HalSetBusData(busdatatype, busnumber, slotnumber, buffer, length)
}
#[inline]
pub unsafe fn HalSetBusDataByOffset(busdatatype: BUS_DATA_TYPE, busnumber: u32, slotnumber: u32, buffer: *const ::core::ffi::c_void, offset: u32, length: u32) -> u32 {
    ::windows_targets::link!("hal.dll" "system" fn HalSetBusDataByOffset(busdatatype : BUS_DATA_TYPE, busnumber : u32, slotnumber : u32, buffer : *const ::core::ffi::c_void, offset : u32, length : u32) -> u32);
    HalSetBusDataByOffset(busdatatype, busnumber, slotnumber, buffer, offset, length)
}
#[inline]
pub unsafe fn HalTranslateBusAddress(interfacetype: INTERFACE_TYPE, busnumber: u32, busaddress: i64, addressspace: *mut u32, translatedaddress: *mut i64) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("hal.dll" "system" fn HalTranslateBusAddress(interfacetype : INTERFACE_TYPE, busnumber : u32, busaddress : i64, addressspace : *mut u32, translatedaddress : *mut i64) -> super::super::super::Win32::Foundation:: BOOLEAN);
    HalTranslateBusAddress(interfacetype, busnumber, busaddress, addressspace, translatedaddress)
}
#[inline]
pub unsafe fn HvlRegisterWheaErrorNotification(callback: PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn HvlRegisterWheaErrorNotification(callback : PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HvlRegisterWheaErrorNotification(callback)
}
#[inline]
pub unsafe fn HvlUnregisterWheaErrorNotification(callback: PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn HvlUnregisterWheaErrorNotification(callback : PHVL_WHEA_ERROR_NOTIFICATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    HvlUnregisterWheaErrorNotification(callback)
}
#[inline]
pub unsafe fn IoAcquireCancelSpinLock() -> u8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAcquireCancelSpinLock(irql : *mut u8));
    let mut result__ = ::std::mem::zeroed();
    IoAcquireCancelSpinLock(&mut result__);
    result__
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAcquireKsrPersistentMemory(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, buffer: *mut ::core::ffi::c_void, size: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAcquireKsrPersistentMemory(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffer : *mut ::core::ffi::c_void, size : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAcquireKsrPersistentMemory(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), buffer, size)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAcquireKsrPersistentMemoryEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, datatag: ::core::option::Option<*const u16>, dataversion: ::core::option::Option<*mut u32>, buffer: *mut ::core::ffi::c_void, size: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAcquireKsrPersistentMemoryEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, datatag : *const u16, dataversion : *mut u32, buffer : *mut ::core::ffi::c_void, size : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAcquireKsrPersistentMemoryEx(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(physicaldeviceid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(datatag.unwrap_or(::std::ptr::null())), ::core::mem::transmute(dataversion.unwrap_or(::std::ptr::null_mut())), buffer, size)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoAcquireRemoveLockEx<P0>(removelock: *mut IO_REMOVE_LOCK, tag: ::core::option::Option<*const ::core::ffi::c_void>, file: P0, line: u32, remlocksize: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAcquireRemoveLockEx(removelock : *mut IO_REMOVE_LOCK, tag : *const ::core::ffi::c_void, file : ::windows_core::PCSTR, line : u32, remlocksize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAcquireRemoveLockEx(removelock, ::core::mem::transmute(tag.unwrap_or(::std::ptr::null())), file.into_param().abi(), line, remlocksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_Storage_IscsiDisc", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateAdapterChannel(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, numberofmapregisters: u32, executionroutine: *const super::super::Foundation::DRIVER_CONTROL, context: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateAdapterChannel(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, numberofmapregisters : u32, executionroutine : *const super::super::Foundation:: DRIVER_CONTROL, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAllocateAdapterChannel(adapterobject, deviceobject, numberofmapregisters, executionroutine, context)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateController(controllerobject: *const CONTROLLER_OBJECT, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, executionroutine: *const super::super::Foundation::DRIVER_CONTROL, context: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateController(controllerobject : *const CONTROLLER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, executionroutine : *const super::super::Foundation:: DRIVER_CONTROL, context : *const ::core::ffi::c_void));
    IoAllocateController(controllerobject, deviceobject, executionroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateDriverObjectExtension(driverobject: *const super::super::Foundation::DRIVER_OBJECT, clientidentificationaddress: *const ::core::ffi::c_void, driverobjectextensionsize: u32, driverobjectextension: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateDriverObjectExtension(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, clientidentificationaddress : *const ::core::ffi::c_void, driverobjectextensionsize : u32, driverobjectextension : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAllocateDriverObjectExtension(driverobject, clientidentificationaddress, driverobjectextensionsize, driverobjectextension)
}
#[inline]
pub unsafe fn IoAllocateErrorLogEntry(ioobject: *const ::core::ffi::c_void, entrysize: u8) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateErrorLogEntry(ioobject : *const ::core::ffi::c_void, entrysize : u8) -> *mut ::core::ffi::c_void);
    IoAllocateErrorLogEntry(ioobject, entrysize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateIrp<P0>(stacksize: i8, chargequota: P0) -> *mut super::super::Foundation::IRP
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateIrp(stacksize : i8, chargequota : super::super::super::Win32::Foundation:: BOOLEAN) -> *mut super::super::Foundation:: IRP);
    IoAllocateIrp(stacksize, chargequota.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateIrpEx<P0>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, stacksize: i8, chargequota: P0) -> *mut super::super::Foundation::IRP
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateIrpEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, stacksize : i8, chargequota : super::super::super::Win32::Foundation:: BOOLEAN) -> *mut super::super::Foundation:: IRP);
    IoAllocateIrpEx(deviceobject, stacksize, chargequota.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateMdl<P0, P1>(virtualaddress: ::core::option::Option<*const ::core::ffi::c_void>, length: u32, secondarybuffer: P0, chargequota: P1, irp: ::core::option::Option<*mut super::super::Foundation::IRP>) -> *mut super::super::Foundation::MDL
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateMdl(virtualaddress : *const ::core::ffi::c_void, length : u32, secondarybuffer : super::super::super::Win32::Foundation:: BOOLEAN, chargequota : super::super::super::Win32::Foundation:: BOOLEAN, irp : *mut super::super::Foundation:: IRP) -> *mut super::super::Foundation:: MDL);
    IoAllocateMdl(::core::mem::transmute(virtualaddress.unwrap_or(::std::ptr::null())), length, secondarybuffer.into_param().abi(), chargequota.into_param().abi(), ::core::mem::transmute(irp.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateSfioStreamIdentifier(fileobject: *const super::super::Foundation::FILE_OBJECT, length: u32, signature: *const ::core::ffi::c_void, streamidentifier: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateSfioStreamIdentifier(fileobject : *const super::super::Foundation:: FILE_OBJECT, length : u32, signature : *const ::core::ffi::c_void, streamidentifier : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAllocateSfioStreamIdentifier(fileobject, length, signature, streamidentifier)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAllocateWorkItem(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::Foundation::PIO_WORKITEM {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAllocateWorkItem(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::Foundation:: PIO_WORKITEM);
    IoAllocateWorkItem(deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAssignResources(registrypath: *const super::super::super::Win32::Foundation::UNICODE_STRING, driverclassname: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, driverobject: *const super::super::Foundation::DRIVER_OBJECT, deviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, requestedresources: ::core::option::Option<*const IO_RESOURCE_REQUIREMENTS_LIST>, allocatedresources: *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAssignResources(registrypath : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverclassname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, requestedresources : *const IO_RESOURCE_REQUIREMENTS_LIST, allocatedresources : *mut *mut CM_RESOURCE_LIST) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAssignResources(registrypath, ::core::mem::transmute(driverclassname.unwrap_or(::std::ptr::null())), driverobject, ::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(requestedresources.unwrap_or(::std::ptr::null())), allocatedresources)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDevice(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::super::Win32::Foundation::UNICODE_STRING, attacheddevice: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAttachDevice(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::super::Win32::Foundation:: UNICODE_STRING, attacheddevice : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAttachDevice(sourcedevice, targetdevice, attacheddevice)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDeviceByPointer(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAttachDeviceByPointer(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAttachDeviceByPointer(sourcedevice, targetdevice)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDeviceToDeviceStack(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::Foundation::DEVICE_OBJECT) -> *mut super::super::Foundation::DEVICE_OBJECT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAttachDeviceToDeviceStack(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::Foundation:: DEVICE_OBJECT) -> *mut super::super::Foundation:: DEVICE_OBJECT);
    IoAttachDeviceToDeviceStack(sourcedevice, targetdevice)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoAttachDeviceToDeviceStackSafe(sourcedevice: *const super::super::Foundation::DEVICE_OBJECT, targetdevice: *const super::super::Foundation::DEVICE_OBJECT, attachedtodeviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoAttachDeviceToDeviceStackSafe(sourcedevice : *const super::super::Foundation:: DEVICE_OBJECT, targetdevice : *const super::super::Foundation:: DEVICE_OBJECT, attachedtodeviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoAttachDeviceToDeviceStackSafe(sourcedevice, targetdevice, attachedtodeviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoBuildAsynchronousFsdRequest(majorfunction: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, length: u32, startingoffset: ::core::option::Option<*const i64>, iostatusblock: ::core::option::Option<*const super::super::super::Win32::System::IO::IO_STATUS_BLOCK>) -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoBuildAsynchronousFsdRequest(majorfunction : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffer : *mut ::core::ffi::c_void, length : u32, startingoffset : *const i64, iostatusblock : *const super::super::super::Win32::System::IO:: IO_STATUS_BLOCK) -> *mut super::super::Foundation:: IRP);
    IoBuildAsynchronousFsdRequest(majorfunction, deviceobject, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), length, ::core::mem::transmute(startingoffset.unwrap_or(::std::ptr::null())), ::core::mem::transmute(iostatusblock.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoBuildDeviceIoControlRequest<P0>(iocontrolcode: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, inputbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inputbufferlength: u32, outputbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outputbufferlength: u32, internaldeviceiocontrol: P0, event: ::core::option::Option<*const super::super::Foundation::KEVENT>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK) -> *mut super::super::Foundation::IRP
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoBuildDeviceIoControlRequest(iocontrolcode : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, inputbuffer : *const ::core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut ::core::ffi::c_void, outputbufferlength : u32, internaldeviceiocontrol : super::super::super::Win32::Foundation:: BOOLEAN, event : *const super::super::Foundation:: KEVENT, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK) -> *mut super::super::Foundation:: IRP);
    IoBuildDeviceIoControlRequest(iocontrolcode, deviceobject, ::core::mem::transmute(inputbuffer.unwrap_or(::std::ptr::null())), inputbufferlength, ::core::mem::transmute(outputbuffer.unwrap_or(::std::ptr::null_mut())), outputbufferlength, internaldeviceiocontrol.into_param().abi(), ::core::mem::transmute(event.unwrap_or(::std::ptr::null())), iostatusblock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoBuildPartialMdl(sourcemdl: *const super::super::Foundation::MDL, targetmdl: *mut super::super::Foundation::MDL, virtualaddress: *mut ::core::ffi::c_void, length: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoBuildPartialMdl(sourcemdl : *const super::super::Foundation:: MDL, targetmdl : *mut super::super::Foundation:: MDL, virtualaddress : *mut ::core::ffi::c_void, length : u32));
    IoBuildPartialMdl(sourcemdl, targetmdl, virtualaddress, length)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoBuildSynchronousFsdRequest(majorfunction: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, buffer: *mut ::core::ffi::c_void, length: u32, startingoffset: ::core::option::Option<*const i64>, event: *const super::super::Foundation::KEVENT, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK) -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoBuildSynchronousFsdRequest(majorfunction : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffer : *mut ::core::ffi::c_void, length : u32, startingoffset : *const i64, event : *const super::super::Foundation:: KEVENT, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK) -> *mut super::super::Foundation:: IRP);
    IoBuildSynchronousFsdRequest(majorfunction, deviceobject, buffer, length, ::core::mem::transmute(startingoffset.unwrap_or(::std::ptr::null())), event, iostatusblock)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCancelFileOpen(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, fileobject: *const super::super::Foundation::FILE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCancelFileOpen(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, fileobject : *const super::super::Foundation:: FILE_OBJECT));
    IoCancelFileOpen(deviceobject, fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCancelIrp(irp: *const super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCancelIrp(irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoCancelIrp(irp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCheckLinkShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: ::core::option::Option<*mut super::super::Foundation::FILE_OBJECT>, shareaccess: ::core::option::Option<*mut SHARE_ACCESS>, linkshareaccess: ::core::option::Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCheckLinkShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCheckLinkShareAccess(desiredaccess, desiredshareaccess, ::core::mem::transmute(fileobject.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(shareaccess.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(linkshareaccess.unwrap_or(::std::ptr::null_mut())), ioshareaccessflags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCheckShareAccess<P0>(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, update: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCheckShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, update : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCheckShareAccess(desiredaccess, desiredshareaccess, fileobject, shareaccess, update.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCheckShareAccessEx<P0>(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, update: P0, writepermission: ::core::option::Option<*const super::super::super::Win32::Foundation::BOOLEAN>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCheckShareAccessEx(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, update : super::super::super::Win32::Foundation:: BOOLEAN, writepermission : *const super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCheckShareAccessEx(desiredaccess, desiredshareaccess, fileobject, shareaccess, update.into_param().abi(), ::core::mem::transmute(writepermission.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCleanupIrp(irp: *mut super::super::Foundation::IRP) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCleanupIrp(irp : *mut super::super::Foundation:: IRP));
    IoCleanupIrp(irp)
}
#[inline]
pub unsafe fn IoClearActivityIdThread(originalid: *const ::windows_core::GUID) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoClearActivityIdThread(originalid : *const ::windows_core::GUID));
    IoClearActivityIdThread(originalid)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoClearIrpExtraCreateParameter(irp: *mut super::super::Foundation::IRP) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoClearIrpExtraCreateParameter(irp : *mut super::super::Foundation:: IRP));
    IoClearIrpExtraCreateParameter(irp)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoConnectInterrupt<P0, P1>(interruptobject: *mut super::super::Foundation::PKINTERRUPT, serviceroutine: PKSERVICE_ROUTINE, servicecontext: ::core::option::Option<*const ::core::ffi::c_void>, spinlock: ::core::option::Option<*const usize>, vector: u32, irql: u8, synchronizeirql: u8, interruptmode: KINTERRUPT_MODE, sharevector: P0, processorenablemask: usize, floatingsave: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoConnectInterrupt(interruptobject : *mut super::super::Foundation:: PKINTERRUPT, serviceroutine : PKSERVICE_ROUTINE, servicecontext : *const ::core::ffi::c_void, spinlock : *const usize, vector : u32, irql : u8, synchronizeirql : u8, interruptmode : KINTERRUPT_MODE, sharevector : super::super::super::Win32::Foundation:: BOOLEAN, processorenablemask : usize, floatingsave : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoConnectInterrupt(interruptobject, serviceroutine, ::core::mem::transmute(servicecontext.unwrap_or(::std::ptr::null())), ::core::mem::transmute(spinlock.unwrap_or(::std::ptr::null())), vector, irql, synchronizeirql, interruptmode, sharevector.into_param().abi(), processorenablemask, floatingsave.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoConnectInterruptEx(parameters: *mut IO_CONNECT_INTERRUPT_PARAMETERS) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoConnectInterruptEx(parameters : *mut IO_CONNECT_INTERRUPT_PARAMETERS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoConnectInterruptEx(parameters)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoCreateController(size: u32) -> *mut CONTROLLER_OBJECT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateController(size : u32) -> *mut CONTROLLER_OBJECT);
    IoCreateController(size)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCreateDevice<P0>(driverobject: *const super::super::Foundation::DRIVER_OBJECT, deviceextensionsize: u32, devicename: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, devicetype: u32, devicecharacteristics: u32, exclusive: P0, deviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateDevice(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, deviceextensionsize : u32, devicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, devicetype : u32, devicecharacteristics : u32, exclusive : super::super::super::Win32::Foundation:: BOOLEAN, deviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateDevice(driverobject, deviceextensionsize, ::core::mem::transmute(devicename.unwrap_or(::std::ptr::null())), devicetype, devicecharacteristics, exclusive.into_param().abi(), deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCreateDisk(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, disk: ::core::option::Option<*const super::super::super::Win32::System::Ioctl::CREATE_DISK>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateDisk(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, disk : *const super::super::super::Win32::System::Ioctl:: CREATE_DISK) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateDisk(deviceobject, ::core::mem::transmute(disk.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoCreateFile(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: ::core::option::Option<*const i64>, fileattributes: u32, shareaccess: u32, disposition: u32, createoptions: u32, eabuffer: ::core::option::Option<*const ::core::ffi::c_void>, ealength: u32, createfiletype: CREATE_FILE_TYPE, internalparameters: ::core::option::Option<*const ::core::ffi::c_void>, options: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateFile(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, disposition : u32, createoptions : u32, eabuffer : *const ::core::ffi::c_void, ealength : u32, createfiletype : CREATE_FILE_TYPE, internalparameters : *const ::core::ffi::c_void, options : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateFile(filehandle, desiredaccess, objectattributes, iostatusblock, ::core::mem::transmute(allocationsize.unwrap_or(::std::ptr::null())), fileattributes, shareaccess, disposition, createoptions, ::core::mem::transmute(eabuffer.unwrap_or(::std::ptr::null())), ealength, createfiletype, ::core::mem::transmute(internalparameters.unwrap_or(::std::ptr::null())), options)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoCreateFileEx(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: ::core::option::Option<*const i64>, fileattributes: u32, shareaccess: u32, disposition: u32, createoptions: u32, eabuffer: ::core::option::Option<*const ::core::ffi::c_void>, ealength: u32, createfiletype: CREATE_FILE_TYPE, internalparameters: ::core::option::Option<*const ::core::ffi::c_void>, options: u32, drivercontext: ::core::option::Option<*const IO_DRIVER_CREATE_CONTEXT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateFileEx(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, disposition : u32, createoptions : u32, eabuffer : *const ::core::ffi::c_void, ealength : u32, createfiletype : CREATE_FILE_TYPE, internalparameters : *const ::core::ffi::c_void, options : u32, drivercontext : *const IO_DRIVER_CREATE_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateFileEx(filehandle, desiredaccess, objectattributes, iostatusblock, ::core::mem::transmute(allocationsize.unwrap_or(::std::ptr::null())), fileattributes, shareaccess, disposition, createoptions, ::core::mem::transmute(eabuffer.unwrap_or(::std::ptr::null())), ealength, createfiletype, ::core::mem::transmute(internalparameters.unwrap_or(::std::ptr::null())), options, ::core::mem::transmute(drivercontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoCreateFileSpecifyDeviceObjectHint(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: ::core::option::Option<*const i64>, fileattributes: u32, shareaccess: u32, disposition: u32, createoptions: u32, eabuffer: ::core::option::Option<*const ::core::ffi::c_void>, ealength: u32, createfiletype: CREATE_FILE_TYPE, internalparameters: ::core::option::Option<*const ::core::ffi::c_void>, options: u32, deviceobject: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateFileSpecifyDeviceObjectHint(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, disposition : u32, createoptions : u32, eabuffer : *const ::core::ffi::c_void, ealength : u32, createfiletype : CREATE_FILE_TYPE, internalparameters : *const ::core::ffi::c_void, options : u32, deviceobject : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateFileSpecifyDeviceObjectHint(filehandle, desiredaccess, objectattributes, iostatusblock, ::core::mem::transmute(allocationsize.unwrap_or(::std::ptr::null())), fileattributes, shareaccess, disposition, createoptions, ::core::mem::transmute(eabuffer.unwrap_or(::std::ptr::null())), ealength, createfiletype, ::core::mem::transmute(internalparameters.unwrap_or(::std::ptr::null())), options, ::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoCreateNotificationEvent(eventname: *const super::super::super::Win32::Foundation::UNICODE_STRING, eventhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> *mut super::super::Foundation::KEVENT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateNotificationEvent(eventname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, eventhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> *mut super::super::Foundation:: KEVENT);
    IoCreateNotificationEvent(eventname, eventhandle)
}
#[inline]
pub unsafe fn IoCreateSymbolicLink(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, devicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateSymbolicLink(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, devicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateSymbolicLink(symboliclinkname, devicename)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoCreateSynchronizationEvent(eventname: *const super::super::super::Win32::Foundation::UNICODE_STRING, eventhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> *mut super::super::Foundation::KEVENT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateSynchronizationEvent(eventname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, eventhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> *mut super::super::Foundation:: KEVENT);
    IoCreateSynchronizationEvent(eventname, eventhandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn IoCreateSystemThread<P0>(ioobject: *mut ::core::ffi::c_void, threadhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, processhandle: P0, clientid: ::core::option::Option<*mut super::super::super::Win32::System::WindowsProgramming::CLIENT_ID>, startroutine: PKSTART_ROUTINE, startcontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateSystemThread(ioobject : *mut ::core::ffi::c_void, threadhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, processhandle : super::super::super::Win32::Foundation:: HANDLE, clientid : *mut super::super::super::Win32::System::WindowsProgramming:: CLIENT_ID, startroutine : PKSTART_ROUTINE, startcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateSystemThread(ioobject, threadhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), processhandle.into_param().abi(), ::core::mem::transmute(clientid.unwrap_or(::std::ptr::null_mut())), startroutine, ::core::mem::transmute(startcontext.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn IoCreateUnprotectedSymbolicLink(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, devicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCreateUnprotectedSymbolicLink(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, devicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCreateUnprotectedSymbolicLink(symboliclinkname, devicename)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInitialize(csq: *mut IO_CSQ, csqinsertirp: PIO_CSQ_INSERT_IRP, csqremoveirp: PIO_CSQ_REMOVE_IRP, csqpeeknextirp: PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock: PIO_CSQ_ACQUIRE_LOCK, csqreleaselock: PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp: PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCsqInitialize(csq : *mut IO_CSQ, csqinsertirp : PIO_CSQ_INSERT_IRP, csqremoveirp : PIO_CSQ_REMOVE_IRP, csqpeeknextirp : PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock : PIO_CSQ_ACQUIRE_LOCK, csqreleaselock : PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp : PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCsqInitialize(csq, csqinsertirp, csqremoveirp, csqpeeknextirp, csqacquirelock, csqreleaselock, csqcompletecanceledirp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInitializeEx(csq: *mut IO_CSQ, csqinsertirp: PIO_CSQ_INSERT_IRP_EX, csqremoveirp: PIO_CSQ_REMOVE_IRP, csqpeeknextirp: PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock: PIO_CSQ_ACQUIRE_LOCK, csqreleaselock: PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp: PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCsqInitializeEx(csq : *mut IO_CSQ, csqinsertirp : PIO_CSQ_INSERT_IRP_EX, csqremoveirp : PIO_CSQ_REMOVE_IRP, csqpeeknextirp : PIO_CSQ_PEEK_NEXT_IRP, csqacquirelock : PIO_CSQ_ACQUIRE_LOCK, csqreleaselock : PIO_CSQ_RELEASE_LOCK, csqcompletecanceledirp : PIO_CSQ_COMPLETE_CANCELED_IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCsqInitializeEx(csq, csqinsertirp, csqremoveirp, csqpeeknextirp, csqacquirelock, csqreleaselock, csqcompletecanceledirp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInsertIrp(csq: *mut IO_CSQ, irp: *mut super::super::Foundation::IRP, context: ::core::option::Option<*mut IO_CSQ_IRP_CONTEXT>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCsqInsertIrp(csq : *mut IO_CSQ, irp : *mut super::super::Foundation:: IRP, context : *mut IO_CSQ_IRP_CONTEXT));
    IoCsqInsertIrp(csq, irp, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqInsertIrpEx(csq: *mut IO_CSQ, irp: *mut super::super::Foundation::IRP, context: ::core::option::Option<*mut IO_CSQ_IRP_CONTEXT>, insertcontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCsqInsertIrpEx(csq : *mut IO_CSQ, irp : *mut super::super::Foundation:: IRP, context : *mut IO_CSQ_IRP_CONTEXT, insertcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoCsqInsertIrpEx(csq, irp, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(insertcontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqRemoveIrp(csq: *mut IO_CSQ, context: *mut IO_CSQ_IRP_CONTEXT) -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCsqRemoveIrp(csq : *mut IO_CSQ, context : *mut IO_CSQ_IRP_CONTEXT) -> *mut super::super::Foundation:: IRP);
    IoCsqRemoveIrp(csq, context)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoCsqRemoveNextIrp(csq: *mut IO_CSQ, peekcontext: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoCsqRemoveNextIrp(csq : *mut IO_CSQ, peekcontext : *const ::core::ffi::c_void) -> *mut super::super::Foundation:: IRP);
    IoCsqRemoveNextIrp(csq, ::core::mem::transmute(peekcontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoDecrementKeepAliveCount<P0>(fileobject: *mut super::super::Foundation::FILE_OBJECT, process: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDecrementKeepAliveCount(fileobject : *mut super::super::Foundation:: FILE_OBJECT, process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoDecrementKeepAliveCount(fileobject, process.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoDeleteController(controllerobject: *const CONTROLLER_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDeleteController(controllerobject : *const CONTROLLER_OBJECT));
    IoDeleteController(controllerobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoDeleteDevice(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDeleteDevice(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoDeleteDevice(deviceobject)
}
#[inline]
pub unsafe fn IoDeleteSymbolicLink(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDeleteSymbolicLink(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoDeleteSymbolicLink(symboliclinkname)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoDetachDevice(targetdevice: *mut super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDetachDevice(targetdevice : *mut super::super::Foundation:: DEVICE_OBJECT));
    IoDetachDevice(targetdevice)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoDisconnectInterrupt<P0>(interruptobject: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKINTERRUPT>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDisconnectInterrupt(interruptobject : super::super::Foundation:: PKINTERRUPT));
    IoDisconnectInterrupt(interruptobject.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoDisconnectInterruptEx(parameters: *const IO_DISCONNECT_INTERRUPT_PARAMETERS) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoDisconnectInterruptEx(parameters : *const IO_DISCONNECT_INTERRUPT_PARAMETERS));
    IoDisconnectInterruptEx(parameters)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoEnumerateKsrPersistentMemoryEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, callback: PIO_PERSISTED_MEMORY_ENUMERATION_CALLBACK, callbackcontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoEnumerateKsrPersistentMemoryEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, callback : PIO_PERSISTED_MEMORY_ENUMERATION_CALLBACK, callbackcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoEnumerateKsrPersistentMemoryEx(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(physicaldeviceid.unwrap_or(::std::ptr::null())), callback, callbackcontext)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Storage_IscsiDisc"))]
#[inline]
pub unsafe fn IoFlushAdapterBuffers<P0>(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, mdl: *const super::super::Foundation::MDL, mapregisterbase: *const ::core::ffi::c_void, currentva: *const ::core::ffi::c_void, length: u32, writetodevice: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("hal.dll" "system" fn IoFlushAdapterBuffers(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, mdl : *const super::super::Foundation:: MDL, mapregisterbase : *const ::core::ffi::c_void, currentva : *const ::core::ffi::c_void, length : u32, writetodevice : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoFlushAdapterBuffers(adapterobject, mdl, mapregisterbase, currentva, length, writetodevice.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoForwardIrpSynchronously(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoForwardIrpSynchronously(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoForwardIrpSynchronously(deviceobject, irp)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn IoFreeAdapterChannel(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT) {
    ::windows_targets::link!("hal.dll" "system" fn IoFreeAdapterChannel(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT));
    IoFreeAdapterChannel(adapterobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoFreeController(controllerobject: *const CONTROLLER_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeController(controllerobject : *const CONTROLLER_OBJECT));
    IoFreeController(controllerobject)
}
#[inline]
pub unsafe fn IoFreeErrorLogEntry(elentry: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeErrorLogEntry(elentry : *const ::core::ffi::c_void));
    IoFreeErrorLogEntry(elentry)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoFreeIrp(irp: *const super::super::Foundation::IRP) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeIrp(irp : *const super::super::Foundation:: IRP));
    IoFreeIrp(irp)
}
#[inline]
pub unsafe fn IoFreeKsrPersistentMemory(datahandle: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeKsrPersistentMemory(datahandle : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoFreeKsrPersistentMemory(datahandle)
}
#[cfg(feature = "Win32_Storage_IscsiDisc")]
#[inline]
pub unsafe fn IoFreeMapRegisters(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, mapregisterbase: *const ::core::ffi::c_void, numberofmapregisters: u32) {
    ::windows_targets::link!("hal.dll" "system" fn IoFreeMapRegisters(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, mapregisterbase : *const ::core::ffi::c_void, numberofmapregisters : u32));
    IoFreeMapRegisters(adapterobject, mapregisterbase, numberofmapregisters)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoFreeMdl(mdl: *mut super::super::Foundation::MDL) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeMdl(mdl : *mut super::super::Foundation:: MDL));
    IoFreeMdl(mdl)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoFreeSfioStreamIdentifier(fileobject: *const super::super::Foundation::FILE_OBJECT, signature: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeSfioStreamIdentifier(fileobject : *const super::super::Foundation:: FILE_OBJECT, signature : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoFreeSfioStreamIdentifier(fileobject, signature)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoFreeWorkItem<P0>(ioworkitem: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PIO_WORKITEM>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoFreeWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM));
    IoFreeWorkItem(ioworkitem.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetActivityIdIrp(irp: *const super::super::Foundation::IRP, guid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetActivityIdIrp(irp : *const super::super::Foundation:: IRP, guid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetActivityIdIrp(irp, guid)
}
#[inline]
pub unsafe fn IoGetActivityIdThread() -> *mut ::windows_core::GUID {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetActivityIdThread() -> *mut ::windows_core::GUID);
    IoGetActivityIdThread()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn IoGetAffinityInterrupt<P0>(interruptobject: P0, groupaffinity: *mut super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKINTERRUPT>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetAffinityInterrupt(interruptobject : super::super::Foundation:: PKINTERRUPT, groupaffinity : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetAffinityInterrupt(interruptobject.into_param().abi(), groupaffinity)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetAttachedDeviceReference(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> *mut super::super::Foundation::DEVICE_OBJECT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetAttachedDeviceReference(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> *mut super::super::Foundation:: DEVICE_OBJECT);
    IoGetAttachedDeviceReference(deviceobject)
}
#[inline]
pub unsafe fn IoGetBootDiskInformation(bootdiskinformation: *mut BOOTDISK_INFORMATION, size: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetBootDiskInformation(bootdiskinformation : *mut BOOTDISK_INFORMATION, size : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetBootDiskInformation(bootdiskinformation, size)
}
#[inline]
pub unsafe fn IoGetBootDiskInformationLite(bootdiskinformation: *mut *mut BOOTDISK_INFORMATION_LITE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetBootDiskInformationLite(bootdiskinformation : *mut *mut BOOTDISK_INFORMATION_LITE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetBootDiskInformationLite(bootdiskinformation)
}
#[inline]
pub unsafe fn IoGetConfigurationInformation() -> *mut CONFIGURATION_INFORMATION {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetConfigurationInformation() -> *mut CONFIGURATION_INFORMATION);
    IoGetConfigurationInformation()
}
#[inline]
pub unsafe fn IoGetContainerInformation(informationclass: IO_CONTAINER_INFORMATION_CLASS, containerobject: ::core::option::Option<*const ::core::ffi::c_void>, buffer: ::core::option::Option<*mut ::core::ffi::c_void>, bufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetContainerInformation(informationclass : IO_CONTAINER_INFORMATION_CLASS, containerobject : *const ::core::ffi::c_void, buffer : *mut ::core::ffi::c_void, bufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetContainerInformation(informationclass, ::core::mem::transmute(containerobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null_mut())), bufferlength)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoGetCurrentProcess() -> super::super::Foundation::PEPROCESS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetCurrentProcess() -> super::super::Foundation:: PEPROCESS);
    IoGetCurrentProcess()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceDirectory(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, directorytype: DEVICE_DIRECTORY_TYPE, flags: u32, reserved: *const ::core::ffi::c_void, devicedirectoryhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceDirectory(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, directorytype : DEVICE_DIRECTORY_TYPE, flags : u32, reserved : *const ::core::ffi::c_void, devicedirectoryhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceDirectory(physicaldeviceobject, directorytype, flags, reserved, devicedirectoryhandle)
}
#[inline]
pub unsafe fn IoGetDeviceInterfaceAlias(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, aliasinterfaceclassguid: *const ::windows_core::GUID, aliassymboliclinkname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceInterfaceAlias(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, aliasinterfaceclassguid : *const ::windows_core::GUID, aliassymboliclinkname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceInterfaceAlias(symboliclinkname, aliasinterfaceclassguid, aliassymboliclinkname)
}
#[cfg(feature = "Win32_Devices_Properties")]
#[inline]
pub unsafe fn IoGetDeviceInterfacePropertyData(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, propertykey: *const super::super::super::Win32::Devices::Properties::DEVPROPKEY, lcid: u32, flags: u32, size: u32, data: *mut ::core::ffi::c_void, requiredsize: *mut u32, r#type: *mut super::super::super::Win32::Devices::Properties::DEVPROPTYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceInterfacePropertyData(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, propertykey : *const super::super::super::Win32::Devices::Properties:: DEVPROPKEY, lcid : u32, flags : u32, size : u32, data : *mut ::core::ffi::c_void, requiredsize : *mut u32, r#type : *mut super::super::super::Win32::Devices::Properties:: DEVPROPTYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceInterfacePropertyData(symboliclinkname, propertykey, lcid, flags, size, data, requiredsize, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceInterfaces(interfaceclassguid: *const ::windows_core::GUID, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, flags: u32, symboliclinklist: *mut ::windows_core::PWSTR) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceInterfaces(interfaceclassguid : *const ::windows_core::GUID, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, flags : u32, symboliclinklist : *mut ::windows_core::PWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceInterfaces(interfaceclassguid, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), flags, symboliclinklist)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceNumaNode(pdo: *const super::super::Foundation::DEVICE_OBJECT, nodenumber: *mut u16) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceNumaNode(pdo : *const super::super::Foundation:: DEVICE_OBJECT, nodenumber : *mut u16) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceNumaNode(pdo, nodenumber)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceObjectPointer(objectname: *const super::super::super::Win32::Foundation::UNICODE_STRING, desiredaccess: u32, fileobject: *mut *mut super::super::Foundation::FILE_OBJECT, deviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceObjectPointer(objectname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, desiredaccess : u32, fileobject : *mut *mut super::super::Foundation:: FILE_OBJECT, deviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceObjectPointer(objectname, desiredaccess, fileobject, deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDeviceProperty(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, deviceproperty: DEVICE_REGISTRY_PROPERTY, bufferlength: u32, propertybuffer: ::core::option::Option<*mut ::core::ffi::c_void>, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDeviceProperty(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, deviceproperty : DEVICE_REGISTRY_PROPERTY, bufferlength : u32, propertybuffer : *mut ::core::ffi::c_void, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDeviceProperty(deviceobject, deviceproperty, bufferlength, ::core::mem::transmute(propertybuffer.unwrap_or(::std::ptr::null_mut())), resultlength)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Devices_Properties", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDevicePropertyData(pdo: *const super::super::Foundation::DEVICE_OBJECT, propertykey: *const super::super::super::Win32::Devices::Properties::DEVPROPKEY, lcid: u32, flags: u32, size: u32, data: *mut ::core::ffi::c_void, requiredsize: *mut u32, r#type: *mut super::super::super::Win32::Devices::Properties::DEVPROPTYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDevicePropertyData(pdo : *const super::super::Foundation:: DEVICE_OBJECT, propertykey : *const super::super::super::Win32::Devices::Properties:: DEVPROPKEY, lcid : u32, flags : u32, size : u32, data : *mut ::core::ffi::c_void, requiredsize : *mut u32, r#type : *mut super::super::super::Win32::Devices::Properties:: DEVPROPTYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDevicePropertyData(pdo, propertykey, lcid, flags, size, data, requiredsize, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDmaAdapter(physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, devicedescription: *const DEVICE_DESCRIPTION, numberofmapregisters: *mut u32) -> *mut DMA_ADAPTER {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDmaAdapter(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devicedescription : *const DEVICE_DESCRIPTION, numberofmapregisters : *mut u32) -> *mut DMA_ADAPTER);
    IoGetDmaAdapter(::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), devicedescription, numberofmapregisters)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDriverDirectory(driverobject: *const super::super::Foundation::DRIVER_OBJECT, directorytype: DRIVER_DIRECTORY_TYPE, flags: u32, driverdirectoryhandle: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDriverDirectory(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, directorytype : DRIVER_DIRECTORY_TYPE, flags : u32, driverdirectoryhandle : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetDriverDirectory(driverobject, directorytype, flags, driverdirectoryhandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetDriverObjectExtension(driverobject: *const super::super::Foundation::DRIVER_OBJECT, clientidentificationaddress: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetDriverObjectExtension(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, clientidentificationaddress : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    IoGetDriverObjectExtension(driverobject, clientidentificationaddress)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn IoGetFileObjectGenericMapping() -> *mut super::super::super::Win32::Security::GENERIC_MAPPING {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetFileObjectGenericMapping() -> *mut super::super::super::Win32::Security:: GENERIC_MAPPING);
    IoGetFileObjectGenericMapping()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetFsZeroingOffset(irp: *const super::super::Foundation::IRP, zeroingoffset: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetFsZeroingOffset(irp : *const super::super::Foundation:: IRP, zeroingoffset : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetFsZeroingOffset(irp, zeroingoffset)
}
#[inline]
pub unsafe fn IoGetInitialStack() -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetInitialStack() -> *mut ::core::ffi::c_void);
    IoGetInitialStack()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetInitiatorProcess(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::Foundation::PEPROCESS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetInitiatorProcess(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::Foundation:: PEPROCESS);
    IoGetInitiatorProcess(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetIoAttributionHandle(irp: *const super::super::Foundation::IRP, ioattributionhandle: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetIoAttributionHandle(irp : *const super::super::Foundation:: IRP, ioattributionhandle : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetIoAttributionHandle(irp, ioattributionhandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetIoPriorityHint(irp: *const super::super::Foundation::IRP) -> super::super::Foundation::IO_PRIORITY_HINT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetIoPriorityHint(irp : *const super::super::Foundation:: IRP) -> super::super::Foundation:: IO_PRIORITY_HINT);
    IoGetIoPriorityHint(irp)
}
#[inline]
pub unsafe fn IoGetIommuInterface(version: u32, interfaceout: *mut DMA_IOMMU_INTERFACE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetIommuInterface(version : u32, interfaceout : *mut DMA_IOMMU_INTERFACE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetIommuInterface(version, interfaceout)
}
#[inline]
pub unsafe fn IoGetIommuInterfaceEx(version: u32, flags: u64, interfaceout: *mut DMA_IOMMU_INTERFACE_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetIommuInterfaceEx(version : u32, flags : u64, interfaceout : *mut DMA_IOMMU_INTERFACE_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetIommuInterfaceEx(version, flags, interfaceout)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetIrpExtraCreateParameter(irp: *const super::super::Foundation::IRP, extracreateparameter: *mut *mut isize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetIrpExtraCreateParameter(irp : *const super::super::Foundation:: IRP, extracreateparameter : *mut *mut isize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoGetIrpExtraCreateParameter(irp, extracreateparameter)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetPagingIoPriority(irp: *const super::super::Foundation::IRP) -> IO_PAGING_PRIORITY {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetPagingIoPriority(irp : *const super::super::Foundation:: IRP) -> IO_PAGING_PRIORITY);
    IoGetPagingIoPriority(irp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetRelatedDeviceObject(fileobject: *const super::super::Foundation::FILE_OBJECT) -> *mut super::super::Foundation::DEVICE_OBJECT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetRelatedDeviceObject(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> *mut super::super::Foundation:: DEVICE_OBJECT);
    IoGetRelatedDeviceObject(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetSfioStreamIdentifier(fileobject: *const super::super::Foundation::FILE_OBJECT, signature: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetSfioStreamIdentifier(fileobject : *const super::super::Foundation:: FILE_OBJECT, signature : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    IoGetSfioStreamIdentifier(fileobject, signature)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetSilo(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::Foundation::PESILO {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetSilo(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::Foundation:: PESILO);
    IoGetSilo(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetSiloParameters(fileobject: *const super::super::Foundation::FILE_OBJECT) -> *mut IO_FOEXT_SILO_PARAMETERS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetSiloParameters(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> *mut IO_FOEXT_SILO_PARAMETERS);
    IoGetSiloParameters(fileobject)
}
#[inline]
pub unsafe fn IoGetStackLimits(lowlimit: *mut usize, highlimit: *mut usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetStackLimits(lowlimit : *mut usize, highlimit : *mut usize));
    IoGetStackLimits(lowlimit, highlimit)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetTopLevelIrp() -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetTopLevelIrp() -> *mut super::super::Foundation:: IRP);
    IoGetTopLevelIrp()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoGetTransactionParameterBlock(fileobject: *const super::super::Foundation::FILE_OBJECT) -> *mut TXN_PARAMETER_BLOCK {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoGetTransactionParameterBlock(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> *mut TXN_PARAMETER_BLOCK);
    IoGetTransactionParameterBlock(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIncrementKeepAliveCount<P0>(fileobject: *mut super::super::Foundation::FILE_OBJECT, process: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIncrementKeepAliveCount(fileobject : *mut super::super::Foundation:: FILE_OBJECT, process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoIncrementKeepAliveCount(fileobject, process.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInitializeIrp(irp: *mut super::super::Foundation::IRP, packetsize: u16, stacksize: i8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInitializeIrp(irp : *mut super::super::Foundation:: IRP, packetsize : u16, stacksize : i8));
    IoInitializeIrp(irp, packetsize, stacksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInitializeIrpEx(irp: *mut super::super::Foundation::IRP, deviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, packetsize: u16, stacksize: i8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInitializeIrpEx(irp : *mut super::super::Foundation:: IRP, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, packetsize : u16, stacksize : i8));
    IoInitializeIrpEx(irp, ::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())), packetsize, stacksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoInitializeRemoveLockEx(lock: *mut IO_REMOVE_LOCK, allocatetag: u32, maxlockedminutes: u32, highwatermark: u32, remlocksize: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInitializeRemoveLockEx(lock : *mut IO_REMOVE_LOCK, allocatetag : u32, maxlockedminutes : u32, highwatermark : u32, remlocksize : u32));
    IoInitializeRemoveLockEx(lock, allocatetag, maxlockedminutes, highwatermark, remlocksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInitializeTimer(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, timerroutine: PIO_TIMER_ROUTINE, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInitializeTimer(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, timerroutine : PIO_TIMER_ROUTINE, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoInitializeTimer(deviceobject, timerroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoInitializeWorkItem<P0>(ioobject: *const ::core::ffi::c_void, ioworkitem: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PIO_WORKITEM>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInitializeWorkItem(ioobject : *const ::core::ffi::c_void, ioworkitem : super::super::Foundation:: PIO_WORKITEM));
    IoInitializeWorkItem(ioobject, ioworkitem.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInvalidateDeviceRelations(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, r#type: DEVICE_RELATION_TYPE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInvalidateDeviceRelations(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, r#type : DEVICE_RELATION_TYPE));
    IoInvalidateDeviceRelations(deviceobject, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoInvalidateDeviceState(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoInvalidateDeviceState(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoInvalidateDeviceState(physicaldeviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIs32bitProcess(irp: ::core::option::Option<*const super::super::Foundation::IRP>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIs32bitProcess(irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoIs32bitProcess(::core::mem::transmute(irp.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIsFileObjectIgnoringSharing(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIsFileObjectIgnoringSharing(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoIsFileObjectIgnoringSharing(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIsFileOriginRemote(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIsFileOriginRemote(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoIsFileOriginRemote(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoIsInitiator32bitProcess(irp: *const super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIsInitiator32bitProcess(irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoIsInitiator32bitProcess(irp)
}
#[inline]
pub unsafe fn IoIsValidIrpStatus<P0>(status: P0) -> u32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIsValidIrpStatus(status : super::super::super::Win32::Foundation:: NTSTATUS) -> u32);
    IoIsValidIrpStatus(status.into_param().abi())
}
#[inline]
pub unsafe fn IoIsWdmVersionAvailable(majorversion: u8, minorversion: u8) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoIsWdmVersionAvailable(majorversion : u8, minorversion : u8) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoIsWdmVersionAvailable(majorversion, minorversion)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoMakeAssociatedIrp(irp: *const super::super::Foundation::IRP, stacksize: i8) -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoMakeAssociatedIrp(irp : *const super::super::Foundation:: IRP, stacksize : i8) -> *mut super::super::Foundation:: IRP);
    IoMakeAssociatedIrp(irp, stacksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoMakeAssociatedIrpEx(irp: *const super::super::Foundation::IRP, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, stacksize: i8) -> *mut super::super::Foundation::IRP {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoMakeAssociatedIrpEx(irp : *const super::super::Foundation:: IRP, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, stacksize : i8) -> *mut super::super::Foundation:: IRP);
    IoMakeAssociatedIrpEx(irp, deviceobject, stacksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Storage_IscsiDisc"))]
#[inline]
pub unsafe fn IoMapTransfer<P0>(adapterobject: *const super::super::super::Win32::Storage::IscsiDisc::_ADAPTER_OBJECT, mdl: *const super::super::Foundation::MDL, mapregisterbase: *const ::core::ffi::c_void, currentva: *const ::core::ffi::c_void, length: *mut u32, writetodevice: P0) -> i64
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("hal.dll" "system" fn IoMapTransfer(adapterobject : *const super::super::super::Win32::Storage::IscsiDisc:: _ADAPTER_OBJECT, mdl : *const super::super::Foundation:: MDL, mapregisterbase : *const ::core::ffi::c_void, currentva : *const ::core::ffi::c_void, length : *mut u32, writetodevice : super::super::super::Win32::Foundation:: BOOLEAN) -> i64);
    IoMapTransfer(adapterobject, mdl, mapregisterbase, currentva, length, writetodevice.into_param().abi())
}
#[inline]
pub unsafe fn IoOpenDeviceInterfaceRegistryKey(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, desiredaccess: u32, deviceinterfaceregkey: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoOpenDeviceInterfaceRegistryKey(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, desiredaccess : u32, deviceinterfaceregkey : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoOpenDeviceInterfaceRegistryKey(symboliclinkname, desiredaccess, deviceinterfaceregkey)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoOpenDeviceRegistryKey(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, devinstkeytype: u32, desiredaccess: u32, deviceregkey: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoOpenDeviceRegistryKey(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devinstkeytype : u32, desiredaccess : u32, deviceregkey : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoOpenDeviceRegistryKey(deviceobject, devinstkeytype, desiredaccess, deviceregkey)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoOpenDriverRegistryKey(driverobject: *const super::super::Foundation::DRIVER_OBJECT, regkeytype: DRIVER_REGKEY_TYPE, desiredaccess: u32, flags: u32, driverregkey: *mut super::super::super::Win32::Foundation::HANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoOpenDriverRegistryKey(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, regkeytype : DRIVER_REGKEY_TYPE, desiredaccess : u32, flags : u32, driverregkey : *mut super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoOpenDriverRegistryKey(driverobject, regkeytype, desiredaccess, flags, driverregkey)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoPropagateActivityIdToThread(irp: *const super::super::Foundation::IRP, propagatedid: *mut ::windows_core::GUID, originalid: *mut *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoPropagateActivityIdToThread(irp : *const super::super::Foundation:: IRP, propagatedid : *mut ::windows_core::GUID, originalid : *mut *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoPropagateActivityIdToThread(irp, propagatedid, originalid)
}
#[inline]
pub unsafe fn IoQueryDeviceDescription(bustype: ::core::option::Option<*const INTERFACE_TYPE>, busnumber: ::core::option::Option<*const u32>, controllertype: ::core::option::Option<*const CONFIGURATION_TYPE>, controllernumber: ::core::option::Option<*const u32>, peripheraltype: ::core::option::Option<*const CONFIGURATION_TYPE>, peripheralnumber: ::core::option::Option<*const u32>, calloutroutine: PIO_QUERY_DEVICE_ROUTINE, context: ::core::option::Option<*mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueryDeviceDescription(bustype : *const INTERFACE_TYPE, busnumber : *const u32, controllertype : *const CONFIGURATION_TYPE, controllernumber : *const u32, peripheraltype : *const CONFIGURATION_TYPE, peripheralnumber : *const u32, calloutroutine : PIO_QUERY_DEVICE_ROUTINE, context : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoQueryDeviceDescription(
        ::core::mem::transmute(bustype.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(busnumber.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(controllertype.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(controllernumber.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(peripheraltype.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(peripheralnumber.unwrap_or(::std::ptr::null())),
        calloutroutine,
        ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())),
    )
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoQueryFullDriverPath(driverobject: *const super::super::Foundation::DRIVER_OBJECT, fullpath: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueryFullDriverPath(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, fullpath : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoQueryFullDriverPath(driverobject, fullpath)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn IoQueryInformationByName(objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *mut ::core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS, options: u32, drivercontext: ::core::option::Option<*const IO_DRIVER_CREATE_CONTEXT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueryInformationByName(objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *mut ::core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS, options : u32, drivercontext : *const IO_DRIVER_CREATE_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoQueryInformationByName(objectattributes, iostatusblock, fileinformation, length, fileinformationclass, options, ::core::mem::transmute(drivercontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoQueryKsrPersistentMemorySize(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, buffersize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueryKsrPersistentMemorySize(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, buffersize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoQueryKsrPersistentMemorySize(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), buffersize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoQueryKsrPersistentMemorySizeEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, datatag: ::core::option::Option<*const u16>, dataversion: ::core::option::Option<*mut u32>, buffersize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueryKsrPersistentMemorySizeEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, datatag : *const u16, dataversion : *mut u32, buffersize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoQueryKsrPersistentMemorySizeEx(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(physicaldeviceid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(datatag.unwrap_or(::std::ptr::null())), ::core::mem::transmute(dataversion.unwrap_or(::std::ptr::null_mut())), buffersize)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoQueueWorkItem<P0>(ioworkitem: P0, workerroutine: PIO_WORKITEM_ROUTINE, queuetype: WORK_QUEUE_TYPE, context: ::core::option::Option<*const ::core::ffi::c_void>)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PIO_WORKITEM>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueueWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM, workerroutine : PIO_WORKITEM_ROUTINE, queuetype : WORK_QUEUE_TYPE, context : *const ::core::ffi::c_void));
    IoQueueWorkItem(ioworkitem.into_param().abi(), workerroutine, queuetype, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoQueueWorkItemEx<P0>(ioworkitem: P0, workerroutine: PIO_WORKITEM_ROUTINE_EX, queuetype: WORK_QUEUE_TYPE, context: ::core::option::Option<*const ::core::ffi::c_void>)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PIO_WORKITEM>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoQueueWorkItemEx(ioworkitem : super::super::Foundation:: PIO_WORKITEM, workerroutine : PIO_WORKITEM_ROUTINE_EX, queuetype : WORK_QUEUE_TYPE, context : *const ::core::ffi::c_void));
    IoQueueWorkItemEx(ioworkitem.into_param().abi(), workerroutine, queuetype, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRaiseHardError(irp: *const super::super::Foundation::IRP, vpb: ::core::option::Option<*const super::super::Foundation::VPB>, realdeviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRaiseHardError(irp : *const super::super::Foundation:: IRP, vpb : *const super::super::Foundation:: VPB, realdeviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoRaiseHardError(irp, ::core::mem::transmute(vpb.unwrap_or(::std::ptr::null())), realdeviceobject)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoRaiseInformationalHardError<P0, P1>(errorstatus: P0, string: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, thread: P1) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
    P1: ::windows_core::IntoParam<super::super::Foundation::PKTHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRaiseInformationalHardError(errorstatus : super::super::super::Win32::Foundation:: NTSTATUS, string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, thread : super::super::Foundation:: PKTHREAD) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoRaiseInformationalHardError(errorstatus.into_param().abi(), ::core::mem::transmute(string.unwrap_or(::std::ptr::null())), thread.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReadDiskSignature(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, bytespersector: u32, signature: *mut DISK_SIGNATURE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReadDiskSignature(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, bytespersector : u32, signature : *mut DISK_SIGNATURE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReadDiskSignature(deviceobject, bytespersector, signature)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReadPartitionTable<P0>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, returnrecognizedpartitions: P0, partitionbuffer: *mut *mut super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReadPartitionTable(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, returnrecognizedpartitions : super::super::super::Win32::Foundation:: BOOLEAN, partitionbuffer : *mut *mut super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReadPartitionTable(deviceobject, sectorsize, returnrecognizedpartitions.into_param().abi(), partitionbuffer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReadPartitionTableEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, drivelayout: *mut *mut super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReadPartitionTableEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, drivelayout : *mut *mut super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReadPartitionTableEx(deviceobject, drivelayout)
}
#[inline]
pub unsafe fn IoRecordIoAttribution(opaquehandle: *mut ::core::ffi::c_void, attributioninformation: *const IO_ATTRIBUTION_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRecordIoAttribution(opaquehandle : *mut ::core::ffi::c_void, attributioninformation : *const IO_ATTRIBUTION_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRecordIoAttribution(opaquehandle, attributioninformation)
}
#[inline]
pub unsafe fn IoRegisterBootDriverCallback(callbackfunction: PBOOT_DRIVER_CALLBACK_FUNCTION, callbackcontext: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterBootDriverCallback(callbackfunction : PBOOT_DRIVER_CALLBACK_FUNCTION, callbackcontext : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    IoRegisterBootDriverCallback(callbackfunction, ::core::mem::transmute(callbackcontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterBootDriverReinitialization(driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverreinitializationroutine: *const super::super::Foundation::DRIVER_REINITIALIZE, context: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterBootDriverReinitialization(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverreinitializationroutine : *const super::super::Foundation:: DRIVER_REINITIALIZE, context : *const ::core::ffi::c_void));
    IoRegisterBootDriverReinitialization(driverobject, driverreinitializationroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn IoRegisterContainerNotification(notificationclass: IO_CONTAINER_NOTIFICATION_CLASS, callbackfunction: PIO_CONTAINER_NOTIFICATION_FUNCTION, notificationinformation: ::core::option::Option<*const ::core::ffi::c_void>, notificationinformationlength: u32, callbackregistration: *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterContainerNotification(notificationclass : IO_CONTAINER_NOTIFICATION_CLASS, callbackfunction : PIO_CONTAINER_NOTIFICATION_FUNCTION, notificationinformation : *const ::core::ffi::c_void, notificationinformationlength : u32, callbackregistration : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRegisterContainerNotification(notificationclass, callbackfunction, ::core::mem::transmute(notificationinformation.unwrap_or(::std::ptr::null())), notificationinformationlength, callbackregistration)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterDeviceInterface(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, interfaceclassguid: *const ::windows_core::GUID, referencestring: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, symboliclinkname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterDeviceInterface(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, interfaceclassguid : *const ::windows_core::GUID, referencestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, symboliclinkname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRegisterDeviceInterface(physicaldeviceobject, interfaceclassguid, ::core::mem::transmute(referencestring.unwrap_or(::std::ptr::null())), symboliclinkname)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterDriverReinitialization(driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverreinitializationroutine: *const super::super::Foundation::DRIVER_REINITIALIZE, context: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterDriverReinitialization(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverreinitializationroutine : *const super::super::Foundation:: DRIVER_REINITIALIZE, context : *const ::core::ffi::c_void));
    IoRegisterDriverReinitialization(driverobject, driverreinitializationroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterLastChanceShutdownNotification(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterLastChanceShutdownNotification(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRegisterLastChanceShutdownNotification(deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterPlugPlayNotification(eventcategory: IO_NOTIFICATION_EVENT_CATEGORY, eventcategoryflags: u32, eventcategorydata: ::core::option::Option<*const ::core::ffi::c_void>, driverobject: *const super::super::Foundation::DRIVER_OBJECT, callbackroutine: *const super::super::Foundation::DRIVER_NOTIFICATION_CALLBACK_ROUTINE, context: ::core::option::Option<*mut ::core::ffi::c_void>, notificationentry: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterPlugPlayNotification(eventcategory : IO_NOTIFICATION_EVENT_CATEGORY, eventcategoryflags : u32, eventcategorydata : *const ::core::ffi::c_void, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, callbackroutine : *const super::super::Foundation:: DRIVER_NOTIFICATION_CALLBACK_ROUTINE, context : *mut ::core::ffi::c_void, notificationentry : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRegisterPlugPlayNotification(eventcategory, eventcategoryflags, ::core::mem::transmute(eventcategorydata.unwrap_or(::std::ptr::null())), driverobject, callbackroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())), notificationentry)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRegisterShutdownNotification(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRegisterShutdownNotification(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRegisterShutdownNotification(deviceobject)
}
#[inline]
pub unsafe fn IoReleaseCancelSpinLock(irql: u8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReleaseCancelSpinLock(irql : u8));
    IoReleaseCancelSpinLock(irql)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoReleaseRemoveLockAndWaitEx(removelock: *mut IO_REMOVE_LOCK, tag: ::core::option::Option<*const ::core::ffi::c_void>, remlocksize: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReleaseRemoveLockAndWaitEx(removelock : *mut IO_REMOVE_LOCK, tag : *const ::core::ffi::c_void, remlocksize : u32));
    IoReleaseRemoveLockAndWaitEx(removelock, ::core::mem::transmute(tag.unwrap_or(::std::ptr::null())), remlocksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn IoReleaseRemoveLockEx(removelock: *mut IO_REMOVE_LOCK, tag: ::core::option::Option<*const ::core::ffi::c_void>, remlocksize: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReleaseRemoveLockEx(removelock : *mut IO_REMOVE_LOCK, tag : *const ::core::ffi::c_void, remlocksize : u32));
    IoReleaseRemoveLockEx(removelock, ::core::mem::transmute(tag.unwrap_or(::std::ptr::null())), remlocksize)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRemoveLinkShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: ::core::option::Option<*mut LINK_SHARE_ACCESS>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRemoveLinkShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS));
    IoRemoveLinkShareAccess(fileobject, shareaccess, ::core::mem::transmute(linkshareaccess.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRemoveLinkShareAccessEx(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: ::core::option::Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRemoveLinkShareAccessEx(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32));
    IoRemoveLinkShareAccessEx(fileobject, shareaccess, ::core::mem::transmute(linkshareaccess.unwrap_or(::std::ptr::null_mut())), ioshareaccessflags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRemoveShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRemoveShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS));
    IoRemoveShareAccess(fileobject, shareaccess)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReplacePartitionUnit(targetpdo: *const super::super::Foundation::DEVICE_OBJECT, sparepdo: *const super::super::Foundation::DEVICE_OBJECT, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReplacePartitionUnit(targetpdo : *const super::super::Foundation:: DEVICE_OBJECT, sparepdo : *const super::super::Foundation:: DEVICE_OBJECT, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReplacePartitionUnit(targetpdo, sparepdo, flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportDetectedDevice<P0>(driverobject: *const super::super::Foundation::DRIVER_OBJECT, legacybustype: INTERFACE_TYPE, busnumber: u32, slotnumber: u32, resourcelist: ::core::option::Option<*const CM_RESOURCE_LIST>, resourcerequirements: ::core::option::Option<*const IO_RESOURCE_REQUIREMENTS_LIST>, resourceassigned: P0, deviceobject: *mut *mut super::super::Foundation::DEVICE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportDetectedDevice(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, legacybustype : INTERFACE_TYPE, busnumber : u32, slotnumber : u32, resourcelist : *const CM_RESOURCE_LIST, resourcerequirements : *const IO_RESOURCE_REQUIREMENTS_LIST, resourceassigned : super::super::super::Win32::Foundation:: BOOLEAN, deviceobject : *mut *mut super::super::Foundation:: DEVICE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReportDetectedDevice(driverobject, legacybustype, busnumber, slotnumber, ::core::mem::transmute(resourcelist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(resourcerequirements.unwrap_or(::std::ptr::null())), resourceassigned.into_param().abi(), deviceobject)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoReportInterruptActive(parameters: *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportInterruptActive(parameters : *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS));
    IoReportInterruptActive(parameters)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoReportInterruptInactive(parameters: *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportInterruptInactive(parameters : *const IO_REPORT_INTERRUPT_ACTIVE_STATE_PARAMETERS));
    IoReportInterruptInactive(parameters)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportResourceForDetection(driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverlist: ::core::option::Option<*const CM_RESOURCE_LIST>, driverlistsize: u32, deviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, devicelist: ::core::option::Option<*const CM_RESOURCE_LIST>, devicelistsize: u32, conflictdetected: *mut super::super::super::Win32::Foundation::BOOLEAN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportResourceForDetection(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverlist : *const CM_RESOURCE_LIST, driverlistsize : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devicelist : *const CM_RESOURCE_LIST, devicelistsize : u32, conflictdetected : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReportResourceForDetection(driverobject, ::core::mem::transmute(driverlist.unwrap_or(::std::ptr::null())), driverlistsize, ::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(devicelist.unwrap_or(::std::ptr::null())), devicelistsize, conflictdetected)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportResourceUsage<P0>(driverclassname: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, driverobject: *const super::super::Foundation::DRIVER_OBJECT, driverlist: ::core::option::Option<*const CM_RESOURCE_LIST>, driverlistsize: u32, deviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, devicelist: ::core::option::Option<*const CM_RESOURCE_LIST>, devicelistsize: u32, overrideconflict: P0, conflictdetected: *mut super::super::super::Win32::Foundation::BOOLEAN) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportResourceUsage(driverclassname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, driverobject : *const super::super::Foundation:: DRIVER_OBJECT, driverlist : *const CM_RESOURCE_LIST, driverlistsize : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, devicelist : *const CM_RESOURCE_LIST, devicelistsize : u32, overrideconflict : super::super::super::Win32::Foundation:: BOOLEAN, conflictdetected : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReportResourceUsage(::core::mem::transmute(driverclassname.unwrap_or(::std::ptr::null())), driverobject, ::core::mem::transmute(driverlist.unwrap_or(::std::ptr::null())), driverlistsize, ::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(devicelist.unwrap_or(::std::ptr::null())), devicelistsize, overrideconflict.into_param().abi(), conflictdetected)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportRootDevice(driverobject: *const super::super::Foundation::DRIVER_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportRootDevice(driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReportRootDevice(driverobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportTargetDeviceChange(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, notificationstructure: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportTargetDeviceChange(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, notificationstructure : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReportTargetDeviceChange(physicaldeviceobject, notificationstructure)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReportTargetDeviceChangeAsynchronous(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, notificationstructure: *const ::core::ffi::c_void, callback: PDEVICE_CHANGE_COMPLETE_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReportTargetDeviceChangeAsynchronous(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, notificationstructure : *const ::core::ffi::c_void, callback : PDEVICE_CHANGE_COMPLETE_CALLBACK, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReportTargetDeviceChangeAsynchronous(physicaldeviceobject, notificationstructure, callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRequestDeviceEject(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRequestDeviceEject(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoRequestDeviceEject(physicaldeviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoRequestDeviceEjectEx(physicaldeviceobject: *const super::super::Foundation::DEVICE_OBJECT, callback: PIO_DEVICE_EJECT_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>, driverobject: ::core::option::Option<*const super::super::Foundation::DRIVER_OBJECT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoRequestDeviceEjectEx(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, callback : PIO_DEVICE_EJECT_CALLBACK, context : *const ::core::ffi::c_void, driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoRequestDeviceEjectEx(physicaldeviceobject, callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), ::core::mem::transmute(driverobject.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReserveKsrPersistentMemory(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, size: usize, flags: u32, datahandle: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReserveKsrPersistentMemory(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, size : usize, flags : u32, datahandle : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReserveKsrPersistentMemory(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), size, flags, datahandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReserveKsrPersistentMemoryEx(driverobject: *const super::super::Foundation::DRIVER_OBJECT, physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, physicaldeviceid: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, datatag: ::core::option::Option<*const u16>, dataversion: u32, size: usize, flags: u32, datahandle: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReserveKsrPersistentMemoryEx(driverobject : *const super::super::Foundation:: DRIVER_OBJECT, physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, physicaldeviceid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, datatag : *const u16, dataversion : u32, size : usize, flags : u32, datahandle : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoReserveKsrPersistentMemoryEx(driverobject, ::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(physicaldeviceid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(datatag.unwrap_or(::std::ptr::null())), dataversion, size, flags, datahandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoReuseIrp<P0>(irp: *mut super::super::Foundation::IRP, iostatus: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoReuseIrp(irp : *mut super::super::Foundation:: IRP, iostatus : super::super::super::Win32::Foundation:: NTSTATUS));
    IoReuseIrp(irp, iostatus.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetActivityIdIrp(irp: *mut super::super::Foundation::IRP, guid: ::core::option::Option<*const ::windows_core::GUID>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetActivityIdIrp(irp : *mut super::super::Foundation:: IRP, guid : *const ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetActivityIdIrp(irp, ::core::mem::transmute(guid.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn IoSetActivityIdThread(activityid: *const ::windows_core::GUID) -> *mut ::windows_core::GUID {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetActivityIdThread(activityid : *const ::windows_core::GUID) -> *mut ::windows_core::GUID);
    IoSetActivityIdThread(activityid)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetCompletionRoutineEx<P0, P1, P2>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP, completionroutine: super::super::Foundation::PIO_COMPLETION_ROUTINE, context: ::core::option::Option<*const ::core::ffi::c_void>, invokeonsuccess: P0, invokeonerror: P1, invokeoncancel: P2) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P2: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetCompletionRoutineEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP, completionroutine : super::super::Foundation:: PIO_COMPLETION_ROUTINE, context : *const ::core::ffi::c_void, invokeonsuccess : super::super::super::Win32::Foundation:: BOOLEAN, invokeonerror : super::super::super::Win32::Foundation:: BOOLEAN, invokeoncancel : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetCompletionRoutineEx(deviceobject, irp, completionroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), invokeonsuccess.into_param().abi(), invokeonerror.into_param().abi(), invokeoncancel.into_param().abi())
}
#[cfg(feature = "Win32_Devices_Properties")]
#[inline]
pub unsafe fn IoSetDeviceInterfacePropertyData(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, propertykey: *const super::super::super::Win32::Devices::Properties::DEVPROPKEY, lcid: u32, flags: u32, r#type: u32, size: u32, data: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetDeviceInterfacePropertyData(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, propertykey : *const super::super::super::Win32::Devices::Properties:: DEVPROPKEY, lcid : u32, flags : u32, r#type : u32, size : u32, data : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetDeviceInterfacePropertyData(symboliclinkname, propertykey, lcid, flags, r#type, size, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn IoSetDeviceInterfaceState<P0>(symboliclinkname: *const super::super::super::Win32::Foundation::UNICODE_STRING, enable: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetDeviceInterfaceState(symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, enable : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetDeviceInterfaceState(symboliclinkname, enable.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Devices_Properties", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetDevicePropertyData(pdo: *const super::super::Foundation::DEVICE_OBJECT, propertykey: *const super::super::super::Win32::Devices::Properties::DEVPROPKEY, lcid: u32, flags: u32, r#type: u32, size: u32, data: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetDevicePropertyData(pdo : *const super::super::Foundation:: DEVICE_OBJECT, propertykey : *const super::super::super::Win32::Devices::Properties:: DEVPROPKEY, lcid : u32, flags : u32, r#type : u32, size : u32, data : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetDevicePropertyData(pdo, propertykey, lcid, flags, r#type, size, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFileObjectIgnoreSharing(fileobject: *const super::super::Foundation::FILE_OBJECT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetFileObjectIgnoreSharing(fileobject : *const super::super::Foundation:: FILE_OBJECT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetFileObjectIgnoreSharing(fileobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFileOrigin<P0>(fileobject: *const super::super::Foundation::FILE_OBJECT, remote: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetFileOrigin(fileobject : *const super::super::Foundation:: FILE_OBJECT, remote : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetFileOrigin(fileobject, remote.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFsZeroingOffset(irp: *mut super::super::Foundation::IRP, zeroingoffset: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetFsZeroingOffset(irp : *mut super::super::Foundation:: IRP, zeroingoffset : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetFsZeroingOffset(irp, zeroingoffset)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetFsZeroingOffsetRequired(irp: *mut super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetFsZeroingOffsetRequired(irp : *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetFsZeroingOffsetRequired(irp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetHardErrorOrVerifyDevice(irp: *const super::super::Foundation::IRP, deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetHardErrorOrVerifyDevice(irp : *const super::super::Foundation:: IRP, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoSetHardErrorOrVerifyDevice(irp, deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetIoAttributionIrp(irp: *mut super::super::Foundation::IRP, attributionsource: *const ::core::ffi::c_void, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetIoAttributionIrp(irp : *mut super::super::Foundation:: IRP, attributionsource : *const ::core::ffi::c_void, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetIoAttributionIrp(irp, attributionsource, flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetIoPriorityHint(irp: *const super::super::Foundation::IRP, priorityhint: super::super::Foundation::IO_PRIORITY_HINT) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetIoPriorityHint(irp : *const super::super::Foundation:: IRP, priorityhint : super::super::Foundation:: IO_PRIORITY_HINT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetIoPriorityHint(irp, priorityhint)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetIrpExtraCreateParameter(irp: *mut super::super::Foundation::IRP, extracreateparameter: *const isize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetIrpExtraCreateParameter(irp : *mut super::super::Foundation:: IRP, extracreateparameter : *const isize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetIrpExtraCreateParameter(irp, extracreateparameter)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetLinkShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: ::core::option::Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetLinkShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32));
    IoSetLinkShareAccess(desiredaccess, desiredshareaccess, fileobject, shareaccess, ::core::mem::transmute(linkshareaccess.unwrap_or(::std::ptr::null_mut())), ioshareaccessflags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetMasterIrpStatus<P0>(masterirp: *mut super::super::Foundation::IRP, status: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetMasterIrpStatus(masterirp : *mut super::super::Foundation:: IRP, status : super::super::super::Win32::Foundation:: NTSTATUS));
    IoSetMasterIrpStatus(masterirp, status.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetPartitionInformation(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, partitionnumber: u32, partitiontype: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetPartitionInformation(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, partitionnumber : u32, partitiontype : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetPartitionInformation(deviceobject, sectorsize, partitionnumber, partitiontype)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetPartitionInformationEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, partitionnumber: u32, partitioninfo: *const super::super::super::Win32::System::Ioctl::SET_PARTITION_INFORMATION_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetPartitionInformationEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, partitionnumber : u32, partitioninfo : *const super::super::super::Win32::System::Ioctl:: SET_PARTITION_INFORMATION_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetPartitionInformationEx(deviceobject, partitionnumber, partitioninfo)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetShareAccess(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetShareAccess(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS));
    IoSetShareAccess(desiredaccess, desiredshareaccess, fileobject, shareaccess)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetShareAccessEx(desiredaccess: u32, desiredshareaccess: u32, fileobject: *mut super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, writepermission: ::core::option::Option<*const super::super::super::Win32::Foundation::BOOLEAN>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetShareAccessEx(desiredaccess : u32, desiredshareaccess : u32, fileobject : *mut super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, writepermission : *const super::super::super::Win32::Foundation:: BOOLEAN));
    IoSetShareAccessEx(desiredaccess, desiredshareaccess, fileobject, shareaccess, ::core::mem::transmute(writepermission.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetStartIoAttributes<P0, P1>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, deferredstartio: P0, noncancelable: P1)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetStartIoAttributes(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, deferredstartio : super::super::super::Win32::Foundation:: BOOLEAN, noncancelable : super::super::super::Win32::Foundation:: BOOLEAN));
    IoSetStartIoAttributes(deviceobject, deferredstartio.into_param().abi(), noncancelable.into_param().abi())
}
#[inline]
pub unsafe fn IoSetSystemPartition(volumenamestring: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetSystemPartition(volumenamestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSetSystemPartition(volumenamestring)
}
#[inline]
pub unsafe fn IoSetThreadHardErrorMode<P0>(enableharderrors: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetThreadHardErrorMode(enableharderrors : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoSetThreadHardErrorMode(enableharderrors.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSetTopLevelIrp(irp: ::core::option::Option<*const super::super::Foundation::IRP>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSetTopLevelIrp(irp : *const super::super::Foundation:: IRP));
    IoSetTopLevelIrp(::core::mem::transmute(irp.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSizeOfIrpEx(deviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, stacksize: i8) -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSizeOfIrpEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, stacksize : i8) -> u16);
    IoSizeOfIrpEx(::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())), stacksize)
}
#[inline]
pub unsafe fn IoSizeofWorkItem() -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSizeofWorkItem() -> u32);
    IoSizeofWorkItem()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartNextPacket<P0>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, cancelable: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoStartNextPacket(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, cancelable : super::super::super::Win32::Foundation:: BOOLEAN));
    IoStartNextPacket(deviceobject, cancelable.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartNextPacketByKey<P0>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, cancelable: P0, key: u32)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoStartNextPacketByKey(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, cancelable : super::super::super::Win32::Foundation:: BOOLEAN, key : u32));
    IoStartNextPacketByKey(deviceobject, cancelable.into_param().abi(), key)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartPacket(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP, key: ::core::option::Option<*const u32>, cancelfunction: ::core::option::Option<*const super::super::Foundation::DRIVER_CANCEL>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoStartPacket(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP, key : *const u32, cancelfunction : *const super::super::Foundation:: DRIVER_CANCEL));
    IoStartPacket(deviceobject, irp, ::core::mem::transmute(key.unwrap_or(::std::ptr::null())), ::core::mem::transmute(cancelfunction.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStartTimer(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoStartTimer(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoStartTimer(deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoStopTimer(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoStopTimer(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoStopTimer(deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoSynchronousCallDriver(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *const super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoSynchronousCallDriver(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoSynchronousCallDriver(deviceobject, irp)
}
#[inline]
pub unsafe fn IoTransferActivityId(activityid: *const ::windows_core::GUID, relatedactivityid: *const ::windows_core::GUID) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoTransferActivityId(activityid : *const ::windows_core::GUID, relatedactivityid : *const ::windows_core::GUID));
    IoTransferActivityId(activityid, relatedactivityid)
}
#[inline]
pub unsafe fn IoTranslateBusAddress(interfacetype: INTERFACE_TYPE, busnumber: u32, busaddress: i64, addressspace: *mut u32, translatedaddress: *mut i64) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoTranslateBusAddress(interfacetype : INTERFACE_TYPE, busnumber : u32, busaddress : i64, addressspace : *mut u32, translatedaddress : *mut i64) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoTranslateBusAddress(interfacetype, busnumber, busaddress, addressspace, translatedaddress)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoTryQueueWorkItem<P0>(ioworkitem: P0, workerroutine: PIO_WORKITEM_ROUTINE_EX, queuetype: WORK_QUEUE_TYPE, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PIO_WORKITEM>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoTryQueueWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM, workerroutine : PIO_WORKITEM_ROUTINE_EX, queuetype : WORK_QUEUE_TYPE, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    IoTryQueueWorkItem(ioworkitem.into_param().abi(), workerroutine, queuetype, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn IoUninitializeWorkItem<P0>(ioworkitem: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PIO_WORKITEM>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUninitializeWorkItem(ioworkitem : super::super::Foundation:: PIO_WORKITEM));
    IoUninitializeWorkItem(ioworkitem.into_param().abi())
}
#[inline]
pub unsafe fn IoUnregisterBootDriverCallback(callbackhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUnregisterBootDriverCallback(callbackhandle : *const ::core::ffi::c_void));
    IoUnregisterBootDriverCallback(callbackhandle)
}
#[inline]
pub unsafe fn IoUnregisterContainerNotification(callbackregistration: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUnregisterContainerNotification(callbackregistration : *const ::core::ffi::c_void));
    IoUnregisterContainerNotification(callbackregistration)
}
#[inline]
pub unsafe fn IoUnregisterPlugPlayNotification(notificationentry: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUnregisterPlugPlayNotification(notificationentry : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoUnregisterPlugPlayNotification(notificationentry)
}
#[inline]
pub unsafe fn IoUnregisterPlugPlayNotificationEx(notificationentry: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUnregisterPlugPlayNotificationEx(notificationentry : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoUnregisterPlugPlayNotificationEx(notificationentry)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUnregisterShutdownNotification(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUnregisterShutdownNotification(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    IoUnregisterShutdownNotification(deviceobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUpdateLinkShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: ::core::option::Option<*mut LINK_SHARE_ACCESS>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUpdateLinkShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS));
    IoUpdateLinkShareAccess(fileobject, shareaccess, ::core::mem::transmute(linkshareaccess.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUpdateLinkShareAccessEx(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS, linkshareaccess: ::core::option::Option<*mut LINK_SHARE_ACCESS>, ioshareaccessflags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUpdateLinkShareAccessEx(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS, linkshareaccess : *mut LINK_SHARE_ACCESS, ioshareaccessflags : u32));
    IoUpdateLinkShareAccessEx(fileobject, shareaccess, ::core::mem::transmute(linkshareaccess.unwrap_or(::std::ptr::null_mut())), ioshareaccessflags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoUpdateShareAccess(fileobject: *const super::super::Foundation::FILE_OBJECT, shareaccess: *mut SHARE_ACCESS) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoUpdateShareAccess(fileobject : *const super::super::Foundation:: FILE_OBJECT, shareaccess : *mut SHARE_ACCESS));
    IoUpdateShareAccess(fileobject, shareaccess)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoValidateDeviceIoControlAccess(irp: *const super::super::Foundation::IRP, requiredaccess: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoValidateDeviceIoControlAccess(irp : *const super::super::Foundation:: IRP, requiredaccess : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoValidateDeviceIoControlAccess(irp, requiredaccess)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoVerifyPartitionTable<P0>(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, fixerrors: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoVerifyPartitionTable(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, fixerrors : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoVerifyPartitionTable(deviceobject, fixerrors.into_param().abi())
}
#[inline]
pub unsafe fn IoVolumeDeviceNameToGuid(volumedevicename: *const super::super::super::Win32::Foundation::UNICODE_STRING, guid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceNameToGuid(volumedevicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, guid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoVolumeDeviceNameToGuid(volumedevicename, guid)
}
#[inline]
pub unsafe fn IoVolumeDeviceNameToGuidPath(volumedevicename: *const super::super::super::Win32::Foundation::UNICODE_STRING, guidpath: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceNameToGuidPath(volumedevicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, guidpath : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoVolumeDeviceNameToGuidPath(volumedevicename, guidpath)
}
#[inline]
pub unsafe fn IoVolumeDeviceToDosName(volumedeviceobject: *const ::core::ffi::c_void, dosname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceToDosName(volumedeviceobject : *const ::core::ffi::c_void, dosname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoVolumeDeviceToDosName(volumedeviceobject, dosname)
}
#[inline]
pub unsafe fn IoVolumeDeviceToGuid(volumedeviceobject: *const ::core::ffi::c_void, guid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceToGuid(volumedeviceobject : *const ::core::ffi::c_void, guid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoVolumeDeviceToGuid(volumedeviceobject, guid)
}
#[inline]
pub unsafe fn IoVolumeDeviceToGuidPath(volumedeviceobject: *const ::core::ffi::c_void, guidpath: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoVolumeDeviceToGuidPath(volumedeviceobject : *const ::core::ffi::c_void, guidpath : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoVolumeDeviceToGuidPath(volumedeviceobject, guidpath)
}
#[inline]
pub unsafe fn IoWMIAllocateInstanceIds(guid: *const ::windows_core::GUID, instancecount: u32, firstinstanceid: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIAllocateInstanceIds(guid : *const ::windows_core::GUID, instancecount : u32, firstinstanceid : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIAllocateInstanceIds(guid, instancecount, firstinstanceid)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWMIDeviceObjectToInstanceName(datablockobject: *const ::core::ffi::c_void, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, instancename: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIDeviceObjectToInstanceName(datablockobject : *const ::core::ffi::c_void, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, instancename : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIDeviceObjectToInstanceName(datablockobject, deviceobject, instancename)
}
#[inline]
pub unsafe fn IoWMIExecuteMethod(datablockobject: *const ::core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, methodid: u32, inbuffersize: u32, outbuffersize: *mut u32, inoutbuffer: ::core::option::Option<*mut u8>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIExecuteMethod(datablockobject : *const ::core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, methodid : u32, inbuffersize : u32, outbuffersize : *mut u32, inoutbuffer : *mut u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIExecuteMethod(datablockobject, instancename, methodid, inbuffersize, outbuffersize, ::core::mem::transmute(inoutbuffer.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn IoWMIHandleToInstanceName<P0>(datablockobject: *const ::core::ffi::c_void, filehandle: P0, instancename: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIHandleToInstanceName(datablockobject : *const ::core::ffi::c_void, filehandle : super::super::super::Win32::Foundation:: HANDLE, instancename : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIHandleToInstanceName(datablockobject, filehandle.into_param().abi(), instancename)
}
#[inline]
pub unsafe fn IoWMIOpenBlock(guid: *const ::windows_core::GUID, desiredaccess: u32, datablockobject: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIOpenBlock(guid : *const ::windows_core::GUID, desiredaccess : u32, datablockobject : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIOpenBlock(guid, desiredaccess, datablockobject)
}
#[inline]
pub unsafe fn IoWMIQueryAllData(datablockobject: *const ::core::ffi::c_void, inoutbuffersize: *mut u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIQueryAllData(datablockobject : *const ::core::ffi::c_void, inoutbuffersize : *mut u32, outbuffer : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIQueryAllData(datablockobject, inoutbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn IoWMIQueryAllDataMultiple(datablockobjectlist: &[*const ::core::ffi::c_void], inoutbuffersize: *mut u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIQueryAllDataMultiple(datablockobjectlist : *const *const ::core::ffi::c_void, objectcount : u32, inoutbuffersize : *mut u32, outbuffer : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIQueryAllDataMultiple(::core::mem::transmute(datablockobjectlist.as_ptr()), datablockobjectlist.len().try_into().unwrap(), inoutbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn IoWMIQuerySingleInstance(datablockobject: *const ::core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, inoutbuffersize: *mut u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIQuerySingleInstance(datablockobject : *const ::core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, inoutbuffersize : *mut u32, outbuffer : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIQuerySingleInstance(datablockobject, instancename, inoutbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn IoWMIQuerySingleInstanceMultiple(datablockobjectlist: *const *const ::core::ffi::c_void, instancenames: *const super::super::super::Win32::Foundation::UNICODE_STRING, objectcount: u32, inoutbuffersize: *mut u32, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIQuerySingleInstanceMultiple(datablockobjectlist : *const *const ::core::ffi::c_void, instancenames : *const super::super::super::Win32::Foundation:: UNICODE_STRING, objectcount : u32, inoutbuffersize : *mut u32, outbuffer : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIQuerySingleInstanceMultiple(datablockobjectlist, instancenames, objectcount, inoutbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWMIRegistrationControl(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, action: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIRegistrationControl(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, action : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIRegistrationControl(deviceobject, action)
}
#[inline]
pub unsafe fn IoWMISetNotificationCallback(object: *mut ::core::ffi::c_void, callback: WMI_NOTIFICATION_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMISetNotificationCallback(object : *mut ::core::ffi::c_void, callback : WMI_NOTIFICATION_CALLBACK, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMISetNotificationCallback(object, callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn IoWMISetSingleInstance(datablockobject: *const ::core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, version: u32, valuebuffersize: u32, valuebuffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMISetSingleInstance(datablockobject : *const ::core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, version : u32, valuebuffersize : u32, valuebuffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMISetSingleInstance(datablockobject, instancename, version, valuebuffersize, valuebuffer)
}
#[inline]
pub unsafe fn IoWMISetSingleItem(datablockobject: *const ::core::ffi::c_void, instancename: *const super::super::super::Win32::Foundation::UNICODE_STRING, dataitemid: u32, version: u32, valuebuffersize: u32, valuebuffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMISetSingleItem(datablockobject : *const ::core::ffi::c_void, instancename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, dataitemid : u32, version : u32, valuebuffersize : u32, valuebuffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMISetSingleItem(datablockobject, instancename, dataitemid, version, valuebuffersize, valuebuffer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWMISuggestInstanceName<P0>(physicaldeviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, symboliclinkname: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, combinenames: P0, suggestedinstancename: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMISuggestInstanceName(physicaldeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, symboliclinkname : *const super::super::super::Win32::Foundation:: UNICODE_STRING, combinenames : super::super::super::Win32::Foundation:: BOOLEAN, suggestedinstancename : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMISuggestInstanceName(::core::mem::transmute(physicaldeviceobject.unwrap_or(::std::ptr::null())), ::core::mem::transmute(symboliclinkname.unwrap_or(::std::ptr::null())), combinenames.into_param().abi(), suggestedinstancename)
}
#[inline]
pub unsafe fn IoWMIWriteEvent(wnodeeventitem: *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWMIWriteEvent(wnodeeventitem : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWMIWriteEvent(wnodeeventitem)
}
#[inline]
pub unsafe fn IoWithinStackLimits(regionstart: usize, regionsize: usize) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWithinStackLimits(regionstart : usize, regionsize : usize) -> u32);
    IoWithinStackLimits(regionstart, regionsize)
}
#[inline]
pub unsafe fn IoWriteErrorLogEntry(elentry: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWriteErrorLogEntry(elentry : *const ::core::ffi::c_void));
    IoWriteErrorLogEntry(elentry)
}
#[inline]
pub unsafe fn IoWriteKsrPersistentMemory(datahandle: *const ::core::ffi::c_void, buffer: *const ::core::ffi::c_void, size: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWriteKsrPersistentMemory(datahandle : *const ::core::ffi::c_void, buffer : *const ::core::ffi::c_void, size : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWriteKsrPersistentMemory(datahandle, buffer, size)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWritePartitionTable(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, sectorsize: u32, sectorspertrack: u32, numberofheads: u32, partitionbuffer: *const super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWritePartitionTable(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, sectorsize : u32, sectorspertrack : u32, numberofheads : u32, partitionbuffer : *const super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWritePartitionTable(deviceobject, sectorsize, sectorspertrack, numberofheads, partitionbuffer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Ioctl", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IoWritePartitionTableEx(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, drivelayout: *const super::super::super::Win32::System::Ioctl::DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IoWritePartitionTableEx(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, drivelayout : *const super::super::super::Win32::System::Ioctl:: DRIVE_LAYOUT_INFORMATION_EX) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IoWritePartitionTableEx(deviceobject, drivelayout)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IofCallDriver(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *mut super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IofCallDriver(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    IofCallDriver(deviceobject, irp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn IofCompleteRequest(irp: *const super::super::Foundation::IRP, priorityboost: i8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn IofCompleteRequest(irp : *const super::super::Foundation:: IRP, priorityboost : i8));
    IofCompleteRequest(irp, priorityboost)
}
#[inline]
pub unsafe fn KdChangeOption(option: KD_OPTION, inbufferbytes: u32, inbuffer: *const ::core::ffi::c_void, outbufferbytes: u32, outbuffer: *mut ::core::ffi::c_void, outbufferneeded: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KdChangeOption(option : KD_OPTION, inbufferbytes : u32, inbuffer : *const ::core::ffi::c_void, outbufferbytes : u32, outbuffer : *mut ::core::ffi::c_void, outbufferneeded : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KdChangeOption(option, inbufferbytes, inbuffer, outbufferbytes, outbuffer, outbufferneeded)
}
#[inline]
pub unsafe fn KdDisableDebugger() -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KdDisableDebugger() -> super::super::super::Win32::Foundation:: NTSTATUS);
    KdDisableDebugger()
}
#[inline]
pub unsafe fn KdEnableDebugger() -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KdEnableDebugger() -> super::super::super::Win32::Foundation:: NTSTATUS);
    KdEnableDebugger()
}
#[inline]
pub unsafe fn KdRefreshDebuggerNotPresent() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KdRefreshDebuggerNotPresent() -> super::super::super::Win32::Foundation:: BOOLEAN);
    KdRefreshDebuggerNotPresent()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeAcquireGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX));
    KeAcquireGuardedMutex(mutex)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeAcquireGuardedMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireGuardedMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    KeAcquireGuardedMutexUnsafe(fastmutex)
}
#[inline]
pub unsafe fn KeAcquireInStackQueuedSpinLock(spinlock: *mut usize, lockhandle: *mut KLOCK_QUEUE_HANDLE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireInStackQueuedSpinLock(spinlock : *mut usize, lockhandle : *mut KLOCK_QUEUE_HANDLE));
    KeAcquireInStackQueuedSpinLock(spinlock, lockhandle)
}
#[inline]
pub unsafe fn KeAcquireInStackQueuedSpinLockAtDpcLevel(spinlock: *mut usize, lockhandle: *mut KLOCK_QUEUE_HANDLE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireInStackQueuedSpinLockAtDpcLevel(spinlock : *mut usize, lockhandle : *mut KLOCK_QUEUE_HANDLE));
    KeAcquireInStackQueuedSpinLockAtDpcLevel(spinlock, lockhandle)
}
#[inline]
pub unsafe fn KeAcquireInStackQueuedSpinLockForDpc(spinlock: *mut usize, lockhandle: *mut KLOCK_QUEUE_HANDLE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireInStackQueuedSpinLockForDpc(spinlock : *mut usize, lockhandle : *mut KLOCK_QUEUE_HANDLE));
    KeAcquireInStackQueuedSpinLockForDpc(spinlock, lockhandle)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeAcquireInterruptSpinLock<P0>(interrupt: P0) -> u8
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKINTERRUPT>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireInterruptSpinLock(interrupt : super::super::Foundation:: PKINTERRUPT) -> u8);
    KeAcquireInterruptSpinLock(interrupt.into_param().abi())
}
#[inline]
pub unsafe fn KeAcquireSpinLockForDpc(spinlock: *mut usize) -> u8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAcquireSpinLockForDpc(spinlock : *mut usize) -> u8);
    KeAcquireSpinLockForDpc(spinlock)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeAddTriageDumpDataBlock(ktriagedumpdataarray: *mut KTRIAGE_DUMP_DATA_ARRAY, address: *const ::core::ffi::c_void, size: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAddTriageDumpDataBlock(ktriagedumpdataarray : *mut KTRIAGE_DUMP_DATA_ARRAY, address : *const ::core::ffi::c_void, size : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeAddTriageDumpDataBlock(ktriagedumpdataarray, address, size)
}
#[inline]
pub unsafe fn KeAreAllApcsDisabled() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAreAllApcsDisabled() -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeAreAllApcsDisabled()
}
#[inline]
pub unsafe fn KeAreApcsDisabled() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeAreApcsDisabled() -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeAreApcsDisabled()
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeBugCheck(bugcheckcode: super::super::super::Win32::System::Diagnostics::Debug::BUGCHECK_ERROR) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeBugCheck(bugcheckcode : super::super::super::Win32::System::Diagnostics::Debug:: BUGCHECK_ERROR));
    KeBugCheck(bugcheckcode)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeBugCheckEx(bugcheckcode: super::super::super::Win32::System::Diagnostics::Debug::BUGCHECK_ERROR, bugcheckparameter1: usize, bugcheckparameter2: usize, bugcheckparameter3: usize, bugcheckparameter4: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeBugCheckEx(bugcheckcode : super::super::super::Win32::System::Diagnostics::Debug:: BUGCHECK_ERROR, bugcheckparameter1 : usize, bugcheckparameter2 : usize, bugcheckparameter3 : usize, bugcheckparameter4 : usize));
    KeBugCheckEx(bugcheckcode, bugcheckparameter1, bugcheckparameter2, bugcheckparameter3, bugcheckparameter4)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeCancelTimer(param0: *mut KTIMER) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeCancelTimer(param0 : *mut KTIMER) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeCancelTimer(param0)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeClearEvent(event: *mut super::super::Foundation::KEVENT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeClearEvent(event : *mut super::super::Foundation:: KEVENT));
    KeClearEvent(event)
}
#[inline]
pub unsafe fn KeConvertAuxiliaryCounterToPerformanceCounter(auxiliarycountervalue: u64, performancecountervalue: *mut u64, conversionerror: ::core::option::Option<*mut u64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeConvertAuxiliaryCounterToPerformanceCounter(auxiliarycountervalue : u64, performancecountervalue : *mut u64, conversionerror : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeConvertAuxiliaryCounterToPerformanceCounter(auxiliarycountervalue, performancecountervalue, ::core::mem::transmute(conversionerror.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn KeConvertPerformanceCounterToAuxiliaryCounter(performancecountervalue: u64, auxiliarycountervalue: *mut u64, conversionerror: ::core::option::Option<*mut u64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeConvertPerformanceCounterToAuxiliaryCounter(performancecountervalue : u64, auxiliarycountervalue : *mut u64, conversionerror : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeConvertPerformanceCounterToAuxiliaryCounter(performancecountervalue, auxiliarycountervalue, ::core::mem::transmute(conversionerror.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn KeDelayExecutionThread<P0>(waitmode: i8, alertable: P0, interval: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeDelayExecutionThread(waitmode : i8, alertable : super::super::super::Win32::Foundation:: BOOLEAN, interval : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeDelayExecutionThread(waitmode, alertable.into_param().abi(), interval)
}
#[inline]
pub unsafe fn KeDeregisterBoundCallback(handle: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeDeregisterBoundCallback(handle : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeDeregisterBoundCallback(handle)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeDeregisterBugCheckCallback(callbackrecord: *mut KBUGCHECK_CALLBACK_RECORD) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeDeregisterBugCheckCallback(callbackrecord : *mut KBUGCHECK_CALLBACK_RECORD) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeDeregisterBugCheckCallback(callbackrecord)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeDeregisterBugCheckReasonCallback(callbackrecord: *mut KBUGCHECK_REASON_CALLBACK_RECORD) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeDeregisterBugCheckReasonCallback(callbackrecord : *mut KBUGCHECK_REASON_CALLBACK_RECORD) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeDeregisterBugCheckReasonCallback(callbackrecord)
}
#[inline]
pub unsafe fn KeDeregisterNmiCallback(handle: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeDeregisterNmiCallback(handle : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeDeregisterNmiCallback(handle)
}
#[inline]
pub unsafe fn KeDeregisterProcessorChangeCallback(callbackhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeDeregisterProcessorChangeCallback(callbackhandle : *const ::core::ffi::c_void));
    KeDeregisterProcessorChangeCallback(callbackhandle)
}
#[inline]
pub unsafe fn KeEnterCriticalRegion() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeEnterCriticalRegion());
    KeEnterCriticalRegion()
}
#[inline]
pub unsafe fn KeEnterGuardedRegion() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeEnterGuardedRegion());
    KeEnterGuardedRegion()
}
#[inline]
pub unsafe fn KeExpandKernelStackAndCallout(callout: PEXPAND_STACK_CALLOUT, parameter: ::core::option::Option<*const ::core::ffi::c_void>, size: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeExpandKernelStackAndCallout(callout : PEXPAND_STACK_CALLOUT, parameter : *const ::core::ffi::c_void, size : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeExpandKernelStackAndCallout(callout, ::core::mem::transmute(parameter.unwrap_or(::std::ptr::null())), size)
}
#[inline]
pub unsafe fn KeExpandKernelStackAndCalloutEx<P0>(callout: PEXPAND_STACK_CALLOUT, parameter: ::core::option::Option<*const ::core::ffi::c_void>, size: usize, wait: P0, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeExpandKernelStackAndCalloutEx(callout : PEXPAND_STACK_CALLOUT, parameter : *const ::core::ffi::c_void, size : usize, wait : super::super::super::Win32::Foundation:: BOOLEAN, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeExpandKernelStackAndCalloutEx(callout, ::core::mem::transmute(parameter.unwrap_or(::std::ptr::null())), size, wait.into_param().abi(), ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeFlushIoBuffers<P0, P1>(mdl: *const super::super::Foundation::MDL, readoperation: P0, dmaoperation: P1)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeFlushIoBuffers(mdl : *const super::super::Foundation:: MDL, readoperation : super::super::super::Win32::Foundation:: BOOLEAN, dmaoperation : super::super::super::Win32::Foundation:: BOOLEAN));
    KeFlushIoBuffers(mdl, readoperation.into_param().abi(), dmaoperation.into_param().abi())
}
#[inline]
pub unsafe fn KeFlushQueuedDpcs() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeFlushQueuedDpcs());
    KeFlushQueuedDpcs()
}
#[inline]
pub unsafe fn KeFlushWriteBuffer() {
    ::windows_targets::link!("hal.dll" "system" fn KeFlushWriteBuffer());
    KeFlushWriteBuffer()
}
#[inline]
pub unsafe fn KeGetCurrentIrql() -> u8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeGetCurrentIrql() -> u8);
    KeGetCurrentIrql()
}
#[inline]
pub unsafe fn KeGetCurrentNodeNumber() -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeGetCurrentNodeNumber() -> u16);
    KeGetCurrentNodeNumber()
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeGetCurrentProcessorNumberEx(procnumber: ::core::option::Option<*mut super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER>) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeGetCurrentProcessorNumberEx(procnumber : *mut super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> u32);
    KeGetCurrentProcessorNumberEx(::core::mem::transmute(procnumber.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeGetProcessorIndexFromNumber(procnumber: *const super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeGetProcessorIndexFromNumber(procnumber : *const super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> u32);
    KeGetProcessorIndexFromNumber(procnumber)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeGetProcessorNumberFromIndex(procindex: u32, procnumber: *mut super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeGetProcessorNumberFromIndex(procindex : u32, procnumber : *mut super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeGetProcessorNumberFromIndex(procindex, procnumber)
}
#[inline]
pub unsafe fn KeGetRecommendedSharedDataAlignment() -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeGetRecommendedSharedDataAlignment() -> u32);
    KeGetRecommendedSharedDataAlignment()
}
#[inline]
pub unsafe fn KeInitializeCrashDumpHeader(dumptype: u32, flags: u32, buffer: *mut ::core::ffi::c_void, buffersize: u32, bufferneeded: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeCrashDumpHeader(dumptype : u32, flags : u32, buffer : *mut ::core::ffi::c_void, buffersize : u32, bufferneeded : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeInitializeCrashDumpHeader(dumptype, flags, buffer, buffersize, ::core::mem::transmute(bufferneeded.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE));
    KeInitializeDeviceQueue(devicequeue)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeDpc(dpc: *mut super::super::Foundation::KDPC, deferredroutine: super::super::Foundation::PKDEFERRED_ROUTINE, deferredcontext: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeDpc(dpc : *mut super::super::Foundation:: KDPC, deferredroutine : super::super::Foundation:: PKDEFERRED_ROUTINE, deferredcontext : *const ::core::ffi::c_void));
    KeInitializeDpc(dpc, deferredroutine, ::core::mem::transmute(deferredcontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeEvent<P0>(event: *mut super::super::Foundation::KEVENT, r#type: super::super::super::Win32::System::Kernel::EVENT_TYPE, state: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeEvent(event : *mut super::super::Foundation:: KEVENT, r#type : super::super::super::Win32::System::Kernel:: EVENT_TYPE, state : super::super::super::Win32::Foundation:: BOOLEAN));
    KeInitializeEvent(event, r#type, state.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX));
    KeInitializeGuardedMutex(mutex)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeMutex(mutex: *mut super::super::Foundation::KMUTANT, level: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeMutex(mutex : *mut super::super::Foundation:: KMUTANT, level : u32));
    KeInitializeMutex(mutex, level)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeSemaphore(semaphore: *mut KSEMAPHORE, count: i32, limit: i32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeSemaphore(semaphore : *mut KSEMAPHORE, count : i32, limit : i32));
    KeInitializeSemaphore(semaphore, count, limit)
}
#[inline]
pub unsafe fn KeInitializeSpinLock() -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeSpinLock(spinlock : *mut usize));
    let mut result__ = ::std::mem::zeroed();
    KeInitializeSpinLock(&mut result__);
    result__
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeThreadedDpc(dpc: *mut super::super::Foundation::KDPC, deferredroutine: super::super::Foundation::PKDEFERRED_ROUTINE, deferredcontext: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeThreadedDpc(dpc : *mut super::super::Foundation:: KDPC, deferredroutine : super::super::Foundation:: PKDEFERRED_ROUTINE, deferredcontext : *const ::core::ffi::c_void));
    KeInitializeThreadedDpc(dpc, deferredroutine, ::core::mem::transmute(deferredcontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeTimer(timer: *mut KTIMER) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeTimer(timer : *mut KTIMER));
    KeInitializeTimer(timer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInitializeTimerEx(timer: *mut KTIMER, r#type: super::super::super::Win32::System::Kernel::TIMER_TYPE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeTimerEx(timer : *mut KTIMER, r#type : super::super::super::Win32::System::Kernel:: TIMER_TYPE));
    KeInitializeTimerEx(timer, r#type)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeInitializeTriageDumpDataArray(ktriagedumpdataarray: *mut KTRIAGE_DUMP_DATA_ARRAY, size: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInitializeTriageDumpDataArray(ktriagedumpdataarray : *mut KTRIAGE_DUMP_DATA_ARRAY, size : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeInitializeTriageDumpDataArray(ktriagedumpdataarray, size)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInsertByKeyDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, devicequeueentry: *mut KDEVICE_QUEUE_ENTRY, sortkey: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInsertByKeyDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, devicequeueentry : *mut KDEVICE_QUEUE_ENTRY, sortkey : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeInsertByKeyDeviceQueue(devicequeue, devicequeueentry, sortkey)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInsertDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, devicequeueentry: *mut KDEVICE_QUEUE_ENTRY) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInsertDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, devicequeueentry : *mut KDEVICE_QUEUE_ENTRY) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeInsertDeviceQueue(devicequeue, devicequeueentry)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeInsertQueueDpc(dpc: *mut super::super::Foundation::KDPC, systemargument1: ::core::option::Option<*const ::core::ffi::c_void>, systemargument2: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInsertQueueDpc(dpc : *mut super::super::Foundation:: KDPC, systemargument1 : *const ::core::ffi::c_void, systemargument2 : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeInsertQueueDpc(dpc, ::core::mem::transmute(systemargument1.unwrap_or(::std::ptr::null())), ::core::mem::transmute(systemargument2.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn KeInvalidateAllCaches() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInvalidateAllCaches() -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeInvalidateAllCaches()
}
#[inline]
pub unsafe fn KeInvalidateRangeAllCaches(baseaddress: *const ::core::ffi::c_void, length: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeInvalidateRangeAllCaches(baseaddress : *const ::core::ffi::c_void, length : u32));
    KeInvalidateRangeAllCaches(baseaddress, length)
}
#[inline]
pub unsafe fn KeIpiGenericCall(broadcastfunction: PKIPI_BROADCAST_WORKER, context: usize) -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeIpiGenericCall(broadcastfunction : PKIPI_BROADCAST_WORKER, context : usize) -> usize);
    KeIpiGenericCall(broadcastfunction, context)
}
#[inline]
pub unsafe fn KeIsExecutingDpc() -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeIsExecutingDpc() -> u32);
    KeIsExecutingDpc()
}
#[inline]
pub unsafe fn KeLeaveCriticalRegion() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeLeaveCriticalRegion());
    KeLeaveCriticalRegion()
}
#[inline]
pub unsafe fn KeLeaveGuardedRegion() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeLeaveGuardedRegion());
    KeLeaveGuardedRegion()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KePulseEvent<P0>(event: *mut super::super::Foundation::KEVENT, increment: i32, wait: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KePulseEvent(event : *mut super::super::Foundation:: KEVENT, increment : i32, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    KePulseEvent(event, increment, wait.into_param().abi())
}
#[inline]
pub unsafe fn KeQueryActiveGroupCount() -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryActiveGroupCount() -> u16);
    KeQueryActiveGroupCount()
}
#[inline]
pub unsafe fn KeQueryActiveProcessorCount(activeprocessors: ::core::option::Option<*mut usize>) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryActiveProcessorCount(activeprocessors : *mut usize) -> u32);
    KeQueryActiveProcessorCount(::core::mem::transmute(activeprocessors.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn KeQueryActiveProcessorCountEx(groupnumber: u16) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryActiveProcessorCountEx(groupnumber : u16) -> u32);
    KeQueryActiveProcessorCountEx(groupnumber)
}
#[inline]
pub unsafe fn KeQueryActiveProcessors() -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryActiveProcessors() -> usize);
    KeQueryActiveProcessors()
}
#[inline]
pub unsafe fn KeQueryAuxiliaryCounterFrequency(auxiliarycounterfrequency: ::core::option::Option<*mut u64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryAuxiliaryCounterFrequency(auxiliarycounterfrequency : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeQueryAuxiliaryCounterFrequency(::core::mem::transmute(auxiliarycounterfrequency.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn KeQueryDpcWatchdogInformation(watchdoginformation: *mut KDPC_WATCHDOG_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryDpcWatchdogInformation(watchdoginformation : *mut KDPC_WATCHDOG_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeQueryDpcWatchdogInformation(watchdoginformation)
}
#[inline]
pub unsafe fn KeQueryGroupAffinity(groupnumber: u16) -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryGroupAffinity(groupnumber : u16) -> usize);
    KeQueryGroupAffinity(groupnumber)
}
#[inline]
pub unsafe fn KeQueryHardwareCounterConfiguration(counterarray: &mut [HARDWARE_COUNTER], count: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryHardwareCounterConfiguration(counterarray : *mut HARDWARE_COUNTER, maximumcount : u32, count : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeQueryHardwareCounterConfiguration(::core::mem::transmute(counterarray.as_ptr()), counterarray.len().try_into().unwrap(), count)
}
#[inline]
pub unsafe fn KeQueryHighestNodeNumber() -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryHighestNodeNumber() -> u16);
    KeQueryHighestNodeNumber()
}
#[inline]
pub unsafe fn KeQueryInterruptTimePrecise(qpctimestamp: *mut u64) -> u64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryInterruptTimePrecise(qpctimestamp : *mut u64) -> u64);
    KeQueryInterruptTimePrecise(qpctimestamp)
}
#[cfg(all(feature = "Win32_System_Kernel", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn KeQueryLogicalProcessorRelationship(processornumber: ::core::option::Option<*const super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER>, relationshiptype: super::super::super::Win32::System::SystemInformation::LOGICAL_PROCESSOR_RELATIONSHIP, information: ::core::option::Option<*mut super::super::super::Win32::System::SystemInformation::SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX>, length: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryLogicalProcessorRelationship(processornumber : *const super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER, relationshiptype : super::super::super::Win32::System::SystemInformation:: LOGICAL_PROCESSOR_RELATIONSHIP, information : *mut super::super::super::Win32::System::SystemInformation:: SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX, length : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeQueryLogicalProcessorRelationship(::core::mem::transmute(processornumber.unwrap_or(::std::ptr::null())), relationshiptype, ::core::mem::transmute(information.unwrap_or(::std::ptr::null_mut())), length)
}
#[inline]
pub unsafe fn KeQueryMaximumGroupCount() -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryMaximumGroupCount() -> u16);
    KeQueryMaximumGroupCount()
}
#[inline]
pub unsafe fn KeQueryMaximumProcessorCount() -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryMaximumProcessorCount() -> u32);
    KeQueryMaximumProcessorCount()
}
#[inline]
pub unsafe fn KeQueryMaximumProcessorCountEx(groupnumber: u16) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryMaximumProcessorCountEx(groupnumber : u16) -> u32);
    KeQueryMaximumProcessorCountEx(groupnumber)
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeQueryNodeActiveAffinity(nodenumber: u16, affinity: ::core::option::Option<*mut super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY>, count: ::core::option::Option<*mut u16>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryNodeActiveAffinity(nodenumber : u16, affinity : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, count : *mut u16));
    KeQueryNodeActiveAffinity(nodenumber, ::core::mem::transmute(affinity.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(count.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeQueryNodeActiveAffinity2(nodenumber: u16, groupaffinities: ::core::option::Option<&mut [super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY]>, groupaffinitiesrequired: *mut u16) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryNodeActiveAffinity2(nodenumber : u16, groupaffinities : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, groupaffinitiescount : u16, groupaffinitiesrequired : *mut u16) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeQueryNodeActiveAffinity2(nodenumber, ::core::mem::transmute(groupaffinities.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), groupaffinities.as_deref().map_or(0, |slice| slice.len().try_into().unwrap()), groupaffinitiesrequired)
}
#[inline]
pub unsafe fn KeQueryNodeActiveProcessorCount(nodenumber: u16) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryNodeActiveProcessorCount(nodenumber : u16) -> u32);
    KeQueryNodeActiveProcessorCount(nodenumber)
}
#[inline]
pub unsafe fn KeQueryNodeMaximumProcessorCount(nodenumber: u16) -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryNodeMaximumProcessorCount(nodenumber : u16) -> u16);
    KeQueryNodeMaximumProcessorCount(nodenumber)
}
#[inline]
pub unsafe fn KeQueryPerformanceCounter(performancefrequency: ::core::option::Option<*mut i64>) -> i64 {
    ::windows_targets::link!("hal.dll" "system" fn KeQueryPerformanceCounter(performancefrequency : *mut i64) -> i64);
    KeQueryPerformanceCounter(::core::mem::transmute(performancefrequency.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeQueryPriorityThread<P0>(thread: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKTHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryPriorityThread(thread : super::super::Foundation:: PKTHREAD) -> i32);
    KeQueryPriorityThread(thread.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeQueryRuntimeThread<P0>(thread: P0, usertime: *mut u32) -> u32
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKTHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryRuntimeThread(thread : super::super::Foundation:: PKTHREAD, usertime : *mut u32) -> u32);
    KeQueryRuntimeThread(thread.into_param().abi(), usertime)
}
#[inline]
pub unsafe fn KeQuerySystemTimePrecise() -> i64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQuerySystemTimePrecise(currenttime : *mut i64));
    let mut result__ = ::std::mem::zeroed();
    KeQuerySystemTimePrecise(&mut result__);
    result__
}
#[inline]
pub unsafe fn KeQueryTimeIncrement() -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryTimeIncrement() -> u32);
    KeQueryTimeIncrement()
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeQueryTotalCycleTimeThread<P0>(thread: P0, cycletimestamp: *mut u64) -> u64
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKTHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryTotalCycleTimeThread(thread : super::super::Foundation:: PKTHREAD, cycletimestamp : *mut u64) -> u64);
    KeQueryTotalCycleTimeThread(thread.into_param().abi(), cycletimestamp)
}
#[inline]
pub unsafe fn KeQueryUnbiasedInterruptTime() -> u64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryUnbiasedInterruptTime() -> u64);
    KeQueryUnbiasedInterruptTime()
}
#[inline]
pub unsafe fn KeQueryUnbiasedInterruptTimePrecise(qpctimestamp: *mut u64) -> u64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeQueryUnbiasedInterruptTimePrecise(qpctimestamp : *mut u64) -> u64);
    KeQueryUnbiasedInterruptTimePrecise(qpctimestamp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateEvent(event: *const super::super::Foundation::KEVENT) -> i32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReadStateEvent(event : *const super::super::Foundation:: KEVENT) -> i32);
    KeReadStateEvent(event)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateMutex(mutex: *const super::super::Foundation::KMUTANT) -> i32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReadStateMutex(mutex : *const super::super::Foundation:: KMUTANT) -> i32);
    KeReadStateMutex(mutex)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateSemaphore(semaphore: *const KSEMAPHORE) -> i32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReadStateSemaphore(semaphore : *const KSEMAPHORE) -> i32);
    KeReadStateSemaphore(semaphore)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReadStateTimer(timer: *const KTIMER) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReadStateTimer(timer : *const KTIMER) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeReadStateTimer(timer)
}
#[inline]
pub unsafe fn KeRegisterBoundCallback(callbackroutine: PBOUND_CALLBACK) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRegisterBoundCallback(callbackroutine : PBOUND_CALLBACK) -> *mut ::core::ffi::c_void);
    KeRegisterBoundCallback(callbackroutine)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeRegisterBugCheckCallback(callbackrecord: *mut KBUGCHECK_CALLBACK_RECORD, callbackroutine: PKBUGCHECK_CALLBACK_ROUTINE, buffer: ::core::option::Option<*const ::core::ffi::c_void>, length: u32, component: *const u8) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRegisterBugCheckCallback(callbackrecord : *mut KBUGCHECK_CALLBACK_RECORD, callbackroutine : PKBUGCHECK_CALLBACK_ROUTINE, buffer : *const ::core::ffi::c_void, length : u32, component : *const u8) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeRegisterBugCheckCallback(callbackrecord, callbackroutine, ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null())), length, component)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn KeRegisterBugCheckReasonCallback(callbackrecord: *mut KBUGCHECK_REASON_CALLBACK_RECORD, callbackroutine: PKBUGCHECK_REASON_CALLBACK_ROUTINE, reason: KBUGCHECK_CALLBACK_REASON, component: *const u8) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRegisterBugCheckReasonCallback(callbackrecord : *mut KBUGCHECK_REASON_CALLBACK_RECORD, callbackroutine : PKBUGCHECK_REASON_CALLBACK_ROUTINE, reason : KBUGCHECK_CALLBACK_REASON, component : *const u8) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeRegisterBugCheckReasonCallback(callbackrecord, callbackroutine, reason, component)
}
#[inline]
pub unsafe fn KeRegisterNmiCallback(callbackroutine: PNMI_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRegisterNmiCallback(callbackroutine : PNMI_CALLBACK, context : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    KeRegisterNmiCallback(callbackroutine, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn KeRegisterProcessorChangeCallback(callbackfunction: PPROCESSOR_CALLBACK_FUNCTION, callbackcontext: ::core::option::Option<*const ::core::ffi::c_void>, flags: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRegisterProcessorChangeCallback(callbackfunction : PPROCESSOR_CALLBACK_FUNCTION, callbackcontext : *const ::core::ffi::c_void, flags : u32) -> *mut ::core::ffi::c_void);
    KeRegisterProcessorChangeCallback(callbackfunction, ::core::mem::transmute(callbackcontext.unwrap_or(::std::ptr::null())), flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX));
    KeReleaseGuardedMutex(mutex)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseGuardedMutexUnsafe(fastmutex: *mut super::super::Foundation::FAST_MUTEX) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseGuardedMutexUnsafe(fastmutex : *mut super::super::Foundation:: FAST_MUTEX));
    KeReleaseGuardedMutexUnsafe(fastmutex)
}
#[inline]
pub unsafe fn KeReleaseInStackQueuedSpinLock(lockhandle: *const KLOCK_QUEUE_HANDLE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseInStackQueuedSpinLock(lockhandle : *const KLOCK_QUEUE_HANDLE));
    KeReleaseInStackQueuedSpinLock(lockhandle)
}
#[inline]
pub unsafe fn KeReleaseInStackQueuedSpinLockForDpc(lockhandle: *const KLOCK_QUEUE_HANDLE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseInStackQueuedSpinLockForDpc(lockhandle : *const KLOCK_QUEUE_HANDLE));
    KeReleaseInStackQueuedSpinLockForDpc(lockhandle)
}
#[inline]
pub unsafe fn KeReleaseInStackQueuedSpinLockFromDpcLevel(lockhandle: *const KLOCK_QUEUE_HANDLE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseInStackQueuedSpinLockFromDpcLevel(lockhandle : *const KLOCK_QUEUE_HANDLE));
    KeReleaseInStackQueuedSpinLockFromDpcLevel(lockhandle)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeReleaseInterruptSpinLock<P0>(interrupt: P0, oldirql: u8)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKINTERRUPT>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseInterruptSpinLock(interrupt : super::super::Foundation:: PKINTERRUPT, oldirql : u8));
    KeReleaseInterruptSpinLock(interrupt.into_param().abi(), oldirql)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseMutex<P0>(mutex: *mut super::super::Foundation::KMUTANT, wait: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseMutex(mutex : *mut super::super::Foundation:: KMUTANT, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    KeReleaseMutex(mutex, wait.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeReleaseSemaphore<P0>(semaphore: *mut KSEMAPHORE, increment: i32, adjustment: i32, wait: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseSemaphore(semaphore : *mut KSEMAPHORE, increment : i32, adjustment : i32, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    KeReleaseSemaphore(semaphore, increment, adjustment, wait.into_param().abi())
}
#[inline]
pub unsafe fn KeReleaseSpinLockForDpc(spinlock: *mut usize, oldirql: u8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeReleaseSpinLockForDpc(spinlock : *mut usize, oldirql : u8));
    KeReleaseSpinLockForDpc(spinlock, oldirql)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveByKeyDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, sortkey: u32) -> *mut KDEVICE_QUEUE_ENTRY {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRemoveByKeyDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, sortkey : u32) -> *mut KDEVICE_QUEUE_ENTRY);
    KeRemoveByKeyDeviceQueue(devicequeue, sortkey)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveByKeyDeviceQueueIfBusy(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, sortkey: u32) -> *mut KDEVICE_QUEUE_ENTRY {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRemoveByKeyDeviceQueueIfBusy(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, sortkey : u32) -> *mut KDEVICE_QUEUE_ENTRY);
    KeRemoveByKeyDeviceQueueIfBusy(devicequeue, sortkey)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE) -> *mut KDEVICE_QUEUE_ENTRY {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRemoveDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE) -> *mut KDEVICE_QUEUE_ENTRY);
    KeRemoveDeviceQueue(devicequeue)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveEntryDeviceQueue(devicequeue: *mut super::super::Foundation::KDEVICE_QUEUE, devicequeueentry: *mut KDEVICE_QUEUE_ENTRY) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRemoveEntryDeviceQueue(devicequeue : *mut super::super::Foundation:: KDEVICE_QUEUE, devicequeueentry : *mut KDEVICE_QUEUE_ENTRY) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeRemoveEntryDeviceQueue(devicequeue, devicequeueentry)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveQueueDpc(dpc: *mut super::super::Foundation::KDPC) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRemoveQueueDpc(dpc : *mut super::super::Foundation:: KDPC) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeRemoveQueueDpc(dpc)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeRemoveQueueDpcEx<P0>(dpc: *mut super::super::Foundation::KDPC, waitifactive: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRemoveQueueDpcEx(dpc : *mut super::super::Foundation:: KDPC, waitifactive : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeRemoveQueueDpcEx(dpc, waitifactive.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeResetEvent(event: *mut super::super::Foundation::KEVENT) -> i32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeResetEvent(event : *mut super::super::Foundation:: KEVENT) -> i32);
    KeResetEvent(event)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeRestoreExtendedProcessorState(xstatesave: *const XSTATE_SAVE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRestoreExtendedProcessorState(xstatesave : *const XSTATE_SAVE));
    KeRestoreExtendedProcessorState(xstatesave)
}
#[inline]
pub unsafe fn KeRevertToUserAffinityThread() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRevertToUserAffinityThread());
    KeRevertToUserAffinityThread()
}
#[inline]
pub unsafe fn KeRevertToUserAffinityThreadEx(affinity: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRevertToUserAffinityThreadEx(affinity : usize));
    KeRevertToUserAffinityThreadEx(affinity)
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeRevertToUserGroupAffinityThread(previousaffinity: *const super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeRevertToUserGroupAffinityThread(previousaffinity : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY));
    KeRevertToUserGroupAffinityThread(previousaffinity)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn KeSaveExtendedProcessorState(mask: u64, xstatesave: *mut XSTATE_SAVE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSaveExtendedProcessorState(mask : u64, xstatesave : *mut XSTATE_SAVE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeSaveExtendedProcessorState(mask, xstatesave)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeSetBasePriorityThread<P0>(thread: P0, increment: i32) -> i32
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKTHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetBasePriorityThread(thread : super::super::Foundation:: PKTHREAD, increment : i32) -> i32);
    KeSetBasePriorityThread(thread.into_param().abi(), increment)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetCoalescableTimer(timer: *mut KTIMER, duetime: i64, period: u32, tolerabledelay: u32, dpc: ::core::option::Option<*const super::super::Foundation::KDPC>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetCoalescableTimer(timer : *mut KTIMER, duetime : i64, period : u32, tolerabledelay : u32, dpc : *const super::super::Foundation:: KDPC) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeSetCoalescableTimer(timer, duetime, period, tolerabledelay, ::core::mem::transmute(dpc.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetEvent<P0>(event: *mut super::super::Foundation::KEVENT, increment: i32, wait: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetEvent(event : *mut super::super::Foundation:: KEVENT, increment : i32, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    KeSetEvent(event, increment, wait.into_param().abi())
}
#[inline]
pub unsafe fn KeSetHardwareCounterConfiguration(counterarray: &[HARDWARE_COUNTER]) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetHardwareCounterConfiguration(counterarray : *const HARDWARE_COUNTER, count : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeSetHardwareCounterConfiguration(::core::mem::transmute(counterarray.as_ptr()), counterarray.len().try_into().unwrap())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetImportanceDpc(dpc: *mut super::super::Foundation::KDPC, importance: KDPC_IMPORTANCE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetImportanceDpc(dpc : *mut super::super::Foundation:: KDPC, importance : KDPC_IMPORTANCE));
    KeSetImportanceDpc(dpc, importance)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeSetPriorityThread<P0>(thread: P0, priority: i32) -> i32
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKTHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetPriorityThread(thread : super::super::Foundation:: PKTHREAD, priority : i32) -> i32);
    KeSetPriorityThread(thread.into_param().abi(), priority)
}
#[inline]
pub unsafe fn KeSetSystemAffinityThread(affinity: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetSystemAffinityThread(affinity : usize));
    KeSetSystemAffinityThread(affinity)
}
#[inline]
pub unsafe fn KeSetSystemAffinityThreadEx(affinity: usize) -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetSystemAffinityThreadEx(affinity : usize) -> usize);
    KeSetSystemAffinityThreadEx(affinity)
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn KeSetSystemGroupAffinityThread(affinity: *const super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY, previousaffinity: ::core::option::Option<*mut super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY>) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetSystemGroupAffinityThread(affinity : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, previousaffinity : *mut super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY));
    KeSetSystemGroupAffinityThread(affinity, ::core::mem::transmute(previousaffinity.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTargetProcessorDpc(dpc: *mut super::super::Foundation::KDPC, number: i8) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetTargetProcessorDpc(dpc : *mut super::super::Foundation:: KDPC, number : i8));
    KeSetTargetProcessorDpc(dpc, number)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTargetProcessorDpcEx(dpc: *mut super::super::Foundation::KDPC, procnumber: *const super::super::super::Win32::System::Kernel::PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetTargetProcessorDpcEx(dpc : *mut super::super::Foundation:: KDPC, procnumber : *const super::super::super::Win32::System::Kernel:: PROCESSOR_NUMBER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeSetTargetProcessorDpcEx(dpc, procnumber)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTimer(timer: *mut KTIMER, duetime: i64, dpc: ::core::option::Option<*const super::super::Foundation::KDPC>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetTimer(timer : *mut KTIMER, duetime : i64, dpc : *const super::super::Foundation:: KDPC) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeSetTimer(timer, duetime, ::core::mem::transmute(dpc.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeSetTimerEx(timer: *mut KTIMER, duetime: i64, period: i32, dpc: ::core::option::Option<*const super::super::Foundation::KDPC>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSetTimerEx(timer : *mut KTIMER, duetime : i64, period : i32, dpc : *const super::super::Foundation:: KDPC) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeSetTimerEx(timer, duetime, period, ::core::mem::transmute(dpc.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn KeShouldYieldProcessor() -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeShouldYieldProcessor() -> u32);
    KeShouldYieldProcessor()
}
#[inline]
pub unsafe fn KeStallExecutionProcessor(microseconds: u32) {
    ::windows_targets::link!("hal.dll" "system" fn KeStallExecutionProcessor(microseconds : u32));
    KeStallExecutionProcessor(microseconds)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn KeSynchronizeExecution<P0>(interrupt: P0, synchronizeroutine: PKSYNCHRONIZE_ROUTINE, synchronizecontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PKINTERRUPT>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeSynchronizeExecution(interrupt : super::super::Foundation:: PKINTERRUPT, synchronizeroutine : PKSYNCHRONIZE_ROUTINE, synchronizecontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeSynchronizeExecution(interrupt.into_param().abi(), synchronizeroutine, ::core::mem::transmute(synchronizecontext.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn KeTestSpinLock(spinlock: *const usize) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeTestSpinLock(spinlock : *const usize) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeTestSpinLock(spinlock)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeTryToAcquireGuardedMutex(mutex: *mut super::super::Foundation::FAST_MUTEX) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeTryToAcquireGuardedMutex(mutex : *mut super::super::Foundation:: FAST_MUTEX) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeTryToAcquireGuardedMutex(mutex)
}
#[inline]
pub unsafe fn KeTryToAcquireSpinLockAtDpcLevel(spinlock: *mut usize) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeTryToAcquireSpinLockAtDpcLevel(spinlock : *mut usize) -> super::super::super::Win32::Foundation:: BOOLEAN);
    KeTryToAcquireSpinLockAtDpcLevel(spinlock)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn KeWaitForMultipleObjects<P0>(object: &[*const ::core::ffi::c_void], waittype: super::super::super::Win32::System::Kernel::WAIT_TYPE, waitreason: KWAIT_REASON, waitmode: i8, alertable: P0, timeout: ::core::option::Option<*const i64>, waitblockarray: ::core::option::Option<*mut super::super::Foundation::KWAIT_BLOCK>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeWaitForMultipleObjects(count : u32, object : *const *const ::core::ffi::c_void, waittype : super::super::super::Win32::System::Kernel:: WAIT_TYPE, waitreason : KWAIT_REASON, waitmode : i8, alertable : super::super::super::Win32::Foundation:: BOOLEAN, timeout : *const i64, waitblockarray : *mut super::super::Foundation:: KWAIT_BLOCK) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeWaitForMultipleObjects(object.len().try_into().unwrap(), ::core::mem::transmute(object.as_ptr()), waittype, waitreason, waitmode, alertable.into_param().abi(), ::core::mem::transmute(timeout.unwrap_or(::std::ptr::null())), ::core::mem::transmute(waitblockarray.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn KeWaitForSingleObject<P0>(object: *const ::core::ffi::c_void, waitreason: KWAIT_REASON, waitmode: i8, alertable: P0, timeout: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KeWaitForSingleObject(object : *const ::core::ffi::c_void, waitreason : KWAIT_REASON, waitmode : i8, alertable : super::super::super::Win32::Foundation:: BOOLEAN, timeout : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    KeWaitForSingleObject(object, waitreason, waitmode, alertable.into_param().abi(), ::core::mem::transmute(timeout.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn KfRaiseIrql(newirql: u8) -> u8 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn KfRaiseIrql(newirql : u8) -> u8);
    KfRaiseIrql(newirql)
}
#[inline]
pub unsafe fn MmAddPhysicalMemory(startaddress: *const i64, numberofbytes: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAddPhysicalMemory(startaddress : *const i64, numberofbytes : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmAddPhysicalMemory(startaddress, numberofbytes)
}
#[inline]
pub unsafe fn MmAddVerifierSpecialThunks(entryroutine: usize, thunkbuffer: *const ::core::ffi::c_void, thunkbuffersize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAddVerifierSpecialThunks(entryroutine : usize, thunkbuffer : *const ::core::ffi::c_void, thunkbuffersize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmAddVerifierSpecialThunks(entryroutine, thunkbuffer, thunkbuffersize)
}
#[inline]
pub unsafe fn MmAddVerifierThunks(thunkbuffer: *const ::core::ffi::c_void, thunkbuffersize: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAddVerifierThunks(thunkbuffer : *const ::core::ffi::c_void, thunkbuffersize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmAddVerifierThunks(thunkbuffer, thunkbuffersize)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAdvanceMdl(mdl: *mut super::super::Foundation::MDL, numberofbytes: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAdvanceMdl(mdl : *mut super::super::Foundation:: MDL, numberofbytes : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmAdvanceMdl(mdl, numberofbytes)
}
#[inline]
pub unsafe fn MmAllocateContiguousMemory(numberofbytes: usize, highestacceptableaddress: i64) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemory(numberofbytes : usize, highestacceptableaddress : i64) -> *mut ::core::ffi::c_void);
    MmAllocateContiguousMemory(numberofbytes, highestacceptableaddress)
}
#[inline]
pub unsafe fn MmAllocateContiguousMemoryEx(numberofbytes: *const usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: i64, preferrednode: u32, protect: u32, partitionobject: ::core::option::Option<*const ::core::ffi::c_void>, tag: u32, flags: u32, baseaddress: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemoryEx(numberofbytes : *const usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, preferrednode : u32, protect : u32, partitionobject : *const ::core::ffi::c_void, tag : u32, flags : u32, baseaddress : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmAllocateContiguousMemoryEx(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple, preferrednode, protect, ::core::mem::transmute(partitionobject.unwrap_or(::std::ptr::null())), tag, flags, baseaddress)
}
#[inline]
pub unsafe fn MmAllocateContiguousMemorySpecifyCache(numberofbytes: usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: i64, cachetype: MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemorySpecifyCache(numberofbytes : usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, cachetype : MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void);
    MmAllocateContiguousMemorySpecifyCache(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple, cachetype)
}
#[inline]
pub unsafe fn MmAllocateContiguousMemorySpecifyCacheNode(numberofbytes: usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: i64, cachetype: MEMORY_CACHING_TYPE, preferrednode: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousMemorySpecifyCacheNode(numberofbytes : usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, cachetype : MEMORY_CACHING_TYPE, preferrednode : u32) -> *mut ::core::ffi::c_void);
    MmAllocateContiguousMemorySpecifyCacheNode(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple, cachetype, preferrednode)
}
#[inline]
pub unsafe fn MmAllocateContiguousNodeMemory(numberofbytes: usize, lowestacceptableaddress: i64, highestacceptableaddress: i64, boundaryaddressmultiple: i64, protect: u32, preferrednode: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateContiguousNodeMemory(numberofbytes : usize, lowestacceptableaddress : i64, highestacceptableaddress : i64, boundaryaddressmultiple : i64, protect : u32, preferrednode : u32) -> *mut ::core::ffi::c_void);
    MmAllocateContiguousNodeMemory(numberofbytes, lowestacceptableaddress, highestacceptableaddress, boundaryaddressmultiple, protect, preferrednode)
}
#[inline]
pub unsafe fn MmAllocateMappingAddress(numberofbytes: usize, pooltag: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateMappingAddress(numberofbytes : usize, pooltag : u32) -> *mut ::core::ffi::c_void);
    MmAllocateMappingAddress(numberofbytes, pooltag)
}
#[inline]
pub unsafe fn MmAllocateMappingAddressEx(numberofbytes: usize, pooltag: u32, flags: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateMappingAddressEx(numberofbytes : usize, pooltag : u32, flags : u32) -> *mut ::core::ffi::c_void);
    MmAllocateMappingAddressEx(numberofbytes, pooltag, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocateMdlForIoSpace(physicaladdresslist: &[MM_PHYSICAL_ADDRESS_LIST], newmdl: *mut *mut super::super::Foundation::MDL) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateMdlForIoSpace(physicaladdresslist : *const MM_PHYSICAL_ADDRESS_LIST, numberofentries : usize, newmdl : *mut *mut super::super::Foundation:: MDL) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmAllocateMdlForIoSpace(::core::mem::transmute(physicaladdresslist.as_ptr()), physicaladdresslist.len().try_into().unwrap(), newmdl)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocateNodePagesForMdlEx(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize, cachetype: MEMORY_CACHING_TYPE, idealnode: u32, flags: u32) -> *mut super::super::Foundation::MDL {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateNodePagesForMdlEx(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize, cachetype : MEMORY_CACHING_TYPE, idealnode : u32, flags : u32) -> *mut super::super::Foundation:: MDL);
    MmAllocateNodePagesForMdlEx(lowaddress, highaddress, skipbytes, totalbytes, cachetype, idealnode, flags)
}
#[inline]
pub unsafe fn MmAllocateNonCachedMemory(numberofbytes: usize) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocateNonCachedMemory(numberofbytes : usize) -> *mut ::core::ffi::c_void);
    MmAllocateNonCachedMemory(numberofbytes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocatePagesForMdl(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize) -> *mut super::super::Foundation::MDL {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocatePagesForMdl(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize) -> *mut super::super::Foundation:: MDL);
    MmAllocatePagesForMdl(lowaddress, highaddress, skipbytes, totalbytes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocatePagesForMdlEx(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize, cachetype: MEMORY_CACHING_TYPE, flags: u32) -> *mut super::super::Foundation::MDL {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocatePagesForMdlEx(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize, cachetype : MEMORY_CACHING_TYPE, flags : u32) -> *mut super::super::Foundation:: MDL);
    MmAllocatePagesForMdlEx(lowaddress, highaddress, skipbytes, totalbytes, cachetype, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAllocatePartitionNodePagesForMdlEx(lowaddress: i64, highaddress: i64, skipbytes: i64, totalbytes: usize, cachetype: MEMORY_CACHING_TYPE, idealnode: u32, flags: u32, partitionobject: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut super::super::Foundation::MDL {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAllocatePartitionNodePagesForMdlEx(lowaddress : i64, highaddress : i64, skipbytes : i64, totalbytes : usize, cachetype : MEMORY_CACHING_TYPE, idealnode : u32, flags : u32, partitionobject : *const ::core::ffi::c_void) -> *mut super::super::Foundation:: MDL);
    MmAllocatePartitionNodePagesForMdlEx(lowaddress, highaddress, skipbytes, totalbytes, cachetype, idealnode, flags, ::core::mem::transmute(partitionobject.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmAreMdlPagesCached(memorydescriptorlist: *const super::super::Foundation::MDL) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmAreMdlPagesCached(memorydescriptorlist : *const super::super::Foundation:: MDL) -> u32);
    MmAreMdlPagesCached(memorydescriptorlist)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmBuildMdlForNonPagedPool(memorydescriptorlist: *mut super::super::Foundation::MDL) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmBuildMdlForNonPagedPool(memorydescriptorlist : *mut super::super::Foundation:: MDL));
    MmBuildMdlForNonPagedPool(memorydescriptorlist)
}
#[inline]
pub unsafe fn MmCopyMemory(targetaddress: *const ::core::ffi::c_void, sourceaddress: MM_COPY_ADDRESS, numberofbytes: usize, flags: u32, numberofbytestransferred: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmCopyMemory(targetaddress : *const ::core::ffi::c_void, sourceaddress : MM_COPY_ADDRESS, numberofbytes : usize, flags : u32, numberofbytestransferred : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmCopyMemory(targetaddress, ::core::mem::transmute(sourceaddress), numberofbytes, flags, numberofbytestransferred)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmCreateMdl(memorydescriptorlist: ::core::option::Option<*mut super::super::Foundation::MDL>, base: ::core::option::Option<*const ::core::ffi::c_void>, length: usize) -> *mut super::super::Foundation::MDL {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmCreateMdl(memorydescriptorlist : *mut super::super::Foundation:: MDL, base : *const ::core::ffi::c_void, length : usize) -> *mut super::super::Foundation:: MDL);
    MmCreateMdl(::core::mem::transmute(memorydescriptorlist.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(base.unwrap_or(::std::ptr::null())), length)
}
#[inline]
pub unsafe fn MmCreateMirror() -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmCreateMirror() -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmCreateMirror()
}
#[inline]
pub unsafe fn MmFreeContiguousMemory(baseaddress: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmFreeContiguousMemory(baseaddress : *const ::core::ffi::c_void));
    MmFreeContiguousMemory(baseaddress)
}
#[inline]
pub unsafe fn MmFreeContiguousMemorySpecifyCache(baseaddress: *const ::core::ffi::c_void, numberofbytes: usize, cachetype: MEMORY_CACHING_TYPE) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmFreeContiguousMemorySpecifyCache(baseaddress : *const ::core::ffi::c_void, numberofbytes : usize, cachetype : MEMORY_CACHING_TYPE));
    MmFreeContiguousMemorySpecifyCache(baseaddress, numberofbytes, cachetype)
}
#[inline]
pub unsafe fn MmFreeMappingAddress(baseaddress: *const ::core::ffi::c_void, pooltag: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmFreeMappingAddress(baseaddress : *const ::core::ffi::c_void, pooltag : u32));
    MmFreeMappingAddress(baseaddress, pooltag)
}
#[inline]
pub unsafe fn MmFreeNonCachedMemory(baseaddress: *const ::core::ffi::c_void, numberofbytes: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmFreeNonCachedMemory(baseaddress : *const ::core::ffi::c_void, numberofbytes : usize));
    MmFreeNonCachedMemory(baseaddress, numberofbytes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmFreePagesFromMdl(memorydescriptorlist: *mut super::super::Foundation::MDL) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmFreePagesFromMdl(memorydescriptorlist : *mut super::super::Foundation:: MDL));
    MmFreePagesFromMdl(memorydescriptorlist)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmFreePagesFromMdlEx(memorydescriptorlist: *mut super::super::Foundation::MDL, flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmFreePagesFromMdlEx(memorydescriptorlist : *mut super::super::Foundation:: MDL, flags : u32));
    MmFreePagesFromMdlEx(memorydescriptorlist, flags)
}
#[inline]
pub unsafe fn MmGetCacheAttribute(physicaladdress: i64, cachetype: *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetCacheAttribute(physicaladdress : i64, cachetype : *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmGetCacheAttribute(physicaladdress, cachetype)
}
#[inline]
pub unsafe fn MmGetCacheAttributeEx(physicaladdress: i64, flags: u32, cachetype: *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetCacheAttributeEx(physicaladdress : i64, flags : u32, cachetype : *mut MEMORY_CACHING_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmGetCacheAttributeEx(physicaladdress, flags, cachetype)
}
#[inline]
pub unsafe fn MmGetPhysicalAddress(baseaddress: *const ::core::ffi::c_void) -> i64 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetPhysicalAddress(baseaddress : *const ::core::ffi::c_void) -> i64);
    MmGetPhysicalAddress(baseaddress)
}
#[inline]
pub unsafe fn MmGetPhysicalMemoryRanges() -> *mut PHYSICAL_MEMORY_RANGE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetPhysicalMemoryRanges() -> *mut PHYSICAL_MEMORY_RANGE);
    MmGetPhysicalMemoryRanges()
}
#[inline]
pub unsafe fn MmGetPhysicalMemoryRangesEx(partitionobject: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut PHYSICAL_MEMORY_RANGE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetPhysicalMemoryRangesEx(partitionobject : *const ::core::ffi::c_void) -> *mut PHYSICAL_MEMORY_RANGE);
    MmGetPhysicalMemoryRangesEx(::core::mem::transmute(partitionobject.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn MmGetPhysicalMemoryRangesEx2(partitionobject: ::core::option::Option<*const ::core::ffi::c_void>, flags: u32) -> *mut PHYSICAL_MEMORY_RANGE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetPhysicalMemoryRangesEx2(partitionobject : *const ::core::ffi::c_void, flags : u32) -> *mut PHYSICAL_MEMORY_RANGE);
    MmGetPhysicalMemoryRangesEx2(::core::mem::transmute(partitionobject.unwrap_or(::std::ptr::null())), flags)
}
#[inline]
pub unsafe fn MmGetSystemRoutineAddress(systemroutinename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetSystemRoutineAddress(systemroutinename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> *mut ::core::ffi::c_void);
    MmGetSystemRoutineAddress(systemroutinename)
}
#[inline]
pub unsafe fn MmGetVirtualForPhysical(physicaladdress: i64) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmGetVirtualForPhysical(physicaladdress : i64) -> *mut ::core::ffi::c_void);
    MmGetVirtualForPhysical(physicaladdress)
}
#[inline]
pub unsafe fn MmIsAddressValid(virtualaddress: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsAddressValid(virtualaddress : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    MmIsAddressValid(virtualaddress)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn MmIsDriverSuspectForVerifier(driverobject: *const super::super::Foundation::DRIVER_OBJECT) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsDriverSuspectForVerifier(driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> u32);
    MmIsDriverSuspectForVerifier(driverobject)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn MmIsDriverVerifying(driverobject: *const super::super::Foundation::DRIVER_OBJECT) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsDriverVerifying(driverobject : *const super::super::Foundation:: DRIVER_OBJECT) -> u32);
    MmIsDriverVerifying(driverobject)
}
#[inline]
pub unsafe fn MmIsDriverVerifyingByAddress(addresswithinsection: *const ::core::ffi::c_void) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsDriverVerifyingByAddress(addresswithinsection : *const ::core::ffi::c_void) -> u32);
    MmIsDriverVerifyingByAddress(addresswithinsection)
}
#[inline]
pub unsafe fn MmIsIoSpaceActive(startaddress: i64, numberofbytes: usize) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsIoSpaceActive(startaddress : i64, numberofbytes : usize) -> u32);
    MmIsIoSpaceActive(startaddress, numberofbytes)
}
#[inline]
pub unsafe fn MmIsNonPagedSystemAddressValid(virtualaddress: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsNonPagedSystemAddressValid(virtualaddress : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    MmIsNonPagedSystemAddressValid(virtualaddress)
}
#[inline]
pub unsafe fn MmIsThisAnNtAsSystem() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsThisAnNtAsSystem() -> super::super::super::Win32::Foundation:: BOOLEAN);
    MmIsThisAnNtAsSystem()
}
#[inline]
pub unsafe fn MmIsVerifierEnabled(verifierflags: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmIsVerifierEnabled(verifierflags : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmIsVerifierEnabled(verifierflags)
}
#[inline]
pub unsafe fn MmLockPagableDataSection(addresswithinsection: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmLockPagableDataSection(addresswithinsection : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    MmLockPagableDataSection(addresswithinsection)
}
#[inline]
pub unsafe fn MmLockPagableSectionByHandle(imagesectionhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmLockPagableSectionByHandle(imagesectionhandle : *const ::core::ffi::c_void));
    MmLockPagableSectionByHandle(imagesectionhandle)
}
#[inline]
pub unsafe fn MmMapIoSpace(physicaladdress: i64, numberofbytes: usize, cachetype: MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapIoSpace(physicaladdress : i64, numberofbytes : usize, cachetype : MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void);
    MmMapIoSpace(physicaladdress, numberofbytes, cachetype)
}
#[inline]
pub unsafe fn MmMapIoSpaceEx(physicaladdress: i64, numberofbytes: usize, protect: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapIoSpaceEx(physicaladdress : i64, numberofbytes : usize, protect : u32) -> *mut ::core::ffi::c_void);
    MmMapIoSpaceEx(physicaladdress, numberofbytes, protect)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapLockedPages(memorydescriptorlist: *mut super::super::Foundation::MDL, accessmode: i8) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapLockedPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, accessmode : i8) -> *mut ::core::ffi::c_void);
    MmMapLockedPages(memorydescriptorlist, accessmode)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapLockedPagesSpecifyCache(memorydescriptorlist: *mut super::super::Foundation::MDL, accessmode: i8, cachetype: MEMORY_CACHING_TYPE, requestedaddress: ::core::option::Option<*const ::core::ffi::c_void>, bugcheckonfailure: u32, priority: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapLockedPagesSpecifyCache(memorydescriptorlist : *mut super::super::Foundation:: MDL, accessmode : i8, cachetype : MEMORY_CACHING_TYPE, requestedaddress : *const ::core::ffi::c_void, bugcheckonfailure : u32, priority : u32) -> *mut ::core::ffi::c_void);
    MmMapLockedPagesSpecifyCache(memorydescriptorlist, accessmode, cachetype, ::core::mem::transmute(requestedaddress.unwrap_or(::std::ptr::null())), bugcheckonfailure, priority)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapLockedPagesWithReservedMapping(mappingaddress: *const ::core::ffi::c_void, pooltag: u32, memorydescriptorlist: *mut super::super::Foundation::MDL, cachetype: MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapLockedPagesWithReservedMapping(mappingaddress : *const ::core::ffi::c_void, pooltag : u32, memorydescriptorlist : *mut super::super::Foundation:: MDL, cachetype : MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void);
    MmMapLockedPagesWithReservedMapping(mappingaddress, pooltag, memorydescriptorlist, cachetype)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapMdl(memorydescriptorlist: *mut super::super::Foundation::MDL, protection: u32, driverroutine: PMM_MDL_ROUTINE, drivercontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapMdl(memorydescriptorlist : *mut super::super::Foundation:: MDL, protection : u32, driverroutine : PMM_MDL_ROUTINE, drivercontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapMdl(memorydescriptorlist, protection, driverroutine, ::core::mem::transmute(drivercontext.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMapMemoryDumpMdlEx(va: *const ::core::ffi::c_void, pagetotal: u32, memorydumpmdl: *mut super::super::Foundation::MDL, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapMemoryDumpMdlEx(va : *const ::core::ffi::c_void, pagetotal : u32, memorydumpmdl : *mut super::super::Foundation:: MDL, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapMemoryDumpMdlEx(va, pagetotal, memorydumpmdl, flags)
}
#[inline]
pub unsafe fn MmMapUserAddressesToPage(baseaddress: *const ::core::ffi::c_void, numberofbytes: usize, pageaddress: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapUserAddressesToPage(baseaddress : *const ::core::ffi::c_void, numberofbytes : usize, pageaddress : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapUserAddressesToPage(baseaddress, numberofbytes, pageaddress)
}
#[inline]
pub unsafe fn MmMapVideoDisplay(physicaladdress: i64, numberofbytes: usize, cachetype: MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapVideoDisplay(physicaladdress : i64, numberofbytes : usize, cachetype : MEMORY_CACHING_TYPE) -> *mut ::core::ffi::c_void);
    MmMapVideoDisplay(physicaladdress, numberofbytes, cachetype)
}
#[inline]
pub unsafe fn MmMapViewInSessionSpace(section: *const ::core::ffi::c_void, mappedbase: *mut *mut ::core::ffi::c_void, viewsize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapViewInSessionSpace(section : *const ::core::ffi::c_void, mappedbase : *mut *mut ::core::ffi::c_void, viewsize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapViewInSessionSpace(section, mappedbase, viewsize)
}
#[inline]
pub unsafe fn MmMapViewInSessionSpaceEx(section: *const ::core::ffi::c_void, mappedbase: *mut *mut ::core::ffi::c_void, viewsize: *mut usize, sectionoffset: *mut i64, flags: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapViewInSessionSpaceEx(section : *const ::core::ffi::c_void, mappedbase : *mut *mut ::core::ffi::c_void, viewsize : *mut usize, sectionoffset : *mut i64, flags : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapViewInSessionSpaceEx(section, mappedbase, viewsize, sectionoffset, flags)
}
#[inline]
pub unsafe fn MmMapViewInSystemSpace(section: *const ::core::ffi::c_void, mappedbase: *mut *mut ::core::ffi::c_void, viewsize: *mut usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapViewInSystemSpace(section : *const ::core::ffi::c_void, mappedbase : *mut *mut ::core::ffi::c_void, viewsize : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapViewInSystemSpace(section, mappedbase, viewsize)
}
#[inline]
pub unsafe fn MmMapViewInSystemSpaceEx(section: *const ::core::ffi::c_void, mappedbase: *mut *mut ::core::ffi::c_void, viewsize: *mut usize, sectionoffset: *mut i64, flags: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMapViewInSystemSpaceEx(section : *const ::core::ffi::c_void, mappedbase : *mut *mut ::core::ffi::c_void, viewsize : *mut usize, sectionoffset : *mut i64, flags : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmMapViewInSystemSpaceEx(section, mappedbase, viewsize, sectionoffset, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmMdlPageContentsState(memorydescriptorlist: *mut super::super::Foundation::MDL, state: MM_MDL_PAGE_CONTENTS_STATE) -> MM_MDL_PAGE_CONTENTS_STATE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmMdlPageContentsState(memorydescriptorlist : *mut super::super::Foundation:: MDL, state : MM_MDL_PAGE_CONTENTS_STATE) -> MM_MDL_PAGE_CONTENTS_STATE);
    MmMdlPageContentsState(memorydescriptorlist, state)
}
#[inline]
pub unsafe fn MmPageEntireDriver(addresswithinsection: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmPageEntireDriver(addresswithinsection : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    MmPageEntireDriver(addresswithinsection)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmProbeAndLockPages(memorydescriptorlist: *mut super::super::Foundation::MDL, accessmode: i8, operation: LOCK_OPERATION) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmProbeAndLockPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, accessmode : i8, operation : LOCK_OPERATION));
    MmProbeAndLockPages(memorydescriptorlist, accessmode, operation)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmProbeAndLockProcessPages<P0>(memorydescriptorlist: *mut super::super::Foundation::MDL, process: P0, accessmode: i8, operation: LOCK_OPERATION)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmProbeAndLockProcessPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, process : super::super::Foundation:: PEPROCESS, accessmode : i8, operation : LOCK_OPERATION));
    MmProbeAndLockProcessPages(memorydescriptorlist, process.into_param().abi(), accessmode, operation)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Storage_FileSystem"))]
#[inline]
pub unsafe fn MmProbeAndLockSelectedPages(memorydescriptorlist: *mut super::super::Foundation::MDL, segmentarray: *const super::super::super::Win32::Storage::FileSystem::FILE_SEGMENT_ELEMENT, accessmode: i8, operation: LOCK_OPERATION) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmProbeAndLockSelectedPages(memorydescriptorlist : *mut super::super::Foundation:: MDL, segmentarray : *const super::super::super::Win32::Storage::FileSystem:: FILE_SEGMENT_ELEMENT, accessmode : i8, operation : LOCK_OPERATION));
    MmProbeAndLockSelectedPages(memorydescriptorlist, segmentarray, accessmode, operation)
}
#[inline]
pub unsafe fn MmProtectDriverSection(addresswithinsection: *const ::core::ffi::c_void, size: usize, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmProtectDriverSection(addresswithinsection : *const ::core::ffi::c_void, size : usize, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmProtectDriverSection(addresswithinsection, size, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmProtectMdlSystemAddress(memorydescriptorlist: *const super::super::Foundation::MDL, newprotect: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmProtectMdlSystemAddress(memorydescriptorlist : *const super::super::Foundation:: MDL, newprotect : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmProtectMdlSystemAddress(memorydescriptorlist, newprotect)
}
#[inline]
pub unsafe fn MmQuerySystemSize() -> MM_SYSTEMSIZE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmQuerySystemSize() -> MM_SYSTEMSIZE);
    MmQuerySystemSize()
}
#[inline]
pub unsafe fn MmRemovePhysicalMemory(startaddress: *const i64, numberofbytes: *mut i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmRemovePhysicalMemory(startaddress : *const i64, numberofbytes : *mut i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmRemovePhysicalMemory(startaddress, numberofbytes)
}
#[inline]
pub unsafe fn MmResetDriverPaging(addresswithinsection: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmResetDriverPaging(addresswithinsection : *const ::core::ffi::c_void));
    MmResetDriverPaging(addresswithinsection)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmRotatePhysicalView(virtualaddress: *const ::core::ffi::c_void, numberofbytes: *mut usize, newmdl: ::core::option::Option<*const super::super::Foundation::MDL>, direction: MM_ROTATE_DIRECTION, copyfunction: PMM_ROTATE_COPY_CALLBACK_FUNCTION, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmRotatePhysicalView(virtualaddress : *const ::core::ffi::c_void, numberofbytes : *mut usize, newmdl : *const super::super::Foundation:: MDL, direction : MM_ROTATE_DIRECTION, copyfunction : PMM_ROTATE_COPY_CALLBACK_FUNCTION, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmRotatePhysicalView(virtualaddress, numberofbytes, ::core::mem::transmute(newmdl.unwrap_or(::std::ptr::null())), direction, copyfunction, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn MmSecureVirtualMemory(address: *const ::core::ffi::c_void, size: usize, probemode: u32) -> super::super::super::Win32::Foundation::HANDLE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmSecureVirtualMemory(address : *const ::core::ffi::c_void, size : usize, probemode : u32) -> super::super::super::Win32::Foundation:: HANDLE);
    MmSecureVirtualMemory(address, size, probemode)
}
#[inline]
pub unsafe fn MmSecureVirtualMemoryEx(address: *const ::core::ffi::c_void, size: usize, probemode: u32, flags: u32) -> super::super::super::Win32::Foundation::HANDLE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmSecureVirtualMemoryEx(address : *const ::core::ffi::c_void, size : usize, probemode : u32, flags : u32) -> super::super::super::Win32::Foundation:: HANDLE);
    MmSecureVirtualMemoryEx(address, size, probemode, flags)
}
#[inline]
pub unsafe fn MmSetPermanentCacheAttribute(startaddress: i64, numberofbytes: i64, cachetype: MEMORY_CACHING_TYPE, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmSetPermanentCacheAttribute(startaddress : i64, numberofbytes : i64, cachetype : MEMORY_CACHING_TYPE, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmSetPermanentCacheAttribute(startaddress, numberofbytes, cachetype, flags)
}
#[inline]
pub unsafe fn MmSizeOfMdl(base: ::core::option::Option<*const ::core::ffi::c_void>, length: usize) -> usize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmSizeOfMdl(base : *const ::core::ffi::c_void, length : usize) -> usize);
    MmSizeOfMdl(::core::mem::transmute(base.unwrap_or(::std::ptr::null())), length)
}
#[inline]
pub unsafe fn MmUnlockPagableImageSection(imagesectionhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnlockPagableImageSection(imagesectionhandle : *const ::core::ffi::c_void));
    MmUnlockPagableImageSection(imagesectionhandle)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmUnlockPages(memorydescriptorlist: *mut super::super::Foundation::MDL) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnlockPages(memorydescriptorlist : *mut super::super::Foundation:: MDL));
    MmUnlockPages(memorydescriptorlist)
}
#[inline]
pub unsafe fn MmUnmapIoSpace(baseaddress: *const ::core::ffi::c_void, numberofbytes: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnmapIoSpace(baseaddress : *const ::core::ffi::c_void, numberofbytes : usize));
    MmUnmapIoSpace(baseaddress, numberofbytes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmUnmapLockedPages(baseaddress: *const ::core::ffi::c_void, memorydescriptorlist: *mut super::super::Foundation::MDL) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnmapLockedPages(baseaddress : *const ::core::ffi::c_void, memorydescriptorlist : *mut super::super::Foundation:: MDL));
    MmUnmapLockedPages(baseaddress, memorydescriptorlist)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn MmUnmapReservedMapping(baseaddress: *const ::core::ffi::c_void, pooltag: u32, memorydescriptorlist: *mut super::super::Foundation::MDL) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnmapReservedMapping(baseaddress : *const ::core::ffi::c_void, pooltag : u32, memorydescriptorlist : *mut super::super::Foundation:: MDL));
    MmUnmapReservedMapping(baseaddress, pooltag, memorydescriptorlist)
}
#[inline]
pub unsafe fn MmUnmapVideoDisplay(baseaddress: *const ::core::ffi::c_void, numberofbytes: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnmapVideoDisplay(baseaddress : *const ::core::ffi::c_void, numberofbytes : usize));
    MmUnmapVideoDisplay(baseaddress, numberofbytes)
}
#[inline]
pub unsafe fn MmUnmapViewInSessionSpace(mappedbase: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnmapViewInSessionSpace(mappedbase : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmUnmapViewInSessionSpace(mappedbase)
}
#[inline]
pub unsafe fn MmUnmapViewInSystemSpace(mappedbase: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnmapViewInSystemSpace(mappedbase : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    MmUnmapViewInSystemSpace(mappedbase)
}
#[inline]
pub unsafe fn MmUnsecureVirtualMemory<P0>(securehandle: P0)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn MmUnsecureVirtualMemory(securehandle : super::super::super::Win32::Foundation:: HANDLE));
    MmUnsecureVirtualMemory(securehandle.into_param().abi())
}
#[inline]
pub unsafe fn NtCommitComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtCommitComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCommitComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtCommitEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtCommitEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCommitEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtCommitTransaction<P0, P1>(transactionhandle: P0, wait: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtCommitTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCommitTransaction(transactionhandle.into_param().abi(), wait.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtCreateEnlistment<P0, P1>(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, resourcemanagerhandle: P0, transactionhandle: P1, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: u32, notificationmask: u32, enlistmentkey: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtCreateEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionhandle : super::super::super::Win32::Foundation:: HANDLE, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, notificationmask : u32, enlistmentkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCreateEnlistment(enlistmenthandle, desiredaccess, resourcemanagerhandle.into_param().abi(), transactionhandle.into_param().abi(), ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), createoptions, notificationmask, ::core::mem::transmute(enlistmentkey.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtCreateResourceManager<P0>(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: P0, rmguid: *const ::windows_core::GUID, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: u32, description: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtCreateResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, rmguid : *const ::windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCreateResourceManager(resourcemanagerhandle, desiredaccess, tmhandle.into_param().abi(), rmguid, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), createoptions, ::core::mem::transmute(description.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtCreateTransaction<P0>(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, uow: ::core::option::Option<*const ::windows_core::GUID>, tmhandle: P0, createoptions: u32, isolationlevel: u32, isolationflags: u32, timeout: ::core::option::Option<*const i64>, description: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtCreateTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const ::windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE, createoptions : u32, isolationlevel : u32, isolationflags : u32, timeout : *const i64, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCreateTransaction(transactionhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(uow.unwrap_or(::std::ptr::null())), tmhandle.into_param().abi(), createoptions, isolationlevel, isolationflags, ::core::mem::transmute(timeout.unwrap_or(::std::ptr::null())), ::core::mem::transmute(description.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtCreateTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, createoptions: u32, commitstrength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn NtCreateTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, createoptions : u32, commitstrength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtCreateTransactionManager(tmhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(logfilename.unwrap_or(::std::ptr::null())), createoptions, commitstrength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtEnumerateTransactionObject<P0>(rootobjecthandle: P0, querytype: super::super::super::Win32::System::SystemServices::KTMOBJECT_TYPE, objectcursor: *mut super::super::super::Win32::System::SystemServices::KTMOBJECT_CURSOR, objectcursorlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtEnumerateTransactionObject(rootobjecthandle : super::super::super::Win32::Foundation:: HANDLE, querytype : super::super::super::Win32::System::SystemServices:: KTMOBJECT_TYPE, objectcursor : *mut super::super::super::Win32::System::SystemServices:: KTMOBJECT_CURSOR, objectcursorlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtEnumerateTransactionObject(rootobjecthandle.into_param().abi(), querytype, objectcursor, objectcursorlength, returnlength)
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn NtGetNotificationResourceManager<P0>(resourcemanagerhandle: P0, transactionnotification: *mut super::super::super::Win32::Storage::FileSystem::TRANSACTION_NOTIFICATION, notificationlength: u32, timeout: ::core::option::Option<*const i64>, returnlength: ::core::option::Option<*mut u32>, asynchronous: u32, asynchronouscontext: usize) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtGetNotificationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionnotification : *mut super::super::super::Win32::Storage::FileSystem:: TRANSACTION_NOTIFICATION, notificationlength : u32, timeout : *const i64, returnlength : *mut u32, asynchronous : u32, asynchronouscontext : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtGetNotificationResourceManager(resourcemanagerhandle.into_param().abi(), transactionnotification, notificationlength, ::core::mem::transmute(timeout.unwrap_or(::std::ptr::null())), ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())), asynchronous, asynchronouscontext)
}
#[inline]
pub unsafe fn NtManagePartition<P0, P1>(targethandle: P0, sourcehandle: P1, partitioninformationclass: PARTITION_INFORMATION_CLASS, partitioninformation: *mut ::core::ffi::c_void, partitioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtManagePartition(targethandle : super::super::super::Win32::Foundation:: HANDLE, sourcehandle : super::super::super::Win32::Foundation:: HANDLE, partitioninformationclass : PARTITION_INFORMATION_CLASS, partitioninformation : *mut ::core::ffi::c_void, partitioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtManagePartition(targethandle.into_param().abi(), sourcehandle.into_param().abi(), partitioninformationclass, partitioninformation, partitioninformationlength)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtOpenEnlistment<P0>(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, resourcemanagerhandle: P0, enlistmentguid: *const ::windows_core::GUID, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtOpenEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentguid : *const ::windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtOpenEnlistment(enlistmenthandle, desiredaccess, resourcemanagerhandle.into_param().abi(), enlistmentguid, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn NtOpenProcess(processhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, clientid: ::core::option::Option<*const super::super::super::Win32::System::WindowsProgramming::CLIENT_ID>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn NtOpenProcess(processhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, clientid : *const super::super::super::Win32::System::WindowsProgramming:: CLIENT_ID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtOpenProcess(processhandle, desiredaccess, objectattributes, ::core::mem::transmute(clientid.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtOpenRegistryTransaction(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn NtOpenRegistryTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtOpenRegistryTransaction(transactionhandle, desiredaccess, objectattributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtOpenResourceManager<P0>(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: P0, resourcemanagerguid: ::core::option::Option<*const ::windows_core::GUID>, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtOpenResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerguid : *const ::windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtOpenResourceManager(resourcemanagerhandle, desiredaccess, tmhandle.into_param().abi(), ::core::mem::transmute(resourcemanagerguid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtOpenTransaction<P0>(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, uow: *const ::windows_core::GUID, tmhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtOpenTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const ::windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtOpenTransaction(transactionhandle, desiredaccess, objectattributes, uow, tmhandle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn NtOpenTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, tmidentity: ::core::option::Option<*const ::windows_core::GUID>, openoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn NtOpenTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, tmidentity : *const ::windows_core::GUID, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtOpenTransactionManager(tmhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(logfilename.unwrap_or(::std::ptr::null())), ::core::mem::transmute(tmidentity.unwrap_or(::std::ptr::null())), openoptions)
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn NtPowerInformation(informationlevel: super::super::super::Win32::System::Power::POWER_INFORMATION_LEVEL, inputbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inputbufferlength: u32, outputbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outputbufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn NtPowerInformation(informationlevel : super::super::super::Win32::System::Power:: POWER_INFORMATION_LEVEL, inputbuffer : *const ::core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut ::core::ffi::c_void, outputbufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPowerInformation(informationlevel, ::core::mem::transmute(inputbuffer.unwrap_or(::std::ptr::null())), inputbufferlength, ::core::mem::transmute(outputbuffer.unwrap_or(::std::ptr::null_mut())), outputbufferlength)
}
#[inline]
pub unsafe fn NtPrePrepareComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtPrePrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPrePrepareComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtPrePrepareEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtPrePrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPrePrepareEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtPrepareComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtPrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPrepareComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtPrepareEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtPrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPrepareEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtPropagationComplete<P0>(resourcemanagerhandle: P0, requestcookie: u32, bufferlength: u32, buffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtPropagationComplete(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, requestcookie : u32, bufferlength : u32, buffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPropagationComplete(resourcemanagerhandle.into_param().abi(), requestcookie, bufferlength, buffer)
}
#[inline]
pub unsafe fn NtPropagationFailed<P0, P1>(resourcemanagerhandle: P0, requestcookie: u32, propstatus: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtPropagationFailed(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, requestcookie : u32, propstatus : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtPropagationFailed(resourcemanagerhandle.into_param().abi(), requestcookie, propstatus.into_param().abi())
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationEnlistment<P0>(enlistmenthandle: P0, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *mut ::core::ffi::c_void, enlistmentinformationlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtQueryInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *mut ::core::ffi::c_void, enlistmentinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtQueryInformationEnlistment(enlistmenthandle.into_param().abi(), enlistmentinformationclass, enlistmentinformation, enlistmentinformationlength, returnlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationResourceManager<P0>(resourcemanagerhandle: P0, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *mut ::core::ffi::c_void, resourcemanagerinformationlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtQueryInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *mut ::core::ffi::c_void, resourcemanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtQueryInformationResourceManager(resourcemanagerhandle.into_param().abi(), resourcemanagerinformationclass, resourcemanagerinformation, resourcemanagerinformationlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationTransaction<P0>(transactionhandle: P0, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *mut ::core::ffi::c_void, transactioninformationlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtQueryInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *mut ::core::ffi::c_void, transactioninformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtQueryInformationTransaction(transactionhandle.into_param().abi(), transactioninformationclass, transactioninformation, transactioninformationlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtQueryInformationTransactionManager<P0>(transactionmanagerhandle: P0, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *mut ::core::ffi::c_void, transactionmanagerinformationlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtQueryInformationTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *mut ::core::ffi::c_void, transactionmanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtQueryInformationTransactionManager(transactionmanagerhandle.into_param().abi(), transactionmanagerinformationclass, transactionmanagerinformation, transactionmanagerinformationlength, returnlength)
}
#[inline]
pub unsafe fn NtReadOnlyEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtReadOnlyEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtReadOnlyEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtRecoverEnlistment<P0>(enlistmenthandle: P0, enlistmentkey: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRecoverEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRecoverEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(enlistmentkey.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtRecoverResourceManager<P0>(resourcemanagerhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRecoverResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRecoverResourceManager(resourcemanagerhandle.into_param().abi())
}
#[inline]
pub unsafe fn NtRecoverTransactionManager<P0>(transactionmanagerhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRecoverTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRecoverTransactionManager(transactionmanagerhandle.into_param().abi())
}
#[inline]
pub unsafe fn NtRegisterProtocolAddressInformation<P0>(resourcemanager: P0, protocolid: *const ::windows_core::GUID, protocolinformationsize: u32, protocolinformation: *const ::core::ffi::c_void, createoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRegisterProtocolAddressInformation(resourcemanager : super::super::super::Win32::Foundation:: HANDLE, protocolid : *const ::windows_core::GUID, protocolinformationsize : u32, protocolinformation : *const ::core::ffi::c_void, createoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRegisterProtocolAddressInformation(resourcemanager.into_param().abi(), protocolid, protocolinformationsize, protocolinformation, createoptions)
}
#[inline]
pub unsafe fn NtRenameTransactionManager(logfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, existingtransactionmanagerguid: *const ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn NtRenameTransactionManager(logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, existingtransactionmanagerguid : *const ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRenameTransactionManager(logfilename, existingtransactionmanagerguid)
}
#[inline]
pub unsafe fn NtRollbackComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRollbackComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRollbackComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtRollbackEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRollbackEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRollbackEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn NtRollbackRegistryTransaction<P0>(transactionhandle: P0, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRollbackRegistryTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRollbackRegistryTransaction(transactionhandle.into_param().abi(), flags)
}
#[inline]
pub unsafe fn NtRollbackTransaction<P0, P1>(transactionhandle: P0, wait: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRollbackTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRollbackTransaction(transactionhandle.into_param().abi(), wait.into_param().abi())
}
#[inline]
pub unsafe fn NtRollforwardTransactionManager<P0>(transactionmanagerhandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtRollforwardTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtRollforwardTransactionManager(transactionmanagerhandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationEnlistment<P0>(enlistmenthandle: P0, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *const ::core::ffi::c_void, enlistmentinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtSetInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *const ::core::ffi::c_void, enlistmentinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtSetInformationEnlistment(enlistmenthandle.into_param().abi(), enlistmentinformationclass, enlistmentinformation, enlistmentinformationlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationResourceManager<P0>(resourcemanagerhandle: P0, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *const ::core::ffi::c_void, resourcemanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtSetInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *const ::core::ffi::c_void, resourcemanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtSetInformationResourceManager(resourcemanagerhandle.into_param().abi(), resourcemanagerinformationclass, resourcemanagerinformation, resourcemanagerinformationlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationTransaction<P0>(transactionhandle: P0, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *const ::core::ffi::c_void, transactioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtSetInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *const ::core::ffi::c_void, transactioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtSetInformationTransaction(transactionhandle.into_param().abi(), transactioninformationclass, transactioninformation, transactioninformationlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn NtSetInformationTransactionManager<P0>(tmhandle: P0, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *const ::core::ffi::c_void, transactionmanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtSetInformationTransactionManager(tmhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *const ::core::ffi::c_void, transactionmanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtSetInformationTransactionManager(tmhandle.into_param().abi(), transactionmanagerinformationclass, transactionmanagerinformation, transactionmanagerinformationlength)
}
#[inline]
pub unsafe fn NtSinglePhaseReject<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn NtSinglePhaseReject(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    NtSinglePhaseReject(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ObCloseHandle<P0>(handle: P0, previousmode: i8) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObCloseHandle(handle : super::super::super::Win32::Foundation:: HANDLE, previousmode : i8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObCloseHandle(handle.into_param().abi(), previousmode)
}
#[inline]
pub unsafe fn ObDereferenceObjectDeferDelete(object: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObDereferenceObjectDeferDelete(object : *const ::core::ffi::c_void));
    ObDereferenceObjectDeferDelete(object)
}
#[inline]
pub unsafe fn ObDereferenceObjectDeferDeleteWithTag(object: *const ::core::ffi::c_void, tag: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObDereferenceObjectDeferDeleteWithTag(object : *const ::core::ffi::c_void, tag : u32));
    ObDereferenceObjectDeferDeleteWithTag(object, tag)
}
#[inline]
pub unsafe fn ObGetFilterVersion() -> u16 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObGetFilterVersion() -> u16);
    ObGetFilterVersion()
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn ObGetObjectSecurity(object: *const ::core::ffi::c_void, securitydescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, memoryallocated: *mut super::super::super::Win32::Foundation::BOOLEAN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObGetObjectSecurity(object : *const ::core::ffi::c_void, securitydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, memoryallocated : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObGetObjectSecurity(object, securitydescriptor, memoryallocated)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByHandle<P0, P1>(handle: P0, desiredaccess: u32, objecttype: P1, accessmode: i8, object: *mut *mut ::core::ffi::c_void, handleinformation: ::core::option::Option<*mut OBJECT_HANDLE_INFORMATION>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::Foundation::POBJECT_TYPE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByHandle(handle : super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8, object : *mut *mut ::core::ffi::c_void, handleinformation : *mut OBJECT_HANDLE_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObReferenceObjectByHandle(handle.into_param().abi(), desiredaccess, objecttype.into_param().abi(), accessmode, object, ::core::mem::transmute(handleinformation.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByHandleWithTag<P0, P1>(handle: P0, desiredaccess: u32, objecttype: P1, accessmode: i8, tag: u32, object: *mut *mut ::core::ffi::c_void, handleinformation: ::core::option::Option<*mut OBJECT_HANDLE_INFORMATION>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::Foundation::POBJECT_TYPE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByHandleWithTag(handle : super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8, tag : u32, object : *mut *mut ::core::ffi::c_void, handleinformation : *mut OBJECT_HANDLE_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObReferenceObjectByHandleWithTag(handle.into_param().abi(), desiredaccess, objecttype.into_param().abi(), accessmode, tag, object, ::core::mem::transmute(handleinformation.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByPointer<P0>(object: *const ::core::ffi::c_void, desiredaccess: u32, objecttype: P0, accessmode: i8) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POBJECT_TYPE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByPointer(object : *const ::core::ffi::c_void, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObReferenceObjectByPointer(object, desiredaccess, objecttype.into_param().abi(), accessmode)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObReferenceObjectByPointerWithTag<P0>(object: *const ::core::ffi::c_void, desiredaccess: u32, objecttype: P0, accessmode: i8, tag: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POBJECT_TYPE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReferenceObjectByPointerWithTag(object : *const ::core::ffi::c_void, desiredaccess : u32, objecttype : super::super::Foundation:: POBJECT_TYPE, accessmode : i8, tag : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObReferenceObjectByPointerWithTag(object, desiredaccess, objecttype.into_param().abi(), accessmode, tag)
}
#[inline]
pub unsafe fn ObReferenceObjectSafe(object: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReferenceObjectSafe(object : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ObReferenceObjectSafe(object)
}
#[inline]
pub unsafe fn ObReferenceObjectSafeWithTag(object: *const ::core::ffi::c_void, tag: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReferenceObjectSafeWithTag(object : *const ::core::ffi::c_void, tag : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    ObReferenceObjectSafeWithTag(object, tag)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ObRegisterCallbacks(callbackregistration: *const OB_CALLBACK_REGISTRATION, registrationhandle: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObRegisterCallbacks(callbackregistration : *const OB_CALLBACK_REGISTRATION, registrationhandle : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ObRegisterCallbacks(callbackregistration, registrationhandle)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn ObReleaseObjectSecurity<P0, P1>(securitydescriptor: P0, memoryallocated: P1)
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObReleaseObjectSecurity(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, memoryallocated : super::super::super::Win32::Foundation:: BOOLEAN));
    ObReleaseObjectSecurity(securitydescriptor.into_param().abi(), memoryallocated.into_param().abi())
}
#[inline]
pub unsafe fn ObUnRegisterCallbacks(registrationhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObUnRegisterCallbacks(registrationhandle : *const ::core::ffi::c_void));
    ObUnRegisterCallbacks(registrationhandle)
}
#[inline]
pub unsafe fn ObfDereferenceObject(object: *const ::core::ffi::c_void) -> isize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObfDereferenceObject(object : *const ::core::ffi::c_void) -> isize);
    ObfDereferenceObject(object)
}
#[inline]
pub unsafe fn ObfDereferenceObjectWithTag(object: *const ::core::ffi::c_void, tag: u32) -> isize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObfDereferenceObjectWithTag(object : *const ::core::ffi::c_void, tag : u32) -> isize);
    ObfDereferenceObjectWithTag(object, tag)
}
#[inline]
pub unsafe fn ObfReferenceObject(object: *const ::core::ffi::c_void) -> isize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObfReferenceObject(object : *const ::core::ffi::c_void) -> isize);
    ObfReferenceObject(object)
}
#[inline]
pub unsafe fn ObfReferenceObjectWithTag(object: *const ::core::ffi::c_void, tag: u32) -> isize {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ObfReferenceObjectWithTag(object : *const ::core::ffi::c_void, tag : u32) -> isize);
    ObfReferenceObjectWithTag(object, tag)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwAddInstance<P0>(buffer: P0, name: *const super::super::super::Win32::Foundation::UNICODE_STRING, id: u32, data: &[PCW_DATA]) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PPCW_BUFFER>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PcwAddInstance(buffer : super::super::Foundation:: PPCW_BUFFER, name : *const super::super::super::Win32::Foundation:: UNICODE_STRING, id : u32, count : u32, data : *const PCW_DATA) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PcwAddInstance(buffer.into_param().abi(), name, id, data.len().try_into().unwrap(), ::core::mem::transmute(data.as_ptr()))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwCloseInstance<P0>(instance: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PPCW_INSTANCE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PcwCloseInstance(instance : super::super::Foundation:: PPCW_INSTANCE));
    PcwCloseInstance(instance.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwCreateInstance<P0>(instance: *mut super::super::Foundation::PPCW_INSTANCE, registration: P0, name: *const super::super::super::Win32::Foundation::UNICODE_STRING, data: &[PCW_DATA]) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PPCW_REGISTRATION>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PcwCreateInstance(instance : *mut super::super::Foundation:: PPCW_INSTANCE, registration : super::super::Foundation:: PPCW_REGISTRATION, name : *const super::super::super::Win32::Foundation:: UNICODE_STRING, count : u32, data : *const PCW_DATA) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PcwCreateInstance(instance, registration.into_param().abi(), name, data.len().try_into().unwrap(), ::core::mem::transmute(data.as_ptr()))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwRegister(registration: *mut super::super::Foundation::PPCW_REGISTRATION, info: *const PCW_REGISTRATION_INFORMATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PcwRegister(registration : *mut super::super::Foundation:: PPCW_REGISTRATION, info : *const PCW_REGISTRATION_INFORMATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PcwRegister(registration, info)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PcwUnregister<P0>(registration: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PPCW_REGISTRATION>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PcwUnregister(registration : super::super::Foundation:: PPCW_REGISTRATION));
    PcwUnregister(registration.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoCallDriver(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, irp: *mut super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoCallDriver(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, irp : *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoCallDriver(deviceobject, irp)
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn PoClearPowerRequest(powerrequest: *mut ::core::ffi::c_void, r#type: super::super::super::Win32::System::Power::POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoClearPowerRequest(powerrequest : *mut ::core::ffi::c_void, r#type : super::super::super::Win32::System::Power:: POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoClearPowerRequest(powerrequest, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoCreatePowerRequest(powerrequest: *mut *mut ::core::ffi::c_void, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, context: ::core::option::Option<*const COUNTED_REASON_CONTEXT>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoCreatePowerRequest(powerrequest : *mut *mut ::core::ffi::c_void, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, context : *const COUNTED_REASON_CONTEXT) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoCreatePowerRequest(powerrequest, deviceobject, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoCreateThermalRequest(thermalrequest: *mut *mut ::core::ffi::c_void, targetdeviceobject: *const super::super::Foundation::DEVICE_OBJECT, policydeviceobject: *const super::super::Foundation::DEVICE_OBJECT, context: *const COUNTED_REASON_CONTEXT, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoCreateThermalRequest(thermalrequest : *mut *mut ::core::ffi::c_void, targetdeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, policydeviceobject : *const super::super::Foundation:: DEVICE_OBJECT, context : *const COUNTED_REASON_CONTEXT, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoCreateThermalRequest(thermalrequest, targetdeviceobject, policydeviceobject, context, flags)
}
#[inline]
pub unsafe fn PoDeletePowerRequest(powerrequest: *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoDeletePowerRequest(powerrequest : *mut ::core::ffi::c_void));
    PoDeletePowerRequest(powerrequest)
}
#[inline]
pub unsafe fn PoDeleteThermalRequest(thermalrequest: *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoDeleteThermalRequest(thermalrequest : *mut ::core::ffi::c_void));
    PoDeleteThermalRequest(thermalrequest)
}
#[inline]
pub unsafe fn PoEndDeviceBusy(idlepointer: *mut u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoEndDeviceBusy(idlepointer : *mut u32));
    PoEndDeviceBusy(idlepointer)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxActivateComponent<P0>(handle: P0, component: u32, flags: u32)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxActivateComponent(handle : super::super::Foundation:: POHANDLE, component : u32, flags : u32));
    PoFxActivateComponent(handle.into_param().abi(), component, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteDevicePowerNotRequired<P0>(handle: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxCompleteDevicePowerNotRequired(handle : super::super::Foundation:: POHANDLE));
    PoFxCompleteDevicePowerNotRequired(handle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteDirectedPowerDown<P0>(handle: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxCompleteDirectedPowerDown(handle : super::super::Foundation:: POHANDLE));
    PoFxCompleteDirectedPowerDown(handle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteIdleCondition<P0>(handle: P0, component: u32)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxCompleteIdleCondition(handle : super::super::Foundation:: POHANDLE, component : u32));
    PoFxCompleteIdleCondition(handle.into_param().abi(), component)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxCompleteIdleState<P0>(handle: P0, component: u32)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxCompleteIdleState(handle : super::super::Foundation:: POHANDLE, component : u32));
    PoFxCompleteIdleState(handle.into_param().abi(), component)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxIdleComponent<P0>(handle: P0, component: u32, flags: u32)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxIdleComponent(handle : super::super::Foundation:: POHANDLE, component : u32, flags : u32));
    PoFxIdleComponent(handle.into_param().abi(), component, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxIssueComponentPerfStateChange<P0>(handle: P0, flags: u32, component: u32, perfchange: *const PO_FX_PERF_STATE_CHANGE, context: *const ::core::ffi::c_void)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxIssueComponentPerfStateChange(handle : super::super::Foundation:: POHANDLE, flags : u32, component : u32, perfchange : *const PO_FX_PERF_STATE_CHANGE, context : *const ::core::ffi::c_void));
    PoFxIssueComponentPerfStateChange(handle.into_param().abi(), flags, component, perfchange, context)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxIssueComponentPerfStateChangeMultiple<P0>(handle: P0, flags: u32, component: u32, perfchangescount: u32, perfchanges: *const PO_FX_PERF_STATE_CHANGE, context: *const ::core::ffi::c_void)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxIssueComponentPerfStateChangeMultiple(handle : super::super::Foundation:: POHANDLE, flags : u32, component : u32, perfchangescount : u32, perfchanges : *const PO_FX_PERF_STATE_CHANGE, context : *const ::core::ffi::c_void));
    PoFxIssueComponentPerfStateChangeMultiple(handle.into_param().abi(), flags, component, perfchangescount, perfchanges, context)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxNotifySurprisePowerOn(pdo: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxNotifySurprisePowerOn(pdo : *const super::super::Foundation:: DEVICE_OBJECT));
    PoFxNotifySurprisePowerOn(pdo)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxPowerControl<P0>(handle: P0, powercontrolcode: *const ::windows_core::GUID, inbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inbuffersize: usize, outbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outbuffersize: usize, bytesreturned: ::core::option::Option<*mut usize>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxPowerControl(handle : super::super::Foundation:: POHANDLE, powercontrolcode : *const ::windows_core::GUID, inbuffer : *const ::core::ffi::c_void, inbuffersize : usize, outbuffer : *mut ::core::ffi::c_void, outbuffersize : usize, bytesreturned : *mut usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxPowerControl(handle.into_param().abi(), powercontrolcode, ::core::mem::transmute(inbuffer.unwrap_or(::std::ptr::null())), inbuffersize, ::core::mem::transmute(outbuffer.unwrap_or(::std::ptr::null_mut())), outbuffersize, ::core::mem::transmute(bytesreturned.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxPowerOnCrashdumpDevice<P0>(handle: P0, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxPowerOnCrashdumpDevice(handle : super::super::Foundation:: POHANDLE, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxPowerOnCrashdumpDevice(handle.into_param().abi(), ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxQueryCurrentComponentPerfState<P0>(handle: P0, flags: u32, component: u32, setindex: u32, currentperf: *mut u64) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxQueryCurrentComponentPerfState(handle : super::super::Foundation:: POHANDLE, flags : u32, component : u32, setindex : u32, currentperf : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxQueryCurrentComponentPerfState(handle.into_param().abi(), flags, component, setindex, currentperf)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxRegisterComponentPerfStates<P0>(handle: P0, component: u32, flags: u64, componentperfstatecallback: PPO_FX_COMPONENT_PERF_STATE_CALLBACK, inputstateinfo: *const PO_FX_COMPONENT_PERF_INFO, outputstateinfo: *mut *mut PO_FX_COMPONENT_PERF_INFO) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxRegisterComponentPerfStates(handle : super::super::Foundation:: POHANDLE, component : u32, flags : u64, componentperfstatecallback : PPO_FX_COMPONENT_PERF_STATE_CALLBACK, inputstateinfo : *const PO_FX_COMPONENT_PERF_INFO, outputstateinfo : *mut *mut PO_FX_COMPONENT_PERF_INFO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxRegisterComponentPerfStates(handle.into_param().abi(), component, flags, componentperfstatecallback, inputstateinfo, outputstateinfo)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxRegisterCrashdumpDevice<P0>(handle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxRegisterCrashdumpDevice(handle : super::super::Foundation:: POHANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxRegisterCrashdumpDevice(handle.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxRegisterDevice(pdo: *const super::super::Foundation::DEVICE_OBJECT, device: *const PO_FX_DEVICE_V1, handle: *mut super::super::Foundation::POHANDLE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxRegisterDevice(pdo : *const super::super::Foundation:: DEVICE_OBJECT, device : *const PO_FX_DEVICE_V1, handle : *mut super::super::Foundation:: POHANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxRegisterDevice(pdo, device, handle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxRegisterDripsWatchdogCallback<P0, P1>(handle: P0, callback: PPO_FX_DRIPS_WATCHDOG_CALLBACK, includechilddevices: P1, matchingdriverobject: ::core::option::Option<*const super::super::Foundation::DRIVER_OBJECT>)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxRegisterDripsWatchdogCallback(handle : super::super::Foundation:: POHANDLE, callback : PPO_FX_DRIPS_WATCHDOG_CALLBACK, includechilddevices : super::super::super::Win32::Foundation:: BOOLEAN, matchingdriverobject : *const super::super::Foundation:: DRIVER_OBJECT));
    PoFxRegisterDripsWatchdogCallback(handle.into_param().abi(), callback, includechilddevices.into_param().abi(), ::core::mem::transmute(matchingdriverobject.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxReportDevicePoweredOn<P0>(handle: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxReportDevicePoweredOn(handle : super::super::Foundation:: POHANDLE));
    PoFxReportDevicePoweredOn(handle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetComponentLatency<P0>(handle: P0, component: u32, latency: u64)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxSetComponentLatency(handle : super::super::Foundation:: POHANDLE, component : u32, latency : u64));
    PoFxSetComponentLatency(handle.into_param().abi(), component, latency)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetComponentResidency<P0>(handle: P0, component: u32, residency: u64)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxSetComponentResidency(handle : super::super::Foundation:: POHANDLE, component : u32, residency : u64));
    PoFxSetComponentResidency(handle.into_param().abi(), component, residency)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetComponentWake<P0, P1>(handle: P0, component: u32, wakehint: P1)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxSetComponentWake(handle : super::super::Foundation:: POHANDLE, component : u32, wakehint : super::super::super::Win32::Foundation:: BOOLEAN));
    PoFxSetComponentWake(handle.into_param().abi(), component, wakehint.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxSetDeviceIdleTimeout<P0>(handle: P0, idletimeout: u64)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxSetDeviceIdleTimeout(handle : super::super::Foundation:: POHANDLE, idletimeout : u64));
    PoFxSetDeviceIdleTimeout(handle.into_param().abi(), idletimeout)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoFxSetTargetDripsDevicePowerState<P0>(handle: P0, targetstate: super::super::super::Win32::System::Power::DEVICE_POWER_STATE) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxSetTargetDripsDevicePowerState(handle : super::super::Foundation:: POHANDLE, targetstate : super::super::super::Win32::System::Power:: DEVICE_POWER_STATE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoFxSetTargetDripsDevicePowerState(handle.into_param().abi(), targetstate)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxStartDevicePowerManagement<P0>(handle: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxStartDevicePowerManagement(handle : super::super::Foundation:: POHANDLE));
    PoFxStartDevicePowerManagement(handle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PoFxUnregisterDevice<P0>(handle: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::POHANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoFxUnregisterDevice(handle : super::super::Foundation:: POHANDLE));
    PoFxUnregisterDevice(handle.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoGetSystemWake(irp: *const super::super::Foundation::IRP) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoGetSystemWake(irp : *const super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PoGetSystemWake(irp)
}
#[inline]
pub unsafe fn PoGetThermalRequestSupport(thermalrequest: *const ::core::ffi::c_void, r#type: PO_THERMAL_REQUEST_TYPE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoGetThermalRequestSupport(thermalrequest : *const ::core::ffi::c_void, r#type : PO_THERMAL_REQUEST_TYPE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PoGetThermalRequestSupport(thermalrequest, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoQueryWatchdogTime(pdo: *const super::super::Foundation::DEVICE_OBJECT, secondsremaining: *mut u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoQueryWatchdogTime(pdo : *const super::super::Foundation:: DEVICE_OBJECT, secondsremaining : *mut u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PoQueryWatchdogTime(pdo, secondsremaining)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoRegisterDeviceForIdleDetection(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, conservationidletime: u32, performanceidletime: u32, state: super::super::super::Win32::System::Power::DEVICE_POWER_STATE) -> *mut u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoRegisterDeviceForIdleDetection(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, conservationidletime : u32, performanceidletime : u32, state : super::super::super::Win32::System::Power:: DEVICE_POWER_STATE) -> *mut u32);
    PoRegisterDeviceForIdleDetection(deviceobject, conservationidletime, performanceidletime, state)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoRegisterPowerSettingCallback(deviceobject: ::core::option::Option<*const super::super::Foundation::DEVICE_OBJECT>, settingguid: *const ::windows_core::GUID, callback: PPOWER_SETTING_CALLBACK, context: ::core::option::Option<*const ::core::ffi::c_void>, handle: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoRegisterPowerSettingCallback(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, settingguid : *const ::windows_core::GUID, callback : PPOWER_SETTING_CALLBACK, context : *const ::core::ffi::c_void, handle : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoRegisterPowerSettingCallback(::core::mem::transmute(deviceobject.unwrap_or(::std::ptr::null())), settingguid, callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), ::core::mem::transmute(handle.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn PoRegisterSystemState(statehandle: ::core::option::Option<*mut ::core::ffi::c_void>, flags: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoRegisterSystemState(statehandle : *mut ::core::ffi::c_void, flags : u32) -> *mut ::core::ffi::c_void);
    PoRegisterSystemState(::core::mem::transmute(statehandle.unwrap_or(::std::ptr::null_mut())), flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoRequestPowerIrp(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, minorfunction: u8, powerstate: POWER_STATE, completionfunction: PREQUEST_POWER_COMPLETE, context: ::core::option::Option<*const ::core::ffi::c_void>, irp: ::core::option::Option<*mut *mut super::super::Foundation::IRP>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoRequestPowerIrp(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, minorfunction : u8, powerstate : POWER_STATE, completionfunction : PREQUEST_POWER_COMPLETE, context : *const ::core::ffi::c_void, irp : *mut *mut super::super::Foundation:: IRP) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoRequestPowerIrp(deviceobject, minorfunction, ::core::mem::transmute(powerstate), completionfunction, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), ::core::mem::transmute(irp.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn PoSetDeviceBusyEx(idlepointer: *mut u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetDeviceBusyEx(idlepointer : *mut u32));
    PoSetDeviceBusyEx(idlepointer)
}
#[inline]
pub unsafe fn PoSetHiberRange(memorymap: ::core::option::Option<*const ::core::ffi::c_void>, flags: u32, address: *const ::core::ffi::c_void, length: usize, tag: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetHiberRange(memorymap : *const ::core::ffi::c_void, flags : u32, address : *const ::core::ffi::c_void, length : usize, tag : u32));
    PoSetHiberRange(::core::mem::transmute(memorymap.unwrap_or(::std::ptr::null())), flags, address, length, tag)
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn PoSetPowerRequest(powerrequest: *mut ::core::ffi::c_void, r#type: super::super::super::Win32::System::Power::POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetPowerRequest(powerrequest : *mut ::core::ffi::c_void, r#type : super::super::super::Win32::System::Power:: POWER_REQUEST_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoSetPowerRequest(powerrequest, r#type)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoSetPowerState(deviceobject: *const super::super::Foundation::DEVICE_OBJECT, r#type: POWER_STATE_TYPE, state: POWER_STATE) -> POWER_STATE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetPowerState(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, r#type : POWER_STATE_TYPE, state : POWER_STATE) -> POWER_STATE);
    PoSetPowerState(deviceobject, r#type, ::core::mem::transmute(state))
}
#[inline]
pub unsafe fn PoSetSystemState(flags: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetSystemState(flags : u32));
    PoSetSystemState(flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoSetSystemWake(irp: *mut super::super::Foundation::IRP) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetSystemWake(irp : *mut super::super::Foundation:: IRP));
    PoSetSystemWake(irp)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoSetSystemWakeDevice(deviceobject: *const super::super::Foundation::DEVICE_OBJECT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetSystemWakeDevice(deviceobject : *const super::super::Foundation:: DEVICE_OBJECT));
    PoSetSystemWakeDevice(deviceobject)
}
#[inline]
pub unsafe fn PoSetThermalActiveCooling<P0>(thermalrequest: *mut ::core::ffi::c_void, engaged: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetThermalActiveCooling(thermalrequest : *mut ::core::ffi::c_void, engaged : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoSetThermalActiveCooling(thermalrequest, engaged.into_param().abi())
}
#[inline]
pub unsafe fn PoSetThermalPassiveCooling(thermalrequest: *mut ::core::ffi::c_void, throttle: u8) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoSetThermalPassiveCooling(thermalrequest : *mut ::core::ffi::c_void, throttle : u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoSetThermalPassiveCooling(thermalrequest, throttle)
}
#[inline]
pub unsafe fn PoStartDeviceBusy(idlepointer: *mut u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoStartDeviceBusy(idlepointer : *mut u32));
    PoStartDeviceBusy(idlepointer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn PoStartNextPowerIrp(irp: *mut super::super::Foundation::IRP) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoStartNextPowerIrp(irp : *mut super::super::Foundation:: IRP));
    PoStartNextPowerIrp(irp)
}
#[inline]
pub unsafe fn PoUnregisterPowerSettingCallback(handle: *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoUnregisterPowerSettingCallback(handle : *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PoUnregisterPowerSettingCallback(handle)
}
#[inline]
pub unsafe fn PoUnregisterSystemState(statehandle: *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PoUnregisterSystemState(statehandle : *mut ::core::ffi::c_void));
    PoUnregisterSystemState(statehandle)
}
#[inline]
pub unsafe fn ProbeForRead(address: *const ::core::ffi::c_void, length: usize, alignment: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ProbeForRead(address : *const ::core::ffi::c_void, length : usize, alignment : u32));
    ProbeForRead(address, length, alignment)
}
#[inline]
pub unsafe fn ProbeForWrite(address: *mut ::core::ffi::c_void, length: usize, alignment: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn ProbeForWrite(address : *mut ::core::ffi::c_void, length : usize, alignment : u32));
    ProbeForWrite(address, length, alignment)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsAcquireSiloHardReference<P0>(silo: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsAcquireSiloHardReference(silo : super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsAcquireSiloHardReference(silo.into_param().abi())
}
#[inline]
pub unsafe fn PsAllocSiloContextSlot(reserved: usize, returnedcontextslot: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsAllocSiloContextSlot(reserved : usize, returnedcontextslot : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsAllocSiloContextSlot(reserved, returnedcontextslot)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsAllocateAffinityToken(affinitytoken: *mut super::super::Foundation::PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsAllocateAffinityToken(affinitytoken : *mut super::super::Foundation:: PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsAllocateAffinityToken(affinitytoken)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsAttachSiloToCurrentThread<P0>(silo: P0) -> super::super::Foundation::PESILO
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsAttachSiloToCurrentThread(silo : super::super::Foundation:: PESILO) -> super::super::Foundation:: PESILO);
    PsAttachSiloToCurrentThread(silo.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsCreateSiloContext<P0>(silo: P0, size: u32, pooltype: super::super::Foundation::POOL_TYPE, contextcleanupcallback: SILO_CONTEXT_CLEANUP_CALLBACK, returnedsilocontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsCreateSiloContext(silo : super::super::Foundation:: PESILO, size : u32, pooltype : super::super::Foundation:: POOL_TYPE, contextcleanupcallback : SILO_CONTEXT_CLEANUP_CALLBACK, returnedsilocontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsCreateSiloContext(silo.into_param().abi(), size, pooltype, contextcleanupcallback, returnedsilocontext)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn PsCreateSystemThread<P0>(threadhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, processhandle: P0, clientid: ::core::option::Option<*mut super::super::super::Win32::System::WindowsProgramming::CLIENT_ID>, startroutine: PKSTART_ROUTINE, startcontext: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsCreateSystemThread(threadhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, processhandle : super::super::super::Win32::Foundation:: HANDLE, clientid : *mut super::super::super::Win32::System::WindowsProgramming:: CLIENT_ID, startroutine : PKSTART_ROUTINE, startcontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsCreateSystemThread(threadhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), processhandle.into_param().abi(), ::core::mem::transmute(clientid.unwrap_or(::std::ptr::null_mut())), startroutine, ::core::mem::transmute(startcontext.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn PsDereferenceSiloContext(silocontext: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsDereferenceSiloContext(silocontext : *const ::core::ffi::c_void));
    PsDereferenceSiloContext(silocontext)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsDetachSiloFromCurrentThread<P0>(previoussilo: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsDetachSiloFromCurrentThread(previoussilo : super::super::Foundation:: PESILO));
    PsDetachSiloFromCurrentThread(previoussilo.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsFreeAffinityToken<P0>(affinitytoken: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PAFFINITY_TOKEN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsFreeAffinityToken(affinitytoken : super::super::Foundation:: PAFFINITY_TOKEN));
    PsFreeAffinityToken(affinitytoken.into_param().abi())
}
#[inline]
pub unsafe fn PsFreeSiloContextSlot(contextslot: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsFreeSiloContextSlot(contextslot : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsFreeSiloContextSlot(contextslot)
}
#[inline]
pub unsafe fn PsGetCurrentProcessId() -> super::super::super::Win32::Foundation::HANDLE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetCurrentProcessId() -> super::super::super::Win32::Foundation:: HANDLE);
    PsGetCurrentProcessId()
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetCurrentServerSilo() -> super::super::Foundation::PESILO {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetCurrentServerSilo() -> super::super::Foundation:: PESILO);
    PsGetCurrentServerSilo()
}
#[inline]
pub unsafe fn PsGetCurrentServerSiloName() -> *mut super::super::super::Win32::Foundation::UNICODE_STRING {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetCurrentServerSiloName() -> *mut super::super::super::Win32::Foundation:: UNICODE_STRING);
    PsGetCurrentServerSiloName()
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetCurrentSilo() -> super::super::Foundation::PESILO {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetCurrentSilo() -> super::super::Foundation:: PESILO);
    PsGetCurrentSilo()
}
#[inline]
pub unsafe fn PsGetCurrentThreadId() -> super::super::super::Win32::Foundation::HANDLE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetCurrentThreadId() -> super::super::super::Win32::Foundation:: HANDLE);
    PsGetCurrentThreadId()
}
#[inline]
pub unsafe fn PsGetCurrentThreadTeb() -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetCurrentThreadTeb() -> *mut ::core::ffi::c_void);
    PsGetCurrentThreadTeb()
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetEffectiveServerSilo<P0>(silo: P0) -> super::super::Foundation::PESILO
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetEffectiveServerSilo(silo : super::super::Foundation:: PESILO) -> super::super::Foundation:: PESILO);
    PsGetEffectiveServerSilo(silo.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetHostSilo() -> super::super::Foundation::PESILO {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetHostSilo() -> super::super::Foundation:: PESILO);
    PsGetHostSilo()
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetJobServerSilo<P0>(job: P0, serversilo: *mut super::super::Foundation::PESILO) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEJOB>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetJobServerSilo(job : super::super::Foundation:: PEJOB, serversilo : *mut super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsGetJobServerSilo(job.into_param().abi(), serversilo)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetJobSilo<P0>(job: P0, silo: *mut super::super::Foundation::PESILO) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEJOB>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetJobSilo(job : super::super::Foundation:: PEJOB, silo : *mut super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsGetJobSilo(job.into_param().abi(), silo)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetParentSilo<P0>(job: P0) -> super::super::Foundation::PESILO
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEJOB>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetParentSilo(job : super::super::Foundation:: PEJOB) -> super::super::Foundation:: PESILO);
    PsGetParentSilo(job.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetPermanentSiloContext<P0>(silo: P0, contextslot: u32, returnedsilocontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetPermanentSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, returnedsilocontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsGetPermanentSiloContext(silo.into_param().abi(), contextslot, returnedsilocontext)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessCreateTimeQuadPart<P0>(process: P0) -> i64
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetProcessCreateTimeQuadPart(process : super::super::Foundation:: PEPROCESS) -> i64);
    PsGetProcessCreateTimeQuadPart(process.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessExitStatus<P0>(process: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetProcessExitStatus(process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsGetProcessExitStatus(process.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessId<P0>(process: P0) -> super::super::super::Win32::Foundation::HANDLE
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetProcessId(process : super::super::Foundation:: PEPROCESS) -> super::super::super::Win32::Foundation:: HANDLE);
    PsGetProcessId(process.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetProcessStartKey<P0>(process: P0) -> u64
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetProcessStartKey(process : super::super::Foundation:: PEPROCESS) -> u64);
    PsGetProcessStartKey(process.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetServerSiloServiceSessionId<P0>(silo: P0) -> u32
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetServerSiloServiceSessionId(silo : super::super::Foundation:: PESILO) -> u32);
    PsGetServerSiloServiceSessionId(silo.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetSiloContainerId<P0>(silo: P0) -> *mut ::windows_core::GUID
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetSiloContainerId(silo : super::super::Foundation:: PESILO) -> *mut ::windows_core::GUID);
    PsGetSiloContainerId(silo.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetSiloContext<P0>(silo: P0, contextslot: u32, returnedsilocontext: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, returnedsilocontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsGetSiloContext(silo.into_param().abi(), contextslot, returnedsilocontext)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetSiloMonitorContextSlot<P0>(monitor: P0) -> u32
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PSILO_MONITOR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetSiloMonitorContextSlot(monitor : super::super::Foundation:: PSILO_MONITOR) -> u32);
    PsGetSiloMonitorContextSlot(monitor.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadCreateTime<P0>(thread: P0) -> i64
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PETHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetThreadCreateTime(thread : super::super::Foundation:: PETHREAD) -> i64);
    PsGetThreadCreateTime(thread.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadExitStatus<P0>(thread: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PETHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetThreadExitStatus(thread : super::super::Foundation:: PETHREAD) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsGetThreadExitStatus(thread.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadId<P0>(thread: P0) -> super::super::super::Win32::Foundation::HANDLE
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PETHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetThreadId(thread : super::super::Foundation:: PETHREAD) -> super::super::super::Win32::Foundation:: HANDLE);
    PsGetThreadId(thread.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadProcessId<P0>(thread: P0) -> super::super::super::Win32::Foundation::HANDLE
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PETHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetThreadProcessId(thread : super::super::Foundation:: PETHREAD) -> super::super::super::Win32::Foundation:: HANDLE);
    PsGetThreadProcessId(thread.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadProperty<P0>(thread: P0, key: usize, flags: u32) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PETHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetThreadProperty(thread : super::super::Foundation:: PETHREAD, key : usize, flags : u32) -> *mut ::core::ffi::c_void);
    PsGetThreadProperty(thread.into_param().abi(), key, flags)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsGetThreadServerSilo<P0>(thread: P0) -> super::super::Foundation::PESILO
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PETHREAD>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetThreadServerSilo(thread : super::super::Foundation:: PETHREAD) -> super::super::Foundation:: PESILO);
    PsGetThreadServerSilo(thread.into_param().abi())
}
#[inline]
pub unsafe fn PsGetVersion(majorversion: ::core::option::Option<*mut u32>, minorversion: ::core::option::Option<*mut u32>, buildnumber: ::core::option::Option<*mut u32>, csdversion: ::core::option::Option<*mut super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsGetVersion(majorversion : *mut u32, minorversion : *mut u32, buildnumber : *mut u32, csdversion : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PsGetVersion(::core::mem::transmute(majorversion.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(minorversion.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buildnumber.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(csdversion.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsInsertPermanentSiloContext<P0>(silo: P0, contextslot: u32, silocontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsInsertPermanentSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, silocontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsInsertPermanentSiloContext(silo.into_param().abi(), contextslot, silocontext)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsInsertSiloContext<P0>(silo: P0, contextslot: u32, silocontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsInsertSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, silocontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsInsertSiloContext(silo.into_param().abi(), contextslot, silocontext)
}
#[inline]
pub unsafe fn PsIsCurrentThreadInServerSilo() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsIsCurrentThreadInServerSilo() -> super::super::super::Win32::Foundation:: BOOLEAN);
    PsIsCurrentThreadInServerSilo()
}
#[inline]
pub unsafe fn PsIsCurrentThreadPrefetching() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsIsCurrentThreadPrefetching() -> super::super::super::Win32::Foundation:: BOOLEAN);
    PsIsCurrentThreadPrefetching()
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsIsHostSilo<P0>(silo: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsIsHostSilo(silo : super::super::Foundation:: PESILO) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PsIsHostSilo(silo.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsMakeSiloContextPermanent<P0>(silo: P0, contextslot: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsMakeSiloContextPermanent(silo : super::super::Foundation:: PESILO, contextslot : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsMakeSiloContextPermanent(silo.into_param().abi(), contextslot)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsQueryTotalCycleTimeProcess<P0>(process: P0, cycletimestamp: *mut u64) -> u64
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsQueryTotalCycleTimeProcess(process : super::super::Foundation:: PEPROCESS, cycletimestamp : *mut u64) -> u64);
    PsQueryTotalCycleTimeProcess(process.into_param().abi(), cycletimestamp)
}
#[inline]
pub unsafe fn PsReferenceSiloContext(silocontext: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsReferenceSiloContext(silocontext : *const ::core::ffi::c_void));
    PsReferenceSiloContext(silocontext)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsRegisterSiloMonitor(registration: *const SILO_MONITOR_REGISTRATION, returnedmonitor: *mut super::super::Foundation::PSILO_MONITOR) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsRegisterSiloMonitor(registration : *const SILO_MONITOR_REGISTRATION, returnedmonitor : *mut super::super::Foundation:: PSILO_MONITOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsRegisterSiloMonitor(registration, returnedmonitor)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsReleaseSiloHardReference<P0>(silo: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsReleaseSiloHardReference(silo : super::super::Foundation:: PESILO));
    PsReleaseSiloHardReference(silo.into_param().abi())
}
#[inline]
pub unsafe fn PsRemoveCreateThreadNotifyRoutine(notifyroutine: PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsRemoveCreateThreadNotifyRoutine(notifyroutine : PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsRemoveCreateThreadNotifyRoutine(notifyroutine)
}
#[inline]
pub unsafe fn PsRemoveLoadImageNotifyRoutine(notifyroutine: PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsRemoveLoadImageNotifyRoutine(notifyroutine : PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsRemoveLoadImageNotifyRoutine(notifyroutine)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsRemoveSiloContext<P0>(silo: P0, contextslot: u32, removedsilocontext: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsRemoveSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, removedsilocontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsRemoveSiloContext(silo.into_param().abi(), contextslot, ::core::mem::transmute(removedsilocontext.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsReplaceSiloContext<P0>(silo: P0, contextslot: u32, newsilocontext: *const ::core::ffi::c_void, oldsilocontext: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsReplaceSiloContext(silo : super::super::Foundation:: PESILO, contextslot : u32, newsilocontext : *const ::core::ffi::c_void, oldsilocontext : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsReplaceSiloContext(silo.into_param().abi(), contextslot, newsilocontext, ::core::mem::transmute(oldsilocontext.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsRevertToUserMultipleGroupAffinityThread<P0>(affinitytoken: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PAFFINITY_TOKEN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsRevertToUserMultipleGroupAffinityThread(affinitytoken : super::super::Foundation:: PAFFINITY_TOKEN));
    PsRevertToUserMultipleGroupAffinityThread(affinitytoken.into_param().abi())
}
#[inline]
pub unsafe fn PsSetCreateProcessNotifyRoutine<P0>(notifyroutine: PCREATE_PROCESS_NOTIFY_ROUTINE, remove: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetCreateProcessNotifyRoutine(notifyroutine : PCREATE_PROCESS_NOTIFY_ROUTINE, remove : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetCreateProcessNotifyRoutine(notifyroutine, remove.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn PsSetCreateProcessNotifyRoutineEx<P0>(notifyroutine: PCREATE_PROCESS_NOTIFY_ROUTINE_EX, remove: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetCreateProcessNotifyRoutineEx(notifyroutine : PCREATE_PROCESS_NOTIFY_ROUTINE_EX, remove : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetCreateProcessNotifyRoutineEx(notifyroutine, remove.into_param().abi())
}
#[inline]
pub unsafe fn PsSetCreateProcessNotifyRoutineEx2<P0>(notifytype: PSCREATEPROCESSNOTIFYTYPE, notifyinformation: *const ::core::ffi::c_void, remove: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetCreateProcessNotifyRoutineEx2(notifytype : PSCREATEPROCESSNOTIFYTYPE, notifyinformation : *const ::core::ffi::c_void, remove : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetCreateProcessNotifyRoutineEx2(notifytype, notifyinformation, remove.into_param().abi())
}
#[inline]
pub unsafe fn PsSetCreateThreadNotifyRoutine(notifyroutine: PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetCreateThreadNotifyRoutine(notifyroutine : PCREATE_THREAD_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetCreateThreadNotifyRoutine(notifyroutine)
}
#[inline]
pub unsafe fn PsSetCreateThreadNotifyRoutineEx(notifytype: PSCREATETHREADNOTIFYTYPE, notifyinformation: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetCreateThreadNotifyRoutineEx(notifytype : PSCREATETHREADNOTIFYTYPE, notifyinformation : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetCreateThreadNotifyRoutineEx(notifytype, notifyinformation)
}
#[inline]
pub unsafe fn PsSetCurrentThreadPrefetching<P0>(prefetching: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetCurrentThreadPrefetching(prefetching : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PsSetCurrentThreadPrefetching(prefetching.into_param().abi())
}
#[inline]
pub unsafe fn PsSetLoadImageNotifyRoutine(notifyroutine: PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetLoadImageNotifyRoutine(notifyroutine : PLOAD_IMAGE_NOTIFY_ROUTINE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetLoadImageNotifyRoutine(notifyroutine)
}
#[inline]
pub unsafe fn PsSetLoadImageNotifyRoutineEx(notifyroutine: PLOAD_IMAGE_NOTIFY_ROUTINE, flags: usize) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetLoadImageNotifyRoutineEx(notifyroutine : PLOAD_IMAGE_NOTIFY_ROUTINE, flags : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetLoadImageNotifyRoutineEx(notifyroutine, flags)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_SystemInformation"))]
#[inline]
pub unsafe fn PsSetSystemMultipleGroupAffinityThread<P0>(groupaffinities: &[super::super::super::Win32::System::SystemInformation::GROUP_AFFINITY], affinitytoken: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PAFFINITY_TOKEN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsSetSystemMultipleGroupAffinityThread(groupaffinities : *const super::super::super::Win32::System::SystemInformation:: GROUP_AFFINITY, groupcount : u16, affinitytoken : super::super::Foundation:: PAFFINITY_TOKEN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsSetSystemMultipleGroupAffinityThread(::core::mem::transmute(groupaffinities.as_ptr()), groupaffinities.len().try_into().unwrap(), affinitytoken.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsStartSiloMonitor<P0>(monitor: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PSILO_MONITOR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsStartSiloMonitor(monitor : super::super::Foundation:: PSILO_MONITOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsStartSiloMonitor(monitor.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsTerminateServerSilo<P0, P1>(serversilo: P0, exitstatus: P1)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PESILO>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsTerminateServerSilo(serversilo : super::super::Foundation:: PESILO, exitstatus : super::super::super::Win32::Foundation:: NTSTATUS));
    PsTerminateServerSilo(serversilo.into_param().abi(), exitstatus.into_param().abi())
}
#[inline]
pub unsafe fn PsTerminateSystemThread<P0>(exitstatus: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsTerminateSystemThread(exitstatus : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsTerminateSystemThread(exitstatus.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn PsUnregisterSiloMonitor<P0>(monitor: P0)
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PSILO_MONITOR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsUnregisterSiloMonitor(monitor : super::super::Foundation:: PSILO_MONITOR));
    PsUnregisterSiloMonitor(monitor.into_param().abi())
}
#[inline]
pub unsafe fn PsWrapApcWow64Thread(apccontext: *mut *mut ::core::ffi::c_void, apcroutine: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn PsWrapApcWow64Thread(apccontext : *mut *mut ::core::ffi::c_void, apcroutine : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PsWrapApcWow64Thread(apccontext, apcroutine)
}
#[inline]
pub unsafe fn PshedAllocateMemory(size: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("pshed.dll" "system" fn PshedAllocateMemory(size : u32) -> *mut ::core::ffi::c_void);
    PshedAllocateMemory(size)
}
#[inline]
pub unsafe fn PshedFreeMemory(address: *const ::core::ffi::c_void) {
    ::windows_targets::link!("pshed.dll" "system" fn PshedFreeMemory(address : *const ::core::ffi::c_void));
    PshedFreeMemory(address)
}
#[inline]
pub unsafe fn PshedIsSystemWheaEnabled() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("pshed.dll" "system" fn PshedIsSystemWheaEnabled() -> super::super::super::Win32::Foundation:: BOOLEAN);
    PshedIsSystemWheaEnabled()
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn PshedRegisterPlugin(packet: *mut WHEA_PSHED_PLUGIN_REGISTRATION_PACKET_V2) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("pshed.dll" "system" fn PshedRegisterPlugin(packet : *mut WHEA_PSHED_PLUGIN_REGISTRATION_PACKET_V2) -> super::super::super::Win32::Foundation:: NTSTATUS);
    PshedRegisterPlugin(packet)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn PshedSynchronizeExecution(errorsource: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_DESCRIPTOR, synchronizeroutine: PKSYNCHRONIZE_ROUTINE, synchronizecontext: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("pshed.dll" "system" fn PshedSynchronizeExecution(errorsource : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_DESCRIPTOR, synchronizeroutine : PKSYNCHRONIZE_ROUTINE, synchronizecontext : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    PshedSynchronizeExecution(errorsource, synchronizeroutine, synchronizecontext)
}
#[inline]
pub unsafe fn PshedUnregisterPlugin(pluginhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("pshed.dll" "system" fn PshedUnregisterPlugin(pluginhandle : *const ::core::ffi::c_void));
    PshedUnregisterPlugin(pluginhandle)
}
#[inline]
pub unsafe fn RtlAppendUnicodeStringToString(destination: *mut super::super::super::Win32::Foundation::UNICODE_STRING, source: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlAppendUnicodeStringToString(destination : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, source : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlAppendUnicodeStringToString(destination, source)
}
#[inline]
pub unsafe fn RtlAppendUnicodeToString<P0>(destination: *mut super::super::super::Win32::Foundation::UNICODE_STRING, source: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlAppendUnicodeToString(destination : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, source : ::windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlAppendUnicodeToString(destination, source.into_param().abi())
}
#[inline]
pub unsafe fn RtlAreBitsClear(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlAreBitsClear(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlAreBitsClear(bitmapheader, startingindex, length)
}
#[inline]
pub unsafe fn RtlAreBitsSet(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlAreBitsSet(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlAreBitsSet(bitmapheader, startingindex, length)
}
#[inline]
pub unsafe fn RtlAssert<P0>(voidfailedassertion: *const ::core::ffi::c_void, voidfilename: *const ::core::ffi::c_void, linenumber: u32, mutablemessage: P0)
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlAssert(voidfailedassertion : *const ::core::ffi::c_void, voidfilename : *const ::core::ffi::c_void, linenumber : u32, mutablemessage : ::windows_core::PCSTR));
    RtlAssert(voidfailedassertion, voidfilename, linenumber, mutablemessage.into_param().abi())
}
#[inline]
pub unsafe fn RtlCheckRegistryKey<P0>(relativeto: u32, path: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCheckRegistryKey(relativeto : u32, path : ::windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlCheckRegistryKey(relativeto, path.into_param().abi())
}
#[inline]
pub unsafe fn RtlClearAllBits(bitmapheader: *const RTL_BITMAP) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlClearAllBits(bitmapheader : *const RTL_BITMAP));
    RtlClearAllBits(bitmapheader)
}
#[inline]
pub unsafe fn RtlClearBit(bitmapheader: *const RTL_BITMAP, bitnumber: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlClearBit(bitmapheader : *const RTL_BITMAP, bitnumber : u32));
    RtlClearBit(bitmapheader, bitnumber)
}
#[inline]
pub unsafe fn RtlClearBits(bitmapheader: *const RTL_BITMAP, startingindex: u32, numbertoclear: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlClearBits(bitmapheader : *const RTL_BITMAP, startingindex : u32, numbertoclear : u32));
    RtlClearBits(bitmapheader, startingindex, numbertoclear)
}
#[inline]
pub unsafe fn RtlCmDecodeMemIoResource(descriptor: *const CM_PARTIAL_RESOURCE_DESCRIPTOR, start: ::core::option::Option<*mut u64>) -> u64 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCmDecodeMemIoResource(descriptor : *const CM_PARTIAL_RESOURCE_DESCRIPTOR, start : *mut u64) -> u64);
    RtlCmDecodeMemIoResource(descriptor, ::core::mem::transmute(start.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlCmEncodeMemIoResource(descriptor: *const CM_PARTIAL_RESOURCE_DESCRIPTOR, r#type: u8, length: u64, start: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCmEncodeMemIoResource(descriptor : *const CM_PARTIAL_RESOURCE_DESCRIPTOR, r#type : u8, length : u64, start : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlCmEncodeMemIoResource(descriptor, r#type, length, start)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlCompareString<P0>(string1: *const super::super::super::Win32::System::Kernel::STRING, string2: *const super::super::super::Win32::System::Kernel::STRING, caseinsensitive: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCompareString(string1 : *const super::super::super::Win32::System::Kernel:: STRING, string2 : *const super::super::super::Win32::System::Kernel:: STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    RtlCompareString(string1, string2, caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlCompareUnicodeString<P0>(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCompareUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    RtlCompareUnicodeString(string1, string2, caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlCompareUnicodeStrings<P0>(string1: &[u16], string2: &[u16], caseinsensitive: P0) -> i32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCompareUnicodeStrings(string1 : *const u16, string1length : usize, string2 : *const u16, string2length : usize, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> i32);
    RtlCompareUnicodeStrings(::core::mem::transmute(string1.as_ptr()), string1.len().try_into().unwrap(), ::core::mem::transmute(string2.as_ptr()), string2.len().try_into().unwrap(), caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlContractHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlContractHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlContractHashTable(hashtable)
}
#[inline]
pub unsafe fn RtlCopyBitMap(source: *const RTL_BITMAP, destination: *const RTL_BITMAP, targetbit: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCopyBitMap(source : *const RTL_BITMAP, destination : *const RTL_BITMAP, targetbit : u32));
    RtlCopyBitMap(source, destination, targetbit)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlCopyString(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: ::core::option::Option<*const super::super::super::Win32::System::Kernel::STRING>) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCopyString(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const super::super::super::Win32::System::Kernel:: STRING));
    RtlCopyString(destinationstring, ::core::mem::transmute(sourcestring.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn RtlCopyUnicodeString(destinationstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING, sourcestring: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCopyUnicodeString(destinationstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, sourcestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING));
    RtlCopyUnicodeString(destinationstring, ::core::mem::transmute(sourcestring.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn RtlCreateHashTable(hashtable: *mut *mut RTL_DYNAMIC_HASH_TABLE, shift: u32, flags: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCreateHashTable(hashtable : *mut *mut RTL_DYNAMIC_HASH_TABLE, shift : u32, flags : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlCreateHashTable(hashtable, shift, flags)
}
#[inline]
pub unsafe fn RtlCreateHashTableEx(hashtable: *mut *mut RTL_DYNAMIC_HASH_TABLE, initialsize: u32, shift: u32, flags: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCreateHashTableEx(hashtable : *mut *mut RTL_DYNAMIC_HASH_TABLE, initialsize : u32, shift : u32, flags : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlCreateHashTableEx(hashtable, initialsize, shift, flags)
}
#[inline]
pub unsafe fn RtlCreateRegistryKey<P0>(relativeto: u32, path: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCreateRegistryKey(relativeto : u32, path : ::windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlCreateRegistryKey(relativeto, path.into_param().abi())
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlCreateSecurityDescriptor(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, revision: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlCreateSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, revision : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlCreateSecurityDescriptor(securitydescriptor, revision)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlDelete(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDelete(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    RtlDelete(links)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlDeleteElementGenericTable(table: *const RTL_GENERIC_TABLE, buffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDeleteElementGenericTable(table : *const RTL_GENERIC_TABLE, buffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlDeleteElementGenericTable(table, buffer)
}
#[inline]
pub unsafe fn RtlDeleteElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDeleteElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlDeleteElementGenericTableAvl(table, buffer)
}
#[inline]
pub unsafe fn RtlDeleteElementGenericTableAvlEx(table: *const RTL_AVL_TABLE, nodeorparent: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDeleteElementGenericTableAvlEx(table : *const RTL_AVL_TABLE, nodeorparent : *const ::core::ffi::c_void));
    RtlDeleteElementGenericTableAvlEx(table, nodeorparent)
}
#[inline]
pub unsafe fn RtlDeleteHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDeleteHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE));
    RtlDeleteHashTable(hashtable)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlDeleteNoSplay(links: *const super::super::Foundation::RTL_SPLAY_LINKS, root: *mut *mut super::super::Foundation::RTL_SPLAY_LINKS) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDeleteNoSplay(links : *const super::super::Foundation:: RTL_SPLAY_LINKS, root : *mut *mut super::super::Foundation:: RTL_SPLAY_LINKS));
    RtlDeleteNoSplay(links, root)
}
#[inline]
pub unsafe fn RtlDeleteRegistryValue<P0, P1>(relativeto: u32, path: P0, valuename: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDeleteRegistryValue(relativeto : u32, path : ::windows_core::PCWSTR, valuename : ::windows_core::PCWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlDeleteRegistryValue(relativeto, path.into_param().abi(), valuename.into_param().abi())
}
#[inline]
pub unsafe fn RtlDowncaseUnicodeChar(sourcecharacter: u16) -> u16 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlDowncaseUnicodeChar(sourcecharacter : u16) -> u16);
    RtlDowncaseUnicodeChar(sourcecharacter)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEndEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEndEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR));
    RtlEndEnumerationHashTable(hashtable, enumerator)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEndStrongEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEndStrongEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR));
    RtlEndStrongEnumerationHashTable(hashtable, enumerator)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEndWeakEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEndWeakEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR));
    RtlEndWeakEnumerationHashTable(hashtable, enumerator)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEnumerateEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEnumerateEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    RtlEnumerateEntryHashTable(hashtable, enumerator)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlEnumerateGenericTable<P0>(table: *const RTL_GENERIC_TABLE, restart: P0) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEnumerateGenericTable(table : *const RTL_GENERIC_TABLE, restart : super::super::super::Win32::Foundation:: BOOLEAN) -> *mut ::core::ffi::c_void);
    RtlEnumerateGenericTable(table, restart.into_param().abi())
}
#[inline]
pub unsafe fn RtlEnumerateGenericTableAvl<P0>(table: *const RTL_AVL_TABLE, restart: P0) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableAvl(table : *const RTL_AVL_TABLE, restart : super::super::super::Win32::Foundation:: BOOLEAN) -> *mut ::core::ffi::c_void);
    RtlEnumerateGenericTableAvl(table, restart.into_param().abi())
}
#[inline]
pub unsafe fn RtlEnumerateGenericTableLikeADirectory(table: *const RTL_AVL_TABLE, matchfunction: PRTL_AVL_MATCH_FUNCTION, matchdata: ::core::option::Option<*const ::core::ffi::c_void>, nextflag: u32, restartkey: *mut *mut ::core::ffi::c_void, deletecount: *mut u32, buffer: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableLikeADirectory(table : *const RTL_AVL_TABLE, matchfunction : PRTL_AVL_MATCH_FUNCTION, matchdata : *const ::core::ffi::c_void, nextflag : u32, restartkey : *mut *mut ::core::ffi::c_void, deletecount : *mut u32, buffer : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    RtlEnumerateGenericTableLikeADirectory(table, matchfunction, ::core::mem::transmute(matchdata.unwrap_or(::std::ptr::null())), nextflag, restartkey, deletecount, buffer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlEnumerateGenericTableWithoutSplaying(table: *const RTL_GENERIC_TABLE, restartkey: *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableWithoutSplaying(table : *const RTL_GENERIC_TABLE, restartkey : *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    RtlEnumerateGenericTableWithoutSplaying(table, restartkey)
}
#[inline]
pub unsafe fn RtlEnumerateGenericTableWithoutSplayingAvl(table: *const RTL_AVL_TABLE, restartkey: *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEnumerateGenericTableWithoutSplayingAvl(table : *const RTL_AVL_TABLE, restartkey : *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    RtlEnumerateGenericTableWithoutSplayingAvl(table, restartkey)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlEqualString<P0>(string1: *const super::super::super::Win32::System::Kernel::STRING, string2: *const super::super::super::Win32::System::Kernel::STRING, caseinsensitive: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEqualString(string1 : *const super::super::super::Win32::System::Kernel:: STRING, string2 : *const super::super::super::Win32::System::Kernel:: STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlEqualString(string1, string2, caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlEqualUnicodeString<P0>(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlEqualUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlEqualUnicodeString(string1, string2, caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlExpandHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlExpandHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlExpandHashTable(hashtable)
}
#[inline]
pub unsafe fn RtlExtractBitMap(source: *const RTL_BITMAP, destination: *const RTL_BITMAP, targetbit: u32, numberofbits: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlExtractBitMap(source : *const RTL_BITMAP, destination : *const RTL_BITMAP, targetbit : u32, numberofbits : u32));
    RtlExtractBitMap(source, destination, targetbit, numberofbits)
}
#[inline]
pub unsafe fn RtlFindClearBits(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindClearBits(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    RtlFindClearBits(bitmapheader, numbertofind, hintindex)
}
#[inline]
pub unsafe fn RtlFindClearBitsAndSet(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindClearBitsAndSet(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    RtlFindClearBitsAndSet(bitmapheader, numbertofind, hintindex)
}
#[inline]
pub unsafe fn RtlFindClearRuns<P0>(bitmapheader: *const RTL_BITMAP, runarray: &mut [RTL_BITMAP_RUN], locatelongestruns: P0) -> u32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindClearRuns(bitmapheader : *const RTL_BITMAP, runarray : *mut RTL_BITMAP_RUN, sizeofrunarray : u32, locatelongestruns : super::super::super::Win32::Foundation:: BOOLEAN) -> u32);
    RtlFindClearRuns(bitmapheader, ::core::mem::transmute(runarray.as_ptr()), runarray.len().try_into().unwrap(), locatelongestruns.into_param().abi())
}
#[inline]
pub unsafe fn RtlFindClosestEncodableLength(sourcelength: u64, targetlength: *mut u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindClosestEncodableLength(sourcelength : u64, targetlength : *mut u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlFindClosestEncodableLength(sourcelength, targetlength)
}
#[inline]
pub unsafe fn RtlFindFirstRunClear(bitmapheader: *const RTL_BITMAP, startingindex: *mut u32) -> u32 {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlFindFirstRunClear(bitmapheader : *const RTL_BITMAP, startingindex : *mut u32) -> u32);
    RtlFindFirstRunClear(bitmapheader, startingindex)
}
#[inline]
pub unsafe fn RtlFindLastBackwardRunClear(bitmapheader: *const RTL_BITMAP, fromindex: u32, startingrunindex: *mut u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindLastBackwardRunClear(bitmapheader : *const RTL_BITMAP, fromindex : u32, startingrunindex : *mut u32) -> u32);
    RtlFindLastBackwardRunClear(bitmapheader, fromindex, startingrunindex)
}
#[inline]
pub unsafe fn RtlFindLeastSignificantBit(set: u64) -> i8 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindLeastSignificantBit(set : u64) -> i8);
    RtlFindLeastSignificantBit(set)
}
#[inline]
pub unsafe fn RtlFindLongestRunClear(bitmapheader: *const RTL_BITMAP, startingindex: *mut u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindLongestRunClear(bitmapheader : *const RTL_BITMAP, startingindex : *mut u32) -> u32);
    RtlFindLongestRunClear(bitmapheader, startingindex)
}
#[inline]
pub unsafe fn RtlFindMostSignificantBit(set: u64) -> i8 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindMostSignificantBit(set : u64) -> i8);
    RtlFindMostSignificantBit(set)
}
#[inline]
pub unsafe fn RtlFindNextForwardRunClear(bitmapheader: *const RTL_BITMAP, fromindex: u32, startingrunindex: *mut u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindNextForwardRunClear(bitmapheader : *const RTL_BITMAP, fromindex : u32, startingrunindex : *mut u32) -> u32);
    RtlFindNextForwardRunClear(bitmapheader, fromindex, startingrunindex)
}
#[inline]
pub unsafe fn RtlFindSetBits(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindSetBits(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    RtlFindSetBits(bitmapheader, numbertofind, hintindex)
}
#[inline]
pub unsafe fn RtlFindSetBitsAndClear(bitmapheader: *const RTL_BITMAP, numbertofind: u32, hintindex: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFindSetBitsAndClear(bitmapheader : *const RTL_BITMAP, numbertofind : u32, hintindex : u32) -> u32);
    RtlFindSetBitsAndClear(bitmapheader, numbertofind, hintindex)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlFreeUTF8String(utf8string: ::core::option::Option<*mut super::super::super::Win32::System::Kernel::STRING>) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlFreeUTF8String(utf8string : *mut super::super::super::Win32::System::Kernel:: STRING));
    RtlFreeUTF8String(::core::mem::transmute(utf8string.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlGUIDFromString(guidstring: *const super::super::super::Win32::Foundation::UNICODE_STRING, guid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGUIDFromString(guidstring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, guid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlGUIDFromString(guidstring, guid)
}
#[inline]
pub unsafe fn RtlGenerateClass5Guid(namespaceguid: *const ::windows_core::GUID, buffer: *const ::core::ffi::c_void, buffersize: u32, guid: *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlGenerateClass5Guid(namespaceguid : *const ::windows_core::GUID, buffer : *const ::core::ffi::c_void, buffersize : u32, guid : *mut ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlGenerateClass5Guid(namespaceguid, buffer, buffersize, guid)
}
#[inline]
pub unsafe fn RtlGetActiveConsoleId() -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetActiveConsoleId() -> u32);
    RtlGetActiveConsoleId()
}
#[inline]
pub unsafe fn RtlGetCallersAddress(callersaddress: *mut *mut ::core::ffi::c_void, callerscaller: *mut *mut ::core::ffi::c_void) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetCallersAddress(callersaddress : *mut *mut ::core::ffi::c_void, callerscaller : *mut *mut ::core::ffi::c_void));
    RtlGetCallersAddress(callersaddress, callerscaller)
}
#[inline]
pub unsafe fn RtlGetConsoleSessionForegroundProcessId() -> u64 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetConsoleSessionForegroundProcessId() -> u64);
    RtlGetConsoleSessionForegroundProcessId()
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlGetElementGenericTable(table: *const RTL_GENERIC_TABLE, i: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetElementGenericTable(table : *const RTL_GENERIC_TABLE, i : u32) -> *mut ::core::ffi::c_void);
    RtlGetElementGenericTable(table, i)
}
#[inline]
pub unsafe fn RtlGetElementGenericTableAvl(table: *const RTL_AVL_TABLE, i: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetElementGenericTableAvl(table : *const RTL_AVL_TABLE, i : u32) -> *mut ::core::ffi::c_void);
    RtlGetElementGenericTableAvl(table, i)
}
#[inline]
pub unsafe fn RtlGetEnabledExtendedFeatures(featuremask: u64) -> u64 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetEnabledExtendedFeatures(featuremask : u64) -> u64);
    RtlGetEnabledExtendedFeatures(featuremask)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlGetNextEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, context: *const RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetNextEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, context : *const RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    RtlGetNextEntryHashTable(hashtable, context)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlGetNtProductType(ntproducttype: *mut super::super::super::Win32::System::Kernel::NT_PRODUCT_TYPE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetNtProductType(ntproducttype : *mut super::super::super::Win32::System::Kernel:: NT_PRODUCT_TYPE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlGetNtProductType(ntproducttype)
}
#[inline]
pub unsafe fn RtlGetNtSystemRoot() -> ::windows_core::PCWSTR {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetNtSystemRoot() -> ::windows_core::PCWSTR);
    RtlGetNtSystemRoot()
}
#[inline]
pub unsafe fn RtlGetPersistedStateLocation<P0, P1, P2>(sourceid: P0, customvalue: P1, defaultpath: P2, statelocationtype: STATE_LOCATION_TYPE, targetpath: ::windows_core::PWSTR, bufferlengthin: u32, bufferlengthout: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetPersistedStateLocation(sourceid : ::windows_core::PCWSTR, customvalue : ::windows_core::PCWSTR, defaultpath : ::windows_core::PCWSTR, statelocationtype : STATE_LOCATION_TYPE, targetpath : ::windows_core::PWSTR, bufferlengthin : u32, bufferlengthout : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlGetPersistedStateLocation(sourceid.into_param().abi(), customvalue.into_param().abi(), defaultpath.into_param().abi(), statelocationtype, ::core::mem::transmute(targetpath), bufferlengthin, ::core::mem::transmute(bufferlengthout.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlGetSuiteMask() -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetSuiteMask() -> u32);
    RtlGetSuiteMask()
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn RtlGetVersion(lpversioninformation: *mut super::super::super::Win32::System::SystemInformation::OSVERSIONINFOW) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlGetVersion(lpversioninformation : *mut super::super::super::Win32::System::SystemInformation:: OSVERSIONINFOW) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlGetVersion(lpversioninformation)
}
#[inline]
pub unsafe fn RtlHashUnicodeString<P0>(string: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: P0, hashalgorithm: u32, hashvalue: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlHashUnicodeString(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN, hashalgorithm : u32, hashvalue : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlHashUnicodeString(string, caseinsensitive.into_param().abi(), hashalgorithm, hashvalue)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlInitEnumerationHashTable(hashtable, enumerator)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitStrongEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitStrongEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlInitStrongEnumerationHashTable(hashtable, enumerator)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitUTF8String(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: ::core::option::Option<*const i8>) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitUTF8String(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const i8));
    RtlInitUTF8String(destinationstring, ::core::mem::transmute(sourcestring.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitUTF8StringEx(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: ::core::option::Option<*const i8>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitUTF8StringEx(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const i8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlInitUTF8StringEx(destinationstring, ::core::mem::transmute(sourcestring.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInitWeakEnumerationHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitWeakEnumerationHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlInitWeakEnumerationHashTable(hashtable, enumerator)
}
#[inline]
pub unsafe fn RtlInitializeBitMap(bitmapheader: *mut RTL_BITMAP, bitmapbuffer: ::core::option::Option<*const u32>, sizeofbitmap: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitializeBitMap(bitmapheader : *mut RTL_BITMAP, bitmapbuffer : *const u32, sizeofbitmap : u32));
    RtlInitializeBitMap(bitmapheader, ::core::mem::transmute(bitmapbuffer.unwrap_or(::std::ptr::null())), sizeofbitmap)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlInitializeGenericTable(table: *mut RTL_GENERIC_TABLE, compareroutine: PRTL_GENERIC_COMPARE_ROUTINE, allocateroutine: PRTL_GENERIC_ALLOCATE_ROUTINE, freeroutine: PRTL_GENERIC_FREE_ROUTINE, tablecontext: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitializeGenericTable(table : *mut RTL_GENERIC_TABLE, compareroutine : PRTL_GENERIC_COMPARE_ROUTINE, allocateroutine : PRTL_GENERIC_ALLOCATE_ROUTINE, freeroutine : PRTL_GENERIC_FREE_ROUTINE, tablecontext : *const ::core::ffi::c_void));
    RtlInitializeGenericTable(table, compareroutine, allocateroutine, freeroutine, ::core::mem::transmute(tablecontext.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn RtlInitializeGenericTableAvl(table: *mut RTL_AVL_TABLE, compareroutine: PRTL_AVL_COMPARE_ROUTINE, allocateroutine: PRTL_AVL_ALLOCATE_ROUTINE, freeroutine: PRTL_AVL_FREE_ROUTINE, tablecontext: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInitializeGenericTableAvl(table : *mut RTL_AVL_TABLE, compareroutine : PRTL_AVL_COMPARE_ROUTINE, allocateroutine : PRTL_AVL_ALLOCATE_ROUTINE, freeroutine : PRTL_AVL_FREE_ROUTINE, tablecontext : *const ::core::ffi::c_void));
    RtlInitializeGenericTableAvl(table, compareroutine, allocateroutine, freeroutine, ::core::mem::transmute(tablecontext.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlInsertElementGenericTable(table: *const RTL_GENERIC_TABLE, buffer: *const ::core::ffi::c_void, buffersize: u32, newelement: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInsertElementGenericTable(table : *const RTL_GENERIC_TABLE, buffer : *const ::core::ffi::c_void, buffersize : u32, newelement : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> *mut ::core::ffi::c_void);
    RtlInsertElementGenericTable(table, buffer, buffersize, ::core::mem::transmute(newelement.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlInsertElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const ::core::ffi::c_void, buffersize: u32, newelement: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInsertElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const ::core::ffi::c_void, buffersize : u32, newelement : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> *mut ::core::ffi::c_void);
    RtlInsertElementGenericTableAvl(table, buffer, buffersize, ::core::mem::transmute(newelement.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlInsertElementGenericTableFull(table: *const RTL_GENERIC_TABLE, buffer: *const ::core::ffi::c_void, buffersize: u32, newelement: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>, nodeorparent: *const ::core::ffi::c_void, searchresult: TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInsertElementGenericTableFull(table : *const RTL_GENERIC_TABLE, buffer : *const ::core::ffi::c_void, buffersize : u32, newelement : *mut super::super::super::Win32::Foundation:: BOOLEAN, nodeorparent : *const ::core::ffi::c_void, searchresult : TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void);
    RtlInsertElementGenericTableFull(table, buffer, buffersize, ::core::mem::transmute(newelement.unwrap_or(::std::ptr::null_mut())), nodeorparent, searchresult)
}
#[inline]
pub unsafe fn RtlInsertElementGenericTableFullAvl(table: *const RTL_AVL_TABLE, buffer: *const ::core::ffi::c_void, buffersize: u32, newelement: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>, nodeorparent: *const ::core::ffi::c_void, searchresult: TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInsertElementGenericTableFullAvl(table : *const RTL_AVL_TABLE, buffer : *const ::core::ffi::c_void, buffersize : u32, newelement : *mut super::super::super::Win32::Foundation:: BOOLEAN, nodeorparent : *const ::core::ffi::c_void, searchresult : TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void);
    RtlInsertElementGenericTableFullAvl(table, buffer, buffersize, ::core::mem::transmute(newelement.unwrap_or(::std::ptr::null_mut())), nodeorparent, searchresult)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlInsertEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, entry: *const RTL_DYNAMIC_HASH_TABLE_ENTRY, signature: usize, context: ::core::option::Option<*mut RTL_DYNAMIC_HASH_TABLE_CONTEXT>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInsertEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, entry : *const RTL_DYNAMIC_HASH_TABLE_ENTRY, signature : usize, context : *mut RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlInsertEntryHashTable(hashtable, entry, signature, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlInt64ToUnicodeString(value: u64, base: u32, string: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlInt64ToUnicodeString(value : u64, base : u32, string : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlInt64ToUnicodeString(value, base, string)
}
#[inline]
pub unsafe fn RtlIntegerToUnicodeString(value: u32, base: u32, string: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIntegerToUnicodeString(value : u32, base : u32, string : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlIntegerToUnicodeString(value, base, string)
}
#[inline]
pub unsafe fn RtlIoDecodeMemIoResource(descriptor: *const IO_RESOURCE_DESCRIPTOR, alignment: ::core::option::Option<*mut u64>, minimumaddress: ::core::option::Option<*mut u64>, maximumaddress: ::core::option::Option<*mut u64>) -> u64 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIoDecodeMemIoResource(descriptor : *const IO_RESOURCE_DESCRIPTOR, alignment : *mut u64, minimumaddress : *mut u64, maximumaddress : *mut u64) -> u64);
    RtlIoDecodeMemIoResource(descriptor, ::core::mem::transmute(alignment.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(minimumaddress.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(maximumaddress.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlIoEncodeMemIoResource(descriptor: *const IO_RESOURCE_DESCRIPTOR, r#type: u8, length: u64, alignment: u64, minimumaddress: u64, maximumaddress: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIoEncodeMemIoResource(descriptor : *const IO_RESOURCE_DESCRIPTOR, r#type : u8, length : u64, alignment : u64, minimumaddress : u64, maximumaddress : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlIoEncodeMemIoResource(descriptor, r#type, length, alignment, minimumaddress, maximumaddress)
}
#[inline]
pub unsafe fn RtlIsApiSetImplemented<P0>(apisetname: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsApiSetImplemented(apisetname : ::windows_core::PCSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlIsApiSetImplemented(apisetname.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlIsGenericTableEmpty(table: *const RTL_GENERIC_TABLE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsGenericTableEmpty(table : *const RTL_GENERIC_TABLE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsGenericTableEmpty(table)
}
#[inline]
pub unsafe fn RtlIsGenericTableEmptyAvl(table: *const RTL_AVL_TABLE) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsGenericTableEmptyAvl(table : *const RTL_AVL_TABLE) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsGenericTableEmptyAvl(table)
}
#[inline]
pub unsafe fn RtlIsMultiSessionSku() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsMultiSessionSku() -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsMultiSessionSku()
}
#[inline]
pub unsafe fn RtlIsMultiUsersInSessionSku() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsMultiUsersInSessionSku() -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsMultiUsersInSessionSku()
}
#[inline]
pub unsafe fn RtlIsNtDdiVersionAvailable(version: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlIsNtDdiVersionAvailable(version : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsNtDdiVersionAvailable(version)
}
#[inline]
pub unsafe fn RtlIsServicePackVersionInstalled(version: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlIsServicePackVersionInstalled(version : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsServicePackVersionInstalled(version)
}
#[inline]
pub unsafe fn RtlIsStateSeparationEnabled() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsStateSeparationEnabled() -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlIsStateSeparationEnabled()
}
#[inline]
pub unsafe fn RtlIsUntrustedObject<P0>(handle: P0, object: ::core::option::Option<*const ::core::ffi::c_void>, untrustedobject: *mut super::super::super::Win32::Foundation::BOOLEAN) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlIsUntrustedObject(handle : super::super::super::Win32::Foundation:: HANDLE, object : *const ::core::ffi::c_void, untrustedobject : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlIsUntrustedObject(handle.into_param().abi(), ::core::mem::transmute(object.unwrap_or(::std::ptr::null())), untrustedobject)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlLengthSecurityDescriptor<P0>(securitydescriptor: P0) -> u32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLengthSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> u32);
    RtlLengthSecurityDescriptor(securitydescriptor.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlLookupElementGenericTable(table: *const RTL_GENERIC_TABLE, buffer: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLookupElementGenericTable(table : *const RTL_GENERIC_TABLE, buffer : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    RtlLookupElementGenericTable(table, buffer)
}
#[inline]
pub unsafe fn RtlLookupElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLookupElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    RtlLookupElementGenericTableAvl(table, buffer)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlLookupElementGenericTableFull(table: *const RTL_GENERIC_TABLE, buffer: *const ::core::ffi::c_void, nodeorparent: *mut *mut ::core::ffi::c_void, searchresult: *mut TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLookupElementGenericTableFull(table : *const RTL_GENERIC_TABLE, buffer : *const ::core::ffi::c_void, nodeorparent : *mut *mut ::core::ffi::c_void, searchresult : *mut TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void);
    RtlLookupElementGenericTableFull(table, buffer, nodeorparent, searchresult)
}
#[inline]
pub unsafe fn RtlLookupElementGenericTableFullAvl(table: *const RTL_AVL_TABLE, buffer: *const ::core::ffi::c_void, nodeorparent: *mut *mut ::core::ffi::c_void, searchresult: *mut TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLookupElementGenericTableFullAvl(table : *const RTL_AVL_TABLE, buffer : *const ::core::ffi::c_void, nodeorparent : *mut *mut ::core::ffi::c_void, searchresult : *mut TABLE_SEARCH_RESULT) -> *mut ::core::ffi::c_void);
    RtlLookupElementGenericTableFullAvl(table, buffer, nodeorparent, searchresult)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlLookupEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, signature: usize, context: ::core::option::Option<*mut RTL_DYNAMIC_HASH_TABLE_CONTEXT>) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLookupEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, signature : usize, context : *mut RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    RtlLookupEntryHashTable(hashtable, signature, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlLookupFirstMatchingElementGenericTableAvl(table: *const RTL_AVL_TABLE, buffer: *const ::core::ffi::c_void, restartkey: *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlLookupFirstMatchingElementGenericTableAvl(table : *const RTL_AVL_TABLE, buffer : *const ::core::ffi::c_void, restartkey : *mut *mut ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    RtlLookupFirstMatchingElementGenericTableAvl(table, buffer, restartkey)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlMapGenericMask(accessmask: *mut u32, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlMapGenericMask(accessmask : *mut u32, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING));
    RtlMapGenericMask(accessmask, genericmapping)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlNormalizeSecurityDescriptor<P0>(securitydescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, securitydescriptorlength: u32, newsecuritydescriptor: ::core::option::Option<*mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>, newsecuritydescriptorlength: ::core::option::Option<*mut u32>, checkonly: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNormalizeSecurityDescriptor(securitydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, securitydescriptorlength : u32, newsecuritydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, newsecuritydescriptorlength : *mut u32, checkonly : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlNormalizeSecurityDescriptor(securitydescriptor, securitydescriptorlength, ::core::mem::transmute(newsecuritydescriptor.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(newsecuritydescriptorlength.unwrap_or(::std::ptr::null_mut())), checkonly.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn RtlNumberGenericTableElements(table: *const RTL_GENERIC_TABLE) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberGenericTableElements(table : *const RTL_GENERIC_TABLE) -> u32);
    RtlNumberGenericTableElements(table)
}
#[inline]
pub unsafe fn RtlNumberGenericTableElementsAvl(table: *const RTL_AVL_TABLE) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberGenericTableElementsAvl(table : *const RTL_AVL_TABLE) -> u32);
    RtlNumberGenericTableElementsAvl(table)
}
#[inline]
pub unsafe fn RtlNumberOfClearBits(bitmapheader: *const RTL_BITMAP) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberOfClearBits(bitmapheader : *const RTL_BITMAP) -> u32);
    RtlNumberOfClearBits(bitmapheader)
}
#[inline]
pub unsafe fn RtlNumberOfClearBitsInRange(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberOfClearBitsInRange(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> u32);
    RtlNumberOfClearBitsInRange(bitmapheader, startingindex, length)
}
#[inline]
pub unsafe fn RtlNumberOfSetBits(bitmapheader: *const RTL_BITMAP) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberOfSetBits(bitmapheader : *const RTL_BITMAP) -> u32);
    RtlNumberOfSetBits(bitmapheader)
}
#[inline]
pub unsafe fn RtlNumberOfSetBitsInRange(bitmapheader: *const RTL_BITMAP, startingindex: u32, length: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberOfSetBitsInRange(bitmapheader : *const RTL_BITMAP, startingindex : u32, length : u32) -> u32);
    RtlNumberOfSetBitsInRange(bitmapheader, startingindex, length)
}
#[inline]
pub unsafe fn RtlNumberOfSetBitsUlongPtr(target: usize) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlNumberOfSetBitsUlongPtr(target : usize) -> u32);
    RtlNumberOfSetBitsUlongPtr(target)
}
#[inline]
pub unsafe fn RtlPrefetchMemoryNonTemporal(source: *const ::core::ffi::c_void, length: usize) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlPrefetchMemoryNonTemporal(source : *const ::core::ffi::c_void, length : usize));
    RtlPrefetchMemoryNonTemporal(source, length)
}
#[inline]
pub unsafe fn RtlPrefixUnicodeString<P0>(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlPrefixUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlPrefixUnicodeString(string1, string2, caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlQueryRegistryValueWithFallback<P0, P1>(primaryhandle: P0, fallbackhandle: P1, valuename: *const super::super::super::Win32::Foundation::UNICODE_STRING, valuelength: u32, valuetype: ::core::option::Option<*mut u32>, valuedata: *mut ::core::ffi::c_void, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlQueryRegistryValueWithFallback(primaryhandle : super::super::super::Win32::Foundation:: HANDLE, fallbackhandle : super::super::super::Win32::Foundation:: HANDLE, valuename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, valuelength : u32, valuetype : *mut u32, valuedata : *mut ::core::ffi::c_void, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlQueryRegistryValueWithFallback(primaryhandle.into_param().abi(), fallbackhandle.into_param().abi(), valuename, valuelength, ::core::mem::transmute(valuetype.unwrap_or(::std::ptr::null_mut())), valuedata, resultlength)
}
#[inline]
pub unsafe fn RtlQueryRegistryValues<P0>(relativeto: u32, path: P0, querytable: *mut RTL_QUERY_REGISTRY_TABLE, context: ::core::option::Option<*const ::core::ffi::c_void>, environment: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlQueryRegistryValues(relativeto : u32, path : ::windows_core::PCWSTR, querytable : *mut RTL_QUERY_REGISTRY_TABLE, context : *const ::core::ffi::c_void, environment : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlQueryRegistryValues(relativeto, path.into_param().abi(), querytable, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())), ::core::mem::transmute(environment.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn RtlQueryValidationRunlevel(componentname: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlQueryValidationRunlevel(componentname : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> u32);
    RtlQueryValidationRunlevel(::core::mem::transmute(componentname.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlRealPredecessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRealPredecessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    RtlRealPredecessor(links)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlRealSuccessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRealSuccessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    RtlRealSuccessor(links)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlRemoveEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, entry: *const RTL_DYNAMIC_HASH_TABLE_ENTRY, context: ::core::option::Option<*mut RTL_DYNAMIC_HASH_TABLE_CONTEXT>) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRemoveEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, entry : *const RTL_DYNAMIC_HASH_TABLE_ENTRY, context : *mut RTL_DYNAMIC_HASH_TABLE_CONTEXT) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlRemoveEntryHashTable(hashtable, entry, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceBeginInitialize(runonce: *mut super::super::super::Win32::System::Threading::INIT_ONCE, flags: u32, context: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRunOnceBeginInitialize(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE, flags : u32, context : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlRunOnceBeginInitialize(runonce, flags, ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceComplete(runonce: *mut super::super::super::Win32::System::Threading::INIT_ONCE, flags: u32, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRunOnceComplete(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE, flags : u32, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlRunOnceComplete(runonce, flags, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceExecuteOnce(runonce: *mut super::super::super::Win32::System::Threading::INIT_ONCE, initfn: PRTL_RUN_ONCE_INIT_FN, parameter: ::core::option::Option<*mut ::core::ffi::c_void>, context: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRunOnceExecuteOnce(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE, initfn : PRTL_RUN_ONCE_INIT_FN, parameter : *mut ::core::ffi::c_void, context : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlRunOnceExecuteOnce(runonce, initfn, ::core::mem::transmute(parameter.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_Threading")]
#[inline]
pub unsafe fn RtlRunOnceInitialize() -> super::super::super::Win32::System::Threading::INIT_ONCE {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlRunOnceInitialize(runonce : *mut super::super::super::Win32::System::Threading:: INIT_ONCE));
    let mut result__ = ::std::mem::zeroed();
    RtlRunOnceInitialize(&mut result__);
    result__
}
#[inline]
pub unsafe fn RtlSetAllBits(bitmapheader: *const RTL_BITMAP) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSetAllBits(bitmapheader : *const RTL_BITMAP));
    RtlSetAllBits(bitmapheader)
}
#[inline]
pub unsafe fn RtlSetBit(bitmapheader: *const RTL_BITMAP, bitnumber: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSetBit(bitmapheader : *const RTL_BITMAP, bitnumber : u32));
    RtlSetBit(bitmapheader, bitnumber)
}
#[inline]
pub unsafe fn RtlSetBits(bitmapheader: *const RTL_BITMAP, startingindex: u32, numbertoset: u32) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSetBits(bitmapheader : *const RTL_BITMAP, startingindex : u32, numbertoset : u32));
    RtlSetBits(bitmapheader, startingindex, numbertoset)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlSetDaclSecurityDescriptor<P0, P1>(securitydescriptor: super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, daclpresent: P0, dacl: ::core::option::Option<*const super::super::super::Win32::Security::ACL>, dacldefaulted: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSetDaclSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, daclpresent : super::super::super::Win32::Foundation:: BOOLEAN, dacl : *const super::super::super::Win32::Security:: ACL, dacldefaulted : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlSetDaclSecurityDescriptor(securitydescriptor, daclpresent.into_param().abi(), ::core::mem::transmute(dacl.unwrap_or(::std::ptr::null())), dacldefaulted.into_param().abi())
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn RtlSetSystemGlobalData(dataid: super::super::super::Win32::System::SystemInformation::RTL_SYSTEM_GLOBAL_DATA_ID, buffer: *const ::core::ffi::c_void, size: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlSetSystemGlobalData(dataid : super::super::super::Win32::System::SystemInformation:: RTL_SYSTEM_GLOBAL_DATA_ID, buffer : *const ::core::ffi::c_void, size : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlSetSystemGlobalData(dataid, buffer, size)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlSplay(links: *mut super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSplay(links : *mut super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    RtlSplay(links)
}
#[inline]
pub unsafe fn RtlStringFromGUID(guid: *const ::windows_core::GUID, guidstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlStringFromGUID(guid : *const ::windows_core::GUID, guidstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlStringFromGUID(guid, guidstring)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlStronglyEnumerateEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlStronglyEnumerateEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    RtlStronglyEnumerateEntryHashTable(hashtable, enumerator)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlSubtreePredecessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSubtreePredecessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    RtlSubtreePredecessor(links)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn RtlSubtreeSuccessor(links: *const super::super::Foundation::RTL_SPLAY_LINKS) -> *mut super::super::Foundation::RTL_SPLAY_LINKS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlSubtreeSuccessor(links : *const super::super::Foundation:: RTL_SPLAY_LINKS) -> *mut super::super::Foundation:: RTL_SPLAY_LINKS);
    RtlSubtreeSuccessor(links)
}
#[inline]
pub unsafe fn RtlSuffixUnicodeString<P0>(string1: *const super::super::super::Win32::Foundation::UNICODE_STRING, string2: *const super::super::super::Win32::Foundation::UNICODE_STRING, caseinsensitive: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlSuffixUnicodeString(string1 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, string2 : *const super::super::super::Win32::Foundation:: UNICODE_STRING, caseinsensitive : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlSuffixUnicodeString(string1, string2, caseinsensitive.into_param().abi())
}
#[inline]
pub unsafe fn RtlTestBit(bitmapheader: *const RTL_BITMAP, bitnumber: u32) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlTestBit(bitmapheader : *const RTL_BITMAP, bitnumber : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlTestBit(bitmapheader, bitnumber)
}
#[inline]
pub unsafe fn RtlTimeFieldsToTime(timefields: *const TIME_FIELDS, time: *mut i64) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlTimeFieldsToTime(timefields : *const TIME_FIELDS, time : *mut i64) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlTimeFieldsToTime(timefields, time)
}
#[inline]
pub unsafe fn RtlTimeToTimeFields(time: *const i64) -> TIME_FIELDS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlTimeToTimeFields(time : *const i64, timefields : *mut TIME_FIELDS));
    let mut result__ = ::std::mem::zeroed();
    RtlTimeToTimeFields(time, &mut result__);
    result__
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlUTF8StringToUnicodeString<P0>(destinationstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING, sourcestring: *const super::super::super::Win32::System::Kernel::STRING, allocatedestinationstring: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUTF8StringToUnicodeString(destinationstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, sourcestring : *const super::super::super::Win32::System::Kernel:: STRING, allocatedestinationstring : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUTF8StringToUnicodeString(destinationstring, sourcestring, allocatedestinationstring.into_param().abi())
}
#[inline]
pub unsafe fn RtlUTF8ToUnicodeN(unicodestringdestination: ::windows_core::PWSTR, unicodestringmaxbytecount: u32, unicodestringactualbytecount: *mut u32, utf8stringsource: &[u8]) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUTF8ToUnicodeN(unicodestringdestination : ::windows_core::PWSTR, unicodestringmaxbytecount : u32, unicodestringactualbytecount : *mut u32, utf8stringsource : ::windows_core::PCSTR, utf8stringbytecount : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUTF8ToUnicodeN(::core::mem::transmute(unicodestringdestination), unicodestringmaxbytecount, unicodestringactualbytecount, ::core::mem::transmute(utf8stringsource.as_ptr()), utf8stringsource.len().try_into().unwrap())
}
#[inline]
pub unsafe fn RtlUnicodeStringToInt64(string: *const super::super::super::Win32::Foundation::UNICODE_STRING, base: u32, number: *mut i64, endpointer: ::core::option::Option<*mut ::windows_core::PWSTR>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlUnicodeStringToInt64(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, base : u32, number : *mut i64, endpointer : *mut ::windows_core::PWSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUnicodeStringToInt64(string, base, number, ::core::mem::transmute(endpointer.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn RtlUnicodeStringToInteger(string: *const super::super::super::Win32::Foundation::UNICODE_STRING, base: u32, value: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUnicodeStringToInteger(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING, base : u32, value : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUnicodeStringToInteger(string, base, value)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlUnicodeStringToUTF8String<P0>(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: *const super::super::super::Win32::Foundation::UNICODE_STRING, allocatedestinationstring: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUnicodeStringToUTF8String(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, allocatedestinationstring : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUnicodeStringToUTF8String(destinationstring, sourcestring, allocatedestinationstring.into_param().abi())
}
#[inline]
pub unsafe fn RtlUnicodeToUTF8N(utf8stringdestination: &mut [u8], utf8stringactualbytecount: *mut u32, unicodestringsource: *const u16, unicodestringbytecount: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUnicodeToUTF8N(utf8stringdestination : ::windows_core::PSTR, utf8stringmaxbytecount : u32, utf8stringactualbytecount : *mut u32, unicodestringsource : *const u16, unicodestringbytecount : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUnicodeToUTF8N(::core::mem::transmute(utf8stringdestination.as_ptr()), utf8stringdestination.len().try_into().unwrap(), utf8stringactualbytecount, unicodestringsource, unicodestringbytecount)
}
#[inline]
pub unsafe fn RtlUpcaseUnicodeChar(sourcecharacter: u16) -> u16 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUpcaseUnicodeChar(sourcecharacter : u16) -> u16);
    RtlUpcaseUnicodeChar(sourcecharacter)
}
#[inline]
pub unsafe fn RtlUpcaseUnicodeString<P0>(destinationstring: *mut super::super::super::Win32::Foundation::UNICODE_STRING, sourcestring: *const super::super::super::Win32::Foundation::UNICODE_STRING, allocatedestinationstring: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUpcaseUnicodeString(destinationstring : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, sourcestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING, allocatedestinationstring : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlUpcaseUnicodeString(destinationstring, sourcestring, allocatedestinationstring.into_param().abi())
}
#[inline]
pub unsafe fn RtlUpperChar(character: i8) -> i8 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUpperChar(character : i8) -> i8);
    RtlUpperChar(character)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlUpperString(destinationstring: *mut super::super::super::Win32::System::Kernel::STRING, sourcestring: *const super::super::super::Win32::System::Kernel::STRING) {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlUpperString(destinationstring : *mut super::super::super::Win32::System::Kernel:: STRING, sourcestring : *const super::super::super::Win32::System::Kernel:: STRING));
    RtlUpperString(destinationstring, sourcestring)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlValidRelativeSecurityDescriptor<P0>(securitydescriptorinput: P0, securitydescriptorlength: u32, requiredinformation: u32) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlValidRelativeSecurityDescriptor(securitydescriptorinput : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, securitydescriptorlength : u32, requiredinformation : u32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlValidRelativeSecurityDescriptor(securitydescriptorinput.into_param().abi(), securitydescriptorlength, requiredinformation)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn RtlValidSecurityDescriptor<P0>(securitydescriptor: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlValidSecurityDescriptor(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> super::super::super::Win32::Foundation:: BOOLEAN);
    RtlValidSecurityDescriptor(securitydescriptor.into_param().abi())
}
#[cfg(feature = "Win32_System_SystemInformation")]
#[inline]
pub unsafe fn RtlVerifyVersionInfo(versioninfo: *const super::super::super::Win32::System::SystemInformation::OSVERSIONINFOEXW, typemask: u32, conditionmask: u64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlVerifyVersionInfo(versioninfo : *const super::super::super::Win32::System::SystemInformation:: OSVERSIONINFOEXW, typemask : u32, conditionmask : u64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlVerifyVersionInfo(versioninfo, typemask, conditionmask)
}
#[inline]
pub unsafe fn RtlVolumeDeviceToDosName(volumedeviceobject: *const ::core::ffi::c_void, dosname: *mut super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn RtlVolumeDeviceToDosName(volumedeviceobject : *const ::core::ffi::c_void, dosname : *mut super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlVolumeDeviceToDosName(volumedeviceobject, dosname)
}
#[inline]
pub unsafe fn RtlWalkFrameChain(callers: *mut *mut ::core::ffi::c_void, count: u32, flags: u32) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlWalkFrameChain(callers : *mut *mut ::core::ffi::c_void, count : u32, flags : u32) -> u32);
    RtlWalkFrameChain(callers, count, flags)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlWeaklyEnumerateEntryHashTable(hashtable: *const RTL_DYNAMIC_HASH_TABLE, enumerator: *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlWeaklyEnumerateEntryHashTable(hashtable : *const RTL_DYNAMIC_HASH_TABLE, enumerator : *mut RTL_DYNAMIC_HASH_TABLE_ENUMERATOR) -> *mut RTL_DYNAMIC_HASH_TABLE_ENTRY);
    RtlWeaklyEnumerateEntryHashTable(hashtable, enumerator)
}
#[inline]
pub unsafe fn RtlWriteRegistryValue<P0, P1>(relativeto: u32, path: P0, valuename: P1, valuetype: u32, valuedata: ::core::option::Option<*const ::core::ffi::c_void>, valuelength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn RtlWriteRegistryValue(relativeto : u32, path : ::windows_core::PCWSTR, valuename : ::windows_core::PCWSTR, valuetype : u32, valuedata : *const ::core::ffi::c_void, valuelength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    RtlWriteRegistryValue(relativeto, path.into_param().abi(), valuename.into_param().abi(), valuetype, ::core::mem::transmute(valuedata.unwrap_or(::std::ptr::null())), valuelength)
}
#[cfg(feature = "Win32_System_Kernel")]
#[inline]
pub unsafe fn RtlxAnsiStringToUnicodeSize(ansistring: *const super::super::super::Win32::System::Kernel::STRING) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlxAnsiStringToUnicodeSize(ansistring : *const super::super::super::Win32::System::Kernel:: STRING) -> u32);
    RtlxAnsiStringToUnicodeSize(ansistring)
}
#[inline]
pub unsafe fn RtlxUnicodeStringToAnsiSize(unicodestring: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> u32 {
    ::windows_targets::link!("ntdll.dll" "system" fn RtlxUnicodeStringToAnsiSize(unicodestring : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> u32);
    RtlxUnicodeStringToAnsiSize(unicodestring)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeAccessCheck<P0, P1>(securitydescriptor: P0, subjectsecuritycontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT, subjectcontextlocked: P1, desiredaccess: u32, previouslygrantedaccess: u32, privileges: ::core::option::Option<*mut *mut super::super::super::Win32::Security::PRIVILEGE_SET>, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING, accessmode: i8, grantedaccess: *mut u32, accessstatus: *mut i32) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeAccessCheck(securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, subjectsecuritycontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT, subjectcontextlocked : super::super::super::Win32::Foundation:: BOOLEAN, desiredaccess : u32, previouslygrantedaccess : u32, privileges : *mut *mut super::super::super::Win32::Security:: PRIVILEGE_SET, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING, accessmode : i8, grantedaccess : *mut u32, accessstatus : *mut i32) -> super::super::super::Win32::Foundation:: BOOLEAN);
    SeAccessCheck(securitydescriptor.into_param().abi(), subjectsecuritycontext, subjectcontextlocked.into_param().abi(), desiredaccess, previouslygrantedaccess, ::core::mem::transmute(privileges.unwrap_or(::std::ptr::null_mut())), genericmapping, accessmode, grantedaccess, accessstatus)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeAssignSecurity<P0, P1, P2>(parentdescriptor: P0, explicitdescriptor: P1, newdescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, isdirectoryobject: P2, subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING, pooltype: super::super::Foundation::POOL_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P2: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeAssignSecurity(parentdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, explicitdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, newdescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, isdirectoryobject : super::super::super::Win32::Foundation:: BOOLEAN, subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING, pooltype : super::super::Foundation:: POOL_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeAssignSecurity(parentdescriptor.into_param().abi(), explicitdescriptor.into_param().abi(), newdescriptor, isdirectoryobject.into_param().abi(), subjectcontext, genericmapping, pooltype)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeAssignSecurityEx<P0, P1, P2>(parentdescriptor: P0, explicitdescriptor: P1, newdescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR, objecttype: ::core::option::Option<*const ::windows_core::GUID>, isdirectoryobject: P2, autoinheritflags: u32, subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT, genericmapping: *const super::super::super::Win32::Security::GENERIC_MAPPING, pooltype: super::super::Foundation::POOL_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P2: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeAssignSecurityEx(parentdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, explicitdescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, newdescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, objecttype : *const ::windows_core::GUID, isdirectoryobject : super::super::super::Win32::Foundation:: BOOLEAN, autoinheritflags : u32, subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT, genericmapping : *const super::super::super::Win32::Security:: GENERIC_MAPPING, pooltype : super::super::Foundation:: POOL_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeAssignSecurityEx(parentdescriptor.into_param().abi(), explicitdescriptor.into_param().abi(), newdescriptor, ::core::mem::transmute(objecttype.unwrap_or(::std::ptr::null())), isdirectoryobject.into_param().abi(), autoinheritflags, subjectcontext, genericmapping, pooltype)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeCaptureSubjectContext() -> super::super::Foundation::SECURITY_SUBJECT_CONTEXT {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeCaptureSubjectContext(subjectcontext : *mut super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    let mut result__ = ::std::mem::zeroed();
    SeCaptureSubjectContext(&mut result__);
    result__
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SeComputeAutoInheritByObjectType<P0, P1>(objecttype: *const ::core::ffi::c_void, securitydescriptor: P0, parentsecuritydescriptor: P1) -> u32
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeComputeAutoInheritByObjectType(objecttype : *const ::core::ffi::c_void, securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR, parentsecuritydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> u32);
    SeComputeAutoInheritByObjectType(objecttype, securitydescriptor.into_param().abi(), parentsecuritydescriptor.into_param().abi())
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SeDeassignSecurity(securitydescriptor: *mut super::super::super::Win32::Security::PSECURITY_DESCRIPTOR) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeDeassignSecurity(securitydescriptor : *mut super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeDeassignSecurity(securitydescriptor)
}
#[inline]
pub unsafe fn SeEtwWriteKMCveEvent(cveid: *const super::super::super::Win32::Foundation::UNICODE_STRING, additionaldetails: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeEtwWriteKMCveEvent(cveid : *const super::super::super::Win32::Foundation:: UNICODE_STRING, additionaldetails : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeEtwWriteKMCveEvent(cveid, ::core::mem::transmute(additionaldetails.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeLockSubjectContext(subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeLockSubjectContext(subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    SeLockSubjectContext(subjectcontext)
}
#[inline]
pub unsafe fn SeRegisterImageVerificationCallback(imagetype: SE_IMAGE_TYPE, callbacktype: SE_IMAGE_VERIFICATION_CALLBACK_TYPE, callbackfunction: PSE_IMAGE_VERIFICATION_CALLBACK_FUNCTION, callbackcontext: ::core::option::Option<*const ::core::ffi::c_void>, token: ::core::option::Option<*const ::core::ffi::c_void>, callbackhandle: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeRegisterImageVerificationCallback(imagetype : SE_IMAGE_TYPE, callbacktype : SE_IMAGE_VERIFICATION_CALLBACK_TYPE, callbackfunction : PSE_IMAGE_VERIFICATION_CALLBACK_FUNCTION, callbackcontext : *const ::core::ffi::c_void, token : *const ::core::ffi::c_void, callbackhandle : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeRegisterImageVerificationCallback(imagetype, callbacktype, callbackfunction, ::core::mem::transmute(callbackcontext.unwrap_or(::std::ptr::null())), ::core::mem::transmute(token.unwrap_or(::std::ptr::null())), callbackhandle)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeReleaseSubjectContext(subjectcontext: *mut super::super::Foundation::SECURITY_SUBJECT_CONTEXT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeReleaseSubjectContext(subjectcontext : *mut super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    SeReleaseSubjectContext(subjectcontext)
}
#[cfg(feature = "Win32_Security_Authentication_Identity")]
#[inline]
pub unsafe fn SeReportSecurityEvent<P0>(flags: u32, sourcename: *const super::super::super::Win32::Foundation::UNICODE_STRING, usersid: P0, auditparameters: *const super::super::super::Win32::Security::Authentication::Identity::SE_ADT_PARAMETER_ARRAY) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::PSID>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeReportSecurityEvent(flags : u32, sourcename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, usersid : super::super::super::Win32::Foundation:: PSID, auditparameters : *const super::super::super::Win32::Security::Authentication::Identity:: SE_ADT_PARAMETER_ARRAY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeReportSecurityEvent(flags, sourcename, usersid.into_param().abi(), auditparameters)
}
#[cfg(feature = "Win32_Security_Authentication_Identity")]
#[inline]
pub unsafe fn SeSetAuditParameter(auditparameters: *mut super::super::super::Win32::Security::Authentication::Identity::SE_ADT_PARAMETER_ARRAY, r#type: super::super::super::Win32::Security::Authentication::Identity::SE_ADT_PARAMETER_TYPE, index: u32, data: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeSetAuditParameter(auditparameters : *mut super::super::super::Win32::Security::Authentication::Identity:: SE_ADT_PARAMETER_ARRAY, r#type : super::super::super::Win32::Security::Authentication::Identity:: SE_ADT_PARAMETER_TYPE, index : u32, data : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    SeSetAuditParameter(auditparameters, r#type, index, data)
}
#[inline]
pub unsafe fn SeSinglePrivilegeCheck(privilegevalue: super::super::super::Win32::Foundation::LUID, previousmode: i8) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeSinglePrivilegeCheck(privilegevalue : super::super::super::Win32::Foundation:: LUID, previousmode : i8) -> super::super::super::Win32::Foundation:: BOOLEAN);
    SeSinglePrivilegeCheck(::core::mem::transmute(privilegevalue), previousmode)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_Security"))]
#[inline]
pub unsafe fn SeUnlockSubjectContext(subjectcontext: *const super::super::Foundation::SECURITY_SUBJECT_CONTEXT) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeUnlockSubjectContext(subjectcontext : *const super::super::Foundation:: SECURITY_SUBJECT_CONTEXT));
    SeUnlockSubjectContext(subjectcontext)
}
#[inline]
pub unsafe fn SeUnregisterImageVerificationCallback(callbackhandle: *const ::core::ffi::c_void) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeUnregisterImageVerificationCallback(callbackhandle : *const ::core::ffi::c_void));
    SeUnregisterImageVerificationCallback(callbackhandle)
}
#[cfg(feature = "Win32_Security")]
#[inline]
pub unsafe fn SeValidSecurityDescriptor<P0>(length: u32, securitydescriptor: P0) -> super::super::super::Win32::Foundation::BOOLEAN
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Security::PSECURITY_DESCRIPTOR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn SeValidSecurityDescriptor(length : u32, securitydescriptor : super::super::super::Win32::Security:: PSECURITY_DESCRIPTOR) -> super::super::super::Win32::Foundation:: BOOLEAN);
    SeValidSecurityDescriptor(length, securitydescriptor.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCommitComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmCommitComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmCommitComplete(enlistment, ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCommitEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmCommitEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmCommitEnlistment(enlistment, tmvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCommitTransaction<P0>(transaction: *const super::super::Foundation::KTRANSACTION, wait: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmCommitTransaction(transaction : *const super::super::Foundation:: KTRANSACTION, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmCommitTransaction(transaction, wait.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmCreateEnlistment(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, previousmode: i8, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, resourcemanager: *const isize, transaction: *const super::super::Foundation::KTRANSACTION, createoptions: u32, notificationmask: u32, enlistmentkey: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmCreateEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, previousmode : i8, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, resourcemanager : *const isize, transaction : *const super::super::Foundation:: KTRANSACTION, createoptions : u32, notificationmask : u32, enlistmentkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmCreateEnlistment(enlistmenthandle, previousmode, desiredaccess, objectattributes, resourcemanager, transaction, createoptions, notificationmask, ::core::mem::transmute(enlistmentkey.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmDereferenceEnlistmentKey(enlistment: *const super::super::Foundation::KENLISTMENT, lastreference: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmDereferenceEnlistmentKey(enlistment : *const super::super::Foundation:: KENLISTMENT, lastreference : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmDereferenceEnlistmentKey(enlistment, ::core::mem::transmute(lastreference.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmEnableCallbacks(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER, callbackroutine: PTM_RM_NOTIFICATION, rmkey: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmEnableCallbacks(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER, callbackroutine : PTM_RM_NOTIFICATION, rmkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmEnableCallbacks(resourcemanager, callbackroutine, ::core::mem::transmute(rmkey.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmGetTransactionId(transaction: *const super::super::Foundation::KTRANSACTION) -> ::windows_core::GUID {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmGetTransactionId(transaction : *const super::super::Foundation:: KTRANSACTION, transactionid : *mut ::windows_core::GUID));
    let mut result__ = ::std::mem::zeroed();
    TmGetTransactionId(transaction, &mut result__);
    result__
}
#[inline]
pub unsafe fn TmInitializeTransactionManager(transactionmanager: *const isize, logfilename: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, tmid: ::core::option::Option<*const ::windows_core::GUID>, createoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmInitializeTransactionManager(transactionmanager : *const isize, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, tmid : *const ::windows_core::GUID, createoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmInitializeTransactionManager(transactionmanager, ::core::mem::transmute(logfilename.unwrap_or(::std::ptr::null())), ::core::mem::transmute(tmid.unwrap_or(::std::ptr::null())), createoptions)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmIsTransactionActive(transaction: *const super::super::Foundation::KTRANSACTION) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmIsTransactionActive(transaction : *const super::super::Foundation:: KTRANSACTION) -> super::super::super::Win32::Foundation:: BOOLEAN);
    TmIsTransactionActive(transaction)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrePrepareComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmPrePrepareComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmPrePrepareComplete(enlistment, tmvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrePrepareEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmPrePrepareEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmPrePrepareEnlistment(enlistment, tmvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrepareComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmPrepareComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmPrepareComplete(enlistment, ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPrepareEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmPrepareEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmPrepareEnlistment(enlistment, tmvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPropagationComplete(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER, requestcookie: u32, bufferlength: u32, buffer: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmPropagationComplete(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER, requestcookie : u32, bufferlength : u32, buffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmPropagationComplete(resourcemanager, requestcookie, bufferlength, buffer)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmPropagationFailed<P0>(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER, requestcookie: u32, status: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmPropagationFailed(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER, requestcookie : u32, status : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmPropagationFailed(resourcemanager, requestcookie, status.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmReadOnlyEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmReadOnlyEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmReadOnlyEnlistment(enlistment, ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRecoverEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, enlistmentkey: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRecoverEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, enlistmentkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRecoverEnlistment(enlistment, enlistmentkey)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRecoverResourceManager(resourcemanager: *const super::super::Foundation::KRESOURCEMANAGER) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRecoverResourceManager(resourcemanager : *const super::super::Foundation:: KRESOURCEMANAGER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRecoverResourceManager(resourcemanager)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRecoverTransactionManager(tm: *const super::super::Foundation::KTM, targetvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRecoverTransactionManager(tm : *const super::super::Foundation:: KTM, targetvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRecoverTransactionManager(tm, targetvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmReferenceEnlistmentKey(enlistment: *const super::super::Foundation::KENLISTMENT, key: *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmReferenceEnlistmentKey(enlistment : *const super::super::Foundation:: KENLISTMENT, key : *mut *mut ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmReferenceEnlistmentKey(enlistment, key)
}
#[inline]
pub unsafe fn TmRenameTransactionManager(logfilename: *const super::super::super::Win32::Foundation::UNICODE_STRING, existingtransactionmanagerguid: *const ::windows_core::GUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRenameTransactionManager(logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, existingtransactionmanagerguid : *const ::windows_core::GUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRenameTransactionManager(logfilename, existingtransactionmanagerguid)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRequestOutcomeEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRequestOutcomeEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRequestOutcomeEnlistment(enlistment, tmvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRollbackComplete(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRollbackComplete(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRollbackComplete(enlistment, ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRollbackEnlistment(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRollbackEnlistment(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRollbackEnlistment(enlistment, ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmRollbackTransaction<P0>(transaction: *const super::super::Foundation::KTRANSACTION, wait: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmRollbackTransaction(transaction : *const super::super::Foundation:: KTRANSACTION, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmRollbackTransaction(transaction, wait.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn TmSinglePhaseReject(enlistment: *const super::super::Foundation::KENLISTMENT, tmvirtualclock: *const i64) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn TmSinglePhaseReject(enlistment : *const super::super::Foundation:: KENLISTMENT, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    TmSinglePhaseReject(enlistment, tmvirtualclock)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn VslCreateSecureSection<P0>(handle: *mut super::super::super::Win32::Foundation::HANDLE, targetprocess: P0, mdl: *const super::super::Foundation::MDL, devicepageprotection: u32, attributes: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PEPROCESS>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn VslCreateSecureSection(handle : *mut super::super::super::Win32::Foundation:: HANDLE, targetprocess : super::super::Foundation:: PEPROCESS, mdl : *const super::super::Foundation:: MDL, devicepageprotection : u32, attributes : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    VslCreateSecureSection(handle, targetprocess.into_param().abi(), mdl, devicepageprotection, attributes)
}
#[inline]
pub unsafe fn VslDeleteSecureSection<P0>(globalhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn VslDeleteSecureSection(globalhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    VslDeleteSecureSection(globalhandle.into_param().abi())
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddErrorSource(errorsource: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_DESCRIPTOR, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaAddErrorSource(errorsource : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_DESCRIPTOR, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaAddErrorSource(errorsource, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddErrorSourceDeviceDriver(context: ::core::option::Option<*mut ::core::ffi::c_void>, configuration: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numberpreallocatederrorreports: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaAddErrorSourceDeviceDriver(context : *mut ::core::ffi::c_void, configuration : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numberpreallocatederrorreports : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaAddErrorSourceDeviceDriver(::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())), configuration, numberpreallocatederrorreports)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddErrorSourceDeviceDriverV1(context: ::core::option::Option<*mut ::core::ffi::c_void>, configuration: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numbufferstopreallocate: u32, maxdatalength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaAddErrorSourceDeviceDriverV1(context : *mut ::core::ffi::c_void, configuration : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_CONFIGURATION_DEVICE_DRIVER, numbufferstopreallocate : u32, maxdatalength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaAddErrorSourceDeviceDriverV1(::core::mem::transmute(context.unwrap_or(::std::ptr::null_mut())), configuration, numbufferstopreallocate, maxdatalength)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaAddHwErrorReportSectionDeviceDriver(errorhandle: *const ::core::ffi::c_void, sectiondatalength: u32, bufferset: *mut super::super::super::Win32::System::Diagnostics::Debug::WHEA_DRIVER_BUFFER_SET) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaAddHwErrorReportSectionDeviceDriver(errorhandle : *const ::core::ffi::c_void, sectiondatalength : u32, bufferset : *mut super::super::super::Win32::System::Diagnostics::Debug:: WHEA_DRIVER_BUFFER_SET) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaAddHwErrorReportSectionDeviceDriver(errorhandle, sectiondatalength, bufferset)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaConfigureErrorSource(sourcetype: super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_TYPE, configuration: *const WHEA_ERROR_SOURCE_CONFIGURATION) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaConfigureErrorSource(sourcetype : super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_TYPE, configuration : *const WHEA_ERROR_SOURCE_CONFIGURATION) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaConfigureErrorSource(sourcetype, configuration)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn WheaCreateHwErrorReportDeviceDriver(errorsourceid: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaCreateHwErrorReportDeviceDriver(errorsourceid : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT) -> *mut ::core::ffi::c_void);
    WheaCreateHwErrorReportDeviceDriver(errorsourceid, deviceobject)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaErrorSourceGetState(errorsourceid: u32) -> super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_STATE {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaErrorSourceGetState(errorsourceid : u32) -> super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_STATE);
    WheaErrorSourceGetState(errorsourceid)
}
#[inline]
pub unsafe fn WheaGetNotifyAllOfflinesPolicy() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaGetNotifyAllOfflinesPolicy() -> super::super::super::Win32::Foundation:: BOOLEAN);
    WheaGetNotifyAllOfflinesPolicy()
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaHighIrqlLogSelEventHandlerRegister(handler: PFN_WHEA_HIGH_IRQL_LOG_SEL_EVENT_HANDLER, context: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaHighIrqlLogSelEventHandlerRegister(handler : PFN_WHEA_HIGH_IRQL_LOG_SEL_EVENT_HANDLER, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: BOOLEAN);
    WheaHighIrqlLogSelEventHandlerRegister(handler, context)
}
#[inline]
pub unsafe fn WheaHighIrqlLogSelEventHandlerUnregister() {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaHighIrqlLogSelEventHandlerUnregister());
    WheaHighIrqlLogSelEventHandlerUnregister()
}
#[inline]
pub unsafe fn WheaHwErrorReportAbandonDeviceDriver(errorhandle: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportAbandonDeviceDriver(errorhandle : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaHwErrorReportAbandonDeviceDriver(errorhandle)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaHwErrorReportSetSectionNameDeviceDriver(bufferset: *const super::super::super::Win32::System::Diagnostics::Debug::WHEA_DRIVER_BUFFER_SET, name: &[u8]) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportSetSectionNameDeviceDriver(bufferset : *const super::super::super::Win32::System::Diagnostics::Debug:: WHEA_DRIVER_BUFFER_SET, namelength : u32, name : *const u8) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaHwErrorReportSetSectionNameDeviceDriver(bufferset, name.len().try_into().unwrap(), ::core::mem::transmute(name.as_ptr()))
}
#[inline]
pub unsafe fn WheaHwErrorReportSetSeverityDeviceDriver(errorhandle: *const ::core::ffi::c_void, errorseverity: WHEA_ERROR_SEVERITY) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportSetSeverityDeviceDriver(errorhandle : *const ::core::ffi::c_void, errorseverity : WHEA_ERROR_SEVERITY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaHwErrorReportSetSeverityDeviceDriver(errorhandle, errorseverity)
}
#[inline]
pub unsafe fn WheaHwErrorReportSubmitDeviceDriver(errorhandle: *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaHwErrorReportSubmitDeviceDriver(errorhandle : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaHwErrorReportSubmitDeviceDriver(errorhandle)
}
#[inline]
pub unsafe fn WheaInitializeRecordHeader(header: *mut WHEA_ERROR_RECORD_HEADER) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaInitializeRecordHeader(header : *mut WHEA_ERROR_RECORD_HEADER) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaInitializeRecordHeader(header)
}
#[inline]
pub unsafe fn WheaIsCriticalState() -> super::super::super::Win32::Foundation::BOOLEAN {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaIsCriticalState() -> super::super::super::Win32::Foundation:: BOOLEAN);
    WheaIsCriticalState()
}
#[inline]
pub unsafe fn WheaLogInternalEvent(entry: *const WHEA_EVENT_LOG_ENTRY) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaLogInternalEvent(entry : *const WHEA_EVENT_LOG_ENTRY));
    WheaLogInternalEvent(entry)
}
#[inline]
pub unsafe fn WheaRegisterInUsePageOfflineNotification(callback: PFN_IN_USE_PAGE_OFFLINE_NOTIFY, context: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaRegisterInUsePageOfflineNotification(callback : PFN_IN_USE_PAGE_OFFLINE_NOTIFY, context : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaRegisterInUsePageOfflineNotification(callback, ::core::mem::transmute(context.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn WheaRemoveErrorSource(errorsourceid: u32) {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaRemoveErrorSource(errorsourceid : u32));
    WheaRemoveErrorSource(errorsourceid)
}
#[inline]
pub unsafe fn WheaRemoveErrorSourceDeviceDriver(errorsourceid: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaRemoveErrorSourceDeviceDriver(errorsourceid : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaRemoveErrorSourceDeviceDriver(errorsourceid)
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaReportHwError(errorpacket: *mut WHEA_ERROR_PACKET_V2) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaReportHwError(errorpacket : *mut WHEA_ERROR_PACKET_V2) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaReportHwError(errorpacket)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
#[inline]
pub unsafe fn WheaReportHwErrorDeviceDriver<P0>(errorsourceid: u32, deviceobject: *const super::super::Foundation::DEVICE_OBJECT, errordata: &[u8], sectiontypeguid: *const ::windows_core::GUID, errorseverity: WHEA_ERROR_SEVERITY, devicefriendlyname: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaReportHwErrorDeviceDriver(errorsourceid : u32, deviceobject : *const super::super::Foundation:: DEVICE_OBJECT, errordata : *const u8, errordatalength : u32, sectiontypeguid : *const ::windows_core::GUID, errorseverity : WHEA_ERROR_SEVERITY, devicefriendlyname : ::windows_core::PCSTR) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaReportHwErrorDeviceDriver(errorsourceid, deviceobject, ::core::mem::transmute(errordata.as_ptr()), errordata.len().try_into().unwrap(), sectiontypeguid, errorseverity, devicefriendlyname.into_param().abi())
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
#[inline]
pub unsafe fn WheaUnconfigureErrorSource(sourcetype: super::super::super::Win32::System::Diagnostics::Debug::WHEA_ERROR_SOURCE_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaUnconfigureErrorSource(sourcetype : super::super::super::Win32::System::Diagnostics::Debug:: WHEA_ERROR_SOURCE_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaUnconfigureErrorSource(sourcetype)
}
#[inline]
pub unsafe fn WheaUnregisterInUsePageOfflineNotification(callback: PFN_IN_USE_PAGE_OFFLINE_NOTIFY) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WheaUnregisterInUsePageOfflineNotification(callback : PFN_IN_USE_PAGE_OFFLINE_NOTIFY) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WheaUnregisterInUsePageOfflineNotification(callback)
}
#[inline]
pub unsafe fn WmiQueryTraceInformation(traceinformationclass: TRACE_INFORMATION_CLASS, traceinformation: *mut ::core::ffi::c_void, traceinformationlength: u32, requiredlength: ::core::option::Option<*mut u32>, buffer: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntoskrnl.exe" "system" fn WmiQueryTraceInformation(traceinformationclass : TRACE_INFORMATION_CLASS, traceinformation : *mut ::core::ffi::c_void, traceinformationlength : u32, requiredlength : *mut u32, buffer : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    WmiQueryTraceInformation(traceinformationclass, traceinformation, traceinformationlength, ::core::mem::transmute(requiredlength.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(buffer.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwAllocateLocallyUniqueId(luid: *mut super::super::super::Win32::Foundation::LUID) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwAllocateLocallyUniqueId(luid : *mut super::super::super::Win32::Foundation:: LUID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwAllocateLocallyUniqueId(luid)
}
#[inline]
pub unsafe fn ZwCancelTimer<P0>(timerhandle: P0, currentstate: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCancelTimer(timerhandle : super::super::super::Win32::Foundation:: HANDLE, currentstate : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCancelTimer(timerhandle.into_param().abi(), ::core::mem::transmute(currentstate.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn ZwClose<P0>(handle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwClose(handle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwClose(handle.into_param().abi())
}
#[inline]
pub unsafe fn ZwCommitComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCommitComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCommitComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwCommitEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCommitEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCommitEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwCommitRegistryTransaction<P0>(transactionhandle: P0, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCommitRegistryTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCommitRegistryTransaction(transactionhandle.into_param().abi(), flags)
}
#[inline]
pub unsafe fn ZwCommitTransaction<P0, P1>(transactionhandle: P0, wait: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCommitTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCommitTransaction(transactionhandle.into_param().abi(), wait.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateDirectoryObject(directoryhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateDirectoryObject(directoryhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateDirectoryObject(directoryhandle, desiredaccess, objectattributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateEnlistment<P0, P1>(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, resourcemanagerhandle: P0, transactionhandle: P1, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: u32, notificationmask: u32, enlistmentkey: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionhandle : super::super::super::Win32::Foundation:: HANDLE, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, notificationmask : u32, enlistmentkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateEnlistment(enlistmenthandle, desiredaccess, resourcemanagerhandle.into_param().abi(), transactionhandle.into_param().abi(), ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), createoptions, notificationmask, ::core::mem::transmute(enlistmentkey.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwCreateFile(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, allocationsize: ::core::option::Option<*const i64>, fileattributes: u32, shareaccess: u32, createdisposition: u32, createoptions: u32, eabuffer: ::core::option::Option<*const ::core::ffi::c_void>, ealength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateFile(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, allocationsize : *const i64, fileattributes : u32, shareaccess : u32, createdisposition : u32, createoptions : u32, eabuffer : *const ::core::ffi::c_void, ealength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateFile(filehandle, desiredaccess, objectattributes, iostatusblock, ::core::mem::transmute(allocationsize.unwrap_or(::std::ptr::null())), fileattributes, shareaccess, createdisposition, createoptions, ::core::mem::transmute(eabuffer.unwrap_or(::std::ptr::null())), ealength)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateKey(keyhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, titleindex: u32, class: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, createoptions: u32, disposition: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateKey(keyhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, titleindex : u32, class : *const super::super::super::Win32::Foundation:: UNICODE_STRING, createoptions : u32, disposition : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateKey(keyhandle, desiredaccess, objectattributes, titleindex, ::core::mem::transmute(class.unwrap_or(::std::ptr::null())), createoptions, ::core::mem::transmute(disposition.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateKeyTransacted<P0>(keyhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, titleindex: u32, class: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, createoptions: u32, transactionhandle: P0, disposition: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateKeyTransacted(keyhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, titleindex : u32, class : *const super::super::super::Win32::Foundation:: UNICODE_STRING, createoptions : u32, transactionhandle : super::super::super::Win32::Foundation:: HANDLE, disposition : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateKeyTransacted(keyhandle, desiredaccess, objectattributes, titleindex, ::core::mem::transmute(class.unwrap_or(::std::ptr::null())), createoptions, transactionhandle.into_param().abi(), ::core::mem::transmute(disposition.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateRegistryTransaction(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateRegistryTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateRegistryTransaction(transactionhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), createoptions)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateResourceManager<P0>(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: P0, resourcemanagerguid: ::core::option::Option<*const ::windows_core::GUID>, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, createoptions: u32, description: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerguid : *const ::windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, createoptions : u32, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateResourceManager(resourcemanagerhandle, desiredaccess, tmhandle.into_param().abi(), ::core::mem::transmute(resourcemanagerguid.unwrap_or(::std::ptr::null())), ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), createoptions, ::core::mem::transmute(description.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateSection<P0>(sectionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, maximumsize: ::core::option::Option<*const i64>, sectionpageprotection: u32, allocationattributes: u32, filehandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateSection(sectionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, maximumsize : *const i64, sectionpageprotection : u32, allocationattributes : u32, filehandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateSection(sectionhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(maximumsize.unwrap_or(::std::ptr::null())), sectionpageprotection, allocationattributes, filehandle.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_Kernel"))]
#[inline]
pub unsafe fn ZwCreateTimer(timerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, timertype: super::super::super::Win32::System::Kernel::TIMER_TYPE) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateTimer(timerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, timertype : super::super::super::Win32::System::Kernel:: TIMER_TYPE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateTimer(timerhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), timertype)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateTransaction<P0>(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, uow: ::core::option::Option<*const ::windows_core::GUID>, tmhandle: P0, createoptions: u32, isolationlevel: u32, isolationflags: u32, timeout: ::core::option::Option<*const i64>, description: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const ::windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE, createoptions : u32, isolationlevel : u32, isolationflags : u32, timeout : *const i64, description : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateTransaction(transactionhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(uow.unwrap_or(::std::ptr::null())), tmhandle.into_param().abi(), createoptions, isolationlevel, isolationflags, ::core::mem::transmute(timeout.unwrap_or(::std::ptr::null())), ::core::mem::transmute(description.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwCreateTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, createoptions: u32, commitstrength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwCreateTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, createoptions : u32, commitstrength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwCreateTransactionManager(tmhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(logfilename.unwrap_or(::std::ptr::null())), createoptions, commitstrength)
}
#[inline]
pub unsafe fn ZwDeleteKey<P0>(keyhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwDeleteKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwDeleteKey(keyhandle.into_param().abi())
}
#[inline]
pub unsafe fn ZwDeleteValueKey<P0>(keyhandle: P0, valuename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwDeleteValueKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, valuename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwDeleteValueKey(keyhandle.into_param().abi(), valuename)
}
#[cfg(feature = "Win32_System_IO")]
#[inline]
pub unsafe fn ZwDeviceIoControlFile<P0, P1>(filehandle: P0, event: P1, apcroutine: super::super::super::Win32::System::IO::PIO_APC_ROUTINE, apccontext: ::core::option::Option<*const ::core::ffi::c_void>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, iocontrolcode: u32, inputbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inputbufferlength: u32, outputbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outputbufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwDeviceIoControlFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, event : super::super::super::Win32::Foundation:: HANDLE, apcroutine : super::super::super::Win32::System::IO:: PIO_APC_ROUTINE, apccontext : *const ::core::ffi::c_void, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, iocontrolcode : u32, inputbuffer : *const ::core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut ::core::ffi::c_void, outputbufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwDeviceIoControlFile(filehandle.into_param().abi(), event.into_param().abi(), apcroutine, ::core::mem::transmute(apccontext.unwrap_or(::std::ptr::null())), iostatusblock, iocontrolcode, ::core::mem::transmute(inputbuffer.unwrap_or(::std::ptr::null())), inputbufferlength, ::core::mem::transmute(outputbuffer.unwrap_or(::std::ptr::null_mut())), outputbufferlength)
}
#[inline]
pub unsafe fn ZwDisplayString(string: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwDisplayString(string : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwDisplayString(string)
}
#[inline]
pub unsafe fn ZwEnumerateKey<P0>(keyhandle: P0, index: u32, keyinformationclass: KEY_INFORMATION_CLASS, keyinformation: ::core::option::Option<*mut ::core::ffi::c_void>, length: u32, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwEnumerateKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, index : u32, keyinformationclass : KEY_INFORMATION_CLASS, keyinformation : *mut ::core::ffi::c_void, length : u32, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwEnumerateKey(keyhandle.into_param().abi(), index, keyinformationclass, ::core::mem::transmute(keyinformation.unwrap_or(::std::ptr::null_mut())), length, resultlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwEnumerateTransactionObject<P0>(rootobjecthandle: P0, querytype: super::super::super::Win32::System::SystemServices::KTMOBJECT_TYPE, objectcursor: *mut super::super::super::Win32::System::SystemServices::KTMOBJECT_CURSOR, objectcursorlength: u32, returnlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwEnumerateTransactionObject(rootobjecthandle : super::super::super::Win32::Foundation:: HANDLE, querytype : super::super::super::Win32::System::SystemServices:: KTMOBJECT_TYPE, objectcursor : *mut super::super::super::Win32::System::SystemServices:: KTMOBJECT_CURSOR, objectcursorlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwEnumerateTransactionObject(rootobjecthandle.into_param().abi(), querytype, objectcursor, objectcursorlength, returnlength)
}
#[inline]
pub unsafe fn ZwEnumerateValueKey<P0>(keyhandle: P0, index: u32, keyvalueinformationclass: KEY_VALUE_INFORMATION_CLASS, keyvalueinformation: ::core::option::Option<*mut ::core::ffi::c_void>, length: u32, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwEnumerateValueKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, index : u32, keyvalueinformationclass : KEY_VALUE_INFORMATION_CLASS, keyvalueinformation : *mut ::core::ffi::c_void, length : u32, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwEnumerateValueKey(keyhandle.into_param().abi(), index, keyvalueinformationclass, ::core::mem::transmute(keyvalueinformation.unwrap_or(::std::ptr::null_mut())), length, resultlength)
}
#[inline]
pub unsafe fn ZwFlushKey<P0>(keyhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwFlushKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwFlushKey(keyhandle.into_param().abi())
}
#[cfg(feature = "Win32_Storage_FileSystem")]
#[inline]
pub unsafe fn ZwGetNotificationResourceManager<P0>(resourcemanagerhandle: P0, transactionnotification: *mut super::super::super::Win32::Storage::FileSystem::TRANSACTION_NOTIFICATION, notificationlength: u32, timeout: *const i64, returnlength: ::core::option::Option<*mut u32>, asynchronous: u32, asynchronouscontext: usize) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwGetNotificationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionnotification : *mut super::super::super::Win32::Storage::FileSystem:: TRANSACTION_NOTIFICATION, notificationlength : u32, timeout : *const i64, returnlength : *mut u32, asynchronous : u32, asynchronouscontext : usize) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwGetNotificationResourceManager(resourcemanagerhandle.into_param().abi(), transactionnotification, notificationlength, timeout, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())), asynchronous, asynchronouscontext)
}
#[inline]
pub unsafe fn ZwLoadDriver(driverservicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwLoadDriver(driverservicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwLoadDriver(driverservicename)
}
#[inline]
pub unsafe fn ZwMakeTemporaryObject<P0>(handle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwMakeTemporaryObject(handle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwMakeTemporaryObject(handle.into_param().abi())
}
#[inline]
pub unsafe fn ZwMapViewOfSection<P0, P1>(sectionhandle: P0, processhandle: P1, baseaddress: *mut *mut ::core::ffi::c_void, zerobits: usize, commitsize: usize, sectionoffset: ::core::option::Option<*mut i64>, viewsize: *mut usize, inheritdisposition: SECTION_INHERIT, allocationtype: u32, win32protect: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwMapViewOfSection(sectionhandle : super::super::super::Win32::Foundation:: HANDLE, processhandle : super::super::super::Win32::Foundation:: HANDLE, baseaddress : *mut *mut ::core::ffi::c_void, zerobits : usize, commitsize : usize, sectionoffset : *mut i64, viewsize : *mut usize, inheritdisposition : SECTION_INHERIT, allocationtype : u32, win32protect : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwMapViewOfSection(sectionhandle.into_param().abi(), processhandle.into_param().abi(), baseaddress, zerobits, commitsize, ::core::mem::transmute(sectionoffset.unwrap_or(::std::ptr::null_mut())), viewsize, inheritdisposition, allocationtype, win32protect)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenEnlistment<P0>(enlistmenthandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, rmhandle: P0, enlistmentguid: *const ::windows_core::GUID, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenEnlistment(enlistmenthandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, rmhandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentguid : *const ::windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenEnlistment(enlistmenthandle, desiredaccess, rmhandle.into_param().abi(), enlistmentguid, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenEvent(eventhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenEvent(eventhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenEvent(eventhandle, desiredaccess, objectattributes)
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwOpenFile(filehandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, shareaccess: u32, openoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenFile(filehandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, shareaccess : u32, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenFile(filehandle, desiredaccess, objectattributes, iostatusblock, shareaccess, openoptions)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenKey(keyhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenKey(keyhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenKey(keyhandle, desiredaccess, objectattributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenKeyEx(keyhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, openoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenKeyEx(keyhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenKeyEx(keyhandle, desiredaccess, objectattributes, openoptions)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenKeyTransacted<P0>(keyhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, transactionhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenKeyTransacted(keyhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, transactionhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenKeyTransacted(keyhandle, desiredaccess, objectattributes, transactionhandle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenKeyTransactedEx<P0>(keyhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, openoptions: u32, transactionhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenKeyTransactedEx(keyhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, openoptions : u32, transactionhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenKeyTransactedEx(keyhandle, desiredaccess, objectattributes, openoptions, transactionhandle.into_param().abi())
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Win32_System_WindowsProgramming"))]
#[inline]
pub unsafe fn ZwOpenProcess(processhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, clientid: ::core::option::Option<*const super::super::super::Win32::System::WindowsProgramming::CLIENT_ID>) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenProcess(processhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, clientid : *const super::super::super::Win32::System::WindowsProgramming:: CLIENT_ID) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenProcess(processhandle, desiredaccess, objectattributes, ::core::mem::transmute(clientid.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenResourceManager<P0>(resourcemanagerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, tmhandle: P0, resourcemanagerguid: *const ::windows_core::GUID, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenResourceManager(resourcemanagerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, tmhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerguid : *const ::windows_core::GUID, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenResourceManager(resourcemanagerhandle, desiredaccess, tmhandle.into_param().abi(), resourcemanagerguid, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenSection(sectionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenSection(sectionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenSection(sectionhandle, desiredaccess, objectattributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenSymbolicLinkObject(linkhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenSymbolicLinkObject(linkhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenSymbolicLinkObject(linkhandle, desiredaccess, objectattributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenTimer(timerhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenTimer(timerhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenTimer(timerhandle, desiredaccess, objectattributes)
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenTransaction<P0>(transactionhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, uow: *const ::windows_core::GUID, tmhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenTransaction(transactionhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, uow : *const ::windows_core::GUID, tmhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenTransaction(transactionhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), uow, tmhandle.into_param().abi())
}
#[cfg(feature = "Wdk_Foundation")]
#[inline]
pub unsafe fn ZwOpenTransactionManager(tmhandle: *mut super::super::super::Win32::Foundation::HANDLE, desiredaccess: u32, objectattributes: ::core::option::Option<*const super::super::Foundation::OBJECT_ATTRIBUTES>, logfilename: ::core::option::Option<*const super::super::super::Win32::Foundation::UNICODE_STRING>, tmidentity: ::core::option::Option<*const ::windows_core::GUID>, openoptions: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwOpenTransactionManager(tmhandle : *mut super::super::super::Win32::Foundation:: HANDLE, desiredaccess : u32, objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, logfilename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, tmidentity : *const ::windows_core::GUID, openoptions : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwOpenTransactionManager(tmhandle, desiredaccess, ::core::mem::transmute(objectattributes.unwrap_or(::std::ptr::null())), ::core::mem::transmute(logfilename.unwrap_or(::std::ptr::null())), ::core::mem::transmute(tmidentity.unwrap_or(::std::ptr::null())), openoptions)
}
#[cfg(feature = "Win32_System_Power")]
#[inline]
pub unsafe fn ZwPowerInformation(informationlevel: super::super::super::Win32::System::Power::POWER_INFORMATION_LEVEL, inputbuffer: ::core::option::Option<*const ::core::ffi::c_void>, inputbufferlength: u32, outputbuffer: ::core::option::Option<*mut ::core::ffi::c_void>, outputbufferlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwPowerInformation(informationlevel : super::super::super::Win32::System::Power:: POWER_INFORMATION_LEVEL, inputbuffer : *const ::core::ffi::c_void, inputbufferlength : u32, outputbuffer : *mut ::core::ffi::c_void, outputbufferlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwPowerInformation(informationlevel, ::core::mem::transmute(inputbuffer.unwrap_or(::std::ptr::null())), inputbufferlength, ::core::mem::transmute(outputbuffer.unwrap_or(::std::ptr::null_mut())), outputbufferlength)
}
#[inline]
pub unsafe fn ZwPrePrepareComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwPrePrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwPrePrepareComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwPrePrepareEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwPrePrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwPrePrepareEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwPrepareComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwPrepareComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwPrepareComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwPrepareEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwPrepareEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwPrepareEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwQueryInformationByName(objectattributes: *const super::super::Foundation::OBJECT_ATTRIBUTES, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *mut ::core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryInformationByName(objectattributes : *const super::super::Foundation:: OBJECT_ATTRIBUTES, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *mut ::core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryInformationByName(objectattributes, iostatusblock, fileinformation, length, fileinformationclass)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationEnlistment<P0>(enlistmenthandle: P0, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *mut ::core::ffi::c_void, enlistmentinformationlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *mut ::core::ffi::c_void, enlistmentinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryInformationEnlistment(enlistmenthandle.into_param().abi(), enlistmentinformationclass, enlistmentinformation, enlistmentinformationlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(all(feature = "Wdk_Storage_FileSystem", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwQueryInformationFile<P0>(filehandle: P0, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *mut ::core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryInformationFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *mut ::core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryInformationFile(filehandle.into_param().abi(), iostatusblock, fileinformation, length, fileinformationclass)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationResourceManager<P0>(resourcemanagerhandle: P0, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *mut ::core::ffi::c_void, resourcemanagerinformationlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *mut ::core::ffi::c_void, resourcemanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryInformationResourceManager(resourcemanagerhandle.into_param().abi(), resourcemanagerinformationclass, resourcemanagerinformation, resourcemanagerinformationlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationTransaction<P0>(transactionhandle: P0, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *mut ::core::ffi::c_void, transactioninformationlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *mut ::core::ffi::c_void, transactioninformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryInformationTransaction(transactionhandle.into_param().abi(), transactioninformationclass, transactioninformation, transactioninformationlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwQueryInformationTransactionManager<P0>(transactionmanagerhandle: P0, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *mut ::core::ffi::c_void, transactionmanagerinformationlength: u32, returnlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryInformationTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *mut ::core::ffi::c_void, transactionmanagerinformationlength : u32, returnlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryInformationTransactionManager(transactionmanagerhandle.into_param().abi(), transactionmanagerinformationclass, transactionmanagerinformation, transactionmanagerinformationlength, ::core::mem::transmute(returnlength.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn ZwQueryKey<P0>(keyhandle: P0, keyinformationclass: KEY_INFORMATION_CLASS, keyinformation: ::core::option::Option<*mut ::core::ffi::c_void>, length: u32, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, keyinformationclass : KEY_INFORMATION_CLASS, keyinformation : *mut ::core::ffi::c_void, length : u32, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryKey(keyhandle.into_param().abi(), keyinformationclass, ::core::mem::transmute(keyinformation.unwrap_or(::std::ptr::null_mut())), length, resultlength)
}
#[inline]
pub unsafe fn ZwQuerySymbolicLinkObject<P0>(linkhandle: P0, linktarget: *mut super::super::super::Win32::Foundation::UNICODE_STRING, returnedlength: ::core::option::Option<*mut u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQuerySymbolicLinkObject(linkhandle : super::super::super::Win32::Foundation:: HANDLE, linktarget : *mut super::super::super::Win32::Foundation:: UNICODE_STRING, returnedlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQuerySymbolicLinkObject(linkhandle.into_param().abi(), linktarget, ::core::mem::transmute(returnedlength.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn ZwQueryValueKey<P0>(keyhandle: P0, valuename: *const super::super::super::Win32::Foundation::UNICODE_STRING, keyvalueinformationclass: KEY_VALUE_INFORMATION_CLASS, keyvalueinformation: ::core::option::Option<*mut ::core::ffi::c_void>, length: u32, resultlength: *mut u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwQueryValueKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, valuename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, keyvalueinformationclass : KEY_VALUE_INFORMATION_CLASS, keyvalueinformation : *mut ::core::ffi::c_void, length : u32, resultlength : *mut u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwQueryValueKey(keyhandle.into_param().abi(), valuename, keyvalueinformationclass, ::core::mem::transmute(keyvalueinformation.unwrap_or(::std::ptr::null_mut())), length, resultlength)
}
#[cfg(feature = "Win32_System_IO")]
#[inline]
pub unsafe fn ZwReadFile<P0, P1>(filehandle: P0, event: P1, apcroutine: super::super::super::Win32::System::IO::PIO_APC_ROUTINE, apccontext: ::core::option::Option<*const ::core::ffi::c_void>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, buffer: *mut ::core::ffi::c_void, length: u32, byteoffset: ::core::option::Option<*const i64>, key: ::core::option::Option<*const u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwReadFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, event : super::super::super::Win32::Foundation:: HANDLE, apcroutine : super::super::super::Win32::System::IO:: PIO_APC_ROUTINE, apccontext : *const ::core::ffi::c_void, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, buffer : *mut ::core::ffi::c_void, length : u32, byteoffset : *const i64, key : *const u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwReadFile(filehandle.into_param().abi(), event.into_param().abi(), apcroutine, ::core::mem::transmute(apccontext.unwrap_or(::std::ptr::null())), iostatusblock, buffer, length, ::core::mem::transmute(byteoffset.unwrap_or(::std::ptr::null())), ::core::mem::transmute(key.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwReadOnlyEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwReadOnlyEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwReadOnlyEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwRecoverEnlistment<P0>(enlistmenthandle: P0, enlistmentkey: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRecoverEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentkey : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRecoverEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(enlistmentkey.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwRecoverResourceManager<P0>(resourcemanagerhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRecoverResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRecoverResourceManager(resourcemanagerhandle.into_param().abi())
}
#[inline]
pub unsafe fn ZwRecoverTransactionManager<P0>(transactionmanagerhandle: P0) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRecoverTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRecoverTransactionManager(transactionmanagerhandle.into_param().abi())
}
#[inline]
pub unsafe fn ZwRenameKey<P0>(keyhandle: P0, newname: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRenameKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, newname : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRenameKey(keyhandle.into_param().abi(), newname)
}
#[inline]
pub unsafe fn ZwRestoreKey<P0, P1>(keyhandle: P0, filehandle: P1, flags: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRestoreKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, filehandle : super::super::super::Win32::Foundation:: HANDLE, flags : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRestoreKey(keyhandle.into_param().abi(), filehandle.into_param().abi(), flags)
}
#[inline]
pub unsafe fn ZwRollbackComplete<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRollbackComplete(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRollbackComplete(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwRollbackEnlistment<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRollbackEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRollbackEnlistment(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwRollbackTransaction<P0, P1>(transactionhandle: P0, wait: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRollbackTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, wait : super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRollbackTransaction(transactionhandle.into_param().abi(), wait.into_param().abi())
}
#[inline]
pub unsafe fn ZwRollforwardTransactionManager<P0>(transactionmanagerhandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwRollforwardTransactionManager(transactionmanagerhandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwRollforwardTransactionManager(transactionmanagerhandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwSaveKey<P0, P1>(keyhandle: P0, filehandle: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSaveKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, filehandle : super::super::super::Win32::Foundation:: HANDLE) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSaveKey(keyhandle.into_param().abi(), filehandle.into_param().abi())
}
#[inline]
pub unsafe fn ZwSaveKeyEx<P0, P1>(keyhandle: P0, filehandle: P1, format: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSaveKeyEx(keyhandle : super::super::super::Win32::Foundation:: HANDLE, filehandle : super::super::super::Win32::Foundation:: HANDLE, format : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSaveKeyEx(keyhandle.into_param().abi(), filehandle.into_param().abi(), format)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationEnlistment<P0>(enlistmenthandle: P0, enlistmentinformationclass: super::super::super::Win32::System::SystemServices::ENLISTMENT_INFORMATION_CLASS, enlistmentinformation: *const ::core::ffi::c_void, enlistmentinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetInformationEnlistment(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, enlistmentinformationclass : super::super::super::Win32::System::SystemServices:: ENLISTMENT_INFORMATION_CLASS, enlistmentinformation : *const ::core::ffi::c_void, enlistmentinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetInformationEnlistment(enlistmenthandle.into_param().abi(), enlistmentinformationclass, enlistmentinformation, enlistmentinformationlength)
}
#[cfg(all(feature = "Wdk_Storage_FileSystem", feature = "Win32_System_IO"))]
#[inline]
pub unsafe fn ZwSetInformationFile<P0>(filehandle: P0, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, fileinformation: *const ::core::ffi::c_void, length: u32, fileinformationclass: super::super::Storage::FileSystem::FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetInformationFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, fileinformation : *const ::core::ffi::c_void, length : u32, fileinformationclass : super::super::Storage::FileSystem:: FILE_INFORMATION_CLASS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetInformationFile(filehandle.into_param().abi(), iostatusblock, fileinformation, length, fileinformationclass)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationResourceManager<P0>(resourcemanagerhandle: P0, resourcemanagerinformationclass: super::super::super::Win32::System::SystemServices::RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation: *const ::core::ffi::c_void, resourcemanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetInformationResourceManager(resourcemanagerhandle : super::super::super::Win32::Foundation:: HANDLE, resourcemanagerinformationclass : super::super::super::Win32::System::SystemServices:: RESOURCEMANAGER_INFORMATION_CLASS, resourcemanagerinformation : *const ::core::ffi::c_void, resourcemanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetInformationResourceManager(resourcemanagerhandle.into_param().abi(), resourcemanagerinformationclass, resourcemanagerinformation, resourcemanagerinformationlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationTransaction<P0>(transactionhandle: P0, transactioninformationclass: super::super::super::Win32::System::SystemServices::TRANSACTION_INFORMATION_CLASS, transactioninformation: *const ::core::ffi::c_void, transactioninformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetInformationTransaction(transactionhandle : super::super::super::Win32::Foundation:: HANDLE, transactioninformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTION_INFORMATION_CLASS, transactioninformation : *const ::core::ffi::c_void, transactioninformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetInformationTransaction(transactionhandle.into_param().abi(), transactioninformationclass, transactioninformation, transactioninformationlength)
}
#[cfg(feature = "Win32_System_SystemServices")]
#[inline]
pub unsafe fn ZwSetInformationTransactionManager<P0>(tmhandle: P0, transactionmanagerinformationclass: super::super::super::Win32::System::SystemServices::TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation: *const ::core::ffi::c_void, transactionmanagerinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetInformationTransactionManager(tmhandle : super::super::super::Win32::Foundation:: HANDLE, transactionmanagerinformationclass : super::super::super::Win32::System::SystemServices:: TRANSACTIONMANAGER_INFORMATION_CLASS, transactionmanagerinformation : *const ::core::ffi::c_void, transactionmanagerinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetInformationTransactionManager(tmhandle.into_param().abi(), transactionmanagerinformationclass, transactionmanagerinformation, transactionmanagerinformationlength)
}
#[inline]
pub unsafe fn ZwSetTimer<P0, P1>(timerhandle: P0, duetime: *const i64, timerapcroutine: PTIMER_APC_ROUTINE, timercontext: ::core::option::Option<*const ::core::ffi::c_void>, resumetimer: P1, period: i32, previousstate: ::core::option::Option<*mut super::super::super::Win32::Foundation::BOOLEAN>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::BOOLEAN>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetTimer(timerhandle : super::super::super::Win32::Foundation:: HANDLE, duetime : *const i64, timerapcroutine : PTIMER_APC_ROUTINE, timercontext : *const ::core::ffi::c_void, resumetimer : super::super::super::Win32::Foundation:: BOOLEAN, period : i32, previousstate : *mut super::super::super::Win32::Foundation:: BOOLEAN) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetTimer(timerhandle.into_param().abi(), duetime, timerapcroutine, ::core::mem::transmute(timercontext.unwrap_or(::std::ptr::null())), resumetimer.into_param().abi(), period, ::core::mem::transmute(previousstate.unwrap_or(::std::ptr::null_mut())))
}
#[inline]
pub unsafe fn ZwSetTimerEx<P0>(timerhandle: P0, timersetinformationclass: TIMER_SET_INFORMATION_CLASS, timersetinformation: ::core::option::Option<*mut ::core::ffi::c_void>, timersetinformationlength: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetTimerEx(timerhandle : super::super::super::Win32::Foundation:: HANDLE, timersetinformationclass : TIMER_SET_INFORMATION_CLASS, timersetinformation : *mut ::core::ffi::c_void, timersetinformationlength : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetTimerEx(timerhandle.into_param().abi(), timersetinformationclass, ::core::mem::transmute(timersetinformation.unwrap_or(::std::ptr::null_mut())), timersetinformationlength)
}
#[inline]
pub unsafe fn ZwSetValueKey<P0>(keyhandle: P0, valuename: *const super::super::super::Win32::Foundation::UNICODE_STRING, titleindex: u32, r#type: u32, data: ::core::option::Option<*const ::core::ffi::c_void>, datasize: u32) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSetValueKey(keyhandle : super::super::super::Win32::Foundation:: HANDLE, valuename : *const super::super::super::Win32::Foundation:: UNICODE_STRING, titleindex : u32, r#type : u32, data : *const ::core::ffi::c_void, datasize : u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSetValueKey(keyhandle.into_param().abi(), valuename, titleindex, r#type, ::core::mem::transmute(data.unwrap_or(::std::ptr::null())), datasize)
}
#[inline]
pub unsafe fn ZwSinglePhaseReject<P0>(enlistmenthandle: P0, tmvirtualclock: ::core::option::Option<*const i64>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwSinglePhaseReject(enlistmenthandle : super::super::super::Win32::Foundation:: HANDLE, tmvirtualclock : *const i64) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwSinglePhaseReject(enlistmenthandle.into_param().abi(), ::core::mem::transmute(tmvirtualclock.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn ZwTerminateProcess<P0, P1>(processhandle: P0, exitstatus: P1) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::NTSTATUS>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwTerminateProcess(processhandle : super::super::super::Win32::Foundation:: HANDLE, exitstatus : super::super::super::Win32::Foundation:: NTSTATUS) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwTerminateProcess(processhandle.into_param().abi(), exitstatus.into_param().abi())
}
#[inline]
pub unsafe fn ZwUnloadDriver(driverservicename: *const super::super::super::Win32::Foundation::UNICODE_STRING) -> super::super::super::Win32::Foundation::NTSTATUS {
    ::windows_targets::link!("ntdll.dll" "system" fn ZwUnloadDriver(driverservicename : *const super::super::super::Win32::Foundation:: UNICODE_STRING) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwUnloadDriver(driverservicename)
}
#[inline]
pub unsafe fn ZwUnmapViewOfSection<P0>(processhandle: P0, baseaddress: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwUnmapViewOfSection(processhandle : super::super::super::Win32::Foundation:: HANDLE, baseaddress : *const ::core::ffi::c_void) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwUnmapViewOfSection(processhandle.into_param().abi(), ::core::mem::transmute(baseaddress.unwrap_or(::std::ptr::null())))
}
#[cfg(feature = "Win32_System_IO")]
#[inline]
pub unsafe fn ZwWriteFile<P0, P1>(filehandle: P0, event: P1, apcroutine: super::super::super::Win32::System::IO::PIO_APC_ROUTINE, apccontext: ::core::option::Option<*const ::core::ffi::c_void>, iostatusblock: *mut super::super::super::Win32::System::IO::IO_STATUS_BLOCK, buffer: *const ::core::ffi::c_void, length: u32, byteoffset: ::core::option::Option<*const i64>, key: ::core::option::Option<*const u32>) -> super::super::super::Win32::Foundation::NTSTATUS
where
    P0: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
    P1: ::windows_core::IntoParam<super::super::super::Win32::Foundation::HANDLE>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn ZwWriteFile(filehandle : super::super::super::Win32::Foundation:: HANDLE, event : super::super::super::Win32::Foundation:: HANDLE, apcroutine : super::super::super::Win32::System::IO:: PIO_APC_ROUTINE, apccontext : *const ::core::ffi::c_void, iostatusblock : *mut super::super::super::Win32::System::IO:: IO_STATUS_BLOCK, buffer : *const ::core::ffi::c_void, length : u32, byteoffset : *const i64, key : *const u32) -> super::super::super::Win32::Foundation:: NTSTATUS);
    ZwWriteFile(filehandle.into_param().abi(), event.into_param().abi(), apcroutine, ::core::mem::transmute(apccontext.unwrap_or(::std::ptr::null())), iostatusblock, buffer, length, ::core::mem::transmute(byteoffset.unwrap_or(::std::ptr::null())), ::core::mem::transmute(key.unwrap_or(::std::ptr::null())))
}
#[inline]
pub unsafe fn vDbgPrintEx<P0>(componentid: u32, level: u32, format: P0, arglist: *const i8) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn vDbgPrintEx(componentid : u32, level : u32, format : ::windows_core::PCSTR, arglist : *const i8) -> u32);
    vDbgPrintEx(componentid, level, format.into_param().abi(), arglist)
}
#[inline]
pub unsafe fn vDbgPrintExWithPrefix<P0, P1>(prefix: P0, componentid: u32, level: u32, format: P1, arglist: *const i8) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("ntdll.dll" "system" fn vDbgPrintExWithPrefix(prefix : ::windows_core::PCSTR, componentid : u32, level : u32, format : ::windows_core::PCSTR, arglist : *const i8) -> u32);
    vDbgPrintExWithPrefix(prefix.into_param().abi(), componentid, level, format.into_param().abi(), arglist)
}
pub const ACPIBus: INTERFACE_TYPE = INTERFACE_TYPE(17i32);
pub const ADAPTER_INFO_API_BYPASS: u32 = 2u32;
pub const ADAPTER_INFO_SYNCHRONOUS_CALLBACK: u32 = 1u32;
pub const ALLOC_DATA_PRAGMA: u32 = 1u32;
pub const ALLOC_PRAGMA: u32 = 1u32;
pub const ANY_SIZE: u32 = 1u32;
pub const APC_LEVEL: u32 = 1u32;
pub const ARBITER_FLAG_BOOT_CONFIG: u32 = 1u32;
pub const ARBITER_FLAG_OTHER_ENUM: u32 = 4u32;
pub const ARBITER_FLAG_ROOT_ENUM: u32 = 2u32;
pub const ARBITER_PARTIAL: u32 = 1u32;
pub const ARM64_PCR_RESERVED_MASK: u32 = 4095u32;
pub const ARM_PROCESSOR_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe19e3d16_bc11_11e4_9caa_c2051d5d46b0);
pub const ATS_DEVICE_SVM_OPTOUT: u32 = 1u32;
pub const AccessFlagFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(5i32);
pub const AddressSizeFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(1i32);
pub const AgpControl: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(1i32);
pub const AllLoggerHandlesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(6i32);
pub const AperturePageSize: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(3i32);
pub const ApertureSize: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(2i32);
pub const ApicDestinationModeLogicalClustered: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(3i32);
pub const ApicDestinationModeLogicalFlat: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(2i32);
pub const ApicDestinationModePhysical: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(1i32);
pub const ApicDestinationModeUnknown: HAL_APIC_DESTINATION_MODE = HAL_APIC_DESTINATION_MODE(4i32);
pub const ArbiterActionAddReserved: ARBITER_ACTION = ARBITER_ACTION(8i32);
pub const ArbiterActionBootAllocation: ARBITER_ACTION = ARBITER_ACTION(9i32);
pub const ArbiterActionCommitAllocation: ARBITER_ACTION = ARBITER_ACTION(2i32);
pub const ArbiterActionQueryAllocatedResources: ARBITER_ACTION = ARBITER_ACTION(4i32);
pub const ArbiterActionQueryArbitrate: ARBITER_ACTION = ARBITER_ACTION(7i32);
pub const ArbiterActionQueryConflict: ARBITER_ACTION = ARBITER_ACTION(6i32);
pub const ArbiterActionRetestAllocation: ARBITER_ACTION = ARBITER_ACTION(1i32);
pub const ArbiterActionRollbackAllocation: ARBITER_ACTION = ARBITER_ACTION(3i32);
pub const ArbiterActionTestAllocation: ARBITER_ACTION = ARBITER_ACTION(0i32);
pub const ArbiterActionWriteReservedResources: ARBITER_ACTION = ARBITER_ACTION(5i32);
pub const ArbiterRequestHalReported: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(1i32);
pub const ArbiterRequestLegacyAssigned: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(2i32);
pub const ArbiterRequestLegacyReported: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(0i32);
pub const ArbiterRequestPnpDetected: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(3i32);
pub const ArbiterRequestPnpEnumerated: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(4i32);
pub const ArbiterRequestUndefined: ARBITER_REQUEST_SOURCE = ARBITER_REQUEST_SOURCE(-1i32);
pub const ArbiterResultExternalConflict: ARBITER_RESULT = ARBITER_RESULT(1i32);
pub const ArbiterResultNullRequest: ARBITER_RESULT = ARBITER_RESULT(2i32);
pub const ArbiterResultSuccess: ARBITER_RESULT = ARBITER_RESULT(0i32);
pub const ArbiterResultUndefined: ARBITER_RESULT = ARBITER_RESULT(-1i32);
pub const ArcSystem: CONFIGURATION_TYPE = CONFIGURATION_TYPE(0i32);
pub const AssignSecurityDescriptor: SECURITY_OPERATION_CODE = SECURITY_OPERATION_CODE(3i32);
pub const AudioController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(23i32);
pub const BMC_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x487565ba_6494_4367_95ca_4eff893522f6);
pub const BOOT_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3d61a466_ab40_409a_a698_f362d464b38f);
pub const BackgroundWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(4i32);
pub const BdCbClassificationEnd: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(4i32);
pub const BdCbClassificationKnownBadImage: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(2i32);
pub const BdCbClassificationKnownBadImageBootCritical: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(3i32);
pub const BdCbClassificationKnownGoodImage: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(1i32);
pub const BdCbClassificationUnknownImage: BDCB_CLASSIFICATION = BDCB_CLASSIFICATION(0i32);
pub const BdCbInitializeImage: BDCB_CALLBACK_TYPE = BDCB_CALLBACK_TYPE(1i32);
pub const BdCbStatusPrepareForDependencyLoad: BDCB_STATUS_UPDATE_TYPE = BDCB_STATUS_UPDATE_TYPE(0i32);
pub const BdCbStatusPrepareForDriverLoad: BDCB_STATUS_UPDATE_TYPE = BDCB_STATUS_UPDATE_TYPE(1i32);
pub const BdCbStatusPrepareForUnload: BDCB_STATUS_UPDATE_TYPE = BDCB_STATUS_UPDATE_TYPE(2i32);
pub const BdCbStatusUpdate: BDCB_CALLBACK_TYPE = BDCB_CALLBACK_TYPE(0i32);
pub const BoundExceptionContinueSearch: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(0i32);
pub const BoundExceptionError: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(2i32);
pub const BoundExceptionHandled: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(1i32);
pub const BoundExceptionMaximum: BOUND_CALLBACK_STATUS = BOUND_CALLBACK_STATUS(3i32);
pub const BufferEmpty: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(0i32);
pub const BufferFinished: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(3i32);
pub const BufferIncomplete: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(4i32);
pub const BufferInserted: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(1i32);
pub const BufferStarted: KBUGCHECK_BUFFER_DUMP_STATE = KBUGCHECK_BUFFER_DUMP_STATE(2i32);
pub const BusQueryCompatibleIDs: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(2i32);
pub const BusQueryContainerID: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(5i32);
pub const BusQueryDeviceID: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(0i32);
pub const BusQueryDeviceSerialNumber: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(4i32);
pub const BusQueryHardwareIDs: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(1i32);
pub const BusQueryInstanceID: BUS_QUERY_ID_TYPE = BUS_QUERY_ID_TYPE(3i32);
pub const BusRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(0i32);
pub const BusWidth32Bits: PCI_BUS_WIDTH = PCI_BUS_WIDTH(0i32);
pub const BusWidth64Bits: PCI_BUS_WIDTH = PCI_BUS_WIDTH(1i32);
pub const CBus: INTERFACE_TYPE = INTERFACE_TYPE(9i32);
pub const CLFS_MAX_CONTAINER_INFO: u32 = 256u32;
pub const CLFS_SCAN_BACKWARD: u8 = 4u8;
pub const CLFS_SCAN_BUFFERED: u8 = 32u8;
pub const CLFS_SCAN_CLOSE: u8 = 8u8;
pub const CLFS_SCAN_FORWARD: u8 = 2u8;
pub const CLFS_SCAN_INIT: u8 = 1u8;
pub const CLFS_SCAN_INITIALIZED: u8 = 16u8;
pub const CLOCK1_LEVEL: u32 = 28u32;
pub const CLOCK2_LEVEL: u32 = 28u32;
pub const CLOCK_LEVEL: u32 = 28u32;
pub const CMCI_LEVEL: u32 = 5u32;
pub const CMCI_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x919448b2_3739_4b7f_a8f1_e0062805c2a3);
pub const CMC_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x2dce8bb1_bdd7_450e_b9ad_9cf4ebd4f890);
pub const CM_RESOURCE_CONNECTION_CLASS_FUNCTION_CONFIG: u32 = 3u32;
pub const CM_RESOURCE_CONNECTION_CLASS_GPIO: u32 = 1u32;
pub const CM_RESOURCE_CONNECTION_CLASS_SERIAL: u32 = 2u32;
pub const CM_RESOURCE_CONNECTION_TYPE_FUNCTION_CONFIG: u32 = 1u32;
pub const CM_RESOURCE_CONNECTION_TYPE_GPIO_IO: u32 = 2u32;
pub const CM_RESOURCE_CONNECTION_TYPE_SERIAL_I2C: u32 = 1u32;
pub const CM_RESOURCE_CONNECTION_TYPE_SERIAL_SPI: u32 = 2u32;
pub const CM_RESOURCE_CONNECTION_TYPE_SERIAL_UART: u32 = 3u32;
pub const CM_RESOURCE_DMA_16: u32 = 1u32;
pub const CM_RESOURCE_DMA_32: u32 = 2u32;
pub const CM_RESOURCE_DMA_8: u32 = 0u32;
pub const CM_RESOURCE_DMA_8_AND_16: u32 = 4u32;
pub const CM_RESOURCE_DMA_BUS_MASTER: u32 = 8u32;
pub const CM_RESOURCE_DMA_TYPE_A: u32 = 16u32;
pub const CM_RESOURCE_DMA_TYPE_B: u32 = 32u32;
pub const CM_RESOURCE_DMA_TYPE_F: u32 = 64u32;
pub const CM_RESOURCE_DMA_V3: u32 = 128u32;
pub const CM_RESOURCE_INTERRUPT_LATCHED: u32 = 1u32;
pub const CM_RESOURCE_INTERRUPT_LEVEL_LATCHED_BITS: u32 = 1u32;
pub const CM_RESOURCE_INTERRUPT_LEVEL_SENSITIVE: u32 = 0u32;
pub const CM_RESOURCE_INTERRUPT_MESSAGE: u32 = 2u32;
pub const CM_RESOURCE_INTERRUPT_POLICY_INCLUDED: u32 = 4u32;
pub const CM_RESOURCE_INTERRUPT_SECONDARY_INTERRUPT: u32 = 16u32;
pub const CM_RESOURCE_INTERRUPT_WAKE_HINT: u32 = 32u32;
pub const CM_RESOURCE_MEMORY_24: u32 = 16u32;
pub const CM_RESOURCE_MEMORY_BAR: u32 = 128u32;
pub const CM_RESOURCE_MEMORY_CACHEABLE: u32 = 32u32;
pub const CM_RESOURCE_MEMORY_COMBINEDWRITE: u32 = 8u32;
pub const CM_RESOURCE_MEMORY_COMPAT_FOR_INACCESSIBLE_RANGE: u32 = 256u32;
pub const CM_RESOURCE_MEMORY_LARGE: u32 = 3584u32;
pub const CM_RESOURCE_MEMORY_LARGE_40: u32 = 512u32;
pub const CM_RESOURCE_MEMORY_LARGE_40_MAXLEN: u64 = 1099511627520u64;
pub const CM_RESOURCE_MEMORY_LARGE_48: u32 = 1024u32;
pub const CM_RESOURCE_MEMORY_LARGE_48_MAXLEN: u64 = 281474976645120u64;
pub const CM_RESOURCE_MEMORY_LARGE_64: u32 = 2048u32;
pub const CM_RESOURCE_MEMORY_LARGE_64_MAXLEN: u64 = 18446744069414584320u64;
pub const CM_RESOURCE_MEMORY_PREFETCHABLE: u32 = 4u32;
pub const CM_RESOURCE_MEMORY_READ_ONLY: u32 = 1u32;
pub const CM_RESOURCE_MEMORY_READ_WRITE: u32 = 0u32;
pub const CM_RESOURCE_MEMORY_WINDOW_DECODE: u32 = 64u32;
pub const CM_RESOURCE_MEMORY_WRITEABILITY_MASK: u32 = 3u32;
pub const CM_RESOURCE_MEMORY_WRITE_ONLY: u32 = 2u32;
pub const CM_RESOURCE_PORT_10_BIT_DECODE: u32 = 4u32;
pub const CM_RESOURCE_PORT_12_BIT_DECODE: u32 = 8u32;
pub const CM_RESOURCE_PORT_16_BIT_DECODE: u32 = 16u32;
pub const CM_RESOURCE_PORT_BAR: u32 = 256u32;
pub const CM_RESOURCE_PORT_IO: u32 = 1u32;
pub const CM_RESOURCE_PORT_MEMORY: u32 = 0u32;
pub const CM_RESOURCE_PORT_PASSIVE_DECODE: u32 = 64u32;
pub const CM_RESOURCE_PORT_POSITIVE_DECODE: u32 = 32u32;
pub const CM_RESOURCE_PORT_WINDOW_DECODE: u32 = 128u32;
pub const CM_SERVICE_MEASURED_BOOT_LOAD: u32 = 32u32;
pub const CONNECT_CURRENT_VERSION: u32 = 5u32;
pub const CONNECT_FULLY_SPECIFIED: u32 = 1u32;
pub const CONNECT_FULLY_SPECIFIED_GROUP: u32 = 4u32;
pub const CONNECT_LINE_BASED: u32 = 2u32;
pub const CONNECT_MESSAGE_BASED: u32 = 3u32;
pub const CONNECT_MESSAGE_BASED_PASSIVE: u32 = 5u32;
pub const CP15_PCR_RESERVED_MASK: u32 = 4095u32;
pub const CPER_EMPTY_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x00000000_0000_0000_0000_000000000000);
pub const CPE_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4e292f96_d843_4a55_a8c2_d481f27ebeee);
pub const CP_GET_ERROR: u32 = 2u32;
pub const CP_GET_NODATA: u32 = 1u32;
pub const CP_GET_SUCCESS: u32 = 0u32;
pub const CardPresent: PCI_EXPRESS_CARD_PRESENCE = PCI_EXPRESS_CARD_PRESENCE(1i32);
pub const CbusConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(3i32);
pub const CdromController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(15i32);
pub const CentralProcessor: CONFIGURATION_TYPE = CONFIGURATION_TYPE(1i32);
pub const ClfsClientRecord: u8 = 3u8;
pub const ClfsContainerActive: u32 = 4u32;
pub const ClfsContainerActivePendingDelete: u32 = 8u32;
pub const ClfsContainerInactive: u32 = 2u32;
pub const ClfsContainerInitializing: u32 = 1u32;
pub const ClfsContainerPendingArchive: u32 = 16u32;
pub const ClfsContainerPendingArchiveAndDelete: u32 = 32u32;
pub const ClfsDataRecord: u8 = 1u8;
pub const ClfsNullRecord: u8 = 0u8;
pub const ClfsRestartRecord: u8 = 2u8;
pub const ClsContainerActive: u32 = 4u32;
pub const ClsContainerActivePendingDelete: u32 = 8u32;
pub const ClsContainerInactive: u32 = 2u32;
pub const ClsContainerInitializing: u32 = 1u32;
pub const ClsContainerPendingArchive: u32 = 16u32;
pub const ClsContainerPendingArchiveAndDelete: u32 = 32u32;
pub const CmResourceShareDeviceExclusive: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(1i32);
pub const CmResourceShareDriverExclusive: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(2i32);
pub const CmResourceShareShared: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(3i32);
pub const CmResourceShareUndetermined: CM_SHARE_DISPOSITION = CM_SHARE_DISPOSITION(0i32);
pub const CmResourceTypeBusNumber: u32 = 6u32;
pub const CmResourceTypeConfigData: u32 = 128u32;
pub const CmResourceTypeConnection: u32 = 132u32;
pub const CmResourceTypeDevicePrivate: u32 = 129u32;
pub const CmResourceTypeDeviceSpecific: u32 = 5u32;
pub const CmResourceTypeDma: u32 = 4u32;
pub const CmResourceTypeInterrupt: u32 = 2u32;
pub const CmResourceTypeMaximum: u32 = 8u32;
pub const CmResourceTypeMemory: u32 = 3u32;
pub const CmResourceTypeMemoryLarge: u32 = 7u32;
pub const CmResourceTypeMfCardConfig: u32 = 131u32;
pub const CmResourceTypeNonArbitrated: u32 = 128u32;
pub const CmResourceTypeNull: u32 = 0u32;
pub const CmResourceTypePcCardConfig: u32 = 130u32;
pub const CmResourceTypePort: u32 = 1u32;
pub const Cmos: BUS_DATA_TYPE = BUS_DATA_TYPE(0i32);
pub const CommonBufferConfigTypeHardwareAccessPermissions: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(2i32);
pub const CommonBufferConfigTypeLogicalAddressLimits: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(0i32);
pub const CommonBufferConfigTypeMax: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(3i32);
pub const CommonBufferConfigTypeSubSection: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(1i32);
pub const CommonBufferHardwareAccessMax: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(3i32);
pub const CommonBufferHardwareAccessReadOnly: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(0i32);
pub const CommonBufferHardwareAccessReadWrite: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(2i32);
pub const CommonBufferHardwareAccessWriteOnly: DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE = DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(1i32);
pub const Compatible: DMA_SPEED = DMA_SPEED(0i32);
pub const ConfigurationSpaceUndefined: BUS_DATA_TYPE = BUS_DATA_TYPE(-1i32);
pub const ContinueCompletion: IO_COMPLETION_ROUTINE_RESULT = IO_COMPLETION_ROUTINE_RESULT(0i32);
pub const CreateFileTypeMailslot: CREATE_FILE_TYPE = CREATE_FILE_TYPE(2i32);
pub const CreateFileTypeNamedPipe: CREATE_FILE_TYPE = CREATE_FILE_TYPE(1i32);
pub const CreateFileTypeNone: CREATE_FILE_TYPE = CREATE_FILE_TYPE(0i32);
pub const CriticalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(0i32);
pub const CustomPriorityWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(32i32);
pub const D3COLD_SUPPORT_INTERFACE_VERSION: u32 = 1u32;
pub const DBG_DEVICE_FLAG_BARS_MAPPED: u32 = 2u32;
pub const DBG_DEVICE_FLAG_HAL_SCRATCH_ALLOCATED: u32 = 1u32;
pub const DBG_DEVICE_FLAG_HOST_VISIBLE_ALLOCATED: u32 = 32u32;
pub const DBG_DEVICE_FLAG_SCRATCH_ALLOCATED: u32 = 4u32;
pub const DBG_DEVICE_FLAG_SYNTHETIC: u32 = 16u32;
pub const DBG_DEVICE_FLAG_UNCACHED_MEMORY: u32 = 8u32;
pub const DBG_STATUS_BUGCHECK_FIRST: u32 = 3u32;
pub const DBG_STATUS_BUGCHECK_SECOND: u32 = 4u32;
pub const DBG_STATUS_CONTROL_C: u32 = 1u32;
pub const DBG_STATUS_DEBUG_CONTROL: u32 = 6u32;
pub const DBG_STATUS_FATAL: u32 = 5u32;
pub const DBG_STATUS_SYSRQ: u32 = 2u32;
pub const DBG_STATUS_WORKER: u32 = 7u32;
pub const DEFAULT_DEVICE_DRIVER_CREATOR_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x57217c8d_5e66_44fb_8033_9b74cacedf5b);
pub const DEVICE_DESCRIPTION_VERSION: u32 = 0u32;
pub const DEVICE_DESCRIPTION_VERSION1: u32 = 1u32;
pub const DEVICE_DESCRIPTION_VERSION2: u32 = 2u32;
pub const DEVICE_DESCRIPTION_VERSION3: u32 = 3u32;
pub const DEVICE_DRIVER_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0033f803_2e70_4e88_992c_6f26daf3db7a);
pub const DEVICE_INTERFACE_INCLUDE_NONACTIVE: u32 = 1u32;
pub const DEVICE_RESET_INTERFACE_VERSION: u32 = 1u32;
pub const DEVICE_RESET_INTERFACE_VERSION_1: u32 = 1u32;
pub const DEVICE_RESET_INTERFACE_VERSION_2: u32 = 2u32;
pub const DEVICE_RESET_INTERFACE_VERSION_3: u32 = 3u32;
pub const DIRECTORY_CREATE_OBJECT: u32 = 4u32;
pub const DIRECTORY_CREATE_SUBDIRECTORY: u32 = 8u32;
pub const DIRECTORY_QUERY: u32 = 1u32;
pub const DIRECTORY_TRAVERSE: u32 = 2u32;
pub const DISPATCH_LEVEL: u32 = 2u32;
pub const DMAV3_TRANFER_WIDTH_128: u32 = 4u32;
pub const DMAV3_TRANFER_WIDTH_16: u32 = 1u32;
pub const DMAV3_TRANFER_WIDTH_256: u32 = 5u32;
pub const DMAV3_TRANFER_WIDTH_32: u32 = 2u32;
pub const DMAV3_TRANFER_WIDTH_64: u32 = 3u32;
pub const DMAV3_TRANFER_WIDTH_8: u32 = 0u32;
pub const DMA_ADAPTER_INFO_VERSION1: u32 = 1u32;
pub const DMA_FAIL_ON_BOUNCE: u32 = 4u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_1: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_2: u32 = 2u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_MAX: u32 = 2u32;
pub const DMA_IOMMU_INTERFACE_EX_VERSION_MIN: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_VERSION: u32 = 1u32;
pub const DMA_IOMMU_INTERFACE_VERSION_1: u32 = 1u32;
pub const DMA_SYNCHRONOUS_CALLBACK: u32 = 1u32;
pub const DMA_TRANSFER_CONTEXT_SIZE_V1: u32 = 128u32;
pub const DMA_TRANSFER_CONTEXT_VERSION1: u32 = 1u32;
pub const DMA_TRANSFER_INFO_VERSION1: u32 = 1u32;
pub const DMA_TRANSFER_INFO_VERSION2: u32 = 2u32;
pub const DMA_ZERO_BUFFERS: u32 = 2u32;
pub const DOMAIN_COMMON_BUFFER_LARGE_PAGE: u32 = 1u32;
pub const DPC_NORMAL: u32 = 0u32;
pub const DPC_THREADED: u32 = 1u32;
pub const DPC_WATCHDOG_GLOBAL_TRIAGE_BLOCK_REVISION_1: u32 = 1u32;
pub const DPC_WATCHDOG_GLOBAL_TRIAGE_BLOCK_SIGNATURE: u32 = 2931740382u32;
pub const DRIVER_VERIFIER_FORCE_IRQL_CHECKING: u32 = 2u32;
pub const DRIVER_VERIFIER_INJECT_ALLOCATION_FAILURES: u32 = 4u32;
pub const DRIVER_VERIFIER_IO_CHECKING: u32 = 16u32;
pub const DRIVER_VERIFIER_SPECIAL_POOLING: u32 = 1u32;
pub const DRIVER_VERIFIER_TRACK_POOL_ALLOCATIONS: u32 = 8u32;
pub const DRS_LEVEL: u32 = 14u32;
pub const DRVO_BOOTREINIT_REGISTERED: u32 = 32u32;
pub const DRVO_BUILTIN_DRIVER: u32 = 4u32;
pub const DRVO_INITIALIZED: u32 = 16u32;
pub const DRVO_LEGACY_DRIVER: u32 = 2u32;
pub const DRVO_LEGACY_RESOURCES: u32 = 64u32;
pub const DRVO_REINIT_REGISTERED: u32 = 8u32;
pub const DRVO_UNLOAD_INVOKED: u32 = 1u32;
pub const DUPLICATE_SAME_ATTRIBUTES: u32 = 4u32;
pub const DeallocateObject: IO_ALLOCATION_ACTION = IO_ALLOCATION_ACTION(2i32);
pub const DeallocateObjectKeepRegisters: IO_ALLOCATION_ACTION = IO_ALLOCATION_ACTION(3i32);
pub const DelayExecution: KWAIT_REASON = KWAIT_REASON(4i32);
pub const DelayedWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(1i32);
pub const DeleteSecurityDescriptor: SECURITY_OPERATION_CODE = SECURITY_OPERATION_CODE(2i32);
pub const DeviceDirectoryData: DEVICE_DIRECTORY_TYPE = DEVICE_DIRECTORY_TYPE(0i32);
pub const DevicePowerState: POWER_STATE_TYPE = POWER_STATE_TYPE(1i32);
pub const DevicePropertyAddress: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(16i32);
pub const DevicePropertyAllocatedResources: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(21i32);
pub const DevicePropertyBootConfiguration: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(3i32);
pub const DevicePropertyBootConfigurationTranslated: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4i32);
pub const DevicePropertyBusNumber: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(14i32);
pub const DevicePropertyBusTypeGuid: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(8204i32);
pub const DevicePropertyClassGuid: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4102i32);
pub const DevicePropertyClassName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4101i32);
pub const DevicePropertyCompatibleIDs: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(16386i32);
pub const DevicePropertyContainerID: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4118i32);
pub const DevicePropertyDeviceDescription: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4096i32);
pub const DevicePropertyDriverKeyName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4103i32);
pub const DevicePropertyEnumeratorName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4111i32);
pub const DevicePropertyFriendlyName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4105i32);
pub const DevicePropertyHardwareID: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(16385i32);
pub const DevicePropertyInstallState: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(18i32);
pub const DevicePropertyLegacyBusType: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(13i32);
pub const DevicePropertyLocationInformation: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4106i32);
pub const DevicePropertyManufacturer: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4104i32);
pub const DevicePropertyPhysicalDeviceObjectName: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(4107i32);
pub const DevicePropertyRemovalPolicy: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(19i32);
pub const DevicePropertyResourceRequirements: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(20i32);
pub const DevicePropertyUINumber: DEVICE_REGISTRY_PROPERTY = DEVICE_REGISTRY_PROPERTY(17i32);
pub const DeviceTextDescription: DEVICE_TEXT_TYPE = DEVICE_TEXT_TYPE(0i32);
pub const DeviceTextLocationInformation: DEVICE_TEXT_TYPE = DEVICE_TEXT_TYPE(1i32);
pub const DeviceUsageTypeBoot: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(4i32);
pub const DeviceUsageTypeDumpFile: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(3i32);
pub const DeviceUsageTypeGuestAssigned: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(6i32);
pub const DeviceUsageTypeHibernation: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(2i32);
pub const DeviceUsageTypePaging: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(1i32);
pub const DeviceUsageTypePostDisplay: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(5i32);
pub const DeviceUsageTypeUndefined: DEVICE_USAGE_NOTIFICATION_TYPE = DEVICE_USAGE_NOTIFICATION_TYPE(0i32);
pub const DeviceWakeDepthD0: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(1i32);
pub const DeviceWakeDepthD1: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(2i32);
pub const DeviceWakeDepthD2: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(3i32);
pub const DeviceWakeDepthD3cold: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(5i32);
pub const DeviceWakeDepthD3hot: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(4i32);
pub const DeviceWakeDepthMaximum: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(6i32);
pub const DeviceWakeDepthNotWakeable: DEVICE_WAKE_DEPTH = DEVICE_WAKE_DEPTH(0i32);
pub const DirectoryNotifyExtendedInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(2i32);
pub const DirectoryNotifyFullInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(3i32);
pub const DirectoryNotifyInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(1i32);
pub const DirectoryNotifyMaximumInformation: DIRECTORY_NOTIFY_INFORMATION_CLASS = DIRECTORY_NOTIFY_INFORMATION_CLASS(4i32);
pub const DisabledControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(11i32);
pub const DiskController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(13i32);
pub const DiskIoNotifyRoutinesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(11i32);
pub const DiskPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(25i32);
pub const DisplayController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(19i32);
pub const DmaAborted: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(1i32);
pub const DmaCancelled: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(3i32);
pub const DmaComplete: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(0i32);
pub const DmaError: DMA_COMPLETION_STATUS = DMA_COMPLETION_STATUS(2i32);
pub const DockingInformation: CONFIGURATION_TYPE = CONFIGURATION_TYPE(38i32);
pub const DomainConfigurationArm64: DOMAIN_CONFIGURATION_ARCH = DOMAIN_CONFIGURATION_ARCH(0i32);
pub const DomainConfigurationInvalid: DOMAIN_CONFIGURATION_ARCH = DOMAIN_CONFIGURATION_ARCH(2i32);
pub const DomainConfigurationX64: DOMAIN_CONFIGURATION_ARCH = DOMAIN_CONFIGURATION_ARCH(1i32);
pub const DomainTypeMax: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(3i32);
pub const DomainTypePassThrough: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(1i32);
pub const DomainTypeTranslate: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(0i32);
pub const DomainTypeUnmanaged: IOMMU_DMA_DOMAIN_TYPE = IOMMU_DMA_DOMAIN_TYPE(2i32);
pub const DriverDirectoryData: DRIVER_DIRECTORY_TYPE = DRIVER_DIRECTORY_TYPE(1i32);
pub const DriverDirectoryImage: DRIVER_DIRECTORY_TYPE = DRIVER_DIRECTORY_TYPE(0i32);
pub const DriverDirectorySharedData: DRIVER_DIRECTORY_TYPE = DRIVER_DIRECTORY_TYPE(2i32);
pub const DriverRegKeyParameters: DRIVER_REGKEY_TYPE = DRIVER_REGKEY_TYPE(0i32);
pub const DriverRegKeyPersistentState: DRIVER_REGKEY_TYPE = DRIVER_REGKEY_TYPE(1i32);
pub const DriverRegKeySharedPersistentState: DRIVER_REGKEY_TYPE = DRIVER_REGKEY_TYPE(2i32);
pub const DrvRtPoolNxOptIn: DRIVER_RUNTIME_INIT_FLAGS = DRIVER_RUNTIME_INIT_FLAGS(1i32);
pub const DtiAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(11i32);
pub const EFLAG_SIGN: u32 = 32768u32;
pub const EFLAG_ZERO: u32 = 16384u32;
pub const EISA_EMPTY_SLOT: u32 = 131u32;
pub const EISA_FREE_FORM_DATA: u32 = 64u32;
pub const EISA_FUNCTION_ENABLED: u32 = 128u32;
pub const EISA_HAS_DMA_ENTRY: u32 = 8u32;
pub const EISA_HAS_IRQ_ENTRY: u32 = 4u32;
pub const EISA_HAS_MEMORY_ENTRY: u32 = 2u32;
pub const EISA_HAS_PORT_INIT_ENTRY: u32 = 32u32;
pub const EISA_HAS_PORT_RANGE: u32 = 16u32;
pub const EISA_HAS_TYPE_ENTRY: u32 = 1u32;
pub const EISA_INVALID_BIOS_CALL: u32 = 134u32;
pub const EISA_INVALID_CONFIGURATION: u32 = 130u32;
pub const EISA_INVALID_FUNCTION: u32 = 129u32;
pub const EISA_INVALID_SLOT: u32 = 128u32;
pub const EISA_MEMORY_TYPE_RAM: u32 = 1u32;
pub const EISA_MORE_ENTRIES: u32 = 128u32;
pub const EISA_SYSTEM_MEMORY: u32 = 0u32;
pub const ERROR_LOG_LIMIT_SIZE: u32 = 240u32;
pub const ERROR_MAJOR_REVISION_SAL_03_00: u32 = 0u32;
pub const ERROR_MEMORY_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf2_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_MINOR_REVISION_SAL_03_00: u32 = 2u32;
pub const ERROR_PCI_BUS_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf4_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PCI_COMPONENT_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf6_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PLATFORM_BUS_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf9_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PLATFORM_HOST_CONTROLLER_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf8_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PLATFORM_SPECIFIC_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf7_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_PROCESSOR_STATE_PARAMETER_BUS_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_BUS_CHECK_SHIFT: u32 = 61u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_CACHE_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_CACHE_CHECK_SHIFT: u32 = 59u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_MICROARCH_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_MICROARCH_CHECK_SHIFT: u32 = 63u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_REG_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_REG_CHECK_SHIFT: u32 = 62u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_TLB_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_TLB_CHECK_SHIFT: u32 = 60u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_UNKNOWN_CHECK_MASK: u32 = 1u32;
pub const ERROR_PROCESSOR_STATE_PARAMETER_UNKNOWN_CHECK_SHIFT: u32 = 63u32;
pub const ERROR_SMBIOS_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf5_3cb7_11d4_bca7_0080c73c8881);
pub const ERROR_SYSTEM_EVENT_LOG_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe429faf3_3cb7_11d4_bca7_0080c73c8881);
pub const ERRTYP_BUS: u32 = 16u32;
pub const ERRTYP_CACHE: u32 = 6u32;
pub const ERRTYP_FLOW: u32 = 9u32;
pub const ERRTYP_FUNCTION: u32 = 7u32;
pub const ERRTYP_IMPROPER: u32 = 18u32;
pub const ERRTYP_INTERNAL: u32 = 1u32;
pub const ERRTYP_LOSSOFLOCKSTEP: u32 = 20u32;
pub const ERRTYP_MAP: u32 = 17u32;
pub const ERRTYP_MEM: u32 = 4u32;
pub const ERRTYP_PARITY: u32 = 22u32;
pub const ERRTYP_PATHERROR: u32 = 24u32;
pub const ERRTYP_POISONED: u32 = 26u32;
pub const ERRTYP_PROTOCOL: u32 = 23u32;
pub const ERRTYP_RESPONSE: u32 = 21u32;
pub const ERRTYP_SELFTEST: u32 = 8u32;
pub const ERRTYP_TIMEOUT: u32 = 25u32;
pub const ERRTYP_TLB: u32 = 5u32;
pub const ERRTYP_UNIMPL: u32 = 19u32;
pub const EVENT_QUERY_STATE: u32 = 1u32;
pub const EXCEPTION_ALIGNMENT_CHECK: u32 = 17u32;
pub const EXCEPTION_BOUND_CHECK: u32 = 5u32;
pub const EXCEPTION_CP_FAULT: u32 = 21u32;
pub const EXCEPTION_DEBUG: u32 = 1u32;
pub const EXCEPTION_DIVIDED_BY_ZERO: u32 = 0u32;
pub const EXCEPTION_DOUBLE_FAULT: u32 = 8u32;
pub const EXCEPTION_GP_FAULT: u32 = 13u32;
pub const EXCEPTION_INT3: u32 = 3u32;
pub const EXCEPTION_INVALID_OPCODE: u32 = 6u32;
pub const EXCEPTION_INVALID_TSS: u32 = 10u32;
pub const EXCEPTION_NMI: u32 = 2u32;
pub const EXCEPTION_NPX_ERROR: u32 = 16u32;
pub const EXCEPTION_NPX_NOT_AVAILABLE: u32 = 7u32;
pub const EXCEPTION_NPX_OVERRUN: u32 = 9u32;
pub const EXCEPTION_RESERVED_TRAP: u32 = 15u32;
pub const EXCEPTION_SEGMENT_NOT_PRESENT: u32 = 11u32;
pub const EXCEPTION_SE_FAULT: u32 = 23u32;
pub const EXCEPTION_SOFTWARE_ORIGINATE: u32 = 128u32;
pub const EXCEPTION_STACK_FAULT: u32 = 12u32;
pub const EXCEPTION_VIRTUALIZATION_FAULT: u32 = 32u32;
pub const EXTINT_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfe84086e_b557_43cf_ac1b_17982e078470);
pub const EX_CARR_ALLOCATE_NONPAGED_POOL: u32 = 1u32;
pub const EX_CARR_ALLOCATE_PAGED_POOL: u32 = 0u32;
pub const EX_CARR_DISABLE_EXPANSION: u32 = 2u32;
pub const EX_CREATE_FLAG_FILE_DEST_OPEN_FOR_COPY: u32 = 2u32;
pub const EX_CREATE_FLAG_FILE_SOURCE_OPEN_FOR_COPY: u32 = 1u32;
pub const EX_DEFAULT_PUSH_LOCK_FLAGS: u32 = 0u32;
pub const EX_LOOKASIDE_LIST_EX_FLAGS_FAIL_NO_RAISE: u32 = 2u32;
pub const EX_LOOKASIDE_LIST_EX_FLAGS_RAISE_ON_FAIL: u32 = 1u32;
pub const EX_MAXIMUM_LOOKASIDE_DEPTH_BASE: u32 = 256u32;
pub const EX_MAXIMUM_LOOKASIDE_DEPTH_LIMIT: u32 = 1024u32;
pub const EX_RUNDOWN_ACTIVE: u32 = 1u32;
pub const EX_RUNDOWN_COUNT_SHIFT: u32 = 1u32;
pub const EX_TIMER_HIGH_RESOLUTION: u32 = 4u32;
pub const EX_TIMER_NO_WAKE: u32 = 8u32;
pub const Eisa: INTERFACE_TYPE = INTERFACE_TYPE(2i32);
pub const EisaAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(8i32);
pub const EisaConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(1i32);
pub const EjectionRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(1i32);
pub const EndAlternatives: ALTERNATIVE_ARCHITECTURE_TYPE = ALTERNATIVE_ARCHITECTURE_TYPE(2i32);
pub const EventCategoryDeviceInterfaceChange: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(2i32);
pub const EventCategoryHardwareProfileChange: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(1i32);
pub const EventCategoryKernelSoftRestart: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(4i32);
pub const EventCategoryReserved: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(0i32);
pub const EventCategoryTargetDeviceChange: IO_NOTIFICATION_EVENT_CATEGORY = IO_NOTIFICATION_EVENT_CATEGORY(3i32);
pub const EventLoggerHandleClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(5i32);
pub const Executive: KWAIT_REASON = KWAIT_REASON(0i32);
pub const ExternalFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(3i32);
pub const FILE_128_BYTE_ALIGNMENT: u32 = 127u32;
pub const FILE_256_BYTE_ALIGNMENT: u32 = 255u32;
pub const FILE_32_BYTE_ALIGNMENT: u32 = 31u32;
pub const FILE_512_BYTE_ALIGNMENT: u32 = 511u32;
pub const FILE_64_BYTE_ALIGNMENT: u32 = 63u32;
pub const FILE_ATTRIBUTE_VALID_FLAGS: u32 = 32695u32;
pub const FILE_ATTRIBUTE_VALID_KERNEL_SET_FLAGS: u32 = 5910951u32;
pub const FILE_ATTRIBUTE_VALID_SET_FLAGS: u32 = 12711u32;
pub const FILE_AUTOGENERATED_DEVICE_NAME: u32 = 128u32;
pub const FILE_BYTE_ALIGNMENT: u32 = 0u32;
pub const FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL: u32 = 512u32;
pub const FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_DEPRECATED: u32 = 512u32;
pub const FILE_CHARACTERISTICS_EXPECT_ORDERLY_REMOVAL_EX: u32 = 16384u32;
pub const FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL: u32 = 768u32;
pub const FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_DEPRECATED: u32 = 768u32;
pub const FILE_CHARACTERISTICS_EXPECT_SURPRISE_REMOVAL_EX: u32 = 32768u32;
pub const FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK: u32 = 768u32;
pub const FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_DEPRECATED: u32 = 768u32;
pub const FILE_CHARACTERISTICS_REMOVAL_POLICY_MASK_EX: u32 = 768u32;
pub const FILE_CHARACTERISTIC_CSV: u32 = 65536u32;
pub const FILE_CHARACTERISTIC_PNP_DEVICE: u32 = 2048u32;
pub const FILE_CHARACTERISTIC_TS_DEVICE: u32 = 4096u32;
pub const FILE_CHARACTERISTIC_WEBDAV_DEVICE: u32 = 8192u32;
pub const FILE_DEVICE_ALLOW_APPCONTAINER_TRAVERSAL: u32 = 131072u32;
pub const FILE_DEVICE_IS_MOUNTED: u32 = 32u32;
pub const FILE_DEVICE_REQUIRE_SECURITY_CHECK: u32 = 1048576u32;
pub const FILE_DEVICE_SECURE_OPEN: u32 = 256u32;
pub const FILE_FLOPPY_DISKETTE: u32 = 4u32;
pub const FILE_LONG_ALIGNMENT: u32 = 3u32;
pub const FILE_OCTA_ALIGNMENT: u32 = 15u32;
pub const FILE_PORTABLE_DEVICE: u32 = 262144u32;
pub const FILE_QUAD_ALIGNMENT: u32 = 7u32;
pub const FILE_QUERY_INDEX_SPECIFIED: u32 = 4u32;
pub const FILE_QUERY_NO_CURSOR_UPDATE: u32 = 16u32;
pub const FILE_QUERY_RESTART_SCAN: u32 = 1u32;
pub const FILE_QUERY_RETURN_ON_DISK_ENTRIES_ONLY: u32 = 8u32;
pub const FILE_QUERY_RETURN_SINGLE_ENTRY: u32 = 2u32;
pub const FILE_READ_ONLY_DEVICE: u32 = 2u32;
pub const FILE_REMOTE_DEVICE: u32 = 16u32;
pub const FILE_REMOTE_DEVICE_VSMB: u32 = 524288u32;
pub const FILE_REMOVABLE_MEDIA: u32 = 1u32;
pub const FILE_SHARE_VALID_FLAGS: u32 = 7u32;
pub const FILE_SKIP_SET_USER_EVENT_ON_FAST_IO: u32 = 4u32;
pub const FILE_USE_FILE_POINTER_POSITION: u32 = 4294967294u32;
pub const FILE_VALID_EXTENDED_OPTION_FLAGS: u32 = 268435456u32;
pub const FILE_VIRTUAL_VOLUME: u32 = 64u32;
pub const FILE_WORD_ALIGNMENT: u32 = 1u32;
pub const FILE_WRITE_ONCE_MEDIA: u32 = 8u32;
pub const FILE_WRITE_TO_END_OF_FILE: u32 = 4294967295u32;
pub const FIRMWARE_ERROR_RECORD_REFERENCE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x81212a96_09ed_4996_9471_8d729c8e69ed);
pub const FLAG_OWNER_POINTER_IS_THREAD: u32 = 1u32;
pub const FLUSH_MULTIPLE_MAXIMUM: u32 = 32u32;
pub const FM_LOCK_BIT: u32 = 1u32;
pub const FM_LOCK_BIT_V: u32 = 0u32;
pub const FO_ALERTABLE_IO: u32 = 4u32;
pub const FO_BYPASS_IO_ENABLED: u32 = 8388608u32;
pub const FO_CACHE_SUPPORTED: u32 = 64u32;
pub const FO_CLEANUP_COMPLETE: u32 = 16384u32;
pub const FO_DELETE_ON_CLOSE: u32 = 65536u32;
pub const FO_DIRECT_DEVICE_OPEN: u32 = 2048u32;
pub const FO_DISALLOW_EXCLUSIVE: u32 = 33554432u32;
pub const FO_FILE_FAST_IO_READ: u32 = 524288u32;
pub const FO_FILE_MODIFIED: u32 = 4096u32;
pub const FO_FILE_OPEN: u32 = 1u32;
pub const FO_FILE_OPEN_CANCELLED: u32 = 2097152u32;
pub const FO_FILE_SIZE_CHANGED: u32 = 8192u32;
pub const FO_FLAGS_VALID_ONLY_DURING_CREATE: u32 = 33554432u32;
pub const FO_GENERATE_AUDIT_ON_CLOSE: u32 = 1024u32;
pub const FO_HANDLE_CREATED: u32 = 262144u32;
pub const FO_INDIRECT_WAIT_OBJECT: u32 = 268435456u32;
pub const FO_MAILSLOT: u32 = 512u32;
pub const FO_NAMED_PIPE: u32 = 128u32;
pub const FO_NO_INTERMEDIATE_BUFFERING: u32 = 8u32;
pub const FO_OPENED_CASE_SENSITIVE: u32 = 131072u32;
pub const FO_QUEUE_IRP_TO_THREAD: u32 = 1024u32;
pub const FO_RANDOM_ACCESS: u32 = 1048576u32;
pub const FO_REMOTE_ORIGIN: u32 = 16777216u32;
pub const FO_SECTION_MINSTORE_TREATMENT: u32 = 536870912u32;
pub const FO_SEQUENTIAL_ONLY: u32 = 32u32;
pub const FO_SKIP_COMPLETION_PORT: u32 = 33554432u32;
pub const FO_SKIP_SET_EVENT: u32 = 67108864u32;
pub const FO_SKIP_SET_FAST_IO: u32 = 134217728u32;
pub const FO_STREAM_FILE: u32 = 256u32;
pub const FO_SYNCHRONOUS_IO: u32 = 2u32;
pub const FO_TEMPORARY_FILE: u32 = 32768u32;
pub const FO_VOLUME_OPEN: u32 = 4194304u32;
pub const FO_WRITE_THROUGH: u32 = 16u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_16GB: u32 = 6u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_1GB: u32 = 2u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_1MB: u32 = 9u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_256MB: u32 = 0u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_2GB: u32 = 3u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_32GB: u32 = 7u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_4GB: u32 = 4u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_512MB: u32 = 1u32;
pub const FPB_MEM_HIGH_VECTOR_GRANULARITY_8GB: u32 = 5u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_16MB: u32 = 4u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_1MB: u32 = 0u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_2MB: u32 = 1u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_4MB: u32 = 2u32;
pub const FPB_MEM_LOW_VECTOR_GRANULARITY_8MB: u32 = 3u32;
pub const FPB_MEM_VECTOR_GRANULARITY_1B: u32 = 8u32;
pub const FPB_RID_VECTOR_GRANULARITY_256RIDS: u32 = 5u32;
pub const FPB_RID_VECTOR_GRANULARITY_64RIDS: u32 = 3u32;
pub const FPB_RID_VECTOR_GRANULARITY_8RIDS: u32 = 0u32;
pub const FPB_VECTOR_SELECT_MEM_HIGH: u32 = 2u32;
pub const FPB_VECTOR_SELECT_MEM_LOW: u32 = 1u32;
pub const FPB_VECTOR_SELECT_RID: u32 = 0u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_1KBITS: u32 = 2u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_256BITS: u32 = 0u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_2KBITS: u32 = 3u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_4KBITS: u32 = 4u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_512BITS: u32 = 1u32;
pub const FPB_VECTOR_SIZE_SUPPORTED_8KBITS: u32 = 5u32;
pub const FailControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(4i32);
pub const FaultInformationArm64: FAULT_INFORMATION_ARCH = FAULT_INFORMATION_ARCH(1i32);
pub const FaultInformationInvalid: FAULT_INFORMATION_ARCH = FAULT_INFORMATION_ARCH(0i32);
pub const FaultInformationX64: FAULT_INFORMATION_ARCH = FAULT_INFORMATION_ARCH(2i32);
pub const FloatingPointProcessor: CONFIGURATION_TYPE = CONFIGURATION_TYPE(2i32);
pub const FloppyDiskPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(26i32);
pub const FltIoNotifyRoutinesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(13i32);
pub const FreePage: KWAIT_REASON = KWAIT_REASON(1i32);
pub const FunctionLevelDeviceReset: DEVICE_RESET_TYPE = DEVICE_RESET_TYPE(0i32);
pub const GENERIC_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3e62a467_ab40_409a_a698_f362d464b38f);
pub const GENERIC_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe71254e8_c1b9_4940_ab76_909703a4320f);
pub const GENPROC_FLAGS_CORRECTED: u32 = 8u32;
pub const GENPROC_FLAGS_OVERFLOW: u32 = 4u32;
pub const GENPROC_FLAGS_PRECISEIP: u32 = 2u32;
pub const GENPROC_FLAGS_RESTARTABLE: u32 = 1u32;
pub const GENPROC_OP_DATAREAD: u32 = 1u32;
pub const GENPROC_OP_DATAWRITE: u32 = 2u32;
pub const GENPROC_OP_GENERIC: u32 = 0u32;
pub const GENPROC_OP_INSTRUCTIONEXE: u32 = 3u32;
pub const GENPROC_PROCERRTYPE_BUS: u32 = 4u32;
pub const GENPROC_PROCERRTYPE_CACHE: u32 = 1u32;
pub const GENPROC_PROCERRTYPE_MAE: u32 = 8u32;
pub const GENPROC_PROCERRTYPE_TLB: u32 = 2u32;
pub const GENPROC_PROCERRTYPE_UNKNOWN: u32 = 0u32;
pub const GENPROC_PROCISA_ARM32: u32 = 4u32;
pub const GENPROC_PROCISA_ARM64: u32 = 8u32;
pub const GENPROC_PROCISA_IPF: u32 = 1u32;
pub const GENPROC_PROCISA_X64: u32 = 2u32;
pub const GENPROC_PROCISA_X86: u32 = 0u32;
pub const GENPROC_PROCTYPE_ARM: u32 = 2u32;
pub const GENPROC_PROCTYPE_IPF: u32 = 1u32;
pub const GENPROC_PROCTYPE_XPF: u32 = 0u32;
pub const GUID_ECP_CREATE_USER_PROCESS: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe0e429ff_6ddc_4e65_aab6_45d05a038a08);
pub const GartHigh: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(5i32);
pub const GartLow: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(4i32);
pub const GenericEqual: RTL_GENERIC_COMPARE_RESULTS = RTL_GENERIC_COMPARE_RESULTS(2i32);
pub const GenericGreaterThan: RTL_GENERIC_COMPARE_RESULTS = RTL_GENERIC_COMPARE_RESULTS(1i32);
pub const GenericLessThan: RTL_GENERIC_COMPARE_RESULTS = RTL_GENERIC_COMPARE_RESULTS(0i32);
pub const GlobalLoggerHandleClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(4i32);
pub const GroupAffinityAllGroupZero: IRQ_GROUP_POLICY = IRQ_GROUP_POLICY(0i32);
pub const GroupAffinityDontCare: IRQ_GROUP_POLICY = IRQ_GROUP_POLICY(1i32);
pub const HAL_DISPATCH_VERSION: u32 = 5u32;
pub const HAL_DMA_ADAPTER_VERSION_1: u32 = 1u32;
pub const HAL_MASK_UNMASK_FLAGS_NONE: u32 = 0u32;
pub const HAL_MASK_UNMASK_FLAGS_SERVICING_COMPLETE: u32 = 2u32;
pub const HAL_MASK_UNMASK_FLAGS_SERVICING_DEFERRED: u32 = 1u32;
pub const HAL_MCA_RECORD: MCA_EXCEPTION_TYPE = MCA_EXCEPTION_TYPE(1i32);
pub const HAL_MCE_RECORD: MCA_EXCEPTION_TYPE = MCA_EXCEPTION_TYPE(0i32);
pub const HAL_PLATFORM_ACPI_TABLES_CACHED: i32 = 32i32;
pub const HAL_PLATFORM_DISABLE_PTCG: i32 = 4i32;
pub const HAL_PLATFORM_DISABLE_UC_MAIN_MEMORY: i32 = 8i32;
pub const HAL_PLATFORM_DISABLE_WRITE_COMBINING: i32 = 1i32;
pub const HAL_PLATFORM_ENABLE_WRITE_COMBINING_MMIO: i32 = 16i32;
pub const HASH_STRING_ALGORITHM_DEFAULT: u32 = 0u32;
pub const HASH_STRING_ALGORITHM_INVALID: u32 = 4294967295u32;
pub const HASH_STRING_ALGORITHM_X65599: u32 = 1u32;
pub const HIGH_LEVEL: u32 = 31u32;
pub const HIGH_PRIORITY: u32 = 31u32;
pub const HalAcpiAuditInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(26i32);
pub const HalCallbackInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(5i32);
pub const HalChannelTopologyInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(31i32);
pub const HalCmcLog: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(7i32);
pub const HalCmcLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(13i32);
pub const HalCmcRegisterDriver: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(4i32);
pub const HalCpeLog: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(8i32);
pub const HalCpeLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(14i32);
pub const HalCpeRegisterDriver: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(5i32);
pub const HalDisplayBiosInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(9i32);
pub const HalDisplayEmulatedBios: HAL_DISPLAY_BIOS_INFORMATION = HAL_DISPLAY_BIOS_INFORMATION(1i32);
pub const HalDisplayInt10Bios: HAL_DISPLAY_BIOS_INFORMATION = HAL_DISPLAY_BIOS_INFORMATION(0i32);
pub const HalDisplayNoBios: HAL_DISPLAY_BIOS_INFORMATION = HAL_DISPLAY_BIOS_INFORMATION(2i32);
pub const HalDmaCrashDumpRegisterSet1: HAL_DMA_CRASH_DUMP_REGISTER_TYPE = HAL_DMA_CRASH_DUMP_REGISTER_TYPE(0i32);
pub const HalDmaCrashDumpRegisterSet2: HAL_DMA_CRASH_DUMP_REGISTER_TYPE = HAL_DMA_CRASH_DUMP_REGISTER_TYPE(1i32);
pub const HalDmaCrashDumpRegisterSetMax: HAL_DMA_CRASH_DUMP_REGISTER_TYPE = HAL_DMA_CRASH_DUMP_REGISTER_TYPE(2i32);
pub const HalDmaRemappingInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(47i32);
pub const HalEnlightenment: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(11i32);
pub const HalErrorInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(12i32);
pub const HalExternalCacheInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(32i32);
pub const HalFrameBufferCachingInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(8i32);
pub const HalFrequencyInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(22i32);
pub const HalFwBootPerformanceInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(34i32);
pub const HalFwS3PerformanceInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(35i32);
pub const HalGenerateCmcInterrupt: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(9i32);
pub const HalGetChannelPowerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(36i32);
pub const HalHardwareWatchdogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(46i32);
pub const HalHeterogeneousMemoryAttributesInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(49i32);
pub const HalHypervisorInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(24i32);
pub const HalI386ExceptionChainTerminatorInformation: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(15i32);
pub const HalInformationClassUnused1: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(2i32);
pub const HalInitLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(21i32);
pub const HalInstalledBusInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(0i32);
pub const HalInterruptControllerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(39i32);
pub const HalIrtInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(27i32);
pub const HalKernelErrorHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(3i32);
pub const HalMapRegisterInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(6i32);
pub const HalMcaLog: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(6i32);
pub const HalMcaLogInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(7i32);
pub const HalMcaRegisterDriver: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(2i32);
pub const HalNumaRangeTableInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(30i32);
pub const HalNumaTopologyInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(11i32);
pub const HalParkingPageInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(29i32);
pub const HalPartitionIpiInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(18i32);
pub const HalPlatformInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(19i32);
pub const HalPlatformTimerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(25i32);
pub const HalPowerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(3i32);
pub const HalProcessorBrandString: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(23i32);
pub const HalProcessorFeatureInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(10i32);
pub const HalProcessorSpeedInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(4i32);
pub const HalProfileDpgoSourceInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(12i32);
pub const HalProfileSourceAdd: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(20i32);
pub const HalProfileSourceInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(1i32);
pub const HalProfileSourceInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(1i32);
pub const HalProfileSourceInterval: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(0i32);
pub const HalProfileSourceRemove: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(21i32);
pub const HalProfileSourceTimerHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(10i32);
pub const HalPsciInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(38i32);
pub const HalQueryAMLIIllegalIOPortAddresses: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(16i32);
pub const HalQueryAcpiWakeAlarmSystemPowerStateInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(43i32);
pub const HalQueryArmErrataInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(41i32);
pub const HalQueryDebuggerInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(33i32);
pub const HalQueryHyperlaunchEntrypoint: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(45i32);
pub const HalQueryIommuReservedRegionInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(40i32);
pub const HalQueryMaxHotPlugMemoryAddress: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(17i32);
pub const HalQueryMcaInterface: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(15i32);
pub const HalQueryPerDeviceMsiLimitInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(50i32);
pub const HalQueryProcessorEfficiencyInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(42i32);
pub const HalQueryProfileCorruptionStatus: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(51i32);
pub const HalQueryProfileCounterOwnership: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(52i32);
pub const HalQueryProfileNumberOfCounters: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(44i32);
pub const HalQueryProfileSourceList: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(20i32);
pub const HalQueryStateElementInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(37i32);
pub const HalQueryUnused0001: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(48i32);
pub const HalRegisterSecondaryInterruptInterface: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(13i32);
pub const HalSecondaryInterruptInformation: HAL_QUERY_INFORMATION_CLASS = HAL_QUERY_INFORMATION_CLASS(28i32);
pub const HalSetChannelPowerInformation: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(14i32);
pub const HalSetClockTimerMinimumInterval: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(23i32);
pub const HalSetHvciEnabled: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(18i32);
pub const HalSetProcessorTraceInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(19i32);
pub const HalSetPsciSuspendMode: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(17i32);
pub const HalSetResetParkDisposition: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(16i32);
pub const HalSetSwInterruptHandler: HAL_SET_INFORMATION_CLASS = HAL_SET_INFORMATION_CLASS(22i32);
pub const HighImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(2i32);
pub const HighPagePriority: MM_PAGE_PRIORITY = MM_PAGE_PRIORITY(32i32);
pub const HighPoolPriority: EX_POOL_PRIORITY = EX_POOL_PRIORITY(32i32);
pub const HighPoolPrioritySpecialPoolOverrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(40i32);
pub const HighPoolPrioritySpecialPoolUnderrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(41i32);
pub const HotSpareControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(7i32);
pub const HyperCriticalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(2i32);
pub const IMAGE_ADDRESSING_MODE_32BIT: u32 = 3u32;
pub const INITIAL_PRIVILEGE_COUNT: u32 = 3u32;
pub const INIT_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcc5263e8_9308_454a_89d0_340bd39bc98e);
pub const INJECT_ERRTYPE_MEMORY_CORRECTABLE: u32 = 8u32;
pub const INJECT_ERRTYPE_MEMORY_UNCORRECTABLEFATAL: u32 = 32u32;
pub const INJECT_ERRTYPE_MEMORY_UNCORRECTABLENONFATAL: u32 = 16u32;
pub const INJECT_ERRTYPE_PCIEXPRESS_CORRECTABLE: u32 = 64u32;
pub const INJECT_ERRTYPE_PCIEXPRESS_UNCORRECTABLEFATAL: u32 = 256u32;
pub const INJECT_ERRTYPE_PCIEXPRESS_UNCORRECTABLENONFATAL: u32 = 128u32;
pub const INJECT_ERRTYPE_PLATFORM_CORRECTABLE: u32 = 512u32;
pub const INJECT_ERRTYPE_PLATFORM_UNCORRECTABLEFATAL: u32 = 2048u32;
pub const INJECT_ERRTYPE_PLATFORM_UNCORRECTABLENONFATAL: u32 = 1024u32;
pub const INJECT_ERRTYPE_PROCESSOR_CORRECTABLE: u32 = 1u32;
pub const INJECT_ERRTYPE_PROCESSOR_UNCORRECTABLEFATAL: u32 = 4u32;
pub const INJECT_ERRTYPE_PROCESSOR_UNCORRECTABLENONFATAL: u32 = 2u32;
pub const IOCTL_CANCEL_DEVICE_WAKE: u32 = 2719752u32;
pub const IOCTL_QUERY_DEVICE_POWER_STATE: u32 = 2703360u32;
pub const IOCTL_SET_DEVICE_WAKE: u32 = 2719748u32;
pub const IOMMU_ACCESS_NONE: u32 = 0u32;
pub const IOMMU_ACCESS_READ: u32 = 1u32;
pub const IOMMU_ACCESS_WRITE: u32 = 2u32;
pub const IO_ATTACH_DEVICE: u32 = 1024u32;
pub const IO_ATTRIBUTION_INFO_V1: u32 = 1u32;
pub const IO_CHECK_CREATE_PARAMETERS: u32 = 512u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_CHECK_DELETE: u32 = 16u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_CHECK_READ: u32 = 4u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_CHECK_WRITE: u32 = 8u32;
pub const IO_CHECK_SHARE_ACCESS_DONT_UPDATE_FILE_OBJECT: u32 = 2u32;
pub const IO_CHECK_SHARE_ACCESS_FORCE_CHECK: u32 = 32u32;
pub const IO_CHECK_SHARE_ACCESS_FORCE_USING_SCB: u32 = 64u32;
pub const IO_CHECK_SHARE_ACCESS_UPDATE_SHARE_ACCESS: u32 = 1u32;
pub const IO_FORCE_ACCESS_CHECK: u32 = 1u32;
pub const IO_IGNORE_SHARE_ACCESS_CHECK: u32 = 2048u32;
pub const IO_KEYBOARD_INCREMENT: u32 = 6u32;
pub const IO_MOUSE_INCREMENT: u32 = 6u32;
pub const IO_NO_PARAMETER_CHECKING: u32 = 256u32;
pub const IO_PARALLEL_INCREMENT: u32 = 1u32;
pub const IO_REMOUNT: u32 = 1u32;
pub const IO_REPARSE: u32 = 0u32;
pub const IO_REPARSE_GLOBAL: u32 = 2u32;
pub const IO_RESOURCE_ALTERNATIVE: u32 = 8u32;
pub const IO_RESOURCE_DEFAULT: u32 = 2u32;
pub const IO_RESOURCE_PREFERRED: u32 = 1u32;
pub const IO_SERIAL_INCREMENT: u32 = 2u32;
pub const IO_SESSION_MAX_PAYLOAD_SIZE: i32 = 256i32;
pub const IO_SESSION_STATE_ALL_EVENTS: u32 = 4294967295u32;
pub const IO_SESSION_STATE_CONNECT_EVENT: u32 = 4u32;
pub const IO_SESSION_STATE_CREATION_EVENT: u32 = 1u32;
pub const IO_SESSION_STATE_DISCONNECT_EVENT: u32 = 8u32;
pub const IO_SESSION_STATE_LOGOFF_EVENT: u32 = 32u32;
pub const IO_SESSION_STATE_LOGON_EVENT: u32 = 16u32;
pub const IO_SESSION_STATE_TERMINATION_EVENT: u32 = 2u32;
pub const IO_SESSION_STATE_VALID_EVENT_MASK: u32 = 63u32;
pub const IO_SET_IRP_IO_ATTRIBUTION_FLAGS_MASK: u32 = 3u32;
pub const IO_SET_IRP_IO_ATTRIBUTION_FROM_PROCESS: u32 = 2u32;
pub const IO_SET_IRP_IO_ATTRIBUTION_FROM_THREAD: u32 = 1u32;
pub const IO_SHARE_ACCESS_NON_PRIMARY_STREAM: u32 = 128u32;
pub const IO_SHARE_ACCESS_NO_WRITE_PERMISSION: u32 = 2147483648u32;
pub const IO_SOUND_INCREMENT: u32 = 8u32;
pub const IO_TYPE_ADAPTER: u32 = 1u32;
pub const IO_TYPE_CONTROLLER: u32 = 2u32;
pub const IO_TYPE_CSQ: u32 = 2u32;
pub const IO_TYPE_CSQ_EX: u32 = 3u32;
pub const IO_TYPE_CSQ_IRP_CONTEXT: u32 = 1u32;
pub const IO_TYPE_DEVICE: u32 = 3u32;
pub const IO_TYPE_DEVICE_OBJECT_EXTENSION: u32 = 13u32;
pub const IO_TYPE_DRIVER: u32 = 4u32;
pub const IO_TYPE_ERROR_LOG: u32 = 11u32;
pub const IO_TYPE_ERROR_MESSAGE: u32 = 12u32;
pub const IO_TYPE_FILE: u32 = 5u32;
pub const IO_TYPE_IORING: u32 = 14u32;
pub const IO_TYPE_IRP: u32 = 6u32;
pub const IO_TYPE_MASTER_ADAPTER: u32 = 7u32;
pub const IO_TYPE_OPEN_PACKET: u32 = 8u32;
pub const IO_TYPE_TIMER: u32 = 9u32;
pub const IO_TYPE_VPB: u32 = 10u32;
pub const IO_VIDEO_INCREMENT: u32 = 1u32;
pub const IPF_SAL_RECORD_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6f3380d1_6eb0_497f_a578_4d4c65a71617);
pub const IPI_LEVEL: u32 = 29u32;
pub const IPMI_MSR_DUMP_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1c15b445_9b06_4667_ac25_33c056b88803);
pub const IRP_ALLOCATED_FIXED_SIZE: u32 = 4u32;
pub const IRP_ALLOCATED_MUST_SUCCEED: u32 = 2u32;
pub const IRP_ASSOCIATED_IRP: u32 = 8u32;
pub const IRP_BUFFERED_IO: u32 = 16u32;
pub const IRP_CLOSE_OPERATION: u32 = 1024u32;
pub const IRP_CREATE_OPERATION: u32 = 128u32;
pub const IRP_DEALLOCATE_BUFFER: u32 = 32u32;
pub const IRP_DEFER_IO_COMPLETION: u32 = 2048u32;
pub const IRP_HOLD_DEVICE_QUEUE: u32 = 8192u32;
pub const IRP_INPUT_OPERATION: u32 = 64u32;
pub const IRP_LOOKASIDE_ALLOCATION: u32 = 8u32;
pub const IRP_MJ_CLEANUP: u32 = 18u32;
pub const IRP_MJ_CLOSE: u32 = 2u32;
pub const IRP_MJ_CREATE: u32 = 0u32;
pub const IRP_MJ_CREATE_MAILSLOT: u32 = 19u32;
pub const IRP_MJ_CREATE_NAMED_PIPE: u32 = 1u32;
pub const IRP_MJ_DEVICE_CHANGE: u32 = 24u32;
pub const IRP_MJ_DEVICE_CONTROL: u32 = 14u32;
pub const IRP_MJ_DIRECTORY_CONTROL: u32 = 12u32;
pub const IRP_MJ_FILE_SYSTEM_CONTROL: u32 = 13u32;
pub const IRP_MJ_FLUSH_BUFFERS: u32 = 9u32;
pub const IRP_MJ_INTERNAL_DEVICE_CONTROL: u32 = 15u32;
pub const IRP_MJ_LOCK_CONTROL: u32 = 17u32;
pub const IRP_MJ_MAXIMUM_FUNCTION: u32 = 27u32;
pub const IRP_MJ_PNP: u32 = 27u32;
pub const IRP_MJ_PNP_POWER: u32 = 27u32;
pub const IRP_MJ_POWER: u32 = 22u32;
pub const IRP_MJ_QUERY_EA: u32 = 7u32;
pub const IRP_MJ_QUERY_INFORMATION: u32 = 5u32;
pub const IRP_MJ_QUERY_QUOTA: u32 = 25u32;
pub const IRP_MJ_QUERY_SECURITY: u32 = 20u32;
pub const IRP_MJ_QUERY_VOLUME_INFORMATION: u32 = 10u32;
pub const IRP_MJ_READ: u32 = 3u32;
pub const IRP_MJ_SCSI: u32 = 15u32;
pub const IRP_MJ_SET_EA: u32 = 8u32;
pub const IRP_MJ_SET_INFORMATION: u32 = 6u32;
pub const IRP_MJ_SET_QUOTA: u32 = 26u32;
pub const IRP_MJ_SET_SECURITY: u32 = 21u32;
pub const IRP_MJ_SET_VOLUME_INFORMATION: u32 = 11u32;
pub const IRP_MJ_SHUTDOWN: u32 = 16u32;
pub const IRP_MJ_SYSTEM_CONTROL: u32 = 23u32;
pub const IRP_MJ_WRITE: u32 = 4u32;
pub const IRP_MN_CANCEL_REMOVE_DEVICE: u32 = 3u32;
pub const IRP_MN_CANCEL_STOP_DEVICE: u32 = 6u32;
pub const IRP_MN_CHANGE_SINGLE_INSTANCE: u32 = 2u32;
pub const IRP_MN_CHANGE_SINGLE_ITEM: u32 = 3u32;
pub const IRP_MN_COMPLETE: u32 = 4u32;
pub const IRP_MN_COMPRESSED: u32 = 8u32;
pub const IRP_MN_DEVICE_ENUMERATED: u32 = 25u32;
pub const IRP_MN_DEVICE_USAGE_NOTIFICATION: u32 = 22u32;
pub const IRP_MN_DISABLE_COLLECTION: u32 = 7u32;
pub const IRP_MN_DISABLE_EVENTS: u32 = 5u32;
pub const IRP_MN_DPC: u32 = 1u32;
pub const IRP_MN_EJECT: u32 = 17u32;
pub const IRP_MN_ENABLE_COLLECTION: u32 = 6u32;
pub const IRP_MN_ENABLE_EVENTS: u32 = 4u32;
pub const IRP_MN_EXECUTE_METHOD: u32 = 9u32;
pub const IRP_MN_FILTER_RESOURCE_REQUIREMENTS: u32 = 13u32;
pub const IRP_MN_FLUSH_AND_PURGE: u32 = 1u32;
pub const IRP_MN_FLUSH_DATA_ONLY: u32 = 2u32;
pub const IRP_MN_FLUSH_DATA_SYNC_ONLY: u32 = 4u32;
pub const IRP_MN_FLUSH_NO_SYNC: u32 = 3u32;
pub const IRP_MN_KERNEL_CALL: u32 = 4u32;
pub const IRP_MN_LOAD_FILE_SYSTEM: u32 = 3u32;
pub const IRP_MN_LOCK: u32 = 1u32;
pub const IRP_MN_MDL: u32 = 2u32;
pub const IRP_MN_MOUNT_VOLUME: u32 = 1u32;
pub const IRP_MN_NORMAL: u32 = 0u32;
pub const IRP_MN_NOTIFY_CHANGE_DIRECTORY: u32 = 2u32;
pub const IRP_MN_NOTIFY_CHANGE_DIRECTORY_EX: u32 = 3u32;
pub const IRP_MN_POWER_SEQUENCE: u32 = 1u32;
pub const IRP_MN_QUERY_ALL_DATA: u32 = 0u32;
pub const IRP_MN_QUERY_BUS_INFORMATION: u32 = 21u32;
pub const IRP_MN_QUERY_CAPABILITIES: u32 = 9u32;
pub const IRP_MN_QUERY_DEVICE_RELATIONS: u32 = 7u32;
pub const IRP_MN_QUERY_DEVICE_TEXT: u32 = 12u32;
pub const IRP_MN_QUERY_DIRECTORY: u32 = 1u32;
pub const IRP_MN_QUERY_ID: u32 = 19u32;
pub const IRP_MN_QUERY_INTERFACE: u32 = 8u32;
pub const IRP_MN_QUERY_LEGACY_BUS_INFORMATION: u32 = 24u32;
pub const IRP_MN_QUERY_PNP_DEVICE_STATE: u32 = 20u32;
pub const IRP_MN_QUERY_POWER: u32 = 3u32;
pub const IRP_MN_QUERY_REMOVE_DEVICE: u32 = 1u32;
pub const IRP_MN_QUERY_RESOURCES: u32 = 10u32;
pub const IRP_MN_QUERY_RESOURCE_REQUIREMENTS: u32 = 11u32;
pub const IRP_MN_QUERY_SINGLE_INSTANCE: u32 = 1u32;
pub const IRP_MN_QUERY_STOP_DEVICE: u32 = 5u32;
pub const IRP_MN_READ_CONFIG: u32 = 15u32;
pub const IRP_MN_REGINFO: u32 = 8u32;
pub const IRP_MN_REGINFO_EX: u32 = 11u32;
pub const IRP_MN_REMOVE_DEVICE: u32 = 2u32;
pub const IRP_MN_SCSI_CLASS: u32 = 1u32;
pub const IRP_MN_SET_LOCK: u32 = 18u32;
pub const IRP_MN_SET_POWER: u32 = 2u32;
pub const IRP_MN_START_DEVICE: u32 = 0u32;
pub const IRP_MN_STOP_DEVICE: u32 = 4u32;
pub const IRP_MN_SURPRISE_REMOVAL: u32 = 23u32;
pub const IRP_MN_TRACK_LINK: u32 = 4u32;
pub const IRP_MN_UNLOCK_ALL: u32 = 3u32;
pub const IRP_MN_UNLOCK_ALL_BY_KEY: u32 = 4u32;
pub const IRP_MN_UNLOCK_SINGLE: u32 = 2u32;
pub const IRP_MN_USER_FS_REQUEST: u32 = 0u32;
pub const IRP_MN_VERIFY_VOLUME: u32 = 2u32;
pub const IRP_MN_WAIT_WAKE: u32 = 0u32;
pub const IRP_MN_WRITE_CONFIG: u32 = 16u32;
pub const IRP_MOUNT_COMPLETION: u32 = 2u32;
pub const IRP_NOCACHE: u32 = 1u32;
pub const IRP_OB_QUERY_NAME: u32 = 4096u32;
pub const IRP_PAGING_IO: u32 = 2u32;
pub const IRP_QUOTA_CHARGED: u32 = 1u32;
pub const IRP_READ_OPERATION: u32 = 256u32;
pub const IRP_SYNCHRONOUS_API: u32 = 4u32;
pub const IRP_SYNCHRONOUS_PAGING_IO: u32 = 64u32;
pub const IRP_UM_DRIVER_INITIATED_IO: u32 = 4194304u32;
pub const IRP_WRITE_OPERATION: u32 = 512u32;
pub const InACriticalArrayControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(8i32);
pub const InAFailedArrayControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(9i32);
pub const IndicatorBlink: PCI_EXPRESS_INDICATOR_STATE = PCI_EXPRESS_INDICATOR_STATE(2i32);
pub const IndicatorOff: PCI_EXPRESS_INDICATOR_STATE = PCI_EXPRESS_INDICATOR_STATE(3i32);
pub const IndicatorOn: PCI_EXPRESS_INDICATOR_STATE = PCI_EXPRESS_INDICATOR_STATE(1i32);
pub const InitiateReset: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(1i32);
pub const InstallStateFailedInstall: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(2i32);
pub const InstallStateFinishInstall: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(3i32);
pub const InstallStateInstalled: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(0i32);
pub const InstallStateNeedsReinstall: DEVICE_INSTALL_STATE = DEVICE_INSTALL_STATE(1i32);
pub const IntelCacheData: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(1i32);
pub const IntelCacheInstruction: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(2i32);
pub const IntelCacheNull: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(0i32);
pub const IntelCacheRam: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(4i32);
pub const IntelCacheTrace: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(5i32);
pub const IntelCacheUnified: INTEL_CACHE_TYPE = INTEL_CACHE_TYPE(3i32);
pub const InterfaceTypeUndefined: INTERFACE_TYPE = INTERFACE_TYPE(-1i32);
pub const Internal: INTERFACE_TYPE = INTERFACE_TYPE(0i32);
pub const InternalPowerBus: INTERFACE_TYPE = INTERFACE_TYPE(13i32);
pub const InterruptActiveBoth: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(3i32);
pub const InterruptActiveBothTriggerHigh: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(4i32);
pub const InterruptActiveBothTriggerLow: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(3i32);
pub const InterruptActiveHigh: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(1i32);
pub const InterruptActiveLow: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(2i32);
pub const InterruptFallingEdge: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(2i32);
pub const InterruptPolarityUnknown: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(0i32);
pub const InterruptRisingEdge: KINTERRUPT_POLARITY = KINTERRUPT_POLARITY(1i32);
pub const InvalidDeviceTypeControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(10i32);
pub const IoMaxContainerInformationClass: IO_CONTAINER_INFORMATION_CLASS = IO_CONTAINER_INFORMATION_CLASS(1i32);
pub const IoMaxContainerNotificationClass: IO_CONTAINER_NOTIFICATION_CLASS = IO_CONTAINER_NOTIFICATION_CLASS(1i32);
pub const IoModifyAccess: LOCK_OPERATION = LOCK_OPERATION(2i32);
pub const IoPagingPriorityHigh: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(2i32);
pub const IoPagingPriorityInvalid: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(0i32);
pub const IoPagingPriorityNormal: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(1i32);
pub const IoPagingPriorityReserved1: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(3i32);
pub const IoPagingPriorityReserved2: IO_PAGING_PRIORITY = IO_PAGING_PRIORITY(4i32);
pub const IoQueryDeviceComponentInformation: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(2i32);
pub const IoQueryDeviceConfigurationData: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(1i32);
pub const IoQueryDeviceIdentifier: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(0i32);
pub const IoQueryDeviceMaxData: IO_QUERY_DEVICE_DATA_FORMAT = IO_QUERY_DEVICE_DATA_FORMAT(3i32);
pub const IoReadAccess: LOCK_OPERATION = LOCK_OPERATION(0i32);
pub const IoSessionEventConnected: IO_SESSION_EVENT = IO_SESSION_EVENT(3i32);
pub const IoSessionEventCreated: IO_SESSION_EVENT = IO_SESSION_EVENT(1i32);
pub const IoSessionEventDisconnected: IO_SESSION_EVENT = IO_SESSION_EVENT(4i32);
pub const IoSessionEventIgnore: IO_SESSION_EVENT = IO_SESSION_EVENT(0i32);
pub const IoSessionEventLogoff: IO_SESSION_EVENT = IO_SESSION_EVENT(6i32);
pub const IoSessionEventLogon: IO_SESSION_EVENT = IO_SESSION_EVENT(5i32);
pub const IoSessionEventMax: IO_SESSION_EVENT = IO_SESSION_EVENT(7i32);
pub const IoSessionEventTerminated: IO_SESSION_EVENT = IO_SESSION_EVENT(2i32);
pub const IoSessionStateConnected: IO_SESSION_STATE = IO_SESSION_STATE(3i32);
pub const IoSessionStateCreated: IO_SESSION_STATE = IO_SESSION_STATE(1i32);
pub const IoSessionStateDisconnected: IO_SESSION_STATE = IO_SESSION_STATE(4i32);
pub const IoSessionStateDisconnectedLoggedOn: IO_SESSION_STATE = IO_SESSION_STATE(5i32);
pub const IoSessionStateInformation: IO_CONTAINER_INFORMATION_CLASS = IO_CONTAINER_INFORMATION_CLASS(0i32);
pub const IoSessionStateInitialized: IO_SESSION_STATE = IO_SESSION_STATE(2i32);
pub const IoSessionStateLoggedOff: IO_SESSION_STATE = IO_SESSION_STATE(7i32);
pub const IoSessionStateLoggedOn: IO_SESSION_STATE = IO_SESSION_STATE(6i32);
pub const IoSessionStateMax: IO_SESSION_STATE = IO_SESSION_STATE(9i32);
pub const IoSessionStateNotification: IO_CONTAINER_NOTIFICATION_CLASS = IO_CONTAINER_NOTIFICATION_CLASS(0i32);
pub const IoSessionStateTerminated: IO_SESSION_STATE = IO_SESSION_STATE(8i32);
pub const IoWriteAccess: LOCK_OPERATION = LOCK_OPERATION(1i32);
pub const IommuDeviceCreationConfigTypeAcpi: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(1i32);
pub const IommuDeviceCreationConfigTypeDeviceId: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(2i32);
pub const IommuDeviceCreationConfigTypeMax: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(3i32);
pub const IommuDeviceCreationConfigTypeNone: IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE = IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(0i32);
pub const IommuDmaLogicalAllocatorBuddy: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE = IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(1i32);
pub const IommuDmaLogicalAllocatorMax: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE = IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(2i32);
pub const IommuDmaLogicalAllocatorNone: IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE = IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(0i32);
pub const IrqPolicyAllCloseProcessors: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(1i32);
pub const IrqPolicyAllProcessorsInMachine: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(3i32);
pub const IrqPolicyAllProcessorsInMachineWhenSteered: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(6i32);
pub const IrqPolicyMachineDefault: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(0i32);
pub const IrqPolicyOneCloseProcessor: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(2i32);
pub const IrqPolicySpecifiedProcessors: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(4i32);
pub const IrqPolicySpreadMessagesAcrossAllProcessors: IRQ_DEVICE_POLICY = IRQ_DEVICE_POLICY(5i32);
pub const IrqPriorityHigh: IRQ_PRIORITY = IRQ_PRIORITY(3i32);
pub const IrqPriorityLow: IRQ_PRIORITY = IRQ_PRIORITY(1i32);
pub const IrqPriorityNormal: IRQ_PRIORITY = IRQ_PRIORITY(2i32);
pub const IrqPriorityUndefined: IRQ_PRIORITY = IRQ_PRIORITY(0i32);
pub const Isa: INTERFACE_TYPE = INTERFACE_TYPE(1i32);
pub const IsochCommand: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(6i32);
pub const IsochStatus: EXTENDED_AGP_REGISTER = EXTENDED_AGP_REGISTER(0i32);
pub const KADDRESS_BASE: u32 = 0u32;
pub const KB_ADD_PAGES_FLAG_ADDITIONAL_RANGES_EXIST: u32 = 2147483648u32;
pub const KB_ADD_PAGES_FLAG_PHYSICAL_ADDRESS: u32 = 2u32;
pub const KB_ADD_PAGES_FLAG_VIRTUAL_ADDRESS: u32 = 1u32;
pub const KB_REMOVE_PAGES_FLAG_ADDITIONAL_RANGES_EXIST: u32 = 2147483648u32;
pub const KB_REMOVE_PAGES_FLAG_PHYSICAL_ADDRESS: u32 = 2u32;
pub const KB_REMOVE_PAGES_FLAG_VIRTUAL_ADDRESS: u32 = 1u32;
pub const KB_SECONDARY_DATA_FLAG_ADDITIONAL_DATA: u32 = 1u32;
pub const KB_SECONDARY_DATA_FLAG_NO_DEVICE_ACCESS: u32 = 2u32;
pub const KB_TRIAGE_DUMP_DATA_FLAG_BUGCHECK_ACTIVE: u32 = 1u32;
pub const KD_OPTION_SET_BLOCK_ENABLE: KD_OPTION = KD_OPTION(0i32);
pub const KENCODED_TIMER_PROCESSOR: u32 = 1u32;
pub const KERNEL_LARGE_STACK_COMMIT: u32 = 12288u32;
pub const KERNEL_LARGE_STACK_SIZE: u32 = 61440u32;
pub const KERNEL_MCA_EXCEPTION_STACK_SIZE: u32 = 8192u32;
pub const KERNEL_SOFT_RESTART_NOTIFICATION_VERSION: u32 = 1u32;
pub const KERNEL_STACK_SIZE: u32 = 12288u32;
pub const KE_MAX_TRIAGE_DUMP_DATA_MEMORY_SIZE: u32 = 33554432u32;
pub const KE_PROCESSOR_CHANGE_ADD_EXISTING: u32 = 1u32;
pub const KI_USER_SHARED_DATA: u32 = 4292804608u32;
pub const KUMS_UCH_VOLATILE_BIT: u32 = 0u32;
pub const KbCallbackAddPages: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(4i32);
pub const KbCallbackDumpIo: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(3i32);
pub const KbCallbackInvalid: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(0i32);
pub const KbCallbackRemovePages: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(6i32);
pub const KbCallbackReserved1: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(1i32);
pub const KbCallbackReserved2: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(8i32);
pub const KbCallbackSecondaryDumpData: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(2i32);
pub const KbCallbackSecondaryMultiPartDumpData: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(5i32);
pub const KbCallbackTriageDumpData: KBUGCHECK_CALLBACK_REASON = KBUGCHECK_CALLBACK_REASON(7i32);
pub const KbDumpIoBody: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(2i32);
pub const KbDumpIoComplete: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(4i32);
pub const KbDumpIoHeader: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(1i32);
pub const KbDumpIoInvalid: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(0i32);
pub const KbDumpIoSecondaryData: KBUGCHECK_DUMP_IO_TYPE = KBUGCHECK_DUMP_IO_TYPE(3i32);
pub const KdConfigureDeviceAndContinue: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(0i32);
pub const KdConfigureDeviceAndStop: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(2i32);
pub const KdNameSpaceACPI: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(1i32);
pub const KdNameSpaceAny: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(2i32);
pub const KdNameSpaceMax: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(4i32);
pub const KdNameSpaceNone: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(3i32);
pub const KdNameSpacePCI: KD_NAMESPACE_ENUM = KD_NAMESPACE_ENUM(0i32);
pub const KdSkipDeviceAndContinue: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(1i32);
pub const KdSkipDeviceAndStop: KD_CALLBACK_ACTION = KD_CALLBACK_ACTION(3i32);
pub const KeProcessorAddCompleteNotify: KE_PROCESSOR_CHANGE_NOTIFY_STATE = KE_PROCESSOR_CHANGE_NOTIFY_STATE(1i32);
pub const KeProcessorAddFailureNotify: KE_PROCESSOR_CHANGE_NOTIFY_STATE = KE_PROCESSOR_CHANGE_NOTIFY_STATE(2i32);
pub const KeProcessorAddStartNotify: KE_PROCESSOR_CHANGE_NOTIFY_STATE = KE_PROCESSOR_CHANGE_NOTIFY_STATE(0i32);
pub const KeepObject: IO_ALLOCATION_ACTION = IO_ALLOCATION_ACTION(1i32);
pub const KernelMode: MODE = MODE(0i32);
pub const KeyBasicInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(0i32);
pub const KeyCachedInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(4i32);
pub const KeyFlagsInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(5i32);
pub const KeyFullInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(2i32);
pub const KeyHandleTagsInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(7i32);
pub const KeyLayerInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(9i32);
pub const KeyNameInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(3i32);
pub const KeyNodeInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(1i32);
pub const KeyTrustInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(8i32);
pub const KeyValueBasicInformation: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(0i32);
pub const KeyValueFullInformation: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(1i32);
pub const KeyValueFullInformationAlign64: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(3i32);
pub const KeyValueLayerInformation: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(5i32);
pub const KeyValuePartialInformation: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(2i32);
pub const KeyValuePartialInformationAlign64: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(4i32);
pub const KeyVirtualizationInformation: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(6i32);
pub const KeyboardController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(22i32);
pub const KeyboardPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(32i32);
pub const L0sAndL1EntryDisabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(0i32);
pub const L0sAndL1EntryEnabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(3i32);
pub const L0sAndL1EntrySupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(3i32);
pub const L0sEntryEnabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(1i32);
pub const L0sEntrySupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(1i32);
pub const L0s_128ns_256ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(2i32);
pub const L0s_1us_2us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(5i32);
pub const L0s_256ns_512ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(3i32);
pub const L0s_2us_4us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(6i32);
pub const L0s_512ns_1us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(4i32);
pub const L0s_64ns_128ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(1i32);
pub const L0s_Above4us: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(7i32);
pub const L0s_Below64ns: PCI_EXPRESS_L0s_EXIT_LATENCY = PCI_EXPRESS_L0s_EXIT_LATENCY(0i32);
pub const L1EntryEnabled: PCI_EXPRESS_ASPM_CONTROL = PCI_EXPRESS_ASPM_CONTROL(2i32);
pub const L1EntrySupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(2i32);
pub const L1_16us_32us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(5i32);
pub const L1_1us_2us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(1i32);
pub const L1_2us_4us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(2i32);
pub const L1_32us_64us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(6i32);
pub const L1_4us_8us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(3i32);
pub const L1_8us_16us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(4i32);
pub const L1_Above64us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(7i32);
pub const L1_Below1us: PCI_EXPRESS_L1_EXIT_LATENCY = PCI_EXPRESS_L1_EXIT_LATENCY(0i32);
pub const LOCK_QUEUE_HALTED: u32 = 4u32;
pub const LOCK_QUEUE_HALTED_BIT: u32 = 2u32;
pub const LOCK_QUEUE_OWNER: u32 = 2u32;
pub const LOCK_QUEUE_OWNER_BIT: u32 = 1u32;
pub const LOCK_QUEUE_WAIT: u32 = 1u32;
pub const LOCK_QUEUE_WAIT_BIT: u32 = 0u32;
pub const LONG_2ND_MOST_SIGNIFICANT_BIT: u32 = 2u32;
pub const LONG_3RD_MOST_SIGNIFICANT_BIT: u32 = 1u32;
pub const LONG_LEAST_SIGNIFICANT_BIT: u32 = 0u32;
pub const LONG_MOST_SIGNIFICANT_BIT: u32 = 3u32;
pub const LOWBYTE_MASK: u32 = 255u32;
pub const LOW_LEVEL: u32 = 0u32;
pub const LOW_PRIORITY: u32 = 0u32;
pub const LOW_REALTIME_PRIORITY: u32 = 16u32;
pub const LastDStateTransitionD3cold: D3COLD_LAST_TRANSITION_STATUS = D3COLD_LAST_TRANSITION_STATUS(2i32);
pub const LastDStateTransitionD3hot: D3COLD_LAST_TRANSITION_STATUS = D3COLD_LAST_TRANSITION_STATUS(1i32);
pub const LastDStateTransitionStatusUnknown: D3COLD_LAST_TRANSITION_STATUS = D3COLD_LAST_TRANSITION_STATUS(0i32);
pub const LastDrvRtFlag: DRIVER_RUNTIME_INIT_FLAGS = DRIVER_RUNTIME_INIT_FLAGS(2i32);
pub const Latched: KINTERRUPT_MODE = KINTERRUPT_MODE(1i32);
pub const LevelSensitive: KINTERRUPT_MODE = KINTERRUPT_MODE(0i32);
pub const LinePeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(35i32);
pub const LocateControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(3i32);
pub const LocationTypeFileSystem: STATE_LOCATION_TYPE = STATE_LOCATION_TYPE(1i32);
pub const LocationTypeMaximum: STATE_LOCATION_TYPE = STATE_LOCATION_TYPE(2i32);
pub const LocationTypeRegistry: STATE_LOCATION_TYPE = STATE_LOCATION_TYPE(0i32);
pub const LoggerEventsLoggedClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(10i32);
pub const LoggerEventsLostClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(8i32);
pub const LowImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(0i32);
pub const LowPagePriority: MM_PAGE_PRIORITY = MM_PAGE_PRIORITY(0i32);
pub const LowPoolPriority: EX_POOL_PRIORITY = EX_POOL_PRIORITY(0i32);
pub const LowPoolPrioritySpecialPoolOverrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(8i32);
pub const LowPoolPrioritySpecialPoolUnderrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(9i32);
pub const MAXIMUM_DEBUG_BARS: u32 = 6u32;
pub const MAXIMUM_FILENAME_LENGTH: u32 = 256u32;
pub const MAXIMUM_PRIORITY: u32 = 32u32;
pub const MAX_EVENT_COUNTERS: u32 = 31u32;
pub const MCA_EXTREG_V2MAX: u32 = 24u32;
pub const MCE_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe8f56ffe_919c_4cc5_ba88_65abe14913bb);
pub const MDL_ALLOCATED_FIXED_SIZE: u32 = 8u32;
pub const MDL_DESCRIBES_AWE: u32 = 1024u32;
pub const MDL_FREE_EXTRA_PTES: u32 = 512u32;
pub const MDL_INTERNAL: u32 = 32768u32;
pub const MDL_LOCKED_PAGE_TABLES: u32 = 256u32;
pub const MDL_PAGE_CONTENTS_INVARIANT: u32 = 16384u32;
pub const MEMORY_CORRECTABLE_ERROR_SUMMARY_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0e36c93e_ca15_4a83_ba8a_cbe80f7f0017);
pub const MEMORY_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa5bc1114_6f64_4ede_b863_3e83ed7c83b1);
pub const MEM_COMMIT: u32 = 4096u32;
pub const MEM_DECOMMIT: u32 = 16384u32;
pub const MEM_EXTENDED_PARAMETER_EC_CODE: u32 = 64u32;
pub const MEM_EXTENDED_PARAMETER_TYPE_BITS: u32 = 8u32;
pub const MEM_LARGE_PAGES: u32 = 536870912u32;
pub const MEM_MAPPED: u32 = 262144u32;
pub const MEM_PRIVATE: u32 = 131072u32;
pub const MEM_RELEASE: u32 = 32768u32;
pub const MEM_RESERVE: u32 = 8192u32;
pub const MEM_RESET: u32 = 524288u32;
pub const MEM_RESET_UNDO: u32 = 16777216u32;
pub const MEM_TOP_DOWN: u32 = 1048576u32;
pub const MM_ADD_PHYSICAL_MEMORY_ALREADY_ZEROED: u32 = 1u32;
pub const MM_ADD_PHYSICAL_MEMORY_HUGE_PAGES_ONLY: u32 = 4u32;
pub const MM_ADD_PHYSICAL_MEMORY_LARGE_PAGES_ONLY: u32 = 2u32;
pub const MM_ALLOCATE_AND_HOT_REMOVE: u32 = 256u32;
pub const MM_ALLOCATE_CONTIGUOUS_MEMORY_FAST_ONLY: u32 = 1u32;
pub const MM_ALLOCATE_FAST_LARGE_PAGES: u32 = 64u32;
pub const MM_ALLOCATE_FROM_LOCAL_NODE_ONLY: u32 = 2u32;
pub const MM_ALLOCATE_FULLY_REQUIRED: u32 = 4u32;
pub const MM_ALLOCATE_NO_WAIT: u32 = 8u32;
pub const MM_ALLOCATE_PREFER_CONTIGUOUS: u32 = 16u32;
pub const MM_ALLOCATE_REQUIRE_CONTIGUOUS_CHUNKS: u32 = 32u32;
pub const MM_ALLOCATE_TRIM_IF_NECESSARY: u32 = 128u32;
pub const MM_ANY_NODE_OK: u32 = 2147483648u32;
pub const MM_COPY_MEMORY_PHYSICAL: u32 = 1u32;
pub const MM_COPY_MEMORY_VIRTUAL: u32 = 2u32;
pub const MM_DONT_ZERO_ALLOCATION: u32 = 1u32;
pub const MM_DUMP_MAP_CACHED: u32 = 1u32;
pub const MM_DUMP_MAP_INVALIDATE: u32 = 2u32;
pub const MM_FREE_MDL_PAGES_ZERO: u32 = 1u32;
pub const MM_GET_CACHE_ATTRIBUTE_IO_SPACE: u32 = 1u32;
pub const MM_GET_PHYSICAL_MEMORY_RANGES_INCLUDE_ALL_PARTITIONS: u32 = 2u32;
pub const MM_GET_PHYSICAL_MEMORY_RANGES_INCLUDE_FILE_ONLY: u32 = 1u32;
pub const MM_MAPPING_ADDRESS_DIVISIBLE: u32 = 1u32;
pub const MM_MAXIMUM_DISK_IO_SIZE: u32 = 65536u32;
pub const MM_PERMANENT_ADDRESS_IS_IO_SPACE: u32 = 1u32;
pub const MM_PROTECT_DRIVER_SECTION_ALLOW_UNLOAD: u32 = 1u32;
pub const MM_PROTECT_DRIVER_SECTION_VALID_FLAGS: u32 = 1u32;
pub const MM_REMOVE_PHYSICAL_MEMORY_BAD_ONLY: u32 = 1u32;
pub const MM_SECURE_EXCLUSIVE: u32 = 1u32;
pub const MM_SECURE_NO_CHANGE: u32 = 2u32;
pub const MM_SECURE_NO_INHERIT: u32 = 8u32;
pub const MM_SECURE_USER_MODE_ONLY: u32 = 4u32;
pub const MM_SYSTEM_SPACE_END: u32 = 4294967295u32;
pub const MM_SYSTEM_VIEW_EXCEPTIONS_FOR_INPAGE_ERRORS: u32 = 1u32;
pub const MPIBus: INTERFACE_TYPE = INTERFACE_TYPE(10i32);
pub const MPIConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(8i32);
pub const MPSABus: INTERFACE_TYPE = INTERFACE_TYPE(11i32);
pub const MPSAConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(9i32);
pub const MRLClosed: PCI_EXPRESS_MRL_STATE = PCI_EXPRESS_MRL_STATE(0i32);
pub const MRLOpen: PCI_EXPRESS_MRL_STATE = PCI_EXPRESS_MRL_STATE(1i32);
pub const MU_TELEMETRY_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x85183a8b_9c41_429c_939c_5c3c087ca280);
pub const MapPhysicalAddressTypeContiguousRange: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(1i32);
pub const MapPhysicalAddressTypeMax: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(3i32);
pub const MapPhysicalAddressTypeMdl: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(0i32);
pub const MapPhysicalAddressTypePfn: IOMMU_MAP_PHYSICAL_ADDRESS_TYPE = IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(2i32);
pub const MaxFaultType: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(7i32);
pub const MaxHardwareCounterType: HARDWARE_COUNTER_TYPE = HARDWARE_COUNTER_TYPE(1i32);
pub const MaxKeyInfoClass: KEY_INFORMATION_CLASS = KEY_INFORMATION_CLASS(10i32);
pub const MaxKeyValueInfoClass: KEY_VALUE_INFORMATION_CLASS = KEY_VALUE_INFORMATION_CLASS(6i32);
pub const MaxPayload1024Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(3i32);
pub const MaxPayload128Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(0i32);
pub const MaxPayload2048Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(4i32);
pub const MaxPayload256Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(1i32);
pub const MaxPayload4096Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(5i32);
pub const MaxPayload512Bytes: PCI_EXPRESS_MAX_PAYLOAD_SIZE = PCI_EXPRESS_MAX_PAYLOAD_SIZE(2i32);
pub const MaxRegNtNotifyClass: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(51i32);
pub const MaxSubsystemInformationType: SUBSYSTEM_INFORMATION_TYPE = SUBSYSTEM_INFORMATION_TYPE(2i32);
pub const MaxTimerInfoClass: TIMER_SET_INFORMATION_CLASS = TIMER_SET_INFORMATION_CLASS(1i32);
pub const MaxTraceInformationClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(16i32);
pub const MaximumBusDataType: BUS_DATA_TYPE = BUS_DATA_TYPE(12i32);
pub const MaximumDmaSpeed: DMA_SPEED = DMA_SPEED(5i32);
pub const MaximumDmaWidth: DMA_WIDTH = DMA_WIDTH(5i32);
pub const MaximumInterfaceType: INTERFACE_TYPE = INTERFACE_TYPE(18i32);
pub const MaximumMode: MODE = MODE(2i32);
pub const MaximumType: CONFIGURATION_TYPE = CONFIGURATION_TYPE(41i32);
pub const MaximumWaitReason: KWAIT_REASON = KWAIT_REASON(42i32);
pub const MaximumWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(7i32);
pub const MdlMappingNoExecute: u32 = 1073741824u32;
pub const MdlMappingNoWrite: u32 = 2147483648u32;
pub const MdlMappingWithGuardPtes: u32 = 536870912u32;
pub const MediumHighImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(3i32);
pub const MediumImportance: KDPC_IMPORTANCE = KDPC_IMPORTANCE(1i32);
pub const MemDedicatedAttributeMax: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(4i32);
pub const MemDedicatedAttributeReadBandwidth: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(0i32);
pub const MemDedicatedAttributeReadLatency: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(1i32);
pub const MemDedicatedAttributeWriteBandwidth: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(2i32);
pub const MemDedicatedAttributeWriteLatency: MEM_DEDICATED_ATTRIBUTE_TYPE = MEM_DEDICATED_ATTRIBUTE_TYPE(3i32);
pub const MemSectionExtendedParameterInvalidType: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(0i32);
pub const MemSectionExtendedParameterMax: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(4i32);
pub const MemSectionExtendedParameterNumaNode: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(2i32);
pub const MemSectionExtendedParameterSigningLevel: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(3i32);
pub const MemSectionExtendedParameterUserPhysicalFlags: MEM_SECTION_EXTENDED_PARAMETER_TYPE = MEM_SECTION_EXTENDED_PARAMETER_TYPE(1i32);
pub const MicroChannel: INTERFACE_TYPE = INTERFACE_TYPE(3i32);
pub const MmCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(1i32);
pub const MmFrameBufferCached: MEMORY_CACHING_TYPE_ORIG = MEMORY_CACHING_TYPE_ORIG(2i32);
pub const MmHardwareCoherentCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(3i32);
pub const MmLargeSystem: MM_SYSTEMSIZE = MM_SYSTEMSIZE(2i32);
pub const MmMaximumCacheType: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(6i32);
pub const MmMaximumRotateDirection: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(4i32);
pub const MmMdlPageContentsDynamic: MM_MDL_PAGE_CONTENTS_STATE = MM_MDL_PAGE_CONTENTS_STATE(0i32);
pub const MmMdlPageContentsInvariant: MM_MDL_PAGE_CONTENTS_STATE = MM_MDL_PAGE_CONTENTS_STATE(1i32);
pub const MmMdlPageContentsQuery: MM_MDL_PAGE_CONTENTS_STATE = MM_MDL_PAGE_CONTENTS_STATE(2i32);
pub const MmMediumSystem: MM_SYSTEMSIZE = MM_SYSTEMSIZE(1i32);
pub const MmNonCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(0i32);
pub const MmNonCachedUnordered: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(4i32);
pub const MmNotMapped: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(-1i32);
pub const MmSmallSystem: MM_SYSTEMSIZE = MM_SYSTEMSIZE(0i32);
pub const MmToFrameBuffer: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(0i32);
pub const MmToFrameBufferNoCopy: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(1i32);
pub const MmToRegularMemory: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(2i32);
pub const MmToRegularMemoryNoCopy: MM_ROTATE_DIRECTION = MM_ROTATE_DIRECTION(3i32);
pub const MmUSWCCached: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(5i32);
pub const MmWriteCombined: MEMORY_CACHING_TYPE = MEMORY_CACHING_TYPE(2i32);
pub const ModemPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(28i32);
pub const ModifyAccess: IO_ACCESS_TYPE = IO_ACCESS_TYPE(2i32);
pub const MonitorPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(29i32);
pub const MonitorRequestReasonAcDcDisplayBurst: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(5i32);
pub const MonitorRequestReasonAcDcDisplayBurstSuppressed: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(28i32);
pub const MonitorRequestReasonBatteryCountChange: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(16i32);
pub const MonitorRequestReasonBatteryCountChangeSuppressed: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(49i32);
pub const MonitorRequestReasonBatteryPreCritical: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(53i32);
pub const MonitorRequestReasonBuiltinPanel: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(47i32);
pub const MonitorRequestReasonDP: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(19i32);
pub const MonitorRequestReasonDim: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(46i32);
pub const MonitorRequestReasonDirectedDrips: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(45i32);
pub const MonitorRequestReasonDisplayRequiredUnDim: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(48i32);
pub const MonitorRequestReasonFullWake: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(9i32);
pub const MonitorRequestReasonGracePeriod: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(17i32);
pub const MonitorRequestReasonIdleTimeout: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(12i32);
pub const MonitorRequestReasonLid: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(15i32);
pub const MonitorRequestReasonMax: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(55i32);
pub const MonitorRequestReasonNearProximity: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(22i32);
pub const MonitorRequestReasonPdcSignal: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(27i32);
pub const MonitorRequestReasonPdcSignalFingerprint: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(44i32);
pub const MonitorRequestReasonPdcSignalHeyCortana: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(42i32);
pub const MonitorRequestReasonPdcSignalHolographicShell: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(43i32);
pub const MonitorRequestReasonPdcSignalSensorsHumanPresence: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(52i32);
pub const MonitorRequestReasonPdcSignalWindowsMobilePwrNotif: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(40i32);
pub const MonitorRequestReasonPdcSignalWindowsMobileShell: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(41i32);
pub const MonitorRequestReasonPnP: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(18i32);
pub const MonitorRequestReasonPoSetSystemState: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(7i32);
pub const MonitorRequestReasonPolicyChange: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(13i32);
pub const MonitorRequestReasonPowerButton: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(1i32);
pub const MonitorRequestReasonRemoteConnection: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(2i32);
pub const MonitorRequestReasonResumeModernStandby: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(50i32);
pub const MonitorRequestReasonResumePdc: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(24i32);
pub const MonitorRequestReasonResumeS4: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(25i32);
pub const MonitorRequestReasonScMonitorpower: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(3i32);
pub const MonitorRequestReasonScreenOffRequest: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(11i32);
pub const MonitorRequestReasonSessionUnlock: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(10i32);
pub const MonitorRequestReasonSetThreadExecutionState: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(8i32);
pub const MonitorRequestReasonSleepButton: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(14i32);
pub const MonitorRequestReasonSxTransition: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(20i32);
pub const MonitorRequestReasonSystemIdle: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(21i32);
pub const MonitorRequestReasonSystemStateEntered: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(29i32);
pub const MonitorRequestReasonTerminal: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(26i32);
pub const MonitorRequestReasonTerminalInit: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(51i32);
pub const MonitorRequestReasonThermalStandby: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(23i32);
pub const MonitorRequestReasonUnknown: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(0i32);
pub const MonitorRequestReasonUserDisplayBurst: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(6i32);
pub const MonitorRequestReasonUserInput: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(4i32);
pub const MonitorRequestReasonUserInputAccelerometer: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(35i32);
pub const MonitorRequestReasonUserInputHid: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(36i32);
pub const MonitorRequestReasonUserInputInitialization: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(39i32);
pub const MonitorRequestReasonUserInputKeyboard: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(31i32);
pub const MonitorRequestReasonUserInputMouse: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(32i32);
pub const MonitorRequestReasonUserInputPen: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(34i32);
pub const MonitorRequestReasonUserInputPoUserPresent: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(37i32);
pub const MonitorRequestReasonUserInputSessionSwitch: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(38i32);
pub const MonitorRequestReasonUserInputTouch: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(54i32);
pub const MonitorRequestReasonUserInputTouchpad: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(33i32);
pub const MonitorRequestReasonWinrt: POWER_MONITOR_REQUEST_REASON = POWER_MONITOR_REQUEST_REASON(30i32);
pub const MonitorRequestTypeOff: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(0i32);
pub const MonitorRequestTypeOnAndPresent: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(1i32);
pub const MonitorRequestTypeToggleOn: POWER_MONITOR_REQUEST_TYPE = POWER_MONITOR_REQUEST_TYPE(2i32);
pub const MultiFunctionAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(12i32);
pub const NEC98x86: ALTERNATIVE_ARCHITECTURE_TYPE = ALTERNATIVE_ARCHITECTURE_TYPE(1i32);
pub const NMI_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5bad89ff_b7e6_42c9_814a_cf2485d6e98a);
pub const NMI_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe71254e7_c1b9_4940_ab76_909703a4320f);
pub const NPEM_CONTROL_INTERFACE_CURRENT_VERSION: u32 = 2u32;
pub const NPEM_CONTROL_INTERFACE_VERSION1: u32 = 1u32;
pub const NPEM_CONTROL_INTERFACE_VERSION2: u32 = 2u32;
pub const NT_PAGING_LEVELS: u32 = 2u32;
pub const NX_SUPPORT_POLICY_ALWAYSOFF: u32 = 0u32;
pub const NX_SUPPORT_POLICY_ALWAYSON: u32 = 1u32;
pub const NX_SUPPORT_POLICY_OPTIN: u32 = 2u32;
pub const NX_SUPPORT_POLICY_OPTOUT: u32 = 3u32;
pub const NetworkController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(18i32);
pub const NetworkPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(36i32);
pub const NoAspmSupport: PCI_EXPRESS_ASPM_SUPPORT = PCI_EXPRESS_ASPM_SUPPORT(0i32);
pub const NormalPagePriority: MM_PAGE_PRIORITY = MM_PAGE_PRIORITY(16i32);
pub const NormalPoolPriority: EX_POOL_PRIORITY = EX_POOL_PRIORITY(16i32);
pub const NormalPoolPrioritySpecialPoolOverrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(24i32);
pub const NormalPoolPrioritySpecialPoolUnderrun: EX_POOL_PRIORITY = EX_POOL_PRIORITY(25i32);
pub const NormalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(3i32);
pub const NuBus: INTERFACE_TYPE = INTERFACE_TYPE(7i32);
pub const NuBusConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(6i32);
pub const OBJECT_TYPE_CREATE: u32 = 1u32;
pub const OB_FLT_REGISTRATION_VERSION: u32 = 256u32;
pub const OB_FLT_REGISTRATION_VERSION_0100: u32 = 256u32;
pub const OB_OPERATION_HANDLE_CREATE: u32 = 1u32;
pub const OB_OPERATION_HANDLE_DUPLICATE: u32 = 2u32;
pub const OB_PREOP_SUCCESS: OB_PREOP_CALLBACK_STATUS = OB_PREOP_CALLBACK_STATUS(0i32);
pub const OPLOCK_KEY_FLAG_PARENT_KEY: u32 = 1u32;
pub const OPLOCK_KEY_FLAG_TARGET_KEY: u32 = 2u32;
pub const OPLOCK_KEY_VERSION_WIN7: u32 = 1u32;
pub const OPLOCK_KEY_VERSION_WIN8: u32 = 2u32;
pub const OSC_CAPABILITIES_MASKED: u32 = 16u32;
pub const OSC_FIRMWARE_FAILURE: u32 = 2u32;
pub const OSC_UNRECOGNIZED_REVISION: u32 = 8u32;
pub const OSC_UNRECOGNIZED_UUID: u32 = 4u32;
pub const OkControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(2i32);
pub const OtherController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(24i32);
pub const OtherPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(34i32);
pub const PAGE_ENCLAVE_NO_CHANGE: u32 = 536870912u32;
pub const PAGE_ENCLAVE_THREAD_CONTROL: u32 = 2147483648u32;
pub const PAGE_ENCLAVE_UNVALIDATED: u32 = 536870912u32;
pub const PAGE_EXECUTE: u32 = 16u32;
pub const PAGE_EXECUTE_READ: u32 = 32u32;
pub const PAGE_EXECUTE_READWRITE: u32 = 64u32;
pub const PAGE_EXECUTE_WRITECOPY: u32 = 128u32;
pub const PAGE_GRAPHICS_COHERENT: u32 = 131072u32;
pub const PAGE_GRAPHICS_EXECUTE: u32 = 16384u32;
pub const PAGE_GRAPHICS_EXECUTE_READ: u32 = 32768u32;
pub const PAGE_GRAPHICS_EXECUTE_READWRITE: u32 = 65536u32;
pub const PAGE_GRAPHICS_NOACCESS: u32 = 2048u32;
pub const PAGE_GRAPHICS_NOCACHE: u32 = 262144u32;
pub const PAGE_GRAPHICS_READONLY: u32 = 4096u32;
pub const PAGE_GRAPHICS_READWRITE: u32 = 8192u32;
pub const PAGE_GUARD: u32 = 256u32;
pub const PAGE_NOACCESS: u32 = 1u32;
pub const PAGE_NOCACHE: u32 = 512u32;
pub const PAGE_READONLY: u32 = 2u32;
pub const PAGE_READWRITE: u32 = 4u32;
pub const PAGE_REVERT_TO_FILE_MAP: u32 = 2147483648u32;
pub const PAGE_SHIFT: i32 = 12i32;
pub const PAGE_SIZE: u32 = 4096u32;
pub const PAGE_TARGETS_INVALID: u32 = 1073741824u32;
pub const PAGE_TARGETS_NO_UPDATE: u32 = 1073741824u32;
pub const PAGE_WRITECOMBINE: u32 = 1024u32;
pub const PAGE_WRITECOPY: u32 = 8u32;
pub const PARKING_TOPOLOGY_POLICY_DISABLED: u32 = 0u32;
pub const PASSIVE_LEVEL: u32 = 0u32;
pub const PCCARD_DEVICE_PCI: u32 = 16u32;
pub const PCCARD_DUP_LEGACY_BASE: u32 = 6u32;
pub const PCCARD_MAP_ERROR: u32 = 1u32;
pub const PCCARD_MAP_ZERO: u32 = 2u32;
pub const PCCARD_NO_CONTROLLERS: u32 = 7u32;
pub const PCCARD_NO_LEGACY_BASE: u32 = 5u32;
pub const PCCARD_NO_PIC: u32 = 4u32;
pub const PCCARD_NO_TIMER: u32 = 3u32;
pub const PCCARD_SCAN_DISABLED: u32 = 1u32;
pub const PCIBus: INTERFACE_TYPE = INTERFACE_TYPE(5i32);
pub const PCIConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(4i32);
pub const PCIEXPRESS_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd995e954_bbc1_430f_ad91_b44dcb3c6f35);
pub const PCIE_CORRECTABLE_ERROR_SUMMARY_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe96eca99_53e2_4f52_9be7_d2dbe9508ed0);
pub const PCIXBUS_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc5753963_3b84_4095_bf78_eddad3f9c9dd);
pub const PCIXBUS_ERRTYPE_ADDRESSPARITY: u32 = 6u32;
pub const PCIXBUS_ERRTYPE_BUSTIMEOUT: u32 = 4u32;
pub const PCIXBUS_ERRTYPE_COMMANDPARITY: u32 = 7u32;
pub const PCIXBUS_ERRTYPE_DATAPARITY: u32 = 1u32;
pub const PCIXBUS_ERRTYPE_MASTERABORT: u32 = 3u32;
pub const PCIXBUS_ERRTYPE_MASTERDATAPARITY: u32 = 5u32;
pub const PCIXBUS_ERRTYPE_SYSTEM: u32 = 2u32;
pub const PCIXBUS_ERRTYPE_UNKNOWN: u32 = 0u32;
pub const PCIXDEVICE_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xeb5e4685_ca66_4769_b6a2_26068b001326);
pub const PCIX_MODE1_100MHZ: u32 = 2u32;
pub const PCIX_MODE1_133MHZ: u32 = 3u32;
pub const PCIX_MODE1_66MHZ: u32 = 1u32;
pub const PCIX_MODE2_266_100MHZ: u32 = 10u32;
pub const PCIX_MODE2_266_133MHZ: u32 = 11u32;
pub const PCIX_MODE2_266_66MHZ: u32 = 9u32;
pub const PCIX_MODE2_533_100MHZ: u32 = 14u32;
pub const PCIX_MODE2_533_133MHZ: u32 = 15u32;
pub const PCIX_MODE2_533_66MHZ: u32 = 13u32;
pub const PCIX_MODE_CONVENTIONAL_PCI: u32 = 0u32;
pub const PCIX_VERSION_DUAL_MODE_ECC: u32 = 2u32;
pub const PCIX_VERSION_MODE1_ONLY: u32 = 0u32;
pub const PCIX_VERSION_MODE2_ECC: u32 = 1u32;
pub const PCI_ACS_ALLOWED: u32 = 0u32;
pub const PCI_ACS_BLOCKED: u32 = 1u32;
pub const PCI_ACS_REDIRECTED: u32 = 2u32;
pub const PCI_ADDRESS_IO_ADDRESS_MASK: u32 = 4294967292u32;
pub const PCI_ADDRESS_IO_SPACE: u32 = 1u32;
pub const PCI_ADDRESS_MEMORY_ADDRESS_MASK: u32 = 4294967280u32;
pub const PCI_ADDRESS_MEMORY_PREFETCHABLE: u32 = 8u32;
pub const PCI_ADDRESS_MEMORY_TYPE_MASK: u32 = 6u32;
pub const PCI_ADDRESS_ROM_ADDRESS_MASK: u32 = 4294965248u32;
pub const PCI_AGP_RATE_1X: u32 = 1u32;
pub const PCI_AGP_RATE_2X: u32 = 2u32;
pub const PCI_AGP_RATE_4X: u32 = 4u32;
pub const PCI_ATS_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_BRIDGE_TYPE: u32 = 1u32;
pub const PCI_BUS_INTERFACE_STANDARD_VERSION: u32 = 2u32;
pub const PCI_CAPABILITY_ID_ADVANCED_FEATURES: u32 = 19u32;
pub const PCI_CAPABILITY_ID_AGP: u32 = 2u32;
pub const PCI_CAPABILITY_ID_AGP_TARGET: u32 = 14u32;
pub const PCI_CAPABILITY_ID_CPCI_HOTSWAP: u32 = 6u32;
pub const PCI_CAPABILITY_ID_CPCI_RES_CTRL: u32 = 11u32;
pub const PCI_CAPABILITY_ID_DEBUG_PORT: u32 = 10u32;
pub const PCI_CAPABILITY_ID_FPB: u32 = 21u32;
pub const PCI_CAPABILITY_ID_HYPERTRANSPORT: u32 = 8u32;
pub const PCI_CAPABILITY_ID_MSI: u32 = 5u32;
pub const PCI_CAPABILITY_ID_MSIX: u32 = 17u32;
pub const PCI_CAPABILITY_ID_P2P_SSID: u32 = 13u32;
pub const PCI_CAPABILITY_ID_PCIX: u32 = 7u32;
pub const PCI_CAPABILITY_ID_PCI_EXPRESS: u32 = 16u32;
pub const PCI_CAPABILITY_ID_POWER_MANAGEMENT: u32 = 1u32;
pub const PCI_CAPABILITY_ID_SATA_CONFIG: u32 = 18u32;
pub const PCI_CAPABILITY_ID_SECURE: u32 = 15u32;
pub const PCI_CAPABILITY_ID_SHPC: u32 = 12u32;
pub const PCI_CAPABILITY_ID_SLOT_ID: u32 = 4u32;
pub const PCI_CAPABILITY_ID_VENDOR_SPECIFIC: u32 = 9u32;
pub const PCI_CAPABILITY_ID_VPD: u32 = 3u32;
pub const PCI_CARDBUS_BRIDGE_TYPE: u32 = 2u32;
pub const PCI_CLASS_BASE_SYSTEM_DEV: u32 = 8u32;
pub const PCI_CLASS_BRIDGE_DEV: u32 = 6u32;
pub const PCI_CLASS_DATA_ACQ_SIGNAL_PROC: u32 = 17u32;
pub const PCI_CLASS_DISPLAY_CTLR: u32 = 3u32;
pub const PCI_CLASS_DOCKING_STATION: u32 = 10u32;
pub const PCI_CLASS_ENCRYPTION_DECRYPTION: u32 = 16u32;
pub const PCI_CLASS_INPUT_DEV: u32 = 9u32;
pub const PCI_CLASS_INTELLIGENT_IO_CTLR: u32 = 14u32;
pub const PCI_CLASS_MASS_STORAGE_CTLR: u32 = 1u32;
pub const PCI_CLASS_MEMORY_CTLR: u32 = 5u32;
pub const PCI_CLASS_MULTIMEDIA_DEV: u32 = 4u32;
pub const PCI_CLASS_NETWORK_CTLR: u32 = 2u32;
pub const PCI_CLASS_NOT_DEFINED: u32 = 255u32;
pub const PCI_CLASS_PRE_20: u32 = 0u32;
pub const PCI_CLASS_PROCESSOR: u32 = 11u32;
pub const PCI_CLASS_SATELLITE_COMMS_CTLR: u32 = 15u32;
pub const PCI_CLASS_SERIAL_BUS_CTLR: u32 = 12u32;
pub const PCI_CLASS_SIMPLE_COMMS_CTLR: u32 = 7u32;
pub const PCI_CLASS_WIRELESS_CTLR: u32 = 13u32;
pub const PCI_DATA_VERSION: u32 = 1u32;
pub const PCI_DEVICE_PRESENT_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_DEVICE_TYPE: u32 = 0u32;
pub const PCI_DISABLE_LEVEL_INTERRUPT: u32 = 1024u32;
pub const PCI_ENABLE_BUS_MASTER: u32 = 4u32;
pub const PCI_ENABLE_FAST_BACK_TO_BACK: u32 = 512u32;
pub const PCI_ENABLE_IO_SPACE: u32 = 1u32;
pub const PCI_ENABLE_MEMORY_SPACE: u32 = 2u32;
pub const PCI_ENABLE_PARITY: u32 = 64u32;
pub const PCI_ENABLE_SERR: u32 = 256u32;
pub const PCI_ENABLE_SPECIAL_CYCLES: u32 = 8u32;
pub const PCI_ENABLE_VGA_COMPATIBLE_PALETTE: u32 = 32u32;
pub const PCI_ENABLE_WAIT_CYCLE: u32 = 128u32;
pub const PCI_ENABLE_WRITE_AND_INVALIDATE: u32 = 16u32;
pub const PCI_EXPRESS_ACCESS_CONTROL_SERVICES_CAP_ID: u32 = 13u32;
pub const PCI_EXPRESS_ADVANCED_ERROR_REPORTING_CAP_ID: u32 = 1u32;
pub const PCI_EXPRESS_ARI_CAP_ID: u32 = 14u32;
pub const PCI_EXPRESS_ATS_CAP_ID: u32 = 15u32;
pub const PCI_EXPRESS_CONFIGURATION_ACCESS_CORRELATION_CAP_ID: u32 = 12u32;
pub const PCI_EXPRESS_DESIGNATED_VENDOR_SPECIFIC_CAP_ID: u32 = 35u32;
pub const PCI_EXPRESS_DEVICE_SERIAL_NUMBER_CAP_ID: u32 = 3u32;
pub const PCI_EXPRESS_DPA_CAP_ID: u32 = 22u32;
pub const PCI_EXPRESS_DPC_CAP_ID: u32 = 29u32;
pub const PCI_EXPRESS_FRS_QUEUEING_CAP_ID: u32 = 33u32;
pub const PCI_EXPRESS_L1_PM_SS_CAP_ID: u32 = 30u32;
pub const PCI_EXPRESS_LINK_QUIESCENT_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_EXPRESS_LN_REQUESTER_CAP_ID: u32 = 28u32;
pub const PCI_EXPRESS_LTR_CAP_ID: u32 = 24u32;
pub const PCI_EXPRESS_MFVC_CAP_ID: u32 = 8u32;
pub const PCI_EXPRESS_MPCIE_CAP_ID: u32 = 32u32;
pub const PCI_EXPRESS_MULTICAST_CAP_ID: u32 = 18u32;
pub const PCI_EXPRESS_MULTI_ROOT_IO_VIRTUALIZATION_CAP_ID: u32 = 17u32;
pub const PCI_EXPRESS_NPEM_CAP_ID: u32 = 41u32;
pub const PCI_EXPRESS_PAGE_REQUEST_CAP_ID: u32 = 19u32;
pub const PCI_EXPRESS_PASID_CAP_ID: u32 = 27u32;
pub const PCI_EXPRESS_PMUX_CAP_ID: u32 = 26u32;
pub const PCI_EXPRESS_POWER_BUDGETING_CAP_ID: u32 = 4u32;
pub const PCI_EXPRESS_PTM_CAP_ID: u32 = 31u32;
pub const PCI_EXPRESS_RCRB_HEADER_CAP_ID: u32 = 10u32;
pub const PCI_EXPRESS_RC_EVENT_COLLECTOR_ENDPOINT_ASSOCIATION_CAP_ID: u32 = 7u32;
pub const PCI_EXPRESS_RC_INTERNAL_LINK_CONTROL_CAP_ID: u32 = 6u32;
pub const PCI_EXPRESS_RC_LINK_DECLARATION_CAP_ID: u32 = 5u32;
pub const PCI_EXPRESS_READINESS_TIME_REPORTING_CAP_ID: u32 = 34u32;
pub const PCI_EXPRESS_RESERVED_FOR_AMD_CAP_ID: u32 = 20u32;
pub const PCI_EXPRESS_RESIZABLE_BAR_CAP_ID: u32 = 21u32;
pub const PCI_EXPRESS_ROOT_PORT_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_EXPRESS_SECONDARY_PCI_EXPRESS_CAP_ID: u32 = 25u32;
pub const PCI_EXPRESS_SINGLE_ROOT_IO_VIRTUALIZATION_CAP_ID: u32 = 16u32;
pub const PCI_EXPRESS_TPH_REQUESTER_CAP_ID: u32 = 23u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_MSIX_TABLE: u32 = 2u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_NONE: u32 = 0u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_RESERVED: u32 = 3u32;
pub const PCI_EXPRESS_TPH_ST_LOCATION_TPH_CAPABILITY: u32 = 1u32;
pub const PCI_EXPRESS_VC_AND_MFVC_CAP_ID: u32 = 9u32;
pub const PCI_EXPRESS_VENDOR_SPECIFIC_CAP_ID: u32 = 11u32;
pub const PCI_EXPRESS_VIRTUAL_CHANNEL_CAP_ID: u32 = 2u32;
pub const PCI_EXTENDED_CONFIG_LENGTH: u32 = 4096u32;
pub const PCI_INVALID_ALTERNATE_FUNCTION_NUMBER: u32 = 255u32;
pub const PCI_INVALID_VENDORID: u32 = 65535u32;
pub const PCI_MAX_BRIDGE_NUMBER: u32 = 255u32;
pub const PCI_MAX_DEVICES: u32 = 32u32;
pub const PCI_MAX_FUNCTION: u32 = 8u32;
pub const PCI_MAX_SEGMENT_NUMBER: u32 = 65535u32;
pub const PCI_MSIX_TABLE_CONFIG_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_MULTIFUNCTION: u32 = 128u32;
pub const PCI_PROGRAMMING_INTERFACE_MSC_NVM_EXPRESS: u32 = 2u32;
pub const PCI_PTM_TIME_SOURCE_AUX: u32 = 4294967295u32;
pub const PCI_RECOVERY_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdd060800_f6e1_4204_ac27_c4bca9568402);
pub const PCI_ROMADDRESS_ENABLED: u32 = 1u32;
pub const PCI_ROOT_BUS_OSC_METHOD_CAPABILITY_REVISION: u32 = 1u32;
pub const PCI_SECURITY_DIRECT_TRANSLATED_P2P: u32 = 4u32;
pub const PCI_SECURITY_ENHANCED: u32 = 2u32;
pub const PCI_SECURITY_FULLY_SUPPORTED: u32 = 1u32;
pub const PCI_SECURITY_GUEST_ASSIGNED: u32 = 1u32;
pub const PCI_SECURITY_INTERFACE_VERSION: u32 = 1u32;
pub const PCI_SECURITY_INTERFACE_VERSION2: u32 = 2u32;
pub const PCI_SECURITY_SRIOV_DIRECT_TRANSLATED_P2P: u32 = 262144u32;
pub const PCI_STATUS_66MHZ_CAPABLE: u32 = 32u32;
pub const PCI_STATUS_CAPABILITIES_LIST: u32 = 16u32;
pub const PCI_STATUS_DATA_PARITY_DETECTED: u32 = 256u32;
pub const PCI_STATUS_DETECTED_PARITY_ERROR: u32 = 32768u32;
pub const PCI_STATUS_DEVSEL: u32 = 1536u32;
pub const PCI_STATUS_FAST_BACK_TO_BACK: u32 = 128u32;
pub const PCI_STATUS_IMMEDIATE_READINESS: u32 = 1u32;
pub const PCI_STATUS_INTERRUPT_PENDING: u32 = 8u32;
pub const PCI_STATUS_RECEIVED_MASTER_ABORT: u32 = 8192u32;
pub const PCI_STATUS_RECEIVED_TARGET_ABORT: u32 = 4096u32;
pub const PCI_STATUS_SIGNALED_SYSTEM_ERROR: u32 = 16384u32;
pub const PCI_STATUS_SIGNALED_TARGET_ABORT: u32 = 2048u32;
pub const PCI_STATUS_UDF_SUPPORTED: u32 = 64u32;
pub const PCI_SUBCLASS_BR_CARDBUS: u32 = 7u32;
pub const PCI_SUBCLASS_BR_EISA: u32 = 2u32;
pub const PCI_SUBCLASS_BR_HOST: u32 = 0u32;
pub const PCI_SUBCLASS_BR_ISA: u32 = 1u32;
pub const PCI_SUBCLASS_BR_MCA: u32 = 3u32;
pub const PCI_SUBCLASS_BR_NUBUS: u32 = 6u32;
pub const PCI_SUBCLASS_BR_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_BR_PCI_TO_PCI: u32 = 4u32;
pub const PCI_SUBCLASS_BR_PCMCIA: u32 = 5u32;
pub const PCI_SUBCLASS_BR_RACEWAY: u32 = 8u32;
pub const PCI_SUBCLASS_COM_MODEM: u32 = 3u32;
pub const PCI_SUBCLASS_COM_MULTIPORT: u32 = 2u32;
pub const PCI_SUBCLASS_COM_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_COM_PARALLEL: u32 = 1u32;
pub const PCI_SUBCLASS_COM_SERIAL: u32 = 0u32;
pub const PCI_SUBCLASS_CRYPTO_ENTERTAINMENT: u32 = 16u32;
pub const PCI_SUBCLASS_CRYPTO_NET_COMP: u32 = 0u32;
pub const PCI_SUBCLASS_CRYPTO_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_DASP_DPIO: u32 = 0u32;
pub const PCI_SUBCLASS_DASP_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_DOC_GENERIC: u32 = 0u32;
pub const PCI_SUBCLASS_DOC_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_INP_DIGITIZER: u32 = 1u32;
pub const PCI_SUBCLASS_INP_GAMEPORT: u32 = 4u32;
pub const PCI_SUBCLASS_INP_KEYBOARD: u32 = 0u32;
pub const PCI_SUBCLASS_INP_MOUSE: u32 = 2u32;
pub const PCI_SUBCLASS_INP_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_INP_SCANNER: u32 = 3u32;
pub const PCI_SUBCLASS_INTIO_I2O: u32 = 0u32;
pub const PCI_SUBCLASS_MEM_FLASH: u32 = 1u32;
pub const PCI_SUBCLASS_MEM_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_MEM_RAM: u32 = 0u32;
pub const PCI_SUBCLASS_MM_AUDIO_DEV: u32 = 1u32;
pub const PCI_SUBCLASS_MM_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_MM_TELEPHONY_DEV: u32 = 2u32;
pub const PCI_SUBCLASS_MM_VIDEO_DEV: u32 = 0u32;
pub const PCI_SUBCLASS_MSC_AHCI_CTLR: u32 = 6u32;
pub const PCI_SUBCLASS_MSC_FLOPPY_CTLR: u32 = 2u32;
pub const PCI_SUBCLASS_MSC_IDE_CTLR: u32 = 1u32;
pub const PCI_SUBCLASS_MSC_IPI_CTLR: u32 = 3u32;
pub const PCI_SUBCLASS_MSC_NVM_CTLR: u32 = 8u32;
pub const PCI_SUBCLASS_MSC_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_MSC_RAID_CTLR: u32 = 4u32;
pub const PCI_SUBCLASS_MSC_SCSI_BUS_CTLR: u32 = 0u32;
pub const PCI_SUBCLASS_NET_ATM_CTLR: u32 = 3u32;
pub const PCI_SUBCLASS_NET_ETHERNET_CTLR: u32 = 0u32;
pub const PCI_SUBCLASS_NET_FDDI_CTLR: u32 = 2u32;
pub const PCI_SUBCLASS_NET_ISDN_CTLR: u32 = 4u32;
pub const PCI_SUBCLASS_NET_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_NET_TOKEN_RING_CTLR: u32 = 1u32;
pub const PCI_SUBCLASS_PRE_20_NON_VGA: u32 = 0u32;
pub const PCI_SUBCLASS_PRE_20_VGA: u32 = 1u32;
pub const PCI_SUBCLASS_PROC_386: u32 = 0u32;
pub const PCI_SUBCLASS_PROC_486: u32 = 1u32;
pub const PCI_SUBCLASS_PROC_ALPHA: u32 = 16u32;
pub const PCI_SUBCLASS_PROC_COPROCESSOR: u32 = 64u32;
pub const PCI_SUBCLASS_PROC_PENTIUM: u32 = 2u32;
pub const PCI_SUBCLASS_PROC_POWERPC: u32 = 32u32;
pub const PCI_SUBCLASS_SAT_AUDIO: u32 = 2u32;
pub const PCI_SUBCLASS_SAT_DATA: u32 = 4u32;
pub const PCI_SUBCLASS_SAT_TV: u32 = 1u32;
pub const PCI_SUBCLASS_SAT_VOICE: u32 = 3u32;
pub const PCI_SUBCLASS_SB_ACCESS: u32 = 1u32;
pub const PCI_SUBCLASS_SB_FIBRE_CHANNEL: u32 = 4u32;
pub const PCI_SUBCLASS_SB_IEEE1394: u32 = 0u32;
pub const PCI_SUBCLASS_SB_SMBUS: u32 = 5u32;
pub const PCI_SUBCLASS_SB_SSA: u32 = 2u32;
pub const PCI_SUBCLASS_SB_THUNDERBOLT: u32 = 10u32;
pub const PCI_SUBCLASS_SB_USB: u32 = 3u32;
pub const PCI_SUBCLASS_SYS_DMA_CTLR: u32 = 1u32;
pub const PCI_SUBCLASS_SYS_GEN_HOTPLUG_CTLR: u32 = 4u32;
pub const PCI_SUBCLASS_SYS_INTERRUPT_CTLR: u32 = 0u32;
pub const PCI_SUBCLASS_SYS_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_SYS_RCEC: u32 = 7u32;
pub const PCI_SUBCLASS_SYS_REAL_TIME_CLOCK: u32 = 3u32;
pub const PCI_SUBCLASS_SYS_SDIO_CTRL: u32 = 5u32;
pub const PCI_SUBCLASS_SYS_SYSTEM_TIMER: u32 = 2u32;
pub const PCI_SUBCLASS_VID_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_VID_VGA_CTLR: u32 = 0u32;
pub const PCI_SUBCLASS_VID_XGA_CTLR: u32 = 1u32;
pub const PCI_SUBCLASS_WIRELESS_CON_IR: u32 = 1u32;
pub const PCI_SUBCLASS_WIRELESS_IRDA: u32 = 0u32;
pub const PCI_SUBCLASS_WIRELESS_OTHER: u32 = 128u32;
pub const PCI_SUBCLASS_WIRELESS_RF: u32 = 16u32;
pub const PCI_SUBLCASS_VID_3D_CTLR: u32 = 2u32;
pub const PCI_TYPE0_ADDRESSES: u32 = 6u32;
pub const PCI_TYPE1_ADDRESSES: u32 = 2u32;
pub const PCI_TYPE2_ADDRESSES: u32 = 5u32;
pub const PCI_TYPE_20BIT: u32 = 2u32;
pub const PCI_TYPE_32BIT: u32 = 0u32;
pub const PCI_TYPE_64BIT: u32 = 4u32;
pub const PCI_USE_CLASS_SUBCLASS: u32 = 8u32;
pub const PCI_USE_LOCAL_BUS: u32 = 32u32;
pub const PCI_USE_LOCAL_DEVICE: u32 = 64u32;
pub const PCI_USE_PROGIF: u32 = 16u32;
pub const PCI_USE_REVISION: u32 = 2u32;
pub const PCI_USE_SUBSYSTEM_IDS: u32 = 1u32;
pub const PCI_USE_VENDEV_IDS: u32 = 4u32;
pub const PCI_WHICHSPACE_CONFIG: u32 = 0u32;
pub const PCI_WHICHSPACE_ROM: u32 = 1382638416u32;
pub const PCIe_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcf93c01f_1a16_4dfc_b8bc_9c4daf67c104);
pub const PCMCIABus: INTERFACE_TYPE = INTERFACE_TYPE(8i32);
pub const PCMCIAConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(7i32);
pub const PCR_BTI_MITIGATION_CSWAP_HVC: u32 = 16u32;
pub const PCR_BTI_MITIGATION_CSWAP_SMC: u32 = 32u32;
pub const PCR_BTI_MITIGATION_NONE: u32 = 0u32;
pub const PCR_BTI_MITIGATION_VBAR_MASK: u32 = 15u32;
pub const PCR_MAJOR_VERSION: u32 = 1u32;
pub const PCR_MINOR_VERSION: u32 = 1u32;
pub const PCW_CURRENT_VERSION: u32 = 512u32;
pub const PCW_VERSION_1: u32 = 256u32;
pub const PCW_VERSION_2: u32 = 512u32;
pub const PDE_BASE: u32 = 3224371200u32;
pub const PDE_PER_PAGE: u32 = 512u32;
pub const PDE_TOP: u32 = 3224375295u32;
pub const PDI_SHIFT: u32 = 21u32;
pub const PEI_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x09a9d5ac_5204_4214_96e5_94992e752bcd);
pub const PFAControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(6i32);
pub const PLUGPLAY_PROPERTY_PERSISTENT: u32 = 1u32;
pub const PLUGPLAY_REGKEY_CURRENT_HWPROFILE: u32 = 4u32;
pub const PLUGPLAY_REGKEY_DEVICE: u32 = 1u32;
pub const PLUGPLAY_REGKEY_DRIVER: u32 = 2u32;
pub const PMCCounter: HARDWARE_COUNTER_TYPE = HARDWARE_COUNTER_TYPE(0i32);
pub const PMEM_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x81687003_dbfd_4728_9ffd_f0904f97597d);
pub const PNPBus: INTERFACE_TYPE = INTERFACE_TYPE(15i32);
pub const PNPISABus: INTERFACE_TYPE = INTERFACE_TYPE(14i32);
pub const PNPISAConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(10i32);
pub const PNPNOTIFY_DEVICE_INTERFACE_INCLUDE_EXISTING_INTERFACES: u32 = 1u32;
pub const PNP_DEVICE_ASSIGNED_TO_GUEST: u32 = 256u32;
pub const PNP_DEVICE_DISABLED: u32 = 1u32;
pub const PNP_DEVICE_DISCONNECTED: u32 = 64u32;
pub const PNP_DEVICE_DONT_DISPLAY_IN_UI: u32 = 2u32;
pub const PNP_DEVICE_FAILED: u32 = 4u32;
pub const PNP_DEVICE_NOT_DISABLEABLE: u32 = 32u32;
pub const PNP_DEVICE_REMOVED: u32 = 8u32;
pub const PNP_DEVICE_RESOURCE_REQUIREMENTS_CHANGED: u32 = 16u32;
pub const PNP_DEVICE_RESOURCE_UPDATED: u32 = 128u32;
pub const PNP_EXTENDED_ADDRESS_INTERFACE_VERSION: u32 = 1u32;
pub const PNP_REPLACE_DRIVER_INTERFACE_VERSION: u32 = 1u32;
pub const PNP_REPLACE_HARDWARE_MEMORY_MIRRORING: u32 = 4u32;
pub const PNP_REPLACE_HARDWARE_PAGE_COPY: u32 = 8u32;
pub const PNP_REPLACE_HARDWARE_QUIESCE: u32 = 16u32;
pub const PNP_REPLACE_MEMORY_SUPPORTED: u32 = 1u32;
pub const PNP_REPLACE_PARAMETERS_VERSION: u32 = 2u32;
pub const PNP_REPLACE_PROCESSOR_SUPPORTED: u32 = 2u32;
pub const POOL_COLD_ALLOCATION: u32 = 256u32;
pub const POOL_CREATE_FLG_SECURE_POOL: u32 = 1u32;
pub const POOL_CREATE_FLG_USE_GLOBAL_POOL: u32 = 2u32;
pub const POOL_CREATE_PARAMS_VERSION: u32 = 1u32;
pub const POOL_EXTENDED_PARAMETER_REQUIRED_FIELD_BITS: u32 = 1u32;
pub const POOL_EXTENDED_PARAMETER_TYPE_BITS: u32 = 8u32;
pub const POOL_NX_ALLOCATION: u32 = 512u32;
pub const POOL_NX_OPTIN_AUTO: u32 = 1u32;
pub const POOL_QUOTA_FAIL_INSTEAD_OF_RAISE: u32 = 8u32;
pub const POOL_RAISE_IF_ALLOCATION_FAILURE: u32 = 16u32;
pub const POOL_TAGGING: u32 = 1u32;
pub const POOL_ZEROING_INFORMATION: u32 = 227u32;
pub const POOL_ZERO_ALLOCATION: u32 = 1024u32;
pub const PORT_MAXIMUM_MESSAGE_LENGTH: u32 = 512u32;
pub const POWER_LEVEL: u32 = 30u32;
pub const POWER_PLATFORM_ROLE_V1: u32 = 1u32;
pub const POWER_PLATFORM_ROLE_V2: u32 = 2u32;
pub const POWER_PLATFORM_ROLE_VERSION: u32 = 2u32;
pub const POWER_SETTING_VALUE_VERSION: u32 = 1u32;
pub const POWER_THROTTLING_PROCESS_CURRENT_VERSION: u32 = 1u32;
pub const POWER_THROTTLING_PROCESS_DELAYTIMERS: u32 = 2u32;
pub const POWER_THROTTLING_PROCESS_EXECUTION_SPEED: u32 = 1u32;
pub const POWER_THROTTLING_PROCESS_IGNORE_TIMER_RESOLUTION: u32 = 4u32;
pub const POWER_THROTTLING_THREAD_CURRENT_VERSION: u32 = 1u32;
pub const POWER_THROTTLING_THREAD_EXECUTION_SPEED: u32 = 1u32;
pub const POWER_THROTTLING_THREAD_VALID_FLAGS: u32 = 1u32;
pub const PO_FX_COMPONENT_FLAG_F0_ON_DX: u64 = 1u64;
pub const PO_FX_COMPONENT_FLAG_NO_DEBOUNCE: u64 = 2u64;
pub const PO_FX_DIRECTED_FX_DEFAULT_IDLE_TIMEOUT: u32 = 0u32;
pub const PO_FX_FLAG_ASYNC_ONLY: u32 = 2u32;
pub const PO_FX_FLAG_BLOCKING: u32 = 1u32;
pub const PO_FX_FLAG_PERF_PEP_OPTIONAL: u32 = 1u32;
pub const PO_FX_FLAG_PERF_QUERY_ON_ALL_IDLE_STATES: u32 = 4u32;
pub const PO_FX_FLAG_PERF_QUERY_ON_F0: u32 = 2u32;
pub const PO_FX_UNKNOWN_POWER: u32 = 4294967295u32;
pub const PO_FX_UNKNOWN_TIME: u64 = 18446744073709551615u64;
pub const PO_FX_VERSION: u32 = 1u32;
pub const PO_FX_VERSION_V1: u32 = 1u32;
pub const PO_FX_VERSION_V2: u32 = 2u32;
pub const PO_FX_VERSION_V3: u32 = 3u32;
pub const PO_MEM_BOOT_PHASE: u32 = 65536u32;
pub const PO_MEM_CLONE: u32 = 2u32;
pub const PO_MEM_CL_OR_NCHK: u32 = 4u32;
pub const PO_MEM_DISCARD: u32 = 32768u32;
pub const PO_MEM_PAGE_ADDRESS: u32 = 16384u32;
pub const PO_MEM_PRESERVE: u32 = 1u32;
pub const PPI_SHIFT: u32 = 30u32;
pub const PRIVILEGE_SET_ALL_NECESSARY: u32 = 1u32;
pub const PROCESSOR_FEATURE_MAX: u32 = 64u32;
pub const PROCESSOR_GENERIC_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9876ccad_47b4_4bdb_b65e_16f193c4f3db);
pub const PROCESS_EXCEPTION_PORT_ALL_STATE_BITS: u32 = 3u32;
pub const PROCESS_HANDLE_EXCEPTIONS_ENABLED: u32 = 1u32;
pub const PROCESS_HANDLE_RAISE_UM_EXCEPTION_ON_INVALID_HANDLE_CLOSE_DISABLED: u32 = 0u32;
pub const PROCESS_HANDLE_RAISE_UM_EXCEPTION_ON_INVALID_HANDLE_CLOSE_ENABLED: u32 = 1u32;
pub const PROCESS_HANDLE_TRACING_MAX_STACKS: u32 = 16u32;
pub const PROCESS_LUID_DOSDEVICES_ONLY: u32 = 1u32;
pub const PROFILE_LEVEL: u32 = 27u32;
pub const PROTECTED_POOL: u32 = 0u32;
pub const PS_IMAGE_NOTIFY_CONFLICTING_ARCHITECTURE: u32 = 1u32;
pub const PS_INVALID_SILO_CONTEXT_SLOT: u32 = 4294967295u32;
pub const PTE_BASE: u32 = 3221225472u32;
pub const PTE_PER_PAGE: u32 = 512u32;
pub const PTE_TOP: u32 = 3225419775u32;
pub const PTI_SHIFT: u32 = 12u32;
pub const PageIn: KWAIT_REASON = KWAIT_REASON(2i32);
pub const ParallelController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(20i32);
pub const PciAcsBitDisable: PCI_ACS_BIT = PCI_ACS_BIT(2i32);
pub const PciAcsBitDontCare: PCI_ACS_BIT = PCI_ACS_BIT(3i32);
pub const PciAcsBitEnable: PCI_ACS_BIT = PCI_ACS_BIT(1i32);
pub const PciAcsReserved: PCI_ACS_BIT = PCI_ACS_BIT(0i32);
pub const PciAddressParityError: u16 = 6u16;
pub const PciBusDataParityError: u16 = 1u16;
pub const PciBusMasterAbort: u16 = 3u16;
pub const PciBusSystemError: u16 = 2u16;
pub const PciBusTimeOut: u16 = 4u16;
pub const PciBusUnknownError: u16 = 0u16;
pub const PciCommandParityError: u16 = 7u16;
pub const PciConventional: PCI_HARDWARE_INTERFACE = PCI_HARDWARE_INTERFACE(0i32);
pub const PciDeviceD3Cold_Reason_Default_State_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(8i32);
pub const PciDeviceD3Cold_Reason_INF_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(9i32);
pub const PciDeviceD3Cold_Reason_Interface_Api_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(10i32);
pub const PciDeviceD3Cold_State_Disabled_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(1i32);
pub const PciDeviceD3Cold_State_Disabled_Bridge_HackFlags_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(4i32);
pub const PciDeviceD3Cold_State_Enabled_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(2i32);
pub const PciDeviceD3Cold_State_ParentRootPortS0WakeSupported_BitIndex: PCI_DEVICE_D3COLD_STATE_REASON = PCI_DEVICE_D3COLD_STATE_REASON(3i32);
pub const PciExpress: PCI_HARDWARE_INTERFACE = PCI_HARDWARE_INTERFACE(3i32);
pub const PciExpressASPMLinkSubState_L11_BitIndex: PCI_EXPRESS_LINK_SUBSTATE = PCI_EXPRESS_LINK_SUBSTATE(2i32);
pub const PciExpressASPMLinkSubState_L12_BitIndex: PCI_EXPRESS_LINK_SUBSTATE = PCI_EXPRESS_LINK_SUBSTATE(3i32);
pub const PciExpressDownstreamSwitchPort: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(6i32);
pub const PciExpressEndpoint: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(0i32);
pub const PciExpressLegacyEndpoint: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(1i32);
pub const PciExpressPciPmLinkSubState_L11_BitIndex: PCI_EXPRESS_LINK_SUBSTATE = PCI_EXPRESS_LINK_SUBSTATE(0i32);
pub const PciExpressPciPmLinkSubState_L12_BitIndex: PCI_EXPRESS_LINK_SUBSTATE = PCI_EXPRESS_LINK_SUBSTATE(1i32);
pub const PciExpressRootComplexEventCollector: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(10i32);
pub const PciExpressRootComplexIntegratedEndpoint: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(9i32);
pub const PciExpressRootPort: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(4i32);
pub const PciExpressToPciXBridge: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(7i32);
pub const PciExpressUpstreamSwitchPort: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(5i32);
pub const PciMasterDataParityError: u16 = 5u16;
pub const PciXMode1: PCI_HARDWARE_INTERFACE = PCI_HARDWARE_INTERFACE(1i32);
pub const PciXMode2: PCI_HARDWARE_INTERFACE = PCI_HARDWARE_INTERFACE(2i32);
pub const PciXToExpressBridge: PCI_EXPRESS_DEVICE_TYPE = PCI_EXPRESS_DEVICE_TYPE(8i32);
pub const PcwCallbackAddCounter: PCW_CALLBACK_TYPE = PCW_CALLBACK_TYPE(0i32);
pub const PcwCallbackCollectData: PCW_CALLBACK_TYPE = PCW_CALLBACK_TYPE(3i32);
pub const PcwCallbackEnumerateInstances: PCW_CALLBACK_TYPE = PCW_CALLBACK_TYPE(2i32);
pub const PcwCallbackRemoveCounter: PCW_CALLBACK_TYPE = PCW_CALLBACK_TYPE(1i32);
pub const PcwRegistrationNone: PCW_REGISTRATION_FLAGS = PCW_REGISTRATION_FLAGS(0i32);
pub const PcwRegistrationSiloNeutral: PCW_REGISTRATION_FLAGS = PCW_REGISTRATION_FLAGS(1i32);
pub const PermissionFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(4i32);
pub const PlatformLevelDeviceReset: DEVICE_RESET_TYPE = DEVICE_RESET_TYPE(1i32);
pub const PlatformRoleAppliancePC: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(6i32);
pub const PlatformRoleDesktop: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(1i32);
pub const PlatformRoleEnterpriseServer: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(4i32);
pub const PlatformRoleMaximum: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(9i32);
pub const PlatformRoleMobile: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(2i32);
pub const PlatformRolePerformanceServer: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(7i32);
pub const PlatformRoleSOHOServer: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(5i32);
pub const PlatformRoleSlate: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(8i32);
pub const PlatformRoleUnspecified: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(0i32);
pub const PlatformRoleWorkstation: POWER_PLATFORM_ROLE = POWER_PLATFORM_ROLE(3i32);
pub const PoAc: SYSTEM_POWER_CONDITION = SYSTEM_POWER_CONDITION(0i32);
pub const PoConditionMaximum: SYSTEM_POWER_CONDITION = SYSTEM_POWER_CONDITION(3i32);
pub const PoDc: SYSTEM_POWER_CONDITION = SYSTEM_POWER_CONDITION(1i32);
pub const PoFxPerfStateTypeDiscrete: PO_FX_PERF_STATE_TYPE = PO_FX_PERF_STATE_TYPE(0i32);
pub const PoFxPerfStateTypeMaximum: PO_FX_PERF_STATE_TYPE = PO_FX_PERF_STATE_TYPE(2i32);
pub const PoFxPerfStateTypeRange: PO_FX_PERF_STATE_TYPE = PO_FX_PERF_STATE_TYPE(1i32);
pub const PoFxPerfStateUnitBandwidth: PO_FX_PERF_STATE_UNIT = PO_FX_PERF_STATE_UNIT(2i32);
pub const PoFxPerfStateUnitFrequency: PO_FX_PERF_STATE_UNIT = PO_FX_PERF_STATE_UNIT(1i32);
pub const PoFxPerfStateUnitMaximum: PO_FX_PERF_STATE_UNIT = PO_FX_PERF_STATE_UNIT(3i32);
pub const PoFxPerfStateUnitOther: PO_FX_PERF_STATE_UNIT = PO_FX_PERF_STATE_UNIT(0i32);
pub const PoHot: SYSTEM_POWER_CONDITION = SYSTEM_POWER_CONDITION(2i32);
pub const PoThermalRequestActive: PO_THERMAL_REQUEST_TYPE = PO_THERMAL_REQUEST_TYPE(1i32);
pub const PoThermalRequestPassive: PO_THERMAL_REQUEST_TYPE = PO_THERMAL_REQUEST_TYPE(0i32);
pub const PointerController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(21i32);
pub const PointerPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(31i32);
pub const PoolAllocation: KWAIT_REASON = KWAIT_REASON(3i32);
pub const PoolExtendedParameterInvalidType: POOL_EXTENDED_PARAMETER_TYPE = POOL_EXTENDED_PARAMETER_TYPE(0i32);
pub const PoolExtendedParameterMax: POOL_EXTENDED_PARAMETER_TYPE = POOL_EXTENDED_PARAMETER_TYPE(4i32);
pub const PoolExtendedParameterNumaNode: POOL_EXTENDED_PARAMETER_TYPE = POOL_EXTENDED_PARAMETER_TYPE(3i32);
pub const PoolExtendedParameterPriority: POOL_EXTENDED_PARAMETER_TYPE = POOL_EXTENDED_PARAMETER_TYPE(1i32);
pub const PoolExtendedParameterSecurePool: POOL_EXTENDED_PARAMETER_TYPE = POOL_EXTENDED_PARAMETER_TYPE(2i32);
pub const Pos: BUS_DATA_TYPE = BUS_DATA_TYPE(2i32);
pub const PowerOff: PCI_EXPRESS_POWER_STATE = PCI_EXPRESS_POWER_STATE(1i32);
pub const PowerOn: PCI_EXPRESS_POWER_STATE = PCI_EXPRESS_POWER_STATE(0i32);
pub const PowerRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(2i32);
pub const PrimaryDcache: CONFIGURATION_TYPE = CONFIGURATION_TYPE(4i32);
pub const PrimaryIcache: CONFIGURATION_TYPE = CONFIGURATION_TYPE(3i32);
pub const PrinterPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(30i32);
pub const ProcessorInternal: INTERFACE_TYPE = INTERFACE_TYPE(12i32);
pub const Profile2Issue: KPROFILE_SOURCE = KPROFILE_SOURCE(15i32);
pub const Profile3Issue: KPROFILE_SOURCE = KPROFILE_SOURCE(16i32);
pub const Profile4Issue: KPROFILE_SOURCE = KPROFILE_SOURCE(17i32);
pub const ProfileAlignmentFixup: KPROFILE_SOURCE = KPROFILE_SOURCE(1i32);
pub const ProfileBranchInstructions: KPROFILE_SOURCE = KPROFILE_SOURCE(6i32);
pub const ProfileBranchMispredictions: KPROFILE_SOURCE = KPROFILE_SOURCE(11i32);
pub const ProfileCacheMisses: KPROFILE_SOURCE = KPROFILE_SOURCE(10i32);
pub const ProfileDcacheAccesses: KPROFILE_SOURCE = KPROFILE_SOURCE(21i32);
pub const ProfileDcacheMisses: KPROFILE_SOURCE = KPROFILE_SOURCE(8i32);
pub const ProfileFpInstructions: KPROFILE_SOURCE = KPROFILE_SOURCE(13i32);
pub const ProfileIcacheIssues: KPROFILE_SOURCE = KPROFILE_SOURCE(20i32);
pub const ProfileIcacheMisses: KPROFILE_SOURCE = KPROFILE_SOURCE(9i32);
pub const ProfileIntegerInstructions: KPROFILE_SOURCE = KPROFILE_SOURCE(14i32);
pub const ProfileLoadInstructions: KPROFILE_SOURCE = KPROFILE_SOURCE(4i32);
pub const ProfileLoadLinkedIssues: KPROFILE_SOURCE = KPROFILE_SOURCE(23i32);
pub const ProfileMaximum: KPROFILE_SOURCE = KPROFILE_SOURCE(24i32);
pub const ProfileMemoryBarrierCycles: KPROFILE_SOURCE = KPROFILE_SOURCE(22i32);
pub const ProfilePipelineDry: KPROFILE_SOURCE = KPROFILE_SOURCE(3i32);
pub const ProfilePipelineFrozen: KPROFILE_SOURCE = KPROFILE_SOURCE(5i32);
pub const ProfileSpecialInstructions: KPROFILE_SOURCE = KPROFILE_SOURCE(18i32);
pub const ProfileStoreInstructions: KPROFILE_SOURCE = KPROFILE_SOURCE(12i32);
pub const ProfileTime: KPROFILE_SOURCE = KPROFILE_SOURCE(0i32);
pub const ProfileTotalCycles: KPROFILE_SOURCE = KPROFILE_SOURCE(19i32);
pub const ProfileTotalIssues: KPROFILE_SOURCE = KPROFILE_SOURCE(2i32);
pub const ProfileTotalNonissues: KPROFILE_SOURCE = KPROFILE_SOURCE(7i32);
pub const PsCreateProcessNotifySubsystems: PSCREATEPROCESSNOTIFYTYPE = PSCREATEPROCESSNOTIFYTYPE(0i32);
pub const PsCreateThreadNotifyNonSystem: PSCREATETHREADNOTIFYTYPE = PSCREATETHREADNOTIFYTYPE(0i32);
pub const PsCreateThreadNotifySubsystems: PSCREATETHREADNOTIFYTYPE = PSCREATETHREADNOTIFYTYPE(1i32);
pub const PshedFADiscovery: u32 = 1u32;
pub const PshedFAErrorInfoRetrieval: u32 = 8u32;
pub const PshedFAErrorInjection: u32 = 32u32;
pub const PshedFAErrorRecordPersistence: u32 = 4u32;
pub const PshedFAErrorRecovery: u32 = 16u32;
pub const PshedFAErrorSourceControl: u32 = 2u32;
pub const PshedPiEnableNotifyErrorCreateNotifyEvent: WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS = WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS(1i32);
pub const PshedPiEnableNotifyErrorCreateSystemThread: WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS = WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS(2i32);
pub const PshedPiEnableNotifyErrorMax: WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS = WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS(3i32);
pub const PshedPiErrReadingPcieOverridesBadSignature: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(4i32);
pub const PshedPiErrReadingPcieOverridesBadSize: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(3i32);
pub const PshedPiErrReadingPcieOverridesNoCapOffset: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(5i32);
pub const PshedPiErrReadingPcieOverridesNoErr: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(0i32);
pub const PshedPiErrReadingPcieOverridesNoMemory: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(1i32);
pub const PshedPiErrReadingPcieOverridesNotBinary: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(6i32);
pub const PshedPiErrReadingPcieOverridesQueryErr: PSHED_PI_ERR_READING_PCIE_OVERRIDES = PSHED_PI_ERR_READING_PCIE_OVERRIDES(2i32);
pub const QuerySecurityDescriptor: SECURITY_OPERATION_CODE = SECURITY_OPERATION_CODE(1i32);
pub const RCB128Bytes: PCI_EXPRESS_RCB = PCI_EXPRESS_RCB(1i32);
pub const RCB64Bytes: PCI_EXPRESS_RCB = PCI_EXPRESS_RCB(0i32);
pub const RECOVERY_INFO_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc34832a1_02c3_4c52_a9f1_9f1d5d7723fc);
pub const RESOURCE_HASH_TABLE_SIZE: u32 = 64u32;
pub const RESULT_NEGATIVE: u32 = 1u32;
pub const RESULT_POSITIVE: u32 = 2u32;
pub const RESULT_ZERO: u32 = 0u32;
pub const ROOT_CMD_ENABLE_CORRECTABLE_ERROR_REPORTING: u32 = 1u32;
pub const ROOT_CMD_ENABLE_FATAL_ERROR_REPORTING: u32 = 4u32;
pub const ROOT_CMD_ENABLE_NONFATAL_ERROR_REPORTING: u32 = 2u32;
pub const RTL_GUID_STRING_SIZE: u32 = 38u32;
pub const RTL_HASH_ALLOCATED_HEADER: u32 = 1u32;
pub const RTL_HASH_RESERVED_SIGNATURE: u32 = 0u32;
pub const RTL_QUERY_REGISTRY_DELETE: u32 = 64u32;
pub const RTL_QUERY_REGISTRY_DIRECT: u32 = 32u32;
pub const RTL_QUERY_REGISTRY_NOEXPAND: u32 = 16u32;
pub const RTL_QUERY_REGISTRY_NOSTRING: u32 = 128u32;
pub const RTL_QUERY_REGISTRY_NOVALUE: u32 = 8u32;
pub const RTL_QUERY_REGISTRY_REQUIRED: u32 = 4u32;
pub const RTL_QUERY_REGISTRY_SUBKEY: u32 = 1u32;
pub const RTL_QUERY_REGISTRY_TOPKEY: u32 = 2u32;
pub const RTL_QUERY_REGISTRY_TYPECHECK: u32 = 256u32;
pub const RTL_QUERY_REGISTRY_TYPECHECK_SHIFT: u32 = 24u32;
pub const RTL_REGISTRY_ABSOLUTE: u32 = 0u32;
pub const RTL_REGISTRY_CONTROL: u32 = 2u32;
pub const RTL_REGISTRY_DEVICEMAP: u32 = 4u32;
pub const RTL_REGISTRY_HANDLE: u32 = 1073741824u32;
pub const RTL_REGISTRY_MAXIMUM: u32 = 6u32;
pub const RTL_REGISTRY_OPTIONAL: u32 = 2147483648u32;
pub const RTL_REGISTRY_SERVICES: u32 = 1u32;
pub const RTL_REGISTRY_USER: u32 = 5u32;
pub const RTL_REGISTRY_WINDOWS_NT: u32 = 3u32;
pub const RTL_STACK_WALKING_MODE_FRAMES_TO_SKIP_SHIFT: u32 = 8u32;
pub const RandomAccess: IO_ACCESS_MODE = IO_ACCESS_MODE(1i32);
pub const ReadAccess: IO_ACCESS_TYPE = IO_ACCESS_TYPE(0i32);
pub const RealModeIrqRoutingTable: CONFIGURATION_TYPE = CONFIGURATION_TYPE(39i32);
pub const RealModePCIEnumeration: CONFIGURATION_TYPE = CONFIGURATION_TYPE(40i32);
pub const RealTimeWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(5i32);
pub const RebuildControl: NPEM_CONTROL_STANDARD_CONTROL_BIT = NPEM_CONTROL_STANDARD_CONTROL_BIT(5i32);
pub const RegNtCallbackObjectContextCleanup: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(40i32);
pub const RegNtDeleteKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(0i32);
pub const RegNtDeleteValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(2i32);
pub const RegNtEnumerateKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(5i32);
pub const RegNtEnumerateValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(6i32);
pub const RegNtKeyHandleClose: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(14i32);
pub const RegNtPostCreateKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(11i32);
pub const RegNtPostCreateKeyEx: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(27i32);
pub const RegNtPostDeleteKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(15i32);
pub const RegNtPostDeleteValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(17i32);
pub const RegNtPostEnumerateKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(20i32);
pub const RegNtPostEnumerateValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(21i32);
pub const RegNtPostFlushKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(31i32);
pub const RegNtPostKeyHandleClose: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(25i32);
pub const RegNtPostLoadKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(33i32);
pub const RegNtPostOpenKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(13i32);
pub const RegNtPostOpenKeyEx: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(29i32);
pub const RegNtPostQueryKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(22i32);
pub const RegNtPostQueryKeyName: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(48i32);
pub const RegNtPostQueryKeySecurity: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(37i32);
pub const RegNtPostQueryMultipleValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(24i32);
pub const RegNtPostQueryValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(23i32);
pub const RegNtPostRenameKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(19i32);
pub const RegNtPostReplaceKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(46i32);
pub const RegNtPostRestoreKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(42i32);
pub const RegNtPostSaveKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(44i32);
pub const RegNtPostSaveMergedKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(50i32);
pub const RegNtPostSetInformationKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(18i32);
pub const RegNtPostSetKeySecurity: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(39i32);
pub const RegNtPostSetValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(16i32);
pub const RegNtPostUnLoadKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(35i32);
pub const RegNtPreCreateKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(10i32);
pub const RegNtPreCreateKeyEx: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(26i32);
pub const RegNtPreDeleteKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(0i32);
pub const RegNtPreDeleteValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(2i32);
pub const RegNtPreEnumerateKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(5i32);
pub const RegNtPreEnumerateValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(6i32);
pub const RegNtPreFlushKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(30i32);
pub const RegNtPreKeyHandleClose: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(14i32);
pub const RegNtPreLoadKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(32i32);
pub const RegNtPreOpenKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(12i32);
pub const RegNtPreOpenKeyEx: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(28i32);
pub const RegNtPreQueryKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(7i32);
pub const RegNtPreQueryKeyName: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(47i32);
pub const RegNtPreQueryKeySecurity: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(36i32);
pub const RegNtPreQueryMultipleValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(9i32);
pub const RegNtPreQueryValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(8i32);
pub const RegNtPreRenameKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(4i32);
pub const RegNtPreReplaceKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(45i32);
pub const RegNtPreRestoreKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(41i32);
pub const RegNtPreSaveKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(43i32);
pub const RegNtPreSaveMergedKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(49i32);
pub const RegNtPreSetInformationKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(3i32);
pub const RegNtPreSetKeySecurity: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(38i32);
pub const RegNtPreSetValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(1i32);
pub const RegNtPreUnLoadKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(34i32);
pub const RegNtQueryKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(7i32);
pub const RegNtQueryMultipleValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(9i32);
pub const RegNtQueryValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(8i32);
pub const RegNtRenameKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(4i32);
pub const RegNtSetInformationKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(3i32);
pub const RegNtSetValueKey: REG_NOTIFY_CLASS = REG_NOTIFY_CLASS(1i32);
pub const RemovalPolicyExpectNoRemoval: DEVICE_REMOVAL_POLICY = DEVICE_REMOVAL_POLICY(1i32);
pub const RemovalPolicyExpectOrderlyRemoval: DEVICE_REMOVAL_POLICY = DEVICE_REMOVAL_POLICY(2i32);
pub const RemovalPolicyExpectSurpriseRemoval: DEVICE_REMOVAL_POLICY = DEVICE_REMOVAL_POLICY(3i32);
pub const RemovalRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(3i32);
pub const ResourceNeverExclusive: u32 = 16u32;
pub const ResourceOwnedExclusive: u32 = 128u32;
pub const ResourceReleaseByOtherThread: u32 = 32u32;
pub const ResourceTypeEventBuffer: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(4i32);
pub const ResourceTypeExtendedCounterConfiguration: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(2i32);
pub const ResourceTypeIdenitificationTag: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(5i32);
pub const ResourceTypeMax: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(6i32);
pub const ResourceTypeOverflow: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(3i32);
pub const ResourceTypeRange: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(1i32);
pub const ResourceTypeSingle: PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE = PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(0i32);
pub const ResultNegative: INTERLOCKED_RESULT = INTERLOCKED_RESULT(32768i32);
pub const ResultPositive: INTERLOCKED_RESULT = INTERLOCKED_RESULT(0i32);
pub const ResultZero: INTERLOCKED_RESULT = INTERLOCKED_RESULT(16384i32);
pub const SCI_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe9d59197_94ee_4a4f_8ad8_9b7d8bd93d2e);
pub const SDEV_IDENTIFIER_INTERFACE_VERSION: u32 = 1u32;
pub const SEA_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9a78788a_bbe8_11e4_809e_67611e5d46b0);
pub const SEA_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf5fe48a6_84ce_4c1e_aa64_20c9a53099f1);
pub const SECTION_MAP_EXECUTE: u32 = 8u32;
pub const SECTION_MAP_EXECUTE_EXPLICIT: u32 = 32u32;
pub const SECTION_MAP_READ: u32 = 4u32;
pub const SECTION_MAP_WRITE: u32 = 2u32;
pub const SECTION_QUERY: u32 = 1u32;
pub const SECURE_DRIVER_INTERFACE_VERSION: u32 = 1u32;
pub const SECURE_POOL_FLAGS_FREEABLE: u32 = 1u32;
pub const SECURE_POOL_FLAGS_MODIFIABLE: u32 = 2u32;
pub const SECURE_POOL_FLAGS_NONE: u32 = 0u32;
pub const SECURE_SECTION_ALLOW_PARTIAL_MDL: u32 = 1u32;
pub const SEC_LARGE_PAGES: u32 = 2147483648u32;
pub const SEH_VALIDATION_POLICY_DEFER: u32 = 3u32;
pub const SEH_VALIDATION_POLICY_OFF: u32 = 1u32;
pub const SEH_VALIDATION_POLICY_ON: u32 = 0u32;
pub const SEH_VALIDATION_POLICY_TELEMETRY: u32 = 2u32;
pub const SEI_NOTIFY_TYPE_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5c284c81_b0ae_4e87_a322_b04c85624323);
pub const SEI_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf2a4a152_9c6d_4020_aecf_7695b389251b);
pub const SEMAPHORE_QUERY_STATE: u32 = 1u32;
pub const SE_ASSIGNPRIMARYTOKEN_PRIVILEGE: i32 = 3i32;
pub const SE_AUDIT_PRIVILEGE: i32 = 21i32;
pub const SE_BACKUP_PRIVILEGE: i32 = 17i32;
pub const SE_CHANGE_NOTIFY_PRIVILEGE: i32 = 23i32;
pub const SE_CREATE_GLOBAL_PRIVILEGE: i32 = 30i32;
pub const SE_CREATE_PAGEFILE_PRIVILEGE: i32 = 15i32;
pub const SE_CREATE_PERMANENT_PRIVILEGE: i32 = 16i32;
pub const SE_CREATE_SYMBOLIC_LINK_PRIVILEGE: i32 = 35i32;
pub const SE_CREATE_TOKEN_PRIVILEGE: i32 = 2i32;
pub const SE_DEBUG_PRIVILEGE: i32 = 20i32;
pub const SE_DELEGATE_SESSION_USER_IMPERSONATE_PRIVILEGE: i32 = 36i32;
pub const SE_ENABLE_DELEGATION_PRIVILEGE: i32 = 27i32;
pub const SE_IMPERSONATE_PRIVILEGE: i32 = 29i32;
pub const SE_INCREASE_QUOTA_PRIVILEGE: i32 = 5i32;
pub const SE_INC_BASE_PRIORITY_PRIVILEGE: i32 = 14i32;
pub const SE_INC_WORKING_SET_PRIVILEGE: i32 = 33i32;
pub const SE_LOAD_DRIVER_PRIVILEGE: i32 = 10i32;
pub const SE_LOCK_MEMORY_PRIVILEGE: i32 = 4i32;
pub const SE_MACHINE_ACCOUNT_PRIVILEGE: i32 = 6i32;
pub const SE_MANAGE_VOLUME_PRIVILEGE: i32 = 28i32;
pub const SE_MAX_WELL_KNOWN_PRIVILEGE: i32 = 36i32;
pub const SE_MIN_WELL_KNOWN_PRIVILEGE: i32 = 2i32;
pub const SE_PROF_SINGLE_PROCESS_PRIVILEGE: i32 = 13i32;
pub const SE_RELABEL_PRIVILEGE: i32 = 32i32;
pub const SE_REMOTE_SHUTDOWN_PRIVILEGE: i32 = 24i32;
pub const SE_RESTORE_PRIVILEGE: i32 = 18i32;
pub const SE_SECURITY_PRIVILEGE: i32 = 8i32;
pub const SE_SHUTDOWN_PRIVILEGE: i32 = 19i32;
pub const SE_SYNC_AGENT_PRIVILEGE: i32 = 26i32;
pub const SE_SYSTEMTIME_PRIVILEGE: i32 = 12i32;
pub const SE_SYSTEM_ENVIRONMENT_PRIVILEGE: i32 = 22i32;
pub const SE_SYSTEM_PROFILE_PRIVILEGE: i32 = 11i32;
pub const SE_TAKE_OWNERSHIP_PRIVILEGE: i32 = 9i32;
pub const SE_TCB_PRIVILEGE: i32 = 7i32;
pub const SE_TIME_ZONE_PRIVILEGE: i32 = 34i32;
pub const SE_TRUSTED_CREDMAN_ACCESS_PRIVILEGE: i32 = 31i32;
pub const SE_UNDOCK_PRIVILEGE: i32 = 25i32;
pub const SE_UNSOLICITED_INPUT_PRIVILEGE: i32 = 6i32;
pub const SHARED_GLOBAL_FLAGS_CLEAR_GLOBAL_DATA_FLAG: u32 = 2147483648u32;
pub const SHARED_GLOBAL_FLAGS_CONSOLE_BROKER_ENABLED_V: u32 = 6u32;
pub const SHARED_GLOBAL_FLAGS_DYNAMIC_PROC_ENABLED_V: u32 = 5u32;
pub const SHARED_GLOBAL_FLAGS_ELEVATION_ENABLED_V: u32 = 1u32;
pub const SHARED_GLOBAL_FLAGS_ERROR_PORT_V: u32 = 0u32;
pub const SHARED_GLOBAL_FLAGS_INSTALLER_DETECT_ENABLED_V: u32 = 3u32;
pub const SHARED_GLOBAL_FLAGS_LKG_ENABLED_V: u32 = 4u32;
pub const SHARED_GLOBAL_FLAGS_MULTIUSERS_IN_SESSION_SKU_V: u32 = 9u32;
pub const SHARED_GLOBAL_FLAGS_MULTI_SESSION_SKU_V: u32 = 8u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_A73_ERRATA: u32 = 64u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_DISABLE_32BIT: u32 = 4u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_ENABLED: u32 = 1u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_HV_PAGE: u32 = 2u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_LFENCE: u32 = 32u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_MFENCE: u32 = 16u32;
pub const SHARED_GLOBAL_FLAGS_QPC_BYPASS_USE_RDTSCP: u32 = 128u32;
pub const SHARED_GLOBAL_FLAGS_SECURE_BOOT_ENABLED_V: u32 = 7u32;
pub const SHARED_GLOBAL_FLAGS_SET_GLOBAL_DATA_FLAG: u32 = 1073741824u32;
pub const SHARED_GLOBAL_FLAGS_STATE_SEPARATION_ENABLED_V: u32 = 10u32;
pub const SHARED_GLOBAL_FLAGS_VIRT_ENABLED_V: u32 = 2u32;
pub const SHORT_LEAST_SIGNIFICANT_BIT: u32 = 0u32;
pub const SHORT_MOST_SIGNIFICANT_BIT: u32 = 1u32;
pub const SILO_MONITOR_REGISTRATION_VERSION: u32 = 1u32;
pub const SINGLE_GROUP_LEGACY_API: u32 = 1u32;
pub const SL_ALLOW_RAW_MOUNT: u32 = 1u32;
pub const SL_BYPASS_ACCESS_CHECK: u32 = 1u32;
pub const SL_BYPASS_IO: u32 = 64u32;
pub const SL_CASE_SENSITIVE: u32 = 128u32;
pub const SL_ERROR_RETURNED: u32 = 2u32;
pub const SL_EXCLUSIVE_LOCK: u32 = 2u32;
pub const SL_FAIL_IMMEDIATELY: u32 = 1u32;
pub const SL_FORCE_ACCESS_CHECK: u32 = 1u32;
pub const SL_FORCE_ASYNCHRONOUS: u32 = 1u32;
pub const SL_FORCE_DIRECT_WRITE: u32 = 16u32;
pub const SL_FT_SEQUENTIAL_WRITE: u32 = 8u32;
pub const SL_IGNORE_READONLY_ATTRIBUTE: u32 = 64u32;
pub const SL_INDEX_SPECIFIED: u32 = 4u32;
pub const SL_INFO_FORCE_ACCESS_CHECK: u32 = 1u32;
pub const SL_INFO_IGNORE_READONLY_ATTRIBUTE: u32 = 64u32;
pub const SL_INVOKE_ON_CANCEL: u32 = 32u32;
pub const SL_INVOKE_ON_ERROR: u32 = 128u32;
pub const SL_INVOKE_ON_SUCCESS: u32 = 64u32;
pub const SL_KEY_SPECIFIED: u32 = 1u32;
pub const SL_NO_CURSOR_UPDATE: u32 = 16u32;
pub const SL_OPEN_PAGING_FILE: u32 = 2u32;
pub const SL_OPEN_TARGET_DIRECTORY: u32 = 4u32;
pub const SL_OVERRIDE_VERIFY_VOLUME: u32 = 2u32;
pub const SL_PENDING_RETURNED: u32 = 1u32;
pub const SL_PERSISTENT_MEMORY_FIXED_MAPPING: u32 = 32u32;
pub const SL_QUERY_DIRECTORY_MASK: u32 = 27u32;
pub const SL_READ_ACCESS_GRANTED: u32 = 1u32;
pub const SL_REALTIME_STREAM: u32 = 32u32;
pub const SL_RESTART_SCAN: u32 = 1u32;
pub const SL_RETURN_ON_DISK_ENTRIES_ONLY: u32 = 8u32;
pub const SL_RETURN_SINGLE_ENTRY: u32 = 2u32;
pub const SL_STOP_ON_SYMLINK: u32 = 8u32;
pub const SL_WATCH_TREE: u32 = 1u32;
pub const SL_WRITE_ACCESS_GRANTED: u32 = 4u32;
pub const SL_WRITE_THROUGH: u32 = 4u32;
pub const SOC_SUBSYS_AUDIO_DSP: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(1i32);
pub const SOC_SUBSYS_COMPUTE_DSP: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(4i32);
pub const SOC_SUBSYS_SECURE_PROC: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(5i32);
pub const SOC_SUBSYS_SENSORS: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(3i32);
pub const SOC_SUBSYS_VENDOR_DEFINED: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(65536i32);
pub const SOC_SUBSYS_WIRELESS_MODEM: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(0i32);
pub const SOC_SUBSYS_WIRELSS_CONNECTIVITY: SOC_SUBSYSTEM_TYPE = SOC_SUBSYSTEM_TYPE(2i32);
pub const SSINFO_FLAGS_ALIGNED_DEVICE: u32 = 1u32;
pub const SSINFO_FLAGS_BYTE_ADDRESSABLE: u32 = 16u32;
pub const SSINFO_FLAGS_NO_SEEK_PENALTY: u32 = 4u32;
pub const SSINFO_FLAGS_PARTITION_ALIGNED_ON_DEVICE: u32 = 2u32;
pub const SSINFO_FLAGS_TRIM_ENABLED: u32 = 8u32;
pub const SSINFO_OFFSET_UNKNOWN: u32 = 4294967295u32;
pub const SYMBOLIC_LINK_QUERY: u32 = 1u32;
pub const SYMBOLIC_LINK_SET: u32 = 2u32;
pub const SYSTEM_CALL_INT_2E: u32 = 1u32;
pub const SYSTEM_CALL_SYSCALL: u32 = 0u32;
pub const ScsiAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(10i32);
pub const SeImageTypeDriver: SE_IMAGE_TYPE = SE_IMAGE_TYPE(1i32);
pub const SeImageTypeDynamicCodeFile: SE_IMAGE_TYPE = SE_IMAGE_TYPE(3i32);
pub const SeImageTypeElamDriver: SE_IMAGE_TYPE = SE_IMAGE_TYPE(0i32);
pub const SeImageTypeMax: SE_IMAGE_TYPE = SE_IMAGE_TYPE(4i32);
pub const SeImageTypePlatformSecureFile: SE_IMAGE_TYPE = SE_IMAGE_TYPE(2i32);
pub const SeImageVerificationCallbackInformational: SE_IMAGE_VERIFICATION_CALLBACK_TYPE = SE_IMAGE_VERIFICATION_CALLBACK_TYPE(0i32);
pub const SecondaryCache: CONFIGURATION_TYPE = CONFIGURATION_TYPE(7i32);
pub const SecondaryDcache: CONFIGURATION_TYPE = CONFIGURATION_TYPE(6i32);
pub const SecondaryIcache: CONFIGURATION_TYPE = CONFIGURATION_TYPE(5i32);
pub const SequentialAccess: IO_ACCESS_MODE = IO_ACCESS_MODE(0i32);
pub const SerialController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(17i32);
pub const SetSecurityDescriptor: SECURITY_OPERATION_CODE = SECURITY_OPERATION_CODE(0i32);
pub const SgiInternalConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(11i32);
pub const SharedInterruptTime: u32 = 4292804616u32;
pub const SharedSystemTime: u32 = 4292804628u32;
pub const SharedTickCount: u32 = 4292805408u32;
pub const SingleBusRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(5i32);
pub const SlotEmpty: PCI_EXPRESS_CARD_PRESENCE = PCI_EXPRESS_CARD_PRESENCE(0i32);
pub const StandardDesign: ALTERNATIVE_ARCHITECTURE_TYPE = ALTERNATIVE_ARCHITECTURE_TYPE(0i32);
pub const StopCompletion: IO_COMPLETION_ROUTINE_RESULT = IO_COMPLETION_ROUTINE_RESULT(-1073741802i32);
pub const SubsystemInformationTypeWSL: SUBSYSTEM_INFORMATION_TYPE = SUBSYSTEM_INFORMATION_TYPE(1i32);
pub const SubsystemInformationTypeWin32: SUBSYSTEM_INFORMATION_TYPE = SUBSYSTEM_INFORMATION_TYPE(0i32);
pub const SuperCriticalWorkQueue: WORK_QUEUE_TYPE = WORK_QUEUE_TYPE(6i32);
pub const Suspended: KWAIT_REASON = KWAIT_REASON(5i32);
pub const SystemFirmwareTable_Enumerate: SYSTEM_FIRMWARE_TABLE_ACTION = SYSTEM_FIRMWARE_TABLE_ACTION(0i32);
pub const SystemFirmwareTable_Get: SYSTEM_FIRMWARE_TABLE_ACTION = SYSTEM_FIRMWARE_TABLE_ACTION(1i32);
pub const SystemMemory: CONFIGURATION_TYPE = CONFIGURATION_TYPE(37i32);
pub const SystemMemoryPartitionDedicatedMemoryInformation: PARTITION_INFORMATION_CLASS = PARTITION_INFORMATION_CLASS(9i32);
pub const SystemMemoryPartitionInformation: PARTITION_INFORMATION_CLASS = PARTITION_INFORMATION_CLASS(0i32);
pub const SystemMemoryPartitionOpenDedicatedMemory: PARTITION_INFORMATION_CLASS = PARTITION_INFORMATION_CLASS(10i32);
pub const SystemPowerState: POWER_STATE_TYPE = POWER_STATE_TYPE(0i32);
pub const THREAD_ALERT: u32 = 4u32;
pub const THREAD_CSWITCH_PMU_DISABLE: u32 = 0u32;
pub const THREAD_CSWITCH_PMU_ENABLE: u32 = 1u32;
pub const THREAD_GET_CONTEXT: u32 = 8u32;
pub const THREAD_WAIT_OBJECTS: u32 = 3u32;
pub const TIMER_EXPIRED_INDEX_BITS: u32 = 6u32;
pub const TIMER_PROCESSOR_INDEX_BITS: u32 = 5u32;
pub const TIMER_TOLERABLE_DELAY_BITS: u32 = 6u32;
pub const TREE_CONNECT_NO_CLIENT_BUFFERING: u32 = 8u32;
pub const TREE_CONNECT_WRITE_THROUGH: u32 = 2u32;
pub const TXF_MINIVERSION_DEFAULT_VIEW: u32 = 65534u32;
pub const TableEmptyTree: TABLE_SEARCH_RESULT = TABLE_SEARCH_RESULT(0i32);
pub const TableFoundNode: TABLE_SEARCH_RESULT = TABLE_SEARCH_RESULT(1i32);
pub const TableInsertAsLeft: TABLE_SEARCH_RESULT = TABLE_SEARCH_RESULT(2i32);
pub const TableInsertAsRight: TABLE_SEARCH_RESULT = TABLE_SEARCH_RESULT(3i32);
pub const TapeController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(14i32);
pub const TapePeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(27i32);
pub const TargetDeviceRelation: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(4i32);
pub const TcAdapter: CONFIGURATION_TYPE = CONFIGURATION_TYPE(9i32);
pub const TerminalPeripheral: CONFIGURATION_TYPE = CONFIGURATION_TYPE(33i32);
pub const TimerSetCoalescableTimer: TIMER_SET_INFORMATION_CLASS = TIMER_SET_INFORMATION_CLASS(0i32);
pub const TlbMatchConflict: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(2i32);
pub const TraceEnableFlagsClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(2i32);
pub const TraceEnableLevelClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(3i32);
pub const TraceHandleByNameClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(7i32);
pub const TraceHandleClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(1i32);
pub const TraceIdClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(0i32);
pub const TraceInformationClassReserved1: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(12i32);
pub const TraceInformationClassReserved2: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(14i32);
pub const TraceSessionSettingsClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(9i32);
pub const TranslateChildToParent: RESOURCE_TRANSLATION_DIRECTION = RESOURCE_TRANSLATION_DIRECTION(0i32);
pub const TranslateParentToChild: RESOURCE_TRANSLATION_DIRECTION = RESOURCE_TRANSLATION_DIRECTION(1i32);
pub const TranslationFault: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(6i32);
pub const TransportRelations: DEVICE_RELATION_TYPE = DEVICE_RELATION_TYPE(6i32);
pub const TurboChannel: INTERFACE_TYPE = INTERFACE_TYPE(4i32);
pub const TypeA: DMA_SPEED = DMA_SPEED(1i32);
pub const TypeB: DMA_SPEED = DMA_SPEED(2i32);
pub const TypeC: DMA_SPEED = DMA_SPEED(3i32);
pub const TypeF: DMA_SPEED = DMA_SPEED(4i32);
pub const UADDRESS_BASE: u32 = 0u32;
pub const UnsupportedUpstreamTransaction: FAULT_INFORMATION_ARM64_TYPE = FAULT_INFORMATION_ARM64_TYPE(0i32);
pub const UserMode: MODE = MODE(1i32);
pub const UserNotPresent: POWER_USER_PRESENCE_TYPE = POWER_USER_PRESENCE_TYPE(0i32);
pub const UserPresent: POWER_USER_PRESENCE_TYPE = POWER_USER_PRESENCE_TYPE(1i32);
pub const UserRequest: KWAIT_REASON = KWAIT_REASON(6i32);
pub const UserUnknown: POWER_USER_PRESENCE_TYPE = POWER_USER_PRESENCE_TYPE(255i32);
pub const VMEBus: INTERFACE_TYPE = INTERFACE_TYPE(6i32);
pub const VMEConfiguration: BUS_DATA_TYPE = BUS_DATA_TYPE(5i32);
pub const VPB_DIRECT_WRITES_ALLOWED: u32 = 32u32;
pub const VPB_DISMOUNTING: u32 = 128u32;
pub const VPB_FLAGS_BYPASSIO_BLOCKED: u32 = 64u32;
pub const VPB_LOCKED: u32 = 2u32;
pub const VPB_MOUNTED: u32 = 1u32;
pub const VPB_PERSISTENT: u32 = 4u32;
pub const VPB_RAW_MOUNT: u32 = 16u32;
pub const VPB_REMOVE_PENDING: u32 = 8u32;
pub const ViewShare: SECTION_INHERIT = SECTION_INHERIT(1i32);
pub const ViewUnmap: SECTION_INHERIT = SECTION_INHERIT(2i32);
pub const Vmcs: INTERFACE_TYPE = INTERFACE_TYPE(16i32);
pub const WCS_RAS_REGISTER_NAME_MAX_LENGTH: u32 = 32u32;
pub const WDM_MAJORVERSION: u32 = 6u32;
pub const WDM_MINORVERSION: u32 = 0u32;
pub const WHEA_AMD_EXT_REG_NUM: u32 = 10u32;
pub const WHEA_BUSCHECK_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1cf3f8b3_c5b1_49a2_aa59_5eef92ffa63c);
pub const WHEA_CACHECHECK_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa55701f5_e3ef_43de_ac72_249b573fad2c);
pub const WHEA_DEVICE_ERROR_SUMMARY_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x990b31e9_541a_4db0_a42f_837d344f6923);
pub const WHEA_DPC_CAPABILITY_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xec49534b_30e7_4358_972f_eca6958fae3b);
pub const WHEA_ERROR_LOG_ENTRY_VERSION: u32 = 1u32;
pub const WHEA_ERROR_PACKET_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe71254e9_c1b9_4940_ab76_909703a4320f);
pub const WHEA_ERROR_PACKET_V1_VERSION: u32 = 2u32;
pub const WHEA_ERROR_PACKET_V2_VERSION: u32 = 3u32;
pub const WHEA_ERROR_PACKET_VERSION: u32 = 3u32;
pub const WHEA_ERROR_PKT_VERSION: u32 = 3u32;
pub const WHEA_ERROR_RECORD_FLAGS_DEVICE_DRIVER: u32 = 8u32;
pub const WHEA_ERROR_RECORD_FLAGS_PREVIOUSERROR: u32 = 2u32;
pub const WHEA_ERROR_RECORD_FLAGS_RECOVERED: u32 = 1u32;
pub const WHEA_ERROR_RECORD_FLAGS_SIMULATED: u32 = 4u32;
pub const WHEA_ERROR_RECORD_REVISION: u32 = 528u32;
pub const WHEA_ERROR_RECORD_SECTION_DESCRIPTOR_REVISION: u32 = 768u32;
pub const WHEA_ERROR_RECORD_SIGNATURE_END: u32 = 4294967295u32;
pub const WHEA_ERROR_RECORD_VALID_PARTITIONID: u32 = 4u32;
pub const WHEA_ERROR_RECORD_VALID_PLATFORMID: u32 = 1u32;
pub const WHEA_ERROR_RECORD_VALID_TIMESTAMP: u32 = 2u32;
pub const WHEA_ERROR_TEXT_LEN: u32 = 32u32;
pub const WHEA_ERR_SRC_OVERRIDE_FLAG: u32 = 1u32;
pub const WHEA_FIRMWARE_RECORD_TYPE_IPFSAL: u32 = 0u32;
pub const WHEA_GENERIC_ENTRY_TEXT_LEN: u32 = 20u32;
pub const WHEA_GENERIC_ENTRY_V2_VERSION: u32 = 768u32;
pub const WHEA_GENERIC_ENTRY_VERSION: u32 = 768u32;
pub const WHEA_INVALID_ERR_SRC_ID: u32 = 0u32;
pub const WHEA_IN_USE_PAGE_NOTIFY_FLAG_NOTIFYALL: u32 = 64u32;
pub const WHEA_IN_USE_PAGE_NOTIFY_FLAG_PAGEOFFLINED: u32 = 128u32;
pub const WHEA_IN_USE_PAGE_NOTIFY_FLAG_PLATFORMDIRECTED: u32 = 1u32;
pub const WHEA_MAX_LOG_DATA_LEN: u32 = 36u32;
pub const WHEA_MEMERRTYPE_INVALIDADDRESS: u32 = 10u32;
pub const WHEA_MEMERRTYPE_MASTERABORT: u32 = 6u32;
pub const WHEA_MEMERRTYPE_MEMORYSPARING: u32 = 12u32;
pub const WHEA_MEMERRTYPE_MIRRORBROKEN: u32 = 11u32;
pub const WHEA_MEMERRTYPE_MULTIBITECC: u32 = 3u32;
pub const WHEA_MEMERRTYPE_MULTISYMCHIPKILL: u32 = 5u32;
pub const WHEA_MEMERRTYPE_NOERROR: u32 = 1u32;
pub const WHEA_MEMERRTYPE_PARITYERROR: u32 = 8u32;
pub const WHEA_MEMERRTYPE_SINGLEBITECC: u32 = 2u32;
pub const WHEA_MEMERRTYPE_SINGLESYMCHIPKILL: u32 = 4u32;
pub const WHEA_MEMERRTYPE_TARGETABORT: u32 = 7u32;
pub const WHEA_MEMERRTYPE_UNKNOWN: u32 = 0u32;
pub const WHEA_MEMERRTYPE_WATCHDOGTIMEOUT: u32 = 9u32;
pub const WHEA_MSCHECK_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x48ab7f57_dc34_4f6c_a7d3_b0b5b0a74314);
pub const WHEA_PCIE_CORRECTABLE_ERROR_SECTION_COUNT_SIZE: u32 = 32u32;
pub const WHEA_PLUGIN_REGISTRATION_PACKET_V1: u32 = 65536u32;
pub const WHEA_PLUGIN_REGISTRATION_PACKET_V2: u32 = 131072u32;
pub const WHEA_PLUGIN_REGISTRATION_PACKET_VERSION: u32 = 131072u32;
pub const WHEA_PMEM_ERROR_SECTION_LOCATION_INFO_SIZE: u32 = 64u32;
pub const WHEA_PMEM_ERROR_SECTION_MAX_PAGES: u32 = 50u32;
pub const WHEA_RECORD_CREATOR_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcf07c4bd_b789_4e18_b3c4_1f732cb57131);
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_CONTAINMENTWRN: u32 = 2u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_FRU_TEXT_BY_PLUGIN: u32 = 128u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_LATENTERROR: u32 = 32u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_PRIMARY: u32 = 1u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_PROPAGATED: u32 = 64u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_RESET: u32 = 4u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_RESOURCENA: u32 = 16u32;
pub const WHEA_SECTION_DESCRIPTOR_FLAGS_THRESHOLDEXCEEDED: u32 = 8u32;
pub const WHEA_SECTION_DESCRIPTOR_REVISION: u32 = 768u32;
pub const WHEA_SEL_BUGCHECK_RECOVERY_STATUS_PHASE1_VERSION: u32 = 1u32;
pub const WHEA_TLBCHECK_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfc06b535_5e1f_4562_9f25_0a3b9adb63c3);
pub const WHEA_WRITE_FLAG_DUMMY: u32 = 1u32;
pub const WHEA_XPF_MCA_EXTREG_MAX_COUNT: u32 = 24u32;
pub const WHEA_XPF_MCA_SECTION_VERSION: u32 = 3u32;
pub const WHEA_XPF_MCA_SECTION_VERSION_2: u32 = 2u32;
pub const WHEA_XPF_MCA_SECTION_VERSION_3: u32 = 3u32;
pub const WMIREGISTER: u32 = 0u32;
pub const WMIREG_ACTION_BLOCK_IRPS: u32 = 5u32;
pub const WMIREG_ACTION_DEREGISTER: u32 = 2u32;
pub const WMIREG_ACTION_REGISTER: u32 = 1u32;
pub const WMIREG_ACTION_REREGISTER: u32 = 3u32;
pub const WMIREG_ACTION_UPDATE_GUIDS: u32 = 4u32;
pub const WMIUPDATE: u32 = 1u32;
pub const WdfNotifyRoutinesClass: TRACE_INFORMATION_CLASS = TRACE_INFORMATION_CLASS(15i32);
pub const WheaCpuVendorAmd: WHEA_CPU_VENDOR = WHEA_CPU_VENDOR(2i32);
pub const WheaCpuVendorIntel: WHEA_CPU_VENDOR = WHEA_CPU_VENDOR(1i32);
pub const WheaCpuVendorOther: WHEA_CPU_VENDOR = WHEA_CPU_VENDOR(0i32);
pub const WheaDataFormatGeneric: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(7i32);
pub const WheaDataFormatIPFSalRecord: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(0i32);
pub const WheaDataFormatMax: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(8i32);
pub const WheaDataFormatMemory: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(2i32);
pub const WheaDataFormatNMIPort: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(4i32);
pub const WheaDataFormatPCIExpress: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(3i32);
pub const WheaDataFormatPCIXBus: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(5i32);
pub const WheaDataFormatPCIXDevice: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(6i32);
pub const WheaDataFormatXPFMCA: WHEA_ERROR_PACKET_DATA_FORMAT = WHEA_ERROR_PACKET_DATA_FORMAT(1i32);
pub const WheaErrSevCorrected: WHEA_ERROR_SEVERITY = WHEA_ERROR_SEVERITY(2i32);
pub const WheaErrSevFatal: WHEA_ERROR_SEVERITY = WHEA_ERROR_SEVERITY(1i32);
pub const WheaErrSevInformational: WHEA_ERROR_SEVERITY = WHEA_ERROR_SEVERITY(3i32);
pub const WheaErrSevRecoverable: WHEA_ERROR_SEVERITY = WHEA_ERROR_SEVERITY(0i32);
pub const WheaErrTypeGeneric: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(6i32);
pub const WheaErrTypeMemory: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(1i32);
pub const WheaErrTypeNMI: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(3i32);
pub const WheaErrTypePCIExpress: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(2i32);
pub const WheaErrTypePCIXBus: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(4i32);
pub const WheaErrTypePCIXDevice: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(5i32);
pub const WheaErrTypePmem: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(7i32);
pub const WheaErrTypeProcessor: WHEA_ERROR_TYPE = WHEA_ERROR_TYPE(0i32);
pub const WheaEventBugCheckRecoveryEntry: WHEA_BUGCHECK_RECOVERY_LOG_TYPE = WHEA_BUGCHECK_RECOVERY_LOG_TYPE(0i32);
pub const WheaEventBugCheckRecoveryMax: WHEA_BUGCHECK_RECOVERY_LOG_TYPE = WHEA_BUGCHECK_RECOVERY_LOG_TYPE(2i32);
pub const WheaEventBugCheckRecoveryReturn: WHEA_BUGCHECK_RECOVERY_LOG_TYPE = WHEA_BUGCHECK_RECOVERY_LOG_TYPE(1i32);
pub const WheaEventLogAzccRootBusList: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483617i32);
pub const WheaEventLogAzccRootBusPoisonSet: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483602i32);
pub const WheaEventLogAzccRootBusSearchErr: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483618i32);
pub const WheaEventLogCmciFinalRestart: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483620i32);
pub const WheaEventLogCmciRestart: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483621i32);
pub const WheaEventLogEntryEarlyError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483594i32);
pub const WheaEventLogEntryEtwOverFlow: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483619i32);
pub const WheaEventLogEntryIdAcpiTimeOut: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483622i32);
pub const WheaEventLogEntryIdAddRemoveErrorSource: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483636i32);
pub const WheaEventLogEntryIdAerNotGrantedToOs: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483624i32);
pub const WheaEventLogEntryIdAttemptErrorRecovery: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483634i32);
pub const WheaEventLogEntryIdBadHestNotifyData: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483565i32);
pub const WheaEventLogEntryIdBadPageLimitReached: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483596i32);
pub const WheaEventLogEntryIdClearedPoison: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483630i32);
pub const WheaEventLogEntryIdCmcPollingTimeout: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483647i32);
pub const WheaEventLogEntryIdCmcSwitchToPolling: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483645i32);
pub const WheaEventLogEntryIdCmciImplPresent: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483608i32);
pub const WheaEventLogEntryIdCmciInitError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483607i32);
pub const WheaEventLogEntryIdCpuBusesInitFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483571i32);
pub const WheaEventLogEntryIdCpusFrozen: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483552i32);
pub const WheaEventLogEntryIdCpusFrozenNoCrashDump: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483551i32);
pub const WheaEventLogEntryIdCreateGenericRecord: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483627i32);
pub const WheaEventLogEntryIdDefectListCorrupt: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483566i32);
pub const WheaEventLogEntryIdDefectListFull: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483568i32);
pub const WheaEventLogEntryIdDefectListUEFIVarFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483567i32);
pub const WheaEventLogEntryIdDeviceDriver: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483609i32);
pub const WheaEventLogEntryIdDroppedCorrectedError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483644i32);
pub const WheaEventLogEntryIdDrvErrSrcInvalid: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483605i32);
pub const WheaEventLogEntryIdDrvHandleBusy: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483604i32);
pub const WheaEventLogEntryIdEnableKeyNotifFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483580i32);
pub const WheaEventLogEntryIdErrDimmInfoMismatch: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483600i32);
pub const WheaEventLogEntryIdErrSrcArrayInvalid: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483623i32);
pub const WheaEventLogEntryIdErrSrcInvalid: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483616i32);
pub const WheaEventLogEntryIdErrorRecord: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483626i32);
pub const WheaEventLogEntryIdErrorRecordLimit: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483625i32);
pub const WheaEventLogEntryIdFailedAddToDefectList: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483569i32);
pub const WheaEventLogEntryIdGenericErrMemMap: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483615i32);
pub const WheaEventLogEntryIdKeyNotificationFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483579i32);
pub const WheaEventLogEntryIdMcaErrorCleared: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483631i32);
pub const WheaEventLogEntryIdMcaFoundErrorInBank: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483633i32);
pub const WheaEventLogEntryIdMcaStuckErrorCheck: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483632i32);
pub const WheaEventLogEntryIdMemoryAddDevice: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483575i32);
pub const WheaEventLogEntryIdMemoryRemoveDevice: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483574i32);
pub const WheaEventLogEntryIdMemorySummaryFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483573i32);
pub const WheaEventLogEntryIdOscCapabilities: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483638i32);
pub const WheaEventLogEntryIdPFAMemoryOfflined: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483642i32);
pub const WheaEventLogEntryIdPFAMemoryPolicy: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483640i32);
pub const WheaEventLogEntryIdPFAMemoryRemoveMonitor: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483641i32);
pub const WheaEventLogEntryIdPcieAddDevice: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483577i32);
pub const WheaEventLogEntryIdPcieConfigInfo: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483591i32);
pub const WheaEventLogEntryIdPcieDpcError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483572i32);
pub const WheaEventLogEntryIdPcieOverrideInfo: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483593i32);
pub const WheaEventLogEntryIdPcieRemoveDevice: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483578i32);
pub const WheaEventLogEntryIdPcieSpuriousErrSource: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483576i32);
pub const WheaEventLogEntryIdPcieSummaryFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483584i32);
pub const WheaEventLogEntryIdProcessEINJ: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483629i32);
pub const WheaEventLogEntryIdProcessHEST: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483628i32);
pub const WheaEventLogEntryIdPshedCallbackCollision: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483614i32);
pub const WheaEventLogEntryIdPshedInjectError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483639i32);
pub const WheaEventLogEntryIdPshedPiTraceLog: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147221488i32);
pub const WheaEventLogEntryIdPshedPluginInitFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483570i32);
pub const WheaEventLogEntryIdPshedPluginLoad: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483612i32);
pub const WheaEventLogEntryIdPshedPluginRegister: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483637i32);
pub const WheaEventLogEntryIdPshedPluginSupported: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483610i32);
pub const WheaEventLogEntryIdPshedPluginUnload: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483611i32);
pub const WheaEventLogEntryIdReadPcieOverridesErr: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483592i32);
pub const WheaEventLogEntryIdRowFailure: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483561i32);
pub const WheaEventLogEntryIdSELBugCheckInfo: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483601i32);
pub const WheaEventLogEntryIdSELBugCheckProgress: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483613i32);
pub const WheaEventLogEntryIdSELBugCheckRecovery: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483606i32);
pub const WheaEventLogEntryIdSrasTableEntries: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483562i32);
pub const WheaEventLogEntryIdSrasTableError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483563i32);
pub const WheaEventLogEntryIdSrasTableNotFound: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483564i32);
pub const WheaEventLogEntryIdStartedReportHwError: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483643i32);
pub const WheaEventLogEntryIdThrottleAddErrSrcFailed: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483582i32);
pub const WheaEventLogEntryIdThrottleRegCorrupt: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483583i32);
pub const WheaEventLogEntryIdThrottleRegDataIgnored: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483581i32);
pub const WheaEventLogEntryIdWheaHeartbeat: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483603i32);
pub const WheaEventLogEntryIdWheaInit: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483646i32);
pub const WheaEventLogEntryIdWorkQueueItem: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483635i32);
pub const WheaEventLogEntryIdeDpcEnabled: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483599i32);
pub const WheaEventLogEntryPageOfflineDone: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483598i32);
pub const WheaEventLogEntryPageOfflinePendMax: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483597i32);
pub const WheaEventLogEntrySrarDetail: WHEA_EVENT_LOG_ENTRY_ID = WHEA_EVENT_LOG_ENTRY_ID(-2147483595i32);
pub const WheaEventLogEntryTypeError: WHEA_EVENT_LOG_ENTRY_TYPE = WHEA_EVENT_LOG_ENTRY_TYPE(2i32);
pub const WheaEventLogEntryTypeInformational: WHEA_EVENT_LOG_ENTRY_TYPE = WHEA_EVENT_LOG_ENTRY_TYPE(0i32);
pub const WheaEventLogEntryTypeWarning: WHEA_EVENT_LOG_ENTRY_TYPE = WHEA_EVENT_LOG_ENTRY_TYPE(1i32);
pub const WheaMemoryThrottle: WHEA_THROTTLE_TYPE = WHEA_THROTTLE_TYPE(1i32);
pub const WheaPciExpressDownstreamSwitchPort: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(6i32);
pub const WheaPciExpressEndpoint: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(0i32);
pub const WheaPciExpressLegacyEndpoint: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(1i32);
pub const WheaPciExpressRootComplexEventCollector: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(10i32);
pub const WheaPciExpressRootComplexIntegratedEndpoint: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(9i32);
pub const WheaPciExpressRootPort: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(4i32);
pub const WheaPciExpressToPciXBridge: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(7i32);
pub const WheaPciExpressUpstreamSwitchPort: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(5i32);
pub const WheaPciREcoveryStatusUnknown: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(0i32);
pub const WheaPciRecoverySignalAer: WHEA_PCI_RECOVERY_SIGNAL = WHEA_PCI_RECOVERY_SIGNAL(1i32);
pub const WheaPciRecoverySignalDpc: WHEA_PCI_RECOVERY_SIGNAL = WHEA_PCI_RECOVERY_SIGNAL(2i32);
pub const WheaPciRecoverySignalUnknown: WHEA_PCI_RECOVERY_SIGNAL = WHEA_PCI_RECOVERY_SIGNAL(0i32);
pub const WheaPciRecoveryStatusBusNotFound: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(6i32);
pub const WheaPciRecoveryStatusComplexTree: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(5i32);
pub const WheaPciRecoveryStatusLinkDisableTimeout: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(2i32);
pub const WheaPciRecoveryStatusLinkEnableTimeout: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(3i32);
pub const WheaPciRecoveryStatusNoError: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(1i32);
pub const WheaPciRecoveryStatusRpBusyTimeout: WHEA_PCI_RECOVERY_STATUS = WHEA_PCI_RECOVERY_STATUS(4i32);
pub const WheaPciXToExpressBridge: WHEA_PCIEXPRESS_DEVICE_TYPE = WHEA_PCIEXPRESS_DEVICE_TYPE(8i32);
pub const WheaPcieThrottle: WHEA_THROTTLE_TYPE = WHEA_THROTTLE_TYPE(0i32);
pub const WheaPfaRemoveCapacity: WHEA_PFA_REMOVE_TRIGGER = WHEA_PFA_REMOVE_TRIGGER(3i32);
pub const WheaPfaRemoveErrorThreshold: WHEA_PFA_REMOVE_TRIGGER = WHEA_PFA_REMOVE_TRIGGER(1i32);
pub const WheaPfaRemoveTimeout: WHEA_PFA_REMOVE_TRIGGER = WHEA_PFA_REMOVE_TRIGGER(2i32);
pub const WheaRawDataFormatAMD64MCA: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(3i32);
pub const WheaRawDataFormatGeneric: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(9i32);
pub const WheaRawDataFormatIA32MCA: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(1i32);
pub const WheaRawDataFormatIPFSalRecord: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(0i32);
pub const WheaRawDataFormatIntel64MCA: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(2i32);
pub const WheaRawDataFormatMax: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(10i32);
pub const WheaRawDataFormatMemory: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(4i32);
pub const WheaRawDataFormatNMIPort: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(6i32);
pub const WheaRawDataFormatPCIExpress: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(5i32);
pub const WheaRawDataFormatPCIXBus: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(7i32);
pub const WheaRawDataFormatPCIXDevice: WHEA_RAW_DATA_FORMAT = WHEA_RAW_DATA_FORMAT(8i32);
pub const WheaRecoveryContextErrorTypeMax: WHEA_RECOVERY_CONTEXT_ERROR_TYPE = WHEA_RECOVERY_CONTEXT_ERROR_TYPE(3i32);
pub const WheaRecoveryContextErrorTypeMemory: WHEA_RECOVERY_CONTEXT_ERROR_TYPE = WHEA_RECOVERY_CONTEXT_ERROR_TYPE(1i32);
pub const WheaRecoveryContextErrorTypePmem: WHEA_RECOVERY_CONTEXT_ERROR_TYPE = WHEA_RECOVERY_CONTEXT_ERROR_TYPE(2i32);
pub const WheaRecoveryFailureReasonFarNotValid: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(17i32);
pub const WheaRecoveryFailureReasonHighIrql: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(10i32);
pub const WheaRecoveryFailureReasonInsufficientAltContextWrappers: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(11i32);
pub const WheaRecoveryFailureReasonInterruptsDisabled: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(12i32);
pub const WheaRecoveryFailureReasonInvalidAddressMode: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(9i32);
pub const WheaRecoveryFailureReasonKernelCouldNotMarkMemoryBad: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(1i32);
pub const WheaRecoveryFailureReasonKernelMarkMemoryBadTimedOut: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(2i32);
pub const WheaRecoveryFailureReasonKernelWillPageFaultBCAtCurrentIrql: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(16i32);
pub const WheaRecoveryFailureReasonMax: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(18i32);
pub const WheaRecoveryFailureReasonMiscOrAddrNotValid: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(8i32);
pub const WheaRecoveryFailureReasonNoRecoveryContext: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(3i32);
pub const WheaRecoveryFailureReasonNotContinuable: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(4i32);
pub const WheaRecoveryFailureReasonNotSupported: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(7i32);
pub const WheaRecoveryFailureReasonOverflow: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(6i32);
pub const WheaRecoveryFailureReasonPcc: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(5i32);
pub const WheaRecoveryFailureReasonStackOverflow: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(14i32);
pub const WheaRecoveryFailureReasonSwapBusy: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(13i32);
pub const WheaRecoveryFailureReasonUnexpectedFailure: WHEA_RECOVERY_FAILURE_REASON = WHEA_RECOVERY_FAILURE_REASON(15i32);
pub const WheaRecoveryTypeActionOptional: WHEA_RECOVERY_TYPE = WHEA_RECOVERY_TYPE(2i32);
pub const WheaRecoveryTypeActionRequired: WHEA_RECOVERY_TYPE = WHEA_RECOVERY_TYPE(1i32);
pub const WheaRecoveryTypeMax: WHEA_RECOVERY_TYPE = WHEA_RECOVERY_TYPE(3i32);
pub const WheapDpcErrBusNotFound: WHEAP_DPC_ERROR_EVENT_TYPE = WHEAP_DPC_ERROR_EVENT_TYPE(1i32);
pub const WheapDpcErrDeviceIdBad: WHEAP_DPC_ERROR_EVENT_TYPE = WHEAP_DPC_ERROR_EVENT_TYPE(3i32);
pub const WheapDpcErrDpcedSubtree: WHEAP_DPC_ERROR_EVENT_TYPE = WHEAP_DPC_ERROR_EVENT_TYPE(2i32);
pub const WheapDpcErrNoChildren: WHEAP_DPC_ERROR_EVENT_TYPE = WHEAP_DPC_ERROR_EVENT_TYPE(5i32);
pub const WheapDpcErrNoErr: WHEAP_DPC_ERROR_EVENT_TYPE = WHEAP_DPC_ERROR_EVENT_TYPE(0i32);
pub const WheapDpcErrResetFailed: WHEAP_DPC_ERROR_EVENT_TYPE = WHEAP_DPC_ERROR_EVENT_TYPE(4i32);
pub const WheapPfaOfflinePredictiveFailure: WHEAP_PFA_OFFLINE_DECISION_TYPE = WHEAP_PFA_OFFLINE_DECISION_TYPE(1i32);
pub const WheapPfaOfflineUncorrectedError: WHEAP_PFA_OFFLINE_DECISION_TYPE = WHEAP_PFA_OFFLINE_DECISION_TYPE(2i32);
pub const Width16Bits: DMA_WIDTH = DMA_WIDTH(1i32);
pub const Width32Bits: DMA_WIDTH = DMA_WIDTH(2i32);
pub const Width64Bits: DMA_WIDTH = DMA_WIDTH(3i32);
pub const Width8Bits: DMA_WIDTH = DMA_WIDTH(0i32);
pub const WidthNoWrap: DMA_WIDTH = DMA_WIDTH(4i32);
pub const WormController: CONFIGURATION_TYPE = CONFIGURATION_TYPE(16i32);
pub const WrAlertByThreadId: KWAIT_REASON = KWAIT_REASON(37i32);
pub const WrCalloutStack: KWAIT_REASON = KWAIT_REASON(25i32);
pub const WrCpuRateControl: KWAIT_REASON = KWAIT_REASON(24i32);
pub const WrDeferredPreempt: KWAIT_REASON = KWAIT_REASON(38i32);
pub const WrDelayExecution: KWAIT_REASON = KWAIT_REASON(11i32);
pub const WrDispatchInt: KWAIT_REASON = KWAIT_REASON(31i32);
pub const WrExecutive: KWAIT_REASON = KWAIT_REASON(7i32);
pub const WrFastMutex: KWAIT_REASON = KWAIT_REASON(34i32);
pub const WrFreePage: KWAIT_REASON = KWAIT_REASON(8i32);
pub const WrGuardedMutex: KWAIT_REASON = KWAIT_REASON(35i32);
pub const WrIoRing: KWAIT_REASON = KWAIT_REASON(40i32);
pub const WrKernel: KWAIT_REASON = KWAIT_REASON(26i32);
pub const WrKeyedEvent: KWAIT_REASON = KWAIT_REASON(21i32);
pub const WrLpcReceive: KWAIT_REASON = KWAIT_REASON(16i32);
pub const WrLpcReply: KWAIT_REASON = KWAIT_REASON(17i32);
pub const WrMdlCache: KWAIT_REASON = KWAIT_REASON(41i32);
pub const WrMutex: KWAIT_REASON = KWAIT_REASON(29i32);
pub const WrPageIn: KWAIT_REASON = KWAIT_REASON(9i32);
pub const WrPageOut: KWAIT_REASON = KWAIT_REASON(19i32);
pub const WrPhysicalFault: KWAIT_REASON = KWAIT_REASON(39i32);
pub const WrPoolAllocation: KWAIT_REASON = KWAIT_REASON(10i32);
pub const WrPreempted: KWAIT_REASON = KWAIT_REASON(32i32);
pub const WrProcessInSwap: KWAIT_REASON = KWAIT_REASON(23i32);
pub const WrPushLock: KWAIT_REASON = KWAIT_REASON(28i32);
pub const WrQuantumEnd: KWAIT_REASON = KWAIT_REASON(30i32);
pub const WrQueue: KWAIT_REASON = KWAIT_REASON(15i32);
pub const WrRendezvous: KWAIT_REASON = KWAIT_REASON(20i32);
pub const WrResource: KWAIT_REASON = KWAIT_REASON(27i32);
pub const WrRundown: KWAIT_REASON = KWAIT_REASON(36i32);
pub const WrSpare0: KWAIT_REASON = KWAIT_REASON(14i32);
pub const WrSuspended: KWAIT_REASON = KWAIT_REASON(12i32);
pub const WrTerminated: KWAIT_REASON = KWAIT_REASON(22i32);
pub const WrUserRequest: KWAIT_REASON = KWAIT_REASON(13i32);
pub const WrVirtualMemory: KWAIT_REASON = KWAIT_REASON(18i32);
pub const WrYieldExecution: KWAIT_REASON = KWAIT_REASON(33i32);
pub const WriteAccess: IO_ACCESS_TYPE = IO_ACCESS_TYPE(1i32);
pub const XPF_BUS_CHECK_ADDRESS_IO: u32 = 2u32;
pub const XPF_BUS_CHECK_ADDRESS_MEMORY: u32 = 0u32;
pub const XPF_BUS_CHECK_ADDRESS_OTHER: u32 = 3u32;
pub const XPF_BUS_CHECK_ADDRESS_RESERVED: u32 = 1u32;
pub const XPF_BUS_CHECK_OPERATION_DATAREAD: u32 = 3u32;
pub const XPF_BUS_CHECK_OPERATION_DATAWRITE: u32 = 4u32;
pub const XPF_BUS_CHECK_OPERATION_GENERIC: u32 = 0u32;
pub const XPF_BUS_CHECK_OPERATION_GENREAD: u32 = 1u32;
pub const XPF_BUS_CHECK_OPERATION_GENWRITE: u32 = 2u32;
pub const XPF_BUS_CHECK_OPERATION_INSTRUCTIONFETCH: u32 = 5u32;
pub const XPF_BUS_CHECK_OPERATION_PREFETCH: u32 = 6u32;
pub const XPF_BUS_CHECK_PARTICIPATION_GENERIC: u32 = 3u32;
pub const XPF_BUS_CHECK_PARTICIPATION_PROCOBSERVED: u32 = 2u32;
pub const XPF_BUS_CHECK_PARTICIPATION_PROCORIGINATED: u32 = 0u32;
pub const XPF_BUS_CHECK_PARTICIPATION_PROCRESPONDED: u32 = 1u32;
pub const XPF_BUS_CHECK_TRANSACTIONTYPE_DATAACCESS: u32 = 1u32;
pub const XPF_BUS_CHECK_TRANSACTIONTYPE_GENERIC: u32 = 2u32;
pub const XPF_BUS_CHECK_TRANSACTIONTYPE_INSTRUCTION: u32 = 0u32;
pub const XPF_CACHE_CHECK_OPERATION_DATAREAD: u32 = 3u32;
pub const XPF_CACHE_CHECK_OPERATION_DATAWRITE: u32 = 4u32;
pub const XPF_CACHE_CHECK_OPERATION_EVICTION: u32 = 7u32;
pub const XPF_CACHE_CHECK_OPERATION_GENERIC: u32 = 0u32;
pub const XPF_CACHE_CHECK_OPERATION_GENREAD: u32 = 1u32;
pub const XPF_CACHE_CHECK_OPERATION_GENWRITE: u32 = 2u32;
pub const XPF_CACHE_CHECK_OPERATION_INSTRUCTIONFETCH: u32 = 5u32;
pub const XPF_CACHE_CHECK_OPERATION_PREFETCH: u32 = 6u32;
pub const XPF_CACHE_CHECK_OPERATION_SNOOP: u32 = 8u32;
pub const XPF_CACHE_CHECK_TRANSACTIONTYPE_DATAACCESS: u32 = 1u32;
pub const XPF_CACHE_CHECK_TRANSACTIONTYPE_GENERIC: u32 = 2u32;
pub const XPF_CACHE_CHECK_TRANSACTIONTYPE_INSTRUCTION: u32 = 0u32;
pub const XPF_CONTEXT_INFO_32BITCONTEXT: u32 = 2u32;
pub const XPF_CONTEXT_INFO_32BITDEBUGREGS: u32 = 5u32;
pub const XPF_CONTEXT_INFO_64BITCONTEXT: u32 = 3u32;
pub const XPF_CONTEXT_INFO_64BITDEBUGREGS: u32 = 6u32;
pub const XPF_CONTEXT_INFO_FXSAVE: u32 = 4u32;
pub const XPF_CONTEXT_INFO_MMREGISTERS: u32 = 7u32;
pub const XPF_CONTEXT_INFO_MSRREGISTERS: u32 = 1u32;
pub const XPF_CONTEXT_INFO_UNCLASSIFIEDDATA: u32 = 0u32;
pub const XPF_MCA_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8a1e1d01_42f9_4557_9c33_565e5cc3f7e8);
pub const XPF_MS_CHECK_ERRORTYPE_EXTERNAL: u32 = 3u32;
pub const XPF_MS_CHECK_ERRORTYPE_FRC: u32 = 4u32;
pub const XPF_MS_CHECK_ERRORTYPE_INTERNALUNCLASSIFIED: u32 = 5u32;
pub const XPF_MS_CHECK_ERRORTYPE_MCROMPARITY: u32 = 2u32;
pub const XPF_MS_CHECK_ERRORTYPE_NOERROR: u32 = 0u32;
pub const XPF_MS_CHECK_ERRORTYPE_UNCLASSIFIED: u32 = 1u32;
pub const XPF_PROCESSOR_ERROR_SECTION_GUID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdc3ea0b0_a144_4797_b95b_53fa242b6e1d);
pub const XPF_TLB_CHECK_OPERATION_DATAREAD: u32 = 3u32;
pub const XPF_TLB_CHECK_OPERATION_DATAWRITE: u32 = 4u32;
pub const XPF_TLB_CHECK_OPERATION_GENERIC: u32 = 0u32;
pub const XPF_TLB_CHECK_OPERATION_GENREAD: u32 = 1u32;
pub const XPF_TLB_CHECK_OPERATION_GENWRITE: u32 = 2u32;
pub const XPF_TLB_CHECK_OPERATION_INSTRUCTIONFETCH: u32 = 5u32;
pub const XPF_TLB_CHECK_OPERATION_PREFETCH: u32 = 6u32;
pub const XPF_TLB_CHECK_TRANSACTIONTYPE_DATAACCESS: u32 = 1u32;
pub const XPF_TLB_CHECK_TRANSACTIONTYPE_GENERIC: u32 = 2u32;
pub const XPF_TLB_CHECK_TRANSACTIONTYPE_INSTRUCTION: u32 = 0u32;
pub const _STRSAFE_USE_SECURE_CRT: u32 = 0u32;
pub const __guid_type: u32 = 8192u32;
pub const __multiString_type: u32 = 16384u32;
pub const __string_type: u32 = 4096u32;
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct ALTERNATIVE_ARCHITECTURE_TYPE(pub i32);
impl ::windows_core::TypeKind for ALTERNATIVE_ARCHITECTURE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for ALTERNATIVE_ARCHITECTURE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ALTERNATIVE_ARCHITECTURE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct ARBITER_ACTION(pub i32);
impl ::windows_core::TypeKind for ARBITER_ACTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for ARBITER_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ARBITER_ACTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct ARBITER_REQUEST_SOURCE(pub i32);
impl ::windows_core::TypeKind for ARBITER_REQUEST_SOURCE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for ARBITER_REQUEST_SOURCE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ARBITER_REQUEST_SOURCE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct ARBITER_RESULT(pub i32);
impl ::windows_core::TypeKind for ARBITER_RESULT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for ARBITER_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ARBITER_RESULT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct BDCB_CALLBACK_TYPE(pub i32);
impl ::windows_core::TypeKind for BDCB_CALLBACK_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BDCB_CALLBACK_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BDCB_CALLBACK_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct BDCB_CLASSIFICATION(pub i32);
impl ::windows_core::TypeKind for BDCB_CLASSIFICATION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BDCB_CLASSIFICATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BDCB_CLASSIFICATION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct BDCB_STATUS_UPDATE_TYPE(pub i32);
impl ::windows_core::TypeKind for BDCB_STATUS_UPDATE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BDCB_STATUS_UPDATE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BDCB_STATUS_UPDATE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct BOUND_CALLBACK_STATUS(pub i32);
impl ::windows_core::TypeKind for BOUND_CALLBACK_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BOUND_CALLBACK_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BOUND_CALLBACK_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct BUS_DATA_TYPE(pub i32);
impl ::windows_core::TypeKind for BUS_DATA_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BUS_DATA_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BUS_DATA_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct BUS_QUERY_ID_TYPE(pub i32);
impl ::windows_core::TypeKind for BUS_QUERY_ID_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BUS_QUERY_ID_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BUS_QUERY_ID_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct CM_SHARE_DISPOSITION(pub i32);
impl ::windows_core::TypeKind for CM_SHARE_DISPOSITION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CM_SHARE_DISPOSITION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_SHARE_DISPOSITION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct CONFIGURATION_TYPE(pub i32);
impl ::windows_core::TypeKind for CONFIGURATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CONFIGURATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CONFIGURATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct CREATE_FILE_TYPE(pub i32);
impl ::windows_core::TypeKind for CREATE_FILE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CREATE_FILE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREATE_FILE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct D3COLD_LAST_TRANSITION_STATUS(pub i32);
impl ::windows_core::TypeKind for D3COLD_LAST_TRANSITION_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for D3COLD_LAST_TRANSITION_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D3COLD_LAST_TRANSITION_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_DIRECTORY_TYPE(pub i32);
impl ::windows_core::TypeKind for DEVICE_DIRECTORY_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_DIRECTORY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_DIRECTORY_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_INSTALL_STATE(pub i32);
impl ::windows_core::TypeKind for DEVICE_INSTALL_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_INSTALL_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_INSTALL_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_REGISTRY_PROPERTY(pub i32);
impl ::windows_core::TypeKind for DEVICE_REGISTRY_PROPERTY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_REGISTRY_PROPERTY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_REGISTRY_PROPERTY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_RELATION_TYPE(pub i32);
impl ::windows_core::TypeKind for DEVICE_RELATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_RELATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_RELATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_REMOVAL_POLICY(pub i32);
impl ::windows_core::TypeKind for DEVICE_REMOVAL_POLICY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_REMOVAL_POLICY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_REMOVAL_POLICY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_RESET_TYPE(pub i32);
impl ::windows_core::TypeKind for DEVICE_RESET_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_RESET_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_RESET_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_TEXT_TYPE(pub i32);
impl ::windows_core::TypeKind for DEVICE_TEXT_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_TEXT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_TEXT_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_USAGE_NOTIFICATION_TYPE(pub i32);
impl ::windows_core::TypeKind for DEVICE_USAGE_NOTIFICATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_USAGE_NOTIFICATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_USAGE_NOTIFICATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DEVICE_WAKE_DEPTH(pub i32);
impl ::windows_core::TypeKind for DEVICE_WAKE_DEPTH {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DEVICE_WAKE_DEPTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEVICE_WAKE_DEPTH").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DIRECTORY_NOTIFY_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for DIRECTORY_NOTIFY_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DIRECTORY_NOTIFY_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DIRECTORY_NOTIFY_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE(pub i32);
impl ::windows_core::TypeKind for DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_ACCESS_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE(pub i32);
impl ::windows_core::TypeKind for DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DMA_COMMON_BUFFER_EXTENDED_CONFIGURATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DMA_COMPLETION_STATUS(pub i32);
impl ::windows_core::TypeKind for DMA_COMPLETION_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DMA_COMPLETION_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DMA_COMPLETION_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DMA_SPEED(pub i32);
impl ::windows_core::TypeKind for DMA_SPEED {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DMA_SPEED {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DMA_SPEED").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DMA_WIDTH(pub i32);
impl ::windows_core::TypeKind for DMA_WIDTH {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DMA_WIDTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DMA_WIDTH").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DOMAIN_CONFIGURATION_ARCH(pub i32);
impl ::windows_core::TypeKind for DOMAIN_CONFIGURATION_ARCH {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DOMAIN_CONFIGURATION_ARCH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DOMAIN_CONFIGURATION_ARCH").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DRIVER_DIRECTORY_TYPE(pub i32);
impl ::windows_core::TypeKind for DRIVER_DIRECTORY_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DRIVER_DIRECTORY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DRIVER_DIRECTORY_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DRIVER_REGKEY_TYPE(pub i32);
impl ::windows_core::TypeKind for DRIVER_REGKEY_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DRIVER_REGKEY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DRIVER_REGKEY_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct DRIVER_RUNTIME_INIT_FLAGS(pub i32);
impl ::windows_core::TypeKind for DRIVER_RUNTIME_INIT_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DRIVER_RUNTIME_INIT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DRIVER_RUNTIME_INIT_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct EXTENDED_AGP_REGISTER(pub i32);
impl ::windows_core::TypeKind for EXTENDED_AGP_REGISTER {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for EXTENDED_AGP_REGISTER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EXTENDED_AGP_REGISTER").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct EX_POOL_PRIORITY(pub i32);
impl ::windows_core::TypeKind for EX_POOL_PRIORITY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for EX_POOL_PRIORITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EX_POOL_PRIORITY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct FAULT_INFORMATION_ARCH(pub i32);
impl ::windows_core::TypeKind for FAULT_INFORMATION_ARCH {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for FAULT_INFORMATION_ARCH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FAULT_INFORMATION_ARCH").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct FAULT_INFORMATION_ARM64_TYPE(pub i32);
impl ::windows_core::TypeKind for FAULT_INFORMATION_ARM64_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for FAULT_INFORMATION_ARM64_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FAULT_INFORMATION_ARM64_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct HAL_APIC_DESTINATION_MODE(pub i32);
impl ::windows_core::TypeKind for HAL_APIC_DESTINATION_MODE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HAL_APIC_DESTINATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAL_APIC_DESTINATION_MODE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct HAL_DISPLAY_BIOS_INFORMATION(pub i32);
impl ::windows_core::TypeKind for HAL_DISPLAY_BIOS_INFORMATION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HAL_DISPLAY_BIOS_INFORMATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAL_DISPLAY_BIOS_INFORMATION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct HAL_DMA_CRASH_DUMP_REGISTER_TYPE(pub i32);
impl ::windows_core::TypeKind for HAL_DMA_CRASH_DUMP_REGISTER_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HAL_DMA_CRASH_DUMP_REGISTER_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAL_DMA_CRASH_DUMP_REGISTER_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct HAL_QUERY_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for HAL_QUERY_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HAL_QUERY_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAL_QUERY_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct HAL_SET_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for HAL_SET_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HAL_SET_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HAL_SET_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct HARDWARE_COUNTER_TYPE(pub i32);
impl ::windows_core::TypeKind for HARDWARE_COUNTER_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HARDWARE_COUNTER_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HARDWARE_COUNTER_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct INTEL_CACHE_TYPE(pub i32);
impl ::windows_core::TypeKind for INTEL_CACHE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for INTEL_CACHE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INTEL_CACHE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct INTERFACE_TYPE(pub i32);
impl ::windows_core::TypeKind for INTERFACE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for INTERFACE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INTERFACE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct INTERLOCKED_RESULT(pub i32);
impl ::windows_core::TypeKind for INTERLOCKED_RESULT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for INTERLOCKED_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("INTERLOCKED_RESULT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE(pub i32);
impl ::windows_core::TypeKind for IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOMMU_DEVICE_CREATION_CONFIGURATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IOMMU_DMA_DOMAIN_TYPE(pub i32);
impl ::windows_core::TypeKind for IOMMU_DMA_DOMAIN_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IOMMU_DMA_DOMAIN_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOMMU_DMA_DOMAIN_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE(pub i32);
impl ::windows_core::TypeKind for IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOMMU_DMA_LOGICAL_ALLOCATOR_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IOMMU_MAP_PHYSICAL_ADDRESS_TYPE(pub i32);
impl ::windows_core::TypeKind for IOMMU_MAP_PHYSICAL_ADDRESS_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IOMMU_MAP_PHYSICAL_ADDRESS_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOMMU_MAP_PHYSICAL_ADDRESS_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_ACCESS_MODE(pub i32);
impl ::windows_core::TypeKind for IO_ACCESS_MODE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_ACCESS_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_ACCESS_MODE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_ACCESS_TYPE(pub i32);
impl ::windows_core::TypeKind for IO_ACCESS_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_ACCESS_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_ACCESS_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_ALLOCATION_ACTION(pub i32);
impl ::windows_core::TypeKind for IO_ALLOCATION_ACTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_ALLOCATION_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_ALLOCATION_ACTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_COMPLETION_ROUTINE_RESULT(pub i32);
impl ::windows_core::TypeKind for IO_COMPLETION_ROUTINE_RESULT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_COMPLETION_ROUTINE_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_COMPLETION_ROUTINE_RESULT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_CONTAINER_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for IO_CONTAINER_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_CONTAINER_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_CONTAINER_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_CONTAINER_NOTIFICATION_CLASS(pub i32);
impl ::windows_core::TypeKind for IO_CONTAINER_NOTIFICATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_CONTAINER_NOTIFICATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_CONTAINER_NOTIFICATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_NOTIFICATION_EVENT_CATEGORY(pub i32);
impl ::windows_core::TypeKind for IO_NOTIFICATION_EVENT_CATEGORY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_NOTIFICATION_EVENT_CATEGORY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_NOTIFICATION_EVENT_CATEGORY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_PAGING_PRIORITY(pub i32);
impl ::windows_core::TypeKind for IO_PAGING_PRIORITY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_PAGING_PRIORITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_PAGING_PRIORITY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_QUERY_DEVICE_DATA_FORMAT(pub i32);
impl ::windows_core::TypeKind for IO_QUERY_DEVICE_DATA_FORMAT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_QUERY_DEVICE_DATA_FORMAT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_QUERY_DEVICE_DATA_FORMAT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_SESSION_EVENT(pub i32);
impl ::windows_core::TypeKind for IO_SESSION_EVENT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_SESSION_EVENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_SESSION_EVENT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IO_SESSION_STATE(pub i32);
impl ::windows_core::TypeKind for IO_SESSION_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IO_SESSION_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IO_SESSION_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IRQ_DEVICE_POLICY(pub i32);
impl ::windows_core::TypeKind for IRQ_DEVICE_POLICY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IRQ_DEVICE_POLICY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRQ_DEVICE_POLICY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IRQ_GROUP_POLICY(pub i32);
impl ::windows_core::TypeKind for IRQ_GROUP_POLICY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IRQ_GROUP_POLICY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRQ_GROUP_POLICY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct IRQ_PRIORITY(pub i32);
impl ::windows_core::TypeKind for IRQ_PRIORITY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for IRQ_PRIORITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IRQ_PRIORITY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KBUGCHECK_BUFFER_DUMP_STATE(pub i32);
impl ::windows_core::TypeKind for KBUGCHECK_BUFFER_DUMP_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KBUGCHECK_BUFFER_DUMP_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KBUGCHECK_BUFFER_DUMP_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KBUGCHECK_CALLBACK_REASON(pub i32);
impl ::windows_core::TypeKind for KBUGCHECK_CALLBACK_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KBUGCHECK_CALLBACK_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KBUGCHECK_CALLBACK_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KBUGCHECK_DUMP_IO_TYPE(pub i32);
impl ::windows_core::TypeKind for KBUGCHECK_DUMP_IO_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KBUGCHECK_DUMP_IO_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KBUGCHECK_DUMP_IO_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KDPC_IMPORTANCE(pub i32);
impl ::windows_core::TypeKind for KDPC_IMPORTANCE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KDPC_IMPORTANCE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KDPC_IMPORTANCE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KD_CALLBACK_ACTION(pub i32);
impl ::windows_core::TypeKind for KD_CALLBACK_ACTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KD_CALLBACK_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KD_CALLBACK_ACTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KD_NAMESPACE_ENUM(pub i32);
impl ::windows_core::TypeKind for KD_NAMESPACE_ENUM {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KD_NAMESPACE_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KD_NAMESPACE_ENUM").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KD_OPTION(pub i32);
impl ::windows_core::TypeKind for KD_OPTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KD_OPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KD_OPTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KEY_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for KEY_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KEY_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KEY_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KEY_VALUE_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for KEY_VALUE_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KEY_VALUE_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KEY_VALUE_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KE_PROCESSOR_CHANGE_NOTIFY_STATE(pub i32);
impl ::windows_core::TypeKind for KE_PROCESSOR_CHANGE_NOTIFY_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KE_PROCESSOR_CHANGE_NOTIFY_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KE_PROCESSOR_CHANGE_NOTIFY_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KINTERRUPT_MODE(pub i32);
impl ::windows_core::TypeKind for KINTERRUPT_MODE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KINTERRUPT_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KINTERRUPT_MODE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KINTERRUPT_POLARITY(pub i32);
impl ::windows_core::TypeKind for KINTERRUPT_POLARITY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KINTERRUPT_POLARITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KINTERRUPT_POLARITY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KPROFILE_SOURCE(pub i32);
impl ::windows_core::TypeKind for KPROFILE_SOURCE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KPROFILE_SOURCE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KPROFILE_SOURCE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct KWAIT_REASON(pub i32);
impl ::windows_core::TypeKind for KWAIT_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for KWAIT_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("KWAIT_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct LOCK_OPERATION(pub i32);
impl ::windows_core::TypeKind for LOCK_OPERATION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for LOCK_OPERATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("LOCK_OPERATION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MCA_EXCEPTION_TYPE(pub i32);
impl ::windows_core::TypeKind for MCA_EXCEPTION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MCA_EXCEPTION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MCA_EXCEPTION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MEMORY_CACHING_TYPE(pub i32);
impl ::windows_core::TypeKind for MEMORY_CACHING_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MEMORY_CACHING_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MEMORY_CACHING_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MEMORY_CACHING_TYPE_ORIG(pub i32);
impl ::windows_core::TypeKind for MEMORY_CACHING_TYPE_ORIG {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MEMORY_CACHING_TYPE_ORIG {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MEMORY_CACHING_TYPE_ORIG").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MEM_DEDICATED_ATTRIBUTE_TYPE(pub i32);
impl ::windows_core::TypeKind for MEM_DEDICATED_ATTRIBUTE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MEM_DEDICATED_ATTRIBUTE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MEM_DEDICATED_ATTRIBUTE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MEM_SECTION_EXTENDED_PARAMETER_TYPE(pub i32);
impl ::windows_core::TypeKind for MEM_SECTION_EXTENDED_PARAMETER_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MEM_SECTION_EXTENDED_PARAMETER_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MEM_SECTION_EXTENDED_PARAMETER_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MM_MDL_PAGE_CONTENTS_STATE(pub i32);
impl ::windows_core::TypeKind for MM_MDL_PAGE_CONTENTS_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MM_MDL_PAGE_CONTENTS_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MM_MDL_PAGE_CONTENTS_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MM_PAGE_PRIORITY(pub i32);
impl ::windows_core::TypeKind for MM_PAGE_PRIORITY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MM_PAGE_PRIORITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MM_PAGE_PRIORITY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MM_ROTATE_DIRECTION(pub i32);
impl ::windows_core::TypeKind for MM_ROTATE_DIRECTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MM_ROTATE_DIRECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MM_ROTATE_DIRECTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MM_SYSTEMSIZE(pub i32);
impl ::windows_core::TypeKind for MM_SYSTEMSIZE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MM_SYSTEMSIZE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MM_SYSTEMSIZE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct MODE(pub i32);
impl ::windows_core::TypeKind for MODE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MODE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct NPEM_CONTROL_STANDARD_CONTROL_BIT(pub i32);
impl ::windows_core::TypeKind for NPEM_CONTROL_STANDARD_CONTROL_BIT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for NPEM_CONTROL_STANDARD_CONTROL_BIT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("NPEM_CONTROL_STANDARD_CONTROL_BIT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct OB_PREOP_CALLBACK_STATUS(pub i32);
impl ::windows_core::TypeKind for OB_PREOP_CALLBACK_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for OB_PREOP_CALLBACK_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("OB_PREOP_CALLBACK_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PARTITION_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for PARTITION_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PARTITION_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PARTITION_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_ACS_BIT(pub i32);
impl ::windows_core::TypeKind for PCI_ACS_BIT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_ACS_BIT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_ACS_BIT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_BUS_WIDTH(pub i32);
impl ::windows_core::TypeKind for PCI_BUS_WIDTH {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_BUS_WIDTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_BUS_WIDTH").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_DEVICE_D3COLD_STATE_REASON(pub i32);
impl ::windows_core::TypeKind for PCI_DEVICE_D3COLD_STATE_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_DEVICE_D3COLD_STATE_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_DEVICE_D3COLD_STATE_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_ASPM_CONTROL(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_ASPM_CONTROL {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_ASPM_CONTROL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_ASPM_CONTROL").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_ASPM_SUPPORT(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_ASPM_SUPPORT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_ASPM_SUPPORT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_ASPM_SUPPORT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_CARD_PRESENCE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_CARD_PRESENCE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_CARD_PRESENCE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_CARD_PRESENCE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_DEVICE_TYPE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_DEVICE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_DEVICE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_DEVICE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_INDICATOR_STATE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_INDICATOR_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_INDICATOR_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_INDICATOR_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_L0s_EXIT_LATENCY(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_L0s_EXIT_LATENCY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_L0s_EXIT_LATENCY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_L0s_EXIT_LATENCY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_L1_EXIT_LATENCY(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_L1_EXIT_LATENCY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_L1_EXIT_LATENCY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_L1_EXIT_LATENCY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_LINK_SUBSTATE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_LINK_SUBSTATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_LINK_SUBSTATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_LINK_SUBSTATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_MAX_PAYLOAD_SIZE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_MAX_PAYLOAD_SIZE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_MAX_PAYLOAD_SIZE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_MAX_PAYLOAD_SIZE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_MRL_STATE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_MRL_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_MRL_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_MRL_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_POWER_STATE(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_POWER_STATE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_POWER_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_POWER_STATE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_EXPRESS_RCB(pub i32);
impl ::windows_core::TypeKind for PCI_EXPRESS_RCB {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_EXPRESS_RCB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_EXPRESS_RCB").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCI_HARDWARE_INTERFACE(pub i32);
impl ::windows_core::TypeKind for PCI_HARDWARE_INTERFACE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCI_HARDWARE_INTERFACE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCI_HARDWARE_INTERFACE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCW_CALLBACK_TYPE(pub i32);
impl ::windows_core::TypeKind for PCW_CALLBACK_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCW_CALLBACK_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCW_CALLBACK_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PCW_REGISTRATION_FLAGS(pub i32);
impl ::windows_core::TypeKind for PCW_REGISTRATION_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PCW_REGISTRATION_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PCW_REGISTRATION_FLAGS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE(pub i32);
impl ::windows_core::TypeKind for PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PHYSICAL_COUNTER_RESOURCE_DESCRIPTOR_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct POOL_EXTENDED_PARAMETER_TYPE(pub i32);
impl ::windows_core::TypeKind for POOL_EXTENDED_PARAMETER_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for POOL_EXTENDED_PARAMETER_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("POOL_EXTENDED_PARAMETER_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct POWER_MONITOR_REQUEST_REASON(pub i32);
impl ::windows_core::TypeKind for POWER_MONITOR_REQUEST_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for POWER_MONITOR_REQUEST_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("POWER_MONITOR_REQUEST_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct POWER_MONITOR_REQUEST_TYPE(pub i32);
impl ::windows_core::TypeKind for POWER_MONITOR_REQUEST_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for POWER_MONITOR_REQUEST_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("POWER_MONITOR_REQUEST_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct POWER_PLATFORM_ROLE(pub i32);
impl ::windows_core::TypeKind for POWER_PLATFORM_ROLE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for POWER_PLATFORM_ROLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("POWER_PLATFORM_ROLE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct POWER_STATE_TYPE(pub i32);
impl ::windows_core::TypeKind for POWER_STATE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for POWER_STATE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("POWER_STATE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct POWER_USER_PRESENCE_TYPE(pub i32);
impl ::windows_core::TypeKind for POWER_USER_PRESENCE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for POWER_USER_PRESENCE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("POWER_USER_PRESENCE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PO_FX_PERF_STATE_TYPE(pub i32);
impl ::windows_core::TypeKind for PO_FX_PERF_STATE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PO_FX_PERF_STATE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PO_FX_PERF_STATE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PO_FX_PERF_STATE_UNIT(pub i32);
impl ::windows_core::TypeKind for PO_FX_PERF_STATE_UNIT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PO_FX_PERF_STATE_UNIT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PO_FX_PERF_STATE_UNIT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PO_THERMAL_REQUEST_TYPE(pub i32);
impl ::windows_core::TypeKind for PO_THERMAL_REQUEST_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PO_THERMAL_REQUEST_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PO_THERMAL_REQUEST_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PSCREATEPROCESSNOTIFYTYPE(pub i32);
impl ::windows_core::TypeKind for PSCREATEPROCESSNOTIFYTYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PSCREATEPROCESSNOTIFYTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PSCREATEPROCESSNOTIFYTYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PSCREATETHREADNOTIFYTYPE(pub i32);
impl ::windows_core::TypeKind for PSCREATETHREADNOTIFYTYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PSCREATETHREADNOTIFYTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PSCREATETHREADNOTIFYTYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct PSHED_PI_ERR_READING_PCIE_OVERRIDES(pub i32);
impl ::windows_core::TypeKind for PSHED_PI_ERR_READING_PCIE_OVERRIDES {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PSHED_PI_ERR_READING_PCIE_OVERRIDES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PSHED_PI_ERR_READING_PCIE_OVERRIDES").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct REG_NOTIFY_CLASS(pub i32);
impl ::windows_core::TypeKind for REG_NOTIFY_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for REG_NOTIFY_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("REG_NOTIFY_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct RESOURCE_TRANSLATION_DIRECTION(pub i32);
impl ::windows_core::TypeKind for RESOURCE_TRANSLATION_DIRECTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for RESOURCE_TRANSLATION_DIRECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("RESOURCE_TRANSLATION_DIRECTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct RTL_GENERIC_COMPARE_RESULTS(pub i32);
impl ::windows_core::TypeKind for RTL_GENERIC_COMPARE_RESULTS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for RTL_GENERIC_COMPARE_RESULTS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("RTL_GENERIC_COMPARE_RESULTS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SECTION_INHERIT(pub i32);
impl ::windows_core::TypeKind for SECTION_INHERIT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SECTION_INHERIT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SECTION_INHERIT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SECURITY_OPERATION_CODE(pub i32);
impl ::windows_core::TypeKind for SECURITY_OPERATION_CODE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SECURITY_OPERATION_CODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SECURITY_OPERATION_CODE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SE_IMAGE_TYPE(pub i32);
impl ::windows_core::TypeKind for SE_IMAGE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SE_IMAGE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SE_IMAGE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SE_IMAGE_VERIFICATION_CALLBACK_TYPE(pub i32);
impl ::windows_core::TypeKind for SE_IMAGE_VERIFICATION_CALLBACK_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SE_IMAGE_VERIFICATION_CALLBACK_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SE_IMAGE_VERIFICATION_CALLBACK_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SOC_SUBSYSTEM_TYPE(pub i32);
impl ::windows_core::TypeKind for SOC_SUBSYSTEM_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SOC_SUBSYSTEM_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SOC_SUBSYSTEM_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct STATE_LOCATION_TYPE(pub i32);
impl ::windows_core::TypeKind for STATE_LOCATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for STATE_LOCATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("STATE_LOCATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SUBSYSTEM_INFORMATION_TYPE(pub i32);
impl ::windows_core::TypeKind for SUBSYSTEM_INFORMATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SUBSYSTEM_INFORMATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SUBSYSTEM_INFORMATION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SYSTEM_FIRMWARE_TABLE_ACTION(pub i32);
impl ::windows_core::TypeKind for SYSTEM_FIRMWARE_TABLE_ACTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SYSTEM_FIRMWARE_TABLE_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SYSTEM_FIRMWARE_TABLE_ACTION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct SYSTEM_POWER_CONDITION(pub i32);
impl ::windows_core::TypeKind for SYSTEM_POWER_CONDITION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SYSTEM_POWER_CONDITION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SYSTEM_POWER_CONDITION").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct TABLE_SEARCH_RESULT(pub i32);
impl ::windows_core::TypeKind for TABLE_SEARCH_RESULT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for TABLE_SEARCH_RESULT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("TABLE_SEARCH_RESULT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct TIMER_SET_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for TIMER_SET_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for TIMER_SET_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("TIMER_SET_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct TRACE_INFORMATION_CLASS(pub i32);
impl ::windows_core::TypeKind for TRACE_INFORMATION_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for TRACE_INFORMATION_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("TRACE_INFORMATION_CLASS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEAP_DPC_ERROR_EVENT_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEAP_DPC_ERROR_EVENT_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEAP_DPC_ERROR_EVENT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEAP_DPC_ERROR_EVENT_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEAP_PFA_OFFLINE_DECISION_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEAP_PFA_OFFLINE_DECISION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEAP_PFA_OFFLINE_DECISION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEAP_PFA_OFFLINE_DECISION_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_BUGCHECK_RECOVERY_LOG_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_BUGCHECK_RECOVERY_LOG_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_BUGCHECK_RECOVERY_LOG_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_BUGCHECK_RECOVERY_LOG_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_CPU_VENDOR(pub i32);
impl ::windows_core::TypeKind for WHEA_CPU_VENDOR {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_CPU_VENDOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_CPU_VENDOR").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_ERROR_PACKET_DATA_FORMAT(pub i32);
impl ::windows_core::TypeKind for WHEA_ERROR_PACKET_DATA_FORMAT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_ERROR_PACKET_DATA_FORMAT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_ERROR_PACKET_DATA_FORMAT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_ERROR_SEVERITY(pub i32);
impl ::windows_core::TypeKind for WHEA_ERROR_SEVERITY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_ERROR_SEVERITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_ERROR_SEVERITY").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_ERROR_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_ERROR_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_ERROR_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_ERROR_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_EVENT_LOG_ENTRY_ID(pub i32);
impl ::windows_core::TypeKind for WHEA_EVENT_LOG_ENTRY_ID {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_EVENT_LOG_ENTRY_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_EVENT_LOG_ENTRY_ID").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_EVENT_LOG_ENTRY_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_EVENT_LOG_ENTRY_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_EVENT_LOG_ENTRY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_EVENT_LOG_ENTRY_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_PCIEXPRESS_DEVICE_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_PCIEXPRESS_DEVICE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_PCIEXPRESS_DEVICE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_PCIEXPRESS_DEVICE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_PCI_RECOVERY_SIGNAL(pub i32);
impl ::windows_core::TypeKind for WHEA_PCI_RECOVERY_SIGNAL {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_PCI_RECOVERY_SIGNAL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_PCI_RECOVERY_SIGNAL").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_PCI_RECOVERY_STATUS(pub i32);
impl ::windows_core::TypeKind for WHEA_PCI_RECOVERY_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_PCI_RECOVERY_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_PCI_RECOVERY_STATUS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_PFA_REMOVE_TRIGGER(pub i32);
impl ::windows_core::TypeKind for WHEA_PFA_REMOVE_TRIGGER {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_PFA_REMOVE_TRIGGER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_PFA_REMOVE_TRIGGER").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS(pub i32);
impl ::windows_core::TypeKind for WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_PSHED_PLUGIN_ENABLE_NOTIFY_ERRORS").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_RAW_DATA_FORMAT(pub i32);
impl ::windows_core::TypeKind for WHEA_RAW_DATA_FORMAT {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_RAW_DATA_FORMAT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_RAW_DATA_FORMAT").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_RECOVERY_CONTEXT_ERROR_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_RECOVERY_CONTEXT_ERROR_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_RECOVERY_CONTEXT_ERROR_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_RECOVERY_CONTEXT_ERROR_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_RECOVERY_FAILURE_REASON(pub i32);
impl ::windows_core::TypeKind for WHEA_RECOVERY_FAILURE_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_RECOVERY_FAILURE_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_RECOVERY_FAILURE_REASON").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_RECOVERY_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_RECOVERY_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_RECOVERY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_RECOVERY_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WHEA_THROTTLE_TYPE(pub i32);
impl ::windows_core::TypeKind for WHEA_THROTTLE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WHEA_THROTTLE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WHEA_THROTTLE_TYPE").field(&self.0).finish()
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq, ::core::marker::Copy, ::core::clone::Clone, ::core::default::Default)]
pub struct WORK_QUEUE_TYPE(pub i32);
impl ::windows_core::TypeKind for WORK_QUEUE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for WORK_QUEUE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("WORK_QUEUE_TYPE").field(&self.0).finish()
    }
}
#[repr(C)]
pub struct ACPI_DEBUGGING_DEVICE_IN_USE {
    pub NameSpacePathLength: u32,
    pub NameSpacePath: [u16; 1],
}
impl ::core::marker::Copy for ACPI_DEBUGGING_DEVICE_IN_USE {}
impl ::core::clone::Clone for ACPI_DEBUGGING_DEVICE_IN_USE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ACPI_DEBUGGING_DEVICE_IN_USE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ACPI_DEBUGGING_DEVICE_IN_USE").field("NameSpacePathLength", &self.NameSpacePathLength).field("NameSpacePath", &self.NameSpacePath).finish()
    }
}
impl ::windows_core::TypeKind for ACPI_DEBUGGING_DEVICE_IN_USE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for ACPI_DEBUGGING_DEVICE_IN_USE {
    fn eq(&self, other: &Self) -> bool {
        self.NameSpacePathLength == other.NameSpacePathLength && self.NameSpacePath == other.NameSpacePath
    }
}
impl ::core::cmp::Eq for ACPI_DEBUGGING_DEVICE_IN_USE {}
impl ::core::default::Default for ACPI_DEBUGGING_DEVICE_IN_USE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ACPI_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut ::core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub GpeConnectVector: PGPE_CONNECT_VECTOR,
    pub GpeDisconnectVector: PGPE_DISCONNECT_VECTOR,
    pub GpeEnableEvent: PGPE_ENABLE_EVENT,
    pub GpeDisableEvent: PGPE_DISABLE_EVENT,
    pub GpeClearStatus: PGPE_CLEAR_STATUS,
    pub RegisterForDeviceNotifications: PREGISTER_FOR_DEVICE_NOTIFICATIONS,
    pub UnregisterForDeviceNotifications: PUNREGISTER_FOR_DEVICE_NOTIFICATIONS,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ACPI_INTERFACE_STANDARD {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ACPI_INTERFACE_STANDARD {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::fmt::Debug for ACPI_INTERFACE_STANDARD {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ACPI_INTERFACE_STANDARD").field("Size", &self.Size).field("Version", &self.Version).field("Context", &self.Context).finish()
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ACPI_INTERFACE_STANDARD {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ACPI_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct ACPI_INTERFACE_STANDARD2 {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut ::core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub GpeConnectVector: PGPE_CONNECT_VECTOR2,
    pub GpeDisconnectVector: PGPE_DISCONNECT_VECTOR2,
    pub GpeEnableEvent: PGPE_ENABLE_EVENT2,
    pub GpeDisableEvent: PGPE_DISABLE_EVENT2,
    pub GpeClearStatus: PGPE_CLEAR_STATUS2,
    pub RegisterForDeviceNotifications: PREGISTER_FOR_DEVICE_NOTIFICATIONS2,
    pub UnregisterForDeviceNotifications: PUNREGISTER_FOR_DEVICE_NOTIFICATIONS2,
}
impl ::core::marker::Copy for ACPI_INTERFACE_STANDARD2 {}
impl ::core::clone::Clone for ACPI_INTERFACE_STANDARD2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ACPI_INTERFACE_STANDARD2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ACPI_INTERFACE_STANDARD2").field("Size", &self.Size).field("Version", &self.Version).field("Context", &self.Context).finish()
    }
}
impl ::windows_core::TypeKind for ACPI_INTERFACE_STANDARD2 {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::default::Default for ACPI_INTERFACE_STANDARD2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct AGP_TARGET_BUS_INTERFACE_STANDARD {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut ::core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub SetBusData: PGET_SET_DEVICE_DATA,
    pub GetBusData: PGET_SET_DEVICE_DATA,
    pub CapabilityID: u8,
}
impl ::core::marker::Copy for AGP_TARGET_BUS_INTERFACE_STANDARD {}
impl ::core::clone::Clone for AGP_TARGET_BUS_INTERFACE_STANDARD {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AGP_TARGET_BUS_INTERFACE_STANDARD {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AGP_TARGET_BUS_INTERFACE_STANDARD").field("Size", &self.Size).field("Version", &self.Version).field("Context", &self.Context).field("CapabilityID", &self.CapabilityID).finish()
    }
}
impl ::windows_core::TypeKind for AGP_TARGET_BUS_INTERFACE_STANDARD {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::default::Default for AGP_TARGET_BUS_INTERFACE_STANDARD {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub union AMD_L1_CACHE_INFO {
    pub Ulong: u32,
    pub Anonymous: AMD_L1_CACHE_INFO_0,
}
impl ::core::marker::Copy for AMD_L1_CACHE_INFO {}
impl ::core::clone::Clone for AMD_L1_CACHE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::windows_core::TypeKind for AMD_L1_CACHE_INFO {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::default::Default for AMD_L1_CACHE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct AMD_L1_CACHE_INFO_0 {
    pub LineSize: u8,
    pub LinesPerTag: u8,
    pub Associativity: u8,
    pub Size: u8,
}
impl ::core::marker::Copy for AMD_L1_CACHE_INFO_0 {}
impl ::core::clone::Clone for AMD_L1_CACHE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMD_L1_CACHE_INFO_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMD_L1_CACHE_INFO_0").field("LineSize", &self.LineSize).field("LinesPerTag", &self.LinesPerTag).field("Associativity", &self.Associativity).field("Size", &self.Size).finish()
    }
}
impl ::windows_core::TypeKind for AMD_L1_CACHE_INFO_0 {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for AMD_L1_CACHE_INFO_0 {
    fn eq(&self, other: &Self) -> bool {
        self.LineSize == other.LineSize && self.LinesPerTag == other.LinesPerTag && self.Associativity == other.Associativity && self.Size == other.Size
    }
}
impl ::core::cmp::Eq for AMD_L1_CACHE_INFO_0 {}
impl ::core::default::Default for AMD_L1_CACHE_INFO_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub union AMD_L2_CACHE_INFO {
    pub Ulong: u32,
    pub Anonymous: AMD_L2_CACHE_INFO_0,
}
impl ::core::marker::Copy for AMD_L2_CACHE_INFO {}
impl ::core::clone::Clone for AMD_L2_CACHE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::windows_core::TypeKind for AMD_L2_CACHE_INFO {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::default::Default for AMD_L2_CACHE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct AMD_L2_CACHE_INFO_0 {
    pub LineSize: u8,
    pub _bitfield: u8,
    pub Size: u16,
}
impl ::core::marker::Copy for AMD_L2_CACHE_INFO_0 {}
impl ::core::clone::Clone for AMD_L2_CACHE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMD_L2_CACHE_INFO_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMD_L2_CACHE_INFO_0").field("LineSize", &self.LineSize).field("_bitfield", &self._bitfield).field("Size", &self.Size).finish()
    }
}
impl ::windows_core::TypeKind for AMD_L2_CACHE_INFO_0 {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for AMD_L2_CACHE_INFO_0 {
    fn eq(&self, other: &Self) -> bool {
        self.LineSize == other.LineSize && self._bitfield == other._bitfield && self.Size == other.Size
    }
}
impl ::core::cmp::Eq for AMD_L2_CACHE_INFO_0 {}
impl ::core::default::Default for AMD_L2_CACHE_INFO_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub union AMD_L3_CACHE_INFO {
    pub Ulong: u32,
    pub Anonymous: AMD_L3_CACHE_INFO_0,
}
impl ::core::marker::Copy for AMD_L3_CACHE_INFO {}
impl ::core::clone::Clone for AMD_L3_CACHE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::windows_core::TypeKind for AMD_L3_CACHE_INFO {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::default::Default for AMD_L3_CACHE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct AMD_L3_CACHE_INFO_0 {
    pub LineSize: u8,
    pub _bitfield1: u8,
    pub _bitfield2: u16,
}
impl ::core::marker::Copy for AMD_L3_CACHE_INFO_0 {}
impl ::core::clone::Clone for AMD_L3_CACHE_INFO_0 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AMD_L3_CACHE_INFO_0 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AMD_L3_CACHE_INFO_0").field("LineSize", &self.LineSize).field("_bitfield1", &self._bitfield1).field("_bitfield2", &self._bitfield2).finish()
    }
}
impl ::windows_core::TypeKind for AMD_L3_CACHE_INFO_0 {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for AMD_L3_CACHE_INFO_0 {
    fn eq(&self, other: &Self) -> bool {
        self.LineSize == other.LineSize && self._bitfield1 == other._bitfield1 && self._bitfield2 == other._bitfield2
    }
}
impl ::core::cmp::Eq for AMD_L3_CACHE_INFO_0 {}
impl ::core::default::Default for AMD_L3_CACHE_INFO_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ARBITER_ADD_RESERVED_PARAMETERS {
    pub ReserveDevice: *mut super::super::Foundation::DEVICE_OBJECT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_ADD_RESERVED_PARAMETERS {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_ADD_RESERVED_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::fmt::Debug for ARBITER_ADD_RESERVED_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_ADD_RESERVED_PARAMETERS").field("ReserveDevice", &self.ReserveDevice).finish()
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_ADD_RESERVED_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::PartialEq for ARBITER_ADD_RESERVED_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ReserveDevice == other.ReserveDevice
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::Eq for ARBITER_ADD_RESERVED_PARAMETERS {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_ADD_RESERVED_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
pub struct ARBITER_BOOT_ALLOCATION_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::marker::Copy for ARBITER_BOOT_ALLOCATION_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::clone::Clone for ARBITER_BOOT_ALLOCATION_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for ARBITER_BOOT_ALLOCATION_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_BOOT_ALLOCATION_PARAMETERS").field("ArbitrationList", &self.ArbitrationList).finish()
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::windows_core::TypeKind for ARBITER_BOOT_ALLOCATION_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for ARBITER_BOOT_ALLOCATION_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ArbitrationList == other.ArbitrationList
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for ARBITER_BOOT_ALLOCATION_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for ARBITER_BOOT_ALLOCATION_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ARBITER_CONFLICT_INFO {
    pub OwningObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub Start: u64,
    pub End: u64,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_CONFLICT_INFO {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_CONFLICT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::fmt::Debug for ARBITER_CONFLICT_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_CONFLICT_INFO").field("OwningObject", &self.OwningObject).field("Start", &self.Start).field("End", &self.End).finish()
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_CONFLICT_INFO {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::PartialEq for ARBITER_CONFLICT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.OwningObject == other.OwningObject && self.Start == other.Start && self.End == other.End
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::Eq for ARBITER_CONFLICT_INFO {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_CONFLICT_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ARBITER_INTERFACE {
    pub Size: u16,
    pub Version: u16,
    pub Context: *mut ::core::ffi::c_void,
    pub InterfaceReference: PINTERFACE_REFERENCE,
    pub InterfaceDereference: PINTERFACE_DEREFERENCE,
    pub ArbiterHandler: PARBITER_HANDLER,
    pub Flags: u32,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_INTERFACE {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_INTERFACE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::fmt::Debug for ARBITER_INTERFACE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_INTERFACE").field("Size", &self.Size).field("Version", &self.Version).field("Context", &self.Context).field("Flags", &self.Flags).finish()
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_INTERFACE {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_INTERFACE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ARBITER_LIST_ENTRY {
    pub ListEntry: super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub AlternativeCount: u32,
    pub Alternatives: *mut IO_RESOURCE_DESCRIPTOR,
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub RequestSource: ARBITER_REQUEST_SOURCE,
    pub Flags: u32,
    pub WorkSpace: isize,
    pub InterfaceType: INTERFACE_TYPE,
    pub SlotNumber: u32,
    pub BusNumber: u32,
    pub Assignment: *mut CM_PARTIAL_RESOURCE_DESCRIPTOR,
    pub SelectedAlternative: *mut IO_RESOURCE_DESCRIPTOR,
    pub Result: ARBITER_RESULT,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_LIST_ENTRY {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_LIST_ENTRY {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::fmt::Debug for ARBITER_LIST_ENTRY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_LIST_ENTRY")
            .field("ListEntry", &self.ListEntry)
            .field("AlternativeCount", &self.AlternativeCount)
            .field("Alternatives", &self.Alternatives)
            .field("PhysicalDeviceObject", &self.PhysicalDeviceObject)
            .field("RequestSource", &self.RequestSource)
            .field("Flags", &self.Flags)
            .field("WorkSpace", &self.WorkSpace)
            .field("InterfaceType", &self.InterfaceType)
            .field("SlotNumber", &self.SlotNumber)
            .field("BusNumber", &self.BusNumber)
            .field("Assignment", &self.Assignment)
            .field("SelectedAlternative", &self.SelectedAlternative)
            .field("Result", &self.Result)
            .finish()
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_LIST_ENTRY {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::PartialEq for ARBITER_LIST_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.ListEntry == other.ListEntry && self.AlternativeCount == other.AlternativeCount && self.Alternatives == other.Alternatives && self.PhysicalDeviceObject == other.PhysicalDeviceObject && self.RequestSource == other.RequestSource && self.Flags == other.Flags && self.WorkSpace == other.WorkSpace && self.InterfaceType == other.InterfaceType && self.SlotNumber == other.SlotNumber && self.BusNumber == other.BusNumber && self.Assignment == other.Assignment && self.SelectedAlternative == other.SelectedAlternative && self.Result == other.Result
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::Eq for ARBITER_LIST_ENTRY {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_LIST_ENTRY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ARBITER_PARAMETERS {
    pub Parameters: ARBITER_PARAMETERS_0,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_PARAMETERS {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub union ARBITER_PARAMETERS_0 {
    pub TestAllocation: ARBITER_TEST_ALLOCATION_PARAMETERS,
    pub RetestAllocation: ARBITER_RETEST_ALLOCATION_PARAMETERS,
    pub BootAllocation: ARBITER_BOOT_ALLOCATION_PARAMETERS,
    pub QueryAllocatedResources: ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS,
    pub QueryConflict: ARBITER_QUERY_CONFLICT_PARAMETERS,
    pub QueryArbitrate: ARBITER_QUERY_ARBITRATE_PARAMETERS,
    pub AddReserved: ARBITER_ADD_RESERVED_PARAMETERS,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_PARAMETERS_0 {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_PARAMETERS_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_PARAMETERS_0 {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_PARAMETERS_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
pub struct ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    pub AllocatedResources: *mut *mut CM_PARTIAL_RESOURCE_LIST,
}
impl ::core::marker::Copy for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {}
impl ::core::clone::Clone for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS").field("AllocatedResources", &self.AllocatedResources).finish()
    }
}
impl ::windows_core::TypeKind for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.AllocatedResources == other.AllocatedResources
    }
}
impl ::core::cmp::Eq for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {}
impl ::core::default::Default for ARBITER_QUERY_ALLOCATED_RESOURCES_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
pub struct ARBITER_QUERY_ARBITRATE_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::marker::Copy for ARBITER_QUERY_ARBITRATE_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::clone::Clone for ARBITER_QUERY_ARBITRATE_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for ARBITER_QUERY_ARBITRATE_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_QUERY_ARBITRATE_PARAMETERS").field("ArbitrationList", &self.ArbitrationList).finish()
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::windows_core::TypeKind for ARBITER_QUERY_ARBITRATE_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for ARBITER_QUERY_ARBITRATE_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ArbitrationList == other.ArbitrationList
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for ARBITER_QUERY_ARBITRATE_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for ARBITER_QUERY_ARBITRATE_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
pub struct ARBITER_QUERY_CONFLICT_PARAMETERS {
    pub PhysicalDeviceObject: *mut super::super::Foundation::DEVICE_OBJECT,
    pub ConflictingResource: *mut IO_RESOURCE_DESCRIPTOR,
    pub ConflictCount: *mut u32,
    pub Conflicts: *mut *mut ARBITER_CONFLICT_INFO,
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::marker::Copy for ARBITER_QUERY_CONFLICT_PARAMETERS {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::clone::Clone for ARBITER_QUERY_CONFLICT_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::fmt::Debug for ARBITER_QUERY_CONFLICT_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_QUERY_CONFLICT_PARAMETERS").field("PhysicalDeviceObject", &self.PhysicalDeviceObject).field("ConflictingResource", &self.ConflictingResource).field("ConflictCount", &self.ConflictCount).field("Conflicts", &self.Conflicts).finish()
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::windows_core::TypeKind for ARBITER_QUERY_CONFLICT_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::PartialEq for ARBITER_QUERY_CONFLICT_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.PhysicalDeviceObject == other.PhysicalDeviceObject && self.ConflictingResource == other.ConflictingResource && self.ConflictCount == other.ConflictCount && self.Conflicts == other.Conflicts
    }
}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::cmp::Eq for ARBITER_QUERY_CONFLICT_PARAMETERS {}
#[cfg(all(feature = "Wdk_Foundation", feature = "Wdk_Storage_FileSystem", feature = "Win32_Security", feature = "Win32_System_IO", feature = "Win32_System_Kernel", feature = "Win32_System_Power"))]
impl ::core::default::Default for ARBITER_QUERY_CONFLICT_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
pub struct ARBITER_RETEST_ALLOCATION_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub AllocateFromCount: u32,
    pub AllocateFrom: *mut CM_PARTIAL_RESOURCE_DESCRIPTOR,
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::marker::Copy for ARBITER_RETEST_ALLOCATION_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::clone::Clone for ARBITER_RETEST_ALLOCATION_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for ARBITER_RETEST_ALLOCATION_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_RETEST_ALLOCATION_PARAMETERS").field("ArbitrationList", &self.ArbitrationList).field("AllocateFromCount", &self.AllocateFromCount).field("AllocateFrom", &self.AllocateFrom).finish()
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::windows_core::TypeKind for ARBITER_RETEST_ALLOCATION_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for ARBITER_RETEST_ALLOCATION_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ArbitrationList == other.ArbitrationList && self.AllocateFromCount == other.AllocateFromCount && self.AllocateFrom == other.AllocateFrom
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for ARBITER_RETEST_ALLOCATION_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for ARBITER_RETEST_ALLOCATION_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Kernel")]
pub struct ARBITER_TEST_ALLOCATION_PARAMETERS {
    pub ArbitrationList: *mut super::super::super::Win32::System::Kernel::LIST_ENTRY,
    pub AllocateFromCount: u32,
    pub AllocateFrom: *mut CM_PARTIAL_RESOURCE_DESCRIPTOR,
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::marker::Copy for ARBITER_TEST_ALLOCATION_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::clone::Clone for ARBITER_TEST_ALLOCATION_PARAMETERS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::fmt::Debug for ARBITER_TEST_ALLOCATION_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("ARBITER_TEST_ALLOCATION_PARAMETERS").field("ArbitrationList", &self.ArbitrationList).field("AllocateFromCount", &self.AllocateFromCount).field("AllocateFrom", &self.AllocateFrom).finish()
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::windows_core::TypeKind for ARBITER_TEST_ALLOCATION_PARAMETERS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::PartialEq for ARBITER_TEST_ALLOCATION_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.ArbitrationList == other.ArbitrationList && self.AllocateFromCount == other.AllocateFromCount && self.AllocateFrom == other.AllocateFrom
    }
}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::cmp::Eq for ARBITER_TEST_ALLOCATION_PARAMETERS {}
#[cfg(feature = "Win32_System_Kernel")]
impl ::core::default::Default for ARBITER_TEST_ALLOCATION_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
pub struct ARM64_NT_CONTEXT {
    pub ContextFlags: u32,
    pub Cpsr: u32,
    pub Anonymous: ARM64_NT_CONTEXT_0,
    pub Sp: u64,
    pub Pc: u64,
    pub V: [super::super::super::Win32::System::Diagnostics::Debug::ARM64_NT_NEON128; 32],
    pub Fpcr: u32,
    pub Fpsr: u32,
    pub Bcr: [u32; 8],
    pub Bvr: [u64; 8],
    pub Wcr: [u32; 2],
    pub Wvr: [u64; 2],
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::marker::Copy for ARM64_NT_CONTEXT {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::clone::Clone for ARM64_NT_CONTEXT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::windows_core::TypeKind for ARM64_NT_CONTEXT {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::default::Default for ARM64_NT_CONTEXT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
pub union ARM64_NT_CONTEXT_0 {
    pub Anonymous: ARM64_NT_CONTEXT_0_0,
    pub X: [u64; 31],
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::marker::Copy for ARM64_NT_CONTEXT_0 {}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::clone::Clone for ARM64_NT_CONTEXT_0 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::windows_core::TypeKind for ARM64_NT_CONTEXT_0 {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::default::Default for ARM64_NT_CONTEXT_0 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
pub struct ARM64_NT_CONTEXT_0_0 {
    pub X0: u64,
    pub X1: u64,
    pub X2: u64,
    pub X3: u64,
    pub X4: u64,
    pub X5: u64,
    pub X6: u64,
    pub X7: u64,
    pub X8: u64,
    pub X9: u64,
    pub X10: u64,
    pub X11: u64,
    pub X12: u64,
    pub X13: u64,
    pub X14: u64,
    pub X15: u64,
    pub X16: u64,
    pub X17: u64,
    pub X18: u64,
    pub X19: u64,
    pub X20: u64,
    pub X21: u64,
    pub X22: u64,
    pub X23: u64,
    pub X24: u64,
    pub X25: u64,
    pub X26: u64,
    pub X27: u64,
    pub X28: u64,
    pub Fp: u64,
    pub Lr: u64,
}
#[cfg(feature = "Win32_System_Diagnostics_Debug")]
impl ::core::marker::Copy for ARM64_NT_CONTEXT_0_0 {}
#[cfg(feature = "Win32_System_D