// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurusecurity

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetFindings = "BatchGetFindings"

// BatchGetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetFindings for more information on using the BatchGetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetFindingsRequest method.
//	req, resp := client.BatchGetFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/BatchGetFindings
func (c *CodeGuruSecurity) BatchGetFindingsRequest(input *BatchGetFindingsInput) (req *request.Request, output *BatchGetFindingsOutput) {
	op := &request.Operation{
		Name:       opBatchGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/batchGetFindings",
	}

	if input == nil {
		input = &BatchGetFindingsInput{}
	}

	output = &BatchGetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetFindings API operation for Amazon CodeGuru Security.
//
// Returns a list of all requested findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation BatchGetFindings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/BatchGetFindings
func (c *CodeGuruSecurity) BatchGetFindings(input *BatchGetFindingsInput) (*BatchGetFindingsOutput, error) {
	req, out := c.BatchGetFindingsRequest(input)
	return out, req.Send()
}

// BatchGetFindingsWithContext is the same as BatchGetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) BatchGetFindingsWithContext(ctx aws.Context, input *BatchGetFindingsInput, opts ...request.Option) (*BatchGetFindingsOutput, error) {
	req, out := c.BatchGetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScan = "CreateScan"

// CreateScanRequest generates a "aws/request.Request" representing the
// client's request for the CreateScan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScan for more information on using the CreateScan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateScanRequest method.
//	req, resp := client.CreateScanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateScan
func (c *CodeGuruSecurity) CreateScanRequest(input *CreateScanInput) (req *request.Request, output *CreateScanOutput) {
	op := &request.Operation{
		Name:       opCreateScan,
		HTTPMethod: "POST",
		HTTPPath:   "/scans",
	}

	if input == nil {
		input = &CreateScanInput{}
	}

	output = &CreateScanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScan API operation for Amazon CodeGuru Security.
//
// Use to create a scan using code uploaded to an S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation CreateScan for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateScan
func (c *CodeGuruSecurity) CreateScan(input *CreateScanInput) (*CreateScanOutput, error) {
	req, out := c.CreateScanRequest(input)
	return out, req.Send()
}

// CreateScanWithContext is the same as CreateScan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) CreateScanWithContext(ctx aws.Context, input *CreateScanInput, opts ...request.Option) (*CreateScanOutput, error) {
	req, out := c.CreateScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUploadUrl = "CreateUploadUrl"

// CreateUploadUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreateUploadUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUploadUrl for more information on using the CreateUploadUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUploadUrlRequest method.
//	req, resp := client.CreateUploadUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateUploadUrl
func (c *CodeGuruSecurity) CreateUploadUrlRequest(input *CreateUploadUrlInput) (req *request.Request, output *CreateUploadUrlOutput) {
	op := &request.Operation{
		Name:       opCreateUploadUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/uploadUrl",
	}

	if input == nil {
		input = &CreateUploadUrlInput{}
	}

	output = &CreateUploadUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUploadUrl API operation for Amazon CodeGuru Security.
//
// Generates a pre-signed URL and request headers used to upload a code resource.
//
// You can upload your code resource to the URL and add the request headers
// using any HTTP client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation CreateUploadUrl for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/CreateUploadUrl
func (c *CodeGuruSecurity) CreateUploadUrl(input *CreateUploadUrlInput) (*CreateUploadUrlOutput, error) {
	req, out := c.CreateUploadUrlRequest(input)
	return out, req.Send()
}

// CreateUploadUrlWithContext is the same as CreateUploadUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUploadUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) CreateUploadUrlWithContext(ctx aws.Context, input *CreateUploadUrlInput, opts ...request.Option) (*CreateUploadUrlOutput, error) {
	req, out := c.CreateUploadUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountConfiguration = "GetAccountConfiguration"

// GetAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountConfiguration for more information on using the GetAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountConfigurationRequest method.
//	req, resp := client.GetAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetAccountConfiguration
func (c *CodeGuruSecurity) GetAccountConfigurationRequest(input *GetAccountConfigurationInput) (req *request.Request, output *GetAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetAccountConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/accountConfiguration/get",
	}

	if input == nil {
		input = &GetAccountConfigurationInput{}
	}

	output = &GetAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountConfiguration API operation for Amazon CodeGuru Security.
//
// Use to get account level configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation GetAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetAccountConfiguration
func (c *CodeGuruSecurity) GetAccountConfiguration(input *GetAccountConfigurationInput) (*GetAccountConfigurationOutput, error) {
	req, out := c.GetAccountConfigurationRequest(input)
	return out, req.Send()
}

// GetAccountConfigurationWithContext is the same as GetAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) GetAccountConfigurationWithContext(ctx aws.Context, input *GetAccountConfigurationInput, opts ...request.Option) (*GetAccountConfigurationOutput, error) {
	req, out := c.GetAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFindings = "GetFindings"

// GetFindingsRequest generates a "aws/request.Request" representing the
// client's request for the GetFindings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFindings for more information on using the GetFindings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFindingsRequest method.
//	req, resp := client.GetFindingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetFindings
func (c *CodeGuruSecurity) GetFindingsRequest(input *GetFindingsInput) (req *request.Request, output *GetFindingsOutput) {
	op := &request.Operation{
		Name:       opGetFindings,
		HTTPMethod: "GET",
		HTTPPath:   "/findings/{scanName}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	output = &GetFindingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFindings API operation for Amazon CodeGuru Security.
//
// Returns a list of all findings generated by a particular scan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation GetFindings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetFindings
func (c *CodeGuruSecurity) GetFindings(input *GetFindingsInput) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	return out, req.Send()
}

// GetFindingsWithContext is the same as GetFindings with the addition of
// the ability to pass a context and additional request options.
//
// See GetFindings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) GetFindingsWithContext(ctx aws.Context, input *GetFindingsInput, opts ...request.Option) (*GetFindingsOutput, error) {
	req, out := c.GetFindingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFindingsPages iterates over the pages of a GetFindings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFindings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetFindings operation.
//	pageNum := 0
//	err := client.GetFindingsPages(params,
//	    func(page *codegurusecurity.GetFindingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeGuruSecurity) GetFindingsPages(input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool) error {
	return c.GetFindingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFindingsPagesWithContext same as GetFindingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) GetFindingsPagesWithContext(ctx aws.Context, input *GetFindingsInput, fn func(*GetFindingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFindingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFindingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFindingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMetricsSummary = "GetMetricsSummary"

// GetMetricsSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricsSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricsSummary for more information on using the GetMetricsSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricsSummaryRequest method.
//	req, resp := client.GetMetricsSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetMetricsSummary
func (c *CodeGuruSecurity) GetMetricsSummaryRequest(input *GetMetricsSummaryInput) (req *request.Request, output *GetMetricsSummaryOutput) {
	op := &request.Operation{
		Name:       opGetMetricsSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/metrics/summary",
	}

	if input == nil {
		input = &GetMetricsSummaryInput{}
	}

	output = &GetMetricsSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricsSummary API operation for Amazon CodeGuru Security.
//
// Returns top level metrics about an account from a specified date, including
// number of open findings, the categories with most findings, the scans with
// most open findings, and scans with most open critical findings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation GetMetricsSummary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetMetricsSummary
func (c *CodeGuruSecurity) GetMetricsSummary(input *GetMetricsSummaryInput) (*GetMetricsSummaryOutput, error) {
	req, out := c.GetMetricsSummaryRequest(input)
	return out, req.Send()
}

// GetMetricsSummaryWithContext is the same as GetMetricsSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricsSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) GetMetricsSummaryWithContext(ctx aws.Context, input *GetMetricsSummaryInput, opts ...request.Option) (*GetMetricsSummaryOutput, error) {
	req, out := c.GetMetricsSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetScan = "GetScan"

// GetScanRequest generates a "aws/request.Request" representing the
// client's request for the GetScan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScan for more information on using the GetScan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetScanRequest method.
//	req, resp := client.GetScanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetScan
func (c *CodeGuruSecurity) GetScanRequest(input *GetScanInput) (req *request.Request, output *GetScanOutput) {
	op := &request.Operation{
		Name:       opGetScan,
		HTTPMethod: "GET",
		HTTPPath:   "/scans/{scanName}",
	}

	if input == nil {
		input = &GetScanInput{}
	}

	output = &GetScanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetScan API operation for Amazon CodeGuru Security.
//
// Returns details about a scan, including whether or not a scan has completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation GetScan for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/GetScan
func (c *CodeGuruSecurity) GetScan(input *GetScanInput) (*GetScanOutput, error) {
	req, out := c.GetScanRequest(input)
	return out, req.Send()
}

// GetScanWithContext is the same as GetScan with the addition of
// the ability to pass a context and additional request options.
//
// See GetScan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) GetScanWithContext(ctx aws.Context, input *GetScanInput, opts ...request.Option) (*GetScanOutput, error) {
	req, out := c.GetScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFindingsMetrics = "ListFindingsMetrics"

// ListFindingsMetricsRequest generates a "aws/request.Request" representing the
// client's request for the ListFindingsMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFindingsMetrics for more information on using the ListFindingsMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFindingsMetricsRequest method.
//	req, resp := client.ListFindingsMetricsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListFindingsMetrics
func (c *CodeGuruSecurity) ListFindingsMetricsRequest(input *ListFindingsMetricsInput) (req *request.Request, output *ListFindingsMetricsOutput) {
	op := &request.Operation{
		Name:       opListFindingsMetrics,
		HTTPMethod: "GET",
		HTTPPath:   "/metrics/findings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFindingsMetricsInput{}
	}

	output = &ListFindingsMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFindingsMetrics API operation for Amazon CodeGuru Security.
//
// Returns metrics about all findings in an account within a specified time
// range.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation ListFindingsMetrics for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListFindingsMetrics
func (c *CodeGuruSecurity) ListFindingsMetrics(input *ListFindingsMetricsInput) (*ListFindingsMetricsOutput, error) {
	req, out := c.ListFindingsMetricsRequest(input)
	return out, req.Send()
}

// ListFindingsMetricsWithContext is the same as ListFindingsMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See ListFindingsMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) ListFindingsMetricsWithContext(ctx aws.Context, input *ListFindingsMetricsInput, opts ...request.Option) (*ListFindingsMetricsOutput, error) {
	req, out := c.ListFindingsMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFindingsMetricsPages iterates over the pages of a ListFindingsMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFindingsMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFindingsMetrics operation.
//	pageNum := 0
//	err := client.ListFindingsMetricsPages(params,
//	    func(page *codegurusecurity.ListFindingsMetricsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeGuruSecurity) ListFindingsMetricsPages(input *ListFindingsMetricsInput, fn func(*ListFindingsMetricsOutput, bool) bool) error {
	return c.ListFindingsMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFindingsMetricsPagesWithContext same as ListFindingsMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) ListFindingsMetricsPagesWithContext(ctx aws.Context, input *ListFindingsMetricsInput, fn func(*ListFindingsMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFindingsMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFindingsMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFindingsMetricsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListScans = "ListScans"

// ListScansRequest generates a "aws/request.Request" representing the
// client's request for the ListScans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScans for more information on using the ListScans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScansRequest method.
//	req, resp := client.ListScansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListScans
func (c *CodeGuruSecurity) ListScansRequest(input *ListScansInput) (req *request.Request, output *ListScansOutput) {
	op := &request.Operation{
		Name:       opListScans,
		HTTPMethod: "GET",
		HTTPPath:   "/scans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScansInput{}
	}

	output = &ListScansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScans API operation for Amazon CodeGuru Security.
//
// Returns a list of all the scans in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation ListScans for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListScans
func (c *CodeGuruSecurity) ListScans(input *ListScansInput) (*ListScansOutput, error) {
	req, out := c.ListScansRequest(input)
	return out, req.Send()
}

// ListScansWithContext is the same as ListScans with the addition of
// the ability to pass a context and additional request options.
//
// See ListScans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) ListScansWithContext(ctx aws.Context, input *ListScansInput, opts ...request.Option) (*ListScansOutput, error) {
	req, out := c.ListScansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScansPages iterates over the pages of a ListScans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScans operation.
//	pageNum := 0
//	err := client.ListScansPages(params,
//	    func(page *codegurusecurity.ListScansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CodeGuruSecurity) ListScansPages(input *ListScansInput, fn func(*ListScansOutput, bool) bool) error {
	return c.ListScansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScansPagesWithContext same as ListScansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) ListScansPagesWithContext(ctx aws.Context, input *ListScansInput, fn func(*ListScansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListTagsForResource
func (c *CodeGuruSecurity) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CodeGuru Security.
//
// Returns a list of all tags associated with a scan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ListTagsForResource
func (c *CodeGuruSecurity) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/TagResource
func (c *CodeGuruSecurity) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CodeGuru Security.
//
// Use to add one or more tags to an existing scan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/TagResource
func (c *CodeGuruSecurity) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UntagResource
func (c *CodeGuruSecurity) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CodeGuru Security.
//
// Use to remove one or more tags from an existing scan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UntagResource
func (c *CodeGuruSecurity) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountConfiguration = "UpdateAccountConfiguration"

// UpdateAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountConfiguration for more information on using the UpdateAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountConfigurationRequest method.
//	req, resp := client.UpdateAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UpdateAccountConfiguration
func (c *CodeGuruSecurity) UpdateAccountConfigurationRequest(input *UpdateAccountConfigurationInput) (req *request.Request, output *UpdateAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/updateAccountConfiguration",
	}

	if input == nil {
		input = &UpdateAccountConfigurationInput{}
	}

	output = &UpdateAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountConfiguration API operation for Amazon CodeGuru Security.
//
// Use to update account-level configuration with an encryption key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CodeGuru Security's
// API operation UpdateAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The server encountered an internal error and is unable to complete the request.
//
//   - ResourceNotFoundException
//     The resource specified in the request was not found.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the specified constraints.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/UpdateAccountConfiguration
func (c *CodeGuruSecurity) UpdateAccountConfiguration(input *UpdateAccountConfigurationInput) (*UpdateAccountConfigurationOutput, error) {
	req, out := c.UpdateAccountConfigurationRequest(input)
	return out, req.Send()
}

// UpdateAccountConfigurationWithContext is the same as UpdateAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeGuruSecurity) UpdateAccountConfigurationWithContext(ctx aws.Context, input *UpdateAccountConfigurationInput, opts ...request.Option) (*UpdateAccountConfigurationOutput, error) {
	req, out := c.UpdateAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The identifier for the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the resource you don't have access to.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The type of resource you don't have access to.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A summary of findings metrics in an account.
type AccountFindingsMetric struct {
	_ struct{} `type:"structure"`

	// The number of closed findings of each severity in an account on the specified
	// date.
	ClosedFindings *FindingMetricsValuePerSeverity `locationName:"closedFindings" type:"structure"`

	// The date from which the finding metrics were retrieved.
	Date *time.Time `locationName:"date" type:"timestamp"`

	// The average time it takes to close findings of each severity in days.
	MeanTimeToClose *FindingMetricsValuePerSeverity `locationName:"meanTimeToClose" type:"structure"`

	// The number of new findings of each severity in account on the specified date.
	NewFindings *FindingMetricsValuePerSeverity `locationName:"newFindings" type:"structure"`

	// The number of open findings of each severity in an account as of the specified
	// date.
	OpenFindings *FindingMetricsValuePerSeverity `locationName:"openFindings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountFindingsMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountFindingsMetric) GoString() string {
	return s.String()
}

// SetClosedFindings sets the ClosedFindings field's value.
func (s *AccountFindingsMetric) SetClosedFindings(v *FindingMetricsValuePerSeverity) *AccountFindingsMetric {
	s.ClosedFindings = v
	return s
}

// SetDate sets the Date field's value.
func (s *AccountFindingsMetric) SetDate(v time.Time) *AccountFindingsMetric {
	s.Date = &v
	return s
}

// SetMeanTimeToClose sets the MeanTimeToClose field's value.
func (s *AccountFindingsMetric) SetMeanTimeToClose(v *FindingMetricsValuePerSeverity) *AccountFindingsMetric {
	s.MeanTimeToClose = v
	return s
}

// SetNewFindings sets the NewFindings field's value.
func (s *AccountFindingsMetric) SetNewFindings(v *FindingMetricsValuePerSeverity) *AccountFindingsMetric {
	s.NewFindings = v
	return s
}

// SetOpenFindings sets the OpenFindings field's value.
func (s *AccountFindingsMetric) SetOpenFindings(v *FindingMetricsValuePerSeverity) *AccountFindingsMetric {
	s.OpenFindings = v
	return s
}

// Contains information about the error that caused a finding to fail to be
// retrieved.
type BatchGetFindingsError struct {
	_ struct{} `type:"structure"`

	// A code associated with the type of error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true" enum:"ErrorCode"`

	// The finding ID of the finding that was not fetched.
	//
	// FindingId is a required field
	FindingId *string `locationName:"findingId" type:"string" required:"true"`

	// Describes the error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the scan that generated the finding.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingsError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetFindingsError) SetErrorCode(v string) *BatchGetFindingsError {
	s.ErrorCode = &v
	return s
}

// SetFindingId sets the FindingId field's value.
func (s *BatchGetFindingsError) SetFindingId(v string) *BatchGetFindingsError {
	s.FindingId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetFindingsError) SetMessage(v string) *BatchGetFindingsError {
	s.Message = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *BatchGetFindingsError) SetScanName(v string) *BatchGetFindingsError {
	s.ScanName = &v
	return s
}

type BatchGetFindingsInput struct {
	_ struct{} `type:"structure"`

	// A list of finding identifiers. Each identifier consists of a scanName and
	// a findingId. You retrieve the findingId when you call GetFindings.
	//
	// FindingIdentifiers is a required field
	FindingIdentifiers []*FindingIdentifier `locationName:"findingIdentifiers" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetFindingsInput"}
	if s.FindingIdentifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingIdentifiers"))
	}
	if s.FindingIdentifiers != nil && len(s.FindingIdentifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FindingIdentifiers", 1))
	}
	if s.FindingIdentifiers != nil {
		for i, v := range s.FindingIdentifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FindingIdentifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingIdentifiers sets the FindingIdentifiers field's value.
func (s *BatchGetFindingsInput) SetFindingIdentifiers(v []*FindingIdentifier) *BatchGetFindingsInput {
	s.FindingIdentifiers = v
	return s
}

type BatchGetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors for individual findings which were not fetched. Each BatchGetFindingsError
	// contains the scanName, findingId, errorCode and error message.
	//
	// FailedFindings is a required field
	FailedFindings []*BatchGetFindingsError `locationName:"failedFindings" type:"list" required:"true"`

	// A list of all requested findings.
	//
	// Findings is a required field
	Findings []*Finding `locationName:"findings" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetFindingsOutput) GoString() string {
	return s.String()
}

// SetFailedFindings sets the FailedFindings field's value.
func (s *BatchGetFindingsOutput) SetFailedFindings(v []*BatchGetFindingsError) *BatchGetFindingsOutput {
	s.FailedFindings = v
	return s
}

// SetFindings sets the Findings field's value.
func (s *BatchGetFindingsOutput) SetFindings(v []*Finding) *BatchGetFindingsOutput {
	s.Findings = v
	return s
}

// Information about a finding category with open findings.
type CategoryWithFindingNum struct {
	_ struct{} `type:"structure"`

	// The name of the finding category. A finding category is determined by the
	// detector that detected the finding.
	CategoryName *string `locationName:"categoryName" type:"string"`

	// The number of open findings in the category.
	FindingNumber *int64 `locationName:"findingNumber" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryWithFindingNum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryWithFindingNum) GoString() string {
	return s.String()
}

// SetCategoryName sets the CategoryName field's value.
func (s *CategoryWithFindingNum) SetCategoryName(v string) *CategoryWithFindingNum {
	s.CategoryName = &v
	return s
}

// SetFindingNumber sets the FindingNumber field's value.
func (s *CategoryWithFindingNum) SetFindingNumber(v int64) *CategoryWithFindingNum {
	s.FindingNumber = &v
	return s
}

// The line of code where a finding was detected.
type CodeLine struct {
	_ struct{} `type:"structure"`

	// The code that contains a vulnerability.
	Content *string `locationName:"content" type:"string"`

	// The code line number.
	Number *int64 `locationName:"number" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeLine) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeLine) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *CodeLine) SetContent(v string) *CodeLine {
	s.Content = &v
	return s
}

// SetNumber sets the Number field's value.
func (s *CodeLine) SetNumber(v int64) *CodeLine {
	s.Number = &v
	return s
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The identifier for the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the service resource associated with the request.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource associated with the request.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateScanInput struct {
	_ struct{} `type:"structure"`

	// The type of analysis you want CodeGuru Security to perform in the scan, either
	// Security or All. The Secuirty type only generates findings related to security.
	// The All type generates both security findings and quality findings. Defaults
	// to Security type if missing.
	AnalysisType *string `locationName:"analysisType" type:"string" enum:"AnalysisType"`

	// The idempotency token for the request. Amazon CodeGuru Security uses this
	// value to prevent the accidental creation of duplicate scans if there are
	// failures and retries.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The identifier for an input resource used to create a scan.
	//
	// ResourceId is a required field
	ResourceId *ResourceId `locationName:"resourceId" type:"structure" required:"true"`

	// The unique name that CodeGuru Security uses to track revisions across multiple
	// scans of the same resource. Only allowed for a STANDARD scan type. If not
	// specified, it will be auto generated.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`

	// The type of scan, either Standard or Express. Defaults to Standard type if
	// missing.
	//
	// Express scans run on limited resources and use a limited set of detectors
	// to analyze your code in near-real time. Standard scans have standard resource
	// limits and use the full set of detectors to analyze your code.
	ScanType *string `locationName:"scanType" type:"string" enum:"ScanType"`

	// An array of key-value pairs used to tag a scan. A tag is a custom attribute
	// label with two parts:
	//
	//    * A tag key. For example, CostCenter, Environment, or Secret. Tag keys
	//    are case sensitive.
	//
	//    * An optional tag value field. For example, 111122223333, Production,
	//    or a team name. Omitting the tag value is the same as using an empty string.
	//    Tag values are case sensitive.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScanInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ScanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanName"))
	}
	if s.ScanName != nil && len(*s.ScanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisType sets the AnalysisType field's value.
func (s *CreateScanInput) SetAnalysisType(v string) *CreateScanInput {
	s.AnalysisType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateScanInput) SetClientToken(v string) *CreateScanInput {
	s.ClientToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateScanInput) SetResourceId(v *ResourceId) *CreateScanInput {
	s.ResourceId = v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *CreateScanInput) SetScanName(v string) *CreateScanInput {
	s.ScanName = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *CreateScanInput) SetScanType(v string) *CreateScanInput {
	s.ScanType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScanInput) SetTags(v map[string]*string) *CreateScanInput {
	s.Tags = v
	return s
}

type CreateScanOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource object that contains resources that were
	// scanned.
	//
	// ResourceId is a required field
	ResourceId *ResourceId `locationName:"resourceId" type:"structure" required:"true"`

	// UUID that identifies the individual scan run.
	//
	// RunId is a required field
	RunId *string `locationName:"runId" type:"string" required:"true"`

	// The name of the scan.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`

	// The ARN for the scan name.
	ScanNameArn *string `locationName:"scanNameArn" min:"1" type:"string"`

	// The current state of the scan. Returns either InProgress, Successful, or
	// Failed.
	//
	// ScanState is a required field
	ScanState *string `locationName:"scanState" type:"string" required:"true" enum:"ScanState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScanOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateScanOutput) SetResourceId(v *ResourceId) *CreateScanOutput {
	s.ResourceId = v
	return s
}

// SetRunId sets the RunId field's value.
func (s *CreateScanOutput) SetRunId(v string) *CreateScanOutput {
	s.RunId = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *CreateScanOutput) SetScanName(v string) *CreateScanOutput {
	s.ScanName = &v
	return s
}

// SetScanNameArn sets the ScanNameArn field's value.
func (s *CreateScanOutput) SetScanNameArn(v string) *CreateScanOutput {
	s.ScanNameArn = &v
	return s
}

// SetScanState sets the ScanState field's value.
func (s *CreateScanOutput) SetScanState(v string) *CreateScanOutput {
	s.ScanState = &v
	return s
}

type CreateUploadUrlInput struct {
	_ struct{} `type:"structure"`

	// The name of the scan that will use the uploaded resource. CodeGuru Security
	// uses the unique scan name to track revisions across multiple scans of the
	// same resource. Use this scanName when you call CreateScan on the code resource
	// you upload to this URL.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUploadUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUploadUrlInput"}
	if s.ScanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanName"))
	}
	if s.ScanName != nil && len(*s.ScanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScanName sets the ScanName field's value.
func (s *CreateUploadUrlInput) SetScanName(v string) *CreateUploadUrlInput {
	s.ScanName = &v
	return s
}

type CreateUploadUrlOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the uploaded code resource.
	//
	// CodeArtifactId is a required field
	CodeArtifactId *string `locationName:"codeArtifactId" type:"string" required:"true"`

	// A set of key-value pairs that contain the required headers when uploading
	// your resource.
	//
	// RequestHeaders is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUploadUrlOutput's
	// String and GoString methods.
	//
	// RequestHeaders is a required field
	RequestHeaders map[string]*string `locationName:"requestHeaders" type:"map" required:"true" sensitive:"true"`

	// A pre-signed S3 URL. You can upload the code file you want to scan and add
	// the required requestHeaders using any HTTP client.
	//
	// S3Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateUploadUrlOutput's
	// String and GoString methods.
	//
	// S3Url is a required field
	S3Url *string `locationName:"s3Url" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUploadUrlOutput) GoString() string {
	return s.String()
}

// SetCodeArtifactId sets the CodeArtifactId field's value.
func (s *CreateUploadUrlOutput) SetCodeArtifactId(v string) *CreateUploadUrlOutput {
	s.CodeArtifactId = &v
	return s
}

// SetRequestHeaders sets the RequestHeaders field's value.
func (s *CreateUploadUrlOutput) SetRequestHeaders(v map[string]*string) *CreateUploadUrlOutput {
	s.RequestHeaders = v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *CreateUploadUrlOutput) SetS3Url(v string) *CreateUploadUrlOutput {
	s.S3Url = &v
	return s
}

// Information about account-level configuration.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The KMS key ARN to use for encryption. This must be provided as a header
	// when uploading your code resource.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfig"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *EncryptionConfig) SetKmsKeyArn(v string) *EncryptionConfig {
	s.KmsKeyArn = &v
	return s
}

// Information about the location of security vulnerabilities that Amazon CodeGuru
// Security detected in your code.
type FilePath struct {
	_ struct{} `type:"structure"`

	// A list of CodeLine objects that describe where the security vulnerability
	// appears in your code.
	CodeSnippet []*CodeLine `locationName:"codeSnippet" type:"list"`

	// The last line number of the code snippet where the security vulnerability
	// appears in your code.
	EndLine *int64 `locationName:"endLine" type:"integer"`

	// The name of the file.
	Name *string `locationName:"name" type:"string"`

	// The path to the resource with the security vulnerability.
	Path *string `locationName:"path" type:"string"`

	// The first line number of the code snippet where the security vulnerability
	// appears in your code.
	StartLine *int64 `locationName:"startLine" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilePath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilePath) GoString() string {
	return s.String()
}

// SetCodeSnippet sets the CodeSnippet field's value.
func (s *FilePath) SetCodeSnippet(v []*CodeLine) *FilePath {
	s.CodeSnippet = v
	return s
}

// SetEndLine sets the EndLine field's value.
func (s *FilePath) SetEndLine(v int64) *FilePath {
	s.EndLine = &v
	return s
}

// SetName sets the Name field's value.
func (s *FilePath) SetName(v string) *FilePath {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *FilePath) SetPath(v string) *FilePath {
	s.Path = &v
	return s
}

// SetStartLine sets the StartLine field's value.
func (s *FilePath) SetStartLine(v int64) *FilePath {
	s.StartLine = &v
	return s
}

// Information about a finding that was detected in your code.
type Finding struct {
	_ struct{} `type:"structure"`

	// The time when the finding was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A description of the finding.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the detector that detected the finding in your code. A
	// detector is a defined rule based on industry standards and AWS best practices.
	DetectorId *string `locationName:"detectorId" type:"string"`

	// The name of the detector that identified the security vulnerability in your
	// code.
	DetectorName *string `locationName:"detectorName" type:"string"`

	// One or more tags or categorizations that are associated with a detector.
	// These tags are defined by type, programming language, or other classification
	// such as maintainability or consistency.
	DetectorTags []*string `locationName:"detectorTags" type:"list"`

	// The identifier for the component that generated a finding such as AWSCodeGuruSecurity
	// or AWSInspector.
	GeneratorId *string `locationName:"generatorId" type:"string"`

	// The identifier for a finding.
	Id *string `locationName:"id" type:"string"`

	// An object that contains the details about how to remediate a finding.
	Remediation *Remediation `locationName:"remediation" type:"structure"`

	// The resource where Amazon CodeGuru Security detected a finding.
	Resource *Resource `locationName:"resource" type:"structure"`

	// The identifier for the rule that generated the finding.
	RuleId *string `locationName:"ruleId" type:"string"`

	// The severity of the finding.
	Severity *string `locationName:"severity" type:"string" enum:"Severity"`

	// The status of the finding. A finding status can be open or closed.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The title of the finding.
	Title *string `locationName:"title" type:"string"`

	// The type of finding.
	Type *string `locationName:"type" type:"string"`

	// The time when the finding was last updated. Findings are updated when you
	// remediate them or when the finding code location changes.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// An object that describes the detected security vulnerability.
	Vulnerability *Vulnerability `locationName:"vulnerability" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Finding) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Finding) SetCreatedAt(v time.Time) *Finding {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Finding) SetDescription(v string) *Finding {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Finding) SetDetectorId(v string) *Finding {
	s.DetectorId = &v
	return s
}

// SetDetectorName sets the DetectorName field's value.
func (s *Finding) SetDetectorName(v string) *Finding {
	s.DetectorName = &v
	return s
}

// SetDetectorTags sets the DetectorTags field's value.
func (s *Finding) SetDetectorTags(v []*string) *Finding {
	s.DetectorTags = v
	return s
}

// SetGeneratorId sets the GeneratorId field's value.
func (s *Finding) SetGeneratorId(v string) *Finding {
	s.GeneratorId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Finding) SetId(v string) *Finding {
	s.Id = &v
	return s
}

// SetRemediation sets the Remediation field's value.
func (s *Finding) SetRemediation(v *Remediation) *Finding {
	s.Remediation = v
	return s
}

// SetResource sets the Resource field's value.
func (s *Finding) SetResource(v *Resource) *Finding {
	s.Resource = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *Finding) SetRuleId(v string) *Finding {
	s.RuleId = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Finding) SetSeverity(v string) *Finding {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Finding) SetStatus(v string) *Finding {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Finding) SetTitle(v string) *Finding {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *Finding) SetType(v string) *Finding {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Finding) SetUpdatedAt(v time.Time) *Finding {
	s.UpdatedAt = &v
	return s
}

// SetVulnerability sets the Vulnerability field's value.
func (s *Finding) SetVulnerability(v *Vulnerability) *Finding {
	s.Vulnerability = v
	return s
}

// An object that contains information about a finding and the scan that generated
// it.
type FindingIdentifier struct {
	_ struct{} `type:"structure"`

	// The identifier for a finding.
	//
	// FindingId is a required field
	FindingId *string `locationName:"findingId" type:"string" required:"true"`

	// The name of the scan that generated the finding.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FindingIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FindingIdentifier"}
	if s.FindingId == nil {
		invalidParams.Add(request.NewErrParamRequired("FindingId"))
	}
	if s.ScanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFindingId sets the FindingId field's value.
func (s *FindingIdentifier) SetFindingId(v string) *FindingIdentifier {
	s.FindingId = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *FindingIdentifier) SetScanName(v string) *FindingIdentifier {
	s.ScanName = &v
	return s
}

// The severity of the issue in the code that generated a finding.
type FindingMetricsValuePerSeverity struct {
	_ struct{} `type:"structure"`

	// The severity of the finding is critical and should be addressed immediately.
	Critical *float64 `locationName:"critical" type:"double"`

	// The severity of the finding is high and should be addressed as a near-term
	// priority.
	High *float64 `locationName:"high" type:"double"`

	// The finding is related to quality or readability improvements and not considered
	// actionable.
	Info *float64 `locationName:"info" type:"double"`

	// The severity of the finding is low and does require action on its own.
	Low *float64 `locationName:"low" type:"double"`

	// The severity of the finding is medium and should be addressed as a mid-term
	// priority.
	Medium *float64 `locationName:"medium" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingMetricsValuePerSeverity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FindingMetricsValuePerSeverity) GoString() string {
	return s.String()
}

// SetCritical sets the Critical field's value.
func (s *FindingMetricsValuePerSeverity) SetCritical(v float64) *FindingMetricsValuePerSeverity {
	s.Critical = &v
	return s
}

// SetHigh sets the High field's value.
func (s *FindingMetricsValuePerSeverity) SetHigh(v float64) *FindingMetricsValuePerSeverity {
	s.High = &v
	return s
}

// SetInfo sets the Info field's value.
func (s *FindingMetricsValuePerSeverity) SetInfo(v float64) *FindingMetricsValuePerSeverity {
	s.Info = &v
	return s
}

// SetLow sets the Low field's value.
func (s *FindingMetricsValuePerSeverity) SetLow(v float64) *FindingMetricsValuePerSeverity {
	s.Low = &v
	return s
}

// SetMedium sets the Medium field's value.
func (s *FindingMetricsValuePerSeverity) SetMedium(v float64) *FindingMetricsValuePerSeverity {
	s.Medium = &v
	return s
}

type GetAccountConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountConfigurationInput) GoString() string {
	return s.String()
}

type GetAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An EncryptionConfig object that contains the KMS key ARN to use for encryption.
	// By default, CodeGuru Security uses an AWS-managed key for encryption. To
	// specify your own key, call UpdateAccountConfiguration.
	//
	// EncryptionConfig is a required field
	EncryptionConfig *EncryptionConfig `locationName:"encryptionConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *GetAccountConfigurationOutput) SetEncryptionConfig(v *EncryptionConfig) *GetAccountConfigurationOutput {
	s.EncryptionConfig = v
	return s
}

type GetFindingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response. Use this parameter
	// when paginating results. If additional results exist beyond the number you
	// specify, the nextToken element is returned in the response. Use nextToken
	// in a subsequent request to retrieve additional results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request. For subsequent
	// calls, use the nextToken value returned from the previous request to continue
	// listing results after the first page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The name of the scan you want to retrieve findings from.
	//
	// ScanName is a required field
	ScanName *string `location:"uri" locationName:"scanName" min:"1" type:"string" required:"true"`

	// The status of the findings you want to get. Pass either Open, Closed, or
	// All.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFindingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ScanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanName"))
	}
	if s.ScanName != nil && len(*s.ScanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFindingsInput) SetMaxResults(v int64) *GetFindingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsInput) SetNextToken(v string) *GetFindingsInput {
	s.NextToken = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *GetFindingsInput) SetScanName(v string) *GetFindingsInput {
	s.ScanName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetFindingsInput) SetStatus(v string) *GetFindingsInput {
	s.Status = &v
	return s
}

type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of findings generated by the specified scan.
	Findings []*Finding `locationName:"findings" type:"list"`

	// A pagination token. You can use this in future calls to GetFindings to continue
	// listing results after the current page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFindingsOutput) GoString() string {
	return s.String()
}

// SetFindings sets the Findings field's value.
func (s *GetFindingsOutput) SetFindings(v []*Finding) *GetFindingsOutput {
	s.Findings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFindingsOutput) SetNextToken(v string) *GetFindingsOutput {
	s.NextToken = &v
	return s
}

type GetMetricsSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The date you want to retrieve summary metrics from, rounded to the nearest
	// day. The date must be within the past two years since metrics data is only
	// stored for two years. If a date outside of this range is passed, the response
	// will be empty.
	//
	// Date is a required field
	Date *time.Time `location:"querystring" locationName:"date" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricsSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricsSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricsSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricsSummaryInput"}
	if s.Date == nil {
		invalidParams.Add(request.NewErrParamRequired("Date"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDate sets the Date field's value.
func (s *GetMetricsSummaryInput) SetDate(v time.Time) *GetMetricsSummaryInput {
	s.Date = &v
	return s
}

type GetMetricsSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The summary metrics from the specified date.
	MetricsSummary *MetricsSummary `locationName:"metricsSummary" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricsSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMetricsSummaryOutput) GoString() string {
	return s.String()
}

// SetMetricsSummary sets the MetricsSummary field's value.
func (s *GetMetricsSummaryOutput) SetMetricsSummary(v *MetricsSummary) *GetMetricsSummaryOutput {
	s.MetricsSummary = v
	return s
}

type GetScanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// UUID that identifies the individual scan run you want to view details about.
	// You retrieve this when you call the CreateScan operation. Defaults to the
	// latest scan run if missing.
	RunId *string `location:"querystring" locationName:"runId" type:"string"`

	// The name of the scan you want to view details about.
	//
	// ScanName is a required field
	ScanName *string `location:"uri" locationName:"scanName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScanInput"}
	if s.ScanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScanName"))
	}
	if s.ScanName != nil && len(*s.ScanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRunId sets the RunId field's value.
func (s *GetScanInput) SetRunId(v string) *GetScanInput {
	s.RunId = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *GetScanInput) SetScanName(v string) *GetScanInput {
	s.ScanName = &v
	return s
}

type GetScanOutput struct {
	_ struct{} `type:"structure"`

	// The type of analysis CodeGuru Security performed in the scan, either Security
	// or All. The Security type only generates findings related to security. The
	// All type generates both security findings and quality findings.
	//
	// AnalysisType is a required field
	AnalysisType *string `locationName:"analysisType" type:"string" required:"true" enum:"AnalysisType"`

	// The time the scan was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The number of times a scan has been re-run on a revised resource.
	NumberOfRevisions *int64 `locationName:"numberOfRevisions" type:"long"`

	// UUID that identifies the individual scan run.
	//
	// RunId is a required field
	RunId *string `locationName:"runId" type:"string" required:"true"`

	// The name of the scan.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`

	// The ARN for the scan name.
	ScanNameArn *string `locationName:"scanNameArn" min:"1" type:"string"`

	// The current state of the scan. Pass either InProgress, Successful, or Failed.
	//
	// ScanState is a required field
	ScanState *string `locationName:"scanState" type:"string" required:"true" enum:"ScanState"`

	// The time when the scan was last updated. Only available for STANDARD scan
	// types.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScanOutput) GoString() string {
	return s.String()
}

// SetAnalysisType sets the AnalysisType field's value.
func (s *GetScanOutput) SetAnalysisType(v string) *GetScanOutput {
	s.AnalysisType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetScanOutput) SetCreatedAt(v time.Time) *GetScanOutput {
	s.CreatedAt = &v
	return s
}

// SetNumberOfRevisions sets the NumberOfRevisions field's value.
func (s *GetScanOutput) SetNumberOfRevisions(v int64) *GetScanOutput {
	s.NumberOfRevisions = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *GetScanOutput) SetRunId(v string) *GetScanOutput {
	s.RunId = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *GetScanOutput) SetScanName(v string) *GetScanOutput {
	s.ScanName = &v
	return s
}

// SetScanNameArn sets the ScanNameArn field's value.
func (s *GetScanOutput) SetScanNameArn(v string) *GetScanOutput {
	s.ScanNameArn = &v
	return s
}

// SetScanState sets the ScanState field's value.
func (s *GetScanOutput) SetScanState(v string) *GetScanOutput {
	s.ScanState = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetScanOutput) SetUpdatedAt(v time.Time) *GetScanOutput {
	s.UpdatedAt = &v
	return s
}

// The server encountered an internal error and is unable to complete the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The internal error encountered by the server.
	Error_ *string `locationName:"error" type:"string"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListFindingsMetricsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The end date of the interval which you want to retrieve metrics from.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"endDate" type:"timestamp" required:"true"`

	// The maximum number of results to return in the response. Use this parameter
	// when paginating results. If additional results exist beyond the number you
	// specify, the nextToken element is returned in the response. Use nextToken
	// in a subsequent request to retrieve additional results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request. For subsequent
	// calls, use the nextToken value returned from the previous request to continue
	// listing results after the first page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The start date of the interval which you want to retrieve metrics from.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"startDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFindingsMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFindingsMetricsInput"}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDate sets the EndDate field's value.
func (s *ListFindingsMetricsInput) SetEndDate(v time.Time) *ListFindingsMetricsInput {
	s.EndDate = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFindingsMetricsInput) SetMaxResults(v int64) *ListFindingsMetricsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsMetricsInput) SetNextToken(v string) *ListFindingsMetricsInput {
	s.NextToken = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ListFindingsMetricsInput) SetStartDate(v time.Time) *ListFindingsMetricsInput {
	s.StartDate = &v
	return s
}

type ListFindingsMetricsOutput struct {
	_ struct{} `type:"structure"`

	// A list of AccountFindingsMetric objects retrieved from the specified time
	// interval.
	FindingsMetrics []*AccountFindingsMetric `locationName:"findingsMetrics" type:"list"`

	// A pagination token. You can use this in future calls to ListFindingMetrics
	// to continue listing results after the current page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFindingsMetricsOutput) GoString() string {
	return s.String()
}

// SetFindingsMetrics sets the FindingsMetrics field's value.
func (s *ListFindingsMetricsOutput) SetFindingsMetrics(v []*AccountFindingsMetric) *ListFindingsMetricsOutput {
	s.FindingsMetrics = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFindingsMetricsOutput) SetNextToken(v string) *ListFindingsMetricsOutput {
	s.NextToken = &v
	return s
}

type ListScansInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response. Use this parameter
	// when paginating results. If additional results exist beyond the number you
	// specify, the nextToken element is returned in the response. Use nextToken
	// in a subsequent request to retrieve additional results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to use for paginating results that are returned in the response.
	// Set the value of this parameter to null for the first request. For subsequent
	// calls, use the nextToken value returned from the previous request to continue
	// listing results after the first page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScansInput) SetMaxResults(v int64) *ListScansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScansInput) SetNextToken(v string) *ListScansInput {
	s.NextToken = &v
	return s
}

type ListScansOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token. You can use this in future calls to ListScans to continue
	// listing results after the current page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of ScanSummary objects with information about all scans in an account.
	Summaries []*ScanSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScansOutput) SetNextToken(v string) *ListScansOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListScansOutput) SetSummaries(v []*ScanSummary) *ListScansOutput {
	s.Summaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the ScanName object. You can retrieve this ARN by calling ListScans
	// or GetScan.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs used to tag an existing scan. A tag is a custom
	// attribute label with two parts:
	//
	//    * A tag key. For example, CostCenter, Environment, or Secret. Tag keys
	//    are case sensitive.
	//
	//    * An optional tag value field. For example, 111122223333, Production,
	//    or a team name. Omitting the tag value is the same as using an empty string.
	//    Tag values are case sensitive.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about summary metrics in an account.
type MetricsSummary struct {
	_ struct{} `type:"structure"`

	// A list of CategoryWithFindingNum objects for the top 5 finding categories
	// with the most open findings in an account.
	CategoriesWithMostFindings []*CategoryWithFindingNum `locationName:"categoriesWithMostFindings" type:"list"`

	// The date from which the metrics summary information was retrieved.
	Date *time.Time `locationName:"date" type:"timestamp"`

	// The number of open findings of each severity in an account.
	OpenFindings *FindingMetricsValuePerSeverity `locationName:"openFindings" type:"structure"`

	// A list of ScanNameWithFindingNum objects for the top 3 scans with the most
	// number of open findings in an account.
	ScansWithMostOpenCriticalFindings []*ScanNameWithFindingNum `locationName:"scansWithMostOpenCriticalFindings" type:"list"`

	// A list of ScanNameWithFindingNum objects for the top 3 scans with the most
	// number of open critical findings in an account.
	ScansWithMostOpenFindings []*ScanNameWithFindingNum `locationName:"scansWithMostOpenFindings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetricsSummary) GoString() string {
	return s.String()
}

// SetCategoriesWithMostFindings sets the CategoriesWithMostFindings field's value.
func (s *MetricsSummary) SetCategoriesWithMostFindings(v []*CategoryWithFindingNum) *MetricsSummary {
	s.CategoriesWithMostFindings = v
	return s
}

// SetDate sets the Date field's value.
func (s *MetricsSummary) SetDate(v time.Time) *MetricsSummary {
	s.Date = &v
	return s
}

// SetOpenFindings sets the OpenFindings field's value.
func (s *MetricsSummary) SetOpenFindings(v *FindingMetricsValuePerSeverity) *MetricsSummary {
	s.OpenFindings = v
	return s
}

// SetScansWithMostOpenCriticalFindings sets the ScansWithMostOpenCriticalFindings field's value.
func (s *MetricsSummary) SetScansWithMostOpenCriticalFindings(v []*ScanNameWithFindingNum) *MetricsSummary {
	s.ScansWithMostOpenCriticalFindings = v
	return s
}

// SetScansWithMostOpenFindings sets the ScansWithMostOpenFindings field's value.
func (s *MetricsSummary) SetScansWithMostOpenFindings(v []*ScanNameWithFindingNum) *MetricsSummary {
	s.ScansWithMostOpenFindings = v
	return s
}

// Information about the recommended course of action to remediate a finding.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The recommended course of action to remediate the finding.
	Text *string `locationName:"text" type:"string"`

	// The URL address to the recommendation for remediating the finding.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Recommendation) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *Recommendation) SetText(v string) *Recommendation {
	s.Text = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Recommendation) SetUrl(v string) *Recommendation {
	s.Url = &v
	return s
}

// Information about how to remediate a finding.
type Remediation struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the recommended course of action
	// to remediate a finding.
	Recommendation *Recommendation `locationName:"recommendation" type:"structure"`

	// A list of SuggestedFix objects. Each object contains information about a
	// suggested code fix to remediate the finding.
	SuggestedFixes []*SuggestedFix `locationName:"suggestedFixes" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Remediation) GoString() string {
	return s.String()
}

// SetRecommendation sets the Recommendation field's value.
func (s *Remediation) SetRecommendation(v *Recommendation) *Remediation {
	s.Recommendation = v
	return s
}

// SetSuggestedFixes sets the SuggestedFixes field's value.
func (s *Remediation) SetSuggestedFixes(v []*SuggestedFix) *Remediation {
	s.SuggestedFixes = v
	return s
}

// Information about a resource, such as an Amazon S3 bucket or AWS Lambda function,
// that contains a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// The identifier for the resource.
	Id *string `locationName:"id" type:"string"`

	// The identifier for a section of the resource, such as an AWS Lambda layer.
	SubResourceId *string `locationName:"subResourceId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetSubResourceId sets the SubResourceId field's value.
func (s *Resource) SetSubResourceId(v string) *Resource {
	s.SubResourceId = &v
	return s
}

// The identifier for a resource object that contains resources where a finding
// was detected.
type ResourceId struct {
	_ struct{} `type:"structure"`

	// The identifier for the code file uploaded to the resource where a finding
	// was detected.
	CodeArtifactId *string `locationName:"codeArtifactId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceId) GoString() string {
	return s.String()
}

// SetCodeArtifactId sets the CodeArtifactId field's value.
func (s *ResourceId) SetCodeArtifactId(v string) *ResourceId {
	s.CodeArtifactId = &v
	return s
}

// The resource specified in the request was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The identifier for the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the resource that was not found.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource that was not found.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a scan with open findings.
type ScanNameWithFindingNum struct {
	_ struct{} `type:"structure"`

	// The number of open findings generated by a scan.
	FindingNumber *int64 `locationName:"findingNumber" type:"integer"`

	// The name of the scan.
	ScanName *string `locationName:"scanName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScanNameWithFindingNum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScanNameWithFindingNum) GoString() string {
	return s.String()
}

// SetFindingNumber sets the FindingNumber field's value.
func (s *ScanNameWithFindingNum) SetFindingNumber(v int64) *ScanNameWithFindingNum {
	s.FindingNumber = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *ScanNameWithFindingNum) SetScanName(v string) *ScanNameWithFindingNum {
	s.ScanName = &v
	return s
}

// Information about a scan.
type ScanSummary struct {
	_ struct{} `type:"structure"`

	// The time when the scan was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The identifier for the scan run.
	//
	// RunId is a required field
	RunId *string `locationName:"runId" type:"string" required:"true"`

	// The name of the scan.
	//
	// ScanName is a required field
	ScanName *string `locationName:"scanName" min:"1" type:"string" required:"true"`

	// The ARN for the scan name.
	ScanNameArn *string `locationName:"scanNameArn" min:"1" type:"string"`

	// The state of the scan. A scan can be In Progress, Complete, or Failed.
	//
	// ScanState is a required field
	ScanState *string `locationName:"scanState" type:"string" required:"true" enum:"ScanState"`

	// The time the scan was last updated. A scan is updated when it is re-run.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScanSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScanSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ScanSummary) SetCreatedAt(v time.Time) *ScanSummary {
	s.CreatedAt = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *ScanSummary) SetRunId(v string) *ScanSummary {
	s.RunId = &v
	return s
}

// SetScanName sets the ScanName field's value.
func (s *ScanSummary) SetScanName(v string) *ScanSummary {
	s.ScanName = &v
	return s
}

// SetScanNameArn sets the ScanNameArn field's value.
func (s *ScanSummary) SetScanNameArn(v string) *ScanSummary {
	s.ScanNameArn = &v
	return s
}

// SetScanState sets the ScanState field's value.
func (s *ScanSummary) SetScanState(v string) *ScanSummary {
	s.ScanState = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ScanSummary) SetUpdatedAt(v time.Time) *ScanSummary {
	s.UpdatedAt = &v
	return s
}

// Information about the suggested code fix to remediate a finding.
type SuggestedFix struct {
	_ struct{} `type:"structure"`

	// The suggested code to add to your file.
	Code *string `locationName:"code" type:"string"`

	// A description of the suggested code fix and why it is being suggested.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestedFix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuggestedFix) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *SuggestedFix) SetCode(v string) *SuggestedFix {
	s.Code = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SuggestedFix) SetDescription(v string) *SuggestedFix {
	s.Description = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the ScanName object. You can retrieve this ARN by calling ListScans
	// or GetScan.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// An array of key-value pairs used to tag an existing scan. A tag is a custom
	// attribute label with two parts:
	//
	//    * A tag key. For example, CostCenter, Environment, or Secret. Tag keys
	//    are case sensitive.
	//
	//    * An optional tag value field. For example, 111122223333, Production,
	//    or a team name. Omitting the tag value is the same as using an empty string.
	//    Tag values are case sensitive.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The identifier for the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The identifier for the originating quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The identifier for the originating service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the ScanName object. You can retrieve this ARN by calling ListScans
	// or GetScan.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of keys for each tag you want to remove from a scan.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccountConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The KMS key ARN you want to use for encryption. Defaults to service-side
	// encryption if missing.
	//
	// EncryptionConfig is a required field
	EncryptionConfig *EncryptionConfig `locationName:"encryptionConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountConfigurationInput"}
	if s.EncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfig"))
	}
	if s.EncryptionConfig != nil {
		if err := s.EncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *UpdateAccountConfigurationInput) SetEncryptionConfig(v *EncryptionConfig) *UpdateAccountConfigurationInput {
	s.EncryptionConfig = v
	return s
}

type UpdateAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An EncryptionConfig object that contains the KMS key ARN to use for encryption.
	//
	// EncryptionConfig is a required field
	EncryptionConfig *EncryptionConfig `locationName:"encryptionConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *UpdateAccountConfigurationOutput) SetEncryptionConfig(v *EncryptionConfig) *UpdateAccountConfigurationOutput {
	s.EncryptionConfig = v
	return s
}

// The input fails to satisfy the specified constraints.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The identifier for the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// The field that caused the error, if applicable.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// The reason the request failed validation.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Describes the exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Information about a security vulnerability that Amazon CodeGuru Security
// detected.
type Vulnerability struct {
	_ struct{} `type:"structure"`

	// An object that describes the location of the detected security vulnerability
	// in your code.
	FilePath *FilePath `locationName:"filePath" type:"structure"`

	// The identifier for the vulnerability.
	Id *string `locationName:"id" type:"string"`

	// The number of times the vulnerability appears in your code.
	ItemCount *int64 `locationName:"itemCount" type:"integer"`

	// One or more URL addresses that contain details about a vulnerability.
	ReferenceUrls []*string `locationName:"referenceUrls" type:"list"`

	// One or more vulnerabilities that are related to the vulnerability being described.
	RelatedVulnerabilities []*string `locationName:"relatedVulnerabilities" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Vulnerability) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Vulnerability) GoString() string {
	return s.String()
}

// SetFilePath sets the FilePath field's value.
func (s *Vulnerability) SetFilePath(v *FilePath) *Vulnerability {
	s.FilePath = v
	return s
}

// SetId sets the Id field's value.
func (s *Vulnerability) SetId(v string) *Vulnerability {
	s.Id = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *Vulnerability) SetItemCount(v int64) *Vulnerability {
	s.ItemCount = &v
	return s
}

// SetReferenceUrls sets the ReferenceUrls field's value.
func (s *Vulnerability) SetReferenceUrls(v []*string) *Vulnerability {
	s.ReferenceUrls = v
	return s
}

// SetRelatedVulnerabilities sets the RelatedVulnerabilities field's value.
func (s *Vulnerability) SetRelatedVulnerabilities(v []*string) *Vulnerability {
	s.RelatedVulnerabilities = v
	return s
}

const (
	// AnalysisTypeSecurity is a AnalysisType enum value
	AnalysisTypeSecurity = "Security"

	// AnalysisTypeAll is a AnalysisType enum value
	AnalysisTypeAll = "All"
)

// AnalysisType_Values returns all elements of the AnalysisType enum
func AnalysisType_Values() []string {
	return []string{
		AnalysisTypeSecurity,
		AnalysisTypeAll,
	}
}

const (
	// ErrorCodeDuplicateIdentifier is a ErrorCode enum value
	ErrorCodeDuplicateIdentifier = "DUPLICATE_IDENTIFIER"

	// ErrorCodeItemDoesNotExist is a ErrorCode enum value
	ErrorCodeItemDoesNotExist = "ITEM_DOES_NOT_EXIST"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "INTERNAL_ERROR"

	// ErrorCodeInvalidFindingId is a ErrorCode enum value
	ErrorCodeInvalidFindingId = "INVALID_FINDING_ID"

	// ErrorCodeInvalidScanName is a ErrorCode enum value
	ErrorCodeInvalidScanName = "INVALID_SCAN_NAME"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeDuplicateIdentifier,
		ErrorCodeItemDoesNotExist,
		ErrorCodeInternalError,
		ErrorCodeInvalidFindingId,
		ErrorCodeInvalidScanName,
	}
}

const (
	// ScanStateInProgress is a ScanState enum value
	ScanStateInProgress = "InProgress"

	// ScanStateSuccessful is a ScanState enum value
	ScanStateSuccessful = "Successful"

	// ScanStateFailed is a ScanState enum value
	ScanStateFailed = "Failed"
)

// ScanState_Values returns all elements of the ScanState enum
func ScanState_Values() []string {
	return []string{
		ScanStateInProgress,
		ScanStateSuccessful,
		ScanStateFailed,
	}
}

const (
	// ScanTypeStandard is a ScanType enum value
	ScanTypeStandard = "Standard"

	// ScanTypeExpress is a ScanType enum value
	ScanTypeExpress = "Express"
)

// ScanType_Values returns all elements of the ScanType enum
func ScanType_Values() []string {
	return []string{
		ScanTypeStandard,
		ScanTypeExpress,
	}
}

const (
	// SeverityCritical is a Severity enum value
	SeverityCritical = "Critical"

	// SeverityHigh is a Severity enum value
	SeverityHigh = "High"

	// SeverityMedium is a Severity enum value
	SeverityMedium = "Medium"

	// SeverityLow is a Severity enum value
	SeverityLow = "Low"

	// SeverityInfo is a Severity enum value
	SeverityInfo = "Info"
)

// Severity_Values returns all elements of the Severity enum
func Severity_Values() []string {
	return []string{
		SeverityCritical,
		SeverityHigh,
		SeverityMedium,
		SeverityLow,
		SeverityInfo,
	}
}

const (
	// StatusClosed is a Status enum value
	StatusClosed = "Closed"

	// StatusOpen is a Status enum value
	StatusOpen = "Open"

	// StatusAll is a Status enum value
	StatusAll = "All"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusClosed,
		StatusOpen,
		StatusAll,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"

	// ValidationExceptionReasonLambdaCodeShaMisMatch is a ValidationExceptionReason enum value
	ValidationExceptionReasonLambdaCodeShaMisMatch = "lambdaCodeShaMisMatch"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
		ValidationExceptionReasonLambdaCodeShaMisMatch,
	}
}
