/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    transient Object[] queue;
    private int size;
    private final Comparator<? super E> comparator;
    transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public PriorityQueue() {
    }

    public PriorityQueue(int n) {
    }

    public PriorityQueue(Comparator<? super E> comparator) {
    }

    public PriorityQueue(int n, Comparator<? super E> comparator) {
    }

    public PriorityQueue(Collection<? extends E> collection) {
    }

    public PriorityQueue(PriorityQueue<? extends E> priorityQueue) {
    }

    public PriorityQueue(SortedSet<? extends E> sortedSet) {
    }

    @Override
    public boolean add(E e) {
        return false;
    }

    @Override
    public boolean offer(E e) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public E poll() {
        return null;
    }

    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public final Spliterator<E> spliterator() {
        return null;
    }

    final class PriorityQueueSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        PriorityQueueSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = PriorityQueue.this.modCount;
                hi = this.fence = PriorityQueue.this.size;
            }
            return hi;
        }

        public PriorityQueueSpliterator trySplit() {
            PriorityQueueSpliterator priorityQueueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                priorityQueueSpliterator = null;
            } else {
                this.index = mid;
                PriorityQueueSpliterator priorityQueueSpliterator2 = new PriorityQueueSpliterator(lo, this.index, this.expectedModCount);
                priorityQueueSpliterator = priorityQueueSpliterator2;
            }
            return priorityQueueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Object e;
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.fence < 0) {
                this.fence = PriorityQueue.this.size;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
            Object[] es = PriorityQueue.this.queue;
            this.index = hi = this.fence;
            for (int i = this.index; i < hi && (e = es[i]) != null; ++i) {
                action.accept(e);
            }
            if (PriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.fence < 0) {
                this.fence = PriorityQueue.this.size;
                this.expectedModCount = PriorityQueue.this.modCount;
            }
            if ((i = this.index) < this.fence) {
                this.index = i + 1;
                Object e = PriorityQueue.this.queue[i];
                if (e == null || PriorityQueue.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                action.accept(e);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }

    private final class Itr
    implements Iterator<E> {
        private int cursor;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private int expectedModCount;

        Itr() {
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }
}

