/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyBodyResolveStateKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyTypeParametersChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyTypeParametersChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyTypeParametersChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyTypeParametersChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,48:1\n1205#2,2:49\n1282#2,4:51\n1915#2,2:56\n812#2,12:58\n1586#2:70\n1661#2,3:71\n832#2:74\n862#2,2:75\n1915#2,2:77\n1915#2,2:81\n1#3:55\n14060#4,2:79\n*S KotlinDebug\n*F\n+ 1 FirPropertyTypeParametersChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyTypeParametersChecker\n*L\n27#1:49,2\n27#1:51,4\n40#1:56,2\n42#1:58,12\n42#1:70\n42#1:71,3\n43#1:74\n43#1:75,2\n43#1:77,2\n35#1:81,2\n33#1:79,2\n*E\n"})
public final class FirPropertyTypeParametersChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyTypeParametersChecker INSTANCE = new FirPropertyTypeParametersChecker();

    private FirPropertyTypeParametersChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Object it;
        Iterator $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (FirPropertyBodyResolveStateKt.isLocal(declaration)) {
            return;
        }
        Iterable $this$associate$iv = declaration.getTypeParameters();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Map map = destination$iv$iv;
            it = (FirTypeParameter)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to(((FirTypeParameter)it).getName(), ((FirTypeParameter)it).getSymbol().getResolvedBounds());
            map.put(((Pair)it).getFirst(), ((Pair)it).getSecond());
        }
        Map boundsByName = destination$iv$iv;
        Set usedTypes = new LinkedHashSet();
        FirPureAbstractElement firPureAbstractElement = declaration.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it2 = firPureAbstractElement;
            boolean bl = false;
            FirPropertyTypeParametersChecker.check$collectAllTypes(usedTypes, boundsByName, FirTypeUtilsKt.getConeType((FirTypeRef)it2));
        }
        Iterable $this$forEach$iv2 = declaration.getContextParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            FirValueParameter it3 = (FirValueParameter)element$iv2;
            boolean bl = false;
            FirPropertyTypeParametersChecker.check$collectAllTypes(usedTypes, boundsByName, FirTypeUtilsKt.getConeType(it3.getReturnTypeRef()));
        }
        Iterable $this$filterIsInstance$iv = usedTypes;
        boolean $i$f$filterIsInstance = false;
        element$iv2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConeTypeParameterType)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConeTypeParameterType)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((ConeTypeParameterType)it).getLookupTag().getName());
        }
        List usedNames = (List)destination$iv$iv2;
        Iterable $this$filterNot$iv = declaration.getTypeParameters();
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (FirTypeParameter)element$iv$iv;
            boolean bl = false;
            if (usedNames.contains(((FirTypeParameter)it).getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            FirTypeParameter danglingParam = (FirTypeParameter)element$iv3;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)danglingParam.getSource(), FirErrors.INSTANCE.getINCORRECT_TYPE_PARAMETER_OF_PROPERTY(), null, 8, null);
        }
    }

    private static final void check$collectAllTypes(Set<ConeKotlinType> usedTypes, Map<Name, ? extends List<? extends FirResolvedTypeRef>> boundsByName, ConeKotlinType type) {
        block4: {
            Object it;
            ConeSimpleKotlinType unwrappedType = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type);
            if (!usedTypes.add(unwrappedType)) break block4;
            ConeTypeProjection[] $this$forEach$iv = unwrappedType.getTypeArguments();
            boolean $i$f$forEach = false;
            for (ConeTypeProjection element$iv : $this$forEach$iv) {
                ConeKotlinType p0;
                it = element$iv;
                boolean bl = false;
                if (ConeTypeProjectionKt.getType((ConeTypeProjection)it) == null) continue;
                boolean bl2 = false;
                FirPropertyTypeParametersChecker.check$collectAllTypes(usedTypes, boundsByName, p0);
            }
            if (unwrappedType instanceof ConeTypeParameterType) {
                List<? extends FirResolvedTypeRef> list = boundsByName.get(((ConeTypeParameterType)unwrappedType).getLookupTag().getName());
                if (list != null) {
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (ConeTypeProjection element$iv : $this$forEach$iv2) {
                        it = (FirResolvedTypeRef)((Object)element$iv);
                        boolean bl = false;
                        FirPropertyTypeParametersChecker.check$collectAllTypes(usedTypes, boundsByName, ((FirResolvedTypeRef)it).getConeType());
                    }
                }
            }
        }
    }
}

