#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5998
#define LARGE_STATE_COUNT 1167
#define SYMBOL_COUNT 398
#define ALIAS_COUNT 7
#define TOKEN_COUNT 175
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 44
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 352

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_with = 16,
  anon_sym_assert = 17,
  anon_sym_var = 18,
  anon_sym_let = 19,
  anon_sym_const = 20,
  anon_sym_BANG = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_switch = 24,
  anon_sym_for = 25,
  anon_sym_LPAREN = 26,
  anon_sym_SEMI = 27,
  anon_sym_RPAREN = 28,
  anon_sym_await = 29,
  anon_sym_in = 30,
  anon_sym_of = 31,
  anon_sym_while = 32,
  anon_sym_do = 33,
  anon_sym_try = 34,
  anon_sym_break = 35,
  anon_sym_continue = 36,
  anon_sym_debugger = 37,
  anon_sym_return = 38,
  anon_sym_throw = 39,
  anon_sym_COLON = 40,
  anon_sym_case = 41,
  anon_sym_catch = 42,
  anon_sym_finally = 43,
  anon_sym_yield = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  sym__glimmer_template_content = 47,
  sym_glimmer_opening_tag = 48,
  sym_glimmer_closing_tag = 49,
  sym_html_character_reference = 50,
  anon_sym_GT = 51,
  sym_jsx_identifier = 52,
  anon_sym_DOT = 53,
  anon_sym_LT_SLASH = 54,
  anon_sym_SLASH_GT = 55,
  anon_sym_DQUOTE = 56,
  anon_sym_SQUOTE = 57,
  sym_unescaped_double_jsx_string_fragment = 58,
  sym_unescaped_single_jsx_string_fragment = 59,
  anon_sym_class = 60,
  anon_sym_async = 61,
  anon_sym_function = 62,
  anon_sym_EQ_GT = 63,
  anon_sym_QMARK_DOT = 64,
  anon_sym_new = 65,
  anon_sym_using = 66,
  anon_sym_PLUS_EQ = 67,
  anon_sym_DASH_EQ = 68,
  anon_sym_STAR_EQ = 69,
  anon_sym_SLASH_EQ = 70,
  anon_sym_PERCENT_EQ = 71,
  anon_sym_CARET_EQ = 72,
  anon_sym_AMP_EQ = 73,
  anon_sym_PIPE_EQ = 74,
  anon_sym_GT_GT_EQ = 75,
  anon_sym_GT_GT_GT_EQ = 76,
  anon_sym_LT_LT_EQ = 77,
  anon_sym_STAR_STAR_EQ = 78,
  anon_sym_AMP_AMP_EQ = 79,
  anon_sym_PIPE_PIPE_EQ = 80,
  anon_sym_QMARK_QMARK_EQ = 81,
  anon_sym_DOT_DOT_DOT = 82,
  anon_sym_AMP_AMP = 83,
  anon_sym_PIPE_PIPE = 84,
  anon_sym_GT_GT = 85,
  anon_sym_GT_GT_GT = 86,
  anon_sym_LT_LT = 87,
  anon_sym_AMP = 88,
  anon_sym_CARET = 89,
  anon_sym_PIPE = 90,
  anon_sym_PLUS = 91,
  anon_sym_DASH = 92,
  anon_sym_SLASH = 93,
  anon_sym_PERCENT = 94,
  anon_sym_STAR_STAR = 95,
  anon_sym_LT = 96,
  anon_sym_LT_EQ = 97,
  anon_sym_EQ_EQ = 98,
  anon_sym_EQ_EQ_EQ = 99,
  anon_sym_BANG_EQ = 100,
  anon_sym_BANG_EQ_EQ = 101,
  anon_sym_GT_EQ = 102,
  anon_sym_QMARK_QMARK = 103,
  anon_sym_instanceof = 104,
  anon_sym_TILDE = 105,
  anon_sym_void = 106,
  anon_sym_delete = 107,
  anon_sym_PLUS_PLUS = 108,
  anon_sym_DASH_DASH = 109,
  sym_unescaped_double_string_fragment = 110,
  sym_unescaped_single_string_fragment = 111,
  sym_escape_sequence = 112,
  sym_comment = 113,
  anon_sym_BQUOTE = 114,
  anon_sym_DOLLAR_LBRACE = 115,
  anon_sym_SLASH2 = 116,
  sym_regex_pattern = 117,
  sym_regex_flags = 118,
  sym_number = 119,
  sym_private_property_identifier = 120,
  anon_sym_target = 121,
  anon_sym_meta = 122,
  sym_this = 123,
  sym_super = 124,
  sym_true = 125,
  sym_false = 126,
  sym_null = 127,
  sym_undefined = 128,
  anon_sym_AT = 129,
  anon_sym_static = 130,
  anon_sym_readonly = 131,
  anon_sym_get = 132,
  anon_sym_set = 133,
  anon_sym_QMARK = 134,
  anon_sym_declare = 135,
  anon_sym_public = 136,
  anon_sym_private = 137,
  anon_sym_protected = 138,
  anon_sym_override = 139,
  anon_sym_module = 140,
  anon_sym_any = 141,
  anon_sym_number = 142,
  anon_sym_boolean = 143,
  anon_sym_string = 144,
  anon_sym_symbol = 145,
  anon_sym_object = 146,
  anon_sym_abstract = 147,
  anon_sym_accessor = 148,
  anon_sym_satisfies = 149,
  anon_sym_require = 150,
  anon_sym_extends = 151,
  anon_sym_implements = 152,
  anon_sym_global = 153,
  anon_sym_interface = 154,
  anon_sym_enum = 155,
  anon_sym_DASH_QMARK_COLON = 156,
  anon_sym_PLUS_QMARK_COLON = 157,
  anon_sym_QMARK_COLON = 158,
  anon_sym_asserts = 159,
  anon_sym_infer = 160,
  anon_sym_is = 161,
  anon_sym_keyof = 162,
  anon_sym_unique = 163,
  anon_sym_unknown = 164,
  anon_sym_never = 165,
  anon_sym_LBRACE_PIPE = 166,
  anon_sym_PIPE_RBRACE = 167,
  sym__automatic_semicolon = 168,
  sym__template_chars = 169,
  sym__ternary_qmark = 170,
  sym_html_comment = 171,
  sym_jsx_text = 172,
  sym__function_signature_automatic_semicolon = 173,
  sym___error_recovery = 174,
  sym_program = 175,
  sym_export_statement = 176,
  sym_namespace_export = 177,
  sym_export_clause = 178,
  sym_export_specifier = 179,
  sym__module_export_name = 180,
  sym_declaration = 181,
  sym_import = 182,
  sym_import_statement = 183,
  sym_import_clause = 184,
  sym__from_clause = 185,
  sym_namespace_import = 186,
  sym_named_imports = 187,
  sym_import_specifier = 188,
  sym_import_attribute = 189,
  sym_statement = 190,
  sym_expression_statement = 191,
  sym_variable_declaration = 192,
  sym_lexical_declaration = 193,
  sym_variable_declarator = 194,
  sym_statement_block = 195,
  sym_else_clause = 196,
  sym_if_statement = 197,
  sym_switch_statement = 198,
  sym_for_statement = 199,
  sym_for_in_statement = 200,
  sym__for_header = 201,
  sym_while_statement = 202,
  sym_do_statement = 203,
  sym_try_statement = 204,
  sym_with_statement = 205,
  sym_break_statement = 206,
  sym_continue_statement = 207,
  sym_debugger_statement = 208,
  sym_return_statement = 209,
  sym_throw_statement = 210,
  sym_empty_statement = 211,
  sym_labeled_statement = 212,
  sym_switch_body = 213,
  sym_switch_case = 214,
  sym_switch_default = 215,
  sym_catch_clause = 216,
  sym_finally_clause = 217,
  sym_parenthesized_expression = 218,
  sym_expression = 219,
  sym_primary_expression = 220,
  sym_yield_expression = 221,
  sym_object = 222,
  sym_object_pattern = 223,
  sym_assignment_pattern = 224,
  sym_object_assignment_pattern = 225,
  sym_array = 226,
  sym_array_pattern = 227,
  sym_glimmer_template = 228,
  sym_jsx_element = 229,
  sym_jsx_expression = 230,
  sym_jsx_opening_element = 231,
  sym_nested_identifier = 232,
  sym_jsx_namespace_name = 233,
  sym_jsx_closing_element = 234,
  sym_jsx_self_closing_element = 235,
  sym_jsx_attribute = 236,
  sym__jsx_string = 237,
  sym_class = 238,
  sym_class_declaration = 239,
  sym_class_heritage = 240,
  sym_function_expression = 241,
  sym_function_declaration = 242,
  sym_generator_function = 243,
  sym_generator_function_declaration = 244,
  sym_arrow_function = 245,
  sym__call_signature = 246,
  sym__formal_parameter = 247,
  sym_optional_chain = 248,
  sym_call_expression = 249,
  sym_new_expression = 250,
  sym_await_expression = 251,
  sym_member_expression = 252,
  sym_subscript_expression = 253,
  sym_assignment_expression = 254,
  sym__augmented_assignment_lhs = 255,
  sym_augmented_assignment_expression = 256,
  sym__initializer = 257,
  sym__destructuring_pattern = 258,
  sym_spread_element = 259,
  sym_ternary_expression = 260,
  sym_binary_expression = 261,
  sym_unary_expression = 262,
  sym_update_expression = 263,
  sym_sequence_expression = 264,
  sym_string = 265,
  sym_template_string = 266,
  sym_template_substitution = 267,
  sym_regex = 268,
  sym_meta_property = 269,
  sym_arguments = 270,
  sym_decorator = 271,
  sym_decorator_member_expression = 272,
  sym_decorator_call_expression = 273,
  sym_class_body = 274,
  sym_formal_parameters = 275,
  sym_class_static_block = 276,
  sym_pattern = 277,
  sym_rest_pattern = 278,
  sym_method_definition = 279,
  sym_pair = 280,
  sym_pair_pattern = 281,
  sym__property_name = 282,
  sym_computed_property_name = 283,
  sym_public_field_definition = 284,
  sym__import_identifier = 285,
  sym_non_null_expression = 286,
  sym_method_signature = 287,
  sym_abstract_method_signature = 288,
  sym_function_signature = 289,
  sym_decorator_parenthesized_expression = 290,
  sym_as_expression = 291,
  sym_satisfies_expression = 292,
  sym_instantiation_expression = 293,
  sym_import_require_clause = 294,
  sym_extends_clause = 295,
  sym__extends_clause_single = 296,
  sym_implements_clause = 297,
  sym_ambient_declaration = 298,
  sym_abstract_class_declaration = 299,
  sym_module = 300,
  sym_internal_module = 301,
  sym__module = 302,
  sym_import_alias = 303,
  sym_nested_type_identifier = 304,
  sym_interface_declaration = 305,
  sym_extends_type_clause = 306,
  sym_enum_declaration = 307,
  sym_enum_body = 308,
  sym_enum_assignment = 309,
  sym_type_alias_declaration = 310,
  sym_accessibility_modifier = 311,
  sym_override_modifier = 312,
  sym_required_parameter = 313,
  sym_optional_parameter = 314,
  sym__parameter_name = 315,
  sym_omitting_type_annotation = 316,
  sym_adding_type_annotation = 317,
  sym_opting_type_annotation = 318,
  sym_type_annotation = 319,
  sym__type_query_member_expression_in_type_annotation = 320,
  sym__type_query_call_expression_in_type_annotation = 321,
  sym_asserts = 322,
  sym_asserts_annotation = 323,
  sym_type = 324,
  sym_tuple_parameter = 325,
  sym_optional_tuple_parameter = 326,
  sym_optional_type = 327,
  sym_rest_type = 328,
  sym__tuple_type_member = 329,
  sym_constructor_type = 330,
  sym_primary_type = 331,
  sym_template_type = 332,
  sym_template_literal_type = 333,
  sym_infer_type = 334,
  sym_conditional_type = 335,
  sym_generic_type = 336,
  sym_type_predicate = 337,
  sym_type_predicate_annotation = 338,
  sym__type_query_member_expression = 339,
  sym__type_query_subscript_expression = 340,
  sym__type_query_call_expression = 341,
  sym__type_query_instantiation_expression = 342,
  sym_type_query = 343,
  sym_index_type_query = 344,
  sym_lookup_type = 345,
  sym_mapped_type_clause = 346,
  sym_literal_type = 347,
  sym__number = 348,
  sym_existential_type = 349,
  sym_flow_maybe_type = 350,
  sym_parenthesized_type = 351,
  sym_predefined_type = 352,
  sym_type_arguments = 353,
  sym_object_type = 354,
  sym_call_signature = 355,
  sym_property_signature = 356,
  sym_type_parameters = 357,
  sym_type_parameter = 358,
  sym_default_type = 359,
  sym_constraint = 360,
  sym_construct_signature = 361,
  sym_index_signature = 362,
  sym_array_type = 363,
  sym_tuple_type = 364,
  sym_readonly_type = 365,
  sym_union_type = 366,
  sym_intersection_type = 367,
  sym_function_type = 368,
  aux_sym_program_repeat1 = 369,
  aux_sym_export_statement_repeat1 = 370,
  aux_sym_export_clause_repeat1 = 371,
  aux_sym_named_imports_repeat1 = 372,
  aux_sym_variable_declaration_repeat1 = 373,
  aux_sym_switch_body_repeat1 = 374,
  aux_sym_object_repeat1 = 375,
  aux_sym_object_pattern_repeat1 = 376,
  aux_sym_array_repeat1 = 377,
  aux_sym_array_pattern_repeat1 = 378,
  aux_sym_glimmer_template_repeat1 = 379,
  aux_sym_jsx_element_repeat1 = 380,
  aux_sym__jsx_string_repeat1 = 381,
  aux_sym__jsx_string_repeat2 = 382,
  aux_sym_sequence_expression_repeat1 = 383,
  aux_sym_string_repeat1 = 384,
  aux_sym_string_repeat2 = 385,
  aux_sym_template_string_repeat1 = 386,
  aux_sym_class_body_repeat1 = 387,
  aux_sym_formal_parameters_repeat1 = 388,
  aux_sym__jsx_start_opening_element_repeat1 = 389,
  aux_sym_extends_clause_repeat1 = 390,
  aux_sym_implements_clause_repeat1 = 391,
  aux_sym_extends_type_clause_repeat1 = 392,
  aux_sym_enum_body_repeat1 = 393,
  aux_sym_template_literal_type_repeat1 = 394,
  aux_sym_object_type_repeat1 = 395,
  aux_sym_type_parameters_repeat1 = 396,
  aux_sym_tuple_type_repeat1 = 397,
  alias_sym_interface_body = 398,
  alias_sym_property_identifier = 399,
  alias_sym_shorthand_property_identifier = 400,
  alias_sym_shorthand_property_identifier_pattern = 401,
  alias_sym_statement_identifier = 402,
  alias_sym_this_type = 403,
  alias_sym_type_identifier = 404,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_assert] = "assert",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__glimmer_template_content] = "_glimmer_template_content",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [sym_html_character_reference] = "html_character_reference",
  [anon_sym_GT] = ">",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_jsx_string_fragment] = "string_fragment",
  [sym_unescaped_single_jsx_string_fragment] = "string_fragment",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_using] = "using",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_object] = "object",
  [anon_sym_abstract] = "abstract",
  [anon_sym_accessor] = "accessor",
  [anon_sym_satisfies] = "satisfies",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_PLUS_QMARK_COLON] = "+\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unique] = "unique symbol",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym___error_recovery] = "__error_recovery",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym__jsx_string] = "string",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym__import_identifier] = "_import_identifier",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_decorator_parenthesized_expression] = "parenthesized_expression",
  [sym_as_expression] = "as_expression",
  [sym_satisfies_expression] = "satisfies_expression",
  [sym_instantiation_expression] = "instantiation_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym__extends_clause_single] = "_extends_clause_single",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_adding_type_annotation] = "adding_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym__type_query_member_expression_in_type_annotation] = "member_expression",
  [sym__type_query_call_expression_in_type_annotation] = "call_expression",
  [sym_asserts] = "asserts",
  [sym_asserts_annotation] = "asserts_annotation",
  [sym_type] = "type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym_primary_type] = "primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym__type_query_instantiation_expression] = "instantiation_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_glimmer_template_repeat1] = "glimmer_template_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym__jsx_string_repeat1] = "_jsx_string_repeat1",
  [aux_sym__jsx_string_repeat2] = "_jsx_string_repeat2",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym__jsx_start_opening_element_repeat1] = "_jsx_start_opening_element_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__glimmer_template_content] = sym__glimmer_template_content,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [sym_html_character_reference] = sym_html_character_reference,
  [anon_sym_GT] = anon_sym_GT,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_jsx_string_fragment] = sym__template_chars,
  [sym_unescaped_single_jsx_string_fragment] = sym__template_chars,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_accessor] = anon_sym_accessor,
  [anon_sym_satisfies] = anon_sym_satisfies,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_PLUS_QMARK_COLON] = anon_sym_PLUS_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym___error_recovery] = sym___error_recovery,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym__jsx_string] = sym_string,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym__import_identifier] = sym__import_identifier,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_decorator_parenthesized_expression] = sym_parenthesized_expression,
  [sym_as_expression] = sym_as_expression,
  [sym_satisfies_expression] = sym_satisfies_expression,
  [sym_instantiation_expression] = sym_instantiation_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym__extends_clause_single] = sym__extends_clause_single,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_adding_type_annotation] = sym_adding_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type_query_member_expression_in_type_annotation] = sym_member_expression,
  [sym__type_query_call_expression_in_type_annotation] = sym_call_expression,
  [sym_asserts] = sym_asserts,
  [sym_asserts_annotation] = sym_asserts_annotation,
  [sym_type] = sym_type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym_primary_type] = sym_primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym__type_query_instantiation_expression] = sym_instantiation_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_glimmer_template_repeat1] = aux_sym_glimmer_template_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym__jsx_string_repeat1] = aux_sym__jsx_string_repeat1,
  [aux_sym__jsx_string_repeat2] = aux_sym__jsx_string_repeat2,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym__jsx_start_opening_element_repeat1] = aux_sym__jsx_start_opening_element_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__glimmer_template_content] = {
    .visible = false,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_html_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accessor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_satisfies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_string] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__import_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_satisfies_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__extends_clause_single] = {
    .visible = false,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_adding_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glimmer_template_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_start_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constraint = 10,
  field_constructor = 11,
  field_content = 12,
  field_declaration = 13,
  field_decorator = 14,
  field_finalizer = 15,
  field_flags = 16,
  field_function = 17,
  field_handler = 18,
  field_increment = 19,
  field_index = 20,
  field_index_type = 21,
  field_initializer = 22,
  field_key = 23,
  field_kind = 24,
  field_label = 25,
  field_left = 26,
  field_module = 27,
  field_name = 28,
  field_object = 29,
  field_open_tag = 30,
  field_operator = 31,
  field_optional_chain = 32,
  field_parameter = 33,
  field_parameters = 34,
  field_pattern = 35,
  field_property = 36,
  field_return_type = 37,
  field_right = 38,
  field_sign = 39,
  field_source = 40,
  field_type = 41,
  field_type_arguments = 42,
  field_type_parameters = 43,
  field_value = 44,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 1},
  [12] = {.index = 12, .length = 2},
  [13] = {.index = 14, .length = 1},
  [14] = {.index = 3, .length = 1},
  [15] = {.index = 15, .length = 2},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 1},
  [18] = {.index = 20, .length = 2},
  [19] = {.index = 22, .length = 2},
  [20] = {.index = 24, .length = 2},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 2},
  [24] = {.index = 31, .length = 2},
  [25] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 1},
  [30] = {.index = 36, .length = 2},
  [31] = {.index = 38, .length = 2},
  [32] = {.index = 40, .length = 2},
  [33] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 2},
  [35] = {.index = 45, .length = 2},
  [36] = {.index = 47, .length = 6},
  [37] = {.index = 53, .length = 1},
  [38] = {.index = 54, .length = 3},
  [39] = {.index = 57, .length = 3},
  [40] = {.index = 60, .length = 2},
  [41] = {.index = 62, .length = 2},
  [42] = {.index = 64, .length = 2},
  [43] = {.index = 66, .length = 2},
  [44] = {.index = 68, .length = 1},
  [45] = {.index = 69, .length = 3},
  [46] = {.index = 72, .length = 2},
  [47] = {.index = 74, .length = 1},
  [48] = {.index = 75, .length = 2},
  [51] = {.index = 77, .length = 2},
  [52] = {.index = 79, .length = 2},
  [53] = {.index = 81, .length = 2},
  [54] = {.index = 83, .length = 1},
  [55] = {.index = 84, .length = 2},
  [56] = {.index = 86, .length = 4},
  [57] = {.index = 90, .length = 2},
  [58] = {.index = 92, .length = 2},
  [59] = {.index = 94, .length = 1},
  [60] = {.index = 94, .length = 1},
  [61] = {.index = 95, .length = 1},
  [62] = {.index = 96, .length = 2},
  [63] = {.index = 98, .length = 2},
  [64] = {.index = 94, .length = 1},
  [65] = {.index = 27, .length = 2},
  [66] = {.index = 31, .length = 2},
  [67] = {.index = 100, .length = 3},
  [68] = {.index = 72, .length = 2},
  [69] = {.index = 72, .length = 2},
  [70] = {.index = 103, .length = 2},
  [71] = {.index = 103, .length = 2},
  [72] = {.index = 105, .length = 3},
  [73] = {.index = 105, .length = 3},
  [74] = {.index = 108, .length = 3},
  [75] = {.index = 111, .length = 2},
  [76] = {.index = 113, .length = 2},
  [77] = {.index = 115, .length = 4},
  [78] = {.index = 119, .length = 3},
  [79] = {.index = 122, .length = 2},
  [80] = {.index = 124, .length = 2},
  [81] = {.index = 126, .length = 1},
  [82] = {.index = 127, .length = 1},
  [83] = {.index = 103, .length = 2},
  [84] = {.index = 27, .length = 2},
  [85] = {.index = 128, .length = 2},
  [86] = {.index = 130, .length = 5},
  [87] = {.index = 135, .length = 1},
  [88] = {.index = 136, .length = 1},
  [89] = {.index = 137, .length = 2},
  [90] = {.index = 139, .length = 3},
  [91] = {.index = 142, .length = 2},
  [92] = {.index = 144, .length = 3},
  [93] = {.index = 147, .length = 6},
  [94] = {.index = 153, .length = 1},
  [95] = {.index = 154, .length = 1},
  [96] = {.index = 155, .length = 3},
  [97] = {.index = 158, .length = 3},
  [98] = {.index = 161, .length = 4},
  [99] = {.index = 165, .length = 2},
  [100] = {.index = 167, .length = 2},
  [101] = {.index = 169, .length = 3},
  [102] = {.index = 172, .length = 4},
  [103] = {.index = 176, .length = 1},
  [104] = {.index = 177, .length = 2},
  [105] = {.index = 179, .length = 1},
  [106] = {.index = 180, .length = 2},
  [107] = {.index = 182, .length = 3},
  [108] = {.index = 185, .length = 2},
  [109] = {.index = 187, .length = 4},
  [110] = {.index = 191, .length = 3},
  [111] = {.index = 194, .length = 2},
  [112] = {.index = 196, .length = 2},
  [113] = {.index = 198, .length = 2},
  [114] = {.index = 200, .length = 2},
  [115] = {.index = 202, .length = 2},
  [118] = {.index = 202, .length = 2},
  [119] = {.index = 204, .length = 4},
  [120] = {.index = 208, .length = 2},
  [121] = {.index = 210, .length = 2},
  [122] = {.index = 212, .length = 4},
  [123] = {.index = 210, .length = 2},
  [124] = {.index = 216, .length = 4},
  [125] = {.index = 220, .length = 4},
  [126] = {.index = 224, .length = 5},
  [127] = {.index = 229, .length = 3},
  [128] = {.index = 232, .length = 2},
  [129] = {.index = 232, .length = 2},
  [130] = {.index = 234, .length = 2},
  [131] = {.index = 236, .length = 2},
  [132] = {.index = 238, .length = 2},
  [133] = {.index = 240, .length = 2},
  [134] = {.index = 242, .length = 2},
  [135] = {.index = 244, .length = 2},
  [136] = {.index = 246, .length = 3},
  [137] = {.index = 244, .length = 2},
  [138] = {.index = 240, .length = 2},
  [139] = {.index = 142, .length = 2},
  [140] = {.index = 249, .length = 1},
  [141] = {.index = 249, .length = 1},
  [142] = {.index = 180, .length = 2},
  [143] = {.index = 182, .length = 3},
  [144] = {.index = 250, .length = 2},
  [145] = {.index = 252, .length = 3},
  [146] = {.index = 255, .length = 2},
  [147] = {.index = 257, .length = 3},
  [148] = {.index = 260, .length = 2},
  [149] = {.index = 262, .length = 3},
  [150] = {.index = 265, .length = 1},
  [151] = {.index = 266, .length = 2},
  [152] = {.index = 268, .length = 2},
  [153] = {.index = 270, .length = 5},
  [154] = {.index = 266, .length = 2},
  [155] = {.index = 275, .length = 1},
  [156] = {.index = 276, .length = 4},
  [157] = {.index = 280, .length = 2},
  [158] = {.index = 282, .length = 1},
  [159] = {.index = 283, .length = 2},
  [160] = {.index = 285, .length = 2},
  [161] = {.index = 287, .length = 2},
  [162] = {.index = 289, .length = 4},
  [163] = {.index = 293, .length = 2},
  [164] = {.index = 295, .length = 3},
  [165] = {.index = 298, .length = 3},
  [166] = {.index = 301, .length = 3},
  [167] = {.index = 304, .length = 4},
  [168] = {.index = 308, .length = 1},
  [169] = {.index = 309, .length = 2},
  [170] = {.index = 311, .length = 4},
  [171] = {.index = 315, .length = 4},
  [172] = {.index = 319, .length = 4},
  [173] = {.index = 323, .length = 2},
  [174] = {.index = 325, .length = 2},
  [175] = {.index = 327, .length = 4},
  [176] = {.index = 327, .length = 4},
  [177] = {.index = 331, .length = 4},
  [178] = {.index = 331, .length = 4},
  [179] = {.index = 335, .length = 4},
  [180] = {.index = 339, .length = 4},
  [181] = {.index = 343, .length = 5},
  [182] = {.index = 348, .length = 3},
  [183] = {.index = 351, .length = 3},
  [184] = {.index = 351, .length = 3},
  [185] = {.index = 354, .length = 2},
  [186] = {.index = 356, .length = 3},
  [187] = {.index = 359, .length = 2},
  [188] = {.index = 359, .length = 2},
  [189] = {.index = 301, .length = 3},
  [190] = {.index = 361, .length = 3},
  [191] = {.index = 364, .length = 3},
  [192] = {.index = 137, .length = 2},
  [193] = {.index = 367, .length = 2},
  [194] = {.index = 369, .length = 3},
  [195] = {.index = 372, .length = 4},
  [196] = {.index = 376, .length = 3},
  [197] = {.index = 379, .length = 3},
  [198] = {.index = 382, .length = 2},
  [199] = {.index = 384, .length = 3},
  [200] = {.index = 387, .length = 5},
  [201] = {.index = 382, .length = 2},
  [202] = {.index = 392, .length = 3},
  [203] = {.index = 392, .length = 3},
  [204] = {.index = 395, .length = 3},
  [205] = {.index = 398, .length = 2},
  [206] = {.index = 400, .length = 4},
  [207] = {.index = 137, .length = 2},
  [208] = {.index = 404, .length = 1},
  [209] = {.index = 405, .length = 2},
  [210] = {.index = 407, .length = 2},
  [211] = {.index = 409, .length = 2},
  [212] = {.index = 411, .length = 2},
  [213] = {.index = 413, .length = 3},
  [214] = {.index = 416, .length = 1},
  [215] = {.index = 417, .length = 3},
  [216] = {.index = 420, .length = 2},
  [217] = {.index = 422, .length = 3},
  [218] = {.index = 425, .length = 3},
  [219] = {.index = 428, .length = 3},
  [220] = {.index = 431, .length = 3},
  [221] = {.index = 434, .length = 4},
  [222] = {.index = 438, .length = 2},
  [223] = {.index = 440, .length = 2},
  [224] = {.index = 442, .length = 1},
  [225] = {.index = 443, .length = 4},
  [226] = {.index = 443, .length = 4},
  [227] = {.index = 447, .length = 2},
  [228] = {.index = 449, .length = 3},
  [229] = {.index = 452, .length = 5},
  [230] = {.index = 457, .length = 3},
  [231] = {.index = 460, .length = 2},
  [232] = {.index = 462, .length = 2},
  [233] = {.index = 464, .length = 2},
  [234] = {.index = 466, .length = 1},
  [235] = {.index = 467, .length = 4},
  [236] = {.index = 471, .length = 3},
  [237] = {.index = 474, .length = 4},
  [238] = {.index = 478, .length = 5},
  [239] = {.index = 483, .length = 1},
  [240] = {.index = 484, .length = 2},
  [241] = {.index = 486, .length = 4},
  [242] = {.index = 490, .length = 4},
  [243] = {.index = 494, .length = 4},
  [244] = {.index = 498, .length = 3},
  [245] = {.index = 501, .length = 2},
  [246] = {.index = 503, .length = 4},
  [247] = {.index = 507, .length = 4},
  [248] = {.index = 511, .length = 2},
  [249] = {.index = 513, .length = 2},
  [250] = {.index = 515, .length = 3},
  [251] = {.index = 518, .length = 3},
  [252] = {.index = 521, .length = 2},
  [253] = {.index = 523, .length = 2},
  [254] = {.index = 525, .length = 1},
  [255] = {.index = 526, .length = 1},
  [256] = {.index = 527, .length = 3},
  [257] = {.index = 530, .length = 3},
  [258] = {.index = 533, .length = 3},
  [259] = {.index = 536, .length = 3},
  [260] = {.index = 539, .length = 4},
  [261] = {.index = 543, .length = 2},
  [262] = {.index = 545, .length = 4},
  [263] = {.index = 549, .length = 3},
  [264] = {.index = 552, .length = 2},
  [265] = {.index = 554, .length = 2},
  [266] = {.index = 556, .length = 4},
  [267] = {.index = 560, .length = 4},
  [268] = {.index = 564, .length = 4},
  [269] = {.index = 568, .length = 3},
  [270] = {.index = 571, .length = 2},
  [272] = {.index = 573, .length = 4},
  [273] = {.index = 577, .length = 5},
  [274] = {.index = 582, .length = 5},
  [275] = {.index = 587, .length = 5},
  [276] = {.index = 592, .length = 4},
  [277] = {.index = 596, .length = 5},
  [278] = {.index = 601, .length = 4},
  [279] = {.index = 605, .length = 4},
  [280] = {.index = 609, .length = 3},
  [281] = {.index = 612, .length = 3},
  [282] = {.index = 615, .length = 3},
  [283] = {.index = 612, .length = 3},
  [284] = {.index = 618, .length = 2},
  [285] = {.index = 620, .length = 4},
  [286] = {.index = 624, .length = 4},
  [287] = {.index = 628, .length = 3},
  [288] = {.index = 631, .length = 2},
  [289] = {.index = 633, .length = 2},
  [290] = {.index = 635, .length = 3},
  [291] = {.index = 638, .length = 2},
  [292] = {.index = 640, .length = 2},
  [293] = {.index = 642, .length = 1},
  [294] = {.index = 643, .length = 3},
  [295] = {.index = 646, .length = 3},
  [296] = {.index = 649, .length = 4},
  [297] = {.index = 653, .length = 4},
  [298] = {.index = 657, .length = 3},
  [299] = {.index = 660, .length = 3},
  [300] = {.index = 663, .length = 2},
  [301] = {.index = 665, .length = 3},
  [302] = {.index = 668, .length = 2},
  [303] = {.index = 670, .length = 4},
  [304] = {.index = 674, .length = 4},
  [305] = {.index = 678, .length = 4},
  [306] = {.index = 682, .length = 3},
  [307] = {.index = 685, .length = 5},
  [308] = {.index = 690, .length = 5},
  [309] = {.index = 695, .length = 5},
  [310] = {.index = 700, .length = 4},
  [311] = {.index = 704, .length = 4},
  [312] = {.index = 708, .length = 3},
  [313] = {.index = 711, .length = 3},
  [314] = {.index = 711, .length = 3},
  [315] = {.index = 714, .length = 2},
  [316] = {.index = 716, .length = 2},
  [317] = {.index = 718, .length = 3},
  [318] = {.index = 721, .length = 2},
  [319] = {.index = 723, .length = 2},
  [320] = {.index = 725, .length = 4},
  [321] = {.index = 729, .length = 3},
  [322] = {.index = 732, .length = 3},
  [323] = {.index = 735, .length = 4},
  [324] = {.index = 739, .length = 3},
  [325] = {.index = 742, .length = 3},
  [326] = {.index = 745, .length = 2},
  [327] = {.index = 747, .length = 4},
  [328] = {.index = 751, .length = 5},
  [329] = {.index = 756, .length = 5},
  [330] = {.index = 761, .length = 4},
  [331] = {.index = 761, .length = 4},
  [332] = {.index = 765, .length = 4},
  [333] = {.index = 769, .length = 3},
  [334] = {.index = 772, .length = 2},
  [335] = {.index = 774, .length = 2},
  [336] = {.index = 776, .length = 3},
  [337] = {.index = 779, .length = 4},
  [338] = {.index = 783, .length = 4},
  [339] = {.index = 787, .length = 3},
  [340] = {.index = 790, .length = 3},
  [341] = {.index = 793, .length = 4},
  [342] = {.index = 797, .length = 3},
  [343] = {.index = 800, .length = 3},
  [344] = {.index = 803, .length = 5},
  [345] = {.index = 808, .length = 3},
  [346] = {.index = 811, .length = 4},
  [347] = {.index = 815, .length = 4},
  [348] = {.index = 819, .length = 3},
  [349] = {.index = 822, .length = 3},
  [350] = {.index = 825, .length = 4},
  [351] = {.index = 829, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_pattern, 0},
  [9] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [14] =
    {field_constructor, 1},
  [15] =
    {field_arguments, 1},
    {field_function, 0},
  [17] =
    {field_argument, 0},
    {field_operator, 1},
  [19] =
    {field_type_arguments, 1},
  [20] =
    {field_parameters, 0},
    {field_return_type, 1},
  [22] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [24] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [26] =
    {field_declaration, 2},
  [27] =
    {field_left, 0},
    {field_right, 2},
  [29] =
    {field_body, 2},
    {field_label, 0},
  [31] =
    {field_body, 2},
    {field_parameter, 0},
  [33] =
    {field_body, 1},
    {field_name, 0},
  [35] =
    {field_source, 1},
  [36] =
    {field_body, 2},
    {field_object, 1},
  [38] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [40] =
    {field_name, 0},
    {field_type, 1},
  [42] =
    {field_kind, 0},
  [43] =
    {field_condition, 1},
    {field_consequence, 2},
  [45] =
    {field_body, 2},
    {field_value, 1},
  [47] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [53] =
    {field_pattern, 1},
  [54] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [57] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [60] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [62] =
    {field_body, 2},
    {field_condition, 1},
  [64] =
    {field_body, 1},
    {field_handler, 2},
  [66] =
    {field_body, 1},
    {field_finalizer, 2},
  [68] =
    {field_label, 1},
  [69] =
    {field_close_tag, 2},
    {field_content, 1},
    {field_open_tag, 0},
  [72] =
    {field_body, 2},
    {field_name, 1},
  [74] =
    {field_value, 0},
  [75] =
    {field_type_arguments, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [77] =
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [79] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
  [81] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [83] =
    {field_body, 2},
  [84] =
    {field_body, 2},
    {field_type_parameters, 1},
  [86] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [90] =
    {field_arguments, 2},
    {field_constructor, 1},
  [92] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [94] =
    {field_name, 1},
  [95] =
    {field_attribute, 0},
  [96] =
    {field_name, 0},
    {field_value, 1},
  [98] =
    {field_constraint, 1},
    {field_name, 0},
  [100] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [103] =
    {field_object, 0},
    {field_property, 2},
  [105] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [108] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [111] =
    {field_arguments, 2},
    {field_function, 0},
  [113] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [115] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [119] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [122] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [124] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [126] =
    {field_source, 2, .inherited = true},
  [127] =
    {field_value, 2},
  [128] =
    {field_key, 0},
    {field_value, 2},
  [130] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [135] =
    {field_source, 2},
  [136] =
    {field_value, 1},
  [137] =
    {field_name, 0},
    {field_type, 2},
  [139] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [142] =
    {field_body, 3},
    {field_name, 2},
  [144] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [147] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [153] =
    {field_type, 2},
  [154] =
    {field_pattern, 2},
  [155] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [158] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [161] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [165] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [167] =
    {field_body, 1},
    {field_condition, 3},
  [169] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [172] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [176] =
    {field_decorator, 0, .inherited = true},
  [177] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
  [179] =
    {field_decorator, 1, .inherited = true},
  [180] =
    {field_body, 3},
    {field_name, 1},
  [182] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [185] =
    {field_type_arguments, 1},
    {field_value, 0},
  [187] =
    {field_type_arguments, 1, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [191] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [194] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [196] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [198] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [200] =
    {field_function, 1, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
  [202] =
    {field_name, 0},
    {field_type_arguments, 1},
  [204] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [208] =
    {field_body, 3},
    {field_type_parameters, 1},
  [210] =
    {field_body, 3},
    {field_parameter, 1},
  [212] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [216] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [220] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [224] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [229] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [232] =
    {field_left, 1},
    {field_right, 3},
  [234] =
    {field_flags, 3},
    {field_pattern, 1},
  [236] =
    {field_name, 1},
    {field_value, 2},
  [238] =
    {field_constraint, 2},
    {field_name, 1},
  [240] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [242] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [244] =
    {field_name, 1},
    {field_type_arguments, 2},
  [246] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [249] =
    {field_type, 1},
  [250] =
    {field_index, 2},
    {field_object, 0},
  [252] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [255] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [257] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [260] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [262] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [265] =
    {field_source, 3, .inherited = true},
  [266] =
    {field_alias, 2},
    {field_name, 0},
  [268] =
    {field_name, 1},
    {field_value, 3},
  [270] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [275] =
    {field_pattern, 3},
  [276] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [280] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [282] =
    {field_name, 2},
  [283] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [285] =
    {field_name, 1},
    {field_type, 2},
  [287] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [289] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [293] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [295] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [298] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
  [301] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [304] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [308] =
    {field_parameters, 1},
  [309] =
    {field_function, 0},
    {field_type_arguments, 1},
  [311] =
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_type_arguments, 1},
  [315] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [319] =
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_type_arguments, 1},
  [323] =
    {field_module, 0},
    {field_name, 2},
  [325] =
    {field_parameters, 0},
    {field_return_type, 2},
  [327] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [331] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [335] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [339] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [343] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [348] =
    {field_constraint, 2},
    {field_name, 1},
    {field_value, 3},
  [351] =
    {field_attribute, 3, .inherited = true},
    {field_name, 1},
    {field_type_arguments, 2},
  [354] =
    {field_body, 4},
    {field_name, 2},
  [356] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [359] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [361] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [364] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [367] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [369] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [372] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [376] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [379] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [382] =
    {field_alias, 3},
    {field_name, 1},
  [384] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [387] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [392] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [395] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [398] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [400] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [404] =
    {field_type, 3},
  [405] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [407] =
    {field_name, 2},
    {field_type, 3},
  [409] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [411] =
    {field_name, 1},
    {field_type, 3},
  [413] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [416] =
    {field_name, 3},
  [417] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [420] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [422] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [425] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
  [428] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [431] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
  [434] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [438] =
    {field_parameters, 1},
    {field_type, 2},
  [440] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [442] =
    {field_parameters, 2},
  [443] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [447] =
    {field_parameters, 1},
    {field_type, 3},
  [449] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [452] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [457] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [460] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [462] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [464] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [466] =
    {field_name, 2, .inherited = true},
  [467] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [471] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [474] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [478] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [483] =
    {field_source, 4},
  [484] =
    {field_body, 3},
    {field_value, 1},
  [486] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [490] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [494] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [498] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [501] =
    {field_body, 4},
    {field_parameter, 2},
  [503] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [507] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [511] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [513] =
    {field_name, 2},
    {field_type, 4},
  [515] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [518] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [521] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [523] =
    {field_name, 3},
    {field_type, 4},
  [525] =
    {field_type, 4},
  [526] =
    {field_name, 4},
  [527] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [530] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
  [533] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [536] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
  [539] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [543] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
  [545] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [549] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [552] =
    {field_parameters, 2},
    {field_type, 3},
  [554] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [556] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [560] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [564] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [568] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [571] =
    {field_parameters, 2},
    {field_type, 4},
  [573] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [577] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [582] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [587] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [592] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [596] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [601] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [605] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [609] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [612] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [615] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [618] =
    {field_sign, 0},
    {field_type, 5},
  [620] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [624] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [628] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [631] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [633] =
    {field_name, 3},
    {field_type, 5},
  [635] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [638] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [640] =
    {field_name, 4},
    {field_type, 5},
  [642] =
    {field_name, 5},
  [643] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [646] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
  [649] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [653] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [657] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [660] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
  [663] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
  [665] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [668] =
    {field_index, 3},
    {field_object, 0},
  [670] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [674] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [678] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [682] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [685] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [690] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [695] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
  [700] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [704] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [708] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [711] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [714] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [716] =
    {field_name, 4},
    {field_type, 6},
  [718] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [721] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [723] =
    {field_name, 5},
    {field_type, 6},
  [725] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [729] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [732] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
  [735] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [739] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [742] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
  [745] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
  [747] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [751] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [756] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [761] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [765] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [769] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [772] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [774] =
    {field_name, 5},
    {field_type, 7},
  [776] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [779] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [783] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [787] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [790] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
  [793] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [797] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 7, .inherited = true},
  [800] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
  [803] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [808] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [811] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [815] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [819] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 8, .inherited = true},
  [822] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
  [825] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [829] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
    {field_value, 9, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_type_identifier,
  },
  [22] = {
    [0] = sym_identifier,
  },
  [23] = {
    [0] = alias_sym_statement_identifier,
  },
  [24] = {
    [0] = sym_identifier,
  },
  [26] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [27] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [28] = {
    [1] = sym_identifier,
  },
  [44] = {
    [1] = alias_sym_statement_identifier,
  },
  [46] = {
    [1] = alias_sym_type_identifier,
  },
  [49] = {
    [0] = alias_sym_type_identifier,
  },
  [50] = {
    [0] = alias_sym_this_type,
  },
  [59] = {
    [1] = alias_sym_type_identifier,
  },
  [62] = {
    [0] = alias_sym_type_identifier,
  },
  [63] = {
    [0] = alias_sym_type_identifier,
  },
  [64] = {
    [1] = sym_member_expression,
  },
  [68] = {
    [1] = alias_sym_type_identifier,
    [2] = alias_sym_interface_body,
  },
  [70] = {
    [2] = alias_sym_property_identifier,
  },
  [72] = {
    [2] = alias_sym_property_identifier,
  },
  [83] = {
    [0] = sym_member_expression,
    [2] = alias_sym_property_identifier,
  },
  [84] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [106] = {
    [1] = alias_sym_type_identifier,
  },
  [107] = {
    [1] = alias_sym_type_identifier,
  },
  [115] = {
    [0] = alias_sym_type_identifier,
  },
  [116] = {
    [1] = alias_sym_type_identifier,
  },
  [117] = {
    [1] = anon_sym_unique,
  },
  [121] = {
    [1] = sym_identifier,
  },
  [128] = {
    [1] = sym_identifier,
  },
  [131] = {
    [1] = alias_sym_type_identifier,
  },
  [132] = {
    [1] = alias_sym_type_identifier,
  },
  [136] = {
    [0] = alias_sym_type_identifier,
  },
  [137] = {
    [1] = sym_member_expression,
  },
  [138] = {
    [1] = sym_member_expression,
  },
  [139] = {
    [2] = alias_sym_type_identifier,
  },
  [140] = {
    [1] = alias_sym_type_identifier,
  },
  [142] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [143] = {
    [1] = alias_sym_type_identifier,
    [3] = alias_sym_interface_body,
  },
  [147] = {
    [2] = alias_sym_type_identifier,
  },
  [152] = {
    [1] = alias_sym_type_identifier,
  },
  [154] = {
    [0] = sym_identifier,
  },
  [166] = {
    [1] = alias_sym_type_identifier,
  },
  [173] = {
    [2] = alias_sym_type_identifier,
  },
  [175] = {
    [2] = alias_sym_property_identifier,
  },
  [177] = {
    [2] = alias_sym_property_identifier,
  },
  [182] = {
    [1] = alias_sym_type_identifier,
  },
  [184] = {
    [1] = sym_member_expression,
  },
  [185] = {
    [2] = alias_sym_type_identifier,
  },
  [186] = {
    [2] = alias_sym_type_identifier,
  },
  [187] = {
    [1] = alias_sym_type_identifier,
  },
  [189] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_interface_body,
  },
  [192] = {
    [0] = sym_identifier,
  },
  [194] = {
    [2] = alias_sym_type_identifier,
  },
  [195] = {
    [2] = alias_sym_type_identifier,
  },
  [197] = {
    [3] = alias_sym_type_identifier,
  },
  [199] = {
    [1] = alias_sym_type_identifier,
  },
  [201] = {
    [1] = sym_identifier,
  },
  [202] = {
    [1] = sym_identifier,
  },
  [207] = {
    [0] = alias_sym_type_identifier,
  },
  [225] = {
    [2] = alias_sym_property_identifier,
  },
  [230] = {
    [2] = alias_sym_type_identifier,
  },
  [235] = {
    [2] = alias_sym_type_identifier,
  },
  [236] = {
    [3] = alias_sym_type_identifier,
  },
  [237] = {
    [3] = alias_sym_type_identifier,
  },
  [271] = {
    [3] = alias_sym_property_identifier,
  },
  [272] = {
    [3] = alias_sym_type_identifier,
  },
  [281] = {
    [1] = sym_identifier,
  },
  [282] = {
    [0] = alias_sym_type_identifier,
  },
  [313] = {
    [2] = sym_identifier,
  },
  [330] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_nested_identifier, 2,
    sym_nested_identifier,
    sym_member_expression,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  sym_object_type, 2,
    sym_object_type,
    alias_sym_interface_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 17,
  [20] = 14,
  [21] = 14,
  [22] = 17,
  [23] = 14,
  [24] = 17,
  [25] = 17,
  [26] = 14,
  [27] = 17,
  [28] = 14,
  [29] = 14,
  [30] = 17,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 32,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 45,
  [47] = 33,
  [48] = 32,
  [49] = 36,
  [50] = 44,
  [51] = 51,
  [52] = 52,
  [53] = 35,
  [54] = 37,
  [55] = 38,
  [56] = 39,
  [57] = 40,
  [58] = 41,
  [59] = 42,
  [60] = 43,
  [61] = 51,
  [62] = 52,
  [63] = 52,
  [64] = 52,
  [65] = 52,
  [66] = 31,
  [67] = 52,
  [68] = 52,
  [69] = 52,
  [70] = 52,
  [71] = 52,
  [72] = 45,
  [73] = 33,
  [74] = 36,
  [75] = 44,
  [76] = 51,
  [77] = 31,
  [78] = 35,
  [79] = 37,
  [80] = 38,
  [81] = 39,
  [82] = 40,
  [83] = 41,
  [84] = 42,
  [85] = 43,
  [86] = 86,
  [87] = 87,
  [88] = 87,
  [89] = 87,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 93,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 96,
  [99] = 99,
  [100] = 93,
  [101] = 101,
  [102] = 102,
  [103] = 102,
  [104] = 101,
  [105] = 105,
  [106] = 101,
  [107] = 107,
  [108] = 101,
  [109] = 101,
  [110] = 110,
  [111] = 107,
  [112] = 110,
  [113] = 107,
  [114] = 114,
  [115] = 107,
  [116] = 107,
  [117] = 117,
  [118] = 117,
  [119] = 114,
  [120] = 110,
  [121] = 107,
  [122] = 117,
  [123] = 105,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 107,
  [128] = 107,
  [129] = 110,
  [130] = 130,
  [131] = 131,
  [132] = 114,
  [133] = 107,
  [134] = 107,
  [135] = 107,
  [136] = 114,
  [137] = 107,
  [138] = 102,
  [139] = 110,
  [140] = 110,
  [141] = 107,
  [142] = 107,
  [143] = 107,
  [144] = 110,
  [145] = 126,
  [146] = 107,
  [147] = 110,
  [148] = 125,
  [149] = 149,
  [150] = 149,
  [151] = 149,
  [152] = 107,
  [153] = 110,
  [154] = 149,
  [155] = 149,
  [156] = 149,
  [157] = 149,
  [158] = 158,
  [159] = 149,
  [160] = 149,
  [161] = 161,
  [162] = 162,
  [163] = 162,
  [164] = 162,
  [165] = 162,
  [166] = 166,
  [167] = 167,
  [168] = 162,
  [169] = 162,
  [170] = 162,
  [171] = 162,
  [172] = 162,
  [173] = 173,
  [174] = 173,
  [175] = 173,
  [176] = 173,
  [177] = 173,
  [178] = 173,
  [179] = 173,
  [180] = 173,
  [181] = 173,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 183,
  [186] = 184,
  [187] = 184,
  [188] = 184,
  [189] = 183,
  [190] = 183,
  [191] = 182,
  [192] = 182,
  [193] = 193,
  [194] = 194,
  [195] = 193,
  [196] = 182,
  [197] = 193,
  [198] = 182,
  [199] = 182,
  [200] = 194,
  [201] = 182,
  [202] = 182,
  [203] = 182,
  [204] = 204,
  [205] = 204,
  [206] = 206,
  [207] = 207,
  [208] = 207,
  [209] = 209,
  [210] = 209,
  [211] = 209,
  [212] = 206,
  [213] = 207,
  [214] = 206,
  [215] = 215,
  [216] = 215,
  [217] = 215,
  [218] = 218,
  [219] = 215,
  [220] = 215,
  [221] = 215,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 222,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 230,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 244,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 222,
  [259] = 242,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 244,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 222,
  [268] = 222,
  [269] = 222,
  [270] = 270,
  [271] = 270,
  [272] = 270,
  [273] = 270,
  [274] = 274,
  [275] = 222,
  [276] = 270,
  [277] = 270,
  [278] = 222,
  [279] = 222,
  [280] = 222,
  [281] = 270,
  [282] = 282,
  [283] = 283,
  [284] = 283,
  [285] = 285,
  [286] = 283,
  [287] = 283,
  [288] = 288,
  [289] = 289,
  [290] = 283,
  [291] = 283,
  [292] = 283,
  [293] = 293,
  [294] = 294,
  [295] = 285,
  [296] = 282,
  [297] = 283,
  [298] = 283,
  [299] = 283,
  [300] = 300,
  [301] = 283,
  [302] = 283,
  [303] = 283,
  [304] = 283,
  [305] = 300,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 307,
  [311] = 311,
  [312] = 312,
  [313] = 312,
  [314] = 312,
  [315] = 315,
  [316] = 307,
  [317] = 317,
  [318] = 318,
  [319] = 317,
  [320] = 320,
  [321] = 320,
  [322] = 318,
  [323] = 318,
  [324] = 324,
  [325] = 324,
  [326] = 326,
  [327] = 317,
  [328] = 324,
  [329] = 320,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 333,
  [336] = 336,
  [337] = 332,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 336,
  [342] = 332,
  [343] = 338,
  [344] = 339,
  [345] = 340,
  [346] = 333,
  [347] = 336,
  [348] = 348,
  [349] = 333,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 333,
  [355] = 336,
  [356] = 336,
  [357] = 332,
  [358] = 333,
  [359] = 336,
  [360] = 330,
  [361] = 332,
  [362] = 338,
  [363] = 339,
  [364] = 340,
  [365] = 338,
  [366] = 366,
  [367] = 339,
  [368] = 340,
  [369] = 369,
  [370] = 340,
  [371] = 371,
  [372] = 332,
  [373] = 373,
  [374] = 374,
  [375] = 336,
  [376] = 376,
  [377] = 338,
  [378] = 338,
  [379] = 333,
  [380] = 339,
  [381] = 336,
  [382] = 332,
  [383] = 338,
  [384] = 339,
  [385] = 332,
  [386] = 340,
  [387] = 340,
  [388] = 388,
  [389] = 333,
  [390] = 339,
  [391] = 340,
  [392] = 338,
  [393] = 351,
  [394] = 353,
  [395] = 395,
  [396] = 333,
  [397] = 336,
  [398] = 332,
  [399] = 338,
  [400] = 339,
  [401] = 340,
  [402] = 339,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 407,
  [429] = 408,
  [430] = 409,
  [431] = 410,
  [432] = 405,
  [433] = 411,
  [434] = 412,
  [435] = 413,
  [436] = 414,
  [437] = 416,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 438,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 438,
  [449] = 449,
  [450] = 447,
  [451] = 438,
  [452] = 443,
  [453] = 441,
  [454] = 442,
  [455] = 443,
  [456] = 456,
  [457] = 443,
  [458] = 446,
  [459] = 459,
  [460] = 443,
  [461] = 443,
  [462] = 462,
  [463] = 443,
  [464] = 464,
  [465] = 417,
  [466] = 418,
  [467] = 422,
  [468] = 423,
  [469] = 469,
  [470] = 424,
  [471] = 471,
  [472] = 425,
  [473] = 473,
  [474] = 427,
  [475] = 407,
  [476] = 408,
  [477] = 409,
  [478] = 410,
  [479] = 405,
  [480] = 411,
  [481] = 412,
  [482] = 413,
  [483] = 414,
  [484] = 416,
  [485] = 420,
  [486] = 441,
  [487] = 442,
  [488] = 456,
  [489] = 443,
  [490] = 418,
  [491] = 445,
  [492] = 417,
  [493] = 418,
  [494] = 422,
  [495] = 423,
  [496] = 424,
  [497] = 425,
  [498] = 427,
  [499] = 407,
  [500] = 408,
  [501] = 409,
  [502] = 410,
  [503] = 405,
  [504] = 411,
  [505] = 412,
  [506] = 413,
  [507] = 414,
  [508] = 416,
  [509] = 422,
  [510] = 464,
  [511] = 441,
  [512] = 442,
  [513] = 443,
  [514] = 445,
  [515] = 446,
  [516] = 447,
  [517] = 464,
  [518] = 418,
  [519] = 422,
  [520] = 423,
  [521] = 424,
  [522] = 471,
  [523] = 425,
  [524] = 427,
  [525] = 407,
  [526] = 408,
  [527] = 409,
  [528] = 471,
  [529] = 405,
  [530] = 411,
  [531] = 412,
  [532] = 413,
  [533] = 414,
  [534] = 417,
  [535] = 416,
  [536] = 441,
  [537] = 442,
  [538] = 443,
  [539] = 445,
  [540] = 417,
  [541] = 418,
  [542] = 422,
  [543] = 423,
  [544] = 424,
  [545] = 425,
  [546] = 427,
  [547] = 407,
  [548] = 408,
  [549] = 409,
  [550] = 410,
  [551] = 405,
  [552] = 411,
  [553] = 412,
  [554] = 413,
  [555] = 414,
  [556] = 416,
  [557] = 441,
  [558] = 442,
  [559] = 443,
  [560] = 445,
  [561] = 446,
  [562] = 447,
  [563] = 464,
  [564] = 471,
  [565] = 418,
  [566] = 422,
  [567] = 423,
  [568] = 424,
  [569] = 425,
  [570] = 427,
  [571] = 407,
  [572] = 408,
  [573] = 409,
  [574] = 410,
  [575] = 405,
  [576] = 411,
  [577] = 412,
  [578] = 413,
  [579] = 414,
  [580] = 416,
  [581] = 441,
  [582] = 442,
  [583] = 443,
  [584] = 445,
  [585] = 445,
  [586] = 446,
  [587] = 447,
  [588] = 464,
  [589] = 471,
  [590] = 418,
  [591] = 422,
  [592] = 423,
  [593] = 424,
  [594] = 425,
  [595] = 427,
  [596] = 407,
  [597] = 408,
  [598] = 409,
  [599] = 410,
  [600] = 405,
  [601] = 411,
  [602] = 412,
  [603] = 413,
  [604] = 414,
  [605] = 416,
  [606] = 441,
  [607] = 442,
  [608] = 443,
  [609] = 423,
  [610] = 445,
  [611] = 446,
  [612] = 447,
  [613] = 464,
  [614] = 471,
  [615] = 424,
  [616] = 446,
  [617] = 447,
  [618] = 417,
  [619] = 619,
  [620] = 417,
  [621] = 418,
  [622] = 422,
  [623] = 423,
  [624] = 424,
  [625] = 425,
  [626] = 427,
  [627] = 407,
  [628] = 408,
  [629] = 409,
  [630] = 410,
  [631] = 405,
  [632] = 411,
  [633] = 412,
  [634] = 413,
  [635] = 414,
  [636] = 416,
  [637] = 441,
  [638] = 442,
  [639] = 443,
  [640] = 445,
  [641] = 446,
  [642] = 447,
  [643] = 471,
  [644] = 425,
  [645] = 645,
  [646] = 426,
  [647] = 464,
  [648] = 471,
  [649] = 446,
  [650] = 447,
  [651] = 417,
  [652] = 417,
  [653] = 464,
  [654] = 427,
  [655] = 471,
  [656] = 464,
  [657] = 410,
  [658] = 658,
  [659] = 658,
  [660] = 658,
  [661] = 661,
  [662] = 661,
  [663] = 661,
  [664] = 664,
  [665] = 664,
  [666] = 664,
  [667] = 667,
  [668] = 667,
  [669] = 667,
  [670] = 670,
  [671] = 670,
  [672] = 670,
  [673] = 673,
  [674] = 674,
  [675] = 673,
  [676] = 674,
  [677] = 264,
  [678] = 232,
  [679] = 674,
  [680] = 673,
  [681] = 681,
  [682] = 682,
  [683] = 681,
  [684] = 684,
  [685] = 685,
  [686] = 681,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 689,
  [691] = 691,
  [692] = 692,
  [693] = 692,
  [694] = 692,
  [695] = 691,
  [696] = 691,
  [697] = 689,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 699,
  [702] = 698,
  [703] = 700,
  [704] = 698,
  [705] = 705,
  [706] = 705,
  [707] = 698,
  [708] = 705,
  [709] = 698,
  [710] = 698,
  [711] = 711,
  [712] = 712,
  [713] = 248,
  [714] = 714,
  [715] = 698,
  [716] = 698,
  [717] = 250,
  [718] = 698,
  [719] = 699,
  [720] = 720,
  [721] = 262,
  [722] = 235,
  [723] = 723,
  [724] = 249,
  [725] = 248,
  [726] = 234,
  [727] = 250,
  [728] = 698,
  [729] = 698,
  [730] = 720,
  [731] = 720,
  [732] = 698,
  [733] = 249,
  [734] = 234,
  [735] = 735,
  [736] = 698,
  [737] = 712,
  [738] = 224,
  [739] = 227,
  [740] = 698,
  [741] = 698,
  [742] = 698,
  [743] = 700,
  [744] = 744,
  [745] = 745,
  [746] = 698,
  [747] = 225,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 749,
  [753] = 753,
  [754] = 749,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 749,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 749,
  [764] = 764,
  [765] = 765,
  [766] = 749,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 252,
  [771] = 749,
  [772] = 253,
  [773] = 773,
  [774] = 774,
  [775] = 749,
  [776] = 776,
  [777] = 749,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 786,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 786,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 256,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 786,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 786,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 262,
  [841] = 235,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 260,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 906,
  [909] = 906,
  [910] = 907,
  [911] = 906,
  [912] = 906,
  [913] = 907,
  [914] = 907,
  [915] = 907,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 761,
  [920] = 920,
  [921] = 753,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 931,
  [933] = 931,
  [934] = 934,
  [935] = 931,
  [936] = 934,
  [937] = 937,
  [938] = 934,
  [939] = 937,
  [940] = 937,
  [941] = 934,
  [942] = 931,
  [943] = 931,
  [944] = 934,
  [945] = 931,
  [946] = 934,
  [947] = 934,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 951,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 954,
  [957] = 954,
  [958] = 951,
  [959] = 954,
  [960] = 951,
  [961] = 951,
  [962] = 954,
  [963] = 951,
  [964] = 955,
  [965] = 955,
  [966] = 954,
  [967] = 954,
  [968] = 955,
  [969] = 951,
  [970] = 955,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 980,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 973,
  [994] = 974,
  [995] = 995,
  [996] = 996,
  [997] = 975,
  [998] = 976,
  [999] = 988,
  [1000] = 989,
  [1001] = 977,
  [1002] = 978,
  [1003] = 979,
  [1004] = 990,
  [1005] = 980,
  [1006] = 991,
  [1007] = 992,
  [1008] = 988,
  [1009] = 989,
  [1010] = 990,
  [1011] = 995,
  [1012] = 996,
  [1013] = 991,
  [1014] = 992,
  [1015] = 979,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 995,
  [1019] = 996,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 987,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 973,
  [1027] = 974,
  [1028] = 1020,
  [1029] = 1021,
  [1030] = 973,
  [1031] = 974,
  [1032] = 995,
  [1033] = 996,
  [1034] = 975,
  [1035] = 976,
  [1036] = 1036,
  [1037] = 977,
  [1038] = 978,
  [1039] = 972,
  [1040] = 979,
  [1041] = 980,
  [1042] = 995,
  [1043] = 996,
  [1044] = 975,
  [1045] = 976,
  [1046] = 1046,
  [1047] = 977,
  [1048] = 978,
  [1049] = 979,
  [1050] = 980,
  [1051] = 1051,
  [1052] = 1025,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 988,
  [1056] = 989,
  [1057] = 990,
  [1058] = 991,
  [1059] = 991,
  [1060] = 972,
  [1061] = 992,
  [1062] = 973,
  [1063] = 974,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 973,
  [1067] = 974,
  [1068] = 995,
  [1069] = 996,
  [1070] = 971,
  [1071] = 975,
  [1072] = 976,
  [1073] = 1025,
  [1074] = 977,
  [1075] = 972,
  [1076] = 978,
  [1077] = 979,
  [1078] = 980,
  [1079] = 988,
  [1080] = 989,
  [1081] = 990,
  [1082] = 991,
  [1083] = 992,
  [1084] = 1025,
  [1085] = 972,
  [1086] = 995,
  [1087] = 996,
  [1088] = 1025,
  [1089] = 1025,
  [1090] = 973,
  [1091] = 974,
  [1092] = 975,
  [1093] = 976,
  [1094] = 988,
  [1095] = 989,
  [1096] = 990,
  [1097] = 991,
  [1098] = 992,
  [1099] = 972,
  [1100] = 986,
  [1101] = 977,
  [1102] = 978,
  [1103] = 1025,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 985,
  [1108] = 979,
  [1109] = 975,
  [1110] = 976,
  [1111] = 980,
  [1112] = 977,
  [1113] = 978,
  [1114] = 972,
  [1115] = 988,
  [1116] = 989,
  [1117] = 1036,
  [1118] = 990,
  [1119] = 971,
  [1120] = 971,
  [1121] = 971,
  [1122] = 971,
  [1123] = 971,
  [1124] = 992,
  [1125] = 1125,
  [1126] = 1125,
  [1127] = 1125,
  [1128] = 1125,
  [1129] = 1125,
  [1130] = 1125,
  [1131] = 1125,
  [1132] = 1125,
  [1133] = 1125,
  [1134] = 1125,
  [1135] = 1125,
  [1136] = 1125,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1137,
  [1140] = 1140,
  [1141] = 1138,
  [1142] = 1138,
  [1143] = 1137,
  [1144] = 1140,
  [1145] = 1140,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1146,
  [1149] = 1149,
  [1150] = 1147,
  [1151] = 1151,
  [1152] = 1151,
  [1153] = 1147,
  [1154] = 1147,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1147,
  [1159] = 1156,
  [1160] = 1155,
  [1161] = 1147,
  [1162] = 1155,
  [1163] = 1157,
  [1164] = 1157,
  [1165] = 1149,
  [1166] = 1156,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1147,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1168,
  [1180] = 1147,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1168,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1147,
  [1189] = 1185,
  [1190] = 1190,
  [1191] = 1185,
  [1192] = 1147,
  [1193] = 1147,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 753,
  [1197] = 1146,
  [1198] = 1195,
  [1199] = 1195,
  [1200] = 1200,
  [1201] = 761,
  [1202] = 1190,
  [1203] = 1147,
  [1204] = 1190,
  [1205] = 1205,
  [1206] = 1178,
  [1207] = 1194,
  [1208] = 1147,
  [1209] = 1178,
  [1210] = 1210,
  [1211] = 1178,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1178,
  [1215] = 1215,
  [1216] = 1147,
  [1217] = 1147,
  [1218] = 1147,
  [1219] = 1147,
  [1220] = 1149,
  [1221] = 1181,
  [1222] = 1147,
  [1223] = 1212,
  [1224] = 1212,
  [1225] = 1225,
  [1226] = 1225,
  [1227] = 1227,
  [1228] = 1178,
  [1229] = 1229,
  [1230] = 1225,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1178,
  [1234] = 1234,
  [1235] = 1225,
  [1236] = 1205,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1205,
  [1240] = 1178,
  [1241] = 1225,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1227,
  [1245] = 1225,
  [1246] = 1225,
  [1247] = 1243,
  [1248] = 1248,
  [1249] = 1249,
  [1250] = 1178,
  [1251] = 1225,
  [1252] = 1225,
  [1253] = 1253,
  [1254] = 1249,
  [1255] = 1229,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1173,
  [1259] = 1210,
  [1260] = 1237,
  [1261] = 1261,
  [1262] = 1173,
  [1263] = 1174,
  [1264] = 1210,
  [1265] = 1265,
  [1266] = 1178,
  [1267] = 1267,
  [1268] = 1205,
  [1269] = 1174,
  [1270] = 1270,
  [1271] = 1200,
  [1272] = 1178,
  [1273] = 1273,
  [1274] = 1237,
  [1275] = 1178,
  [1276] = 1173,
  [1277] = 1273,
  [1278] = 1174,
  [1279] = 1261,
  [1280] = 1280,
  [1281] = 1205,
  [1282] = 1205,
  [1283] = 1273,
  [1284] = 1270,
  [1285] = 1170,
  [1286] = 1178,
  [1287] = 1210,
  [1288] = 753,
  [1289] = 1289,
  [1290] = 1249,
  [1291] = 1178,
  [1292] = 1205,
  [1293] = 1293,
  [1294] = 1169,
  [1295] = 1237,
  [1296] = 1243,
  [1297] = 1243,
  [1298] = 1243,
  [1299] = 1293,
  [1300] = 1234,
  [1301] = 1171,
  [1302] = 1249,
  [1303] = 761,
  [1304] = 1304,
  [1305] = 1175,
  [1306] = 1304,
  [1307] = 1210,
  [1308] = 1172,
  [1309] = 1304,
  [1310] = 1293,
  [1311] = 1177,
  [1312] = 1167,
  [1313] = 1289,
  [1314] = 1249,
  [1315] = 1249,
  [1316] = 1205,
  [1317] = 1200,
  [1318] = 1205,
  [1319] = 1243,
  [1320] = 1210,
  [1321] = 1174,
  [1322] = 1322,
  [1323] = 1253,
  [1324] = 1173,
  [1325] = 1174,
  [1326] = 1326,
  [1327] = 1210,
  [1328] = 1205,
  [1329] = 1243,
  [1330] = 1200,
  [1331] = 1173,
  [1332] = 1257,
  [1333] = 1243,
  [1334] = 1210,
  [1335] = 1335,
  [1336] = 1200,
  [1337] = 1210,
  [1338] = 1249,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1249,
  [1342] = 1326,
  [1343] = 1174,
  [1344] = 1229,
  [1345] = 1243,
  [1346] = 1346,
  [1347] = 1347,
  [1348] = 1243,
  [1349] = 1210,
  [1350] = 1249,
  [1351] = 1346,
  [1352] = 1346,
  [1353] = 1249,
  [1354] = 1354,
  [1355] = 1346,
  [1356] = 1356,
  [1357] = 1357,
  [1358] = 1243,
  [1359] = 1346,
  [1360] = 1173,
  [1361] = 1361,
  [1362] = 1249,
  [1363] = 1227,
  [1364] = 1249,
  [1365] = 1200,
  [1366] = 1243,
  [1367] = 1346,
  [1368] = 1243,
  [1369] = 1261,
  [1370] = 1243,
  [1371] = 1243,
  [1372] = 1243,
  [1373] = 1200,
  [1374] = 1234,
  [1375] = 1322,
  [1376] = 1335,
  [1377] = 1200,
  [1378] = 1249,
  [1379] = 1249,
  [1380] = 1249,
  [1381] = 1249,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1382,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1257,
  [1388] = 1385,
  [1389] = 1389,
  [1390] = 1347,
  [1391] = 1389,
  [1392] = 1386,
  [1393] = 1382,
  [1394] = 1383,
  [1395] = 1385,
  [1396] = 1385,
  [1397] = 1389,
  [1398] = 1382,
  [1399] = 1243,
  [1400] = 1383,
  [1401] = 1383,
  [1402] = 1386,
  [1403] = 1386,
  [1404] = 1383,
  [1405] = 1389,
  [1406] = 1382,
  [1407] = 1382,
  [1408] = 1383,
  [1409] = 1382,
  [1410] = 1383,
  [1411] = 1249,
  [1412] = 1386,
  [1413] = 1200,
  [1414] = 1200,
  [1415] = 1383,
  [1416] = 1382,
  [1417] = 1385,
  [1418] = 1386,
  [1419] = 1383,
  [1420] = 1389,
  [1421] = 1385,
  [1422] = 1389,
  [1423] = 1382,
  [1424] = 1424,
  [1425] = 1424,
  [1426] = 1424,
  [1427] = 1424,
  [1428] = 1424,
  [1429] = 1424,
  [1430] = 1424,
  [1431] = 1424,
  [1432] = 1424,
  [1433] = 1433,
  [1434] = 1433,
  [1435] = 1433,
  [1436] = 1433,
  [1437] = 1437,
  [1438] = 1433,
  [1439] = 1433,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1440,
  [1444] = 1442,
  [1445] = 1440,
  [1446] = 1446,
  [1447] = 1440,
  [1448] = 1442,
  [1449] = 1440,
  [1450] = 1441,
  [1451] = 1441,
  [1452] = 1442,
  [1453] = 1441,
  [1454] = 1442,
  [1455] = 1441,
  [1456] = 1456,
  [1457] = 1456,
  [1458] = 1456,
  [1459] = 1456,
  [1460] = 1460,
  [1461] = 1456,
  [1462] = 1456,
  [1463] = 1463,
  [1464] = 264,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 232,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 264,
  [1472] = 1472,
  [1473] = 229,
  [1474] = 950,
  [1475] = 232,
  [1476] = 948,
  [1477] = 1477,
  [1478] = 1478,
  [1479] = 1479,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 949,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 225,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 682,
  [1496] = 1496,
  [1497] = 248,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 224,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 227,
  [1511] = 1511,
  [1512] = 225,
  [1513] = 1513,
  [1514] = 227,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 684,
  [1520] = 1520,
  [1521] = 1521,
  [1522] = 1522,
  [1523] = 1523,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1531,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1544,
  [1545] = 1545,
  [1546] = 687,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 224,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1555,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1563,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1570,
  [1571] = 685,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1574,
  [1575] = 1575,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1588,
  [1589] = 688,
  [1590] = 1590,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1607,
  [1608] = 250,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1611,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1612,
  [1617] = 1617,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1460,
  [1629] = 1629,
  [1630] = 260,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 249,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1612,
  [1656] = 1612,
  [1657] = 1657,
  [1658] = 252,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 235,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 262,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1677,
  [1678] = 252,
  [1679] = 253,
  [1680] = 1680,
  [1681] = 234,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 253,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1612,
  [1695] = 256,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1721,
  [1722] = 1722,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1727,
  [1728] = 248,
  [1729] = 1701,
  [1730] = 1470,
  [1731] = 256,
  [1732] = 1697,
  [1733] = 250,
  [1734] = 1734,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1469,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1738,
  [1741] = 249,
  [1742] = 260,
  [1743] = 1735,
  [1744] = 235,
  [1745] = 1738,
  [1746] = 1466,
  [1747] = 234,
  [1748] = 1735,
  [1749] = 1749,
  [1750] = 1738,
  [1751] = 1692,
  [1752] = 1735,
  [1753] = 1735,
  [1754] = 1754,
  [1755] = 262,
  [1756] = 1738,
  [1757] = 1467,
  [1758] = 1726,
  [1759] = 1759,
  [1760] = 1680,
  [1761] = 1716,
  [1762] = 1537,
  [1763] = 1693,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1477,
  [1767] = 1478,
  [1768] = 1480,
  [1769] = 1481,
  [1770] = 1770,
  [1771] = 1718,
  [1772] = 1672,
  [1773] = 1700,
  [1774] = 950,
  [1775] = 1653,
  [1776] = 1613,
  [1777] = 1618,
  [1778] = 1626,
  [1779] = 1646,
  [1780] = 1659,
  [1781] = 1484,
  [1782] = 1666,
  [1783] = 1677,
  [1784] = 1689,
  [1785] = 1660,
  [1786] = 1708,
  [1787] = 1787,
  [1788] = 1702,
  [1789] = 1610,
  [1790] = 1712,
  [1791] = 1482,
  [1792] = 1472,
  [1793] = 1787,
  [1794] = 1588,
  [1795] = 1479,
  [1796] = 1764,
  [1797] = 1595,
  [1798] = 1692,
  [1799] = 1697,
  [1800] = 1701,
  [1801] = 1486,
  [1802] = 1802,
  [1803] = 1529,
  [1804] = 1566,
  [1805] = 1805,
  [1806] = 1726,
  [1807] = 1529,
  [1808] = 1566,
  [1809] = 1674,
  [1810] = 1712,
  [1811] = 1620,
  [1812] = 1759,
  [1813] = 1634,
  [1814] = 1635,
  [1815] = 949,
  [1816] = 1529,
  [1817] = 1787,
  [1818] = 1787,
  [1819] = 1566,
  [1820] = 1759,
  [1821] = 1699,
  [1822] = 1725,
  [1823] = 1787,
  [1824] = 1759,
  [1825] = 1699,
  [1826] = 1725,
  [1827] = 1716,
  [1828] = 1718,
  [1829] = 1672,
  [1830] = 1700,
  [1831] = 1653,
  [1832] = 1613,
  [1833] = 1618,
  [1834] = 1626,
  [1835] = 1646,
  [1836] = 1659,
  [1837] = 1666,
  [1838] = 1677,
  [1839] = 1689,
  [1840] = 1660,
  [1841] = 1708,
  [1842] = 1702,
  [1843] = 1610,
  [1844] = 1674,
  [1845] = 1617,
  [1846] = 1620,
  [1847] = 1634,
  [1848] = 1635,
  [1849] = 1641,
  [1850] = 1850,
  [1851] = 948,
  [1852] = 1641,
  [1853] = 1853,
  [1854] = 1680,
  [1855] = 1693,
  [1856] = 1617,
  [1857] = 1604,
  [1858] = 1487,
  [1859] = 1548,
  [1860] = 1549,
  [1861] = 1550,
  [1862] = 1609,
  [1863] = 1552,
  [1864] = 1553,
  [1865] = 1554,
  [1866] = 1555,
  [1867] = 1556,
  [1868] = 1557,
  [1869] = 1558,
  [1870] = 1559,
  [1871] = 1560,
  [1872] = 1562,
  [1873] = 1563,
  [1874] = 1565,
  [1875] = 1567,
  [1876] = 1569,
  [1877] = 1570,
  [1878] = 1547,
  [1879] = 685,
  [1880] = 1572,
  [1881] = 1573,
  [1882] = 1575,
  [1883] = 1577,
  [1884] = 1578,
  [1885] = 1579,
  [1886] = 1580,
  [1887] = 1581,
  [1888] = 1583,
  [1889] = 1584,
  [1890] = 1585,
  [1891] = 1586,
  [1892] = 1587,
  [1893] = 688,
  [1894] = 1590,
  [1895] = 1592,
  [1896] = 1593,
  [1897] = 1594,
  [1898] = 1596,
  [1899] = 1597,
  [1900] = 1598,
  [1901] = 1599,
  [1902] = 1600,
  [1903] = 1601,
  [1904] = 1602,
  [1905] = 1605,
  [1906] = 229,
  [1907] = 1490,
  [1908] = 1908,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1912,
  [1913] = 1722,
  [1914] = 1914,
  [1915] = 1516,
  [1916] = 1916,
  [1917] = 1529,
  [1918] = 1532,
  [1919] = 1566,
  [1920] = 682,
  [1921] = 1496,
  [1922] = 1504,
  [1923] = 1498,
  [1924] = 1561,
  [1925] = 1574,
  [1926] = 1499,
  [1927] = 1692,
  [1928] = 1524,
  [1929] = 1910,
  [1930] = 1930,
  [1931] = 1720,
  [1932] = 1932,
  [1933] = 1802,
  [1934] = 1568,
  [1935] = 1564,
  [1936] = 1936,
  [1937] = 1582,
  [1938] = 1727,
  [1939] = 1576,
  [1940] = 1940,
  [1941] = 1941,
  [1942] = 1500,
  [1943] = 1943,
  [1944] = 1944,
  [1945] = 1603,
  [1946] = 1946,
  [1947] = 1910,
  [1948] = 1932,
  [1949] = 1802,
  [1950] = 1529,
  [1951] = 1566,
  [1952] = 1588,
  [1953] = 1501,
  [1954] = 1595,
  [1955] = 1910,
  [1956] = 1529,
  [1957] = 1566,
  [1958] = 1720,
  [1959] = 1727,
  [1960] = 1722,
  [1961] = 1502,
  [1962] = 1503,
  [1963] = 1537,
  [1964] = 1505,
  [1965] = 1965,
  [1966] = 1507,
  [1967] = 1508,
  [1968] = 1509,
  [1969] = 1969,
  [1970] = 1513,
  [1971] = 1971,
  [1972] = 1515,
  [1973] = 1491,
  [1974] = 1564,
  [1975] = 1517,
  [1976] = 1518,
  [1977] = 1582,
  [1978] = 1727,
  [1979] = 1588,
  [1980] = 1492,
  [1981] = 1493,
  [1982] = 1720,
  [1983] = 1722,
  [1984] = 1754,
  [1985] = 1697,
  [1986] = 1965,
  [1987] = 1494,
  [1988] = 1988,
  [1989] = 1607,
  [1990] = 1591,
  [1991] = 229,
  [1992] = 1910,
  [1993] = 1489,
  [1994] = 684,
  [1995] = 1520,
  [1996] = 1521,
  [1997] = 1522,
  [1998] = 1523,
  [1999] = 1525,
  [2000] = 1526,
  [2001] = 1527,
  [2002] = 1754,
  [2003] = 1528,
  [2004] = 1530,
  [2005] = 1531,
  [2006] = 1533,
  [2007] = 1534,
  [2008] = 1535,
  [2009] = 1536,
  [2010] = 1538,
  [2011] = 1539,
  [2012] = 1540,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 1541,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 1542,
  [2020] = 1543,
  [2021] = 2021,
  [2022] = 1544,
  [2023] = 2023,
  [2024] = 1701,
  [2025] = 1910,
  [2026] = 2026,
  [2027] = 1595,
  [2028] = 1545,
  [2029] = 1606,
  [2030] = 687,
  [2031] = 1699,
  [2032] = 1725,
  [2033] = 1716,
  [2034] = 1718,
  [2035] = 1672,
  [2036] = 1700,
  [2037] = 1653,
  [2038] = 1613,
  [2039] = 1618,
  [2040] = 1626,
  [2041] = 1646,
  [2042] = 1659,
  [2043] = 1666,
  [2044] = 1677,
  [2045] = 1689,
  [2046] = 1660,
  [2047] = 1708,
  [2048] = 1702,
  [2049] = 1610,
  [2050] = 1674,
  [2051] = 1617,
  [2052] = 1620,
  [2053] = 1634,
  [2054] = 1635,
  [2055] = 1641,
  [2056] = 1726,
  [2057] = 1680,
  [2058] = 1693,
  [2059] = 1712,
  [2060] = 1511,
  [2061] = 1651,
  [2062] = 1640,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 1685,
  [2067] = 245,
  [2068] = 246,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 1652,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 241,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 1682,
  [2080] = 1614,
  [2081] = 1676,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 1720,
  [2089] = 1625,
  [2090] = 1698,
  [2091] = 2085,
  [2092] = 1727,
  [2093] = 2093,
  [2094] = 2087,
  [2095] = 2085,
  [2096] = 1703,
  [2097] = 2087,
  [2098] = 2098,
  [2099] = 2099,
  [2100] = 261,
  [2101] = 2101,
  [2102] = 2102,
  [2103] = 1529,
  [2104] = 1566,
  [2105] = 1647,
  [2106] = 2098,
  [2107] = 2099,
  [2108] = 2108,
  [2109] = 1529,
  [2110] = 1566,
  [2111] = 2098,
  [2112] = 2099,
  [2113] = 2098,
  [2114] = 2099,
  [2115] = 2115,
  [2116] = 254,
  [2117] = 2098,
  [2118] = 2099,
  [2119] = 2119,
  [2120] = 1654,
  [2121] = 1657,
  [2122] = 255,
  [2123] = 1688,
  [2124] = 1714,
  [2125] = 2125,
  [2126] = 1619,
  [2127] = 1649,
  [2128] = 1623,
  [2129] = 2129,
  [2130] = 1632,
  [2131] = 1675,
  [2132] = 1537,
  [2133] = 1637,
  [2134] = 1648,
  [2135] = 1699,
  [2136] = 1725,
  [2137] = 1662,
  [2138] = 1716,
  [2139] = 1663,
  [2140] = 1667,
  [2141] = 1668,
  [2142] = 1718,
  [2143] = 1672,
  [2144] = 1700,
  [2145] = 2145,
  [2146] = 1653,
  [2147] = 2147,
  [2148] = 1613,
  [2149] = 1618,
  [2150] = 1626,
  [2151] = 1646,
  [2152] = 1659,
  [2153] = 1666,
  [2154] = 1677,
  [2155] = 1689,
  [2156] = 1670,
  [2157] = 1660,
  [2158] = 1708,
  [2159] = 2159,
  [2160] = 1702,
  [2161] = 1610,
  [2162] = 1674,
  [2163] = 1617,
  [2164] = 1620,
  [2165] = 1634,
  [2166] = 1635,
  [2167] = 2167,
  [2168] = 1641,
  [2169] = 2169,
  [2170] = 2170,
  [2171] = 243,
  [2172] = 1687,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 1615,
  [2176] = 1770,
  [2177] = 1683,
  [2178] = 2167,
  [2179] = 1684,
  [2180] = 1690,
  [2181] = 1705,
  [2182] = 2159,
  [2183] = 1642,
  [2184] = 1645,
  [2185] = 2145,
  [2186] = 1709,
  [2187] = 1710,
  [2188] = 1704,
  [2189] = 1661,
  [2190] = 2145,
  [2191] = 1711,
  [2192] = 1715,
  [2193] = 1717,
  [2194] = 1719,
  [2195] = 1696,
  [2196] = 2145,
  [2197] = 2145,
  [2198] = 2198,
  [2199] = 2145,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2204,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 1726,
  [2208] = 1680,
  [2209] = 1693,
  [2210] = 1712,
  [2211] = 2211,
  [2212] = 2212,
  [2213] = 1669,
  [2214] = 251,
  [2215] = 2215,
  [2216] = 2216,
  [2217] = 2217,
  [2218] = 237,
  [2219] = 1706,
  [2220] = 2220,
  [2221] = 1713,
  [2222] = 1707,
  [2223] = 1673,
  [2224] = 2224,
  [2225] = 2225,
  [2226] = 2226,
  [2227] = 2085,
  [2228] = 1724,
  [2229] = 2087,
  [2230] = 2073,
  [2231] = 1633,
  [2232] = 261,
  [2233] = 2233,
  [2234] = 2202,
  [2235] = 2235,
  [2236] = 2212,
  [2237] = 1720,
  [2238] = 2238,
  [2239] = 2239,
  [2240] = 2240,
  [2241] = 2075,
  [2242] = 2093,
  [2243] = 2243,
  [2244] = 2145,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2248,
  [2249] = 1699,
  [2250] = 1725,
  [2251] = 1716,
  [2252] = 1718,
  [2253] = 1672,
  [2254] = 1700,
  [2255] = 1653,
  [2256] = 1613,
  [2257] = 1618,
  [2258] = 1626,
  [2259] = 1646,
  [2260] = 1659,
  [2261] = 1666,
  [2262] = 1677,
  [2263] = 1689,
  [2264] = 1660,
  [2265] = 1708,
  [2266] = 1702,
  [2267] = 1610,
  [2268] = 1674,
  [2269] = 1617,
  [2270] = 1620,
  [2271] = 1634,
  [2272] = 1635,
  [2273] = 1641,
  [2274] = 1691,
  [2275] = 238,
  [2276] = 2245,
  [2277] = 1629,
  [2278] = 2278,
  [2279] = 1726,
  [2280] = 1680,
  [2281] = 1693,
  [2282] = 1712,
  [2283] = 1611,
  [2284] = 1621,
  [2285] = 1721,
  [2286] = 239,
  [2287] = 1802,
  [2288] = 243,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 1627,
  [2292] = 2085,
  [2293] = 1643,
  [2294] = 2087,
  [2295] = 2295,
  [2296] = 1564,
  [2297] = 2297,
  [2298] = 1622,
  [2299] = 1624,
  [2300] = 1631,
  [2301] = 1636,
  [2302] = 1638,
  [2303] = 1639,
  [2304] = 2304,
  [2305] = 1665,
  [2306] = 2238,
  [2307] = 2239,
  [2308] = 2308,
  [2309] = 2240,
  [2310] = 1582,
  [2311] = 1727,
  [2312] = 1916,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2203,
  [2317] = 2129,
  [2318] = 2318,
  [2319] = 251,
  [2320] = 237,
  [2321] = 240,
  [2322] = 241,
  [2323] = 1739,
  [2324] = 238,
  [2325] = 245,
  [2326] = 246,
  [2327] = 254,
  [2328] = 255,
  [2329] = 239,
  [2330] = 2330,
  [2331] = 2331,
  [2332] = 1754,
  [2333] = 2147,
  [2334] = 2085,
  [2335] = 2078,
  [2336] = 2087,
  [2337] = 2337,
  [2338] = 1916,
  [2339] = 1723,
  [2340] = 1770,
  [2341] = 240,
  [2342] = 1754,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2202,
  [2347] = 2238,
  [2348] = 2239,
  [2349] = 2075,
  [2350] = 1537,
  [2351] = 2315,
  [2352] = 2203,
  [2353] = 2078,
  [2354] = 1754,
  [2355] = 1650,
  [2356] = 2315,
  [2357] = 2318,
  [2358] = 2358,
  [2359] = 1697,
  [2360] = 1646,
  [2361] = 1659,
  [2362] = 1666,
  [2363] = 1677,
  [2364] = 1689,
  [2365] = 1660,
  [2366] = 1708,
  [2367] = 1702,
  [2368] = 1610,
  [2369] = 1674,
  [2370] = 1617,
  [2371] = 1620,
  [2372] = 1634,
  [2373] = 1635,
  [2374] = 1641,
  [2375] = 2375,
  [2376] = 1564,
  [2377] = 257,
  [2378] = 2378,
  [2379] = 2379,
  [2380] = 1726,
  [2381] = 1680,
  [2382] = 2382,
  [2383] = 1693,
  [2384] = 1712,
  [2385] = 1582,
  [2386] = 2386,
  [2387] = 2387,
  [2388] = 1529,
  [2389] = 1765,
  [2390] = 2390,
  [2391] = 1566,
  [2392] = 2392,
  [2393] = 2393,
  [2394] = 2394,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 2397,
  [2398] = 2398,
  [2399] = 2399,
  [2400] = 2378,
  [2401] = 2401,
  [2402] = 1692,
  [2403] = 2403,
  [2404] = 1697,
  [2405] = 2378,
  [2406] = 2397,
  [2407] = 2407,
  [2408] = 1701,
  [2409] = 2409,
  [2410] = 2393,
  [2411] = 257,
  [2412] = 1588,
  [2413] = 1720,
  [2414] = 2414,
  [2415] = 2399,
  [2416] = 2379,
  [2417] = 2398,
  [2418] = 2418,
  [2419] = 1727,
  [2420] = 2420,
  [2421] = 2421,
  [2422] = 1618,
  [2423] = 1626,
  [2424] = 2424,
  [2425] = 2378,
  [2426] = 2378,
  [2427] = 2427,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 1770,
  [2431] = 1722,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 1699,
  [2435] = 1725,
  [2436] = 1716,
  [2437] = 1718,
  [2438] = 1672,
  [2439] = 1700,
  [2440] = 1653,
  [2441] = 1613,
  [2442] = 1618,
  [2443] = 1626,
  [2444] = 1646,
  [2445] = 1659,
  [2446] = 1666,
  [2447] = 1677,
  [2448] = 1689,
  [2449] = 1660,
  [2450] = 1708,
  [2451] = 1702,
  [2452] = 1610,
  [2453] = 1674,
  [2454] = 1617,
  [2455] = 1620,
  [2456] = 1634,
  [2457] = 1635,
  [2458] = 1641,
  [2459] = 1754,
  [2460] = 1595,
  [2461] = 2461,
  [2462] = 2462,
  [2463] = 2387,
  [2464] = 2464,
  [2465] = 1726,
  [2466] = 1680,
  [2467] = 1693,
  [2468] = 1712,
  [2469] = 1699,
  [2470] = 1725,
  [2471] = 1716,
  [2472] = 1754,
  [2473] = 1754,
  [2474] = 1718,
  [2475] = 1537,
  [2476] = 1722,
  [2477] = 1672,
  [2478] = 1700,
  [2479] = 1653,
  [2480] = 1613,
  [2481] = 2378,
  [2482] = 2482,
  [2483] = 1537,
  [2484] = 1916,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 2487,
  [2488] = 2488,
  [2489] = 2489,
  [2490] = 1692,
  [2491] = 1697,
  [2492] = 1701,
  [2493] = 950,
  [2494] = 1722,
  [2495] = 949,
  [2496] = 2496,
  [2497] = 1588,
  [2498] = 948,
  [2499] = 1595,
  [2500] = 2500,
  [2501] = 1722,
  [2502] = 1720,
  [2503] = 1727,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 1699,
  [2507] = 1725,
  [2508] = 1716,
  [2509] = 1718,
  [2510] = 1672,
  [2511] = 1700,
  [2512] = 1653,
  [2513] = 1613,
  [2514] = 1618,
  [2515] = 1626,
  [2516] = 1646,
  [2517] = 1659,
  [2518] = 1666,
  [2519] = 1677,
  [2520] = 1689,
  [2521] = 1660,
  [2522] = 1708,
  [2523] = 1702,
  [2524] = 1610,
  [2525] = 1674,
  [2526] = 1617,
  [2527] = 1620,
  [2528] = 1634,
  [2529] = 1635,
  [2530] = 1641,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2533,
  [2534] = 2534,
  [2535] = 2535,
  [2536] = 2536,
  [2537] = 2537,
  [2538] = 2538,
  [2539] = 1754,
  [2540] = 2018,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 1726,
  [2546] = 1680,
  [2547] = 1693,
  [2548] = 1712,
  [2549] = 2504,
  [2550] = 2504,
  [2551] = 2504,
  [2552] = 2552,
  [2553] = 2553,
  [2554] = 2504,
  [2555] = 1537,
  [2556] = 2504,
  [2557] = 2557,
  [2558] = 2558,
  [2559] = 2559,
  [2560] = 2560,
  [2561] = 2504,
  [2562] = 1764,
  [2563] = 2505,
  [2564] = 2504,
  [2565] = 2504,
  [2566] = 2099,
  [2567] = 2567,
  [2568] = 1770,
  [2569] = 2569,
  [2570] = 2570,
  [2571] = 2571,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2098,
  [2576] = 2099,
  [2577] = 2098,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 2098,
  [2581] = 2581,
  [2582] = 2582,
  [2583] = 2583,
  [2584] = 2394,
  [2585] = 2099,
  [2586] = 2586,
  [2587] = 2587,
  [2588] = 2098,
  [2589] = 2099,
  [2590] = 2590,
  [2591] = 2591,
  [2592] = 2592,
  [2593] = 2593,
  [2594] = 2098,
  [2595] = 2099,
  [2596] = 2592,
  [2597] = 2098,
  [2598] = 2099,
  [2599] = 2599,
  [2600] = 2600,
  [2601] = 1537,
  [2602] = 1537,
  [2603] = 2603,
  [2604] = 2604,
  [2605] = 1576,
  [2606] = 2606,
  [2607] = 2607,
  [2608] = 2608,
  [2609] = 2609,
  [2610] = 2610,
  [2611] = 2611,
  [2612] = 2612,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2615,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2618,
  [2619] = 2608,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2622,
  [2623] = 2623,
  [2624] = 2624,
  [2625] = 2625,
  [2626] = 2626,
  [2627] = 2608,
  [2628] = 249,
  [2629] = 2629,
  [2630] = 2630,
  [2631] = 2631,
  [2632] = 2632,
  [2633] = 248,
  [2634] = 2634,
  [2635] = 2608,
  [2636] = 2636,
  [2637] = 234,
  [2638] = 2608,
  [2639] = 2639,
  [2640] = 2640,
  [2641] = 2641,
  [2642] = 2642,
  [2643] = 2608,
  [2644] = 2644,
  [2645] = 2645,
  [2646] = 250,
  [2647] = 2647,
  [2648] = 2608,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2655,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 1213,
  [2660] = 2660,
  [2661] = 2608,
  [2662] = 2662,
  [2663] = 248,
  [2664] = 2664,
  [2665] = 2608,
  [2666] = 250,
  [2667] = 1256,
  [2668] = 2668,
  [2669] = 1603,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 2673,
  [2674] = 2674,
  [2675] = 234,
  [2676] = 2500,
  [2677] = 2677,
  [2678] = 2678,
  [2679] = 249,
  [2680] = 2680,
  [2681] = 2496,
  [2682] = 2682,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 2069,
  [2687] = 2289,
  [2688] = 2217,
  [2689] = 2689,
  [2690] = 2690,
  [2691] = 2691,
  [2692] = 2692,
  [2693] = 2086,
  [2694] = 2694,
  [2695] = 2420,
  [2696] = 2393,
  [2697] = 2407,
  [2698] = 2397,
  [2699] = 2398,
  [2700] = 2399,
  [2701] = 2701,
  [2702] = 2702,
  [2703] = 2409,
  [2704] = 2701,
  [2705] = 1248,
  [2706] = 2461,
  [2707] = 2414,
  [2708] = 2398,
  [2709] = 2709,
  [2710] = 2403,
  [2711] = 2711,
  [2712] = 2461,
  [2713] = 2399,
  [2714] = 2390,
  [2715] = 2403,
  [2716] = 2414,
  [2717] = 2709,
  [2718] = 2393,
  [2719] = 2719,
  [2720] = 2421,
  [2721] = 2397,
  [2722] = 2395,
  [2723] = 2390,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2727,
  [2728] = 2728,
  [2729] = 2729,
  [2730] = 2730,
  [2731] = 2731,
  [2732] = 2732,
  [2733] = 2729,
  [2734] = 2734,
  [2735] = 2725,
  [2736] = 2732,
  [2737] = 2730,
  [2738] = 2738,
  [2739] = 2731,
  [2740] = 2730,
  [2741] = 2734,
  [2742] = 2730,
  [2743] = 2726,
  [2744] = 2744,
  [2745] = 2732,
  [2746] = 2746,
  [2747] = 2747,
  [2748] = 1267,
  [2749] = 2749,
  [2750] = 2750,
  [2751] = 2751,
  [2752] = 1232,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2756,
  [2757] = 2757,
  [2758] = 1280,
  [2759] = 2759,
  [2760] = 2760,
  [2761] = 2761,
  [2762] = 2762,
  [2763] = 1231,
  [2764] = 2764,
  [2765] = 2462,
  [2766] = 1265,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 2772,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2777,
  [2778] = 2778,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2782,
  [2783] = 2783,
  [2784] = 2784,
  [2785] = 2773,
  [2786] = 2786,
  [2787] = 2787,
  [2788] = 2772,
  [2789] = 2789,
  [2790] = 2790,
  [2791] = 2791,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2794,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2784,
  [2799] = 2771,
  [2800] = 2793,
  [2801] = 2801,
  [2802] = 2779,
  [2803] = 2803,
  [2804] = 2804,
  [2805] = 2805,
  [2806] = 2806,
  [2807] = 2804,
  [2808] = 2808,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2811,
  [2812] = 2812,
  [2813] = 2813,
  [2814] = 2814,
  [2815] = 2815,
  [2816] = 2816,
  [2817] = 2817,
  [2818] = 2818,
  [2819] = 2781,
  [2820] = 2820,
  [2821] = 2780,
  [2822] = 2822,
  [2823] = 2823,
  [2824] = 2813,
  [2825] = 2825,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2774,
  [2829] = 2794,
  [2830] = 2830,
  [2831] = 2831,
  [2832] = 2832,
  [2833] = 1466,
  [2834] = 1470,
  [2835] = 1469,
  [2836] = 1598,
  [2837] = 1601,
  [2838] = 1575,
  [2839] = 1581,
  [2840] = 1584,
  [2841] = 1572,
  [2842] = 1578,
  [2843] = 1590,
  [2844] = 1592,
  [2845] = 1593,
  [2846] = 1594,
  [2847] = 1596,
  [2848] = 1597,
  [2849] = 1580,
  [2850] = 1599,
  [2851] = 1600,
  [2852] = 1577,
  [2853] = 1487,
  [2854] = 1548,
  [2855] = 1549,
  [2856] = 1550,
  [2857] = 1609,
  [2858] = 1552,
  [2859] = 1579,
  [2860] = 1553,
  [2861] = 1554,
  [2862] = 1555,
  [2863] = 1556,
  [2864] = 1557,
  [2865] = 1558,
  [2866] = 1583,
  [2867] = 1559,
  [2868] = 1560,
  [2869] = 1573,
  [2870] = 1478,
  [2871] = 232,
  [2872] = 2872,
  [2873] = 2872,
  [2874] = 264,
  [2875] = 1540,
  [2876] = 1469,
  [2877] = 1534,
  [2878] = 1525,
  [2879] = 1535,
  [2880] = 1539,
  [2881] = 1542,
  [2882] = 1466,
  [2883] = 1498,
  [2884] = 1480,
  [2885] = 1531,
  [2886] = 1520,
  [2887] = 1496,
  [2888] = 1541,
  [2889] = 1467,
  [2890] = 1470,
  [2891] = 1522,
  [2892] = 2892,
  [2893] = 1533,
  [2894] = 1477,
  [2895] = 1484,
  [2896] = 1591,
  [2897] = 1515,
  [2898] = 1481,
  [2899] = 1547,
  [2900] = 1518,
  [2901] = 1491,
  [2902] = 1606,
  [2903] = 1548,
  [2904] = 1602,
  [2905] = 1524,
  [2906] = 1487,
  [2907] = 1549,
  [2908] = 1507,
  [2909] = 1550,
  [2910] = 1609,
  [2911] = 1552,
  [2912] = 1553,
  [2913] = 1554,
  [2914] = 1555,
  [2915] = 1556,
  [2916] = 1557,
  [2917] = 1558,
  [2918] = 1559,
  [2919] = 1492,
  [2920] = 1509,
  [2921] = 1493,
  [2922] = 1494,
  [2923] = 1560,
  [2924] = 1513,
  [2925] = 2925,
  [2926] = 1517,
  [2927] = 1572,
  [2928] = 1573,
  [2929] = 1575,
  [2930] = 1577,
  [2931] = 1578,
  [2932] = 1579,
  [2933] = 1580,
  [2934] = 1581,
  [2935] = 1583,
  [2936] = 1584,
  [2937] = 1590,
  [2938] = 1592,
  [2939] = 1593,
  [2940] = 1594,
  [2941] = 1596,
  [2942] = 1597,
  [2943] = 1598,
  [2944] = 1599,
  [2945] = 1600,
  [2946] = 1601,
  [2947] = 1467,
  [2948] = 1604,
  [2949] = 2925,
  [2950] = 2950,
  [2951] = 2951,
  [2952] = 2952,
  [2953] = 2953,
  [2954] = 1585,
  [2955] = 1586,
  [2956] = 1587,
  [2957] = 2925,
  [2958] = 1521,
  [2959] = 1523,
  [2960] = 1526,
  [2961] = 1527,
  [2962] = 1528,
  [2963] = 1530,
  [2964] = 1536,
  [2965] = 1543,
  [2966] = 2950,
  [2967] = 2951,
  [2968] = 2952,
  [2969] = 2953,
  [2970] = 1545,
  [2971] = 2925,
  [2972] = 2950,
  [2973] = 2951,
  [2974] = 2952,
  [2975] = 2953,
  [2976] = 2925,
  [2977] = 1499,
  [2978] = 2950,
  [2979] = 2951,
  [2980] = 2952,
  [2981] = 2953,
  [2982] = 1466,
  [2983] = 2925,
  [2984] = 1469,
  [2985] = 1470,
  [2986] = 2925,
  [2987] = 1489,
  [2988] = 1490,
  [2989] = 1500,
  [2990] = 1504,
  [2991] = 2925,
  [2992] = 1501,
  [2993] = 2950,
  [2994] = 2925,
  [2995] = 2951,
  [2996] = 1503,
  [2997] = 2952,
  [2998] = 2953,
  [2999] = 1562,
  [3000] = 1563,
  [3001] = 1567,
  [3002] = 1569,
  [3003] = 1505,
  [3004] = 3004,
  [3005] = 3005,
  [3006] = 3006,
  [3007] = 1482,
  [3008] = 3006,
  [3009] = 3009,
  [3010] = 3010,
  [3011] = 3004,
  [3012] = 3012,
  [3013] = 3013,
  [3014] = 1472,
  [3015] = 3015,
  [3016] = 3016,
  [3017] = 3017,
  [3018] = 3018,
  [3019] = 3006,
  [3020] = 3020,
  [3021] = 3021,
  [3022] = 3022,
  [3023] = 3023,
  [3024] = 3004,
  [3025] = 3004,
  [3026] = 1479,
  [3027] = 3027,
  [3028] = 3028,
  [3029] = 3006,
  [3030] = 3030,
  [3031] = 3031,
  [3032] = 3004,
  [3033] = 3033,
  [3034] = 3034,
  [3035] = 3006,
  [3036] = 3006,
  [3037] = 3037,
  [3038] = 3038,
  [3039] = 3039,
  [3040] = 3040,
  [3041] = 3006,
  [3042] = 1478,
  [3043] = 3043,
  [3044] = 1481,
  [3045] = 3045,
  [3046] = 1594,
  [3047] = 3047,
  [3048] = 1520,
  [3049] = 1522,
  [3050] = 3050,
  [3051] = 1538,
  [3052] = 1525,
  [3053] = 1508,
  [3054] = 1544,
  [3055] = 1467,
  [3056] = 3056,
  [3057] = 1531,
  [3058] = 3058,
  [3059] = 950,
  [3060] = 1496,
  [3061] = 1533,
  [3062] = 1534,
  [3063] = 1561,
  [3064] = 1574,
  [3065] = 1535,
  [3066] = 1498,
  [3067] = 1511,
  [3068] = 1539,
  [3069] = 1540,
  [3070] = 3070,
  [3071] = 1541,
  [3072] = 3072,
  [3073] = 3072,
  [3074] = 1487,
  [3075] = 1605,
  [3076] = 3076,
  [3077] = 3077,
  [3078] = 1549,
  [3079] = 1550,
  [3080] = 1609,
  [3081] = 1552,
  [3082] = 1553,
  [3083] = 1554,
  [3084] = 3084,
  [3085] = 1555,
  [3086] = 1556,
  [3087] = 1557,
  [3088] = 1558,
  [3089] = 1559,
  [3090] = 1560,
  [3091] = 948,
  [3092] = 1502,
  [3093] = 3093,
  [3094] = 1572,
  [3095] = 1573,
  [3096] = 1575,
  [3097] = 1577,
  [3098] = 1578,
  [3099] = 1579,
  [3100] = 1580,
  [3101] = 949,
  [3102] = 1581,
  [3103] = 1583,
  [3104] = 1584,
  [3105] = 1590,
  [3106] = 1592,
  [3107] = 1593,
  [3108] = 1480,
  [3109] = 1542,
  [3110] = 1596,
  [3111] = 1597,
  [3112] = 1598,
  [3113] = 1599,
  [3114] = 1600,
  [3115] = 3115,
  [3116] = 1565,
  [3117] = 1570,
  [3118] = 1601,
  [3119] = 1548,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 3122,
  [3123] = 3123,
  [3124] = 3124,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 1518,
  [3129] = 3129,
  [3130] = 3130,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 1484,
  [3134] = 3134,
  [3135] = 1515,
  [3136] = 3136,
  [3137] = 1482,
  [3138] = 3138,
  [3139] = 1472,
  [3140] = 1466,
  [3141] = 1547,
  [3142] = 3122,
  [3143] = 3143,
  [3144] = 3129,
  [3145] = 3145,
  [3146] = 3146,
  [3147] = 3129,
  [3148] = 3148,
  [3149] = 264,
  [3150] = 1469,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 3153,
  [3154] = 3129,
  [3155] = 1606,
  [3156] = 1591,
  [3157] = 1470,
  [3158] = 3158,
  [3159] = 232,
  [3160] = 3160,
  [3161] = 3161,
  [3162] = 3162,
  [3163] = 3129,
  [3164] = 3164,
  [3165] = 3165,
  [3166] = 3122,
  [3167] = 3167,
  [3168] = 1478,
  [3169] = 1481,
  [3170] = 3170,
  [3171] = 3171,
  [3172] = 1479,
  [3173] = 3173,
  [3174] = 3174,
  [3175] = 3175,
  [3176] = 1491,
  [3177] = 3177,
  [3178] = 3178,
  [3179] = 3179,
  [3180] = 3180,
  [3181] = 3122,
  [3182] = 3182,
  [3183] = 1477,
  [3184] = 1545,
  [3185] = 1565,
  [3186] = 1567,
  [3187] = 1535,
  [3188] = 1494,
  [3189] = 1569,
  [3190] = 3190,
  [3191] = 1570,
  [3192] = 1543,
  [3193] = 3193,
  [3194] = 3190,
  [3195] = 1499,
  [3196] = 3193,
  [3197] = 3193,
  [3198] = 685,
  [3199] = 1500,
  [3200] = 1501,
  [3201] = 1502,
  [3202] = 1604,
  [3203] = 1503,
  [3204] = 1505,
  [3205] = 1507,
  [3206] = 1508,
  [3207] = 1509,
  [3208] = 1511,
  [3209] = 1513,
  [3210] = 1561,
  [3211] = 1574,
  [3212] = 1517,
  [3213] = 3213,
  [3214] = 3190,
  [3215] = 3215,
  [3216] = 684,
  [3217] = 1521,
  [3218] = 1523,
  [3219] = 3138,
  [3220] = 1526,
  [3221] = 1527,
  [3222] = 1480,
  [3223] = 1585,
  [3224] = 1586,
  [3225] = 1528,
  [3226] = 1587,
  [3227] = 950,
  [3228] = 1530,
  [3229] = 688,
  [3230] = 3190,
  [3231] = 1536,
  [3232] = 1496,
  [3233] = 1498,
  [3234] = 1538,
  [3235] = 949,
  [3236] = 1467,
  [3237] = 3237,
  [3238] = 1520,
  [3239] = 1522,
  [3240] = 1525,
  [3241] = 3241,
  [3242] = 1533,
  [3243] = 1534,
  [3244] = 1539,
  [3245] = 1540,
  [3246] = 1541,
  [3247] = 1542,
  [3248] = 948,
  [3249] = 1544,
  [3250] = 1562,
  [3251] = 687,
  [3252] = 1563,
  [3253] = 1531,
  [3254] = 1489,
  [3255] = 1490,
  [3256] = 1504,
  [3257] = 1602,
  [3258] = 1605,
  [3259] = 1524,
  [3260] = 682,
  [3261] = 1492,
  [3262] = 1493,
  [3263] = 3193,
  [3264] = 3264,
  [3265] = 1477,
  [3266] = 3266,
  [3267] = 3267,
  [3268] = 3268,
  [3269] = 3269,
  [3270] = 3270,
  [3271] = 1491,
  [3272] = 3266,
  [3273] = 1467,
  [3274] = 1479,
  [3275] = 1481,
  [3276] = 3276,
  [3277] = 3277,
  [3278] = 3270,
  [3279] = 3268,
  [3280] = 3270,
  [3281] = 3269,
  [3282] = 1482,
  [3283] = 3283,
  [3284] = 3284,
  [3285] = 3285,
  [3286] = 3286,
  [3287] = 3285,
  [3288] = 3288,
  [3289] = 1472,
  [3290] = 3266,
  [3291] = 3268,
  [3292] = 1484,
  [3293] = 3293,
  [3294] = 1515,
  [3295] = 3270,
  [3296] = 1518,
  [3297] = 3297,
  [3298] = 3298,
  [3299] = 3299,
  [3300] = 685,
  [3301] = 3301,
  [3302] = 3302,
  [3303] = 3303,
  [3304] = 3304,
  [3305] = 3305,
  [3306] = 3306,
  [3307] = 3307,
  [3308] = 3308,
  [3309] = 3309,
  [3310] = 3310,
  [3311] = 3311,
  [3312] = 3312,
  [3313] = 3313,
  [3314] = 3314,
  [3315] = 3314,
  [3316] = 3316,
  [3317] = 3129,
  [3318] = 3318,
  [3319] = 3319,
  [3320] = 3320,
  [3321] = 1602,
  [3322] = 3319,
  [3323] = 3323,
  [3324] = 3324,
  [3325] = 3325,
  [3326] = 3326,
  [3327] = 3327,
  [3328] = 1481,
  [3329] = 1489,
  [3330] = 1490,
  [3331] = 3331,
  [3332] = 3332,
  [3333] = 3333,
  [3334] = 3334,
  [3335] = 1504,
  [3336] = 3323,
  [3337] = 3337,
  [3338] = 3325,
  [3339] = 1524,
  [3340] = 3340,
  [3341] = 1561,
  [3342] = 1574,
  [3343] = 3343,
  [3344] = 3344,
  [3345] = 3345,
  [3346] = 3346,
  [3347] = 1492,
  [3348] = 3348,
  [3349] = 3327,
  [3350] = 3323,
  [3351] = 3129,
  [3352] = 1493,
  [3353] = 1494,
  [3354] = 3354,
  [3355] = 3355,
  [3356] = 3356,
  [3357] = 3357,
  [3358] = 3358,
  [3359] = 3325,
  [3360] = 3331,
  [3361] = 3327,
  [3362] = 3332,
  [3363] = 3333,
  [3364] = 3364,
  [3365] = 3331,
  [3366] = 3366,
  [3367] = 3367,
  [3368] = 3313,
  [3369] = 1507,
  [3370] = 3332,
  [3371] = 3283,
  [3372] = 3337,
  [3373] = 3333,
  [3374] = 3374,
  [3375] = 3375,
  [3376] = 682,
  [3377] = 3316,
  [3378] = 3378,
  [3379] = 3379,
  [3380] = 3380,
  [3381] = 3381,
  [3382] = 1517,
  [3383] = 3383,
  [3384] = 3307,
  [3385] = 1499,
  [3386] = 3386,
  [3387] = 1501,
  [3388] = 3388,
  [3389] = 1502,
  [3390] = 1503,
  [3391] = 1505,
  [3392] = 1508,
  [3393] = 1509,
  [3394] = 1511,
  [3395] = 1513,
  [3396] = 3316,
  [3397] = 3397,
  [3398] = 3398,
  [3399] = 3399,
  [3400] = 3400,
  [3401] = 3314,
  [3402] = 1591,
  [3403] = 3314,
  [3404] = 3319,
  [3405] = 3374,
  [3406] = 684,
  [3407] = 3319,
  [3408] = 3408,
  [3409] = 1521,
  [3410] = 3410,
  [3411] = 3411,
  [3412] = 1523,
  [3413] = 3413,
  [3414] = 3414,
  [3415] = 3415,
  [3416] = 1526,
  [3417] = 1527,
  [3418] = 1528,
  [3419] = 3419,
  [3420] = 3420,
  [3421] = 1530,
  [3422] = 3422,
  [3423] = 3423,
  [3424] = 3424,
  [3425] = 3425,
  [3426] = 264,
  [3427] = 1536,
  [3428] = 1538,
  [3429] = 3311,
  [3430] = 3397,
  [3431] = 3431,
  [3432] = 3431,
  [3433] = 1543,
  [3434] = 1544,
  [3435] = 1545,
  [3436] = 3323,
  [3437] = 3325,
  [3438] = 1606,
  [3439] = 3439,
  [3440] = 687,
  [3441] = 3431,
  [3442] = 3442,
  [3443] = 3443,
  [3444] = 3327,
  [3445] = 3445,
  [3446] = 3374,
  [3447] = 3447,
  [3448] = 3331,
  [3449] = 3378,
  [3450] = 3450,
  [3451] = 1605,
  [3452] = 1604,
  [3453] = 3129,
  [3454] = 3129,
  [3455] = 1562,
  [3456] = 1563,
  [3457] = 1565,
  [3458] = 1567,
  [3459] = 1569,
  [3460] = 1570,
  [3461] = 1547,
  [3462] = 1213,
  [3463] = 3332,
  [3464] = 3333,
  [3465] = 3431,
  [3466] = 3276,
  [3467] = 232,
  [3468] = 3468,
  [3469] = 3284,
  [3470] = 3129,
  [3471] = 1585,
  [3472] = 1586,
  [3473] = 1587,
  [3474] = 3474,
  [3475] = 688,
  [3476] = 3476,
  [3477] = 3477,
  [3478] = 3129,
  [3479] = 3479,
  [3480] = 3480,
  [3481] = 1500,
  [3482] = 3482,
  [3483] = 3483,
  [3484] = 3484,
  [3485] = 3138,
  [3486] = 949,
  [3487] = 3484,
  [3488] = 3488,
  [3489] = 3489,
  [3490] = 3490,
  [3491] = 3491,
  [3492] = 3484,
  [3493] = 3484,
  [3494] = 3494,
  [3495] = 3490,
  [3496] = 3484,
  [3497] = 224,
  [3498] = 3498,
  [3499] = 1479,
  [3500] = 3498,
  [3501] = 3501,
  [3502] = 948,
  [3503] = 3503,
  [3504] = 3498,
  [3505] = 227,
  [3506] = 3501,
  [3507] = 3284,
  [3508] = 1482,
  [3509] = 950,
  [3510] = 1472,
  [3511] = 3484,
  [3512] = 3498,
  [3513] = 3498,
  [3514] = 3484,
  [3515] = 3515,
  [3516] = 252,
  [3517] = 253,
  [3518] = 3498,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3484,
  [3522] = 3522,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3525,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3213,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 3531,
  [3532] = 3532,
  [3533] = 3533,
  [3534] = 3534,
  [3535] = 3535,
  [3536] = 3536,
  [3537] = 3537,
  [3538] = 3538,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3542,
  [3543] = 3543,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 3549,
  [3550] = 3550,
  [3551] = 3399,
  [3552] = 3552,
  [3553] = 3553,
  [3554] = 3554,
  [3555] = 3555,
  [3556] = 3556,
  [3557] = 253,
  [3558] = 3558,
  [3559] = 3559,
  [3560] = 3560,
  [3561] = 3561,
  [3562] = 3562,
  [3563] = 3563,
  [3564] = 3564,
  [3565] = 3537,
  [3566] = 3566,
  [3567] = 3552,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 3571,
  [3572] = 3572,
  [3573] = 3573,
  [3574] = 3574,
  [3575] = 3575,
  [3576] = 3576,
  [3577] = 3577,
  [3578] = 3578,
  [3579] = 3552,
  [3580] = 3580,
  [3581] = 3581,
  [3582] = 3582,
  [3583] = 3583,
  [3584] = 3584,
  [3585] = 3585,
  [3586] = 3586,
  [3587] = 3587,
  [3588] = 3588,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 3592,
  [3593] = 3593,
  [3594] = 3594,
  [3595] = 3544,
  [3596] = 3596,
  [3597] = 3468,
  [3598] = 3598,
  [3599] = 3450,
  [3600] = 3600,
  [3601] = 3601,
  [3602] = 3602,
  [3603] = 3552,
  [3604] = 3604,
  [3605] = 3605,
  [3606] = 3606,
  [3607] = 3569,
  [3608] = 3608,
  [3609] = 3609,
  [3610] = 3610,
  [3611] = 3611,
  [3612] = 3612,
  [3613] = 3592,
  [3614] = 3614,
  [3615] = 3615,
  [3616] = 3537,
  [3617] = 3617,
  [3618] = 3618,
  [3619] = 3619,
  [3620] = 3546,
  [3621] = 3536,
  [3622] = 3596,
  [3623] = 3623,
  [3624] = 1482,
  [3625] = 3625,
  [3626] = 1472,
  [3627] = 3532,
  [3628] = 3628,
  [3629] = 3629,
  [3630] = 3630,
  [3631] = 3631,
  [3632] = 3632,
  [3633] = 3633,
  [3634] = 3611,
  [3635] = 3635,
  [3636] = 3476,
  [3637] = 3637,
  [3638] = 3638,
  [3639] = 3639,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3642,
  [3643] = 3643,
  [3644] = 3644,
  [3645] = 3645,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3552,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3651,
  [3652] = 3639,
  [3653] = 3646,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3658,
  [3659] = 3592,
  [3660] = 3660,
  [3661] = 3661,
  [3662] = 3630,
  [3663] = 3663,
  [3664] = 1538,
  [3665] = 3665,
  [3666] = 1502,
  [3667] = 1508,
  [3668] = 1511,
  [3669] = 1544,
  [3670] = 3592,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 1479,
  [3674] = 1561,
  [3675] = 1574,
  [3676] = 3649,
  [3677] = 3677,
  [3678] = 3678,
  [3679] = 3679,
  [3680] = 3680,
  [3681] = 3681,
  [3682] = 3682,
  [3683] = 3683,
  [3684] = 3684,
  [3685] = 3685,
  [3686] = 3686,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 1565,
  [3691] = 3691,
  [3692] = 3692,
  [3693] = 3693,
  [3694] = 3694,
  [3695] = 3695,
  [3696] = 3696,
  [3697] = 3546,
  [3698] = 1570,
  [3699] = 3699,
  [3700] = 3700,
  [3701] = 3701,
  [3702] = 3702,
  [3703] = 3703,
  [3704] = 3704,
  [3705] = 3705,
  [3706] = 3706,
  [3707] = 3707,
  [3708] = 3708,
  [3709] = 3709,
  [3710] = 3710,
  [3711] = 1605,
  [3712] = 3712,
  [3713] = 3713,
  [3714] = 3552,
  [3715] = 3632,
  [3716] = 3716,
  [3717] = 3663,
  [3718] = 3682,
  [3719] = 3719,
  [3720] = 3592,
  [3721] = 3721,
  [3722] = 3722,
  [3723] = 3723,
  [3724] = 3724,
  [3725] = 3548,
  [3726] = 3726,
  [3727] = 3727,
  [3728] = 3728,
  [3729] = 3729,
  [3730] = 3610,
  [3731] = 3731,
  [3732] = 3277,
  [3733] = 3733,
  [3734] = 3707,
  [3735] = 3735,
  [3736] = 3736,
  [3737] = 3737,
  [3738] = 3738,
  [3739] = 3739,
  [3740] = 3643,
  [3741] = 3741,
  [3742] = 3639,
  [3743] = 3743,
  [3744] = 3744,
  [3745] = 3649,
  [3746] = 3646,
  [3747] = 3747,
  [3748] = 3748,
  [3749] = 252,
  [3750] = 225,
  [3751] = 3552,
  [3752] = 3752,
  [3753] = 3552,
  [3754] = 3754,
  [3755] = 3755,
  [3756] = 3756,
  [3757] = 3757,
  [3758] = 3758,
  [3759] = 3759,
  [3760] = 3759,
  [3761] = 3761,
  [3762] = 3679,
  [3763] = 3340,
  [3764] = 3764,
  [3765] = 3765,
  [3766] = 3766,
  [3767] = 3767,
  [3768] = 3768,
  [3769] = 3769,
  [3770] = 3770,
  [3771] = 3592,
  [3772] = 3772,
  [3773] = 687,
  [3774] = 3774,
  [3775] = 3775,
  [3776] = 3283,
  [3777] = 3777,
  [3778] = 3778,
  [3779] = 3779,
  [3780] = 3568,
  [3781] = 3781,
  [3782] = 3782,
  [3783] = 3783,
  [3784] = 3784,
  [3785] = 3570,
  [3786] = 3786,
  [3787] = 3787,
  [3788] = 3705,
  [3789] = 3600,
  [3790] = 3790,
  [3791] = 3791,
  [3792] = 3572,
  [3793] = 3793,
  [3794] = 3573,
  [3795] = 3795,
  [3796] = 3796,
  [3797] = 3797,
  [3798] = 682,
  [3799] = 3793,
  [3800] = 3800,
  [3801] = 3801,
  [3802] = 685,
  [3803] = 1502,
  [3804] = 3804,
  [3805] = 3805,
  [3806] = 1508,
  [3807] = 3807,
  [3808] = 3808,
  [3809] = 1511,
  [3810] = 3810,
  [3811] = 3736,
  [3812] = 3793,
  [3813] = 3793,
  [3814] = 3712,
  [3815] = 3815,
  [3816] = 3816,
  [3817] = 3817,
  [3818] = 3791,
  [3819] = 3819,
  [3820] = 688,
  [3821] = 3790,
  [3822] = 3782,
  [3823] = 3784,
  [3824] = 3824,
  [3825] = 3815,
  [3826] = 3796,
  [3827] = 3731,
  [3828] = 3779,
  [3829] = 3829,
  [3830] = 3830,
  [3831] = 3781,
  [3832] = 1538,
  [3833] = 1544,
  [3834] = 3808,
  [3835] = 3729,
  [3836] = 3779,
  [3837] = 3796,
  [3838] = 3787,
  [3839] = 3839,
  [3840] = 3840,
  [3841] = 3808,
  [3842] = 3791,
  [3843] = 3709,
  [3844] = 3844,
  [3845] = 3807,
  [3846] = 1561,
  [3847] = 1574,
  [3848] = 3848,
  [3849] = 3276,
  [3850] = 3786,
  [3851] = 3801,
  [3852] = 3852,
  [3853] = 3779,
  [3854] = 3787,
  [3855] = 3710,
  [3856] = 3787,
  [3857] = 1591,
  [3858] = 3793,
  [3859] = 3671,
  [3860] = 3533,
  [3861] = 1570,
  [3862] = 3703,
  [3863] = 3863,
  [3864] = 3775,
  [3865] = 3865,
  [3866] = 3866,
  [3867] = 3796,
  [3868] = 3787,
  [3869] = 3598,
  [3870] = 684,
  [3871] = 3871,
  [3872] = 3791,
  [3873] = 3782,
  [3874] = 3874,
  [3875] = 3840,
  [3876] = 3876,
  [3877] = 3810,
  [3878] = 3878,
  [3879] = 3793,
  [3880] = 3880,
  [3881] = 3805,
  [3882] = 3795,
  [3883] = 1605,
  [3884] = 3884,
  [3885] = 3779,
  [3886] = 3886,
  [3887] = 3796,
  [3888] = 3550,
  [3889] = 3844,
  [3890] = 3602,
  [3891] = 3779,
  [3892] = 3892,
  [3893] = 3790,
  [3894] = 3894,
  [3895] = 3793,
  [3896] = 3665,
  [3897] = 3897,
  [3898] = 1248,
  [3899] = 3538,
  [3900] = 3886,
  [3901] = 3880,
  [3902] = 3791,
  [3903] = 3886,
  [3904] = 3701,
  [3905] = 1547,
  [3906] = 3728,
  [3907] = 3791,
  [3908] = 3526,
  [3909] = 3909,
  [3910] = 3910,
  [3911] = 3911,
  [3912] = 3787,
  [3913] = 3910,
  [3914] = 3778,
  [3915] = 3796,
  [3916] = 3916,
  [3917] = 3699,
  [3918] = 3918,
  [3919] = 3871,
  [3920] = 3237,
  [3921] = 1606,
  [3922] = 3922,
  [3923] = 3923,
  [3924] = 3804,
  [3925] = 3772,
  [3926] = 3922,
  [3927] = 3810,
  [3928] = 3650,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 3657,
  [3932] = 1565,
  [3933] = 3933,
  [3934] = 3934,
  [3935] = 3935,
  [3936] = 3936,
  [3937] = 3631,
  [3938] = 3637,
  [3939] = 816,
  [3940] = 833,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3943,
  [3944] = 3944,
  [3945] = 3945,
  [3946] = 3946,
  [3947] = 3947,
  [3948] = 3948,
  [3949] = 3949,
  [3950] = 3950,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3953,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 3958,
  [3959] = 809,
  [3960] = 813,
  [3961] = 814,
  [3962] = 3962,
  [3963] = 3963,
  [3964] = 3964,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 3967,
  [3968] = 3968,
  [3969] = 3969,
  [3970] = 3970,
  [3971] = 3971,
  [3972] = 3972,
  [3973] = 3865,
  [3974] = 3909,
  [3975] = 3929,
  [3976] = 825,
  [3977] = 3977,
  [3978] = 826,
  [3979] = 827,
  [3980] = 3980,
  [3981] = 3981,
  [3982] = 829,
  [3983] = 831,
  [3984] = 755,
  [3985] = 836,
  [3986] = 838,
  [3987] = 846,
  [3988] = 851,
  [3989] = 3989,
  [3990] = 3990,
  [3991] = 3991,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3758,
  [3995] = 3995,
  [3996] = 897,
  [3997] = 898,
  [3998] = 900,
  [3999] = 3999,
  [4000] = 4000,
  [4001] = 4001,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 4004,
  [4005] = 4005,
  [4006] = 4006,
  [4007] = 4007,
  [4008] = 4008,
  [4009] = 4009,
  [4010] = 4010,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 4013,
  [4014] = 4014,
  [4015] = 4015,
  [4016] = 4016,
  [4017] = 4017,
  [4018] = 3946,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 3968,
  [4022] = 4022,
  [4023] = 3971,
  [4024] = 4024,
  [4025] = 797,
  [4026] = 798,
  [4027] = 799,
  [4028] = 4028,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 4031,
  [4032] = 4032,
  [4033] = 4032,
  [4034] = 4034,
  [4035] = 807,
  [4036] = 4036,
  [4037] = 808,
  [4038] = 4038,
  [4039] = 811,
  [4040] = 778,
  [4041] = 4041,
  [4042] = 3947,
  [4043] = 4043,
  [4044] = 3981,
  [4045] = 3970,
  [4046] = 4046,
  [4047] = 4047,
  [4048] = 4048,
  [4049] = 4049,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4052,
  [4053] = 4053,
  [4054] = 764,
  [4055] = 4055,
  [4056] = 4056,
  [4057] = 4057,
  [4058] = 4058,
  [4059] = 4059,
  [4060] = 832,
  [4061] = 4061,
  [4062] = 834,
  [4063] = 835,
  [4064] = 837,
  [4065] = 758,
  [4066] = 760,
  [4067] = 4067,
  [4068] = 765,
  [4069] = 845,
  [4070] = 769,
  [4071] = 776,
  [4072] = 4047,
  [4073] = 4073,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 866,
  [4077] = 773,
  [4078] = 4078,
  [4079] = 4079,
  [4080] = 4080,
  [4081] = 4081,
  [4082] = 4082,
  [4083] = 4083,
  [4084] = 4084,
  [4085] = 4085,
  [4086] = 4086,
  [4087] = 4087,
  [4088] = 4088,
  [4089] = 4089,
  [4090] = 4090,
  [4091] = 4091,
  [4092] = 4092,
  [4093] = 4093,
  [4094] = 4094,
  [4095] = 4095,
  [4096] = 4096,
  [4097] = 893,
  [4098] = 894,
  [4099] = 895,
  [4100] = 902,
  [4101] = 901,
  [4102] = 828,
  [4103] = 3971,
  [4104] = 812,
  [4105] = 4105,
  [4106] = 4048,
  [4107] = 824,
  [4108] = 820,
  [4109] = 4049,
  [4110] = 4110,
  [4111] = 4052,
  [4112] = 4112,
  [4113] = 4113,
  [4114] = 4114,
  [4115] = 4115,
  [4116] = 4116,
  [4117] = 822,
  [4118] = 823,
  [4119] = 4002,
  [4120] = 4120,
  [4121] = 4121,
  [4122] = 850,
  [4123] = 768,
  [4124] = 757,
  [4125] = 762,
  [4126] = 4015,
  [4127] = 3946,
  [4128] = 803,
  [4129] = 4129,
  [4130] = 4130,
  [4131] = 4131,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 4134,
  [4135] = 4135,
  [4136] = 3947,
  [4137] = 3981,
  [4138] = 4138,
  [4139] = 4139,
  [4140] = 4140,
  [4141] = 4141,
  [4142] = 4142,
  [4143] = 4143,
  [4144] = 4144,
  [4145] = 4145,
  [4146] = 4053,
  [4147] = 4147,
  [4148] = 4055,
  [4149] = 4149,
  [4150] = 4002,
  [4151] = 4015,
  [4152] = 4152,
  [4153] = 4153,
  [4154] = 4084,
  [4155] = 857,
  [4156] = 858,
  [4157] = 859,
  [4158] = 860,
  [4159] = 862,
  [4160] = 863,
  [4161] = 4161,
  [4162] = 865,
  [4163] = 4163,
  [4164] = 876,
  [4165] = 3947,
  [4166] = 880,
  [4167] = 774,
  [4168] = 4168,
  [4169] = 4169,
  [4170] = 4170,
  [4171] = 4171,
  [4172] = 4172,
  [4173] = 4173,
  [4174] = 4174,
  [4175] = 4079,
  [4176] = 4176,
  [4177] = 4177,
  [4178] = 4015,
  [4179] = 4179,
  [4180] = 3947,
  [4181] = 4181,
  [4182] = 4182,
  [4183] = 839,
  [4184] = 849,
  [4185] = 853,
  [4186] = 877,
  [4187] = 882,
  [4188] = 4188,
  [4189] = 4189,
  [4190] = 4190,
  [4191] = 4191,
  [4192] = 4192,
  [4193] = 4193,
  [4194] = 4194,
  [4195] = 4195,
  [4196] = 4196,
  [4197] = 4197,
  [4198] = 4198,
  [4199] = 4199,
  [4200] = 4200,
  [4201] = 4201,
  [4202] = 4202,
  [4203] = 4036,
  [4204] = 4204,
  [4205] = 4205,
  [4206] = 4038,
  [4207] = 3977,
  [4208] = 4208,
  [4209] = 4209,
  [4210] = 4057,
  [4211] = 4211,
  [4212] = 4212,
  [4213] = 4213,
  [4214] = 4214,
  [4215] = 1685,
  [4216] = 1625,
  [4217] = 4078,
  [4218] = 4113,
  [4219] = 4219,
  [4220] = 4220,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4223,
  [4224] = 4224,
  [4225] = 3942,
  [4226] = 3944,
  [4227] = 4227,
  [4228] = 4228,
  [4229] = 4229,
  [4230] = 4230,
  [4231] = 4231,
  [4232] = 4232,
  [4233] = 4233,
  [4234] = 1704,
  [4235] = 1706,
  [4236] = 4236,
  [4237] = 4237,
  [4238] = 4194,
  [4239] = 4214,
  [4240] = 4240,
  [4241] = 4241,
  [4242] = 4242,
  [4243] = 1645,
  [4244] = 1661,
  [4245] = 4245,
  [4246] = 4246,
  [4247] = 4247,
  [4248] = 3980,
  [4249] = 4249,
  [4250] = 4161,
  [4251] = 4174,
  [4252] = 4252,
  [4253] = 4253,
  [4254] = 4254,
  [4255] = 4255,
  [4256] = 4256,
  [4257] = 4257,
  [4258] = 4258,
  [4259] = 4259,
  [4260] = 1648,
  [4261] = 1662,
  [4262] = 1663,
  [4263] = 1667,
  [4264] = 4182,
  [4265] = 1668,
  [4266] = 1670,
  [4267] = 4267,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 4149,
  [4271] = 4241,
  [4272] = 4272,
  [4273] = 4242,
  [4274] = 4274,
  [4275] = 1690,
  [4276] = 1705,
  [4277] = 4277,
  [4278] = 4278,
  [4279] = 4279,
  [4280] = 4280,
  [4281] = 4281,
  [4282] = 4282,
  [4283] = 4283,
  [4284] = 4284,
  [4285] = 4285,
  [4286] = 4286,
  [4287] = 4287,
  [4288] = 4288,
  [4289] = 4289,
  [4290] = 4290,
  [4291] = 4291,
  [4292] = 4292,
  [4293] = 1611,
  [4294] = 1621,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4298,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 4303,
  [4304] = 3977,
  [4305] = 3654,
  [4306] = 4306,
  [4307] = 4307,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4310,
  [4311] = 4078,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4314,
  [4315] = 3942,
  [4316] = 3944,
  [4317] = 4317,
  [4318] = 4318,
  [4319] = 4319,
  [4320] = 3980,
  [4321] = 4086,
  [4322] = 4322,
  [4323] = 4323,
  [4324] = 4324,
  [4325] = 4325,
  [4326] = 4326,
  [4327] = 4327,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 1685,
  [4331] = 1625,
  [4332] = 4332,
  [4333] = 4333,
  [4334] = 4268,
  [4335] = 4335,
  [4336] = 4336,
  [4337] = 4337,
  [4338] = 1704,
  [4339] = 1706,
  [4340] = 4340,
  [4341] = 4341,
  [4342] = 1645,
  [4343] = 1661,
  [4344] = 4344,
  [4345] = 4345,
  [4346] = 4067,
  [4347] = 4347,
  [4348] = 4221,
  [4349] = 4349,
  [4350] = 4350,
  [4351] = 4351,
  [4352] = 4257,
  [4353] = 4353,
  [4354] = 4354,
  [4355] = 1648,
  [4356] = 1662,
  [4357] = 1663,
  [4358] = 1667,
  [4359] = 1668,
  [4360] = 1670,
  [4361] = 4361,
  [4362] = 4362,
  [4363] = 4363,
  [4364] = 4364,
  [4365] = 4365,
  [4366] = 1690,
  [4367] = 4367,
  [4368] = 4008,
  [4369] = 1705,
  [4370] = 4370,
  [4371] = 3933,
  [4372] = 4372,
  [4373] = 4373,
  [4374] = 4374,
  [4375] = 4375,
  [4376] = 4376,
  [4377] = 4377,
  [4378] = 4378,
  [4379] = 1611,
  [4380] = 1621,
  [4381] = 4381,
  [4382] = 4382,
  [4383] = 4383,
  [4384] = 4384,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4387,
  [4388] = 4388,
  [4389] = 4389,
  [4390] = 4032,
  [4391] = 4391,
  [4392] = 4392,
  [4393] = 4202,
  [4394] = 4394,
  [4395] = 4048,
  [4396] = 4049,
  [4397] = 4145,
  [4398] = 4398,
  [4399] = 4399,
  [4400] = 4400,
  [4401] = 4401,
  [4402] = 4067,
  [4403] = 4403,
  [4404] = 4404,
  [4405] = 4405,
  [4406] = 4002,
  [4407] = 4407,
  [4408] = 4408,
  [4409] = 4409,
  [4410] = 256,
  [4411] = 260,
  [4412] = 4412,
  [4413] = 4413,
  [4414] = 4414,
  [4415] = 4415,
  [4416] = 4416,
  [4417] = 4417,
  [4418] = 4418,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4421,
  [4422] = 789,
  [4423] = 4423,
  [4424] = 854,
  [4425] = 890,
  [4426] = 4377,
  [4427] = 4427,
  [4428] = 4428,
  [4429] = 4429,
  [4430] = 4430,
  [4431] = 4431,
  [4432] = 4432,
  [4433] = 4433,
  [4434] = 4434,
  [4435] = 4082,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 4438,
  [4439] = 4439,
  [4440] = 4440,
  [4441] = 4441,
  [4442] = 4442,
  [4443] = 4443,
  [4444] = 4444,
  [4445] = 1531,
  [4446] = 874,
  [4447] = 875,
  [4448] = 1535,
  [4449] = 4449,
  [4450] = 4450,
  [4451] = 4015,
  [4452] = 4452,
  [4453] = 4453,
  [4454] = 3852,
  [4455] = 4455,
  [4456] = 795,
  [4457] = 802,
  [4458] = 4458,
  [4459] = 4459,
  [4460] = 4043,
  [4461] = 4461,
  [4462] = 4462,
  [4463] = 4463,
  [4464] = 4464,
  [4465] = 4075,
  [4466] = 4466,
  [4467] = 4467,
  [4468] = 4468,
  [4469] = 4469,
  [4470] = 4470,
  [4471] = 4471,
  [4472] = 4472,
  [4473] = 4473,
  [4474] = 4474,
  [4475] = 4475,
  [4476] = 4476,
  [4477] = 4477,
  [4478] = 4478,
  [4479] = 4479,
  [4480] = 4480,
  [4481] = 4468,
  [4482] = 4482,
  [4483] = 4483,
  [4484] = 4484,
  [4485] = 4485,
  [4486] = 4486,
  [4487] = 4478,
  [4488] = 4488,
  [4489] = 4468,
  [4490] = 4490,
  [4491] = 4491,
  [4492] = 4492,
  [4493] = 4493,
  [4494] = 4494,
  [4495] = 4470,
  [4496] = 4496,
  [4497] = 4497,
  [4498] = 4486,
  [4499] = 4468,
  [4500] = 4500,
  [4501] = 4479,
  [4502] = 4483,
  [4503] = 4484,
  [4504] = 4504,
  [4505] = 4497,
  [4506] = 4506,
  [4507] = 4507,
  [4508] = 4479,
  [4509] = 4509,
  [4510] = 4482,
  [4511] = 4486,
  [4512] = 4482,
  [4513] = 4513,
  [4514] = 4478,
  [4515] = 4468,
  [4516] = 4516,
  [4517] = 4482,
  [4518] = 3625,
  [4519] = 4519,
  [4520] = 4520,
  [4521] = 4521,
  [4522] = 4522,
  [4523] = 4483,
  [4524] = 4492,
  [4525] = 4497,
  [4526] = 4497,
  [4527] = 4513,
  [4528] = 4528,
  [4529] = 4494,
  [4530] = 4479,
  [4531] = 4531,
  [4532] = 4492,
  [4533] = 4533,
  [4534] = 4534,
  [4535] = 4535,
  [4536] = 4478,
  [4537] = 4468,
  [4538] = 4478,
  [4539] = 4483,
  [4540] = 4482,
  [4541] = 4478,
  [4542] = 4542,
  [4543] = 4543,
  [4544] = 4471,
  [4545] = 4545,
  [4546] = 4546,
  [4547] = 4547,
  [4548] = 4492,
  [4549] = 4492,
  [4550] = 4550,
  [4551] = 4494,
  [4552] = 4552,
  [4553] = 4553,
  [4554] = 4494,
  [4555] = 4555,
  [4556] = 4556,
  [4557] = 4494,
  [4558] = 4519,
  [4559] = 4559,
  [4560] = 4560,
  [4561] = 4561,
  [4562] = 4484,
  [4563] = 4492,
  [4564] = 4494,
  [4565] = 4565,
  [4566] = 4566,
  [4567] = 4567,
  [4568] = 4568,
  [4569] = 4531,
  [4570] = 4486,
  [4571] = 4478,
  [4572] = 4572,
  [4573] = 4497,
  [4574] = 4574,
  [4575] = 4482,
  [4576] = 4473,
  [4577] = 4577,
  [4578] = 4479,
  [4579] = 4485,
  [4580] = 3658,
  [4581] = 4486,
  [4582] = 4577,
  [4583] = 224,
  [4584] = 4492,
  [4585] = 227,
  [4586] = 4494,
  [4587] = 4513,
  [4588] = 4483,
  [4589] = 4484,
  [4590] = 4513,
  [4591] = 4591,
  [4592] = 4509,
  [4593] = 4513,
  [4594] = 4486,
  [4595] = 4497,
  [4596] = 4596,
  [4597] = 4486,
  [4598] = 4497,
  [4599] = 4513,
  [4600] = 4468,
  [4601] = 4483,
  [4602] = 4477,
  [4603] = 4482,
  [4604] = 4484,
  [4605] = 4605,
  [4606] = 4606,
  [4607] = 4607,
  [4608] = 4491,
  [4609] = 4567,
  [4610] = 4513,
  [4611] = 4611,
  [4612] = 4612,
  [4613] = 4613,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4620,
  [4621] = 4621,
  [4622] = 4622,
  [4623] = 4623,
  [4624] = 4624,
  [4625] = 4625,
  [4626] = 4626,
  [4627] = 4627,
  [4628] = 4628,
  [4629] = 4629,
  [4630] = 4630,
  [4631] = 4631,
  [4632] = 4632,
  [4633] = 4633,
  [4634] = 4634,
  [4635] = 4633,
  [4636] = 4636,
  [4637] = 4637,
  [4638] = 4638,
  [4639] = 4639,
  [4640] = 4640,
  [4641] = 4641,
  [4642] = 4642,
  [4643] = 4643,
  [4644] = 4644,
  [4645] = 4645,
  [4646] = 4646,
  [4647] = 4647,
  [4648] = 4648,
  [4649] = 4649,
  [4650] = 4650,
  [4651] = 4651,
  [4652] = 4652,
  [4653] = 4653,
  [4654] = 4654,
  [4655] = 4655,
  [4656] = 4619,
  [4657] = 4657,
  [4658] = 4629,
  [4659] = 4659,
  [4660] = 4660,
  [4661] = 4661,
  [4662] = 4636,
  [4663] = 4637,
  [4664] = 4664,
  [4665] = 4665,
  [4666] = 4666,
  [4667] = 4667,
  [4668] = 4633,
  [4669] = 4669,
  [4670] = 4636,
  [4671] = 4637,
  [4672] = 4672,
  [4673] = 4673,
  [4674] = 4674,
  [4675] = 4675,
  [4676] = 4676,
  [4677] = 4645,
  [4678] = 4646,
  [4679] = 4679,
  [4680] = 4648,
  [4681] = 4681,
  [4682] = 4650,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 4615,
  [4686] = 4616,
  [4687] = 4617,
  [4688] = 4618,
  [4689] = 4689,
  [4690] = 4619,
  [4691] = 4691,
  [4692] = 4692,
  [4693] = 4693,
  [4694] = 4694,
  [4695] = 4636,
  [4696] = 4637,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4636,
  [4700] = 4637,
  [4701] = 4701,
  [4702] = 4702,
  [4703] = 4703,
  [4704] = 4704,
  [4705] = 4648,
  [4706] = 4650,
  [4707] = 4707,
  [4708] = 4708,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 4711,
  [4712] = 4712,
  [4713] = 4641,
  [4714] = 4714,
  [4715] = 4636,
  [4716] = 4637,
  [4717] = 4717,
  [4718] = 4030,
  [4719] = 4719,
  [4720] = 4720,
  [4721] = 4648,
  [4722] = 4722,
  [4723] = 4650,
  [4724] = 4724,
  [4725] = 4725,
  [4726] = 4726,
  [4727] = 4727,
  [4728] = 4728,
  [4729] = 4729,
  [4730] = 4730,
  [4731] = 4731,
  [4732] = 3533,
  [4733] = 4733,
  [4734] = 4734,
  [4735] = 4735,
  [4736] = 4736,
  [4737] = 4737,
  [4738] = 4738,
  [4739] = 4739,
  [4740] = 4740,
  [4741] = 4741,
  [4742] = 4742,
  [4743] = 4743,
  [4744] = 4744,
  [4745] = 4745,
  [4746] = 4746,
  [4747] = 4747,
  [4748] = 4748,
  [4749] = 4749,
  [4750] = 4750,
  [4751] = 4751,
  [4752] = 4752,
  [4753] = 4753,
  [4754] = 4754,
  [4755] = 4755,
  [4756] = 4645,
  [4757] = 4757,
  [4758] = 4758,
  [4759] = 4759,
  [4760] = 767,
  [4761] = 4761,
  [4762] = 4646,
  [4763] = 4763,
  [4764] = 4633,
  [4765] = 4765,
  [4766] = 4766,
  [4767] = 4767,
  [4768] = 4768,
  [4769] = 4769,
  [4770] = 4770,
  [4771] = 4771,
  [4772] = 4772,
  [4773] = 4773,
  [4774] = 4774,
  [4775] = 4775,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4778,
  [4779] = 4779,
  [4780] = 4780,
  [4781] = 4781,
  [4782] = 4782,
  [4783] = 4783,
  [4784] = 4784,
  [4785] = 4785,
  [4786] = 4786,
  [4787] = 4787,
  [4788] = 4788,
  [4789] = 4789,
  [4790] = 4790,
  [4791] = 4791,
  [4792] = 4792,
  [4793] = 4793,
  [4794] = 4794,
  [4795] = 4795,
  [4796] = 4796,
  [4797] = 4648,
  [4798] = 4798,
  [4799] = 4799,
  [4800] = 4800,
  [4801] = 4641,
  [4802] = 4646,
  [4803] = 4650,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4808,
  [4809] = 4809,
  [4810] = 4810,
  [4811] = 4811,
  [4812] = 4812,
  [4813] = 4813,
  [4814] = 4814,
  [4815] = 4815,
  [4816] = 4816,
  [4817] = 4817,
  [4818] = 4818,
  [4819] = 4819,
  [4820] = 4820,
  [4821] = 4821,
  [4822] = 4822,
  [4823] = 4823,
  [4824] = 4824,
  [4825] = 4825,
  [4826] = 4826,
  [4827] = 4827,
  [4828] = 4828,
  [4829] = 4829,
  [4830] = 4830,
  [4831] = 4831,
  [4832] = 4832,
  [4833] = 4833,
  [4834] = 4749,
  [4835] = 4835,
  [4836] = 4836,
  [4837] = 4837,
  [4838] = 3736,
  [4839] = 4839,
  [4840] = 4840,
  [4841] = 4841,
  [4842] = 4842,
  [4843] = 3965,
  [4844] = 4621,
  [4845] = 4845,
  [4846] = 4846,
  [4847] = 4847,
  [4848] = 4848,
  [4849] = 4849,
  [4850] = 4850,
  [4851] = 4851,
  [4852] = 4852,
  [4853] = 4853,
  [4854] = 4619,
  [4855] = 4855,
  [4856] = 4856,
  [4857] = 4857,
  [4858] = 4858,
  [4859] = 4859,
  [4860] = 4860,
  [4861] = 4861,
  [4862] = 4862,
  [4863] = 4863,
  [4864] = 4864,
  [4865] = 4865,
  [4866] = 4791,
  [4867] = 4867,
  [4868] = 4615,
  [4869] = 4869,
  [4870] = 4870,
  [4871] = 4871,
  [4872] = 4616,
  [4873] = 4873,
  [4874] = 4874,
  [4875] = 4875,
  [4876] = 4617,
  [4877] = 4877,
  [4878] = 4878,
  [4879] = 4652,
  [4880] = 4880,
  [4881] = 4881,
  [4882] = 4882,
  [4883] = 4883,
  [4884] = 4884,
  [4885] = 4885,
  [4886] = 4886,
  [4887] = 4887,
  [4888] = 4888,
  [4889] = 4889,
  [4890] = 4890,
  [4891] = 4891,
  [4892] = 4892,
  [4893] = 4893,
  [4894] = 4894,
  [4895] = 4895,
  [4896] = 4896,
  [4897] = 4897,
  [4898] = 4618,
  [4899] = 4899,
  [4900] = 4900,
  [4901] = 4901,
  [4902] = 4902,
  [4903] = 4747,
  [4904] = 4619,
  [4905] = 4794,
  [4906] = 4906,
  [4907] = 4907,
  [4908] = 4908,
  [4909] = 4633,
  [4910] = 4910,
  [4911] = 4911,
  [4912] = 4648,
  [4913] = 4913,
  [4914] = 4914,
  [4915] = 4915,
  [4916] = 4916,
  [4917] = 4917,
  [4918] = 4918,
  [4919] = 4919,
  [4920] = 4920,
  [4921] = 4921,
  [4922] = 4922,
  [4923] = 4923,
  [4924] = 4924,
  [4925] = 4736,
  [4926] = 4926,
  [4927] = 4927,
  [4928] = 4928,
  [4929] = 4929,
  [4930] = 4650,
  [4931] = 4931,
  [4932] = 1591,
  [4933] = 4933,
  [4934] = 4934,
  [4935] = 4935,
  [4936] = 4936,
  [4937] = 4748,
  [4938] = 4870,
  [4939] = 4751,
  [4940] = 4875,
  [4941] = 4941,
  [4942] = 4942,
  [4943] = 4943,
  [4944] = 4944,
  [4945] = 4945,
  [4946] = 4946,
  [4947] = 4947,
  [4948] = 4948,
  [4949] = 4949,
  [4950] = 4950,
  [4951] = 4951,
  [4952] = 4952,
  [4953] = 4953,
  [4954] = 4954,
  [4955] = 4955,
  [4956] = 4956,
  [4957] = 4730,
  [4958] = 4958,
  [4959] = 4959,
  [4960] = 4960,
  [4961] = 4961,
  [4962] = 4962,
  [4963] = 4963,
  [4964] = 4964,
  [4965] = 4965,
  [4966] = 4966,
  [4967] = 4967,
  [4968] = 4968,
  [4969] = 4969,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4972,
  [4973] = 4973,
  [4974] = 4974,
  [4975] = 4975,
  [4976] = 4976,
  [4977] = 4977,
  [4978] = 4978,
  [4979] = 4979,
  [4980] = 3538,
  [4981] = 4981,
  [4982] = 4982,
  [4983] = 4983,
  [4984] = 4984,
  [4985] = 4985,
  [4986] = 4816,
  [4987] = 4987,
  [4988] = 4988,
  [4989] = 4989,
  [4990] = 4990,
  [4991] = 4991,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4994,
  [4995] = 4995,
  [4996] = 4996,
  [4997] = 4997,
  [4998] = 4998,
  [4999] = 4999,
  [5000] = 5000,
  [5001] = 5001,
  [5002] = 5002,
  [5003] = 5003,
  [5004] = 5004,
  [5005] = 5005,
  [5006] = 4737,
  [5007] = 5007,
  [5008] = 5008,
  [5009] = 3729,
  [5010] = 5010,
  [5011] = 5011,
  [5012] = 5012,
  [5013] = 5013,
  [5014] = 5014,
  [5015] = 5015,
  [5016] = 5016,
  [5017] = 5017,
  [5018] = 5018,
  [5019] = 4829,
  [5020] = 5020,
  [5021] = 5021,
  [5022] = 5022,
  [5023] = 5023,
  [5024] = 5024,
  [5025] = 5025,
  [5026] = 5026,
  [5027] = 5027,
  [5028] = 5028,
  [5029] = 5029,
  [5030] = 5030,
  [5031] = 4830,
  [5032] = 5032,
  [5033] = 5033,
  [5034] = 5034,
  [5035] = 5035,
  [5036] = 5036,
  [5037] = 4831,
  [5038] = 5038,
  [5039] = 5039,
  [5040] = 5040,
  [5041] = 5041,
  [5042] = 5042,
  [5043] = 5043,
  [5044] = 5044,
  [5045] = 5045,
  [5046] = 1606,
  [5047] = 4742,
  [5048] = 4646,
  [5049] = 5049,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 5052,
  [5053] = 5053,
  [5054] = 5054,
  [5055] = 5055,
  [5056] = 5056,
  [5057] = 5057,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 5060,
  [5061] = 5061,
  [5062] = 5062,
  [5063] = 5063,
  [5064] = 5064,
  [5065] = 4647,
  [5066] = 5066,
  [5067] = 5067,
  [5068] = 5068,
  [5069] = 5069,
  [5070] = 5020,
  [5071] = 5071,
  [5072] = 4328,
  [5073] = 5073,
  [5074] = 5074,
  [5075] = 5075,
  [5076] = 1547,
  [5077] = 5077,
  [5078] = 5078,
  [5079] = 5079,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 5083,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 4646,
  [5089] = 5089,
  [5090] = 5090,
  [5091] = 5091,
  [5092] = 5092,
  [5093] = 5091,
  [5094] = 5094,
  [5095] = 5095,
  [5096] = 5096,
  [5097] = 5097,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 5100,
  [5101] = 5101,
  [5102] = 5102,
  [5103] = 5103,
  [5104] = 5104,
  [5105] = 4829,
  [5106] = 5106,
  [5107] = 5107,
  [5108] = 5108,
  [5109] = 5109,
  [5110] = 5110,
  [5111] = 5111,
  [5112] = 5112,
  [5113] = 4830,
  [5114] = 5114,
  [5115] = 5115,
  [5116] = 5116,
  [5117] = 5117,
  [5118] = 5118,
  [5119] = 4652,
  [5120] = 5120,
  [5121] = 5121,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 5124,
  [5125] = 5125,
  [5126] = 5126,
  [5127] = 5127,
  [5128] = 5128,
  [5129] = 5129,
  [5130] = 5130,
  [5131] = 5131,
  [5132] = 5132,
  [5133] = 5133,
  [5134] = 5134,
  [5135] = 5135,
  [5136] = 5136,
  [5137] = 5137,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 5140,
  [5141] = 5141,
  [5142] = 5142,
  [5143] = 5143,
  [5144] = 5144,
  [5145] = 5145,
  [5146] = 5146,
  [5147] = 5147,
  [5148] = 5148,
  [5149] = 5149,
  [5150] = 5150,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 4624,
  [5154] = 5154,
  [5155] = 4625,
  [5156] = 5041,
  [5157] = 4673,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 4935,
  [5161] = 5161,
  [5162] = 5162,
  [5163] = 4621,
  [5164] = 1507,
  [5165] = 5165,
  [5166] = 1517,
  [5167] = 5167,
  [5168] = 4651,
  [5169] = 4633,
  [5170] = 5170,
  [5171] = 4895,
  [5172] = 5172,
  [5173] = 4673,
  [5174] = 5174,
  [5175] = 4679,
  [5176] = 5176,
  [5177] = 5177,
  [5178] = 5178,
  [5179] = 4897,
  [5180] = 4730,
  [5181] = 5181,
  [5182] = 5182,
  [5183] = 4922,
  [5184] = 5184,
  [5185] = 5185,
  [5186] = 5186,
  [5187] = 767,
  [5188] = 4636,
  [5189] = 4637,
  [5190] = 4935,
  [5191] = 5191,
  [5192] = 5192,
  [5193] = 5193,
  [5194] = 5194,
  [5195] = 5195,
  [5196] = 4906,
  [5197] = 5197,
  [5198] = 5198,
  [5199] = 4907,
  [5200] = 4641,
  [5201] = 4914,
  [5202] = 5202,
  [5203] = 3643,
  [5204] = 5204,
  [5205] = 4645,
  [5206] = 5206,
  [5207] = 5207,
  [5208] = 5208,
  [5209] = 5209,
  [5210] = 5210,
  [5211] = 4645,
  [5212] = 4633,
  [5213] = 5213,
  [5214] = 5214,
  [5215] = 5215,
  [5216] = 5216,
  [5217] = 5217,
  [5218] = 5218,
  [5219] = 5219,
  [5220] = 4646,
  [5221] = 5221,
  [5222] = 5222,
  [5223] = 5223,
  [5224] = 5224,
  [5225] = 5225,
  [5226] = 5226,
  [5227] = 4648,
  [5228] = 5228,
  [5229] = 4650,
  [5230] = 5230,
  [5231] = 5231,
  [5232] = 5232,
  [5233] = 5233,
  [5234] = 5234,
  [5235] = 5235,
  [5236] = 5236,
  [5237] = 5237,
  [5238] = 5238,
  [5239] = 5239,
  [5240] = 5240,
  [5241] = 5241,
  [5242] = 5242,
  [5243] = 5243,
  [5244] = 5244,
  [5245] = 5245,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5248,
  [5249] = 2653,
  [5250] = 5250,
  [5251] = 5251,
  [5252] = 5252,
  [5253] = 5253,
  [5254] = 5254,
  [5255] = 5255,
  [5256] = 5256,
  [5257] = 5257,
  [5258] = 5258,
  [5259] = 5259,
  [5260] = 5260,
  [5261] = 5261,
  [5262] = 5262,
  [5263] = 5263,
  [5264] = 5264,
  [5265] = 5265,
  [5266] = 5266,
  [5267] = 5267,
  [5268] = 5268,
  [5269] = 5269,
  [5270] = 5270,
  [5271] = 5271,
  [5272] = 5272,
  [5273] = 5273,
  [5274] = 5274,
  [5275] = 5275,
  [5276] = 5276,
  [5277] = 5277,
  [5278] = 5278,
  [5279] = 5279,
  [5280] = 5280,
  [5281] = 5272,
  [5282] = 5282,
  [5283] = 5283,
  [5284] = 5268,
  [5285] = 5285,
  [5286] = 5239,
  [5287] = 5287,
  [5288] = 5276,
  [5289] = 5289,
  [5290] = 5290,
  [5291] = 5257,
  [5292] = 5282,
  [5293] = 5293,
  [5294] = 5294,
  [5295] = 5295,
  [5296] = 3865,
  [5297] = 5297,
  [5298] = 5298,
  [5299] = 5283,
  [5300] = 5300,
  [5301] = 5301,
  [5302] = 5261,
  [5303] = 5303,
  [5304] = 5304,
  [5305] = 5274,
  [5306] = 5306,
  [5307] = 5307,
  [5308] = 5308,
  [5309] = 5272,
  [5310] = 5255,
  [5311] = 5311,
  [5312] = 5312,
  [5313] = 5313,
  [5314] = 3852,
  [5315] = 5315,
  [5316] = 5316,
  [5317] = 5317,
  [5318] = 5276,
  [5319] = 1721,
  [5320] = 5320,
  [5321] = 5321,
  [5322] = 5282,
  [5323] = 2654,
  [5324] = 5324,
  [5325] = 5325,
  [5326] = 5258,
  [5327] = 5327,
  [5328] = 5328,
  [5329] = 5329,
  [5330] = 5257,
  [5331] = 5331,
  [5332] = 5332,
  [5333] = 5333,
  [5334] = 5334,
  [5335] = 5245,
  [5336] = 5336,
  [5337] = 5261,
  [5338] = 5338,
  [5339] = 5274,
  [5340] = 5272,
  [5341] = 5341,
  [5342] = 5342,
  [5343] = 5343,
  [5344] = 5344,
  [5345] = 5345,
  [5346] = 5346,
  [5347] = 5276,
  [5348] = 5282,
  [5349] = 2630,
  [5350] = 5283,
  [5351] = 5351,
  [5352] = 5238,
  [5353] = 5353,
  [5354] = 5354,
  [5355] = 5245,
  [5356] = 2606,
  [5357] = 5283,
  [5358] = 5358,
  [5359] = 5359,
  [5360] = 5360,
  [5361] = 5361,
  [5362] = 2612,
  [5363] = 5363,
  [5364] = 2607,
  [5365] = 5365,
  [5366] = 5366,
  [5367] = 2621,
  [5368] = 5246,
  [5369] = 5236,
  [5370] = 5242,
  [5371] = 5371,
  [5372] = 5372,
  [5373] = 5373,
  [5374] = 5338,
  [5375] = 5334,
  [5376] = 5376,
  [5377] = 5377,
  [5378] = 5378,
  [5379] = 5379,
  [5380] = 5380,
  [5381] = 5248,
  [5382] = 5235,
  [5383] = 5258,
  [5384] = 5384,
  [5385] = 2658,
  [5386] = 5386,
  [5387] = 5387,
  [5388] = 2622,
  [5389] = 2610,
  [5390] = 5244,
  [5391] = 5303,
  [5392] = 5258,
  [5393] = 5393,
  [5394] = 5394,
  [5395] = 5353,
  [5396] = 5248,
  [5397] = 5397,
  [5398] = 2631,
  [5399] = 5245,
  [5400] = 2655,
  [5401] = 5401,
  [5402] = 2656,
  [5403] = 5403,
  [5404] = 5328,
  [5405] = 5246,
  [5406] = 5283,
  [5407] = 5393,
  [5408] = 5331,
  [5409] = 5248,
  [5410] = 5410,
  [5411] = 5247,
  [5412] = 3909,
  [5413] = 2642,
  [5414] = 5414,
  [5415] = 5250,
  [5416] = 5416,
  [5417] = 5306,
  [5418] = 5418,
  [5419] = 5419,
  [5420] = 5418,
  [5421] = 5276,
  [5422] = 5422,
  [5423] = 5423,
  [5424] = 5424,
  [5425] = 5425,
  [5426] = 3929,
  [5427] = 5272,
  [5428] = 5428,
  [5429] = 5270,
  [5430] = 5430,
  [5431] = 5251,
  [5432] = 5233,
  [5433] = 5416,
  [5434] = 5434,
  [5435] = 5346,
  [5436] = 5428,
  [5437] = 5437,
  [5438] = 5438,
  [5439] = 5246,
  [5440] = 5440,
  [5441] = 5441,
  [5442] = 5266,
  [5443] = 5443,
  [5444] = 5444,
  [5445] = 5307,
  [5446] = 5262,
  [5447] = 5240,
  [5448] = 5448,
  [5449] = 5449,
  [5450] = 5450,
  [5451] = 5451,
  [5452] = 5452,
  [5453] = 5258,
  [5454] = 5454,
  [5455] = 5455,
  [5456] = 5456,
  [5457] = 5457,
  [5458] = 5458,
  [5459] = 5459,
  [5460] = 5460,
  [5461] = 5422,
  [5462] = 5462,
  [5463] = 5463,
  [5464] = 5280,
  [5465] = 1673,
  [5466] = 5466,
  [5467] = 1691,
  [5468] = 5468,
  [5469] = 5338,
  [5470] = 5470,
  [5471] = 5471,
  [5472] = 5418,
  [5473] = 5430,
  [5474] = 5378,
  [5475] = 5475,
  [5476] = 5459,
  [5477] = 5403,
  [5478] = 2615,
  [5479] = 5466,
  [5480] = 5258,
  [5481] = 5475,
  [5482] = 5482,
  [5483] = 5483,
  [5484] = 2644,
  [5485] = 5485,
  [5486] = 5359,
  [5487] = 5487,
  [5488] = 2632,
  [5489] = 5482,
  [5490] = 5419,
  [5491] = 5491,
  [5492] = 5492,
  [5493] = 5493,
  [5494] = 5363,
  [5495] = 5386,
  [5496] = 5496,
  [5497] = 5386,
  [5498] = 5372,
  [5499] = 5422,
  [5500] = 5448,
  [5501] = 5248,
  [5502] = 5502,
  [5503] = 5503,
  [5504] = 5459,
  [5505] = 5414,
  [5506] = 5506,
  [5507] = 5320,
  [5508] = 5262,
  [5509] = 5267,
  [5510] = 5245,
  [5511] = 5511,
  [5512] = 5246,
  [5513] = 5333,
  [5514] = 5248,
  [5515] = 5455,
  [5516] = 5462,
  [5517] = 5517,
  [5518] = 5448,
  [5519] = 5351,
  [5520] = 5520,
  [5521] = 5521,
  [5522] = 5293,
  [5523] = 5306,
  [5524] = 5418,
  [5525] = 5376,
  [5526] = 5327,
  [5527] = 5422,
  [5528] = 5341,
  [5529] = 5529,
  [5530] = 2616,
  [5531] = 5531,
  [5532] = 5377,
  [5533] = 5466,
  [5534] = 5246,
  [5535] = 5535,
  [5536] = 5259,
  [5537] = 2645,
  [5538] = 5441,
  [5539] = 5539,
  [5540] = 5303,
  [5541] = 2640,
  [5542] = 5542,
  [5543] = 5517,
  [5544] = 5544,
  [5545] = 5360,
  [5546] = 5437,
  [5547] = 5547,
  [5548] = 5341,
  [5549] = 5373,
  [5550] = 5550,
  [5551] = 5551,
  [5552] = 5345,
  [5553] = 5313,
  [5554] = 5554,
  [5555] = 5257,
  [5556] = 5521,
  [5557] = 5261,
  [5558] = 5257,
  [5559] = 5559,
  [5560] = 5245,
  [5561] = 5393,
  [5562] = 5246,
  [5563] = 5261,
  [5564] = 5520,
  [5565] = 5378,
  [5566] = 5248,
  [5567] = 5274,
  [5568] = 5568,
  [5569] = 5401,
  [5570] = 5570,
  [5571] = 5440,
  [5572] = 5245,
  [5573] = 5328,
  [5574] = 5361,
  [5575] = 2625,
  [5576] = 5320,
  [5577] = 5434,
  [5578] = 5365,
  [5579] = 2626,
  [5580] = 5366,
  [5581] = 5274,
  [5582] = 5282,
  [5583] = 5258,
  [5584] = 5584,
  [5585] = 5585,
  [5586] = 5586,
  [5587] = 5587,
  [5588] = 5588,
  [5589] = 5589,
  [5590] = 5590,
  [5591] = 5591,
  [5592] = 5592,
  [5593] = 5593,
  [5594] = 5594,
  [5595] = 5595,
  [5596] = 5586,
  [5597] = 5597,
  [5598] = 5598,
  [5599] = 5599,
  [5600] = 5600,
  [5601] = 5601,
  [5602] = 5602,
  [5603] = 5603,
  [5604] = 5604,
  [5605] = 5605,
  [5606] = 5606,
  [5607] = 5607,
  [5608] = 5605,
  [5609] = 5597,
  [5610] = 5610,
  [5611] = 5611,
  [5612] = 5612,
  [5613] = 5613,
  [5614] = 5614,
  [5615] = 5615,
  [5616] = 5616,
  [5617] = 5617,
  [5618] = 5618,
  [5619] = 5619,
  [5620] = 5620,
  [5621] = 5621,
  [5622] = 5622,
  [5623] = 5623,
  [5624] = 5586,
  [5625] = 5625,
  [5626] = 5626,
  [5627] = 5598,
  [5628] = 5587,
  [5629] = 5629,
  [5630] = 5590,
  [5631] = 5589,
  [5632] = 5592,
  [5633] = 5633,
  [5634] = 5634,
  [5635] = 5635,
  [5636] = 5636,
  [5637] = 5637,
  [5638] = 5638,
  [5639] = 5594,
  [5640] = 5640,
  [5641] = 5641,
  [5642] = 5642,
  [5643] = 5640,
  [5644] = 5644,
  [5645] = 5588,
  [5646] = 5646,
  [5647] = 5637,
  [5648] = 5620,
  [5649] = 5649,
  [5650] = 5650,
  [5651] = 5607,
  [5652] = 5652,
  [5653] = 5653,
  [5654] = 5654,
  [5655] = 5655,
  [5656] = 5656,
  [5657] = 5657,
  [5658] = 5658,
  [5659] = 5659,
  [5660] = 5660,
  [5661] = 5601,
  [5662] = 5662,
  [5663] = 5663,
  [5664] = 5662,
  [5665] = 5590,
  [5666] = 5666,
  [5667] = 5667,
  [5668] = 5641,
  [5669] = 5656,
  [5670] = 5649,
  [5671] = 5671,
  [5672] = 5672,
  [5673] = 5673,
  [5674] = 5595,
  [5675] = 5675,
  [5676] = 5676,
  [5677] = 5677,
  [5678] = 5655,
  [5679] = 5593,
  [5680] = 5600,
  [5681] = 5635,
  [5682] = 5601,
  [5683] = 5683,
  [5684] = 5684,
  [5685] = 5601,
  [5686] = 5662,
  [5687] = 5687,
  [5688] = 5660,
  [5689] = 5642,
  [5690] = 5675,
  [5691] = 5650,
  [5692] = 5642,
  [5693] = 5644,
  [5694] = 5622,
  [5695] = 5586,
  [5696] = 5660,
  [5697] = 5653,
  [5698] = 5675,
  [5699] = 5657,
  [5700] = 5700,
  [5701] = 5672,
  [5702] = 5702,
  [5703] = 5593,
  [5704] = 5600,
  [5705] = 5705,
  [5706] = 5706,
  [5707] = 5707,
  [5708] = 5708,
  [5709] = 5709,
  [5710] = 5637,
  [5711] = 5711,
  [5712] = 5636,
  [5713] = 5659,
  [5714] = 5666,
  [5715] = 5715,
  [5716] = 5716,
  [5717] = 5602,
  [5718] = 5606,
  [5719] = 5673,
  [5720] = 5702,
  [5721] = 5598,
  [5722] = 5622,
  [5723] = 5660,
  [5724] = 5625,
  [5725] = 5642,
  [5726] = 5610,
  [5727] = 5633,
  [5728] = 5620,
  [5729] = 5677,
  [5730] = 5715,
  [5731] = 5684,
  [5732] = 5634,
  [5733] = 5602,
  [5734] = 5734,
  [5735] = 5637,
  [5736] = 5660,
  [5737] = 5660,
  [5738] = 5716,
  [5739] = 5593,
  [5740] = 5740,
  [5741] = 5741,
  [5742] = 5650,
  [5743] = 5600,
  [5744] = 5657,
  [5745] = 5635,
  [5746] = 5740,
  [5747] = 5607,
  [5748] = 5748,
  [5749] = 5653,
  [5750] = 5702,
  [5751] = 5751,
  [5752] = 5641,
  [5753] = 5646,
  [5754] = 5754,
  [5755] = 5755,
  [5756] = 5611,
  [5757] = 5649,
  [5758] = 5715,
  [5759] = 5593,
  [5760] = 5716,
  [5761] = 5761,
  [5762] = 5625,
  [5763] = 5600,
  [5764] = 5687,
  [5765] = 5765,
  [5766] = 5766,
  [5767] = 5709,
  [5768] = 5634,
  [5769] = 5618,
  [5770] = 5593,
  [5771] = 5600,
  [5772] = 5595,
  [5773] = 5610,
  [5774] = 5751,
  [5775] = 5614,
  [5776] = 5776,
  [5777] = 5611,
  [5778] = 5778,
  [5779] = 5779,
  [5780] = 5780,
  [5781] = 5611,
  [5782] = 5782,
  [5783] = 5783,
  [5784] = 5660,
  [5785] = 5676,
  [5786] = 5614,
  [5787] = 5619,
  [5788] = 5621,
  [5789] = 5687,
  [5790] = 5623,
  [5791] = 5602,
  [5792] = 5606,
  [5793] = 5683,
  [5794] = 5605,
  [5795] = 5626,
  [5796] = 5796,
  [5797] = 5587,
  [5798] = 5589,
  [5799] = 5592,
  [5800] = 5622,
  [5801] = 5586,
  [5802] = 5625,
  [5803] = 5765,
  [5804] = 5659,
  [5805] = 5598,
  [5806] = 5594,
  [5807] = 5614,
  [5808] = 5637,
  [5809] = 5610,
  [5810] = 5634,
  [5811] = 5761,
  [5812] = 5655,
  [5813] = 5813,
  [5814] = 5814,
  [5815] = 5600,
  [5816] = 5620,
  [5817] = 5817,
  [5818] = 5606,
  [5819] = 5748,
  [5820] = 5666,
  [5821] = 5821,
  [5822] = 5653,
  [5823] = 5601,
  [5824] = 5659,
  [5825] = 5825,
  [5826] = 5666,
  [5827] = 5677,
  [5828] = 5635,
  [5829] = 5598,
  [5830] = 5830,
  [5831] = 5641,
  [5832] = 5832,
  [5833] = 5646,
  [5834] = 5834,
  [5835] = 5677,
  [5836] = 5754,
  [5837] = 5684,
  [5838] = 5838,
  [5839] = 5649,
  [5840] = 5650,
  [5841] = 5610,
  [5842] = 5662,
  [5843] = 5602,
  [5844] = 5606,
  [5845] = 5655,
  [5846] = 5657,
  [5847] = 5622,
  [5848] = 5586,
  [5849] = 5625,
  [5850] = 5702,
  [5851] = 5715,
  [5852] = 5716,
  [5853] = 5619,
  [5854] = 5618,
  [5855] = 5602,
  [5856] = 5606,
  [5857] = 5634,
  [5858] = 5649,
  [5859] = 5605,
  [5860] = 5687,
  [5861] = 5675,
  [5862] = 5622,
  [5863] = 5586,
  [5864] = 5625,
  [5865] = 5618,
  [5866] = 5621,
  [5867] = 5656,
  [5868] = 5868,
  [5869] = 5604,
  [5870] = 5623,
  [5871] = 5708,
  [5872] = 5626,
  [5873] = 5711,
  [5874] = 5874,
  [5875] = 5587,
  [5876] = 5740,
  [5877] = 5589,
  [5878] = 5592,
  [5879] = 5634,
  [5880] = 5779,
  [5881] = 5611,
  [5882] = 5882,
  [5883] = 5883,
  [5884] = 5625,
  [5885] = 5605,
  [5886] = 5614,
  [5887] = 5619,
  [5888] = 5621,
  [5889] = 5889,
  [5890] = 5602,
  [5891] = 5606,
  [5892] = 5607,
  [5893] = 5606,
  [5894] = 5894,
  [5895] = 5605,
  [5896] = 5638,
  [5897] = 5700,
  [5898] = 5622,
  [5899] = 5635,
  [5900] = 5586,
  [5901] = 5625,
  [5902] = 5902,
  [5903] = 5590,
  [5904] = 5594,
  [5905] = 5601,
  [5906] = 5623,
  [5907] = 5626,
  [5908] = 5598,
  [5909] = 5587,
  [5910] = 5634,
  [5911] = 5642,
  [5912] = 5595,
  [5913] = 5667,
  [5914] = 5610,
  [5915] = 5641,
  [5916] = 5637,
  [5917] = 5683,
  [5918] = 5602,
  [5919] = 5667,
  [5920] = 5672,
  [5921] = 5653,
  [5922] = 5641,
  [5923] = 5659,
  [5924] = 5766,
  [5925] = 5589,
  [5926] = 5592,
  [5927] = 5594,
  [5928] = 5708,
  [5929] = 5666,
  [5930] = 5605,
  [5931] = 5667,
  [5932] = 5655,
  [5933] = 5933,
  [5934] = 5646,
  [5935] = 5711,
  [5936] = 5601,
  [5937] = 5618,
  [5938] = 5677,
  [5939] = 5649,
  [5940] = 5684,
  [5941] = 5605,
  [5942] = 5667,
  [5943] = 5650,
  [5944] = 5605,
  [5945] = 5684,
  [5946] = 5662,
  [5947] = 5675,
  [5948] = 5657,
  [5949] = 5662,
  [5950] = 5702,
  [5951] = 5951,
  [5952] = 5637,
  [5953] = 5951,
  [5954] = 5591,
  [5955] = 5955,
  [5956] = 5715,
  [5957] = 5716,
  [5958] = 5707,
  [5959] = 5602,
  [5960] = 5613,
  [5961] = 5675,
  [5962] = 5667,
  [5963] = 5641,
  [5964] = 5606,
  [5965] = 5965,
  [5966] = 5646,
  [5967] = 5817,
  [5968] = 5622,
  [5969] = 5586,
  [5970] = 5625,
  [5971] = 5642,
  [5972] = 5634,
  [5973] = 5687,
  [5974] = 5595,
  [5975] = 5975,
  [5976] = 5642,
  [5977] = 5965,
  [5978] = 5978,
  [5979] = 5619,
  [5980] = 5634,
  [5981] = 5649,
  [5982] = 5982,
  [5983] = 5654,
  [5984] = 5984,
  [5985] = 5622,
  [5986] = 5618,
  [5987] = 5778,
  [5988] = 5988,
  [5989] = 5613,
  [5990] = 5990,
  [5991] = 5621,
  [5992] = 5623,
  [5993] = 5667,
  [5994] = 5994,
  [5995] = 5978,
  [5996] = 5626,
  [5997] = 5593,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(150);
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '#', 10,
        '$', 311,
        '%', 251,
        '&', 230,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 153,
        '+', 243,
        ',', 161,
        '-', 247,
        '.', 183,
        '/', 296,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 256,
        '=', 157,
        '>', 179,
        '?', 317,
        '@', 314,
        '[', 169,
        '\\', 104,
        ']', 170,
        '^', 233,
        '`', 294,
        '{', 160,
        '|', 236,
        '}', 162,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(147);
      if (lookahead > '@') ADVANCE(312);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '<') ADVANCE(174);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(173);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(39);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '[') ADVANCE(88);
      if (lookahead == '\\') ADVANCE(146);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(297);
      if (lookahead != 0) ADVANCE(298);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '#', 87,
        '%', 251,
        '&', 230,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 153,
        '+', 242,
        ',', 161,
        '-', 246,
        '.', 183,
        '/', 249,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 258,
        '=', 157,
        '>', 179,
        '?', 317,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 233,
        '`', 294,
        '{', 159,
        '|', 235,
        '}', 162,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (lookahead > '#') ADVANCE(312);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '#', 87,
        '%', 251,
        '&', 230,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 153,
        '+', 242,
        ',', 161,
        '-', 246,
        '.', 183,
        '/', 249,
        '0', 301,
        ':', 168,
        '<', 258,
        '=', 157,
        '>', 179,
        '?', 317,
        '@', 314,
        '[', 169,
        '\\', 106,
        '^', 233,
        '`', 294,
        '{', 160,
        '|', 235,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '#', 87,
        '%', 251,
        '&', 230,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 153,
        '+', 242,
        ',', 161,
        '-', 246,
        '.', 184,
        '/', 249,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 257,
        '=', 157,
        '>', 179,
        '?', 317,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 233,
        '`', 294,
        '{', 160,
        '|', 236,
        '}', 162,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '%', 251,
        '&', 230,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 153,
        '+', 242,
        ',', 161,
        '-', 246,
        '.', 182,
        '/', 249,
        ':', 168,
        ';', 166,
        '<', 257,
        '=', 157,
        '>', 179,
        '?', 317,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 233,
        '`', 294,
        '{', 159,
        '|', 235,
        '}', 162,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 164,
        '%', 250,
        '&', 231,
        '(', 165,
        ')', 167,
        '*', 154,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 182,
        '/', 248,
        ':', 168,
        ';', 166,
        '<', 259,
        '=', 156,
        '>', 180,
        '?', 318,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 232,
        '`', 294,
        '{', 159,
        '|', 238,
        '}', 162,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 164,
        '%', 250,
        '&', 231,
        '(', 165,
        ')', 167,
        '*', 154,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 182,
        '/', 248,
        ':', 168,
        ';', 166,
        '<', 259,
        '=', 82,
        '>', 180,
        '?', 36,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 232,
        '`', 294,
        '{', 159,
        '|', 237,
        '}', 162,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(299);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 164,
        '%', 250,
        '&', 231,
        '(', 165,
        ')', 167,
        '*', 154,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 182,
        '/', 248,
        ':', 168,
        ';', 166,
        '<', 259,
        '=', 82,
        '>', 180,
        '?', 36,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 232,
        '`', 294,
        '{', 159,
        '|', 237,
        '}', 162,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(151);
      if (lookahead == '\\') ADVANCE(105);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(313);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 163,
        '"', 187,
        '#', 87,
        '&', 229,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 152,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 35,
        '/', 248,
        '0', 301,
        '<', 261,
        '?', 315,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '`', 294,
        '{', 160,
        '|', 234,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 163,
        '"', 187,
        '#', 87,
        '&', 229,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 152,
        '+', 240,
        ',', 161,
        '-', 244,
        '.', 183,
        '/', 29,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 254,
        '=', 158,
        '>', 178,
        '?', 315,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '`', 294,
        '{', 160,
        '|', 239,
        '}', 162,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(12);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '!', 163,
        '"', 187,
        '#', 87,
        '&', 229,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 152,
        '+', 240,
        ',', 161,
        '-', 244,
        '.', 183,
        '/', 29,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 254,
        '=', 158,
        '>', 178,
        '?', 315,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '{', 159,
        '|', 239,
        '}', 162,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '!', 163,
        '"', 187,
        '#', 87,
        '&', 229,
        '\'', 188,
        '(', 165,
        ')', 167,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 183,
        '/', 248,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 261,
        '=', 158,
        '>', 178,
        '?', 316,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '`', 294,
        '{', 159,
        '|', 239,
        '}', 162,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(312);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '"', 187,
        '&', 229,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 152,
        ',', 161,
        '.', 182,
        '/', 29,
        ':', 168,
        ';', 166,
        '<', 254,
        '=', 158,
        '>', 178,
        '?', 316,
        '[', 169,
        '\\', 106,
        ']', 170,
        '{', 159,
        '|', 239,
        '}', 162,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(15);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(312);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '"', 187,
        '&', 229,
        '\'', 188,
        '(', 165,
        '*', 152,
        '+', 240,
        '-', 244,
        '.', 122,
        '/', 30,
        '0', 301,
        '<', 254,
        '>', 178,
        '?', 315,
        '[', 169,
        '\\', 106,
        '`', 294,
        '{', 160,
        '|', 234,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(16);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(310);
      if (lookahead > '~') ADVANCE(312);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '&') ADVANCE(21);
      if (lookahead == '/') ADVANCE(190);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(189);
      if (lookahead != 0) ADVANCE(191);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '/') ADVANCE(29);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(18);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(187);
      if (lookahead == '/') ADVANCE(273);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(18);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(276);
      if (lookahead != 0) ADVANCE(278);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(118);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(81);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(118);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(81);
      if (lookahead != 0) ADVANCE(191);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(118);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(81);
      if (lookahead != 0) ADVANCE(197);
      END_STATE();
    case 23:
      if (lookahead == '$') ADVANCE(108);
      if (lookahead == '&') ADVANCE(20);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '<') ADVANCE(255);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead == '`') ADVANCE(294);
      if (lookahead == '{') ADVANCE(159);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 24:
      if (lookahead == '$') ADVANCE(108);
      if (lookahead == '&') ADVANCE(20);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '<') ADVANCE(255);
      if (lookahead == '`') ADVANCE(294);
      if (lookahead == '{') ADVANCE(159);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(24);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '&', 229,
        '(', 165,
        '+', 85,
        ',', 161,
        '-', 86,
        '.', 182,
        '/', 30,
        ':', 168,
        '<', 254,
        '=', 155,
        '>', 178,
        '?', 42,
        '[', 169,
        '\\', 106,
        '{', 159,
        '|', 234,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(25);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(310);
      if (lookahead > '~') ADVANCE(312);
      END_STATE();
    case 26:
      if (lookahead == '&') ADVANCE(22);
      if (lookahead == '\'') ADVANCE(188);
      if (lookahead == '/') ADVANCE(196);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(195);
      if (lookahead != 0) ADVANCE(197);
      END_STATE();
    case 27:
      if (lookahead == '\'') ADVANCE(188);
      if (lookahead == '/') ADVANCE(29);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(27);
      END_STATE();
    case 28:
      if (lookahead == '\'') ADVANCE(188);
      if (lookahead == '/') ADVANCE(279);
      if (lookahead == '\\') ADVANCE(107);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(27);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(282);
      if (lookahead != 0) ADVANCE(284);
      END_STATE();
    case 29:
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '/') ADVANCE(293);
      END_STATE();
    case 30:
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '/') ADVANCE(293);
      if (lookahead == '>') ADVANCE(186);
      END_STATE();
    case 31:
      if (lookahead == '*') ADVANCE(31);
      if (lookahead == '/') ADVANCE(290);
      if (lookahead != 0) ADVANCE(32);
      END_STATE();
    case 32:
      if (lookahead == '*') ADVANCE(31);
      if (lookahead != 0) ADVANCE(32);
      END_STATE();
    case 33:
      if (lookahead == '*') ADVANCE(192);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      if (lookahead != 0) ADVANCE(193);
      END_STATE();
    case 34:
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      if (lookahead != 0) ADVANCE(199);
      END_STATE();
    case 35:
      if (lookahead == '.') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(307);
      END_STATE();
    case 36:
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '?') ADVANCE(268);
      END_STATE();
    case 37:
      if (lookahead == '.') ADVANCE(218);
      END_STATE();
    case 38:
      if (lookahead == '/') ADVANCE(296);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(39);
      END_STATE();
    case 39:
      if (lookahead == '/') ADVANCE(29);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(39);
      END_STATE();
    case 40:
      if (lookahead == ':') ADVANCE(320);
      END_STATE();
    case 41:
      if (lookahead == ':') ADVANCE(319);
      END_STATE();
    case 42:
      if (lookahead == ':') ADVANCE(321);
      END_STATE();
    case 43:
      if (lookahead == ';') ADVANCE(177);
      END_STATE();
    case 44:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(45);
      END_STATE();
    case 47:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 49:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == ';') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 54:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 62:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(61);
      END_STATE();
    case 63:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 64:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 65:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 66:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 68:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(67);
      END_STATE();
    case 69:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(69);
      END_STATE();
    case 71:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 73:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 74:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(73);
      END_STATE();
    case 75:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 76:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(75);
      END_STATE();
    case 77:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 78:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 79:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 80:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(79);
      END_STATE();
    case 81:
      if (lookahead == ';') ADVANCE(177);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 82:
      if (lookahead == '=') ADVANCE(263);
      END_STATE();
    case 83:
      if (lookahead == '>') ADVANCE(175);
      END_STATE();
    case 84:
      if (lookahead == '>') ADVANCE(176);
      END_STATE();
    case 85:
      if (lookahead == '?') ADVANCE(40);
      END_STATE();
    case 86:
      if (lookahead == '?') ADVANCE(41);
      END_STATE();
    case 87:
      if (lookahead == '\\') ADVANCE(105);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(313);
      END_STATE();
    case 88:
      if (lookahead == '\\') ADVANCE(145);
      if (lookahead == ']') ADVANCE(298);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(88);
      END_STATE();
    case 89:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 96:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 97:
      if (lookahead == 'm') ADVANCE(99);
      END_STATE();
    case 98:
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 99:
      if (lookahead == 'p') ADVANCE(95);
      END_STATE();
    case 100:
      if (lookahead == 'p') ADVANCE(96);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(94);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(109);
      if (lookahead == 'x') ADVANCE(135);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(289);
      if (lookahead != 0) ADVANCE(285);
      END_STATE();
    case 105:
      if (lookahead == 'u') ADVANCE(110);
      END_STATE();
    case 106:
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(112);
      if (lookahead == 'x') ADVANCE(135);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(289);
      if (lookahead != 0) ADVANCE(285);
      END_STATE();
    case 108:
      if (lookahead == '{') ADVANCE(295);
      END_STATE();
    case 109:
      if (lookahead == '{') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(140);
      END_STATE();
    case 110:
      if (lookahead == '{') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 111:
      if (lookahead == '{') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 112:
      if (lookahead == '{') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(132);
      END_STATE();
    case 113:
      if (lookahead == '}') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 114:
      if (lookahead == '}') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 115:
      if (lookahead == '}') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(115);
      END_STATE();
    case 116:
      if (lookahead == '}') ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(116);
      END_STATE();
    case 117:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(308);
      END_STATE();
    case 118:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 119:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(304);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(305);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(302);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(307);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(303);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(308);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(312);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(313);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(285);
      END_STATE();
    case 128:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(306);
      END_STATE();
    case 129:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(116);
      END_STATE();
    case 130:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(286);
      END_STATE();
    case 131:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 132:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 133:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(114);
      END_STATE();
    case 134:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 135:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(127);
      END_STATE();
    case 136:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(115);
      END_STATE();
    case 137:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 138:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 139:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 140:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 141:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 142:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      END_STATE();
    case 143:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(191);
      END_STATE();
    case 144:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(197);
      END_STATE();
    case 145:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(88);
      END_STATE();
    case 146:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(298);
      END_STATE();
    case 147:
      if (eof) ADVANCE(150);
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '#', 10,
        '$', 311,
        '%', 251,
        '&', 230,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 153,
        '+', 243,
        ',', 161,
        '-', 247,
        '.', 183,
        '/', 249,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 256,
        '=', 157,
        '>', 179,
        '?', 317,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 233,
        '`', 294,
        '{', 160,
        '|', 236,
        '}', 162,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(147);
      if (lookahead > '@') ADVANCE(312);
      END_STATE();
    case 148:
      if (eof) ADVANCE(150);
      ADVANCE_MAP(
        '!', 164,
        '"', 187,
        '#', 87,
        '%', 250,
        '&', 231,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 154,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 184,
        '/', 248,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 260,
        '=', 156,
        '>', 180,
        '?', 36,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '^', 232,
        '`', 294,
        '{', 159,
        '|', 237,
        '}', 162,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(148);
      if (lookahead > '#') ADVANCE(312);
      END_STATE();
    case 149:
      if (eof) ADVANCE(150);
      ADVANCE_MAP(
        '!', 163,
        '"', 187,
        '#', 10,
        '&', 229,
        '\'', 188,
        '(', 165,
        ')', 167,
        '*', 152,
        '+', 241,
        ',', 161,
        '-', 245,
        '.', 183,
        '/', 248,
        '0', 301,
        ':', 168,
        ';', 166,
        '<', 261,
        '=', 158,
        '>', 178,
        '?', 315,
        '@', 314,
        '[', 169,
        '\\', 106,
        ']', 170,
        '`', 294,
        '{', 159,
        '|', 239,
        '}', 162,
        '~', 270,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(149);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(312);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(253);
      if (lookahead == '=') ADVANCE(205);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(252);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(263);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(263);
      if (lookahead == '>') ADVANCE(201);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(201);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(322);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(265);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '/') ADVANCE(293);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '<') ADVANCE(174);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n') ADVANCE(173);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(171);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(103);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_glimmer_opening_tag);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_glimmer_closing_tag);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_html_character_reference);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(267);
      if (lookahead == '>') ADVANCE(223);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(267);
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(307);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(307);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(21);
      if (lookahead == '/') ADVANCE(190);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(143);
      if (lookahead == '*') ADVANCE(193);
      if (lookahead == '/') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(191);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '*') ADVANCE(192);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(193);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(33);
      if (lookahead == '*') ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(291);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(191);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(22);
      if (lookahead == '/') ADVANCE(196);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(195);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(197);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(144);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(34);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '/') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(199);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(34);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(292);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(211);
      if (lookahead == '>') ADVANCE(226);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(225);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(212);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(213);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(220);
      if (lookahead == '=') ADVANCE(209);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(219);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(208);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(210);
      if (lookahead == '|') ADVANCE(222);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(210);
      if (lookahead == '|') ADVANCE(222);
      if (lookahead == '}') ADVANCE(323);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(221);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(221);
      if (lookahead == '}') ADVANCE(323);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(323);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(271);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(271);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(271);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '?') ADVANCE(40);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(272);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(272);
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(272);
      if (lookahead == '=') ADVANCE(204);
      if (lookahead == '?') ADVANCE(41);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '/') ADVANCE(293);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(32);
      if (lookahead == '/') ADVANCE(293);
      if (lookahead == '=') ADVANCE(206);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(207);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(185);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(185);
      if (lookahead == '<') ADVANCE(228);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(228);
      if (lookahead == '=') ADVANCE(262);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(228);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(227);
      if (lookahead == '=') ADVANCE(262);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(227);
      if (lookahead == '=') ADVANCE(262);
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(264);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(266);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(217);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '/') ADVANCE(277);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(278);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(274);
      if (lookahead == '/') ADVANCE(278);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(274);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(273);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(276);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(278);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(278);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(277);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(278);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(281);
      if (lookahead == '/') ADVANCE(283);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(284);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(280);
      if (lookahead == '/') ADVANCE(284);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(281);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(280);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(281);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(279);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(282);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(284);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(284);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(283);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(284);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(106);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(312);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(285);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(285);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(288);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(191);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(293);
      if (lookahead != 0) ADVANCE(194);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(197);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(293);
      if (lookahead != 0) ADVANCE(200);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(293);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(39);
      if (lookahead == '/') ADVANCE(29);
      if (lookahead == '[') ADVANCE(88);
      if (lookahead == '\\') ADVANCE(146);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(297);
      if (lookahead != 0) ADVANCE(298);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(88);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(298);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(106);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(299);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(312);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 309,
        '0', 303,
        '_', 123,
        'n', 300,
        'B', 119,
        'b', 119,
        'E', 117,
        'e', 117,
        'O', 120,
        'o', 120,
        'X', 128,
        'x', 128,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(302);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(309);
      if (lookahead == '_') ADVANCE(121);
      if (lookahead == 'n') ADVANCE(300);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(302);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(123);
      if (lookahead == 'n') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(303);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(119);
      if (lookahead == 'n') ADVANCE(300);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(304);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(120);
      if (lookahead == 'n') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(305);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(306);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(122);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(307);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(308);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(307);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(181);
      if (lookahead == '\\') ADVANCE(106);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(310);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(312);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(106);
      if (lookahead == '{') ADVANCE(295);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(312);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(106);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(312);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(105);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(313);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(202);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '?') ADVANCE(269);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(202);
      if (lookahead == '?') ADVANCE(268);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_PLUS_QMARK_COLON);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'k', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'o', 13,
        'p', 14,
        'r', 15,
        's', 16,
        't', 17,
        'u', 18,
        'v', 19,
        'w', 20,
        'y', 21,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(44);
      if (lookahead == 'm') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'w') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'h') ADVANCE(68);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'y') ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(71);
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 'y') ADVANCE(82);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(86);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(88);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 32:
      if (lookahead == 'b') ADVANCE(90);
      if (lookahead == 'c') ADVANCE(91);
      if (lookahead == 'f') ADVANCE(92);
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(96);
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(99);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(106);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(109);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(113);
      END_STATE();
    case 53:
      if (lookahead == 'v') ADVANCE(114);
      if (lookahead == 'w') ADVANCE(115);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(116);
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 55:
      if (lookahead == 'j') ADVANCE(118);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(121);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(122);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'q') ADVANCE(124);
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(130);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 66:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(134);
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 69:
      if (lookahead == 'u') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(137);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(138);
      END_STATE();
    case 71:
      if (lookahead == 'd') ADVANCE(139);
      if (lookahead == 'i') ADVANCE(140);
      if (lookahead == 'k') ADVANCE(141);
      END_STATE();
    case 72:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(145);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 83:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 84:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(154);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(156);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(157);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(158);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 90:
      if (lookahead == 'u') ADVANCE(160);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(161);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(162);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 95:
      if (lookahead == 'm') ADVANCE(165);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 101:
      if (lookahead == 'm') ADVANCE(170);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 104:
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(173);
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(176);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 109:
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 117:
      if (lookahead == 'b') ADVANCE(184);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 120:
      if (lookahead == 'v') ADVANCE(187);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(188);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 124:
      if (lookahead == 'u') ADVANCE(191);
      END_STATE();
    case 125:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 132:
      if (lookahead == 'b') ADVANCE(198);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(200);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 140:
      if (lookahead == 'q') ADVANCE(205);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(206);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(209);
      END_STATE();
    case 146:
      if (lookahead == 'h') ADVANCE(210);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(211);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 149:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(215);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 154:
      if (lookahead == 'k') ADVANCE(218);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 156:
      if (lookahead == 'h') ADVANCE(219);
      END_STATE();
    case 157:
      if (lookahead == 's') ADVANCE(220);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 160:
      if (lookahead == 'g') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 162:
      if (lookahead == 'u') ADVANCE(225);
      END_STATE();
    case 163:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(230);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 178:
      if (lookahead == 'f') ADVANCE(238);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(239);
      END_STATE();
    case 181:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(241);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(247);
      END_STATE();
    case 190:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(249);
      END_STATE();
    case 192:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(251);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 196:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(255);
      END_STATE();
    case 198:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 201:
      if (lookahead == 'w') ADVANCE(258);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(259);
      END_STATE();
    case 204:
      if (lookahead == 'f') ADVANCE(260);
      END_STATE();
    case 205:
      if (lookahead == 'u') ADVANCE(261);
      END_STATE();
    case 206:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 207:
      if (lookahead == 'g') ADVANCE(263);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 211:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 213:
      if (lookahead == 's') ADVANCE(267);
      END_STATE();
    case 214:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 217:
      if (lookahead == 'a') ADVANCE(269);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(270);
      END_STATE();
    case 223:
      if (lookahead == 'g') ADVANCE(271);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 225:
      if (lookahead == 'l') ADVANCE(273);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 228:
      if (lookahead == 'd') ADVANCE(276);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 233:
      if (lookahead == 'm') ADVANCE(280);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 237:
      if (lookahead == 'f') ADVANCE(283);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 240:
      if (lookahead == 'p') ADVANCE(285);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 242:
      if (lookahead == 'r') ADVANCE(286);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 245:
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 246:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 247:
      if (lookahead == 'c') ADVANCE(291);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(294);
      END_STATE();
    case 251:
      if (lookahead == 'f') ADVANCE(295);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(296);
      END_STATE();
    case 253:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 255:
      if (lookahead == 'h') ADVANCE(298);
      END_STATE();
    case 256:
      if (lookahead == 'l') ADVANCE(299);
      END_STATE();
    case 257:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 259:
      if (lookahead == 'f') ADVANCE(301);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 262:
      if (lookahead == 'w') ADVANCE(304);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 266:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 267:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == 's') ADVANCE(307);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 270:
      if (lookahead == 'u') ADVANCE(309);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 276:
      if (lookahead == 's') ADVANCE(313);
      END_STATE();
    case 277:
      if (lookahead == 'y') ADVANCE(314);
      END_STATE();
    case 278:
      if (lookahead == 'o') ADVANCE(315);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 282:
      if (lookahead == 'c') ADVANCE(317);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 285:
      if (lookahead == 'a') ADVANCE(319);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(320);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(323);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 295:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(326);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 304:
      if (lookahead == 'n') ADVANCE(327);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(328);
      END_STATE();
    case 306:
      if (lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 310:
      if (lookahead == 'r') ADVANCE(331);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 316:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 318:
      if (lookahead == 'c') ADVANCE(335);
      END_STATE();
    case 319:
      if (lookahead == 'c') ADVANCE(336);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 322:
      if (lookahead == 'e') ADVANCE(338);
      END_STATE();
    case 323:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 325:
      if (lookahead == 'e') ADVANCE(340);
      END_STATE();
    case 326:
      if (lookahead == 'e') ADVANCE(341);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_accessor);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(342);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(343);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(344);
      END_STATE();
    case 336:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 338:
      if (lookahead == 'd') ADVANCE(346);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 340:
      if (lookahead == 's') ADVANCE(347);
      END_STATE();
    case 341:
      if (lookahead == 'd') ADVANCE(348);
      END_STATE();
    case 342:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 343:
      if (lookahead == 'f') ADVANCE(350);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_satisfies);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 149, .external_lex_state = 2},
  [2] = {.lex_state = 4, .external_lex_state = 3},
  [3] = {.lex_state = 4, .external_lex_state = 3},
  [4] = {.lex_state = 149, .external_lex_state = 2},
  [5] = {.lex_state = 149, .external_lex_state = 2},
  [6] = {.lex_state = 149, .external_lex_state = 2},
  [7] = {.lex_state = 149, .external_lex_state = 2},
  [8] = {.lex_state = 149, .external_lex_state = 2},
  [9] = {.lex_state = 149, .external_lex_state = 2},
  [10] = {.lex_state = 149, .external_lex_state = 2},
  [11] = {.lex_state = 149, .external_lex_state = 2},
  [12] = {.lex_state = 149, .external_lex_state = 2},
  [13] = {.lex_state = 149, .external_lex_state = 2},
  [14] = {.lex_state = 149, .external_lex_state = 2},
  [15] = {.lex_state = 149, .external_lex_state = 2},
  [16] = {.lex_state = 149, .external_lex_state = 2},
  [17] = {.lex_state = 149, .external_lex_state = 2},
  [18] = {.lex_state = 149, .external_lex_state = 2},
  [19] = {.lex_state = 149, .external_lex_state = 2},
  [20] = {.lex_state = 149, .external_lex_state = 2},
  [21] = {.lex_state = 149, .external_lex_state = 2},
  [22] = {.lex_state = 149, .external_lex_state = 2},
  [23] = {.lex_state = 149, .external_lex_state = 2},
  [24] = {.lex_state = 149, .external_lex_state = 2},
  [25] = {.lex_state = 149, .external_lex_state = 2},
  [26] = {.lex_state = 149, .external_lex_state = 2},
  [27] = {.lex_state = 149, .external_lex_state = 2},
  [28] = {.lex_state = 149, .external_lex_state = 2},
  [29] = {.lex_state = 149, .external_lex_state = 2},
  [30] = {.lex_state = 149, .external_lex_state = 2},
  [31] = {.lex_state = 149, .external_lex_state = 2},
  [32] = {.lex_state = 149, .external_lex_state = 2},
  [33] = {.lex_state = 149, .external_lex_state = 2},
  [34] = {.lex_state = 149, .external_lex_state = 2},
  [35] = {.lex_state = 149, .external_lex_state = 2},
  [36] = {.lex_state = 149, .external_lex_state = 2},
  [37] = {.lex_state = 149, .external_lex_state = 2},
  [38] = {.lex_state = 149, .external_lex_state = 2},
  [39] = {.lex_state = 149, .external_lex_state = 2},
  [40] = {.lex_state = 149, .external_lex_state = 2},
  [41] = {.lex_state = 149, .external_lex_state = 2},
  [42] = {.lex_state = 149, .external_lex_state = 2},
  [43] = {.lex_state = 149, .external_lex_state = 2},
  [44] = {.lex_state = 149, .external_lex_state = 2},
  [45] = {.lex_state = 149, .external_lex_state = 2},
  [46] = {.lex_state = 149, .external_lex_state = 2},
  [47] = {.lex_state = 149, .external_lex_state = 2},
  [48] = {.lex_state = 149, .external_lex_state = 2},
  [49] = {.lex_state = 149, .external_lex_state = 2},
  [50] = {.lex_state = 149, .external_lex_state = 2},
  [51] = {.lex_state = 149, .external_lex_state = 2},
  [52] = {.lex_state = 11, .external_lex_state = 2},
  [53] = {.lex_state = 149, .external_lex_state = 2},
  [54] = {.lex_state = 149, .external_lex_state = 2},
  [55] = {.lex_state = 149, .external_lex_state = 2},
  [56] = {.lex_state = 149, .external_lex_state = 2},
  [57] = {.lex_state = 149, .external_lex_state = 2},
  [58] = {.lex_state = 149, .external_lex_state = 2},
  [59] = {.lex_state = 149, .external_lex_state = 2},
  [60] = {.lex_state = 149, .external_lex_state = 2},
  [61] = {.lex_state = 149, .external_lex_state = 2},
  [62] = {.lex_state = 11, .external_lex_state = 2},
  [63] = {.lex_state = 11, .external_lex_state = 2},
  [64] = {.lex_state = 11, .external_lex_state = 2},
  [65] = {.lex_state = 11, .external_lex_state = 2},
  [66] = {.lex_state = 149, .external_lex_state = 2},
  [67] = {.lex_state = 11, .external_lex_state = 2},
  [68] = {.lex_state = 11, .external_lex_state = 2},
  [69] = {.lex_state = 11, .external_lex_state = 2},
  [70] = {.lex_state = 11, .external_lex_state = 2},
  [71] = {.lex_state = 11, .external_lex_state = 2},
  [72] = {.lex_state = 149, .external_lex_state = 2},
  [73] = {.lex_state = 149, .external_lex_state = 2},
  [74] = {.lex_state = 149, .external_lex_state = 2},
  [75] = {.lex_state = 149, .external_lex_state = 2},
  [76] = {.lex_state = 149, .external_lex_state = 2},
  [77] = {.lex_state = 149, .external_lex_state = 2},
  [78] = {.lex_state = 149, .external_lex_state = 2},
  [79] = {.lex_state = 149, .external_lex_state = 2},
  [80] = {.lex_state = 149, .external_lex_state = 2},
  [81] = {.lex_state = 149, .external_lex_state = 2},
  [82] = {.lex_state = 149, .external_lex_state = 2},
  [83] = {.lex_state = 149, .external_lex_state = 2},
  [84] = {.lex_state = 149, .external_lex_state = 2},
  [85] = {.lex_state = 149, .external_lex_state = 2},
  [86] = {.lex_state = 149, .external_lex_state = 2},
  [87] = {.lex_state = 3, .external_lex_state = 4},
  [88] = {.lex_state = 3, .external_lex_state = 4},
  [89] = {.lex_state = 3, .external_lex_state = 4},
  [90] = {.lex_state = 3, .external_lex_state = 3},
  [91] = {.lex_state = 3, .external_lex_state = 3},
  [92] = {.lex_state = 3, .external_lex_state = 3},
  [93] = {.lex_state = 11, .external_lex_state = 2},
  [94] = {.lex_state = 11, .external_lex_state = 2},
  [95] = {.lex_state = 3, .external_lex_state = 3},
  [96] = {.lex_state = 3, .external_lex_state = 3},
  [97] = {.lex_state = 3, .external_lex_state = 3},
  [98] = {.lex_state = 3, .external_lex_state = 3},
  [99] = {.lex_state = 3, .external_lex_state = 3},
  [100] = {.lex_state = 11, .external_lex_state = 2},
  [101] = {.lex_state = 11, .external_lex_state = 2},
  [102] = {.lex_state = 3, .external_lex_state = 3},
  [103] = {.lex_state = 3, .external_lex_state = 3},
  [104] = {.lex_state = 11, .external_lex_state = 2},
  [105] = {.lex_state = 3, .external_lex_state = 3},
  [106] = {.lex_state = 11, .external_lex_state = 2},
  [107] = {.lex_state = 3, .external_lex_state = 3},
  [108] = {.lex_state = 11, .external_lex_state = 2},
  [109] = {.lex_state = 11, .external_lex_state = 2},
  [110] = {.lex_state = 3, .external_lex_state = 3},
  [111] = {.lex_state = 3, .external_lex_state = 3},
  [112] = {.lex_state = 3, .external_lex_state = 4},
  [113] = {.lex_state = 3, .external_lex_state = 4},
  [114] = {.lex_state = 3, .external_lex_state = 3},
  [115] = {.lex_state = 3, .external_lex_state = 4},
  [116] = {.lex_state = 3, .external_lex_state = 4},
  [117] = {.lex_state = 3, .external_lex_state = 4},
  [118] = {.lex_state = 3, .external_lex_state = 4},
  [119] = {.lex_state = 3, .external_lex_state = 3},
  [120] = {.lex_state = 3, .external_lex_state = 4},
  [121] = {.lex_state = 3, .external_lex_state = 4},
  [122] = {.lex_state = 3, .external_lex_state = 4},
  [123] = {.lex_state = 3, .external_lex_state = 3},
  [124] = {.lex_state = 3, .external_lex_state = 3},
  [125] = {.lex_state = 3, .external_lex_state = 3},
  [126] = {.lex_state = 3, .external_lex_state = 3},
  [127] = {.lex_state = 3, .external_lex_state = 3},
  [128] = {.lex_state = 3, .external_lex_state = 3},
  [129] = {.lex_state = 3, .external_lex_state = 3},
  [130] = {.lex_state = 3, .external_lex_state = 3},
  [131] = {.lex_state = 3, .external_lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 3},
  [133] = {.lex_state = 3, .external_lex_state = 3},
  [134] = {.lex_state = 3, .external_lex_state = 4},
  [135] = {.lex_state = 3, .external_lex_state = 4},
  [136] = {.lex_state = 3, .external_lex_state = 3},
  [137] = {.lex_state = 3, .external_lex_state = 3},
  [138] = {.lex_state = 3, .external_lex_state = 3},
  [139] = {.lex_state = 3, .external_lex_state = 3},
  [140] = {.lex_state = 3, .external_lex_state = 4},
  [141] = {.lex_state = 3, .external_lex_state = 3},
  [142] = {.lex_state = 3, .external_lex_state = 3},
  [143] = {.lex_state = 3, .external_lex_state = 3},
  [144] = {.lex_state = 3, .external_lex_state = 3},
  [145] = {.lex_state = 3, .external_lex_state = 3},
  [146] = {.lex_state = 3, .external_lex_state = 3},
  [147] = {.lex_state = 3, .external_lex_state = 3},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 3},
  [150] = {.lex_state = 3, .external_lex_state = 3},
  [151] = {.lex_state = 3, .external_lex_state = 3},
  [152] = {.lex_state = 3, .external_lex_state = 3},
  [153] = {.lex_state = 3, .external_lex_state = 3},
  [154] = {.lex_state = 3, .external_lex_state = 3},
  [155] = {.lex_state = 3, .external_lex_state = 3},
  [156] = {.lex_state = 3, .external_lex_state = 3},
  [157] = {.lex_state = 3, .external_lex_state = 3},
  [158] = {.lex_state = 11, .external_lex_state = 2},
  [159] = {.lex_state = 3, .external_lex_state = 3},
  [160] = {.lex_state = 3, .external_lex_state = 3},
  [161] = {.lex_state = 11, .external_lex_state = 2},
  [162] = {.lex_state = 11, .external_lex_state = 2},
  [163] = {.lex_state = 11, .external_lex_state = 2},
  [164] = {.lex_state = 11, .external_lex_state = 2},
  [165] = {.lex_state = 11, .external_lex_state = 2},
  [166] = {.lex_state = 11, .external_lex_state = 2},
  [167] = {.lex_state = 11, .external_lex_state = 2},
  [168] = {.lex_state = 11, .external_lex_state = 2},
  [169] = {.lex_state = 11, .external_lex_state = 2},
  [170] = {.lex_state = 11, .external_lex_state = 2},
  [171] = {.lex_state = 11, .external_lex_state = 2},
  [172] = {.lex_state = 11, .external_lex_state = 2},
  [173] = {.lex_state = 148, .external_lex_state = 3},
  [174] = {.lex_state = 148, .external_lex_state = 4},
  [175] = {.lex_state = 148, .external_lex_state = 4},
  [176] = {.lex_state = 148, .external_lex_state = 4},
  [177] = {.lex_state = 148, .external_lex_state = 3},
  [178] = {.lex_state = 148, .external_lex_state = 3},
  [179] = {.lex_state = 148, .external_lex_state = 3},
  [180] = {.lex_state = 148, .external_lex_state = 3},
  [181] = {.lex_state = 148, .external_lex_state = 3},
  [182] = {.lex_state = 5, .external_lex_state = 3},
  [183] = {.lex_state = 149, .external_lex_state = 2},
  [184] = {.lex_state = 149, .external_lex_state = 2},
  [185] = {.lex_state = 149, .external_lex_state = 2},
  [186] = {.lex_state = 149, .external_lex_state = 2},
  [187] = {.lex_state = 149, .external_lex_state = 2},
  [188] = {.lex_state = 149, .external_lex_state = 2},
  [189] = {.lex_state = 149, .external_lex_state = 2},
  [190] = {.lex_state = 149, .external_lex_state = 2},
  [191] = {.lex_state = 5, .external_lex_state = 4},
  [192] = {.lex_state = 5, .external_lex_state = 4},
  [193] = {.lex_state = 5, .external_lex_state = 3},
  [194] = {.lex_state = 5, .external_lex_state = 3},
  [195] = {.lex_state = 5, .external_lex_state = 3},
  [196] = {.lex_state = 5, .external_lex_state = 4},
  [197] = {.lex_state = 5, .external_lex_state = 3},
  [198] = {.lex_state = 5, .external_lex_state = 3},
  [199] = {.lex_state = 5, .external_lex_state = 3},
  [200] = {.lex_state = 5, .external_lex_state = 3},
  [201] = {.lex_state = 5, .external_lex_state = 3},
  [202] = {.lex_state = 5, .external_lex_state = 3},
  [203] = {.lex_state = 5, .external_lex_state = 3},
  [204] = {.lex_state = 149, .external_lex_state = 2},
  [205] = {.lex_state = 149, .external_lex_state = 2},
  [206] = {.lex_state = 149, .external_lex_state = 2},
  [207] = {.lex_state = 149, .external_lex_state = 2},
  [208] = {.lex_state = 149, .external_lex_state = 2},
  [209] = {.lex_state = 149, .external_lex_state = 2},
  [210] = {.lex_state = 149, .external_lex_state = 2},
  [211] = {.lex_state = 149, .external_lex_state = 2},
  [212] = {.lex_state = 149, .external_lex_state = 2},
  [213] = {.lex_state = 149, .external_lex_state = 2},
  [214] = {.lex_state = 149, .external_lex_state = 2},
  [215] = {.lex_state = 149, .external_lex_state = 2},
  [216] = {.lex_state = 149, .external_lex_state = 2},
  [217] = {.lex_state = 149, .external_lex_state = 2},
  [218] = {.lex_state = 149, .external_lex_state = 2},
  [219] = {.lex_state = 149, .external_lex_state = 2},
  [220] = {.lex_state = 149, .external_lex_state = 2},
  [221] = {.lex_state = 149, .external_lex_state = 2},
  [222] = {.lex_state = 149, .external_lex_state = 2},
  [223] = {.lex_state = 149, .external_lex_state = 2},
  [224] = {.lex_state = 148, .external_lex_state = 4},
  [225] = {.lex_state = 148, .external_lex_state = 4},
  [226] = {.lex_state = 149, .external_lex_state = 5},
  [227] = {.lex_state = 148, .external_lex_state = 4},
  [228] = {.lex_state = 149, .external_lex_state = 2},
  [229] = {.lex_state = 148, .external_lex_state = 4},
  [230] = {.lex_state = 149, .external_lex_state = 2},
  [231] = {.lex_state = 149, .external_lex_state = 2},
  [232] = {.lex_state = 148, .external_lex_state = 4},
  [233] = {.lex_state = 149, .external_lex_state = 2},
  [234] = {.lex_state = 148, .external_lex_state = 4},
  [235] = {.lex_state = 148, .external_lex_state = 4},
  [236] = {.lex_state = 149, .external_lex_state = 2},
  [237] = {.lex_state = 148, .external_lex_state = 4},
  [238] = {.lex_state = 148, .external_lex_state = 4},
  [239] = {.lex_state = 148, .external_lex_state = 4},
  [240] = {.lex_state = 148, .external_lex_state = 4},
  [241] = {.lex_state = 148, .external_lex_state = 4},
  [242] = {.lex_state = 149, .external_lex_state = 2},
  [243] = {.lex_state = 148, .external_lex_state = 4},
  [244] = {.lex_state = 149, .external_lex_state = 2},
  [245] = {.lex_state = 148, .external_lex_state = 4},
  [246] = {.lex_state = 148, .external_lex_state = 4},
  [247] = {.lex_state = 149, .external_lex_state = 2},
  [248] = {.lex_state = 148, .external_lex_state = 4},
  [249] = {.lex_state = 148, .external_lex_state = 4},
  [250] = {.lex_state = 148, .external_lex_state = 4},
  [251] = {.lex_state = 148, .external_lex_state = 4},
  [252] = {.lex_state = 148, .external_lex_state = 4},
  [253] = {.lex_state = 148, .external_lex_state = 4},
  [254] = {.lex_state = 148, .external_lex_state = 4},
  [255] = {.lex_state = 148, .external_lex_state = 4},
  [256] = {.lex_state = 148, .external_lex_state = 4},
  [257] = {.lex_state = 148, .external_lex_state = 4},
  [258] = {.lex_state = 149, .external_lex_state = 2},
  [259] = {.lex_state = 149, .external_lex_state = 2},
  [260] = {.lex_state = 148, .external_lex_state = 4},
  [261] = {.lex_state = 148, .external_lex_state = 4},
  [262] = {.lex_state = 148, .external_lex_state = 4},
  [263] = {.lex_state = 149, .external_lex_state = 2},
  [264] = {.lex_state = 148, .external_lex_state = 4},
  [265] = {.lex_state = 149, .external_lex_state = 2},
  [266] = {.lex_state = 149, .external_lex_state = 2},
  [267] = {.lex_state = 149, .external_lex_state = 2},
  [268] = {.lex_state = 149, .external_lex_state = 2},
  [269] = {.lex_state = 149, .external_lex_state = 2},
  [270] = {.lex_state = 149, .external_lex_state = 2},
  [271] = {.lex_state = 149, .external_lex_state = 2},
  [272] = {.lex_state = 149, .external_lex_state = 2},
  [273] = {.lex_state = 149, .external_lex_state = 2},
  [274] = {.lex_state = 149, .external_lex_state = 2},
  [275] = {.lex_state = 149, .external_lex_state = 2},
  [276] = {.lex_state = 149, .external_lex_state = 2},
  [277] = {.lex_state = 149, .external_lex_state = 2},
  [278] = {.lex_state = 149, .external_lex_state = 2},
  [279] = {.lex_state = 149, .external_lex_state = 2},
  [280] = {.lex_state = 149, .external_lex_state = 2},
  [281] = {.lex_state = 149, .external_lex_state = 2},
  [282] = {.lex_state = 149, .external_lex_state = 2},
  [283] = {.lex_state = 149, .external_lex_state = 2},
  [284] = {.lex_state = 149, .external_lex_state = 2},
  [285] = {.lex_state = 3, .external_lex_state = 3},
  [286] = {.lex_state = 149, .external_lex_state = 2},
  [287] = {.lex_state = 149, .external_lex_state = 2},
  [288] = {.lex_state = 149, .external_lex_state = 2},
  [289] = {.lex_state = 149, .external_lex_state = 2},
  [290] = {.lex_state = 149, .external_lex_state = 2},
  [291] = {.lex_state = 149, .external_lex_state = 2},
  [292] = {.lex_state = 149, .external_lex_state = 2},
  [293] = {.lex_state = 149, .external_lex_state = 2},
  [294] = {.lex_state = 149, .external_lex_state = 2},
  [295] = {.lex_state = 3, .external_lex_state = 3},
  [296] = {.lex_state = 149, .external_lex_state = 2},
  [297] = {.lex_state = 149, .external_lex_state = 2},
  [298] = {.lex_state = 149, .external_lex_state = 2},
  [299] = {.lex_state = 149, .external_lex_state = 2},
  [300] = {.lex_state = 3, .external_lex_state = 3},
  [301] = {.lex_state = 149, .external_lex_state = 2},
  [302] = {.lex_state = 149, .external_lex_state = 2},
  [303] = {.lex_state = 149, .external_lex_state = 2},
  [304] = {.lex_state = 149, .external_lex_state = 2},
  [305] = {.lex_state = 3, .external_lex_state = 3},
  [306] = {.lex_state = 149, .external_lex_state = 2},
  [307] = {.lex_state = 149, .external_lex_state = 2},
  [308] = {.lex_state = 149, .external_lex_state = 2},
  [309] = {.lex_state = 149, .external_lex_state = 5},
  [310] = {.lex_state = 149, .external_lex_state = 2},
  [311] = {.lex_state = 149, .external_lex_state = 2},
  [312] = {.lex_state = 149, .external_lex_state = 2},
  [313] = {.lex_state = 149, .external_lex_state = 2},
  [314] = {.lex_state = 149, .external_lex_state = 2},
  [315] = {.lex_state = 149, .external_lex_state = 2},
  [316] = {.lex_state = 149, .external_lex_state = 2},
  [317] = {.lex_state = 149, .external_lex_state = 2},
  [318] = {.lex_state = 149, .external_lex_state = 2},
  [319] = {.lex_state = 149, .external_lex_state = 2},
  [320] = {.lex_state = 149, .external_lex_state = 2},
  [321] = {.lex_state = 149, .external_lex_state = 2},
  [322] = {.lex_state = 149, .external_lex_state = 2},
  [323] = {.lex_state = 149, .external_lex_state = 2},
  [324] = {.lex_state = 149, .external_lex_state = 2},
  [325] = {.lex_state = 149, .external_lex_state = 2},
  [326] = {.lex_state = 149, .external_lex_state = 2},
  [327] = {.lex_state = 149, .external_lex_state = 2},
  [328] = {.lex_state = 149, .external_lex_state = 2},
  [329] = {.lex_state = 149, .external_lex_state = 2},
  [330] = {.lex_state = 149, .external_lex_state = 2},
  [331] = {.lex_state = 149, .external_lex_state = 2},
  [332] = {.lex_state = 149, .external_lex_state = 2},
  [333] = {.lex_state = 149, .external_lex_state = 2},
  [334] = {.lex_state = 149, .external_lex_state = 2},
  [335] = {.lex_state = 149, .external_lex_state = 2},
  [336] = {.lex_state = 149, .external_lex_state = 2},
  [337] = {.lex_state = 149, .external_lex_state = 2},
  [338] = {.lex_state = 149, .external_lex_state = 2},
  [339] = {.lex_state = 149, .external_lex_state = 2},
  [340] = {.lex_state = 149, .external_lex_state = 2},
  [341] = {.lex_state = 149, .external_lex_state = 2},
  [342] = {.lex_state = 149, .external_lex_state = 2},
  [343] = {.lex_state = 149, .external_lex_state = 2},
  [344] = {.lex_state = 149, .external_lex_state = 2},
  [345] = {.lex_state = 149, .external_lex_state = 2},
  [346] = {.lex_state = 149, .external_lex_state = 2},
  [347] = {.lex_state = 149, .external_lex_state = 2},
  [348] = {.lex_state = 149, .external_lex_state = 2},
  [349] = {.lex_state = 149, .external_lex_state = 2},
  [350] = {.lex_state = 149, .external_lex_state = 2},
  [351] = {.lex_state = 149, .external_lex_state = 2},
  [352] = {.lex_state = 149, .external_lex_state = 2},
  [353] = {.lex_state = 149, .external_lex_state = 2},
  [354] = {.lex_state = 149, .external_lex_state = 2},
  [355] = {.lex_state = 149, .external_lex_state = 2},
  [356] = {.lex_state = 149, .external_lex_state = 2},
  [357] = {.lex_state = 149, .external_lex_state = 2},
  [358] = {.lex_state = 149, .external_lex_state = 2},
  [359] = {.lex_state = 149, .external_lex_state = 2},
  [360] = {.lex_state = 149, .external_lex_state = 2},
  [361] = {.lex_state = 149, .external_lex_state = 2},
  [362] = {.lex_state = 149, .external_lex_state = 2},
  [363] = {.lex_state = 149, .external_lex_state = 2},
  [364] = {.lex_state = 149, .external_lex_state = 2},
  [365] = {.lex_state = 149, .external_lex_state = 2},
  [366] = {.lex_state = 149, .external_lex_state = 2},
  [367] = {.lex_state = 149, .external_lex_state = 2},
  [368] = {.lex_state = 149, .external_lex_state = 2},
  [369] = {.lex_state = 149, .external_lex_state = 2},
  [370] = {.lex_state = 149, .external_lex_state = 2},
  [371] = {.lex_state = 149, .external_lex_state = 2},
  [372] = {.lex_state = 149, .external_lex_state = 2},
  [373] = {.lex_state = 149, .external_lex_state = 2},
  [374] = {.lex_state = 149, .external_lex_state = 2},
  [375] = {.lex_state = 149, .external_lex_state = 2},
  [376] = {.lex_state = 149, .external_lex_state = 2},
  [377] = {.lex_state = 149, .external_lex_state = 2},
  [378] = {.lex_state = 149, .external_lex_state = 2},
  [379] = {.lex_state = 149, .external_lex_state = 2},
  [380] = {.lex_state = 149, .external_lex_state = 2},
  [381] = {.lex_state = 149, .external_lex_state = 2},
  [382] = {.lex_state = 149, .external_lex_state = 2},
  [383] = {.lex_state = 149, .external_lex_state = 2},
  [384] = {.lex_state = 149, .external_lex_state = 2},
  [385] = {.lex_state = 149, .external_lex_state = 2},
  [386] = {.lex_state = 149, .external_lex_state = 2},
  [387] = {.lex_state = 149, .external_lex_state = 2},
  [388] = {.lex_state = 149, .external_lex_state = 2},
  [389] = {.lex_state = 149, .external_lex_state = 2},
  [390] = {.lex_state = 149, .external_lex_state = 2},
  [391] = {.lex_state = 149, .external_lex_state = 2},
  [392] = {.lex_state = 149, .external_lex_state = 2},
  [393] = {.lex_state = 149, .external_lex_state = 2},
  [394] = {.lex_state = 149, .external_lex_state = 2},
  [395] = {.lex_state = 149, .external_lex_state = 2},
  [396] = {.lex_state = 149, .external_lex_state = 2},
  [397] = {.lex_state = 149, .external_lex_state = 2},
  [398] = {.lex_state = 149, .external_lex_state = 2},
  [399] = {.lex_state = 149, .external_lex_state = 2},
  [400] = {.lex_state = 149, .external_lex_state = 2},
  [401] = {.lex_state = 149, .external_lex_state = 2},
  [402] = {.lex_state = 149, .external_lex_state = 2},
  [403] = {.lex_state = 149, .external_lex_state = 2},
  [404] = {.lex_state = 149, .external_lex_state = 2},
  [405] = {.lex_state = 149, .external_lex_state = 2},
  [406] = {.lex_state = 149, .external_lex_state = 2},
  [407] = {.lex_state = 149, .external_lex_state = 2},
  [408] = {.lex_state = 149, .external_lex_state = 2},
  [409] = {.lex_state = 149, .external_lex_state = 2},
  [410] = {.lex_state = 149, .external_lex_state = 2},
  [411] = {.lex_state = 149, .external_lex_state = 2},
  [412] = {.lex_state = 149, .external_lex_state = 2},
  [413] = {.lex_state = 149, .external_lex_state = 2},
  [414] = {.lex_state = 149, .external_lex_state = 2},
  [415] = {.lex_state = 149, .external_lex_state = 2},
  [416] = {.lex_state = 149, .external_lex_state = 2},
  [417] = {.lex_state = 149, .external_lex_state = 2},
  [418] = {.lex_state = 149, .external_lex_state = 2},
  [419] = {.lex_state = 149, .external_lex_state = 2},
  [420] = {.lex_state = 149, .external_lex_state = 2},
  [421] = {.lex_state = 149, .external_lex_state = 2},
  [422] = {.lex_state = 149, .external_lex_state = 2},
  [423] = {.lex_state = 149, .external_lex_state = 2},
  [424] = {.lex_state = 149, .external_lex_state = 2},
  [425] = {.lex_state = 149, .external_lex_state = 2},
  [426] = {.lex_state = 149, .external_lex_state = 2},
  [427] = {.lex_state = 149, .external_lex_state = 2},
  [428] = {.lex_state = 149, .external_lex_state = 2},
  [429] = {.lex_state = 149, .external_lex_state = 2},
  [430] = {.lex_state = 149, .external_lex_state = 2},
  [431] = {.lex_state = 149, .external_lex_state = 2},
  [432] = {.lex_state = 149, .external_lex_state = 2},
  [433] = {.lex_state = 149, .external_lex_state = 2},
  [434] = {.lex_state = 149, .external_lex_state = 2},
  [435] = {.lex_state = 149, .external_lex_state = 2},
  [436] = {.lex_state = 149, .external_lex_state = 2},
  [437] = {.lex_state = 149, .external_lex_state = 2},
  [438] = {.lex_state = 149, .external_lex_state = 2},
  [439] = {.lex_state = 149, .external_lex_state = 2},
  [440] = {.lex_state = 149, .external_lex_state = 2},
  [441] = {.lex_state = 149, .external_lex_state = 2},
  [442] = {.lex_state = 149, .external_lex_state = 2},
  [443] = {.lex_state = 149, .external_lex_state = 2},
  [444] = {.lex_state = 149, .external_lex_state = 2},
  [445] = {.lex_state = 149, .external_lex_state = 2},
  [446] = {.lex_state = 149, .external_lex_state = 2},
  [447] = {.lex_state = 149, .external_lex_state = 2},
  [448] = {.lex_state = 149, .external_lex_state = 2},
  [449] = {.lex_state = 149, .external_lex_state = 2},
  [450] = {.lex_state = 149, .external_lex_state = 2},
  [451] = {.lex_state = 149, .external_lex_state = 2},
  [452] = {.lex_state = 149, .external_lex_state = 2},
  [453] = {.lex_state = 149, .external_lex_state = 2},
  [454] = {.lex_state = 149, .external_lex_state = 2},
  [455] = {.lex_state = 149, .external_lex_state = 2},
  [456] = {.lex_state = 149, .external_lex_state = 2},
  [457] = {.lex_state = 149, .external_lex_state = 2},
  [458] = {.lex_state = 149, .external_lex_state = 2},
  [459] = {.lex_state = 149, .external_lex_state = 2},
  [460] = {.lex_state = 149, .external_lex_state = 2},
  [461] = {.lex_state = 149, .external_lex_state = 2},
  [462] = {.lex_state = 149, .external_lex_state = 2},
  [463] = {.lex_state = 149, .external_lex_state = 2},
  [464] = {.lex_state = 149, .external_lex_state = 2},
  [465] = {.lex_state = 149, .external_lex_state = 2},
  [466] = {.lex_state = 149, .external_lex_state = 2},
  [467] = {.lex_state = 149, .external_lex_state = 2},
  [468] = {.lex_state = 149, .external_lex_state = 2},
  [469] = {.lex_state = 149, .external_lex_state = 2},
  [470] = {.lex_state = 149, .external_lex_state = 2},
  [471] = {.lex_state = 149, .external_lex_state = 2},
  [472] = {.lex_state = 149, .external_lex_state = 2},
  [473] = {.lex_state = 149, .external_lex_state = 2},
  [474] = {.lex_state = 149, .external_lex_state = 2},
  [475] = {.lex_state = 149, .external_lex_state = 2},
  [476] = {.lex_state = 149, .external_lex_state = 2},
  [477] = {.lex_state = 149, .external_lex_state = 2},
  [478] = {.lex_state = 149, .external_lex_state = 2},
  [479] = {.lex_state = 149, .external_lex_state = 2},
  [480] = {.lex_state = 149, .external_lex_state = 2},
  [481] = {.lex_state = 149, .external_lex_state = 2},
  [482] = {.lex_state = 149, .external_lex_state = 2},
  [483] = {.lex_state = 149, .external_lex_state = 2},
  [484] = {.lex_state = 149, .external_lex_state = 2},
  [485] = {.lex_state = 149, .external_lex_state = 2},
  [486] = {.lex_state = 149, .external_lex_state = 2},
  [487] = {.lex_state = 149, .external_lex_state = 2},
  [488] = {.lex_state = 149, .external_lex_state = 2},
  [489] = {.lex_state = 149, .external_lex_state = 2},
  [490] = {.lex_state = 149, .external_lex_state = 2},
  [491] = {.lex_state = 149, .external_lex_state = 2},
  [492] = {.lex_state = 149, .external_lex_state = 2},
  [493] = {.lex_state = 149, .external_lex_state = 2},
  [494] = {.lex_state = 149, .external_lex_state = 2},
  [495] = {.lex_state = 149, .external_lex_state = 2},
  [496] = {.lex_state = 149, .external_lex_state = 2},
  [497] = {.lex_state = 149, .external_lex_state = 2},
  [498] = {.lex_state = 149, .external_lex_state = 2},
  [499] = {.lex_state = 149, .external_lex_state = 2},
  [500] = {.lex_state = 149, .external_lex_state = 2},
  [501] = {.lex_state = 149, .external_lex_state = 2},
  [502] = {.lex_state = 149, .external_lex_state = 2},
  [503] = {.lex_state = 149, .external_lex_state = 2},
  [504] = {.lex_state = 149, .external_lex_state = 2},
  [505] = {.lex_state = 149, .external_lex_state = 2},
  [506] = {.lex_state = 149, .external_lex_state = 2},
  [507] = {.lex_state = 149, .external_lex_state = 2},
  [508] = {.lex_state = 149, .external_lex_state = 2},
  [509] = {.lex_state = 149, .external_lex_state = 2},
  [510] = {.lex_state = 149, .external_lex_state = 2},
  [511] = {.lex_state = 149, .external_lex_state = 2},
  [512] = {.lex_state = 149, .external_lex_state = 2},
  [513] = {.lex_state = 149, .external_lex_state = 2},
  [514] = {.lex_state = 149, .external_lex_state = 2},
  [515] = {.lex_state = 149, .external_lex_state = 2},
  [516] = {.lex_state = 149, .external_lex_state = 2},
  [517] = {.lex_state = 149, .external_lex_state = 2},
  [518] = {.lex_state = 149, .external_lex_state = 2},
  [519] = {.lex_state = 149, .external_lex_state = 2},
  [520] = {.lex_state = 149, .external_lex_state = 2},
  [521] = {.lex_state = 149, .external_lex_state = 2},
  [522] = {.lex_state = 149, .external_lex_state = 2},
  [523] = {.lex_state = 149, .external_lex_state = 2},
  [524] = {.lex_state = 149, .external_lex_state = 2},
  [525] = {.lex_state = 149, .external_lex_state = 2},
  [526] = {.lex_state = 149, .external_lex_state = 2},
  [527] = {.lex_state = 149, .external_lex_state = 2},
  [528] = {.lex_state = 149, .external_lex_state = 2},
  [529] = {.lex_state = 149, .external_lex_state = 2},
  [530] = {.lex_state = 149, .external_lex_state = 2},
  [531] = {.lex_state = 149, .external_lex_state = 2},
  [532] = {.lex_state = 149, .external_lex_state = 2},
  [533] = {.lex_state = 149, .external_lex_state = 2},
  [534] = {.lex_state = 149, .external_lex_state = 2},
  [535] = {.lex_state = 149, .external_lex_state = 2},
  [536] = {.lex_state = 149, .external_lex_state = 2},
  [537] = {.lex_state = 149, .external_lex_state = 2},
  [538] = {.lex_state = 149, .external_lex_state = 2},
  [539] = {.lex_state = 149, .external_lex_state = 2},
  [540] = {.lex_state = 149, .external_lex_state = 2},
  [541] = {.lex_state = 149, .external_lex_state = 2},
  [542] = {.lex_state = 149, .external_lex_state = 2},
  [543] = {.lex_state = 149, .external_lex_state = 2},
  [544] = {.lex_state = 149, .external_lex_state = 2},
  [545] = {.lex_state = 149, .external_lex_state = 2},
  [546] = {.lex_state = 149, .external_lex_state = 2},
  [547] = {.lex_state = 149, .external_lex_state = 2},
  [548] = {.lex_state = 149, .external_lex_state = 2},
  [549] = {.lex_state = 149, .external_lex_state = 2},
  [550] = {.lex_state = 149, .external_lex_state = 2},
  [551] = {.lex_state = 149, .external_lex_state = 2},
  [552] = {.lex_state = 149, .external_lex_state = 2},
  [553] = {.lex_state = 149, .external_lex_state = 2},
  [554] = {.lex_state = 149, .external_lex_state = 2},
  [555] = {.lex_state = 149, .external_lex_state = 2},
  [556] = {.lex_state = 149, .external_lex_state = 2},
  [557] = {.lex_state = 149, .external_lex_state = 2},
  [558] = {.lex_state = 149, .external_lex_state = 2},
  [559] = {.lex_state = 149, .external_lex_state = 2},
  [560] = {.lex_state = 149, .external_lex_state = 2},
  [561] = {.lex_state = 149, .external_lex_state = 2},
  [562] = {.lex_state = 149, .external_lex_state = 2},
  [563] = {.lex_state = 149, .external_lex_state = 2},
  [564] = {.lex_state = 149, .external_lex_state = 2},
  [565] = {.lex_state = 149, .external_lex_state = 2},
  [566] = {.lex_state = 149, .external_lex_state = 2},
  [567] = {.lex_state = 149, .external_lex_state = 2},
  [568] = {.lex_state = 149, .external_lex_state = 2},
  [569] = {.lex_state = 149, .external_lex_state = 2},
  [570] = {.lex_state = 149, .external_lex_state = 2},
  [571] = {.lex_state = 149, .external_lex_state = 2},
  [572] = {.lex_state = 149, .external_lex_state = 2},
  [573] = {.lex_state = 149, .external_lex_state = 2},
  [574] = {.lex_state = 149, .external_lex_state = 2},
  [575] = {.lex_state = 149, .external_lex_state = 2},
  [576] = {.lex_state = 149, .external_lex_state = 2},
  [577] = {.lex_state = 149, .external_lex_state = 2},
  [578] = {.lex_state = 149, .external_lex_state = 2},
  [579] = {.lex_state = 149, .external_lex_state = 2},
  [580] = {.lex_state = 149, .external_lex_state = 2},
  [581] = {.lex_state = 149, .external_lex_state = 2},
  [582] = {.lex_state = 149, .external_lex_state = 2},
  [583] = {.lex_state = 149, .external_lex_state = 2},
  [584] = {.lex_state = 149, .external_lex_state = 2},
  [585] = {.lex_state = 149, .external_lex_state = 2},
  [586] = {.lex_state = 149, .external_lex_state = 2},
  [587] = {.lex_state = 149, .external_lex_state = 2},
  [588] = {.lex_state = 149, .external_lex_state = 2},
  [589] = {.lex_state = 149, .external_lex_state = 2},
  [590] = {.lex_state = 149, .external_lex_state = 2},
  [591] = {.lex_state = 149, .external_lex_state = 2},
  [592] = {.lex_state = 149, .external_lex_state = 2},
  [593] = {.lex_state = 149, .external_lex_state = 2},
  [594] = {.lex_state = 149, .external_lex_state = 2},
  [595] = {.lex_state = 149, .external_lex_state = 2},
  [596] = {.lex_state = 149, .external_lex_state = 2},
  [597] = {.lex_state = 149, .external_lex_state = 2},
  [598] = {.lex_state = 149, .external_lex_state = 2},
  [599] = {.lex_state = 149, .external_lex_state = 2},
  [600] = {.lex_state = 149, .external_lex_state = 2},
  [601] = {.lex_state = 149, .external_lex_state = 2},
  [602] = {.lex_state = 149, .external_lex_state = 2},
  [603] = {.lex_state = 149, .external_lex_state = 2},
  [604] = {.lex_state = 149, .external_lex_state = 2},
  [605] = {.lex_state = 149, .external_lex_state = 2},
  [606] = {.lex_state = 149, .external_lex_state = 2},
  [607] = {.lex_state = 149, .external_lex_state = 2},
  [608] = {.lex_state = 149, .external_lex_state = 2},
  [609] = {.lex_state = 149, .external_lex_state = 2},
  [610] = {.lex_state = 149, .external_lex_state = 2},
  [611] = {.lex_state = 149, .external_lex_state = 2},
  [612] = {.lex_state = 149, .external_lex_state = 2},
  [613] = {.lex_state = 149, .external_lex_state = 2},
  [614] = {.lex_state = 149, .external_lex_state = 2},
  [615] = {.lex_state = 149, .external_lex_state = 2},
  [616] = {.lex_state = 149, .external_lex_state = 2},
  [617] = {.lex_state = 149, .external_lex_state = 2},
  [618] = {.lex_state = 149, .external_lex_state = 2},
  [619] = {.lex_state = 149, .external_lex_state = 2},
  [620] = {.lex_state = 149, .external_lex_state = 2},
  [621] = {.lex_state = 149, .external_lex_state = 2},
  [622] = {.lex_state = 149, .external_lex_state = 2},
  [623] = {.lex_state = 149, .external_lex_state = 2},
  [624] = {.lex_state = 149, .external_lex_state = 2},
  [625] = {.lex_state = 149, .external_lex_state = 2},
  [626] = {.lex_state = 149, .external_lex_state = 2},
  [627] = {.lex_state = 149, .external_lex_state = 2},
  [628] = {.lex_state = 149, .external_lex_state = 2},
  [629] = {.lex_state = 149, .external_lex_state = 2},
  [630] = {.lex_state = 149, .external_lex_state = 2},
  [631] = {.lex_state = 149, .external_lex_state = 2},
  [632] = {.lex_state = 149, .external_lex_state = 2},
  [633] = {.lex_state = 149, .external_lex_state = 2},
  [634] = {.lex_state = 149, .external_lex_state = 2},
  [635] = {.lex_state = 149, .external_lex_state = 2},
  [636] = {.lex_state = 149, .external_lex_state = 2},
  [637] = {.lex_state = 149, .external_lex_state = 2},
  [638] = {.lex_state = 149, .external_lex_state = 2},
  [639] = {.lex_state = 149, .external_lex_state = 2},
  [640] = {.lex_state = 149, .external_lex_state = 2},
  [641] = {.lex_state = 149, .external_lex_state = 2},
  [642] = {.lex_state = 149, .external_lex_state = 2},
  [643] = {.lex_state = 149, .external_lex_state = 2},
  [644] = {.lex_state = 149, .external_lex_state = 2},
  [645] = {.lex_state = 149, .external_lex_state = 2},
  [646] = {.lex_state = 149, .external_lex_state = 2},
  [647] = {.lex_state = 149, .external_lex_state = 2},
  [648] = {.lex_state = 149, .external_lex_state = 2},
  [649] = {.lex_state = 149, .external_lex_state = 2},
  [650] = {.lex_state = 149, .external_lex_state = 2},
  [651] = {.lex_state = 149, .external_lex_state = 2},
  [652] = {.lex_state = 149, .external_lex_state = 2},
  [653] = {.lex_state = 149, .external_lex_state = 2},
  [654] = {.lex_state = 149, .external_lex_state = 2},
  [655] = {.lex_state = 149, .external_lex_state = 2},
  [656] = {.lex_state = 149, .external_lex_state = 2},
  [657] = {.lex_state = 149, .external_lex_state = 2},
  [658] = {.lex_state = 6, .external_lex_state = 4},
  [659] = {.lex_state = 6, .external_lex_state = 4},
  [660] = {.lex_state = 6, .external_lex_state = 4},
  [661] = {.lex_state = 5, .external_lex_state = 4},
  [662] = {.lex_state = 5, .external_lex_state = 4},
  [663] = {.lex_state = 5, .external_lex_state = 4},
  [664] = {.lex_state = 5, .external_lex_state = 4},
  [665] = {.lex_state = 5, .external_lex_state = 4},
  [666] = {.lex_state = 5, .external_lex_state = 4},
  [667] = {.lex_state = 6, .external_lex_state = 4},
  [668] = {.lex_state = 6, .external_lex_state = 4},
  [669] = {.lex_state = 6, .external_lex_state = 4},
  [670] = {.lex_state = 5, .external_lex_state = 4},
  [671] = {.lex_state = 5, .external_lex_state = 4},
  [672] = {.lex_state = 5, .external_lex_state = 4},
  [673] = {.lex_state = 5, .external_lex_state = 4},
  [674] = {.lex_state = 5, .external_lex_state = 4},
  [675] = {.lex_state = 5, .external_lex_state = 4},
  [676] = {.lex_state = 5, .external_lex_state = 4},
  [677] = {.lex_state = 149, .external_lex_state = 2},
  [678] = {.lex_state = 149, .external_lex_state = 2},
  [679] = {.lex_state = 5, .external_lex_state = 4},
  [680] = {.lex_state = 5, .external_lex_state = 4},
  [681] = {.lex_state = 5, .external_lex_state = 4},
  [682] = {.lex_state = 149, .external_lex_state = 2},
  [683] = {.lex_state = 5, .external_lex_state = 4},
  [684] = {.lex_state = 149, .external_lex_state = 2},
  [685] = {.lex_state = 149, .external_lex_state = 2},
  [686] = {.lex_state = 5, .external_lex_state = 4},
  [687] = {.lex_state = 149, .external_lex_state = 2},
  [688] = {.lex_state = 149, .external_lex_state = 2},
  [689] = {.lex_state = 5, .external_lex_state = 4},
  [690] = {.lex_state = 5, .external_lex_state = 4},
  [691] = {.lex_state = 5, .external_lex_state = 4},
  [692] = {.lex_state = 5, .external_lex_state = 4},
  [693] = {.lex_state = 5, .external_lex_state = 4},
  [694] = {.lex_state = 5, .external_lex_state = 4},
  [695] = {.lex_state = 5, .external_lex_state = 4},
  [696] = {.lex_state = 5, .external_lex_state = 4},
  [697] = {.lex_state = 5, .external_lex_state = 4},
  [698] = {.lex_state = 5, .external_lex_state = 3},
  [699] = {.lex_state = 5, .external_lex_state = 3},
  [700] = {.lex_state = 5, .external_lex_state = 3},
  [701] = {.lex_state = 5, .external_lex_state = 3},
  [702] = {.lex_state = 5, .external_lex_state = 3},
  [703] = {.lex_state = 5, .external_lex_state = 3},
  [704] = {.lex_state = 5, .external_lex_state = 4},
  [705] = {.lex_state = 5, .external_lex_state = 4},
  [706] = {.lex_state = 5, .external_lex_state = 4},
  [707] = {.lex_state = 5, .external_lex_state = 4},
  [708] = {.lex_state = 5, .external_lex_state = 4},
  [709] = {.lex_state = 5, .external_lex_state = 4},
  [710] = {.lex_state = 5, .external_lex_state = 4},
  [711] = {.lex_state = 149, .external_lex_state = 2},
  [712] = {.lex_state = 5, .external_lex_state = 3},
  [713] = {.lex_state = 149, .external_lex_state = 5},
  [714] = {.lex_state = 5, .external_lex_state = 3},
  [715] = {.lex_state = 6, .external_lex_state = 3},
  [716] = {.lex_state = 6, .external_lex_state = 3},
  [717] = {.lex_state = 149, .external_lex_state = 5},
  [718] = {.lex_state = 5, .external_lex_state = 4},
  [719] = {.lex_state = 5, .external_lex_state = 3},
  [720] = {.lex_state = 5, .external_lex_state = 4},
  [721] = {.lex_state = 149, .external_lex_state = 5},
  [722] = {.lex_state = 149, .external_lex_state = 5},
  [723] = {.lex_state = 5, .external_lex_state = 3},
  [724] = {.lex_state = 149, .external_lex_state = 5},
  [725] = {.lex_state = 149, .external_lex_state = 5},
  [726] = {.lex_state = 149, .external_lex_state = 5},
  [727] = {.lex_state = 149, .external_lex_state = 5},
  [728] = {.lex_state = 5, .external_lex_state = 3},
  [729] = {.lex_state = 5, .external_lex_state = 3},
  [730] = {.lex_state = 5, .external_lex_state = 4},
  [731] = {.lex_state = 5, .external_lex_state = 4},
  [732] = {.lex_state = 5, .external_lex_state = 4},
  [733] = {.lex_state = 149, .external_lex_state = 2},
  [734] = {.lex_state = 149, .external_lex_state = 2},
  [735] = {.lex_state = 5, .external_lex_state = 3},
  [736] = {.lex_state = 5, .external_lex_state = 3},
  [737] = {.lex_state = 5, .external_lex_state = 3},
  [738] = {.lex_state = 149, .external_lex_state = 2},
  [739] = {.lex_state = 149, .external_lex_state = 2},
  [740] = {.lex_state = 5, .external_lex_state = 3},
  [741] = {.lex_state = 5, .external_lex_state = 3},
  [742] = {.lex_state = 5, .external_lex_state = 3},
  [743] = {.lex_state = 5, .external_lex_state = 3},
  [744] = {.lex_state = 149, .external_lex_state = 2},
  [745] = {.lex_state = 149, .external_lex_state = 2},
  [746] = {.lex_state = 5, .external_lex_state = 3},
  [747] = {.lex_state = 149, .external_lex_state = 2},
  [748] = {.lex_state = 149, .external_lex_state = 5},
  [749] = {.lex_state = 5, .external_lex_state = 3},
  [750] = {.lex_state = 149, .external_lex_state = 2},
  [751] = {.lex_state = 149, .external_lex_state = 2},
  [752] = {.lex_state = 5, .external_lex_state = 3},
  [753] = {.lex_state = 149, .external_lex_state = 5},
  [754] = {.lex_state = 5, .external_lex_state = 3},
  [755] = {.lex_state = 149, .external_lex_state = 5},
  [756] = {.lex_state = 149, .external_lex_state = 2},
  [757] = {.lex_state = 149, .external_lex_state = 5},
  [758] = {.lex_state = 149, .external_lex_state = 5},
  [759] = {.lex_state = 5, .external_lex_state = 3},
  [760] = {.lex_state = 149, .external_lex_state = 5},
  [761] = {.lex_state = 149, .external_lex_state = 5},
  [762] = {.lex_state = 149, .external_lex_state = 5},
  [763] = {.lex_state = 5, .external_lex_state = 3},
  [764] = {.lex_state = 149, .external_lex_state = 5},
  [765] = {.lex_state = 149, .external_lex_state = 5},
  [766] = {.lex_state = 5, .external_lex_state = 3},
  [767] = {.lex_state = 149, .external_lex_state = 2},
  [768] = {.lex_state = 149, .external_lex_state = 5},
  [769] = {.lex_state = 149, .external_lex_state = 5},
  [770] = {.lex_state = 149, .external_lex_state = 2},
  [771] = {.lex_state = 5, .external_lex_state = 3},
  [772] = {.lex_state = 149, .external_lex_state = 2},
  [773] = {.lex_state = 149, .external_lex_state = 5},
  [774] = {.lex_state = 149, .external_lex_state = 5},
  [775] = {.lex_state = 5, .external_lex_state = 3},
  [776] = {.lex_state = 149, .external_lex_state = 5},
  [777] = {.lex_state = 5, .external_lex_state = 3},
  [778] = {.lex_state = 149, .external_lex_state = 2},
  [779] = {.lex_state = 149, .external_lex_state = 2},
  [780] = {.lex_state = 149, .external_lex_state = 2},
  [781] = {.lex_state = 149, .external_lex_state = 2},
  [782] = {.lex_state = 149, .external_lex_state = 2},
  [783] = {.lex_state = 149, .external_lex_state = 2},
  [784] = {.lex_state = 149, .external_lex_state = 2},
  [785] = {.lex_state = 149, .external_lex_state = 2},
  [786] = {.lex_state = 12, .external_lex_state = 2},
  [787] = {.lex_state = 149, .external_lex_state = 2},
  [788] = {.lex_state = 149, .external_lex_state = 2},
  [789] = {.lex_state = 149, .external_lex_state = 2},
  [790] = {.lex_state = 149, .external_lex_state = 2},
  [791] = {.lex_state = 149, .external_lex_state = 2},
  [792] = {.lex_state = 12, .external_lex_state = 2},
  [793] = {.lex_state = 149, .external_lex_state = 2},
  [794] = {.lex_state = 149, .external_lex_state = 2},
  [795] = {.lex_state = 149, .external_lex_state = 2},
  [796] = {.lex_state = 149, .external_lex_state = 2},
  [797] = {.lex_state = 149, .external_lex_state = 2},
  [798] = {.lex_state = 149, .external_lex_state = 2},
  [799] = {.lex_state = 149, .external_lex_state = 2},
  [800] = {.lex_state = 149, .external_lex_state = 2},
  [801] = {.lex_state = 149, .external_lex_state = 2},
  [802] = {.lex_state = 149, .external_lex_state = 2},
  [803] = {.lex_state = 149, .external_lex_state = 2},
  [804] = {.lex_state = 149, .external_lex_state = 2},
  [805] = {.lex_state = 149, .external_lex_state = 2},
  [806] = {.lex_state = 12, .external_lex_state = 2},
  [807] = {.lex_state = 149, .external_lex_state = 2},
  [808] = {.lex_state = 149, .external_lex_state = 2},
  [809] = {.lex_state = 149, .external_lex_state = 2},
  [810] = {.lex_state = 149, .external_lex_state = 2},
  [811] = {.lex_state = 149, .external_lex_state = 2},
  [812] = {.lex_state = 149, .external_lex_state = 2},
  [813] = {.lex_state = 149, .external_lex_state = 2},
  [814] = {.lex_state = 149, .external_lex_state = 2},
  [815] = {.lex_state = 149, .external_lex_state = 2},
  [816] = {.lex_state = 149, .external_lex_state = 2},
  [817] = {.lex_state = 12, .external_lex_state = 2},
  [818] = {.lex_state = 149, .external_lex_state = 2},
  [819] = {.lex_state = 149, .external_lex_state = 2},
  [820] = {.lex_state = 149, .external_lex_state = 2},
  [821] = {.lex_state = 12, .external_lex_state = 2},
  [822] = {.lex_state = 149, .external_lex_state = 2},
  [823] = {.lex_state = 149, .external_lex_state = 2},
  [824] = {.lex_state = 149, .external_lex_state = 2},
  [825] = {.lex_state = 149, .external_lex_state = 2},
  [826] = {.lex_state = 149, .external_lex_state = 2},
  [827] = {.lex_state = 149, .external_lex_state = 2},
  [828] = {.lex_state = 149, .external_lex_state = 2},
  [829] = {.lex_state = 149, .external_lex_state = 2},
  [830] = {.lex_state = 149, .external_lex_state = 2},
  [831] = {.lex_state = 149, .external_lex_state = 2},
  [832] = {.lex_state = 149, .external_lex_state = 2},
  [833] = {.lex_state = 149, .external_lex_state = 2},
  [834] = {.lex_state = 149, .external_lex_state = 2},
  [835] = {.lex_state = 149, .external_lex_state = 2},
  [836] = {.lex_state = 149, .external_lex_state = 2},
  [837] = {.lex_state = 149, .external_lex_state = 2},
  [838] = {.lex_state = 149, .external_lex_state = 2},
  [839] = {.lex_state = 149, .external_lex_state = 2},
  [840] = {.lex_state = 149, .external_lex_state = 2},
  [841] = {.lex_state = 149, .external_lex_state = 2},
  [842] = {.lex_state = 149, .external_lex_state = 2},
  [843] = {.lex_state = 149, .external_lex_state = 2},
  [844] = {.lex_state = 149, .external_lex_state = 2},
  [845] = {.lex_state = 149, .external_lex_state = 2},
  [846] = {.lex_state = 149, .external_lex_state = 2},
  [847] = {.lex_state = 149, .external_lex_state = 2},
  [848] = {.lex_state = 149, .external_lex_state = 2},
  [849] = {.lex_state = 149, .external_lex_state = 2},
  [850] = {.lex_state = 149, .external_lex_state = 2},
  [851] = {.lex_state = 149, .external_lex_state = 2},
  [852] = {.lex_state = 149, .external_lex_state = 2},
  [853] = {.lex_state = 149, .external_lex_state = 2},
  [854] = {.lex_state = 149, .external_lex_state = 2},
  [855] = {.lex_state = 149, .external_lex_state = 2},
  [856] = {.lex_state = 149, .external_lex_state = 2},
  [857] = {.lex_state = 149, .external_lex_state = 2},
  [858] = {.lex_state = 149, .external_lex_state = 2},
  [859] = {.lex_state = 149, .external_lex_state = 2},
  [860] = {.lex_state = 149, .external_lex_state = 2},
  [861] = {.lex_state = 149, .external_lex_state = 2},
  [862] = {.lex_state = 149, .external_lex_state = 2},
  [863] = {.lex_state = 149, .external_lex_state = 2},
  [864] = {.lex_state = 149, .external_lex_state = 2},
  [865] = {.lex_state = 149, .external_lex_state = 2},
  [866] = {.lex_state = 149, .external_lex_state = 2},
  [867] = {.lex_state = 149, .external_lex_state = 2},
  [868] = {.lex_state = 149, .external_lex_state = 2},
  [869] = {.lex_state = 149, .external_lex_state = 2},
  [870] = {.lex_state = 149, .external_lex_state = 2},
  [871] = {.lex_state = 149, .external_lex_state = 2},
  [872] = {.lex_state = 149, .external_lex_state = 2},
  [873] = {.lex_state = 149, .external_lex_state = 2},
  [874] = {.lex_state = 149, .external_lex_state = 2},
  [875] = {.lex_state = 149, .external_lex_state = 2},
  [876] = {.lex_state = 149, .external_lex_state = 2},
  [877] = {.lex_state = 149, .external_lex_state = 2},
  [878] = {.lex_state = 149, .external_lex_state = 2},
  [879] = {.lex_state = 149, .external_lex_state = 2},
  [880] = {.lex_state = 149, .external_lex_state = 2},
  [881] = {.lex_state = 149, .external_lex_state = 2},
  [882] = {.lex_state = 149, .external_lex_state = 2},
  [883] = {.lex_state = 149, .external_lex_state = 2},
  [884] = {.lex_state = 149, .external_lex_state = 2},
  [885] = {.lex_state = 149, .external_lex_state = 2},
  [886] = {.lex_state = 149, .external_lex_state = 2},
  [887] = {.lex_state = 149, .external_lex_state = 2},
  [888] = {.lex_state = 149, .external_lex_state = 2},
  [889] = {.lex_state = 149, .external_lex_state = 2},
  [890] = {.lex_state = 149, .external_lex_state = 2},
  [891] = {.lex_state = 149, .external_lex_state = 2},
  [892] = {.lex_state = 149, .external_lex_state = 2},
  [893] = {.lex_state = 149, .external_lex_state = 2},
  [894] = {.lex_state = 149, .external_lex_state = 2},
  [895] = {.lex_state = 149, .external_lex_state = 2},
  [896] = {.lex_state = 149, .external_lex_state = 2},
  [897] = {.lex_state = 149, .external_lex_state = 2},
  [898] = {.lex_state = 149, .external_lex_state = 2},
  [899] = {.lex_state = 149, .external_lex_state = 2},
  [900] = {.lex_state = 149, .external_lex_state = 2},
  [901] = {.lex_state = 149, .external_lex_state = 2},
  [902] = {.lex_state = 149, .external_lex_state = 2},
  [903] = {.lex_state = 149, .external_lex_state = 2},
  [904] = {.lex_state = 149, .external_lex_state = 2},
  [905] = {.lex_state = 149, .external_lex_state = 2},
  [906] = {.lex_state = 12, .external_lex_state = 2},
  [907] = {.lex_state = 12, .external_lex_state = 2},
  [908] = {.lex_state = 12, .external_lex_state = 2},
  [909] = {.lex_state = 12, .external_lex_state = 2},
  [910] = {.lex_state = 12, .external_lex_state = 2},
  [911] = {.lex_state = 12, .external_lex_state = 2},
  [912] = {.lex_state = 12, .external_lex_state = 2},
  [913] = {.lex_state = 12, .external_lex_state = 2},
  [914] = {.lex_state = 12, .external_lex_state = 2},
  [915] = {.lex_state = 12, .external_lex_state = 2},
  [916] = {.lex_state = 12, .external_lex_state = 2},
  [917] = {.lex_state = 149, .external_lex_state = 2},
  [918] = {.lex_state = 149, .external_lex_state = 2},
  [919] = {.lex_state = 149, .external_lex_state = 2},
  [920] = {.lex_state = 149, .external_lex_state = 2},
  [921] = {.lex_state = 149, .external_lex_state = 2},
  [922] = {.lex_state = 149, .external_lex_state = 2},
  [923] = {.lex_state = 149, .external_lex_state = 2},
  [924] = {.lex_state = 149, .external_lex_state = 2},
  [925] = {.lex_state = 149, .external_lex_state = 2},
  [926] = {.lex_state = 149, .external_lex_state = 2},
  [927] = {.lex_state = 149, .external_lex_state = 2},
  [928] = {.lex_state = 149, .external_lex_state = 2},
  [929] = {.lex_state = 149, .external_lex_state = 2},
  [930] = {.lex_state = 149, .external_lex_state = 2},
  [931] = {.lex_state = 12, .external_lex_state = 2},
  [932] = {.lex_state = 12, .external_lex_state = 2},
  [933] = {.lex_state = 12, .external_lex_state = 2},
  [934] = {.lex_state = 12, .external_lex_state = 2},
  [935] = {.lex_state = 12, .external_lex_state = 2},
  [936] = {.lex_state = 12, .external_lex_state = 2},
  [937] = {.lex_state = 12, .external_lex_state = 2},
  [938] = {.lex_state = 12, .external_lex_state = 2},
  [939] = {.lex_state = 12, .external_lex_state = 2},
  [940] = {.lex_state = 12, .external_lex_state = 2},
  [941] = {.lex_state = 12, .external_lex_state = 2},
  [942] = {.lex_state = 12, .external_lex_state = 2},
  [943] = {.lex_state = 12, .external_lex_state = 2},
  [944] = {.lex_state = 12, .external_lex_state = 2},
  [945] = {.lex_state = 12, .external_lex_state = 2},
  [946] = {.lex_state = 12, .external_lex_state = 2},
  [947] = {.lex_state = 12, .external_lex_state = 2},
  [948] = {.lex_state = 14, .external_lex_state = 2},
  [949] = {.lex_state = 14, .external_lex_state = 2},
  [950] = {.lex_state = 14, .external_lex_state = 2},
  [951] = {.lex_state = 12, .external_lex_state = 2},
  [952] = {.lex_state = 12, .external_lex_state = 2},
  [953] = {.lex_state = 16, .external_lex_state = 2},
  [954] = {.lex_state = 12, .external_lex_state = 2},
  [955] = {.lex_state = 12, .external_lex_state = 2},
  [956] = {.lex_state = 12, .external_lex_state = 2},
  [957] = {.lex_state = 12, .external_lex_state = 2},
  [958] = {.lex_state = 12, .external_lex_state = 2},
  [959] = {.lex_state = 12, .external_lex_state = 2},
  [960] = {.lex_state = 12, .external_lex_state = 2},
  [961] = {.lex_state = 12, .external_lex_state = 2},
  [962] = {.lex_state = 12, .external_lex_state = 2},
  [963] = {.lex_state = 12, .external_lex_state = 2},
  [964] = {.lex_state = 12, .external_lex_state = 2},
  [965] = {.lex_state = 12, .external_lex_state = 2},
  [966] = {.lex_state = 12, .external_lex_state = 2},
  [967] = {.lex_state = 12, .external_lex_state = 2},
  [968] = {.lex_state = 12, .external_lex_state = 2},
  [969] = {.lex_state = 12, .external_lex_state = 2},
  [970] = {.lex_state = 12, .external_lex_state = 2},
  [971] = {.lex_state = 12, .external_lex_state = 2},
  [972] = {.lex_state = 12, .external_lex_state = 2},
  [973] = {.lex_state = 12, .external_lex_state = 2},
  [974] = {.lex_state = 12, .external_lex_state = 2},
  [975] = {.lex_state = 12, .external_lex_state = 2},
  [976] = {.lex_state = 12, .external_lex_state = 2},
  [977] = {.lex_state = 12, .external_lex_state = 2},
  [978] = {.lex_state = 12, .external_lex_state = 2},
  [979] = {.lex_state = 12, .external_lex_state = 2},
  [980] = {.lex_state = 12, .external_lex_state = 2},
  [981] = {.lex_state = 12, .external_lex_state = 2},
  [982] = {.lex_state = 12, .external_lex_state = 2},
  [983] = {.lex_state = 12, .external_lex_state = 2},
  [984] = {.lex_state = 12, .external_lex_state = 2},
  [985] = {.lex_state = 12, .external_lex_state = 2},
  [986] = {.lex_state = 12, .external_lex_state = 2},
  [987] = {.lex_state = 12, .external_lex_state = 2},
  [988] = {.lex_state = 12, .external_lex_state = 2},
  [989] = {.lex_state = 12, .external_lex_state = 2},
  [990] = {.lex_state = 12, .external_lex_state = 2},
  [991] = {.lex_state = 12, .external_lex_state = 2},
  [992] = {.lex_state = 12, .external_lex_state = 2},
  [993] = {.lex_state = 12, .external_lex_state = 2},
  [994] = {.lex_state = 12, .external_lex_state = 2},
  [995] = {.lex_state = 12, .external_lex_state = 2},
  [996] = {.lex_state = 12, .external_lex_state = 2},
  [997] = {.lex_state = 12, .external_lex_state = 2},
  [998] = {.lex_state = 12, .external_lex_state = 2},
  [999] = {.lex_state = 12, .external_lex_state = 2},
  [1000] = {.lex_state = 12, .external_lex_state = 2},
  [1001] = {.lex_state = 12, .external_lex_state = 2},
  [1002] = {.lex_state = 12, .external_lex_state = 2},
  [1003] = {.lex_state = 12, .external_lex_state = 2},
  [1004] = {.lex_state = 12, .external_lex_state = 2},
  [1005] = {.lex_state = 12, .external_lex_state = 2},
  [1006] = {.lex_state = 12, .external_lex_state = 2},
  [1007] = {.lex_state = 12, .external_lex_state = 2},
  [1008] = {.lex_state = 12, .external_lex_state = 2},
  [1009] = {.lex_state = 12, .external_lex_state = 2},
  [1010] = {.lex_state = 12, .external_lex_state = 2},
  [1011] = {.lex_state = 12, .external_lex_state = 2},
  [1012] = {.lex_state = 12, .external_lex_state = 2},
  [1013] = {.lex_state = 12, .external_lex_state = 2},
  [1014] = {.lex_state = 12, .external_lex_state = 2},
  [1015] = {.lex_state = 12, .external_lex_state = 2},
  [1016] = {.lex_state = 12, .external_lex_state = 2},
  [1017] = {.lex_state = 12, .external_lex_state = 2},
  [1018] = {.lex_state = 12, .external_lex_state = 2},
  [1019] = {.lex_state = 12, .external_lex_state = 2},
  [1020] = {.lex_state = 12, .external_lex_state = 2},
  [1021] = {.lex_state = 12, .external_lex_state = 2},
  [1022] = {.lex_state = 12, .external_lex_state = 2},
  [1023] = {.lex_state = 12, .external_lex_state = 2},
  [1024] = {.lex_state = 12, .external_lex_state = 2},
  [1025] = {.lex_state = 12, .external_lex_state = 2},
  [1026] = {.lex_state = 12, .external_lex_state = 2},
  [1027] = {.lex_state = 12, .external_lex_state = 2},
  [1028] = {.lex_state = 12, .external_lex_state = 2},
  [1029] = {.lex_state = 12, .external_lex_state = 2},
  [1030] = {.lex_state = 12, .external_lex_state = 2},
  [1031] = {.lex_state = 12, .external_lex_state = 2},
  [1032] = {.lex_state = 12, .external_lex_state = 2},
  [1033] = {.lex_state = 12, .external_lex_state = 2},
  [1034] = {.lex_state = 12, .external_lex_state = 2},
  [1035] = {.lex_state = 12, .external_lex_state = 2},
  [1036] = {.lex_state = 12, .external_lex_state = 2},
  [1037] = {.lex_state = 12, .external_lex_state = 2},
  [1038] = {.lex_state = 12, .external_lex_state = 2},
  [1039] = {.lex_state = 12, .external_lex_state = 2},
  [1040] = {.lex_state = 12, .external_lex_state = 2},
  [1041] = {.lex_state = 12, .external_lex_state = 2},
  [1042] = {.lex_state = 12, .external_lex_state = 2},
  [1043] = {.lex_state = 12, .external_lex_state = 2},
  [1044] = {.lex_state = 12, .external_lex_state = 2},
  [1045] = {.lex_state = 12, .external_lex_state = 2},
  [1046] = {.lex_state = 12, .external_lex_state = 2},
  [1047] = {.lex_state = 12, .external_lex_state = 2},
  [1048] = {.lex_state = 12, .external_lex_state = 2},
  [1049] = {.lex_state = 12, .external_lex_state = 2},
  [1050] = {.lex_state = 12, .external_lex_state = 2},
  [1051] = {.lex_state = 12, .external_lex_state = 2},
  [1052] = {.lex_state = 12, .external_lex_state = 2},
  [1053] = {.lex_state = 12, .external_lex_state = 2},
  [1054] = {.lex_state = 12, .external_lex_state = 2},
  [1055] = {.lex_state = 12, .external_lex_state = 2},
  [1056] = {.lex_state = 12, .external_lex_state = 2},
  [1057] = {.lex_state = 12, .external_lex_state = 2},
  [1058] = {.lex_state = 12, .external_lex_state = 2},
  [1059] = {.lex_state = 12, .external_lex_state = 2},
  [1060] = {.lex_state = 12, .external_lex_state = 2},
  [1061] = {.lex_state = 12, .external_lex_state = 2},
  [1062] = {.lex_state = 12, .external_lex_state = 2},
  [1063] = {.lex_state = 12, .external_lex_state = 2},
  [1064] = {.lex_state = 12, .external_lex_state = 2},
  [1065] = {.lex_state = 12, .external_lex_state = 2},
  [1066] = {.lex_state = 12, .external_lex_state = 2},
  [1067] = {.lex_state = 12, .external_lex_state = 2},
  [1068] = {.lex_state = 12, .external_lex_state = 2},
  [1069] = {.lex_state = 12, .external_lex_state = 2},
  [1070] = {.lex_state = 12, .external_lex_state = 2},
  [1071] = {.lex_state = 12, .external_lex_state = 2},
  [1072] = {.lex_state = 12, .external_lex_state = 2},
  [1073] = {.lex_state = 12, .external_lex_state = 2},
  [1074] = {.lex_state = 12, .external_lex_state = 2},
  [1075] = {.lex_state = 12, .external_lex_state = 2},
  [1076] = {.lex_state = 12, .external_lex_state = 2},
  [1077] = {.lex_state = 12, .external_lex_state = 2},
  [1078] = {.lex_state = 12, .external_lex_state = 2},
  [1079] = {.lex_state = 12, .external_lex_state = 2},
  [1080] = {.lex_state = 12, .external_lex_state = 2},
  [1081] = {.lex_state = 12, .external_lex_state = 2},
  [1082] = {.lex_state = 12, .external_lex_state = 2},
  [1083] = {.lex_state = 12, .external_lex_state = 2},
  [1084] = {.lex_state = 12, .external_lex_state = 2},
  [1085] = {.lex_state = 12, .external_lex_state = 2},
  [1086] = {.lex_state = 12, .external_lex_state = 2},
  [1087] = {.lex_state = 12, .external_lex_state = 2},
  [1088] = {.lex_state = 12, .external_lex_state = 2},
  [1089] = {.lex_state = 12, .external_lex_state = 2},
  [1090] = {.lex_state = 12, .external_lex_state = 2},
  [1091] = {.lex_state = 12, .external_lex_state = 2},
  [1092] = {.lex_state = 12, .external_lex_state = 2},
  [1093] = {.lex_state = 12, .external_lex_state = 2},
  [1094] = {.lex_state = 12, .external_lex_state = 2},
  [1095] = {.lex_state = 12, .external_lex_state = 2},
  [1096] = {.lex_state = 12, .external_lex_state = 2},
  [1097] = {.lex_state = 12, .external_lex_state = 2},
  [1098] = {.lex_state = 12, .external_lex_state = 2},
  [1099] = {.lex_state = 12, .external_lex_state = 2},
  [1100] = {.lex_state = 12, .external_lex_state = 2},
  [1101] = {.lex_state = 12, .external_lex_state = 2},
  [1102] = {.lex_state = 12, .external_lex_state = 2},
  [1103] = {.lex_state = 12, .external_lex_state = 2},
  [1104] = {.lex_state = 12, .external_lex_state = 2},
  [1105] = {.lex_state = 12, .external_lex_state = 2},
  [1106] = {.lex_state = 12, .external_lex_state = 2},
  [1107] = {.lex_state = 12, .external_lex_state = 2},
  [1108] = {.lex_state = 12, .external_lex_state = 2},
  [1109] = {.lex_state = 12, .external_lex_state = 2},
  [1110] = {.lex_state = 12, .external_lex_state = 2},
  [1111] = {.lex_state = 12, .external_lex_state = 2},
  [1112] = {.lex_state = 12, .external_lex_state = 2},
  [1113] = {.lex_state = 12, .external_lex_state = 2},
  [1114] = {.lex_state = 12, .external_lex_state = 2},
  [1115] = {.lex_state = 12, .external_lex_state = 2},
  [1116] = {.lex_state = 12, .external_lex_state = 2},
  [1117] = {.lex_state = 12, .external_lex_state = 2},
  [1118] = {.lex_state = 12, .external_lex_state = 2},
  [1119] = {.lex_state = 12, .external_lex_state = 2},
  [1120] = {.lex_state = 12, .external_lex_state = 2},
  [1121] = {.lex_state = 12, .external_lex_state = 2},
  [1122] = {.lex_state = 12, .external_lex_state = 2},
  [1123] = {.lex_state = 12, .external_lex_state = 2},
  [1124] = {.lex_state = 12, .external_lex_state = 2},
  [1125] = {.lex_state = 13, .external_lex_state = 2},
  [1126] = {.lex_state = 13, .external_lex_state = 2},
  [1127] = {.lex_state = 13, .external_lex_state = 2},
  [1128] = {.lex_state = 13, .external_lex_state = 2},
  [1129] = {.lex_state = 13, .external_lex_state = 2},
  [1130] = {.lex_state = 13, .external_lex_state = 2},
  [1131] = {.lex_state = 13, .external_lex_state = 2},
  [1132] = {.lex_state = 13, .external_lex_state = 2},
  [1133] = {.lex_state = 13, .external_lex_state = 2},
  [1134] = {.lex_state = 13, .external_lex_state = 2},
  [1135] = {.lex_state = 13, .external_lex_state = 2},
  [1136] = {.lex_state = 13, .external_lex_state = 2},
  [1137] = {.lex_state = 5, .external_lex_state = 4},
  [1138] = {.lex_state = 5, .external_lex_state = 4},
  [1139] = {.lex_state = 5, .external_lex_state = 4},
  [1140] = {.lex_state = 6, .external_lex_state = 4},
  [1141] = {.lex_state = 5, .external_lex_state = 4},
  [1142] = {.lex_state = 5, .external_lex_state = 4},
  [1143] = {.lex_state = 5, .external_lex_state = 4},
  [1144] = {.lex_state = 6, .external_lex_state = 4},
  [1145] = {.lex_state = 6, .external_lex_state = 4},
  [1146] = {.lex_state = 5, .external_lex_state = 3},
  [1147] = {.lex_state = 5, .external_lex_state = 3},
  [1148] = {.lex_state = 5, .external_lex_state = 3},
  [1149] = {.lex_state = 5, .external_lex_state = 3},
  [1150] = {.lex_state = 5, .external_lex_state = 3},
  [1151] = {.lex_state = 13, .external_lex_state = 2},
  [1152] = {.lex_state = 13, .external_lex_state = 2},
  [1153] = {.lex_state = 5, .external_lex_state = 4},
  [1154] = {.lex_state = 5, .external_lex_state = 4},
  [1155] = {.lex_state = 5, .external_lex_state = 4},
  [1156] = {.lex_state = 6, .external_lex_state = 4},
  [1157] = {.lex_state = 5, .external_lex_state = 4},
  [1158] = {.lex_state = 5, .external_lex_state = 4},
  [1159] = {.lex_state = 6, .external_lex_state = 4},
  [1160] = {.lex_state = 5, .external_lex_state = 4},
  [1161] = {.lex_state = 5, .external_lex_state = 4},
  [1162] = {.lex_state = 5, .external_lex_state = 4},
  [1163] = {.lex_state = 5, .external_lex_state = 4},
  [1164] = {.lex_state = 5, .external_lex_state = 4},
  [1165] = {.lex_state = 5, .external_lex_state = 3},
  [1166] = {.lex_state = 6, .external_lex_state = 4},
  [1167] = {.lex_state = 6, .external_lex_state = 3},
  [1168] = {.lex_state = 5, .external_lex_state = 4},
  [1169] = {.lex_state = 6, .external_lex_state = 3},
  [1170] = {.lex_state = 6, .external_lex_state = 3},
  [1171] = {.lex_state = 6, .external_lex_state = 3},
  [1172] = {.lex_state = 6, .external_lex_state = 3},
  [1173] = {.lex_state = 6, .external_lex_state = 3},
  [1174] = {.lex_state = 6, .external_lex_state = 3},
  [1175] = {.lex_state = 6, .external_lex_state = 3},
  [1176] = {.lex_state = 6, .external_lex_state = 3},
  [1177] = {.lex_state = 6, .external_lex_state = 3},
  [1178] = {.lex_state = 5, .external_lex_state = 3},
  [1179] = {.lex_state = 5, .external_lex_state = 4},
  [1180] = {.lex_state = 6, .external_lex_state = 3},
  [1181] = {.lex_state = 5, .external_lex_state = 3},
  [1182] = {.lex_state = 5, .external_lex_state = 3},
  [1183] = {.lex_state = 6, .external_lex_state = 3},
  [1184] = {.lex_state = 5, .external_lex_state = 4},
  [1185] = {.lex_state = 5, .external_lex_state = 4},
  [1186] = {.lex_state = 5, .external_lex_state = 3},
  [1187] = {.lex_state = 5, .external_lex_state = 3},
  [1188] = {.lex_state = 5, .external_lex_state = 3},
  [1189] = {.lex_state = 5, .external_lex_state = 4},
  [1190] = {.lex_state = 5, .external_lex_state = 4},
  [1191] = {.lex_state = 5, .external_lex_state = 4},
  [1192] = {.lex_state = 5, .external_lex_state = 4},
  [1193] = {.lex_state = 5, .external_lex_state = 3},
  [1194] = {.lex_state = 6, .external_lex_state = 4},
  [1195] = {.lex_state = 5, .external_lex_state = 4},
  [1196] = {.lex_state = 6, .external_lex_state = 3},
  [1197] = {.lex_state = 5, .external_lex_state = 3},
  [1198] = {.lex_state = 5, .external_lex_state = 4},
  [1199] = {.lex_state = 5, .external_lex_state = 4},
  [1200] = {.lex_state = 6, .external_lex_state = 3},
  [1201] = {.lex_state = 6, .external_lex_state = 3},
  [1202] = {.lex_state = 5, .external_lex_state = 4},
  [1203] = {.lex_state = 5, .external_lex_state = 4},
  [1204] = {.lex_state = 5, .external_lex_state = 4},
  [1205] = {.lex_state = 5, .external_lex_state = 3},
  [1206] = {.lex_state = 5, .external_lex_state = 4},
  [1207] = {.lex_state = 6, .external_lex_state = 4},
  [1208] = {.lex_state = 5, .external_lex_state = 4},
  [1209] = {.lex_state = 5, .external_lex_state = 4},
  [1210] = {.lex_state = 5, .external_lex_state = 3},
  [1211] = {.lex_state = 5, .external_lex_state = 3},
  [1212] = {.lex_state = 5, .external_lex_state = 4},
  [1213] = {.lex_state = 149, .external_lex_state = 2},
  [1214] = {.lex_state = 5, .external_lex_state = 4},
  [1215] = {.lex_state = 5, .external_lex_state = 3},
  [1216] = {.lex_state = 5, .external_lex_state = 3},
  [1217] = {.lex_state = 5, .external_lex_state = 3},
  [1218] = {.lex_state = 5, .external_lex_state = 3},
  [1219] = {.lex_state = 5, .external_lex_state = 3},
  [1220] = {.lex_state = 5, .external_lex_state = 3},
  [1221] = {.lex_state = 5, .external_lex_state = 3},
  [1222] = {.lex_state = 5, .external_lex_state = 3},
  [1223] = {.lex_state = 5, .external_lex_state = 3},
  [1224] = {.lex_state = 5, .external_lex_state = 3},
  [1225] = {.lex_state = 5, .external_lex_state = 3},
  [1226] = {.lex_state = 5, .external_lex_state = 3},
  [1227] = {.lex_state = 5, .external_lex_state = 3},
  [1228] = {.lex_state = 5, .external_lex_state = 3},
  [1229] = {.lex_state = 5, .external_lex_state = 3},
  [1230] = {.lex_state = 5, .external_lex_state = 3},
  [1231] = {.lex_state = 149, .external_lex_state = 2},
  [1232] = {.lex_state = 149, .external_lex_state = 2},
  [1233] = {.lex_state = 5, .external_lex_state = 3},
  [1234] = {.lex_state = 5, .external_lex_state = 3},
  [1235] = {.lex_state = 5, .external_lex_state = 3},
  [1236] = {.lex_state = 5, .external_lex_state = 4},
  [1237] = {.lex_state = 5, .external_lex_state = 4},
  [1238] = {.lex_state = 149, .external_lex_state = 2},
  [1239] = {.lex_state = 5, .external_lex_state = 4},
  [1240] = {.lex_state = 5, .external_lex_state = 4},
  [1241] = {.lex_state = 5, .external_lex_state = 3},
  [1242] = {.lex_state = 6, .external_lex_state = 3},
  [1243] = {.lex_state = 5, .external_lex_state = 3},
  [1244] = {.lex_state = 5, .external_lex_state = 3},
  [1245] = {.lex_state = 5, .external_lex_state = 3},
  [1246] = {.lex_state = 5, .external_lex_state = 3},
  [1247] = {.lex_state = 5, .external_lex_state = 3},
  [1248] = {.lex_state = 149, .external_lex_state = 2},
  [1249] = {.lex_state = 5, .external_lex_state = 3},
  [1250] = {.lex_state = 6, .external_lex_state = 3},
  [1251] = {.lex_state = 5, .external_lex_state = 3},
  [1252] = {.lex_state = 5, .external_lex_state = 3},
  [1253] = {.lex_state = 5, .external_lex_state = 3},
  [1254] = {.lex_state = 5, .external_lex_state = 3},
  [1255] = {.lex_state = 5, .external_lex_state = 3},
  [1256] = {.lex_state = 149, .external_lex_state = 2},
  [1257] = {.lex_state = 5, .external_lex_state = 3},
  [1258] = {.lex_state = 5, .external_lex_state = 4},
  [1259] = {.lex_state = 5, .external_lex_state = 4},
  [1260] = {.lex_state = 5, .external_lex_state = 3},
  [1261] = {.lex_state = 5, .external_lex_state = 3},
  [1262] = {.lex_state = 5, .external_lex_state = 3},
  [1263] = {.lex_state = 5, .external_lex_state = 3},
  [1264] = {.lex_state = 5, .external_lex_state = 4},
  [1265] = {.lex_state = 149, .external_lex_state = 2},
  [1266] = {.lex_state = 5, .external_lex_state = 3},
  [1267] = {.lex_state = 149, .external_lex_state = 2},
  [1268] = {.lex_state = 5, .external_lex_state = 4},
  [1269] = {.lex_state = 5, .external_lex_state = 4},
  [1270] = {.lex_state = 5, .external_lex_state = 3},
  [1271] = {.lex_state = 5, .external_lex_state = 3},
  [1272] = {.lex_state = 5, .external_lex_state = 3},
  [1273] = {.lex_state = 5, .external_lex_state = 4},
  [1274] = {.lex_state = 5, .external_lex_state = 3},
  [1275] = {.lex_state = 5, .external_lex_state = 3},
  [1276] = {.lex_state = 5, .external_lex_state = 4},
  [1277] = {.lex_state = 5, .external_lex_state = 4},
  [1278] = {.lex_state = 5, .external_lex_state = 4},
  [1279] = {.lex_state = 5, .external_lex_state = 3},
  [1280] = {.lex_state = 149, .external_lex_state = 2},
  [1281] = {.lex_state = 6, .external_lex_state = 3},
  [1282] = {.lex_state = 5, .external_lex_state = 3},
  [1283] = {.lex_state = 5, .external_lex_state = 4},
  [1284] = {.lex_state = 5, .external_lex_state = 3},
  [1285] = {.lex_state = 5, .external_lex_state = 4},
  [1286] = {.lex_state = 5, .external_lex_state = 3},
  [1287] = {.lex_state = 5, .external_lex_state = 4},
  [1288] = {.lex_state = 5, .external_lex_state = 4},
  [1289] = {.lex_state = 5, .external_lex_state = 3},
  [1290] = {.lex_state = 5, .external_lex_state = 4},
  [1291] = {.lex_state = 5, .external_lex_state = 3},
  [1292] = {.lex_state = 5, .external_lex_state = 3},
  [1293] = {.lex_state = 5, .external_lex_state = 4},
  [1294] = {.lex_state = 5, .external_lex_state = 4},
  [1295] = {.lex_state = 5, .external_lex_state = 3},
  [1296] = {.lex_state = 5, .external_lex_state = 4},
  [1297] = {.lex_state = 5, .external_lex_state = 4},
  [1298] = {.lex_state = 5, .external_lex_state = 4},
  [1299] = {.lex_state = 5, .external_lex_state = 4},
  [1300] = {.lex_state = 5, .external_lex_state = 3},
  [1301] = {.lex_state = 5, .external_lex_state = 4},
  [1302] = {.lex_state = 5, .external_lex_state = 4},
  [1303] = {.lex_state = 5, .external_lex_state = 4},
  [1304] = {.lex_state = 5, .external_lex_state = 4},
  [1305] = {.lex_state = 5, .external_lex_state = 4},
  [1306] = {.lex_state = 5, .external_lex_state = 4},
  [1307] = {.lex_state = 5, .external_lex_state = 3},
  [1308] = {.lex_state = 5, .external_lex_state = 4},
  [1309] = {.lex_state = 5, .external_lex_state = 4},
  [1310] = {.lex_state = 5, .external_lex_state = 4},
  [1311] = {.lex_state = 5, .external_lex_state = 4},
  [1312] = {.lex_state = 5, .external_lex_state = 4},
  [1313] = {.lex_state = 5, .external_lex_state = 3},
  [1314] = {.lex_state = 5, .external_lex_state = 4},
  [1315] = {.lex_state = 5, .external_lex_state = 4},
  [1316] = {.lex_state = 5, .external_lex_state = 3},
  [1317] = {.lex_state = 5, .external_lex_state = 4},
  [1318] = {.lex_state = 5, .external_lex_state = 3},
  [1319] = {.lex_state = 5, .external_lex_state = 4},
  [1320] = {.lex_state = 6, .external_lex_state = 3},
  [1321] = {.lex_state = 5, .external_lex_state = 3},
  [1322] = {.lex_state = 5, .external_lex_state = 3},
  [1323] = {.lex_state = 5, .external_lex_state = 3},
  [1324] = {.lex_state = 5, .external_lex_state = 4},
  [1325] = {.lex_state = 5, .external_lex_state = 4},
  [1326] = {.lex_state = 5, .external_lex_state = 4},
  [1327] = {.lex_state = 5, .external_lex_state = 3},
  [1328] = {.lex_state = 5, .external_lex_state = 3},
  [1329] = {.lex_state = 6, .external_lex_state = 3},
  [1330] = {.lex_state = 5, .external_lex_state = 4},
  [1331] = {.lex_state = 5, .external_lex_state = 3},
  [1332] = {.lex_state = 5, .external_lex_state = 3},
  [1333] = {.lex_state = 6, .external_lex_state = 3},
  [1334] = {.lex_state = 5, .external_lex_state = 3},
  [1335] = {.lex_state = 5, .external_lex_state = 3},
  [1336] = {.lex_state = 5, .external_lex_state = 4},
  [1337] = {.lex_state = 5, .external_lex_state = 3},
  [1338] = {.lex_state = 6, .external_lex_state = 3},
  [1339] = {.lex_state = 5, .external_lex_state = 3},
  [1340] = {.lex_state = 5, .external_lex_state = 3},
  [1341] = {.lex_state = 6, .external_lex_state = 3},
  [1342] = {.lex_state = 5, .external_lex_state = 4},
  [1343] = {.lex_state = 5, .external_lex_state = 3},
  [1344] = {.lex_state = 5, .external_lex_state = 3},
  [1345] = {.lex_state = 5, .external_lex_state = 4},
  [1346] = {.lex_state = 12, .external_lex_state = 2},
  [1347] = {.lex_state = 5, .external_lex_state = 3},
  [1348] = {.lex_state = 5, .external_lex_state = 3},
  [1349] = {.lex_state = 5, .external_lex_state = 3},
  [1350] = {.lex_state = 5, .external_lex_state = 4},
  [1351] = {.lex_state = 12, .external_lex_state = 2},
  [1352] = {.lex_state = 12, .external_lex_state = 2},
  [1353] = {.lex_state = 5, .external_lex_state = 4},
  [1354] = {.lex_state = 5, .external_lex_state = 3},
  [1355] = {.lex_state = 12, .external_lex_state = 2},
  [1356] = {.lex_state = 5, .external_lex_state = 3},
  [1357] = {.lex_state = 5, .external_lex_state = 3},
  [1358] = {.lex_state = 5, .external_lex_state = 4},
  [1359] = {.lex_state = 12, .external_lex_state = 2},
  [1360] = {.lex_state = 5, .external_lex_state = 3},
  [1361] = {.lex_state = 5, .external_lex_state = 3},
  [1362] = {.lex_state = 5, .external_lex_state = 3},
  [1363] = {.lex_state = 5, .external_lex_state = 3},
  [1364] = {.lex_state = 5, .external_lex_state = 3},
  [1365] = {.lex_state = 6, .external_lex_state = 3},
  [1366] = {.lex_state = 5, .external_lex_state = 3},
  [1367] = {.lex_state = 12, .external_lex_state = 2},
  [1368] = {.lex_state = 5, .external_lex_state = 3},
  [1369] = {.lex_state = 5, .external_lex_state = 3},
  [1370] = {.lex_state = 5, .external_lex_state = 3},
  [1371] = {.lex_state = 5, .external_lex_state = 3},
  [1372] = {.lex_state = 5, .external_lex_state = 3},
  [1373] = {.lex_state = 5, .external_lex_state = 4},
  [1374] = {.lex_state = 5, .external_lex_state = 3},
  [1375] = {.lex_state = 5, .external_lex_state = 3},
  [1376] = {.lex_state = 5, .external_lex_state = 3},
  [1377] = {.lex_state = 5, .external_lex_state = 3},
  [1378] = {.lex_state = 5, .external_lex_state = 3},
  [1379] = {.lex_state = 5, .external_lex_state = 3},
  [1380] = {.lex_state = 5, .external_lex_state = 3},
  [1381] = {.lex_state = 5, .external_lex_state = 3},
  [1382] = {.lex_state = 5, .external_lex_state = 3},
  [1383] = {.lex_state = 5, .external_lex_state = 3},
  [1384] = {.lex_state = 5, .external_lex_state = 3},
  [1385] = {.lex_state = 12, .external_lex_state = 2},
  [1386] = {.lex_state = 12, .external_lex_state = 2},
  [1387] = {.lex_state = 5, .external_lex_state = 3},
  [1388] = {.lex_state = 12, .external_lex_state = 2},
  [1389] = {.lex_state = 12, .external_lex_state = 2},
  [1390] = {.lex_state = 5, .external_lex_state = 3},
  [1391] = {.lex_state = 12, .external_lex_state = 2},
  [1392] = {.lex_state = 12, .external_lex_state = 2},
  [1393] = {.lex_state = 5, .external_lex_state = 3},
  [1394] = {.lex_state = 5, .external_lex_state = 3},
  [1395] = {.lex_state = 12, .external_lex_state = 2},
  [1396] = {.lex_state = 12, .external_lex_state = 2},
  [1397] = {.lex_state = 12, .external_lex_state = 2},
  [1398] = {.lex_state = 5, .external_lex_state = 3},
  [1399] = {.lex_state = 5, .external_lex_state = 3},
  [1400] = {.lex_state = 5, .external_lex_state = 3},
  [1401] = {.lex_state = 5, .external_lex_state = 3},
  [1402] = {.lex_state = 12, .external_lex_state = 2},
  [1403] = {.lex_state = 12, .external_lex_state = 2},
  [1404] = {.lex_state = 5, .external_lex_state = 3},
  [1405] = {.lex_state = 12, .external_lex_state = 2},
  [1406] = {.lex_state = 5, .external_lex_state = 3},
  [1407] = {.lex_state = 5, .external_lex_state = 3},
  [1408] = {.lex_state = 5, .external_lex_state = 3},
  [1409] = {.lex_state = 5, .external_lex_state = 3},
  [1410] = {.lex_state = 5, .external_lex_state = 3},
  [1411] = {.lex_state = 5, .external_lex_state = 3},
  [1412] = {.lex_state = 12, .external_lex_state = 2},
  [1413] = {.lex_state = 5, .external_lex_state = 3},
  [1414] = {.lex_state = 5, .external_lex_state = 3},
  [1415] = {.lex_state = 5, .external_lex_state = 3},
  [1416] = {.lex_state = 5, .external_lex_state = 3},
  [1417] = {.lex_state = 12, .external_lex_state = 2},
  [1418] = {.lex_state = 12, .external_lex_state = 2},
  [1419] = {.lex_state = 5, .external_lex_state = 3},
  [1420] = {.lex_state = 12, .external_lex_state = 2},
  [1421] = {.lex_state = 12, .external_lex_state = 2},
  [1422] = {.lex_state = 12, .external_lex_state = 2},
  [1423] = {.lex_state = 5, .external_lex_state = 3},
  [1424] = {.lex_state = 5, .external_lex_state = 3},
  [1425] = {.lex_state = 5, .external_lex_state = 3},
  [1426] = {.lex_state = 5, .external_lex_state = 3},
  [1427] = {.lex_state = 5, .external_lex_state = 3},
  [1428] = {.lex_state = 5, .external_lex_state = 3},
  [1429] = {.lex_state = 5, .external_lex_state = 3},
  [1430] = {.lex_state = 5, .external_lex_state = 3},
  [1431] = {.lex_state = 5, .external_lex_state = 3},
  [1432] = {.lex_state = 5, .external_lex_state = 3},
  [1433] = {.lex_state = 12, .external_lex_state = 2},
  [1434] = {.lex_state = 12, .external_lex_state = 2},
  [1435] = {.lex_state = 12, .external_lex_state = 2},
  [1436] = {.lex_state = 12, .external_lex_state = 2},
  [1437] = {.lex_state = 12, .external_lex_state = 2},
  [1438] = {.lex_state = 12, .external_lex_state = 2},
  [1439] = {.lex_state = 12, .external_lex_state = 2},
  [1440] = {.lex_state = 12, .external_lex_state = 2},
  [1441] = {.lex_state = 12, .external_lex_state = 2},
  [1442] = {.lex_state = 13, .external_lex_state = 5},
  [1443] = {.lex_state = 12, .external_lex_state = 2},
  [1444] = {.lex_state = 13, .external_lex_state = 5},
  [1445] = {.lex_state = 12, .external_lex_state = 2},
  [1446] = {.lex_state = 12, .external_lex_state = 2},
  [1447] = {.lex_state = 12, .external_lex_state = 2},
  [1448] = {.lex_state = 13, .external_lex_state = 5},
  [1449] = {.lex_state = 12, .external_lex_state = 2},
  [1450] = {.lex_state = 12, .external_lex_state = 2},
  [1451] = {.lex_state = 12, .external_lex_state = 2},
  [1452] = {.lex_state = 13, .external_lex_state = 5},
  [1453] = {.lex_state = 12, .external_lex_state = 2},
  [1454] = {.lex_state = 13, .external_lex_state = 5},
  [1455] = {.lex_state = 12, .external_lex_state = 2},
  [1456] = {.lex_state = 149, .external_lex_state = 2},
  [1457] = {.lex_state = 149, .external_lex_state = 2},
  [1458] = {.lex_state = 149, .external_lex_state = 2},
  [1459] = {.lex_state = 149, .external_lex_state = 2},
  [1460] = {.lex_state = 7, .external_lex_state = 3},
  [1461] = {.lex_state = 149, .external_lex_state = 2},
  [1462] = {.lex_state = 149, .external_lex_state = 2},
  [1463] = {.lex_state = 13, .external_lex_state = 5},
  [1464] = {.lex_state = 7, .external_lex_state = 4},
  [1465] = {.lex_state = 13, .external_lex_state = 5},
  [1466] = {.lex_state = 7, .external_lex_state = 3},
  [1467] = {.lex_state = 7, .external_lex_state = 3},
  [1468] = {.lex_state = 7, .external_lex_state = 4},
  [1469] = {.lex_state = 7, .external_lex_state = 3},
  [1470] = {.lex_state = 7, .external_lex_state = 3},
  [1471] = {.lex_state = 7, .external_lex_state = 3},
  [1472] = {.lex_state = 7, .external_lex_state = 3},
  [1473] = {.lex_state = 7, .external_lex_state = 4},
  [1474] = {.lex_state = 7, .external_lex_state = 3},
  [1475] = {.lex_state = 7, .external_lex_state = 3},
  [1476] = {.lex_state = 7, .external_lex_state = 3},
  [1477] = {.lex_state = 7, .external_lex_state = 3},
  [1478] = {.lex_state = 7, .external_lex_state = 3},
  [1479] = {.lex_state = 7, .external_lex_state = 3},
  [1480] = {.lex_state = 7, .external_lex_state = 3},
  [1481] = {.lex_state = 7, .external_lex_state = 3},
  [1482] = {.lex_state = 7, .external_lex_state = 3},
  [1483] = {.lex_state = 149, .external_lex_state = 2},
  [1484] = {.lex_state = 7, .external_lex_state = 3},
  [1485] = {.lex_state = 7, .external_lex_state = 3},
  [1486] = {.lex_state = 7, .external_lex_state = 3},
  [1487] = {.lex_state = 7, .external_lex_state = 3},
  [1488] = {.lex_state = 7, .external_lex_state = 3},
  [1489] = {.lex_state = 7, .external_lex_state = 3},
  [1490] = {.lex_state = 7, .external_lex_state = 3},
  [1491] = {.lex_state = 7, .external_lex_state = 3},
  [1492] = {.lex_state = 7, .external_lex_state = 3},
  [1493] = {.lex_state = 7, .external_lex_state = 3},
  [1494] = {.lex_state = 7, .external_lex_state = 3},
  [1495] = {.lex_state = 7, .external_lex_state = 3},
  [1496] = {.lex_state = 7, .external_lex_state = 3},
  [1497] = {.lex_state = 7, .external_lex_state = 4},
  [1498] = {.lex_state = 7, .external_lex_state = 3},
  [1499] = {.lex_state = 7, .external_lex_state = 3},
  [1500] = {.lex_state = 7, .external_lex_state = 3},
  [1501] = {.lex_state = 7, .external_lex_state = 3},
  [1502] = {.lex_state = 7, .external_lex_state = 3},
  [1503] = {.lex_state = 7, .external_lex_state = 3},
  [1504] = {.lex_state = 7, .external_lex_state = 3},
  [1505] = {.lex_state = 7, .external_lex_state = 3},
  [1506] = {.lex_state = 7, .external_lex_state = 4},
  [1507] = {.lex_state = 7, .external_lex_state = 3},
  [1508] = {.lex_state = 7, .external_lex_state = 3},
  [1509] = {.lex_state = 7, .external_lex_state = 3},
  [1510] = {.lex_state = 7, .external_lex_state = 4},
  [1511] = {.lex_state = 7, .external_lex_state = 3},
  [1512] = {.lex_state = 7, .external_lex_state = 4},
  [1513] = {.lex_state = 7, .external_lex_state = 3},
  [1514] = {.lex_state = 7, .external_lex_state = 3},
  [1515] = {.lex_state = 7, .external_lex_state = 3},
  [1516] = {.lex_state = 7, .external_lex_state = 3},
  [1517] = {.lex_state = 7, .external_lex_state = 3},
  [1518] = {.lex_state = 7, .external_lex_state = 3},
  [1519] = {.lex_state = 7, .external_lex_state = 3},
  [1520] = {.lex_state = 7, .external_lex_state = 3},
  [1521] = {.lex_state = 7, .external_lex_state = 3},
  [1522] = {.lex_state = 7, .external_lex_state = 3},
  [1523] = {.lex_state = 7, .external_lex_state = 3},
  [1524] = {.lex_state = 7, .external_lex_state = 3},
  [1525] = {.lex_state = 7, .external_lex_state = 3},
  [1526] = {.lex_state = 7, .external_lex_state = 3},
  [1527] = {.lex_state = 7, .external_lex_state = 3},
  [1528] = {.lex_state = 7, .external_lex_state = 3},
  [1529] = {.lex_state = 7, .external_lex_state = 3},
  [1530] = {.lex_state = 7, .external_lex_state = 3},
  [1531] = {.lex_state = 7, .external_lex_state = 3},
  [1532] = {.lex_state = 7, .external_lex_state = 3},
  [1533] = {.lex_state = 7, .external_lex_state = 3},
  [1534] = {.lex_state = 7, .external_lex_state = 3},
  [1535] = {.lex_state = 7, .external_lex_state = 3},
  [1536] = {.lex_state = 7, .external_lex_state = 3},
  [1537] = {.lex_state = 7, .external_lex_state = 3},
  [1538] = {.lex_state = 7, .external_lex_state = 3},
  [1539] = {.lex_state = 7, .external_lex_state = 3},
  [1540] = {.lex_state = 7, .external_lex_state = 3},
  [1541] = {.lex_state = 7, .external_lex_state = 3},
  [1542] = {.lex_state = 7, .external_lex_state = 3},
  [1543] = {.lex_state = 7, .external_lex_state = 3},
  [1544] = {.lex_state = 7, .external_lex_state = 3},
  [1545] = {.lex_state = 7, .external_lex_state = 3},
  [1546] = {.lex_state = 7, .external_lex_state = 3},
  [1547] = {.lex_state = 7, .external_lex_state = 3},
  [1548] = {.lex_state = 7, .external_lex_state = 3},
  [1549] = {.lex_state = 7, .external_lex_state = 3},
  [1550] = {.lex_state = 7, .external_lex_state = 3},
  [1551] = {.lex_state = 7, .external_lex_state = 3},
  [1552] = {.lex_state = 7, .external_lex_state = 3},
  [1553] = {.lex_state = 7, .external_lex_state = 3},
  [1554] = {.lex_state = 7, .external_lex_state = 3},
  [1555] = {.lex_state = 7, .external_lex_state = 3},
  [1556] = {.lex_state = 7, .external_lex_state = 3},
  [1557] = {.lex_state = 7, .external_lex_state = 3},
  [1558] = {.lex_state = 7, .external_lex_state = 3},
  [1559] = {.lex_state = 7, .external_lex_state = 3},
  [1560] = {.lex_state = 7, .external_lex_state = 3},
  [1561] = {.lex_state = 7, .external_lex_state = 3},
  [1562] = {.lex_state = 7, .external_lex_state = 3},
  [1563] = {.lex_state = 7, .external_lex_state = 3},
  [1564] = {.lex_state = 7, .external_lex_state = 3},
  [1565] = {.lex_state = 7, .external_lex_state = 3},
  [1566] = {.lex_state = 7, .external_lex_state = 3},
  [1567] = {.lex_state = 7, .external_lex_state = 3},
  [1568] = {.lex_state = 7, .external_lex_state = 3},
  [1569] = {.lex_state = 7, .external_lex_state = 3},
  [1570] = {.lex_state = 7, .external_lex_state = 3},
  [1571] = {.lex_state = 7, .external_lex_state = 3},
  [1572] = {.lex_state = 7, .external_lex_state = 3},
  [1573] = {.lex_state = 7, .external_lex_state = 3},
  [1574] = {.lex_state = 7, .external_lex_state = 3},
  [1575] = {.lex_state = 7, .external_lex_state = 3},
  [1576] = {.lex_state = 7, .external_lex_state = 3},
  [1577] = {.lex_state = 7, .external_lex_state = 3},
  [1578] = {.lex_state = 7, .external_lex_state = 3},
  [1579] = {.lex_state = 7, .external_lex_state = 3},
  [1580] = {.lex_state = 7, .external_lex_state = 3},
  [1581] = {.lex_state = 7, .external_lex_state = 3},
  [1582] = {.lex_state = 7, .external_lex_state = 3},
  [1583] = {.lex_state = 7, .external_lex_state = 3},
  [1584] = {.lex_state = 7, .external_lex_state = 3},
  [1585] = {.lex_state = 7, .external_lex_state = 3},
  [1586] = {.lex_state = 7, .external_lex_state = 3},
  [1587] = {.lex_state = 7, .external_lex_state = 3},
  [1588] = {.lex_state = 7, .external_lex_state = 3},
  [1589] = {.lex_state = 7, .external_lex_state = 3},
  [1590] = {.lex_state = 7, .external_lex_state = 3},
  [1591] = {.lex_state = 7, .external_lex_state = 3},
  [1592] = {.lex_state = 7, .external_lex_state = 3},
  [1593] = {.lex_state = 7, .external_lex_state = 3},
  [1594] = {.lex_state = 7, .external_lex_state = 3},
  [1595] = {.lex_state = 7, .external_lex_state = 3},
  [1596] = {.lex_state = 7, .external_lex_state = 3},
  [1597] = {.lex_state = 7, .external_lex_state = 3},
  [1598] = {.lex_state = 7, .external_lex_state = 3},
  [1599] = {.lex_state = 7, .external_lex_state = 3},
  [1600] = {.lex_state = 7, .external_lex_state = 3},
  [1601] = {.lex_state = 7, .external_lex_state = 3},
  [1602] = {.lex_state = 7, .external_lex_state = 3},
  [1603] = {.lex_state = 7, .external_lex_state = 3},
  [1604] = {.lex_state = 7, .external_lex_state = 3},
  [1605] = {.lex_state = 7, .external_lex_state = 3},
  [1606] = {.lex_state = 7, .external_lex_state = 3},
  [1607] = {.lex_state = 7, .external_lex_state = 3},
  [1608] = {.lex_state = 7, .external_lex_state = 4},
  [1609] = {.lex_state = 7, .external_lex_state = 3},
  [1610] = {.lex_state = 7, .external_lex_state = 3},
  [1611] = {.lex_state = 7, .external_lex_state = 3},
  [1612] = {.lex_state = 12, .external_lex_state = 5},
  [1613] = {.lex_state = 7, .external_lex_state = 3},
  [1614] = {.lex_state = 7, .external_lex_state = 3},
  [1615] = {.lex_state = 7, .external_lex_state = 3},
  [1616] = {.lex_state = 12, .external_lex_state = 5},
  [1617] = {.lex_state = 7, .external_lex_state = 3},
  [1618] = {.lex_state = 7, .external_lex_state = 3},
  [1619] = {.lex_state = 7, .external_lex_state = 3},
  [1620] = {.lex_state = 7, .external_lex_state = 3},
  [1621] = {.lex_state = 7, .external_lex_state = 3},
  [1622] = {.lex_state = 7, .external_lex_state = 3},
  [1623] = {.lex_state = 7, .external_lex_state = 3},
  [1624] = {.lex_state = 7, .external_lex_state = 3},
  [1625] = {.lex_state = 7, .external_lex_state = 3},
  [1626] = {.lex_state = 7, .external_lex_state = 3},
  [1627] = {.lex_state = 7, .external_lex_state = 3},
  [1628] = {.lex_state = 7, .external_lex_state = 4},
  [1629] = {.lex_state = 7, .external_lex_state = 3},
  [1630] = {.lex_state = 7, .external_lex_state = 3},
  [1631] = {.lex_state = 7, .external_lex_state = 3},
  [1632] = {.lex_state = 7, .external_lex_state = 3},
  [1633] = {.lex_state = 7, .external_lex_state = 3},
  [1634] = {.lex_state = 7, .external_lex_state = 3},
  [1635] = {.lex_state = 7, .external_lex_state = 3},
  [1636] = {.lex_state = 7, .external_lex_state = 3},
  [1637] = {.lex_state = 7, .external_lex_state = 3},
  [1638] = {.lex_state = 7, .external_lex_state = 3},
  [1639] = {.lex_state = 7, .external_lex_state = 3},
  [1640] = {.lex_state = 7, .external_lex_state = 3},
  [1641] = {.lex_state = 7, .external_lex_state = 3},
  [1642] = {.lex_state = 7, .external_lex_state = 3},
  [1643] = {.lex_state = 7, .external_lex_state = 3},
  [1644] = {.lex_state = 7, .external_lex_state = 3},
  [1645] = {.lex_state = 7, .external_lex_state = 3},
  [1646] = {.lex_state = 7, .external_lex_state = 3},
  [1647] = {.lex_state = 7, .external_lex_state = 3},
  [1648] = {.lex_state = 7, .external_lex_state = 3},
  [1649] = {.lex_state = 7, .external_lex_state = 3},
  [1650] = {.lex_state = 7, .external_lex_state = 3},
  [1651] = {.lex_state = 7, .external_lex_state = 3},
  [1652] = {.lex_state = 7, .external_lex_state = 3},
  [1653] = {.lex_state = 7, .external_lex_state = 3},
  [1654] = {.lex_state = 7, .external_lex_state = 3},
  [1655] = {.lex_state = 12, .external_lex_state = 5},
  [1656] = {.lex_state = 12, .external_lex_state = 5},
  [1657] = {.lex_state = 7, .external_lex_state = 3},
  [1658] = {.lex_state = 7, .external_lex_state = 3},
  [1659] = {.lex_state = 7, .external_lex_state = 3},
  [1660] = {.lex_state = 7, .external_lex_state = 3},
  [1661] = {.lex_state = 7, .external_lex_state = 3},
  [1662] = {.lex_state = 7, .external_lex_state = 3},
  [1663] = {.lex_state = 7, .external_lex_state = 3},
  [1664] = {.lex_state = 7, .external_lex_state = 3},
  [1665] = {.lex_state = 7, .external_lex_state = 3},
  [1666] = {.lex_state = 7, .external_lex_state = 3},
  [1667] = {.lex_state = 7, .external_lex_state = 3},
  [1668] = {.lex_state = 7, .external_lex_state = 3},
  [1669] = {.lex_state = 7, .external_lex_state = 3},
  [1670] = {.lex_state = 7, .external_lex_state = 3},
  [1671] = {.lex_state = 7, .external_lex_state = 3},
  [1672] = {.lex_state = 7, .external_lex_state = 3},
  [1673] = {.lex_state = 7, .external_lex_state = 3},
  [1674] = {.lex_state = 7, .external_lex_state = 3},
  [1675] = {.lex_state = 7, .external_lex_state = 3},
  [1676] = {.lex_state = 7, .external_lex_state = 3},
  [1677] = {.lex_state = 7, .external_lex_state = 3},
  [1678] = {.lex_state = 7, .external_lex_state = 4},
  [1679] = {.lex_state = 7, .external_lex_state = 4},
  [1680] = {.lex_state = 7, .external_lex_state = 3},
  [1681] = {.lex_state = 7, .external_lex_state = 3},
  [1682] = {.lex_state = 7, .external_lex_state = 3},
  [1683] = {.lex_state = 7, .external_lex_state = 3},
  [1684] = {.lex_state = 7, .external_lex_state = 3},
  [1685] = {.lex_state = 7, .external_lex_state = 3},
  [1686] = {.lex_state = 7, .external_lex_state = 3},
  [1687] = {.lex_state = 7, .external_lex_state = 3},
  [1688] = {.lex_state = 7, .external_lex_state = 3},
  [1689] = {.lex_state = 7, .external_lex_state = 3},
  [1690] = {.lex_state = 7, .external_lex_state = 3},
  [1691] = {.lex_state = 7, .external_lex_state = 3},
  [1692] = {.lex_state = 7, .external_lex_state = 3},
  [1693] = {.lex_state = 7, .external_lex_state = 3},
  [1694] = {.lex_state = 12, .external_lex_state = 5},
  [1695] = {.lex_state = 7, .external_lex_state = 3},
  [1696] = {.lex_state = 7, .external_lex_state = 3},
  [1697] = {.lex_state = 7, .external_lex_state = 3},
  [1698] = {.lex_state = 7, .external_lex_state = 3},
  [1699] = {.lex_state = 7, .external_lex_state = 3},
  [1700] = {.lex_state = 7, .external_lex_state = 3},
  [1701] = {.lex_state = 7, .external_lex_state = 3},
  [1702] = {.lex_state = 7, .external_lex_state = 3},
  [1703] = {.lex_state = 7, .external_lex_state = 3},
  [1704] = {.lex_state = 7, .external_lex_state = 3},
  [1705] = {.lex_state = 7, .external_lex_state = 3},
  [1706] = {.lex_state = 7, .external_lex_state = 3},
  [1707] = {.lex_state = 7, .external_lex_state = 3},
  [1708] = {.lex_state = 7, .external_lex_state = 3},
  [1709] = {.lex_state = 7, .external_lex_state = 3},
  [1710] = {.lex_state = 7, .external_lex_state = 3},
  [1711] = {.lex_state = 7, .external_lex_state = 3},
  [1712] = {.lex_state = 7, .external_lex_state = 3},
  [1713] = {.lex_state = 7, .external_lex_state = 3},
  [1714] = {.lex_state = 7, .external_lex_state = 3},
  [1715] = {.lex_state = 7, .external_lex_state = 3},
  [1716] = {.lex_state = 7, .external_lex_state = 3},
  [1717] = {.lex_state = 7, .external_lex_state = 3},
  [1718] = {.lex_state = 7, .external_lex_state = 3},
  [1719] = {.lex_state = 7, .external_lex_state = 3},
  [1720] = {.lex_state = 7, .external_lex_state = 3},
  [1721] = {.lex_state = 7, .external_lex_state = 3},
  [1722] = {.lex_state = 7, .external_lex_state = 3},
  [1723] = {.lex_state = 7, .external_lex_state = 3},
  [1724] = {.lex_state = 7, .external_lex_state = 3},
  [1725] = {.lex_state = 7, .external_lex_state = 3},
  [1726] = {.lex_state = 7, .external_lex_state = 3},
  [1727] = {.lex_state = 7, .external_lex_state = 3},
  [1728] = {.lex_state = 7, .external_lex_state = 4},
  [1729] = {.lex_state = 7, .external_lex_state = 3},
  [1730] = {.lex_state = 7, .external_lex_state = 4},
  [1731] = {.lex_state = 7, .external_lex_state = 4},
  [1732] = {.lex_state = 7, .external_lex_state = 3},
  [1733] = {.lex_state = 7, .external_lex_state = 4},
  [1734] = {.lex_state = 12, .external_lex_state = 5},
  [1735] = {.lex_state = 12, .external_lex_state = 5},
  [1736] = {.lex_state = 12, .external_lex_state = 5},
  [1737] = {.lex_state = 7, .external_lex_state = 4},
  [1738] = {.lex_state = 12, .external_lex_state = 5},
  [1739] = {.lex_state = 7, .external_lex_state = 3},
  [1740] = {.lex_state = 12, .external_lex_state = 5},
  [1741] = {.lex_state = 7, .external_lex_state = 4},
  [1742] = {.lex_state = 7, .external_lex_state = 4},
  [1743] = {.lex_state = 12, .external_lex_state = 5},
  [1744] = {.lex_state = 7, .external_lex_state = 4},
  [1745] = {.lex_state = 12, .external_lex_state = 5},
  [1746] = {.lex_state = 7, .external_lex_state = 4},
  [1747] = {.lex_state = 7, .external_lex_state = 4},
  [1748] = {.lex_state = 12, .external_lex_state = 5},
  [1749] = {.lex_state = 13, .external_lex_state = 5},
  [1750] = {.lex_state = 12, .external_lex_state = 5},
  [1751] = {.lex_state = 7, .external_lex_state = 3},
  [1752] = {.lex_state = 12, .external_lex_state = 5},
  [1753] = {.lex_state = 12, .external_lex_state = 5},
  [1754] = {.lex_state = 7, .external_lex_state = 3},
  [1755] = {.lex_state = 7, .external_lex_state = 4},
  [1756] = {.lex_state = 12, .external_lex_state = 5},
  [1757] = {.lex_state = 7, .external_lex_state = 4},
  [1758] = {.lex_state = 7, .external_lex_state = 4},
  [1759] = {.lex_state = 7, .external_lex_state = 3},
  [1760] = {.lex_state = 7, .external_lex_state = 4},
  [1761] = {.lex_state = 7, .external_lex_state = 4},
  [1762] = {.lex_state = 7, .external_lex_state = 3},
  [1763] = {.lex_state = 7, .external_lex_state = 4},
  [1764] = {.lex_state = 7, .external_lex_state = 3},
  [1765] = {.lex_state = 7, .external_lex_state = 3},
  [1766] = {.lex_state = 7, .external_lex_state = 4},
  [1767] = {.lex_state = 7, .external_lex_state = 4},
  [1768] = {.lex_state = 7, .external_lex_state = 4},
  [1769] = {.lex_state = 7, .external_lex_state = 4},
  [1770] = {.lex_state = 8, .external_lex_state = 3},
  [1771] = {.lex_state = 7, .external_lex_state = 4},
  [1772] = {.lex_state = 7, .external_lex_state = 4},
  [1773] = {.lex_state = 7, .external_lex_state = 4},
  [1774] = {.lex_state = 7, .external_lex_state = 4},
  [1775] = {.lex_state = 7, .external_lex_state = 4},
  [1776] = {.lex_state = 7, .external_lex_state = 4},
  [1777] = {.lex_state = 7, .external_lex_state = 4},
  [1778] = {.lex_state = 7, .external_lex_state = 4},
  [1779] = {.lex_state = 7, .external_lex_state = 4},
  [1780] = {.lex_state = 7, .external_lex_state = 4},
  [1781] = {.lex_state = 7, .external_lex_state = 4},
  [1782] = {.lex_state = 7, .external_lex_state = 4},
  [1783] = {.lex_state = 7, .external_lex_state = 4},
  [1784] = {.lex_state = 7, .external_lex_state = 4},
  [1785] = {.lex_state = 7, .external_lex_state = 4},
  [1786] = {.lex_state = 7, .external_lex_state = 4},
  [1787] = {.lex_state = 12, .external_lex_state = 5},
  [1788] = {.lex_state = 7, .external_lex_state = 4},
  [1789] = {.lex_state = 7, .external_lex_state = 4},
  [1790] = {.lex_state = 7, .external_lex_state = 4},
  [1791] = {.lex_state = 7, .external_lex_state = 4},
  [1792] = {.lex_state = 7, .external_lex_state = 4},
  [1793] = {.lex_state = 12, .external_lex_state = 5},
  [1794] = {.lex_state = 7, .external_lex_state = 3},
  [1795] = {.lex_state = 7, .external_lex_state = 4},
  [1796] = {.lex_state = 7, .external_lex_state = 3},
  [1797] = {.lex_state = 7, .external_lex_state = 3},
  [1798] = {.lex_state = 7, .external_lex_state = 3},
  [1799] = {.lex_state = 7, .external_lex_state = 3},
  [1800] = {.lex_state = 7, .external_lex_state = 3},
  [1801] = {.lex_state = 7, .external_lex_state = 4},
  [1802] = {.lex_state = 7, .external_lex_state = 4},
  [1803] = {.lex_state = 7, .external_lex_state = 3},
  [1804] = {.lex_state = 7, .external_lex_state = 3},
  [1805] = {.lex_state = 12, .external_lex_state = 5},
  [1806] = {.lex_state = 7, .external_lex_state = 4},
  [1807] = {.lex_state = 7, .external_lex_state = 4},
  [1808] = {.lex_state = 7, .external_lex_state = 4},
  [1809] = {.lex_state = 7, .external_lex_state = 4},
  [1810] = {.lex_state = 7, .external_lex_state = 4},
  [1811] = {.lex_state = 7, .external_lex_state = 4},
  [1812] = {.lex_state = 7, .external_lex_state = 3},
  [1813] = {.lex_state = 7, .external_lex_state = 4},
  [1814] = {.lex_state = 7, .external_lex_state = 4},
  [1815] = {.lex_state = 7, .external_lex_state = 4},
  [1816] = {.lex_state = 7, .external_lex_state = 4},
  [1817] = {.lex_state = 12, .external_lex_state = 5},
  [1818] = {.lex_state = 12, .external_lex_state = 5},
  [1819] = {.lex_state = 7, .external_lex_state = 4},
  [1820] = {.lex_state = 7, .external_lex_state = 3},
  [1821] = {.lex_state = 7, .external_lex_state = 4},
  [1822] = {.lex_state = 7, .external_lex_state = 4},
  [1823] = {.lex_state = 12, .external_lex_state = 5},
  [1824] = {.lex_state = 7, .external_lex_state = 3},
  [1825] = {.lex_state = 7, .external_lex_state = 4},
  [1826] = {.lex_state = 7, .external_lex_state = 4},
  [1827] = {.lex_state = 7, .external_lex_state = 4},
  [1828] = {.lex_state = 7, .external_lex_state = 4},
  [1829] = {.lex_state = 7, .external_lex_state = 4},
  [1830] = {.lex_state = 7, .external_lex_state = 4},
  [1831] = {.lex_state = 7, .external_lex_state = 4},
  [1832] = {.lex_state = 7, .external_lex_state = 4},
  [1833] = {.lex_state = 7, .external_lex_state = 4},
  [1834] = {.lex_state = 7, .external_lex_state = 4},
  [1835] = {.lex_state = 7, .external_lex_state = 4},
  [1836] = {.lex_state = 7, .external_lex_state = 4},
  [1837] = {.lex_state = 7, .external_lex_state = 4},
  [1838] = {.lex_state = 7, .external_lex_state = 4},
  [1839] = {.lex_state = 7, .external_lex_state = 4},
  [1840] = {.lex_state = 7, .external_lex_state = 4},
  [1841] = {.lex_state = 7, .external_lex_state = 4},
  [1842] = {.lex_state = 7, .external_lex_state = 4},
  [1843] = {.lex_state = 7, .external_lex_state = 4},
  [1844] = {.lex_state = 7, .external_lex_state = 4},
  [1845] = {.lex_state = 7, .external_lex_state = 4},
  [1846] = {.lex_state = 7, .external_lex_state = 4},
  [1847] = {.lex_state = 7, .external_lex_state = 4},
  [1848] = {.lex_state = 7, .external_lex_state = 4},
  [1849] = {.lex_state = 7, .external_lex_state = 4},
  [1850] = {.lex_state = 12, .external_lex_state = 5},
  [1851] = {.lex_state = 7, .external_lex_state = 4},
  [1852] = {.lex_state = 7, .external_lex_state = 4},
  [1853] = {.lex_state = 12, .external_lex_state = 5},
  [1854] = {.lex_state = 7, .external_lex_state = 4},
  [1855] = {.lex_state = 7, .external_lex_state = 4},
  [1856] = {.lex_state = 7, .external_lex_state = 4},
  [1857] = {.lex_state = 7, .external_lex_state = 4},
  [1858] = {.lex_state = 7, .external_lex_state = 4},
  [1859] = {.lex_state = 7, .external_lex_state = 4},
  [1860] = {.lex_state = 7, .external_lex_state = 4},
  [1861] = {.lex_state = 7, .external_lex_state = 4},
  [1862] = {.lex_state = 7, .external_lex_state = 4},
  [1863] = {.lex_state = 7, .external_lex_state = 4},
  [1864] = {.lex_state = 7, .external_lex_state = 4},
  [1865] = {.lex_state = 7, .external_lex_state = 4},
  [1866] = {.lex_state = 7, .external_lex_state = 4},
  [1867] = {.lex_state = 7, .external_lex_state = 4},
  [1868] = {.lex_state = 7, .external_lex_state = 4},
  [1869] = {.lex_state = 7, .external_lex_state = 4},
  [1870] = {.lex_state = 7, .external_lex_state = 4},
  [1871] = {.lex_state = 7, .external_lex_state = 4},
  [1872] = {.lex_state = 7, .external_lex_state = 4},
  [1873] = {.lex_state = 7, .external_lex_state = 4},
  [1874] = {.lex_state = 7, .external_lex_state = 4},
  [1875] = {.lex_state = 7, .external_lex_state = 4},
  [1876] = {.lex_state = 7, .external_lex_state = 4},
  [1877] = {.lex_state = 7, .external_lex_state = 4},
  [1878] = {.lex_state = 7, .external_lex_state = 4},
  [1879] = {.lex_state = 7, .external_lex_state = 4},
  [1880] = {.lex_state = 7, .external_lex_state = 4},
  [1881] = {.lex_state = 7, .external_lex_state = 4},
  [1882] = {.lex_state = 7, .external_lex_state = 4},
  [1883] = {.lex_state = 7, .external_lex_state = 4},
  [1884] = {.lex_state = 7, .external_lex_state = 4},
  [1885] = {.lex_state = 7, .external_lex_state = 4},
  [1886] = {.lex_state = 7, .external_lex_state = 4},
  [1887] = {.lex_state = 7, .external_lex_state = 4},
  [1888] = {.lex_state = 7, .external_lex_state = 4},
  [1889] = {.lex_state = 7, .external_lex_state = 4},
  [1890] = {.lex_state = 7, .external_lex_state = 4},
  [1891] = {.lex_state = 7, .external_lex_state = 4},
  [1892] = {.lex_state = 7, .external_lex_state = 4},
  [1893] = {.lex_state = 7, .external_lex_state = 4},
  [1894] = {.lex_state = 7, .external_lex_state = 4},
  [1895] = {.lex_state = 7, .external_lex_state = 4},
  [1896] = {.lex_state = 7, .external_lex_state = 4},
  [1897] = {.lex_state = 7, .external_lex_state = 4},
  [1898] = {.lex_state = 7, .external_lex_state = 4},
  [1899] = {.lex_state = 7, .external_lex_state = 4},
  [1900] = {.lex_state = 7, .external_lex_state = 4},
  [1901] = {.lex_state = 7, .external_lex_state = 4},
  [1902] = {.lex_state = 7, .external_lex_state = 4},
  [1903] = {.lex_state = 7, .external_lex_state = 4},
  [1904] = {.lex_state = 7, .external_lex_state = 4},
  [1905] = {.lex_state = 7, .external_lex_state = 4},
  [1906] = {.lex_state = 7, .external_lex_state = 4},
  [1907] = {.lex_state = 7, .external_lex_state = 4},
  [1908] = {.lex_state = 7, .external_lex_state = 4},
  [1909] = {.lex_state = 7, .external_lex_state = 4},
  [1910] = {.lex_state = 12, .external_lex_state = 2},
  [1911] = {.lex_state = 7, .external_lex_state = 4},
  [1912] = {.lex_state = 7, .external_lex_state = 4},
  [1913] = {.lex_state = 7, .external_lex_state = 3},
  [1914] = {.lex_state = 7, .external_lex_state = 4},
  [1915] = {.lex_state = 7, .external_lex_state = 4},
  [1916] = {.lex_state = 7, .external_lex_state = 4},
  [1917] = {.lex_state = 7, .external_lex_state = 3},
  [1918] = {.lex_state = 7, .external_lex_state = 4},
  [1919] = {.lex_state = 7, .external_lex_state = 3},
  [1920] = {.lex_state = 7, .external_lex_state = 4},
  [1921] = {.lex_state = 7, .external_lex_state = 4},
  [1922] = {.lex_state = 7, .external_lex_state = 4},
  [1923] = {.lex_state = 7, .external_lex_state = 4},
  [1924] = {.lex_state = 7, .external_lex_state = 4},
  [1925] = {.lex_state = 7, .external_lex_state = 4},
  [1926] = {.lex_state = 7, .external_lex_state = 4},
  [1927] = {.lex_state = 7, .external_lex_state = 4},
  [1928] = {.lex_state = 7, .external_lex_state = 4},
  [1929] = {.lex_state = 12, .external_lex_state = 2},
  [1930] = {.lex_state = 7, .external_lex_state = 4},
  [1931] = {.lex_state = 7, .external_lex_state = 3},
  [1932] = {.lex_state = 7, .external_lex_state = 3},
  [1933] = {.lex_state = 7, .external_lex_state = 3},
  [1934] = {.lex_state = 7, .external_lex_state = 4},
  [1935] = {.lex_state = 7, .external_lex_state = 4},
  [1936] = {.lex_state = 7, .external_lex_state = 4},
  [1937] = {.lex_state = 7, .external_lex_state = 4},
  [1938] = {.lex_state = 7, .external_lex_state = 3},
  [1939] = {.lex_state = 7, .external_lex_state = 4},
  [1940] = {.lex_state = 12, .external_lex_state = 5},
  [1941] = {.lex_state = 12, .external_lex_state = 5},
  [1942] = {.lex_state = 7, .external_lex_state = 4},
  [1943] = {.lex_state = 12, .external_lex_state = 5},
  [1944] = {.lex_state = 12, .external_lex_state = 5},
  [1945] = {.lex_state = 7, .external_lex_state = 4},
  [1946] = {.lex_state = 12, .external_lex_state = 5},
  [1947] = {.lex_state = 12, .external_lex_state = 2},
  [1948] = {.lex_state = 7, .external_lex_state = 3},
  [1949] = {.lex_state = 7, .external_lex_state = 3},
  [1950] = {.lex_state = 7, .external_lex_state = 3},
  [1951] = {.lex_state = 7, .external_lex_state = 3},
  [1952] = {.lex_state = 7, .external_lex_state = 4},
  [1953] = {.lex_state = 7, .external_lex_state = 4},
  [1954] = {.lex_state = 7, .external_lex_state = 4},
  [1955] = {.lex_state = 12, .external_lex_state = 2},
  [1956] = {.lex_state = 7, .external_lex_state = 3},
  [1957] = {.lex_state = 7, .external_lex_state = 3},
  [1958] = {.lex_state = 7, .external_lex_state = 4},
  [1959] = {.lex_state = 7, .external_lex_state = 4},
  [1960] = {.lex_state = 7, .external_lex_state = 4},
  [1961] = {.lex_state = 7, .external_lex_state = 4},
  [1962] = {.lex_state = 7, .external_lex_state = 4},
  [1963] = {.lex_state = 7, .external_lex_state = 4},
  [1964] = {.lex_state = 7, .external_lex_state = 4},
  [1965] = {.lex_state = 149, .external_lex_state = 2},
  [1966] = {.lex_state = 7, .external_lex_state = 4},
  [1967] = {.lex_state = 7, .external_lex_state = 4},
  [1968] = {.lex_state = 7, .external_lex_state = 4},
  [1969] = {.lex_state = 7, .external_lex_state = 4},
  [1970] = {.lex_state = 7, .external_lex_state = 4},
  [1971] = {.lex_state = 12, .external_lex_state = 5},
  [1972] = {.lex_state = 7, .external_lex_state = 4},
  [1973] = {.lex_state = 7, .external_lex_state = 4},
  [1974] = {.lex_state = 7, .external_lex_state = 4},
  [1975] = {.lex_state = 7, .external_lex_state = 4},
  [1976] = {.lex_state = 7, .external_lex_state = 4},
  [1977] = {.lex_state = 7, .external_lex_state = 4},
  [1978] = {.lex_state = 7, .external_lex_state = 4},
  [1979] = {.lex_state = 7, .external_lex_state = 4},
  [1980] = {.lex_state = 7, .external_lex_state = 4},
  [1981] = {.lex_state = 7, .external_lex_state = 4},
  [1982] = {.lex_state = 7, .external_lex_state = 4},
  [1983] = {.lex_state = 7, .external_lex_state = 4},
  [1984] = {.lex_state = 7, .external_lex_state = 4},
  [1985] = {.lex_state = 7, .external_lex_state = 4},
  [1986] = {.lex_state = 149, .external_lex_state = 2},
  [1987] = {.lex_state = 7, .external_lex_state = 4},
  [1988] = {.lex_state = 12, .external_lex_state = 5},
  [1989] = {.lex_state = 7, .external_lex_state = 4},
  [1990] = {.lex_state = 7, .external_lex_state = 4},
  [1991] = {.lex_state = 7, .external_lex_state = 4},
  [1992] = {.lex_state = 12, .external_lex_state = 2},
  [1993] = {.lex_state = 7, .external_lex_state = 4},
  [1994] = {.lex_state = 7, .external_lex_state = 4},
  [1995] = {.lex_state = 7, .external_lex_state = 4},
  [1996] = {.lex_state = 7, .external_lex_state = 4},
  [1997] = {.lex_state = 7, .external_lex_state = 4},
  [1998] = {.lex_state = 7, .external_lex_state = 4},
  [1999] = {.lex_state = 7, .external_lex_state = 4},
  [2000] = {.lex_state = 7, .external_lex_state = 4},
  [2001] = {.lex_state = 7, .external_lex_state = 4},
  [2002] = {.lex_state = 7, .external_lex_state = 4},
  [2003] = {.lex_state = 7, .external_lex_state = 4},
  [2004] = {.lex_state = 7, .external_lex_state = 4},
  [2005] = {.lex_state = 7, .external_lex_state = 4},
  [2006] = {.lex_state = 7, .external_lex_state = 4},
  [2007] = {.lex_state = 7, .external_lex_state = 4},
  [2008] = {.lex_state = 7, .external_lex_state = 4},
  [2009] = {.lex_state = 7, .external_lex_state = 4},
  [2010] = {.lex_state = 7, .external_lex_state = 4},
  [2011] = {.lex_state = 7, .external_lex_state = 4},
  [2012] = {.lex_state = 7, .external_lex_state = 4},
  [2013] = {.lex_state = 12, .external_lex_state = 5},
  [2014] = {.lex_state = 12, .external_lex_state = 5},
  [2015] = {.lex_state = 7, .external_lex_state = 4},
  [2016] = {.lex_state = 12, .external_lex_state = 5},
  [2017] = {.lex_state = 7, .external_lex_state = 3},
  [2018] = {.lex_state = 7, .external_lex_state = 3},
  [2019] = {.lex_state = 7, .external_lex_state = 4},
  [2020] = {.lex_state = 7, .external_lex_state = 4},
  [2021] = {.lex_state = 12, .external_lex_state = 5},
  [2022] = {.lex_state = 7, .external_lex_state = 4},
  [2023] = {.lex_state = 12, .external_lex_state = 5},
  [2024] = {.lex_state = 7, .external_lex_state = 4},
  [2025] = {.lex_state = 12, .external_lex_state = 2},
  [2026] = {.lex_state = 12, .external_lex_state = 5},
  [2027] = {.lex_state = 7, .external_lex_state = 4},
  [2028] = {.lex_state = 7, .external_lex_state = 4},
  [2029] = {.lex_state = 7, .external_lex_state = 4},
  [2030] = {.lex_state = 7, .external_lex_state = 4},
  [2031] = {.lex_state = 7, .external_lex_state = 3},
  [2032] = {.lex_state = 7, .external_lex_state = 3},
  [2033] = {.lex_state = 7, .external_lex_state = 3},
  [2034] = {.lex_state = 7, .external_lex_state = 3},
  [2035] = {.lex_state = 7, .external_lex_state = 3},
  [2036] = {.lex_state = 7, .external_lex_state = 3},
  [2037] = {.lex_state = 7, .external_lex_state = 3},
  [2038] = {.lex_state = 7, .external_lex_state = 3},
  [2039] = {.lex_state = 7, .external_lex_state = 3},
  [2040] = {.lex_state = 7, .external_lex_state = 3},
  [2041] = {.lex_state = 7, .external_lex_state = 3},
  [2042] = {.lex_state = 7, .external_lex_state = 3},
  [2043] = {.lex_state = 7, .external_lex_state = 3},
  [2044] = {.lex_state = 7, .external_lex_state = 3},
  [2045] = {.lex_state = 7, .external_lex_state = 3},
  [2046] = {.lex_state = 7, .external_lex_state = 3},
  [2047] = {.lex_state = 7, .external_lex_state = 3},
  [2048] = {.lex_state = 7, .external_lex_state = 3},
  [2049] = {.lex_state = 7, .external_lex_state = 3},
  [2050] = {.lex_state = 7, .external_lex_state = 3},
  [2051] = {.lex_state = 7, .external_lex_state = 3},
  [2052] = {.lex_state = 7, .external_lex_state = 3},
  [2053] = {.lex_state = 7, .external_lex_state = 3},
  [2054] = {.lex_state = 7, .external_lex_state = 3},
  [2055] = {.lex_state = 7, .external_lex_state = 3},
  [2056] = {.lex_state = 7, .external_lex_state = 3},
  [2057] = {.lex_state = 7, .external_lex_state = 3},
  [2058] = {.lex_state = 7, .external_lex_state = 3},
  [2059] = {.lex_state = 7, .external_lex_state = 3},
  [2060] = {.lex_state = 7, .external_lex_state = 4},
  [2061] = {.lex_state = 7, .external_lex_state = 4},
  [2062] = {.lex_state = 7, .external_lex_state = 4},
  [2063] = {.lex_state = 7, .external_lex_state = 3},
  [2064] = {.lex_state = 7, .external_lex_state = 3},
  [2065] = {.lex_state = 7, .external_lex_state = 3},
  [2066] = {.lex_state = 7, .external_lex_state = 4},
  [2067] = {.lex_state = 7, .external_lex_state = 4},
  [2068] = {.lex_state = 7, .external_lex_state = 4},
  [2069] = {.lex_state = 12, .external_lex_state = 5},
  [2070] = {.lex_state = 7, .external_lex_state = 3},
  [2071] = {.lex_state = 7, .external_lex_state = 4},
  [2072] = {.lex_state = 7, .external_lex_state = 3},
  [2073] = {.lex_state = 12, .external_lex_state = 5},
  [2074] = {.lex_state = 12, .external_lex_state = 5},
  [2075] = {.lex_state = 7, .external_lex_state = 3},
  [2076] = {.lex_state = 7, .external_lex_state = 4},
  [2077] = {.lex_state = 7, .external_lex_state = 3},
  [2078] = {.lex_state = 7, .external_lex_state = 3},
  [2079] = {.lex_state = 7, .external_lex_state = 4},
  [2080] = {.lex_state = 7, .external_lex_state = 4},
  [2081] = {.lex_state = 7, .external_lex_state = 4},
  [2082] = {.lex_state = 12, .external_lex_state = 5},
  [2083] = {.lex_state = 7, .external_lex_state = 3},
  [2084] = {.lex_state = 12, .external_lex_state = 5},
  [2085] = {.lex_state = 12, .external_lex_state = 2},
  [2086] = {.lex_state = 12, .external_lex_state = 5},
  [2087] = {.lex_state = 12, .external_lex_state = 2},
  [2088] = {.lex_state = 7, .external_lex_state = 3},
  [2089] = {.lex_state = 7, .external_lex_state = 4},
  [2090] = {.lex_state = 7, .external_lex_state = 4},
  [2091] = {.lex_state = 12, .external_lex_state = 2},
  [2092] = {.lex_state = 7, .external_lex_state = 3},
  [2093] = {.lex_state = 12, .external_lex_state = 5},
  [2094] = {.lex_state = 12, .external_lex_state = 2},
  [2095] = {.lex_state = 12, .external_lex_state = 2},
  [2096] = {.lex_state = 7, .external_lex_state = 4},
  [2097] = {.lex_state = 12, .external_lex_state = 2},
  [2098] = {.lex_state = 12, .external_lex_state = 5},
  [2099] = {.lex_state = 12, .external_lex_state = 5},
  [2100] = {.lex_state = 7, .external_lex_state = 4},
  [2101] = {.lex_state = 12, .external_lex_state = 5},
  [2102] = {.lex_state = 12, .external_lex_state = 5},
  [2103] = {.lex_state = 7, .external_lex_state = 4},
  [2104] = {.lex_state = 7, .external_lex_state = 4},
  [2105] = {.lex_state = 7, .external_lex_state = 4},
  [2106] = {.lex_state = 12, .external_lex_state = 5},
  [2107] = {.lex_state = 12, .external_lex_state = 5},
  [2108] = {.lex_state = 12, .external_lex_state = 5},
  [2109] = {.lex_state = 7, .external_lex_state = 3},
  [2110] = {.lex_state = 7, .external_lex_state = 3},
  [2111] = {.lex_state = 12, .external_lex_state = 5},
  [2112] = {.lex_state = 12, .external_lex_state = 5},
  [2113] = {.lex_state = 12, .external_lex_state = 5},
  [2114] = {.lex_state = 12, .external_lex_state = 5},
  [2115] = {.lex_state = 12, .external_lex_state = 5},
  [2116] = {.lex_state = 7, .external_lex_state = 4},
  [2117] = {.lex_state = 12, .external_lex_state = 5},
  [2118] = {.lex_state = 12, .external_lex_state = 5},
  [2119] = {.lex_state = 12, .external_lex_state = 5},
  [2120] = {.lex_state = 7, .external_lex_state = 4},
  [2121] = {.lex_state = 7, .external_lex_state = 4},
  [2122] = {.lex_state = 7, .external_lex_state = 4},
  [2123] = {.lex_state = 7, .external_lex_state = 4},
  [2124] = {.lex_state = 7, .external_lex_state = 4},
  [2125] = {.lex_state = 7, .external_lex_state = 3},
  [2126] = {.lex_state = 7, .external_lex_state = 4},
  [2127] = {.lex_state = 7, .external_lex_state = 4},
  [2128] = {.lex_state = 7, .external_lex_state = 4},
  [2129] = {.lex_state = 7, .external_lex_state = 3},
  [2130] = {.lex_state = 7, .external_lex_state = 4},
  [2131] = {.lex_state = 7, .external_lex_state = 4},
  [2132] = {.lex_state = 7, .external_lex_state = 4},
  [2133] = {.lex_state = 7, .external_lex_state = 4},
  [2134] = {.lex_state = 7, .external_lex_state = 4},
  [2135] = {.lex_state = 7, .external_lex_state = 4},
  [2136] = {.lex_state = 7, .external_lex_state = 4},
  [2137] = {.lex_state = 7, .external_lex_state = 4},
  [2138] = {.lex_state = 7, .external_lex_state = 4},
  [2139] = {.lex_state = 7, .external_lex_state = 4},
  [2140] = {.lex_state = 7, .external_lex_state = 4},
  [2141] = {.lex_state = 7, .external_lex_state = 4},
  [2142] = {.lex_state = 7, .external_lex_state = 4},
  [2143] = {.lex_state = 7, .external_lex_state = 4},
  [2144] = {.lex_state = 7, .external_lex_state = 4},
  [2145] = {.lex_state = 7, .external_lex_state = 3},
  [2146] = {.lex_state = 7, .external_lex_state = 4},
  [2147] = {.lex_state = 7, .external_lex_state = 3},
  [2148] = {.lex_state = 7, .external_lex_state = 4},
  [2149] = {.lex_state = 7, .external_lex_state = 4},
  [2150] = {.lex_state = 7, .external_lex_state = 4},
  [2151] = {.lex_state = 7, .external_lex_state = 4},
  [2152] = {.lex_state = 7, .external_lex_state = 4},
  [2153] = {.lex_state = 7, .external_lex_state = 4},
  [2154] = {.lex_state = 7, .external_lex_state = 4},
  [2155] = {.lex_state = 7, .external_lex_state = 4},
  [2156] = {.lex_state = 7, .external_lex_state = 4},
  [2157] = {.lex_state = 7, .external_lex_state = 4},
  [2158] = {.lex_state = 7, .external_lex_state = 4},
  [2159] = {.lex_state = 7, .external_lex_state = 3},
  [2160] = {.lex_state = 7, .external_lex_state = 4},
  [2161] = {.lex_state = 7, .external_lex_state = 4},
  [2162] = {.lex_state = 7, .external_lex_state = 4},
  [2163] = {.lex_state = 7, .external_lex_state = 4},
  [2164] = {.lex_state = 7, .external_lex_state = 4},
  [2165] = {.lex_state = 7, .external_lex_state = 4},
  [2166] = {.lex_state = 7, .external_lex_state = 4},
  [2167] = {.lex_state = 7, .external_lex_state = 3},
  [2168] = {.lex_state = 7, .external_lex_state = 4},
  [2169] = {.lex_state = 12, .external_lex_state = 5},
  [2170] = {.lex_state = 7, .external_lex_state = 4},
  [2171] = {.lex_state = 7, .external_lex_state = 4},
  [2172] = {.lex_state = 7, .external_lex_state = 4},
  [2173] = {.lex_state = 7, .external_lex_state = 3},
  [2174] = {.lex_state = 7, .external_lex_state = 3},
  [2175] = {.lex_state = 7, .external_lex_state = 4},
  [2176] = {.lex_state = 8, .external_lex_state = 4},
  [2177] = {.lex_state = 7, .external_lex_state = 4},
  [2178] = {.lex_state = 7, .external_lex_state = 3},
  [2179] = {.lex_state = 7, .external_lex_state = 4},
  [2180] = {.lex_state = 7, .external_lex_state = 4},
  [2181] = {.lex_state = 7, .external_lex_state = 4},
  [2182] = {.lex_state = 7, .external_lex_state = 3},
  [2183] = {.lex_state = 7, .external_lex_state = 4},
  [2184] = {.lex_state = 7, .external_lex_state = 4},
  [2185] = {.lex_state = 7, .external_lex_state = 3},
  [2186] = {.lex_state = 7, .external_lex_state = 4},
  [2187] = {.lex_state = 7, .external_lex_state = 4},
  [2188] = {.lex_state = 7, .external_lex_state = 4},
  [2189] = {.lex_state = 7, .external_lex_state = 4},
  [2190] = {.lex_state = 7, .external_lex_state = 3},
  [2191] = {.lex_state = 7, .external_lex_state = 4},
  [2192] = {.lex_state = 7, .external_lex_state = 4},
  [2193] = {.lex_state = 7, .external_lex_state = 4},
  [2194] = {.lex_state = 7, .external_lex_state = 4},
  [2195] = {.lex_state = 7, .external_lex_state = 4},
  [2196] = {.lex_state = 7, .external_lex_state = 3},
  [2197] = {.lex_state = 7, .external_lex_state = 3},
  [2198] = {.lex_state = 7, .external_lex_state = 3},
  [2199] = {.lex_state = 7, .external_lex_state = 3},
  [2200] = {.lex_state = 7, .external_lex_state = 3},
  [2201] = {.lex_state = 7, .external_lex_state = 3},
  [2202] = {.lex_state = 7, .external_lex_state = 3},
  [2203] = {.lex_state = 7, .external_lex_state = 3},
  [2204] = {.lex_state = 7, .external_lex_state = 3},
  [2205] = {.lex_state = 7, .external_lex_state = 3},
  [2206] = {.lex_state = 7, .external_lex_state = 3},
  [2207] = {.lex_state = 7, .external_lex_state = 4},
  [2208] = {.lex_state = 7, .external_lex_state = 4},
  [2209] = {.lex_state = 7, .external_lex_state = 4},
  [2210] = {.lex_state = 7, .external_lex_state = 4},
  [2211] = {.lex_state = 7, .external_lex_state = 3},
  [2212] = {.lex_state = 12, .external_lex_state = 5},
  [2213] = {.lex_state = 7, .external_lex_state = 4},
  [2214] = {.lex_state = 7, .external_lex_state = 4},
  [2215] = {.lex_state = 12, .external_lex_state = 5},
  [2216] = {.lex_state = 7, .external_lex_state = 3},
  [2217] = {.lex_state = 12, .external_lex_state = 5},
  [2218] = {.lex_state = 7, .external_lex_state = 4},
  [2219] = {.lex_state = 7, .external_lex_state = 4},
  [2220] = {.lex_state = 7, .external_lex_state = 3},
  [2221] = {.lex_state = 7, .external_lex_state = 4},
  [2222] = {.lex_state = 7, .external_lex_state = 4},
  [2223] = {.lex_state = 7, .external_lex_state = 4},
  [2224] = {.lex_state = 7, .external_lex_state = 3},
  [2225] = {.lex_state = 7, .external_lex_state = 4},
  [2226] = {.lex_state = 7, .external_lex_state = 4},
  [2227] = {.lex_state = 12, .external_lex_state = 2},
  [2228] = {.lex_state = 7, .external_lex_state = 4},
  [2229] = {.lex_state = 12, .external_lex_state = 2},
  [2230] = {.lex_state = 12, .external_lex_state = 5},
  [2231] = {.lex_state = 7, .external_lex_state = 4},
  [2232] = {.lex_state = 7, .external_lex_state = 4},
  [2233] = {.lex_state = 7, .external_lex_state = 3},
  [2234] = {.lex_state = 7, .external_lex_state = 3},
  [2235] = {.lex_state = 12, .external_lex_state = 5},
  [2236] = {.lex_state = 12, .external_lex_state = 5},
  [2237] = {.lex_state = 7, .external_lex_state = 3},
  [2238] = {.lex_state = 7, .external_lex_state = 3},
  [2239] = {.lex_state = 7, .external_lex_state = 3},
  [2240] = {.lex_state = 12, .external_lex_state = 5},
  [2241] = {.lex_state = 7, .external_lex_state = 3},
  [2242] = {.lex_state = 12, .external_lex_state = 5},
  [2243] = {.lex_state = 7, .external_lex_state = 3},
  [2244] = {.lex_state = 7, .external_lex_state = 3},
  [2245] = {.lex_state = 7, .external_lex_state = 3},
  [2246] = {.lex_state = 12, .external_lex_state = 5},
  [2247] = {.lex_state = 12, .external_lex_state = 5},
  [2248] = {.lex_state = 12, .external_lex_state = 5},
  [2249] = {.lex_state = 7, .external_lex_state = 3},
  [2250] = {.lex_state = 7, .external_lex_state = 3},
  [2251] = {.lex_state = 7, .external_lex_state = 3},
  [2252] = {.lex_state = 7, .external_lex_state = 3},
  [2253] = {.lex_state = 7, .external_lex_state = 3},
  [2254] = {.lex_state = 7, .external_lex_state = 3},
  [2255] = {.lex_state = 7, .external_lex_state = 3},
  [2256] = {.lex_state = 7, .external_lex_state = 3},
  [2257] = {.lex_state = 7, .external_lex_state = 3},
  [2258] = {.lex_state = 7, .external_lex_state = 3},
  [2259] = {.lex_state = 7, .external_lex_state = 3},
  [2260] = {.lex_state = 7, .external_lex_state = 3},
  [2261] = {.lex_state = 7, .external_lex_state = 3},
  [2262] = {.lex_state = 7, .external_lex_state = 3},
  [2263] = {.lex_state = 7, .external_lex_state = 3},
  [2264] = {.lex_state = 7, .external_lex_state = 3},
  [2265] = {.lex_state = 7, .external_lex_state = 3},
  [2266] = {.lex_state = 7, .external_lex_state = 3},
  [2267] = {.lex_state = 7, .external_lex_state = 3},
  [2268] = {.lex_state = 7, .external_lex_state = 3},
  [2269] = {.lex_state = 7, .external_lex_state = 3},
  [2270] = {.lex_state = 7, .external_lex_state = 3},
  [2271] = {.lex_state = 7, .external_lex_state = 3},
  [2272] = {.lex_state = 7, .external_lex_state = 3},
  [2273] = {.lex_state = 7, .external_lex_state = 3},
  [2274] = {.lex_state = 7, .external_lex_state = 4},
  [2275] = {.lex_state = 7, .external_lex_state = 4},
  [2276] = {.lex_state = 7, .external_lex_state = 3},
  [2277] = {.lex_state = 7, .external_lex_state = 4},
  [2278] = {.lex_state = 149, .external_lex_state = 2},
  [2279] = {.lex_state = 7, .external_lex_state = 3},
  [2280] = {.lex_state = 7, .external_lex_state = 3},
  [2281] = {.lex_state = 7, .external_lex_state = 3},
  [2282] = {.lex_state = 7, .external_lex_state = 3},
  [2283] = {.lex_state = 7, .external_lex_state = 4},
  [2284] = {.lex_state = 7, .external_lex_state = 4},
  [2285] = {.lex_state = 7, .external_lex_state = 4},
  [2286] = {.lex_state = 7, .external_lex_state = 4},
  [2287] = {.lex_state = 7, .external_lex_state = 3},
  [2288] = {.lex_state = 7, .external_lex_state = 4},
  [2289] = {.lex_state = 12, .external_lex_state = 5},
  [2290] = {.lex_state = 12, .external_lex_state = 5},
  [2291] = {.lex_state = 7, .external_lex_state = 4},
  [2292] = {.lex_state = 12, .external_lex_state = 2},
  [2293] = {.lex_state = 7, .external_lex_state = 4},
  [2294] = {.lex_state = 12, .external_lex_state = 2},
  [2295] = {.lex_state = 12, .external_lex_state = 5},
  [2296] = {.lex_state = 7, .external_lex_state = 3},
  [2297] = {.lex_state = 12, .external_lex_state = 5},
  [2298] = {.lex_state = 7, .external_lex_state = 4},
  [2299] = {.lex_state = 7, .external_lex_state = 4},
  [2300] = {.lex_state = 7, .external_lex_state = 4},
  [2301] = {.lex_state = 7, .external_lex_state = 4},
  [2302] = {.lex_state = 7, .external_lex_state = 4},
  [2303] = {.lex_state = 7, .external_lex_state = 4},
  [2304] = {.lex_state = 7, .external_lex_state = 3},
  [2305] = {.lex_state = 7, .external_lex_state = 4},
  [2306] = {.lex_state = 7, .external_lex_state = 3},
  [2307] = {.lex_state = 7, .external_lex_state = 3},
  [2308] = {.lex_state = 7, .external_lex_state = 3},
  [2309] = {.lex_state = 12, .external_lex_state = 5},
  [2310] = {.lex_state = 7, .external_lex_state = 3},
  [2311] = {.lex_state = 7, .external_lex_state = 3},
  [2312] = {.lex_state = 7, .external_lex_state = 3},
  [2313] = {.lex_state = 12, .external_lex_state = 5},
  [2314] = {.lex_state = 12, .external_lex_state = 5},
  [2315] = {.lex_state = 7, .external_lex_state = 3},
  [2316] = {.lex_state = 7, .external_lex_state = 3},
  [2317] = {.lex_state = 7, .external_lex_state = 3},
  [2318] = {.lex_state = 7, .external_lex_state = 3},
  [2319] = {.lex_state = 7, .external_lex_state = 4},
  [2320] = {.lex_state = 7, .external_lex_state = 4},
  [2321] = {.lex_state = 7, .external_lex_state = 4},
  [2322] = {.lex_state = 7, .external_lex_state = 4},
  [2323] = {.lex_state = 7, .external_lex_state = 4},
  [2324] = {.lex_state = 7, .external_lex_state = 4},
  [2325] = {.lex_state = 7, .external_lex_state = 4},
  [2326] = {.lex_state = 7, .external_lex_state = 4},
  [2327] = {.lex_state = 7, .external_lex_state = 4},
  [2328] = {.lex_state = 7, .external_lex_state = 4},
  [2329] = {.lex_state = 7, .external_lex_state = 4},
  [2330] = {.lex_state = 7, .external_lex_state = 3},
  [2331] = {.lex_state = 12, .external_lex_state = 5},
  [2332] = {.lex_state = 7, .external_lex_state = 3},
  [2333] = {.lex_state = 7, .external_lex_state = 3},
  [2334] = {.lex_state = 12, .external_lex_state = 2},
  [2335] = {.lex_state = 7, .external_lex_state = 3},
  [2336] = {.lex_state = 12, .external_lex_state = 2},
  [2337] = {.lex_state = 149, .external_lex_state = 2},
  [2338] = {.lex_state = 7, .external_lex_state = 4},
  [2339] = {.lex_state = 7, .external_lex_state = 4},
  [2340] = {.lex_state = 8, .external_lex_state = 4},
  [2341] = {.lex_state = 7, .external_lex_state = 4},
  [2342] = {.lex_state = 7, .external_lex_state = 3},
  [2343] = {.lex_state = 12, .external_lex_state = 5},
  [2344] = {.lex_state = 12, .external_lex_state = 5},
  [2345] = {.lex_state = 12, .external_lex_state = 5},
  [2346] = {.lex_state = 7, .external_lex_state = 3},
  [2347] = {.lex_state = 7, .external_lex_state = 3},
  [2348] = {.lex_state = 7, .external_lex_state = 3},
  [2349] = {.lex_state = 7, .external_lex_state = 3},
  [2350] = {.lex_state = 7, .external_lex_state = 4},
  [2351] = {.lex_state = 7, .external_lex_state = 3},
  [2352] = {.lex_state = 7, .external_lex_state = 3},
  [2353] = {.lex_state = 7, .external_lex_state = 3},
  [2354] = {.lex_state = 7, .external_lex_state = 4},
  [2355] = {.lex_state = 7, .external_lex_state = 4},
  [2356] = {.lex_state = 7, .external_lex_state = 3},
  [2357] = {.lex_state = 7, .external_lex_state = 3},
  [2358] = {.lex_state = 12, .external_lex_state = 5},
  [2359] = {.lex_state = 7, .external_lex_state = 3},
  [2360] = {.lex_state = 7, .external_lex_state = 3},
  [2361] = {.lex_state = 7, .external_lex_state = 3},
  [2362] = {.lex_state = 7, .external_lex_state = 3},
  [2363] = {.lex_state = 7, .external_lex_state = 3},
  [2364] = {.lex_state = 7, .external_lex_state = 3},
  [2365] = {.lex_state = 7, .external_lex_state = 3},
  [2366] = {.lex_state = 7, .external_lex_state = 3},
  [2367] = {.lex_state = 7, .external_lex_state = 3},
  [2368] = {.lex_state = 7, .external_lex_state = 3},
  [2369] = {.lex_state = 7, .external_lex_state = 3},
  [2370] = {.lex_state = 7, .external_lex_state = 3},
  [2371] = {.lex_state = 7, .external_lex_state = 3},
  [2372] = {.lex_state = 7, .external_lex_state = 3},
  [2373] = {.lex_state = 7, .external_lex_state = 3},
  [2374] = {.lex_state = 7, .external_lex_state = 3},
  [2375] = {.lex_state = 12, .external_lex_state = 2},
  [2376] = {.lex_state = 7, .external_lex_state = 3},
  [2377] = {.lex_state = 7, .external_lex_state = 4},
  [2378] = {.lex_state = 12, .external_lex_state = 2},
  [2379] = {.lex_state = 7, .external_lex_state = 4},
  [2380] = {.lex_state = 7, .external_lex_state = 3},
  [2381] = {.lex_state = 7, .external_lex_state = 3},
  [2382] = {.lex_state = 12, .external_lex_state = 5},
  [2383] = {.lex_state = 7, .external_lex_state = 3},
  [2384] = {.lex_state = 7, .external_lex_state = 3},
  [2385] = {.lex_state = 7, .external_lex_state = 3},
  [2386] = {.lex_state = 12, .external_lex_state = 2},
  [2387] = {.lex_state = 7, .external_lex_state = 4},
  [2388] = {.lex_state = 7, .external_lex_state = 3},
  [2389] = {.lex_state = 7, .external_lex_state = 3},
  [2390] = {.lex_state = 12, .external_lex_state = 5},
  [2391] = {.lex_state = 7, .external_lex_state = 3},
  [2392] = {.lex_state = 12, .external_lex_state = 5},
  [2393] = {.lex_state = 12, .external_lex_state = 5},
  [2394] = {.lex_state = 7, .external_lex_state = 3},
  [2395] = {.lex_state = 12, .external_lex_state = 5},
  [2396] = {.lex_state = 149, .external_lex_state = 2},
  [2397] = {.lex_state = 12, .external_lex_state = 5},
  [2398] = {.lex_state = 12, .external_lex_state = 5},
  [2399] = {.lex_state = 12, .external_lex_state = 5},
  [2400] = {.lex_state = 12, .external_lex_state = 2},
  [2401] = {.lex_state = 12, .external_lex_state = 5},
  [2402] = {.lex_state = 7, .external_lex_state = 3},
  [2403] = {.lex_state = 12, .external_lex_state = 5},
  [2404] = {.lex_state = 7, .external_lex_state = 3},
  [2405] = {.lex_state = 12, .external_lex_state = 2},
  [2406] = {.lex_state = 12, .external_lex_state = 5},
  [2407] = {.lex_state = 12, .external_lex_state = 5},
  [2408] = {.lex_state = 7, .external_lex_state = 3},
  [2409] = {.lex_state = 12, .external_lex_state = 5},
  [2410] = {.lex_state = 12, .external_lex_state = 5},
  [2411] = {.lex_state = 7, .external_lex_state = 4},
  [2412] = {.lex_state = 7, .external_lex_state = 4},
  [2413] = {.lex_state = 7, .external_lex_state = 4},
  [2414] = {.lex_state = 12, .external_lex_state = 5},
  [2415] = {.lex_state = 12, .external_lex_state = 5},
  [2416] = {.lex_state = 7, .external_lex_state = 4},
  [2417] = {.lex_state = 12, .external_lex_state = 5},
  [2418] = {.lex_state = 12, .external_lex_state = 5},
  [2419] = {.lex_state = 7, .external_lex_state = 4},
  [2420] = {.lex_state = 12, .external_lex_state = 5},
  [2421] = {.lex_state = 12, .external_lex_state = 5},
  [2422] = {.lex_state = 7, .external_lex_state = 3},
  [2423] = {.lex_state = 7, .external_lex_state = 3},
  [2424] = {.lex_state = 7, .external_lex_state = 3},
  [2425] = {.lex_state = 12, .external_lex_state = 2},
  [2426] = {.lex_state = 12, .external_lex_state = 2},
  [2427] = {.lex_state = 149, .external_lex_state = 2},
  [2428] = {.lex_state = 12, .external_lex_state = 5},
  [2429] = {.lex_state = 7, .external_lex_state = 3},
  [2430] = {.lex_state = 8, .external_lex_state = 3},
  [2431] = {.lex_state = 7, .external_lex_state = 4},
  [2432] = {.lex_state = 7, .external_lex_state = 3},
  [2433] = {.lex_state = 7, .external_lex_state = 4},
  [2434] = {.lex_state = 7, .external_lex_state = 3},
  [2435] = {.lex_state = 7, .external_lex_state = 3},
  [2436] = {.lex_state = 7, .external_lex_state = 3},
  [2437] = {.lex_state = 7, .external_lex_state = 3},
  [2438] = {.lex_state = 7, .external_lex_state = 3},
  [2439] = {.lex_state = 7, .external_lex_state = 3},
  [2440] = {.lex_state = 7, .external_lex_state = 3},
  [2441] = {.lex_state = 7, .external_lex_state = 3},
  [2442] = {.lex_state = 7, .external_lex_state = 3},
  [2443] = {.lex_state = 7, .external_lex_state = 3},
  [2444] = {.lex_state = 7, .external_lex_state = 3},
  [2445] = {.lex_state = 7, .external_lex_state = 3},
  [2446] = {.lex_state = 7, .external_lex_state = 3},
  [2447] = {.lex_state = 7, .external_lex_state = 3},
  [2448] = {.lex_state = 7, .external_lex_state = 3},
  [2449] = {.lex_state = 7, .external_lex_state = 3},
  [2450] = {.lex_state = 7, .external_lex_state = 3},
  [2451] = {.lex_state = 7, .external_lex_state = 3},
  [2452] = {.lex_state = 7, .external_lex_state = 3},
  [2453] = {.lex_state = 7, .external_lex_state = 3},
  [2454] = {.lex_state = 7, .external_lex_state = 3},
  [2455] = {.lex_state = 7, .external_lex_state = 3},
  [2456] = {.lex_state = 7, .external_lex_state = 3},
  [2457] = {.lex_state = 7, .external_lex_state = 3},
  [2458] = {.lex_state = 7, .external_lex_state = 3},
  [2459] = {.lex_state = 7, .external_lex_state = 3},
  [2460] = {.lex_state = 7, .external_lex_state = 4},
  [2461] = {.lex_state = 12, .external_lex_state = 5},
  [2462] = {.lex_state = 12, .external_lex_state = 5},
  [2463] = {.lex_state = 7, .external_lex_state = 4},
  [2464] = {.lex_state = 12, .external_lex_state = 5},
  [2465] = {.lex_state = 7, .external_lex_state = 3},
  [2466] = {.lex_state = 7, .external_lex_state = 3},
  [2467] = {.lex_state = 7, .external_lex_state = 3},
  [2468] = {.lex_state = 7, .external_lex_state = 3},
  [2469] = {.lex_state = 7, .external_lex_state = 3},
  [2470] = {.lex_state = 7, .external_lex_state = 3},
  [2471] = {.lex_state = 7, .external_lex_state = 3},
  [2472] = {.lex_state = 7, .external_lex_state = 3},
  [2473] = {.lex_state = 7, .external_lex_state = 3},
  [2474] = {.lex_state = 7, .external_lex_state = 3},
  [2475] = {.lex_state = 7, .external_lex_state = 3},
  [2476] = {.lex_state = 7, .external_lex_state = 3},
  [2477] = {.lex_state = 7, .external_lex_state = 3},
  [2478] = {.lex_state = 7, .external_lex_state = 3},
  [2479] = {.lex_state = 7, .external_lex_state = 3},
  [2480] = {.lex_state = 7, .external_lex_state = 3},
  [2481] = {.lex_state = 12, .external_lex_state = 2},
  [2482] = {.lex_state = 7, .external_lex_state = 3},
  [2483] = {.lex_state = 7, .external_lex_state = 3},
  [2484] = {.lex_state = 7, .external_lex_state = 3},
  [2485] = {.lex_state = 7, .external_lex_state = 3},
  [2486] = {.lex_state = 149, .external_lex_state = 5},
  [2487] = {.lex_state = 149, .external_lex_state = 5},
  [2488] = {.lex_state = 7, .external_lex_state = 3},
  [2489] = {.lex_state = 7, .external_lex_state = 3},
  [2490] = {.lex_state = 7, .external_lex_state = 3},
  [2491] = {.lex_state = 7, .external_lex_state = 3},
  [2492] = {.lex_state = 7, .external_lex_state = 3},
  [2493] = {.lex_state = 149, .external_lex_state = 2},
  [2494] = {.lex_state = 7, .external_lex_state = 3},
  [2495] = {.lex_state = 149, .external_lex_state = 2},
  [2496] = {.lex_state = 12, .external_lex_state = 5},
  [2497] = {.lex_state = 7, .external_lex_state = 3},
  [2498] = {.lex_state = 149, .external_lex_state = 2},
  [2499] = {.lex_state = 7, .external_lex_state = 3},
  [2500] = {.lex_state = 12, .external_lex_state = 5},
  [2501] = {.lex_state = 7, .external_lex_state = 3},
  [2502] = {.lex_state = 7, .external_lex_state = 3},
  [2503] = {.lex_state = 7, .external_lex_state = 3},
  [2504] = {.lex_state = 7, .external_lex_state = 3},
  [2505] = {.lex_state = 7, .external_lex_state = 3},
  [2506] = {.lex_state = 7, .external_lex_state = 3},
  [2507] = {.lex_state = 7, .external_lex_state = 3},
  [2508] = {.lex_state = 7, .external_lex_state = 3},
  [2509] = {.lex_state = 7, .external_lex_state = 3},
  [2510] = {.lex_state = 7, .external_lex_state = 3},
  [2511] = {.lex_state = 7, .external_lex_state = 3},
  [2512] = {.lex_state = 7, .external_lex_state = 3},
  [2513] = {.lex_state = 7, .external_lex_state = 3},
  [2514] = {.lex_state = 7, .external_lex_state = 3},
  [2515] = {.lex_state = 7, .external_lex_state = 3},
  [2516] = {.lex_state = 7, .external_lex_state = 3},
  [2517] = {.lex_state = 7, .external_lex_state = 3},
  [2518] = {.lex_state = 7, .external_lex_state = 3},
  [2519] = {.lex_state = 7, .external_lex_state = 3},
  [2520] = {.lex_state = 7, .external_lex_state = 3},
  [2521] = {.lex_state = 7, .external_lex_state = 3},
  [2522] = {.lex_state = 7, .external_lex_state = 3},
  [2523] = {.lex_state = 7, .external_lex_state = 3},
  [2524] = {.lex_state = 7, .external_lex_state = 3},
  [2525] = {.lex_state = 7, .external_lex_state = 3},
  [2526] = {.lex_state = 7, .external_lex_state = 3},
  [2527] = {.lex_state = 7, .external_lex_state = 3},
  [2528] = {.lex_state = 7, .external_lex_state = 3},
  [2529] = {.lex_state = 7, .external_lex_state = 3},
  [2530] = {.lex_state = 7, .external_lex_state = 3},
  [2531] = {.lex_state = 12, .external_lex_state = 2},
  [2532] = {.lex_state = 12, .external_lex_state = 2},
  [2533] = {.lex_state = 12, .external_lex_state = 2},
  [2534] = {.lex_state = 12, .external_lex_state = 2},
  [2535] = {.lex_state = 12, .external_lex_state = 2},
  [2536] = {.lex_state = 7, .external_lex_state = 3},
  [2537] = {.lex_state = 7, .external_lex_state = 3},
  [2538] = {.lex_state = 7, .external_lex_state = 3},
  [2539] = {.lex_state = 7, .external_lex_state = 3},
  [2540] = {.lex_state = 7, .external_lex_state = 3},
  [2541] = {.lex_state = 149, .external_lex_state = 5},
  [2542] = {.lex_state = 149, .external_lex_state = 5},
  [2543] = {.lex_state = 149, .external_lex_state = 5},
  [2544] = {.lex_state = 149, .external_lex_state = 5},
  [2545] = {.lex_state = 7, .external_lex_state = 3},
  [2546] = {.lex_state = 7, .external_lex_state = 3},
  [2547] = {.lex_state = 7, .external_lex_state = 3},
  [2548] = {.lex_state = 7, .external_lex_state = 3},
  [2549] = {.lex_state = 7, .external_lex_state = 3},
  [2550] = {.lex_state = 7, .external_lex_state = 3},
  [2551] = {.lex_state = 7, .external_lex_state = 3},
  [2552] = {.lex_state = 7, .external_lex_state = 3},
  [2553] = {.lex_state = 7, .external_lex_state = 3},
  [2554] = {.lex_state = 7, .external_lex_state = 3},
  [2555] = {.lex_state = 7, .external_lex_state = 4},
  [2556] = {.lex_state = 7, .external_lex_state = 3},
  [2557] = {.lex_state = 149, .external_lex_state = 5},
  [2558] = {.lex_state = 149, .external_lex_state = 5},
  [2559] = {.lex_state = 149, .external_lex_state = 5},
  [2560] = {.lex_state = 149, .external_lex_state = 5},
  [2561] = {.lex_state = 7, .external_lex_state = 3},
  [2562] = {.lex_state = 7, .external_lex_state = 3},
  [2563] = {.lex_state = 7, .external_lex_state = 3},
  [2564] = {.lex_state = 7, .external_lex_state = 3},
  [2565] = {.lex_state = 7, .external_lex_state = 3},
  [2566] = {.lex_state = 12, .external_lex_state = 2},
  [2567] = {.lex_state = 149, .external_lex_state = 5},
  [2568] = {.lex_state = 8, .external_lex_state = 3},
  [2569] = {.lex_state = 149, .external_lex_state = 5},
  [2570] = {.lex_state = 149, .external_lex_state = 5},
  [2571] = {.lex_state = 149, .external_lex_state = 5},
  [2572] = {.lex_state = 149, .external_lex_state = 5},
  [2573] = {.lex_state = 149, .external_lex_state = 5},
  [2574] = {.lex_state = 149, .external_lex_state = 5},
  [2575] = {.lex_state = 12, .external_lex_state = 2},
  [2576] = {.lex_state = 12, .external_lex_state = 2},
  [2577] = {.lex_state = 12, .external_lex_state = 2},
  [2578] = {.lex_state = 149, .external_lex_state = 5},
  [2579] = {.lex_state = 12, .external_lex_state = 2},
  [2580] = {.lex_state = 12, .external_lex_state = 2},
  [2581] = {.lex_state = 12, .external_lex_state = 2},
  [2582] = {.lex_state = 12, .external_lex_state = 2},
  [2583] = {.lex_state = 149, .external_lex_state = 5},
  [2584] = {.lex_state = 7, .external_lex_state = 3},
  [2585] = {.lex_state = 12, .external_lex_state = 2},
  [2586] = {.lex_state = 149, .external_lex_state = 5},
  [2587] = {.lex_state = 149, .external_lex_state = 5},
  [2588] = {.lex_state = 12, .external_lex_state = 2},
  [2589] = {.lex_state = 12, .external_lex_state = 2},
  [2590] = {.lex_state = 149, .external_lex_state = 5},
  [2591] = {.lex_state = 149, .external_lex_state = 5},
  [2592] = {.lex_state = 7, .external_lex_state = 3},
  [2593] = {.lex_state = 149, .external_lex_state = 5},
  [2594] = {.lex_state = 12, .external_lex_state = 2},
  [2595] = {.lex_state = 12, .external_lex_state = 2},
  [2596] = {.lex_state = 7, .external_lex_state = 3},
  [2597] = {.lex_state = 12, .external_lex_state = 2},
  [2598] = {.lex_state = 12, .external_lex_state = 2},
  [2599] = {.lex_state = 149, .external_lex_state = 5},
  [2600] = {.lex_state = 149, .external_lex_state = 5},
  [2601] = {.lex_state = 7, .external_lex_state = 3},
  [2602] = {.lex_state = 7, .external_lex_state = 3},
  [2603] = {.lex_state = 12, .external_lex_state = 2},
  [2604] = {.lex_state = 12, .external_lex_state = 5},
  [2605] = {.lex_state = 7, .external_lex_state = 3},
  [2606] = {.lex_state = 12, .external_lex_state = 5},
  [2607] = {.lex_state = 12, .external_lex_state = 5},
  [2608] = {.lex_state = 7, .external_lex_state = 3},
  [2609] = {.lex_state = 12, .external_lex_state = 2},
  [2610] = {.lex_state = 12, .external_lex_state = 5},
  [2611] = {.lex_state = 12, .external_lex_state = 5},
  [2612] = {.lex_state = 12, .external_lex_state = 5},
  [2613] = {.lex_state = 12, .external_lex_state = 5},
  [2614] = {.lex_state = 12, .external_lex_state = 5},
  [2615] = {.lex_state = 12, .external_lex_state = 5},
  [2616] = {.lex_state = 12, .external_lex_state = 5},
  [2617] = {.lex_state = 12, .external_lex_state = 5},
  [2618] = {.lex_state = 12, .external_lex_state = 5},
  [2619] = {.lex_state = 7, .external_lex_state = 3},
  [2620] = {.lex_state = 12, .external_lex_state = 5},
  [2621] = {.lex_state = 12, .external_lex_state = 5},
  [2622] = {.lex_state = 12, .external_lex_state = 5},
  [2623] = {.lex_state = 12, .external_lex_state = 5},
  [2624] = {.lex_state = 12, .external_lex_state = 5},
  [2625] = {.lex_state = 12, .external_lex_state = 5},
  [2626] = {.lex_state = 12, .external_lex_state = 5},
  [2627] = {.lex_state = 7, .external_lex_state = 3},
  [2628] = {.lex_state = 12, .external_lex_state = 5},
  [2629] = {.lex_state = 12, .external_lex_state = 5},
  [2630] = {.lex_state = 12, .external_lex_state = 5},
  [2631] = {.lex_state = 12, .external_lex_state = 5},
  [2632] = {.lex_state = 12, .external_lex_state = 5},
  [2633] = {.lex_state = 12, .external_lex_state = 5},
  [2634] = {.lex_state = 12, .external_lex_state = 5},
  [2635] = {.lex_state = 7, .external_lex_state = 3},
  [2636] = {.lex_state = 12, .external_lex_state = 5},
  [2637] = {.lex_state = 12, .external_lex_state = 5},
  [2638] = {.lex_state = 7, .external_lex_state = 3},
  [2639] = {.lex_state = 12, .external_lex_state = 5},
  [2640] = {.lex_state = 12, .external_lex_state = 5},
  [2641] = {.lex_state = 12, .external_lex_state = 5},
  [2642] = {.lex_state = 12, .external_lex_state = 5},
  [2643] = {.lex_state = 7, .external_lex_state = 3},
  [2644] = {.lex_state = 12, .external_lex_state = 5},
  [2645] = {.lex_state = 12, .external_lex_state = 5},
  [2646] = {.lex_state = 12, .external_lex_state = 5},
  [2647] = {.lex_state = 12, .external_lex_state = 5},
  [2648] = {.lex_state = 7, .external_lex_state = 3},
  [2649] = {.lex_state = 12, .external_lex_state = 5},
  [2650] = {.lex_state = 12, .external_lex_state = 5},
  [2651] = {.lex_state = 12, .external_lex_state = 5},
  [2652] = {.lex_state = 12, .external_lex_state = 5},
  [2653] = {.lex_state = 12, .external_lex_state = 5},
  [2654] = {.lex_state = 12, .external_lex_state = 5},
  [2655] = {.lex_state = 12, .external_lex_state = 5},
  [2656] = {.lex_state = 12, .external_lex_state = 5},
  [2657] = {.lex_state = 12, .external_lex_state = 5},
  [2658] = {.lex_state = 12, .external_lex_state = 5},
  [2659] = {.lex_state = 12, .external_lex_state = 2},
  [2660] = {.lex_state = 12, .external_lex_state = 5},
  [2661] = {.lex_state = 7, .external_lex_state = 3},
  [2662] = {.lex_state = 12, .external_lex_state = 5},
  [2663] = {.lex_state = 12, .external_lex_state = 5},
  [2664] = {.lex_state = 12, .external_lex_state = 5},
  [2665] = {.lex_state = 7, .external_lex_state = 3},
  [2666] = {.lex_state = 12, .external_lex_state = 5},
  [2667] = {.lex_state = 12, .external_lex_state = 2},
  [2668] = {.lex_state = 12, .external_lex_state = 5},
  [2669] = {.lex_state = 7, .external_lex_state = 3},
  [2670] = {.lex_state = 12, .external_lex_state = 2},
  [2671] = {.lex_state = 12, .external_lex_state = 2},
  [2672] = {.lex_state = 12, .external_lex_state = 2},
  [2673] = {.lex_state = 12, .external_lex_state = 2},
  [2674] = {.lex_state = 12, .external_lex_state = 2},
  [2675] = {.lex_state = 12, .external_lex_state = 2},
  [2676] = {.lex_state = 12, .external_lex_state = 2},
  [2677] = {.lex_state = 12, .external_lex_state = 2},
  [2678] = {.lex_state = 12, .external_lex_state = 2},
  [2679] = {.lex_state = 12, .external_lex_state = 2},
  [2680] = {.lex_state = 12, .external_lex_state = 2},
  [2681] = {.lex_state = 12, .external_lex_state = 2},
  [2682] = {.lex_state = 149, .external_lex_state = 2},
  [2683] = {.lex_state = 12, .external_lex_state = 2},
  [2684] = {.lex_state = 149, .external_lex_state = 2},
  [2685] = {.lex_state = 12, .external_lex_state = 2},
  [2686] = {.lex_state = 12, .external_lex_state = 2},
  [2687] = {.lex_state = 12, .external_lex_state = 2},
  [2688] = {.lex_state = 12, .external_lex_state = 2},
  [2689] = {.lex_state = 12, .external_lex_state = 2},
  [2690] = {.lex_state = 12, .external_lex_state = 2},
  [2691] = {.lex_state = 12, .external_lex_state = 2},
  [2692] = {.lex_state = 12, .external_lex_state = 2},
  [2693] = {.lex_state = 12, .external_lex_state = 2},
  [2694] = {.lex_state = 149, .external_lex_state = 2},
  [2695] = {.lex_state = 12, .external_lex_state = 2},
  [2696] = {.lex_state = 12, .external_lex_state = 2},
  [2697] = {.lex_state = 12, .external_lex_state = 2},
  [2698] = {.lex_state = 12, .external_lex_state = 2},
  [2699] = {.lex_state = 12, .external_lex_state = 2},
  [2700] = {.lex_state = 12, .external_lex_state = 2},
  [2701] = {.lex_state = 12, .external_lex_state = 2},
  [2702] = {.lex_state = 149, .external_lex_state = 2},
  [2703] = {.lex_state = 12, .external_lex_state = 2},
  [2704] = {.lex_state = 12, .external_lex_state = 2},
  [2705] = {.lex_state = 149, .external_lex_state = 2},
  [2706] = {.lex_state = 12, .external_lex_state = 2},
  [2707] = {.lex_state = 12, .external_lex_state = 2},
  [2708] = {.lex_state = 12, .external_lex_state = 2},
  [2709] = {.lex_state = 12, .external_lex_state = 2},
  [2710] = {.lex_state = 12, .external_lex_state = 2},
  [2711] = {.lex_state = 12, .external_lex_state = 2},
  [2712] = {.lex_state = 12, .external_lex_state = 2},
  [2713] = {.lex_state = 12, .external_lex_state = 2},
  [2714] = {.lex_state = 12, .external_lex_state = 2},
  [2715] = {.lex_state = 12, .external_lex_state = 2},
  [2716] = {.lex_state = 12, .external_lex_state = 2},
  [2717] = {.lex_state = 12, .external_lex_state = 2},
  [2718] = {.lex_state = 12, .external_lex_state = 2},
  [2719] = {.lex_state = 12, .external_lex_state = 2},
  [2720] = {.lex_state = 12, .external_lex_state = 2},
  [2721] = {.lex_state = 12, .external_lex_state = 2},
  [2722] = {.lex_state = 12, .external_lex_state = 2},
  [2723] = {.lex_state = 12, .external_lex_state = 2},
  [2724] = {.lex_state = 149, .external_lex_state = 2},
  [2725] = {.lex_state = 149, .external_lex_state = 2},
  [2726] = {.lex_state = 149, .external_lex_state = 2},
  [2727] = {.lex_state = 149, .external_lex_state = 2},
  [2728] = {.lex_state = 149, .external_lex_state = 2},
  [2729] = {.lex_state = 149, .external_lex_state = 2},
  [2730] = {.lex_state = 149, .external_lex_state = 2},
  [2731] = {.lex_state = 149, .external_lex_state = 2},
  [2732] = {.lex_state = 149, .external_lex_state = 2},
  [2733] = {.lex_state = 149, .external_lex_state = 2},
  [2734] = {.lex_state = 149, .external_lex_state = 2},
  [2735] = {.lex_state = 149, .external_lex_state = 2},
  [2736] = {.lex_state = 149, .external_lex_state = 2},
  [2737] = {.lex_state = 149, .external_lex_state = 2},
  [2738] = {.lex_state = 149, .external_lex_state = 2},
  [2739] = {.lex_state = 149, .external_lex_state = 2},
  [2740] = {.lex_state = 149, .external_lex_state = 2},
  [2741] = {.lex_state = 149, .external_lex_state = 2},
  [2742] = {.lex_state = 149, .external_lex_state = 2},
  [2743] = {.lex_state = 149, .external_lex_state = 2},
  [2744] = {.lex_state = 149, .external_lex_state = 2},
  [2745] = {.lex_state = 149, .external_lex_state = 2},
  [2746] = {.lex_state = 149, .external_lex_state = 2},
  [2747] = {.lex_state = 149, .external_lex_state = 2},
  [2748] = {.lex_state = 149, .external_lex_state = 2},
  [2749] = {.lex_state = 149, .external_lex_state = 2},
  [2750] = {.lex_state = 149, .external_lex_state = 2},
  [2751] = {.lex_state = 149, .external_lex_state = 2},
  [2752] = {.lex_state = 149, .external_lex_state = 2},
  [2753] = {.lex_state = 149, .external_lex_state = 2},
  [2754] = {.lex_state = 149, .external_lex_state = 2},
  [2755] = {.lex_state = 149, .external_lex_state = 2},
  [2756] = {.lex_state = 149, .external_lex_state = 2},
  [2757] = {.lex_state = 149, .external_lex_state = 2},
  [2758] = {.lex_state = 149, .external_lex_state = 2},
  [2759] = {.lex_state = 149, .external_lex_state = 2},
  [2760] = {.lex_state = 149, .external_lex_state = 2},
  [2761] = {.lex_state = 149, .external_lex_state = 2},
  [2762] = {.lex_state = 149, .external_lex_state = 2},
  [2763] = {.lex_state = 149, .external_lex_state = 2},
  [2764] = {.lex_state = 149, .external_lex_state = 2},
  [2765] = {.lex_state = 12, .external_lex_state = 2},
  [2766] = {.lex_state = 149, .external_lex_state = 2},
  [2767] = {.lex_state = 149, .external_lex_state = 2},
  [2768] = {.lex_state = 149, .external_lex_state = 2},
  [2769] = {.lex_state = 149, .external_lex_state = 2},
  [2770] = {.lex_state = 149, .external_lex_state = 2},
  [2771] = {.lex_state = 149, .external_lex_state = 2},
  [2772] = {.lex_state = 149, .external_lex_state = 2},
  [2773] = {.lex_state = 149, .external_lex_state = 2},
  [2774] = {.lex_state = 149, .external_lex_state = 2},
  [2775] = {.lex_state = 149, .external_lex_state = 2},
  [2776] = {.lex_state = 149, .external_lex_state = 2},
  [2777] = {.lex_state = 149, .external_lex_state = 2},
  [2778] = {.lex_state = 149, .external_lex_state = 2},
  [2779] = {.lex_state = 149, .external_lex_state = 2},
  [2780] = {.lex_state = 149, .external_lex_state = 2},
  [2781] = {.lex_state = 149, .external_lex_state = 2},
  [2782] = {.lex_state = 149, .external_lex_state = 2},
  [2783] = {.lex_state = 149, .external_lex_state = 2},
  [2784] = {.lex_state = 149, .external_lex_state = 2},
  [2785] = {.lex_state = 149, .external_lex_state = 2},
  [2786] = {.lex_state = 149, .external_lex_state = 2},
  [2787] = {.lex_state = 149, .external_lex_state = 2},
  [2788] = {.lex_state = 149, .external_lex_state = 2},
  [2789] = {.lex_state = 149, .external_lex_state = 2},
  [2790] = {.lex_state = 149, .external_lex_state = 2},
  [2791] = {.lex_state = 149, .external_lex_state = 2},
  [2792] = {.lex_state = 149, .external_lex_state = 2},
  [2793] = {.lex_state = 149, .external_lex_state = 2},
  [2794] = {.lex_state = 149, .external_lex_state = 2},
  [2795] = {.lex_state = 149, .external_lex_state = 2},
  [2796] = {.lex_state = 149, .external_lex_state = 2},
  [2797] = {.lex_state = 149, .external_lex_state = 2},
  [2798] = {.lex_state = 149, .external_lex_state = 2},
  [2799] = {.lex_state = 149, .external_lex_state = 2},
  [2800] = {.lex_state = 149, .external_lex_state = 2},
  [2801] = {.lex_state = 149, .external_lex_state = 2},
  [2802] = {.lex_state = 149, .external_lex_state = 2},
  [2803] = {.lex_state = 149, .external_lex_state = 2},
  [2804] = {.lex_state = 149, .external_lex_state = 2},
  [2805] = {.lex_state = 149, .external_lex_state = 2},
  [2806] = {.lex_state = 149, .external_lex_state = 2},
  [2807] = {.lex_state = 149, .external_lex_state = 2},
  [2808] = {.lex_state = 149, .external_lex_state = 2},
  [2809] = {.lex_state = 149, .external_lex_state = 2},
  [2810] = {.lex_state = 149, .external_lex_state = 2},
  [2811] = {.lex_state = 149, .external_lex_state = 2},
  [2812] = {.lex_state = 149, .external_lex_state = 2},
  [2813] = {.lex_state = 149, .external_lex_state = 2},
  [2814] = {.lex_state = 149, .external_lex_state = 2},
  [2815] = {.lex_state = 149, .external_lex_state = 2},
  [2816] = {.lex_state = 149, .external_lex_state = 2},
  [2817] = {.lex_state = 149, .external_lex_state = 2},
  [2818] = {.lex_state = 149, .external_lex_state = 2},
  [2819] = {.lex_state = 149, .external_lex_state = 2},
  [2820] = {.lex_state = 149, .external_lex_state = 2},
  [2821] = {.lex_state = 149, .external_lex_state = 2},
  [2822] = {.lex_state = 149, .external_lex_state = 2},
  [2823] = {.lex_state = 149, .external_lex_state = 2},
  [2824] = {.lex_state = 149, .external_lex_state = 2},
  [2825] = {.lex_state = 149, .external_lex_state = 2},
  [2826] = {.lex_state = 149, .external_lex_state = 2},
  [2827] = {.lex_state = 149, .external_lex_state = 2},
  [2828] = {.lex_state = 149, .external_lex_state = 2},
  [2829] = {.lex_state = 149, .external_lex_state = 2},
  [2830] = {.lex_state = 149, .external_lex_state = 2},
  [2831] = {.lex_state = 149, .external_lex_state = 2},
  [2832] = {.lex_state = 149, .external_lex_state = 2},
  [2833] = {.lex_state = 15, .external_lex_state = 2},
  [2834] = {.lex_state = 15, .external_lex_state = 2},
  [2835] = {.lex_state = 15, .external_lex_state = 2},
  [2836] = {.lex_state = 15, .external_lex_state = 2},
  [2837] = {.lex_state = 15, .external_lex_state = 2},
  [2838] = {.lex_state = 15, .external_lex_state = 2},
  [2839] = {.lex_state = 15, .external_lex_state = 2},
  [2840] = {.lex_state = 15, .external_lex_state = 2},
  [2841] = {.lex_state = 15, .external_lex_state = 2},
  [2842] = {.lex_state = 15, .external_lex_state = 2},
  [2843] = {.lex_state = 15, .external_lex_state = 2},
  [2844] = {.lex_state = 15, .external_lex_state = 2},
  [2845] = {.lex_state = 15, .external_lex_state = 2},
  [2846] = {.lex_state = 15, .external_lex_state = 2},
  [2847] = {.lex_state = 15, .external_lex_state = 2},
  [2848] = {.lex_state = 15, .external_lex_state = 2},
  [2849] = {.lex_state = 15, .external_lex_state = 2},
  [2850] = {.lex_state = 15, .external_lex_state = 2},
  [2851] = {.lex_state = 15, .external_lex_state = 2},
  [2852] = {.lex_state = 15, .external_lex_state = 2},
  [2853] = {.lex_state = 15, .external_lex_state = 2},
  [2854] = {.lex_state = 15, .external_lex_state = 2},
  [2855] = {.lex_state = 15, .external_lex_state = 2},
  [2856] = {.lex_state = 15, .external_lex_state = 2},
  [2857] = {.lex_state = 15, .external_lex_state = 2},
  [2858] = {.lex_state = 15, .external_lex_state = 2},
  [2859] = {.lex_state = 15, .external_lex_state = 2},
  [2860] = {.lex_state = 15, .external_lex_state = 2},
  [2861] = {.lex_state = 15, .external_lex_state = 2},
  [2862] = {.lex_state = 15, .external_lex_state = 2},
  [2863] = {.lex_state = 15, .external_lex_state = 2},
  [2864] = {.lex_state = 15, .external_lex_state = 2},
  [2865] = {.lex_state = 15, .external_lex_state = 2},
  [2866] = {.lex_state = 15, .external_lex_state = 2},
  [2867] = {.lex_state = 15, .external_lex_state = 2},
  [2868] = {.lex_state = 15, .external_lex_state = 2},
  [2869] = {.lex_state = 15, .external_lex_state = 2},
  [2870] = {.lex_state = 13, .external_lex_state = 2},
  [2871] = {.lex_state = 13, .external_lex_state = 5},
  [2872] = {.lex_state = 25, .external_lex_state = 2},
  [2873] = {.lex_state = 25, .external_lex_state = 2},
  [2874] = {.lex_state = 13, .external_lex_state = 5},
  [2875] = {.lex_state = 149, .external_lex_state = 2},
  [2876] = {.lex_state = 15, .external_lex_state = 5},
  [2877] = {.lex_state = 149, .external_lex_state = 2},
  [2878] = {.lex_state = 14, .external_lex_state = 2},
  [2879] = {.lex_state = 13, .external_lex_state = 2},
  [2880] = {.lex_state = 149, .external_lex_state = 2},
  [2881] = {.lex_state = 149, .external_lex_state = 2},
  [2882] = {.lex_state = 15, .external_lex_state = 5},
  [2883] = {.lex_state = 14, .external_lex_state = 2},
  [2884] = {.lex_state = 13, .external_lex_state = 2},
  [2885] = {.lex_state = 13, .external_lex_state = 2},
  [2886] = {.lex_state = 14, .external_lex_state = 2},
  [2887] = {.lex_state = 14, .external_lex_state = 2},
  [2888] = {.lex_state = 149, .external_lex_state = 2},
  [2889] = {.lex_state = 13, .external_lex_state = 2},
  [2890] = {.lex_state = 15, .external_lex_state = 5},
  [2891] = {.lex_state = 14, .external_lex_state = 2},
  [2892] = {.lex_state = 15, .external_lex_state = 2},
  [2893] = {.lex_state = 149, .external_lex_state = 2},
  [2894] = {.lex_state = 149, .external_lex_state = 2},
  [2895] = {.lex_state = 149, .external_lex_state = 2},
  [2896] = {.lex_state = 149, .external_lex_state = 2},
  [2897] = {.lex_state = 149, .external_lex_state = 2},
  [2898] = {.lex_state = 149, .external_lex_state = 2},
  [2899] = {.lex_state = 149, .external_lex_state = 2},
  [2900] = {.lex_state = 149, .external_lex_state = 2},
  [2901] = {.lex_state = 149, .external_lex_state = 2},
  [2902] = {.lex_state = 149, .external_lex_state = 2},
  [2903] = {.lex_state = 15, .external_lex_state = 5},
  [2904] = {.lex_state = 149, .external_lex_state = 2},
  [2905] = {.lex_state = 149, .external_lex_state = 2},
  [2906] = {.lex_state = 15, .external_lex_state = 5},
  [2907] = {.lex_state = 15, .external_lex_state = 5},
  [2908] = {.lex_state = 149, .external_lex_state = 2},
  [2909] = {.lex_state = 15, .external_lex_state = 5},
  [2910] = {.lex_state = 15, .external_lex_state = 5},
  [2911] = {.lex_state = 15, .external_lex_state = 5},
  [2912] = {.lex_state = 15, .external_lex_state = 5},
  [2913] = {.lex_state = 15, .external_lex_state = 5},
  [2914] = {.lex_state = 15, .external_lex_state = 5},
  [2915] = {.lex_state = 15, .external_lex_state = 5},
  [2916] = {.lex_state = 15, .external_lex_state = 5},
  [2917] = {.lex_state = 15, .external_lex_state = 5},
  [2918] = {.lex_state = 15, .external_lex_state = 5},
  [2919] = {.lex_state = 149, .external_lex_state = 2},
  [2920] = {.lex_state = 149, .external_lex_state = 2},
  [2921] = {.lex_state = 149, .external_lex_state = 2},
  [2922] = {.lex_state = 149, .external_lex_state = 2},
  [2923] = {.lex_state = 15, .external_lex_state = 5},
  [2924] = {.lex_state = 149, .external_lex_state = 2},
  [2925] = {.lex_state = 4, .external_lex_state = 2},
  [2926] = {.lex_state = 149, .external_lex_state = 2},
  [2927] = {.lex_state = 15, .external_lex_state = 5},
  [2928] = {.lex_state = 15, .external_lex_state = 5},
  [2929] = {.lex_state = 15, .external_lex_state = 5},
  [2930] = {.lex_state = 15, .external_lex_state = 5},
  [2931] = {.lex_state = 15, .external_lex_state = 5},
  [2932] = {.lex_state = 15, .external_lex_state = 5},
  [2933] = {.lex_state = 15, .external_lex_state = 5},
  [2934] = {.lex_state = 15, .external_lex_state = 5},
  [2935] = {.lex_state = 15, .external_lex_state = 5},
  [2936] = {.lex_state = 15, .external_lex_state = 5},
  [2937] = {.lex_state = 15, .external_lex_state = 5},
  [2938] = {.lex_state = 15, .external_lex_state = 5},
  [2939] = {.lex_state = 15, .external_lex_state = 5},
  [2940] = {.lex_state = 15, .external_lex_state = 5},
  [2941] = {.lex_state = 15, .external_lex_state = 5},
  [2942] = {.lex_state = 15, .external_lex_state = 5},
  [2943] = {.lex_state = 15, .external_lex_state = 5},
  [2944] = {.lex_state = 15, .external_lex_state = 5},
  [2945] = {.lex_state = 15, .external_lex_state = 5},
  [2946] = {.lex_state = 15, .external_lex_state = 5},
  [2947] = {.lex_state = 13, .external_lex_state = 5},
  [2948] = {.lex_state = 149, .external_lex_state = 2},
  [2949] = {.lex_state = 4, .external_lex_state = 2},
  [2950] = {.lex_state = 149, .external_lex_state = 2},
  [2951] = {.lex_state = 149, .external_lex_state = 2},
  [2952] = {.lex_state = 149, .external_lex_state = 2},
  [2953] = {.lex_state = 149, .external_lex_state = 2},
  [2954] = {.lex_state = 149, .external_lex_state = 2},
  [2955] = {.lex_state = 149, .external_lex_state = 2},
  [2956] = {.lex_state = 149, .external_lex_state = 2},
  [2957] = {.lex_state = 4, .external_lex_state = 2},
  [2958] = {.lex_state = 149, .external_lex_state = 2},
  [2959] = {.lex_state = 149, .external_lex_state = 2},
  [2960] = {.lex_state = 149, .external_lex_state = 2},
  [2961] = {.lex_state = 149, .external_lex_state = 2},
  [2962] = {.lex_state = 149, .external_lex_state = 2},
  [2963] = {.lex_state = 149, .external_lex_state = 2},
  [2964] = {.lex_state = 149, .external_lex_state = 2},
  [2965] = {.lex_state = 149, .external_lex_state = 2},
  [2966] = {.lex_state = 149, .external_lex_state = 2},
  [2967] = {.lex_state = 149, .external_lex_state = 2},
  [2968] = {.lex_state = 149, .external_lex_state = 2},
  [2969] = {.lex_state = 149, .external_lex_state = 2},
  [2970] = {.lex_state = 149, .external_lex_state = 2},
  [2971] = {.lex_state = 4, .external_lex_state = 2},
  [2972] = {.lex_state = 149, .external_lex_state = 2},
  [2973] = {.lex_state = 149, .external_lex_state = 2},
  [2974] = {.lex_state = 149, .external_lex_state = 2},
  [2975] = {.lex_state = 149, .external_lex_state = 2},
  [2976] = {.lex_state = 4, .external_lex_state = 2},
  [2977] = {.lex_state = 149, .external_lex_state = 2},
  [2978] = {.lex_state = 149, .external_lex_state = 2},
  [2979] = {.lex_state = 149, .external_lex_state = 2},
  [2980] = {.lex_state = 149, .external_lex_state = 2},
  [2981] = {.lex_state = 149, .external_lex_state = 2},
  [2982] = {.lex_state = 15, .external_lex_state = 6},
  [2983] = {.lex_state = 4, .external_lex_state = 2},
  [2984] = {.lex_state = 15, .external_lex_state = 6},
  [2985] = {.lex_state = 15, .external_lex_state = 6},
  [2986] = {.lex_state = 4, .external_lex_state = 2},
  [2987] = {.lex_state = 149, .external_lex_state = 2},
  [2988] = {.lex_state = 149, .external_lex_state = 2},
  [2989] = {.lex_state = 149, .external_lex_state = 2},
  [2990] = {.lex_state = 149, .external_lex_state = 2},
  [2991] = {.lex_state = 4, .external_lex_state = 2},
  [2992] = {.lex_state = 149, .external_lex_state = 2},
  [2993] = {.lex_state = 149, .external_lex_state = 2},
  [2994] = {.lex_state = 4, .external_lex_state = 2},
  [2995] = {.lex_state = 149, .external_lex_state = 2},
  [2996] = {.lex_state = 149, .external_lex_state = 2},
  [2997] = {.lex_state = 149, .external_lex_state = 2},
  [2998] = {.lex_state = 149, .external_lex_state = 2},
  [2999] = {.lex_state = 149, .external_lex_state = 2},
  [3000] = {.lex_state = 149, .external_lex_state = 2},
  [3001] = {.lex_state = 149, .external_lex_state = 2},
  [3002] = {.lex_state = 149, .external_lex_state = 2},
  [3003] = {.lex_state = 149, .external_lex_state = 2},
  [3004] = {.lex_state = 12, .external_lex_state = 5},
  [3005] = {.lex_state = 12, .external_lex_state = 5},
  [3006] = {.lex_state = 149, .external_lex_state = 2},
  [3007] = {.lex_state = 149, .external_lex_state = 2},
  [3008] = {.lex_state = 149, .external_lex_state = 2},
  [3009] = {.lex_state = 12, .external_lex_state = 5},
  [3010] = {.lex_state = 12, .external_lex_state = 5},
  [3011] = {.lex_state = 12, .external_lex_state = 5},
  [3012] = {.lex_state = 12, .external_lex_state = 5},
  [3013] = {.lex_state = 12, .external_lex_state = 5},
  [3014] = {.lex_state = 149, .external_lex_state = 2},
  [3015] = {.lex_state = 25, .external_lex_state = 2},
  [3016] = {.lex_state = 12, .external_lex_state = 5},
  [3017] = {.lex_state = 12, .external_lex_state = 5},
  [3018] = {.lex_state = 12, .external_lex_state = 5},
  [3019] = {.lex_state = 149, .external_lex_state = 2},
  [3020] = {.lex_state = 12, .external_lex_state = 5},
  [3021] = {.lex_state = 149, .external_lex_state = 2},
  [3022] = {.lex_state = 12, .external_lex_state = 5},
  [3023] = {.lex_state = 12, .external_lex_state = 5},
  [3024] = {.lex_state = 12, .external_lex_state = 5},
  [3025] = {.lex_state = 12, .external_lex_state = 5},
  [3026] = {.lex_state = 149, .external_lex_state = 2},
  [3027] = {.lex_state = 12, .external_lex_state = 5},
  [3028] = {.lex_state = 12, .external_lex_state = 5},
  [3029] = {.lex_state = 149, .external_lex_state = 2},
  [3030] = {.lex_state = 12, .external_lex_state = 5},
  [3031] = {.lex_state = 12, .external_lex_state = 5},
  [3032] = {.lex_state = 12, .external_lex_state = 5},
  [3033] = {.lex_state = 12, .external_lex_state = 5},
  [3034] = {.lex_state = 12, .external_lex_state = 5},
  [3035] = {.lex_state = 149, .external_lex_state = 2},
  [3036] = {.lex_state = 149, .external_lex_state = 2},
  [3037] = {.lex_state = 12, .external_lex_state = 5},
  [3038] = {.lex_state = 12, .external_lex_state = 5},
  [3039] = {.lex_state = 12, .external_lex_state = 5},
  [3040] = {.lex_state = 12, .external_lex_state = 5},
  [3041] = {.lex_state = 149, .external_lex_state = 2},
  [3042] = {.lex_state = 13, .external_lex_state = 5},
  [3043] = {.lex_state = 12, .external_lex_state = 5},
  [3044] = {.lex_state = 149, .external_lex_state = 5},
  [3045] = {.lex_state = 12, .external_lex_state = 5},
  [3046] = {.lex_state = 15, .external_lex_state = 6},
  [3047] = {.lex_state = 12, .external_lex_state = 5},
  [3048] = {.lex_state = 14, .external_lex_state = 5},
  [3049] = {.lex_state = 14, .external_lex_state = 5},
  [3050] = {.lex_state = 12, .external_lex_state = 5},
  [3051] = {.lex_state = 149, .external_lex_state = 2},
  [3052] = {.lex_state = 14, .external_lex_state = 5},
  [3053] = {.lex_state = 149, .external_lex_state = 2},
  [3054] = {.lex_state = 149, .external_lex_state = 2},
  [3055] = {.lex_state = 13, .external_lex_state = 6},
  [3056] = {.lex_state = 12, .external_lex_state = 5},
  [3057] = {.lex_state = 13, .external_lex_state = 5},
  [3058] = {.lex_state = 12, .external_lex_state = 5},
  [3059] = {.lex_state = 14, .external_lex_state = 5},
  [3060] = {.lex_state = 14, .external_lex_state = 5},
  [3061] = {.lex_state = 149, .external_lex_state = 5},
  [3062] = {.lex_state = 149, .external_lex_state = 5},
  [3063] = {.lex_state = 149, .external_lex_state = 2},
  [3064] = {.lex_state = 149, .external_lex_state = 2},
  [3065] = {.lex_state = 13, .external_lex_state = 5},
  [3066] = {.lex_state = 14, .external_lex_state = 5},
  [3067] = {.lex_state = 149, .external_lex_state = 2},
  [3068] = {.lex_state = 149, .external_lex_state = 5},
  [3069] = {.lex_state = 149, .external_lex_state = 5},
  [3070] = {.lex_state = 12, .external_lex_state = 5},
  [3071] = {.lex_state = 149, .external_lex_state = 5},
  [3072] = {.lex_state = 25, .external_lex_state = 2},
  [3073] = {.lex_state = 25, .external_lex_state = 2},
  [3074] = {.lex_state = 15, .external_lex_state = 6},
  [3075] = {.lex_state = 149, .external_lex_state = 2},
  [3076] = {.lex_state = 12, .external_lex_state = 5},
  [3077] = {.lex_state = 12, .external_lex_state = 5},
  [3078] = {.lex_state = 15, .external_lex_state = 6},
  [3079] = {.lex_state = 15, .external_lex_state = 6},
  [3080] = {.lex_state = 15, .external_lex_state = 6},
  [3081] = {.lex_state = 15, .external_lex_state = 6},
  [3082] = {.lex_state = 15, .external_lex_state = 6},
  [3083] = {.lex_state = 15, .external_lex_state = 6},
  [3084] = {.lex_state = 12, .external_lex_state = 5},
  [3085] = {.lex_state = 15, .external_lex_state = 6},
  [3086] = {.lex_state = 15, .external_lex_state = 6},
  [3087] = {.lex_state = 15, .external_lex_state = 6},
  [3088] = {.lex_state = 15, .external_lex_state = 6},
  [3089] = {.lex_state = 15, .external_lex_state = 6},
  [3090] = {.lex_state = 15, .external_lex_state = 6},
  [3091] = {.lex_state = 14, .external_lex_state = 5},
  [3092] = {.lex_state = 149, .external_lex_state = 2},
  [3093] = {.lex_state = 12, .external_lex_state = 5},
  [3094] = {.lex_state = 15, .external_lex_state = 6},
  [3095] = {.lex_state = 15, .external_lex_state = 6},
  [3096] = {.lex_state = 15, .external_lex_state = 6},
  [3097] = {.lex_state = 15, .external_lex_state = 6},
  [3098] = {.lex_state = 15, .external_lex_state = 6},
  [3099] = {.lex_state = 15, .external_lex_state = 6},
  [3100] = {.lex_state = 15, .external_lex_state = 6},
  [3101] = {.lex_state = 14, .external_lex_state = 5},
  [3102] = {.lex_state = 15, .external_lex_state = 6},
  [3103] = {.lex_state = 15, .external_lex_state = 6},
  [3104] = {.lex_state = 15, .external_lex_state = 6},
  [3105] = {.lex_state = 15, .external_lex_state = 6},
  [3106] = {.lex_state = 15, .external_lex_state = 6},
  [3107] = {.lex_state = 15, .external_lex_state = 6},
  [3108] = {.lex_state = 13, .external_lex_state = 5},
  [3109] = {.lex_state = 149, .external_lex_state = 5},
  [3110] = {.lex_state = 15, .external_lex_state = 6},
  [3111] = {.lex_state = 15, .external_lex_state = 6},
  [3112] = {.lex_state = 15, .external_lex_state = 6},
  [3113] = {.lex_state = 15, .external_lex_state = 6},
  [3114] = {.lex_state = 15, .external_lex_state = 6},
  [3115] = {.lex_state = 12, .external_lex_state = 5},
  [3116] = {.lex_state = 149, .external_lex_state = 2},
  [3117] = {.lex_state = 149, .external_lex_state = 2},
  [3118] = {.lex_state = 15, .external_lex_state = 6},
  [3119] = {.lex_state = 15, .external_lex_state = 6},
  [3120] = {.lex_state = 12, .external_lex_state = 5},
  [3121] = {.lex_state = 12, .external_lex_state = 5},
  [3122] = {.lex_state = 25, .external_lex_state = 2},
  [3123] = {.lex_state = 12, .external_lex_state = 5},
  [3124] = {.lex_state = 12, .external_lex_state = 5},
  [3125] = {.lex_state = 12, .external_lex_state = 5},
  [3126] = {.lex_state = 12, .external_lex_state = 5},
  [3127] = {.lex_state = 12, .external_lex_state = 5},
  [3128] = {.lex_state = 149, .external_lex_state = 5},
  [3129] = {.lex_state = 12, .external_lex_state = 5},
  [3130] = {.lex_state = 12, .external_lex_state = 5},
  [3131] = {.lex_state = 12, .external_lex_state = 5},
  [3132] = {.lex_state = 12, .external_lex_state = 5},
  [3133] = {.lex_state = 149, .external_lex_state = 5},
  [3134] = {.lex_state = 12, .external_lex_state = 5},
  [3135] = {.lex_state = 149, .external_lex_state = 5},
  [3136] = {.lex_state = 12, .external_lex_state = 5},
  [3137] = {.lex_state = 149, .external_lex_state = 5},
  [3138] = {.lex_state = 149, .external_lex_state = 2},
  [3139] = {.lex_state = 149, .external_lex_state = 5},
  [3140] = {.lex_state = 15, .external_lex_state = 2},
  [3141] = {.lex_state = 149, .external_lex_state = 5},
  [3142] = {.lex_state = 25, .external_lex_state = 2},
  [3143] = {.lex_state = 12, .external_lex_state = 5},
  [3144] = {.lex_state = 12, .external_lex_state = 5},
  [3145] = {.lex_state = 12, .external_lex_state = 5},
  [3146] = {.lex_state = 12, .external_lex_state = 5},
  [3147] = {.lex_state = 12, .external_lex_state = 5},
  [3148] = {.lex_state = 12, .external_lex_state = 5},
  [3149] = {.lex_state = 12, .external_lex_state = 2},
  [3150] = {.lex_state = 15, .external_lex_state = 2},
  [3151] = {.lex_state = 12, .external_lex_state = 5},
  [3152] = {.lex_state = 12, .external_lex_state = 5},
  [3153] = {.lex_state = 12, .external_lex_state = 5},
  [3154] = {.lex_state = 12, .external_lex_state = 5},
  [3155] = {.lex_state = 149, .external_lex_state = 5},
  [3156] = {.lex_state = 149, .external_lex_state = 5},
  [3157] = {.lex_state = 15, .external_lex_state = 2},
  [3158] = {.lex_state = 12, .external_lex_state = 5},
  [3159] = {.lex_state = 12, .external_lex_state = 2},
  [3160] = {.lex_state = 12, .external_lex_state = 5},
  [3161] = {.lex_state = 12, .external_lex_state = 5},
  [3162] = {.lex_state = 12, .external_lex_state = 5},
  [3163] = {.lex_state = 12, .external_lex_state = 5},
  [3164] = {.lex_state = 12, .external_lex_state = 5},
  [3165] = {.lex_state = 12, .external_lex_state = 5},
  [3166] = {.lex_state = 25, .external_lex_state = 2},
  [3167] = {.lex_state = 12, .external_lex_state = 5},
  [3168] = {.lex_state = 13, .external_lex_state = 6},
  [3169] = {.lex_state = 149, .external_lex_state = 6},
  [3170] = {.lex_state = 149, .external_lex_state = 2},
  [3171] = {.lex_state = 12, .external_lex_state = 5},
  [3172] = {.lex_state = 149, .external_lex_state = 5},
  [3173] = {.lex_state = 12, .external_lex_state = 2},
  [3174] = {.lex_state = 12, .external_lex_state = 5},
  [3175] = {.lex_state = 12, .external_lex_state = 5},
  [3176] = {.lex_state = 149, .external_lex_state = 5},
  [3177] = {.lex_state = 12, .external_lex_state = 5},
  [3178] = {.lex_state = 12, .external_lex_state = 5},
  [3179] = {.lex_state = 12, .external_lex_state = 5},
  [3180] = {.lex_state = 12, .external_lex_state = 5},
  [3181] = {.lex_state = 25, .external_lex_state = 2},
  [3182] = {.lex_state = 12, .external_lex_state = 5},
  [3183] = {.lex_state = 149, .external_lex_state = 5},
  [3184] = {.lex_state = 149, .external_lex_state = 5},
  [3185] = {.lex_state = 149, .external_lex_state = 5},
  [3186] = {.lex_state = 149, .external_lex_state = 5},
  [3187] = {.lex_state = 13, .external_lex_state = 6},
  [3188] = {.lex_state = 149, .external_lex_state = 5},
  [3189] = {.lex_state = 149, .external_lex_state = 5},
  [3190] = {.lex_state = 23, .external_lex_state = 7},
  [3191] = {.lex_state = 149, .external_lex_state = 5},
  [3192] = {.lex_state = 149, .external_lex_state = 5},
  [3193] = {.lex_state = 23, .external_lex_state = 7},
  [3194] = {.lex_state = 23, .external_lex_state = 7},
  [3195] = {.lex_state = 149, .external_lex_state = 5},
  [3196] = {.lex_state = 23, .external_lex_state = 7},
  [3197] = {.lex_state = 23, .external_lex_state = 7},
  [3198] = {.lex_state = 149, .external_lex_state = 5},
  [3199] = {.lex_state = 149, .external_lex_state = 5},
  [3200] = {.lex_state = 149, .external_lex_state = 5},
  [3201] = {.lex_state = 149, .external_lex_state = 5},
  [3202] = {.lex_state = 149, .external_lex_state = 5},
  [3203] = {.lex_state = 149, .external_lex_state = 5},
  [3204] = {.lex_state = 149, .external_lex_state = 5},
  [3205] = {.lex_state = 149, .external_lex_state = 5},
  [3206] = {.lex_state = 149, .external_lex_state = 5},
  [3207] = {.lex_state = 149, .external_lex_state = 5},
  [3208] = {.lex_state = 149, .external_lex_state = 5},
  [3209] = {.lex_state = 149, .external_lex_state = 5},
  [3210] = {.lex_state = 149, .external_lex_state = 5},
  [3211] = {.lex_state = 149, .external_lex_state = 5},
  [3212] = {.lex_state = 149, .external_lex_state = 5},
  [3213] = {.lex_state = 12, .external_lex_state = 5},
  [3214] = {.lex_state = 23, .external_lex_state = 7},
  [3215] = {.lex_state = 12, .external_lex_state = 5},
  [3216] = {.lex_state = 149, .external_lex_state = 5},
  [3217] = {.lex_state = 149, .external_lex_state = 5},
  [3218] = {.lex_state = 149, .external_lex_state = 5},
  [3219] = {.lex_state = 149, .external_lex_state = 5},
  [3220] = {.lex_state = 149, .external_lex_state = 5},
  [3221] = {.lex_state = 149, .external_lex_state = 5},
  [3222] = {.lex_state = 13, .external_lex_state = 6},
  [3223] = {.lex_state = 149, .external_lex_state = 5},
  [3224] = {.lex_state = 149, .external_lex_state = 5},
  [3225] = {.lex_state = 149, .external_lex_state = 5},
  [3226] = {.lex_state = 149, .external_lex_state = 5},
  [3227] = {.lex_state = 14, .external_lex_state = 6},
  [3228] = {.lex_state = 149, .external_lex_state = 5},
  [3229] = {.lex_state = 149, .external_lex_state = 5},
  [3230] = {.lex_state = 23, .external_lex_state = 7},
  [3231] = {.lex_state = 149, .external_lex_state = 5},
  [3232] = {.lex_state = 14, .external_lex_state = 6},
  [3233] = {.lex_state = 14, .external_lex_state = 6},
  [3234] = {.lex_state = 149, .external_lex_state = 5},
  [3235] = {.lex_state = 14, .external_lex_state = 6},
  [3236] = {.lex_state = 12, .external_lex_state = 2},
  [3237] = {.lex_state = 12, .external_lex_state = 5},
  [3238] = {.lex_state = 14, .external_lex_state = 6},
  [3239] = {.lex_state = 14, .external_lex_state = 6},
  [3240] = {.lex_state = 14, .external_lex_state = 6},
  [3241] = {.lex_state = 149, .external_lex_state = 2},
  [3242] = {.lex_state = 149, .external_lex_state = 6},
  [3243] = {.lex_state = 149, .external_lex_state = 6},
  [3244] = {.lex_state = 149, .external_lex_state = 6},
  [3245] = {.lex_state = 149, .external_lex_state = 6},
  [3246] = {.lex_state = 149, .external_lex_state = 6},
  [3247] = {.lex_state = 149, .external_lex_state = 6},
  [3248] = {.lex_state = 14, .external_lex_state = 6},
  [3249] = {.lex_state = 149, .external_lex_state = 5},
  [3250] = {.lex_state = 149, .external_lex_state = 5},
  [3251] = {.lex_state = 149, .external_lex_state = 5},
  [3252] = {.lex_state = 149, .external_lex_state = 5},
  [3253] = {.lex_state = 13, .external_lex_state = 6},
  [3254] = {.lex_state = 149, .external_lex_state = 5},
  [3255] = {.lex_state = 149, .external_lex_state = 5},
  [3256] = {.lex_state = 149, .external_lex_state = 5},
  [3257] = {.lex_state = 149, .external_lex_state = 5},
  [3258] = {.lex_state = 149, .external_lex_state = 5},
  [3259] = {.lex_state = 149, .external_lex_state = 5},
  [3260] = {.lex_state = 149, .external_lex_state = 5},
  [3261] = {.lex_state = 149, .external_lex_state = 5},
  [3262] = {.lex_state = 149, .external_lex_state = 5},
  [3263] = {.lex_state = 23, .external_lex_state = 7},
  [3264] = {.lex_state = 149, .external_lex_state = 2},
  [3265] = {.lex_state = 149, .external_lex_state = 6},
  [3266] = {.lex_state = 13, .external_lex_state = 2},
  [3267] = {.lex_state = 23, .external_lex_state = 7},
  [3268] = {.lex_state = 13, .external_lex_state = 2},
  [3269] = {.lex_state = 13, .external_lex_state = 2},
  [3270] = {.lex_state = 25, .external_lex_state = 2},
  [3271] = {.lex_state = 149, .external_lex_state = 6},
  [3272] = {.lex_state = 13, .external_lex_state = 2},
  [3273] = {.lex_state = 12, .external_lex_state = 2},
  [3274] = {.lex_state = 149, .external_lex_state = 6},
  [3275] = {.lex_state = 149, .external_lex_state = 2},
  [3276] = {.lex_state = 149, .external_lex_state = 5},
  [3277] = {.lex_state = 12, .external_lex_state = 5},
  [3278] = {.lex_state = 25, .external_lex_state = 2},
  [3279] = {.lex_state = 13, .external_lex_state = 2},
  [3280] = {.lex_state = 25, .external_lex_state = 2},
  [3281] = {.lex_state = 13, .external_lex_state = 2},
  [3282] = {.lex_state = 149, .external_lex_state = 6},
  [3283] = {.lex_state = 149, .external_lex_state = 5},
  [3284] = {.lex_state = 149, .external_lex_state = 5},
  [3285] = {.lex_state = 13, .external_lex_state = 2},
  [3286] = {.lex_state = 149, .external_lex_state = 2},
  [3287] = {.lex_state = 13, .external_lex_state = 2},
  [3288] = {.lex_state = 13, .external_lex_state = 2},
  [3289] = {.lex_state = 149, .external_lex_state = 6},
  [3290] = {.lex_state = 13, .external_lex_state = 2},
  [3291] = {.lex_state = 13, .external_lex_state = 2},
  [3292] = {.lex_state = 149, .external_lex_state = 6},
  [3293] = {.lex_state = 149, .external_lex_state = 2},
  [3294] = {.lex_state = 149, .external_lex_state = 6},
  [3295] = {.lex_state = 25, .external_lex_state = 2},
  [3296] = {.lex_state = 149, .external_lex_state = 6},
  [3297] = {.lex_state = 149, .external_lex_state = 5},
  [3298] = {.lex_state = 149, .external_lex_state = 5},
  [3299] = {.lex_state = 149, .external_lex_state = 2},
  [3300] = {.lex_state = 149, .external_lex_state = 6},
  [3301] = {.lex_state = 149, .external_lex_state = 5},
  [3302] = {.lex_state = 149, .external_lex_state = 5},
  [3303] = {.lex_state = 149, .external_lex_state = 5},
  [3304] = {.lex_state = 149, .external_lex_state = 5},
  [3305] = {.lex_state = 149, .external_lex_state = 5},
  [3306] = {.lex_state = 13, .external_lex_state = 2},
  [3307] = {.lex_state = 13, .external_lex_state = 2},
  [3308] = {.lex_state = 149, .external_lex_state = 5},
  [3309] = {.lex_state = 149, .external_lex_state = 5},
  [3310] = {.lex_state = 25, .external_lex_state = 2},
  [3311] = {.lex_state = 13, .external_lex_state = 2},
  [3312] = {.lex_state = 149, .external_lex_state = 5},
  [3313] = {.lex_state = 13, .external_lex_state = 2},
  [3314] = {.lex_state = 25, .external_lex_state = 2},
  [3315] = {.lex_state = 25, .external_lex_state = 2},
  [3316] = {.lex_state = 13, .external_lex_state = 2},
  [3317] = {.lex_state = 12, .external_lex_state = 2},
  [3318] = {.lex_state = 149, .external_lex_state = 5},
  [3319] = {.lex_state = 25, .external_lex_state = 2},
  [3320] = {.lex_state = 149, .external_lex_state = 5},
  [3321] = {.lex_state = 149, .external_lex_state = 6},
  [3322] = {.lex_state = 25, .external_lex_state = 2},
  [3323] = {.lex_state = 25, .external_lex_state = 2},
  [3324] = {.lex_state = 149, .external_lex_state = 5},
  [3325] = {.lex_state = 25, .external_lex_state = 2},
  [3326] = {.lex_state = 149, .external_lex_state = 5},
  [3327] = {.lex_state = 25, .external_lex_state = 2},
  [3328] = {.lex_state = 149, .external_lex_state = 2},
  [3329] = {.lex_state = 149, .external_lex_state = 6},
  [3330] = {.lex_state = 149, .external_lex_state = 6},
  [3331] = {.lex_state = 25, .external_lex_state = 2},
  [3332] = {.lex_state = 25, .external_lex_state = 2},
  [3333] = {.lex_state = 25, .external_lex_state = 2},
  [3334] = {.lex_state = 149, .external_lex_state = 5},
  [3335] = {.lex_state = 149, .external_lex_state = 6},
  [3336] = {.lex_state = 25, .external_lex_state = 2},
  [3337] = {.lex_state = 13, .external_lex_state = 2},
  [3338] = {.lex_state = 25, .external_lex_state = 2},
  [3339] = {.lex_state = 149, .external_lex_state = 6},
  [3340] = {.lex_state = 149, .external_lex_state = 2},
  [3341] = {.lex_state = 149, .external_lex_state = 6},
  [3342] = {.lex_state = 149, .external_lex_state = 6},
  [3343] = {.lex_state = 149, .external_lex_state = 5},
  [3344] = {.lex_state = 13, .external_lex_state = 2},
  [3345] = {.lex_state = 149, .external_lex_state = 5},
  [3346] = {.lex_state = 149, .external_lex_state = 5},
  [3347] = {.lex_state = 149, .external_lex_state = 6},
  [3348] = {.lex_state = 149, .external_lex_state = 2},
  [3349] = {.lex_state = 25, .external_lex_state = 2},
  [3350] = {.lex_state = 25, .external_lex_state = 2},
  [3351] = {.lex_state = 12, .external_lex_state = 2},
  [3352] = {.lex_state = 149, .external_lex_state = 6},
  [3353] = {.lex_state = 149, .external_lex_state = 6},
  [3354] = {.lex_state = 149, .external_lex_state = 5},
  [3355] = {.lex_state = 149, .external_lex_state = 5},
  [3356] = {.lex_state = 149, .external_lex_state = 5},
  [3357] = {.lex_state = 149, .external_lex_state = 5},
  [3358] = {.lex_state = 149, .external_lex_state = 5},
  [3359] = {.lex_state = 25, .external_lex_state = 2},
  [3360] = {.lex_state = 25, .external_lex_state = 2},
  [3361] = {.lex_state = 25, .external_lex_state = 2},
  [3362] = {.lex_state = 25, .external_lex_state = 2},
  [3363] = {.lex_state = 25, .external_lex_state = 2},
  [3364] = {.lex_state = 149, .external_lex_state = 5},
  [3365] = {.lex_state = 25, .external_lex_state = 2},
  [3366] = {.lex_state = 149, .external_lex_state = 5},
  [3367] = {.lex_state = 149, .external_lex_state = 5},
  [3368] = {.lex_state = 13, .external_lex_state = 2},
  [3369] = {.lex_state = 149, .external_lex_state = 6},
  [3370] = {.lex_state = 25, .external_lex_state = 2},
  [3371] = {.lex_state = 149, .external_lex_state = 6},
  [3372] = {.lex_state = 13, .external_lex_state = 2},
  [3373] = {.lex_state = 25, .external_lex_state = 2},
  [3374] = {.lex_state = 13, .external_lex_state = 2},
  [3375] = {.lex_state = 149, .external_lex_state = 5},
  [3376] = {.lex_state = 149, .external_lex_state = 6},
  [3377] = {.lex_state = 13, .external_lex_state = 2},
  [3378] = {.lex_state = 13, .external_lex_state = 2},
  [3379] = {.lex_state = 149, .external_lex_state = 2},
  [3380] = {.lex_state = 149, .external_lex_state = 5},
  [3381] = {.lex_state = 149, .external_lex_state = 5},
  [3382] = {.lex_state = 149, .external_lex_state = 6},
  [3383] = {.lex_state = 149, .external_lex_state = 5},
  [3384] = {.lex_state = 13, .external_lex_state = 2},
  [3385] = {.lex_state = 149, .external_lex_state = 6},
  [3386] = {.lex_state = 149, .external_lex_state = 5},
  [3387] = {.lex_state = 149, .external_lex_state = 6},
  [3388] = {.lex_state = 149, .external_lex_state = 5},
  [3389] = {.lex_state = 149, .external_lex_state = 6},
  [3390] = {.lex_state = 149, .external_lex_state = 6},
  [3391] = {.lex_state = 149, .external_lex_state = 6},
  [3392] = {.lex_state = 149, .external_lex_state = 6},
  [3393] = {.lex_state = 149, .external_lex_state = 6},
  [3394] = {.lex_state = 149, .external_lex_state = 6},
  [3395] = {.lex_state = 149, .external_lex_state = 6},
  [3396] = {.lex_state = 13, .external_lex_state = 2},
  [3397] = {.lex_state = 13, .external_lex_state = 2},
  [3398] = {.lex_state = 149, .external_lex_state = 5},
  [3399] = {.lex_state = 149, .external_lex_state = 2},
  [3400] = {.lex_state = 149, .external_lex_state = 5},
  [3401] = {.lex_state = 25, .external_lex_state = 2},
  [3402] = {.lex_state = 149, .external_lex_state = 6},
  [3403] = {.lex_state = 25, .external_lex_state = 2},
  [3404] = {.lex_state = 25, .external_lex_state = 2},
  [3405] = {.lex_state = 13, .external_lex_state = 2},
  [3406] = {.lex_state = 149, .external_lex_state = 6},
  [3407] = {.lex_state = 25, .external_lex_state = 2},
  [3408] = {.lex_state = 149, .external_lex_state = 5},
  [3409] = {.lex_state = 149, .external_lex_state = 6},
  [3410] = {.lex_state = 149, .external_lex_state = 2},
  [3411] = {.lex_state = 149, .external_lex_state = 5},
  [3412] = {.lex_state = 149, .external_lex_state = 6},
  [3413] = {.lex_state = 149, .external_lex_state = 5},
  [3414] = {.lex_state = 149, .external_lex_state = 5},
  [3415] = {.lex_state = 149, .external_lex_state = 5},
  [3416] = {.lex_state = 149, .external_lex_state = 6},
  [3417] = {.lex_state = 149, .external_lex_state = 6},
  [3418] = {.lex_state = 149, .external_lex_state = 6},
  [3419] = {.lex_state = 149, .external_lex_state = 5},
  [3420] = {.lex_state = 149, .external_lex_state = 5},
  [3421] = {.lex_state = 149, .external_lex_state = 6},
  [3422] = {.lex_state = 149, .external_lex_state = 5},
  [3423] = {.lex_state = 149, .external_lex_state = 5},
  [3424] = {.lex_state = 149, .external_lex_state = 5},
  [3425] = {.lex_state = 149, .external_lex_state = 5},
  [3426] = {.lex_state = 149, .external_lex_state = 6},
  [3427] = {.lex_state = 149, .external_lex_state = 6},
  [3428] = {.lex_state = 149, .external_lex_state = 6},
  [3429] = {.lex_state = 13, .external_lex_state = 2},
  [3430] = {.lex_state = 13, .external_lex_state = 2},
  [3431] = {.lex_state = 25, .external_lex_state = 2},
  [3432] = {.lex_state = 25, .external_lex_state = 2},
  [3433] = {.lex_state = 149, .external_lex_state = 6},
  [3434] = {.lex_state = 149, .external_lex_state = 6},
  [3435] = {.lex_state = 149, .external_lex_state = 6},
  [3436] = {.lex_state = 25, .external_lex_state = 2},
  [3437] = {.lex_state = 25, .external_lex_state = 2},
  [3438] = {.lex_state = 149, .external_lex_state = 6},
  [3439] = {.lex_state = 149, .external_lex_state = 5},
  [3440] = {.lex_state = 149, .external_lex_state = 6},
  [3441] = {.lex_state = 25, .external_lex_state = 2},
  [3442] = {.lex_state = 149, .external_lex_state = 5},
  [3443] = {.lex_state = 149, .external_lex_state = 5},
  [3444] = {.lex_state = 25, .external_lex_state = 2},
  [3445] = {.lex_state = 149, .external_lex_state = 5},
  [3446] = {.lex_state = 13, .external_lex_state = 2},
  [3447] = {.lex_state = 149, .external_lex_state = 5},
  [3448] = {.lex_state = 25, .external_lex_state = 2},
  [3449] = {.lex_state = 13, .external_lex_state = 2},
  [3450] = {.lex_state = 149, .external_lex_state = 2},
  [3451] = {.lex_state = 149, .external_lex_state = 6},
  [3452] = {.lex_state = 149, .external_lex_state = 6},
  [3453] = {.lex_state = 12, .external_lex_state = 2},
  [3454] = {.lex_state = 12, .external_lex_state = 2},
  [3455] = {.lex_state = 149, .external_lex_state = 6},
  [3456] = {.lex_state = 149, .external_lex_state = 6},
  [3457] = {.lex_state = 149, .external_lex_state = 6},
  [3458] = {.lex_state = 149, .external_lex_state = 6},
  [3459] = {.lex_state = 149, .external_lex_state = 6},
  [3460] = {.lex_state = 149, .external_lex_state = 6},
  [3461] = {.lex_state = 149, .external_lex_state = 6},
  [3462] = {.lex_state = 12, .external_lex_state = 2},
  [3463] = {.lex_state = 25, .external_lex_state = 2},
  [3464] = {.lex_state = 25, .external_lex_state = 2},
  [3465] = {.lex_state = 25, .external_lex_state = 2},
  [3466] = {.lex_state = 149, .external_lex_state = 6},
  [3467] = {.lex_state = 149, .external_lex_state = 6},
  [3468] = {.lex_state = 149, .external_lex_state = 2},
  [3469] = {.lex_state = 149, .external_lex_state = 2},
  [3470] = {.lex_state = 12, .external_lex_state = 2},
  [3471] = {.lex_state = 149, .external_lex_state = 6},
  [3472] = {.lex_state = 149, .external_lex_state = 6},
  [3473] = {.lex_state = 149, .external_lex_state = 6},
  [3474] = {.lex_state = 149, .external_lex_state = 5},
  [3475] = {.lex_state = 149, .external_lex_state = 6},
  [3476] = {.lex_state = 149, .external_lex_state = 2},
  [3477] = {.lex_state = 149, .external_lex_state = 5},
  [3478] = {.lex_state = 12, .external_lex_state = 2},
  [3479] = {.lex_state = 149, .external_lex_state = 5},
  [3480] = {.lex_state = 13, .external_lex_state = 2},
  [3481] = {.lex_state = 149, .external_lex_state = 6},
  [3482] = {.lex_state = 25, .external_lex_state = 2},
  [3483] = {.lex_state = 25, .external_lex_state = 2},
  [3484] = {.lex_state = 23, .external_lex_state = 8},
  [3485] = {.lex_state = 149, .external_lex_state = 2},
  [3486] = {.lex_state = 14, .external_lex_state = 2},
  [3487] = {.lex_state = 23, .external_lex_state = 8},
  [3488] = {.lex_state = 149, .external_lex_state = 5},
  [3489] = {.lex_state = 149, .external_lex_state = 5},
  [3490] = {.lex_state = 16, .external_lex_state = 2},
  [3491] = {.lex_state = 149, .external_lex_state = 2},
  [3492] = {.lex_state = 23, .external_lex_state = 8},
  [3493] = {.lex_state = 23, .external_lex_state = 8},
  [3494] = {.lex_state = 149, .external_lex_state = 5},
  [3495] = {.lex_state = 16, .external_lex_state = 2},
  [3496] = {.lex_state = 23, .external_lex_state = 8},
  [3497] = {.lex_state = 149, .external_lex_state = 5},
  [3498] = {.lex_state = 149, .external_lex_state = 2},
  [3499] = {.lex_state = 149, .external_lex_state = 2},
  [3500] = {.lex_state = 149, .external_lex_state = 2},
  [3501] = {.lex_state = 149, .external_lex_state = 2},
  [3502] = {.lex_state = 14, .external_lex_state = 2},
  [3503] = {.lex_state = 25, .external_lex_state = 2},
  [3504] = {.lex_state = 149, .external_lex_state = 2},
  [3505] = {.lex_state = 149, .external_lex_state = 5},
  [3506] = {.lex_state = 149, .external_lex_state = 2},
  [3507] = {.lex_state = 149, .external_lex_state = 6},
  [3508] = {.lex_state = 149, .external_lex_state = 2},
  [3509] = {.lex_state = 14, .external_lex_state = 2},
  [3510] = {.lex_state = 149, .external_lex_state = 2},
  [3511] = {.lex_state = 23, .external_lex_state = 8},
  [3512] = {.lex_state = 149, .external_lex_state = 2},
  [3513] = {.lex_state = 149, .external_lex_state = 2},
  [3514] = {.lex_state = 23, .external_lex_state = 8},
  [3515] = {.lex_state = 25, .external_lex_state = 2},
  [3516] = {.lex_state = 25, .external_lex_state = 2},
  [3517] = {.lex_state = 25, .external_lex_state = 2},
  [3518] = {.lex_state = 149, .external_lex_state = 2},
  [3519] = {.lex_state = 149, .external_lex_state = 5},
  [3520] = {.lex_state = 25, .external_lex_state = 2},
  [3521] = {.lex_state = 23, .external_lex_state = 8},
  [3522] = {.lex_state = 25, .external_lex_state = 2},
  [3523] = {.lex_state = 25, .external_lex_state = 2},
  [3524] = {.lex_state = 25, .external_lex_state = 2},
  [3525] = {.lex_state = 25, .external_lex_state = 2},
  [3526] = {.lex_state = 149, .external_lex_state = 5},
  [3527] = {.lex_state = 149, .external_lex_state = 5},
  [3528] = {.lex_state = 12, .external_lex_state = 2},
  [3529] = {.lex_state = 149, .external_lex_state = 5},
  [3530] = {.lex_state = 149, .external_lex_state = 5},
  [3531] = {.lex_state = 149, .external_lex_state = 5},
  [3532] = {.lex_state = 149, .external_lex_state = 2},
  [3533] = {.lex_state = 149, .external_lex_state = 5},
  [3534] = {.lex_state = 149, .external_lex_state = 2},
  [3535] = {.lex_state = 149, .external_lex_state = 5},
  [3536] = {.lex_state = 149, .external_lex_state = 2},
  [3537] = {.lex_state = 149, .external_lex_state = 2},
  [3538] = {.lex_state = 149, .external_lex_state = 5},
  [3539] = {.lex_state = 149, .external_lex_state = 5},
  [3540] = {.lex_state = 25, .external_lex_state = 2},
  [3541] = {.lex_state = 149, .external_lex_state = 5},
  [3542] = {.lex_state = 149, .external_lex_state = 5},
  [3543] = {.lex_state = 149, .external_lex_state = 5},
  [3544] = {.lex_state = 149, .external_lex_state = 2},
  [3545] = {.lex_state = 149, .external_lex_state = 2},
  [3546] = {.lex_state = 149, .external_lex_state = 2},
  [3547] = {.lex_state = 149, .external_lex_state = 5},
  [3548] = {.lex_state = 12, .external_lex_state = 2},
  [3549] = {.lex_state = 149, .external_lex_state = 5},
  [3550] = {.lex_state = 149, .external_lex_state = 5},
  [3551] = {.lex_state = 149, .external_lex_state = 5},
  [3552] = {.lex_state = 15, .external_lex_state = 2},
  [3553] = {.lex_state = 149, .external_lex_state = 5},
  [3554] = {.lex_state = 149, .external_lex_state = 2},
  [3555] = {.lex_state = 149, .external_lex_state = 5},
  [3556] = {.lex_state = 149, .external_lex_state = 5},
  [3557] = {.lex_state = 149, .external_lex_state = 5},
  [3558] = {.lex_state = 149, .external_lex_state = 5},
  [3559] = {.lex_state = 12, .external_lex_state = 2},
  [3560] = {.lex_state = 149, .external_lex_state = 5},
  [3561] = {.lex_state = 149, .external_lex_state = 5},
  [3562] = {.lex_state = 149, .external_lex_state = 5},
  [3563] = {.lex_state = 149, .external_lex_state = 5},
  [3564] = {.lex_state = 149, .external_lex_state = 5},
  [3565] = {.lex_state = 149, .external_lex_state = 2},
  [3566] = {.lex_state = 149, .external_lex_state = 5},
  [3567] = {.lex_state = 15, .external_lex_state = 2},
  [3568] = {.lex_state = 149, .external_lex_state = 5},
  [3569] = {.lex_state = 12, .external_lex_state = 2},
  [3570] = {.lex_state = 149, .external_lex_state = 5},
  [3571] = {.lex_state = 149, .external_lex_state = 5},
  [3572] = {.lex_state = 149, .external_lex_state = 5},
  [3573] = {.lex_state = 149, .external_lex_state = 5},
  [3574] = {.lex_state = 149, .external_lex_state = 5},
  [3575] = {.lex_state = 149, .external_lex_state = 5},
  [3576] = {.lex_state = 149, .external_lex_state = 5},
  [3577] = {.lex_state = 149, .external_lex_state = 5},
  [3578] = {.lex_state = 149, .external_lex_state = 5},
  [3579] = {.lex_state = 15, .external_lex_state = 2},
  [3580] = {.lex_state = 149, .external_lex_state = 5},
  [3581] = {.lex_state = 149, .external_lex_state = 5},
  [3582] = {.lex_state = 149, .external_lex_state = 5},
  [3583] = {.lex_state = 149, .external_lex_state = 5},
  [3584] = {.lex_state = 149, .external_lex_state = 5},
  [3585] = {.lex_state = 149, .external_lex_state = 5},
  [3586] = {.lex_state = 149, .external_lex_state = 5},
  [3587] = {.lex_state = 149, .external_lex_state = 5},
  [3588] = {.lex_state = 149, .external_lex_state = 5},
  [3589] = {.lex_state = 149, .external_lex_state = 5},
  [3590] = {.lex_state = 149, .external_lex_state = 5},
  [3591] = {.lex_state = 149, .external_lex_state = 5},
  [3592] = {.lex_state = 15, .external_lex_state = 2},
  [3593] = {.lex_state = 149, .external_lex_state = 5},
  [3594] = {.lex_state = 149, .external_lex_state = 2},
  [3595] = {.lex_state = 149, .external_lex_state = 2},
  [3596] = {.lex_state = 149, .external_lex_state = 2},
  [3597] = {.lex_state = 149, .external_lex_state = 5},
  [3598] = {.lex_state = 149, .external_lex_state = 5},
  [3599] = {.lex_state = 149, .external_lex_state = 5},
  [3600] = {.lex_state = 149, .external_lex_state = 5},
  [3601] = {.lex_state = 149, .external_lex_state = 5},
  [3602] = {.lex_state = 149, .external_lex_state = 5},
  [3603] = {.lex_state = 15, .external_lex_state = 2},
  [3604] = {.lex_state = 149, .external_lex_state = 5},
  [3605] = {.lex_state = 149, .external_lex_state = 5},
  [3606] = {.lex_state = 149, .external_lex_state = 2},
  [3607] = {.lex_state = 12, .external_lex_state = 2},
  [3608] = {.lex_state = 149, .external_lex_state = 5},
  [3609] = {.lex_state = 149, .external_lex_state = 5},
  [3610] = {.lex_state = 149, .external_lex_state = 2},
  [3611] = {.lex_state = 149, .external_lex_state = 2},
  [3612] = {.lex_state = 149, .external_lex_state = 2},
  [3613] = {.lex_state = 15, .external_lex_state = 2},
  [3614] = {.lex_state = 149, .external_lex_state = 5},
  [3615] = {.lex_state = 149, .external_lex_state = 5},
  [3616] = {.lex_state = 149, .external_lex_state = 2},
  [3617] = {.lex_state = 149, .external_lex_state = 5},
  [3618] = {.lex_state = 149, .external_lex_state = 5},
  [3619] = {.lex_state = 149, .external_lex_state = 5},
  [3620] = {.lex_state = 149, .external_lex_state = 2},
  [3621] = {.lex_state = 149, .external_lex_state = 2},
  [3622] = {.lex_state = 149, .external_lex_state = 2},
  [3623] = {.lex_state = 149, .external_lex_state = 2},
  [3624] = {.lex_state = 149, .external_lex_state = 2},
  [3625] = {.lex_state = 149, .external_lex_state = 2},
  [3626] = {.lex_state = 149, .external_lex_state = 2},
  [3627] = {.lex_state = 149, .external_lex_state = 2},
  [3628] = {.lex_state = 149, .external_lex_state = 5},
  [3629] = {.lex_state = 149, .external_lex_state = 5},
  [3630] = {.lex_state = 149, .external_lex_state = 2},
  [3631] = {.lex_state = 149, .external_lex_state = 5},
  [3632] = {.lex_state = 149, .external_lex_state = 2},
  [3633] = {.lex_state = 149, .external_lex_state = 5},
  [3634] = {.lex_state = 149, .external_lex_state = 2},
  [3635] = {.lex_state = 149, .external_lex_state = 5},
  [3636] = {.lex_state = 149, .external_lex_state = 5},
  [3637] = {.lex_state = 149, .external_lex_state = 5},
  [3638] = {.lex_state = 149, .external_lex_state = 5},
  [3639] = {.lex_state = 12, .external_lex_state = 2},
  [3640] = {.lex_state = 12, .external_lex_state = 2},
  [3641] = {.lex_state = 149, .external_lex_state = 5},
  [3642] = {.lex_state = 149, .external_lex_state = 5},
  [3643] = {.lex_state = 149, .external_lex_state = 2},
  [3644] = {.lex_state = 149, .external_lex_state = 5},
  [3645] = {.lex_state = 149, .external_lex_state = 2},
  [3646] = {.lex_state = 12, .external_lex_state = 2},
  [3647] = {.lex_state = 149, .external_lex_state = 5},
  [3648] = {.lex_state = 15, .external_lex_state = 2},
  [3649] = {.lex_state = 149, .external_lex_state = 2},
  [3650] = {.lex_state = 149, .external_lex_state = 5},
  [3651] = {.lex_state = 149, .external_lex_state = 5},
  [3652] = {.lex_state = 12, .external_lex_state = 2},
  [3653] = {.lex_state = 12, .external_lex_state = 2},
  [3654] = {.lex_state = 149, .external_lex_state = 2},
  [3655] = {.lex_state = 149, .external_lex_state = 5},
  [3656] = {.lex_state = 149, .external_lex_state = 5},
  [3657] = {.lex_state = 149, .external_lex_state = 5},
  [3658] = {.lex_state = 149, .external_lex_state = 2},
  [3659] = {.lex_state = 15, .external_lex_state = 2},
  [3660] = {.lex_state = 149, .external_lex_state = 5},
  [3661] = {.lex_state = 149, .external_lex_state = 5},
  [3662] = {.lex_state = 149, .external_lex_state = 2},
  [3663] = {.lex_state = 149, .external_lex_state = 2},
  [3664] = {.lex_state = 149, .external_lex_state = 2},
  [3665] = {.lex_state = 149, .external_lex_state = 5},
  [3666] = {.lex_state = 149, .external_lex_state = 2},
  [3667] = {.lex_state = 149, .external_lex_state = 2},
  [3668] = {.lex_state = 149, .external_lex_state = 2},
  [3669] = {.lex_state = 149, .external_lex_state = 2},
  [3670] = {.lex_state = 15, .external_lex_state = 2},
  [3671] = {.lex_state = 149, .external_lex_state = 5},
  [3672] = {.lex_state = 149, .external_lex_state = 5},
  [3673] = {.lex_state = 149, .external_lex_state = 2},
  [3674] = {.lex_state = 149, .external_lex_state = 2},
  [3675] = {.lex_state = 149, .external_lex_state = 2},
  [3676] = {.lex_state = 149, .external_lex_state = 2},
  [3677] = {.lex_state = 149, .external_lex_state = 5},
  [3678] = {.lex_state = 149, .external_lex_state = 5},
  [3679] = {.lex_state = 12, .external_lex_state = 2},
  [3680] = {.lex_state = 149, .external_lex_state = 5},
  [3681] = {.lex_state = 12, .external_lex_state = 2},
  [3682] = {.lex_state = 12, .external_lex_state = 2},
  [3683] = {.lex_state = 149, .external_lex_state = 5},
  [3684] = {.lex_state = 149, .external_lex_state = 5},
  [3685] = {.lex_state = 149, .external_lex_state = 5},
  [3686] = {.lex_state = 149, .external_lex_state = 5},
  [3687] = {.lex_state = 149, .external_lex_state = 5},
  [3688] = {.lex_state = 149, .external_lex_state = 5},
  [3689] = {.lex_state = 149, .external_lex_state = 5},
  [3690] = {.lex_state = 149, .external_lex_state = 2},
  [3691] = {.lex_state = 149, .external_lex_state = 5},
  [3692] = {.lex_state = 149, .external_lex_state = 5},
  [3693] = {.lex_state = 149, .external_lex_state = 5},
  [3694] = {.lex_state = 149, .external_lex_state = 5},
  [3695] = {.lex_state = 149, .external_lex_state = 5},
  [3696] = {.lex_state = 149, .external_lex_state = 5},
  [3697] = {.lex_state = 149, .external_lex_state = 2},
  [3698] = {.lex_state = 149, .external_lex_state = 2},
  [3699] = {.lex_state = 149, .external_lex_state = 5},
  [3700] = {.lex_state = 149, .external_lex_state = 5},
  [3701] = {.lex_state = 149, .external_lex_state = 5},
  [3702] = {.lex_state = 149, .external_lex_state = 5},
  [3703] = {.lex_state = 149, .external_lex_state = 5},
  [3704] = {.lex_state = 149, .external_lex_state = 5},
  [3705] = {.lex_state = 149, .external_lex_state = 5},
  [3706] = {.lex_state = 149, .external_lex_state = 5},
  [3707] = {.lex_state = 149, .external_lex_state = 2},
  [3708] = {.lex_state = 149, .external_lex_state = 5},
  [3709] = {.lex_state = 149, .external_lex_state = 5},
  [3710] = {.lex_state = 149, .external_lex_state = 5},
  [3711] = {.lex_state = 149, .external_lex_state = 2},
  [3712] = {.lex_state = 149, .external_lex_state = 5},
  [3713] = {.lex_state = 149, .external_lex_state = 5},
  [3714] = {.lex_state = 15, .external_lex_state = 2},
  [3715] = {.lex_state = 149, .external_lex_state = 2},
  [3716] = {.lex_state = 149, .external_lex_state = 2},
  [3717] = {.lex_state = 149, .external_lex_state = 2},
  [3718] = {.lex_state = 12, .external_lex_state = 2},
  [3719] = {.lex_state = 149, .external_lex_state = 5},
  [3720] = {.lex_state = 15, .external_lex_state = 2},
  [3721] = {.lex_state = 149, .external_lex_state = 5},
  [3722] = {.lex_state = 12, .external_lex_state = 2},
  [3723] = {.lex_state = 149, .external_lex_state = 5},
  [3724] = {.lex_state = 149, .external_lex_state = 5},
  [3725] = {.lex_state = 12, .external_lex_state = 2},
  [3726] = {.lex_state = 149, .external_lex_state = 5},
  [3727] = {.lex_state = 149, .external_lex_state = 5},
  [3728] = {.lex_state = 149, .external_lex_state = 5},
  [3729] = {.lex_state = 149, .external_lex_state = 5},
  [3730] = {.lex_state = 149, .external_lex_state = 2},
  [3731] = {.lex_state = 149, .external_lex_state = 5},
  [3732] = {.lex_state = 12, .external_lex_state = 2},
  [3733] = {.lex_state = 149, .external_lex_state = 5},
  [3734] = {.lex_state = 149, .external_lex_state = 2},
  [3735] = {.lex_state = 149, .external_lex_state = 5},
  [3736] = {.lex_state = 149, .external_lex_state = 5},
  [3737] = {.lex_state = 149, .external_lex_state = 5},
  [3738] = {.lex_state = 149, .external_lex_state = 5},
  [3739] = {.lex_state = 149, .external_lex_state = 5},
  [3740] = {.lex_state = 149, .external_lex_state = 2},
  [3741] = {.lex_state = 149, .external_lex_state = 5},
  [3742] = {.lex_state = 12, .external_lex_state = 2},
  [3743] = {.lex_state = 149, .external_lex_state = 5},
  [3744] = {.lex_state = 149, .external_lex_state = 5},
  [3745] = {.lex_state = 149, .external_lex_state = 2},
  [3746] = {.lex_state = 12, .external_lex_state = 2},
  [3747] = {.lex_state = 149, .external_lex_state = 5},
  [3748] = {.lex_state = 149, .external_lex_state = 5},
  [3749] = {.lex_state = 149, .external_lex_state = 5},
  [3750] = {.lex_state = 149, .external_lex_state = 5},
  [3751] = {.lex_state = 15, .external_lex_state = 2},
  [3752] = {.lex_state = 149, .external_lex_state = 5},
  [3753] = {.lex_state = 15, .external_lex_state = 2},
  [3754] = {.lex_state = 149, .external_lex_state = 5},
  [3755] = {.lex_state = 149, .external_lex_state = 5},
  [3756] = {.lex_state = 149, .external_lex_state = 5},
  [3757] = {.lex_state = 149, .external_lex_state = 5},
  [3758] = {.lex_state = 149, .external_lex_state = 5},
  [3759] = {.lex_state = 15, .external_lex_state = 2},
  [3760] = {.lex_state = 15, .external_lex_state = 2},
  [3761] = {.lex_state = 149, .external_lex_state = 5},
  [3762] = {.lex_state = 12, .external_lex_state = 2},
  [3763] = {.lex_state = 149, .external_lex_state = 5},
  [3764] = {.lex_state = 149, .external_lex_state = 5},
  [3765] = {.lex_state = 149, .external_lex_state = 2},
  [3766] = {.lex_state = 149, .external_lex_state = 5},
  [3767] = {.lex_state = 149, .external_lex_state = 5},
  [3768] = {.lex_state = 149, .external_lex_state = 5},
  [3769] = {.lex_state = 149, .external_lex_state = 5},
  [3770] = {.lex_state = 149, .external_lex_state = 5},
  [3771] = {.lex_state = 15, .external_lex_state = 2},
  [3772] = {.lex_state = 12, .external_lex_state = 2},
  [3773] = {.lex_state = 149, .external_lex_state = 2},
  [3774] = {.lex_state = 25, .external_lex_state = 2},
  [3775] = {.lex_state = 12, .external_lex_state = 2},
  [3776] = {.lex_state = 149, .external_lex_state = 2},
  [3777] = {.lex_state = 12, .external_lex_state = 2},
  [3778] = {.lex_state = 12, .external_lex_state = 2},
  [3779] = {.lex_state = 149, .external_lex_state = 5},
  [3780] = {.lex_state = 149, .external_lex_state = 6},
  [3781] = {.lex_state = 12, .external_lex_state = 2},
  [3782] = {.lex_state = 149, .external_lex_state = 2},
  [3783] = {.lex_state = 149, .external_lex_state = 2},
  [3784] = {.lex_state = 12, .external_lex_state = 2},
  [3785] = {.lex_state = 149, .external_lex_state = 6},
  [3786] = {.lex_state = 12, .external_lex_state = 2},
  [3787] = {.lex_state = 149, .external_lex_state = 5},
  [3788] = {.lex_state = 149, .external_lex_state = 6},
  [3789] = {.lex_state = 149, .external_lex_state = 6},
  [3790] = {.lex_state = 12, .external_lex_state = 2},
  [3791] = {.lex_state = 149, .external_lex_state = 5},
  [3792] = {.lex_state = 149, .external_lex_state = 6},
  [3793] = {.lex_state = 149, .external_lex_state = 2},
  [3794] = {.lex_state = 149, .external_lex_state = 6},
  [3795] = {.lex_state = 12, .external_lex_state = 2},
  [3796] = {.lex_state = 149, .external_lex_state = 5},
  [3797] = {.lex_state = 23, .external_lex_state = 8},
  [3798] = {.lex_state = 149, .external_lex_state = 2},
  [3799] = {.lex_state = 149, .external_lex_state = 2},
  [3800] = {.lex_state = 12, .external_lex_state = 2},
  [3801] = {.lex_state = 16, .external_lex_state = 2},
  [3802] = {.lex_state = 149, .external_lex_state = 2},
  [3803] = {.lex_state = 149, .external_lex_state = 2},
  [3804] = {.lex_state = 12, .external_lex_state = 2},
  [3805] = {.lex_state = 12, .external_lex_state = 2},
  [3806] = {.lex_state = 149, .external_lex_state = 2},
  [3807] = {.lex_state = 12, .external_lex_state = 2},
  [3808] = {.lex_state = 149, .external_lex_state = 2},
  [3809] = {.lex_state = 149, .external_lex_state = 2},
  [3810] = {.lex_state = 149, .external_lex_state = 2},
  [3811] = {.lex_state = 149, .external_lex_state = 6},
  [3812] = {.lex_state = 149, .external_lex_state = 2},
  [3813] = {.lex_state = 149, .external_lex_state = 2},
  [3814] = {.lex_state = 149, .external_lex_state = 6},
  [3815] = {.lex_state = 12, .external_lex_state = 2},
  [3816] = {.lex_state = 12, .external_lex_state = 2},
  [3817] = {.lex_state = 149, .external_lex_state = 2},
  [3818] = {.lex_state = 149, .external_lex_state = 5},
  [3819] = {.lex_state = 25, .external_lex_state = 2},
  [3820] = {.lex_state = 149, .external_lex_state = 2},
  [3821] = {.lex_state = 12, .external_lex_state = 2},
  [3822] = {.lex_state = 149, .external_lex_state = 2},
  [3823] = {.lex_state = 12, .external_lex_state = 2},
  [3824] = {.lex_state = 12, .external_lex_state = 2},
  [3825] = {.lex_state = 12, .external_lex_state = 2},
  [3826] = {.lex_state = 149, .external_lex_state = 5},
  [3827] = {.lex_state = 149, .external_lex_state = 6},
  [3828] = {.lex_state = 149, .external_lex_state = 5},
  [3829] = {.lex_state = 12, .external_lex_state = 2},
  [3830] = {.lex_state = 149, .external_lex_state = 2},
  [3831] = {.lex_state = 12, .external_lex_state = 2},
  [3832] = {.lex_state = 149, .external_lex_state = 2},
  [3833] = {.lex_state = 149, .external_lex_state = 2},
  [3834] = {.lex_state = 149, .external_lex_state = 2},
  [3835] = {.lex_state = 149, .external_lex_state = 6},
  [3836] = {.lex_state = 149, .external_lex_state = 5},
  [3837] = {.lex_state = 149, .external_lex_state = 5},
  [3838] = {.lex_state = 149, .external_lex_state = 5},
  [3839] = {.lex_state = 12, .external_lex_state = 2},
  [3840] = {.lex_state = 12, .external_lex_state = 2},
  [3841] = {.lex_state = 149, .external_lex_state = 2},
  [3842] = {.lex_state = 149, .external_lex_state = 5},
  [3843] = {.lex_state = 149, .external_lex_state = 6},
  [3844] = {.lex_state = 23, .external_lex_state = 8},
  [3845] = {.lex_state = 12, .external_lex_state = 2},
  [3846] = {.lex_state = 149, .external_lex_state = 2},
  [3847] = {.lex_state = 149, .external_lex_state = 2},
  [3848] = {.lex_state = 149, .external_lex_state = 2},
  [3849] = {.lex_state = 149, .external_lex_state = 2},
  [3850] = {.lex_state = 12, .external_lex_state = 2},
  [3851] = {.lex_state = 16, .external_lex_state = 2},
  [3852] = {.lex_state = 149, .external_lex_state = 5},
  [3853] = {.lex_state = 149, .external_lex_state = 5},
  [3854] = {.lex_state = 149, .external_lex_state = 5},
  [3855] = {.lex_state = 149, .external_lex_state = 6},
  [3856] = {.lex_state = 149, .external_lex_state = 5},
  [3857] = {.lex_state = 25, .external_lex_state = 2},
  [3858] = {.lex_state = 149, .external_lex_state = 2},
  [3859] = {.lex_state = 149, .external_lex_state = 6},
  [3860] = {.lex_state = 149, .external_lex_state = 6},
  [3861] = {.lex_state = 149, .external_lex_state = 2},
  [3862] = {.lex_state = 149, .external_lex_state = 6},
  [3863] = {.lex_state = 149, .external_lex_state = 2},
  [3864] = {.lex_state = 12, .external_lex_state = 2},
  [3865] = {.lex_state = 149, .external_lex_state = 5},
  [3866] = {.lex_state = 12, .external_lex_state = 2},
  [3867] = {.lex_state = 149, .external_lex_state = 5},
  [3868] = {.lex_state = 149, .external_lex_state = 5},
  [3869] = {.lex_state = 149, .external_lex_state = 6},
  [3870] = {.lex_state = 149, .external_lex_state = 2},
  [3871] = {.lex_state = 12, .external_lex_state = 2},
  [3872] = {.lex_state = 149, .external_lex_state = 5},
  [3873] = {.lex_state = 149, .external_lex_state = 2},
  [3874] = {.lex_state = 149, .external_lex_state = 5},
  [3875] = {.lex_state = 12, .external_lex_state = 2},
  [3876] = {.lex_state = 12, .external_lex_state = 2},
  [3877] = {.lex_state = 149, .external_lex_state = 2},
  [3878] = {.lex_state = 149, .external_lex_state = 2},
  [3879] = {.lex_state = 149, .external_lex_state = 2},
  [3880] = {.lex_state = 12, .external_lex_state = 2},
  [3881] = {.lex_state = 12, .external_lex_state = 2},
  [3882] = {.lex_state = 12, .external_lex_state = 2},
  [3883] = {.lex_state = 149, .external_lex_state = 2},
  [3884] = {.lex_state = 149, .external_lex_state = 2},
  [3885] = {.lex_state = 149, .external_lex_state = 5},
  [3886] = {.lex_state = 12, .external_lex_state = 2},
  [3887] = {.lex_state = 149, .external_lex_state = 5},
  [3888] = {.lex_state = 149, .external_lex_state = 6},
  [3889] = {.lex_state = 23, .external_lex_state = 8},
  [3890] = {.lex_state = 149, .external_lex_state = 6},
  [3891] = {.lex_state = 149, .external_lex_state = 5},
  [3892] = {.lex_state = 149, .external_lex_state = 2},
  [3893] = {.lex_state = 12, .external_lex_state = 2},
  [3894] = {.lex_state = 12, .external_lex_state = 2},
  [3895] = {.lex_state = 149, .external_lex_state = 2},
  [3896] = {.lex_state = 149, .external_lex_state = 6},
  [3897] = {.lex_state = 12, .external_lex_state = 2},
  [3898] = {.lex_state = 149, .external_lex_state = 2},
  [3899] = {.lex_state = 149, .external_lex_state = 6},
  [3900] = {.lex_state = 12, .external_lex_state = 2},
  [3901] = {.lex_state = 12, .external_lex_state = 2},
  [3902] = {.lex_state = 149, .external_lex_state = 5},
  [3903] = {.lex_state = 12, .external_lex_state = 2},
  [3904] = {.lex_state = 149, .external_lex_state = 6},
  [3905] = {.lex_state = 25, .external_lex_state = 2},
  [3906] = {.lex_state = 149, .external_lex_state = 6},
  [3907] = {.lex_state = 149, .external_lex_state = 5},
  [3908] = {.lex_state = 149, .external_lex_state = 6},
  [3909] = {.lex_state = 149, .external_lex_state = 5},
  [3910] = {.lex_state = 23, .external_lex_state = 8},
  [3911] = {.lex_state = 149, .external_lex_state = 2},
  [3912] = {.lex_state = 149, .external_lex_state = 5},
  [3913] = {.lex_state = 23, .external_lex_state = 8},
  [3914] = {.lex_state = 12, .external_lex_state = 2},
  [3915] = {.lex_state = 149, .external_lex_state = 5},
  [3916] = {.lex_state = 149, .external_lex_state = 2},
  [3917] = {.lex_state = 149, .external_lex_state = 6},
  [3918] = {.lex_state = 149, .external_lex_state = 2},
  [3919] = {.lex_state = 12, .external_lex_state = 2},
  [3920] = {.lex_state = 12, .external_lex_state = 2},
  [3921] = {.lex_state = 25, .external_lex_state = 2},
  [3922] = {.lex_state = 12, .external_lex_state = 2},
  [3923] = {.lex_state = 12, .external_lex_state = 2},
  [3924] = {.lex_state = 12, .external_lex_state = 2},
  [3925] = {.lex_state = 12, .external_lex_state = 2},
  [3926] = {.lex_state = 12, .external_lex_state = 2},
  [3927] = {.lex_state = 149, .external_lex_state = 2},
  [3928] = {.lex_state = 149, .external_lex_state = 6},
  [3929] = {.lex_state = 149, .external_lex_state = 5},
  [3930] = {.lex_state = 12, .external_lex_state = 2},
  [3931] = {.lex_state = 149, .external_lex_state = 6},
  [3932] = {.lex_state = 149, .external_lex_state = 2},
  [3933] = {.lex_state = 12, .external_lex_state = 2},
  [3934] = {.lex_state = 149, .external_lex_state = 5},
  [3935] = {.lex_state = 149, .external_lex_state = 5},
  [3936] = {.lex_state = 149, .external_lex_state = 5},
  [3937] = {.lex_state = 149, .external_lex_state = 2},
  [3938] = {.lex_state = 149, .external_lex_state = 2},
  [3939] = {.lex_state = 149, .external_lex_state = 5},
  [3940] = {.lex_state = 149, .external_lex_state = 5},
  [3941] = {.lex_state = 149, .external_lex_state = 5},
  [3942] = {.lex_state = 12, .external_lex_state = 2},
  [3943] = {.lex_state = 149, .external_lex_state = 5},
  [3944] = {.lex_state = 12, .external_lex_state = 2},
  [3945] = {.lex_state = 149, .external_lex_state = 5},
  [3946] = {.lex_state = 149, .external_lex_state = 6},
  [3947] = {.lex_state = 23, .external_lex_state = 9},
  [3948] = {.lex_state = 149, .external_lex_state = 5},
  [3949] = {.lex_state = 149, .external_lex_state = 5},
  [3950] = {.lex_state = 149, .external_lex_state = 5},
  [3951] = {.lex_state = 149, .external_lex_state = 5},
  [3952] = {.lex_state = 149, .external_lex_state = 5},
  [3953] = {.lex_state = 149, .external_lex_state = 5},
  [3954] = {.lex_state = 23, .external_lex_state = 7},
  [3955] = {.lex_state = 25, .external_lex_state = 2},
  [3956] = {.lex_state = 149, .external_lex_state = 5},
  [3957] = {.lex_state = 149, .external_lex_state = 5},
  [3958] = {.lex_state = 149, .external_lex_state = 5},
  [3959] = {.lex_state = 149, .external_lex_state = 5},
  [3960] = {.lex_state = 149, .external_lex_state = 5},
  [3961] = {.lex_state = 149, .external_lex_state = 5},
  [3962] = {.lex_state = 23, .external_lex_state = 7},
  [3963] = {.lex_state = 149, .external_lex_state = 5},
  [3964] = {.lex_state = 149, .external_lex_state = 5},
  [3965] = {.lex_state = 149, .external_lex_state = 2},
  [3966] = {.lex_state = 149, .external_lex_state = 5},
  [3967] = {.lex_state = 149, .external_lex_state = 5},
  [3968] = {.lex_state = 4, .external_lex_state = 2},
  [3969] = {.lex_state = 149, .external_lex_state = 5},
  [3970] = {.lex_state = 25, .external_lex_state = 2},
  [3971] = {.lex_state = 149, .external_lex_state = 2},
  [3972] = {.lex_state = 149, .external_lex_state = 5},
  [3973] = {.lex_state = 149, .external_lex_state = 6},
  [3974] = {.lex_state = 149, .external_lex_state = 6},
  [3975] = {.lex_state = 149, .external_lex_state = 6},
  [3976] = {.lex_state = 149, .external_lex_state = 5},
  [3977] = {.lex_state = 12, .external_lex_state = 2},
  [3978] = {.lex_state = 149, .external_lex_state = 5},
  [3979] = {.lex_state = 149, .external_lex_state = 5},
  [3980] = {.lex_state = 12, .external_lex_state = 2},
  [3981] = {.lex_state = 149, .external_lex_state = 6},
  [3982] = {.lex_state = 149, .external_lex_state = 5},
  [3983] = {.lex_state = 149, .external_lex_state = 5},
  [3984] = {.lex_state = 149, .external_lex_state = 5},
  [3985] = {.lex_state = 149, .external_lex_state = 5},
  [3986] = {.lex_state = 149, .external_lex_state = 5},
  [3987] = {.lex_state = 149, .external_lex_state = 5},
  [3988] = {.lex_state = 149, .external_lex_state = 5},
  [3989] = {.lex_state = 149, .external_lex_state = 5},
  [3990] = {.lex_state = 149, .external_lex_state = 2},
  [3991] = {.lex_state = 149, .external_lex_state = 5},
  [3992] = {.lex_state = 149, .external_lex_state = 5},
  [3993] = {.lex_state = 149, .external_lex_state = 5},
  [3994] = {.lex_state = 149, .external_lex_state = 2},
  [3995] = {.lex_state = 149, .external_lex_state = 5},
  [3996] = {.lex_state = 149, .external_lex_state = 5},
  [3997] = {.lex_state = 149, .external_lex_state = 5},
  [3998] = {.lex_state = 149, .external_lex_state = 5},
  [3999] = {.lex_state = 149, .external_lex_state = 5},
  [4000] = {.lex_state = 149, .external_lex_state = 5},
  [4001] = {.lex_state = 149, .external_lex_state = 5},
  [4002] = {.lex_state = 16, .external_lex_state = 2},
  [4003] = {.lex_state = 149, .external_lex_state = 5},
  [4004] = {.lex_state = 23, .external_lex_state = 7},
  [4005] = {.lex_state = 149, .external_lex_state = 5},
  [4006] = {.lex_state = 149, .external_lex_state = 2},
  [4007] = {.lex_state = 149, .external_lex_state = 5},
  [4008] = {.lex_state = 149, .external_lex_state = 2},
  [4009] = {.lex_state = 149, .external_lex_state = 5},
  [4010] = {.lex_state = 23, .external_lex_state = 7},
  [4011] = {.lex_state = 149, .external_lex_state = 5},
  [4012] = {.lex_state = 23, .external_lex_state = 7},
  [4013] = {.lex_state = 149, .external_lex_state = 5},
  [4014] = {.lex_state = 23, .external_lex_state = 7},
  [4015] = {.lex_state = 23, .external_lex_state = 9},
  [4016] = {.lex_state = 23, .external_lex_state = 7},
  [4017] = {.lex_state = 149, .external_lex_state = 5},
  [4018] = {.lex_state = 149, .external_lex_state = 6},
  [4019] = {.lex_state = 149, .external_lex_state = 5},
  [4020] = {.lex_state = 149, .external_lex_state = 5},
  [4021] = {.lex_state = 4, .external_lex_state = 2},
  [4022] = {.lex_state = 149, .external_lex_state = 5},
  [4023] = {.lex_state = 149, .external_lex_state = 2},
  [4024] = {.lex_state = 149, .external_lex_state = 5},
  [4025] = {.lex_state = 149, .external_lex_state = 5},
  [4026] = {.lex_state = 149, .external_lex_state = 5},
  [4027] = {.lex_state = 149, .external_lex_state = 5},
  [4028] = {.lex_state = 23, .external_lex_state = 7},
  [4029] = {.lex_state = 149, .external_lex_state = 5},
  [4030] = {.lex_state = 149, .external_lex_state = 2},
  [4031] = {.lex_state = 149, .external_lex_state = 5},
  [4032] = {.lex_state = 149, .external_lex_state = 2},
  [4033] = {.lex_state = 149, .external_lex_state = 2},
  [4034] = {.lex_state = 149, .external_lex_state = 5},
  [4035] = {.lex_state = 149, .external_lex_state = 5},
  [4036] = {.lex_state = 149, .external_lex_state = 6},
  [4037] = {.lex_state = 149, .external_lex_state = 5},
  [4038] = {.lex_state = 149, .external_lex_state = 5},
  [4039] = {.lex_state = 149, .external_lex_state = 5},
  [4040] = {.lex_state = 149, .external_lex_state = 5},
  [4041] = {.lex_state = 149, .external_lex_state = 5},
  [4042] = {.lex_state = 23, .external_lex_state = 9},
  [4043] = {.lex_state = 15, .external_lex_state = 2},
  [4044] = {.lex_state = 149, .external_lex_state = 6},
  [4045] = {.lex_state = 23, .external_lex_state = 7},
  [4046] = {.lex_state = 149, .external_lex_state = 5},
  [4047] = {.lex_state = 149, .external_lex_state = 2},
  [4048] = {.lex_state = 149, .external_lex_state = 2},
  [4049] = {.lex_state = 149, .external_lex_state = 2},
  [4050] = {.lex_state = 149, .external_lex_state = 5},
  [4051] = {.lex_state = 149, .external_lex_state = 5},
  [4052] = {.lex_state = 25, .external_lex_state = 2},
  [4053] = {.lex_state = 149, .external_lex_state = 6},
  [4054] = {.lex_state = 149, .external_lex_state = 5},
  [4055] = {.lex_state = 149, .external_lex_state = 5},
  [4056] = {.lex_state = 149, .external_lex_state = 5},
  [4057] = {.lex_state = 12, .external_lex_state = 2},
  [4058] = {.lex_state = 149, .external_lex_state = 5},
  [4059] = {.lex_state = 149, .external_lex_state = 5},
  [4060] = {.lex_state = 149, .external_lex_state = 5},
  [4061] = {.lex_state = 149, .external_lex_state = 5},
  [4062] = {.lex_state = 149, .external_lex_state = 5},
  [4063] = {.lex_state = 149, .external_lex_state = 5},
  [4064] = {.lex_state = 149, .external_lex_state = 5},
  [4065] = {.lex_state = 149, .external_lex_state = 5},
  [4066] = {.lex_state = 149, .external_lex_state = 5},
  [4067] = {.lex_state = 149, .external_lex_state = 2},
  [4068] = {.lex_state = 149, .external_lex_state = 5},
  [4069] = {.lex_state = 149, .external_lex_state = 5},
  [4070] = {.lex_state = 149, .external_lex_state = 5},
  [4071] = {.lex_state = 149, .external_lex_state = 5},
  [4072] = {.lex_state = 149, .external_lex_state = 2},
  [4073] = {.lex_state = 149, .external_lex_state = 5},
  [4074] = {.lex_state = 149, .external_lex_state = 5},
  [4075] = {.lex_state = 149, .external_lex_state = 5},
  [4076] = {.lex_state = 149, .external_lex_state = 5},
  [4077] = {.lex_state = 149, .external_lex_state = 5},
  [4078] = {.lex_state = 149, .external_lex_state = 2},
  [4079] = {.lex_state = 12, .external_lex_state = 2},
  [4080] = {.lex_state = 149, .external_lex_state = 5},
  [4081] = {.lex_state = 149, .external_lex_state = 5},
  [4082] = {.lex_state = 12, .external_lex_state = 2},
  [4083] = {.lex_state = 149, .external_lex_state = 2},
  [4084] = {.lex_state = 12, .external_lex_state = 2},
  [4085] = {.lex_state = 149, .external_lex_state = 5},
  [4086] = {.lex_state = 12, .external_lex_state = 2},
  [4087] = {.lex_state = 149, .external_lex_state = 5},
  [4088] = {.lex_state = 149, .external_lex_state = 5},
  [4089] = {.lex_state = 149, .external_lex_state = 5},
  [4090] = {.lex_state = 149, .external_lex_state = 5},
  [4091] = {.lex_state = 149, .external_lex_state = 5},
  [4092] = {.lex_state = 149, .external_lex_state = 5},
  [4093] = {.lex_state = 149, .external_lex_state = 5},
  [4094] = {.lex_state = 149, .external_lex_state = 5},
  [4095] = {.lex_state = 149, .external_lex_state = 5},
  [4096] = {.lex_state = 149, .external_lex_state = 5},
  [4097] = {.lex_state = 149, .external_lex_state = 5},
  [4098] = {.lex_state = 149, .external_lex_state = 5},
  [4099] = {.lex_state = 149, .external_lex_state = 5},
  [4100] = {.lex_state = 149, .external_lex_state = 5},
  [4101] = {.lex_state = 149, .external_lex_state = 5},
  [4102] = {.lex_state = 149, .external_lex_state = 5},
  [4103] = {.lex_state = 149, .external_lex_state = 2},
  [4104] = {.lex_state = 149, .external_lex_state = 5},
  [4105] = {.lex_state = 149, .external_lex_state = 2},
  [4106] = {.lex_state = 149, .external_lex_state = 2},
  [4107] = {.lex_state = 149, .external_lex_state = 5},
  [4108] = {.lex_state = 149, .external_lex_state = 5},
  [4109] = {.lex_state = 149, .external_lex_state = 2},
  [4110] = {.lex_state = 23, .external_lex_state = 7},
  [4111] = {.lex_state = 23, .external_lex_state = 7},
  [4112] = {.lex_state = 149, .external_lex_state = 5},
  [4113] = {.lex_state = 12, .external_lex_state = 2},
  [4114] = {.lex_state = 149, .external_lex_state = 5},
  [4115] = {.lex_state = 12, .external_lex_state = 2},
  [4116] = {.lex_state = 149, .external_lex_state = 5},
  [4117] = {.lex_state = 149, .external_lex_state = 5},
  [4118] = {.lex_state = 149, .external_lex_state = 5},
  [4119] = {.lex_state = 16, .external_lex_state = 2},
  [4120] = {.lex_state = 149, .external_lex_state = 5},
  [4121] = {.lex_state = 149, .external_lex_state = 5},
  [4122] = {.lex_state = 149, .external_lex_state = 5},
  [4123] = {.lex_state = 149, .external_lex_state = 5},
  [4124] = {.lex_state = 149, .external_lex_state = 5},
  [4125] = {.lex_state = 149, .external_lex_state = 5},
  [4126] = {.lex_state = 23, .external_lex_state = 9},
  [4127] = {.lex_state = 149, .external_lex_state = 6},
  [4128] = {.lex_state = 149, .external_lex_state = 5},
  [4129] = {.lex_state = 149, .external_lex_state = 5},
  [4130] = {.lex_state = 149, .external_lex_state = 5},
  [4131] = {.lex_state = 149, .external_lex_state = 5},
  [4132] = {.lex_state = 149, .external_lex_state = 2},
  [4133] = {.lex_state = 149, .external_lex_state = 5},
  [4134] = {.lex_state = 149, .external_lex_state = 5},
  [4135] = {.lex_state = 149, .external_lex_state = 5},
  [4136] = {.lex_state = 23, .external_lex_state = 9},
  [4137] = {.lex_state = 149, .external_lex_state = 6},
  [4138] = {.lex_state = 149, .external_lex_state = 5},
  [4139] = {.lex_state = 149, .external_lex_state = 5},
  [4140] = {.lex_state = 149, .external_lex_state = 2},
  [4141] = {.lex_state = 12, .external_lex_state = 2},
  [4142] = {.lex_state = 149, .external_lex_state = 5},
  [4143] = {.lex_state = 149, .external_lex_state = 5},
  [4144] = {.lex_state = 149, .external_lex_state = 5},
  [4145] = {.lex_state = 12, .external_lex_state = 2},
  [4146] = {.lex_state = 149, .external_lex_state = 6},
  [4147] = {.lex_state = 149, .external_lex_state = 2},
  [4148] = {.lex_state = 149, .external_lex_state = 5},
  [4149] = {.lex_state = 12, .external_lex_state = 2},
  [4150] = {.lex_state = 16, .external_lex_state = 2},
  [4151] = {.lex_state = 23, .external_lex_state = 9},
  [4152] = {.lex_state = 149, .external_lex_state = 5},
  [4153] = {.lex_state = 149, .external_lex_state = 5},
  [4154] = {.lex_state = 12, .external_lex_state = 2},
  [4155] = {.lex_state = 149, .external_lex_state = 5},
  [4156] = {.lex_state = 149, .external_lex_state = 5},
  [4157] = {.lex_state = 149, .external_lex_state = 5},
  [4158] = {.lex_state = 149, .external_lex_state = 5},
  [4159] = {.lex_state = 149, .external_lex_state = 5},
  [4160] = {.lex_state = 149, .external_lex_state = 5},
  [4161] = {.lex_state = 12, .external_lex_state = 2},
  [4162] = {.lex_state = 149, .external_lex_state = 5},
  [4163] = {.lex_state = 149, .external_lex_state = 5},
  [4164] = {.lex_state = 149, .external_lex_state = 5},
  [4165] = {.lex_state = 23, .external_lex_state = 9},
  [4166] = {.lex_state = 149, .external_lex_state = 5},
  [4167] = {.lex_state = 149, .external_lex_state = 5},
  [4168] = {.lex_state = 149, .external_lex_state = 5},
  [4169] = {.lex_state = 149, .external_lex_state = 5},
  [4170] = {.lex_state = 149, .external_lex_state = 5},
  [4171] = {.lex_state = 149, .external_lex_state = 5},
  [4172] = {.lex_state = 149, .external_lex_state = 5},
  [4173] = {.lex_state = 149, .external_lex_state = 5},
  [4174] = {.lex_state = 12, .external_lex_state = 2},
  [4175] = {.lex_state = 12, .external_lex_state = 2},
  [4176] = {.lex_state = 149, .external_lex_state = 5},
  [4177] = {.lex_state = 149, .external_lex_state = 5},
  [4178] = {.lex_state = 23, .external_lex_state = 9},
  [4179] = {.lex_state = 149, .external_lex_state = 5},
  [4180] = {.lex_state = 23, .external_lex_state = 9},
  [4181] = {.lex_state = 149, .external_lex_state = 5},
  [4182] = {.lex_state = 12, .external_lex_state = 2},
  [4183] = {.lex_state = 149, .external_lex_state = 5},
  [4184] = {.lex_state = 149, .external_lex_state = 5},
  [4185] = {.lex_state = 149, .external_lex_state = 5},
  [4186] = {.lex_state = 149, .external_lex_state = 5},
  [4187] = {.lex_state = 149, .external_lex_state = 5},
  [4188] = {.lex_state = 149, .external_lex_state = 5},
  [4189] = {.lex_state = 149, .external_lex_state = 5},
  [4190] = {.lex_state = 149, .external_lex_state = 5},
  [4191] = {.lex_state = 149, .external_lex_state = 5},
  [4192] = {.lex_state = 149, .external_lex_state = 5},
  [4193] = {.lex_state = 149, .external_lex_state = 5},
  [4194] = {.lex_state = 12, .external_lex_state = 2},
  [4195] = {.lex_state = 149, .external_lex_state = 5},
  [4196] = {.lex_state = 149, .external_lex_state = 5},
  [4197] = {.lex_state = 149, .external_lex_state = 5},
  [4198] = {.lex_state = 149, .external_lex_state = 5},
  [4199] = {.lex_state = 149, .external_lex_state = 5},
  [4200] = {.lex_state = 149, .external_lex_state = 2},
  [4201] = {.lex_state = 149, .external_lex_state = 5},
  [4202] = {.lex_state = 12, .external_lex_state = 2},
  [4203] = {.lex_state = 149, .external_lex_state = 6},
  [4204] = {.lex_state = 149, .external_lex_state = 2},
  [4205] = {.lex_state = 149, .external_lex_state = 2},
  [4206] = {.lex_state = 149, .external_lex_state = 5},
  [4207] = {.lex_state = 12, .external_lex_state = 2},
  [4208] = {.lex_state = 149, .external_lex_state = 5},
  [4209] = {.lex_state = 149, .external_lex_state = 2},
  [4210] = {.lex_state = 12, .external_lex_state = 2},
  [4211] = {.lex_state = 149, .external_lex_state = 5},
  [4212] = {.lex_state = 149, .external_lex_state = 5},
  [4213] = {.lex_state = 149, .external_lex_state = 5},
  [4214] = {.lex_state = 12, .external_lex_state = 2},
  [4215] = {.lex_state = 23, .external_lex_state = 7},
  [4216] = {.lex_state = 23, .external_lex_state = 7},
  [4217] = {.lex_state = 149, .external_lex_state = 2},
  [4218] = {.lex_state = 12, .external_lex_state = 2},
  [4219] = {.lex_state = 149, .external_lex_state = 5},
  [4220] = {.lex_state = 149, .external_lex_state = 5},
  [4221] = {.lex_state = 12, .external_lex_state = 2},
  [4222] = {.lex_state = 149, .external_lex_state = 5},
  [4223] = {.lex_state = 149, .external_lex_state = 5},
  [4224] = {.lex_state = 149, .external_lex_state = 5},
  [4225] = {.lex_state = 12, .external_lex_state = 2},
  [4226] = {.lex_state = 12, .external_lex_state = 2},
  [4227] = {.lex_state = 149, .external_lex_state = 5},
  [4228] = {.lex_state = 149, .external_lex_state = 5},
  [4229] = {.lex_state = 149, .external_lex_state = 5},
  [4230] = {.lex_state = 149, .external_lex_state = 5},
  [4231] = {.lex_state = 149, .external_lex_state = 5},
  [4232] = {.lex_state = 149, .external_lex_state = 5},
  [4233] = {.lex_state = 149, .external_lex_state = 5},
  [4234] = {.lex_state = 23, .external_lex_state = 7},
  [4235] = {.lex_state = 23, .external_lex_state = 7},
  [4236] = {.lex_state = 149, .external_lex_state = 5},
  [4237] = {.lex_state = 149, .external_lex_state = 5},
  [4238] = {.lex_state = 12, .external_lex_state = 2},
  [4239] = {.lex_state = 12, .external_lex_state = 2},
  [4240] = {.lex_state = 149, .external_lex_state = 5},
  [4241] = {.lex_state = 12, .external_lex_state = 2},
  [4242] = {.lex_state = 12, .external_lex_state = 2},
  [4243] = {.lex_state = 23, .external_lex_state = 7},
  [4244] = {.lex_state = 23, .external_lex_state = 7},
  [4245] = {.lex_state = 149, .external_lex_state = 5},
  [4246] = {.lex_state = 149, .external_lex_state = 5},
  [4247] = {.lex_state = 149, .external_lex_state = 5},
  [4248] = {.lex_state = 12, .external_lex_state = 2},
  [4249] = {.lex_state = 149, .external_lex_state = 5},
  [4250] = {.lex_state = 12, .external_lex_state = 2},
  [4251] = {.lex_state = 12, .external_lex_state = 2},
  [4252] = {.lex_state = 149, .external_lex_state = 5},
  [4253] = {.lex_state = 149, .external_lex_state = 5},
  [4254] = {.lex_state = 149, .external_lex_state = 5},
  [4255] = {.lex_state = 149, .external_lex_state = 5},
  [4256] = {.lex_state = 149, .external_lex_state = 5},
  [4257] = {.lex_state = 12, .external_lex_state = 2},
  [4258] = {.lex_state = 149, .external_lex_state = 5},
  [4259] = {.lex_state = 149, .external_lex_state = 5},
  [4260] = {.lex_state = 23, .external_lex_state = 7},
  [4261] = {.lex_state = 23, .external_lex_state = 7},
  [4262] = {.lex_state = 23, .external_lex_state = 7},
  [4263] = {.lex_state = 23, .external_lex_state = 7},
  [4264] = {.lex_state = 12, .external_lex_state = 2},
  [4265] = {.lex_state = 23, .external_lex_state = 7},
  [4266] = {.lex_state = 23, .external_lex_state = 7},
  [4267] = {.lex_state = 149, .external_lex_state = 5},
  [4268] = {.lex_state = 12, .external_lex_state = 2},
  [4269] = {.lex_state = 149, .external_lex_state = 5},
  [4270] = {.lex_state = 12, .external_lex_state = 2},
  [4271] = {.lex_state = 12, .external_lex_state = 2},
  [4272] = {.lex_state = 149, .external_lex_state = 5},
  [4273] = {.lex_state = 12, .external_lex_state = 2},
  [4274] = {.lex_state = 149, .external_lex_state = 5},
  [4275] = {.lex_state = 23, .external_lex_state = 7},
  [4276] = {.lex_state = 23, .external_lex_state = 7},
  [4277] = {.lex_state = 149, .external_lex_state = 5},
  [4278] = {.lex_state = 149, .external_lex_state = 5},
  [4279] = {.lex_state = 149, .external_lex_state = 5},
  [4280] = {.lex_state = 149, .external_lex_state = 5},
  [4281] = {.lex_state = 149, .external_lex_state = 5},
  [4282] = {.lex_state = 149, .external_lex_state = 5},
  [4283] = {.lex_state = 149, .external_lex_state = 5},
  [4284] = {.lex_state = 149, .external_lex_state = 5},
  [4285] = {.lex_state = 149, .external_lex_state = 5},
  [4286] = {.lex_state = 25, .external_lex_state = 2},
  [4287] = {.lex_state = 149, .external_lex_state = 5},
  [4288] = {.lex_state = 149, .external_lex_state = 5},
  [4289] = {.lex_state = 149, .external_lex_state = 5},
  [4290] = {.lex_state = 149, .external_lex_state = 5},
  [4291] = {.lex_state = 149, .external_lex_state = 5},
  [4292] = {.lex_state = 149, .external_lex_state = 5},
  [4293] = {.lex_state = 23, .external_lex_state = 7},
  [4294] = {.lex_state = 23, .external_lex_state = 7},
  [4295] = {.lex_state = 149, .external_lex_state = 5},
  [4296] = {.lex_state = 12, .external_lex_state = 2},
  [4297] = {.lex_state = 149, .external_lex_state = 5},
  [4298] = {.lex_state = 149, .external_lex_state = 5},
  [4299] = {.lex_state = 149, .external_lex_state = 5},
  [4300] = {.lex_state = 149, .external_lex_state = 5},
  [4301] = {.lex_state = 149, .external_lex_state = 5},
  [4302] = {.lex_state = 12, .external_lex_state = 2},
  [4303] = {.lex_state = 149, .external_lex_state = 5},
  [4304] = {.lex_state = 12, .external_lex_state = 2},
  [4305] = {.lex_state = 149, .external_lex_state = 2},
  [4306] = {.lex_state = 149, .external_lex_state = 2},
  [4307] = {.lex_state = 149, .external_lex_state = 5},
  [4308] = {.lex_state = 149, .external_lex_state = 5},
  [4309] = {.lex_state = 149, .external_lex_state = 2},
  [4310] = {.lex_state = 23, .external_lex_state = 9},
  [4311] = {.lex_state = 149, .external_lex_state = 2},
  [4312] = {.lex_state = 149, .external_lex_state = 5},
  [4313] = {.lex_state = 149, .external_lex_state = 5},
  [4314] = {.lex_state = 149, .external_lex_state = 2},
  [4315] = {.lex_state = 12, .external_lex_state = 2},
  [4316] = {.lex_state = 12, .external_lex_state = 2},
  [4317] = {.lex_state = 149, .external_lex_state = 5},
  [4318] = {.lex_state = 149, .external_lex_state = 5},
  [4319] = {.lex_state = 149, .external_lex_state = 5},
  [4320] = {.lex_state = 12, .external_lex_state = 2},
  [4321] = {.lex_state = 12, .external_lex_state = 2},
  [4322] = {.lex_state = 149, .external_lex_state = 5},
  [4323] = {.lex_state = 149, .external_lex_state = 5},
  [4324] = {.lex_state = 25, .external_lex_state = 2},
  [4325] = {.lex_state = 25, .external_lex_state = 2},
  [4326] = {.lex_state = 23, .external_lex_state = 7},
  [4327] = {.lex_state = 23, .external_lex_state = 7},
  [4328] = {.lex_state = 149, .external_lex_state = 2},
  [4329] = {.lex_state = 12, .external_lex_state = 2},
  [4330] = {.lex_state = 25, .external_lex_state = 2},
  [4331] = {.lex_state = 25, .external_lex_state = 2},
  [4332] = {.lex_state = 149, .external_lex_state = 5},
  [4333] = {.lex_state = 149, .external_lex_state = 5},
  [4334] = {.lex_state = 12, .external_lex_state = 2},
  [4335] = {.lex_state = 149, .external_lex_state = 5},
  [4336] = {.lex_state = 149, .external_lex_state = 5},
  [4337] = {.lex_state = 149, .external_lex_state = 5},
  [4338] = {.lex_state = 25, .external_lex_state = 2},
  [4339] = {.lex_state = 25, .external_lex_state = 2},
  [4340] = {.lex_state = 149, .external_lex_state = 5},
  [4341] = {.lex_state = 149, .external_lex_state = 5},
  [4342] = {.lex_state = 25, .external_lex_state = 2},
  [4343] = {.lex_state = 25, .external_lex_state = 2},
  [4344] = {.lex_state = 149, .external_lex_state = 5},
  [4345] = {.lex_state = 149, .external_lex_state = 5},
  [4346] = {.lex_state = 149, .external_lex_state = 2},
  [4347] = {.lex_state = 149, .external_lex_state = 5},
  [4348] = {.lex_state = 12, .external_lex_state = 2},
  [4349] = {.lex_state = 149, .external_lex_state = 5},
  [4350] = {.lex_state = 149, .external_lex_state = 5},
  [4351] = {.lex_state = 149, .external_lex_state = 5},
  [4352] = {.lex_state = 12, .external_lex_state = 2},
  [4353] = {.lex_state = 149, .external_lex_state = 2},
  [4354] = {.lex_state = 149, .external_lex_state = 2},
  [4355] = {.lex_state = 25, .external_lex_state = 2},
  [4356] = {.lex_state = 25, .external_lex_state = 2},
  [4357] = {.lex_state = 25, .external_lex_state = 2},
  [4358] = {.lex_state = 25, .external_lex_state = 2},
  [4359] = {.lex_state = 25, .external_lex_state = 2},
  [4360] = {.lex_state = 25, .external_lex_state = 2},
  [4361] = {.lex_state = 149, .external_lex_state = 5},
  [4362] = {.lex_state = 149, .external_lex_state = 2},
  [4363] = {.lex_state = 149, .external_lex_state = 5},
  [4364] = {.lex_state = 149, .external_lex_state = 2},
  [4365] = {.lex_state = 149, .external_lex_state = 5},
  [4366] = {.lex_state = 25, .external_lex_state = 2},
  [4367] = {.lex_state = 149, .external_lex_state = 2},
  [4368] = {.lex_state = 149, .external_lex_state = 2},
  [4369] = {.lex_state = 25, .external_lex_state = 2},
  [4370] = {.lex_state = 149, .external_lex_state = 5},
  [4371] = {.lex_state = 12, .external_lex_state = 2},
  [4372] = {.lex_state = 149, .external_lex_state = 2},
  [4373] = {.lex_state = 149, .external_lex_state = 5},
  [4374] = {.lex_state = 149, .external_lex_state = 5},
  [4375] = {.lex_state = 149, .external_lex_state = 5},
  [4376] = {.lex_state = 149, .external_lex_state = 5},
  [4377] = {.lex_state = 149, .external_lex_state = 2},
  [4378] = {.lex_state = 149, .external_lex_state = 5},
  [4379] = {.lex_state = 25, .external_lex_state = 2},
  [4380] = {.lex_state = 25, .external_lex_state = 2},
  [4381] = {.lex_state = 149, .external_lex_state = 5},
  [4382] = {.lex_state = 12, .external_lex_state = 2},
  [4383] = {.lex_state = 149, .external_lex_state = 5},
  [4384] = {.lex_state = 149, .external_lex_state = 5},
  [4385] = {.lex_state = 149, .external_lex_state = 5},
  [4386] = {.lex_state = 149, .external_lex_state = 5},
  [4387] = {.lex_state = 149, .external_lex_state = 5},
  [4388] = {.lex_state = 149, .external_lex_state = 5},
  [4389] = {.lex_state = 149, .external_lex_state = 5},
  [4390] = {.lex_state = 149, .external_lex_state = 2},
  [4391] = {.lex_state = 149, .external_lex_state = 5},
  [4392] = {.lex_state = 149, .external_lex_state = 5},
  [4393] = {.lex_state = 12, .external_lex_state = 2},
  [4394] = {.lex_state = 149, .external_lex_state = 2},
  [4395] = {.lex_state = 149, .external_lex_state = 2},
  [4396] = {.lex_state = 149, .external_lex_state = 2},
  [4397] = {.lex_state = 12, .external_lex_state = 2},
  [4398] = {.lex_state = 149, .external_lex_state = 5},
  [4399] = {.lex_state = 12, .external_lex_state = 2},
  [4400] = {.lex_state = 149, .external_lex_state = 5},
  [4401] = {.lex_state = 149, .external_lex_state = 5},
  [4402] = {.lex_state = 149, .external_lex_state = 2},
  [4403] = {.lex_state = 149, .external_lex_state = 5},
  [4404] = {.lex_state = 149, .external_lex_state = 5},
  [4405] = {.lex_state = 149, .external_lex_state = 5},
  [4406] = {.lex_state = 16, .external_lex_state = 2},
  [4407] = {.lex_state = 149, .external_lex_state = 5},
  [4408] = {.lex_state = 149, .external_lex_state = 5},
  [4409] = {.lex_state = 149, .external_lex_state = 5},
  [4410] = {.lex_state = 149, .external_lex_state = 5},
  [4411] = {.lex_state = 149, .external_lex_state = 5},
  [4412] = {.lex_state = 149, .external_lex_state = 5},
  [4413] = {.lex_state = 149, .external_lex_state = 5},
  [4414] = {.lex_state = 149, .external_lex_state = 5},
  [4415] = {.lex_state = 149, .external_lex_state = 5},
  [4416] = {.lex_state = 149, .external_lex_state = 5},
  [4417] = {.lex_state = 149, .external_lex_state = 5},
  [4418] = {.lex_state = 149, .external_lex_state = 5},
  [4419] = {.lex_state = 12, .external_lex_state = 2},
  [4420] = {.lex_state = 149, .external_lex_state = 5},
  [4421] = {.lex_state = 149, .external_lex_state = 5},
  [4422] = {.lex_state = 149, .external_lex_state = 5},
  [4423] = {.lex_state = 149, .external_lex_state = 5},
  [4424] = {.lex_state = 149, .external_lex_state = 5},
  [4425] = {.lex_state = 149, .external_lex_state = 5},
  [4426] = {.lex_state = 149, .external_lex_state = 2},
  [4427] = {.lex_state = 149, .external_lex_state = 5},
  [4428] = {.lex_state = 12, .external_lex_state = 2},
  [4429] = {.lex_state = 149, .external_lex_state = 5},
  [4430] = {.lex_state = 149, .external_lex_state = 5},
  [4431] = {.lex_state = 149, .external_lex_state = 5},
  [4432] = {.lex_state = 149, .external_lex_state = 5},
  [4433] = {.lex_state = 149, .external_lex_state = 5},
  [4434] = {.lex_state = 149, .external_lex_state = 5},
  [4435] = {.lex_state = 12, .external_lex_state = 2},
  [4436] = {.lex_state = 149, .external_lex_state = 5},
  [4437] = {.lex_state = 149, .external_lex_state = 5},
  [4438] = {.lex_state = 149, .external_lex_state = 5},
  [4439] = {.lex_state = 149, .external_lex_state = 5},
  [4440] = {.lex_state = 149, .external_lex_state = 5},
  [4441] = {.lex_state = 149, .external_lex_state = 5},
  [4442] = {.lex_state = 149, .external_lex_state = 5},
  [4443] = {.lex_state = 149, .external_lex_state = 5},
  [4444] = {.lex_state = 149, .external_lex_state = 5},
  [4445] = {.lex_state = 12, .external_lex_state = 2},
  [4446] = {.lex_state = 149, .external_lex_state = 5},
  [4447] = {.lex_state = 149, .external_lex_state = 5},
  [4448] = {.lex_state = 12, .external_lex_state = 2},
  [4449] = {.lex_state = 149, .external_lex_state = 5},
  [4450] = {.lex_state = 12, .external_lex_state = 2},
  [4451] = {.lex_state = 23, .external_lex_state = 9},
  [4452] = {.lex_state = 12, .external_lex_state = 2},
  [4453] = {.lex_state = 149, .external_lex_state = 5},
  [4454] = {.lex_state = 149, .external_lex_state = 6},
  [4455] = {.lex_state = 149, .external_lex_state = 5},
  [4456] = {.lex_state = 149, .external_lex_state = 5},
  [4457] = {.lex_state = 149, .external_lex_state = 5},
  [4458] = {.lex_state = 149, .external_lex_state = 5},
  [4459] = {.lex_state = 149, .external_lex_state = 5},
  [4460] = {.lex_state = 15, .external_lex_state = 2},
  [4461] = {.lex_state = 149, .external_lex_state = 5},
  [4462] = {.lex_state = 149, .external_lex_state = 5},
  [4463] = {.lex_state = 149, .external_lex_state = 5},
  [4464] = {.lex_state = 25, .external_lex_state = 2},
  [4465] = {.lex_state = 149, .external_lex_state = 5},
  [4466] = {.lex_state = 12, .external_lex_state = 2},
  [4467] = {.lex_state = 149, .external_lex_state = 5},
  [4468] = {.lex_state = 28, .external_lex_state = 10},
  [4469] = {.lex_state = 149, .external_lex_state = 2},
  [4470] = {.lex_state = 149, .external_lex_state = 5},
  [4471] = {.lex_state = 149, .external_lex_state = 5},
  [4472] = {.lex_state = 149, .external_lex_state = 2},
  [4473] = {.lex_state = 149, .external_lex_state = 2},
  [4474] = {.lex_state = 4, .external_lex_state = 2},
  [4475] = {.lex_state = 149, .external_lex_state = 2},
  [4476] = {.lex_state = 12, .external_lex_state = 2},
  [4477] = {.lex_state = 149, .external_lex_state = 5},
  [4478] = {.lex_state = 19, .external_lex_state = 10},
  [4479] = {.lex_state = 149, .external_lex_state = 2},
  [4480] = {.lex_state = 17, .external_lex_state = 2},
  [4481] = {.lex_state = 28, .external_lex_state = 10},
  [4482] = {.lex_state = 149, .external_lex_state = 2},
  [4483] = {.lex_state = 12, .external_lex_state = 2},
  [4484] = {.lex_state = 149, .external_lex_state = 2},
  [4485] = {.lex_state = 15, .external_lex_state = 2},
  [4486] = {.lex_state = 12, .external_lex_state = 2},
  [4487] = {.lex_state = 19, .external_lex_state = 10},
  [4488] = {.lex_state = 12, .external_lex_state = 2},
  [4489] = {.lex_state = 28, .external_lex_state = 10},
  [4490] = {.lex_state = 12, .external_lex_state = 2},
  [4491] = {.lex_state = 149, .external_lex_state = 5},
  [4492] = {.lex_state = 19, .external_lex_state = 10},
  [4493] = {.lex_state = 26, .external_lex_state = 2},
  [4494] = {.lex_state = 28, .external_lex_state = 10},
  [4495] = {.lex_state = 149, .external_lex_state = 5},
  [4496] = {.lex_state = 149, .external_lex_state = 2},
  [4497] = {.lex_state = 12, .external_lex_state = 2},
  [4498] = {.lex_state = 12, .external_lex_state = 2},
  [4499] = {.lex_state = 28, .external_lex_state = 10},
  [4500] = {.lex_state = 149, .external_lex_state = 2},
  [4501] = {.lex_state = 149, .external_lex_state = 2},
  [4502] = {.lex_state = 12, .external_lex_state = 2},
  [4503] = {.lex_state = 149, .external_lex_state = 2},
  [4504] = {.lex_state = 149, .external_lex_state = 2},
  [4505] = {.lex_state = 12, .external_lex_state = 2},
  [4506] = {.lex_state = 23, .external_lex_state = 8},
  [4507] = {.lex_state = 149, .external_lex_state = 2},
  [4508] = {.lex_state = 149, .external_lex_state = 2},
  [4509] = {.lex_state = 149, .external_lex_state = 5},
  [4510] = {.lex_state = 149, .external_lex_state = 2},
  [4511] = {.lex_state = 12, .external_lex_state = 2},
  [4512] = {.lex_state = 149, .external_lex_state = 2},
  [4513] = {.lex_state = 149, .external_lex_state = 2},
  [4514] = {.lex_state = 19, .external_lex_state = 10},
  [4515] = {.lex_state = 28, .external_lex_state = 10},
  [4516] = {.lex_state = 149, .external_lex_state = 2},
  [4517] = {.lex_state = 149, .external_lex_state = 2},
  [4518] = {.lex_state = 149, .external_lex_state = 5},
  [4519] = {.lex_state = 149, .external_lex_state = 5},
  [4520] = {.lex_state = 149, .external_lex_state = 2},
  [4521] = {.lex_state = 149, .external_lex_state = 5},
  [4522] = {.lex_state = 149, .external_lex_state = 2},
  [4523] = {.lex_state = 12, .external_lex_state = 2},
  [4524] = {.lex_state = 19, .external_lex_state = 10},
  [4525] = {.lex_state = 12, .external_lex_state = 2},
  [4526] = {.lex_state = 12, .external_lex_state = 2},
  [4527] = {.lex_state = 149, .external_lex_state = 2},
  [4528] = {.lex_state = 149, .external_lex_state = 2},
  [4529] = {.lex_state = 28, .external_lex_state = 10},
  [4530] = {.lex_state = 149, .external_lex_state = 2},
  [4531] = {.lex_state = 149, .external_lex_state = 2},
  [4532] = {.lex_state = 19, .external_lex_state = 10},
  [4533] = {.lex_state = 17, .external_lex_state = 2},
  [4534] = {.lex_state = 26, .external_lex_state = 2},
  [4535] = {.lex_state = 149, .external_lex_state = 2},
  [4536] = {.lex_state = 19, .external_lex_state = 10},
  [4537] = {.lex_state = 28, .external_lex_state = 10},
  [4538] = {.lex_state = 19, .external_lex_state = 10},
  [4539] = {.lex_state = 12, .external_lex_state = 2},
  [4540] = {.lex_state = 149, .external_lex_state = 2},
  [4541] = {.lex_state = 19, .external_lex_state = 10},
  [4542] = {.lex_state = 149, .external_lex_state = 2},
  [4543] = {.lex_state = 4, .external_lex_state = 2},
  [4544] = {.lex_state = 149, .external_lex_state = 5},
  [4545] = {.lex_state = 4, .external_lex_state = 2},
  [4546] = {.lex_state = 149, .external_lex_state = 2},
  [4547] = {.lex_state = 149, .external_lex_state = 2},
  [4548] = {.lex_state = 19, .external_lex_state = 10},
  [4549] = {.lex_state = 19, .external_lex_state = 10},
  [4550] = {.lex_state = 149, .external_lex_state = 2},
  [4551] = {.lex_state = 28, .external_lex_state = 10},
  [4552] = {.lex_state = 19, .external_lex_state = 10},
  [4553] = {.lex_state = 28, .external_lex_state = 10},
  [4554] = {.lex_state = 28, .external_lex_state = 10},
  [4555] = {.lex_state = 149, .external_lex_state = 2},
  [4556] = {.lex_state = 149, .external_lex_state = 2},
  [4557] = {.lex_state = 28, .external_lex_state = 10},
  [4558] = {.lex_state = 149, .external_lex_state = 5},
  [4559] = {.lex_state = 149, .external_lex_state = 5},
  [4560] = {.lex_state = 149, .external_lex_state = 2},
  [4561] = {.lex_state = 149, .external_lex_state = 2},
  [4562] = {.lex_state = 149, .external_lex_state = 2},
  [4563] = {.lex_state = 19, .external_lex_state = 10},
  [4564] = {.lex_state = 28, .external_lex_state = 10},
  [4565] = {.lex_state = 149, .external_lex_state = 5},
  [4566] = {.lex_state = 149, .external_lex_state = 6},
  [4567] = {.lex_state = 149, .external_lex_state = 2},
  [4568] = {.lex_state = 149, .external_lex_state = 2},
  [4569] = {.lex_state = 149, .external_lex_state = 2},
  [4570] = {.lex_state = 12, .external_lex_state = 2},
  [4571] = {.lex_state = 19, .external_lex_state = 10},
  [4572] = {.lex_state = 149, .external_lex_state = 2},
  [4573] = {.lex_state = 12, .external_lex_state = 2},
  [4574] = {.lex_state = 4, .external_lex_state = 2},
  [4575] = {.lex_state = 149, .external_lex_state = 2},
  [4576] = {.lex_state = 149, .external_lex_state = 2},
  [4577] = {.lex_state = 149, .external_lex_state = 2},
  [4578] = {.lex_state = 149, .external_lex_state = 2},
  [4579] = {.lex_state = 15, .external_lex_state = 2},
  [4580] = {.lex_state = 149, .external_lex_state = 5},
  [4581] = {.lex_state = 12, .external_lex_state = 2},
  [4582] = {.lex_state = 149, .external_lex_state = 2},
  [4583] = {.lex_state = 149, .external_lex_state = 2},
  [4584] = {.lex_state = 19, .external_lex_state = 10},
  [4585] = {.lex_state = 149, .external_lex_state = 2},
  [4586] = {.lex_state = 28, .external_lex_state = 10},
  [4587] = {.lex_state = 149, .external_lex_state = 2},
  [4588] = {.lex_state = 12, .external_lex_state = 2},
  [4589] = {.lex_state = 149, .external_lex_state = 2},
  [4590] = {.lex_state = 149, .external_lex_state = 2},
  [4591] = {.lex_state = 149, .external_lex_state = 2},
  [4592] = {.lex_state = 149, .external_lex_state = 5},
  [4593] = {.lex_state = 149, .external_lex_state = 2},
  [4594] = {.lex_state = 12, .external_lex_state = 2},
  [4595] = {.lex_state = 12, .external_lex_state = 2},
  [4596] = {.lex_state = 23, .external_lex_state = 8},
  [4597] = {.lex_state = 12, .external_lex_state = 2},
  [4598] = {.lex_state = 12, .external_lex_state = 2},
  [4599] = {.lex_state = 149, .external_lex_state = 2},
  [4600] = {.lex_state = 28, .external_lex_state = 10},
  [4601] = {.lex_state = 12, .external_lex_state = 2},
  [4602] = {.lex_state = 149, .external_lex_state = 5},
  [4603] = {.lex_state = 149, .external_lex_state = 2},
  [4604] = {.lex_state = 149, .external_lex_state = 2},
  [4605] = {.lex_state = 17, .external_lex_state = 2},
  [4606] = {.lex_state = 26, .external_lex_state = 2},
  [4607] = {.lex_state = 149, .external_lex_state = 2},
  [4608] = {.lex_state = 149, .external_lex_state = 5},
  [4609] = {.lex_state = 149, .external_lex_state = 2},
  [4610] = {.lex_state = 149, .external_lex_state = 2},
  [4611] = {.lex_state = 4, .external_lex_state = 2},
  [4612] = {.lex_state = 149, .external_lex_state = 5},
  [4613] = {.lex_state = 4, .external_lex_state = 2},
  [4614] = {.lex_state = 149, .external_lex_state = 5},
  [4615] = {.lex_state = 149, .external_lex_state = 2},
  [4616] = {.lex_state = 149, .external_lex_state = 2},
  [4617] = {.lex_state = 149, .external_lex_state = 2},
  [4618] = {.lex_state = 149, .external_lex_state = 2},
  [4619] = {.lex_state = 149, .external_lex_state = 2},
  [4620] = {.lex_state = 149, .external_lex_state = 5},
  [4621] = {.lex_state = 149, .external_lex_state = 2},
  [4622] = {.lex_state = 149, .external_lex_state = 5},
  [4623] = {.lex_state = 149, .external_lex_state = 2},
  [4624] = {.lex_state = 149, .external_lex_state = 2},
  [4625] = {.lex_state = 149, .external_lex_state = 2},
  [4626] = {.lex_state = 149, .external_lex_state = 5},
  [4627] = {.lex_state = 149, .external_lex_state = 5},
  [4628] = {.lex_state = 149, .external_lex_state = 5},
  [4629] = {.lex_state = 4, .external_lex_state = 2},
  [4630] = {.lex_state = 149, .external_lex_state = 5},
  [4631] = {.lex_state = 149, .external_lex_state = 5},
  [4632] = {.lex_state = 149, .external_lex_state = 5},
  [4633] = {.lex_state = 149, .external_lex_state = 2},
  [4634] = {.lex_state = 149, .external_lex_state = 5},
  [4635] = {.lex_state = 149, .external_lex_state = 2},
  [4636] = {.lex_state = 149, .external_lex_state = 2},
  [4637] = {.lex_state = 149, .external_lex_state = 2},
  [4638] = {.lex_state = 149, .external_lex_state = 5},
  [4639] = {.lex_state = 149, .external_lex_state = 5},
  [4640] = {.lex_state = 149, .external_lex_state = 5},
  [4641] = {.lex_state = 149, .external_lex_state = 2},
  [4642] = {.lex_state = 149, .external_lex_state = 5},
  [4643] = {.lex_state = 149, .external_lex_state = 5},
  [4644] = {.lex_state = 149, .external_lex_state = 5},
  [4645] = {.lex_state = 149, .external_lex_state = 2},
  [4646] = {.lex_state = 149, .external_lex_state = 2},
  [4647] = {.lex_state = 149, .external_lex_state = 2},
  [4648] = {.lex_state = 149, .external_lex_state = 2},
  [4649] = {.lex_state = 149, .external_lex_state = 5},
  [4650] = {.lex_state = 149, .external_lex_state = 2},
  [4651] = {.lex_state = 1, .external_lex_state = 2},
  [4652] = {.lex_state = 149, .external_lex_state = 2},
  [4653] = {.lex_state = 149, .external_lex_state = 5},
  [4654] = {.lex_state = 149, .external_lex_state = 5},
  [4655] = {.lex_state = 149, .external_lex_state = 5},
  [4656] = {.lex_state = 149, .external_lex_state = 2},
  [4657] = {.lex_state = 149, .external_lex_state = 5},
  [4658] = {.lex_state = 4, .external_lex_state = 2},
  [4659] = {.lex_state = 149, .external_lex_state = 5},
  [4660] = {.lex_state = 149, .external_lex_state = 5},
  [4661] = {.lex_state = 149, .external_lex_state = 5},
  [4662] = {.lex_state = 149, .external_lex_state = 2},
  [4663] = {.lex_state = 149, .external_lex_state = 2},
  [4664] = {.lex_state = 149, .external_lex_state = 5},
  [4665] = {.lex_state = 149, .external_lex_state = 5},
  [4666] = {.lex_state = 149, .external_lex_state = 5},
  [4667] = {.lex_state = 149, .external_lex_state = 5},
  [4668] = {.lex_state = 149, .external_lex_state = 2},
  [4669] = {.lex_state = 149, .external_lex_state = 5},
  [4670] = {.lex_state = 149, .external_lex_state = 2},
  [4671] = {.lex_state = 149, .external_lex_state = 2},
  [4672] = {.lex_state = 149, .external_lex_state = 5},
  [4673] = {.lex_state = 149, .external_lex_state = 2},
  [4674] = {.lex_state = 149, .external_lex_state = 5},
  [4675] = {.lex_state = 149, .external_lex_state = 5},
  [4676] = {.lex_state = 149, .external_lex_state = 5},
  [4677] = {.lex_state = 149, .external_lex_state = 2},
  [4678] = {.lex_state = 149, .external_lex_state = 2},
  [4679] = {.lex_state = 149, .external_lex_state = 2},
  [4680] = {.lex_state = 149, .external_lex_state = 2},
  [4681] = {.lex_state = 149, .external_lex_state = 2},
  [4682] = {.lex_state = 149, .external_lex_state = 2},
  [4683] = {.lex_state = 149, .external_lex_state = 5},
  [4684] = {.lex_state = 149, .external_lex_state = 5},
  [4685] = {.lex_state = 149, .external_lex_state = 2},
  [4686] = {.lex_state = 149, .external_lex_state = 2},
  [4687] = {.lex_state = 149, .external_lex_state = 2},
  [4688] = {.lex_state = 149, .external_lex_state = 2},
  [4689] = {.lex_state = 149, .external_lex_state = 2},
  [4690] = {.lex_state = 149, .external_lex_state = 2},
  [4691] = {.lex_state = 149, .external_lex_state = 5},
  [4692] = {.lex_state = 149, .external_lex_state = 2},
  [4693] = {.lex_state = 149, .external_lex_state = 2},
  [4694] = {.lex_state = 149, .external_lex_state = 5},
  [4695] = {.lex_state = 149, .external_lex_state = 2},
  [4696] = {.lex_state = 149, .external_lex_state = 2},
  [4697] = {.lex_state = 149, .external_lex_state = 5},
  [4698] = {.lex_state = 149, .external_lex_state = 5},
  [4699] = {.lex_state = 149, .external_lex_state = 2},
  [4700] = {.lex_state = 149, .external_lex_state = 2},
  [4701] = {.lex_state = 149, .external_lex_state = 5},
  [4702] = {.lex_state = 149, .external_lex_state = 5},
  [4703] = {.lex_state = 149, .external_lex_state = 5},
  [4704] = {.lex_state = 149, .external_lex_state = 5},
  [4705] = {.lex_state = 149, .external_lex_state = 2},
  [4706] = {.lex_state = 149, .external_lex_state = 2},
  [4707] = {.lex_state = 149, .external_lex_state = 5},
  [4708] = {.lex_state = 149, .external_lex_state = 5},
  [4709] = {.lex_state = 149, .external_lex_state = 5},
  [4710] = {.lex_state = 149, .external_lex_state = 5},
  [4711] = {.lex_state = 149, .external_lex_state = 5},
  [4712] = {.lex_state = 149, .external_lex_state = 5},
  [4713] = {.lex_state = 149, .external_lex_state = 2},
  [4714] = {.lex_state = 149, .external_lex_state = 5},
  [4715] = {.lex_state = 149, .external_lex_state = 2},
  [4716] = {.lex_state = 149, .external_lex_state = 2},
  [4717] = {.lex_state = 149, .external_lex_state = 5},
  [4718] = {.lex_state = 4, .external_lex_state = 2},
  [4719] = {.lex_state = 149, .external_lex_state = 5},
  [4720] = {.lex_state = 149, .external_lex_state = 5},
  [4721] = {.lex_state = 149, .external_lex_state = 2},
  [4722] = {.lex_state = 149, .external_lex_state = 5},
  [4723] = {.lex_state = 149, .external_lex_state = 2},
  [4724] = {.lex_state = 149, .external_lex_state = 5},
  [4725] = {.lex_state = 149, .external_lex_state = 5},
  [4726] = {.lex_state = 149, .external_lex_state = 5},
  [4727] = {.lex_state = 149, .external_lex_state = 5},
  [4728] = {.lex_state = 149, .external_lex_state = 5},
  [4729] = {.lex_state = 149, .external_lex_state = 5},
  [4730] = {.lex_state = 149, .external_lex_state = 2},
  [4731] = {.lex_state = 149, .external_lex_state = 5},
  [4732] = {.lex_state = 149, .external_lex_state = 2},
  [4733] = {.lex_state = 149, .external_lex_state = 5},
  [4734] = {.lex_state = 149, .external_lex_state = 5},
  [4735] = {.lex_state = 149, .external_lex_state = 5},
  [4736] = {.lex_state = 149, .external_lex_state = 2},
  [4737] = {.lex_state = 149, .external_lex_state = 2},
  [4738] = {.lex_state = 149, .external_lex_state = 5},
  [4739] = {.lex_state = 149, .external_lex_state = 5},
  [4740] = {.lex_state = 149, .external_lex_state = 5},
  [4741] = {.lex_state = 149, .external_lex_state = 5},
  [4742] = {.lex_state = 149, .external_lex_state = 2},
  [4743] = {.lex_state = 149, .external_lex_state = 5},
  [4744] = {.lex_state = 149, .external_lex_state = 5},
  [4745] = {.lex_state = 149, .external_lex_state = 5},
  [4746] = {.lex_state = 149, .external_lex_state = 5},
  [4747] = {.lex_state = 149, .external_lex_state = 2},
  [4748] = {.lex_state = 149, .external_lex_state = 5},
  [4749] = {.lex_state = 149, .external_lex_state = 2},
  [4750] = {.lex_state = 149, .external_lex_state = 2},
  [4751] = {.lex_state = 149, .external_lex_state = 5},
  [4752] = {.lex_state = 149, .external_lex_state = 5},
  [4753] = {.lex_state = 149, .external_lex_state = 5},
  [4754] = {.lex_state = 149, .external_lex_state = 5},
  [4755] = {.lex_state = 149, .external_lex_state = 5},
  [4756] = {.lex_state = 149, .external_lex_state = 2},
  [4757] = {.lex_state = 149, .external_lex_state = 5},
  [4758] = {.lex_state = 149, .external_lex_state = 5},
  [4759] = {.lex_state = 149, .external_lex_state = 5},
  [4760] = {.lex_state = 149, .external_lex_state = 2},
  [4761] = {.lex_state = 149, .external_lex_state = 5},
  [4762] = {.lex_state = 149, .external_lex_state = 2},
  [4763] = {.lex_state = 149, .external_lex_state = 5},
  [4764] = {.lex_state = 149, .external_lex_state = 2},
  [4765] = {.lex_state = 149, .external_lex_state = 2},
  [4766] = {.lex_state = 149, .external_lex_state = 5},
  [4767] = {.lex_state = 149, .external_lex_state = 5},
  [4768] = {.lex_state = 149, .external_lex_state = 5},
  [4769] = {.lex_state = 149, .external_lex_state = 5},
  [4770] = {.lex_state = 149, .external_lex_state = 5},
  [4771] = {.lex_state = 149, .external_lex_state = 5},
  [4772] = {.lex_state = 149, .external_lex_state = 5},
  [4773] = {.lex_state = 149, .external_lex_state = 5},
  [4774] = {.lex_state = 149, .external_lex_state = 5},
  [4775] = {.lex_state = 149, .external_lex_state = 5},
  [4776] = {.lex_state = 149, .external_lex_state = 5},
  [4777] = {.lex_state = 149, .external_lex_state = 2},
  [4778] = {.lex_state = 149, .external_lex_state = 5},
  [4779] = {.lex_state = 149, .external_lex_state = 5},
  [4780] = {.lex_state = 149, .external_lex_state = 5},
  [4781] = {.lex_state = 149, .external_lex_state = 5},
  [4782] = {.lex_state = 149, .external_lex_state = 5},
  [4783] = {.lex_state = 149, .external_lex_state = 5},
  [4784] = {.lex_state = 149, .external_lex_state = 5},
  [4785] = {.lex_state = 149, .external_lex_state = 5},
  [4786] = {.lex_state = 149, .external_lex_state = 5},
  [4787] = {.lex_state = 149, .external_lex_state = 5},
  [4788] = {.lex_state = 149, .external_lex_state = 5},
  [4789] = {.lex_state = 149, .external_lex_state = 5},
  [4790] = {.lex_state = 149, .external_lex_state = 5},
  [4791] = {.lex_state = 4, .external_lex_state = 2},
  [4792] = {.lex_state = 149, .external_lex_state = 5},
  [4793] = {.lex_state = 149, .external_lex_state = 5},
  [4794] = {.lex_state = 149, .external_lex_state = 2},
  [4795] = {.lex_state = 149, .external_lex_state = 5},
  [4796] = {.lex_state = 149, .external_lex_state = 5},
  [4797] = {.lex_state = 149, .external_lex_state = 2},
  [4798] = {.lex_state = 149, .external_lex_state = 5},
  [4799] = {.lex_state = 149, .external_lex_state = 5},
  [4800] = {.lex_state = 149, .external_lex_state = 5},
  [4801] = {.lex_state = 149, .external_lex_state = 2},
  [4802] = {.lex_state = 149, .external_lex_state = 2},
  [4803] = {.lex_state = 149, .external_lex_state = 2},
  [4804] = {.lex_state = 149, .external_lex_state = 5},
  [4805] = {.lex_state = 149, .external_lex_state = 5},
  [4806] = {.lex_state = 149, .external_lex_state = 5},
  [4807] = {.lex_state = 149, .external_lex_state = 5},
  [4808] = {.lex_state = 149, .external_lex_state = 5},
  [4809] = {.lex_state = 149, .external_lex_state = 5},
  [4810] = {.lex_state = 149, .external_lex_state = 5},
  [4811] = {.lex_state = 149, .external_lex_state = 5},
  [4812] = {.lex_state = 149, .external_lex_state = 5},
  [4813] = {.lex_state = 149, .external_lex_state = 5},
  [4814] = {.lex_state = 149, .external_lex_state = 5},
  [4815] = {.lex_state = 149, .external_lex_state = 5},
  [4816] = {.lex_state = 149, .external_lex_state = 2},
  [4817] = {.lex_state = 149, .external_lex_state = 5},
  [4818] = {.lex_state = 149, .external_lex_state = 5},
  [4819] = {.lex_state = 149, .external_lex_state = 5},
  [4820] = {.lex_state = 149, .external_lex_state = 5},
  [4821] = {.lex_state = 149, .external_lex_state = 5},
  [4822] = {.lex_state = 149, .external_lex_state = 5},
  [4823] = {.lex_state = 149, .external_lex_state = 5},
  [4824] = {.lex_state = 149, .external_lex_state = 5},
  [4825] = {.lex_state = 149, .external_lex_state = 5},
  [4826] = {.lex_state = 149, .external_lex_state = 5},
  [4827] = {.lex_state = 149, .external_lex_state = 2},
  [4828] = {.lex_state = 149, .external_lex_state = 5},
  [4829] = {.lex_state = 149, .external_lex_state = 2},
  [4830] = {.lex_state = 149, .external_lex_state = 2},
  [4831] = {.lex_state = 149, .external_lex_state = 2},
  [4832] = {.lex_state = 149, .external_lex_state = 5},
  [4833] = {.lex_state = 149, .external_lex_state = 5},
  [4834] = {.lex_state = 149, .external_lex_state = 2},
  [4835] = {.lex_state = 149, .external_lex_state = 5},
  [4836] = {.lex_state = 149, .external_lex_state = 5},
  [4837] = {.lex_state = 149, .external_lex_state = 5},
  [4838] = {.lex_state = 149, .external_lex_state = 2},
  [4839] = {.lex_state = 149, .external_lex_state = 5},
  [4840] = {.lex_state = 149, .external_lex_state = 5},
  [4841] = {.lex_state = 149, .external_lex_state = 2},
  [4842] = {.lex_state = 149, .external_lex_state = 5},
  [4843] = {.lex_state = 4, .external_lex_state = 2},
  [4844] = {.lex_state = 149, .external_lex_state = 2},
  [4845] = {.lex_state = 149, .external_lex_state = 5},
  [4846] = {.lex_state = 149, .external_lex_state = 5},
  [4847] = {.lex_state = 149, .external_lex_state = 5},
  [4848] = {.lex_state = 149, .external_lex_state = 5},
  [4849] = {.lex_state = 149, .external_lex_state = 5},
  [4850] = {.lex_state = 149, .external_lex_state = 5},
  [4851] = {.lex_state = 149, .external_lex_state = 5},
  [4852] = {.lex_state = 149, .external_lex_state = 5},
  [4853] = {.lex_state = 149, .external_lex_state = 5},
  [4854] = {.lex_state = 149, .external_lex_state = 2},
  [4855] = {.lex_state = 149, .external_lex_state = 5},
  [4856] = {.lex_state = 149, .external_lex_state = 2},
  [4857] = {.lex_state = 149, .external_lex_state = 5},
  [4858] = {.lex_state = 149, .external_lex_state = 5},
  [4859] = {.lex_state = 149, .external_lex_state = 5},
  [4860] = {.lex_state = 149, .external_lex_state = 5},
  [4861] = {.lex_state = 149, .external_lex_state = 5},
  [4862] = {.lex_state = 149, .external_lex_state = 5},
  [4863] = {.lex_state = 149, .external_lex_state = 5},
  [4864] = {.lex_state = 149, .external_lex_state = 5},
  [4865] = {.lex_state = 149, .external_lex_state = 5},
  [4866] = {.lex_state = 4, .external_lex_state = 2},
  [4867] = {.lex_state = 149, .external_lex_state = 5},
  [4868] = {.lex_state = 149, .external_lex_state = 2},
  [4869] = {.lex_state = 149, .external_lex_state = 5},
  [4870] = {.lex_state = 149, .external_lex_state = 2},
  [4871] = {.lex_state = 149, .external_lex_state = 5},
  [4872] = {.lex_state = 149, .external_lex_state = 2},
  [4873] = {.lex_state = 149, .external_lex_state = 5},
  [4874] = {.lex_state = 149, .external_lex_state = 5},
  [4875] = {.lex_state = 149, .external_lex_state = 2},
  [4876] = {.lex_state = 149, .external_lex_state = 2},
  [4877] = {.lex_state = 149, .external_lex_state = 5},
  [4878] = {.lex_state = 149, .external_lex_state = 5},
  [4879] = {.lex_state = 149, .external_lex_state = 2},
  [4880] = {.lex_state = 149, .external_lex_state = 5},
  [4881] = {.lex_state = 149, .external_lex_state = 5},
  [4882] = {.lex_state = 149, .external_lex_state = 5},
  [4883] = {.lex_state = 149, .external_lex_state = 5},
  [4884] = {.lex_state = 149, .external_lex_state = 5},
  [4885] = {.lex_state = 149, .external_lex_state = 5},
  [4886] = {.lex_state = 149, .external_lex_state = 5},
  [4887] = {.lex_state = 149, .external_lex_state = 5},
  [4888] = {.lex_state = 149, .external_lex_state = 5},
  [4889] = {.lex_state = 149, .external_lex_state = 5},
  [4890] = {.lex_state = 149, .external_lex_state = 5},
  [4891] = {.lex_state = 149, .external_lex_state = 5},
  [4892] = {.lex_state = 149, .external_lex_state = 5},
  [4893] = {.lex_state = 149, .external_lex_state = 5},
  [4894] = {.lex_state = 149, .external_lex_state = 5},
  [4895] = {.lex_state = 149, .external_lex_state = 2},
  [4896] = {.lex_state = 149, .external_lex_state = 5},
  [4897] = {.lex_state = 149, .external_lex_state = 2},
  [4898] = {.lex_state = 149, .external_lex_state = 2},
  [4899] = {.lex_state = 149, .external_lex_state = 2},
  [4900] = {.lex_state = 149, .external_lex_state = 2},
  [4901] = {.lex_state = 149, .external_lex_state = 5},
  [4902] = {.lex_state = 149, .external_lex_state = 2},
  [4903] = {.lex_state = 149, .external_lex_state = 2},
  [4904] = {.lex_state = 149, .external_lex_state = 2},
  [4905] = {.lex_state = 149, .external_lex_state = 2},
  [4906] = {.lex_state = 149, .external_lex_state = 2},
  [4907] = {.lex_state = 149, .external_lex_state = 2},
  [4908] = {.lex_state = 149, .external_lex_state = 5},
  [4909] = {.lex_state = 149, .external_lex_state = 2},
  [4910] = {.lex_state = 149, .external_lex_state = 5},
  [4911] = {.lex_state = 149, .external_lex_state = 5},
  [4912] = {.lex_state = 149, .external_lex_state = 2},
  [4913] = {.lex_state = 149, .external_lex_state = 5},
  [4914] = {.lex_state = 1, .external_lex_state = 2},
  [4915] = {.lex_state = 149, .external_lex_state = 5},
  [4916] = {.lex_state = 149, .external_lex_state = 5},
  [4917] = {.lex_state = 149, .external_lex_state = 5},
  [4918] = {.lex_state = 149, .external_lex_state = 5},
  [4919] = {.lex_state = 149, .external_lex_state = 5},
  [4920] = {.lex_state = 149, .external_lex_state = 5},
  [4921] = {.lex_state = 149, .external_lex_state = 5},
  [4922] = {.lex_state = 149, .external_lex_state = 2},
  [4923] = {.lex_state = 149, .external_lex_state = 5},
  [4924] = {.lex_state = 149, .external_lex_state = 5},
  [4925] = {.lex_state = 149, .external_lex_state = 2},
  [4926] = {.lex_state = 149, .external_lex_state = 5},
  [4927] = {.lex_state = 149, .external_lex_state = 5},
  [4928] = {.lex_state = 149, .external_lex_state = 5},
  [4929] = {.lex_state = 149, .external_lex_state = 2},
  [4930] = {.lex_state = 149, .external_lex_state = 2},
  [4931] = {.lex_state = 149, .external_lex_state = 5},
  [4932] = {.lex_state = 4, .external_lex_state = 2},
  [4933] = {.lex_state = 149, .external_lex_state = 2},
  [4934] = {.lex_state = 149, .external_lex_state = 2},
  [4935] = {.lex_state = 149, .external_lex_state = 2},
  [4936] = {.lex_state = 149, .external_lex_state = 5},
  [4937] = {.lex_state = 149, .external_lex_state = 5},
  [4938] = {.lex_state = 149, .external_lex_state = 2},
  [4939] = {.lex_state = 149, .external_lex_state = 5},
  [4940] = {.lex_state = 149, .external_lex_state = 2},
  [4941] = {.lex_state = 149, .external_lex_state = 5},
  [4942] = {.lex_state = 149, .external_lex_state = 2},
  [4943] = {.lex_state = 149, .external_lex_state = 5},
  [4944] = {.lex_state = 149, .external_lex_state = 5},
  [4945] = {.lex_state = 149, .external_lex_state = 5},
  [4946] = {.lex_state = 149, .external_lex_state = 5},
  [4947] = {.lex_state = 149, .external_lex_state = 5},
  [4948] = {.lex_state = 149, .external_lex_state = 5},
  [4949] = {.lex_state = 149, .external_lex_state = 5},
  [4950] = {.lex_state = 149, .external_lex_state = 5},
  [4951] = {.lex_state = 149, .external_lex_state = 5},
  [4952] = {.lex_state = 149, .external_lex_state = 5},
  [4953] = {.lex_state = 149, .external_lex_state = 5},
  [4954] = {.lex_state = 149, .external_lex_state = 5},
  [4955] = {.lex_state = 149, .external_lex_state = 5},
  [4956] = {.lex_state = 149, .external_lex_state = 5},
  [4957] = {.lex_state = 149, .external_lex_state = 2},
  [4958] = {.lex_state = 149, .external_lex_state = 2},
  [4959] = {.lex_state = 149, .external_lex_state = 5},
  [4960] = {.lex_state = 149, .external_lex_state = 5},
  [4961] = {.lex_state = 149, .external_lex_state = 5},
  [4962] = {.lex_state = 149, .external_lex_state = 5},
  [4963] = {.lex_state = 149, .external_lex_state = 5},
  [4964] = {.lex_state = 149, .external_lex_state = 5},
  [4965] = {.lex_state = 149, .external_lex_state = 5},
  [4966] = {.lex_state = 149, .external_lex_state = 5},
  [4967] = {.lex_state = 149, .external_lex_state = 5},
  [4968] = {.lex_state = 149, .external_lex_state = 5},
  [4969] = {.lex_state = 149, .external_lex_state = 5},
  [4970] = {.lex_state = 149, .external_lex_state = 5},
  [4971] = {.lex_state = 149, .external_lex_state = 5},
  [4972] = {.lex_state = 149, .external_lex_state = 5},
  [4973] = {.lex_state = 149, .external_lex_state = 5},
  [4974] = {.lex_state = 149, .external_lex_state = 5},
  [4975] = {.lex_state = 149, .external_lex_state = 5},
  [4976] = {.lex_state = 149, .external_lex_state = 5},
  [4977] = {.lex_state = 149, .external_lex_state = 2},
  [4978] = {.lex_state = 149, .external_lex_state = 5},
  [4979] = {.lex_state = 149, .external_lex_state = 5},
  [4980] = {.lex_state = 149, .external_lex_state = 2},
  [4981] = {.lex_state = 149, .external_lex_state = 2},
  [4982] = {.lex_state = 149, .external_lex_state = 5},
  [4983] = {.lex_state = 149, .external_lex_state = 2},
  [4984] = {.lex_state = 149, .external_lex_state = 2},
  [4985] = {.lex_state = 149, .external_lex_state = 5},
  [4986] = {.lex_state = 149, .external_lex_state = 2},
  [4987] = {.lex_state = 149, .external_lex_state = 5},
  [4988] = {.lex_state = 149, .external_lex_state = 5},
  [4989] = {.lex_state = 149, .external_lex_state = 5},
  [4990] = {.lex_state = 149, .external_lex_state = 5},
  [4991] = {.lex_state = 149, .external_lex_state = 5},
  [4992] = {.lex_state = 149, .external_lex_state = 5},
  [4993] = {.lex_state = 149, .external_lex_state = 5},
  [4994] = {.lex_state = 149, .external_lex_state = 5},
  [4995] = {.lex_state = 149, .external_lex_state = 5},
  [4996] = {.lex_state = 149, .external_lex_state = 5},
  [4997] = {.lex_state = 149, .external_lex_state = 5},
  [4998] = {.lex_state = 149, .external_lex_state = 5},
  [4999] = {.lex_state = 149, .external_lex_state = 5},
  [5000] = {.lex_state = 149, .external_lex_state = 5},
  [5001] = {.lex_state = 149, .external_lex_state = 2},
  [5002] = {.lex_state = 149, .external_lex_state = 2},
  [5003] = {.lex_state = 149, .external_lex_state = 5},
  [5004] = {.lex_state = 149, .external_lex_state = 5},
  [5005] = {.lex_state = 149, .external_lex_state = 2},
  [5006] = {.lex_state = 149, .external_lex_state = 2},
  [5007] = {.lex_state = 149, .external_lex_state = 5},
  [5008] = {.lex_state = 149, .external_lex_state = 5},
  [5009] = {.lex_state = 149, .external_lex_state = 2},
  [5010] = {.lex_state = 149, .external_lex_state = 5},
  [5011] = {.lex_state = 149, .external_lex_state = 5},
  [5012] = {.lex_state = 149, .external_lex_state = 5},
  [5013] = {.lex_state = 149, .external_lex_state = 2},
  [5014] = {.lex_state = 149, .external_lex_state = 5},
  [5015] = {.lex_state = 149, .external_lex_state = 5},
  [5016] = {.lex_state = 149, .external_lex_state = 5},
  [5017] = {.lex_state = 149, .external_lex_state = 5},
  [5018] = {.lex_state = 149, .external_lex_state = 5},
  [5019] = {.lex_state = 149, .external_lex_state = 2},
  [5020] = {.lex_state = 149, .external_lex_state = 2},
  [5021] = {.lex_state = 149, .external_lex_state = 5},
  [5022] = {.lex_state = 149, .external_lex_state = 5},
  [5023] = {.lex_state = 149, .external_lex_state = 5},
  [5024] = {.lex_state = 149, .external_lex_state = 5},
  [5025] = {.lex_state = 149, .external_lex_state = 5},
  [5026] = {.lex_state = 149, .external_lex_state = 5},
  [5027] = {.lex_state = 149, .external_lex_state = 5},
  [5028] = {.lex_state = 149, .external_lex_state = 5},
  [5029] = {.lex_state = 149, .external_lex_state = 5},
  [5030] = {.lex_state = 149, .external_lex_state = 5},
  [5031] = {.lex_state = 149, .external_lex_state = 2},
  [5032] = {.lex_state = 149, .external_lex_state = 5},
  [5033] = {.lex_state = 149, .external_lex_state = 5},
  [5034] = {.lex_state = 149, .external_lex_state = 5},
  [5035] = {.lex_state = 149, .external_lex_state = 5},
  [5036] = {.lex_state = 149, .external_lex_state = 5},
  [5037] = {.lex_state = 149, .external_lex_state = 2},
  [5038] = {.lex_state = 149, .external_lex_state = 5},
  [5039] = {.lex_state = 149, .external_lex_state = 5},
  [5040] = {.lex_state = 149, .external_lex_state = 5},
  [5041] = {.lex_state = 12, .external_lex_state = 2},
  [5042] = {.lex_state = 149, .external_lex_state = 5},
  [5043] = {.lex_state = 149, .external_lex_state = 5},
  [5044] = {.lex_state = 149, .external_lex_state = 5},
  [5045] = {.lex_state = 149, .external_lex_state = 2},
  [5046] = {.lex_state = 4, .external_lex_state = 2},
  [5047] = {.lex_state = 149, .external_lex_state = 2},
  [5048] = {.lex_state = 149, .external_lex_state = 2},
  [5049] = {.lex_state = 149, .external_lex_state = 5},
  [5050] = {.lex_state = 149, .external_lex_state = 5},
  [5051] = {.lex_state = 149, .external_lex_state = 5},
  [5052] = {.lex_state = 149, .external_lex_state = 5},
  [5053] = {.lex_state = 149, .external_lex_state = 5},
  [5054] = {.lex_state = 149, .external_lex_state = 5},
  [5055] = {.lex_state = 149, .external_lex_state = 5},
  [5056] = {.lex_state = 149, .external_lex_state = 5},
  [5057] = {.lex_state = 149, .external_lex_state = 5},
  [5058] = {.lex_state = 149, .external_lex_state = 5},
  [5059] = {.lex_state = 149, .external_lex_state = 5},
  [5060] = {.lex_state = 149, .external_lex_state = 5},
  [5061] = {.lex_state = 149, .external_lex_state = 5},
  [5062] = {.lex_state = 149, .external_lex_state = 5},
  [5063] = {.lex_state = 149, .external_lex_state = 5},
  [5064] = {.lex_state = 149, .external_lex_state = 5},
  [5065] = {.lex_state = 149, .external_lex_state = 2},
  [5066] = {.lex_state = 149, .external_lex_state = 5},
  [5067] = {.lex_state = 149, .external_lex_state = 5},
  [5068] = {.lex_state = 149, .external_lex_state = 5},
  [5069] = {.lex_state = 149, .external_lex_state = 5},
  [5070] = {.lex_state = 149, .external_lex_state = 2},
  [5071] = {.lex_state = 149, .external_lex_state = 5},
  [5072] = {.lex_state = 4, .external_lex_state = 2},
  [5073] = {.lex_state = 149, .external_lex_state = 5},
  [5074] = {.lex_state = 149, .external_lex_state = 5},
  [5075] = {.lex_state = 149, .external_lex_state = 5},
  [5076] = {.lex_state = 4, .external_lex_state = 2},
  [5077] = {.lex_state = 149, .external_lex_state = 5},
  [5078] = {.lex_state = 149, .external_lex_state = 5},
  [5079] = {.lex_state = 149, .external_lex_state = 5},
  [5080] = {.lex_state = 149, .external_lex_state = 5},
  [5081] = {.lex_state = 149, .external_lex_state = 5},
  [5082] = {.lex_state = 149, .external_lex_state = 5},
  [5083] = {.lex_state = 149, .external_lex_state = 5},
  [5084] = {.lex_state = 149, .external_lex_state = 5},
  [5085] = {.lex_state = 149, .external_lex_state = 5},
  [5086] = {.lex_state = 149, .external_lex_state = 5},
  [5087] = {.lex_state = 149, .external_lex_state = 5},
  [5088] = {.lex_state = 149, .external_lex_state = 2},
  [5089] = {.lex_state = 149, .external_lex_state = 5},
  [5090] = {.lex_state = 149, .external_lex_state = 5},
  [5091] = {.lex_state = 149, .external_lex_state = 2},
  [5092] = {.lex_state = 149, .external_lex_state = 5},
  [5093] = {.lex_state = 149, .external_lex_state = 2},
  [5094] = {.lex_state = 149, .external_lex_state = 5},
  [5095] = {.lex_state = 149, .external_lex_state = 5},
  [5096] = {.lex_state = 149, .external_lex_state = 5},
  [5097] = {.lex_state = 149, .external_lex_state = 5},
  [5098] = {.lex_state = 149, .external_lex_state = 5},
  [5099] = {.lex_state = 149, .external_lex_state = 5},
  [5100] = {.lex_state = 149, .external_lex_state = 5},
  [5101] = {.lex_state = 149, .external_lex_state = 5},
  [5102] = {.lex_state = 149, .external_lex_state = 5},
  [5103] = {.lex_state = 149, .external_lex_state = 5},
  [5104] = {.lex_state = 149, .external_lex_state = 5},
  [5105] = {.lex_state = 149, .external_lex_state = 2},
  [5106] = {.lex_state = 149, .external_lex_state = 5},
  [5107] = {.lex_state = 149, .external_lex_state = 5},
  [5108] = {.lex_state = 149, .external_lex_state = 5},
  [5109] = {.lex_state = 149, .external_lex_state = 5},
  [5110] = {.lex_state = 149, .external_lex_state = 5},
  [5111] = {.lex_state = 149, .external_lex_state = 5},
  [5112] = {.lex_state = 149, .external_lex_state = 5},
  [5113] = {.lex_state = 149, .external_lex_state = 2},
  [5114] = {.lex_state = 149, .external_lex_state = 5},
  [5115] = {.lex_state = 149, .external_lex_state = 5},
  [5116] = {.lex_state = 149, .external_lex_state = 5},
  [5117] = {.lex_state = 149, .external_lex_state = 5},
  [5118] = {.lex_state = 149, .external_lex_state = 5},
  [5119] = {.lex_state = 149, .external_lex_state = 2},
  [5120] = {.lex_state = 149, .external_lex_state = 5},
  [5121] = {.lex_state = 149, .external_lex_state = 5},
  [5122] = {.lex_state = 149, .external_lex_state = 5},
  [5123] = {.lex_state = 149, .external_lex_state = 5},
  [5124] = {.lex_state = 149, .external_lex_state = 5},
  [5125] = {.lex_state = 149, .external_lex_state = 5},
  [5126] = {.lex_state = 149, .external_lex_state = 5},
  [5127] = {.lex_state = 149, .external_lex_state = 5},
  [5128] = {.lex_state = 149, .external_lex_state = 5},
  [5129] = {.lex_state = 149, .external_lex_state = 5},
  [5130] = {.lex_state = 149, .external_lex_state = 5},
  [5131] = {.lex_state = 149, .external_lex_state = 5},
  [5132] = {.lex_state = 149, .external_lex_state = 5},
  [5133] = {.lex_state = 149, .external_lex_state = 5},
  [5134] = {.lex_state = 149, .external_lex_state = 5},
  [5135] = {.lex_state = 149, .external_lex_state = 5},
  [5136] = {.lex_state = 149, .external_lex_state = 5},
  [5137] = {.lex_state = 149, .external_lex_state = 5},
  [5138] = {.lex_state = 149, .external_lex_state = 5},
  [5139] = {.lex_state = 149, .external_lex_state = 5},
  [5140] = {.lex_state = 149, .external_lex_state = 5},
  [5141] = {.lex_state = 149, .external_lex_state = 5},
  [5142] = {.lex_state = 149, .external_lex_state = 5},
  [5143] = {.lex_state = 149, .external_lex_state = 5},
  [5144] = {.lex_state = 149, .external_lex_state = 5},
  [5145] = {.lex_state = 149, .external_lex_state = 5},
  [5146] = {.lex_state = 149, .external_lex_state = 5},
  [5147] = {.lex_state = 149, .external_lex_state = 5},
  [5148] = {.lex_state = 149, .external_lex_state = 2},
  [5149] = {.lex_state = 149, .external_lex_state = 2},
  [5150] = {.lex_state = 149, .external_lex_state = 2},
  [5151] = {.lex_state = 149, .external_lex_state = 5},
  [5152] = {.lex_state = 149, .external_lex_state = 5},
  [5153] = {.lex_state = 149, .external_lex_state = 2},
  [5154] = {.lex_state = 149, .external_lex_state = 5},
  [5155] = {.lex_state = 149, .external_lex_state = 2},
  [5156] = {.lex_state = 12, .external_lex_state = 2},
  [5157] = {.lex_state = 149, .external_lex_state = 2},
  [5158] = {.lex_state = 149, .external_lex_state = 2},
  [5159] = {.lex_state = 149, .external_lex_state = 5},
  [5160] = {.lex_state = 149, .external_lex_state = 2},
  [5161] = {.lex_state = 149, .external_lex_state = 5},
  [5162] = {.lex_state = 1, .external_lex_state = 2},
  [5163] = {.lex_state = 149, .external_lex_state = 2},
  [5164] = {.lex_state = 4, .external_lex_state = 2},
  [5165] = {.lex_state = 149, .external_lex_state = 5},
  [5166] = {.lex_state = 4, .external_lex_state = 2},
  [5167] = {.lex_state = 149, .external_lex_state = 5},
  [5168] = {.lex_state = 1, .external_lex_state = 2},
  [5169] = {.lex_state = 149, .external_lex_state = 2},
  [5170] = {.lex_state = 149, .external_lex_state = 5},
  [5171] = {.lex_state = 149, .external_lex_state = 2},
  [5172] = {.lex_state = 149, .external_lex_state = 5},
  [5173] = {.lex_state = 149, .external_lex_state = 2},
  [5174] = {.lex_state = 149, .external_lex_state = 5},
  [5175] = {.lex_state = 149, .external_lex_state = 2},
  [5176] = {.lex_state = 149, .external_lex_state = 5},
  [5177] = {.lex_state = 149, .external_lex_state = 5},
  [5178] = {.lex_state = 149, .external_lex_state = 5},
  [5179] = {.lex_state = 149, .external_lex_state = 2},
  [5180] = {.lex_state = 149, .external_lex_state = 2},
  [5181] = {.lex_state = 149, .external_lex_state = 2},
  [5182] = {.lex_state = 149, .external_lex_state = 5},
  [5183] = {.lex_state = 149, .external_lex_state = 2},
  [5184] = {.lex_state = 149, .external_lex_state = 2},
  [5185] = {.lex_state = 149, .external_lex_state = 5},
  [5186] = {.lex_state = 149, .external_lex_state = 5},
  [5187] = {.lex_state = 149, .external_lex_state = 2},
  [5188] = {.lex_state = 149, .external_lex_state = 2},
  [5189] = {.lex_state = 149, .external_lex_state = 2},
  [5190] = {.lex_state = 149, .external_lex_state = 2},
  [5191] = {.lex_state = 149, .external_lex_state = 2},
  [5192] = {.lex_state = 149, .external_lex_state = 5},
  [5193] = {.lex_state = 149, .external_lex_state = 5},
  [5194] = {.lex_state = 149, .external_lex_state = 5},
  [5195] = {.lex_state = 149, .external_lex_state = 5},
  [5196] = {.lex_state = 149, .external_lex_state = 2},
  [5197] = {.lex_state = 149, .external_lex_state = 5},
  [5198] = {.lex_state = 12, .external_lex_state = 2},
  [5199] = {.lex_state = 149, .external_lex_state = 2},
  [5200] = {.lex_state = 149, .external_lex_state = 2},
  [5201] = {.lex_state = 1, .external_lex_state = 2},
  [5202] = {.lex_state = 149, .external_lex_state = 5},
  [5203] = {.lex_state = 149, .external_lex_state = 2},
  [5204] = {.lex_state = 149, .external_lex_state = 5},
  [5205] = {.lex_state = 149, .external_lex_state = 2},
  [5206] = {.lex_state = 149, .external_lex_state = 5},
  [5207] = {.lex_state = 149, .external_lex_state = 5},
  [5208] = {.lex_state = 149, .external_lex_state = 5},
  [5209] = {.lex_state = 149, .external_lex_state = 5},
  [5210] = {.lex_state = 149, .external_lex_state = 5},
  [5211] = {.lex_state = 149, .external_lex_state = 2},
  [5212] = {.lex_state = 149, .external_lex_state = 2},
  [5213] = {.lex_state = 149, .external_lex_state = 5},
  [5214] = {.lex_state = 149, .external_lex_state = 5},
  [5215] = {.lex_state = 149, .external_lex_state = 5},
  [5216] = {.lex_state = 149, .external_lex_state = 2},
  [5217] = {.lex_state = 149, .external_lex_state = 5},
  [5218] = {.lex_state = 23, .external_lex_state = 9},
  [5219] = {.lex_state = 149, .external_lex_state = 5},
  [5220] = {.lex_state = 149, .external_lex_state = 2},
  [5221] = {.lex_state = 149, .external_lex_state = 5},
  [5222] = {.lex_state = 149, .external_lex_state = 5},
  [5223] = {.lex_state = 149, .external_lex_state = 5},
  [5224] = {.lex_state = 149, .external_lex_state = 5},
  [5225] = {.lex_state = 149, .external_lex_state = 5},
  [5226] = {.lex_state = 149, .external_lex_state = 5},
  [5227] = {.lex_state = 149, .external_lex_state = 2},
  [5228] = {.lex_state = 149, .external_lex_state = 5},
  [5229] = {.lex_state = 149, .external_lex_state = 2},
  [5230] = {.lex_state = 149, .external_lex_state = 5},
  [5231] = {.lex_state = 149, .external_lex_state = 5},
  [5232] = {.lex_state = 149, .external_lex_state = 2},
  [5233] = {.lex_state = 149, .external_lex_state = 2},
  [5234] = {.lex_state = 149, .external_lex_state = 2},
  [5235] = {.lex_state = 149, .external_lex_state = 2},
  [5236] = {.lex_state = 149, .external_lex_state = 2},
  [5237] = {.lex_state = 149, .external_lex_state = 2},
  [5238] = {.lex_state = 149, .external_lex_state = 2},
  [5239] = {.lex_state = 149, .external_lex_state = 2},
  [5240] = {.lex_state = 149, .external_lex_state = 2},
  [5241] = {.lex_state = 149, .external_lex_state = 2},
  [5242] = {.lex_state = 149, .external_lex_state = 2},
  [5243] = {.lex_state = 149, .external_lex_state = 2},
  [5244] = {.lex_state = 149, .external_lex_state = 2},
  [5245] = {.lex_state = 149, .external_lex_state = 2},
  [5246] = {.lex_state = 149, .external_lex_state = 2},
  [5247] = {.lex_state = 149, .external_lex_state = 2},
  [5248] = {.lex_state = 149, .external_lex_state = 2},
  [5249] = {.lex_state = 149, .external_lex_state = 2},
  [5250] = {.lex_state = 149, .external_lex_state = 2},
  [5251] = {.lex_state = 149, .external_lex_state = 2},
  [5252] = {.lex_state = 149, .external_lex_state = 2},
  [5253] = {.lex_state = 149, .external_lex_state = 2},
  [5254] = {.lex_state = 149, .external_lex_state = 2},
  [5255] = {.lex_state = 149, .external_lex_state = 2},
  [5256] = {.lex_state = 149, .external_lex_state = 5},
  [5257] = {.lex_state = 149, .external_lex_state = 2},
  [5258] = {.lex_state = 149, .external_lex_state = 2},
  [5259] = {.lex_state = 149, .external_lex_state = 2},
  [5260] = {.lex_state = 149, .external_lex_state = 2},
  [5261] = {.lex_state = 149, .external_lex_state = 2},
  [5262] = {.lex_state = 149, .external_lex_state = 2},
  [5263] = {.lex_state = 149, .external_lex_state = 2},
  [5264] = {.lex_state = 149, .external_lex_state = 2},
  [5265] = {.lex_state = 149, .external_lex_state = 5},
  [5266] = {.lex_state = 149, .external_lex_state = 2},
  [5267] = {.lex_state = 149, .external_lex_state = 2},
  [5268] = {.lex_state = 149, .external_lex_state = 2},
  [5269] = {.lex_state = 149, .external_lex_state = 5},
  [5270] = {.lex_state = 149, .external_lex_state = 2},
  [5271] = {.lex_state = 149, .external_lex_state = 2},
  [5272] = {.lex_state = 149, .external_lex_state = 2},
  [5273] = {.lex_state = 149, .external_lex_state = 2},
  [5274] = {.lex_state = 149, .external_lex_state = 2},
  [5275] = {.lex_state = 149, .external_lex_state = 2},
  [5276] = {.lex_state = 149, .external_lex_state = 2},
  [5277] = {.lex_state = 149, .external_lex_state = 2},
  [5278] = {.lex_state = 149, .external_lex_state = 2},
  [5279] = {.lex_state = 149, .external_lex_state = 2},
  [5280] = {.lex_state = 149, .external_lex_state = 2},
  [5281] = {.lex_state = 149, .external_lex_state = 2},
  [5282] = {.lex_state = 149, .external_lex_state = 2},
  [5283] = {.lex_state = 149, .external_lex_state = 2},
  [5284] = {.lex_state = 149, .external_lex_state = 2},
  [5285] = {.lex_state = 149, .external_lex_state = 2},
  [5286] = {.lex_state = 149, .external_lex_state = 2},
  [5287] = {.lex_state = 149, .external_lex_state = 2},
  [5288] = {.lex_state = 149, .external_lex_state = 2},
  [5289] = {.lex_state = 149, .external_lex_state = 2},
  [5290] = {.lex_state = 149, .external_lex_state = 2},
  [5291] = {.lex_state = 149, .external_lex_state = 2},
  [5292] = {.lex_state = 149, .external_lex_state = 2},
  [5293] = {.lex_state = 149, .external_lex_state = 2},
  [5294] = {.lex_state = 149, .external_lex_state = 2},
  [5295] = {.lex_state = 149, .external_lex_state = 2},
  [5296] = {.lex_state = 149, .external_lex_state = 2},
  [5297] = {.lex_state = 149, .external_lex_state = 2},
  [5298] = {.lex_state = 149, .external_lex_state = 2},
  [5299] = {.lex_state = 149, .external_lex_state = 2},
  [5300] = {.lex_state = 16, .external_lex_state = 2},
  [5301] = {.lex_state = 149, .external_lex_state = 2},
  [5302] = {.lex_state = 149, .external_lex_state = 2},
  [5303] = {.lex_state = 149, .external_lex_state = 2},
  [5304] = {.lex_state = 149, .external_lex_state = 2},
  [5305] = {.lex_state = 149, .external_lex_state = 2},
  [5306] = {.lex_state = 149, .external_lex_state = 2},
  [5307] = {.lex_state = 149, .external_lex_state = 2},
  [5308] = {.lex_state = 149, .external_lex_state = 2},
  [5309] = {.lex_state = 149, .external_lex_state = 2},
  [5310] = {.lex_state = 149, .external_lex_state = 2},
  [5311] = {.lex_state = 149, .external_lex_state = 5},
  [5312] = {.lex_state = 149, .external_lex_state = 2},
  [5313] = {.lex_state = 149, .external_lex_state = 2},
  [5314] = {.lex_state = 149, .external_lex_state = 2},
  [5315] = {.lex_state = 149, .external_lex_state = 2},
  [5316] = {.lex_state = 149, .external_lex_state = 2},
  [5317] = {.lex_state = 149, .external_lex_state = 2},
  [5318] = {.lex_state = 149, .external_lex_state = 2},
  [5319] = {.lex_state = 149, .external_lex_state = 5},
  [5320] = {.lex_state = 149, .external_lex_state = 2},
  [5321] = {.lex_state = 149, .external_lex_state = 2},
  [5322] = {.lex_state = 149, .external_lex_state = 2},
  [5323] = {.lex_state = 149, .external_lex_state = 2},
  [5324] = {.lex_state = 149, .external_lex_state = 2},
  [5325] = {.lex_state = 149, .external_lex_state = 2},
  [5326] = {.lex_state = 149, .external_lex_state = 2},
  [5327] = {.lex_state = 149, .external_lex_state = 2},
  [5328] = {.lex_state = 149, .external_lex_state = 2},
  [5329] = {.lex_state = 149, .external_lex_state = 5},
  [5330] = {.lex_state = 149, .external_lex_state = 2},
  [5331] = {.lex_state = 149, .external_lex_state = 2},
  [5332] = {.lex_state = 149, .external_lex_state = 5},
  [5333] = {.lex_state = 149, .external_lex_state = 2},
  [5334] = {.lex_state = 149, .external_lex_state = 2},
  [5335] = {.lex_state = 149, .external_lex_state = 2},
  [5336] = {.lex_state = 149, .external_lex_state = 2},
  [5337] = {.lex_state = 149, .external_lex_state = 2},
  [5338] = {.lex_state = 149, .external_lex_state = 2},
  [5339] = {.lex_state = 149, .external_lex_state = 2},
  [5340] = {.lex_state = 149, .external_lex_state = 2},
  [5341] = {.lex_state = 149, .external_lex_state = 2},
  [5342] = {.lex_state = 149, .external_lex_state = 2},
  [5343] = {.lex_state = 149, .external_lex_state = 2},
  [5344] = {.lex_state = 149, .external_lex_state = 5},
  [5345] = {.lex_state = 149, .external_lex_state = 2},
  [5346] = {.lex_state = 149, .external_lex_state = 2},
  [5347] = {.lex_state = 149, .external_lex_state = 2},
  [5348] = {.lex_state = 149, .external_lex_state = 2},
  [5349] = {.lex_state = 149, .external_lex_state = 2},
  [5350] = {.lex_state = 149, .external_lex_state = 2},
  [5351] = {.lex_state = 149, .external_lex_state = 2},
  [5352] = {.lex_state = 149, .external_lex_state = 2},
  [5353] = {.lex_state = 149, .external_lex_state = 2},
  [5354] = {.lex_state = 149, .external_lex_state = 2},
  [5355] = {.lex_state = 149, .external_lex_state = 2},
  [5356] = {.lex_state = 149, .external_lex_state = 2},
  [5357] = {.lex_state = 149, .external_lex_state = 2},
  [5358] = {.lex_state = 149, .external_lex_state = 2},
  [5359] = {.lex_state = 149, .external_lex_state = 2},
  [5360] = {.lex_state = 149, .external_lex_state = 2},
  [5361] = {.lex_state = 149, .external_lex_state = 2},
  [5362] = {.lex_state = 149, .external_lex_state = 2},
  [5363] = {.lex_state = 149, .external_lex_state = 2},
  [5364] = {.lex_state = 149, .external_lex_state = 2},
  [5365] = {.lex_state = 149, .external_lex_state = 2},
  [5366] = {.lex_state = 149, .external_lex_state = 2},
  [5367] = {.lex_state = 149, .external_lex_state = 2},
  [5368] = {.lex_state = 149, .external_lex_state = 2},
  [5369] = {.lex_state = 149, .external_lex_state = 2},
  [5370] = {.lex_state = 149, .external_lex_state = 2},
  [5371] = {.lex_state = 149, .external_lex_state = 2},
  [5372] = {.lex_state = 149, .external_lex_state = 2},
  [5373] = {.lex_state = 149, .external_lex_state = 2},
  [5374] = {.lex_state = 149, .external_lex_state = 2},
  [5375] = {.lex_state = 149, .external_lex_state = 2},
  [5376] = {.lex_state = 149, .external_lex_state = 2},
  [5377] = {.lex_state = 149, .external_lex_state = 2},
  [5378] = {.lex_state = 149, .external_lex_state = 2},
  [5379] = {.lex_state = 149, .external_lex_state = 2},
  [5380] = {.lex_state = 149, .external_lex_state = 2},
  [5381] = {.lex_state = 149, .external_lex_state = 2},
  [5382] = {.lex_state = 149, .external_lex_state = 2},
  [5383] = {.lex_state = 149, .external_lex_state = 2},
  [5384] = {.lex_state = 149, .external_lex_state = 2},
  [5385] = {.lex_state = 149, .external_lex_state = 2},
  [5386] = {.lex_state = 149, .external_lex_state = 2},
  [5387] = {.lex_state = 149, .external_lex_state = 2},
  [5388] = {.lex_state = 149, .external_lex_state = 2},
  [5389] = {.lex_state = 149, .external_lex_state = 2},
  [5390] = {.lex_state = 149, .external_lex_state = 2},
  [5391] = {.lex_state = 149, .external_lex_state = 2},
  [5392] = {.lex_state = 149, .external_lex_state = 2},
  [5393] = {.lex_state = 149, .external_lex_state = 2},
  [5394] = {.lex_state = 149, .external_lex_state = 2},
  [5395] = {.lex_state = 149, .external_lex_state = 2},
  [5396] = {.lex_state = 149, .external_lex_state = 2},
  [5397] = {.lex_state = 149, .external_lex_state = 2},
  [5398] = {.lex_state = 149, .external_lex_state = 2},
  [5399] = {.lex_state = 149, .external_lex_state = 2},
  [5400] = {.lex_state = 149, .external_lex_state = 2},
  [5401] = {.lex_state = 149, .external_lex_state = 2},
  [5402] = {.lex_state = 149, .external_lex_state = 2},
  [5403] = {.lex_state = 149, .external_lex_state = 5},
  [5404] = {.lex_state = 149, .external_lex_state = 2},
  [5405] = {.lex_state = 149, .external_lex_state = 2},
  [5406] = {.lex_state = 149, .external_lex_state = 2},
  [5407] = {.lex_state = 149, .external_lex_state = 2},
  [5408] = {.lex_state = 149, .external_lex_state = 2},
  [5409] = {.lex_state = 149, .external_lex_state = 2},
  [5410] = {.lex_state = 149, .external_lex_state = 2},
  [5411] = {.lex_state = 149, .external_lex_state = 2},
  [5412] = {.lex_state = 149, .external_lex_state = 2},
  [5413] = {.lex_state = 149, .external_lex_state = 2},
  [5414] = {.lex_state = 149, .external_lex_state = 2},
  [5415] = {.lex_state = 149, .external_lex_state = 2},
  [5416] = {.lex_state = 149, .external_lex_state = 2},
  [5417] = {.lex_state = 149, .external_lex_state = 2},
  [5418] = {.lex_state = 149, .external_lex_state = 2},
  [5419] = {.lex_state = 149, .external_lex_state = 2},
  [5420] = {.lex_state = 149, .external_lex_state = 2},
  [5421] = {.lex_state = 149, .external_lex_state = 2},
  [5422] = {.lex_state = 149, .external_lex_state = 2},
  [5423] = {.lex_state = 149, .external_lex_state = 2},
  [5424] = {.lex_state = 149, .external_lex_state = 2},
  [5425] = {.lex_state = 149, .external_lex_state = 2},
  [5426] = {.lex_state = 149, .external_lex_state = 2},
  [5427] = {.lex_state = 149, .external_lex_state = 2},
  [5428] = {.lex_state = 149, .external_lex_state = 2},
  [5429] = {.lex_state = 149, .external_lex_state = 2},
  [5430] = {.lex_state = 149, .external_lex_state = 5},
  [5431] = {.lex_state = 149, .external_lex_state = 2},
  [5432] = {.lex_state = 149, .external_lex_state = 2},
  [5433] = {.lex_state = 149, .external_lex_state = 2},
  [5434] = {.lex_state = 149, .external_lex_state = 2},
  [5435] = {.lex_state = 149, .external_lex_state = 2},
  [5436] = {.lex_state = 149, .external_lex_state = 2},
  [5437] = {.lex_state = 149, .external_lex_state = 2},
  [5438] = {.lex_state = 149, .external_lex_state = 5},
  [5439] = {.lex_state = 149, .external_lex_state = 2},
  [5440] = {.lex_state = 149, .external_lex_state = 5},
  [5441] = {.lex_state = 149, .external_lex_state = 2},
  [5442] = {.lex_state = 149, .external_lex_state = 2},
  [5443] = {.lex_state = 149, .external_lex_state = 2},
  [5444] = {.lex_state = 149, .external_lex_state = 2},
  [5445] = {.lex_state = 149, .external_lex_state = 2},
  [5446] = {.lex_state = 149, .external_lex_state = 2},
  [5447] = {.lex_state = 149, .external_lex_state = 2},
  [5448] = {.lex_state = 149, .external_lex_state = 2},
  [5449] = {.lex_state = 149, .external_lex_state = 5},
  [5450] = {.lex_state = 149, .external_lex_state = 2},
  [5451] = {.lex_state = 149, .external_lex_state = 2},
  [5452] = {.lex_state = 149, .external_lex_state = 2},
  [5453] = {.lex_state = 149, .external_lex_state = 2},
  [5454] = {.lex_state = 149, .external_lex_state = 5},
  [5455] = {.lex_state = 149, .external_lex_state = 2},
  [5456] = {.lex_state = 149, .external_lex_state = 2},
  [5457] = {.lex_state = 149, .external_lex_state = 2},
  [5458] = {.lex_state = 149, .external_lex_state = 2},
  [5459] = {.lex_state = 149, .external_lex_state = 2},
  [5460] = {.lex_state = 149, .external_lex_state = 5},
  [5461] = {.lex_state = 149, .external_lex_state = 2},
  [5462] = {.lex_state = 149, .external_lex_state = 5},
  [5463] = {.lex_state = 149, .external_lex_state = 2},
  [5464] = {.lex_state = 149, .external_lex_state = 2},
  [5465] = {.lex_state = 149, .external_lex_state = 5},
  [5466] = {.lex_state = 149, .external_lex_state = 2},
  [5467] = {.lex_state = 149, .external_lex_state = 5},
  [5468] = {.lex_state = 149, .external_lex_state = 2},
  [5469] = {.lex_state = 149, .external_lex_state = 2},
  [5470] = {.lex_state = 149, .external_lex_state = 5},
  [5471] = {.lex_state = 149, .external_lex_state = 2},
  [5472] = {.lex_state = 149, .external_lex_state = 2},
  [5473] = {.lex_state = 149, .external_lex_state = 5},
  [5474] = {.lex_state = 149, .external_lex_state = 2},
  [5475] = {.lex_state = 149, .external_lex_state = 5},
  [5476] = {.lex_state = 149, .external_lex_state = 2},
  [5477] = {.lex_state = 149, .external_lex_state = 5},
  [5478] = {.lex_state = 149, .external_lex_state = 2},
  [5479] = {.lex_state = 149, .external_lex_state = 2},
  [5480] = {.lex_state = 149, .external_lex_state = 2},
  [5481] = {.lex_state = 149, .external_lex_state = 5},
  [5482] = {.lex_state = 149, .external_lex_state = 2},
  [5483] = {.lex_state = 149, .external_lex_state = 5},
  [5484] = {.lex_state = 149, .external_lex_state = 2},
  [5485] = {.lex_state = 149, .external_lex_state = 5},
  [5486] = {.lex_state = 149, .external_lex_state = 2},
  [5487] = {.lex_state = 149, .external_lex_state = 2},
  [5488] = {.lex_state = 149, .external_lex_state = 2},
  [5489] = {.lex_state = 149, .external_lex_state = 2},
  [5490] = {.lex_state = 149, .external_lex_state = 2},
  [5491] = {.lex_state = 149, .external_lex_state = 2},
  [5492] = {.lex_state = 149, .external_lex_state = 2},
  [5493] = {.lex_state = 149, .external_lex_state = 2},
  [5494] = {.lex_state = 149, .external_lex_state = 2},
  [5495] = {.lex_state = 149, .external_lex_state = 2},
  [5496] = {.lex_state = 149, .external_lex_state = 2},
  [5497] = {.lex_state = 149, .external_lex_state = 2},
  [5498] = {.lex_state = 149, .external_lex_state = 2},
  [5499] = {.lex_state = 149, .external_lex_state = 2},
  [5500] = {.lex_state = 149, .external_lex_state = 2},
  [5501] = {.lex_state = 149, .external_lex_state = 2},
  [5502] = {.lex_state = 149, .external_lex_state = 5},
  [5503] = {.lex_state = 149, .external_lex_state = 2},
  [5504] = {.lex_state = 149, .external_lex_state = 2},
  [5505] = {.lex_state = 149, .external_lex_state = 2},
  [5506] = {.lex_state = 149, .external_lex_state = 2},
  [5507] = {.lex_state = 149, .external_lex_state = 2},
  [5508] = {.lex_state = 149, .external_lex_state = 2},
  [5509] = {.lex_state = 149, .external_lex_state = 2},
  [5510] = {.lex_state = 149, .external_lex_state = 2},
  [5511] = {.lex_state = 149, .external_lex_state = 2},
  [5512] = {.lex_state = 149, .external_lex_state = 2},
  [5513] = {.lex_state = 149, .external_lex_state = 2},
  [5514] = {.lex_state = 149, .external_lex_state = 2},
  [5515] = {.lex_state = 149, .external_lex_state = 2},
  [5516] = {.lex_state = 149, .external_lex_state = 5},
  [5517] = {.lex_state = 149, .external_lex_state = 2},
  [5518] = {.lex_state = 149, .external_lex_state = 2},
  [5519] = {.lex_state = 149, .external_lex_state = 2},
  [5520] = {.lex_state = 149, .external_lex_state = 2},
  [5521] = {.lex_state = 149, .external_lex_state = 2},
  [5522] = {.lex_state = 149, .external_lex_state = 2},
  [5523] = {.lex_state = 149, .external_lex_state = 2},
  [5524] = {.lex_state = 149, .external_lex_state = 2},
  [5525] = {.lex_state = 149, .external_lex_state = 2},
  [5526] = {.lex_state = 149, .external_lex_state = 2},
  [5527] = {.lex_state = 149, .external_lex_state = 2},
  [5528] = {.lex_state = 149, .external_lex_state = 2},
  [5529] = {.lex_state = 149, .external_lex_state = 2},
  [5530] = {.lex_state = 149, .external_lex_state = 2},
  [5531] = {.lex_state = 149, .external_lex_state = 2},
  [5532] = {.lex_state = 149, .external_lex_state = 2},
  [5533] = {.lex_state = 149, .external_lex_state = 2},
  [5534] = {.lex_state = 149, .external_lex_state = 2},
  [5535] = {.lex_state = 149, .external_lex_state = 2},
  [5536] = {.lex_state = 149, .external_lex_state = 2},
  [5537] = {.lex_state = 149, .external_lex_state = 2},
  [5538] = {.lex_state = 149, .external_lex_state = 2},
  [5539] = {.lex_state = 149, .external_lex_state = 2},
  [5540] = {.lex_state = 149, .external_lex_state = 2},
  [5541] = {.lex_state = 149, .external_lex_state = 2},
  [5542] = {.lex_state = 149, .external_lex_state = 2},
  [5543] = {.lex_state = 149, .external_lex_state = 2},
  [5544] = {.lex_state = 149, .external_lex_state = 2},
  [5545] = {.lex_state = 149, .external_lex_state = 2},
  [5546] = {.lex_state = 149, .external_lex_state = 2},
  [5547] = {.lex_state = 149, .external_lex_state = 2},
  [5548] = {.lex_state = 149, .external_lex_state = 2},
  [5549] = {.lex_state = 149, .external_lex_state = 2},
  [5550] = {.lex_state = 149, .external_lex_state = 2},
  [5551] = {.lex_state = 149, .external_lex_state = 2},
  [5552] = {.lex_state = 149, .external_lex_state = 2},
  [5553] = {.lex_state = 149, .external_lex_state = 2},
  [5554] = {.lex_state = 149, .external_lex_state = 2},
  [5555] = {.lex_state = 149, .external_lex_state = 2},
  [5556] = {.lex_state = 149, .external_lex_state = 2},
  [5557] = {.lex_state = 149, .external_lex_state = 2},
  [5558] = {.lex_state = 149, .external_lex_state = 2},
  [5559] = {.lex_state = 149, .external_lex_state = 2},
  [5560] = {.lex_state = 149, .external_lex_state = 2},
  [5561] = {.lex_state = 149, .external_lex_state = 2},
  [5562] = {.lex_state = 149, .external_lex_state = 2},
  [5563] = {.lex_state = 149, .external_lex_state = 2},
  [5564] = {.lex_state = 149, .external_lex_state = 2},
  [5565] = {.lex_state = 149, .external_lex_state = 2},
  [5566] = {.lex_state = 149, .external_lex_state = 2},
  [5567] = {.lex_state = 149, .external_lex_state = 2},
  [5568] = {.lex_state = 149, .external_lex_state = 2},
  [5569] = {.lex_state = 149, .external_lex_state = 2},
  [5570] = {.lex_state = 149, .external_lex_state = 2},
  [5571] = {.lex_state = 149, .external_lex_state = 5},
  [5572] = {.lex_state = 149, .external_lex_state = 2},
  [5573] = {.lex_state = 149, .external_lex_state = 2},
  [5574] = {.lex_state = 149, .external_lex_state = 2},
  [5575] = {.lex_state = 149, .external_lex_state = 2},
  [5576] = {.lex_state = 149, .external_lex_state = 2},
  [5577] = {.lex_state = 149, .external_lex_state = 2},
  [5578] = {.lex_state = 149, .external_lex_state = 2},
  [5579] = {.lex_state = 149, .external_lex_state = 2},
  [5580] = {.lex_state = 149, .external_lex_state = 2},
  [5581] = {.lex_state = 149, .external_lex_state = 2},
  [5582] = {.lex_state = 149, .external_lex_state = 2},
  [5583] = {.lex_state = 149, .external_lex_state = 2},
  [5584] = {.lex_state = 149, .external_lex_state = 2},
  [5585] = {.lex_state = 149, .external_lex_state = 2},
  [5586] = {.lex_state = 149, .external_lex_state = 2},
  [5587] = {.lex_state = 149, .external_lex_state = 2},
  [5588] = {.lex_state = 149, .external_lex_state = 2},
  [5589] = {.lex_state = 149, .external_lex_state = 2},
  [5590] = {.lex_state = 149, .external_lex_state = 2},
  [5591] = {.lex_state = 149, .external_lex_state = 2},
  [5592] = {.lex_state = 149, .external_lex_state = 2},
  [5593] = {.lex_state = 149, .external_lex_state = 2},
  [5594] = {.lex_state = 149, .external_lex_state = 2},
  [5595] = {.lex_state = 38, .external_lex_state = 2},
  [5596] = {.lex_state = 149, .external_lex_state = 2},
  [5597] = {.lex_state = 149, .external_lex_state = 2},
  [5598] = {.lex_state = 149, .external_lex_state = 2},
  [5599] = {.lex_state = 149, .external_lex_state = 2},
  [5600] = {.lex_state = 149, .external_lex_state = 2},
  [5601] = {.lex_state = 149, .external_lex_state = 2},
  [5602] = {.lex_state = 149, .external_lex_state = 2},
  [5603] = {.lex_state = 149, .external_lex_state = 2},
  [5604] = {.lex_state = 149, .external_lex_state = 2},
  [5605] = {.lex_state = 149, .external_lex_state = 2},
  [5606] = {.lex_state = 149, .external_lex_state = 2},
  [5607] = {.lex_state = 149, .external_lex_state = 2},
  [5608] = {.lex_state = 149, .external_lex_state = 2},
  [5609] = {.lex_state = 149, .external_lex_state = 2},
  [5610] = {.lex_state = 149, .external_lex_state = 2},
  [5611] = {.lex_state = 149, .external_lex_state = 2},
  [5612] = {.lex_state = 149, .external_lex_state = 2},
  [5613] = {.lex_state = 149, .external_lex_state = 2},
  [5614] = {.lex_state = 149, .external_lex_state = 2},
  [5615] = {.lex_state = 149, .external_lex_state = 2},
  [5616] = {.lex_state = 149, .external_lex_state = 2},
  [5617] = {.lex_state = 149, .external_lex_state = 2},
  [5618] = {.lex_state = 149, .external_lex_state = 2},
  [5619] = {.lex_state = 149, .external_lex_state = 2},
  [5620] = {.lex_state = 149, .external_lex_state = 2},
  [5621] = {.lex_state = 149, .external_lex_state = 2},
  [5622] = {.lex_state = 149, .external_lex_state = 2},
  [5623] = {.lex_state = 149, .external_lex_state = 2},
  [5624] = {.lex_state = 149, .external_lex_state = 2},
  [5625] = {.lex_state = 149, .external_lex_state = 2},
  [5626] = {.lex_state = 149, .external_lex_state = 2},
  [5627] = {.lex_state = 149, .external_lex_state = 2},
  [5628] = {.lex_state = 149, .external_lex_state = 2},
  [5629] = {.lex_state = 149, .external_lex_state = 2},
  [5630] = {.lex_state = 149, .external_lex_state = 2},
  [5631] = {.lex_state = 149, .external_lex_state = 2},
  [5632] = {.lex_state = 149, .external_lex_state = 2},
  [5633] = {.lex_state = 149, .external_lex_state = 2},
  [5634] = {.lex_state = 149, .external_lex_state = 2},
  [5635] = {.lex_state = 149, .external_lex_state = 2},
  [5636] = {.lex_state = 149, .external_lex_state = 2},
  [5637] = {.lex_state = 149, .external_lex_state = 2},
  [5638] = {.lex_state = 149, .external_lex_state = 2},
  [5639] = {.lex_state = 149, .external_lex_state = 2},
  [5640] = {.lex_state = 149, .external_lex_state = 2},
  [5641] = {.lex_state = 149, .external_lex_state = 2},
  [5642] = {.lex_state = 149, .external_lex_state = 2},
  [5643] = {.lex_state = 149, .external_lex_state = 2},
  [5644] = {.lex_state = 149, .external_lex_state = 2},
  [5645] = {.lex_state = 149, .external_lex_state = 2},
  [5646] = {.lex_state = 149, .external_lex_state = 2},
  [5647] = {.lex_state = 149, .external_lex_state = 2},
  [5648] = {.lex_state = 149, .external_lex_state = 2},
  [5649] = {.lex_state = 149, .external_lex_state = 2},
  [5650] = {.lex_state = 149, .external_lex_state = 2},
  [5651] = {.lex_state = 149, .external_lex_state = 2},
  [5652] = {.lex_state = 149, .external_lex_state = 2},
  [5653] = {.lex_state = 149, .external_lex_state = 2},
  [5654] = {.lex_state = 149, .external_lex_state = 2},
  [5655] = {.lex_state = 149, .external_lex_state = 2},
  [5656] = {.lex_state = 149, .external_lex_state = 2},
  [5657] = {.lex_state = 149, .external_lex_state = 2},
  [5658] = {.lex_state = 149, .external_lex_state = 2},
  [5659] = {.lex_state = 149, .external_lex_state = 2},
  [5660] = {.lex_state = 149, .external_lex_state = 2},
  [5661] = {.lex_state = 149, .external_lex_state = 2},
  [5662] = {.lex_state = 149, .external_lex_state = 2},
  [5663] = {.lex_state = 149, .external_lex_state = 2},
  [5664] = {.lex_state = 149, .external_lex_state = 2},
  [5665] = {.lex_state = 149, .external_lex_state = 2},
  [5666] = {.lex_state = 149, .external_lex_state = 2},
  [5667] = {.lex_state = 149, .external_lex_state = 2},
  [5668] = {.lex_state = 149, .external_lex_state = 2},
  [5669] = {.lex_state = 149, .external_lex_state = 2},
  [5670] = {.lex_state = 149, .external_lex_state = 2},
  [5671] = {.lex_state = 149, .external_lex_state = 2},
  [5672] = {.lex_state = 149, .external_lex_state = 2},
  [5673] = {.lex_state = 149, .external_lex_state = 2},
  [5674] = {.lex_state = 38, .external_lex_state = 2},
  [5675] = {.lex_state = 149, .external_lex_state = 2},
  [5676] = {.lex_state = 149, .external_lex_state = 2},
  [5677] = {.lex_state = 149, .external_lex_state = 2},
  [5678] = {.lex_state = 149, .external_lex_state = 2},
  [5679] = {.lex_state = 149, .external_lex_state = 2},
  [5680] = {.lex_state = 149, .external_lex_state = 2},
  [5681] = {.lex_state = 149, .external_lex_state = 2},
  [5682] = {.lex_state = 149, .external_lex_state = 2},
  [5683] = {.lex_state = 149, .external_lex_state = 2},
  [5684] = {.lex_state = 149, .external_lex_state = 2},
  [5685] = {.lex_state = 149, .external_lex_state = 2},
  [5686] = {.lex_state = 149, .external_lex_state = 2},
  [5687] = {.lex_state = 2, .external_lex_state = 11},
  [5688] = {.lex_state = 149, .external_lex_state = 2},
  [5689] = {.lex_state = 149, .external_lex_state = 2},
  [5690] = {.lex_state = 149, .external_lex_state = 2},
  [5691] = {.lex_state = 149, .external_lex_state = 2},
  [5692] = {.lex_state = 149, .external_lex_state = 2},
  [5693] = {.lex_state = 149, .external_lex_state = 2},
  [5694] = {.lex_state = 149, .external_lex_state = 2},
  [5695] = {.lex_state = 149, .external_lex_state = 2},
  [5696] = {.lex_state = 149, .external_lex_state = 2},
  [5697] = {.lex_state = 149, .external_lex_state = 2},
  [5698] = {.lex_state = 149, .external_lex_state = 2},
  [5699] = {.lex_state = 149, .external_lex_state = 2},
  [5700] = {.lex_state = 149, .external_lex_state = 2},
  [5701] = {.lex_state = 149, .external_lex_state = 2},
  [5702] = {.lex_state = 149, .external_lex_state = 2},
  [5703] = {.lex_state = 149, .external_lex_state = 2},
  [5704] = {.lex_state = 149, .external_lex_state = 2},
  [5705] = {.lex_state = 149, .external_lex_state = 2},
  [5706] = {.lex_state = 149, .external_lex_state = 2},
  [5707] = {.lex_state = 149, .external_lex_state = 2},
  [5708] = {.lex_state = 149, .external_lex_state = 2},
  [5709] = {.lex_state = 149, .external_lex_state = 2},
  [5710] = {.lex_state = 149, .external_lex_state = 2},
  [5711] = {.lex_state = 149, .external_lex_state = 2},
  [5712] = {.lex_state = 149, .external_lex_state = 2},
  [5713] = {.lex_state = 149, .external_lex_state = 2},
  [5714] = {.lex_state = 149, .external_lex_state = 2},
  [5715] = {.lex_state = 149, .external_lex_state = 2},
  [5716] = {.lex_state = 149, .external_lex_state = 2},
  [5717] = {.lex_state = 149, .external_lex_state = 2},
  [5718] = {.lex_state = 149, .external_lex_state = 2},
  [5719] = {.lex_state = 149, .external_lex_state = 2},
  [5720] = {.lex_state = 149, .external_lex_state = 2},
  [5721] = {.lex_state = 149, .external_lex_state = 2},
  [5722] = {.lex_state = 149, .external_lex_state = 2},
  [5723] = {.lex_state = 149, .external_lex_state = 2},
  [5724] = {.lex_state = 149, .external_lex_state = 2},
  [5725] = {.lex_state = 149, .external_lex_state = 2},
  [5726] = {.lex_state = 149, .external_lex_state = 2},
  [5727] = {.lex_state = 149, .external_lex_state = 2},
  [5728] = {.lex_state = 149, .external_lex_state = 2},
  [5729] = {.lex_state = 149, .external_lex_state = 2},
  [5730] = {.lex_state = 149, .external_lex_state = 2},
  [5731] = {.lex_state = 149, .external_lex_state = 2},
  [5732] = {.lex_state = 149, .external_lex_state = 2},
  [5733] = {.lex_state = 149, .external_lex_state = 2},
  [5734] = {.lex_state = 149, .external_lex_state = 2},
  [5735] = {.lex_state = 149, .external_lex_state = 2},
  [5736] = {.lex_state = 149, .external_lex_state = 2},
  [5737] = {.lex_state = 149, .external_lex_state = 2},
  [5738] = {.lex_state = 149, .external_lex_state = 2},
  [5739] = {.lex_state = 149, .external_lex_state = 2},
  [5740] = {.lex_state = 149, .external_lex_state = 2},
  [5741] = {.lex_state = 149, .external_lex_state = 2},
  [5742] = {.lex_state = 149, .external_lex_state = 2},
  [5743] = {.lex_state = 149, .external_lex_state = 2},
  [5744] = {.lex_state = 149, .external_lex_state = 2},
  [5745] = {.lex_state = 149, .external_lex_state = 2},
  [5746] = {.lex_state = 149, .external_lex_state = 2},
  [5747] = {.lex_state = 149, .external_lex_state = 2},
  [5748] = {.lex_state = 149, .external_lex_state = 2},
  [5749] = {.lex_state = 149, .external_lex_state = 2},
  [5750] = {.lex_state = 149, .external_lex_state = 2},
  [5751] = {.lex_state = 149, .external_lex_state = 2},
  [5752] = {.lex_state = 149, .external_lex_state = 2},
  [5753] = {.lex_state = 149, .external_lex_state = 2},
  [5754] = {.lex_state = 149, .external_lex_state = 2},
  [5755] = {.lex_state = 149, .external_lex_state = 2},
  [5756] = {.lex_state = 149, .external_lex_state = 2},
  [5757] = {.lex_state = 149, .external_lex_state = 2},
  [5758] = {.lex_state = 149, .external_lex_state = 2},
  [5759] = {.lex_state = 149, .external_lex_state = 2},
  [5760] = {.lex_state = 149, .external_lex_state = 2},
  [5761] = {.lex_state = 149, .external_lex_state = 2},
  [5762] = {.lex_state = 149, .external_lex_state = 2},
  [5763] = {.lex_state = 149, .external_lex_state = 2},
  [5764] = {.lex_state = 2, .external_lex_state = 11},
  [5765] = {.lex_state = 149, .external_lex_state = 2},
  [5766] = {.lex_state = 149, .external_lex_state = 2},
  [5767] = {.lex_state = 149, .external_lex_state = 2},
  [5768] = {.lex_state = 149, .external_lex_state = 2},
  [5769] = {.lex_state = 149, .external_lex_state = 2},
  [5770] = {.lex_state = 149, .external_lex_state = 2},
  [5771] = {.lex_state = 149, .external_lex_state = 2},
  [5772] = {.lex_state = 38, .external_lex_state = 2},
  [5773] = {.lex_state = 149, .external_lex_state = 2},
  [5774] = {.lex_state = 149, .external_lex_state = 2},
  [5775] = {.lex_state = 149, .external_lex_state = 2},
  [5776] = {.lex_state = 149, .external_lex_state = 2},
  [5777] = {.lex_state = 149, .external_lex_state = 2},
  [5778] = {.lex_state = 149, .external_lex_state = 2},
  [5779] = {.lex_state = 149, .external_lex_state = 2},
  [5780] = {.lex_state = 149, .external_lex_state = 2},
  [5781] = {.lex_state = 149, .external_lex_state = 2},
  [5782] = {.lex_state = 149, .external_lex_state = 2},
  [5783] = {.lex_state = 149, .external_lex_state = 2},
  [5784] = {.lex_state = 149, .external_lex_state = 2},
  [5785] = {.lex_state = 149, .external_lex_state = 2},
  [5786] = {.lex_state = 149, .external_lex_state = 2},
  [5787] = {.lex_state = 149, .external_lex_state = 2},
  [5788] = {.lex_state = 149, .external_lex_state = 2},
  [5789] = {.lex_state = 2, .external_lex_state = 11},
  [5790] = {.lex_state = 149, .external_lex_state = 2},
  [5791] = {.lex_state = 149, .external_lex_state = 2},
  [5792] = {.lex_state = 149, .external_lex_state = 2},
  [5793] = {.lex_state = 149, .external_lex_state = 2},
  [5794] = {.lex_state = 149, .external_lex_state = 2},
  [5795] = {.lex_state = 149, .external_lex_state = 2},
  [5796] = {.lex_state = 149, .external_lex_state = 2},
  [5797] = {.lex_state = 149, .external_lex_state = 2},
  [5798] = {.lex_state = 149, .external_lex_state = 2},
  [5799] = {.lex_state = 149, .external_lex_state = 2},
  [5800] = {.lex_state = 149, .external_lex_state = 2},
  [5801] = {.lex_state = 149, .external_lex_state = 2},
  [5802] = {.lex_state = 149, .external_lex_state = 2},
  [5803] = {.lex_state = 149, .external_lex_state = 2},
  [5804] = {.lex_state = 149, .external_lex_state = 2},
  [5805] = {.lex_state = 149, .external_lex_state = 2},
  [5806] = {.lex_state = 149, .external_lex_state = 2},
  [5807] = {.lex_state = 149, .external_lex_state = 2},
  [5808] = {.lex_state = 149, .external_lex_state = 2},
  [5809] = {.lex_state = 149, .external_lex_state = 2},
  [5810] = {.lex_state = 149, .external_lex_state = 2},
  [5811] = {.lex_state = 149, .external_lex_state = 2},
  [5812] = {.lex_state = 149, .external_lex_state = 2},
  [5813] = {.lex_state = 149, .external_lex_state = 2},
  [5814] = {.lex_state = 149, .external_lex_state = 2},
  [5815] = {.lex_state = 149, .external_lex_state = 2},
  [5816] = {.lex_state = 149, .external_lex_state = 2},
  [5817] = {.lex_state = 149, .external_lex_state = 2},
  [5818] = {.lex_state = 149, .external_lex_state = 2},
  [5819] = {.lex_state = 149, .external_lex_state = 2},
  [5820] = {.lex_state = 149, .external_lex_state = 2},
  [5821] = {.lex_state = 149, .external_lex_state = 2},
  [5822] = {.lex_state = 149, .external_lex_state = 2},
  [5823] = {.lex_state = 149, .external_lex_state = 2},
  [5824] = {.lex_state = 149, .external_lex_state = 2},
  [5825] = {.lex_state = 149, .external_lex_state = 2},
  [5826] = {.lex_state = 149, .external_lex_state = 2},
  [5827] = {.lex_state = 149, .external_lex_state = 2},
  [5828] = {.lex_state = 149, .external_lex_state = 2},
  [5829] = {.lex_state = 149, .external_lex_state = 2},
  [5830] = {.lex_state = 149, .external_lex_state = 2},
  [5831] = {.lex_state = 149, .external_lex_state = 2},
  [5832] = {.lex_state = 149, .external_lex_state = 2},
  [5833] = {.lex_state = 149, .external_lex_state = 2},
  [5834] = {.lex_state = 149, .external_lex_state = 2},
  [5835] = {.lex_state = 149, .external_lex_state = 2},
  [5836] = {.lex_state = 149, .external_lex_state = 2},
  [5837] = {.lex_state = 149, .external_lex_state = 2},
  [5838] = {.lex_state = 149, .external_lex_state = 2},
  [5839] = {.lex_state = 149, .external_lex_state = 2},
  [5840] = {.lex_state = 149, .external_lex_state = 2},
  [5841] = {.lex_state = 149, .external_lex_state = 2},
  [5842] = {.lex_state = 149, .external_lex_state = 2},
  [5843] = {.lex_state = 149, .external_lex_state = 2},
  [5844] = {.lex_state = 149, .external_lex_state = 2},
  [5845] = {.lex_state = 149, .external_lex_state = 2},
  [5846] = {.lex_state = 149, .external_lex_state = 2},
  [5847] = {.lex_state = 149, .external_lex_state = 2},
  [5848] = {.lex_state = 149, .external_lex_state = 2},
  [5849] = {.lex_state = 149, .external_lex_state = 2},
  [5850] = {.lex_state = 149, .external_lex_state = 2},
  [5851] = {.lex_state = 149, .external_lex_state = 2},
  [5852] = {.lex_state = 149, .external_lex_state = 2},
  [5853] = {.lex_state = 149, .external_lex_state = 2},
  [5854] = {.lex_state = 149, .external_lex_state = 2},
  [5855] = {.lex_state = 149, .external_lex_state = 2},
  [5856] = {.lex_state = 149, .external_lex_state = 2},
  [5857] = {.lex_state = 149, .external_lex_state = 2},
  [5858] = {.lex_state = 149, .external_lex_state = 2},
  [5859] = {.lex_state = 149, .external_lex_state = 2},
  [5860] = {.lex_state = 2, .external_lex_state = 11},
  [5861] = {.lex_state = 149, .external_lex_state = 2},
  [5862] = {.lex_state = 149, .external_lex_state = 2},
  [5863] = {.lex_state = 149, .external_lex_state = 2},
  [5864] = {.lex_state = 149, .external_lex_state = 2},
  [5865] = {.lex_state = 149, .external_lex_state = 2},
  [5866] = {.lex_state = 149, .external_lex_state = 2},
  [5867] = {.lex_state = 149, .external_lex_state = 2},
  [5868] = {.lex_state = 149, .external_lex_state = 2},
  [5869] = {.lex_state = 149, .external_lex_state = 2},
  [5870] = {.lex_state = 149, .external_lex_state = 2},
  [5871] = {.lex_state = 149, .external_lex_state = 2},
  [5872] = {.lex_state = 149, .external_lex_state = 2},
  [5873] = {.lex_state = 149, .external_lex_state = 2},
  [5874] = {.lex_state = 149, .external_lex_state = 2},
  [5875] = {.lex_state = 149, .external_lex_state = 2},
  [5876] = {.lex_state = 149, .external_lex_state = 2},
  [5877] = {.lex_state = 149, .external_lex_state = 2},
  [5878] = {.lex_state = 149, .external_lex_state = 2},
  [5879] = {.lex_state = 149, .external_lex_state = 2},
  [5880] = {.lex_state = 149, .external_lex_state = 2},
  [5881] = {.lex_state = 149, .external_lex_state = 2},
  [5882] = {.lex_state = 149, .external_lex_state = 2},
  [5883] = {.lex_state = 149, .external_lex_state = 2},
  [5884] = {.lex_state = 149, .external_lex_state = 2},
  [5885] = {.lex_state = 149, .external_lex_state = 2},
  [5886] = {.lex_state = 149, .external_lex_state = 2},
  [5887] = {.lex_state = 149, .external_lex_state = 2},
  [5888] = {.lex_state = 149, .external_lex_state = 2},
  [5889] = {.lex_state = 149, .external_lex_state = 2},
  [5890] = {.lex_state = 149, .external_lex_state = 2},
  [5891] = {.lex_state = 149, .external_lex_state = 2},
  [5892] = {.lex_state = 149, .external_lex_state = 2},
  [5893] = {.lex_state = 149, .external_lex_state = 2},
  [5894] = {.lex_state = 149, .external_lex_state = 2},
  [5895] = {.lex_state = 149, .external_lex_state = 2},
  [5896] = {.lex_state = 149, .external_lex_state = 2},
  [5897] = {.lex_state = 149, .external_lex_state = 2},
  [5898] = {.lex_state = 149, .external_lex_state = 2},
  [5899] = {.lex_state = 149, .external_lex_state = 2},
  [5900] = {.lex_state = 149, .external_lex_state = 2},
  [5901] = {.lex_state = 149, .external_lex_state = 2},
  [5902] = {.lex_state = 149, .external_lex_state = 2},
  [5903] = {.lex_state = 149, .external_lex_state = 2},
  [5904] = {.lex_state = 149, .external_lex_state = 2},
  [5905] = {.lex_state = 149, .external_lex_state = 2},
  [5906] = {.lex_state = 149, .external_lex_state = 2},
  [5907] = {.lex_state = 149, .external_lex_state = 2},
  [5908] = {.lex_state = 149, .external_lex_state = 2},
  [5909] = {.lex_state = 149, .external_lex_state = 2},
  [5910] = {.lex_state = 149, .external_lex_state = 2},
  [5911] = {.lex_state = 149, .external_lex_state = 2},
  [5912] = {.lex_state = 38, .external_lex_state = 2},
  [5913] = {.lex_state = 149, .external_lex_state = 2},
  [5914] = {.lex_state = 149, .external_lex_state = 2},
  [5915] = {.lex_state = 149, .external_lex_state = 2},
  [5916] = {.lex_state = 149, .external_lex_state = 2},
  [5917] = {.lex_state = 149, .external_lex_state = 2},
  [5918] = {.lex_state = 149, .external_lex_state = 2},
  [5919] = {.lex_state = 149, .external_lex_state = 2},
  [5920] = {.lex_state = 149, .external_lex_state = 2},
  [5921] = {.lex_state = 149, .external_lex_state = 2},
  [5922] = {.lex_state = 149, .external_lex_state = 2},
  [5923] = {.lex_state = 149, .external_lex_state = 2},
  [5924] = {.lex_state = 149, .external_lex_state = 2},
  [5925] = {.lex_state = 149, .external_lex_state = 2},
  [5926] = {.lex_state = 149, .external_lex_state = 2},
  [5927] = {.lex_state = 149, .external_lex_state = 2},
  [5928] = {.lex_state = 149, .external_lex_state = 2},
  [5929] = {.lex_state = 149, .external_lex_state = 2},
  [5930] = {.lex_state = 149, .external_lex_state = 2},
  [5931] = {.lex_state = 149, .external_lex_state = 2},
  [5932] = {.lex_state = 149, .external_lex_state = 2},
  [5933] = {.lex_state = 149, .external_lex_state = 2},
  [5934] = {.lex_state = 149, .external_lex_state = 2},
  [5935] = {.lex_state = 149, .external_lex_state = 2},
  [5936] = {.lex_state = 149, .external_lex_state = 2},
  [5937] = {.lex_state = 149, .external_lex_state = 2},
  [5938] = {.lex_state = 149, .external_lex_state = 2},
  [5939] = {.lex_state = 149, .external_lex_state = 2},
  [5940] = {.lex_state = 149, .external_lex_state = 2},
  [5941] = {.lex_state = 149, .external_lex_state = 2},
  [5942] = {.lex_state = 149, .external_lex_state = 2},
  [5943] = {.lex_state = 149, .external_lex_state = 2},
  [5944] = {.lex_state = 149, .external_lex_state = 2},
  [5945] = {.lex_state = 149, .external_lex_state = 2},
  [5946] = {.lex_state = 149, .external_lex_state = 2},
  [5947] = {.lex_state = 149, .external_lex_state = 2},
  [5948] = {.lex_state = 149, .external_lex_state = 2},
  [5949] = {.lex_state = 149, .external_lex_state = 2},
  [5950] = {.lex_state = 149, .external_lex_state = 2},
  [5951] = {.lex_state = 149, .external_lex_state = 2},
  [5952] = {.lex_state = 149, .external_lex_state = 2},
  [5953] = {.lex_state = 149, .external_lex_state = 2},
  [5954] = {.lex_state = 149, .external_lex_state = 2},
  [5955] = {.lex_state = 149, .external_lex_state = 2},
  [5956] = {.lex_state = 149, .external_lex_state = 2},
  [5957] = {.lex_state = 149, .external_lex_state = 2},
  [5958] = {.lex_state = 149, .external_lex_state = 2},
  [5959] = {.lex_state = 149, .external_lex_state = 2},
  [5960] = {.lex_state = 149, .external_lex_state = 2},
  [5961] = {.lex_state = 149, .external_lex_state = 2},
  [5962] = {.lex_state = 149, .external_lex_state = 2},
  [5963] = {.lex_state = 149, .external_lex_state = 2},
  [5964] = {.lex_state = 149, .external_lex_state = 2},
  [5965] = {.lex_state = 149, .external_lex_state = 2},
  [5966] = {.lex_state = 149, .external_lex_state = 2},
  [5967] = {.lex_state = 149, .external_lex_state = 2},
  [5968] = {.lex_state = 149, .external_lex_state = 2},
  [5969] = {.lex_state = 149, .external_lex_state = 2},
  [5970] = {.lex_state = 149, .external_lex_state = 2},
  [5971] = {.lex_state = 149, .external_lex_state = 2},
  [5972] = {.lex_state = 149, .external_lex_state = 2},
  [5973] = {.lex_state = 2, .external_lex_state = 11},
  [5974] = {.lex_state = 38, .external_lex_state = 2},
  [5975] = {.lex_state = 149, .external_lex_state = 2},
  [5976] = {.lex_state = 149, .external_lex_state = 2},
  [5977] = {.lex_state = 149, .external_lex_state = 2},
  [5978] = {.lex_state = 149, .external_lex_state = 2},
  [5979] = {.lex_state = 149, .external_lex_state = 2},
  [5980] = {.lex_state = 149, .external_lex_state = 2},
  [5981] = {.lex_state = 149, .external_lex_state = 2},
  [5982] = {.lex_state = 149, .external_lex_state = 2},
  [5983] = {.lex_state = 149, .external_lex_state = 2},
  [5984] = {.lex_state = 149, .external_lex_state = 2},
  [5985] = {.lex_state = 149, .external_lex_state = 2},
  [5986] = {.lex_state = 149, .external_lex_state = 2},
  [5987] = {.lex_state = 149, .external_lex_state = 2},
  [5988] = {.lex_state = 149, .external_lex_state = 2},
  [5989] = {.lex_state = 149, .external_lex_state = 2},
  [5990] = {.lex_state = 149, .external_lex_state = 2},
  [5991] = {.lex_state = 149, .external_lex_state = 2},
  [5992] = {.lex_state = 149, .external_lex_state = 2},
  [5993] = {.lex_state = 149, .external_lex_state = 2},
  [5994] = {.lex_state = 149, .external_lex_state = 2},
  [5995] = {.lex_state = 149, .external_lex_state = 2},
  [5996] = {.lex_state = 149, .external_lex_state = 2},
  [5997] = {.lex_state = 149, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_glimmer_opening_tag] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_accessor] = ACTIONS(1),
    [anon_sym_satisfies] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_PLUS_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(5783),
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_import] = STATE(3552),
    [sym_parenthesized_expression] = STATE(1200),
    [sym_expression] = STATE(2596),
    [sym_primary_expression] = STATE(1486),
    [sym_yield_expression] = STATE(1640),
    [sym_object] = STATE(1614),
    [sym_object_pattern] = STATE(3643),
    [sym_array] = STATE(1614),
    [sym_array_pattern] = STATE(3643),
    [sym_glimmer_template] = STATE(1640),
    [sym_jsx_element] = STATE(1640),
    [sym_jsx_opening_element] = STATE(3196),
    [sym_nested_identifier] = STATE(5937),
    [sym_jsx_self_closing_element] = STATE(1640),
    [sym_class] = STATE(1614),
    [sym_function_expression] = STATE(1614),
    [sym_generator_function] = STATE(1614),
    [sym_arrow_function] = STATE(1614),
    [sym__call_signature] = STATE(5856),
    [sym_call_expression] = STATE(1614),
    [sym_new_expression] = STATE(1576),
    [sym_await_expression] = STATE(1640),
    [sym_member_expression] = STATE(1279),
    [sym_subscript_expression] = STATE(1279),
    [sym_assignment_expression] = STATE(1640),
    [sym__augmented_assignment_lhs] = STATE(2957),
    [sym_augmented_assignment_expression] = STATE(1640),
    [sym__destructuring_pattern] = STATE(3643),
    [sym_ternary_expression] = STATE(1640),
    [sym_binary_expression] = STATE(1640),
    [sym_unary_expression] = STATE(1640),
    [sym_update_expression] = STATE(1640),
    [sym_string] = STATE(2237),
    [sym_template_string] = STATE(1614),
    [sym_regex] = STATE(1614),
    [sym_meta_property] = STATE(1614),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(4033),
    [sym_pattern] = STATE(4147),
    [sym_rest_pattern] = STATE(3606),
    [sym_non_null_expression] = STATE(1279),
    [sym_as_expression] = STATE(1640),
    [sym_satisfies_expression] = STATE(1640),
    [sym_instantiation_expression] = STATE(1640),
    [sym_internal_module] = STATE(1640),
    [sym_nested_type_identifier] = STATE(2884),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2898),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2901),
    [sym_type] = STATE(3053),
    [sym_constructor_type] = STATE(2919),
    [sym_primary_type] = STATE(2921),
    [sym_template_literal_type] = STATE(2988),
    [sym_infer_type] = STATE(2919),
    [sym_conditional_type] = STATE(2988),
    [sym_generic_type] = STATE(2988),
    [sym_type_query] = STATE(2988),
    [sym_index_type_query] = STATE(2988),
    [sym_lookup_type] = STATE(2988),
    [sym_literal_type] = STATE(2988),
    [sym__number] = STATE(2922),
    [sym_existential_type] = STATE(2988),
    [sym_flow_maybe_type] = STATE(2988),
    [sym_parenthesized_type] = STATE(2988),
    [sym_predefined_type] = STATE(2988),
    [sym_object_type] = STATE(2988),
    [sym_type_parameters] = STATE(5407),
    [sym_array_type] = STATE(2988),
    [sym_tuple_type] = STATE(2988),
    [sym_readonly_type] = STATE(2919),
    [sym_union_type] = STATE(2988),
    [sym_intersection_type] = STATE(2988),
    [sym_function_type] = STATE(2919),
    [aux_sym_export_statement_repeat1] = STATE(4582),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_type] = ACTIONS(115),
    [anon_sym_EQ] = ACTIONS(119),
    [anon_sym_as] = ACTIONS(122),
    [anon_sym_namespace] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(128),
    [anon_sym_typeof] = ACTIONS(130),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(115),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(136),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_RPAREN] = ACTIONS(128),
    [anon_sym_await] = ACTIONS(141),
    [anon_sym_in] = ACTIONS(122),
    [anon_sym_COLON] = ACTIONS(128),
    [anon_sym_yield] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(145),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(122),
    [anon_sym_DOT] = ACTIONS(122),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ_GT] = ACTIONS(159),
    [anon_sym_QMARK_DOT] = ACTIONS(161),
    [anon_sym_new] = ACTIONS(163),
    [anon_sym_using] = ACTIONS(165),
    [anon_sym_PLUS_EQ] = ACTIONS(167),
    [anon_sym_DASH_EQ] = ACTIONS(167),
    [anon_sym_STAR_EQ] = ACTIONS(167),
    [anon_sym_SLASH_EQ] = ACTIONS(167),
    [anon_sym_PERCENT_EQ] = ACTIONS(167),
    [anon_sym_CARET_EQ] = ACTIONS(167),
    [anon_sym_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_LT_LT_EQ] = ACTIONS(167),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(167),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(167),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(167),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(122),
    [anon_sym_PIPE_PIPE] = ACTIONS(122),
    [anon_sym_GT_GT] = ACTIONS(122),
    [anon_sym_GT_GT_GT] = ACTIONS(122),
    [anon_sym_LT_LT] = ACTIONS(122),
    [anon_sym_AMP] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(122),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_SLASH] = ACTIONS(177),
    [anon_sym_PERCENT] = ACTIONS(122),
    [anon_sym_STAR_STAR] = ACTIONS(122),
    [anon_sym_LT] = ACTIONS(180),
    [anon_sym_LT_EQ] = ACTIONS(161),
    [anon_sym_EQ_EQ] = ACTIONS(122),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(161),
    [anon_sym_BANG_EQ] = ACTIONS(122),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(161),
    [anon_sym_GT_EQ] = ACTIONS(161),
    [anon_sym_QMARK_QMARK] = ACTIONS(122),
    [anon_sym_instanceof] = ACTIONS(122),
    [anon_sym_TILDE] = ACTIONS(182),
    [anon_sym_void] = ACTIONS(184),
    [anon_sym_delete] = ACTIONS(186),
    [anon_sym_PLUS_PLUS] = ACTIONS(188),
    [anon_sym_DASH_DASH] = ACTIONS(188),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(191),
    [sym_number] = ACTIONS(193),
    [sym_private_property_identifier] = ACTIONS(195),
    [sym_this] = ACTIONS(197),
    [sym_super] = ACTIONS(199),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_undefined] = ACTIONS(203),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_readonly] = ACTIONS(205),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_declare] = ACTIONS(115),
    [anon_sym_public] = ACTIONS(115),
    [anon_sym_private] = ACTIONS(115),
    [anon_sym_protected] = ACTIONS(115),
    [anon_sym_override] = ACTIONS(115),
    [anon_sym_module] = ACTIONS(115),
    [anon_sym_any] = ACTIONS(209),
    [anon_sym_number] = ACTIONS(209),
    [anon_sym_boolean] = ACTIONS(209),
    [anon_sym_string] = ACTIONS(209),
    [anon_sym_symbol] = ACTIONS(209),
    [anon_sym_object] = ACTIONS(209),
    [anon_sym_abstract] = ACTIONS(211),
    [anon_sym_satisfies] = ACTIONS(122),
    [anon_sym_infer] = ACTIONS(213),
    [anon_sym_keyof] = ACTIONS(215),
    [anon_sym_unique] = ACTIONS(217),
    [anon_sym_unknown] = ACTIONS(219),
    [anon_sym_never] = ACTIONS(219),
    [anon_sym_LBRACE_PIPE] = ACTIONS(221),
    [sym__ternary_qmark] = ACTIONS(161),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_import] = STATE(3552),
    [sym_parenthesized_expression] = STATE(1200),
    [sym_expression] = STATE(2596),
    [sym_primary_expression] = STATE(1486),
    [sym_yield_expression] = STATE(1640),
    [sym_object] = STATE(1614),
    [sym_object_pattern] = STATE(3643),
    [sym_array] = STATE(1614),
    [sym_array_pattern] = STATE(3643),
    [sym_glimmer_template] = STATE(1640),
    [sym_jsx_element] = STATE(1640),
    [sym_jsx_opening_element] = STATE(3196),
    [sym_nested_identifier] = STATE(5937),
    [sym_jsx_self_closing_element] = STATE(1640),
    [sym_class] = STATE(1614),
    [sym_function_expression] = STATE(1614),
    [sym_generator_function] = STATE(1614),
    [sym_arrow_function] = STATE(1614),
    [sym__call_signature] = STATE(5856),
    [sym_call_expression] = STATE(1614),
    [sym_new_expression] = STATE(1576),
    [sym_await_expression] = STATE(1640),
    [sym_member_expression] = STATE(1279),
    [sym_subscript_expression] = STATE(1279),
    [sym_assignment_expression] = STATE(1640),
    [sym__augmented_assignment_lhs] = STATE(2957),
    [sym_augmented_assignment_expression] = STATE(1640),
    [sym__destructuring_pattern] = STATE(3643),
    [sym_ternary_expression] = STATE(1640),
    [sym_binary_expression] = STATE(1640),
    [sym_unary_expression] = STATE(1640),
    [sym_update_expression] = STATE(1640),
    [sym_string] = STATE(2237),
    [sym_template_string] = STATE(1614),
    [sym_regex] = STATE(1614),
    [sym_meta_property] = STATE(1614),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(4033),
    [sym_pattern] = STATE(4147),
    [sym_rest_pattern] = STATE(3606),
    [sym_non_null_expression] = STATE(1279),
    [sym_as_expression] = STATE(1640),
    [sym_satisfies_expression] = STATE(1640),
    [sym_instantiation_expression] = STATE(1640),
    [sym_internal_module] = STATE(1640),
    [sym_nested_type_identifier] = STATE(2884),
    [sym__type_query_member_expression_in_type_annotation] = STATE(2898),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2901),
    [sym_type] = STATE(3053),
    [sym_constructor_type] = STATE(2919),
    [sym_primary_type] = STATE(2921),
    [sym_template_literal_type] = STATE(2988),
    [sym_infer_type] = STATE(2919),
    [sym_conditional_type] = STATE(2988),
    [sym_generic_type] = STATE(2988),
    [sym_type_query] = STATE(2988),
    [sym_index_type_query] = STATE(2988),
    [sym_lookup_type] = STATE(2988),
    [sym_literal_type] = STATE(2988),
    [sym__number] = STATE(2922),
    [sym_existential_type] = STATE(2988),
    [sym_flow_maybe_type] = STATE(2988),
    [sym_parenthesized_type] = STATE(2988),
    [sym_predefined_type] = STATE(2988),
    [sym_object_type] = STATE(2988),
    [sym_type_parameters] = STATE(5407),
    [sym_array_type] = STATE(2988),
    [sym_tuple_type] = STATE(2988),
    [sym_readonly_type] = STATE(2919),
    [sym_union_type] = STATE(2988),
    [sym_intersection_type] = STATE(2988),
    [sym_function_type] = STATE(2919),
    [aux_sym_export_statement_repeat1] = STATE(4582),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(117),
    [anon_sym_type] = ACTIONS(115),
    [anon_sym_EQ] = ACTIONS(223),
    [anon_sym_as] = ACTIONS(122),
    [anon_sym_namespace] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(126),
    [anon_sym_COMMA] = ACTIONS(226),
    [anon_sym_typeof] = ACTIONS(130),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(115),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(136),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_RPAREN] = ACTIONS(226),
    [anon_sym_await] = ACTIONS(141),
    [anon_sym_in] = ACTIONS(122),
    [anon_sym_COLON] = ACTIONS(226),
    [anon_sym_yield] = ACTIONS(143),
    [anon_sym_LBRACK] = ACTIONS(145),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_GT] = ACTIONS(122),
    [anon_sym_DOT] = ACTIONS(122),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_EQ_GT] = ACTIONS(229),
    [anon_sym_QMARK_DOT] = ACTIONS(161),
    [anon_sym_new] = ACTIONS(163),
    [anon_sym_using] = ACTIONS(165),
    [anon_sym_PLUS_EQ] = ACTIONS(167),
    [anon_sym_DASH_EQ] = ACTIONS(167),
    [anon_sym_STAR_EQ] = ACTIONS(167),
    [anon_sym_SLASH_EQ] = ACTIONS(167),
    [anon_sym_PERCENT_EQ] = ACTIONS(167),
    [anon_sym_CARET_EQ] = ACTIONS(167),
    [anon_sym_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(167),
    [anon_sym_LT_LT_EQ] = ACTIONS(167),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(167),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(167),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(167),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(167),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(122),
    [anon_sym_PIPE_PIPE] = ACTIONS(122),
    [anon_sym_GT_GT] = ACTIONS(122),
    [anon_sym_GT_GT_GT] = ACTIONS(122),
    [anon_sym_LT_LT] = ACTIONS(122),
    [anon_sym_AMP] = ACTIONS(171),
    [anon_sym_CARET] = ACTIONS(122),
    [anon_sym_PIPE] = ACTIONS(173),
    [anon_sym_PLUS] = ACTIONS(175),
    [anon_sym_DASH] = ACTIONS(175),
    [anon_sym_SLASH] = ACTIONS(177),
    [anon_sym_PERCENT] = ACTIONS(122),
    [anon_sym_STAR_STAR] = ACTIONS(122),
    [anon_sym_LT] = ACTIONS(180),
    [anon_sym_LT_EQ] = ACTIONS(161),
    [anon_sym_EQ_EQ] = ACTIONS(122),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(161),
    [anon_sym_BANG_EQ] = ACTIONS(122),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(161),
    [anon_sym_GT_EQ] = ACTIONS(161),
    [anon_sym_QMARK_QMARK] = ACTIONS(122),
    [anon_sym_instanceof] = ACTIONS(122),
    [anon_sym_TILDE] = ACTIONS(182),
    [anon_sym_void] = ACTIONS(184),
    [anon_sym_delete] = ACTIONS(186),
    [anon_sym_PLUS_PLUS] = ACTIONS(188),
    [anon_sym_DASH_DASH] = ACTIONS(188),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(191),
    [sym_number] = ACTIONS(193),
    [sym_private_property_identifier] = ACTIONS(195),
    [sym_this] = ACTIONS(197),
    [sym_super] = ACTIONS(199),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_undefined] = ACTIONS(203),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(115),
    [anon_sym_readonly] = ACTIONS(205),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_declare] = ACTIONS(115),
    [anon_sym_public] = ACTIONS(115),
    [anon_sym_private] = ACTIONS(115),
    [anon_sym_protected] = ACTIONS(115),
    [anon_sym_override] = ACTIONS(115),
    [anon_sym_module] = ACTIONS(115),
    [anon_sym_any] = ACTIONS(209),
    [anon_sym_number] = ACTIONS(209),
    [anon_sym_boolean] = ACTIONS(209),
    [anon_sym_string] = ACTIONS(209),
    [anon_sym_symbol] = ACTIONS(209),
    [anon_sym_object] = ACTIONS(209),
    [anon_sym_abstract] = ACTIONS(211),
    [anon_sym_satisfies] = ACTIONS(122),
    [anon_sym_infer] = ACTIONS(213),
    [anon_sym_keyof] = ACTIONS(215),
    [anon_sym_unique] = ACTIONS(217),
    [anon_sym_unknown] = ACTIONS(219),
    [anon_sym_never] = ACTIONS(219),
    [anon_sym_LBRACE_PIPE] = ACTIONS(221),
    [sym__ternary_qmark] = ACTIONS(161),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5874),
    [sym_object_assignment_pattern] = STATE(4986),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5874),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5874),
    [sym_spread_element] = STATE(5019),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2225),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_rest_pattern] = STATE(4986),
    [sym_method_definition] = STATE(5019),
    [sym_pair] = STATE(5019),
    [sym_pair_pattern] = STATE(4986),
    [sym__property_name] = STATE(3559),
    [sym_computed_property_name] = STATE(3559),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_accessibility_modifier] = STATE(2724),
    [sym_override_modifier] = STATE(2755),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [aux_sym_object_repeat1] = STATE(5031),
    [aux_sym_object_pattern_repeat1] = STATE(5037),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_export] = ACTIONS(233),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_type] = ACTIONS(237),
    [anon_sym_namespace] = ACTIONS(239),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(245),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(247),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(249),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(251),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(255),
    [sym_private_property_identifier] = ACTIONS(257),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(259),
    [anon_sym_readonly] = ACTIONS(261),
    [anon_sym_get] = ACTIONS(263),
    [anon_sym_set] = ACTIONS(263),
    [anon_sym_declare] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_override] = ACTIONS(269),
    [anon_sym_module] = ACTIONS(271),
    [anon_sym_any] = ACTIONS(273),
    [anon_sym_number] = ACTIONS(273),
    [anon_sym_boolean] = ACTIONS(273),
    [anon_sym_string] = ACTIONS(273),
    [anon_sym_symbol] = ACTIONS(273),
    [anon_sym_object] = ACTIONS(273),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5874),
    [sym_object_assignment_pattern] = STATE(4986),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5874),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5874),
    [sym_spread_element] = STATE(4829),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2225),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_rest_pattern] = STATE(4986),
    [sym_method_definition] = STATE(4829),
    [sym_pair] = STATE(4829),
    [sym_pair_pattern] = STATE(4986),
    [sym__property_name] = STATE(3559),
    [sym_computed_property_name] = STATE(3559),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_accessibility_modifier] = STATE(2724),
    [sym_override_modifier] = STATE(2755),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [aux_sym_object_repeat1] = STATE(4830),
    [aux_sym_object_pattern_repeat1] = STATE(5037),
    [sym_identifier] = ACTIONS(275),
    [anon_sym_export] = ACTIONS(277),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_type] = ACTIONS(279),
    [anon_sym_namespace] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(285),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(247),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(287),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(289),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(255),
    [sym_private_property_identifier] = ACTIONS(257),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(291),
    [anon_sym_readonly] = ACTIONS(293),
    [anon_sym_get] = ACTIONS(295),
    [anon_sym_set] = ACTIONS(295),
    [anon_sym_declare] = ACTIONS(297),
    [anon_sym_public] = ACTIONS(299),
    [anon_sym_private] = ACTIONS(299),
    [anon_sym_protected] = ACTIONS(299),
    [anon_sym_override] = ACTIONS(301),
    [anon_sym_module] = ACTIONS(303),
    [anon_sym_any] = ACTIONS(305),
    [anon_sym_number] = ACTIONS(305),
    [anon_sym_boolean] = ACTIONS(305),
    [anon_sym_string] = ACTIONS(305),
    [anon_sym_symbol] = ACTIONS(305),
    [anon_sym_object] = ACTIONS(305),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5874),
    [sym_object_assignment_pattern] = STATE(4986),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5874),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5874),
    [sym_spread_element] = STATE(5019),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2225),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_rest_pattern] = STATE(4986),
    [sym_method_definition] = STATE(5019),
    [sym_pair] = STATE(5019),
    [sym_pair_pattern] = STATE(4986),
    [sym__property_name] = STATE(3559),
    [sym_computed_property_name] = STATE(3559),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_accessibility_modifier] = STATE(2724),
    [sym_override_modifier] = STATE(2755),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [aux_sym_object_repeat1] = STATE(5031),
    [aux_sym_object_pattern_repeat1] = STATE(5037),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_export] = ACTIONS(233),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_type] = ACTIONS(237),
    [anon_sym_namespace] = ACTIONS(239),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(307),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(245),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(247),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(249),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(251),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(255),
    [sym_private_property_identifier] = ACTIONS(257),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(259),
    [anon_sym_readonly] = ACTIONS(261),
    [anon_sym_get] = ACTIONS(263),
    [anon_sym_set] = ACTIONS(263),
    [anon_sym_declare] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_override] = ACTIONS(269),
    [anon_sym_module] = ACTIONS(271),
    [anon_sym_any] = ACTIONS(273),
    [anon_sym_number] = ACTIONS(273),
    [anon_sym_boolean] = ACTIONS(273),
    [anon_sym_string] = ACTIONS(273),
    [anon_sym_symbol] = ACTIONS(273),
    [anon_sym_object] = ACTIONS(273),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5874),
    [sym_object_assignment_pattern] = STATE(4986),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5874),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5874),
    [sym_spread_element] = STATE(5019),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2225),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_rest_pattern] = STATE(4986),
    [sym_method_definition] = STATE(5019),
    [sym_pair] = STATE(5019),
    [sym_pair_pattern] = STATE(4986),
    [sym__property_name] = STATE(3559),
    [sym_computed_property_name] = STATE(3559),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_accessibility_modifier] = STATE(2724),
    [sym_override_modifier] = STATE(2755),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [aux_sym_object_repeat1] = STATE(5031),
    [aux_sym_object_pattern_repeat1] = STATE(5037),
    [sym_identifier] = ACTIONS(231),
    [anon_sym_export] = ACTIONS(233),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_type] = ACTIONS(237),
    [anon_sym_namespace] = ACTIONS(239),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(245),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(247),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(249),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(251),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(255),
    [sym_private_property_identifier] = ACTIONS(257),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(259),
    [anon_sym_readonly] = ACTIONS(261),
    [anon_sym_get] = ACTIONS(263),
    [anon_sym_set] = ACTIONS(263),
    [anon_sym_declare] = ACTIONS(265),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_private] = ACTIONS(267),
    [anon_sym_protected] = ACTIONS(267),
    [anon_sym_override] = ACTIONS(269),
    [anon_sym_module] = ACTIONS(271),
    [anon_sym_any] = ACTIONS(273),
    [anon_sym_number] = ACTIONS(273),
    [anon_sym_boolean] = ACTIONS(273),
    [anon_sym_string] = ACTIONS(273),
    [anon_sym_symbol] = ACTIONS(273),
    [anon_sym_object] = ACTIONS(273),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5874),
    [sym_object_assignment_pattern] = STATE(4986),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5874),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5874),
    [sym_spread_element] = STATE(4829),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2225),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_rest_pattern] = STATE(4986),
    [sym_method_definition] = STATE(4829),
    [sym_pair] = STATE(4829),
    [sym_pair_pattern] = STATE(4986),
    [sym__property_name] = STATE(3559),
    [sym_computed_property_name] = STATE(3559),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_accessibility_modifier] = STATE(2724),
    [sym_override_modifier] = STATE(2755),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [aux_sym_object_repeat1] = STATE(4830),
    [aux_sym_object_pattern_repeat1] = STATE(5037),
    [sym_identifier] = ACTIONS(311),
    [anon_sym_export] = ACTIONS(313),
    [anon_sym_STAR] = ACTIONS(235),
    [anon_sym_type] = ACTIONS(315),
    [anon_sym_namespace] = ACTIONS(317),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_COMMA] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(319),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(247),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(321),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(323),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(255),
    [sym_private_property_identifier] = ACTIONS(257),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(325),
    [anon_sym_readonly] = ACTIONS(327),
    [anon_sym_get] = ACTIONS(329),
    [anon_sym_set] = ACTIONS(329),
    [anon_sym_declare] = ACTIONS(331),
    [anon_sym_public] = ACTIONS(333),
    [anon_sym_private] = ACTIONS(333),
    [anon_sym_protected] = ACTIONS(333),
    [anon_sym_override] = ACTIONS(335),
    [anon_sym_module] = ACTIONS(337),
    [anon_sym_any] = ACTIONS(339),
    [anon_sym_number] = ACTIONS(339),
    [anon_sym_boolean] = ACTIONS(339),
    [anon_sym_string] = ACTIONS(339),
    [anon_sym_symbol] = ACTIONS(339),
    [anon_sym_object] = ACTIONS(339),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [ts_builtin_sym_end] = ACTIONS(341),
    [sym_identifier] = ACTIONS(343),
    [anon_sym_export] = ACTIONS(346),
    [anon_sym_default] = ACTIONS(349),
    [anon_sym_type] = ACTIONS(351),
    [anon_sym_namespace] = ACTIONS(354),
    [anon_sym_LBRACE] = ACTIONS(357),
    [anon_sym_RBRACE] = ACTIONS(341),
    [anon_sym_typeof] = ACTIONS(360),
    [anon_sym_import] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(366),
    [anon_sym_var] = ACTIONS(369),
    [anon_sym_let] = ACTIONS(372),
    [anon_sym_const] = ACTIONS(375),
    [anon_sym_BANG] = ACTIONS(378),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_switch] = ACTIONS(384),
    [anon_sym_for] = ACTIONS(387),
    [anon_sym_LPAREN] = ACTIONS(390),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_await] = ACTIONS(396),
    [anon_sym_while] = ACTIONS(399),
    [anon_sym_do] = ACTIONS(402),
    [anon_sym_try] = ACTIONS(405),
    [anon_sym_break] = ACTIONS(408),
    [anon_sym_continue] = ACTIONS(411),
    [anon_sym_debugger] = ACTIONS(414),
    [anon_sym_return] = ACTIONS(417),
    [anon_sym_throw] = ACTIONS(420),
    [anon_sym_case] = ACTIONS(349),
    [anon_sym_yield] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(426),
    [sym_glimmer_opening_tag] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(432),
    [anon_sym_SQUOTE] = ACTIONS(435),
    [anon_sym_class] = ACTIONS(438),
    [anon_sym_async] = ACTIONS(441),
    [anon_sym_function] = ACTIONS(444),
    [anon_sym_new] = ACTIONS(447),
    [anon_sym_using] = ACTIONS(450),
    [anon_sym_PLUS] = ACTIONS(360),
    [anon_sym_DASH] = ACTIONS(360),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_LT] = ACTIONS(456),
    [anon_sym_TILDE] = ACTIONS(378),
    [anon_sym_void] = ACTIONS(360),
    [anon_sym_delete] = ACTIONS(360),
    [anon_sym_PLUS_PLUS] = ACTIONS(459),
    [anon_sym_DASH_DASH] = ACTIONS(459),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(462),
    [sym_number] = ACTIONS(465),
    [sym_private_property_identifier] = ACTIONS(468),
    [sym_this] = ACTIONS(471),
    [sym_super] = ACTIONS(471),
    [sym_true] = ACTIONS(471),
    [sym_false] = ACTIONS(471),
    [sym_null] = ACTIONS(471),
    [sym_undefined] = ACTIONS(474),
    [anon_sym_AT] = ACTIONS(477),
    [anon_sym_static] = ACTIONS(480),
    [anon_sym_readonly] = ACTIONS(480),
    [anon_sym_get] = ACTIONS(480),
    [anon_sym_set] = ACTIONS(480),
    [anon_sym_declare] = ACTIONS(483),
    [anon_sym_public] = ACTIONS(480),
    [anon_sym_private] = ACTIONS(480),
    [anon_sym_protected] = ACTIONS(480),
    [anon_sym_override] = ACTIONS(480),
    [anon_sym_module] = ACTIONS(486),
    [anon_sym_any] = ACTIONS(480),
    [anon_sym_number] = ACTIONS(480),
    [anon_sym_boolean] = ACTIONS(480),
    [anon_sym_string] = ACTIONS(480),
    [anon_sym_symbol] = ACTIONS(480),
    [anon_sym_object] = ACTIONS(480),
    [anon_sym_abstract] = ACTIONS(489),
    [anon_sym_interface] = ACTIONS(492),
    [anon_sym_enum] = ACTIONS(495),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(13),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(498),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(498),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(12),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(502),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(504),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(502),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(506),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(506),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(514),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [ts_builtin_sym_end] = ACTIONS(516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [ts_builtin_sym_end] = ACTIONS(518),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(520),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [ts_builtin_sym_end] = ACTIONS(518),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(522),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(524),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(22),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(526),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(528),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(25),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(536),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(538),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(30),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(30),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(540),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(27),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(27),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(871),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(5187),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3873),
    [sym_identifier] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_type] = ACTIONS(584),
    [anon_sym_namespace] = ACTIONS(586),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(588),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(590),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(594),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(596),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(598),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(602),
    [anon_sym_readonly] = ACTIONS(602),
    [anon_sym_get] = ACTIONS(602),
    [anon_sym_set] = ACTIONS(602),
    [anon_sym_declare] = ACTIONS(604),
    [anon_sym_public] = ACTIONS(602),
    [anon_sym_private] = ACTIONS(602),
    [anon_sym_protected] = ACTIONS(602),
    [anon_sym_override] = ACTIONS(602),
    [anon_sym_module] = ACTIONS(606),
    [anon_sym_any] = ACTIONS(602),
    [anon_sym_number] = ACTIONS(602),
    [anon_sym_boolean] = ACTIONS(602),
    [anon_sym_string] = ACTIONS(602),
    [anon_sym_symbol] = ACTIONS(602),
    [anon_sym_object] = ACTIONS(602),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(805),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(767),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(842),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(856),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(891),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(899),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(782),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(791),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(793),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(794),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(800),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(781),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(801),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3782),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_type] = ACTIONS(15),
    [anon_sym_namespace] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(25),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(29),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(73),
    [anon_sym_async] = ACTIONS(75),
    [anon_sym_function] = ACTIONS(77),
    [anon_sym_new] = ACTIONS(79),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(101),
    [anon_sym_readonly] = ACTIONS(101),
    [anon_sym_get] = ACTIONS(101),
    [anon_sym_set] = ACTIONS(101),
    [anon_sym_declare] = ACTIONS(103),
    [anon_sym_public] = ACTIONS(101),
    [anon_sym_private] = ACTIONS(101),
    [anon_sym_protected] = ACTIONS(101),
    [anon_sym_override] = ACTIONS(101),
    [anon_sym_module] = ACTIONS(105),
    [anon_sym_any] = ACTIONS(101),
    [anon_sym_number] = ACTIONS(101),
    [anon_sym_boolean] = ACTIONS(101),
    [anon_sym_string] = ACTIONS(101),
    [anon_sym_symbol] = ACTIONS(101),
    [anon_sym_object] = ACTIONS(101),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(801),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(805),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(4760),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3873),
    [sym_identifier] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(582),
    [anon_sym_type] = ACTIONS(584),
    [anon_sym_namespace] = ACTIONS(586),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(588),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(590),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(592),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(594),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(596),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(598),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(602),
    [anon_sym_readonly] = ACTIONS(602),
    [anon_sym_get] = ACTIONS(602),
    [anon_sym_set] = ACTIONS(602),
    [anon_sym_declare] = ACTIONS(604),
    [anon_sym_public] = ACTIONS(602),
    [anon_sym_private] = ACTIONS(602),
    [anon_sym_protected] = ACTIONS(602),
    [anon_sym_override] = ACTIONS(602),
    [anon_sym_module] = ACTIONS(606),
    [anon_sym_any] = ACTIONS(602),
    [anon_sym_number] = ACTIONS(602),
    [anon_sym_boolean] = ACTIONS(602),
    [anon_sym_string] = ACTIONS(602),
    [anon_sym_symbol] = ACTIONS(602),
    [anon_sym_object] = ACTIONS(602),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(856),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(781),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(804),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_import] = STATE(3753),
    [sym_parenthesized_expression] = STATE(1271),
    [sym_expression] = STATE(2129),
    [sym_primary_expression] = STATE(1486),
    [sym_yield_expression] = STATE(1640),
    [sym_object] = STATE(1614),
    [sym_object_pattern] = STATE(3740),
    [sym_assignment_pattern] = STATE(5171),
    [sym_array] = STATE(1614),
    [sym_array_pattern] = STATE(3740),
    [sym_glimmer_template] = STATE(1640),
    [sym_jsx_element] = STATE(1640),
    [sym_jsx_opening_element] = STATE(3196),
    [sym_nested_identifier] = STATE(5937),
    [sym_jsx_self_closing_element] = STATE(1640),
    [sym_class] = STATE(1614),
    [sym_function_expression] = STATE(1614),
    [sym_generator_function] = STATE(1614),
    [sym_arrow_function] = STATE(1614),
    [sym__call_signature] = STATE(5891),
    [sym_call_expression] = STATE(1614),
    [sym_new_expression] = STATE(1576),
    [sym_await_expression] = STATE(1640),
    [sym_member_expression] = STATE(1261),
    [sym_subscript_expression] = STATE(1261),
    [sym_assignment_expression] = STATE(1640),
    [sym__augmented_assignment_lhs] = STATE(2925),
    [sym_augmented_assignment_expression] = STATE(1640),
    [sym__destructuring_pattern] = STATE(3740),
    [sym_spread_element] = STATE(4897),
    [sym_ternary_expression] = STATE(1640),
    [sym_binary_expression] = STATE(1640),
    [sym_unary_expression] = STATE(1640),
    [sym_update_expression] = STATE(1640),
    [sym_string] = STATE(2237),
    [sym_template_string] = STATE(1614),
    [sym_regex] = STATE(1614),
    [sym_meta_property] = STATE(1614),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(4390),
    [sym_pattern] = STATE(4569),
    [sym_rest_pattern] = STATE(4105),
    [sym_non_null_expression] = STATE(1261),
    [sym_as_expression] = STATE(1640),
    [sym_satisfies_expression] = STATE(1640),
    [sym_instantiation_expression] = STATE(1640),
    [sym_internal_module] = STATE(1640),
    [sym_nested_type_identifier] = STATE(2884),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3275),
    [sym__type_query_call_expression_in_type_annotation] = STATE(2901),
    [sym_type] = STATE(3817),
    [sym_tuple_parameter] = STATE(5205),
    [sym_optional_tuple_parameter] = STATE(5205),
    [sym_optional_type] = STATE(5205),
    [sym_rest_type] = STATE(5205),
    [sym__tuple_type_member] = STATE(5205),
    [sym_constructor_type] = STATE(2919),
    [sym_primary_type] = STATE(2921),
    [sym_template_literal_type] = STATE(2988),
    [sym_infer_type] = STATE(2919),
    [sym_conditional_type] = STATE(2988),
    [sym_generic_type] = STATE(2988),
    [sym_type_query] = STATE(2988),
    [sym_index_type_query] = STATE(2988),
    [sym_lookup_type] = STATE(2988),
    [sym_literal_type] = STATE(2988),
    [sym__number] = STATE(2922),
    [sym_existential_type] = STATE(2988),
    [sym_flow_maybe_type] = STATE(2988),
    [sym_parenthesized_type] = STATE(2988),
    [sym_predefined_type] = STATE(2988),
    [sym_object_type] = STATE(2988),
    [sym_type_parameters] = STATE(5561),
    [sym_array_type] = STATE(2988),
    [sym_tuple_type] = STATE(2988),
    [sym_readonly_type] = STATE(2919),
    [sym_union_type] = STATE(2988),
    [sym_intersection_type] = STATE(2988),
    [sym_function_type] = STATE(2919),
    [aux_sym_export_statement_repeat1] = STATE(4582),
    [aux_sym_array_repeat1] = STATE(4906),
    [aux_sym_array_pattern_repeat1] = STATE(5199),
    [sym_identifier] = ACTIONS(608),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_type] = ACTIONS(610),
    [anon_sym_namespace] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(616),
    [anon_sym_COMMA] = ACTIONS(618),
    [anon_sym_typeof] = ACTIONS(620),
    [anon_sym_import] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(610),
    [anon_sym_const] = ACTIONS(134),
    [anon_sym_BANG] = ACTIONS(622),
    [anon_sym_LPAREN] = ACTIONS(139),
    [anon_sym_await] = ACTIONS(624),
    [anon_sym_yield] = ACTIONS(626),
    [anon_sym_LBRACK] = ACTIONS(628),
    [anon_sym_RBRACK] = ACTIONS(630),
    [sym_glimmer_opening_tag] = ACTIONS(147),
    [anon_sym_DQUOTE] = ACTIONS(149),
    [anon_sym_SQUOTE] = ACTIONS(151),
    [anon_sym_class] = ACTIONS(153),
    [anon_sym_async] = ACTIONS(632),
    [anon_sym_function] = ACTIONS(157),
    [anon_sym_new] = ACTIONS(634),
    [anon_sym_using] = ACTIONS(636),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(638),
    [anon_sym_AMP] = ACTIONS(640),
    [anon_sym_PIPE] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(644),
    [anon_sym_DASH] = ACTIONS(644),
    [anon_sym_SLASH] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(180),
    [anon_sym_TILDE] = ACTIONS(622),
    [anon_sym_void] = ACTIONS(648),
    [anon_sym_delete] = ACTIONS(650),
    [anon_sym_PLUS_PLUS] = ACTIONS(652),
    [anon_sym_DASH_DASH] = ACTIONS(652),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(191),
    [sym_number] = ACTIONS(193),
    [sym_private_property_identifier] = ACTIONS(654),
    [sym_this] = ACTIONS(656),
    [sym_super] = ACTIONS(199),
    [sym_true] = ACTIONS(201),
    [sym_false] = ACTIONS(201),
    [sym_null] = ACTIONS(201),
    [sym_undefined] = ACTIONS(658),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_readonly] = ACTIONS(660),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [anon_sym_QMARK] = ACTIONS(662),
    [anon_sym_declare] = ACTIONS(610),
    [anon_sym_public] = ACTIONS(610),
    [anon_sym_private] = ACTIONS(610),
    [anon_sym_protected] = ACTIONS(610),
    [anon_sym_override] = ACTIONS(610),
    [anon_sym_module] = ACTIONS(610),
    [anon_sym_any] = ACTIONS(664),
    [anon_sym_number] = ACTIONS(664),
    [anon_sym_boolean] = ACTIONS(664),
    [anon_sym_string] = ACTIONS(664),
    [anon_sym_symbol] = ACTIONS(664),
    [anon_sym_object] = ACTIONS(664),
    [anon_sym_abstract] = ACTIONS(666),
    [anon_sym_infer] = ACTIONS(668),
    [anon_sym_keyof] = ACTIONS(670),
    [anon_sym_unique] = ACTIONS(217),
    [anon_sym_unknown] = ACTIONS(219),
    [anon_sym_never] = ACTIONS(219),
    [anon_sym_LBRACE_PIPE] = ACTIONS(221),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(842),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(891),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACTIONS(91),
    [sym_private_property_identifier] = ACTIONS(93),
    [sym_this] = ACTIONS(95),
    [sym_super] = ACTIONS(95),
    [sym_true] = ACTIONS(95),
    [sym_false] = ACTIONS(95),
    [sym_null] = ACTIONS(95),
    [sym_undefined] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(99),
    [anon_sym_static] = ACTIONS(574),
    [anon_sym_readonly] = ACTIONS(574),
    [anon_sym_get] = ACTIONS(574),
    [anon_sym_set] = ACTIONS(574),
    [anon_sym_declare] = ACTIONS(576),
    [anon_sym_public] = ACTIONS(574),
    [anon_sym_private] = ACTIONS(574),
    [anon_sym_protected] = ACTIONS(574),
    [anon_sym_override] = ACTIONS(574),
    [anon_sym_module] = ACTIONS(578),
    [anon_sym_any] = ACTIONS(574),
    [anon_sym_number] = ACTIONS(574),
    [anon_sym_boolean] = ACTIONS(574),
    [anon_sym_string] = ACTIONS(574),
    [anon_sym_symbol] = ACTIONS(574),
    [anon_sym_object] = ACTIONS(574),
    [anon_sym_abstract] = ACTIONS(107),
    [anon_sym_interface] = ACTIONS(109),
    [anon_sym_enum] = ACTIONS(111),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(892),
    [sym_declaration] = STATE(892),
    [sym_import] = STATE(3760),
    [sym_import_statement] = STATE(892),
    [sym_statement] = STATE(899),
    [sym_expression_statement] = STATE(892),
    [sym_variable_declaration] = STATE(789),
    [sym_lexical_declaration] = STATE(789),
    [sym_statement_block] = STATE(892),
    [sym_if_statement] = STATE(892),
    [sym_switch_statement] = STATE(892),
    [sym_for_statement] = STATE(892),
    [sym_for_in_statement] = STATE(892),
    [sym_while_statement] = STATE(892),
    [sym_do_statement] = STATE(892),
    [sym_try_statement] = STATE(892),
    [sym_with_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_debugger_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_throw_statement] = STATE(892),
    [sym_empty_statement] = STATE(892),
    [sym_labeled_statement] = STATE(892),
    [sym_parenthesized_expression] = STATE(1336),
    [sym_expression] = STATE(1930),
    [sym_primary_expression] = STATE(1801),
    [sym_yield_expression] = STATE(2062),
    [sym_object] = STATE(2080),
    [sym_object_pattern] = STATE(5605),
    [sym_array] = STATE(2080),
    [sym_array_pattern] = STATE(5605),
    [sym_glimmer_template] = STATE(2062),
    [sym_jsx_element] = STATE(2062),
    [sym_jsx_opening_element] = STATE(3197),
    [sym_jsx_self_closing_element] = STATE(2062),
    [sym_class] = STATE(2080),
    [sym_class_declaration] = STATE(789),
    [sym_function_expression] = STATE(2080),
    [sym_function_declaration] = STATE(789),
    [sym_generator_function] = STATE(2080),
    [sym_generator_function_declaration] = STATE(789),
    [sym_arrow_function] = STATE(2080),
    [sym__call_signature] = STATE(5818),
    [sym_call_expression] = STATE(2080),
    [sym_new_expression] = STATE(1939),
    [sym_await_expression] = STATE(2062),
    [sym_member_expression] = STATE(1336),
    [sym_subscript_expression] = STATE(1336),
    [sym_assignment_expression] = STATE(2062),
    [sym__augmented_assignment_lhs] = STATE(2949),
    [sym_augmented_assignment_expression] = STATE(2062),
    [sym__destructuring_pattern] = STATE(5605),
    [sym_ternary_expression] = STATE(2062),
    [sym_binary_expression] = STATE(2062),
    [sym_unary_expression] = STATE(2062),
    [sym_update_expression] = STATE(2062),
    [sym_sequence_expression] = STATE(5311),
    [sym_string] = STATE(2080),
    [sym_template_string] = STATE(2080),
    [sym_regex] = STATE(2080),
    [sym_meta_property] = STATE(2080),
    [sym_decorator] = STATE(1267),
    [sym_formal_parameters] = STATE(3849),
    [sym_non_null_expression] = STATE(1336),
    [sym_function_signature] = STATE(789),
    [sym_as_expression] = STATE(2062),
    [sym_satisfies_expression] = STATE(2062),
    [sym_instantiation_expression] = STATE(2062),
    [sym_ambient_declaration] = STATE(789),
    [sym_abstract_class_declaration] = STATE(789),
    [sym_module] = STATE(789),
    [sym_internal_module] = STATE(2377),
    [sym_import_alias] = STATE(789),
    [sym_interface_declaration] = STATE(789),
    [sym_enum_declaration] = STATE(789),
    [sym_type_alias_declaration] = STATE(789),
    [sym_type_parameters] = STATE(5338),
    [aux_sym_export_statement_repeat1] = STATE(3822),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(548),
    [anon_sym_type] = ACTIONS(550),
    [anon_sym_namespace] = ACTIONS(552),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(27),
    [anon_sym_let] = ACTIONS(558),
    [anon_sym_const] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(560),
    [anon_sym_switch] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(562),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_await] = ACTIONS(45),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(49),
    [anon_sym_try] = ACTIONS(51),
    [anon_sym_break] = ACTIONS(53),
    [anon_sym_continue] = ACTIONS(55),
    [anon_sym_debugger] = ACTIONS(57),
    [anon_sym_return] = ACTIONS(59),
    [anon_sym_throw] = ACTIONS(61),
    [anon_sym_yield] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [sym_glimmer_opening_tag] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_SQUOTE] = ACTIONS(71),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_using] = ACTIONS(81),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_LT] = ACTIONS(85),
    [anon_sym_TILDE] = ACTIONS(33),
    [anon_sym_void] = ACTIONS(21),
    [anon_sym_delete] = ACTIONS(21),
    [anon_sym_PLUS_PLUS] = ACTIONS(87),
    [anon_sym_DASH_DASH] = ACTIONS(87),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [sym_number] = ACT