package resourcemover

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DependencyType enumerates the values for dependency type.
type DependencyType string

const (
	// RequiredForMove ...
	RequiredForMove DependencyType = "RequiredForMove"
	// RequiredForPrepare ...
	RequiredForPrepare DependencyType = "RequiredForPrepare"
)

// PossibleDependencyTypeValues returns an array of possible values for the DependencyType const type.
func PossibleDependencyTypeValues() []DependencyType {
	return []DependencyType{RequiredForMove, RequiredForPrepare}
}

// JobName enumerates the values for job name.
type JobName string

const (
	// InitialSync ...
	InitialSync JobName = "InitialSync"
)

// PossibleJobNameValues returns an array of possible values for the JobName const type.
func PossibleJobNameValues() []JobName {
	return []JobName{InitialSync}
}

// MoveResourceInputType enumerates the values for move resource input type.
type MoveResourceInputType string

const (
	// MoveResourceID ...
	MoveResourceID MoveResourceInputType = "MoveResourceId"
	// MoveResourceSourceID ...
	MoveResourceSourceID MoveResourceInputType = "MoveResourceSourceId"
)

// PossibleMoveResourceInputTypeValues returns an array of possible values for the MoveResourceInputType const type.
func PossibleMoveResourceInputTypeValues() []MoveResourceInputType {
	return []MoveResourceInputType{MoveResourceID, MoveResourceSourceID}
}

// MoveState enumerates the values for move state.
type MoveState string

const (
	// AssignmentPending ...
	AssignmentPending MoveState = "AssignmentPending"
	// CommitFailed ...
	CommitFailed MoveState = "CommitFailed"
	// CommitInProgress ...
	CommitInProgress MoveState = "CommitInProgress"
	// CommitPending ...
	CommitPending MoveState = "CommitPending"
	// Committed ...
	Committed MoveState = "Committed"
	// DiscardFailed ...
	DiscardFailed MoveState = "DiscardFailed"
	// DiscardInProgress ...
	DiscardInProgress MoveState = "DiscardInProgress"
	// MoveFailed ...
	MoveFailed MoveState = "MoveFailed"
	// MoveInProgress ...
	MoveInProgress MoveState = "MoveInProgress"
	// MovePending ...
	MovePending MoveState = "MovePending"
	// PrepareFailed ...
	PrepareFailed MoveState = "PrepareFailed"
	// PrepareInProgress ...
	PrepareInProgress MoveState = "PrepareInProgress"
	// PreparePending ...
	PreparePending MoveState = "PreparePending"
)

// PossibleMoveStateValues returns an array of possible values for the MoveState const type.
func PossibleMoveStateValues() []MoveState {
	return []MoveState{AssignmentPending, CommitFailed, CommitInProgress, CommitPending, Committed, DiscardFailed, DiscardInProgress, MoveFailed, MoveInProgress, MovePending, PrepareFailed, PrepareInProgress, PreparePending}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Failed, Succeeded, Updating}
}

// ResolutionType enumerates the values for resolution type.
type ResolutionType string

const (
	// Automatic ...
	Automatic ResolutionType = "Automatic"
	// Manual ...
	Manual ResolutionType = "Manual"
)

// PossibleResolutionTypeValues returns an array of possible values for the ResolutionType const type.
func PossibleResolutionTypeValues() []ResolutionType {
	return []ResolutionType{Automatic, Manual}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// None ...
	None ResourceIdentityType = "None"
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
	// UserAssigned ...
	UserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{None, SystemAssigned, UserAssigned}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// ResourceTypeMicrosoftComputeavailabilitySets ...
	ResourceTypeMicrosoftComputeavailabilitySets ResourceType = "Microsoft.Compute/availabilitySets"
	// ResourceTypeMicrosoftComputevirtualMachines ...
	ResourceTypeMicrosoftComputevirtualMachines ResourceType = "Microsoft.Compute/virtualMachines"
	// ResourceTypeMicrosoftNetworkloadBalancers ...
	ResourceTypeMicrosoftNetworkloadBalancers ResourceType = "Microsoft.Network/loadBalancers"
	// ResourceTypeMicrosoftNetworknetworkInterfaces ...
	ResourceTypeMicrosoftNetworknetworkInterfaces ResourceType = "Microsoft.Network/networkInterfaces"
	// ResourceTypeMicrosoftNetworknetworkSecurityGroups ...
	ResourceTypeMicrosoftNetworknetworkSecurityGroups ResourceType = "Microsoft.Network/networkSecurityGroups"
	// ResourceTypeMicrosoftNetworkpublicIPAddresses ...
	ResourceTypeMicrosoftNetworkpublicIPAddresses ResourceType = "Microsoft.Network/publicIPAddresses"
	// ResourceTypeMicrosoftNetworkvirtualNetworks ...
	ResourceTypeMicrosoftNetworkvirtualNetworks ResourceType = "Microsoft.Network/virtualNetworks"
	// ResourceTypeMicrosoftSqlservers ...
	ResourceTypeMicrosoftSqlservers ResourceType = "Microsoft.Sql/servers"
	// ResourceTypeMicrosoftSqlserversdatabases ...
	ResourceTypeMicrosoftSqlserversdatabases ResourceType = "Microsoft.Sql/servers/databases"
	// ResourceTypeMicrosoftSqlserverselasticPools ...
	ResourceTypeMicrosoftSqlserverselasticPools ResourceType = "Microsoft.Sql/servers/elasticPools"
	// ResourceTypeResourceGroups ...
	ResourceTypeResourceGroups ResourceType = "resourceGroups"
	// ResourceTypeResourceSettings ...
	ResourceTypeResourceSettings ResourceType = "ResourceSettings"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{ResourceTypeMicrosoftComputeavailabilitySets, ResourceTypeMicrosoftComputevirtualMachines, ResourceTypeMicrosoftNetworkloadBalancers, ResourceTypeMicrosoftNetworknetworkInterfaces, ResourceTypeMicrosoftNetworknetworkSecurityGroups, ResourceTypeMicrosoftNetworkpublicIPAddresses, ResourceTypeMicrosoftNetworkvirtualNetworks, ResourceTypeMicrosoftSqlservers, ResourceTypeMicrosoftSqlserversdatabases, ResourceTypeMicrosoftSqlserverselasticPools, ResourceTypeResourceGroups, ResourceTypeResourceSettings}
}

// TargetAvailabilityZone enumerates the values for target availability zone.
type TargetAvailabilityZone string

const (
	// NA ...
	NA TargetAvailabilityZone = "NA"
	// One ...
	One TargetAvailabilityZone = "1"
	// Three ...
	Three TargetAvailabilityZone = "3"
	// Two ...
	Two TargetAvailabilityZone = "2"
)

// PossibleTargetAvailabilityZoneValues returns an array of possible values for the TargetAvailabilityZone const type.
func PossibleTargetAvailabilityZoneValues() []TargetAvailabilityZone {
	return []TargetAvailabilityZone{NA, One, Three, Two}
}

// ZoneRedundant enumerates the values for zone redundant.
type ZoneRedundant string

const (
	// Disable ...
	Disable ZoneRedundant = "Disable"
	// Enable ...
	Enable ZoneRedundant = "Enable"
)

// PossibleZoneRedundantValues returns an array of possible values for the ZoneRedundant const type.
func PossibleZoneRedundantValues() []ZoneRedundant {
	return []ZoneRedundant{Disable, Enable}
}
