use crate::dsl::{Feature::*, Inst, Location::*};
use crate::dsl::{align, fmt, inst, r, rex, rw, sxl, sxq};

#[rustfmt::skip] // Keeps instructions on a single line.
pub fn list() -> Vec<Inst> {
    vec![
        inst("subb", fmt("I", [rw(al), r(imm8)]), rex(0x2C).ib(), _64b | compat),
        inst("subw", fmt("I", [rw(ax), r(imm16)]), rex([0x66, 0x2D]).iw(), _64b | compat),
        inst("subl", fmt("I", [rw(eax), r(imm32)]), rex(0x2D).id(), _64b | compat),
        inst("subq", fmt("I_SXL", [rw(rax), sxq(imm32)]), rex(0x2D).w().id(), _64b),
        inst("subb", fmt("MI", [rw(rm8), r(imm8)]), rex(0x80).digit(5).ib(), _64b | compat),
        inst("subw", fmt("MI", [rw(rm16), r(imm16)]), rex([0x66, 0x81]).digit(5).iw(), _64b | compat),
        inst("subl", fmt("MI", [rw(rm32), r(imm32)]), rex(0x81).digit(5).id(), _64b | compat),
        inst("subq", fmt("MI_SXL", [rw(rm64), sxq(imm32)]), rex(0x81).w().digit(5).id(), _64b),
        inst("subl", fmt("MI_SXB", [rw(rm32), sxl(imm8)]), rex(0x83).digit(5).ib(), _64b | compat),
        inst("subq", fmt("MI_SXB", [rw(rm64), sxq(imm8)]), rex(0x83).w().digit(5).ib(), _64b),
        inst("subb", fmt("MR", [rw(rm8), r(r8)]), rex(0x28).r(), _64b | compat),
        inst("subw", fmt("MR", [rw(rm16), r(r16)]), rex([0x66, 0x29]).r(), _64b | compat),
        inst("subl", fmt("MR", [rw(rm32), r(r32)]), rex(0x29).r(), _64b | compat),
        inst("subq", fmt("MR", [rw(rm64), r(r64)]), rex(0x29).w().r(), _64b),
        inst("subb", fmt("RM", [rw(r8), r(rm8)]), rex(0x2A).r(), _64b | compat),
        inst("subw", fmt("RM", [rw(r16), r(rm16)]), rex([0x66, 0x2B]).r(), _64b | compat),
        inst("subl", fmt("RM", [rw(r32), r(rm32)]), rex(0x2B).r(), _64b | compat),
        inst("subq", fmt("RM", [rw(r64), r(rm64)]), rex(0x2B).w().r(), _64b),
        // Subtract with borrow.
        inst("sbbb", fmt("I", [rw(al), r(imm8)]), rex(0x1C).ib(), _64b | compat),
        inst("sbbw", fmt("I", [rw(ax), r(imm16)]), rex([0x66, 0x1D]).iw(), _64b | compat),
        inst("sbbl", fmt("I", [rw(eax), r(imm32)]), rex(0x1D).id(), _64b | compat),
        inst("sbbq", fmt("I_SXL", [rw(rax), sxq(imm32)]), rex(0x1D).w().id(), _64b),
        inst("sbbb", fmt("MI", [rw(rm8), r(imm8)]), rex(0x80).digit(3).ib(), _64b | compat),
        inst("sbbw", fmt("MI", [rw(rm16), r(imm16)]), rex([0x66, 0x81]).digit(3).iw(), _64b | compat),
        inst("sbbl", fmt("MI", [rw(rm32), r(imm32)]), rex(0x81).digit(3).id(), _64b | compat),
        inst("sbbq", fmt("MI_SXL", [rw(rm64), sxq(imm32)]), rex(0x81).w().digit(3).id(), _64b),
        inst("sbbl", fmt("MI_SXB", [rw(rm32), sxl(imm8)]), rex(0x83).digit(3).ib(), _64b | compat),
        inst("sbbq", fmt("MI_SXB", [rw(rm64), sxq(imm8)]), rex(0x83).w().digit(3).ib(), _64b),
        inst("sbbb", fmt("MR", [rw(rm8), r(r8)]), rex(0x18).r(), _64b | compat),
        inst("sbbw", fmt("MR", [rw(rm16), r(r16)]), rex([0x66, 0x19]).r(), _64b | compat),
        inst("sbbl", fmt("MR", [rw(rm32), r(r32)]), rex(0x19).r(), _64b | compat),
        inst("sbbq", fmt("MR", [rw(rm64), r(r64)]), rex(0x19).w().r(), _64b),
        inst("sbbb", fmt("RM", [rw(r8), r(rm8)]), rex(0x1A).r(), _64b | compat),
        inst("sbbw", fmt("RM", [rw(r16), r(rm16)]), rex([0x66, 0x1B]).r(), _64b | compat),
        inst("sbbl", fmt("RM", [rw(r32), r(rm32)]), rex(0x1B).r(), _64b | compat),
        inst("sbbq", fmt("RM", [rw(r64), r(rm64)]), rex(0x1B).w().r(), _64b),
        // `LOCK`-prefixed memory-writing instructions.
        inst("lock_subb", fmt("MI", [rw(m8), r(imm8)]), rex([0xf0, 0x80]).digit(5).ib(), _64b | compat),
        inst("lock_subw", fmt("MI", [rw(m16), r(imm16)]), rex([0xf0, 0x66, 0x81]).digit(5).iw(), _64b | compat),
        inst("lock_subl", fmt("MI", [rw(m32), r(imm32)]), rex([0xf0, 0x81]).digit(5).id(), _64b | compat),
        inst("lock_subq", fmt("MI_SXL", [rw(m64), sxq(imm32)]), rex([0xf0, 0x81]).w().digit(5).id(), _64b),
        inst("lock_subl", fmt("MI_SXB", [rw(m32), sxl(imm8)]), rex([0xf0, 0x83]).digit(5).ib(), _64b | compat),
        inst("lock_subq", fmt("MI_SXB", [rw(m64), sxq(imm8)]), rex([0xf0, 0x83]).w().digit(5).ib(), _64b),
        inst("lock_subb", fmt("MR", [rw(m8), r(r8)]), rex([0xf0, 0x28]).r(), _64b | compat),
        inst("lock_subw", fmt("MR", [rw(m16), r(r16)]), rex([0xf0, 0x66, 0x29]).r(), _64b | compat),
        inst("lock_subl", fmt("MR", [rw(m32), r(r32)]), rex([0xf0, 0x29]).r(), _64b | compat),
        inst("lock_subq", fmt("MR", [rw(m64), r(r64)]), rex([0xf0, 0x29]).w().r(), _64b),
        inst("lock_sbbb", fmt("MI", [rw(m8), r(imm8)]), rex([0xf0, 0x80]).digit(3).ib(), _64b | compat),
        inst("lock_sbbw", fmt("MI", [rw(m16), r(imm16)]), rex([0xf0, 0x66, 0x81]).digit(3).iw(), _64b | compat),
        inst("lock_sbbl", fmt("MI", [rw(m32), r(imm32)]), rex([0xf0, 0x81]).digit(3).id(), _64b | compat),
        inst("lock_sbbq", fmt("MI_SXL", [rw(m64), sxq(imm32)]), rex([0xf0, 0x81]).w().digit(3).id(), _64b),
        inst("lock_sbbl", fmt("MI_SXB", [rw(m32), sxl(imm8)]), rex([0xf0, 0x83]).digit(3).ib(), _64b | compat),
        inst("lock_sbbq", fmt("MI_SXB", [rw(m64), sxq(imm8)]), rex([0xf0, 0x83]).w().digit(3).ib(), _64b),
        inst("lock_sbbb", fmt("MR", [rw(m8), r(r8)]), rex([0xf0, 0x18]).r(), _64b | compat),
        inst("lock_sbbw", fmt("MR", [rw(m16), r(r16)]), rex([0xf0, 0x66, 0x19]).r(), _64b | compat),
        inst("lock_sbbl", fmt("MR", [rw(m32), r(r32)]), rex([0xf0, 0x19]).r(), _64b | compat),
        inst("lock_sbbq", fmt("MR", [rw(m64), r(r64)]), rex([0xf0, 0x19]).w().r(), _64b),
        // Vector instructions.
        inst("subss", fmt("A", [rw(xmm1), r(xmm_m32)]), rex([0xF3, 0x0F, 0x5C]).r(), _64b | compat | sse),
        inst("subsd", fmt("A", [rw(xmm1), r(xmm_m64)]), rex([0xF2, 0x0F, 0x5C]).r(), _64b | compat | sse2),
        inst("subps", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x0F, 0x5C]).r(), _64b | compat | sse),
        inst("subpd", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0x5C]).r(), _64b | compat | sse2),
        inst("psubb", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xF8]).r(), _64b | compat | sse2),
        inst("psubw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xF9]).r(), _64b | compat | sse2),
        inst("psubd", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xFA]).r(), _64b | compat | sse2),
        inst("psubq", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xFB]).r(), _64b | compat | sse2),
        inst("psubsb", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xE8]).r(), _64b | compat | sse2),
        inst("psubsw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xE9]).r(), _64b | compat | sse2),
        inst("psubusb", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xD8]).r(), _64b | compat | sse2),
        inst("psubusw", fmt("A", [rw(xmm1), r(align(xmm_m128))]), rex([0x66, 0x0F, 0xD9]).r(), _64b | compat | sse2),
    ]
}
