#!/usr/bin/tclsh
#
# This TCL script scans the opcodes.h file (which is itself generated by
# another TCL script) and uses the information gleaned to create the
# opcodes.c source file.
#
# Opcodes.c contains strings which are the symbolic names for the various
# opcodes used by the VDBE.  These strings are used when disassembling a
# VDBE program during tracing or as a result of the EXPLAIN keyword.
#
puts "/* Automatically generated.  Do not edit */"
puts "/* See the tool/mkopcodec.tcl script for details. */"
puts "#if !defined(SQLITE_OMIT_EXPLAIN) \\"
puts " || defined(VDBE_PROFILE) \\"
puts " || defined(SQLITE_DEBUG)"
puts "#if defined(SQLITE_ENABLE_EXPLAIN_COMMENTS) || defined(SQLITE_DEBUG)"
puts "# define OpHelp(X) \"\\0\" X"
puts "#else"
puts "# define OpHelp(X)"
puts "#endif"
puts "const char *sqlite3OpcodeName(int i)\173"
puts " static const char *const azName\[\] = \173"
set mx 0

set in [open [lindex $argv 0]]
fconfigure $in -translation binary
while {![eof $in]} {
  set line [gets $in]
  if {[regexp {^#define OP_} $line]} {
    set name [lindex $line 1]
    regsub {^OP_} $name {} name
    set i [lindex $line 2]
    set label($i) $name
    if {$mx<$i} {set mx $i}
    if {[regexp {synopsis: (.*) \*/} $line all x]} {
      set synopsis($i) [string trim $x]
    } else {
      set synopsis($i) {}
    }
  }
}
close $in

for {set i 0} {$i<=$mx} {incr i} {
  puts [format "    /* %3d */ %-18s OpHelp(\"%s\")," \
         $i \"$label($i)\" $synopsis($i)]
}
puts "  \175;"
puts "  return azName\[i\];"
puts "\175"
puts "#endif"
