## RabbitMQ 3.7.25

RabbitMQ `3.7.25` is a maintenance release. It focuses on bug fixes and usability
improvements.

This is **the last generally supported `3.7.x` release**.
RabbitMQ `3.7.x` series are now covered by the [limited extended support](https://www.rabbitmq.com/versions.html) policy.

Please consider [upgrading](https://www.rabbitmq.com/upgrade.html) to [RabbitMQ `3.8.x`](https://www.rabbitmq.com/changelog.html).

### Erlang/OTP Compatibility Notes

This release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Previously recent `3.7.x` nodes could start on Erlang 20.3 and to some extent tested on it despite
the Erlang `21.3+` requirements in release notes and documentation.

Starting with this release, `21.3+` is a **hard requirement** enforced in the code
to [ensure forward compatibility with Erlang 23](https://github.com/rabbitmq/rabbitmq-server/pull/2269).

Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.
[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * Erlang `20.3` and earlier version support has been completely removed after months of being documented as unsupported.
   This release, however, gains Erlang `23.0` forward compatibility.

   GitHub issue: [rabbitmq/rabbitmq-server#2269](https://github.com/rabbitmq/rabbitmq-server/pull/2269)


### Management Plugin

#### Enhancements

 * More frequent garbage collection by stats DB cache processes in environments where HTTP API queries produced
   large data sets.

   GitHub issue: [rabbitmq/rabbitmq-management#788](https://github.com/rabbitmq/rabbitmq-management/pull/788)

 * `rabbitmqadmin` binding deletion now defaults to the same property key value as binding creation.

   Contributed by Ivan Kaloyanov.

   GitHub issue: [rabbitmq/rabbitmq-management#779](https://github.com/rabbitmq/rabbitmq-management/pull/779)

#### Bug Fixes

 * `rabbitmqadmin import` mangled non-ASCII characters.

   GitHub issue: [rabbitmq/rabbitmq-management#785](https://github.com/rabbitmq/rabbitmq-management/issues/785)


### Federation Plugin

#### Enhancements

 * Internal resources cleanup is now more selective on abnormal link termination. A new upstream parameter, `resource-cleanup-mode`,
   can be set to `"never"` used to prevent internal queues from being deleted by exchange federation links on termination.
   Use this when data safety is more important than protection from resource leaks. It then will be up to the operator to make
   sure such resources are periodically deleted or use a suitable [TTL](https://www.rabbitmq.com/ttl.html).

   GitHub issue: [rabbitmq/rabbitmq-federation#105](https://github.com/rabbitmq/rabbitmq-federation/issues/105)


### Shovel Management Plugin

#### Bug Fixes

 * Shovels are now correctly removed even when deletion commands are executed against a different node
   (not the one on which the target Shovel has been created).

   GitHub issue: [rabbitmq/rabbitmq-shovel#68](https://github.com/rabbitmq/rabbitmq-shovel/issues/68)


### Trust Store Plugin

#### Enhancements

 * HTTPS certificate provider will no longer terminate if upstream service response contains
   invalid JSON.

   GitHub issue: [rabbitmq/rabbitmq-trust-store#73](https://github.com/rabbitmq/rabbitmq-trust-store/issues/73)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.25.tar.xz`.
