/**
 * rgbled.pde
 *
 * Copyright (c) 2011 Daniel Berenguer <dberenguer@usapiens.com>
 *
 * This file is part of the panStamp project.
 *
 * panStamp  is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * panStamp is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with panStamp; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 *
 * Author: Daniel Berenguer
 * Creation date: 06/22/2011
 */

#include "rgbled.h"

#ifdef USE_SOFT_PWM
# include "SoftPWM.h"
  SOFTPWM_DEFINE_CHANNEL( 0, DDRB, PORTB, PORTB1 );
  SOFTPWM_DEFINE_CHANNEL( 1, DDRD, PORTD, PORTD6 );
  SOFTPWM_DEFINE_CHANNEL( 2, DDRD, PORTD, PORTD5 );
# ifdef ENABLE_IR_SEND
  SOFTPWM_DEFINE_CHANNEL( 3, DDRB, PORTB, PORTB0 );
# else
  SOFTPWM_DEFINE_CHANNEL( 3, DDRD, PORTD, PORTD3 );
# endif
//  CSoftPWM< 4, 0 > SoftPWM;
//  ISR(TIMER1_COMPA_vect) { interrupts(); SoftPWM.update(); }

  SOFTPWM_DEFINE_OBJECT( 4 );
#endif

/**
 * Class constructor
 *
 * 'redPin'     Arduino pin connected to the red LED
 * 'greenPin'   Arduino pin connected to the green LED
 * 'bluePin'    Arduino pin connected to the blue LED
*/
RGBLED::RGBLED(int redPin, int greenPin, int bluePin, int whitePin)
{
  _timestamp = millis();

  for( byte i = 0; i < sizeof(levels); ++i )
    levels[i] = 0;

  pRed = redPin;
  pGreen = greenPin;
  pBlue = bluePin;
  pWhite = whitePin;

#ifdef USE_SOFT_PWM
#else
  pinMode(pRed, OUTPUT);
  pinMode(pGreen, OUTPUT);
  pinMode(pBlue, OUTPUT);
  if( pWhite != -1 )
    pinMode(pWhite, OUTPUT);
#endif
}
static
void isr() {
#ifdef USE_SOFT_PWM
  interrupts();
  SoftPWM.update();
//ISR(TIMER1_COMPA_vect) { interrupts(); SoftPWM.update(); }
#endif
}
typedef void (*fptr)();
fptr
RGBLED::begin(long herz)
{
#ifdef USE_SOFT_PWM
  SoftPWM.begin( herz );

  return isr;
#else
  return 0;
#endif
}

/**
 * setColor
 *
 * Set color levels on the RGB LED
 *
 * 'red'      Bright level of the red LED
 * 'green'    Bright level of the green LED
 * 'blue'     Bright level of the blue LED
 */
void RGBLED::setColor(byte red, byte green, byte blue, byte white)
{
  levels[0] = red;
  levels[1] = green;
  levels[2] = blue;
  if( pWhite != -1 )
    levels[3] = white;

  _timestamp = millis();

#ifdef USE_SOFT_PWM
  SoftPWM.set( 0, red );
  SoftPWM.set( 1, green );
  SoftPWM.set( 2, blue );
  if( pWhite != -1 )
    SoftPWM.set( 3, white );
#else
  analogWrite(pRed, red);
  analogWrite(pGreen, green);
  analogWrite(pBlue, blue);
  if( pWhite != -1 )
    analogWrite(pWhite, white);
#endif

#ifdef LED_DEBUG
  digitalWrite(4, isOff()?LOW:HIGH);
#endif
}

void RGBLED::dimUp()
{
  int l[sizeof(levels)];

  for( byte i = 0; i < sizeof(levels); ++i )
    {
      if( isOff() )
        l[i] = 1;
      else
        {
          l[i] = levels[i] << 1;
          if( l[i] > 255 )
            {
              l[i] |= 0xC1;
              l[i] &= 0xFF;
            }
        }
    }

  setColor( l[0], l[1], l[2] );
}

void RGBLED::dimDown()
{
  byte level = 0;
  byte l[sizeof(levels)];

  for( byte i = 0; i < sizeof(l); ++i )
    {
      l[i] = levels[i] >> 1;
      level |= l[i];
    }

  if( level )
    setColor( l[0], l[1], l[2] );
}
