#include "TMP36.h"

TMP36::TMP36(byte sensorPin, ReferenceVoltages referenceVolatage, Tmp36Modes mode, int readings) {
  m_SensorPin = sensorPin;
  m_Readings = readings;
  m_Mode = mode;
  switch (referenceVolatage) {
    case ReferenceVoltage11:
      m_ReferenceVoltage = 1.1;
      break;
    case ReferenceVoltage33:
      m_ReferenceVoltage = 3.3;
      break;
    case ReferenceVoltage50:
      m_ReferenceVoltage = 5.0;
      break;

  }
  
}

float TMP36::InternalRead() {
  float voltage = (analogRead(m_SensorPin) * m_ReferenceVoltage) / 1024;
  return (voltage - 0.5) * 100;
}

float TMP36::ReadTemperature() {
  float temperature = 0;
  for (int i = 0; i < m_Readings; i++) {
    temperature += InternalRead();
  }
  temperature /= m_Readings;

  switch (m_Mode) {
  case HalfDegrees:
      temperature = round(temperature * 2.0) / 2.0;
      break;
    
  case Integer:
      temperature = round(temperature);
      break;
    default:
      break;
  }

  return temperature;
}

