/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSCUSTOMHEADER_H__
#define __UOSCUSTOMHEADER_H__

#include "libsylph/customheader.h"

typedef CustomHeader UosCustomHeader;

#include "uosprefs_account.h"

void uos_custom_header_read_config		(UosPrefsAccount	*ac);
void uos_custom_header_write_config		(UosPrefsAccount	*ac);

gchar *uos_custom_header_get_str		(UosCustomHeader	*ch);
UosCustomHeader *uos_custom_header_read_str	(const gchar	*buf);
UosCustomHeader *uos_custom_header_find	(GSList		*header_list,
					 const gchar	*header);
void uos_custom_header_free			(UosCustomHeader	*ch);

#endif /* __UOSCUSTOMHEADER_H__ */
