/*	############################################################
	# @(#) chr_.h
	# @(#)
	# @(#) Copyright (c) 1995-2001 by Dirk Hagedorn
	# @(#) Dirk Hagedorn (udo@dirk-hagedorn.de)
	#
	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.
	# 
	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.
	# 
	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	# 
	# @(#) Uebersetzungstabellen fuer ...
	############################################################	*/

#include	"portab.h"

#ifndef ID_CHARSET_H
#define	ID_CHARSET_H
const char *id_charset_h= "@(#) chr_  .h    09.04.1996";
#endif


/*	------------------------------------------------------------	*/

/*	############################################################
	# ISO-Zeichensatz in System-Zeichensatz umsetzen
	############################################################	*/
typedef struct _ansi2ascii
{	unsigned char	iso;
	unsigned char	sys;
}	ANSI2ASCII;


LOCAL const ISO2SYS iso2sys_item[128]=
{
	{ '\200', '\000' },		/* null		*/
	{ '\201', '\000' },		/* null		*/
	{ '\202', '\000' },		/* '' (9u)	*/
	{ '\203', '\000' },		/* #f		*/
	{ '\204', '\000' },		/* "" (99u)	*/
	{ '\205', '\000' },		/* !..		*/
	{ '\206', '\000' },		/* #dag		*/
	{ '\207', '\000' },		/* 2x#dag	*/
	{ '\210', '\000' },		/* #circ	*/
	{ '\211', '\000' },		/* #promill	*/
	{ '\212', '\000' },		/* vS		*/
	{ '\213', '\000' },		/* <		*/
	{ '\214', '\000' },		/* &OE		*/
	{ '\215', '\000' },		/* null		*/
	{ '\216', '\000' },		/* null		*/
	{ '\217', '\000' },		/* null		*/
	{ '\220', '\000' },		/* null		*/
	{ '\221', '\000' },		/* '' (6o)	*/
	{ '\222', '\000' },		/* '' (9o)	*/
	{ '\223', '\000' },		/* "" (66o)	*/
	{ '\224', '\000' },		/* "" (99u)	*/
	{ '\225', '\000' },		/* #bullet	*/
	{ '\226', '\000' },		/* --		*/
	{ '\227', '\000' },		/* ---		*/
	{ '\230', '\000' },		/* !~		*/
	{ '\231', '\000' },		/* #tm		*/
	{ '\232', '\000' },		/* vs		*/
	{ '\233', '\000' },		/* >		*/
	{ '\234', '\000' },		/* &oe		*/
	{ '\235', '\000' },		/* null		*/
	{ '\236', '\000' },		/* null		*/
	{ '\237', '\000' },		/* "Y		*/
	{ '\240', '\000' },		/* null		*/
	{ '\241', '\000' },		/* #!		*/
	{ '\242', '\000' },		/* #cent	*/
	{ '\243', '\000' },		/* #pound	*/
	{ '\244', '\000' },		/* general currency	*/
	{ '\245', '\000' },		/* #yen		*/
	{ '\246', '\000' },		/* broken dash	*/
	{ '\247', '\000' },		/* #sect	*/
	{ '\250', '\000' },		/* #"		*/
	{ '\251', '\000' },		/* #copy	*/
	{ '\252', '\000' },		/* _a		*/
	{ '\253', '\000' },		/* #<		*/
	{ '\254', '\000' },		/* #neg		*/
	{ '\255', '\000' },		/* strich	*/
	{ '\256', '\000' },		/* #reg		*/
	{ '\257', '\000' },		/* upline	*/
	{ '\260', '\000' },		/* #degree	*/
	{ '\261', '\000' },		/* #pm		*/
	{ '\262', '\000' },		/* #^2		*/
	{ '\263', '\000' },		/* #^3		*/
	{ '\264', '\000' },		/* #'		*/
	{ '\265', '\000' },		/* #mu		*/
	{ '\266', '\000' },		/* #p		*/
	{ '\267', '\000' },		/* #cdot	*/
	{ '\270', '\000' },		/* cedille	*/
	{ '\271', '\000' },		/* #^1		*/
	{ '\272', '\000' },		/* _o		*/
	{ '\273', '\000' },		/* #>		*/
	{ '\274', '\000' },		/* #1/4		*/
	{ '\275', '\000' },		/* #1/2		*/
	{ '\276', '\000' },		/* #3/4		*/
	{ '\277', '\000' },		/* #?		*/
	{ '\300', '\000' },		/* `A		*/
	{ '\301', '\000' },		/* 'A		*/
	{ '\302', '\000' },		/* ^A		*/
	{ '\303', '\000' },		/* ~A		*/
	{ '\304', '\000' },		/* "A		*/
	{ '\305', '\000' },		/* .A		*/
	{ '\306', '\000' },		/* &AE		*/
	{ '\307', '\000' },		/* ,C		*/
	{ '\310', '\000' },		/* `E		*/
	{ '\311', '\000' },		/* 'E		*/
	{ '\312', '\000' },		/* ^E		*/
	{ '\313', '\000' },		/* "E		*/
	{ '\314', '\000' },		/* `I		*/
	{ '\315', '\000' },		/* 'I		*/
	{ '\316', '\000' },		/* ^I		*/
	{ '\317', '\000' },		/* "I		*/
	{ '\320', '\000' },		/* -D		*/
	{ '\321', '\000' },		/* ~N		*/
	{ '\322', '\000' },		/* `O		*/
	{ '\323', '\000' },		/* 'O		*/
	{ '\324', '\000' },		/* ^O		*/
	{ '\325', '\000' },		/* ~O		*/
	{ '\326', '\000' },		/* "O		*/
	{ '\327', '\000' },		/* #times	*/
	{ '\330', '\000' },		/* /O		*/
	{ '\331', '\000' },		/* `U		*/
	{ '\332', '\000' },		/* 'U		*/
	{ '\333', '\000' },		/* ^U		*/
	{ '\334', '\000' },		/* "U		*/
	{ '\335', '\000' },		/* 'Y		*/
	{ '\336', '\000' },		/* |b		*/
	{ '\337', '\000' },		/* "s (beta) */
	{ '\340', '\000' },		/* `a		*/
	{ '\341', '\000' },		/* 'a		*/
	{ '\342', '\000' },		/* ^a		*/
	{ '\343', '\000' },		/* ~a		*/
	{ '\344', '\000' },		/* "a		*/
	{ '\345', '\000' },		/* .a		*/
	{ '\346', '\000' },		/* &ae		*/
	{ '\347', '\000' },		/* ,c		*/
	{ '\350', '\000' },		/* `e		*/
	{ '\351', '\000' },		/* 'e		*/
	{ '\352', '\000' },		/* ^e		*/
	{ '\353', '\000' },		/* "e		*/
	{ '\354', '\000' },		/* `i		*/
	{ '\355', '\000' },		/* 'i		*/
	{ '\356', '\000' },		/* ^i		*/
	{ '\357', '\000' },		/* "i		*/
	{ '\360', '\000' },		/* o|''		*/
	{ '\361', '\000' },		/* ~n		*/
	{ '\362', '\000' },		/* `o		*/
	{ '\363', '\000' },		/* 'o		*/
	{ '\364', '\000' },		/* ^o		*/
	{ '\365', '\000' },		/* ~o		*/
	{ '\366', '\000' },		/* "o		*/
	{ '\367', '\000' },		/* #div		*/
	{ '\370', '\000' },		/* /o		*/
	{ '\371', '\000' },		/* `u		*/
	{ '\372', '\000' },		/* 'u		*/
	{ '\373', '\000' },		/* ^u		*/
	{ '\374', '\000' },		/* "u		*/
	{ '\375', '\000' },		/* 'y		*/
	{ '\376', '\000' },		/* |B		*/
	{ '\377', '\000' }		/* "y		*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# Systemzeichensatz in andere Zeichensaetze umwandeln
	############################################################	*/

typedef struct _chartable
{
	unsigned char	system;
	char ansi[5];
	char tex[16];
	char html[10];
}	CHARTABLE;

LOCAL const CHARTABLE chrtab[128]=
{
	{	'\000',	"\\'C7",	"\\c{C}",			"&Ccedil;"	},
	{	'\000',	"\\'FC",	"\"u",				"&uuml;"	},
	{	'\000',	"\\'E9",	"\\'{e}",			"&eacute;"	},
	{	'\000',	"\\'E2",	"\\^{a}",			"&acirc;"	},
	{	'\000',	"\\'E4",	"\"a",				"&auml;"	},
	{	'\000',	"\\'E0",	"\\`{a}",			"&agrave;"	},
	{	'\000',	"\\'E5",	"{\\aa}",			"&aring;"	},
	{	'\000',	"\\'E7",	"\\c{c}",			"&ccedil;"	},
	{	'\000',	"\\'EA",	"\\^{e}",			"&ecirc;"	},
	{	'\000',	"\\'EB",	"\\\"{e}",			"&euml;"	},
	{	'\000',	"\\'E8",	"\\`{e}",			"&egrave;"	},
	{	'\000',	"\\'EF",	"\\\"{i}",			"&iuml;"	},
	{	'\000',	"\\'EE",	"\\^{i}",			"&icirc;"	},
	{	'\000',	"\\'EC",	"\\`{i}",			"&igrave;"	},
	{	'\000',	"\\'C4",	"\"A",				"&Auml;"	},
	{	'\000',	"\\'C5",	"{\\AA}",			"&Aring;"	},
	{	'\000',	"\\'C9",	"\\'{E}",			"&Eacute;"	},
	{	'\000',	"\\'E6",	"{\\ae}",			"&aelig;"	},
	{	'\000',	"\\'C6",	"{\\AE}",			"&AElig;"	},
	{	'\000',	"\\'F4",	"\\^{o}",			"&ocirc;"	},
	{	'\000',	"\\'F6",	"\"o",				"&ouml;"	},
	{	'\000',	"\\'F2",	"\\`{o}",			"&ograve;"	},
	{	'\000',	"\\'FB",	"\\^{u}",			"&ucirc;"	},
	{	'\000',	"\\'F9",	"\\`{u}",			"&ugrave;"	},
	{	'\000',	"\\'FF",	"\\\"{y}",			"&yuml;"	},
	{	'\000',	"\\'D6",	"\"O",				"&Ouml;"	},
	{	'\000',	"\\'DC",	"\"U",				"&Uuml;"	},
	{	'\000',	"\\'A2",	"cent",				"&#162;"	},
	{	'\000',	"\\'A3",	"\\pounds{}",		"&#163;"	},
	{	'\000',	"\\'A5",	"yen",				"&#165;"	},
	{	'\000',	"\\'DF",	"{\\ss}",			"&szlig;"	},
	{	'\000',	"\\'83",	"$f$",				"&#166;"	},
	{	'\000',	"\\'E1",	"\\'{a}",			"&aacute;"	},
	{	'\000',	"\\'ED",	"\\'{i}",			"&iacute;"	},
	{	'\000',	"\\'F3",	"\\'{o}",			"&oacute;"	},
	{	'\000',	"\\'FA",	"\\'{u}",			"&uacute;"	},
	{	'\000',	"\\'F1",	"\\~{n}",			"&ntilde;"	},
	{	'\000',	"\\'D1",	"\\~{N}",			"&Ntilde;"	},
	{	'\000',	"\\'AA",	"\\b{a}",			"&#170;"	},
	{	'\000',	"\\'BA",	"\\b{o}",			"&#186;"	},
	{	'\000',	"\\'BF",	"?`",				"&#191;"	},
	{	'\000',	"",			"",					""			},
	{	'\000',	"\\'AC",	"$\\neg$",			"&#172;"	},
	{	'\000',	"\\'BD",	"$\\frac{1}{2}$",	"&#189;"	},
	{	'\000',	"\\'BC",	"$\\frac{1}{4}$",	"&#188;"	},
	{	'\000',	"\\'A1",	"!`",				"&#161;"	},
	{	'\000',	"\\'AB",	"\"<",				"&#171;"	},
	{	'\000',	"\\'BB",	"\">",				"&#187;"	},
	{	'\000',	"\\'E3",	"\\~{a}",			"&atilde;"	},
	{	'\000',	"\\'F5",	"\\~{o}",			"&otilde;"	},
	{	'\000',	"\\'D8",	"{\\O}",			"&Oslash;"	},
	{	'\000',	"\\'F8",	"{\\o}",			"&oslash;"	},
	{	'\000',	"\\'9C",	"{\\oe}",			"&#156;"	},
	{	'\000',	"\\'8C",	"{\\OE}",			"&#140;"	},
	{	'\000',	"\\'C0",	"\\`{A}",			"&Agrave;"	},
	{	'\000',	"\\'C3",	"\\~{A}",			"&Atilde;"	},
	{	'\000',	"\\'D5",	"\\~{O}",			"&Otilde;"	},
	{	'\000',	"\\'A8",	"\\!{ }",			"&#168;"	},
	{	'\000',	"\\'B4",	"\\`{ }",			"&#180;"	},
	{	'\000',	"\\'86",	"\\dag{}",			"&#134;"	},
	{	'\000',	"\\'B6",	"\\P{}",			"&#182;"	},
	{	'\000',	"\\'A9",	"\\copyright{}",	"&#169;"	},
	{	'\000',	"\\'AE",	"(R)",				"&#174;"	},
	{	'\000',	"\\'99",	"(TM)",				"&#153;"	},
	{	'\000',	"ij",		"ij",				"ij"		},
	{	'\000',	"IJ",		"IJ",				"IJ"		},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"\\'A7",	"\\S{}",			"&sect;"	},
	{	'\000',	"\\'F7",	"$\\wedge$",		"&#136;"	},
	{	'\000',	"",			"$\\infty$",		""			},
	{	'\000',	"",		 	"$\\alpha$",		""			},
	{	'\000',	"\\'DF",	"{\\ss}",			"&szlig;"	},
	{	'\000',	"",			"$\\Gamma$",		""			},
	{	'\000',	"",			"$\\pi$",			""			},
	{	'\000',	"",			"$\\Sigma$",		""			},
	{	'\000',	"",			"$\\sigma$",		""			},
	{	'\000',	"\\'B5",	"$\\mu$",			"&#181;"	},
	{	'\000',	"",			"$\\tau$",			""			},
	{	'\000',	"",			"$\\Phi$",			""			},
	{	'\000',	"",			"$\\phi$",			""			},
	{	'\000',	"",			"$\\Omega$",		""			},
	{	'\000',	"",			"$\\delta$",		""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"$\\epsilon$",		""			},
	{	'\000',	"",			"$\\eta$",			""			},
	{	'\000',	"",			"$\\equiv$",		""			},
	{	'\000',	"\\'B1",	"$\\pm$",			"&#177;"	},
	{	'\000',	"",			"$\\geq$",			""			},
	{	'\000',	"",			"$\\leq$",			""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"",					""			},
	{	'\000',	"",			"$\\div$",			"&#247;"	},
	{	'\000',	"",			"$\\approx$",		""			},
	{	'\000',	"\\'B0",	"$\\circ$",			"&#176;"	},
	{	'\000',	"\\'95",	"$\\bullet$",		"&#149;"	},
	{	'\000',	"\\'B7",	"$\\bullet$",		"&#183;"	},
	{	'\000',	"",			"$\\surd$",			""			},
	{	'\000',	"",			"$^n$",				""			},
	{	'\000',	"\\'B2",	"$^2$",				"&#178;"	},
	{	'\000',	"\\'B3",	"$^3$",				"&#179;"	},
	{	'\000',	"\\'AF",	"",					"&#175;"	}		/* #macron	*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# universellen Zeichensatz in ASCII-Zeichensatz umsetzen
	############################################################	*/
typedef struct _uni2systab
{
	char			uni[8];
	unsigned char	system[2];
}	UNI2SYSTAB;

#define	UNI2SYSTABSIZE	63

LOCAL const UNI2SYSTAB uni2sys[UNI2SYSTABSIZE]=
{
	{	"(!\"a)",	""	},
	{	"(!\"e)",	""	},
	{	"(!\"i)",	""	},
	{	"(!\"o)",	""	},
	{	"(!\"u)",	""	},
	{	"(!\"y)",	""	},
	{	"(!\"s)",	""	},
	{	"(!\"A)",	""	},
	{	"(!\"E)",	""	},
	{	"(!\"I)",	""	},
	{	"(!\"O)",	""	},
	{	"(!\"U)",	""	},
	{	"(!\"Y)",	""	},	/* 13 */

	{	"(!'a)",	""	},
	{	"(!'e)",	""	},
	{	"(!'i)",	""	},
	{	"(!'o)",	""	},
	{	"(!'u)",	""	},
	{	"(!'y)",	""	},
	{	"(!'A)",	""	},
	{	"(!'E)",	""	},
	{	"(!'I)",	""	},
	{	"(!'O)",	""	},
	{	"(!'U)",	""	},
	{	"(!'Y)",	""	},	/* 12 */

	{	"(!`a)",	""	},
	{	"(!`e)",	""	},
	{	"(!`i)",	""	},
	{	"(!`o)",	""	},
	{	"(!`u)",	""	},
	{	"(!`A)",	""	},
	{	"(!`E)",	""	},
	{	"(!`I)",	""	},
	{	"(!`O)",	""	},
	{	"(!`U)",	""	},	/* 10 */

	{	"(!^a)",	""	},
	{	"(!^e)",	""	},
	{	"(!^i)",	""	},
	{	"(!^o)",	""	},
	{	"(!^u)",	""	},
	{	"(!^A)",	""	},
	{	"(!^E)",	""	},
	{	"(!^I)",	""	},
	{	"(!^O)",	""	},
	{	"(!^U)",	""	},	/* 10 */

	{	"(!~a)",	""	},
	{	"(!~n)",	""	},
	{	"(!~o)",	""	},
	{	"(!~A)",	""	},
	{	"(!~N)",	""	},
	{	"(!~O)",	""	},	/*  6 */

	{	"(!.a)",	""	},
	{	"(!.A)",	""	},	/*  2 */

	{	"(!&ae)",	""	},
	{	"(!&AE)",	""	},
	{	"(!&oe)",	""	},
	{	"(!&OE)",	""	},	/*  4 */

	{	"(!,c)",	""	},
	{	"(!,C)",	""	},	/*  2 */

	{	"(!_a)",	""	},
	{	"(!_o)",	""	},	/*  2 */

	{	"(!\\o)",	""	},
	{	"(!\\O)",	""	},	/*  2 */

	{	"(!#S)",	""		},
};


/*	############################################################
	# chr_.h
	############################################################	*/
