% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnostic.R
\name{ggally_nostic_cooksd}
\alias{ggally_nostic_cooksd}
\title{ggnostic - Cook's distance}
\usage{
ggally_nostic_cooksd(data, mapping, ..., linePosition = pf(0.5,
  length(attr(data, "var_x")), nrow(data) - length(attr(data, "var_x"))),
  lineColor = brew_colors("grey"), lineType = 2)
}
\arguments{
\item{data, mapping, ..., lineColor, lineType}{parameters supplied to \code{\link{ggally_nostic_line}}}

\item{linePosition}{4 / n is the general cutoff point for Cook's Distance}
}
\value{
ggplot2 plot object
}
\description{
A function to display \code{stats::\link[stats]{cooks.distance}}.
}
\details{
A line is added at F_{p, n - p}(0.5) to display the general cutoff point for Cook's Distance.

Reference: Michael H. Kutner, Christopher J. Nachtsheim, John Neter, and William Li. Applied linear statistical models. The McGraw-Hill / Irwin series operations and decision sciences. McGraw-Hill Irwin, 2005, p. 403
}
\examples{
dt <- broomify(stats::lm(mpg ~ wt + qsec + am, data = mtcars))
ggally_nostic_cooksd(dt, ggplot2::aes(wt, .cooksd))
}
\seealso{
\code{stats::\link[stats]{cooks.distance}}
}
