//start of GrowthByteBuffer.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * GrowthByteBuffer.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces

//import exceptions
import java.lang.IllegalArgumentException;


/**
 * IɐLobt@B<br>
 * RandomAccessFile  łƂĎgpB
 * A܂苐ȃf[^舵̂ɂ͌ȂB
 * XbhZ[tł͂ȂB
 * jdk1.4 ȍ~ ByteBufferƂ͌݊B
 * 
 * <pre>
 * -- revision history --
 * $Log: GrowthByteBuffer.java,v $
 * Revision 1.1  2002/12/05 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     grow() Ńobt@̑ʂ̌vZԈĂ̂CB
 * [change]
 *     ǂݍ݌EɒB read( new byte[0] )  
 *     read( byte[] buf, int off, 0 ) ̖߂l
 *     InputStream Ɠ 0 ɂȂ悤ɂ
 * [maintenance]
 *     \[X
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class GrowthByteBuffer{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  default
    //------------------------------------------------------------------
    //  private static final int DefaultBufferSize
    //------------------------------------------------------------------
    /**
     * ftHg̈̃obt@̃TCY
     */
    private static final int DefaultBufferSize = 16384;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  byte buffer
    //------------------------------------------------------------------
    //  private byte[][] buffer
    //  private int position
    //  private int limit
    //------------------------------------------------------------------
    /**
     * obt@
     * S buffer[0].length ƓTCYbytez̔zB
     */
    private byte[][] buffer;

    /**
     * ݏʒuB
     * position  limitȍ~ɂȂ\B
     */
    private int position;

    /**
     * ݓǂ݂݌EB
     * ȍ~̃f[^͕sB
     * ̈ʒũf[^͓ǂ߂邱Ƃɒӂ邱ƁB
     */
    private int limit;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  public GrowthByteBuffer()
    //  public GrouthByteBuffer( int BufferSize )
    //------------------------------------------------------------------
    /**
     * TCYŐLobt@\zB<br>
     * obt@TCYɂ̓ftHglgpB
     */
    public GrowthByteBuffer(){
        this( GrowthByteBuffer.DefaultBufferSize );
    }

    /**
     * TCYŐLobt@\zB<br>
     *
     * @param BufferSize obt@̃TCY
     */
    public GrowthByteBuffer( int BufferSize ){
        if( 0 < BufferSize ){
            this.buffer    = new byte[16][];
            this.buffer[0] = new byte[ BufferSize ];
            this.position  = 0;
            this.limit     = -1;
        }else{
            throw new IllegalArgumentException( "BufferSize most be 1 or more." );
        }
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void write( int data )
    //  public void write( byte[] buffer )
    //  public void write( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ݈ʒu 1oCg̃f[^ށB
     * 
     * @param data 1oCg̃f[^
     */
    public void write( int data ){
        this.grow( this.position );

        this.buffer[ this.position / this.buffer[0].length ]
                   [ this.position % this.buffer[0].length ]
            = (byte)data;

        this.position++;
    }

    /**
     * ݈ʒu buffer ̓eށB
     * 
     * @param buffer ރf[^يi[ꂽobt@
     */
    public void write( byte[] buffer ){
        this.write( buffer, 0, buffer.length );
    }

    /**
     * ݈ʒu buffer  indexlengthoCg̓eށB
     * 
     * @param buffer ރf[^يi[ꂽobt@
     * @param index  buffeȑރf[^̊Jnʒu
     * @param length ރf[^
     */
    public void write( byte[] buffer, int index, int length ){
        this.grow( this.position + length - 1 );

        while( 0 < length ){
            int copylen = Math.min( ( this.position / this.buffer[0].length + 1 )
                                         * this.buffer[0].length,
                                    this.position + length ) - this.position;

            System.arraycopy( buffer, index, 
                              this.buffer[ this.position / this.buffer[0].length ], 
                                           this.position % this.buffer[0].length,
                              copylen );

            this.position += copylen;
            index         += copylen;
            length        -= copylen;
        }
    }


    //------------------------------------------------------------------
    //  original method
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //------------------------------------------------------------------
    /**
     * ݈ʒu 1bytẽf[^ǂ݂ށB
     * 
     * @return ǂ݂܂ꂽ1bytẽf[^B<br>
     *         ǂ݂݌E𒴂ēǂƂꍇ -1
     */
    public int read(){
        if( this.position <= this.limit ){
            return this.buffer[ this.position / this.buffer[0].length ]
                              [ this.position++ % this.buffer[0].length ] & 0xFF;
        }else{
            return -1;
        }
    }

    /**
     * ݈ʒu buffer𖞂悤Ƀf[^ǂݍށB
     * 
     * @param buffer f[^ǂݍރobt@
     * 
     * @return ۂɓǂ݂܂ꂽf[^<br>
     *         ǂ݂݌E𒴂ēǂƂꍇ -1
     */
    public int read( byte[] buffer ){
        return this.read( buffer, 0, buffer.length );
    }

    /**
     * ݈ʒu buffer index length̃f[^ǂݍށB
     * 
     * @param buffer f[^ǂݍރobt@
     * @param index  bufferf[^ǂ݂݈ʒu
     * @param length ǂݍރf[^̗
     * 
     * @return ۂɓǂ݂܂ꂽf[^<br>
     *         ǂ݂݌E𒴂ēǂƂꍇ -1
     */
    public int read( byte[] buffer, int index, int length ){
        if( this.position <= this.limit ){
            int len = 0;
            while( 0 < length ){
                int copylen = Math.min( Math.min( ( this.position / this.buffer[0].length + 1 )
                                                  * this.buffer[0].length,
                                                  this.position + length ),
                                        this.limit + 1 ) - this.position;
                if( 0 < copylen ){
                    System.arraycopy( this.buffer[ this.position / this.buffer[0].length ], 
                                                   this.position % this.buffer[0].length,
                                      buffer, index, 
                                     copylen );

                    this.position += copylen;
                    index         += copylen;
                    len           += copylen;
                    length        -= copylen;
                }else{
                    break;
                }
            }
            return len;
        }else if( 0 < length ){
            return -1;
        }else{
            return 0;
        }
    }


    //------------------------------------------------------------------
    //  original methods
    //------------------------------------------------------------------
    //  access methods
    //------------------------------------------------------------------
    //  public int length()
    //  public void setLength( int length )
    //  public int position()
    //  public void setPosition( int position )
    //  public void seek( int position )
    //------------------------------------------------------------------
    /**
     * ݂̓ǂ݂݌E𓾂B
     * 
     * @return ݂̓ǂ݂݌E
     */
    public int length(){
        return this.limit + 1;
    }

    /**
     * ǂ݂݌Eʒuݒ肷B
     * 
     * @param Vǂ݂݌Eʒu
     */
    public void setLength( int length ){
        length--;
        if( this.limit < length ){
            this.grow( length );
        }else{
            this.limit = length;
        }
    }

    /**
     * ݈ʒu𓾂B
     * 
     * @return ݈ʒu
     */
    public int position(){
        return this.position;
    }

    /**
     * ݈ʒuݒ肷B
     * java.io.RandomAccessFileƓ 
     * setPosition œǂ݂݌E𒴂l
     * ݒ肵ɂ̓obt@͑ĂȂB
     * ̌ write ɂď񂾎ɂ͂
     * ߂ăobt@͑B
     * 
     * @param position V݈ʒu
     */
    public void setPosition( int position ){
        this.position = position;
    }

    /**
     * ݈ʒuݒ肷B
     * java.io.RandomAccessFileƓ 
     * seek œǂ݂݌E𒴂l
     * ݒ肵ɂ̓obt@͑ĂȂB
     * ̌ write ɂď񂾎ɂ͂
     * ߂ăobt@͑B
     * 
     * @param position V݈ʒu
     */
    public void seek( int position ){
        this.setPosition( position );
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private void grow( int limit )
    //------------------------------------------------------------------
    /**
     * Vǂ݂݌E limit ݒ肵A
     * limit ܂ obt@𑝉B
     * 
     * @param Vǂ݂݌E
     */
    private void grow( int limit ){
        if( this.limit < limit ){
            int last = 0;
            while( last < this.buffer.length 
                && this.buffer[last] != null )
                last++;

            limit++;
            if( last * this.buffer[0].length < limit ){
                int need = ( limit / this.buffer[0].length )
                         + ( limit % this.buffer[0].length == 0 ? 0 : 1 );

                if( this.buffer.length < need ){
                    byte[][] old = this.buffer;
                    this.buffer = new byte[ Math.max( old.length * 2, need ) ][];

                    for( int i = 0 ; i < last ; i++ )
                        this.buffer[i] = old[i];
                }
                for( int i = last ; i < need ; i++ )
                    this.buffer[ i ] = new byte[ this.buffer[0].length ];
            }

            this.limit = limit - 1;
        }
    }

}
//end of GrowthByteBuffer.java
