//
// Created by uos on 2022/4/28.
//

#ifndef UOS_RECOVERY_USERDATARESTOREWIDGET_H
#define UOS_RECOVERY_USERDATARESTOREWIDGET_H

#include "utils/global.h"
#include "common/BaseTableView.h"
#include <DWidget>
#include <QTableView>
#include <DGuiApplicationHelper>
#include <DLabel>
#include <DPushButton>
#include <DSuggestButton>
#include <QStandardItemModel>
#include <QMap>
#include <DFrame>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class UserDataRestoreWidget : public DWidget
{
    Q_OBJECT
public:
    explicit UserDataRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initTableView();
    void setData(BackupInfoList &backupInfo);
Q_SIGNALS:
    void cancel();
    void start(BackupInfo &backupInfo);

private Q_SLOTS:
    void onThemeChange();
    void onBackupFileChanged(const QModelIndex &index);
    void onRadioClicked(bool checked);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    DLabel *m_title = nullptr;
    DLabel *m_subTitle = nullptr;
    BaseTableView *m_tableView = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DSuggestButton *m_okBtn = nullptr;
    QStandardItemModel *m_model = nullptr;
    QMap<QString, BackupInfo> m_allBackupInfo;
    QString m_backupFileOptUUID;
};


#endif //UOS_RECOVERY_USERDATARESTOREWIDGET_H
