#include "utils/environments.h"
#include "MainWindow.h"
#include "utils/global.h"
#include "utils/Utils.h"
#include <DApplication>
#include <QDebug>
#include <QLoggingCategory>
#include <DTabWidget>
#include <QScreen>
#include <DLog>
#include <DApplicationSettings>
#include <QLocale>
#include <QScopedPointer>


DCORE_USE_NAMESPACE
DWIDGET_USE_NAMESPACE


int main(int argc, char **argv)
{
    DApplication app(argc, argv);
    app.setAttribute(Qt::AA_UseHighDpiPixmaps); // 高清图
    app.setOrganizationName("deepin");
    app.setApplicationName("uos-recovery");
    app.setApplicationVersion(VERSION);
    app.loadTranslator();

    QString locale = QLocale::system().name();
    QString tsFile = QString("%1/uos-recovery-gui_%2.qm").arg(DI_I18N_GUI_DIR_ENV, locale);
    QScopedPointer<QTranslator> translator(new QTranslator);
    translator->load(tsFile);
    qApp->installTranslator(translator.data());
    qInfo() << QString("locale: <%1> current load ts file: <%2>").arg(locale, tsFile);

    app.setApplicationDisplayName(QObject::tr("Backup and Restore"));
    app.setStyle("chameleon");
    app.setWindowIcon(QIcon::fromTheme("uos-recovery"));
    app.setProductIcon(QIcon::fromTheme("uos-recovery"));
    app.setApplicationDescription(QApplication::translate("main",
        "Backup and Restore is a tool for system backup and restore, and data backup and recovery."));
    DApplicationSettings saveTheme;
    QLoggingCategory::defaultCategory()->setEnabled(QtDebugMsg, true);

    // app.setAutoActivateWindows(true); // 多DMainWidow不能用这个，DTK的实现不满足要求
    if (!app.setSingleInstance(app.applicationName())) {
        return -1;
    }

    //设置日志
    const QString logFormat = "%{time}{yyyy-MM-dd, HH:mm:ss.zzz}[%{type:1}][%{threadid} ] %{message}\n";
    const QString logDir(QString("/home/%1/.cache/deepin/uos-recovery/").arg(Utils::getUserName()));
    QDir dir(logDir);
    if (!dir.exists()) {
        dir.mkpath(logDir);
    }

    ConsoleAppender *consoleAppender = new ConsoleAppender;
    consoleAppender->setFormat(logFormat);
    RollingFileAppender *rollingFileAppender = new RollingFileAppender(logDir + "uos-recovery-gui.log");
    rollingFileAppender->setFormat(logFormat);
    rollingFileAppender->setLogFilesLimit(5);
    rollingFileAppender->setDatePattern(RollingFileAppender::MinutelyRollover);
    logger->registerAppender(consoleAppender);
    logger->registerAppender(rollingFileAppender);

    MainWindow w;
    auto screen = QGuiApplication::primaryScreen();
    auto rect = screen->geometry();
    if (rect.width() < MAIN_WINDOW_WIDTH || rect.height() < MAIN_WINDOW_HEIGHT) {
        w.showMaximized();
    } else {
        w.setFixedSize(QSize(MAIN_WINDOW_WIDTH, MAIN_WINDOW_HEIGHT));
        w.move((rect.width() - w.width()) / 2, (rect.height() - w.height()) / 2);
        w.show();
    }

    return app.exec();
}