//
// Created by uos on 2022/3/21.
//


#include "ResultWidget.h"
#include "utils/Utils.h"
#include <QVBoxLayout>
#include <DPushButton>
#include <DFontSizeManager>
#include <QDebug>

ResultWidget::ResultWidget(bool success, const QString &resultText,
                           const QString &errorMsg, const QString &btnText, DWidget *parent)
{
    m_isSuccess = success;
    setAccessibleDescription("ResultWidget");

    //垂直布局
    QVBoxLayout *verticalLayout = new QVBoxLayout(this);

    m_resultIcon = new DLabel(this);
    verticalLayout->addWidget(m_resultIcon);
    verticalLayout->setAlignment(m_resultIcon, Qt::AlignHCenter);
    verticalLayout->addSpacing(10);

    m_resultText = new DLabel(this);
    m_resultText->setAlignment(Qt::AlignHCenter);
    DFontSizeManager::instance()->bind(m_resultText, DFontSizeManager::T5);
    QFont font = m_resultText->font();
    font.setWeight(QFont::Medium);
    m_resultText->setFont(font);
    verticalLayout->addWidget(m_resultText);
    verticalLayout->setAlignment(m_resultText, Qt::AlignHCenter);
    verticalLayout->addSpacing(20);

    m_errorMsg = new DLabel;
    m_errorMsg->setAlignment(Qt::AlignHCenter);
    m_errorMsg->setStyleSheet("QLabel {"
                             "font-family: SourceHanSansSC, SourceHanSansSC-Medium;"
                             "font-size: 14px;"
                             "font-weight: 500;"
                             "color: #ff5736;"
                             "}");
    verticalLayout->addWidget(m_errorMsg);

    verticalLayout->addStretch();

    m_viewButton = new DPushButton(this);
    m_viewButton->hide();
    DFontSizeManager::instance()->bind(m_viewButton, DFontSizeManager::T6);
    m_viewButton->setStyleSheet("QPushButton {"
                                "color: #0081FF;"
                                "border: none;"
                                "background-color: transparent;"
                                "}");
    verticalLayout->addWidget(m_viewButton);
    verticalLayout->setAlignment(m_viewButton, Qt::AlignHCenter);

    m_button = new DPushButton(this);
    m_button->setFixedWidth(200);
    DFontSizeManager::instance()->bind(m_button, DFontSizeManager::T6);
    verticalLayout->addWidget(m_button);
    verticalLayout->setAlignment(m_button, Qt::AlignHCenter);
    verticalLayout->setContentsMargins(0, 123, 0, 30);
    set(success, resultText, errorMsg, btnText);

    connect(m_button, &QPushButton::clicked, this, &ResultWidget::done);
    connect(m_viewButton, &QPushButton::clicked, this, &ResultWidget::viewBtnClicked);
}

void ResultWidget::set(bool success, const QString &resultText,
                       const QString &errorMsg, const QString &btnText)
{
    m_isSuccess = success;
    if (success) {
        m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/success.svg", QSize(128, 128)));
    } else {
        m_resultIcon->setPixmap(Utils::hidpiPixmap(":/resources/icons/fail.svg", QSize(128, 128)));
    }
    m_resultText->setText(resultText);
//    m_errorMsg->setText(errorMsg);
    if (!errorMsg.isEmpty()) {
        qInfo()<<"ResultWidget errorMsg = "<<errorMsg;
    }

    m_button->setText(btnText);

}

void ResultWidget::showViewButton(bool show, const QString &btnText, const QString &style)
{
    m_viewButton->setVisible(show);

    if (!btnText.isEmpty()) {
        m_viewButton->setText(btnText);
    }

    if (!style.isEmpty()) {
        m_viewButton->setStyleSheet(style);
    }

}
