//
// Created by uos on 2022/3/17.
//

#ifndef UOS_RECOVERY_PROGRESSWIDGET_H
#define UOS_RECOVERY_PROGRESSWIDGET_H

#include <DWidget>
#include <DWaterProgress>
#include <DLabel>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ProgressWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ProgressWidget(const QString &mainTitle, const QString &subTitle,
                            const QString &warning, DWidget *parent = nullptr);
    void start();
    void stop(bool success);
    void setValue(int value);
    void setMainTitle(const QString &mainTitle);
    void setSubTitle(const QString &subTitle);
    void setWarning(const QString &warning);
    void setRemainTime(int remainTime);
private:
    DWaterProgress *m_waterProgress = nullptr;
    DLabel *m_mainTitle = nullptr;
    DLabel *m_subTitle = nullptr;
    DLabel *m_warning = nullptr;
    DLabel *m_remainTime = nullptr;

};


#endif //UOS_RECOVERY_PROGRESSWIDGET_H
