//
// Created by uos on 2022/2/15.
//

#ifndef UOS_RECOVERY_DEVICETEST_H
#define UOS_RECOVERY_DEVICETEST_H

#include "utils/Device.h"
#include <gtest/gtest.h>
#include <QDebug>
#include <iostream>


class DeviceTest : public testing::Test
{
public:
    void SetUp() override
    {
        m_allDevice = Device::getDeviceByLsblk();
    }

    void TearDown() override
    {

    }

public:
    DeviceInfoList m_allDevice;
};

TEST_F(DeviceTest, getDeviceByLsblk)
{
    EXPECT_FALSE(m_allDevice.isEmpty());
}

TEST_F(DeviceTest, createDevice)
{
    for (const auto& devInfo : m_allDevice) {
        if (devInfo->mountPoint == "/") {
            Device device(devInfo->deviceName);
            auto deviceInfo = device.getDeviceInfo();
            EXPECT_FALSE(deviceInfo.isNull());
            device.calculateDiskSpace();
            auto size = device.size();
            auto used = device.used();
            auto free = device.free();
            EXPECT_FALSE(size.isEmpty());
            EXPECT_FALSE(used.isEmpty());
            EXPECT_FALSE(free.isEmpty());

            Device device1;
            device1.getDeviceByName(devInfo->deviceName);
            auto deviceInfo1 = device1.getDeviceInfo();
            EXPECT_FALSE(deviceInfo1.isNull());

            Device device2;
            device2.getDeviceByUUID(devInfo->uuid);
            auto  deviceInfo2 = device2.getDeviceInfo();
            EXPECT_FALSE(deviceInfo2.isNull());
            break;
        }
    }
}

TEST_F(DeviceTest, mount)
{
    DevicePtr pDevice(new Device("/dev/sdb1"));
    EXPECT_TRUE(pDevice->mount("/mnt"));
    EXPECT_TRUE(pDevice->umount());
}



#endif //UOS_RECOVERY_DEVICETEST_Hs
